import{s as pi,o as ci,n as G}from"../chunks/scheduler.182ea377.js";import{S as fi,i as mi,g as l,s as i,r as u,A as ui,h as d,f as p,c as s,j as U,u as h,x as f,k as j,y as o,a as v,v as g,d as b,t as _,w as y}from"../chunks/index.abf12888.js";import{T as at}from"../chunks/Tip.230e2334.js";import{D as P}from"../chunks/Docstring.93f6f462.js";import{C as $e}from"../chunks/CodeBlock.57fe6e13.js";import{E as xe}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as dn}from"../chunks/Heading.16916d63.js";function hi(T){let n,w='You shouldn’t use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class for training. Individual components (for example, <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> and <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) of diffusion pipelines are usually trained individually, so we suggest directly working with them instead.',a,r,m,t,M='Pipelines do not offer any training functionality. You’ll notice PyTorch’s autograd is disabled by decorating the <code>__call__()</code> method with a <a href="https://pytorch.org/docs/stable/generated/torch.no_grad.html" rel="nofollow"><code>torch.no_grad</code></a> decorator because pipelines should not be used for training. If you’re interested in training, please take a look at the <a href="../../training/overview">Training</a> guides instead!';return{c(){n=l("p"),n.innerHTML=w,a=i(),r=l("br"),m=i(),t=l("p"),t.innerHTML=M},l(k){n=d(k,"P",{"data-svelte-h":!0}),f(n)!=="svelte-17t0bk9"&&(n.innerHTML=w),a=s(k),r=d(k,"BR",{}),m=s(k),t=d(k,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1a94ctl"&&(t.innerHTML=M)},m(k,E){v(k,n,E),v(k,a,E),v(k,r,E),v(k,m,E),v(k,t,E)},p:G,d(k){k&&(p(n),p(a),p(r),p(m),p(t))}}}function gi(T){let n,w=`If the pipeline already has the correct torch.dtype and torch.device, then it is returned as is. Otherwise,
the returned pipeline is a copy of self with the desired torch.dtype and torch.device.`;return{c(){n=l("p"),n.textContent=w},l(a){n=d(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-18gkv0g"&&(n.textContent=w)},m(a,r){v(a,n,r)},p:G,d(a){a&&p(n)}}}function bi(T){let n,w="Examples:",a,r,m;return r=new $e({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUyQyUwQSklMEElMEF0ZXh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEFpbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCoqdGV4dDJpbWcuY29tcG9uZW50cyklMEFpbnBhaW50JTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lKCoqdGV4dDJpbWcuY29tcG9uZW50cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    StableDiffusionPipeline,
<span class="hljs-meta">... </span>    StableDiffusionImg2ImgPipeline,
<span class="hljs-meta">... </span>    StableDiffusionInpaintPipeline,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text2img = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2img = StableDiffusionImg2ImgPipeline(**text2img.components)
<span class="hljs-meta">&gt;&gt;&gt; </span>inpaint = StableDiffusionInpaintPipeline(**text2img.components)`,wrap:!1}}),{c(){n=l("p"),n.textContent=w,a=i(),u(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=w),a=s(t),h(r.$$.fragment,t)},m(t,M){v(t,n,M),v(t,a,M),g(r,t,M),m=!0},p:G,i(t){m||(b(r.$$.fragment,t),m=!0)},o(t){_(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),y(r,t)}}}function _i(T){let n,w=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>.`;return{c(){n=l("p"),n.innerHTML=w},l(a){n=d(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-6jnfc0"&&(n.innerHTML=w)},m(a,r){v(a,n,r)},p:G,d(a){a&&p(n)}}}function yi(T){let n,w=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=l("p"),n.innerHTML=w},l(a){n=d(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-ackzsn"&&(n.innerHTML=w)},m(a,r){v(a,n,r)},p:G,d(a){a&&p(n)}}}function vi(T){let n,w="Examples:",a,r,m;return r=new $e({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=l("p"),n.textContent=w,a=i(),u(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=w),a=s(t),h(r.$$.fragment,t)},m(t,M){v(t,n,M),v(t,a,M),g(r,t,M),m=!0},p:G,i(t){m||(b(r.$$.fragment,t),m=!0)},o(t){_(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),y(r,t)}}}function wi(T){let n,w=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=l("p"),n.textContent=w},l(a){n=d(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-17p1lpg"&&(n.textContent=w)},m(a,r){v(a,n,r)},p:G,d(a){a&&p(n)}}}function xi(T){let n,w="Examples:",a,r,m;return r=new $e({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=w,a=i(),u(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=w),a=s(t),h(r.$$.fragment,t)},m(t,M){v(t,n,M),v(t,a,M),g(r,t,M),m=!0},p:G,i(t){m||(b(r.$$.fragment,t),m=!0)},o(t){_(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),y(r,t)}}}function $i(T){let n,w="If you get the error message below, you need to finetune the weights for your downstream task:",a,r,m;return r=new $e({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTIwYmVjYXVzZSUyMHRoZSUyMHNoYXBlcyUyMGRpZCUyMG5vdCUyMG1hdGNoJTNBJTBBLSUyMGNvbnZfaW4ud2VpZ2h0JTNBJTIwZm91bmQlMjBzaGFwZSUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwNCUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwY2hlY2twb2ludCUyMGFuZCUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwOSUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwbW9kZWwlMjBpbnN0YW50aWF0ZWQlMEFZb3UlMjBzaG91bGQlMjBwcm9iYWJseSUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bi1zdHJlYW0lMjB0YXNrJTIwdG8lMjBiZSUyMGFibGUlMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2Uu",highlighted:`Some weights <span class="hljs-keyword">of</span> UNet2DConditionModel were <span class="hljs-keyword">not</span> initialized <span class="hljs-built_in">from</span> <span class="hljs-keyword">the</span> model checkpoint <span class="hljs-keyword">at</span> runwayml/stable-diffusion-v1<span class="hljs-number">-5</span> <span class="hljs-keyword">and</span> are newly initialized because <span class="hljs-keyword">the</span> shapes did <span class="hljs-keyword">not</span> match:
- conv_in.weight: found shape torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> checkpoint <span class="hljs-keyword">and</span> torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">9</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> model instantiated
You should probably TRAIN this model <span class="hljs-keyword">on</span> <span class="hljs-title">a</span> <span class="hljs-title">down-stream</span> <span class="hljs-title">task</span> <span class="hljs-title">to</span> <span class="hljs-title">be</span> <span class="hljs-title">able</span> <span class="hljs-title">to</span> <span class="hljs-title">use</span> <span class="hljs-title">it</span> <span class="hljs-title">for</span> <span class="hljs-title">predictions</span> <span class="hljs-title">and</span> <span class="hljs-title">inference</span>.`,wrap:!1}}),{c(){n=l("p"),n.textContent=w,a=i(),u(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-xueb0m"&&(n.textContent=w),a=s(t),h(r.$$.fragment,t)},m(t,M){v(t,n,M),v(t,a,M),g(r,t,M),m=!0},p:G,i(t){m||(b(r.$$.fragment,t),m=!0)},o(t){_(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),y(r,t)}}}function Mi(T){let n,w=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated</a> models, log-in with
<code>huggingface-cli login</code>.`;return{c(){n=l("p"),n.innerHTML=w},l(a){n=d(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-x73rgs"&&(n.innerHTML=w)},m(a,r){v(a,n,r)},p:G,d(a){a&&p(n)}}}function Ti(T){let n,w="Examples:",a,r,m;return r=new $e({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZsZG0tdGV4dDJpbS1sYXJnZS0yNTYlMjIpJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMHRoYXQlMjByZXF1aXJlcyUyMGFuJTIwYXV0aG9yaXphdGlvbiUyMHRva2VuJTBBJTIzJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTIwb24lMjBhY2Nlc3MlMjB0b2tlbnMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwdGhpcyUyMHNlY3Rpb24lMEElMjMlMjBvZiUyMHRoZSUyMGRvY3VtZW50YXRpb24lNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZzZWN1cml0eS10b2tlbnMpJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBJTBBJTIzJTIwVXNlJTIwYSUyMGRpZmZlcmVudCUyMHNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwc2NoZWR1bGVy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;CompVis/ldm-text2im-large-256&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline that requires an authorization token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For more information on access tokens, please refer to this section</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># of the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = scheduler`,wrap:!1}}),{c(){n=l("p"),n.textContent=w,a=i(),u(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=w),a=s(t),h(r.$$.fragment,t)},m(t,M){v(t,n,M),v(t,a,M),g(r,t,M),m=!0},p:G,i(t){m||(b(r.$$.fragment,t),m=!0)},o(t){_(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),y(r,t)}}}function Ui(T){let n,w="If you get the error message below, you need to finetune the weights for your downstream task:",a,r,m;return r=new $e({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUyMHdlcmUlMjBub3QlMjBpbml0aWFsaXplZCUyMGZyb20lMjB0aGUlMjBtb2RlbCUyMGNoZWNrcG9pbnQlMjBhdCUyMHJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwYW5kJTIwYXJlJTIwbmV3bHklMjBpbml0aWFsaXplZCUyMGJlY2F1c2UlMjB0aGUlMjBzaGFwZXMlMjBkaWQlMjBub3QlMjBtYXRjaCUzQQ==",highlighted:'Some weights <span class="hljs-keyword">of</span> FlaxUNet2DConditionModel were <span class="hljs-keyword">not</span> initialized <span class="hljs-built_in">from</span> <span class="hljs-keyword">the</span> model checkpoint <span class="hljs-keyword">at</span> runwayml/stable-diffusion-v1<span class="hljs-number">-5</span> <span class="hljs-keyword">and</span> are newly initialized because <span class="hljs-keyword">the</span> shapes did <span class="hljs-keyword">not</span> match:',wrap:!1}}),{c(){n=l("p"),n.textContent=w,a=i(),u(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-xueb0m"&&(n.textContent=w),a=s(t),h(r.$$.fragment,t)},m(t,M){v(t,n,M),v(t,a,M),g(r,t,M),m=!0},p:G,i(t){m||(b(r.$$.fragment,t),m=!0)},o(t){_(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),y(r,t)}}}function ji(T){let n,w=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>.`;return{c(){n=l("p"),n.innerHTML=w},l(a){n=d(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-6jnfc0"&&(n.innerHTML=w)},m(a,r){v(a,n,r)},p:G,d(a){a&&p(n)}}}function Di(T){let n,w="Examples:",a,r,m;return r=new $e({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhEaWZmdXNpb25QaXBlbGluZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEElMjMlMjBSZXF1aXJlcyUyMHRvJTIwYmUlMjBsb2dnZWQlMjBpbiUyMHRvJTIwSHVnZ2luZyUyMEZhY2UlMjBodWIlMkMlMEElMjMlMjBzZWUlMjBtb3JlJTIwaW4lMjAlNUJ0aGUlMjBkb2N1bWVudGF0aW9uJTVEKGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkb2NzJTJGaHViJTJGc2VjdXJpdHktdG9rZW5zKSUwQXBpcGVsaW5lJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNEJTIyYmYxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGR0eXBlJTNEam5wLmJmbG9hdDE2JTJDJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMkMlMjBidXQlMjB1c2UlMjBhJTIwZGlmZmVyZW50JTIwc2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBZHBtcHAlMkMlMjBkcG1wcF9zdGF0ZSUyMCUzRCUyMEZsYXhEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyJTJDJTBBKSUwQSUwQWRwbV9waXBlJTJDJTIwZHBtX3BhcmFtcyUyMCUzRCUyMEZsYXhTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCUyMmJmMTYlMjIlMkMlMjBkdHlwZSUzRGpucC5iZmxvYXQxNiUyQyUyMHNjaGVkdWxlciUzRGRwbXBwJTBBKSUwQWRwbV9wYXJhbXMlNUIlMjJzY2hlZHVsZXIlMjIlNUQlMjAlM0QlMjBkcG1wcF9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Requires to be logged in to Hugging Face hub,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see more in [the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    revision=<span class="hljs-string">&quot;bf16&quot;</span>,
<span class="hljs-meta">... </span>    dtype=jnp.bfloat16,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline, but use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDPMSolverMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dpmpp, dpmpp_state = FlaxDPMSolverMultistepScheduler.from_pretrained(
<span class="hljs-meta">... </span>    model_id,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_pipe, dpm_params = FlaxStableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id, revision=<span class="hljs-string">&quot;bf16&quot;</span>, dtype=jnp.bfloat16, scheduler=dpmpp
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_params[<span class="hljs-string">&quot;scheduler&quot;</span>] = dpmpp_state`,wrap:!1}}),{c(){n=l("p"),n.textContent=w,a=i(),u(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=w),a=s(t),h(r.$$.fragment,t)},m(t,M){v(t,n,M),v(t,a,M),g(r,t,M),m=!0},p:G,i(t){m||(b(r.$$.fragment,t),m=!0)},o(t){_(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),y(r,t)}}}function Pi(T){let n,w="Examples:",a,r,m;return r=new $e({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMHlvdXIlMjBuYW1lc3BhY2UlMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC11bmV0JTIyLiUwQXVuZXQucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLXVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtdW5ldCUyMi4lMEF1bmV0LnB1c2hfdG9faHViKCUyMnlvdXItb3JnJTJGbXktZmluZXR1bmVkLXVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to your namespace with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;my-finetuned-unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to an organization with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;your-org/my-finetuned-unet&quot;</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=w,a=i(),u(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=w),a=s(t),h(r.$$.fragment,t)},m(t,M){v(t,n,M),v(t,a,M),g(r,t,M),m=!0},p:G,i(t){m||(b(r.$$.fragment,t),m=!0)},o(t){_(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),y(r,t)}}}function Zi(T){let n,w,a,r,m,t,M,k="Pipelines provide a simple way to run state-of-the-art diffusion models in inference by bundling all of the necessary components (multiple independently-trained models, schedulers, and processors) into a single end-to-end class. Pipelines are flexible and they can be adapted to use different schedulers or even model components.",E,Me,Uo='All pipelines are built from the base <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class which provides basic functionality for loading, downloading, and saving all the components. Specific pipeline types (for example <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>) loaded with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> are automatically detected and the pipeline components are loaded and passed to the <code>__init__</code> function of the pipeline.',zt,q,Yt,Te,jo="The table below lists all the pipelines currently available in 🤗 Diffusers and the tasks they support. Click on a pipeline to view its abstract and published paper.",Qt,Ue,Do='<thead><tr><th>Pipeline</th> <th>Tasks</th></tr></thead> <tbody><tr><td><a href="alt_diffusion">AltDiffusion</a></td> <td>image2image</td></tr> <tr><td><a href="animatediff">AnimateDiff</a></td> <td>text2video</td></tr> <tr><td><a href="attend_and_excite">Attend-and-Excite</a></td> <td>text2image</td></tr> <tr><td><a href="audio_diffusion">Audio Diffusion</a></td> <td>image2audio</td></tr> <tr><td><a href="audioldm">AudioLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="audioldm2">AudioLDM2</a></td> <td>text2audio</td></tr> <tr><td><a href="blip_diffusion">BLIP Diffusion</a></td> <td>text2image</td></tr> <tr><td><a href="consistency_models">Consistency Models</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="controlnet">ControlNet</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="controlnet_sdxl">ControlNet with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs">ControlNet-XS</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs_sdxl">ControlNet-XS with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="cycle_diffusion">Cycle Diffusion</a></td> <td>image2image</td></tr> <tr><td><a href="dance_diffusion">Dance Diffusion</a></td> <td>unconditional audio generation</td></tr> <tr><td><a href="ddim">DDIM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="ddpm">DDPM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="deepfloyd_if">DeepFloyd IF</a></td> <td>text2image, image2image, inpainting, super-resolution</td></tr> <tr><td><a href="diffedit">DiffEdit</a></td> <td>inpainting</td></tr> <tr><td><a href="dit">DiT</a></td> <td>text2image</td></tr> <tr><td><a href="stable_diffusion/gligen">GLIGEN</a></td> <td>text2image</td></tr> <tr><td><a href="pix2pix">InstructPix2Pix</a></td> <td>image editing</td></tr> <tr><td><a href="kandinsky">Kandinsky 2.1</a></td> <td>text2image, image2image, inpainting, interpolation</td></tr> <tr><td><a href="kandinsky_v22">Kandinsky 2.2</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="kandinsky3">Kandinsky 3</a></td> <td>text2image, image2image</td></tr> <tr><td><a href="latent_consistency_models">Latent Consistency Models</a></td> <td>text2image</td></tr> <tr><td><a href="latent_diffusion">Latent Diffusion</a></td> <td>text2image, super-resolution</td></tr> <tr><td><a href="stable_diffusion/ldm3d_diffusion">LDM3D</a></td> <td>text2image, text-to-3D, text-to-pano, upscaling</td></tr> <tr><td><a href="ledits_pp">LEDITS++</a></td> <td>image editing</td></tr> <tr><td><a href="panorama">MultiDiffusion</a></td> <td>text2image</td></tr> <tr><td><a href="musicldm">MusicLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="paint_by_example">Paint by Example</a></td> <td>inpainting</td></tr> <tr><td><a href="paradigms">ParaDiGMS</a></td> <td>text2image</td></tr> <tr><td><a href="pix2pix_zero">Pix2Pix Zero</a></td> <td>image editing</td></tr> <tr><td><a href="pixart">PixArt-α</a></td> <td>text2image</td></tr> <tr><td><a href="pndm">PNDM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="repaint">RePaint</a></td> <td>inpainting</td></tr> <tr><td><a href="score_sde_ve">Score SDE VE</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="self_attention_guidance">Self-Attention Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="semantic_stable_diffusion">Semantic Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="shap_e">Shap-E</a></td> <td>text-to-3D, image-to-3D</td></tr> <tr><td><a href="spectrogram_diffusion">Spectrogram Diffusion</a></td> <td></td></tr> <tr><td><a href="stable_diffusion/overview">Stable Diffusion</a></td> <td>text2image, image2image, depth2image, inpainting, image variation, latent upscaler, super-resolution</td></tr> <tr><td><a href="model_editing">Stable Diffusion Model Editing</a></td> <td>model editing</td></tr> <tr><td><a href="stable_diffusion/stable_diffusion_xl">Stable Diffusion XL</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_diffusion/sdxl_turbo">Stable Diffusion XL Turbo</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_unclip">Stable unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="stochastic_karras_ve">Stochastic Karras VE</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="stable_diffusion/adapter">T2I-Adapter</a></td> <td>text2image</td></tr> <tr><td><a href="text_to_video">Text2Video</a></td> <td>text2video, video2video</td></tr> <tr><td><a href="text_to_video_zero">Text2Video-Zero</a></td> <td>text2video</td></tr> <tr><td><a href="unclip">unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="latent_diffusion_uncond">Unconditional Latent Diffusion</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="unidiffuser">UniDiffuser</a></td> <td>text2image, image2text, image variation, text variation, unconditional image generation, unconditional audio generation</td></tr> <tr><td><a href="value_guided_sampling">Value-guided planning</a></td> <td>value guided sampling</td></tr> <tr><td><a href="versatile_diffusion">Versatile Diffusion</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="vq_diffusion">VQ Diffusion</a></td> <td>text2image</td></tr> <tr><td><a href="wuerstchen">Wuerstchen</a></td> <td>text2image</td></tr></tbody>',qt,je,At,x,De,pn,rt,Po="Base class for all pipelines.",cn,lt,Zo=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,fn,dt,ko="<li>move all PyTorch modules to the device of your choice</li> <li>enable/disable the progress bar for the denoising iteration</li>",mn,pt,Jo="Class attributes:",un,ct,Co=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>_optional_components</strong> (<code>List[str]</code>) — List of all optional components that don’t have to be passed to the
pipeline to function (should be overridden by subclasses).</li>`,hn,A,Pe,gn,ft,Io="Call self as a function.",bn,mt,Ze,_n,W,ke,yn,ut,Go=`Performs Pipeline dtype and/or device conversion. A torch.dtype and torch.device are inferred from the
arguments of <code>self.to(*args, **kwargs).</code>`,vn,O,wn,ht,Wo="Here are the ways to call <code>to</code>:",xn,gt,Bo=`<li><code>to(dtype, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li> <li><code>to(device, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a></li> <li><code>to(device=None, dtype=None, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the
specified <a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a> and
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li>`,$n,H,Je,Mn,bt,Ho=`The <code>self.components</code> property can be useful to run different pipelines with the same weights and
configurations without reallocating additional memory.`,Tn,_t,Fo=`Returns (<code>dict</code>):
A dictionary containing all the modules needed to initialize the pipeline.`,Un,K,jn,ee,Ce,Dn,yt,Vo=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Pn,te,Ie,Zn,vt,No='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',kn,z,Ge,Jn,wt,Xo="Download and cache a PyTorch diffusion pipeline from pretrained pipeline weights.",Cn,ne,In,F,We,Gn,xt,Lo=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Wn,oe,Bn,ie,Hn,se,Be,Fn,$t,So=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Vn,ae,He,Nn,Mt,Ro=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to GPU only when their specific submodule has its <code>forward</code>
method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,Xn,V,Fe,Ln,Tt,Eo=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Sn,re,Rn,le,En,J,Ve,zn,Ut,zo="Instantiate a PyTorch diffusion pipeline from pretrained pipeline weights.",Yn,jt,Yo="The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.",Qn,de,qn,pe,An,ce,On,fe,Ne,Kn,Dt,Qo=`Function that offloads all components, removes all model hooks that were added when using
<code>enable_model_cpu_offload</code> and then applies them again. In case the model has not been offloaded this function
is a no-op. Make sure to add this function to the end of the <code>__call__</code> function of your pipeline so that it
functions correctly when applying enable_model_cpu_offload.`,eo,me,Xe,to,Pt,qo="Convert a NumPy image or a batch of images to a PIL image.",no,ue,Le,oo,Zt,Ao="Removes all hooks that were added when using <code>enable_sequential_cpu_offload</code> or <code>enable_model_cpu_offload</code>.",io,he,Se,so,kt,Oo=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,Ot,Re,Kt,D,Ee,ao,Jt,Ko="Base class for Flax-based pipelines.",ro,Ct,ei=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,lo,It,ti="<li>enable/disable the progress bar for the denoising iteration</li>",po,Gt,ni="Class attributes:",co,Wt,oi=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li>`,fo,C,ze,mo,Bt,ii="Instantiate a Flax-based diffusion pipeline from pretrained pipeline weights.",uo,Ht,si="The pipeline is set in evaluation mode (`model.eval()) by default and dropout modules are deactivated.",ho,ge,go,be,bo,_e,_o,ye,Ye,yo,Ft,ai="Convert a NumPy image or a batch of images to a PIL image.",vo,ve,Qe,wo,Vt,ri=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,en,qe,tn,X,Ae,xo,Nt,li="A Mixin to push a model, scheduler, or pipeline to the Hugging Face Hub.",$o,Y,Oe,Mo,Xt,di="Upload model, scheduler, or pipeline files to the 🤗 Hugging Face Hub.",To,we,nn,Rt,on;return m=new dn({props:{title:"Pipelines",local:"pipelines",headingTag:"h1"}}),q=new at({props:{warning:!0,$$slots:{default:[hi]},$$scope:{ctx:T}}}),je=new dn({props:{title:"DiffusionPipeline",local:"diffusers.DiffusionPipeline",headingTag:"h2"}}),De=new P({props:{name:"class diffusers.DiffusionPipeline",anchor:"diffusers.DiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L123"}}),Pe=new P({props:{name:"__call__",anchor:"diffusers.DiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ze=new P({props:{name:"device",anchor:"diffusers.DiffusionPipeline.device",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L433",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The torch device on which the pipeline is located.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.device</code></p>
`}}),ke=new P({props:{name:"to",anchor:"diffusers.DiffusionPipeline.to",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.to.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a>`,name:"dtype"},{anchor:"diffusers.DiffusionPipeline.to.device",description:`<strong>device</strong> (<code>torch.Device</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a>`,name:"device"},{anchor:"diffusers.DiffusionPipeline.to.silence_dtype_warnings",description:`<strong>silence_dtype_warnings</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to omit warnings if the target <code>dtype</code> is not compatible with the target <code>device</code>.`,name:"silence_dtype_warnings"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L298",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The pipeline converted to specified <code>dtype</code> and/or <code>dtype</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline"
>DiffusionPipeline</a></p>
`}}),O=new at({props:{$$slots:{default:[gi]},$$scope:{ctx:T}}}),Je=new P({props:{name:"components",anchor:"diffusers.DiffusionPipeline.components",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1478"}}),K=new xe({props:{anchor:"diffusers.DiffusionPipeline.components.example",$$slots:{default:[bi]},$$scope:{ctx:T}}}),Ce=new P({props:{name:"disable_attention_slicing",anchor:"diffusers.DiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1640"}}),Ie=new P({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1574"}}),Ge=new P({props:{name:"download",anchor:"diffusers.DiffusionPipeline.download",parameters:[{name:"pretrained_model_name",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.download.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.`,name:"pretrained_model_name"},{anchor:"diffusers.DiffusionPipeline.download.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>
<p>A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained
pipeline hosted on the Hub. The repository must contain a file called <code>pipeline.py</code> that defines
the custom pipeline.</p>
</li>
<li>
<p>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current <code>main</code> branch of GitHub.</p>
</li>
<li>
<p>A path to a <em>directory</em> (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</p>
</li>
</ul>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>For more information on how to load and create custom pipelines, take a look at <a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/contribute_pipeline" rel="nofollow">How to contribute a
community pipeline</a>.`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.download.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.DiffusionPipeline.download.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.download.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.download.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.download.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.download.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.download.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.download.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.download.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.download.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom pipelines and components defined on the Hub in their own files. This
option should only be set to <code>True</code> for repositories you trust and in which you have read the code, as
it will execute code present on the Hub on your local machine.`,name:"trust_remote_code"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1090",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A path to the downloaded pipeline.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>os.PathLike</code></p>
`}}),ne=new at({props:{$$slots:{default:[_i]},$$scope:{ctx:T}}}),We=new P({props:{name:"enable_attention_slicing",anchor:"diffusers.DiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1600"}}),oe=new at({props:{warning:!0,$$slots:{default:[yi]},$$scope:{ctx:T}}}),ie=new xe({props:{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[vi]},$$scope:{ctx:T}}}),Be=new P({props:{name:"enable_model_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L950"}}),He=new P({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1035"}}),Fe=new P({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1539"}}),re=new at({props:{warning:!0,$$slots:{default:[wi]},$$scope:{ctx:T}}}),le=new xe({props:{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[xi]},$$scope:{ctx:T}}}),Ve=new P({props:{name:"from_pretrained",anchor:"diffusers.DiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing pipeline weights
saved using
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If &#x201C;auto&#x201D; is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>hf-internal-testing/diffusers-dummy-pipeline</code>) of a custom
pipeline hosted on the Hub. The repository must contain a file called pipeline.py that defines
the custom pipeline.</li>
<li>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current main branch of GitHub.</li>
<li>A path to a directory (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</li>
</ul>
<p>For more information on how to load and create custom pipelines, please have a look at <a href="https://huggingface.co/docs/diffusers/using-diffusers/custom_pipeline_overview" rel="nofollow">Loading and
Adding Custom
Pipelines</a>`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. Defaults to the latest stable &#x1F917; Diffusers version.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be defined for each
parameter/buffer name; once a given module name is inside, every submodule of it will be sent to the
same device.</p>
<p>Set <code>device_map=&quot;auto&quot;</code> to have &#x1F917; Accelerate automatically compute the most optimized <code>device_map</code>. For
more information about each option see <a href="https://hf.co/docs/accelerate/main/en/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">designing a device
map</a>.`,name:"device_map"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if device_map contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L463"}}),de=new xe({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example",$$slots:{default:[$i]},$$scope:{ctx:T}}}),pe=new at({props:{$$slots:{default:[Mi]},$$scope:{ctx:T}}}),ce=new xe({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example-2",$$slots:{default:[Ti]},$$scope:{ctx:T}}}),Ne=new P({props:{name:"maybe_free_model_hooks",anchor:"diffusers.DiffusionPipeline.maybe_free_model_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1021"}}),Xe=new P({props:{name:"numpy_to_pil",anchor:"diffusers.DiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1514"}}),Le=new P({props:{name:"remove_all_hooks",anchor:"diffusers.DiffusionPipeline.remove_all_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L940"}}),Se=new P({props:{name:"save_pretrained",anchor:"diffusers.DiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": Optional = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a pipeline to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L178"}}),Re=new dn({props:{title:"FlaxDiffusionPipeline",local:"diffusers.FlaxDiffusionPipeline",headingTag:"h2"}}),Ee=new P({props:{name:"class diffusers.FlaxDiffusionPipeline",anchor:"diffusers.FlaxDiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L101"}}),ze=new P({props:{name:"from_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>runwayml/stable-diffusion-v1-5</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
using <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.dtype",description:`<strong>dtype</strong> (<code>str</code> or <code>jnp.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>jnp.dtype</code> and load the model under this dtype. If <code>&quot;auto&quot;</code>, the dtype is
automatically derived from the model&#x2019;s weights.`,name:"dtype"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components) of the specific pipeline
class. The overwritten components are passed directly to the pipelines <code>__init__</code> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L229"}}),ge=new xe({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example",$$slots:{default:[Ui]},$$scope:{ctx:T}}}),be=new at({props:{$$slots:{default:[ji]},$$scope:{ctx:T}}}),_e=new xe({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example-2",$$slots:{default:[Di]},$$scope:{ctx:T}}}),Ye=new P({props:{name:"numpy_to_pil",anchor:"diffusers.FlaxDiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L588"}}),Qe=new P({props:{name:"save_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"params",val:": Union"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to which to save. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L151"}}),qe=new dn({props:{title:"PushToHubMixin",local:"diffusers.utils.PushToHubMixin",headingTag:"h2"}}),Ae=new P({props:{name:"class diffusers.utils.PushToHubMixin",anchor:"diffusers.utils.PushToHubMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L395"}}),Oe=new P({props:{name:"push_to_hub",anchor:"diffusers.utils.PushToHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your model, scheduler, or pipeline files to. It should
contain your organization name when pushing to an organization. <code>repo_id</code> can also be a path to a local
directory.`,name:"repo_id"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Default to <code>&quot;Upload {object}&quot;</code>.`,name:"commit_message"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. The token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights to the <code>safetensors</code> format.`,name:"safe_serialization"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L424"}}),we=new xe({props:{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.example",$$slots:{default:[Pi]},$$scope:{ctx:T}}}),{c(){n=l("meta"),w=i(),a=l("p"),r=i(),u(m.$$.fragment),t=i(),M=l("p"),M.textContent=k,E=i(),Me=l("p"),Me.innerHTML=Uo,zt=i(),u(q.$$.fragment),Yt=i(),Te=l("p"),Te.textContent=jo,Qt=i(),Ue=l("table"),Ue.innerHTML=Do,qt=i(),u(je.$$.fragment),At=i(),x=l("div"),u(De.$$.fragment),pn=i(),rt=l("p"),rt.textContent=Po,cn=i(),lt=l("p"),lt.innerHTML=Zo,fn=i(),dt=l("ul"),dt.innerHTML=ko,mn=i(),pt=l("p"),pt.textContent=Jo,un=i(),ct=l("ul"),ct.innerHTML=Co,hn=i(),A=l("div"),u(Pe.$$.fragment),gn=i(),ft=l("p"),ft.textContent=Io,bn=i(),mt=l("div"),u(Ze.$$.fragment),_n=i(),W=l("div"),u(ke.$$.fragment),yn=i(),ut=l("p"),ut.innerHTML=Go,vn=i(),u(O.$$.fragment),wn=i(),ht=l("p"),ht.innerHTML=Wo,xn=i(),gt=l("ul"),gt.innerHTML=Bo,$n=i(),H=l("div"),u(Je.$$.fragment),Mn=i(),bt=l("p"),bt.innerHTML=Ho,Tn=i(),_t=l("p"),_t.innerHTML=Fo,Un=i(),u(K.$$.fragment),jn=i(),ee=l("div"),u(Ce.$$.fragment),Dn=i(),yt=l("p"),yt.innerHTML=Vo,Pn=i(),te=l("div"),u(Ie.$$.fragment),Zn=i(),vt=l("p"),vt.innerHTML=No,kn=i(),z=l("div"),u(Ge.$$.fragment),Jn=i(),wt=l("p"),wt.textContent=Xo,Cn=i(),u(ne.$$.fragment),In=i(),F=l("div"),u(We.$$.fragment),Gn=i(),xt=l("p"),xt.textContent=Lo,Wn=i(),u(oe.$$.fragment),Bn=i(),u(ie.$$.fragment),Hn=i(),se=l("div"),u(Be.$$.fragment),Fn=i(),$t=l("p"),$t.innerHTML=So,Vn=i(),ae=l("div"),u(He.$$.fragment),Nn=i(),Mt=l("p"),Mt.innerHTML=Ro,Xn=i(),V=l("div"),u(Fe.$$.fragment),Ln=i(),Tt=l("p"),Tt.innerHTML=Eo,Sn=i(),u(re.$$.fragment),Rn=i(),u(le.$$.fragment),En=i(),J=l("div"),u(Ve.$$.fragment),zn=i(),Ut=l("p"),Ut.textContent=zo,Yn=i(),jt=l("p"),jt.innerHTML=Yo,Qn=i(),u(de.$$.fragment),qn=i(),u(pe.$$.fragment),An=i(),u(ce.$$.fragment),On=i(),fe=l("div"),u(Ne.$$.fragment),Kn=i(),Dt=l("p"),Dt.innerHTML=Qo,eo=i(),me=l("div"),u(Xe.$$.fragment),to=i(),Pt=l("p"),Pt.textContent=qo,no=i(),ue=l("div"),u(Le.$$.fragment),oo=i(),Zt=l("p"),Zt.innerHTML=Ao,io=i(),he=l("div"),u(Se.$$.fragment),so=i(),kt=l("p"),kt.innerHTML=Oo,Ot=i(),u(Re.$$.fragment),Kt=i(),D=l("div"),u(Ee.$$.fragment),ao=i(),Jt=l("p"),Jt.textContent=Ko,ro=i(),Ct=l("p"),Ct.innerHTML=ei,lo=i(),It=l("ul"),It.innerHTML=ti,po=i(),Gt=l("p"),Gt.textContent=ni,co=i(),Wt=l("ul"),Wt.innerHTML=oi,fo=i(),C=l("div"),u(ze.$$.fragment),mo=i(),Bt=l("p"),Bt.textContent=ii,uo=i(),Ht=l("p"),Ht.textContent=si,ho=i(),u(ge.$$.fragment),go=i(),u(be.$$.fragment),bo=i(),u(_e.$$.fragment),_o=i(),ye=l("div"),u(Ye.$$.fragment),yo=i(),Ft=l("p"),Ft.textContent=ai,vo=i(),ve=l("div"),u(Qe.$$.fragment),wo=i(),Vt=l("p"),Vt.innerHTML=ri,en=i(),u(qe.$$.fragment),tn=i(),X=l("div"),u(Ae.$$.fragment),xo=i(),Nt=l("p"),Nt.textContent=li,$o=i(),Y=l("div"),u(Oe.$$.fragment),Mo=i(),Xt=l("p"),Xt.textContent=di,To=i(),u(we.$$.fragment),nn=i(),Rt=l("p"),this.h()},l(e){const c=ui("svelte-u9bgzb",document.head);n=d(c,"META",{name:!0,content:!0}),c.forEach(p),w=s(e),a=d(e,"P",{}),U(a).forEach(p),r=s(e),h(m.$$.fragment,e),t=s(e),M=d(e,"P",{"data-svelte-h":!0}),f(M)!=="svelte-eejdx6"&&(M.textContent=k),E=s(e),Me=d(e,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-1d3b6kb"&&(Me.innerHTML=Uo),zt=s(e),h(q.$$.fragment,e),Yt=s(e),Te=d(e,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-2xd39c"&&(Te.textContent=jo),Qt=s(e),Ue=d(e,"TABLE",{"data-svelte-h":!0}),f(Ue)!=="svelte-156aj54"&&(Ue.innerHTML=Do),qt=s(e),h(je.$$.fragment,e),At=s(e),x=d(e,"DIV",{class:!0});var $=U(x);h(De.$$.fragment,$),pn=s($),rt=d($,"P",{"data-svelte-h":!0}),f(rt)!=="svelte-1neg3rw"&&(rt.textContent=Po),cn=s($),lt=d($,"P",{"data-svelte-h":!0}),f(lt)!=="svelte-1kbb8l4"&&(lt.innerHTML=Zo),fn=s($),dt=d($,"UL",{"data-svelte-h":!0}),f(dt)!=="svelte-2a5chx"&&(dt.innerHTML=ko),mn=s($),pt=d($,"P",{"data-svelte-h":!0}),f(pt)!=="svelte-wz8va1"&&(pt.textContent=Jo),un=s($),ct=d($,"UL",{"data-svelte-h":!0}),f(ct)!=="svelte-1ilr6sx"&&(ct.innerHTML=Co),hn=s($),A=d($,"DIV",{class:!0});var Ke=U(A);h(Pe.$$.fragment,Ke),gn=s(Ke),ft=d(Ke,"P",{"data-svelte-h":!0}),f(ft)!=="svelte-1eed40t"&&(ft.textContent=Io),Ke.forEach(p),bn=s($),mt=d($,"DIV",{class:!0});var Et=U(mt);h(Ze.$$.fragment,Et),Et.forEach(p),_n=s($),W=d($,"DIV",{class:!0});var B=U(W);h(ke.$$.fragment,B),yn=s(B),ut=d(B,"P",{"data-svelte-h":!0}),f(ut)!=="svelte-1vbhnip"&&(ut.innerHTML=Go),vn=s(B),h(O.$$.fragment,B),wn=s(B),ht=d(B,"P",{"data-svelte-h":!0}),f(ht)!=="svelte-5ul9n2"&&(ht.innerHTML=Wo),xn=s(B),gt=d(B,"UL",{"data-svelte-h":!0}),f(gt)!=="svelte-1icy6l9"&&(gt.innerHTML=Bo),B.forEach(p),$n=s($),H=d($,"DIV",{class:!0});var L=U(H);h(Je.$$.fragment,L),Mn=s(L),bt=d(L,"P",{"data-svelte-h":!0}),f(bt)!=="svelte-had4mb"&&(bt.innerHTML=Ho),Tn=s(L),_t=d(L,"P",{"data-svelte-h":!0}),f(_t)!=="svelte-19k67ce"&&(_t.innerHTML=Fo),Un=s(L),h(K.$$.fragment,L),L.forEach(p),jn=s($),ee=d($,"DIV",{class:!0});var et=U(ee);h(Ce.$$.fragment,et),Dn=s(et),yt=d(et,"P",{"data-svelte-h":!0}),f(yt)!=="svelte-1lh0nh5"&&(yt.innerHTML=Vo),et.forEach(p),Pn=s($),te=d($,"DIV",{class:!0});var tt=U(te);h(Ie.$$.fragment,tt),Zn=s(tt),vt=d(tt,"P",{"data-svelte-h":!0}),f(vt)!=="svelte-1vfte1e"&&(vt.innerHTML=No),tt.forEach(p),kn=s($),z=d($,"DIV",{class:!0});var Q=U(z);h(Ge.$$.fragment,Q),Jn=s(Q),wt=d(Q,"P",{"data-svelte-h":!0}),f(wt)!=="svelte-1mfctah"&&(wt.textContent=Xo),Cn=s(Q),h(ne.$$.fragment,Q),Q.forEach(p),In=s($),F=d($,"DIV",{class:!0});var S=U(F);h(We.$$.fragment,S),Gn=s(S),xt=d(S,"P",{"data-svelte-h":!0}),f(xt)!=="svelte-10jaql7"&&(xt.textContent=Lo),Wn=s(S),h(oe.$$.fragment,S),Bn=s(S),h(ie.$$.fragment,S),S.forEach(p),Hn=s($),se=d($,"DIV",{class:!0});var nt=U(se);h(Be.$$.fragment,nt),Fn=s(nt),$t=d(nt,"P",{"data-svelte-h":!0}),f($t)!=="svelte-d7vywi"&&($t.innerHTML=So),nt.forEach(p),Vn=s($),ae=d($,"DIV",{class:!0});var ot=U(ae);h(He.$$.fragment,ot),Nn=s(ot),Mt=d(ot,"P",{"data-svelte-h":!0}),f(Mt)!=="svelte-n1oyuv"&&(Mt.innerHTML=Ro),ot.forEach(p),Xn=s($),V=d($,"DIV",{class:!0});var R=U(V);h(Fe.$$.fragment,R),Ln=s(R),Tt=d(R,"P",{"data-svelte-h":!0}),f(Tt)!=="svelte-e03q3e"&&(Tt.innerHTML=Eo),Sn=s(R),h(re.$$.fragment,R),Rn=s(R),h(le.$$.fragment,R),R.forEach(p),En=s($),J=d($,"DIV",{class:!0});var I=U(J);h(Ve.$$.fragment,I),zn=s(I),Ut=d(I,"P",{"data-svelte-h":!0}),f(Ut)!=="svelte-ccbjek"&&(Ut.textContent=zo),Yn=s(I),jt=d(I,"P",{"data-svelte-h":!0}),f(jt)!=="svelte-1p5vgmd"&&(jt.innerHTML=Yo),Qn=s(I),h(de.$$.fragment,I),qn=s(I),h(pe.$$.fragment,I),An=s(I),h(ce.$$.fragment,I),I.forEach(p),On=s($),fe=d($,"DIV",{class:!0});var it=U(fe);h(Ne.$$.fragment,it),Kn=s(it),Dt=d(it,"P",{"data-svelte-h":!0}),f(Dt)!=="svelte-zkab0b"&&(Dt.innerHTML=Qo),it.forEach(p),eo=s($),me=d($,"DIV",{class:!0});var st=U(me);h(Xe.$$.fragment,st),to=s(st),Pt=d(st,"P",{"data-svelte-h":!0}),f(Pt)!=="svelte-1gut907"&&(Pt.textContent=qo),st.forEach(p),no=s($),ue=d($,"DIV",{class:!0});var sn=U(ue);h(Le.$$.fragment,sn),oo=s(sn),Zt=d(sn,"P",{"data-svelte-h":!0}),f(Zt)!=="svelte-8kophh"&&(Zt.innerHTML=Ao),sn.forEach(p),io=s($),he=d($,"DIV",{class:!0});var an=U(he);h(Se.$$.fragment,an),so=s(an),kt=d(an,"P",{"data-svelte-h":!0}),f(kt)!=="svelte-1jcmq84"&&(kt.innerHTML=Oo),an.forEach(p),$.forEach(p),Ot=s(e),h(Re.$$.fragment,e),Kt=s(e),D=d(e,"DIV",{class:!0});var Z=U(D);h(Ee.$$.fragment,Z),ao=s(Z),Jt=d(Z,"P",{"data-svelte-h":!0}),f(Jt)!=="svelte-1o1wti6"&&(Jt.textContent=Ko),ro=s(Z),Ct=d(Z,"P",{"data-svelte-h":!0}),f(Ct)!=="svelte-1h33ucg"&&(Ct.innerHTML=ei),lo=s(Z),It=d(Z,"UL",{"data-svelte-h":!0}),f(It)!=="svelte-1kk3msp"&&(It.innerHTML=ti),po=s(Z),Gt=d(Z,"P",{"data-svelte-h":!0}),f(Gt)!=="svelte-wz8va1"&&(Gt.textContent=ni),co=s(Z),Wt=d(Z,"UL",{"data-svelte-h":!0}),f(Wt)!=="svelte-56flce"&&(Wt.innerHTML=oi),fo=s(Z),C=d(Z,"DIV",{class:!0});var N=U(C);h(ze.$$.fragment,N),mo=s(N),Bt=d(N,"P",{"data-svelte-h":!0}),f(Bt)!=="svelte-7z61o"&&(Bt.textContent=ii),uo=s(N),Ht=d(N,"P",{"data-svelte-h":!0}),f(Ht)!=="svelte-wyh2cr"&&(Ht.textContent=si),ho=s(N),h(ge.$$.fragment,N),go=s(N),h(be.$$.fragment,N),bo=s(N),h(_e.$$.fragment,N),N.forEach(p),_o=s(Z),ye=d(Z,"DIV",{class:!0});var rn=U(ye);h(Ye.$$.fragment,rn),yo=s(rn),Ft=d(rn,"P",{"data-svelte-h":!0}),f(Ft)!=="svelte-1gut907"&&(Ft.textContent=ai),rn.forEach(p),vo=s(Z),ve=d(Z,"DIV",{class:!0});var ln=U(ve);h(Qe.$$.fragment,ln),wo=s(ln),Vt=d(ln,"P",{"data-svelte-h":!0}),f(Vt)!=="svelte-spoull"&&(Vt.innerHTML=ri),ln.forEach(p),Z.forEach(p),en=s(e),h(qe.$$.fragment,e),tn=s(e),X=d(e,"DIV",{class:!0});var Lt=U(X);h(Ae.$$.fragment,Lt),xo=s(Lt),Nt=d(Lt,"P",{"data-svelte-h":!0}),f(Nt)!=="svelte-7y8zei"&&(Nt.textContent=li),$o=s(Lt),Y=d(Lt,"DIV",{class:!0});var St=U(Y);h(Oe.$$.fragment,St),Mo=s(St),Xt=d(St,"P",{"data-svelte-h":!0}),f(Xt)!=="svelte-5nfhmh"&&(Xt.textContent=di),To=s(St),h(we.$$.fragment,St),St.forEach(p),Lt.forEach(p),nn=s(e),Rt=d(e,"P",{}),U(Rt).forEach(p),this.h()},h(){j(n,"name","hf:doc:metadata"),j(n,"content",ki),j(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){o(document.head,n),v(e,w,c),v(e,a,c),v(e,r,c),g(m,e,c),v(e,t,c),v(e,M,c),v(e,E,c),v(e,Me,c),v(e,zt,c),g(q,e,c),v(e,Yt,c),v(e,Te,c),v(e,Qt,c),v(e,Ue,c),v(e,qt,c),g(je,e,c),v(e,At,c),v(e,x,c),g(De,x,null),o(x,pn),o(x,rt),o(x,cn),o(x,lt),o(x,fn),o(x,dt),o(x,mn),o(x,pt),o(x,un),o(x,ct),o(x,hn),o(x,A),g(Pe,A,null),o(A,gn),o(A,ft),o(x,bn),o(x,mt),g(Ze,mt,null),o(x,_n),o(x,W),g(ke,W,null),o(W,yn),o(W,ut),o(W,vn),g(O,W,null),o(W,wn),o(W,ht),o(W,xn),o(W,gt),o(x,$n),o(x,H),g(Je,H,null),o(H,Mn),o(H,bt),o(H,Tn),o(H,_t),o(H,Un),g(K,H,null),o(x,jn),o(x,ee),g(Ce,ee,null),o(ee,Dn),o(ee,yt),o(x,Pn),o(x,te),g(Ie,te,null),o(te,Zn),o(te,vt),o(x,kn),o(x,z),g(Ge,z,null),o(z,Jn),o(z,wt),o(z,Cn),g(ne,z,null),o(x,In),o(x,F),g(We,F,null),o(F,Gn),o(F,xt),o(F,Wn),g(oe,F,null),o(F,Bn),g(ie,F,null),o(x,Hn),o(x,se),g(Be,se,null),o(se,Fn),o(se,$t),o(x,Vn),o(x,ae),g(He,ae,null),o(ae,Nn),o(ae,Mt),o(x,Xn),o(x,V),g(Fe,V,null),o(V,Ln),o(V,Tt),o(V,Sn),g(re,V,null),o(V,Rn),g(le,V,null),o(x,En),o(x,J),g(Ve,J,null),o(J,zn),o(J,Ut),o(J,Yn),o(J,jt),o(J,Qn),g(de,J,null),o(J,qn),g(pe,J,null),o(J,An),g(ce,J,null),o(x,On),o(x,fe),g(Ne,fe,null),o(fe,Kn),o(fe,Dt),o(x,eo),o(x,me),g(Xe,me,null),o(me,to),o(me,Pt),o(x,no),o(x,ue),g(Le,ue,null),o(ue,oo),o(ue,Zt),o(x,io),o(x,he),g(Se,he,null),o(he,so),o(he,kt),v(e,Ot,c),g(Re,e,c),v(e,Kt,c),v(e,D,c),g(Ee,D,null),o(D,ao),o(D,Jt),o(D,ro),o(D,Ct),o(D,lo),o(D,It),o(D,po),o(D,Gt),o(D,co),o(D,Wt),o(D,fo),o(D,C),g(ze,C,null),o(C,mo),o(C,Bt),o(C,uo),o(C,Ht),o(C,ho),g(ge,C,null),o(C,go),g(be,C,null),o(C,bo),g(_e,C,null),o(D,_o),o(D,ye),g(Ye,ye,null),o(ye,yo),o(ye,Ft),o(D,vo),o(D,ve),g(Qe,ve,null),o(ve,wo),o(ve,Vt),v(e,en,c),g(qe,e,c),v(e,tn,c),v(e,X,c),g(Ae,X,null),o(X,xo),o(X,Nt),o(X,$o),o(X,Y),g(Oe,Y,null),o(Y,Mo),o(Y,Xt),o(Y,To),g(we,Y,null),v(e,nn,c),v(e,Rt,c),on=!0},p(e,[c]){const $={};c&2&&($.$$scope={dirty:c,ctx:e}),q.$set($);const Ke={};c&2&&(Ke.$$scope={dirty:c,ctx:e}),O.$set(Ke);const Et={};c&2&&(Et.$$scope={dirty:c,ctx:e}),K.$set(Et);const B={};c&2&&(B.$$scope={dirty:c,ctx:e}),ne.$set(B);const L={};c&2&&(L.$$scope={dirty:c,ctx:e}),oe.$set(L);const et={};c&2&&(et.$$scope={dirty:c,ctx:e}),ie.$set(et);const tt={};c&2&&(tt.$$scope={dirty:c,ctx:e}),re.$set(tt);const Q={};c&2&&(Q.$$scope={dirty:c,ctx:e}),le.$set(Q);const S={};c&2&&(S.$$scope={dirty:c,ctx:e}),de.$set(S);const nt={};c&2&&(nt.$$scope={dirty:c,ctx:e}),pe.$set(nt);const ot={};c&2&&(ot.$$scope={dirty:c,ctx:e}),ce.$set(ot);const R={};c&2&&(R.$$scope={dirty:c,ctx:e}),ge.$set(R);const I={};c&2&&(I.$$scope={dirty:c,ctx:e}),be.$set(I);const it={};c&2&&(it.$$scope={dirty:c,ctx:e}),_e.$set(it);const st={};c&2&&(st.$$scope={dirty:c,ctx:e}),we.$set(st)},i(e){on||(b(m.$$.fragment,e),b(q.$$.fragment,e),b(je.$$.fragment,e),b(De.$$.fragment,e),b(Pe.$$.fragment,e),b(Ze.$$.fragment,e),b(ke.$$.fragment,e),b(O.$$.fragment,e),b(Je.$$.fragment,e),b(K.$$.fragment,e),b(Ce.$$.fragment,e),b(Ie.$$.fragment,e),b(Ge.$$.fragment,e),b(ne.$$.fragment,e),b(We.$$.fragment,e),b(oe.$$.fragment,e),b(ie.$$.fragment,e),b(Be.$$.fragment,e),b(He.$$.fragment,e),b(Fe.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),b(Ve.$$.fragment,e),b(de.$$.fragment,e),b(pe.$$.fragment,e),b(ce.$$.fragment,e),b(Ne.$$.fragment,e),b(Xe.$$.fragment,e),b(Le.$$.fragment,e),b(Se.$$.fragment,e),b(Re.$$.fragment,e),b(Ee.$$.fragment,e),b(ze.$$.fragment,e),b(ge.$$.fragment,e),b(be.$$.fragment,e),b(_e.$$.fragment,e),b(Ye.$$.fragment,e),b(Qe.$$.fragment,e),b(qe.$$.fragment,e),b(Ae.$$.fragment,e),b(Oe.$$.fragment,e),b(we.$$.fragment,e),on=!0)},o(e){_(m.$$.fragment,e),_(q.$$.fragment,e),_(je.$$.fragment,e),_(De.$$.fragment,e),_(Pe.$$.fragment,e),_(Ze.$$.fragment,e),_(ke.$$.fragment,e),_(O.$$.fragment,e),_(Je.$$.fragment,e),_(K.$$.fragment,e),_(Ce.$$.fragment,e),_(Ie.$$.fragment,e),_(Ge.$$.fragment,e),_(ne.$$.fragment,e),_(We.$$.fragment,e),_(oe.$$.fragment,e),_(ie.$$.fragment,e),_(Be.$$.fragment,e),_(He.$$.fragment,e),_(Fe.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(Ve.$$.fragment,e),_(de.$$.fragment,e),_(pe.$$.fragment,e),_(ce.$$.fragment,e),_(Ne.$$.fragment,e),_(Xe.$$.fragment,e),_(Le.$$.fragment,e),_(Se.$$.fragment,e),_(Re.$$.fragment,e),_(Ee.$$.fragment,e),_(ze.$$.fragment,e),_(ge.$$.fragment,e),_(be.$$.fragment,e),_(_e.$$.fragment,e),_(Ye.$$.fragment,e),_(Qe.$$.fragment,e),_(qe.$$.fragment,e),_(Ae.$$.fragment,e),_(Oe.$$.fragment,e),_(we.$$.fragment,e),on=!1},d(e){e&&(p(w),p(a),p(r),p(t),p(M),p(E),p(Me),p(zt),p(Yt),p(Te),p(Qt),p(Ue),p(qt),p(At),p(x),p(Ot),p(Kt),p(D),p(en),p(tn),p(X),p(nn),p(Rt)),p(n),y(m,e),y(q,e),y(je,e),y(De),y(Pe),y(Ze),y(ke),y(O),y(Je),y(K),y(Ce),y(Ie),y(Ge),y(ne),y(We),y(oe),y(ie),y(Be),y(He),y(Fe),y(re),y(le),y(Ve),y(de),y(pe),y(ce),y(Ne),y(Xe),y(Le),y(Se),y(Re,e),y(Ee),y(ze),y(ge),y(be),y(_e),y(Ye),y(Qe),y(qe,e),y(Ae),y(Oe),y(we)}}}const ki='{"title":"Pipelines","local":"pipelines","sections":[{"title":"DiffusionPipeline","local":"diffusers.DiffusionPipeline","sections":[],"depth":2},{"title":"FlaxDiffusionPipeline","local":"diffusers.FlaxDiffusionPipeline","sections":[],"depth":2},{"title":"PushToHubMixin","local":"diffusers.utils.PushToHubMixin","sections":[],"depth":2}],"depth":1}';function Ji(T){return ci(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vi extends fi{constructor(n){super(),mi(this,n,Ji,Zi,pi,{})}}export{Vi as component};
