import{s as dt,o as pt,n as He}from"../chunks/scheduler.8c3d61f6.js";import{S as ct,i as mt,g as d,s as a,r as u,A as ut,h as p,f as n,c as s,j as V,u as g,x as M,k as Z,y as l,a as r,v as f,d as h,t as _,w as y}from"../chunks/index.da70eac4.js";import{T as gt}from"../chunks/Tip.1d9b8c37.js";import{D as ne}from"../chunks/Docstring.6b390b9a.js";import{C as Fe}from"../chunks/CodeBlock.00a903b3.js";import{E as lt}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as ge,E as ft}from"../chunks/EditOnGithub.1e64e623.js";function ht($){let i,J='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){i=d("p"),i.innerHTML=J},l(m){i=p(m,"P",{"data-svelte-h":!0}),M(i)!=="svelte-1qn15hi"&&(i.innerHTML=J)},m(m,c){r(m,i,c)},p:He,d(m){m&&n(i)}}}function _t($){let i,J="Examples:",m,c,b;return c=new Fe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKLWan, WanPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models: Wan-AI/Wan2.1-T2V-14B-Diffusers, Wan-AI/Wan2.1-T2V-1.3B-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;Wan-AI/Wan2.1-T2V-14B-Diffusers&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.float32)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = WanPipeline.from_pretrained(model_id, vae=vae, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat walks on the grass, realistic&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;Bright tones, overexposed, static, blurred details, subtitles, style, works, paintings, images, static, overall gray, worst quality, low quality, JPEG compression residue, ugly, incomplete, extra fingers, poorly drawn hands, poorly drawn faces, deformed, disfigured, misshapen limbs, fused fingers, still picture, messy background, three legs, many people in the background, walking backwards&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">832</span>,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">81</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">5.0</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">15</span>)`,wrap:!1}}),{c(){i=d("p"),i.textContent=J,m=a(),u(c.$$.fragment)},l(o){i=p(o,"P",{"data-svelte-h":!0}),M(i)!=="svelte-kvfsh7"&&(i.textContent=J),m=s(o),g(c.$$.fragment,o)},m(o,T){r(o,i,T),r(o,m,T),f(c,o,T),b=!0},p:He,i(o){b||(h(c.$$.fragment,o),b=!0)},o(o){_(c.$$.fragment,o),b=!1},d(o){o&&(n(i),n(m)),y(c,o)}}}function yt($){let i,J="Examples:",m,c,b;return c=new Fe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKLWan, WanImageToVideoPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models: Wan-AI/Wan2.1-I2V-14B-480P-Diffusers, Wan-AI/Wan2.1-I2V-1.3B-720P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;Wan-AI/Wan2.1-I2V-14B-480P-Diffusers&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.float32)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = WanImageToVideoPipeline.from_pretrained(model_id, vae=vae, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>height, width = <span class="hljs-number">480</span>, <span class="hljs-number">832</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/astronaut.jpg&quot;</span>
<span class="hljs-meta">... </span>).resize((width, height))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut hatching from an egg, on the surface of the moon, the darkness and depth of space realised in &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the background. High quality, ultrarealistic detail and breath-taking movie-like camera shot.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;Bright tones, overexposed, static, blurred details, subtitles, style, works, paintings, images, static, overall gray, worst quality, low quality, JPEG compression residue, ugly, incomplete, extra fingers, poorly drawn hands, poorly drawn faces, deformed, disfigured, misshapen limbs, fused fingers, still picture, messy background, three legs, many people in the background, walking backwards&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    image=image, prompt=prompt, negative_prompt=negative_prompt, num_frames=<span class="hljs-number">81</span>, guidance_scale=<span class="hljs-number">5.0</span>
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">15</span>)`,wrap:!1}}),{c(){i=d("p"),i.textContent=J,m=a(),u(c.$$.fragment)},l(o){i=p(o,"P",{"data-svelte-h":!0}),M(i)!=="svelte-kvfsh7"&&(i.textContent=J),m=s(o),g(c.$$.fragment,o)},m(o,T){r(o,i,T),r(o,m,T),f(c,o,T),b=!0},p:He,i(o){b||(h(c.$$.fragment,o),b=!0)},o(o){_(c.$$.fragment,o),b=!1},d(o){o&&(n(i),n(m)),y(c,o)}}}function bt($){let i,J,m,c,b,o,T,ze='<a href="https://github.com/Wan-Video/Wan2.1" rel="nofollow">Wan 2.1</a> by the Alibaba Wan Team.',fe,G,he,N,qe="Recommendations for inference:",_e,R,Ae='<li>VAE in <code>torch.float32</code> for better decoding quality.</li> <li><code>num_frames</code> should be of the form <code>4 * k + 1</code>, for example <code>49</code> or <code>81</code>.</li> <li>For smaller resolution videos, try lower values of <code>shift</code> (between <code>2.0</code> to <code>5.0</code>) in the <a href="https://huggingface.co/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler.shift" rel="nofollow">Scheduler</a>. For larger resolution videos, try higher values (between <code>7.0</code> and <code>12.0</code>). The default value is <code>3.0</code> for Wan.</li>',ye,X,be,D,Oe="Wan can be used with many different schedulers, each with their own benefits regarding speed and generation quality. By default, Wan uses the <code>UniPCMultistepScheduler(prediction_type=&quot;flow_prediction&quot;, use_flow_sigmas=True, flow_shift=3.0)</code> scheduler. You can use a different scheduler as follows:",Me,Q,Te,Y,we,w,L,Ze,oe,Ke="Pipeline for text-to-video generation using Wan.",$e,ae,et=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ge,U,S,Pe,se,tt="The call function to the pipeline for generation.",Be,P,Ce,B,H,Ee,ie,nt="Encodes the prompt into text encoder hidden states.",ve,F,Je,v,z,Ne,re,ot="Pipeline for image-to-video generation using Wan.",Re,le,at=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Xe,x,q,De,de,st="The call function to the pipeline for generation.",Qe,C,Ye,E,A,Le,pe,it="Encodes the prompt into text encoder hidden states.",We,O,Ue,I,K,Se,ce,rt="Output class for Wan pipelines.",xe,ee,ke,ue,Ie;return b=new ge({props:{title:"Wan",local:"wan",headingTag:"h1"}}),G=new gt({props:{$$slots:{default:[ht]},$$scope:{ctx:$}}}),X=new ge({props:{title:"Using a custom scheduler",local:"using-a-custom-scheduler",headingTag:"h3"}}),Q=new Fe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsb3dNYXRjaEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUyQyUyMFdhblBpcGVsaW5lJTBBJTBBc2NoZWR1bGVyX2ElMjAlM0QlMjBGbG93TWF0Y2hFdWxlckRpc2NyZXRlU2NoZWR1bGVyKHNoaWZ0JTNENS4wKSUwQXNjaGVkdWxlcl9iJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIocHJlZGljdGlvbl90eXBlJTNEJTIyZmxvd19wcmVkaWN0aW9uJTIyJTJDJTIwdXNlX2Zsb3dfc2lnbWFzJTNEVHJ1ZSUyQyUyMGZsb3dfc2hpZnQlM0Q0LjApJTBBJTBBcGlwZSUyMCUzRCUyMFdhblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJXYW4tQUklMkZXYW4yLjEtVDJWLTEuM0ItRGlmZnVzZXJzJTIyJTJDJTIwc2NoZWR1bGVyJTNEJTNDQ1VTVE9NX1NDSEVEVUxFUl9IRVJFJTNFKSUwQSUwQSUyMyUyMG9yJTJDJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjAlM0NDVVNUT01fU0NIRURVTEVSX0hFUkUlM0U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlowMatchEulerDiscreteScheduler, UniPCMultistepScheduler, WanPipeline

scheduler_a = FlowMatchEulerDiscreteScheduler(shift=<span class="hljs-number">5.0</span>)
scheduler_b = UniPCMultistepScheduler(prediction_type=<span class="hljs-string">&quot;flow_prediction&quot;</span>, use_flow_sigmas=<span class="hljs-literal">True</span>, flow_shift=<span class="hljs-number">4.0</span>)

pipe = WanPipeline.from_pretrained(<span class="hljs-string">&quot;Wan-AI/Wan2.1-T2V-1.3B-Diffusers&quot;</span>, scheduler=&lt;CUSTOM_SCHEDULER_HERE&gt;)

<span class="hljs-comment"># or,</span>
pipe.scheduler = &lt;CUSTOM_SCHEDULER_HERE&gt;`,wrap:!1}}),Y=new ge({props:{title:"WanPipeline",local:"diffusers.WanPipeline",headingTag:"h2"}}),L=new ne({props:{name:"class diffusers.WanPipeline",anchor:"diffusers.WanPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"transformer",val:": WanTransformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"}],parametersDescription:[{anchor:"diffusers.WanPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.WanPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.WanPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/wan_transformer_3d#diffusers.WanTransformer3DModel">WanTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the input latents.`,name:"transformer"},{anchor:"diffusers.WanPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.WanPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan.py#L89"}}),S=new ne({props:{name:"__call__",anchor:"diffusers.WanPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 720"},{name:"width",val:": int = 1280"},{name:"num_frames",val:": int = 81"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.WanPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.WanPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>720</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.WanPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>1280</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.WanPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>129</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.WanPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.WanPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>5.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.WanPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.WanPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.WanPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.WanPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WanPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.WanPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>WanPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.WanPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.WanPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.WanPipeline.__call__.autocast_dtype",description:`<strong>autocast_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.bfloat16</code>) &#x2014;
The dtype to use for the torch.amp.autocast.`,name:"autocast_dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan.py#L350",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>WanPipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned where
the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~WanPipelineOutput</code> or <code>tuple</code></p>
`}}),P=new lt({props:{anchor:"diffusers.WanPipeline.__call__.example",$$slots:{default:[_t]},$$scope:{ctx:$}}}),H=new ne({props:{name:"encode_prompt",anchor:"diffusers.WanPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.WanPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.WanPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WanPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.WanPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.WanPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WanPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.WanPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.WanPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan.py#L177"}}),F=new ge({props:{title:"WanImageToVideoPipeline",local:"diffusers.WanImageToVideoPipeline",headingTag:"h2"}}),z=new ne({props:{name:"class diffusers.WanImageToVideoPipeline",anchor:"diffusers.WanImageToVideoPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"image_encoder",val:": CLIPVisionModel"},{name:"image_processor",val:": CLIPImageProcessor"},{name:"transformer",val:": WanTransformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"}],parametersDescription:[{anchor:"diffusers.WanImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.WanImageToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.WanImageToVideoPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPVisionModel" rel="nofollow">CLIP</a>, specifically
the
<a href="https://github.com/mlfoundations/open_clip/blob/main/docs/PRETRAINED.md#vit-h14-xlm-roberta-large" rel="nofollow">clip-vit-huge-patch14</a>
variant.`,name:"image_encoder"},{anchor:"diffusers.WanImageToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/wan_transformer_3d#diffusers.WanTransformer3DModel">WanTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the input latents.`,name:"transformer"},{anchor:"diffusers.WanImageToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.WanImageToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan_i2v.py#L106"}}),q=new ne({props:{name:"__call__",anchor:"diffusers.WanImageToVideoPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"max_area",val:": int = 921600"},{name:"num_frames",val:": int = 81"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.WanImageToVideoPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.max_area",description:`<strong>max_area</strong> (<code>int</code>, defaults to <code>1280 * 720</code>) &#x2014;
The maximum area in pixels of the generated image.`,name:"max_area"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>129</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>5.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>WanPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
The maximum sequence length of the prompt.`,name:"max_sequence_length"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.shift",description:`<strong>shift</strong> (<code>float</code>, <em>optional</em>, defaults to <code>5.0</code>) &#x2014;
The shift of the flow.`,name:"shift"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.autocast_dtype",description:`<strong>autocast_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.bfloat16</code>) &#x2014;
The dtype to use for the torch.amp.autocast.`,name:"autocast_dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan_i2v.py#L415",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>WanPipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned where
the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~WanPipelineOutput</code> or <code>tuple</code></p>
`}}),C=new lt({props:{anchor:"diffusers.WanImageToVideoPipeline.__call__.example",$$slots:{default:[yt]},$$scope:{ctx:$}}}),A=new ne({props:{name:"encode_prompt",anchor:"diffusers.WanImageToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan_i2v.py#L210"}}),O=new ge({props:{title:"WanPipelineOutput",local:"diffusers.pipelines.wan.pipeline_output.WanPipelineOutput",headingTag:"h2"}}),K=new ne({props:{name:"class diffusers.pipelines.wan.pipeline_output.WanPipelineOutput",anchor:"diffusers.pipelines.wan.pipeline_output.WanPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.wan.pipeline_output.WanPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_output.py#L8"}}),ee=new ft({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/wan.md"}}),{c(){i=d("meta"),J=a(),m=d("p"),c=a(),u(b.$$.fragment),o=a(),T=d("p"),T.innerHTML=ze,fe=a(),u(G.$$.fragment),he=a(),N=d("p"),N.textContent=qe,_e=a(),R=d("ul"),R.innerHTML=Ae,ye=a(),u(X.$$.fragment),be=a(),D=d("p"),D.innerHTML=Oe,Me=a(),u(Q.$$.fragment),Te=a(),u(Y.$$.fragment),we=a(),w=d("div"),u(L.$$.fragment),Ze=a(),oe=d("p"),oe.textContent=Ke,$e=a(),ae=d("p"),ae.innerHTML=et,Ge=a(),U=d("div"),u(S.$$.fragment),Pe=a(),se=d("p"),se.textContent=tt,Be=a(),u(P.$$.fragment),Ce=a(),B=d("div"),u(H.$$.fragment),Ee=a(),ie=d("p"),ie.textContent=nt,ve=a(),u(F.$$.fragment),Je=a(),v=d("div"),u(z.$$.fragment),Ne=a(),re=d("p"),re.textContent=ot,Re=a(),le=d("p"),le.innerHTML=at,Xe=a(),x=d("div"),u(q.$$.fragment),De=a(),de=d("p"),de.textContent=st,Qe=a(),u(C.$$.fragment),Ye=a(),E=d("div"),u(A.$$.fragment),Le=a(),pe=d("p"),pe.textContent=it,We=a(),u(O.$$.fragment),Ue=a(),I=d("div"),u(K.$$.fragment),Se=a(),ce=d("p"),ce.textContent=rt,xe=a(),u(ee.$$.fragment),ke=a(),ue=d("p"),this.h()},l(e){const t=ut("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(n),J=s(e),m=p(e,"P",{}),V(m).forEach(n),c=s(e),g(b.$$.fragment,e),o=s(e),T=p(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-16y8q1j"&&(T.innerHTML=ze),fe=s(e),g(G.$$.fragment,e),he=s(e),N=p(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1bbhycm"&&(N.textContent=qe),_e=s(e),R=p(e,"UL",{"data-svelte-h":!0}),M(R)!=="svelte-1dpydlh"&&(R.innerHTML=Ae),ye=s(e),g(X.$$.fragment,e),be=s(e),D=p(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-c0om1t"&&(D.innerHTML=Oe),Me=s(e),g(Q.$$.fragment,e),Te=s(e),g(Y.$$.fragment,e),we=s(e),w=p(e,"DIV",{class:!0});var W=V(w);g(L.$$.fragment,W),Ze=s(W),oe=p(W,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-cppop6"&&(oe.textContent=Ke),$e=s(W),ae=p(W,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-496sm0"&&(ae.innerHTML=et),Ge=s(W),U=p(W,"DIV",{class:!0});var j=V(U);g(S.$$.fragment,j),Pe=s(j),se=p(j,"P",{"data-svelte-h":!0}),M(se)!=="svelte-50j04k"&&(se.textContent=tt),Be=s(j),g(P.$$.fragment,j),j.forEach(n),Ce=s(W),B=p(W,"DIV",{class:!0});var te=V(B);g(H.$$.fragment,te),Ee=s(te),ie=p(te,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-16q0ax1"&&(ie.textContent=nt),te.forEach(n),W.forEach(n),ve=s(e),g(F.$$.fragment,e),Je=s(e),v=p(e,"DIV",{class:!0});var k=V(v);g(z.$$.fragment,k),Ne=s(k),re=p(k,"P",{"data-svelte-h":!0}),M(re)!=="svelte-1u5shki"&&(re.textContent=ot),Re=s(k),le=p(k,"P",{"data-svelte-h":!0}),M(le)!=="svelte-496sm0"&&(le.innerHTML=at),Xe=s(k),x=p(k,"DIV",{class:!0});var me=V(x);g(q.$$.fragment,me),De=s(me),de=p(me,"P",{"data-svelte-h":!0}),M(de)!=="svelte-50j04k"&&(de.textContent=st),Qe=s(me),g(C.$$.fragment,me),me.forEach(n),Ye=s(k),E=p(k,"DIV",{class:!0});var je=V(E);g(A.$$.fragment,je),Le=s(je),pe=p(je,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-16q0ax1"&&(pe.textContent=it),je.forEach(n),k.forEach(n),We=s(e),g(O.$$.fragment,e),Ue=s(e),I=p(e,"DIV",{class:!0});var Ve=V(I);g(K.$$.fragment,Ve),Se=s(Ve),ce=p(Ve,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-fkhkmf"&&(ce.textContent=rt),Ve.forEach(n),xe=s(e),g(ee.$$.fragment,e),ke=s(e),ue=p(e,"P",{}),V(ue).forEach(n),this.h()},h(){Z(i,"name","hf:doc:metadata"),Z(i,"content",Mt),Z(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,i),r(e,J,t),r(e,m,t),r(e,c,t),f(b,e,t),r(e,o,t),r(e,T,t),r(e,fe,t),f(G,e,t),r(e,he,t),r(e,N,t),r(e,_e,t),r(e,R,t),r(e,ye,t),f(X,e,t),r(e,be,t),r(e,D,t),r(e,Me,t),f(Q,e,t),r(e,Te,t),f(Y,e,t),r(e,we,t),r(e,w,t),f(L,w,null),l(w,Ze),l(w,oe),l(w,$e),l(w,ae),l(w,Ge),l(w,U),f(S,U,null),l(U,Pe),l(U,se),l(U,Be),f(P,U,null),l(w,Ce),l(w,B),f(H,B,null),l(B,Ee),l(B,ie),r(e,ve,t),f(F,e,t),r(e,Je,t),r(e,v,t),f(z,v,null),l(v,Ne),l(v,re),l(v,Re),l(v,le),l(v,Xe),l(v,x),f(q,x,null),l(x,De),l(x,de),l(x,Qe),f(C,x,null),l(v,Ye),l(v,E),f(A,E,null),l(E,Le),l(E,pe),r(e,We,t),f(O,e,t),r(e,Ue,t),r(e,I,t),f(K,I,null),l(I,Se),l(I,ce),r(e,xe,t),f(ee,e,t),r(e,ke,t),r(e,ue,t),Ie=!0},p(e,[t]){const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),G.$set(W);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),P.$set(j);const te={};t&2&&(te.$$scope={dirty:t,ctx:e}),C.$set(te)},i(e){Ie||(h(b.$$.fragment,e),h(G.$$.fragment,e),h(X.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(L.$$.fragment,e),h(S.$$.fragment,e),h(P.$$.fragment,e),h(H.$$.fragment,e),h(F.$$.fragment,e),h(z.$$.fragment,e),h(q.$$.fragment,e),h(C.$$.fragment,e),h(A.$$.fragment,e),h(O.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),Ie=!0)},o(e){_(b.$$.fragment,e),_(G.$$.fragment,e),_(X.$$.fragment,e),_(Q.$$.fragment,e),_(Y.$$.fragment,e),_(L.$$.fragment,e),_(S.$$.fragment,e),_(P.$$.fragment,e),_(H.$$.fragment,e),_(F.$$.fragment,e),_(z.$$.fragment,e),_(q.$$.fragment,e),_(C.$$.fragment,e),_(A.$$.fragment,e),_(O.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),Ie=!1},d(e){e&&(n(J),n(m),n(c),n(o),n(T),n(fe),n(he),n(N),n(_e),n(R),n(ye),n(be),n(D),n(Me),n(Te),n(we),n(w),n(ve),n(Je),n(v),n(We),n(Ue),n(I),n(xe),n(ke),n(ue)),n(i),y(b,e),y(G,e),y(X,e),y(Q,e),y(Y,e),y(L),y(S),y(P),y(H),y(F,e),y(z),y(q),y(C),y(A),y(O,e),y(K),y(ee,e)}}}const Mt='{"title":"Wan","local":"wan","sections":[{"title":"Using a custom scheduler","local":"using-a-custom-scheduler","sections":[],"depth":3},{"title":"WanPipeline","local":"diffusers.WanPipeline","sections":[],"depth":2},{"title":"WanImageToVideoPipeline","local":"diffusers.WanImageToVideoPipeline","sections":[],"depth":2},{"title":"WanPipelineOutput","local":"diffusers.pipelines.wan.pipeline_output.WanPipelineOutput","sections":[],"depth":2}],"depth":1}';function Tt($){return pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends ct{constructor(i){super(),mt(this,i,Tt,bt,dt,{})}}export{It as component};
