import{s as ci,o as gi,n as wo}from"../chunks/scheduler.6062bdaf.js";import{S as pi,i as di,g as r,s as n,r as p,A as hi,h as a,f as i,c as o,j as b,u as d,x as c,k as v,y as t,a as _,v as h,d as u,t as m,w as f}from"../chunks/index.4bca734e.js";import{T as ra}from"../chunks/Tip.b9ac1f03.js";import{D as $}from"../chunks/Docstring.81ba5e3c.js";import{C as ui}from"../chunks/CodeBlock.fa01571c.js";import{E as mi}from"../chunks/ExampleCodeBlock.30e7542f.js";import{H as xo,E as fi}from"../chunks/EditOnGithub.74ab2baa.js";function _i(H){let y,T=`<a href="/docs/huggingface_hub/main/en/package_reference/repository#huggingface_hub.Repository">Repository</a> is deprecated in favor of the http-based alternatives implemented in
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>. Given its large adoption in legacy code, the complete removal of
<a href="/docs/huggingface_hub/main/en/package_reference/repository#huggingface_hub.Repository">Repository</a> will only happen in release <code>v1.0</code>. For more details, please read
<a href="https://huggingface.co/docs/huggingface_hub/concepts/git_vs_http" rel="nofollow">https://huggingface.co/docs/huggingface_hub/concepts/git_vs_http</a>.`;return{c(){y=r("p"),y.innerHTML=T},l(w){y=a(w,"P",{"data-svelte-h":!0}),c(y)!=="svelte-e9v4xw"&&(y.innerHTML=T)},m(w,C){_(w,y,C)},p:wo,d(w){w&&i(y)}}}function bi(H){let y,T="Raises the following error:",w,C,R=`<li><p><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if an organization token (starts with “api_org”) is passed. Use must use
your own personal access token (see <a href="https://hf.co/settings/tokens" rel="nofollow">https://hf.co/settings/tokens</a>).</p></li> <li><p><a href="https://docs.python.org/3/library/exceptions.html#EnvironmentError" rel="nofollow"><code>EnvironmentError</code></a>
if you are trying to clone the repository in a non-empty folder, or if the
<code>git</code> operations raise errors.</p></li>`;return{c(){y=r("p"),y.textContent=T,w=n(),C=r("ul"),C.innerHTML=R},l(x){y=a(x,"P",{"data-svelte-h":!0}),c(y)!=="svelte-1f6kjc7"&&(y.textContent=T),w=o(x),C=a(x,"UL",{"data-svelte-h":!0}),c(C)!=="svelte-dnmxmk"&&(C.innerHTML=R)},m(x,I){_(x,y,I),_(x,w,I),_(x,C,I)},p:wo,d(x){x&&(i(y),i(w),i(C))}}}function vi(H){let y,T="Examples:",w,C,R;return C=new ui({props:{code:"d2l0aCUyMFJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIydGV4dC1maWxlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsb25lX2Zyb20lM0QlMjIlM0N1c2VyJTNFJTJGdGV4dC1maWxlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEVHJ1ZSUyQyUwQSkuY29tbWl0KCUyMk15JTIwZmlyc3QlMjBmaWxlJTIwJTNBKSUyMiklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwb3BlbiglMjJmaWxlLnR4dCUyMiUyQyUyMCUyMnclMkIlMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShqc29uLmR1bXBzKCU3QiUyMmhleSUyMiUzQSUyMDglN0QpKSUwQSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjB0b3JjaC5ubi5UcmFuc2Zvcm1lcigpJTBBd2l0aCUyMFJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIydG9yY2gtbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjbG9uZV9mcm9tJTNEJTIyJTNDdXNlciUzRSUyRnRvcmNoLW1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW4lM0RUcnVlJTJDJTBBKS5jb21taXQoJTIyTXklMjBjb29sJTIwbW9kZWwlMjAlM0EpJTIyKSUzQSUwQSUyMCUyMCUyMCUyMHRvcmNoLnNhdmUobW9kZWwuc3RhdGVfZGljdCgpJTJDJTIwJTIybW9kZWwucHQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;text-files&quot;</span>,
<span class="hljs-meta">... </span>    clone_from=<span class="hljs-string">&quot;&lt;user&gt;/text-files&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>).commit(<span class="hljs-string">&quot;My first file :)&quot;</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;file.txt&quot;</span>, <span class="hljs-string">&quot;w+&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(json.dumps({<span class="hljs-string">&quot;hey&quot;</span>: <span class="hljs-number">8</span>}))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = torch.nn.Transformer()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;torch-model&quot;</span>,
<span class="hljs-meta">... </span>    clone_from=<span class="hljs-string">&quot;&lt;user&gt;/torch-model&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>).commit(<span class="hljs-string">&quot;My cool model :)&quot;</span>):
<span class="hljs-meta">... </span>    torch.save(model.state_dict(), <span class="hljs-string">&quot;model.pt&quot;</span>)`,wrap:!1}}),{c(){y=r("p"),y.textContent=T,w=n(),p(C.$$.fragment)},l(x){y=a(x,"P",{"data-svelte-h":!0}),c(y)!=="svelte-kvfsh7"&&(y.textContent=T),w=o(x),d(C.$$.fragment,x)},m(x,I){_(x,y,I),_(x,w,I),h(C,x,I),R=!0},p:wo,i(x){R||(u(C.$$.fragment,x),R=!0)},o(x){m(C.$$.fragment,x),R=!1},d(x){x&&(i(y),i(w)),f(C,x)}}}function yi(H){let y,T=`<a href="/docs/huggingface_hub/main/en/package_reference/repository#huggingface_hub.Repository">Repository</a> is deprecated in favor of the http-based alternatives implemented in
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>. Given its large adoption in legacy code, the complete removal of
<a href="/docs/huggingface_hub/main/en/package_reference/repository#huggingface_hub.Repository">Repository</a> will only happen in release <code>v1.0</code>. For more details, please read
<a href="https://huggingface.co/docs/huggingface_hub/concepts/git_vs_http" rel="nofollow">https://huggingface.co/docs/huggingface_hub/concepts/git_vs_http</a>.`;return{c(){y=r("p"),y.innerHTML=T},l(w){y=a(w,"P",{"data-svelte-h":!0}),c(y)!=="svelte-e9v4xw"&&(y.innerHTML=T)},m(w,C){_(w,y,C)},p:wo,d(w){w&&i(y)}}}function $i(H){let y,T,w,C,R,x,I,aa=`The <code>Repository</code> class is a helper class that wraps <code>git</code> and <code>git-lfs</code> commands. It provides tooling adapted
for managing repositories which can be very large.`,Tn,we,ia=`It is the recommended tool as soon as any <code>git</code> operation is involved, or when collaboration will be a point
of focus with the repository itself.`,Rn,Ce,In,s,ke,Co,vt,sa="Helper class to wrap the git and git-lfs commands.",ko,yt,la=`The aim is to facilitate interacting with huggingface.co hosted model or
dataset repos, though not a lot here (if any) is actually specific to
huggingface.co.`,To,Q,Ro,M,Te,Io,$t,ca="Instantiate a local clone of a git repo.",Do,xt,ga=`If <code>clone_from</code> is set, the repo will be cloned from an existing remote repository.
If the remote repo does not exist, a <code>EnvironmentError</code> exception will be thrown.
Please create the remote repo first using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`,Mo,wt,pa=`<code>Repository</code> uses the local git credentials by default. If explicitly set, the <code>token</code>
or the <code>git_user</code>/<code>git_email</code> pair will be used instead.`,Lo,Z,Re,Po,Ct,da="Returns the current checked out branch.",Eo,L,Ie,jo,kt,ha="Add a tag at the current head and push it",Uo,Tt,ua="If remote is None, will just be updated locally",Ho,Rt,ma=`If no message is provided, the tag will be lightweight. if a message is
provided, the tag will be annotated.`,Jo,X,De,Vo,It,fa="Automatically track binary files with git-lfs.",Fo,K,Me,No,Dt,_a=`Automatically track large files (files that weigh more than 10MBs) with
git-lfs.`,qo,Y,Le,Wo,Mt,ba="Checks that <code>git</code> and <code>git-lfs</code> can be run.",Bo,P,Pe,So,Lt,va=`Clone from a remote. If the folder already exists, will try to clone the
repository within it.`,Ao,Pt,ya=`If this folder is a git repository with linked history, will try to
update the repository.`,Oo,ee,Go,J,Ee,zo,Et,$a=`Context manager utility to handle committing to a repository. This
automatically tracks large files (&gt;10Mb) with git-lfs. Set the
<code>track_large_files</code> argument to <code>False</code> if you wish to ignore that
behavior.`,Qo,te,Zo,ne,je,Xo,jt,xa="Delete a tag, both local and remote, if it exists",Ko,V,Ue,Yo,Ut,wa="git add",er,Ht,Ca=`Setting the <code>auto_lfs_track</code> parameter to <code>True</code> will automatically
track files that are larger than 10MB with <code>git-lfs</code>.`,tr,F,He,nr,Jt,ka="git checkout a given revision",or,Vt,Ta=`Specifying <code>create_branch_ok</code> to <code>True</code> will create the branch to the
given revision if that revision doesn’t exist.`,rr,oe,Je,ar,Ft,Ra="git commit",ir,re,Ve,sr,Nt,Ia="Sets git username and email (only in the current repo).",lr,ae,Fe,cr,qt,Da="Sets the git credential helper to <code>store</code>",gr,ie,Ne,pr,Wt,Ma=`Get URL to last commit on HEAD. We assume it’s been pushed, and the url
scheme is the same one as for GitHub or HuggingFace.`,dr,se,qe,hr,Bt,La="Get commit sha on top of HEAD.",ur,le,We,mr,St,Pa="git pull",fr,N,Be,_r,At,Ea="git push",br,Ot,ja=`If used without setting <code>blocking</code>, will return url to commit on remote
repo. If used with <code>blocking=True</code>, will return a tuple containing the
url to commit and the command object to follow for information about the
process.`,vr,ce,Se,yr,Gt,Ua="Get URL to origin remote.",$r,ge,Ae,xr,zt,Ha="Return whether or not the git status is clean or not",wr,pe,Oe,Cr,Qt,Ja="HF-specific. This enables upload support of files >5GB.",kr,de,Ge,Tr,Zt,Va="git lfs prune",Rr,q,ze,Ir,Xt,Fa="Tell git-lfs to track files according to a pattern.",Dr,Kt,Na=`Setting the <code>filename</code> argument to <code>True</code> will treat the arguments as
literal filenames, not as patterns. Any special glob characters in the
filename will be escaped when writing to the <code>.gitattributes</code> file.`,Mr,he,Qe,Lr,Yt,qa="Tell git-lfs to untrack those files.",Pr,ue,Ze,Er,en,Wa=`Returns a list of the files that are deleted in the working directory or
index.`,jr,me,Xe,Ur,tn,Ba=`Helper to add, commit, and push files to remote repository on the
HuggingFace Hub. Will automatically track large files (>10MB).`,Hr,fe,Ke,Jr,nn,Sa="Check if a tag exists or not.",Vr,_e,Ye,Fr,on,Aa=`Blocking method: blocks all subsequent execution until all commands have
been processed.`,Dn,et,Mn,W,tt,Nr,rn,Oa="Check if the folder is the root or part of a git repository",Ln,B,nt,qr,an,Ga="Check if the folder is a local clone of the remote_url",Pn,S,ot,Wr,sn,za="Check if the file passed is tracked with git-lfs.",En,A,rt,Br,ln,Qa="Check if file is git-ignored. Supports nested .gitignore files.",jn,O,at,Sr,cn,Za="Returns a list of filenames that are to be staged.",Un,G,it,Ar,gn,Xa="Check if the current checked-out branch is tracked upstream.",Hn,E,st,Or,pn,Ka="Check the number of commits that would be pushed upstream",Gr,dn,Ya=`The name of the upstream repository with which the comparison should be
made.`,Jn,lt,Vn,ct,ei="The <code>Repository</code> utility offers several methods which can be launched asynchronously:",Fn,gt,ti="<li><code>git_push</code></li> <li><code>git_pull</code></li> <li><code>push_to_hub</code></li> <li>The <code>commit</code> context manager</li>",Nn,pt,ni="See below for utilities to manage such asynchronous methods.",qn,k,dt,zr,hn,oi="Helper class to wrap the git and git-lfs commands.",Qr,un,ri=`The aim is to facilitate interacting with huggingface.co hosted model or
dataset repos, though not a lot here (if any) is actually specific to
huggingface.co.`,Zr,be,Xr,ve,ht,Kr,mn,ai="Returns the asynchronous commands that failed.",Yr,ye,ut,ea,fn,ii="Returns the asynchronous commands that are currently in progress.",ta,$e,mt,na,_n,si=`Blocking method: blocks all subsequent execution until all commands have
been processed.`,Wn,z,ft,oa,bn,li="Utility to follow commands launched asynchronously.",Bn,_t,Sn,kn,An;return R=new xo({props:{title:"Managing local and online repositories",local:"managing-local-and-online-repositories",headingTag:"h1"}}),Ce=new xo({props:{title:"The Repository class",local:"huggingface_hub.Repository",headingTag:"h2"}}),ke=new $({props:{name:"class huggingface_hub.Repository",anchor:"huggingface_hub.Repository",parameters:[{name:"local_dir",val:": Union"},{name:"clone_from",val:": Optional = None"},{name:"repo_type",val:": Optional = None"},{name:"token",val:": Union = True"},{name:"git_user",val:": Optional = None"},{name:"git_email",val:": Optional = None"},{name:"revision",val:": Optional = None"},{name:"skip_lfs_files",val:": bool = False"},{name:"client",val:": Optional = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L426"}}),Q=new ra({props:{warning:!0,$$slots:{default:[_i]},$$scope:{ctx:H}}}),Te=new $({props:{name:"__init__",anchor:"huggingface_hub.Repository.__init__",parameters:[{name:"local_dir",val:": Union"},{name:"clone_from",val:": Optional = None"},{name:"repo_type",val:": Optional = None"},{name:"token",val:": Union = True"},{name:"git_user",val:": Optional = None"},{name:"git_email",val:": Optional = None"},{name:"revision",val:": Optional = None"},{name:"skip_lfs_files",val:": bool = False"},{name:"client",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.__init__.local_dir",description:`<strong>local_dir</strong> (<code>str</code> or <code>Path</code>) &#x2014;
path (e.g. <code>&apos;my_trained_model/&apos;</code>) to the local directory, where
the <code>Repository</code> will be initialized.`,name:"local_dir"},{anchor:"huggingface_hub.Repository.__init__.clone_from",description:`<strong>clone_from</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Either a repository url or <code>repo_id</code>.
Example:<ul>
<li><code>&quot;https://huggingface.co/philschmid/playground-tests&quot;</code></li>
<li><code>&quot;philschmid/playground-tests&quot;</code></li>
</ul>`,name:"clone_from"},{anchor:"huggingface_hub.Repository.__init__.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
To set when cloning a repo from a repo_id. Default is model.`,name:"repo_type"},{anchor:"huggingface_hub.Repository.__init__.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
A valid authentication token (see <a href="https://huggingface.co/settings/token" rel="nofollow">https://huggingface.co/settings/token</a>).
If <code>None</code> or <code>True</code> and machine is logged in (through <code>huggingface-cli login</code>
or <a href="/docs/huggingface_hub/main/en/package_reference/login#huggingface_hub.login">login()</a>), token will be retrieved from the cache.
If <code>False</code>, token is not sent in the request header.`,name:"token"},{anchor:"huggingface_hub.Repository.__init__.git_user",description:`<strong>git_user</strong> (<code>str</code>, <em>optional</em>) &#x2014;
will override the <code>git config user.name</code> for committing and
pushing files to the hub.`,name:"git_user"},{anchor:"huggingface_hub.Repository.__init__.git_email",description:`<strong>git_email</strong> (<code>str</code>, <em>optional</em>) &#x2014;
will override the <code>git config user.email</code> for committing and
pushing files to the hub.`,name:"git_email"},{anchor:"huggingface_hub.Repository.__init__.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision to checkout after initializing the repository. If the
revision doesn&#x2019;t exist, a branch will be created with that
revision name from the default branch&#x2019;s current HEAD.`,name:"revision"},{anchor:"huggingface_hub.Repository.__init__.skip_lfs_files",description:`<strong>skip_lfs_files</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
whether to skip git-LFS files or not.`,name:"skip_lfs_files"},{anchor:"huggingface_hub.Repository.__init__.client",description:`<strong>client</strong> (<code>HfApi</code>, <em>optional</em>) &#x2014;
Instance of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> to use when calling the HF Hub API. A new
instance will be created if this is left to <code>None</code>.`,name:"client"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L446",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><ul>
<li>— <a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a>
if the remote repository set in <code>clone_from</code> does not exist.</li>
</ul></li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li></li>
</ul>
`}}),Re=new $({props:{name:"current_branch",anchor:"huggingface_hub.Repository.current_branch",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L563",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Current checked out branch.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Ie=new $({props:{name:"add_tag",anchor:"huggingface_hub.Repository.add_tag",parameters:[{name:"tag_name",val:": str"},{name:"message",val:": Optional = None"},{name:"remote",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.add_tag.tag_name",description:`<strong>tag_name</strong> (<code>str</code>) &#x2014;
The name of the tag to be added.`,name:"tag_name"},{anchor:"huggingface_hub.Repository.add_tag.message",description:`<strong>message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The message that accompanies the tag. The tag will turn into an
annotated tag if a message is passed.`,name:"message"},{anchor:"huggingface_hub.Repository.add_tag.remote",description:`<strong>remote</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The remote on which to add the tag.`,name:"remote"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L1247"}}),De=new $({props:{name:"auto_track_binary_files",anchor:"huggingface_hub.Repository.auto_track_binary_files",parameters:[{name:"pattern",val:": str = '.'"}],parametersDescription:[{anchor:"huggingface_hub.Repository.auto_track_binary_files.pattern",description:`<strong>pattern</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201D;.&#x201C;) &#x2014;
The pattern with which to track files that are binary.`,name:"pattern"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L889",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of filenames that are now tracked due to being
binary files</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Me=new $({props:{name:"auto_track_large_files",anchor:"huggingface_hub.Repository.auto_track_large_files",parameters:[{name:"pattern",val:": str = '.'"}],parametersDescription:[{anchor:"huggingface_hub.Repository.auto_track_large_files.pattern",description:`<strong>pattern</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201D;.&#x201C;) &#x2014;
The pattern with which to track files that are above 10MBs.`,name:"pattern"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L932",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of filenames that are now tracked due to their
size.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Le=new $({props:{name:"check_git_versions",anchor:"huggingface_hub.Repository.check_git_versions",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L578",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><ul>
<li>— <a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a>
if <code>git</code> or <code>git-lfs</code> are not installed.</li>
</ul></li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li></li>
</ul>
`}}),Pe=new $({props:{name:"clone_from",anchor:"huggingface_hub.Repository.clone_from",parameters:[{name:"repo_url",val:": str"},{name:"token",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.clone_from.repo_url",description:`<strong>repo_url</strong> (<code>str</code>) &#x2014;
The URL from which to clone the repository`,name:"repo_url"},{anchor:"huggingface_hub.Repository.clone_from.token",description:`<strong>token</strong> (<code>Union[str, bool]</code>, <em>optional</em>) &#x2014;
Whether to use the authentication token. It can be:<ul>
<li>a string which is the token itself</li>
<li><code>False</code>, which would not use the authentication token</li>
<li><code>True</code>, which would fetch the authentication token from the
local folder and use it (you should be logged in for this to
work).</li>
<li><code>None</code>, which would retrieve the value of
<code>self.huggingface_token</code>.</li>
</ul>`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L601"}}),ee=new ra({props:{$$slots:{default:[bi]},$$scope:{ctx:H}}}),Ee=new $({props:{name:"commit",anchor:"huggingface_hub.Repository.commit",parameters:[{name:"commit_message",val:": str"},{name:"branch",val:": Optional = None"},{name:"track_large_files",val:": bool = True"},{name:"blocking",val:": bool = True"},{name:"auto_lfs_prune",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.commit.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
Message to use for the commit.`,name:"commit_message"},{anchor:"huggingface_hub.Repository.commit.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The branch on which the commit will appear. This branch will be
checked-out before any operation.`,name:"branch"},{anchor:"huggingface_hub.Repository.commit.track_large_files",description:`<strong>track_large_files</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to automatically track large files or not. Will do so by
default.`,name:"track_large_files"},{anchor:"huggingface_hub.Repository.commit.blocking",description:`<strong>blocking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the function should return only when the <code>git push</code> has
finished.`,name:"blocking"},{anchor:"huggingface_hub.Repository.commit.auto_lfs_prune",description:`<strong>auto_lfs_prune</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to automatically prune files once they have been pushed
to the remote.`,name:"auto_lfs_prune"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L1331"}}),te=new mi({props:{anchor:"huggingface_hub.Repository.commit.example",$$slots:{default:[vi]},$$scope:{ctx:H}}}),je=new $({props:{name:"delete_tag",anchor:"huggingface_hub.Repository.delete_tag",parameters:[{name:"tag_name",val:": str"},{name:"remote",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.delete_tag.tag_name",description:`<strong>tag_name</strong> (<code>str</code>) &#x2014;
The tag name to delete.`,name:"tag_name"},{anchor:"huggingface_hub.Repository.delete_tag.remote",description:`<strong>remote</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The remote on which to delete the tag.`,name:"remote"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L1210",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if deleted, <code>False</code> if the tag didn’t exist.
If remote is not passed, will just be updated locally</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Ue=new $({props:{name:"git_add",anchor:"huggingface_hub.Repository.git_add",parameters:[{name:"pattern",val:": str = '.'"},{name:"auto_lfs_track",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_add.pattern",description:`<strong>pattern</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201D;.&#x201C;) &#x2014;
The pattern with which to add files to staging.`,name:"pattern"},{anchor:"huggingface_hub.Repository.git_add.auto_lfs_track",description:`<strong>auto_lfs_track</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to automatically track large and binary files with
git-lfs. Any file over 10MB in size, or in binary format, will
be automatically tracked.`,name:"auto_lfs_track"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L1007"}}),He=new $({props:{name:"git_checkout",anchor:"huggingface_hub.Repository.git_checkout",parameters:[{name:"revision",val:": str"},{name:"create_branch_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_checkout.revision",description:`<strong>revision</strong> (<code>str</code>) &#x2014;
The revision to checkout.`,name:"revision"},{anchor:"huggingface_hub.Repository.git_checkout.create_branch_ok",description:`<strong>create_branch_ok</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether creating a branch named with the <code>revision</code> passed at
the current checked-out reference if <code>revision</code> isn&#x2019;t an
existing revision is allowed.`,name:"create_branch_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L1148"}}),Je=new $({props:{name:"git_commit",anchor:"huggingface_hub.Repository.git_commit",parameters:[{name:"commit_message",val:": str = 'commit files to HF hub'"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_commit.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;commit files to HF hub&#x201D;) &#x2014;
The message attributed to the commit.`,name:"commit_message"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L1041"}}),Ve=new $({props:{name:"git_config_username_and_email",anchor:"huggingface_hub.Repository.git_config_username_and_email",parameters:[{name:"git_user",val:": Optional = None"},{name:"git_email",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_config_username_and_email.git_user",description:`<strong>git_user</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The username to register through <code>git</code>.`,name:"git_user"},{anchor:"huggingface_hub.Repository.git_config_username_and_email.git_email",description:`<strong>git_email</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The email to register through <code>git</code>.`,name:"git_email"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L729"}}),Fe=new $({props:{name:"git_credential_helper_store",anchor:"huggingface_hub.Repository.git_credential_helper_store",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L748"}}),Ne=new $({props:{name:"git_head_commit_url",anchor:"huggingface_hub.Repository.git_head_commit_url",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L785",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The URL to the current checked-out commit.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),qe=new $({props:{name:"git_head_hash",anchor:"huggingface_hub.Repository.git_head_hash",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L757",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The current checked out commit SHA.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),We=new $({props:{name:"git_pull",anchor:"huggingface_hub.Repository.git_pull",parameters:[{name:"rebase",val:": bool = False"},{name:"lfs",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_pull.rebase",description:`<strong>rebase</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to rebase the current branch on top of the upstream
branch after fetching.`,name:"rebase"},{anchor:"huggingface_hub.Repository.git_pull.lfs",description:`<strong>lfs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fetch the LFS files too. This option only changes the
behavior when a repository was cloned without fetching the LFS
files; calling <code>repo.git_pull(lfs=True)</code> will then fetch the LFS
file from the remote repository.`,name:"lfs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L983"}}),Be=new $({props:{name:"git_push",anchor:"huggingface_hub.Repository.git_push",parameters:[{name:"upstream",val:": Optional = None"},{name:"blocking",val:": bool = True"},{name:"auto_lfs_prune",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_push.upstream",description:`<strong>upstream</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Upstream to which this should push. If not specified, will push
to the lastly defined upstream or to the default one (<code>origin main</code>).`,name:"upstream"},{anchor:"huggingface_hub.Repository.git_push.blocking",description:`<strong>blocking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the function should return only when the push has
finished. Setting this to <code>False</code> will return an
<code>CommandInProgress</code> object which has an <code>is_done</code> property. This
property will be set to <code>True</code> when the push is finished.`,name:"blocking"},{anchor:"huggingface_hub.Repository.git_push.auto_lfs_prune",description:`<strong>auto_lfs_prune</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to automatically prune files once they have been pushed
to the remote.`,name:"auto_lfs_prune"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L1058"}}),Se=new $({props:{name:"git_remote_url",anchor:"huggingface_hub.Repository.git_remote_url",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L770",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The URL of the <code>origin</code> remote.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Ae=new $({props:{name:"is_repo_clean",anchor:"huggingface_hub.Repository.is_repo_clean",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L1281",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the git status is clean, <code>False</code> otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Oe=new $({props:{name:"lfs_enable_largefiles",anchor:"huggingface_hub.Repository.lfs_enable_largefiles",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L875"}}),Ge=new $({props:{name:"lfs_prune",anchor:"huggingface_hub.Repository.lfs_prune",parameters:[{name:"recent",val:" = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.lfs_prune.recent",description:`<strong>recent</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to prune files even if they were referenced by recent
commits. See the following
<a href="https://github.com/git-lfs/git-lfs/blob/f3d43f0428a84fc4f1e5405b76b5a73ec2437e65/docs/man/git-lfs-prune.1.ronn#recent-files" rel="nofollow">link</a>
for more information.`,name:"recent"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L965"}}),ze=new $({props:{name:"lfs_track",anchor:"huggingface_hub.Repository.lfs_track",parameters:[{name:"patterns",val:": Union"},{name:"filename",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.lfs_track.patterns",description:`<strong>patterns</strong> (<code>Union[str, List[str]]</code>) &#x2014;
The pattern, or list of patterns, to track with git-lfs.`,name:"patterns"},{anchor:"huggingface_hub.Repository.lfs_track.filename",description:`<strong>filename</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use the patterns as literal filenames.`,name:"filename"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L834"}}),Qe=new $({props:{name:"lfs_untrack",anchor:"huggingface_hub.Repository.lfs_untrack",parameters:[{name:"patterns",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.Repository.lfs_untrack.patterns",description:`<strong>patterns</strong> (<code>Union[str, List[str]]</code>) &#x2014;
The pattern, or list of patterns, to untrack with git-lfs.`,name:"patterns"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L859"}}),Ze=new $({props:{name:"list_deleted_files",anchor:"huggingface_hub.Repository.list_deleted_files",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L799",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of files that have been deleted in the working
directory or index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Xe=new $({props:{name:"push_to_hub",anchor:"huggingface_hub.Repository.push_to_hub",parameters:[{name:"commit_message",val:": str = 'commit files to HF hub'"},{name:"blocking",val:": bool = True"},{name:"clean_ok",val:": bool = True"},{name:"auto_lfs_prune",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
Message to use for the commit.`,name:"commit_message"},{anchor:"huggingface_hub.Repository.push_to_hub.blocking",description:`<strong>blocking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the function should return only when the <code>git push</code> has
finished.`,name:"blocking"},{anchor:"huggingface_hub.Repository.push_to_hub.clean_ok",description:`<strong>clean_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, this function will return None if the repo is
untouched. Default behavior is to fail because the git command
fails.`,name:"clean_ok"},{anchor:"huggingface_hub.Repository.push_to_hub.auto_lfs_prune",description:`<strong>auto_lfs_prune</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to automatically prune files once they have been pushed
to the remote.`,name:"auto_lfs_prune"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L1295"}}),Ke=new $({props:{name:"tag_exists",anchor:"huggingface_hub.Repository.tag_exists",parameters:[{name:"tag_name",val:": str"},{name:"remote",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.tag_exists.tag_name",description:`<strong>tag_name</strong> (<code>str</code>) &#x2014;
The name of the tag to check.`,name:"tag_name"},{anchor:"huggingface_hub.Repository.tag_exists.remote",description:`<strong>remote</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Whether to check if the tag exists on a remote. This parameter
should be the identifier of the remote.`,name:"remote"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L1180",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether the tag exists.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Ye=new $({props:{name:"wait_for_commands",anchor:"huggingface_hub.Repository.wait_for_commands",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L1459"}}),et=new xo({props:{title:"Helper methods",local:"huggingface_hub.repository.is_git_repo",headingTag:"h2"}}),tt=new $({props:{name:"huggingface_hub.repository.is_git_repo",anchor:"huggingface_hub.repository.is_git_repo",parameters:[{name:"folder",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_git_repo.folder",description:`<strong>folder</strong> (<code>str</code>) &#x2014;
The folder in which to run the command.`,name:"folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L114",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the repository is part of a repository, <code>False</code>
otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),nt=new $({props:{name:"huggingface_hub.repository.is_local_clone",anchor:"huggingface_hub.repository.is_local_clone",parameters:[{name:"folder",val:": Union"},{name:"remote_url",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_local_clone.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"},{anchor:"huggingface_hub.repository.is_local_clone.remote_url",description:`<strong>remote_url</strong> (<code>str</code>) &#x2014;
The url of a git repository.`,name:"remote_url"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L131",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the repository is a local clone of the remote
repository specified, <code>False</code> otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),ot=new $({props:{name:"huggingface_hub.repository.is_tracked_with_lfs",anchor:"huggingface_hub.repository.is_tracked_with_lfs",parameters:[{name:"filename",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_tracked_with_lfs.filename",description:`<strong>filename</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The filename to check.`,name:"filename"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L156",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the file passed is tracked with git-lfs, <code>False</code>
otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),rt=new $({props:{name:"huggingface_hub.repository.is_git_ignored",anchor:"huggingface_hub.repository.is_git_ignored",parameters:[{name:"filename",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_git_ignored.filename",description:`<strong>filename</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The filename to check.`,name:"filename"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L193",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the file passed is ignored by <code>git</code>, <code>False</code>
otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),at=new $({props:{name:"huggingface_hub.repository.files_to_be_staged",anchor:"huggingface_hub.repository.files_to_be_staged",parameters:[{name:"pattern",val:": str = '.'"},{name:"folder",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.repository.files_to_be_staged.pattern",description:`<strong>pattern</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The pattern of filenames to check. Put <code>.</code> to get all files.`,name:"pattern"},{anchor:"huggingface_hub.repository.files_to_be_staged.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L241",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of files that are to be staged.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),it=new $({props:{name:"huggingface_hub.repository.is_tracked_upstream",anchor:"huggingface_hub.repository.is_tracked_upstream",parameters:[{name:"folder",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_tracked_upstream.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L266",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the current checked-out branch is tracked upstream,
<code>False</code> otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),st=new $({props:{name:"huggingface_hub.repository.commits_to_push",anchor:"huggingface_hub.repository.commits_to_push",parameters:[{name:"folder",val:": Union"},{name:"upstream",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.repository.commits_to_push.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"},{anchor:"huggingface_hub.repository.commits_to_push.upstream",description:"<strong>upstream</strong> (<code>str</code>, <em>optional</em>) &#x2014;",name:"upstream"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L288",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Number of commits that would be pushed upstream were a <code>git push</code> to proceed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>int</code></p>
`}}),lt=new xo({props:{title:"Following asynchronous commands",local:"huggingface_hub.Repository",headingTag:"h2"}}),dt=new $({props:{name:"class huggingface_hub.Repository",anchor:"huggingface_hub.Repository",parameters:[{name:"local_dir",val:": Union"},{name:"clone_from",val:": Optional = None"},{name:"repo_type",val:": Optional = None"},{name:"token",val:": Union = True"},{name:"git_user",val:": Optional = None"},{name:"git_email",val:": Optional = None"},{name:"revision",val:": Optional = None"},{name:"skip_lfs_files",val:": bool = False"},{name:"client",val:": Optional = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L426"}}),be=new ra({props:{warning:!0,$$slots:{default:[yi]},$$scope:{ctx:H}}}),ht=new $({props:{name:"commands_failed",anchor:"huggingface_hub.Repository.commands_failed",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L1445"}}),ut=new $({props:{name:"commands_in_progress",anchor:"huggingface_hub.Repository.commands_in_progress",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L1452"}}),mt=new $({props:{name:"wait_for_commands",anchor:"huggingface_hub.Repository.wait_for_commands",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L1459"}}),ft=new $({props:{name:"class huggingface_hub.repository.CommandInProgress",anchor:"huggingface_hub.repository.CommandInProgress",parameters:[{name:"title",val:": str"},{name:"is_done_method",val:": Callable"},{name:"status_method",val:": Callable"},{name:"process",val:": Popen"},{name:"post_method",val:": Optional = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/repository.py#L31"}}),_t=new fi({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/repository.md"}}),{c(){y=r("meta"),T=n(),w=r("p"),C=n(),p(R.$$.fragment),x=n(),I=r("p"),I.innerHTML=aa,Tn=n(),we=r("p"),we.innerHTML=ia,Rn=n(),p(Ce.$$.fragment),In=n(),s=r("div"),p(ke.$$.fragment),Co=n(),vt=r("p"),vt.textContent=sa,ko=n(),yt=r("p"),yt.textContent=la,To=n(),p(Q.$$.fragment),Ro=n(),M=r("div"),p(Te.$$.fragment),Io=n(),$t=r("p"),$t.textContent=ca,Do=n(),xt=r("p"),xt.innerHTML=ga,Mo=n(),wt=r("p"),wt.innerHTML=pa,Lo=n(),Z=r("div"),p(Re.$$.fragment),Po=n(),Ct=r("p"),Ct.textContent=da,Eo=n(),L=r("div"),p(Ie.$$.fragment),jo=n(),kt=r("p"),kt.textContent=ha,Uo=n(),Tt=r("p"),Tt.textContent=ua,Ho=n(),Rt=r("p"),Rt.textContent=ma,Jo=n(),X=r("div"),p(De.$$.fragment),Vo=n(),It=r("p"),It.textContent=fa,Fo=n(),K=r("div"),p(Me.$$.fragment),No=n(),Dt=r("p"),Dt.textContent=_a,qo=n(),Y=r("div"),p(Le.$$.fragment),Wo=n(),Mt=r("p"),Mt.innerHTML=ba,Bo=n(),P=r("div"),p(Pe.$$.fragment),So=n(),Lt=r("p"),Lt.textContent=va,Ao=n(),Pt=r("p"),Pt.textContent=ya,Oo=n(),p(ee.$$.fragment),Go=n(),J=r("div"),p(Ee.$$.fragment),zo=n(),Et=r("p"),Et.innerHTML=$a,Qo=n(),p(te.$$.fragment),Zo=n(),ne=r("div"),p(je.$$.fragment),Xo=n(),jt=r("p"),jt.textContent=xa,Ko=n(),V=r("div"),p(Ue.$$.fragment),Yo=n(),Ut=r("p"),Ut.textContent=wa,er=n(),Ht=r("p"),Ht.innerHTML=Ca,tr=n(),F=r("div"),p(He.$$.fragment),nr=n(),Jt=r("p"),Jt.textContent=ka,or=n(),Vt=r("p"),Vt.innerHTML=Ta,rr=n(),oe=r("div"),p(Je.$$.fragment),ar=n(),Ft=r("p"),Ft.textContent=Ra,ir=n(),re=r("div"),p(Ve.$$.fragment),sr=n(),Nt=r("p"),Nt.textContent=Ia,lr=n(),ae=r("div"),p(Fe.$$.fragment),cr=n(),qt=r("p"),qt.innerHTML=Da,gr=n(),ie=r("div"),p(Ne.$$.fragment),pr=n(),Wt=r("p"),Wt.textContent=Ma,dr=n(),se=r("div"),p(qe.$$.fragment),hr=n(),Bt=r("p"),Bt.textContent=La,ur=n(),le=r("div"),p(We.$$.fragment),mr=n(),St=r("p"),St.textContent=Pa,fr=n(),N=r("div"),p(Be.$$.fragment),_r=n(),At=r("p"),At.textContent=Ea,br=n(),Ot=r("p"),Ot.innerHTML=ja,vr=n(),ce=r("div"),p(Se.$$.fragment),yr=n(),Gt=r("p"),Gt.textContent=Ua,$r=n(),ge=r("div"),p(Ae.$$.fragment),xr=n(),zt=r("p"),zt.textContent=Ha,wr=n(),pe=r("div"),p(Oe.$$.fragment),Cr=n(),Qt=r("p"),Qt.textContent=Ja,kr=n(),de=r("div"),p(Ge.$$.fragment),Tr=n(),Zt=r("p"),Zt.textContent=Va,Rr=n(),q=r("div"),p(ze.$$.fragment),Ir=n(),Xt=r("p"),Xt.textContent=Fa,Dr=n(),Kt=r("p"),Kt.innerHTML=Na,Mr=n(),he=r("div"),p(Qe.$$.fragment),Lr=n(),Yt=r("p"),Yt.textContent=qa,Pr=n(),ue=r("div"),p(Ze.$$.fragment),Er=n(),en=r("p"),en.textContent=Wa,jr=n(),me=r("div"),p(Xe.$$.fragment),Ur=n(),tn=r("p"),tn.textContent=Ba,Hr=n(),fe=r("div"),p(Ke.$$.fragment),Jr=n(),nn=r("p"),nn.textContent=Sa,Vr=n(),_e=r("div"),p(Ye.$$.fragment),Fr=n(),on=r("p"),on.textContent=Aa,Dn=n(),p(et.$$.fragment),Mn=n(),W=r("div"),p(tt.$$.fragment),Nr=n(),rn=r("p"),rn.textContent=Oa,Ln=n(),B=r("div"),p(nt.$$.fragment),qr=n(),an=r("p"),an.textContent=Ga,Pn=n(),S=r("div"),p(ot.$$.fragment),Wr=n(),sn=r("p"),sn.textContent=za,En=n(),A=r("div"),p(rt.$$.fragment),Br=n(),ln=r("p"),ln.textContent=Qa,jn=n(),O=r("div"),p(at.$$.fragment),Sr=n(),cn=r("p"),cn.textContent=Za,Un=n(),G=r("div"),p(it.$$.fragment),Ar=n(),gn=r("p"),gn.textContent=Xa,Hn=n(),E=r("div"),p(st.$$.fragment),Or=n(),pn=r("p"),pn.textContent=Ka,Gr=n(),dn=r("p"),dn.textContent=Ya,Jn=n(),p(lt.$$.fragment),Vn=n(),ct=r("p"),ct.innerHTML=ei,Fn=n(),gt=r("ul"),gt.innerHTML=ti,Nn=n(),pt=r("p"),pt.textContent=ni,qn=n(),k=r("div"),p(dt.$$.fragment),zr=n(),hn=r("p"),hn.textContent=oi,Qr=n(),un=r("p"),un.textContent=ri,Zr=n(),p(be.$$.fragment),Xr=n(),ve=r("div"),p(ht.$$.fragment),Kr=n(),mn=r("p"),mn.textContent=ai,Yr=n(),ye=r("div"),p(ut.$$.fragment),ea=n(),fn=r("p"),fn.textContent=ii,ta=n(),$e=r("div"),p(mt.$$.fragment),na=n(),_n=r("p"),_n.textContent=si,Wn=n(),z=r("div"),p(ft.$$.fragment),oa=n(),bn=r("p"),bn.textContent=li,Bn=n(),p(_t.$$.fragment),Sn=n(),kn=r("p"),this.h()},l(e){const g=hi("svelte-u9bgzb",document.head);y=a(g,"META",{name:!0,content:!0}),g.forEach(i),T=o(e),w=a(e,"P",{}),b(w).forEach(i),C=o(e),d(R.$$.fragment,e),x=o(e),I=a(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-fqtivw"&&(I.innerHTML=aa),Tn=o(e),we=a(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-1mkssuw"&&(we.innerHTML=ia),Rn=o(e),d(Ce.$$.fragment,e),In=o(e),s=a(e,"DIV",{class:!0});var l=b(s);d(ke.$$.fragment,l),Co=o(l),vt=a(l,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-sfljep"&&(vt.textContent=sa),ko=o(l),yt=a(l,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-130r937"&&(yt.textContent=la),To=o(l),d(Q.$$.fragment,l),Ro=o(l),M=a(l,"DIV",{class:!0});var j=b(M);d(Te.$$.fragment,j),Io=o(j),$t=a(j,"P",{"data-svelte-h":!0}),c($t)!=="svelte-u91m2x"&&($t.textContent=ca),Do=o(j),xt=a(j,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-1wmxghx"&&(xt.innerHTML=ga),Mo=o(j),wt=a(j,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-1rccgws"&&(wt.innerHTML=pa),j.forEach(i),Lo=o(l),Z=a(l,"DIV",{class:!0});var bt=b(Z);d(Re.$$.fragment,bt),Po=o(bt),Ct=a(bt,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-1931o36"&&(Ct.textContent=da),bt.forEach(i),Eo=o(l),L=a(l,"DIV",{class:!0});var U=b(L);d(Ie.$$.fragment,U),jo=o(U),kt=a(U,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-63n9b3"&&(kt.textContent=ha),Uo=o(U),Tt=a(U,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-1mgqvlx"&&(Tt.textContent=ua),Ho=o(U),Rt=a(U,"P",{"data-svelte-h":!0}),c(Rt)!=="svelte-10sq8kk"&&(Rt.textContent=ma),U.forEach(i),Jo=o(l),X=a(l,"DIV",{class:!0});var On=b(X);d(De.$$.fragment,On),Vo=o(On),It=a(On,"P",{"data-svelte-h":!0}),c(It)!=="svelte-1xz8ip4"&&(It.textContent=fa),On.forEach(i),Fo=o(l),K=a(l,"DIV",{class:!0});var Gn=b(K);d(Me.$$.fragment,Gn),No=o(Gn),Dt=a(Gn,"P",{"data-svelte-h":!0}),c(Dt)!=="svelte-gpfomi"&&(Dt.textContent=_a),Gn.forEach(i),qo=o(l),Y=a(l,"DIV",{class:!0});var zn=b(Y);d(Le.$$.fragment,zn),Wo=o(zn),Mt=a(zn,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-i6ef2h"&&(Mt.innerHTML=ba),zn.forEach(i),Bo=o(l),P=a(l,"DIV",{class:!0});var xe=b(P);d(Pe.$$.fragment,xe),So=o(xe),Lt=a(xe,"P",{"data-svelte-h":!0}),c(Lt)!=="svelte-yrpdu4"&&(Lt.textContent=va),Ao=o(xe),Pt=a(xe,"P",{"data-svelte-h":!0}),c(Pt)!=="svelte-kcbb31"&&(Pt.textContent=ya),Oo=o(xe),d(ee.$$.fragment,xe),xe.forEach(i),Go=o(l),J=a(l,"DIV",{class:!0});var vn=b(J);d(Ee.$$.fragment,vn),zo=o(vn),Et=a(vn,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-srmdei"&&(Et.innerHTML=$a),Qo=o(vn),d(te.$$.fragment,vn),vn.forEach(i),Zo=o(l),ne=a(l,"DIV",{class:!0});var Qn=b(ne);d(je.$$.fragment,Qn),Xo=o(Qn),jt=a(Qn,"P",{"data-svelte-h":!0}),c(jt)!=="svelte-x8sm21"&&(jt.textContent=xa),Qn.forEach(i),Ko=o(l),V=a(l,"DIV",{class:!0});var yn=b(V);d(Ue.$$.fragment,yn),Yo=o(yn),Ut=a(yn,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-1eaw53"&&(Ut.textContent=wa),er=o(yn),Ht=a(yn,"P",{"data-svelte-h":!0}),c(Ht)!=="svelte-1gwi68h"&&(Ht.innerHTML=Ca),yn.forEach(i),tr=o(l),F=a(l,"DIV",{class:!0});var $n=b(F);d(He.$$.fragment,$n),nr=o($n),Jt=a($n,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-fr7o3n"&&(Jt.textContent=ka),or=o($n),Vt=a($n,"P",{"data-svelte-h":!0}),c(Vt)!=="svelte-1f8uww9"&&(Vt.innerHTML=Ta),$n.forEach(i),rr=o(l),oe=a(l,"DIV",{class:!0});var Zn=b(oe);d(Je.$$.fragment,Zn),ar=o(Zn),Ft=a(Zn,"P",{"data-svelte-h":!0}),c(Ft)!=="svelte-10kdqwr"&&(Ft.textContent=Ra),Zn.forEach(i),ir=o(l),re=a(l,"DIV",{class:!0});var Xn=b(re);d(Ve.$$.fragment,Xn),sr=o(Xn),Nt=a(Xn,"P",{"data-svelte-h":!0}),c(Nt)!=="svelte-1jc3bks"&&(Nt.textContent=Ia),Xn.forEach(i),lr=o(l),ae=a(l,"DIV",{class:!0});var Kn=b(ae);d(Fe.$$.fragment,Kn),cr=o(Kn),qt=a(Kn,"P",{"data-svelte-h":!0}),c(qt)!=="svelte-1pc1msi"&&(qt.innerHTML=Da),Kn.forEach(i),gr=o(l),ie=a(l,"DIV",{class:!0});var Yn=b(ie);d(Ne.$$.fragment,Yn),pr=o(Yn),Wt=a(Yn,"P",{"data-svelte-h":!0}),c(Wt)!=="svelte-1v7pd4y"&&(Wt.textContent=Ma),Yn.forEach(i),dr=o(l),se=a(l,"DIV",{class:!0});var eo=b(se);d(qe.$$.fragment,eo),hr=o(eo),Bt=a(eo,"P",{"data-svelte-h":!0}),c(Bt)!=="svelte-vce47s"&&(Bt.textContent=La),eo.forEach(i),ur=o(l),le=a(l,"DIV",{class:!0});var to=b(le);d(We.$$.fragment,to),mr=o(to),St=a(to,"P",{"data-svelte-h":!0}),c(St)!=="svelte-14r2tu1"&&(St.textContent=Pa),to.forEach(i),fr=o(l),N=a(l,"DIV",{class:!0});var xn=b(N);d(Be.$$.fragment,xn),_r=o(xn),At=a(xn,"P",{"data-svelte-h":!0}),c(At)!=="svelte-7q6b1s"&&(At.textContent=Ea),br=o(xn),Ot=a(xn,"P",{"data-svelte-h":!0}),c(Ot)!=="svelte-13r9fow"&&(Ot.innerHTML=ja),xn.forEach(i),vr=o(l),ce=a(l,"DIV",{class:!0});var no=b(ce);d(Se.$$.fragment,no),yr=o(no),Gt=a(no,"P",{"data-svelte-h":!0}),c(Gt)!=="svelte-1gemtfc"&&(Gt.textContent=Ua),no.forEach(i),$r=o(l),ge=a(l,"DIV",{class:!0});var oo=b(ge);d(Ae.$$.fragment,oo),xr=o(oo),zt=a(oo,"P",{"data-svelte-h":!0}),c(zt)!=="svelte-1szkij9"&&(zt.textContent=Ha),oo.forEach(i),wr=o(l),pe=a(l,"DIV",{class:!0});var ro=b(pe);d(Oe.$$.fragment,ro),Cr=o(ro),Qt=a(ro,"P",{"data-svelte-h":!0}),c(Qt)!=="svelte-ywq4p5"&&(Qt.textContent=Ja),ro.forEach(i),kr=o(l),de=a(l,"DIV",{class:!0});var ao=b(de);d(Ge.$$.fragment,ao),Tr=o(ao),Zt=a(ao,"P",{"data-svelte-h":!0}),c(Zt)!=="svelte-o0hw73"&&(Zt.textContent=Va),ao.forEach(i),Rr=o(l),q=a(l,"DIV",{class:!0});var wn=b(q);d(ze.$$.fragment,wn),Ir=o(wn),Xt=a(wn,"P",{"data-svelte-h":!0}),c(Xt)!=="svelte-rew8wo"&&(Xt.textContent=Fa),Dr=o(wn),Kt=a(wn,"P",{"data-svelte-h":!0}),c(Kt)!=="svelte-9edfgw"&&(Kt.innerHTML=Na),wn.forEach(i),Mr=o(l),he=a(l,"DIV",{class:!0});var io=b(he);d(Qe.$$.fragment,io),Lr=o(io),Yt=a(io,"P",{"data-svelte-h":!0}),c(Yt)!=="svelte-un1lv4"&&(Yt.textContent=qa),io.forEach(i),Pr=o(l),ue=a(l,"DIV",{class:!0});var so=b(ue);d(Ze.$$.fragment,so),Er=o(so),en=a(so,"P",{"data-svelte-h":!0}),c(en)!=="svelte-1i0xpsk"&&(en.textContent=Wa),so.forEach(i),jr=o(l),me=a(l,"DIV",{class:!0});var lo=b(me);d(Xe.$$.fragment,lo),Ur=o(lo),tn=a(lo,"P",{"data-svelte-h":!0}),c(tn)!=="svelte-jqquke"&&(tn.textContent=Ba),lo.forEach(i),Hr=o(l),fe=a(l,"DIV",{class:!0});var co=b(fe);d(Ke.$$.fragment,co),Jr=o(co),nn=a(co,"P",{"data-svelte-h":!0}),c(nn)!=="svelte-j7abay"&&(nn.textContent=Sa),co.forEach(i),Vr=o(l),_e=a(l,"DIV",{class:!0});var go=b(_e);d(Ye.$$.fragment,go),Fr=o(go),on=a(go,"P",{"data-svelte-h":!0}),c(on)!=="svelte-11wx7zp"&&(on.textContent=Aa),go.forEach(i),l.forEach(i),Dn=o(e),d(et.$$.fragment,e),Mn=o(e),W=a(e,"DIV",{class:!0});var po=b(W);d(tt.$$.fragment,po),Nr=o(po),rn=a(po,"P",{"data-svelte-h":!0}),c(rn)!=="svelte-5hpmfd"&&(rn.textContent=Oa),po.forEach(i),Ln=o(e),B=a(e,"DIV",{class:!0});var ho=b(B);d(nt.$$.fragment,ho),qr=o(ho),an=a(ho,"P",{"data-svelte-h":!0}),c(an)!=="svelte-1d1mfv5"&&(an.textContent=Ga),ho.forEach(i),Pn=o(e),S=a(e,"DIV",{class:!0});var uo=b(S);d(ot.$$.fragment,uo),Wr=o(uo),sn=a(uo,"P",{"data-svelte-h":!0}),c(sn)!=="svelte-oqtt44"&&(sn.textContent=za),uo.forEach(i),En=o(e),A=a(e,"DIV",{class:!0});var mo=b(A);d(rt.$$.fragment,mo),Br=o(mo),ln=a(mo,"P",{"data-svelte-h":!0}),c(ln)!=="svelte-1jg2eg8"&&(ln.textContent=Qa),mo.forEach(i),jn=o(e),O=a(e,"DIV",{class:!0});var fo=b(O);d(at.$$.fragment,fo),Sr=o(fo),cn=a(fo,"P",{"data-svelte-h":!0}),c(cn)!=="svelte-97mwvc"&&(cn.textContent=Za),fo.forEach(i),Un=o(e),G=a(e,"DIV",{class:!0});var _o=b(G);d(it.$$.fragment,_o),Ar=o(_o),gn=a(_o,"P",{"data-svelte-h":!0}),c(gn)!=="svelte-vpsey2"&&(gn.textContent=Xa),_o.forEach(i),Hn=o(e),E=a(e,"DIV",{class:!0});var Cn=b(E);d(st.$$.fragment,Cn),Or=o(Cn),pn=a(Cn,"P",{"data-svelte-h":!0}),c(pn)!=="svelte-18uhass"&&(pn.textContent=Ka),Gr=o(Cn),dn=a(Cn,"P",{"data-svelte-h":!0}),c(dn)!=="svelte-zq2g9v"&&(dn.textContent=Ya),Cn.forEach(i),Jn=o(e),d(lt.$$.fragment,e),Vn=o(e),ct=a(e,"P",{"data-svelte-h":!0}),c(ct)!=="svelte-1w5vmm6"&&(ct.innerHTML=ei),Fn=o(e),gt=a(e,"UL",{"data-svelte-h":!0}),c(gt)!=="svelte-1dzo48z"&&(gt.innerHTML=ti),Nn=o(e),pt=a(e,"P",{"data-svelte-h":!0}),c(pt)!=="svelte-1k7k7po"&&(pt.textContent=ni),qn=o(e),k=a(e,"DIV",{class:!0});var D=b(k);d(dt.$$.fragment,D),zr=o(D),hn=a(D,"P",{"data-svelte-h":!0}),c(hn)!=="svelte-sfljep"&&(hn.textContent=oi),Qr=o(D),un=a(D,"P",{"data-svelte-h":!0}),c(un)!=="svelte-130r937"&&(un.textContent=ri),Zr=o(D),d(be.$$.fragment,D),Xr=o(D),ve=a(D,"DIV",{class:!0});var bo=b(ve);d(ht.$$.fragment,bo),Kr=o(bo),mn=a(bo,"P",{"data-svelte-h":!0}),c(mn)!=="svelte-1qshjwq"&&(mn.textContent=ai),bo.forEach(i),Yr=o(D),ye=a(D,"DIV",{class:!0});var vo=b(ye);d(ut.$$.fragment,vo),ea=o(vo),fn=a(vo,"P",{"data-svelte-h":!0}),c(fn)!=="svelte-54rv4h"&&(fn.textContent=ii),vo.forEach(i),ta=o(D),$e=a(D,"DIV",{class:!0});var yo=b($e);d(mt.$$.fragment,yo),na=o(yo),_n=a(yo,"P",{"data-svelte-h":!0}),c(_n)!=="svelte-11wx7zp"&&(_n.textContent=si),yo.forEach(i),D.forEach(i),Wn=o(e),z=a(e,"DIV",{class:!0});var $o=b(z);d(ft.$$.fragment,$o),oa=o($o),bn=a($o,"P",{"data-svelte-h":!0}),c(bn)!=="svelte-1na97wh"&&(bn.textContent=li),$o.forEach(i),Bn=o(e),d(_t.$$.fragment,e),Sn=o(e),kn=a(e,"P",{}),b(kn).forEach(i),this.h()},h(){v(y,"name","hf:doc:metadata"),v(y,"content",xi),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,g){t(document.head,y),_(e,T,g),_(e,w,g),_(e,C,g),h(R,e,g),_(e,x,g),_(e,I,g),_(e,Tn,g),_(e,we,g),_(e,Rn,g),h(Ce,e,g),_(e,In,g),_(e,s,g),h(ke,s,null),t(s,Co),t(s,vt),t(s,ko),t(s,yt),t(s,To),h(Q,s,null),t(s,Ro),t(s,M),h(Te,M,null),t(M,Io),t(M,$t),t(M,Do),t(M,xt),t(M,Mo),t(M,wt),t(s,Lo),t(s,Z),h(Re,Z,null),t(Z,Po),t(Z,Ct),t(s,Eo),t(s,L),h(Ie,L,null),t(L,jo),t(L,kt),t(L,Uo),t(L,Tt),t(L,Ho),t(L,Rt),t(s,Jo),t(s,X),h(De,X,null),t(X,Vo),t(X,It),t(s,Fo),t(s,K),h(Me,K,null),t(K,No),t(K,Dt),t(s,qo),t(s,Y),h(Le,Y,null),t(Y,Wo),t(Y,Mt),t(s,Bo),t(s,P),h(Pe,P,null),t(P,So),t(P,Lt),t(P,Ao),t(P,Pt),t(P,Oo),h(ee,P,null),t(s,Go),t(s,J),h(Ee,J,null),t(J,zo),t(J,Et),t(J,Qo),h(te,J,null),t(s,Zo),t(s,ne),h(je,ne,null),t(ne,Xo),t(ne,jt),t(s,Ko),t(s,V),h(Ue,V,null),t(V,Yo),t(V,Ut),t(V,er),t(V,Ht),t(s,tr),t(s,F),h(He,F,null),t(F,nr),t(F,Jt),t(F,or),t(F,Vt),t(s,rr),t(s,oe),h(Je,oe,null),t(oe,ar),t(oe,Ft),t(s,ir),t(s,re),h(Ve,re,null),t(re,sr),t(re,Nt),t(s,lr),t(s,ae),h(Fe,ae,null),t(ae,cr),t(ae,qt),t(s,gr),t(s,ie),h(Ne,ie,null),t(ie,pr),t(ie,Wt),t(s,dr),t(s,se),h(qe,se,null),t(se,hr),t(se,Bt),t(s,ur),t(s,le),h(We,le,null),t(le,mr),t(le,St),t(s,fr),t(s,N),h(Be,N,null),t(N,_r),t(N,At),t(N,br),t(N,Ot),t(s,vr),t(s,ce),h(Se,ce,null),t(ce,yr),t(ce,Gt),t(s,$r),t(s,ge),h(Ae,ge,null),t(ge,xr),t(ge,zt),t(s,wr),t(s,pe),h(Oe,pe,null),t(pe,Cr),t(pe,Qt),t(s,kr),t(s,de),h(Ge,de,null),t(de,Tr),t(de,Zt),t(s,Rr),t(s,q),h(ze,q,null),t(q,Ir),t(q,Xt),t(q,Dr),t(q,Kt),t(s,Mr),t(s,he),h(Qe,he,null),t(he,Lr),t(he,Yt),t(s,Pr),t(s,ue),h(Ze,ue,null),t(ue,Er),t(ue,en),t(s,jr),t(s,me),h(Xe,me,null),t(me,Ur),t(me,tn),t(s,Hr),t(s,fe),h(Ke,fe,null),t(fe,Jr),t(fe,nn),t(s,Vr),t(s,_e),h(Ye,_e,null),t(_e,Fr),t(_e,on),_(e,Dn,g),h(et,e,g),_(e,Mn,g),_(e,W,g),h(tt,W,null),t(W,Nr),t(W,rn),_(e,Ln,g),_(e,B,g),h(nt,B,null),t(B,qr),t(B,an),_(e,Pn,g),_(e,S,g),h(ot,S,null),t(S,Wr),t(S,sn),_(e,En,g),_(e,A,g),h(rt,A,null),t(A,Br),t(A,ln),_(e,jn,g),_(e,O,g),h(at,O,null),t(O,Sr),t(O,cn),_(e,Un,g),_(e,G,g),h(it,G,null),t(G,Ar),t(G,gn),_(e,Hn,g),_(e,E,g),h(st,E,null),t(E,Or),t(E,pn),t(E,Gr),t(E,dn),_(e,Jn,g),h(lt,e,g),_(e,Vn,g),_(e,ct,g),_(e,Fn,g),_(e,gt,g),_(e,Nn,g),_(e,pt,g),_(e,qn,g),_(e,k,g),h(dt,k,null),t(k,zr),t(k,hn),t(k,Qr),t(k,un),t(k,Zr),h(be,k,null),t(k,Xr),t(k,ve),h(ht,ve,null),t(ve,Kr),t(ve,mn),t(k,Yr),t(k,ye),h(ut,ye,null),t(ye,ea),t(ye,fn),t(k,ta),t(k,$e),h(mt,$e,null),t($e,na),t($e,_n),_(e,Wn,g),_(e,z,g),h(ft,z,null),t(z,oa),t(z,bn),_(e,Bn,g),h(_t,e,g),_(e,Sn,g),_(e,kn,g),An=!0},p(e,[g]){const l={};g&2&&(l.$$scope={dirty:g,ctx:e}),Q.$set(l);const j={};g&2&&(j.$$scope={dirty:g,ctx:e}),ee.$set(j);const bt={};g&2&&(bt.$$scope={dirty:g,ctx:e}),te.$set(bt);const U={};g&2&&(U.$$scope={dirty:g,ctx:e}),be.$set(U)},i(e){An||(u(R.$$.fragment,e),u(Ce.$$.fragment,e),u(ke.$$.fragment,e),u(Q.$$.fragment,e),u(Te.$$.fragment,e),u(Re.$$.fragment,e),u(Ie.$$.fragment,e),u(De.$$.fragment,e),u(Me.$$.fragment,e),u(Le.$$.fragment,e),u(Pe.$$.fragment,e),u(ee.$$.fragment,e),u(Ee.$$.fragment,e),u(te.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u(He.$$.fragment,e),u(Je.$$.fragment,e),u(Ve.$$.fragment,e),u(Fe.$$.fragment,e),u(Ne.$$.fragment,e),u(qe.$$.fragment,e),u(We.$$.fragment,e),u(Be.$$.fragment,e),u(Se.$$.fragment,e),u(Ae.$$.fragment,e),u(Oe.$$.fragment,e),u(Ge.$$.fragment,e),u(ze.$$.fragment,e),u(Qe.$$.fragment,e),u(Ze.$$.fragment,e),u(Xe.$$.fragment,e),u(Ke.$$.fragment,e),u(Ye.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(nt.$$.fragment,e),u(ot.$$.fragment,e),u(rt.$$.fragment,e),u(at.$$.fragment,e),u(it.$$.fragment,e),u(st.$$.fragment,e),u(lt.$$.fragment,e),u(dt.$$.fragment,e),u(be.$$.fragment,e),u(ht.$$.fragment,e),u(ut.$$.fragment,e),u(mt.$$.fragment,e),u(ft.$$.fragment,e),u(_t.$$.fragment,e),An=!0)},o(e){m(R.$$.fragment,e),m(Ce.$$.fragment,e),m(ke.$$.fragment,e),m(Q.$$.fragment,e),m(Te.$$.fragment,e),m(Re.$$.fragment,e),m(Ie.$$.fragment,e),m(De.$$.fragment,e),m(Me.$$.fragment,e),m(Le.$$.fragment,e),m(Pe.$$.fragment,e),m(ee.$$.fragment,e),m(Ee.$$.fragment,e),m(te.$$.fragment,e),m(je.$$.fragment,e),m(Ue.$$.fragment,e),m(He.$$.fragment,e),m(Je.$$.fragment,e),m(Ve.$$.fragment,e),m(Fe.$$.fragment,e),m(Ne.$$.fragment,e),m(qe.$$.fragment,e),m(We.$$.fragment,e),m(Be.$$.fragment,e),m(Se.$$.fragment,e),m(Ae.$$.fragment,e),m(Oe.$$.fragment,e),m(Ge.$$.fragment,e),m(ze.$$.fragment,e),m(Qe.$$.fragment,e),m(Ze.$$.fragment,e),m(Xe.$$.fragment,e),m(Ke.$$.fragment,e),m(Ye.$$.fragment,e),m(et.$$.fragment,e),m(tt.$$.fragment,e),m(nt.$$.fragment,e),m(ot.$$.fragment,e),m(rt.$$.fragment,e),m(at.$$.fragment,e),m(it.$$.fragment,e),m(st.$$.fragment,e),m(lt.$$.fragment,e),m(dt.$$.fragment,e),m(be.$$.fragment,e),m(ht.$$.fragment,e),m(ut.$$.fragment,e),m(mt.$$.fragment,e),m(ft.$$.fragment,e),m(_t.$$.fragment,e),An=!1},d(e){e&&(i(T),i(w),i(C),i(x),i(I),i(Tn),i(we),i(Rn),i(In),i(s),i(Dn),i(Mn),i(W),i(Ln),i(B),i(Pn),i(S),i(En),i(A),i(jn),i(O),i(Un),i(G),i(Hn),i(E),i(Jn),i(Vn),i(ct),i(Fn),i(gt),i(Nn),i(pt),i(qn),i(k),i(Wn),i(z),i(Bn),i(Sn),i(kn)),i(y),f(R,e),f(Ce,e),f(ke),f(Q),f(Te),f(Re),f(Ie),f(De),f(Me),f(Le),f(Pe),f(ee),f(Ee),f(te),f(je),f(Ue),f(He),f(Je),f(Ve),f(Fe),f(Ne),f(qe),f(We),f(Be),f(Se),f(Ae),f(Oe),f(Ge),f(ze),f(Qe),f(Ze),f(Xe),f(Ke),f(Ye),f(et,e),f(tt),f(nt),f(ot),f(rt),f(at),f(it),f(st),f(lt,e),f(dt),f(be),f(ht),f(ut),f(mt),f(ft),f(_t,e)}}}const xi='{"title":"Managing local and online repositories","local":"managing-local-and-online-repositories","sections":[{"title":"The Repository class","local":"huggingface_hub.Repository","sections":[],"depth":2},{"title":"Helper methods","local":"huggingface_hub.repository.is_git_repo","sections":[],"depth":2},{"title":"Following asynchronous commands","local":"huggingface_hub.Repository","sections":[],"depth":2}],"depth":1}';function wi(H){return gi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Li extends pi{constructor(y){super(),di(this,y,wi,$i,ci,{})}}export{Li as component};
