import{s as Ql,n as $l,o as Wl}from"../chunks/scheduler.b108d059.js";import{S as Xl,i as Rl,g as i,s as a,r as M,A as Sl,h as o,f as s,c as n,j as zl,u as p,x as r,k as ol,y as Yl,a as t,v as d,d as u,t as c,w as m}from"../chunks/index.008de539.js";import{C as Me}from"../chunks/CodeBlock.7b00c886.js";import{H as y,E as ql}from"../chunks/index.9dd2deb3.js";function Ll(rl){let h,ue,pe,ce,J,me,w,Ml=`Le Hugging Face Hub facilite l’hébergement et le partage de modèles et de jeux de données.
Des <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">dizaines de librairies</a> sont intégrées à cet écosystème. La communauté travaille constamment à en intégrer de nouvelles et contribue ainsi à faciliter la collaboration dans le milieu du machine learning. La librairie <code>huggingface_hub</code> joue un rôle clé dans ce processus puisqu’elle permet d’interagir avec le Hub depuis n’importe quel script Python.`,ye,U,pl="Il existe quatre façons principales d’intégrer une bibliothèque au Hub :",he,b,dl='<li><strong>Push to Hub</strong>  implémente une méthode pour upload un modèle sur le Hub. Cela inclut les paramètres du modèle, sa fiche descriptive (appelée <a href="https://huggingface.co/docs/huggingface_hub/how-to-model-cards" rel="nofollow">Model Card</a>) et toute autre information pertinente liée au modèle (par exemple, les logs d’entraînement). Cette méthode est souvent appelée <code>push_to_hub()</code>.</li> <li><strong>Download from Hub</strong> implémente une méthode pour charger un modèle depuis le Hub. La méthode doit télécharger la configuration et les poids du modèle puis instancier celui-ci. Cette méthode est souvent appelée <code>from_pretrained</code> ou <code>load_from_hub()</code>.</li> <li><strong>Inference API</strong> utilise nos serveurs pour faire de l’inférence gratuitement sur des modèles supportés par votre librairie.</li> <li><strong>Widgets</strong> affiche un widget sur la page d’accueil de votre modèle dans le Hub. Les widgets permettent aux utilisateurs de rapidement tester un modèle depuis le navigateur.</li>',je,f,ul="Dans ce guide, nous nous concentrerons sur les deux premiers sujets. Nous présenterons les deux approches principales que vous pouvez utiliser pour intégrer une librairie, avec leurs avantages et leurs inconvénients. Tout est résumé à la fin du guide pour vous aider à choisir entre les deux. Veuillez garder à l’esprit que ce ne sont que des conseils, et vous êtes libres de les adapter à votre cas d’usage.",Te,I,cl='Si l’Inference API et les Widgets vous intéressent, vous pouvez suivre <a href="https://huggingface.co/docs/hub/models-adding-libraries#set-up-the-inference-api" rel="nofollow">ce guide</a>. Dans les deux cas, vous pouvez nous contacter si vous intégrez une librairie au Hub et que vous voulez être listé <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">dans la documentation officielle</a>.',Je,C,we,v,ml=`La première approche pour intégrer une librairie au Hub est d’implémenter les méthodes <code>push_to_hub</code> et <code>from_pretrained</code>
vous-même. Ceci vous donne une flexibilité totale sur le choix du fichier que vous voulez upload/download et sur comment
gérer les inputs spécifiques à votre framework. Vous pouvez vous référer aux guides : <a href="./upload">upload des fichiers</a>
et <a href="./download">télécharger des fichiers</a> pour en savoir plus sur la manière de faire. Par example, c’est de cette manière que l’intégration
de FastAI est implémentée (voir <code>push_to_hub_fastai()</code> et <code>from_pretrained_fastai()</code>).`,Ue,g,yl="L’implémentation peut varier entre différentes librairies, mais le workflow est souvent similaire.",be,_,fe,A,hl="Voici un exemple classique pour implémenter la méthode <code>from_pretrained</code>:",Ie,Z,Ce,G,ve,B,jl=`La méthode <code>push_to_hub</code> demande souvent un peu plus de complexité pour gérer la création du dépôt git, générer la model card et enregistrer les paramètres.
Une approche commune est de sauvegarder tous ces fichiers dans un dossier temporaire, les transférer sur le Hub avant de les supprimer localement.`,ge,x,_e,k,Tl=`Ceci n’est qu’un exemple. Si vous êtes intéressés par des manipulations plus complexes (supprimer des fichiers distants,
upload des poids à la volée, maintenir les poids localement, etc.) consultez le guide <a href="./upload">upload des fichiers</a>.`,Ae,V,Ze,H,Jl=`Bien que très flexible, cette approche a quelques défauts, particulièrement en termes de maintenance. Les utilisateurs
d’Hugging Face sont habitués à utiliser certaines fonctionnalités lorsqu’ils travaillent avec <code>huggingface_hub</code>. Par exemple,
lors du chargement de fichiers depuis le Hub, il est commun de passer des paramètres tels que:`,Ge,E,wl="<li><code>token</code>: pour télécharger depuis un dépôt privé</li> <li><code>revision</code>: pour télécharger depuis une branche spécifique</li> <li><code>cache_dir</code>: pour paramétrer la mise en cache des fichiers</li> <li><code>force_download</code>: pour désactiver le cache</li> <li><code>api_endpoint</code>/<code>proxies</code>: pour configurer la session HTTP</li>",Be,z,Ul="Lorsque vous pushez des modèles, des paramètres similaires sont utilisables:",xe,Q,bl="<li><code>commit_message</code>: message de commit personnalisé</li> <li><code>private</code>: crée un dépôt privé s’il en manque un</li> <li><code>create_pr</code>: crée une pull request au lieu de push vers <code>main</code></li> <li><code>branch</code>: push vers une branche au lieu de push sur <code>main</code></li> <li><code>allow_patterns</code>/<code>ignore_patterns</code>: filtre les fichiers à upload</li> <li><code>token</code></li> <li><code>api_endpoint</code></li> <li>…</li>",ke,$,fl=`Tous ces paramètres peuvent être ajoutés aux implémentations vues ci-dessus et passés aux méthodes de <code>huggingface_hub</code>.
Toutefois, si un paramètre change ou qu’une nouvelle fonctionnalité est ajoutée, vous devrez mettre à jour votre package.
Supporter ces paramètres implique aussi plus de documentation à maintenir de votre côté. Dans la prochaine section, nous allons voir comment dépasser ces limitations.`,Ve,W,He,X,Il=`Comme vu ci-dessus, deux méthodes principales sont à inclure dans votre librairie pour l’intégrer avec le Hub:
la méthode permettant d’upload des fichiers (<code>push_to_hub</code>) et celle pour télécharger des fichiers (<code>from_pretrained</code>).
Vous pouvez implémenter ces méthodes vous-même mais cela a des inconvénients. Pour gérer ça, <code>huggingface_hub</code> fournit
un outil qui utilise l’héritage de classe. Regardons comment ça marche !`,Ee,R,Cl=`Dans beaucoup de cas, une librairie définit déjà les modèles comme des classes Python. La classe contient les
propriétés du modèle et des méthodes pour charger, lancer, entraîner et évaluer le modèle. Notre approche est d’étendre
cette classe pour inclure les fonctionnalités upload et download en utilisant les mixins. Une <a href="https://stackoverflow.com/a/547714" rel="nofollow">mixin</a>
est une classe qui est faite pour étendre une classe existante avec une liste de fonctionnalités spécifiques en utilisant l’héritage de classe.
<code>huggingface_hub</code> offre son propre mixin, le <code>ModelHubMixin</code>. La clef ici est de comprendre son comportement et comment le customiser.`,ze,S,vl=`La classe <code>ModelHubMixin</code> implémente 3 méthodes <em>public</em> (<code>push_to_hub</code>, <code>save_pretrained</code> et <code>from_pretrained</code>). Ce
sont les méthodes que vos utilisateurs appelleront pour charger/enregistrer des modèles avec votre librairie.
<code>ModelHubMixin</code> définit aussi 2 méthodes <em>private</em> (<code>_save_pretrained</code> et <code>from_pretrained</code>). Ce sont celles que vous
devez implémenter. Ainsi, pour intégrer votre librairie, vous devez :`,Qe,Y,gl=`<li>Faire en sorte que votre classe Model hérite de <code>ModelHubMixin</code>.</li> <li>Implémenter les méthodes privées:<ul><li><code>_save_pretrained()</code>: méthode qui prend en entrée un chemin vers un directory et qui sauvegarde le modèle.
Vous devez écrire toute la logique pour dump votre modèle de cette manière: model card, poids du modèle, fichiers de configuration,
et logs d’entraînement. Toute information pertinente pour ce modèle doit être gérée par cette méthode. Les
<a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">model cards</a> sont particulièrement importantes pour décrire votre modèle. Vérifiez
<a href="./model-cards">notre guide d’implémentation</a> pour plus de détails.</li> <li><code>_from_pretrained()</code>: <strong>méthode de classe</strong> prenant en entrée un <code>model_id</code> et qui retourne un modèle instancié.
Cette méthode doit télécharger un ou plusieurs fichier(s) et le(s) charger.</li></ul></li> <li>Fini!</li>`,$e,q,_l=`L’avantage d’utiliser <code>ModelHubMixin</code> est qu’une fois que vous vous êtes occupés de la sérialisation et du chargement du fichier,
vous êtes prêts. Vous n’avez pas besoin de vous soucier de la création du dépôt, des commits, des pull requests ou des révisions.
Tout ceci est géré par le mixin et est disponible pour vos utilisateurs. Le Mixin s’assure aussi que les méthodes publiques sont
bien documentées et que les annotations de typage sont spécifiées.`,We,L,Xe,F,Al=`Un bon exemple de ce que nous avons vu ci-dessus est <code>PyTorchModelHubMixin</code>, notre intégration pour le framework PyTorch.
C’est une intégration prête à l’emploi.`,Re,N,Se,P,Zl="Voici comment n’importe quel utilisateur peut charger/enregistrer un modèle Pytorch depuis/vers le Hub:",Ye,D,qe,K,Le,O,Gl='L’implémentation est très succincte (voir <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py" rel="nofollow">ici</a>).',Fe,ee,Bl="<li>Premièrement, faites hériter votre classe de <code>ModelHubMixin</code>:</li>",Ne,le,Pe,j,xl="<li>Implémentez la méthode <code>_save_pretrained</code>:</li>",De,se,Ke,T,kl="<li>Implémentez la méthode <code>_from_pretrained</code>:</li>",Oe,te,el,ae,Vl="Et c’est fini ! Votre librairie permet maintenant aux utilisateurs d’upload et de télécharger des fichiers vers et depuis le Hub.",ll,ne,sl,ie,Hl=`Résumons rapidement les deux approches que nous avons vu avec leurs avantages et leurs défauts. Le tableau ci-dessous
est purement indicatif. Votre framework aura peut-êre des spécificités à prendre en compte. Ce guide
est ici pour vous donner des indications et des idées sur comment gérer l’intégration. Dans tous les cas,
n’hésitez pas à nous contacter si vous avez une question !`,tl,oe,El='<thead><tr><th align="center">Intégration</th> <th align="center">Utilisant des helpers</th> <th align="center">Utilisant <code>ModelHubMixin</code></th></tr></thead> <tbody><tr><td align="center">Expérience utilisateur</td> <td align="center"><code>model = load_from_hub(...)</code><br/><code>push_to_hub(model, ...)</code></td> <td align="center"><code>model = MyModel.from_pretrained(...)</code><br/><code>model.push_to_hub(...)</code></td></tr> <tr><td align="center">Flexible</td> <td align="center">Très flexible.<br/>Vous controllez complètement l’implémentation.</td> <td align="center">Moins flexible.<br/>Votre framework doit avoir une classe de modèle.</td></tr> <tr><td align="center">Maintenance</td> <td align="center">Plus de maintenance pour ajouter du support pour la configuration, et de nouvelles fonctionnalités. Peut aussi nécessiter de fixx des problèmes signalés par les utilisateurs.</td> <td align="center">Moins de maintenance vu que la plupart des intégrations avec le Hub sont implémentés dans <code>huggingface_hub</code></td></tr> <tr><td align="center">Documentation / Anotation de type</td> <td align="center">A écrire à la main</td> <td align="center">Géré partiellement par <code>huggingface_hub</code>.</td></tr></tbody>',al,re,nl,de,il;return J=new y({props:{title:"Intégrez votre framework de ML avec le Hub",local:"intégrez-votre-framework-de-ml-avec-le-hub",headingTag:"h1"}}),C=new y({props:{title:"Une approche flexible: les helpers",local:"une-approche-flexible-les-helpers",headingTag:"h2"}}),_=new y({props:{title:"from_pretrained",local:"frompretrained",headingTag:"h3"}}),Z=new Me({props:{code:"ZGVmJTIwZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTNBJTIwc3RyKSUyMC0lM0UlMjBNeU1vZGVsQ2xhc3MlM0ElMEElMjAlMjAlMjAlMjMlMjBUJUMzJUE5bCVDMyVBOWNoYXJnZW1lbnQlMjBkZXMlMjBwYXJhbSVDMyVBOHRyZXMlMjBkZXB1aXMlMjBsZSUyMEh1YiUwQSUyMCUyMCUyMGNhY2hlZF9tb2RlbCUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGZpbGVuYW1lJTNEJTIybW9kZWwucGtsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIyZmFzdGFpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV92ZXJzaW9uJTNEZ2V0X2Zhc3RhaV92ZXJzaW9uKCklMkMlMEElMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIzJTIwSW5zdGFuY2lhdGlvbiUyMGR1JTIwbW9kJUMzJUE4bGUlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2FkX21vZGVsKGNhY2hlZF9tb2RlbCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span></span>) -&gt; MyModelClass:
   <span class="hljs-comment"># Téléchargement des paramètres depuis le Hub</span>
   cached_model = hf_hub_download(
      repo_id=repo_id,
      filename=<span class="hljs-string">&quot;model.pkl&quot;</span>,
      library_name=<span class="hljs-string">&quot;fastai&quot;</span>,
      library_version=get_fastai_version(),
   )

   <span class="hljs-comment"># Instanciation du modèle</span>
    <span class="hljs-keyword">return</span> load_model(cached_model)`,wrap:!1}}),G=new y({props:{title:"push_to_hub",local:"pushtohub",headingTag:"h3"}}),x=new Me({props:{code:"ZGVmJTIwcHVzaF90b19odWIobW9kZWwlM0ElMjBNeU1vZGVsQ2xhc3MlMkMlMjByZXBvX25hbWUlM0ElMjBzdHIpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjBhcGklMjAlM0QlMjBIZkFwaSgpJTBBJTBBJTIwJTIwJTIwJTIzJTIwQ3IlQzMlQTlleiUyMGQndW4lMjBkJUMzJUE5cCVDMyVCNHQlMjBzJ2lsJTIwbidleGlzdGUlMjBwYXMlMjBlbmNvcmUlMkMlMjBldCUyMG9idGVuZXolMjBsZSUyMHJlcG9faWQlMjBhc3NvY2klQzMlQTklMEElMjAlMjAlMjByZXBvX2lkJTIwJTNEJTIwYXBpLmNyZWF0ZV9yZXBvKHJlcG9fbmFtZSUyQyUyMGV4aXN0X29rJTNEVHJ1ZSkucmVwb19pZCUwQSUwQSUyMCUyMCUyMCUyMyUyMFNhdXZlZ2FyZGV6JTIwdG91cyUyMGxlcyUyMGZpY2hpZXJzJTIwZGFucyUyMHVuJTIwY2hlbWluJTIwdGVtcG9yYWlyZSUyQyUyMGV0JTIwcHVzaGV6JTIwbGVzJTIwZW4lMjB1biUyMHNldWwlMjBjb21taXQlMEElMjAlMjAlMjB3aXRoJTIwVGVtcG9yYXJ5RGlyZWN0b3J5KCklMjBhcyUyMHRtcGRpciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHRtcGRpciUyMCUzRCUyMFBhdGgodG1wZGlyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFNhdXZlZ2FyZGV6JTIwbGVzJTIwcG9pZHMlMEElMjAlMjAlMjAlMjAlMjAlMjBzYXZlX21vZGVsKG1vZGVsJTJDJTIwdG1wZGlyJTIwJTJGJTIwJTIybW9kZWwuc2FmZXRlbnNvcnMlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRyVDMyVBOW4lQzMlQTlyZXolMjBsYSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMCUyMCUyMCUyMCUyMGNhcmQlMjAlM0QlMjBnZW5lcmF0ZV9tb2RlbF9jYXJkKG1vZGVsKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCh0bXBkaXIlMjAlMkYlMjAlMjJSRUFETUUubWQlMjIpLndyaXRlX3RleHQoY2FyZCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXV2ZWdhcmRleiUyMGxlcyUyMGxvZ3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXV2ZWdhcmRleiUyMGxlJTIwbSVDMyVBOXRyaXF1ZXMlMjBkJyVDMyVBOXZhbHVhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMC4uLiUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFB1c2hleiUyMHZlcnMlMjBsZSUyMEh1YiUwQSUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGFwaS51cGxvYWRfZm9sZGVyKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwZm9sZGVyX3BhdGglM0R0bXBkaXIp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">model: MyModelClass, repo_name: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-literal">None</span>:
   api = HfApi()

   <span class="hljs-comment"># Créez d&#x27;un dépôt s&#x27;il n&#x27;existe pas encore, et obtenez le repo_id associé</span>
   repo_id = api.create_repo(repo_name, exist_ok=<span class="hljs-literal">True</span>).repo_id

   <span class="hljs-comment"># Sauvegardez tous les fichiers dans un chemin temporaire, et pushez les en un seul commit</span>
   <span class="hljs-keyword">with</span> TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
      tmpdir = Path(tmpdir)

      <span class="hljs-comment"># Sauvegardez les poids</span>
      save_model(model, tmpdir / <span class="hljs-string">&quot;model.safetensors&quot;</span>)

      <span class="hljs-comment"># Générez la model card</span>
      card = generate_model_card(model)
      (tmpdir / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(card)

      <span class="hljs-comment"># Sauvegardez les logs</span>
      <span class="hljs-comment"># Sauvegardez le métriques d&#x27;évaluation</span>
      <span class="hljs-comment"># ...</span>

      <span class="hljs-comment"># Pushez vers le Hub</span>
      <span class="hljs-keyword">return</span> api.upload_folder(repo_id=repo_id, folder_path=tmpdir)`,wrap:!1}}),V=new y({props:{title:"Limitations",local:"limitations",headingTag:"h3"}}),W=new y({props:{title:"Une approche plus complexe: l’héritage de classe",local:"une-approche-plus-complexe-lhéritage-de-classe",headingTag:"h2"}}),L=new y({props:{title:"Un exemple concret: PyTorch",local:"un-exemple-concret-pytorch",headingTag:"h3"}}),N=new y({props:{title:"Comment l’utiliser ?",local:"comment-lutiliser-",headingTag:"h4"}}),D=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyME15TW9kZWwobm4uTW9kdWxlJTJDJTIwUHlUb3JjaE1vZGVsSHViTWl4aW4pJTNBJTIwJTIzJTIwaCVDMyVBOXJpdGFnZSUyMG11bHRpcGxlJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnBhcmFtJTIwJTNEJTIwbm4uUGFyYW1ldGVyKHRvcmNoLnJhbmQoMyUyQyUyMDQpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGluZWFyJTIwJTNEJTIwbm4uTGluZWFyKDQlMkMlMjA1KSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5saW5lYXIoeCUyMCUyQiUyMHNlbGYucGFyYW0pJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsKCklMEElMEFtb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIycGF0aCUyRnRvJTJGbXktYXdlc29tZS1tb2RlbCUyMiklMEElMEFtb2RlbC5wdXNoX3RvX2h1YiglMjJteS1hd2Vzb21lLW1vZGVsJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwTXlNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydXNlcm5hbWUlMkZteS1hd2Vzb21lLW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin

<span class="hljs-comment"># 1. Définissez votre modèle Pytorch exactement comme vous êtes habitués à le faire</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(nn.Module, PyTorchModelHubMixin): <span class="hljs-comment"># héritage multiple</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__() 
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(<span class="hljs-number">3</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel()

<span class="hljs-comment"># 2. (optionnel) Sauvegarder le modèle dans un chemin local</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;path/to/my-awesome-model&quot;</span>)

<span class="hljs-comment"># 3. Pushez les poids du modèle vers le Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># 4. initialisez le modèle depuis le Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)`,wrap:!1}}),K=new y({props:{title:"Implémentation",local:"implémentation",headingTag:"h4"}}),le=new Me({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)`,wrap:!1}}),se=new Me({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUyQyUyME1vZGVsQ2FyZERhdGElMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLiklMEElMEElMjAlMjAlMjBkZWYlMjBfc2F2ZV9wcmV0cmFpbmVkKHNlbGYlMkMlMjBzYXZlX2RpcmVjdG9yeSUzQSUyMFBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyRyVDMyVBOW4lQzMlQTlyZXolMjB1bmUlMjBtb2RlbCUyMGNhcmQlMjBldCUyMGVucmVnaXN0cmV6JTIwbGVzJTIwcG9pZHMlMjBkJ3VuJTIwbW9kJUMzJUE4bGUlMjBQeXRyb2NoJTIwdmVycyUyMHVuJTIwY2hlbWluJTIwbG9jYWwuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfY2FyZCUyMCUzRCUyME1vZGVsQ2FyZC5mcm9tX3RlbXBsYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRfZGF0YSUzRE1vZGVsQ2FyZERhdGEoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGljZW5zZSUzRCdtaXQnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9zdW1tYXJ5JTNELi4uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfdHlwZSUzRC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAoc2F2ZV9kaXJlY3RvcnklMjAlMkYlMjAlMjJSRUFETUUubWQlMjIpLndyaXRlX3RleHQoc3RyKG1vZGVsKSklMEElMjAlMjAlMjAlMjAlMjAlMjB0b3JjaC5zYXZlKG9iaiUzRHNlbGYubW9kdWxlLnN0YXRlX2RpY3QoKSUyQyUyMGYlM0RzYXZlX2RpcmVjdG9yeSUyMCUyRiUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, ModelCardData

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>):
      <span class="hljs-string">&quot;&quot;&quot;Générez une model card et enregistrez les poids d&#x27;un modèle Pytroch vers un chemin local.&quot;&quot;&quot;</span>
      model_card = ModelCard.from_template(
         card_data=ModelCardData(
            license=<span class="hljs-string">&#x27;mit&#x27;</span>,
            library_name=<span class="hljs-string">&quot;pytorch&quot;</span>,
            ...
         ),
         model_summary=...,
         model_type=...,
         ...
      )
      (save_directory / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(<span class="hljs-built_in">str</span>(model))
      torch.save(obj=self.module.state_dict(), f=save_directory / <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)`,wrap:!1}}),te=new Me({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

<span class="hljs-meta">   @classmethod </span><span class="hljs-comment"># Doit absolument être une méthode de clase !</span>
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_from_pretrained</span>(<span class="hljs-params">
      cls,
      *,
      model_id: <span class="hljs-built_in">str</span>,
      revision: <span class="hljs-built_in">str</span>,
      cache_dir: <span class="hljs-built_in">str</span>,
      force_download: <span class="hljs-built_in">bool</span>,
      proxies: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>],
      resume_download: <span class="hljs-built_in">bool</span>,
      local_files_only: <span class="hljs-built_in">bool</span>,
      token: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>, <span class="hljs-literal">None</span>],
      map_location: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span>, <span class="hljs-comment"># argument supplémentaire</span>
      strict: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>, <span class="hljs-comment"># argument supplémentaire</span>
      **model_kwargs,
   </span>):
      <span class="hljs-string">&quot;&quot;&quot;Chargez les poids pré-entrainés et renvoyez les au modèle chargé.&quot;&quot;&quot;</span>
      <span class="hljs-keyword">if</span> os.path.isdir(model_id): <span class="hljs-comment"># Peut être un chemin local</span>
         <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading weights from local directory&quot;</span>)
         model_file = os.path.join(model_id, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
      <span class="hljs-keyword">else</span>: <span class="hljs-comment"># Ou un modèle du Hub</span>
         model_file = hf_hub_download( <span class="hljs-comment"># Téléchargez depuis le Hub, en passant le mêmes arguments d&#x27;entrée</span>
            repo_id=model_id,
            filename=<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
            revision=revision,
            cache_dir=cache_dir,
            force_download=force_download,
            proxies=proxies,
            resume_download=resume_download,
            token=token,
            local_files_only=local_files_only,
         )

      <span class="hljs-comment"># Chargez le modèle et reoutnez une logique personnalisée dépendant de votre framework</span>
      model = cls(**model_kwargs)
      state_dict = torch.load(model_file, map_location=torch.device(map_location))
      model.load_state_dict(state_dict, strict=strict)
      model.<span class="hljs-built_in">eval</span>()
      <span class="hljs-keyword">return</span> model`,wrap:!1}}),ne=new y({props:{title:"Comparaison",local:"comparaison",headingTag:"h2"}}),re=new ql({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/fr/guides/integrations.md"}}),{c(){h=i("meta"),ue=a(),pe=i("p"),ce=a(),M(J.$$.fragment),me=a(),w=i("p"),w.innerHTML=Ml,ye=a(),U=i("p"),U.textContent=pl,he=a(),b=i("ol"),b.innerHTML=dl,je=a(),f=i("p"),f.textContent=ul,Te=a(),I=i("p"),I.innerHTML=cl,Je=a(),M(C.$$.fragment),we=a(),v=i("p"),v.innerHTML=ml,Ue=a(),g=i("p"),g.textContent=yl,be=a(),M(_.$$.fragment),fe=a(),A=i("p"),A.innerHTML=hl,Ie=a(),M(Z.$$.fragment),Ce=a(),M(G.$$.fragment),ve=a(),B=i("p"),B.innerHTML=jl,ge=a(),M(x.$$.fragment),_e=a(),k=i("p"),k.innerHTML=Tl,Ae=a(),M(V.$$.fragment),Ze=a(),H=i("p"),H.innerHTML=Jl,Ge=a(),E=i("ul"),E.innerHTML=wl,Be=a(),z=i("p"),z.textContent=Ul,xe=a(),Q=i("ul"),Q.innerHTML=bl,ke=a(),$=i("p"),$.innerHTML=fl,Ve=a(),M(W.$$.fragment),He=a(),X=i("p"),X.innerHTML=Il,Ee=a(),R=i("p"),R.innerHTML=Cl,ze=a(),S=i("p"),S.innerHTML=vl,Qe=a(),Y=i("ol"),Y.innerHTML=gl,$e=a(),q=i("p"),q.innerHTML=_l,We=a(),M(L.$$.fragment),Xe=a(),F=i("p"),F.innerHTML=Al,Re=a(),M(N.$$.fragment),Se=a(),P=i("p"),P.textContent=Zl,Ye=a(),M(D.$$.fragment),qe=a(),M(K.$$.fragment),Le=a(),O=i("p"),O.innerHTML=Gl,Fe=a(),ee=i("ol"),ee.innerHTML=Bl,Ne=a(),M(le.$$.fragment),Pe=a(),j=i("ol"),j.innerHTML=xl,De=a(),M(se.$$.fragment),Ke=a(),T=i("ol"),T.innerHTML=kl,Oe=a(),M(te.$$.fragment),el=a(),ae=i("p"),ae.textContent=Vl,ll=a(),M(ne.$$.fragment),sl=a(),ie=i("p"),ie.textContent=Hl,tl=a(),oe=i("table"),oe.innerHTML=El,al=a(),M(re.$$.fragment),nl=a(),de=i("p"),this.h()},l(e){const l=Sl("svelte-u9bgzb",document.head);h=o(l,"META",{name:!0,content:!0}),l.forEach(s),ue=n(e),pe=o(e,"P",{}),zl(pe).forEach(s),ce=n(e),p(J.$$.fragment,e),me=n(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-mirtrh"&&(w.innerHTML=Ml),ye=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-lch9h7"&&(U.textContent=pl),he=n(e),b=o(e,"OL",{"data-svelte-h":!0}),r(b)!=="svelte-dkr6ay"&&(b.innerHTML=dl),je=n(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1m2dv"&&(f.textContent=ul),Te=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-fsxn6a"&&(I.innerHTML=cl),Je=n(e),p(C.$$.fragment,e),we=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1qdxn8o"&&(v.innerHTML=ml),Ue=n(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1mpuo70"&&(g.textContent=yl),be=n(e),p(_.$$.fragment,e),fe=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1qkz3sm"&&(A.innerHTML=hl),Ie=n(e),p(Z.$$.fragment,e),Ce=n(e),p(G.$$.fragment,e),ve=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1dt02hs"&&(B.innerHTML=jl),ge=n(e),p(x.$$.fragment,e),_e=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-u256fg"&&(k.innerHTML=Tl),Ae=n(e),p(V.$$.fragment,e),Ze=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-5vkp22"&&(H.innerHTML=Jl),Ge=n(e),E=o(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-13keayf"&&(E.innerHTML=wl),Be=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1rvzx3t"&&(z.textContent=Ul),xe=n(e),Q=o(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-4xb4sl"&&(Q.innerHTML=bl),ke=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-36ifoq"&&($.innerHTML=fl),Ve=n(e),p(W.$$.fragment,e),He=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1712uhi"&&(X.innerHTML=Il),Ee=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-q1s7fi"&&(R.innerHTML=Cl),ze=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-156tn70"&&(S.innerHTML=vl),Qe=n(e),Y=o(e,"OL",{"data-svelte-h":!0}),r(Y)!=="svelte-c9ymwk"&&(Y.innerHTML=gl),$e=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1h46380"&&(q.innerHTML=_l),We=n(e),p(L.$$.fragment,e),Xe=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-rzlgnm"&&(F.innerHTML=Al),Re=n(e),p(N.$$.fragment,e),Se=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1qhg0n9"&&(P.textContent=Zl),Ye=n(e),p(D.$$.fragment,e),qe=n(e),p(K.$$.fragment,e),Le=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-15qqbl2"&&(O.innerHTML=Gl),Fe=n(e),ee=o(e,"OL",{"data-svelte-h":!0}),r(ee)!=="svelte-r5vsjg"&&(ee.innerHTML=Bl),Ne=n(e),p(le.$$.fragment,e),Pe=n(e),j=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(j)!=="svelte-1ue2kw7"&&(j.innerHTML=xl),De=n(e),p(se.$$.fragment,e),Ke=n(e),T=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(T)!=="svelte-1ntce4z"&&(T.innerHTML=kl),Oe=n(e),p(te.$$.fragment,e),el=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-gfrff"&&(ae.textContent=Vl),ll=n(e),p(ne.$$.fragment,e),sl=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-7eam1e"&&(ie.textContent=Hl),tl=n(e),oe=o(e,"TABLE",{"data-svelte-h":!0}),r(oe)!=="svelte-ybnuf2"&&(oe.innerHTML=El),al=n(e),p(re.$$.fragment,e),nl=n(e),de=o(e,"P",{}),zl(de).forEach(s),this.h()},h(){ol(h,"name","hf:doc:metadata"),ol(h,"content",Fl),ol(j,"start","2"),ol(T,"start","3")},m(e,l){Yl(document.head,h),t(e,ue,l),t(e,pe,l),t(e,ce,l),d(J,e,l),t(e,me,l),t(e,w,l),t(e,ye,l),t(e,U,l),t(e,he,l),t(e,b,l),t(e,je,l),t(e,f,l),t(e,Te,l),t(e,I,l),t(e,Je,l),d(C,e,l),t(e,we,l),t(e,v,l),t(e,Ue,l),t(e,g,l),t(e,be,l),d(_,e,l),t(e,fe,l),t(e,A,l),t(e,Ie,l),d(Z,e,l),t(e,Ce,l),d(G,e,l),t(e,ve,l),t(e,B,l),t(e,ge,l),d(x,e,l),t(e,_e,l),t(e,k,l),t(e,Ae,l),d(V,e,l),t(e,Ze,l),t(e,H,l),t(e,Ge,l),t(e,E,l),t(e,Be,l),t(e,z,l),t(e,xe,l),t(e,Q,l),t(e,ke,l),t(e,$,l),t(e,Ve,l),d(W,e,l),t(e,He,l),t(e,X,l),t(e,Ee,l),t(e,R,l),t(e,ze,l),t(e,S,l),t(e,Qe,l),t(e,Y,l),t(e,$e,l),t(e,q,l),t(e,We,l),d(L,e,l),t(e,Xe,l),t(e,F,l),t(e,Re,l),d(N,e,l),t(e,Se,l),t(e,P,l),t(e,Ye,l),d(D,e,l),t(e,qe,l),d(K,e,l),t(e,Le,l),t(e,O,l),t(e,Fe,l),t(e,ee,l),t(e,Ne,l),d(le,e,l),t(e,Pe,l),t(e,j,l),t(e,De,l),d(se,e,l),t(e,Ke,l),t(e,T,l),t(e,Oe,l),d(te,e,l),t(e,el,l),t(e,ae,l),t(e,ll,l),d(ne,e,l),t(e,sl,l),t(e,ie,l),t(e,tl,l),t(e,oe,l),t(e,al,l),d(re,e,l),t(e,nl,l),t(e,de,l),il=!0},p:$l,i(e){il||(u(J.$$.fragment,e),u(C.$$.fragment,e),u(_.$$.fragment,e),u(Z.$$.fragment,e),u(G.$$.fragment,e),u(x.$$.fragment,e),u(V.$$.fragment,e),u(W.$$.fragment,e),u(L.$$.fragment,e),u(N.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(re.$$.fragment,e),il=!0)},o(e){c(J.$$.fragment,e),c(C.$$.fragment,e),c(_.$$.fragment,e),c(Z.$$.fragment,e),c(G.$$.fragment,e),c(x.$$.fragment,e),c(V.$$.fragment,e),c(W.$$.fragment,e),c(L.$$.fragment,e),c(N.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(re.$$.fragment,e),il=!1},d(e){e&&(s(ue),s(pe),s(ce),s(me),s(w),s(ye),s(U),s(he),s(b),s(je),s(f),s(Te),s(I),s(Je),s(we),s(v),s(Ue),s(g),s(be),s(fe),s(A),s(Ie),s(Ce),s(ve),s(B),s(ge),s(_e),s(k),s(Ae),s(Ze),s(H),s(Ge),s(E),s(Be),s(z),s(xe),s(Q),s(ke),s($),s(Ve),s(He),s(X),s(Ee),s(R),s(ze),s(S),s(Qe),s(Y),s($e),s(q),s(We),s(Xe),s(F),s(Re),s(Se),s(P),s(Ye),s(qe),s(Le),s(O),s(Fe),s(ee),s(Ne),s(Pe),s(j),s(De),s(Ke),s(T),s(Oe),s(el),s(ae),s(ll),s(sl),s(ie),s(tl),s(oe),s(al),s(nl),s(de)),s(h),m(J,e),m(C,e),m(_,e),m(Z,e),m(G,e),m(x,e),m(V,e),m(W,e),m(L,e),m(N,e),m(D,e),m(K,e),m(le,e),m(se,e),m(te,e),m(ne,e),m(re,e)}}}const Fl='{"title":"Intégrez votre framework de ML avec le Hub","local":"intégrez-votre-framework-de-ml-avec-le-hub","sections":[{"title":"Une approche flexible: les helpers","local":"une-approche-flexible-les-helpers","sections":[{"title":"from_pretrained","local":"frompretrained","sections":[],"depth":3},{"title":"push_to_hub","local":"pushtohub","sections":[],"depth":3},{"title":"Limitations","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"Une approche plus complexe: l’héritage de classe","local":"une-approche-plus-complexe-lhéritage-de-classe","sections":[{"title":"Un exemple concret: PyTorch","local":"un-exemple-concret-pytorch","sections":[{"title":"Comment l’utiliser ?","local":"comment-lutiliser-","sections":[],"depth":4},{"title":"Implémentation","local":"implémentation","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Comparaison","local":"comparaison","sections":[],"depth":2}],"depth":1}';function Nl(rl){return Wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class es extends Xl{constructor(h){super(),Rl(this,h,Nl,Ll,Ql,{})}}export{es as component};
