import{s as od,n as sd,o as ad}from"../chunks/scheduler.b108d059.js";import{S as nd,i as cd,g as d,s as r,r as c,A as pd,h as o,f as t,c as u,j as n,u as p,x as s,k as a,y as hd,a as l,v as h,d as f,t as m,w as T}from"../chunks/index.008de539.js";import{H as $}from"../chunks/Heading.88bfeb84.js";function fd(Gr){let _,qt,Qt,Et,y,Rt,k,It,L,Jr="Custom data structures.",gt,v,Or=`These are only used internally, meaning an end-user shouldn’t
need to access anything here.`,zt,x,Xr='<li><a href="#module_utils/data-structures">utils/data-structures</a><ul><li><em>static</em><ul><li><a href="#module_utils/data-structures.PriorityQueue">.PriorityQueue</a><ul><li><a href="#new_module_utils/data-structures.PriorityQueue_new"><code>new PriorityQueue(comparator)</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+size"><code>.size</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+isEmpty"><code>.isEmpty()</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+peek"><code>.peek()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+push"><code>.push(...values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+extend"><code>.extend(values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+pop"><code>.pop()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+replace"><code>.replace(value)</code></a> ⇒ <code>*</code></li></ul></li> <li><a href="#module_utils/data-structures.CharTrie">.CharTrie</a><ul><li><a href="#module_utils/data-structures.CharTrie+extend"><code>.extend(texts)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+push"><code>.push(text)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+commonPrefixSearch"><code>.commonPrefixSearch(text)</code></a></li></ul></li> <li><a href="#module_utils/data-structures.TokenLattice">.TokenLattice</a><ul><li><a href="#new_module_utils/data-structures.TokenLattice_new"><code>new TokenLattice(sentence, bosTokenId, eosTokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+insert"><code>.insert(pos, length, score, tokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+viterbi"><code>.viterbi()</code></a> ⇒ <code>Array.&lt;TokenLatticeNode&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+piece"><code>.piece(node)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokens"><code>.tokens()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokenIds"><code>.tokenIds()</code></a> ⇒ <code>Array</code></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/data-structures..CharTrieNode">~CharTrieNode</a><ul><li><a href="#new_module_utils/data-structures..CharTrieNode_new"><code>new CharTrieNode(isLeaf, children)</code></a></li> <li><a href="#module_utils/data-structures..CharTrieNode.default"><code>.default()</code></a> ⇒ <code>CharTrieNode</code></li></ul></li> <li><a href="#module_utils/data-structures..TokenLatticeNode">~TokenLatticeNode</a><ul><li><a href="#new_module_utils/data-structures..TokenLatticeNode_new"><code>new TokenLatticeNode(tokenId, nodeId, pos, length, score)</code></a></li> <li><a href="#module_utils/data-structures..TokenLatticeNode+clone"><code>.clone()</code></a> ⇒ <code>TokenLatticeNode</code></li></ul></li></ul></li></ul></li>',Kt,Dt,jt,C,Bt,b,St,P,Yr=`Efficient Heap-based Implementation of a Priority Queue.
It uses an array-based binary heap, where the root is at index <code>0</code>, and the
children of node <code>i</code> are located at indices <code>2i + 1</code> and <code>2i + 2</code>, respectively.`,Ut,H,Zr="Adapted from the following sources:",Vt,w,eu='<li><a href="https://stackoverflow.com/a/42919752/13989043" rel="nofollow">https://stackoverflow.com/a/42919752/13989043</a> (original)</li> <li><a href="https://github.com/belladoreai/llama-tokenizer-js" rel="nofollow">https://github.com/belladoreai/llama-tokenizer-js</a> (minor improvements)</li>',Wt,M,tu='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Ft,A,iu='<li><a href="#module_utils/data-structures.PriorityQueue">.PriorityQueue</a><ul><li><a href="#new_module_utils/data-structures.PriorityQueue_new"><code>new PriorityQueue(comparator)</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+size"><code>.size</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+isEmpty"><code>.isEmpty()</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+peek"><code>.peek()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+push"><code>.push(...values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+extend"><code>.extend(values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+pop"><code>.pop()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+replace"><code>.replace(value)</code></a> ⇒ <code>*</code></li></ul></li>',Gt,Jt,Ot,Q,Xt,N,Yt,q,lu="Create a new PriorityQueue.",Zt,E,ru="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>comparator</td><td><code>function</code></td><td><p>Comparator function to determine priority. Defaults to a MaxHeap.</p></td></tr></tbody>",ei,ti,ii,R,li,I,ri,g,uu="The size of the queue",ui,z,du='<strong>Kind</strong>: instance property of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a>',di,oi,si,K,ai,D,ni,j,ou="Check if the queue is empty.",ci,B,su='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - <code>true</code> if the queue is empty, <code>false</code> otherwise.',pi,hi,fi,S,mi,U,Ti,V,au="Return the element with the highest priority in the queue.",$i,W,nu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>any</code> - The highest priority element in the queue.',_i,yi,ki,F,Li,G,vi,J,cu="Add one or more elements to the queue.",xi,O,pu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>number</code> - The new size of the queue.',Ci,X,hu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...values</td><td><code>any</code></td><td><p>The values to push into the queue.</p></td></tr></tbody>",bi,Pi,Hi,Y,wi,Z,Mi,ee,fu="Add multiple elements to the queue.",Ai,te,mu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>number</code> - The new size of the queue.',Qi,ie,Tu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>values</td><td><code>Array.&lt;any&gt;</code></td><td><p>The values to push into the queue.</p></td></tr></tbody>",Ni,qi,Ei,le,Ri,re,Ii,ue,$u="Remove and return the element with the highest priority in the queue.",gi,de,_u='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>any</code> - The element with the highest priority in the queue.',zi,Ki,Di,oe,ji,se,Bi,ae,yu="Replace the element with the highest priority in the queue with a new value.",Si,ne,ku='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>*</code> - The replaced value.',Ui,ce,Lu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>value</td><td><code>*</code></td><td><p>The new value.</p></td></tr></tbody>",Vi,Wi,Fi,pe,Gi,he,Ji,fe,vu="A trie structure to efficiently store and search for strings.",Oi,me,xu='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Xi,Te,Cu='<li><a href="#module_utils/data-structures.CharTrie">.CharTrie</a><ul><li><a href="#module_utils/data-structures.CharTrie+extend"><code>.extend(texts)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+push"><code>.push(text)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+commonPrefixSearch"><code>.commonPrefixSearch(text)</code></a></li></ul></li>',Yi,Zi,el,$e,tl,_e,il,ye,bu="Adds one or more <code>texts</code> to the trie.",ll,ke,Pu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',rl,Le,Hu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>Array.&lt;string&gt;</code></td><td><p>The strings to add to the trie.</p></td></tr></tbody>",ul,dl,ol,ve,sl,xe,al,Ce,wu="Adds text to the trie.",nl,be,Mu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',cl,Pe,Au="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>text</td><td><code>string</code></td><td><p>The string to add to the trie.</p></td></tr></tbody>",pl,hl,fl,He,ml,we,Tl,Me,Qu="Searches the trie for all strings with a common prefix of <code>text</code>.",$l,Ae,Nu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',_l,Qe,qu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>text</td><td><code>string</code></td><td><p>The common prefix to search for.</p></td></tr></tbody>",yl,kl,Ll,Ne,vl,qe,xl,Ee,Eu="A lattice data structure to be used for tokenization.",Cl,Re,Ru='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',bl,Ie,Iu='<li><a href="#module_utils/data-structures.TokenLattice">.TokenLattice</a><ul><li><a href="#new_module_utils/data-structures.TokenLattice_new"><code>new TokenLattice(sentence, bosTokenId, eosTokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+insert"><code>.insert(pos, length, score, tokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+viterbi"><code>.viterbi()</code></a> ⇒ <code>Array.&lt;TokenLatticeNode&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+piece"><code>.piece(node)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokens"><code>.tokens()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokenIds"><code>.tokenIds()</code></a> ⇒ <code>Array</code></li></ul></li>',Pl,Hl,wl,ge,Ml,ze,Al,Ke,gu="Creates a new TokenLattice instance.",Ql,De,zu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>sentence</td><td><code>string</code></td><td><p>The input sentence to be tokenized.</p></td> </tr><tr><td>bosTokenId</td><td><code>number</code></td><td><p>The beginning-of-sequence token ID.</p></td> </tr><tr><td>eosTokenId</td><td><code>number</code></td><td><p>The end-of-sequence token ID.</p></td></tr></tbody>",Nl,ql,El,je,Rl,Be,Il,Se,Ku="Inserts a new token node into the token lattice.",gl,Ue,Du='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a>',zl,Ve,ju="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pos</td><td><code>number</code></td><td><p>The starting position of the token.</p></td> </tr><tr><td>length</td><td><code>number</code></td><td><p>The length of the token.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score of the token.</p></td> </tr><tr><td>tokenId</td><td><code>number</code></td><td><p>The token ID of the token.</p></td></tr></tbody>",Kl,Dl,jl,We,Bl,Fe,Sl,Ge,Bu="Implements the Viterbi algorithm to compute the most likely sequence of tokens.",Ul,Je,Su='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;TokenLatticeNode&gt;</code> - The array of nodes representing the most likely sequence of tokens.',Vl,Wl,Fl,Oe,Gl,Xe,Jl,Ye,Uu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>string</code> - The array of nodes representing the most likely sequence of tokens.',Ol,Ze,Vu="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>node</td><td><code>TokenLatticeNode</code></td></tr></tbody>",Xl,Yl,Zl,et,er,tt,tr,it,Wu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array</code> - The array of nodes representing the most likely sequence of tokens.',ir,lr,rr,lt,ur,rt,dr,ut,Fu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array</code> - The array of nodes representing the most likely sequence of tokens.',or,sr,ar,dt,nr,ot,cr,st,Gu="Represents a node in a character trie.",pr,at,Ju='<strong>Kind</strong>: inner class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',hr,nt,Ou='<li><a href="#module_utils/data-structures..CharTrieNode">~CharTrieNode</a><ul><li><a href="#new_module_utils/data-structures..CharTrieNode_new"><code>new CharTrieNode(isLeaf, children)</code></a></li> <li><a href="#module_utils/data-structures..CharTrieNode.default"><code>.default()</code></a> ⇒ <code>CharTrieNode</code></li></ul></li>',fr,mr,Tr,ct,$r,pt,_r,ht,Xu="Create a new CharTrieNode.",yr,ft,Yu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>isLeaf</td><td><code>boolean</code></td><td><p>Whether the node is a leaf node or not.</p></td> </tr><tr><td>children</td><td><code>Map.&lt;string, CharTrieNode&gt;</code></td><td><p>A map containing the node&#39;s children, where the key is a character and the value is a <code>CharTrieNode</code>.</p></td></tr></tbody>",kr,Lr,vr,mt,xr,Tt,Cr,$t,Zu="Returns a new <code>CharTrieNode</code> instance with default values.",br,_t,ed='<strong>Kind</strong>: static method of <a href="#module_utils/data-structures..CharTrieNode"><code>CharTrieNode</code></a><br/> <strong>Returns</strong>: <code>CharTrieNode</code> - A new <code>CharTrieNode</code> instance with <code>isLeaf</code> set to <code>false</code> and an empty <code>children</code> map.',Pr,Hr,wr,yt,Mr,kt,Ar,Lt,td='<strong>Kind</strong>: inner class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Qr,vt,id='<li><a href="#module_utils/data-structures..TokenLatticeNode">~TokenLatticeNode</a><ul><li><a href="#new_module_utils/data-structures..TokenLatticeNode_new"><code>new TokenLatticeNode(tokenId, nodeId, pos, length, score)</code></a></li> <li><a href="#module_utils/data-structures..TokenLatticeNode+clone"><code>.clone()</code></a> ⇒ <code>TokenLatticeNode</code></li></ul></li>',Nr,qr,Er,xt,Rr,Ct,Ir,bt,ld="Represents a node in a token lattice for a given sentence.",gr,Pt,rd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tokenId</td><td><code>number</code></td><td><p>The ID of the token associated with this node.</p></td> </tr><tr><td>nodeId</td><td><code>number</code></td><td><p>The ID of this node.</p></td> </tr><tr><td>pos</td><td><code>number</code></td><td><p>The starting position of the token in the sentence.</p></td> </tr><tr><td>length</td><td><code>number</code></td><td><p>The length of the token.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score associated with the token.</p></td></tr></tbody>",zr,Kr,Dr,Ht,jr,wt,Br,Mt,ud="Returns a clone of this node.",Sr,At,dd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures..TokenLatticeNode"><code>TokenLatticeNode</code></a><br/> <strong>Returns</strong>: <code>TokenLatticeNode</code> - A clone of this node.',Ur,Vr,Wr,Nt,Fr;return k=new $({props:{title:"utils/data-structures",local:"utilsdata-structures",headingTag:"h1"}}),b=new $({props:{title:"utils/data-structures.PriorityQueue",local:"utilsdata-structurespriorityqueue",headingTag:"h2"}}),N=new $({props:{title:"new PriorityQueue(comparator)",local:"new-priorityqueuecomparator",headingTag:"h3"}}),I=new $({props:{title:"priorityQueue.size",local:"priorityqueuesize",headingTag:"h3"}}),D=new $({props:{title:"priorityQueue.isEmpty() ⇒ <code> boolean </code>",local:"priorityqueueisempty--code-boolean-code",headingTag:"h3"}}),U=new $({props:{title:"priorityQueue.peek() ⇒ <code> any </code>",local:"priorityqueuepeek--code-any-code",headingTag:"h3"}}),G=new $({props:{title:"priorityQueue.push(...values) ⇒ <code> number </code>",local:"priorityqueuepushvalues--code-number-code",headingTag:"h3"}}),Z=new $({props:{title:"priorityQueue.extend(values) ⇒ <code> number </code>",local:"priorityqueueextendvalues--code-number-code",headingTag:"h3"}}),re=new $({props:{title:"priorityQueue.pop() ⇒ <code> any </code>",local:"priorityqueuepop--code-any-code",headingTag:"h3"}}),se=new $({props:{title:"priorityQueue.replace(value) ⇒ <code> * </code>",local:"priorityqueuereplacevalue--code--code",headingTag:"h3"}}),he=new $({props:{title:"utils/data-structures.CharTrie",local:"utilsdata-structureschartrie",headingTag:"h2"}}),_e=new $({props:{title:"charTrie.extend(texts)",local:"chartrieextendtexts",headingTag:"h3"}}),xe=new $({props:{title:"charTrie.push(text)",local:"chartriepushtext",headingTag:"h3"}}),we=new $({props:{title:"charTrie.commonPrefixSearch(text)",local:"chartriecommonprefixsearchtext",headingTag:"h3"}}),qe=new $({props:{title:"utils/data-structures.TokenLattice",local:"utilsdata-structurestokenlattice",headingTag:"h2"}}),ze=new $({props:{title:"new TokenLattice(sentence, bosTokenId, eosTokenId)",local:"new-tokenlatticesentence-bostokenid-eostokenid",headingTag:"h3"}}),Be=new $({props:{title:"tokenLattice.insert(pos, length, score, tokenId)",local:"tokenlatticeinsertpos-length-score-tokenid",headingTag:"h3"}}),Fe=new $({props:{title:"tokenLattice.viterbi() ⇒ <code> Array. < TokenLatticeNode > </code>",local:"tokenlatticeviterbi--code-array--tokenlatticenode--code",headingTag:"h3"}}),Xe=new $({props:{title:"tokenLattice.piece(node) ⇒ <code> string </code>",local:"tokenlatticepiecenode--code-string-code",headingTag:"h3"}}),tt=new $({props:{title:"tokenLattice.tokens() ⇒ <code> Array </code>",local:"tokenlatticetokens--code-array-code",headingTag:"h3"}}),rt=new $({props:{title:"tokenLattice.tokenIds() ⇒ <code> Array </code>",local:"tokenlatticetokenids--code-array-code",headingTag:"h3"}}),ot=new $({props:{title:"utils/data-structures~CharTrieNode",local:"utilsdata-structureschartrienode",headingTag:"h2"}}),pt=new $({props:{title:"new CharTrieNode(isLeaf, children)",local:"new-chartrienodeisleaf-children",headingTag:"h3"}}),Tt=new $({props:{title:"CharTrieNode.default() ⇒ <code> CharTrieNode </code>",local:"chartrienodedefault--code-chartrienode-code",headingTag:"h3"}}),kt=new $({props:{title:"utils/data-structures~TokenLatticeNode",local:"utilsdata-structurestokenlatticenode",headingTag:"h2"}}),Ct=new $({props:{title:"new TokenLatticeNode(tokenId, nodeId, pos, length, score)",local:"new-tokenlatticenodetokenid-nodeid-pos-length-score",headingTag:"h3"}}),wt=new $({props:{title:"tokenLatticeNode.clone() ⇒ <code> TokenLatticeNode </code>",local:"tokenlatticenodeclone--code-tokenlatticenode-code",headingTag:"h3"}}),{c(){_=d("meta"),qt=r(),Qt=d("p"),Et=r(),y=d("a"),Rt=r(),c(k.$$.fragment),It=r(),L=d("p"),L.textContent=Jr,gt=r(),v=d("p"),v.textContent=Or,zt=r(),x=d("ul"),x.innerHTML=Xr,Kt=r(),Dt=d("hr"),jt=r(),C=d("a"),Bt=r(),c(b.$$.fragment),St=r(),P=d("p"),P.innerHTML=Yr,Ut=r(),H=d("p"),H.textContent=Zr,Vt=r(),w=d("ul"),w.innerHTML=eu,Wt=r(),M=d("p"),M.innerHTML=tu,Ft=r(),A=d("ul"),A.innerHTML=iu,Gt=r(),Jt=d("hr"),Ot=r(),Q=d("a"),Xt=r(),c(N.$$.fragment),Yt=r(),q=d("p"),q.textContent=lu,Zt=r(),E=d("table"),E.innerHTML=ru,ei=r(),ti=d("hr"),ii=r(),R=d("a"),li=r(),c(I.$$.fragment),ri=r(),g=d("p"),g.textContent=uu,ui=r(),z=d("p"),z.innerHTML=du,di=r(),oi=d("hr"),si=r(),K=d("a"),ai=r(),c(D.$$.fragment),ni=r(),j=d("p"),j.textContent=ou,ci=r(),B=d("p"),B.innerHTML=su,pi=r(),hi=d("hr"),fi=r(),S=d("a"),mi=r(),c(U.$$.fragment),Ti=r(),V=d("p"),V.textContent=au,$i=r(),W=d("p"),W.innerHTML=nu,_i=r(),yi=d("hr"),ki=r(),F=d("a"),Li=r(),c(G.$$.fragment),vi=r(),J=d("p"),J.textContent=cu,xi=r(),O=d("p"),O.innerHTML=pu,Ci=r(),X=d("table"),X.innerHTML=hu,bi=r(),Pi=d("hr"),Hi=r(),Y=d("a"),wi=r(),c(Z.$$.fragment),Mi=r(),ee=d("p"),ee.textContent=fu,Ai=r(),te=d("p"),te.innerHTML=mu,Qi=r(),ie=d("table"),ie.innerHTML=Tu,Ni=r(),qi=d("hr"),Ei=r(),le=d("a"),Ri=r(),c(re.$$.fragment),Ii=r(),ue=d("p"),ue.textContent=$u,gi=r(),de=d("p"),de.innerHTML=_u,zi=r(),Ki=d("hr"),Di=r(),oe=d("a"),ji=r(),c(se.$$.fragment),Bi=r(),ae=d("p"),ae.textContent=yu,Si=r(),ne=d("p"),ne.innerHTML=ku,Ui=r(),ce=d("table"),ce.innerHTML=Lu,Vi=r(),Wi=d("hr"),Fi=r(),pe=d("a"),Gi=r(),c(he.$$.fragment),Ji=r(),fe=d("p"),fe.textContent=vu,Oi=r(),me=d("p"),me.innerHTML=xu,Xi=r(),Te=d("ul"),Te.innerHTML=Cu,Yi=r(),Zi=d("hr"),el=r(),$e=d("a"),tl=r(),c(_e.$$.fragment),il=r(),ye=d("p"),ye.innerHTML=bu,ll=r(),ke=d("p"),ke.innerHTML=Pu,rl=r(),Le=d("table"),Le.innerHTML=Hu,ul=r(),dl=d("hr"),ol=r(),ve=d("a"),sl=r(),c(xe.$$.fragment),al=r(),Ce=d("p"),Ce.textContent=wu,nl=r(),be=d("p"),be.innerHTML=Mu,cl=r(),Pe=d("table"),Pe.innerHTML=Au,pl=r(),hl=d("hr"),fl=r(),He=d("a"),ml=r(),c(we.$$.fragment),Tl=r(),Me=d("p"),Me.innerHTML=Qu,$l=r(),Ae=d("p"),Ae.innerHTML=Nu,_l=r(),Qe=d("table"),Qe.innerHTML=qu,yl=r(),kl=d("hr"),Ll=r(),Ne=d("a"),vl=r(),c(qe.$$.fragment),xl=r(),Ee=d("p"),Ee.textContent=Eu,Cl=r(),Re=d("p"),Re.innerHTML=Ru,bl=r(),Ie=d("ul"),Ie.innerHTML=Iu,Pl=r(),Hl=d("hr"),wl=r(),ge=d("a"),Ml=r(),c(ze.$$.fragment),Al=r(),Ke=d("p"),Ke.textContent=gu,Ql=r(),De=d("table"),De.innerHTML=zu,Nl=r(),ql=d("hr"),El=r(),je=d("a"),Rl=r(),c(Be.$$.fragment),Il=r(),Se=d("p"),Se.textContent=Ku,gl=r(),Ue=d("p"),Ue.innerHTML=Du,zl=r(),Ve=d("table"),Ve.innerHTML=ju,Kl=r(),Dl=d("hr"),jl=r(),We=d("a"),Bl=r(),c(Fe.$$.fragment),Sl=r(),Ge=d("p"),Ge.textContent=Bu,Ul=r(),Je=d("p"),Je.innerHTML=Su,Vl=r(),Wl=d("hr"),Fl=r(),Oe=d("a"),Gl=r(),c(Xe.$$.fragment),Jl=r(),Ye=d("p"),Ye.innerHTML=Uu,Ol=r(),Ze=d("table"),Ze.innerHTML=Vu,Xl=r(),Yl=d("hr"),Zl=r(),et=d("a"),er=r(),c(tt.$$.fragment),tr=r(),it=d("p"),it.innerHTML=Wu,ir=r(),lr=d("hr"),rr=r(),lt=d("a"),ur=r(),c(rt.$$.fragment),dr=r(),ut=d("p"),ut.innerHTML=Fu,or=r(),sr=d("hr"),ar=r(),dt=d("a"),nr=r(),c(ot.$$.fragment),cr=r(),st=d("p"),st.textContent=Gu,pr=r(),at=d("p"),at.innerHTML=Ju,hr=r(),nt=d("ul"),nt.innerHTML=Ou,fr=r(),mr=d("hr"),Tr=r(),ct=d("a"),$r=r(),c(pt.$$.fragment),_r=r(),ht=d("p"),ht.textContent=Xu,yr=r(),ft=d("table"),ft.innerHTML=Yu,kr=r(),Lr=d("hr"),vr=r(),mt=d("a"),xr=r(),c(Tt.$$.fragment),Cr=r(),$t=d("p"),$t.innerHTML=Zu,br=r(),_t=d("p"),_t.innerHTML=ed,Pr=r(),Hr=d("hr"),wr=r(),yt=d("a"),Mr=r(),c(kt.$$.fragment),Ar=r(),Lt=d("p"),Lt.innerHTML=td,Qr=r(),vt=d("ul"),vt.innerHTML=id,Nr=r(),qr=d("hr"),Er=r(),xt=d("a"),Rr=r(),c(Ct.$$.fragment),Ir=r(),bt=d("p"),bt.textContent=ld,gr=r(),Pt=d("table"),Pt.innerHTML=rd,zr=r(),Kr=d("hr"),Dr=r(),Ht=d("a"),jr=r(),c(wt.$$.fragment),Br=r(),Mt=d("p"),Mt.textContent=ud,Sr=r(),At=d("p"),At.innerHTML=dd,Ur=r(),Vr=d("hr"),Wr=r(),Nt=d("p"),this.h()},l(e){const i=pd("svelte-u9bgzb",document.head);_=o(i,"META",{name:!0,content:!0}),i.forEach(t),qt=u(e),Qt=o(e,"P",{}),n(Qt).forEach(t),Et=u(e),y=o(e,"A",{id:!0,class:!0}),n(y).forEach(t),Rt=u(e),p(k.$$.fragment,e),It=u(e),L=o(e,"P",{"data-svelte-h":!0}),s(L)!=="svelte-1aeeeid"&&(L.textContent=Jr),gt=u(e),v=o(e,"P",{"data-svelte-h":!0}),s(v)!=="svelte-1r3ntfo"&&(v.textContent=Or),zt=u(e),x=o(e,"UL",{"data-svelte-h":!0}),s(x)!=="svelte-j4gs7t"&&(x.innerHTML=Xr),Kt=u(e),Dt=o(e,"HR",{}),jt=u(e),C=o(e,"A",{id:!0,class:!0}),n(C).forEach(t),Bt=u(e),p(b.$$.fragment,e),St=u(e),P=o(e,"P",{"data-svelte-h":!0}),s(P)!=="svelte-1ux83uj"&&(P.innerHTML=Yr),Ut=u(e),H=o(e,"P",{"data-svelte-h":!0}),s(H)!=="svelte-vi2pz9"&&(H.textContent=Zr),Vt=u(e),w=o(e,"UL",{"data-svelte-h":!0}),s(w)!=="svelte-qlvgg9"&&(w.innerHTML=eu),Wt=u(e),M=o(e,"P",{"data-svelte-h":!0}),s(M)!=="svelte-1saulos"&&(M.innerHTML=tu),Ft=u(e),A=o(e,"UL",{"data-svelte-h":!0}),s(A)!=="svelte-1306bmq"&&(A.innerHTML=iu),Gt=u(e),Jt=o(e,"HR",{}),Ot=u(e),Q=o(e,"A",{id:!0,class:!0}),n(Q).forEach(t),Xt=u(e),p(N.$$.fragment,e),Yt=u(e),q=o(e,"P",{"data-svelte-h":!0}),s(q)!=="svelte-1dgukb8"&&(q.textContent=lu),Zt=u(e),E=o(e,"TABLE",{"data-svelte-h":!0}),s(E)!=="svelte-15lsmj7"&&(E.innerHTML=ru),ei=u(e),ti=o(e,"HR",{}),ii=u(e),R=o(e,"A",{id:!0,class:!0}),n(R).forEach(t),li=u(e),p(I.$$.fragment,e),ri=u(e),g=o(e,"P",{"data-svelte-h":!0}),s(g)!=="svelte-19ll7y9"&&(g.textContent=uu),ui=u(e),z=o(e,"P",{"data-svelte-h":!0}),s(z)!=="svelte-1spompf"&&(z.innerHTML=du),di=u(e),oi=o(e,"HR",{}),si=u(e),K=o(e,"A",{id:!0,class:!0}),n(K).forEach(t),ai=u(e),p(D.$$.fragment,e),ni=u(e),j=o(e,"P",{"data-svelte-h":!0}),s(j)!=="svelte-iwo0ja"&&(j.textContent=ou),ci=u(e),B=o(e,"P",{"data-svelte-h":!0}),s(B)!=="svelte-usw3zo"&&(B.innerHTML=su),pi=u(e),hi=o(e,"HR",{}),fi=u(e),S=o(e,"A",{id:!0,class:!0}),n(S).forEach(t),mi=u(e),p(U.$$.fragment,e),Ti=u(e),V=o(e,"P",{"data-svelte-h":!0}),s(V)!=="svelte-1g38rzl"&&(V.textContent=au),$i=u(e),W=o(e,"P",{"data-svelte-h":!0}),s(W)!=="svelte-1jn2os3"&&(W.innerHTML=nu),_i=u(e),yi=o(e,"HR",{}),ki=u(e),F=o(e,"A",{id:!0,class:!0}),n(F).forEach(t),Li=u(e),p(G.$$.fragment,e),vi=u(e),J=o(e,"P",{"data-svelte-h":!0}),s(J)!=="svelte-1o3p42d"&&(J.textContent=cu),xi=u(e),O=o(e,"P",{"data-svelte-h":!0}),s(O)!=="svelte-1hty3q7"&&(O.innerHTML=pu),Ci=u(e),X=o(e,"TABLE",{"data-svelte-h":!0}),s(X)!=="svelte-19plha1"&&(X.innerHTML=hu),bi=u(e),Pi=o(e,"HR",{}),Hi=u(e),Y=o(e,"A",{id:!0,class:!0}),n(Y).forEach(t),wi=u(e),p(Z.$$.fragment,e),Mi=u(e),ee=o(e,"P",{"data-svelte-h":!0}),s(ee)!=="svelte-1rf8gmz"&&(ee.textContent=fu),Ai=u(e),te=o(e,"P",{"data-svelte-h":!0}),s(te)!=="svelte-1hty3q7"&&(te.innerHTML=mu),Qi=u(e),ie=o(e,"TABLE",{"data-svelte-h":!0}),s(ie)!=="svelte-txh99d"&&(ie.innerHTML=Tu),Ni=u(e),qi=o(e,"HR",{}),Ei=u(e),le=o(e,"A",{id:!0,class:!0}),n(le).forEach(t),Ri=u(e),p(re.$$.fragment,e),Ii=u(e),ue=o(e,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-1l3oksc"&&(ue.textContent=$u),gi=u(e),de=o(e,"P",{"data-svelte-h":!0}),s(de)!=="svelte-vpswb8"&&(de.innerHTML=_u),zi=u(e),Ki=o(e,"HR",{}),Di=u(e),oe=o(e,"A",{id:!0,class:!0}),n(oe).forEach(t),ji=u(e),p(se.$$.fragment,e),Bi=u(e),ae=o(e,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-7s4t0d"&&(ae.textContent=yu),Si=u(e),ne=o(e,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-ckytvb"&&(ne.innerHTML=ku),Ui=u(e),ce=o(e,"TABLE",{"data-svelte-h":!0}),s(ce)!=="svelte-1xv2m9q"&&(ce.innerHTML=Lu),Vi=u(e),Wi=o(e,"HR",{}),Fi=u(e),pe=o(e,"A",{id:!0,class:!0}),n(pe).forEach(t),Gi=u(e),p(he.$$.fragment,e),Ji=u(e),fe=o(e,"P",{"data-svelte-h":!0}),s(fe)!=="svelte-nklgrc"&&(fe.textContent=vu),Oi=u(e),me=o(e,"P",{"data-svelte-h":!0}),s(me)!=="svelte-1saulos"&&(me.innerHTML=xu),Xi=u(e),Te=o(e,"UL",{"data-svelte-h":!0}),s(Te)!=="svelte-1yt2jf0"&&(Te.innerHTML=Cu),Yi=u(e),Zi=o(e,"HR",{}),el=u(e),$e=o(e,"A",{id:!0,class:!0}),n($e).forEach(t),tl=u(e),p(_e.$$.fragment,e),il=u(e),ye=o(e,"P",{"data-svelte-h":!0}),s(ye)!=="svelte-moeq8l"&&(ye.innerHTML=bu),ll=u(e),ke=o(e,"P",{"data-svelte-h":!0}),s(ke)!=="svelte-33rax3"&&(ke.innerHTML=Pu),rl=u(e),Le=o(e,"TABLE",{"data-svelte-h":!0}),s(Le)!=="svelte-18dtsnv"&&(Le.innerHTML=Hu),ul=u(e),dl=o(e,"HR",{}),ol=u(e),ve=o(e,"A",{id:!0,class:!0}),n(ve).forEach(t),sl=u(e),p(xe.$$.fragment,e),al=u(e),Ce=o(e,"P",{"data-svelte-h":!0}),s(Ce)!=="svelte-4q846v"&&(Ce.textContent=wu),nl=u(e),be=o(e,"P",{"data-svelte-h":!0}),s(be)!=="svelte-33rax3"&&(be.innerHTML=Mu),cl=u(e),Pe=o(e,"TABLE",{"data-svelte-h":!0}),s(Pe)!=="svelte-hqwgb9"&&(Pe.innerHTML=Au),pl=u(e),hl=o(e,"HR",{}),fl=u(e),He=o(e,"A",{id:!0,class:!0}),n(He).forEach(t),ml=u(e),p(we.$$.fragment,e),Tl=u(e),Me=o(e,"P",{"data-svelte-h":!0}),s(Me)!=="svelte-bmaw98"&&(Me.innerHTML=Qu),$l=u(e),Ae=o(e,"P",{"data-svelte-h":!0}),s(Ae)!=="svelte-33rax3"&&(Ae.innerHTML=Nu),_l=u(e),Qe=o(e,"TABLE",{"data-svelte-h":!0}),s(Qe)!=="svelte-18qxh0x"&&(Qe.innerHTML=qu),yl=u(e),kl=o(e,"HR",{}),Ll=u(e),Ne=o(e,"A",{id:!0,class:!0}),n(Ne).forEach(t),vl=u(e),p(qe.$$.fragment,e),xl=u(e),Ee=o(e,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-1xkinx1"&&(Ee.textContent=Eu),Cl=u(e),Re=o(e,"P",{"data-svelte-h":!0}),s(Re)!=="svelte-1saulos"&&(Re.innerHTML=Ru),bl=u(e),Ie=o(e,"UL",{"data-svelte-h":!0}),s(Ie)!=="svelte-svgbr"&&(Ie.innerHTML=Iu),Pl=u(e),Hl=o(e,"HR",{}),wl=u(e),ge=o(e,"A",{id:!0,class:!0}),n(ge).forEach(t),Ml=u(e),p(ze.$$.fragment,e),Al=u(e),Ke=o(e,"P",{"data-svelte-h":!0}),s(Ke)!=="svelte-ziiz62"&&(Ke.textContent=gu),Ql=u(e),De=o(e,"TABLE",{"data-svelte-h":!0}),s(De)!=="svelte-1h8dv5n"&&(De.innerHTML=zu),Nl=u(e),ql=o(e,"HR",{}),El=u(e),je=o(e,"A",{id:!0,class:!0}),n(je).forEach(t),Rl=u(e),p(Be.$$.fragment,e),Il=u(e),Se=o(e,"P",{"data-svelte-h":!0}),s(Se)!=="svelte-1hzq3te"&&(Se.textContent=Ku),gl=u(e),Ue=o(e,"P",{"data-svelte-h":!0}),s(Ue)!=="svelte-1bjyh7n"&&(Ue.innerHTML=Du),zl=u(e),Ve=o(e,"TABLE",{"data-svelte-h":!0}),s(Ve)!=="svelte-1a01i2a"&&(Ve.innerHTML=ju),Kl=u(e),Dl=o(e,"HR",{}),jl=u(e),We=o(e,"A",{id:!0,class:!0}),n(We).forEach(t),Bl=u(e),p(Fe.$$.fragment,e),Sl=u(e),Ge=o(e,"P",{"data-svelte-h":!0}),s(Ge)!=="svelte-jv0r"&&(Ge.textContent=Bu),Ul=u(e),Je=o(e,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-1gfck0d"&&(Je.innerHTML=Su),Vl=u(e),Wl=o(e,"HR",{}),Fl=u(e),Oe=o(e,"A",{id:!0,class:!0}),n(Oe).forEach(t),Gl=u(e),p(Xe.$$.fragment,e),Jl=u(e),Ye=o(e,"P",{"data-svelte-h":!0}),s(Ye)!=="svelte-1n9zjoi"&&(Ye.innerHTML=Uu),Ol=u(e),Ze=o(e,"TABLE",{"data-svelte-h":!0}),s(Ze)!=="svelte-6nufyb"&&(Ze.innerHTML=Vu),Xl=u(e),Yl=o(e,"HR",{}),Zl=u(e),et=o(e,"A",{id:!0,class:!0}),n(et).forEach(t),er=u(e),p(tt.$$.fragment,e),tr=u(e),it=o(e,"P",{"data-svelte-h":!0}),s(it)!=="svelte-1oso32i"&&(it.innerHTML=Wu),ir=u(e),lr=o(e,"HR",{}),rr=u(e),lt=o(e,"A",{id:!0,class:!0}),n(lt).forEach(t),ur=u(e),p(rt.$$.fragment,e),dr=u(e),ut=o(e,"P",{"data-svelte-h":!0}),s(ut)!=="svelte-1oso32i"&&(ut.innerHTML=Fu),or=u(e),sr=o(e,"HR",{}),ar=u(e),dt=o(e,"A",{id:!0,class:!0}),n(dt).forEach(t),nr=u(e),p(ot.$$.fragment,e),cr=u(e),st=o(e,"P",{"data-svelte-h":!0}),s(st)!=="svelte-1auz3rh"&&(st.textContent=Gu),pr=u(e),at=o(e,"P",{"data-svelte-h":!0}),s(at)!=="svelte-1p9ver0"&&(at.innerHTML=Ju),hr=u(e),nt=o(e,"UL",{"data-svelte-h":!0}),s(nt)!=="svelte-4v7sww"&&(nt.innerHTML=Ou),fr=u(e),mr=o(e,"HR",{}),Tr=u(e),ct=o(e,"A",{id:!0,class:!0}),n(ct).forEach(t),$r=u(e),p(pt.$$.fragment,e),_r=u(e),ht=o(e,"P",{"data-svelte-h":!0}),s(ht)!=="svelte-mt1jex"&&(ht.textContent=Xu),yr=u(e),ft=o(e,"TABLE",{"data-svelte-h":!0}),s(ft)!=="svelte-nk427c"&&(ft.innerHTML=Yu),kr=u(e),Lr=o(e,"HR",{}),vr=u(e),mt=o(e,"A",{id:!0,class:!0}),n(mt).forEach(t),xr=u(e),p(Tt.$$.fragment,e),Cr=u(e),$t=o(e,"P",{"data-svelte-h":!0}),s($t)!=="svelte-9cjdkj"&&($t.innerHTML=Zu),br=u(e),_t=o(e,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-3pigfy"&&(_t.innerHTML=ed),Pr=u(e),Hr=o(e,"HR",{}),wr=u(e),yt=o(e,"A",{id:!0,class:!0}),n(yt).forEach(t),Mr=u(e),p(kt.$$.fragment,e),Ar=u(e),Lt=o(e,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-1p9ver0"&&(Lt.innerHTML=td),Qr=u(e),vt=o(e,"UL",{"data-svelte-h":!0}),s(vt)!=="svelte-r6qh2h"&&(vt.innerHTML=id),Nr=u(e),qr=o(e,"HR",{}),Er=u(e),xt=o(e,"A",{id:!0,class:!0}),n(xt).forEach(t),Rr=u(e),p(Ct.$$.fragment,e),Ir=u(e),bt=o(e,"P",{"data-svelte-h":!0}),s(bt)!=="svelte-vrhdhn"&&(bt.textContent=ld),gr=u(e),Pt=o(e,"TABLE",{"data-svelte-h":!0}),s(Pt)!=="svelte-5ahzuq"&&(Pt.innerHTML=rd),zr=u(e),Kr=o(e,"HR",{}),Dr=u(e),Ht=o(e,"A",{id:!0,class:!0}),n(Ht).forEach(t),jr=u(e),p(wt.$$.fragment,e),Br=u(e),Mt=o(e,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-34g670"&&(Mt.textContent=ud),Sr=u(e),At=o(e,"P",{"data-svelte-h":!0}),s(At)!=="svelte-7303j9"&&(At.innerHTML=dd),Ur=u(e),Vr=o(e,"HR",{}),Wr=u(e),Nt=o(e,"P",{}),n(Nt).forEach(t),this.h()},h(){a(_,"name","hf:doc:metadata"),a(_,"content",md),a(y,"id","module_utils/data-structures"),a(y,"class","group"),a(C,"id","module_utils/data-structures.PriorityQueue"),a(C,"class","group"),a(Q,"id","new_module_utils/data-structures.PriorityQueue_new"),a(Q,"class","group"),a(R,"id","module_utils/data-structures.PriorityQueue+size"),a(R,"class","group"),a(K,"id","module_utils/data-structures.PriorityQueue+isEmpty"),a(K,"class","group"),a(S,"id","module_utils/data-structures.PriorityQueue+peek"),a(S,"class","group"),a(F,"id","module_utils/data-structures.PriorityQueue+push"),a(F,"class","group"),a(Y,"id","module_utils/data-structures.PriorityQueue+extend"),a(Y,"class","group"),a(le,"id","module_utils/data-structures.PriorityQueue+pop"),a(le,"class","group"),a(oe,"id","module_utils/data-structures.PriorityQueue+replace"),a(oe,"class","group"),a(pe,"id","module_utils/data-structures.CharTrie"),a(pe,"class","group"),a($e,"id","module_utils/data-structures.CharTrie+extend"),a($e,"class","group"),a(ve,"id","module_utils/data-structures.CharTrie+push"),a(ve,"class","group"),a(He,"id","module_utils/data-structures.CharTrie+commonPrefixSearch"),a(He,"class","group"),a(Ne,"id","module_utils/data-structures.TokenLattice"),a(Ne,"class","group"),a(ge,"id","new_module_utils/data-structures.TokenLattice_new"),a(ge,"class","group"),a(je,"id","module_utils/data-structures.TokenLattice+insert"),a(je,"class","group"),a(We,"id","module_utils/data-structures.TokenLattice+viterbi"),a(We,"class","group"),a(Oe,"id","module_utils/data-structures.TokenLattice+piece"),a(Oe,"class","group"),a(et,"id","module_utils/data-structures.TokenLattice+tokens"),a(et,"class","group"),a(lt,"id","module_utils/data-structures.TokenLattice+tokenIds"),a(lt,"class","group"),a(dt,"id","module_utils/data-structures..CharTrieNode"),a(dt,"class","group"),a(ct,"id","new_module_utils/data-structures..CharTrieNode_new"),a(ct,"class","group"),a(mt,"id","module_utils/data-structures..CharTrieNode.default"),a(mt,"class","group"),a(yt,"id","module_utils/data-structures..TokenLatticeNode"),a(yt,"class","group"),a(xt,"id","new_module_utils/data-structures..TokenLatticeNode_new"),a(xt,"class","group"),a(Ht,"id","module_utils/data-structures..TokenLatticeNode+clone"),a(Ht,"class","group")},m(e,i){hd(document.head,_),l(e,qt,i),l(e,Qt,i),l(e,Et,i),l(e,y,i),l(e,Rt,i),h(k,e,i),l(e,It,i),l(e,L,i),l(e,gt,i),l(e,v,i),l(e,zt,i),l(e,x,i),l(e,Kt,i),l(e,Dt,i),l(e,jt,i),l(e,C,i),l(e,Bt,i),h(b,e,i),l(e,St,i),l(e,P,i),l(e,Ut,i),l(e,H,i),l(e,Vt,i),l(e,w,i),l(e,Wt,i),l(e,M,i),l(e,Ft,i),l(e,A,i),l(e,Gt,i),l(e,Jt,i),l(e,Ot,i),l(e,Q,i),l(e,Xt,i),h(N,e,i),l(e,Yt,i),l(e,q,i),l(e,Zt,i),l(e,E,i),l(e,ei,i),l(e,ti,i),l(e,ii,i),l(e,R,i),l(e,li,i),h(I,e,i),l(e,ri,i),l(e,g,i),l(e,ui,i),l(e,z,i),l(e,di,i),l(e,oi,i),l(e,si,i),l(e,K,i),l(e,ai,i),h(D,e,i),l(e,ni,i),l(e,j,i),l(e,ci,i),l(e,B,i),l(e,pi,i),l(e,hi,i),l(e,fi,i),l(e,S,i),l(e,mi,i),h(U,e,i),l(e,Ti,i),l(e,V,i),l(e,$i,i),l(e,W,i),l(e,_i,i),l(e,yi,i),l(e,ki,i),l(e,F,i),l(e,Li,i),h(G,e,i),l(e,vi,i),l(e,J,i),l(e,xi,i),l(e,O,i),l(e,Ci,i),l(e,X,i),l(e,bi,i),l(e,Pi,i),l(e,Hi,i),l(e,Y,i),l(e,wi,i),h(Z,e,i),l(e,Mi,i),l(e,ee,i),l(e,Ai,i),l(e,te,i),l(e,Qi,i),l(e,ie,i),l(e,Ni,i),l(e,qi,i),l(e,Ei,i),l(e,le,i),l(e,Ri,i),h(re,e,i),l(e,Ii,i),l(e,ue,i),l(e,gi,i),l(e,de,i),l(e,zi,i),l(e,Ki,i),l(e,Di,i),l(e,oe,i),l(e,ji,i),h(se,e,i),l(e,Bi,i),l(e,ae,i),l(e,Si,i),l(e,ne,i),l(e,Ui,i),l(e,ce,i),l(e,Vi,i),l(e,Wi,i),l(e,Fi,i),l(e,pe,i),l(e,Gi,i),h(he,e,i),l(e,Ji,i),l(e,fe,i),l(e,Oi,i),l(e,me,i),l(e,Xi,i),l(e,Te,i),l(e,Yi,i),l(e,Zi,i),l(e,el,i),l(e,$e,i),l(e,tl,i),h(_e,e,i),l(e,il,i),l(e,ye,i),l(e,ll,i),l(e,ke,i),l(e,rl,i),l(e,Le,i),l(e,ul,i),l(e,dl,i),l(e,ol,i),l(e,ve,i),l(e,sl,i),h(xe,e,i),l(e,al,i),l(e,Ce,i),l(e,nl,i),l(e,be,i),l(e,cl,i),l(e,Pe,i),l(e,pl,i),l(e,hl,i),l(e,fl,i),l(e,He,i),l(e,ml,i),h(we,e,i),l(e,Tl,i),l(e,Me,i),l(e,$l,i),l(e,Ae,i),l(e,_l,i),l(e,Qe,i),l(e,yl,i),l(e,kl,i),l(e,Ll,i),l(e,Ne,i),l(e,vl,i),h(qe,e,i),l(e,xl,i),l(e,Ee,i),l(e,Cl,i),l(e,Re,i),l(e,bl,i),l(e,Ie,i),l(e,Pl,i),l(e,Hl,i),l(e,wl,i),l(e,ge,i),l(e,Ml,i),h(ze,e,i),l(e,Al,i),l(e,Ke,i),l(e,Ql,i),l(e,De,i),l(e,Nl,i),l(e,ql,i),l(e,El,i),l(e,je,i),l(e,Rl,i),h(Be,e,i),l(e,Il,i),l(e,Se,i),l(e,gl,i),l(e,Ue,i),l(e,zl,i),l(e,Ve,i),l(e,Kl,i),l(e,Dl,i),l(e,jl,i),l(e,We,i),l(e,Bl,i),h(Fe,e,i),l(e,Sl,i),l(e,Ge,i),l(e,Ul,i),l(e,Je,i),l(e,Vl,i),l(e,Wl,i),l(e,Fl,i),l(e,Oe,i),l(e,Gl,i),h(Xe,e,i),l(e,Jl,i),l(e,Ye,i),l(e,Ol,i),l(e,Ze,i),l(e,Xl,i),l(e,Yl,i),l(e,Zl,i),l(e,et,i),l(e,er,i),h(tt,e,i),l(e,tr,i),l(e,it,i),l(e,ir,i),l(e,lr,i),l(e,rr,i),l(e,lt,i),l(e,ur,i),h(rt,e,i),l(e,dr,i),l(e,ut,i),l(e,or,i),l(e,sr,i),l(e,ar,i),l(e,dt,i),l(e,nr,i),h(ot,e,i),l(e,cr,i),l(e,st,i),l(e,pr,i),l(e,at,i),l(e,hr,i),l(e,nt,i),l(e,fr,i),l(e,mr,i),l(e,Tr,i),l(e,ct,i),l(e,$r,i),h(pt,e,i),l(e,_r,i),l(e,ht,i),l(e,yr,i),l(e,ft,i),l(e,kr,i),l(e,Lr,i),l(e,vr,i),l(e,mt,i),l(e,xr,i),h(Tt,e,i),l(e,Cr,i),l(e,$t,i),l(e,br,i),l(e,_t,i),l(e,Pr,i),l(e,Hr,i),l(e,wr,i),l(e,yt,i),l(e,Mr,i),h(kt,e,i),l(e,Ar,i),l(e,Lt,i),l(e,Qr,i),l(e,vt,i),l(e,Nr,i),l(e,qr,i),l(e,Er,i),l(e,xt,i),l(e,Rr,i),h(Ct,e,i),l(e,Ir,i),l(e,bt,i),l(e,gr,i),l(e,Pt,i),l(e,zr,i),l(e,Kr,i),l(e,Dr,i),l(e,Ht,i),l(e,jr,i),h(wt,e,i),l(e,Br,i),l(e,Mt,i),l(e,Sr,i),l(e,At,i),l(e,Ur,i),l(e,Vr,i),l(e,Wr,i),l(e,Nt,i),Fr=!0},p:sd,i(e){Fr||(f(k.$$.fragment,e),f(b.$$.fragment,e),f(N.$$.fragment,e),f(I.$$.fragment,e),f(D.$$.fragment,e),f(U.$$.fragment,e),f(G.$$.fragment,e),f(Z.$$.fragment,e),f(re.$$.fragment,e),f(se.$$.fragment,e),f(he.$$.fragment,e),f(_e.$$.fragment,e),f(xe.$$.fragment,e),f(we.$$.fragment,e),f(qe.$$.fragment,e),f(ze.$$.fragment,e),f(Be.$$.fragment,e),f(Fe.$$.fragment,e),f(Xe.$$.fragment,e),f(tt.$$.fragment,e),f(rt.$$.fragment,e),f(ot.$$.fragment,e),f(pt.$$.fragment,e),f(Tt.$$.fragment,e),f(kt.$$.fragment,e),f(Ct.$$.fragment,e),f(wt.$$.fragment,e),Fr=!0)},o(e){m(k.$$.fragment,e),m(b.$$.fragment,e),m(N.$$.fragment,e),m(I.$$.fragment,e),m(D.$$.fragment,e),m(U.$$.fragment,e),m(G.$$.fragment,e),m(Z.$$.fragment,e),m(re.$$.fragment,e),m(se.$$.fragment,e),m(he.$$.fragment,e),m(_e.$$.fragment,e),m(xe.$$.fragment,e),m(we.$$.fragment,e),m(qe.$$.fragment,e),m(ze.$$.fragment,e),m(Be.$$.fragment,e),m(Fe.$$.fragment,e),m(Xe.$$.fragment,e),m(tt.$$.fragment,e),m(rt.$$.fragment,e),m(ot.$$.fragment,e),m(pt.$$.fragment,e),m(Tt.$$.fragment,e),m(kt.$$.fragment,e),m(Ct.$$.fragment,e),m(wt.$$.fragment,e),Fr=!1},d(e){e&&(t(qt),t(Qt),t(Et),t(y),t(Rt),t(It),t(L),t(gt),t(v),t(zt),t(x),t(Kt),t(Dt),t(jt),t(C),t(Bt),t(St),t(P),t(Ut),t(H),t(Vt),t(w),t(Wt),t(M),t(Ft),t(A),t(Gt),t(Jt),t(Ot),t(Q),t(Xt),t(Yt),t(q),t(Zt),t(E),t(ei),t(ti),t(ii),t(R),t(li),t(ri),t(g),t(ui),t(z),t(di),t(oi),t(si),t(K),t(ai),t(ni),t(j),t(ci),t(B),t(pi),t(hi),t(fi),t(S),t(mi),t(Ti),t(V),t($i),t(W),t(_i),t(yi),t(ki),t(F),t(Li),t(vi),t(J),t(xi),t(O),t(Ci),t(X),t(bi),t(Pi),t(Hi),t(Y),t(wi),t(Mi),t(ee),t(Ai),t(te),t(Qi),t(ie),t(Ni),t(qi),t(Ei),t(le),t(Ri),t(Ii),t(ue),t(gi),t(de),t(zi),t(Ki),t(Di),t(oe),t(ji),t(Bi),t(ae),t(Si),t(ne),t(Ui),t(ce),t(Vi),t(Wi),t(Fi),t(pe),t(Gi),t(Ji),t(fe),t(Oi),t(me),t(Xi),t(Te),t(Yi),t(Zi),t(el),t($e),t(tl),t(il),t(ye),t(ll),t(ke),t(rl),t(Le),t(ul),t(dl),t(ol),t(ve),t(sl),t(al),t(Ce),t(nl),t(be),t(cl),t(Pe),t(pl),t(hl),t(fl),t(He),t(ml),t(Tl),t(Me),t($l),t(Ae),t(_l),t(Qe),t(yl),t(kl),t(Ll),t(Ne),t(vl),t(xl),t(Ee),t(Cl),t(Re),t(bl),t(Ie),t(Pl),t(Hl),t(wl),t(ge),t(Ml),t(Al),t(Ke),t(Ql),t(De),t(Nl),t(ql),t(El),t(je),t(Rl),t(Il),t(Se),t(gl),t(Ue),t(zl),t(Ve),t(Kl),t(Dl),t(jl),t(We),t(Bl),t(Sl),t(Ge),t(Ul),t(Je),t(Vl),t(Wl),t(Fl),t(Oe),t(Gl),t(Jl),t(Ye),t(Ol),t(Ze),t(Xl),t(Yl),t(Zl),t(et),t(er),t(tr),t(it),t(ir),t(lr),t(rr),t(lt),t(ur),t(dr),t(ut),t(or),t(sr),t(ar),t(dt),t(nr),t(cr),t(st),t(pr),t(at),t(hr),t(nt),t(fr),t(mr),t(Tr),t(ct),t($r),t(_r),t(ht),t(yr),t(ft),t(kr),t(Lr),t(vr),t(mt),t(xr),t(Cr),t($t),t(br),t(_t),t(Pr),t(Hr),t(wr),t(yt),t(Mr),t(Ar),t(Lt),t(Qr),t(vt),t(Nr),t(qr),t(Er),t(xt),t(Rr),t(Ir),t(bt),t(gr),t(Pt),t(zr),t(Kr),t(Dr),t(Ht),t(jr),t(Br),t(Mt),t(Sr),t(At),t(Ur),t(Vr),t(Wr),t(Nt)),t(_),T(k,e),T(b,e),T(N,e),T(I,e),T(D,e),T(U,e),T(G,e),T(Z,e),T(re,e),T(se,e),T(he,e),T(_e,e),T(xe,e),T(we,e),T(qe,e),T(ze,e),T(Be,e),T(Fe,e),T(Xe,e),T(tt,e),T(rt,e),T(ot,e),T(pt,e),T(Tt,e),T(kt,e),T(Ct,e),T(wt,e)}}}const md='{"title":"utils/data-structures","local":"utilsdata-structures","sections":[{"title":"utils/data-structures.PriorityQueue","local":"utilsdata-structurespriorityqueue","sections":[{"title":"new PriorityQueue(comparator)","local":"new-priorityqueuecomparator","sections":[],"depth":3},{"title":"priorityQueue.size","local":"priorityqueuesize","sections":[],"depth":3},{"title":"priorityQueue.isEmpty() ⇒ <code> boolean </code>","local":"priorityqueueisempty--code-boolean-code","sections":[],"depth":3},{"title":"priorityQueue.peek() ⇒ <code> any </code>","local":"priorityqueuepeek--code-any-code","sections":[],"depth":3},{"title":"priorityQueue.push(...values) ⇒ <code> number </code>","local":"priorityqueuepushvalues--code-number-code","sections":[],"depth":3},{"title":"priorityQueue.extend(values) ⇒ <code> number </code>","local":"priorityqueueextendvalues--code-number-code","sections":[],"depth":3},{"title":"priorityQueue.pop() ⇒ <code> any </code>","local":"priorityqueuepop--code-any-code","sections":[],"depth":3},{"title":"priorityQueue.replace(value) ⇒ <code> * </code>","local":"priorityqueuereplacevalue--code--code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures.CharTrie","local":"utilsdata-structureschartrie","sections":[{"title":"charTrie.extend(texts)","local":"chartrieextendtexts","sections":[],"depth":3},{"title":"charTrie.push(text)","local":"chartriepushtext","sections":[],"depth":3},{"title":"charTrie.commonPrefixSearch(text)","local":"chartriecommonprefixsearchtext","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures.TokenLattice","local":"utilsdata-structurestokenlattice","sections":[{"title":"new TokenLattice(sentence, bosTokenId, eosTokenId)","local":"new-tokenlatticesentence-bostokenid-eostokenid","sections":[],"depth":3},{"title":"tokenLattice.insert(pos, length, score, tokenId)","local":"tokenlatticeinsertpos-length-score-tokenid","sections":[],"depth":3},{"title":"tokenLattice.viterbi() ⇒ <code> Array. < TokenLatticeNode > </code>","local":"tokenlatticeviterbi--code-array--tokenlatticenode--code","sections":[],"depth":3},{"title":"tokenLattice.piece(node) ⇒ <code> string </code>","local":"tokenlatticepiecenode--code-string-code","sections":[],"depth":3},{"title":"tokenLattice.tokens() ⇒ <code> Array </code>","local":"tokenlatticetokens--code-array-code","sections":[],"depth":3},{"title":"tokenLattice.tokenIds() ⇒ <code> Array </code>","local":"tokenlatticetokenids--code-array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures~CharTrieNode","local":"utilsdata-structureschartrienode","sections":[{"title":"new CharTrieNode(isLeaf, children)","local":"new-chartrienodeisleaf-children","sections":[],"depth":3},{"title":"CharTrieNode.default() ⇒ <code> CharTrieNode </code>","local":"chartrienodedefault--code-chartrienode-code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures~TokenLatticeNode","local":"utilsdata-structurestokenlatticenode","sections":[{"title":"new TokenLatticeNode(tokenId, nodeId, pos, length, score)","local":"new-tokenlatticenodetokenid-nodeid-pos-length-score","sections":[],"depth":3},{"title":"tokenLatticeNode.clone() ⇒ <code> TokenLatticeNode </code>","local":"tokenlatticenodeclone--code-tokenlatticenode-code","sections":[],"depth":3}],"depth":2}],"depth":1}';function Td(Gr){return ad(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kd extends nd{constructor(_){super(),cd(this,_,Td,fd,od,{})}}export{kd as component};
