import{s as Tt,o as xt,n as ve}from"../chunks/scheduler.182ea377.js";import{S as Ut,i as Jt,g as c,s as o,r as _,A as Mt,h as f,f as l,c as i,j as L,u as y,x,k as D,y as s,a as g,v as w,d as v,t as $,w as T}from"../chunks/index.abf12888.js";import{T as ot}from"../chunks/Tip.230e2334.js";import{D as S}from"../chunks/Docstring.93f6f462.js";import{C as rt}from"../chunks/CodeBlock.57fe6e13.js";import{E as it}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as lt}from"../chunks/Heading.16916d63.js";function It(U){let n,b='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',r,a,u='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){n=c("p"),n.innerHTML=b,r=o(),a=c("p"),a.innerHTML=u},l(t){n=f(t,"P",{"data-svelte-h":!0}),x(n)!=="svelte-1ue9xpl"&&(n.innerHTML=b),r=i(t),a=f(t,"P",{"data-svelte-h":!0}),x(a)!=="svelte-z4pn9c"&&(a.innerHTML=u)},m(t,h){g(t,n,h),g(t,r,h),g(t,a,h)},p:ve,d(t){t&&(l(n),l(r),l(a))}}}function Lt(U){let n,b="Examples:",r,a,u;return a=new rt({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkxhdGVudFVwc2NhbGVQaXBlbGluZSUyQyUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnNkLXgyLWxhdGVudC11cHNjYWxlciUyMiUwQXVwc2NhbGVyJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uTGF0ZW50VXBzY2FsZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEF1cHNjYWxlci50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjBoaWdoJTIwcmVzb2x1dGlvbiUyQyUyMHVucmVhbCUyMGVuZ2luZSUyQyUyMHVsdHJhJTIwcmVhbGlzdGljJTIyJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoMzMpJTBBJTBBbG93X3Jlc19sYXRlbnRzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIpLmltYWdlcyUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGVsaW5lLmRlY29kZV9sYXRlbnRzKGxvd19yZXNfbGF0ZW50cyklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lLm51bXB5X3RvX3BpbChpbWFnZSklNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSglMjIuLiUyRmltYWdlcyUyRmExLnBuZyUyMiklMEElMEF1cHNjYWxlZF9pbWFnZSUyMCUzRCUyMHVwc2NhbGVyKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEbG93X3Jlc19sYXRlbnRzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBdXBzY2FsZWRfaW1hZ2Uuc2F2ZSglMjIuLiUyRmltYWdlcyUyRmEyLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionLatentUpscalePipeline, StableDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch


<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/sd-x2-latent-upscaler&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaler = StableDiffusionLatentUpscalePipeline.from_pretrained(model_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaler.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut high resolution, unreal engine, ultra realistic&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">33</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>low_res_latents = pipeline(prompt, generator=generator, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    image = pipeline.decode_latents(low_res_latents)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipeline.numpy_to_pil(image)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;../images/a1.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image = upscaler(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    image=low_res_latents,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image.save(<span class="hljs-string">&quot;../images/a2.png&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=b,r=o(),_(a.$$.fragment)},l(t){n=f(t,"P",{"data-svelte-h":!0}),x(n)!=="svelte-kvfsh7"&&(n.textContent=b),r=i(t),y(a.$$.fragment,t)},m(t,h){g(t,n,h),g(t,r,h),w(a,t,h),u=!0},p:ve,i(t){u||(v(a.$$.fragment,t),u=!0)},o(t){$(a.$$.fragment,t),u=!1},d(t){t&&(l(n),l(r)),T(a,t)}}}function Dt(U){let n,b=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=c("p"),n.innerHTML=b},l(r){n=f(r,"P",{"data-svelte-h":!0}),x(n)!=="svelte-ackzsn"&&(n.innerHTML=b)},m(r,a){g(r,n,a)},p:ve,d(r){r&&l(n)}}}function jt(U){let n,b="Examples:",r,a,u;return a=new rt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=c("p"),n.textContent=b,r=o(),_(a.$$.fragment)},l(t){n=f(t,"P",{"data-svelte-h":!0}),x(n)!=="svelte-kvfsh7"&&(n.textContent=b),r=i(t),y(a.$$.fragment,t)},m(t,h){g(t,n,h),g(t,r,h),w(a,t,h),u=!0},p:ve,i(t){u||(v(a.$$.fragment,t),u=!0)},o(t){$(a.$$.fragment,t),u=!1},d(t){t&&(l(n),l(r)),T(a,t)}}}function Ct(U){let n,b=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=c("p"),n.textContent=b},l(r){n=f(r,"P",{"data-svelte-h":!0}),x(n)!=="svelte-17p1lpg"&&(n.textContent=b)},m(r,a){g(r,n,a)},p:ve,d(r){r&&l(n)}}}function Pt(U){let n,b="Examples:",r,a,u;return a=new rt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=b,r=o(),_(a.$$.fragment)},l(t){n=f(t,"P",{"data-svelte-h":!0}),x(n)!=="svelte-kvfsh7"&&(n.textContent=b),r=i(t),y(a.$$.fragment,t)},m(t,h){g(t,n,h),g(t,r,h),w(a,t,h),u=!0},p:ve,i(t){u||(v(a.$$.fragment,t),u=!0)},o(t){$(a.$$.fragment,t),u=!1},d(t){t&&(l(n),l(r)),T(a,t)}}}function St(U){let n,b,r,a,u,t,h,pt='The Stable Diffusion latent upscaler model was created by <a href="https://github.com/crowsonkb/k-diffusion" rel="nofollow">Katherine Crowson</a> in collaboration with <a href="https://stability.ai/" rel="nofollow">Stability AI</a>. It is used to enhance the output image resolution by a factor of 2 (see this demo <a href="https://colab.research.google.com/drive/1o1qYJcFeywzCIdkfKJy7cTpgZTCM2EI4" rel="nofollow">notebook</a> for a demonstration of the original implementation).',Te,W,xe,Y,Ue,d,q,Pe,re,ct="Pipeline for upscaling Stable Diffusion output image resolution by a factor of 2.",Se,pe,ft=`This model inherits from <a href="/docs/diffusers/v0.23.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ze,P,Q,Ge,ce,dt="The call function to the pipeline for generation.",We,k,ke,V,A,Ve,fe,ut=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to GPU only when their specific submodule has its <code>forward</code>
method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,Be,J,O,Ee,de,mt=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Re,B,Fe,E,Xe,R,K,Ne,ue,gt=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,ze,M,ee,He,me,ht=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Ye,F,qe,X,Qe,N,te,Ae,ge,bt='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Oe,z,ne,Ke,he,_t="Disables the FreeU mechanism if enabled.",et,I,se,tt,be,yt='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',nt,_e,wt="The suffixes after the scaling factors represent the stages where they are being applied.",st,ye,vt=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Je,ae,Me,Z,oe,at,we,$t="Output class for Stable Diffusion pipelines.",Ie,$e,Le;return u=new lt({props:{title:"Latent upscaler",local:"latent-upscaler",headingTag:"h1"}}),W=new ot({props:{$$slots:{default:[It]},$$scope:{ctx:U}}}),Y=new lt({props:{title:"StableDiffusionLatentUpscalePipeline",local:"diffusers.StableDiffusionLatentUpscalePipeline",headingTag:"h2"}}),q=new S({props:{name:"class diffusers.StableDiffusionLatentUpscalePipeline",anchor:"diffusers.StableDiffusionLatentUpscalePipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": EulerDiscreteScheduler"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.23.1/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.23.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.23.1/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A <a href="/docs/diffusers/v0.23.1/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.23.1/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L63"}}),Q=new S({props:{name:"__call__",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"num_inference_steps",val:": int = 75"},{name:"guidance_scale",val:": float = 9.0"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide image upscaling.`,name:"prompt"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be upscaled. If it&#x2019;s a tensor, it can be either a
latent output from a Stable Diffusion model or an image tensor in the range <code>[-1, 1]</code>. It is considered
a <code>latent</code> if <code>image.shape[1]</code> is <code>4</code>; otherwise, it is considered to be an image representation and
encoded using this pipeline&#x2019;s <code>vae</code> encoder.`,name:"image"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.23.1/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.23.1/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/v0.23.1/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L285",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.23.1/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.23.1/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),k=new it({props:{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.example",$$slots:{default:[Lt]},$$scope:{ctx:U}}}),A=new S({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = 'cuda'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/v0.23.1/src/diffusers/pipelines/pipeline_utils.py#L1466"}}),O=new S({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/v0.23.1/src/diffusers/pipelines/pipeline_utils.py#L2027"}}),B=new ot({props:{warning:!0,$$slots:{default:[Dt]},$$scope:{ctx:U}}}),E=new it({props:{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_attention_slicing.example",$$slots:{default:[jt]},$$scope:{ctx:U}}}),K=new S({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.23.1/src/diffusers/pipelines/pipeline_utils.py#L2067"}}),ee=new S({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/v0.23.1/src/diffusers/pipelines/pipeline_utils.py#L1966"}}),F=new ot({props:{warning:!0,$$slots:{default:[Ct]},$$scope:{ctx:U}}}),X=new it({props:{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Pt]},$$scope:{ctx:U}}}),te=new S({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.23.1/src/diffusers/pipelines/pipeline_utils.py#L2001"}}),ne=new S({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.23.1/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L281"}}),se=new S({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.23.1/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L258"}}),ae=new lt({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),oe=new S({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.23.1/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L11"}}),{c(){n=c("meta"),b=o(),r=c("p"),a=o(),_(u.$$.fragment),t=o(),h=c("p"),h.innerHTML=pt,Te=o(),_(W.$$.fragment),xe=o(),_(Y.$$.fragment),Ue=o(),d=c("div"),_(q.$$.fragment),Pe=o(),re=c("p"),re.textContent=ct,Se=o(),pe=c("p"),pe.innerHTML=ft,Ze=o(),P=c("div"),_(Q.$$.fragment),Ge=o(),ce=c("p"),ce.textContent=dt,We=o(),_(k.$$.fragment),ke=o(),V=c("div"),_(A.$$.fragment),Ve=o(),fe=c("p"),fe.innerHTML=ut,Be=o(),J=c("div"),_(O.$$.fragment),Ee=o(),de=c("p"),de.textContent=mt,Re=o(),_(B.$$.fragment),Fe=o(),_(E.$$.fragment),Xe=o(),R=c("div"),_(K.$$.fragment),Ne=o(),ue=c("p"),ue.innerHTML=gt,ze=o(),M=c("div"),_(ee.$$.fragment),He=o(),me=c("p"),me.innerHTML=ht,Ye=o(),_(F.$$.fragment),qe=o(),_(X.$$.fragment),Qe=o(),N=c("div"),_(te.$$.fragment),Ae=o(),ge=c("p"),ge.innerHTML=bt,Oe=o(),z=c("div"),_(ne.$$.fragment),Ke=o(),he=c("p"),he.textContent=_t,et=o(),I=c("div"),_(se.$$.fragment),tt=o(),be=c("p"),be.innerHTML=yt,nt=o(),_e=c("p"),_e.textContent=wt,st=o(),ye=c("p"),ye.innerHTML=vt,Je=o(),_(ae.$$.fragment),Me=o(),Z=c("div"),_(oe.$$.fragment),at=o(),we=c("p"),we.textContent=$t,Ie=o(),$e=c("p"),this.h()},l(e){const p=Mt("svelte-u9bgzb",document.head);n=f(p,"META",{name:!0,content:!0}),p.forEach(l),b=i(e),r=f(e,"P",{}),L(r).forEach(l),a=i(e),y(u.$$.fragment,e),t=i(e),h=f(e,"P",{"data-svelte-h":!0}),x(h)!=="svelte-1gpdp46"&&(h.innerHTML=pt),Te=i(e),y(W.$$.fragment,e),xe=i(e),y(Y.$$.fragment,e),Ue=i(e),d=f(e,"DIV",{class:!0});var m=L(d);y(q.$$.fragment,m),Pe=i(m),re=f(m,"P",{"data-svelte-h":!0}),x(re)!=="svelte-s74qtl"&&(re.textContent=ct),Se=i(m),pe=f(m,"P",{"data-svelte-h":!0}),x(pe)!=="svelte-3637r9"&&(pe.innerHTML=ft),Ze=i(m),P=f(m,"DIV",{class:!0});var G=L(P);y(Q.$$.fragment,G),Ge=i(G),ce=f(G,"P",{"data-svelte-h":!0}),x(ce)!=="svelte-50j04k"&&(ce.textContent=dt),We=i(G),y(k.$$.fragment,G),G.forEach(l),ke=i(m),V=f(m,"DIV",{class:!0});var ie=L(V);y(A.$$.fragment,ie),Ve=i(ie),fe=f(ie,"P",{"data-svelte-h":!0}),x(fe)!=="svelte-n1oyuv"&&(fe.innerHTML=ut),ie.forEach(l),Be=i(m),J=f(m,"DIV",{class:!0});var j=L(J);y(O.$$.fragment,j),Ee=i(j),de=f(j,"P",{"data-svelte-h":!0}),x(de)!=="svelte-10jaql7"&&(de.textContent=mt),Re=i(j),y(B.$$.fragment,j),Fe=i(j),y(E.$$.fragment,j),j.forEach(l),Xe=i(m),R=f(m,"DIV",{class:!0});var le=L(R);y(K.$$.fragment,le),Ne=i(le),ue=f(le,"P",{"data-svelte-h":!0}),x(ue)!=="svelte-1lh0nh5"&&(ue.innerHTML=gt),le.forEach(l),ze=i(m),M=f(m,"DIV",{class:!0});var C=L(M);y(ee.$$.fragment,C),He=i(C),me=f(C,"P",{"data-svelte-h":!0}),x(me)!=="svelte-e03q3e"&&(me.innerHTML=ht),Ye=i(C),y(F.$$.fragment,C),qe=i(C),y(X.$$.fragment,C),C.forEach(l),Qe=i(m),N=f(m,"DIV",{class:!0});var De=L(N);y(te.$$.fragment,De),Ae=i(De),ge=f(De,"P",{"data-svelte-h":!0}),x(ge)!=="svelte-1vfte1e"&&(ge.innerHTML=bt),De.forEach(l),Oe=i(m),z=f(m,"DIV",{class:!0});var je=L(z);y(ne.$$.fragment,je),Ke=i(je),he=f(je,"P",{"data-svelte-h":!0}),x(he)!=="svelte-psupw6"&&(he.textContent=_t),je.forEach(l),et=i(m),I=f(m,"DIV",{class:!0});var H=L(I);y(se.$$.fragment,H),tt=i(H),be=f(H,"P",{"data-svelte-h":!0}),x(be)!=="svelte-1f3tmq1"&&(be.innerHTML=yt),nt=i(H),_e=f(H,"P",{"data-svelte-h":!0}),x(_e)!=="svelte-xjijlp"&&(_e.textContent=wt),st=i(H),ye=f(H,"P",{"data-svelte-h":!0}),x(ye)!=="svelte-hy0nzs"&&(ye.innerHTML=vt),H.forEach(l),m.forEach(l),Je=i(e),y(ae.$$.fragment,e),Me=i(e),Z=f(e,"DIV",{class:!0});var Ce=L(Z);y(oe.$$.fragment,Ce),at=i(Ce),we=f(Ce,"P",{"data-svelte-h":!0}),x(we)!=="svelte-1qpjiuf"&&(we.textContent=$t),Ce.forEach(l),Ie=i(e),$e=f(e,"P",{}),L($e).forEach(l),this.h()},h(){D(n,"name","hf:doc:metadata"),D(n,"content",Zt),D(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){s(document.head,n),g(e,b,p),g(e,r,p),g(e,a,p),w(u,e,p),g(e,t,p),g(e,h,p),g(e,Te,p),w(W,e,p),g(e,xe,p),w(Y,e,p),g(e,Ue,p),g(e,d,p),w(q,d,null),s(d,Pe),s(d,re),s(d,Se),s(d,pe),s(d,Ze),s(d,P),w(Q,P,null),s(P,Ge),s(P,ce),s(P,We),w(k,P,null),s(d,ke),s(d,V),w(A,V,null),s(V,Ve),s(V,fe),s(d,Be),s(d,J),w(O,J,null),s(J,Ee),s(J,de),s(J,Re),w(B,J,null),s(J,Fe),w(E,J,null),s(d,Xe),s(d,R),w(K,R,null),s(R,Ne),s(R,ue),s(d,ze),s(d,M),w(ee,M,null),s(M,He),s(M,me),s(M,Ye),w(F,M,null),s(M,qe),w(X,M,null),s(d,Qe),s(d,N),w(te,N,null),s(N,Ae),s(N,ge),s(d,Oe),s(d,z),w(ne,z,null),s(z,Ke),s(z,he),s(d,et),s(d,I),w(se,I,null),s(I,tt),s(I,be),s(I,nt),s(I,_e),s(I,st),s(I,ye),g(e,Je,p),w(ae,e,p),g(e,Me,p),g(e,Z,p),w(oe,Z,null),s(Z,at),s(Z,we),g(e,Ie,p),g(e,$e,p),Le=!0},p(e,[p]){const m={};p&2&&(m.$$scope={dirty:p,ctx:e}),W.$set(m);const G={};p&2&&(G.$$scope={dirty:p,ctx:e}),k.$set(G);const ie={};p&2&&(ie.$$scope={dirty:p,ctx:e}),B.$set(ie);const j={};p&2&&(j.$$scope={dirty:p,ctx:e}),E.$set(j);const le={};p&2&&(le.$$scope={dirty:p,ctx:e}),F.$set(le);const C={};p&2&&(C.$$scope={dirty:p,ctx:e}),X.$set(C)},i(e){Le||(v(u.$$.fragment,e),v(W.$$.fragment,e),v(Y.$$.fragment,e),v(q.$$.fragment,e),v(Q.$$.fragment,e),v(k.$$.fragment,e),v(A.$$.fragment,e),v(O.$$.fragment,e),v(B.$$.fragment,e),v(E.$$.fragment,e),v(K.$$.fragment,e),v(ee.$$.fragment,e),v(F.$$.fragment,e),v(X.$$.fragment,e),v(te.$$.fragment,e),v(ne.$$.fragment,e),v(se.$$.fragment,e),v(ae.$$.fragment,e),v(oe.$$.fragment,e),Le=!0)},o(e){$(u.$$.fragment,e),$(W.$$.fragment,e),$(Y.$$.fragment,e),$(q.$$.fragment,e),$(Q.$$.fragment,e),$(k.$$.fragment,e),$(A.$$.fragment,e),$(O.$$.fragment,e),$(B.$$.fragment,e),$(E.$$.fragment,e),$(K.$$.fragment,e),$(ee.$$.fragment,e),$(F.$$.fragment,e),$(X.$$.fragment,e),$(te.$$.fragment,e),$(ne.$$.fragment,e),$(se.$$.fragment,e),$(ae.$$.fragment,e),$(oe.$$.fragment,e),Le=!1},d(e){e&&(l(b),l(r),l(a),l(t),l(h),l(Te),l(xe),l(Ue),l(d),l(Je),l(Me),l(Z),l(Ie),l($e)),l(n),T(u,e),T(W,e),T(Y,e),T(q),T(Q),T(k),T(A),T(O),T(B),T(E),T(K),T(ee),T(F),T(X),T(te),T(ne),T(se),T(ae,e),T(oe)}}}const Zt='{"title":"Latent upscaler","local":"latent-upscaler","sections":[{"title":"StableDiffusionLatentUpscalePipeline","local":"diffusers.StableDiffusionLatentUpscalePipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function Gt(U){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends Ut{constructor(n){super(),Jt(this,n,Gt,St,Tt,{})}}export{Xt as component};
