import{s as ot,n as pt,o as ft}from"../chunks/scheduler.389d799c.js";import{S as ut,i as mt,g as s,s as l,r as f,A as ht,h as r,f as i,c as a,j as st,u,x as o,k as rt,y as gt,a as n,v as m,d as h,t as g,w as d}from"../chunks/index.8f81d18f.js";import{C as dt}from"../chunks/CodeBlock.3845caa1.js";import{H as X,E as ct}from"../chunks/EditOnGithub.33306dfe.js";function vt(je){let p,O,F,V,c,ee,v,Ge="Gaussian Splatting is a <strong>differentiable rasterization technique</strong>.",te,w,ie,T,Be="In simple terms:",ne,x,De="<li>Differentiable can be thought of as a fancy way to say “AI-compatible”</li> <li>Rasterization means taking data and drawing it on the screen</li>",le,$,Se='Rasterization is already really common. It usually takes the form of <a href="https://en.wikipedia.org/wiki/Rasterisation" rel="nofollow">triangle rasterization</a>, where 3D data is converted to 2D pixel data and drawn on the screen. That’s how meshes are usually rendered.',ae,b,Ue='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/ml-for-3d-course/mesh.png" alt="Mesh"/>',se,M,Re="However, triangle rasterization isn’t very AI-compatible. This is because it includes discrete decisions like:",re,C,We="<li>Is this pixel inside the triangle?</li>",oe,_,qe="Neural networks don’t like discrete decisions. They want everything to be fuzzy and continous - or in other words, <em>differentiable</em>.",pe,y,fe,H,Ae="Gaussian Splatting is a differentiable rasterization technique. But how does it actually work?",ue,L,Ee="Splats are composed of millions of points, where each point is composed of four parameters:",me,k,Ne="<li><strong>Position</strong>: where it’s located (XYZ)</li> <li><strong>Covariance</strong>: how it’s stretched (3x3 matrix)</li> <li><strong>Color</strong>: what color it is (RGB)</li> <li><strong>Alpha</strong>: how transparent it is (α)</li>",he,P,Qe="Then, to rasterize a splat, these points are projected into 2D. Then, for every pixel, contribute the contribution of every point. Or, in pseudocode:",ge,z,de,I,Ye="The contribution of a point diminishes the further it is from the pixel. The points also need to be sorted, since they are blended back-to-front.",ce,J,Ze="In theory, every point contributes to every pixel, which is very inefficient. However, that’s okay, because it’s <em>differentiable</em>.",ve,j,Xe='In practice, this is optimized with a tile-based rasterization method, as detailed in the <a href="https://huggingface.co/papers/2308.04079" rel="nofollow">original paper</a>.',we,G,Te,B,Fe='If you’re not training a model, then it doesn’t matter if it’s differentiable. You can just treat each point as an instanced quad, as in open-source web viewers like <a href="https://github.com/huggingface/gsplat.js" rel="nofollow">gsplat.js</a>.',xe,D,Ke='This can be seen in action <a href="https://huggingface.co/spaces/dylanebert/igf" rel="nofollow">here</a>.',$e,S,be,U,Oe='The <a href="https://huggingface.co/papers/2308.04079" rel="nofollow">original paper</a> intializes the points using <a href="https://en.wikipedia.org/wiki/Structure_from_motion" rel="nofollow">Structure-from-Motion</a>, a traditional algorithm for 3D reconstruction.',Me,R,Ve='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/124_ml-for-games/gaussian/points.png" alt="Structure from Motion"/>',Ce,W,et="These points are then rasterized using the tile-based method, and the loss is computed by comparing the rasterized image to the ground truth. Gradient descent is applies to adjust the point parameters (position, covariance, color, alpha).",_e,q,tt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/124_ml-for-games/gaussian/ellipsoids.png" alt="Trained"/>',ye,A,it='The original paper also uses automated densification and pruning to automatically add and remove points as needed. More details can be found <a href="https://huggingface.co/blog/gaussian-splatting" rel="nofollow">here</a>.',He,E,nt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/124_ml-for-games/gaussian/bicycle.png" alt="Final"/>',Le,N,ke,Q,lt="The original approach is suitable for learning individual scenes from photos. However, the concept of differentiable rasterization generalizes to more complex models like neural networks.",Pe,Y,at='This is the case with generative 3D models like <a href="https://huggingface.co/spaces/dylanebert/LGM-mini" rel="nofollow">LGM</a>, which we’ll be using in the next section to build our own generative 3D demo.',ze,Z,Ie,K,Je;return c=new X({props:{title:"What is it?",local:"what-is-it",headingTag:"h1"}}),w=new X({props:{title:"Differentiable Rasterization",local:"differentiable-rasterization",headingTag:"h2"}}),y=new X({props:{title:"Gaussian Splatting",local:"gaussian-splatting",headingTag:"h2"}}),z=new dt({props:{code:"c3BsYXQyZCUyMCUzRCUyMHNwbGF0LnByb2plY3RfYW5kX3NvcnQoKSUwQWZvciUyMHBvaW50JTIwaW4lMjBzcGxhdDJkJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwcGl4ZWwlMjBpbiUyMGltYWdlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGl4ZWwlMjAlMkIlM0QlMjBjb21wdXRlX2NvbnRyaWJ1dGlvbihwb2ludCUyQyUyMHBpeGVsKQ==",highlighted:`splat2d = splat.project_and_sort()
<span class="hljs-keyword">for</span> point <span class="hljs-keyword">in</span> splat2d:
    <span class="hljs-keyword">for</span> pixel <span class="hljs-keyword">in</span> image:
        pixel += compute_contribution(point, pixel)`,wrap:!1}}),G=new X({props:{title:"Inference",local:"inference",headingTag:"h2"}}),S=new X({props:{title:"Training",local:"training",headingTag:"h2"}}),N=new X({props:{title:"Generative 3D",local:"generative-3d",headingTag:"h2"}}),Z=new ct({props:{source:"https://github.com/huggingface/ml-for-3d-course/blob/main/units/en/unit3/what-is-it.mdx"}}),{c(){p=s("meta"),O=l(),F=s("p"),V=l(),f(c.$$.fragment),ee=l(),v=s("p"),v.innerHTML=Ge,te=l(),f(w.$$.fragment),ie=l(),T=s("p"),T.textContent=Be,ne=l(),x=s("ul"),x.innerHTML=De,le=l(),$=s("p"),$.innerHTML=Se,ae=l(),b=s("p"),b.innerHTML=Ue,se=l(),M=s("p"),M.textContent=Re,re=l(),C=s("ul"),C.innerHTML=We,oe=l(),_=s("p"),_.innerHTML=qe,pe=l(),f(y.$$.fragment),fe=l(),H=s("p"),H.textContent=Ae,ue=l(),L=s("p"),L.textContent=Ee,me=l(),k=s("ul"),k.innerHTML=Ne,he=l(),P=s("p"),P.textContent=Qe,ge=l(),f(z.$$.fragment),de=l(),I=s("p"),I.textContent=Ye,ce=l(),J=s("p"),J.innerHTML=Ze,ve=l(),j=s("p"),j.innerHTML=Xe,we=l(),f(G.$$.fragment),Te=l(),B=s("p"),B.innerHTML=Fe,xe=l(),D=s("p"),D.innerHTML=Ke,$e=l(),f(S.$$.fragment),be=l(),U=s("p"),U.innerHTML=Oe,Me=l(),R=s("p"),R.innerHTML=Ve,Ce=l(),W=s("p"),W.textContent=et,_e=l(),q=s("p"),q.innerHTML=tt,ye=l(),A=s("p"),A.innerHTML=it,He=l(),E=s("p"),E.innerHTML=nt,Le=l(),f(N.$$.fragment),ke=l(),Q=s("p"),Q.textContent=lt,Pe=l(),Y=s("p"),Y.innerHTML=at,ze=l(),f(Z.$$.fragment),Ie=l(),K=s("p"),this.h()},l(e){const t=ht("svelte-u9bgzb",document.head);p=r(t,"META",{name:!0,content:!0}),t.forEach(i),O=a(e),F=r(e,"P",{}),st(F).forEach(i),V=a(e),u(c.$$.fragment,e),ee=a(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1l7u0lq"&&(v.innerHTML=Ge),te=a(e),u(w.$$.fragment,e),ie=a(e),T=r(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-7t4fq2"&&(T.textContent=Be),ne=a(e),x=r(e,"UL",{"data-svelte-h":!0}),o(x)!=="svelte-isap97"&&(x.innerHTML=De),le=a(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-yvwu9g"&&($.innerHTML=Se),ae=a(e),b=r(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1xent91"&&(b.innerHTML=Ue),se=a(e),M=r(e,"P",{"data-svelte-h":!0}),o(M)!=="svelte-9ucodi"&&(M.textContent=Re),re=a(e),C=r(e,"UL",{"data-svelte-h":!0}),o(C)!=="svelte-19d9d9h"&&(C.innerHTML=We),oe=a(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-180fjqc"&&(_.innerHTML=qe),pe=a(e),u(y.$$.fragment,e),fe=a(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-2vaw9h"&&(H.textContent=Ae),ue=a(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-w056v4"&&(L.textContent=Ee),me=a(e),k=r(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-1pgaban"&&(k.innerHTML=Ne),he=a(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-n6px5u"&&(P.textContent=Qe),ge=a(e),u(z.$$.fragment,e),de=a(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-dtphl0"&&(I.textContent=Ye),ce=a(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-v7hqi9"&&(J.innerHTML=Ze),ve=a(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1wxfosp"&&(j.innerHTML=Xe),we=a(e),u(G.$$.fragment,e),Te=a(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-tiuv9s"&&(B.innerHTML=Fe),xe=a(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-nvtzrx"&&(D.innerHTML=Ke),$e=a(e),u(S.$$.fragment,e),be=a(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1nuzef1"&&(U.innerHTML=Oe),Me=a(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-jnhg58"&&(R.innerHTML=Ve),Ce=a(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1xyf8kx"&&(W.textContent=et),_e=a(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-txetn1"&&(q.innerHTML=tt),ye=a(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-p9ikvl"&&(A.innerHTML=it),He=a(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-kkz8p5"&&(E.innerHTML=nt),Le=a(e),u(N.$$.fragment,e),ke=a(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1ig1r3c"&&(Q.textContent=lt),Pe=a(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-5hw3d"&&(Y.innerHTML=at),ze=a(e),u(Z.$$.fragment,e),Ie=a(e),K=r(e,"P",{}),st(K).forEach(i),this.h()},h(){rt(p,"name","hf:doc:metadata"),rt(p,"content",wt)},m(e,t){gt(document.head,p),n(e,O,t),n(e,F,t),n(e,V,t),m(c,e,t),n(e,ee,t),n(e,v,t),n(e,te,t),m(w,e,t),n(e,ie,t),n(e,T,t),n(e,ne,t),n(e,x,t),n(e,le,t),n(e,$,t),n(e,ae,t),n(e,b,t),n(e,se,t),n(e,M,t),n(e,re,t),n(e,C,t),n(e,oe,t),n(e,_,t),n(e,pe,t),m(y,e,t),n(e,fe,t),n(e,H,t),n(e,ue,t),n(e,L,t),n(e,me,t),n(e,k,t),n(e,he,t),n(e,P,t),n(e,ge,t),m(z,e,t),n(e,de,t),n(e,I,t),n(e,ce,t),n(e,J,t),n(e,ve,t),n(e,j,t),n(e,we,t),m(G,e,t),n(e,Te,t),n(e,B,t),n(e,xe,t),n(e,D,t),n(e,$e,t),m(S,e,t),n(e,be,t),n(e,U,t),n(e,Me,t),n(e,R,t),n(e,Ce,t),n(e,W,t),n(e,_e,t),n(e,q,t),n(e,ye,t),n(e,A,t),n(e,He,t),n(e,E,t),n(e,Le,t),m(N,e,t),n(e,ke,t),n(e,Q,t),n(e,Pe,t),n(e,Y,t),n(e,ze,t),m(Z,e,t),n(e,Ie,t),n(e,K,t),Je=!0},p:pt,i(e){Je||(h(c.$$.fragment,e),h(w.$$.fragment,e),h(y.$$.fragment,e),h(z.$$.fragment,e),h(G.$$.fragment,e),h(S.$$.fragment,e),h(N.$$.fragment,e),h(Z.$$.fragment,e),Je=!0)},o(e){g(c.$$.fragment,e),g(w.$$.fragment,e),g(y.$$.fragment,e),g(z.$$.fragment,e),g(G.$$.fragment,e),g(S.$$.fragment,e),g(N.$$.fragment,e),g(Z.$$.fragment,e),Je=!1},d(e){e&&(i(O),i(F),i(V),i(ee),i(v),i(te),i(ie),i(T),i(ne),i(x),i(le),i($),i(ae),i(b),i(se),i(M),i(re),i(C),i(oe),i(_),i(pe),i(fe),i(H),i(ue),i(L),i(me),i(k),i(he),i(P),i(ge),i(de),i(I),i(ce),i(J),i(ve),i(j),i(we),i(Te),i(B),i(xe),i(D),i($e),i(be),i(U),i(Me),i(R),i(Ce),i(W),i(_e),i(q),i(ye),i(A),i(He),i(E),i(Le),i(ke),i(Q),i(Pe),i(Y),i(ze),i(Ie),i(K)),i(p),d(c,e),d(w,e),d(y,e),d(z,e),d(G,e),d(S,e),d(N,e),d(Z,e)}}}const wt='{"title":"What is it?","local":"what-is-it","sections":[{"title":"Differentiable Rasterization","local":"differentiable-rasterization","sections":[],"depth":2},{"title":"Gaussian Splatting","local":"gaussian-splatting","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"Training","local":"training","sections":[],"depth":2},{"title":"Generative 3D","local":"generative-3d","sections":[],"depth":2}],"depth":1}';function Tt(je){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ct extends ut{constructor(p){super(),mt(this,p,Tt,vt,ot,{})}}export{Ct as component};
