import{s as Ki,n as Wi,o as ji}from"../chunks/scheduler.6062bdaf.js";import{S as Xi,i as Vi,g as o,s as n,r as f,A as Ji,h as s,f as i,c as a,j as Yi,u,x as r,k as zi,y as Qi,a as l,v as d,d as h,t as c,w as p}from"../chunks/index.4bca734e.js";import{H as m}from"../chunks/Heading.723dceba.js";function Zi(Qt){let g,Be,Ae,Pe,_,qe,H,Zt="<code>huggingface_hub</code> can be configured using environment variables.",Oe,b,ei=`If you are unfamiliar with environment variable, here are generic articles about them
<a href="https://linuxize.com/post/how-to-set-and-list-environment-variables-in-linux/" rel="nofollow">on macOS and Linux</a>
and on <a href="https://phoenixnap.com/kb/windows-set-environment-variable" rel="nofollow">Windows</a>.`,Ne,v,ti=`This page will guide you through all environment variables specific to <code>huggingface_hub</code>
and their meaning.`,ke,$,Ue,T,Re,w,ii=`To configure the inference api base url. You might want to set this variable if your organization
is pointing at an API Gateway rather than directly at the inference api.`,De,L,li="Defaults to <code>&quot;https://api-inference.huggingface.com&quot;</code>.",Ge,E,Ye,y,ni=`To configure where <code>huggingface_hub</code> will locally store data. In particular, your token
and the cache will be stored in this folder.`,ze,M,ai='Defaults to <code>&quot;~/.cache/huggingface&quot;</code> unless <a href="#xdgcachehome">XDG_CACHE_HOME</a> is set.',Ke,x,We,C,oi=`To configure where repositories from the Hub will be cached locally (models, datasets and
spaces).`,je,I,si="Defaults to <code>&quot;$HF_HOME/hub&quot;</code> (e.g. <code>&quot;~/.cache/huggingface/hub&quot;</code> by default).",Xe,F,Ve,A,ri=`To configure where <a href="../guides/manage-cache#caching-assets">assets</a> created by downstream libraries
will be cached locally. Those assets can be preprocessed data, files downloaded from GitHub,
logs,…`,Je,S,fi="Defaults to <code>&quot;$HF_HOME/assets&quot;</code> (e.g. <code>&quot;~/.cache/huggingface/assets&quot;</code> by default).",Qe,B,Ze,P,ui=`To configure the User Access Token to authenticate to the Hub. If set, this value will
overwrite the token stored on the machine (in <code>&quot;$HF_HOME/token&quot;</code>).`,et,q,di='For more details about authentication, check out <a href="../quick-start#authentication">this section</a>.',tt,O,it,N,hi=`Set the verbosity level of the <code>huggingface_hub</code>’s logger. Must be one of
<code>{&quot;debug&quot;, &quot;info&quot;, &quot;warning&quot;, &quot;error&quot;, &quot;critical&quot;}</code>.`,lt,k,ci="Defaults to <code>&quot;warning&quot;</code>.",nt,U,pi='For more details, see <a href="../package_reference/utilities#huggingface_hub.utils.logging.get_verbosity">logging reference</a>.',at,R,ot,D,mi=`Integer value to define under which size a file is considered as “small”. When downloading files to a local directory,
small files will be duplicated to ease user experience while bigger files are symlinked to save disk usage.`,st,G,gi='For more details, see the <a href="../guides/download#download-files-to-local-folder">download guide</a>.',rt,Y,ft,z,_i="Integer value to define the number of seconds to wait for server response when fetching the latest metadata from a repo before downloading a file. If the request times out, <code>huggingface_hub</code> will default to the locally cached files. Setting a lower value speeds up the workflow for machines with a slow connection that have already cached files. A higher value guarantees the metadata call to succeed in more cases. Default to 10s.",ut,K,dt,W,Hi="Integer value to define the number of seconds to wait for server response when downloading a file. If the request times out, a TimeoutError is raised. Setting a higher value is beneficial on machine with a slow connection. A smaller value makes the process fail quicker in case of complete network outage. Default to 10s.",ht,j,ct,X,bi=`The following environment variables expect a boolean value. The variable will be considered
as <code>True</code> if its value is one of <code>{&quot;1&quot;, &quot;ON&quot;, &quot;YES&quot;, &quot;TRUE&quot;}</code> (case-insensitive). Any other value
(or undefined) will be considered as <code>False</code>.`,pt,V,mt,J,vi="If set, no HTTP calls will me made to the Hugging Face Hub. If you try to download files, only the cached files will be accessed. If no cache file is detected, an error is raised This is useful in case your network is slow and you don’t care about having the latest version of a file.",gt,Q,$i='If <code>HF_HUB_OFFLINE=1</code> is set as environment variable and you call any method of <a href="/docs/huggingface_hub/v0.21.1/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>, an <a href="/docs/huggingface_hub/v0.21.1/en/package_reference/utilities#huggingface_hub.utils.OfflineModeIsEnabled">OfflineModeIsEnabled</a> exception will be raised.',_t,Z,Ti="<strong>Note:</strong> even if the latest version of a file is cached, calling <code>hf_hub_download</code> still triggers a HTTP request to check that a new version is not available. Setting <code>HF_HUB_OFFLINE=1</code> will skip this call which speeds up your loading time.",Ht,ee,bt,te,wi=`Authentication is not mandatory for every requests to the Hub. For instance, requesting
details about <code>&quot;gpt2&quot;</code> model does not require to be authenticated. However, if a user is
<a href="../package_reference/login">logged in</a>, the default behavior will be to always send the token
in order to ease user experience (never get a HTTP 401 Unauthorized) when accessing private or gated repositories. For privacy, you can
disable this behavior by setting <code>HF_HUB_DISABLE_IMPLICIT_TOKEN=1</code>. In this case,
the token will be sent only for “write-access” calls (example: create a commit).`,vt,ie,Li=`<strong>Note:</strong> disabling implicit sending of token can have weird side effects. For example,
if you want to list all models on the Hub, your private models will not be listed. You
would need to explicitly pass <code>token=True</code> argument in your script.`,$t,le,Tt,ne,Ei=`For time consuming tasks, <code>huggingface_hub</code> displays a progress bar by default (using tqdm).
You can disable all the progress bars at once by setting <code>HF_HUB_DISABLE_PROGRESS_BARS=1</code>.`,wt,ae,Lt,oe,yi=`If you are on a Windows machine, it is recommended to enable the developer mode or to run
<code>huggingface_hub</code> in admin mode. If not, <code>huggingface_hub</code> will not be able to create
symlinks in your cache system. You will be able to execute any script but your user experience
will be degraded as some huge files might end-up duplicated on your hard-drive. A warning
message is triggered to warn you about this behavior. Set <code>HF_HUB_DISABLE_SYMLINKS_WARNING=1</code>,
to disable this warning.`,Et,se,Mi='For more details, see <a href="../guides/manage-cache#limitations">cache limitations</a>.',yt,re,Mt,fe,xi=`Some features of <code>huggingface_hub</code> are experimental. This means you can use them but we do not guarantee they will be
maintained in the future. In particular, we might update the API or behavior of such features without any deprecation
cycle. A warning message is triggered when using an experimental feature to warn you about it. If you’re comfortable debugging any potential issues using an experimental feature, you can set <code>HF_HUB_DISABLE_EXPERIMENTAL_WARNING=1</code> to disable the warning.`,xt,ue,Ci="If you are using an experimental feature, please let us know! Your feedback can help us design and improve it.",Ct,de,It,he,Ii=`By default, some data is collected by HF libraries (<code>transformers</code>, <code>datasets</code>, <code>gradio</code>,..) to monitor usage, debug issues and help prioritize features.
Each library defines its own policy (i.e. which usage to monitor) but the core implementation happens in <code>huggingface_hub</code> (see <code>send_telemetry</code>).`,Ft,ce,Fi="You can set <code>HF_HUB_DISABLE_TELEMETRY=1</code> as environment variable to globally disable telemetry.",At,pe,St,me,Ai="Set to <code>True</code> for faster uploads and downloads from the Hub using <code>hf_transfer</code>.",Bt,ge,Si=`By default, <code>huggingface_hub</code> uses the Python-based <code>requests.get</code> and <code>requests.post</code> functions.
Although these are reliable and versatile,
they may not be the most efficient choice for machines with high bandwidth.
<a href="https://github.com/huggingface/hf_transfer" rel="nofollow"><code>hf_transfer</code></a> is a Rust-based package developed to
maximize the bandwidth used by dividing large files into smaller parts
and transferring them simultaneously using multiple threads.
This approach can potentially double the transfer speed.
To use <code>hf_transfer</code>:`,Pt,_e,Bi=`<li>Specify the <code>hf_transfer</code> extra when installing <code>huggingface_hub</code>
(e.g. <code>pip install huggingface_hub[hf_transfer]</code>).</li> <li>Set <code>HF_HUB_ENABLE_HF_TRANSFER=1</code> as an environment variable.</li>`,qt,He,Pi="Please note that using <code>hf_transfer</code> comes with certain limitations. Since it is not purely Python-based, debugging errors may be challenging. Additionally, <code>hf_transfer</code> lacks several user-friendly features such as resumable downloads and proxies. These omissions are intentional to maintain the simplicity and speed of the Rust logic. Consequently, <code>hf_transfer</code> is not enabled by default in <code>huggingface_hub</code>.",Ot,be,Nt,ve,qi="In order to standardize all environment variables within the Hugging Face ecosystem, some variables have been marked as deprecated. Although they remain functional, they no longer take precedence over their replacements. The following table outlines the deprecated variables and their corresponding alternatives:",kt,$e,Oi="<thead><tr><th>Deprecated Variable</th> <th>Replacement</th></tr></thead> <tbody><tr><td><code>HUGGINGFACE_HUB_CACHE</code></td> <td><code>HF_HUB_CACHE</code></td></tr> <tr><td><code>HUGGINGFACE_ASSETS_CACHE</code></td> <td><code>HF_ASSETS_CACHE</code></td></tr> <tr><td><code>HUGGING_FACE_HUB_TOKEN</code></td> <td><code>HF_TOKEN</code></td></tr> <tr><td><code>HUGGINGFACE_HUB_VERBOSITY</code></td> <td><code>HF_HUB_VERBOSITY</code></td></tr></tbody>",Ut,Te,Rt,we,Ni="Some environment variables are not specific to <code>huggingface_hub</code> but are still taken into account when they are set.",Dt,Le,Gt,Ee,ki='Boolean value. Equivalent to <code>HF_HUB_DISABLE_TELEMETRY</code>. When set to true, telemetry is globally disabled in the Hugging Face Python ecosystem (<code>transformers</code>, <code>diffusers</code>, <code>gradio</code>, etc.). See <a href="https://consoledonottrack.com/" rel="nofollow">https://consoledonottrack.com/</a> for more details.',Yt,ye,zt,Me,Ui=`Boolean value. When set, <code>huggingface-cli</code> tool will not print any ANSI color.
See <a href="https://no-color.org/" rel="nofollow">no-color.org</a>.`,Kt,xe,Wt,Ce,Ri="Used only when <code>HF_HOME</code> is not set!",jt,Ie,Di=`This is the default way to configure where <a href="https://wiki.archlinux.org/title/XDG_Base_Directory" rel="nofollow">user-specific non-essential (cached) data should be written</a>
on linux machines.`,Xt,Fe,Gi=`If <code>HF_HOME</code> is not set, the default home will be <code>&quot;$XDG_CACHE_HOME/huggingface&quot;</code> instead
of <code>&quot;~/.cache/huggingface&quot;</code>.`,Vt,Se,Jt;return _=new m({props:{title:"Environment variables",local:"environment-variables",headingTag:"h1"}}),$=new m({props:{title:"Generic",local:"generic",headingTag:"h2"}}),T=new m({props:{title:"HF_INFERENCE_ENDPOINT",local:"hfinferenceendpoint",headingTag:"h3"}}),E=new m({props:{title:"HF_HOME",local:"hfhome",headingTag:"h3"}}),x=new m({props:{title:"HF_HUB_CACHE",local:"hfhubcache",headingTag:"h3"}}),F=new m({props:{title:"HF_ASSETS_CACHE",local:"hfassetscache",headingTag:"h3"}}),B=new m({props:{title:"HF_TOKEN",local:"hftoken",headingTag:"h3"}}),O=new m({props:{title:"HF_HUB_VERBOSITY",local:"hfhubverbosity",headingTag:"h3"}}),R=new m({props:{title:"HF_HUB_LOCAL_DIR_AUTO_SYMLINK_THRESHOLD",local:"hfhublocaldirautosymlinkthreshold",headingTag:"h3"}}),Y=new m({props:{title:"HF_HUB_ETAG_TIMEOUT",local:"hfhubetagtimeout",headingTag:"h3"}}),K=new m({props:{title:"HF_HUB_DOWNLOAD_TIMEOUT",local:"hfhubdownloadtimeout",headingTag:"h3"}}),j=new m({props:{title:"Boolean values",local:"boolean-values",headingTag:"h2"}}),V=new m({props:{title:"HF_HUB_OFFLINE",local:"hfhuboffline",headingTag:"h3"}}),ee=new m({props:{title:"HF_HUB_DISABLE_IMPLICIT_TOKEN",local:"hfhubdisableimplicittoken",headingTag:"h3"}}),le=new m({props:{title:"HF_HUB_DISABLE_PROGRESS_BARS",local:"hfhubdisableprogressbars",headingTag:"h3"}}),ae=new m({props:{title:"HF_HUB_DISABLE_SYMLINKS_WARNING",local:"hfhubdisablesymlinkswarning",headingTag:"h3"}}),re=new m({props:{title:"HF_HUB_DISABLE_EXPERIMENTAL_WARNING",local:"hfhubdisableexperimentalwarning",headingTag:"h3"}}),de=new m({props:{title:"HF_HUB_DISABLE_TELEMETRY",local:"hfhubdisabletelemetry",headingTag:"h3"}}),pe=new m({props:{title:"HF_HUB_ENABLE_HF_TRANSFER",local:"hfhubenablehftransfer",headingTag:"h3"}}),be=new m({props:{title:"Deprecated environment variables",local:"deprecated-environment-variables",headingTag:"h2"}}),Te=new m({props:{title:"From external tools",local:"from-external-tools",headingTag:"h2"}}),Le=new m({props:{title:"DO_NOT_TRACK",local:"donottrack",headingTag:"h3"}}),ye=new m({props:{title:"NO_COLOR",local:"nocolor",headingTag:"h3"}}),xe=new m({props:{title:"XDG_CACHE_HOME",local:"xdgcachehome",headingTag:"h3"}}),{c(){g=o("meta"),Be=n(),Ae=o("p"),Pe=n(),f(_.$$.fragment),qe=n(),H=o("p"),H.innerHTML=Zt,Oe=n(),b=o("p"),b.innerHTML=ei,Ne=n(),v=o("p"),v.innerHTML=ti,ke=n(),f($.$$.fragment),Ue=n(),f(T.$$.fragment),Re=n(),w=o("p"),w.textContent=ii,De=n(),L=o("p"),L.innerHTML=li,Ge=n(),f(E.$$.fragment),Ye=n(),y=o("p"),y.innerHTML=ni,ze=n(),M=o("p"),M.innerHTML=ai,Ke=n(),f(x.$$.fragment),We=n(),C=o("p"),C.textContent=oi,je=n(),I=o("p"),I.innerHTML=si,Xe=n(),f(F.$$.fragment),Ve=n(),A=o("p"),A.innerHTML=ri,Je=n(),S=o("p"),S.innerHTML=fi,Qe=n(),f(B.$$.fragment),Ze=n(),P=o("p"),P.innerHTML=ui,et=n(),q=o("p"),q.innerHTML=di,tt=n(),f(O.$$.fragment),it=n(),N=o("p"),N.innerHTML=hi,lt=n(),k=o("p"),k.innerHTML=ci,nt=n(),U=o("p"),U.innerHTML=pi,at=n(),f(R.$$.fragment),ot=n(),D=o("p"),D.textContent=mi,st=n(),G=o("p"),G.innerHTML=gi,rt=n(),f(Y.$$.fragment),ft=n(),z=o("p"),z.innerHTML=_i,ut=n(),f(K.$$.fragment),dt=n(),W=o("p"),W.textContent=Hi,ht=n(),f(j.$$.fragment),ct=n(),X=o("p"),X.innerHTML=bi,pt=n(),f(V.$$.fragment),mt=n(),J=o("p"),J.textContent=vi,gt=n(),Q=o("p"),Q.innerHTML=$i,_t=n(),Z=o("p"),Z.innerHTML=Ti,Ht=n(),f(ee.$$.fragment),bt=n(),te=o("p"),te.innerHTML=wi,vt=n(),ie=o("p"),ie.innerHTML=Li,$t=n(),f(le.$$.fragment),Tt=n(),ne=o("p"),ne.innerHTML=Ei,wt=n(),f(ae.$$.fragment),Lt=n(),oe=o("p"),oe.innerHTML=yi,Et=n(),se=o("p"),se.innerHTML=Mi,yt=n(),f(re.$$.fragment),Mt=n(),fe=o("p"),fe.innerHTML=xi,xt=n(),ue=o("p"),ue.textContent=Ci,Ct=n(),f(de.$$.fragment),It=n(),he=o("p"),he.innerHTML=Ii,Ft=n(),ce=o("p"),ce.innerHTML=Fi,At=n(),f(pe.$$.fragment),St=n(),me=o("p"),me.innerHTML=Ai,Bt=n(),ge=o("p"),ge.innerHTML=Si,Pt=n(),_e=o("ol"),_e.innerHTML=Bi,qt=n(),He=o("p"),He.innerHTML=Pi,Ot=n(),f(be.$$.fragment),Nt=n(),ve=o("p"),ve.textContent=qi,kt=n(),$e=o("table"),$e.innerHTML=Oi,Ut=n(),f(Te.$$.fragment),Rt=n(),we=o("p"),we.innerHTML=Ni,Dt=n(),f(Le.$$.fragment),Gt=n(),Ee=o("p"),Ee.innerHTML=ki,Yt=n(),f(ye.$$.fragment),zt=n(),Me=o("p"),Me.innerHTML=Ui,Kt=n(),f(xe.$$.fragment),Wt=n(),Ce=o("p"),Ce.innerHTML=Ri,jt=n(),Ie=o("p"),Ie.innerHTML=Di,Xt=n(),Fe=o("p"),Fe.innerHTML=Gi,Vt=n(),Se=o("p"),this.h()},l(e){const t=Ji("svelte-u9bgzb",document.head);g=s(t,"META",{name:!0,content:!0}),t.forEach(i),Be=a(e),Ae=s(e,"P",{}),Yi(Ae).forEach(i),Pe=a(e),u(_.$$.fragment,e),qe=a(e),H=s(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1xuew16"&&(H.innerHTML=Zt),Oe=a(e),b=s(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1by1ave"&&(b.innerHTML=ei),Ne=a(e),v=s(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-5z5k2g"&&(v.innerHTML=ti),ke=a(e),u($.$$.fragment,e),Ue=a(e),u(T.$$.fragment,e),Re=a(e),w=s(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-178hqev"&&(w.textContent=ii),De=a(e),L=s(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1jcmi14"&&(L.innerHTML=li),Ge=a(e),u(E.$$.fragment,e),Ye=a(e),y=s(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-uz9mxv"&&(y.innerHTML=ni),ze=a(e),M=s(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1x0d3ca"&&(M.innerHTML=ai),Ke=a(e),u(x.$$.fragment,e),We=a(e),C=s(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-lfw4ab"&&(C.textContent=oi),je=a(e),I=s(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-a5p60a"&&(I.innerHTML=si),Xe=a(e),u(F.$$.fragment,e),Ve=a(e),A=s(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-ksjawo"&&(A.innerHTML=ri),Je=a(e),S=s(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-3wzlwo"&&(S.innerHTML=fi),Qe=a(e),u(B.$$.fragment,e),Ze=a(e),P=s(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-dnq5h3"&&(P.innerHTML=ui),et=a(e),q=s(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-pa4dpn"&&(q.innerHTML=di),tt=a(e),u(O.$$.fragment,e),it=a(e),N=s(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-t9rwl1"&&(N.innerHTML=hi),lt=a(e),k=s(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-4zt9wc"&&(k.innerHTML=ci),nt=a(e),U=s(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-5rzz4d"&&(U.innerHTML=pi),at=a(e),u(R.$$.fragment,e),ot=a(e),D=s(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-gmny4d"&&(D.textContent=mi),st=a(e),G=s(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-18kg6sw"&&(G.innerHTML=gi),rt=a(e),u(Y.$$.fragment,e),ft=a(e),z=s(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-14q9j1n"&&(z.innerHTML=_i),ut=a(e),u(K.$$.fragment,e),dt=a(e),W=s(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-8qjsc"&&(W.textContent=Hi),ht=a(e),u(j.$$.fragment,e),ct=a(e),X=s(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1enkv8e"&&(X.innerHTML=bi),pt=a(e),u(V.$$.fragment,e),mt=a(e),J=s(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-l2giw3"&&(J.textContent=vi),gt=a(e),Q=s(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-o9ntbs"&&(Q.innerHTML=$i),_t=a(e),Z=s(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-p6ydxq"&&(Z.innerHTML=Ti),Ht=a(e),u(ee.$$.fragment,e),bt=a(e),te=s(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1gxpflx"&&(te.innerHTML=wi),vt=a(e),ie=s(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-d0rh1g"&&(ie.innerHTML=Li),$t=a(e),u(le.$$.fragment,e),Tt=a(e),ne=s(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-192tmol"&&(ne.innerHTML=Ei),wt=a(e),u(ae.$$.fragment,e),Lt=a(e),oe=s(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1a5ggf9"&&(oe.innerHTML=yi),Et=a(e),se=s(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1wsb5xe"&&(se.innerHTML=Mi),yt=a(e),u(re.$$.fragment,e),Mt=a(e),fe=s(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-16gkjc3"&&(fe.innerHTML=xi),xt=a(e),ue=s(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-140g1ix"&&(ue.textContent=Ci),Ct=a(e),u(de.$$.fragment,e),It=a(e),he=s(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-yphpce"&&(he.innerHTML=Ii),Ft=a(e),ce=s(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-h3tzls"&&(ce.innerHTML=Fi),At=a(e),u(pe.$$.fragment,e),St=a(e),me=s(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1nmal47"&&(me.innerHTML=Ai),Bt=a(e),ge=s(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1qiqswm"&&(ge.innerHTML=Si),Pt=a(e),_e=s(e,"OL",{"data-svelte-h":!0}),r(_e)!=="svelte-qiartd"&&(_e.innerHTML=Bi),qt=a(e),He=s(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-a4nd83"&&(He.innerHTML=Pi),Ot=a(e),u(be.$$.fragment,e),Nt=a(e),ve=s(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1xlsmjd"&&(ve.textContent=qi),kt=a(e),$e=s(e,"TABLE",{"data-svelte-h":!0}),r($e)!=="svelte-19wux3d"&&($e.innerHTML=Oi),Ut=a(e),u(Te.$$.fragment,e),Rt=a(e),we=s(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-6ntlb2"&&(we.innerHTML=Ni),Dt=a(e),u(Le.$$.fragment,e),Gt=a(e),Ee=s(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-yngnil"&&(Ee.innerHTML=ki),Yt=a(e),u(ye.$$.fragment,e),zt=a(e),Me=s(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-16nqegp"&&(Me.innerHTML=Ui),Kt=a(e),u(xe.$$.fragment,e),Wt=a(e),Ce=s(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-38e7oi"&&(Ce.innerHTML=Ri),jt=a(e),Ie=s(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-khdsxn"&&(Ie.innerHTML=Di),Xt=a(e),Fe=s(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-hhj9xt"&&(Fe.innerHTML=Gi),Vt=a(e),Se=s(e,"P",{}),Yi(Se).forEach(i),this.h()},h(){zi(g,"name","hf:doc:metadata"),zi(g,"content",el)},m(e,t){Qi(document.head,g),l(e,Be,t),l(e,Ae,t),l(e,Pe,t),d(_,e,t),l(e,qe,t),l(e,H,t),l(e,Oe,t),l(e,b,t),l(e,Ne,t),l(e,v,t),l(e,ke,t),d($,e,t),l(e,Ue,t),d(T,e,t),l(e,Re,t),l(e,w,t),l(e,De,t),l(e,L,t),l(e,Ge,t),d(E,e,t),l(e,Ye,t),l(e,y,t),l(e,ze,t),l(e,M,t),l(e,Ke,t),d(x,e,t),l(e,We,t),l(e,C,t),l(e,je,t),l(e,I,t),l(e,Xe,t),d(F,e,t),l(e,Ve,t),l(e,A,t),l(e,Je,t),l(e,S,t),l(e,Qe,t),d(B,e,t),l(e,Ze,t),l(e,P,t),l(e,et,t),l(e,q,t),l(e,tt,t),d(O,e,t),l(e,it,t),l(e,N,t),l(e,lt,t),l(e,k,t),l(e,nt,t),l(e,U,t),l(e,at,t),d(R,e,t),l(e,ot,t),l(e,D,t),l(e,st,t),l(e,G,t),l(e,rt,t),d(Y,e,t),l(e,ft,t),l(e,z,t),l(e,ut,t),d(K,e,t),l(e,dt,t),l(e,W,t),l(e,ht,t),d(j,e,t),l(e,ct,t),l(e,X,t),l(e,pt,t),d(V,e,t),l(e,mt,t),l(e,J,t),l(e,gt,t),l(e,Q,t),l(e,_t,t),l(e,Z,t),l(e,Ht,t),d(ee,e,t),l(e,bt,t),l(e,te,t),l(e,vt,t),l(e,ie,t),l(e,$t,t),d(le,e,t),l(e,Tt,t),l(e,ne,t),l(e,wt,t),d(ae,e,t),l(e,Lt,t),l(e,oe,t),l(e,Et,t),l(e,se,t),l(e,yt,t),d(re,e,t),l(e,Mt,t),l(e,fe,t),l(e,xt,t),l(e,ue,t),l(e,Ct,t),d(de,e,t),l(e,It,t),l(e,he,t),l(e,Ft,t),l(e,ce,t),l(e,At,t),d(pe,e,t),l(e,St,t),l(e,me,t),l(e,Bt,t),l(e,ge,t),l(e,Pt,t),l(e,_e,t),l(e,qt,t),l(e,He,t),l(e,Ot,t),d(be,e,t),l(e,Nt,t),l(e,ve,t),l(e,kt,t),l(e,$e,t),l(e,Ut,t),d(Te,e,t),l(e,Rt,t),l(e,we,t),l(e,Dt,t),d(Le,e,t),l(e,Gt,t),l(e,Ee,t),l(e,Yt,t),d(ye,e,t),l(e,zt,t),l(e,Me,t),l(e,Kt,t),d(xe,e,t),l(e,Wt,t),l(e,Ce,t),l(e,jt,t),l(e,Ie,t),l(e,Xt,t),l(e,Fe,t),l(e,Vt,t),l(e,Se,t),Jt=!0},p:Wi,i(e){Jt||(h(_.$$.fragment,e),h($.$$.fragment,e),h(T.$$.fragment,e),h(E.$$.fragment,e),h(x.$$.fragment,e),h(F.$$.fragment,e),h(B.$$.fragment,e),h(O.$$.fragment,e),h(R.$$.fragment,e),h(Y.$$.fragment,e),h(K.$$.fragment,e),h(j.$$.fragment,e),h(V.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(pe.$$.fragment,e),h(be.$$.fragment,e),h(Te.$$.fragment,e),h(Le.$$.fragment,e),h(ye.$$.fragment,e),h(xe.$$.fragment,e),Jt=!0)},o(e){c(_.$$.fragment,e),c($.$$.fragment,e),c(T.$$.fragment,e),c(E.$$.fragment,e),c(x.$$.fragment,e),c(F.$$.fragment,e),c(B.$$.fragment,e),c(O.$$.fragment,e),c(R.$$.fragment,e),c(Y.$$.fragment,e),c(K.$$.fragment,e),c(j.$$.fragment,e),c(V.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(pe.$$.fragment,e),c(be.$$.fragment,e),c(Te.$$.fragment,e),c(Le.$$.fragment,e),c(ye.$$.fragment,e),c(xe.$$.fragment,e),Jt=!1},d(e){e&&(i(Be),i(Ae),i(Pe),i(qe),i(H),i(Oe),i(b),i(Ne),i(v),i(ke),i(Ue),i(Re),i(w),i(De),i(L),i(Ge),i(Ye),i(y),i(ze),i(M),i(Ke),i(We),i(C),i(je),i(I),i(Xe),i(Ve),i(A),i(Je),i(S),i(Qe),i(Ze),i(P),i(et),i(q),i(tt),i(it),i(N),i(lt),i(k),i(nt),i(U),i(at),i(ot),i(D),i(st),i(G),i(rt),i(ft),i(z),i(ut),i(dt),i(W),i(ht),i(ct),i(X),i(pt),i(mt),i(J),i(gt),i(Q),i(_t),i(Z),i(Ht),i(bt),i(te),i(vt),i(ie),i($t),i(Tt),i(ne),i(wt),i(Lt),i(oe),i(Et),i(se),i(yt),i(Mt),i(fe),i(xt),i(ue),i(Ct),i(It),i(he),i(Ft),i(ce),i(At),i(St),i(me),i(Bt),i(ge),i(Pt),i(_e),i(qt),i(He),i(Ot),i(Nt),i(ve),i(kt),i($e),i(Ut),i(Rt),i(we),i(Dt),i(Gt),i(Ee),i(Yt),i(zt),i(Me),i(Kt),i(Wt),i(Ce),i(jt),i(Ie),i(Xt),i(Fe),i(Vt),i(Se)),i(g),p(_,e),p($,e),p(T,e),p(E,e),p(x,e),p(F,e),p(B,e),p(O,e),p(R,e),p(Y,e),p(K,e),p(j,e),p(V,e),p(ee,e),p(le,e),p(ae,e),p(re,e),p(de,e),p(pe,e),p(be,e),p(Te,e),p(Le,e),p(ye,e),p(xe,e)}}}const el='{"title":"Environment variables","local":"environment-variables","sections":[{"title":"Generic","local":"generic","sections":[{"title":"HF_INFERENCE_ENDPOINT","local":"hfinferenceendpoint","sections":[],"depth":3},{"title":"HF_HOME","local":"hfhome","sections":[],"depth":3},{"title":"HF_HUB_CACHE","local":"hfhubcache","sections":[],"depth":3},{"title":"HF_ASSETS_CACHE","local":"hfassetscache","sections":[],"depth":3},{"title":"HF_TOKEN","local":"hftoken","sections":[],"depth":3},{"title":"HF_HUB_VERBOSITY","local":"hfhubverbosity","sections":[],"depth":3},{"title":"HF_HUB_LOCAL_DIR_AUTO_SYMLINK_THRESHOLD","local":"hfhublocaldirautosymlinkthreshold","sections":[],"depth":3},{"title":"HF_HUB_ETAG_TIMEOUT","local":"hfhubetagtimeout","sections":[],"depth":3},{"title":"HF_HUB_DOWNLOAD_TIMEOUT","local":"hfhubdownloadtimeout","sections":[],"depth":3}],"depth":2},{"title":"Boolean values","local":"boolean-values","sections":[{"title":"HF_HUB_OFFLINE","local":"hfhuboffline","sections":[],"depth":3},{"title":"HF_HUB_DISABLE_IMPLICIT_TOKEN","local":"hfhubdisableimplicittoken","sections":[],"depth":3},{"title":"HF_HUB_DISABLE_PROGRESS_BARS","local":"hfhubdisableprogressbars","sections":[],"depth":3},{"title":"HF_HUB_DISABLE_SYMLINKS_WARNING","local":"hfhubdisablesymlinkswarning","sections":[],"depth":3},{"title":"HF_HUB_DISABLE_EXPERIMENTAL_WARNING","local":"hfhubdisableexperimentalwarning","sections":[],"depth":3},{"title":"HF_HUB_DISABLE_TELEMETRY","local":"hfhubdisabletelemetry","sections":[],"depth":3},{"title":"HF_HUB_ENABLE_HF_TRANSFER","local":"hfhubenablehftransfer","sections":[],"depth":3}],"depth":2},{"title":"Deprecated environment variables","local":"deprecated-environment-variables","sections":[],"depth":2},{"title":"From external tools","local":"from-external-tools","sections":[{"title":"DO_NOT_TRACK","local":"donottrack","sections":[],"depth":3},{"title":"NO_COLOR","local":"nocolor","sections":[],"depth":3},{"title":"XDG_CACHE_HOME","local":"xdgcachehome","sections":[],"depth":3}],"depth":2}],"depth":1}';function tl(Qt){return ji(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class al extends Xi{constructor(g){super(),Vi(this,g,tl,Zi,Ki,{})}}export{al as component};
