import{s as sn,o as an,n as Ma}from"../chunks/scheduler.182ea377.js";import{S as nn,i as pn,g as n,s as a,p as c,A as on,h as p,f as l,c as i,j,q as m,m as o,k as M,v as f,a as s,r as d,d as h,t as u,u as w}from"../chunks/index.008d68e4.js";import{T as ma}from"../chunks/Tip.4f096367.js";import{I as Qt}from"../chunks/IconCopyLink.96bbb92b.js";import{C as y}from"../chunks/CodeBlock.5ed6eb7b.js";function rn(B){let r,b=`It is useful to look at some inference samples while a model is training to measure the
training progress. In our <a href="https://github.com/huggingface/diffusers/tree/main/examples/" rel="nofollow">training scripts</a>, we support this utility with additional support for
logging to TensorBoard and Weights &amp; Biases.`;return{c(){r=n("p"),r.innerHTML=b},l(J){r=p(J,"P",{"data-svelte-h":!0}),o(r)!=="svelte-1yulmeg"&&(r.innerHTML=b)},m(J,T){s(J,r,T)},p:Ma,d(J){J&&l(r)}}}function cn(B){let r,b=`By construction, there are some limitations in this score. The captions in the training dataset
were crawled from the web and extracted from <code>alt</code> and similar tags associated an image on the internet.
They are not necessarily representative of what a human being would use to describe an image. Hence we
had to “engineer” some prompts here.`;return{c(){r=n("p"),r.innerHTML=b},l(J){r=p(J,"P",{"data-svelte-h":!0}),o(r)!=="svelte-17jek1b"&&(r.innerHTML=b)},m(J,T){s(J,r,T)},p:Ma,d(J){J&&l(r)}}}function mn(B){let r,b="Both CLIP score and CLIP direction similarity rely on the CLIP model, which can make the evaluations biased.";return{c(){r=n("p"),r.textContent=b},l(J){r=p(J,"P",{"data-svelte-h":!0}),o(r)!=="svelte-1jj27lk"&&(r.textContent=b)},m(J,T){s(J,r,T)},p:Ma,d(J){J&&l(r)}}}function Mn(B){let r,b="FID results tend to be fragile as they depend on a lot of factors:",J,T,R="<li>The specific Inception model used during computation.</li> <li>The implementation accuracy of the computation.</li> <li>The image format (not the same if we start from PNGs vs JPGs).</li>",g,Z,_=`Keeping that in mind, FID is often most useful when comparing similar runs, but it is
hard to reproduce paper results unless the authors carefully disclose the FID
measurement code.`,q,I,v="These points apply to other related metrics too, such as KID and IS.";return{c(){r=n("p"),r.textContent=b,J=a(),T=n("ul"),T.innerHTML=R,g=a(),Z=n("p"),Z.textContent=_,q=a(),I=n("p"),I.textContent=v},l(U){r=p(U,"P",{"data-svelte-h":!0}),o(r)!=="svelte-nu8das"&&(r.textContent=b),J=i(U),T=p(U,"UL",{"data-svelte-h":!0}),o(T)!=="svelte-1u7ggn4"&&(T.innerHTML=R),g=i(U),Z=p(U,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-tbdsq8"&&(Z.textContent=_),q=i(U),I=p(U,"P",{"data-svelte-h":!0}),o(I)!=="svelte-11vfq1v"&&(I.textContent=v)},m(U,C){s(U,r,C),s(U,J,C),s(U,T,C),s(U,g,C),s(U,Z,C),s(U,q,C),s(U,I,C)},p:Ma,d(U){U&&(l(r),l(J),l(T),l(g),l(Z),l(q),l(I))}}}function dn(B){let r,b,J,T,R,g,Z,_,q="Evaluating Diffusion Models",I,v,U='<img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/>',C,D,ya='Evaluation of generative models like <a href="https://huggingface.co/docs/diffusers/stable_diffusion" rel="nofollow">Stable Diffusion</a> is subjective in nature. But as practitioners and researchers, we often have to make careful choices amongst many different possibilities. So, when working with different generative models (like GANs, Diffusion, etc.), how do we choose one over the other?',pl,K,Ta=`Qualitative evaluation of such models can be error-prone and might incorrectly influence a decision.
However, quantitative metrics don’t necessarily correspond to image quality. So, usually, a combination
of both qualitative and quantitative evaluations provides a stronger signal when choosing one model
over the other.`,ol,O,ja="In this document, we provide a non-exhaustive overview of qualitative and quantitative methods to evaluate Diffusion models. For quantitative methods, we specifically focus on how to implement them alongside <code>diffusers</code>.",rl,ee,Ua='The methods shown in this document can also be used to evaluate different <a href="https://huggingface.co/docs/diffusers/main/en/api/schedulers/overview" rel="nofollow">noise schedulers</a> keeping the underlying generation model fixed.',cl,W,N,Ot,te,da,zt,ba="Scenarios",ml,le,ga="We cover Diffusion models with the following pipelines:",Ml,se,Ia='<li>Text-guided image generation (such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img" rel="nofollow"><code>StableDiffusionPipeline</code></a>).</li> <li>Text-guided image generation, additionally conditioned on an input image (such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img" rel="nofollow"><code>StableDiffusionImg2ImgPipeline</code></a> and <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/pix2pix" rel="nofollow"><code>StableDiffusionInstructPix2PixPipeline</code></a>).</li> <li>Class-conditioned image generation models (such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/dit" rel="nofollow"><code>DiTPipeline</code></a>).</li>',dl,G,H,el,ae,ha,Lt,va="Qualitative Evaluation",hl,ie,Ca=`Qualitative evaluation typically involves human assessment of generated images. Quality is measured across aspects such as compositionality, image-text alignment, and spatial relations. Common prompts provide a degree of uniformity for subjective metrics.
DrawBench and PartiPrompts are prompt datasets used for qualitative benchmarking. DrawBench and PartiPrompts were introduced by <a href="https://imagen.research.google/" rel="nofollow">Imagen</a> and <a href="https://parti.research.google/" rel="nofollow">Parti</a> respectively.`,ul,ne,Za='From the <a href="https://parti.research.google/" rel="nofollow">official Parti website</a>:',wl,pe,Ba="<p>PartiPrompts (P2) is a rich set of over 1600 prompts in English that we release as part of this work. P2 can be used to measure model capabilities across various categories and challenge aspects.</p>",Jl,oe,_a='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/parti-prompts.png" alt="parti-prompts"/>',fl,re,Wa="PartiPrompts has the following columns:",yl,ce,Ga="<li>Prompt</li> <li>Category of the prompt (such as “Abstract”, “World Knowledge”, etc.)</li> <li>Challenge reflecting the difficulty (such as “Basic”, “Complex”, “Writing &amp; Symbols”, etc.)</li>",Tl,me,xa="These benchmarks allow for side-by-side human evaluation of different image generation models.",jl,Me,ka="For this, the 🧨 Diffusers team has built <strong>Open Parti Prompts</strong>, which is a community-driven qualitative benchmark based on Parti Prompts to compare state-of-the-art open-source diffusion models:",Ul,de,Xa='<li><a href="https://huggingface.co/spaces/OpenGenAI/open-parti-prompts" rel="nofollow">Open Parti Prompts Game</a>: For 10 parti prompts, 4 generated images are shown and the user selects the image that suits the prompt best.</li> <li><a href="https://huggingface.co/spaces/OpenGenAI/parti-prompts-leaderboard" rel="nofollow">Open Parti Prompts Leaderboard</a>: The leaderboard comparing the currently best open-sourced diffusion models to each other.</li>',bl,he,Va="To manually compare images, let’s see how we can use <code>diffusers</code> on a couple of PartiPrompts.",gl,ue,Ra='Below we show some prompts sampled across different challenges: Basic, Complex, Linguistic Structures, Imagination, and Writing &amp; Symbols. Here we are using PartiPrompts as a <a href="https://huggingface.co/datasets/nateraw/parti-prompts" rel="nofollow">dataset</a>.',Il,we,vl,Je,Na='Now we can use these prompts to generate some images using Stable Diffusion (<a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow">v1-4 checkpoint</a>):',Cl,fe,Zl,ye,Ha='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/parti-prompts-14.png" alt="parti-prompts-14"/>',Bl,Te,Fa='We can also set <code>num_images_per_prompt</code> accordingly to compare different images for the same prompt. Running the same pipeline but with a different checkpoint (<a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">v1-5</a>), yields:',_l,je,Ea='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/parti-prompts-15.png" alt="parti-prompts-15"/>',Wl,Ue,$a=`Once several images are generated from all the prompts using multiple models (under evaluation), these results are presented to human evaluators for scoring. For
more details on the DrawBench and PartiPrompts benchmarks, refer to their respective papers.`,Gl,F,xl,x,E,tl,be,ua,Pt,Aa="Quantitative Evaluation",kl,ge,Ya="In this section, we will walk you through how to evaluate three different diffusion pipelines using:",Xl,Ie,Sa="<li>CLIP score</li> <li>CLIP directional similarity</li> <li>FID</li>",Vl,k,$,ll,ve,wa,qt,Qa="Text-guided image generation",Rl,Ce,za='<a href="https://arxiv.org/abs/2104.08718" rel="nofollow">CLIP score</a> measures the compatibility of image-caption pairs. Higher CLIP scores imply higher compatibility 🔼. The CLIP score is a quantitative measurement of the qualitative concept “compatibility”. Image-caption pair compatibility can also be thought of as the semantic similarity between the image and the caption. CLIP score was found to have high correlation with human judgement.',Nl,Ze,La='Let’s first load a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>:',Hl,Be,Fl,_e,Pa="Generate some images with multiple prompts:",El,We,$l,Ge,qa="And then, we calculate the CLIP score.",Al,xe,Yl,ke,Da="In the above example, we generated one image per prompt. If we generated multiple images per prompt, we would have to take the average score from the generated images per prompt.",Sl,Xe,Ka=`Now, if we wanted to compare two checkpoints compatible with the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> we should pass a generator while calling the pipeline. First, we generate images with a
fixed seed with the <a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow">v1-4 Stable Diffusion checkpoint</a>:`,Ql,Ve,zl,Re,Oa='Then we load the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">v1-5 checkpoint</a> to generate images:',Ll,Ne,Pl,He,ei="And finally, we compare their CLIP scores:",ql,Fe,Dl,Ee,ti='It seems like the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">v1-5</a> checkpoint performs better than its predecessor. Note, however, that the number of prompts we used to compute the CLIP scores is quite low. For a more practical evaluation, this number should be way higher, and the prompts should be diverse.',Kl,A,Ol,X,Y,sl,$e,Ja,Dt,li="Image-conditioned text-to-image generation",es,Ae,si='In this case, we condition the generation pipeline with an input image as well as a text prompt. Let’s take the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/pix2pix#diffusers.StableDiffusionInstructPix2PixPipeline">StableDiffusionInstructPix2PixPipeline</a>, as an example. It takes an edit instruction as an input prompt and an input image to be edited.',ts,Ye,ai="Here is one example:",ls,Se,ii='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/edit-instruction.png" alt="edit-instruction"/>',ss,Qe,ni='One strategy to evaluate such a model is to measure the consistency of the change between the two images (in <a href="https://huggingface.co/docs/transformers/model_doc/clip" rel="nofollow">CLIP</a> space) with the change between the two image captions (as shown in <a href="https://arxiv.org/abs/2108.00946" rel="nofollow">CLIP-Guided Domain Adaptation of Image Generators</a>). This is referred to as the ”<strong>CLIP directional similarity</strong>“.',as,ze,pi="<li>Caption 1 corresponds to the input image (image 1) that is to be edited.</li> <li>Caption 2 corresponds to the edited image (image 2). It should reflect the edit instruction.</li>",is,Le,oi="Following is a pictorial overview:",ns,Pe,ri='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/edit-consistency.png" alt="edit-consistency"/>',ps,qe,ci="We have prepared a mini dataset to implement this metric. Let’s first load the dataset.",os,De,rs,Ke,cs,Oe,mi="Here we have:",ms,et,Mi="<li><code>input</code> is a caption corresponding to the <code>image</code>.</li> <li><code>edit</code> denotes the edit instruction.</li> <li><code>output</code> denotes the modified caption reflecting the <code>edit</code> instruction.</li>",Ms,tt,di="Let’s take a look at a sample.",ds,lt,hs,st,us,at,hi="And here is the image:",ws,it,Js,nt,ui='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/edit-dataset.png" alt="edit-dataset"/>',fs,pt,wi="We will first edit the images of our dataset with the edit instruction and compute the directional similarity.",ys,ot,Ji='Let’s first load the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/pix2pix#diffusers.StableDiffusionInstructPix2PixPipeline">StableDiffusionInstructPix2PixPipeline</a>:',Ts,rt,js,ct,fi="Now, we perform the edits:",Us,mt,bs,Mt,yi="To measure the directional similarity, we first load CLIP’s image and text encoders:",gs,dt,Is,ht,Ti='Notice that we are using a particular CLIP checkpoint, i.e., <code>openai/clip-vit-large-patch14</code>. This is because the Stable Diffusion pre-training was performed with this CLIP variant. For more details, refer to the <a href="https://huggingface.co/docs/transformers/model_doc/clip" rel="nofollow">documentation</a>.',vs,ut,ji="Next, we prepare a PyTorch <code>nn.Module</code> to compute directional similarity:",Cs,wt,Zs,Jt,Ui="Let’s put <code>DirectionalSimilarity</code> to use now.",Bs,ft,_s,yt,bi="Like the CLIP Score, the higher the CLIP directional similarity, the better it is.",Ws,Tt,gi="It should be noted that the <code>StableDiffusionInstructPix2PixPipeline</code> exposes two arguments, namely, <code>image_guidance_scale</code> and <code>guidance_scale</code> that let you control the quality of the final edited image. We encourage you to experiment with these two arguments and see the impact of that on the directional similarity.",Gs,jt,Ii="We can extend the idea of this metric to measure how similar the original image and edited version are. To do that, we can just do <code>F.cosine_similarity(img_feat_two, img_feat_one)</code>. For these kinds of edits, we would still want the primary semantics of the images to be preserved as much as possible, i.e., a high similarity score.",xs,Ut,vi='We can use these metrics for similar pipelines such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/pix2pix_zero#diffusers.StableDiffusionPix2PixZeroPipeline" rel="nofollow"><code>StableDiffusionPix2PixZeroPipeline</code></a>.',ks,S,Xs,bt,Ci='<strong><em>Extending metrics like IS, FID (discussed later), or KID can be difficult</em></strong> when the model under evaluation was pre-trained on a large image-captioning dataset (such as the <a href="https://laion.ai/blog/laion-5b/" rel="nofollow">LAION-5B dataset</a>). This is because underlying these metrics is an InceptionNet (pre-trained on the ImageNet-1k dataset) used for extracting intermediate image features. The pre-training dataset of Stable Diffusion may have limited overlap with the pre-training dataset of InceptionNet, so it is not a good candidate here for feature extraction.',Vs,gt,Zi='<strong><em>Using the above metrics helps evaluate models that are class-conditioned. For example, <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/dit" rel="nofollow">DiT</a>. It was pre-trained being conditioned on the ImageNet-1k classes.</em></strong>',Rs,V,Q,al,It,fa,Kt,Bi="Class-conditioned image generation",Ns,vt,_i='Class-conditioned generative models are usually pre-trained on a class-labeled dataset such as <a href="https://huggingface.co/datasets/imagenet-1k" rel="nofollow">ImageNet-1k</a>. Popular metrics for evaluating these models include Fréchet Inception Distance (FID), Kernel Inception Distance (KID), and Inception Score (IS). In this document, we focus on FID (<a href="https://arxiv.org/abs/1706.08500" rel="nofollow">Heusel et al.</a>). We show how to compute it with the <a href="https://huggingface.co/docs/diffusers/api/pipelines/dit" rel="nofollow"><code>DiTPipeline</code></a>, which uses the <a href="https://arxiv.org/abs/2212.09748" rel="nofollow">DiT model</a> under the hood.',Hs,Ct,Wi='FID aims to measure how similar are two datasets of images. As per <a href="https://mmgeneration.readthedocs.io/en/latest/quick_run.html#fid" rel="nofollow">this resource</a>:',Fs,Zt,Gi="<p>Fréchet Inception Distance is a measure of similarity between two datasets of images. It was shown to correlate well with the human judgment of visual quality and is most often used to evaluate the quality of samples of Generative Adversarial Networks. FID is calculated by computing the Fréchet distance between two Gaussians fitted to feature representations of the Inception network.</p>",Es,Bt,xi="These two datasets are essentially the dataset of real images and the dataset of fake images (generated images in our case). FID is usually calculated with two large datasets. However, for this document, we will work with two mini datasets.",$s,_t,ki="Let’s first download a few images from the ImageNet-1k training set:",As,Wt,Ys,Gt,Ss,xt,Xi="These are 10 images from the following ImageNet-1k classes: “cassette_player”, “chain_saw” (x2), “church”, “gas_pump” (x3), “parachute” (x2), and “tench”.",Qs,z,Vi='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/real-images.png" alt="real-images"/><br/> <em>Real images.</em>',zs,kt,Ri="Now that the images are loaded, let’s apply some lightweight pre-processing on them to use them for FID calculation.",Ls,Xt,Ps,Vt,Ni='We now load the <a href="https://huggingface.co/docs/diffusers/api/pipelines/dit" rel="nofollow"><code>DiTPipeline</code></a> to generate images conditioned on the above-mentioned classes.',qs,Rt,Ds,Nt,Hi='Now, we can compute the FID using <a href="https://torchmetrics.readthedocs.io/" rel="nofollow"><code>torchmetrics</code></a>.',Ks,Ht,Os,Ft,Fi="The lower the FID, the better it is. Several things can influence FID here:",ea,Et,Ei="<li>Number of images (both real and fake)</li> <li>Randomness induced in the diffusion process</li> <li>Number of inference steps in the diffusion process</li> <li>The scheduler being used in the diffusion process</li>",ta,$t,$i="For the last two points, it is, therefore, a good practice to run the evaluation across different seeds and inference steps, and then report an average result.",la,L,sa,At,Ai="As a final step, let’s visually inspect the <code>fake_images</code>.",aa,P,Yi='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/fake-images.png" alt="fake-images"/><br/> <em>Fake images.</em>',ia;return g=new Qt({}),te=new Qt({}),ae=new Qt({}),we=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwcHJvbXB0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJuYXRlcmF3JTJGcGFydGktcHJvbXB0cyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTIzJTIwcHJvbXB0cyUyMCUzRCUyMHByb21wdHMuc2h1ZmZsZSgpJTBBJTIzJTIwc2FtcGxlX3Byb21wdHMlMjAlM0QlMjAlNUJwcm9tcHRzJTVCaSU1RCU1QiUyMlByb21wdCUyMiU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDUpJTVEJTBBJTBBJTIzJTIwRml4aW5nJTIwdGhlc2UlMjBzYW1wbGUlMjBwcm9tcHRzJTIwaW4lMjB0aGUlMjBpbnRlcmVzdCUyMG9mJTIwcmVwcm9kdWNpYmlsaXR5LiUwQXNhbXBsZV9wcm9tcHRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyYSUyMGNvcmdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyYSUyMGhvdCUyMGFpciUyMGJhbGxvb24lMjB3aXRoJTIwYSUyMHlpbi15YW5nJTIwc3ltYm9sJTJDJTIwd2l0aCUyMHRoZSUyMG1vb24lMjB2aXNpYmxlJTIwaW4lMjB0aGUlMjBkYXl0aW1lJTIwc2t5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyYSUyMGNhciUyMHdpdGglMjBubyUyMHdpbmRvd3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhJTIwY3ViZSUyMG1hZGUlMjBvZiUyMHBvcmN1cGluZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCdUaGUlMjBzYXlpbmclMjAlMjJCRSUyMEVYQ0VMTEVOVCUyMFRPJTIwRUFDSCUyME9USEVSJTIyJTIwd3JpdHRlbiUyMG9uJTIwYSUyMHJlZCUyMGJyaWNrJTIwd2FsbCUyMHdpdGglMjBhJTIwZ3JhZmZpdGklMjBpbWFnZSUyMG9mJTIwYSUyMGdyZWVuJTIwYWxpZW4lMjB3ZWFyaW5nJTIwYSUyMHR1eGVkby4lMjBBJTIweWVsbG93JTIwZmlyZSUyMGh5ZHJhbnQlMjBpcyUyMG9uJTIwYSUyMHNpZGV3YWxrJTIwaW4lMjB0aGUlMjBmb3JlZ3JvdW5kLiclMkMlMEElNUQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># prompts = load_dataset(&quot;nateraw/parti-prompts&quot;, split=&quot;train&quot;)</span>
<span class="hljs-comment"># prompts = prompts.shuffle()</span>
<span class="hljs-comment"># sample_prompts = [prompts[i][&quot;Prompt&quot;] for i in range(5)]</span>

<span class="hljs-comment"># Fixing these sample prompts in the interest of reproducibility.</span>
sample_prompts = [
    <span class="hljs-string">&quot;a corgi&quot;</span>,
    <span class="hljs-string">&quot;a hot air balloon with a yin-yang symbol, with the moon visible in the daytime sky&quot;</span>,
    <span class="hljs-string">&quot;a car with no windows&quot;</span>,
    <span class="hljs-string">&quot;a cube made of porcupine&quot;</span>,
    <span class="hljs-string">&#x27;The saying &quot;BE EXCELLENT TO EACH OTHER&quot; written on a red brick wall with a graffiti image of a green alien wearing a tuxedo. A yellow fire hydrant is on a sidewalk in the foreground.&#x27;</span>,
]`}}),fe=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFzZWVkJTIwJTNEJTIwMCUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKHNlZWQpJTBBJTBBaW1hZ2VzJTIwJTNEJTIwc2RfcGlwZWxpbmUoc2FtcGxlX3Byb21wdHMlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">import</span> torch

seed = <span class="hljs-number">0</span>
generator = torch.manual_seed(seed)

images = sd_pipeline(sample_prompts, num_images_per_prompt=<span class="hljs-number">1</span>, generator=generator).images`}}),F=new ma({props:{$$slots:{default:[rn]},$$scope:{ctx:B}}}),be=new Qt({}),ve=new Qt({}),Be=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9ja3B0JTIwJTNEJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQXNkX3BpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NrcHQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_ckpt = <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
sd_pipeline = StableDiffusionPipeline.from_pretrained(model_ckpt, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)`}}),We=new y({props:{code:"cHJvbXB0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwaGlnaCUyMHRlY2glMjBzb2xhcnB1bmslMjB1dG9waWElMjBpbiUyMHRoZSUyMEFtYXpvbiUyMHJhaW5mb3Jlc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwcGlrYWNodSUyMGZpbmUlMjBkaW5pbmclMjB3aXRoJTIwYSUyMHZpZXclMjB0byUyMHRoZSUyMEVpZmZlbCUyMFRvd2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQSUyMG1lY2hhJTIwcm9ib3QlMjBpbiUyMGElMjBmYXZlbGElMjBpbiUyMGV4cHJlc3Npb25pc3QlMjBzdHlsZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmFuJTIwaW5zZWN0JTIwcm9ib3QlMjBwcmVwYXJpbmclMjBhJTIwZGVsaWNpb3VzJTIwbWVhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkElMjBzbWFsbCUyMGNhYmluJTIwb24lMjB0b3AlMjBvZiUyMGElMjBzbm93eSUyMG1vdW50YWluJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwRGlzbmV5JTJDJTIwYXJ0c3RhdGlvbiUyMiUyQyUwQSU1RCUwQSUwQWltYWdlcyUyMCUzRCUyMHNkX3BpcGVsaW5lKHByb21wdHMlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMikuaW1hZ2VzJTBBJTBBcHJpbnQoaW1hZ2VzLnNoYXBlKSUwQSUyMyUyMCg2JTJDJTIwNTEyJTJDJTIwNTEyJTJDJTIwMyk=",highlighted:`prompts = [
    <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>,
    <span class="hljs-string">&quot;A high tech solarpunk utopia in the Amazon rainforest&quot;</span>,
    <span class="hljs-string">&quot;A pikachu fine dining with a view to the Eiffel Tower&quot;</span>,
    <span class="hljs-string">&quot;A mecha robot in a favela in expressionist style&quot;</span>,
    <span class="hljs-string">&quot;an insect robot preparing a delicious meal&quot;</span>,
    <span class="hljs-string">&quot;A small cabin on top of a snowy mountain in the style of Disney, artstation&quot;</span>,
]

images = sd_pipeline(prompts, num_images_per_prompt=<span class="hljs-number">1</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>).images

<span class="hljs-built_in">print</span>(images.shape)
<span class="hljs-comment"># (6, 512, 512, 3)</span>`}}),xe=new y({props:{code:"ZnJvbSUyMHRvcmNobWV0cmljcy5mdW5jdGlvbmFsLm11bHRpbW9kYWwlMjBpbXBvcnQlMjBjbGlwX3Njb3JlJTBBZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEFjbGlwX3Njb3JlX2ZuJTIwJTNEJTIwcGFydGlhbChjbGlwX3Njb3JlJTJDJTIwbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTIyb3BlbmFpJTJGY2xpcC12aXQtYmFzZS1wYXRjaDE2JTIyKSUwQSUwQWRlZiUyMGNhbGN1bGF0ZV9jbGlwX3Njb3JlKGltYWdlcyUyQyUyMHByb21wdHMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VzX2ludCUyMCUzRCUyMChpbWFnZXMlMjAqJTIwMjU1KS5hc3R5cGUoJTIydWludDglMjIpJTBBJTIwJTIwJTIwJTIwY2xpcF9zY29yZSUyMCUzRCUyMGNsaXBfc2NvcmVfZm4odG9yY2guZnJvbV9udW1weShpbWFnZXNfaW50KS5wZXJtdXRlKDAlMkMlMjAzJTJDJTIwMSUyQyUyMDIpJTJDJTIwcHJvbXB0cykuZGV0YWNoKCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByb3VuZChmbG9hdChjbGlwX3Njb3JlKSUyQyUyMDQpJTBBJTBBc2RfY2xpcF9zY29yZSUyMCUzRCUyMGNhbGN1bGF0ZV9jbGlwX3Njb3JlKGltYWdlcyUyQyUyMHByb21wdHMpJTBBcHJpbnQoZiUyMkNMSVAlMjBzY29yZSUzQSUyMCU3QnNkX2NsaXBfc2NvcmUlN0QlMjIpJTBBJTIzJTIwQ0xJUCUyMHNjb3JlJTNBJTIwMzUuNzAzOA==",highlighted:`<span class="hljs-keyword">from</span> torchmetrics.functional.multimodal <span class="hljs-keyword">import</span> clip_score
<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

clip_score_fn = partial(clip_score, model_name_or_path=<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculate_clip_score</span>(<span class="hljs-params">images, prompts</span>):
    images_int = (images * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
    clip_score = clip_score_fn(torch.from_numpy(images_int).permute(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>), prompts).detach()
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">round</span>(<span class="hljs-built_in">float</span>(clip_score), <span class="hljs-number">4</span>)

sd_clip_score = calculate_clip_score(images, prompts)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP score: <span class="hljs-subst">{sd_clip_score}</span>&quot;</span>)
<span class="hljs-comment"># CLIP score: 35.7038</span>`}}),Ve=new y({props:{code:"c2VlZCUyMCUzRCUyMDAlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZChzZWVkKSUwQSUwQWltYWdlcyUyMCUzRCUyMHNkX3BpcGVsaW5lKHByb21wdHMlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMikuaW1hZ2Vz",highlighted:`seed = <span class="hljs-number">0</span>
generator = torch.manual_seed(seed)

images = sd_pipeline(prompts, num_images_per_prompt=<span class="hljs-number">1</span>, generator=generator, output_type=<span class="hljs-string">&quot;np&quot;</span>).images`}}),Ne=new y({props:{code:"bW9kZWxfY2twdF8xXzUlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXNkX3BpcGVsaW5lXzFfNSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9ja3B0XzFfNSUyQyUyMHRvcmNoX2R0eXBlJTNEd2VpZ2h0X2R0eXBlKS50byhkZXZpY2UpJTBBJTBBaW1hZ2VzXzFfNSUyMCUzRCUyMHNkX3BpcGVsaW5lXzFfNShwcm9tcHRzJTJDJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMSUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMG91dHB1dF90eXBlJTNEJTIybnAlMjIpLmltYWdlcw==",highlighted:`model_ckpt_1_5 = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
sd_pipeline_1_5 = StableDiffusionPipeline.from_pretrained(model_ckpt_1_5, torch_dtype=weight_dtype).to(device)

images_1_5 = sd_pipeline_1_5(prompts, num_images_per_prompt=<span class="hljs-number">1</span>, generator=generator, output_type=<span class="hljs-string">&quot;np&quot;</span>).images`}}),Fe=new y({props:{code:"c2RfY2xpcF9zY29yZV8xXzQlMjAlM0QlMjBjYWxjdWxhdGVfY2xpcF9zY29yZShpbWFnZXMlMkMlMjBwcm9tcHRzKSUwQXByaW50KGYlMjJDTElQJTIwU2NvcmUlMjB3aXRoJTIwdi0xLTQlM0ElMjAlN0JzZF9jbGlwX3Njb3JlXzFfNCU3RCUyMiklMEElMjMlMjBDTElQJTIwU2NvcmUlMjB3aXRoJTIwdi0xLTQlM0ElMjAzNC45MTAyJTBBJTBBc2RfY2xpcF9zY29yZV8xXzUlMjAlM0QlMjBjYWxjdWxhdGVfY2xpcF9zY29yZShpbWFnZXNfMV81JTJDJTIwcHJvbXB0cyklMEFwcmludChmJTIyQ0xJUCUyMFNjb3JlJTIwd2l0aCUyMHYtMS01JTNBJTIwJTdCc2RfY2xpcF9zY29yZV8xXzUlN0QlMjIpJTBBJTIzJTIwQ0xJUCUyMFNjb3JlJTIwd2l0aCUyMHYtMS01JTNBJTIwMzYuMjEzNw==",highlighted:`sd_clip_score_1_4 = calculate_clip_score(images, prompts)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP Score with v-1-4: <span class="hljs-subst">{sd_clip_score_1_4}</span>&quot;</span>)
<span class="hljs-comment"># CLIP Score with v-1-4: 34.9102</span>

sd_clip_score_1_5 = calculate_clip_score(images_1_5, prompts)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP Score with v-1-5: <span class="hljs-subst">{sd_clip_score_1_5}</span>&quot;</span>)
<span class="hljs-comment"># CLIP Score with v-1-5: 36.2137</span>`}}),A=new ma({props:{warning:!0,$$slots:{default:[cn]},$$scope:{ctx:B}}}),$e=new Qt({}),De=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzYXlha3BhdWwlMkZpbnN0cnVjdHBpeDJwaXgtZGVtbyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBZGF0YXNldC5mZWF0dXJlcw==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;sayakpaul/instructpix2pix-demo&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
dataset.features`}}),Ke=new y({props:{code:"JTdCJ2lucHV0JyUzQSUyMFZhbHVlKGR0eXBlJTNEJ3N0cmluZyclMkMlMjBpZCUzRE5vbmUpJTJDJTBBJTIwJ2VkaXQnJTNBJTIwVmFsdWUoZHR5cGUlM0Qnc3RyaW5nJyUyQyUyMGlkJTNETm9uZSklMkMlMEElMjAnb3V0cHV0JyUzQSUyMFZhbHVlKGR0eXBlJTNEJ3N0cmluZyclMkMlMjBpZCUzRE5vbmUpJTJDJTBBJTIwJ2ltYWdlJyUzQSUyMEltYWdlKGRlY29kZSUzRFRydWUlMkMlMjBpZCUzRE5vbmUpJTdE",highlighted:`{<span class="hljs-string">&#x27;input&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=None),
 <span class="hljs-string">&#x27;edit&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=None),
 <span class="hljs-string">&#x27;output&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=None),
 <span class="hljs-string">&#x27;image&#x27;</span>: Image(decode=True, <span class="hljs-built_in">id</span>=None)}`}}),lt=new y({props:{code:"aWR4JTIwJTNEJTIwMCUwQXByaW50KGYlMjJPcmlnaW5hbCUyMGNhcHRpb24lM0ElMjAlN0JkYXRhc2V0JTVCaWR4JTVEJTVCJ2lucHV0JyU1RCU3RCUyMiklMEFwcmludChmJTIyRWRpdCUyMGluc3RydWN0aW9uJTNBJTIwJTdCZGF0YXNldCU1QmlkeCU1RCU1QidlZGl0JyU1RCU3RCUyMiklMEFwcmludChmJTIyTW9kaWZpZWQlMjBjYXB0aW9uJTNBJTIwJTdCZGF0YXNldCU1QmlkeCU1RCU1QidvdXRwdXQnJTVEJTdEJTIyKQ==",highlighted:`idx = <span class="hljs-number">0</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Original caption: <span class="hljs-subst">{dataset[idx][<span class="hljs-string">&#x27;input&#x27;</span>]}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Edit instruction: <span class="hljs-subst">{dataset[idx][<span class="hljs-string">&#x27;edit&#x27;</span>]}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Modified caption: <span class="hljs-subst">{dataset[idx][<span class="hljs-string">&#x27;output&#x27;</span>]}</span>&quot;</span>)`}}),st=new y({props:{code:"T3JpZ2luYWwlMjBjYXB0aW9uJTNBJTIwMi4lMjBGQVJPRSUyMElTTEFORFMlM0ElMjBBbiUyMGFyY2hpcGVsYWdvJTIwb2YlMjAxOCUyMG1vdW50YWlub3VzJTIwaXNsZXMlMjBpbiUyMHRoZSUyME5vcnRoJTIwQXRsYW50aWMlMjBPY2VhbiUyMGJldHdlZW4lMjBOb3J3YXklMjBhbmQlMjBJY2VsYW5kJTJDJTIwdGhlJTIwRmFyb2UlMjBJc2xhbmRzJTIwaGFzJTIwJ2V2ZXJ5dGhpbmclMjB5b3UlMjBjb3VsZCUyMGhvcGUlMjBmb3InJTJDJTIwYWNjb3JkaW5nJTIwdG8lMjBCaWclMjA3JTIwVHJhdmVsLiUyMEl0JTIwYm9hc3RzJTIwJ2NyeXN0YWwlMjBjbGVhciUyMHdhdGVyZmFsbHMlMkMlMjByb2NreSUyMGNsaWZmcyUyMHRoYXQlMjBzZWVtJTIwdG8lMjBqdXQlMjBvdXQlMjBvZiUyMG5vd2hlcmUlMjBhbmQlMjB2ZWx2ZXR5JTIwZ3JlZW4lMjBoaWxscyclMEFFZGl0JTIwaW5zdHJ1Y3Rpb24lM0ElMjBtYWtlJTIwdGhlJTIwaXNsZXMlMjBhbGwlMjB3aGl0ZSUyMG1hcmJsZSUwQU1vZGlmaWVkJTIwY2FwdGlvbiUzQSUyMDIuJTIwV0hJVEUlMjBNQVJCTEUlMjBJU0xBTkRTJTNBJTIwQW4lMjBhcmNoaXBlbGFnbyUyMG9mJTIwMTglMjBtb3VudGFpbm91cyUyMHdoaXRlJTIwbWFyYmxlJTIwaXNsZXMlMjBpbiUyMHRoZSUyME5vcnRoJTIwQXRsYW50aWMlMjBPY2VhbiUyMGJldHdlZW4lMjBOb3J3YXklMjBhbmQlMjBJY2VsYW5kJTJDJTIwdGhlJTIwV2hpdGUlMjBNYXJibGUlMjBJc2xhbmRzJTIwaGFzJTIwJ2V2ZXJ5dGhpbmclMjB5b3UlMjBjb3VsZCUyMGhvcGUlMjBmb3InJTJDJTIwYWNjb3JkaW5nJTIwdG8lMjBCaWclMjA3JTIwVHJhdmVsLiUyMEl0JTIwYm9hc3RzJTIwJ2NyeXN0YWwlMjBjbGVhciUyMHdhdGVyZmFsbHMlMkMlMjByb2NreSUyMGNsaWZmcyUyMHRoYXQlMjBzZWVtJTIwdG8lMjBqdXQlMjBvdXQlMjBvZiUyMG5vd2hlcmUlMjBhbmQlMjB2ZWx2ZXR5JTIwZ3JlZW4lMjBoaWxscyc=",highlighted:`Original caption: 2. FAROE ISLANDS: An archipelago of 18 mountainous isles <span class="hljs-keyword">in</span> the North Atlantic Ocean between Norway and Iceland, the Faroe Islands has <span class="hljs-string">&#x27;everything you could hope for&#x27;</span>, according to Big 7 Travel. It boasts <span class="hljs-string">&#x27;crystal clear waterfalls, rocky cliffs that seem to jut out of nowhere and velvety green hills&#x27;</span>
Edit instruction: make the isles all white marble
Modified caption: 2. WHITE MARBLE ISLANDS: An archipelago of 18 mountainous white marble isles <span class="hljs-keyword">in</span> the North Atlantic Ocean between Norway and Iceland, the White Marble Islands has <span class="hljs-string">&#x27;everything you could hope for&#x27;</span>, according to Big 7 Travel. It boasts <span class="hljs-string">&#x27;crystal clear waterfalls, rocky cliffs that seem to jut out of nowhere and velvety green hills&#x27;</span>`}}),it=new y({props:{code:"ZGF0YXNldCU1QmlkeCU1RCU1QiUyMmltYWdlJTIyJTVE",highlighted:'dataset[idx][<span class="hljs-string">&quot;image&quot;</span>]'}}),rt=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkluc3RydWN0UGl4MlBpeFBpcGVsaW5lJTBBJTBBaW5zdHJ1Y3RfcGl4MnBpeF9waXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkluc3RydWN0UGl4MlBpeFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJ0aW1icm9va3MlMkZpbnN0cnVjdC1waXgycGl4JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byhkZXZpY2Up",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline

instruct_pix2pix_pipeline = StableDiffusionInstructPix2PixPipeline.from_pretrained(
    <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>, torch_dtype=torch.float16
).to(device)`}}),mt=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwZWRpdF9pbWFnZShpbnB1dF9pbWFnZSUyQyUyMGluc3RydWN0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwaW5zdHJ1Y3RfcGl4MnBpeF9waXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnN0cnVjdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTNEaW5wdXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMm5wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwKS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2UlMEElMEFpbnB1dF9pbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEFvcmlnaW5hbF9jYXB0aW9ucyUyMCUzRCUyMCU1QiU1RCUwQW1vZGlmaWVkX2NhcHRpb25zJTIwJTNEJTIwJTVCJTVEJTBBZWRpdGVkX2ltYWdlcyUyMCUzRCUyMCU1QiU1RCUwQSUwQWZvciUyMGlkeCUyMGluJTIwcmFuZ2UobGVuKGRhdGFzZXQpKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0X2ltYWdlJTIwJTNEJTIwZGF0YXNldCU1QmlkeCU1RCU1QiUyMmltYWdlJTIyJTVEJTBBJTIwJTIwJTIwJTIwZWRpdF9pbnN0cnVjdGlvbiUyMCUzRCUyMGRhdGFzZXQlNUJpZHglNUQlNUIlMjJlZGl0JTIyJTVEJTBBJTIwJTIwJTIwJTIwZWRpdGVkX2ltYWdlJTIwJTNEJTIwZWRpdF9pbWFnZShpbnB1dF9pbWFnZSUyQyUyMGVkaXRfaW5zdHJ1Y3Rpb24pJTBBJTBBJTIwJTIwJTIwJTIwaW5wdXRfaW1hZ2VzLmFwcGVuZChucC5hcnJheShpbnB1dF9pbWFnZSkpJTBBJTIwJTIwJTIwJTIwb3JpZ2luYWxfY2FwdGlvbnMuYXBwZW5kKGRhdGFzZXQlNUJpZHglNUQlNUIlMjJpbnB1dCUyMiU1RCklMEElMjAlMjAlMjAlMjBtb2RpZmllZF9jYXB0aW9ucy5hcHBlbmQoZGF0YXNldCU1QmlkeCU1RCU1QiUyMm91dHB1dCUyMiU1RCklMEElMjAlMjAlMjAlMjBlZGl0ZWRfaW1hZ2VzLmFwcGVuZChlZGl0ZWRfaW1hZ2Up",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">edit_image</span>(<span class="hljs-params">input_image, instruction</span>):
    image = instruct_pix2pix_pipeline(
        instruction,
        image=input_image,
        output_type=<span class="hljs-string">&quot;np&quot;</span>,
        generator=generator,
    ).images[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> image

input_images = []
original_captions = []
modified_captions = []
edited_images = []

<span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
    input_image = dataset[idx][<span class="hljs-string">&quot;image&quot;</span>]
    edit_instruction = dataset[idx][<span class="hljs-string">&quot;edit&quot;</span>]
    edited_image = edit_image(input_image, edit_instruction)

    input_images.append(np.array(input_image))
    original_captions.append(dataset[idx][<span class="hljs-string">&quot;input&quot;</span>])
    modified_captions.append(dataset[idx][<span class="hljs-string">&quot;output&quot;</span>])
    edited_images.append(edited_image)`}}),dt=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBDTElQVG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwQ0xJUFRleHRNb2RlbFdpdGhQcm9qZWN0aW9uJTJDJTBBJTIwJTIwJTIwJTIwQ0xJUFZpc2lvbk1vZGVsV2l0aFByb2plY3Rpb24lMkMlMEElMjAlMjAlMjAlMjBDTElQSW1hZ2VQcm9jZXNzb3IlMkMlMEEpJTBBJTBBY2xpcF9pZCUyMCUzRCUyMCUyMm9wZW5haSUyRmNsaXAtdml0LWxhcmdlLXBhdGNoMTQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBDTElQVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjbGlwX2lkKSUwQXRleHRfZW5jb2RlciUyMCUzRCUyMENMSVBUZXh0TW9kZWxXaXRoUHJvamVjdGlvbi5mcm9tX3ByZXRyYWluZWQoY2xpcF9pZCkudG8oZGV2aWNlKSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMENMSVBJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2xpcF9pZCklMEFpbWFnZV9lbmNvZGVyJTIwJTNEJTIwQ0xJUFZpc2lvbk1vZGVsV2l0aFByb2plY3Rpb24uZnJvbV9wcmV0cmFpbmVkKGNsaXBfaWQpLnRvKGRldmljZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    CLIPTokenizer,
    CLIPTextModelWithProjection,
    CLIPVisionModelWithProjection,
    CLIPImageProcessor,
)

clip_id = <span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
tokenizer = CLIPTokenizer.from_pretrained(clip_id)
text_encoder = CLIPTextModelWithProjection.from_pretrained(clip_id).to(device)
image_processor = CLIPImageProcessor.from_pretrained(clip_id)
image_encoder = CLIPVisionModelWithProjection.from_pretrained(clip_id).to(device)`}}),wt=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F


<span class="hljs-keyword">class</span> <span class="hljs-title class_">DirectionalSimilarity</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, tokenizer, text_encoder, image_processor, image_encoder</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.tokenizer = tokenizer
        self.text_encoder = text_encoder
        self.image_processor = image_processor
        self.image_encoder = image_encoder

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_image</span>(<span class="hljs-params">self, image</span>):
        image = self.image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;pixel_values&quot;</span>]
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: image.to(device)}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_text</span>(<span class="hljs-params">self, text</span>):
        inputs = self.tokenizer(
            text,
            max_length=self.tokenizer.model_max_length,
            padding=<span class="hljs-string">&quot;max_length&quot;</span>,
            truncation=<span class="hljs-literal">True</span>,
            return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
        )
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;input_ids&quot;</span>: inputs.input_ids.to(device)}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_image</span>(<span class="hljs-params">self, image</span>):
        preprocessed_image = self.preprocess_image(image)
        image_features = self.image_encoder(**preprocessed_image).image_embeds
        image_features = image_features / image_features.norm(dim=<span class="hljs-number">1</span>, keepdim=<span class="hljs-literal">True</span>)
        <span class="hljs-keyword">return</span> image_features

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_text</span>(<span class="hljs-params">self, text</span>):
        tokenized_text = self.tokenize_text(text)
        text_features = self.text_encoder(**tokenized_text).text_embeds
        text_features = text_features / text_features.norm(dim=<span class="hljs-number">1</span>, keepdim=<span class="hljs-literal">True</span>)
        <span class="hljs-keyword">return</span> text_features

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_directional_similarity</span>(<span class="hljs-params">self, img_feat_one, img_feat_two, text_feat_one, text_feat_two</span>):
        sim_direction = F.cosine_similarity(img_feat_two - img_feat_one, text_feat_two - text_feat_one)
        <span class="hljs-keyword">return</span> sim_direction

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, image_one, image_two, caption_one, caption_two</span>):
        img_feat_one = self.encode_image(image_one)
        img_feat_two = self.encode_image(image_two)
        text_feat_one = self.encode_text(caption_one)
        text_feat_two = self.encode_text(caption_two)
        directional_similarity = self.compute_directional_similarity(
            img_feat_one, img_feat_two, text_feat_one, text_feat_two
        )
        <span class="hljs-keyword">return</span> directional_similarity`}}),ft=new y({props:{code:"ZGlyX3NpbWlsYXJpdHklMjAlM0QlMjBEaXJlY3Rpb25hbFNpbWlsYXJpdHkodG9rZW5pemVyJTJDJTIwdGV4dF9lbmNvZGVyJTJDJTIwaW1hZ2VfcHJvY2Vzc29yJTJDJTIwaW1hZ2VfZW5jb2RlciklMEFzY29yZXMlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oaW5wdXRfaW1hZ2VzKSklM0ElMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGlucHV0X2ltYWdlcyU1QmklNUQlMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9jYXB0aW9uJTIwJTNEJTIwb3JpZ2luYWxfY2FwdGlvbnMlNUJpJTVEJTBBJTIwJTIwJTIwJTIwZWRpdGVkX2ltYWdlJTIwJTNEJTIwZWRpdGVkX2ltYWdlcyU1QmklNUQlMEElMjAlMjAlMjAlMjBtb2RpZmllZF9jYXB0aW9uJTIwJTNEJTIwbW9kaWZpZWRfY2FwdGlvbnMlNUJpJTVEJTBBJTBBJTIwJTIwJTIwJTIwc2ltaWxhcml0eV9zY29yZSUyMCUzRCUyMGRpcl9zaW1pbGFyaXR5KG9yaWdpbmFsX2ltYWdlJTJDJTIwZWRpdGVkX2ltYWdlJTJDJTIwb3JpZ2luYWxfY2FwdGlvbiUyQyUyMG1vZGlmaWVkX2NhcHRpb24pJTBBJTIwJTIwJTIwJTIwc2NvcmVzLmFwcGVuZChmbG9hdChzaW1pbGFyaXR5X3Njb3JlLmRldGFjaCgpLmNwdSgpKSklMEElMEFwcmludChmJTIyQ0xJUCUyMGRpcmVjdGlvbmFsJTIwc2ltaWxhcml0eSUzQSUyMCU3Qm5wLm1lYW4oc2NvcmVzKSU3RCUyMiklMEElMjMlMjBDTElQJTIwZGlyZWN0aW9uYWwlMjBzaW1pbGFyaXR5JTNBJTIwMC4wNzk3OTc2NTUzNDQwMDk0",highlighted:`dir_similarity = DirectionalSimilarity(tokenizer, text_encoder, image_processor, image_encoder)
scores = []

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(input_images)):
    original_image = input_images[i]
    original_caption = original_captions[i]
    edited_image = edited_images[i]
    modified_caption = modified_captions[i]

    similarity_score = dir_similarity(original_image, edited_image, original_caption, modified_caption)
    scores.append(<span class="hljs-built_in">float</span>(similarity_score.detach().cpu()))

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP directional similarity: <span class="hljs-subst">{np.mean(scores)}</span>&quot;</span>)
<span class="hljs-comment"># CLIP directional similarity: 0.0797976553440094</span>`}}),S=new ma({props:{$$slots:{default:[mn]},$$scope:{ctx:B}}}),It=new Qt({}),Wt=new y({props:{code:"ZnJvbSUyMHppcGZpbGUlMjBpbXBvcnQlMjBaaXBGaWxlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFkZWYlMjBkb3dubG9hZCh1cmwlMkMlMjBsb2NhbF9maWxlcGF0aCklM0ElMEElMjAlMjAlMjAlMjByJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjB3aXRoJTIwb3Blbihsb2NhbF9maWxlcGF0aCUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYud3JpdGUoci5jb250ZW50KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxvY2FsX2ZpbGVwYXRoJTBBJTBBZHVtbXlfZGF0YXNldF91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmhmLmNvJTJGZGF0YXNldHMlMkZzYXlha3BhdWwlMkZzYW1wbGUtZGF0YXNldHMlMkZyZXNvbHZlJTJGbWFpbiUyRnNhbXBsZS1pbWFnZW5ldC1pbWFnZXMuemlwJTIyJTBBbG9jYWxfZmlsZXBhdGglMjAlM0QlMjBkb3dubG9hZChkdW1teV9kYXRhc2V0X3VybCUyQyUyMGR1bW15X2RhdGFzZXRfdXJsLnNwbGl0KCUyMiUyRiUyMiklNUItMSU1RCklMEElMEF3aXRoJTIwWmlwRmlsZShsb2NhbF9maWxlcGF0aCUyQyUyMCUyMnIlMjIpJTIwYXMlMjB6aXBwZXIlM0ElMEElMjAlMjAlMjAlMjB6aXBwZXIuZXh0cmFjdGFsbCglMjIuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> zipfile <span class="hljs-keyword">import</span> ZipFile
<span class="hljs-keyword">import</span> requests


<span class="hljs-keyword">def</span> <span class="hljs-title function_">download</span>(<span class="hljs-params">url, local_filepath</span>):
    r = requests.get(url)
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(local_filepath, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
        f.write(r.content)
    <span class="hljs-keyword">return</span> local_filepath

dummy_dataset_url = <span class="hljs-string">&quot;https://hf.co/datasets/sayakpaul/sample-datasets/resolve/main/sample-imagenet-images.zip&quot;</span>
local_filepath = download(dummy_dataset_url, dummy_dataset_url.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>])

<span class="hljs-keyword">with</span> ZipFile(local_filepath, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> zipper:
    zipper.extractall(<span class="hljs-string">&quot;.&quot;</span>)`}}),Gt=new y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwb3MlMEElMEFkYXRhc2V0X3BhdGglMjAlM0QlMjAlMjJzYW1wbGUtaW1hZ2VuZXQtaW1hZ2VzJTIyJTBBaW1hZ2VfcGF0aHMlMjAlM0QlMjBzb3J0ZWQoJTVCb3MucGF0aC5qb2luKGRhdGFzZXRfcGF0aCUyQyUyMHgpJTIwZm9yJTIweCUyMGluJTIwb3MubGlzdGRpcihkYXRhc2V0X3BhdGgpJTVEKSUwQSUwQXJlYWxfaW1hZ2VzJTIwJTNEJTIwJTVCbnAuYXJyYXkoSW1hZ2Uub3BlbihwYXRoKS5jb252ZXJ0KCUyMlJHQiUyMikpJTIwZm9yJTIwcGF0aCUyMGluJTIwaW1hZ2VfcGF0aHMlNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> os

dataset_path = <span class="hljs-string">&quot;sample-imagenet-images&quot;</span>
image_paths = <span class="hljs-built_in">sorted</span>([os.path.join(dataset_path, x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> os.listdir(dataset_path)])

real_images = [np.array(Image.<span class="hljs-built_in">open</span>(path).convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> image_paths]`}}),Xt=new y({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBmdW5jdGlvbmFsJTIwYXMlMjBGJTBBJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc19pbWFnZShpbWFnZSklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRvcmNoLnRlbnNvcihpbWFnZSkudW5zcXVlZXplKDApJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBpbWFnZS5wZXJtdXRlKDAlMkMlMjAzJTJDJTIwMSUyQyUyMDIpJTIwJTJGJTIwMjU1LjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBGLmNlbnRlcl9jcm9wKGltYWdlJTJDJTIwKDI1NiUyQyUyMDI1NikpJTBBJTBBcmVhbF9pbWFnZXMlMjAlM0QlMjB0b3JjaC5jYXQoJTVCcHJlcHJvY2Vzc19pbWFnZShpbWFnZSklMjBmb3IlMjBpbWFnZSUyMGluJTIwcmVhbF9pbWFnZXMlNUQpJTBBcHJpbnQocmVhbF9pbWFnZXMuc2hhcGUpJTBBJTIzJTIwdG9yY2guU2l6ZSglNUIxMCUyQyUyMDMlMkMlMjAyNTYlMkMlMjAyNTYlNUQp",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> functional <span class="hljs-keyword">as</span> F


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_image</span>(<span class="hljs-params">image</span>):
    image = torch.tensor(image).unsqueeze(<span class="hljs-number">0</span>)
    image = image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>) / <span class="hljs-number">255.0</span>
    <span class="hljs-keyword">return</span> F.center_crop(image, (<span class="hljs-number">256</span>, <span class="hljs-number">256</span>))

real_images = torch.cat([preprocess_image(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> real_images])
<span class="hljs-built_in">print</span>(real_images.shape)
<span class="hljs-comment"># torch.Size([10, 3, 256, 256])</span>`}}),Rt=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpVFBpcGVsaW5lJTJDJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTBBJTBBZGl0X3BpcGVsaW5lJTIwJTNEJTIwRGlUUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGRGlULVhMLTItMjU2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWRpdF9waXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcoZGl0X3BpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBZGl0X3BpcGVsaW5lJTIwJTNEJTIwZGl0X3BpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBd29yZHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJjYXNzZXR0ZSUyMHBsYXllciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNoYWluc2F3JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hhaW5zYXclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjaHVyY2glMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJnYXMlMjBwdW1wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZ2FzJTIwcHVtcCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmdhcyUyMHB1bXAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJwYXJhY2h1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJwYXJhY2h1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZW5jaCUyMiUyQyUwQSU1RCUwQSUwQWNsYXNzX2lkcyUyMCUzRCUyMGRpdF9waXBlbGluZS5nZXRfbGFiZWxfaWRzKHdvcmRzKSUwQW91dHB1dCUyMCUzRCUyMGRpdF9waXBlbGluZShjbGFzc19sYWJlbHMlM0RjbGFzc19pZHMlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMm5wJTIyKSUwQSUwQWZha2VfaW1hZ2VzJTIwJTNEJTIwb3V0cHV0LmltYWdlcyUwQWZha2VfaW1hZ2VzJTIwJTNEJTIwdG9yY2gudGVuc29yKGZha2VfaW1hZ2VzKSUwQWZha2VfaW1hZ2VzJTIwJTNEJTIwZmFrZV9pbWFnZXMucGVybXV0ZSgwJTJDJTIwMyUyQyUyMDElMkMlMjAyKSUwQXByaW50KGZha2VfaW1hZ2VzLnNoYXBlKSUwQSUyMyUyMHRvcmNoLlNpemUoJTVCMTAlMkMlMjAzJTJDJTIwMjU2JTJDJTIwMjU2JTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiTPipeline, DPMSolverMultistepScheduler

dit_pipeline = DiTPipeline.from_pretrained(<span class="hljs-string">&quot;facebook/DiT-XL-2-256&quot;</span>, torch_dtype=torch.float16)
dit_pipeline.scheduler = DPMSolverMultistepScheduler.from_config(dit_pipeline.scheduler.config)
dit_pipeline = dit_pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

words = [
    <span class="hljs-string">&quot;cassette player&quot;</span>,
    <span class="hljs-string">&quot;chainsaw&quot;</span>,
    <span class="hljs-string">&quot;chainsaw&quot;</span>,
    <span class="hljs-string">&quot;church&quot;</span>,
    <span class="hljs-string">&quot;gas pump&quot;</span>,
    <span class="hljs-string">&quot;gas pump&quot;</span>,
    <span class="hljs-string">&quot;gas pump&quot;</span>,
    <span class="hljs-string">&quot;parachute&quot;</span>,
    <span class="hljs-string">&quot;parachute&quot;</span>,
    <span class="hljs-string">&quot;tench&quot;</span>,
]

class_ids = dit_pipeline.get_label_ids(words)
output = dit_pipeline(class_labels=class_ids, generator=generator, output_type=<span class="hljs-string">&quot;np&quot;</span>)

fake_images = output.images
fake_images = torch.tensor(fake_images)
fake_images = fake_images.permute(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
<span class="hljs-built_in">print</span>(fake_images.shape)
<span class="hljs-comment"># torch.Size([10, 3, 256, 256])</span>`}}),Ht=new y({props:{code:"ZnJvbSUyMHRvcmNobWV0cmljcy5pbWFnZS5maWQlMjBpbXBvcnQlMjBGcmVjaGV0SW5jZXB0aW9uRGlzdGFuY2UlMEElMEFmaWQlMjAlM0QlMjBGcmVjaGV0SW5jZXB0aW9uRGlzdGFuY2Uobm9ybWFsaXplJTNEVHJ1ZSklMEFmaWQudXBkYXRlKHJlYWxfaW1hZ2VzJTJDJTIwcmVhbCUzRFRydWUpJTBBZmlkLnVwZGF0ZShmYWtlX2ltYWdlcyUyQyUyMHJlYWwlM0RGYWxzZSklMEElMEFwcmludChmJTIyRklEJTNBJTIwJTdCZmxvYXQoZmlkLmNvbXB1dGUoKSklN0QlMjIpJTBBJTIzJTIwRklEJTNBJTIwMTc3LjcxNDcyMTY3OTY4NzU=",highlighted:`<span class="hljs-keyword">from</span> torchmetrics.image.fid <span class="hljs-keyword">import</span> FrechetInceptionDistance

fid = FrechetInceptionDistance(normalize=<span class="hljs-literal">True</span>)
fid.update(real_images, real=<span class="hljs-literal">True</span>)
fid.update(fake_images, real=<span class="hljs-literal">False</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;FID: <span class="hljs-subst">{<span class="hljs-built_in">float</span>(fid.compute())}</span>&quot;</span>)
<span class="hljs-comment"># FID: 177.7147216796875</span>`}}),L=new ma({props:{warning:!0,$$slots:{default:[Mn]},$$scope:{ctx:B}}}),{c(){r=n("meta"),b=a(),J=n("h1"),T=n("a"),R=n("span"),c(g.$$.fragment),Z=a(),_=n("span"),_.textContent=q,I=a(),v=n("a"),v.innerHTML=U,C=a(),D=n("p"),D.innerHTML=ya,pl=a(),K=n("p"),K.textContent=Ta,ol=a(),O=n("p"),O.innerHTML=ja,rl=a(),ee=n("p"),ee.innerHTML=Ua,cl=a(),W=n("h2"),N=n("a"),Ot=n("span"),c(te.$$.fragment),da=a(),zt=n("span"),zt.textContent=ba,ml=a(),le=n("p"),le.textContent=ga,Ml=a(),se=n("ul"),se.innerHTML=Ia,dl=a(),G=n("h2"),H=n("a"),el=n("span"),c(ae.$$.fragment),ha=a(),Lt=n("span"),Lt.textContent=va,hl=a(),ie=n("p"),ie.innerHTML=Ca,ul=a(),ne=n("p"),ne.innerHTML=Za,wl=a(),pe=n("blockquote"),pe.innerHTML=Ba,Jl=a(),oe=n("p"),oe.innerHTML=_a,fl=a(),re=n("p"),re.textContent=Wa,yl=a(),ce=n("ul"),ce.innerHTML=Ga,Tl=a(),me=n("p"),me.textContent=xa,jl=a(),Me=n("p"),Me.innerHTML=ka,Ul=a(),de=n("ul"),de.innerHTML=Xa,bl=a(),he=n("p"),he.innerHTML=Va,gl=a(),ue=n("p"),ue.innerHTML=Ra,Il=a(),c(we.$$.fragment),vl=a(),Je=n("p"),Je.innerHTML=Na,Cl=a(),c(fe.$$.fragment),Zl=a(),ye=n("p"),ye.innerHTML=Ha,Bl=a(),Te=n("p"),Te.innerHTML=Fa,_l=a(),je=n("p"),je.innerHTML=Ea,Wl=a(),Ue=n("p"),Ue.textContent=$a,Gl=a(),c(F.$$.fragment),xl=a(),x=n("h2"),E=n("a"),tl=n("span"),c(be.$$.fragment),ua=a(),Pt=n("span"),Pt.textContent=Aa,kl=a(),ge=n("p"),ge.textContent=Ya,Xl=a(),Ie=n("ul"),Ie.innerHTML=Sa,Vl=a(),k=n("h3"),$=n("a"),ll=n("span"),c(ve.$$.fragment),wa=a(),qt=n("span"),qt.textContent=Qa,Rl=a(),Ce=n("p"),Ce.innerHTML=za,Nl=a(),Ze=n("p"),Ze.innerHTML=La,Hl=a(),c(Be.$$.fragment),Fl=a(),_e=n("p"),_e.textContent=Pa,El=a(),c(We.$$.fragment),$l=a(),Ge=n("p"),Ge.textContent=qa,Al=a(),c(xe.$$.fragment),Yl=a(),ke=n("p"),ke.textContent=Da,Sl=a(),Xe=n("p"),Xe.innerHTML=Ka,Ql=a(),c(Ve.$$.fragment),zl=a(),Re=n("p"),Re.innerHTML=Oa,Ll=a(),c(Ne.$$.fragment),Pl=a(),He=n("p"),He.textContent=ei,ql=a(),c(Fe.$$.fragment),Dl=a(),Ee=n("p"),Ee.innerHTML=ti,Kl=a(),c(A.$$.fragment),Ol=a(),X=n("h3"),Y=n("a"),sl=n("span"),c($e.$$.fragment),Ja=a(),Dt=n("span"),Dt.textContent=li,es=a(),Ae=n("p"),Ae.innerHTML=si,ts=a(),Ye=n("p"),Ye.textContent=ai,ls=a(),Se=n("p"),Se.innerHTML=ii,ss=a(),Qe=n("p"),Qe.innerHTML=ni,as=a(),ze=n("ul"),ze.innerHTML=pi,is=a(),Le=n("p"),Le.textContent=oi,ns=a(),Pe=n("p"),Pe.innerHTML=ri,ps=a(),qe=n("p"),qe.textContent=ci,os=a(),c(De.$$.fragment),rs=a(),c(Ke.$$.fragment),cs=a(),Oe=n("p"),Oe.textContent=mi,ms=a(),et=n("ul"),et.innerHTML=Mi,Ms=a(),tt=n("p"),tt.textContent=di,ds=a(),c(lt.$$.fragment),hs=a(),c(st.$$.fragment),us=a(),at=n("p"),at.textContent=hi,ws=a(),c(it.$$.fragment),Js=a(),nt=n("p"),nt.innerHTML=ui,fs=a(),pt=n("p"),pt.textContent=wi,ys=a(),ot=n("p"),ot.innerHTML=Ji,Ts=a(),c(rt.$$.fragment),js=a(),ct=n("p"),ct.textContent=fi,Us=a(),c(mt.$$.fragment),bs=a(),Mt=n("p"),Mt.textContent=yi,gs=a(),c(dt.$$.fragment),Is=a(),ht=n("p"),ht.innerHTML=Ti,vs=a(),ut=n("p"),ut.innerHTML=ji,Cs=a(),c(wt.$$.fragment),Zs=a(),Jt=n("p"),Jt.innerHTML=Ui,Bs=a(),c(ft.$$.fragment),_s=a(),yt=n("p"),yt.textContent=bi,Ws=a(),Tt=n("p"),Tt.innerHTML=gi,Gs=a(),jt=n("p"),jt.innerHTML=Ii,xs=a(),Ut=n("p"),Ut.innerHTML=vi,ks=a(),c(S.$$.fragment),Xs=a(),bt=n("p"),bt.innerHTML=Ci,Vs=a(),gt=n("p"),gt.innerHTML=Zi,Rs=a(),V=n("h3"),Q=n("a"),al=n("span"),c(It.$$.fragment),fa=a(),Kt=n("span"),Kt.textContent=Bi,Ns=a(),vt=n("p"),vt.innerHTML=_i,Hs=a(),Ct=n("p"),Ct.innerHTML=Wi,Fs=a(),Zt=n("blockquote"),Zt.innerHTML=Gi,Es=a(),Bt=n("p"),Bt.textContent=xi,$s=a(),_t=n("p"),_t.textContent=ki,As=a(),c(Wt.$$.fragment),Ys=a(),c(Gt.$$.fragment),Ss=a(),xt=n("p"),xt.textContent=Xi,Qs=a(),z=n("p"),z.innerHTML=Vi,zs=a(),kt=n("p"),kt.textContent=Ri,Ls=a(),c(Xt.$$.fragment),Ps=a(),Vt=n("p"),Vt.innerHTML=Ni,qs=a(),c(Rt.$$.fragment),Ds=a(),Nt=n("p"),Nt.innerHTML=Hi,Ks=a(),c(Ht.$$.fragment),Os=a(),Ft=n("p"),Ft.textContent=Fi,ea=a(),Et=n("ul"),Et.innerHTML=Ei,ta=a(),$t=n("p"),$t.textContent=$i,la=a(),c(L.$$.fragment),sa=a(),At=n("p"),At.innerHTML=Ai,aa=a(),P=n("p"),P.innerHTML=Yi,this.h()},l(e){const t=on("svelte-1phssyn",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(l),b=i(e),J=p(e,"H1",{class:!0});var Yt=j(J);T=p(Yt,"A",{id:!0,class:!0,href:!0});var il=j(T);R=p(il,"SPAN",{});var nl=j(R);m(g.$$.fragment,nl),nl.forEach(l),il.forEach(l),Z=i(Yt),_=p(Yt,"SPAN",{"data-svelte-h":!0}),o(_)!=="svelte-7ho36w"&&(_.textContent=q),Yt.forEach(l),I=i(e),v=p(e,"A",{target:!0,href:!0,"data-svelte-h":!0}),o(v)!=="svelte-1fn2wis"&&(v.innerHTML=U),C=i(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-z81vpv"&&(D.innerHTML=ya),pl=i(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-14o42r"&&(K.textContent=Ta),ol=i(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-tqblgl"&&(O.innerHTML=ja),rl=i(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1on511i"&&(ee.innerHTML=Ua),cl=i(e),W=p(e,"H2",{class:!0});var St=j(W);N=p(St,"A",{id:!0,class:!0,href:!0});var Si=j(N);Ot=p(Si,"SPAN",{});var Qi=j(Ot);m(te.$$.fragment,Qi),Qi.forEach(l),Si.forEach(l),da=i(St),zt=p(St,"SPAN",{"data-svelte-h":!0}),o(zt)!=="svelte-1y11d00"&&(zt.textContent=ba),St.forEach(l),ml=i(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-cqau2t"&&(le.textContent=ga),Ml=i(e),se=p(e,"UL",{"data-svelte-h":!0}),o(se)!=="svelte-1izcxm8"&&(se.innerHTML=Ia),dl=i(e),G=p(e,"H2",{class:!0});var na=j(G);H=p(na,"A",{id:!0,class:!0,href:!0});var zi=j(H);el=p(zi,"SPAN",{});var Li=j(el);m(ae.$$.fragment,Li),Li.forEach(l),zi.forEach(l),ha=i(na),Lt=p(na,"SPAN",{"data-svelte-h":!0}),o(Lt)!=="svelte-1gcn5ck"&&(Lt.textContent=va),na.forEach(l),hl=i(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-cad463"&&(ie.innerHTML=Ca),ul=i(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-15hirvk"&&(ne.innerHTML=Za),wl=i(e),pe=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(pe)!=="svelte-191e550"&&(pe.innerHTML=Ba),Jl=i(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-19xz367"&&(oe.innerHTML=_a),fl=i(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-76ujpq"&&(re.textContent=Wa),yl=i(e),ce=p(e,"UL",{"data-svelte-h":!0}),o(ce)!=="svelte-umnjz5"&&(ce.innerHTML=Ga),Tl=i(e),me=p(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-ybl15o"&&(me.textContent=xa),jl=i(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-f7spg1"&&(Me.innerHTML=ka),Ul=i(e),de=p(e,"UL",{"data-svelte-h":!0}),o(de)!=="svelte-18glkk1"&&(de.innerHTML=Xa),bl=i(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-e5mnz8"&&(he.innerHTML=Va),gl=i(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-304bv6"&&(ue.innerHTML=Ra),Il=i(e),m(we.$$.fragment,e),vl=i(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-tpmlzv"&&(Je.innerHTML=Na),Cl=i(e),m(fe.$$.fragment,e),Zl=i(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-4i7yd5"&&(ye.innerHTML=Ha),Bl=i(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-1iqix0j"&&(Te.innerHTML=Fa),_l=i(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-gipltn"&&(je.innerHTML=Ea),Wl=i(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1vqr9z3"&&(Ue.textContent=$a),Gl=i(e),m(F.$$.fragment,e),xl=i(e),x=p(e,"H2",{class:!0});var pa=j(x);E=p(pa,"A",{id:!0,class:!0,href:!0});var Pi=j(E);tl=p(Pi,"SPAN",{});var qi=j(tl);m(be.$$.fragment,qi),qi.forEach(l),Pi.forEach(l),ua=i(pa),Pt=p(pa,"SPAN",{"data-svelte-h":!0}),o(Pt)!=="svelte-1aoqc4c"&&(Pt.textContent=Aa),pa.forEach(l),kl=i(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-6557l0"&&(ge.textContent=Ya),Xl=i(e),Ie=p(e,"UL",{"data-svelte-h":!0}),o(Ie)!=="svelte-dg8xrl"&&(Ie.innerHTML=Sa),Vl=i(e),k=p(e,"H3",{class:!0});var oa=j(k);$=p(oa,"A",{id:!0,class:!0,href:!0});var Di=j($);ll=p(Di,"SPAN",{});var Ki=j(ll);m(ve.$$.fragment,Ki),Ki.forEach(l),Di.forEach(l),wa=i(oa),qt=p(oa,"SPAN",{"data-svelte-h":!0}),o(qt)!=="svelte-dqcow8"&&(qt.textContent=Qa),oa.forEach(l),Rl=i(e),Ce=p(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-17jh2lx"&&(Ce.innerHTML=za),Nl=i(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-p28ecz"&&(Ze.innerHTML=La),Hl=i(e),m(Be.$$.fragment,e),Fl=i(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-6rdsa0"&&(_e.textContent=Pa),El=i(e),m(We.$$.fragment,e),$l=i(e),Ge=p(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1iembt3"&&(Ge.textContent=qa),Al=i(e),m(xe.$$.fragment,e),Yl=i(e),ke=p(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-1a3tn0d"&&(ke.textContent=Da),Sl=i(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-1881912"&&(Xe.innerHTML=Ka),Ql=i(e),m(Ve.$$.fragment,e),zl=i(e),Re=p(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-qym5mj"&&(Re.innerHTML=Oa),Ll=i(e),m(Ne.$$.fragment,e),Pl=i(e),He=p(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-ni3sdy"&&(He.textContent=ei),ql=i(e),m(Fe.$$.fragment,e),Dl=i(e),Ee=p(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-1xnoaz5"&&(Ee.innerHTML=ti),Kl=i(e),m(A.$$.fragment,e),Ol=i(e),X=p(e,"H3",{class:!0});var ra=j(X);Y=p(ra,"A",{id:!0,class:!0,href:!0});var Oi=j(Y);sl=p(Oi,"SPAN",{});var en=j(sl);m($e.$$.fragment,en),en.forEach(l),Oi.forEach(l),Ja=i(ra),Dt=p(ra,"SPAN",{"data-svelte-h":!0}),o(Dt)!=="svelte-1sokvhg"&&(Dt.textContent=li),ra.forEach(l),es=i(e),Ae=p(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1jagrhd"&&(Ae.innerHTML=si),ts=i(e),Ye=p(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-r4qmx2"&&(Ye.textContent=ai),ls=i(e),Se=p(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-tnn31f"&&(Se.innerHTML=ii),ss=i(e),Qe=p(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-oghx7t"&&(Qe.innerHTML=ni),as=i(e),ze=p(e,"UL",{"data-svelte-h":!0}),o(ze)!=="svelte-yda35x"&&(ze.innerHTML=pi),is=i(e),Le=p(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-1bn7xvw"&&(Le.textContent=oi),ns=i(e),Pe=p(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-fs1abj"&&(Pe.innerHTML=ri),ps=i(e),qe=p(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1t03m2p"&&(qe.textContent=ci),os=i(e),m(De.$$.fragment,e),rs=i(e),m(Ke.$$.fragment,e),cs=i(e),Oe=p(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-1q1xt9i"&&(Oe.textContent=mi),ms=i(e),et=p(e,"UL",{"data-svelte-h":!0}),o(et)!=="svelte-mhcjab"&&(et.innerHTML=Mi),Ms=i(e),tt=p(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-9q1iss"&&(tt.textContent=di),ds=i(e),m(lt.$$.fragment,e),hs=i(e),m(st.$$.fragment,e),us=i(e),at=p(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-5rwzaj"&&(at.textContent=hi),ws=i(e),m(it.$$.fragment,e),Js=i(e),nt=p(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1r4pb3b"&&(nt.innerHTML=ui),fs=i(e),pt=p(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-1n3s9hn"&&(pt.textContent=wi),ys=i(e),ot=p(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-tv5of"&&(ot.innerHTML=Ji),Ts=i(e),m(rt.$$.fragment,e),js=i(e),ct=p(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-pfw8ud"&&(ct.textContent=fi),Us=i(e),m(mt.$$.fragment,e),bs=i(e),Mt=p(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1nzzrqn"&&(Mt.textContent=yi),gs=i(e),m(dt.$$.fragment,e),Is=i(e),ht=p(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-1c659ih"&&(ht.innerHTML=Ti),vs=i(e),ut=p(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-k3cp0u"&&(ut.innerHTML=ji),Cs=i(e),m(wt.$$.fragment,e),Zs=i(e),Jt=p(e,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-1tdcjay"&&(Jt.innerHTML=Ui),Bs=i(e),m(ft.$$.fragment,e),_s=i(e),yt=p(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-14mrga2"&&(yt.textContent=bi),Ws=i(e),Tt=p(e,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-vck7qn"&&(Tt.innerHTML=gi),Gs=i(e),jt=p(e,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-nbfdj7"&&(jt.innerHTML=Ii),xs=i(e),Ut=p(e,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-9ga2iu"&&(Ut.innerHTML=vi),ks=i(e),m(S.$$.fragment,e),Xs=i(e),bt=p(e,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-7qwtg3"&&(bt.innerHTML=Ci),Vs=i(e),gt=p(e,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-hcc15s"&&(gt.innerHTML=Zi),Rs=i(e),V=p(e,"H3",{class:!0});var ca=j(V);Q=p(ca,"A",{id:!0,class:!0,href:!0});var tn=j(Q);al=p(tn,"SPAN",{});var ln=j(al);m(It.$$.fragment,ln),ln.forEach(l),tn.forEach(l),fa=i(ca),Kt=p(ca,"SPAN",{"data-svelte-h":!0}),o(Kt)!=="svelte-dj85eb"&&(Kt.textContent=Bi),ca.forEach(l),Ns=i(e),vt=p(e,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-1jmn10t"&&(vt.innerHTML=_i),Hs=i(e),Ct=p(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-1rk18fl"&&(Ct.innerHTML=Wi),Fs=i(e),Zt=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Zt)!=="svelte-7e4j74"&&(Zt.innerHTML=Gi),Es=i(e),Bt=p(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-simh2d"&&(Bt.textContent=xi),$s=i(e),_t=p(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-1h659dy"&&(_t.textContent=ki),As=i(e),m(Wt.$$.fragment,e),Ys=i(e),m(Gt.$$.fragment,e),Ss=i(e),xt=p(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-1jd4ltz"&&(xt.textContent=Xi),Qs=i(e),z=p(e,"P",{align:!0,"data-svelte-h":!0}),o(z)!=="svelte-94lw7t"&&(z.innerHTML=Vi),zs=i(e),kt=p(e,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-iw90qp"&&(kt.textContent=Ri),Ls=i(e),m(Xt.$$.fragment,e),Ps=i(e),Vt=p(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-a40j2v"&&(Vt.innerHTML=Ni),qs=i(e),m(Rt.$$.fragment,e),Ds=i(e),Nt=p(e,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-1nlt7gv"&&(Nt.innerHTML=Hi),Ks=i(e),m(Ht.$$.fragment,e),Os=i(e),Ft=p(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-17lmdw3"&&(Ft.textContent=Fi),ea=i(e),Et=p(e,"UL",{"data-svelte-h":!0}),o(Et)!=="svelte-16n90lm"&&(Et.innerHTML=Ei),ta=i(e),$t=p(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-1evgdla"&&($t.textContent=$i),la=i(e),m(L.$$.fragment,e),sa=i(e),At=p(e,"P",{"data-svelte-h":!0}),o(At)!=="svelte-ptrlon"&&(At.innerHTML=Ai),aa=i(e),P=p(e,"P",{align:!0,"data-svelte-h":!0}),o(P)!=="svelte-16e5oh4"&&(P.innerHTML=Yi),this.h()},h(){M(r,"name","hf:doc:metadata"),M(r,"content",JSON.stringify(hn)),M(T,"id","evaluating-diffusion-models"),M(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(T,"href","#evaluating-diffusion-models"),M(J,"class","relative group"),M(v,"target","_blank"),M(v,"href","https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/evaluation.ipynb"),M(N,"id","scenarios"),M(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(N,"href","#scenarios"),M(W,"class","relative group"),M(H,"id","qualitative-evaluation"),M(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(H,"href","#qualitative-evaluation"),M(G,"class","relative group"),M(E,"id","quantitative-evaluation"),M(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(E,"href","#quantitative-evaluation"),M(x,"class","relative group"),M($,"id","textguided-image-generation"),M($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M($,"href","#textguided-image-generation"),M(k,"class","relative group"),M(Y,"id","imageconditioned-texttoimage-generation"),M(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Y,"href","#imageconditioned-texttoimage-generation"),M(X,"class","relative group"),M(Q,"id","classconditioned-image-generation"),M(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Q,"href","#classconditioned-image-generation"),M(V,"class","relative group"),M(z,"align","center"),M(P,"align","center")},m(e,t){f(document.head,r),s(e,b,t),s(e,J,t),f(J,T),f(T,R),d(g,R,null),f(J,Z),f(J,_),s(e,I,t),s(e,v,t),s(e,C,t),s(e,D,t),s(e,pl,t),s(e,K,t),s(e,ol,t),s(e,O,t),s(e,rl,t),s(e,ee,t),s(e,cl,t),s(e,W,t),f(W,N),f(N,Ot),d(te,Ot,null),f(W,da),f(W,zt),s(e,ml,t),s(e,le,t),s(e,Ml,t),s(e,se,t),s(e,dl,t),s(e,G,t),f(G,H),f(H,el),d(ae,el,null),f(G,ha),f(G,Lt),s(e,hl,t),s(e,ie,t),s(e,ul,t),s(e,ne,t),s(e,wl,t),s(e,pe,t),s(e,Jl,t),s(e,oe,t),s(e,fl,t),s(e,re,t),s(e,yl,t),s(e,ce,t),s(e,Tl,t),s(e,me,t),s(e,jl,t),s(e,Me,t),s(e,Ul,t),s(e,de,t),s(e,bl,t),s(e,he,t),s(e,gl,t),s(e,ue,t),s(e,Il,t),d(we,e,t),s(e,vl,t),s(e,Je,t),s(e,Cl,t),d(fe,e,t),s(e,Zl,t),s(e,ye,t),s(e,Bl,t),s(e,Te,t),s(e,_l,t),s(e,je,t),s(e,Wl,t),s(e,Ue,t),s(e,Gl,t),d(F,e,t),s(e,xl,t),s(e,x,t),f(x,E),f(E,tl),d(be,tl,null),f(x,ua),f(x,Pt),s(e,kl,t),s(e,ge,t),s(e,Xl,t),s(e,Ie,t),s(e,Vl,t),s(e,k,t),f(k,$),f($,ll),d(ve,ll,null),f(k,wa),f(k,qt),s(e,Rl,t),s(e,Ce,t),s(e,Nl,t),s(e,Ze,t),s(e,Hl,t),d(Be,e,t),s(e,Fl,t),s(e,_e,t),s(e,El,t),d(We,e,t),s(e,$l,t),s(e,Ge,t),s(e,Al,t),d(xe,e,t),s(e,Yl,t),s(e,ke,t),s(e,Sl,t),s(e,Xe,t),s(e,Ql,t),d(Ve,e,t),s(e,zl,t),s(e,Re,t),s(e,Ll,t),d(Ne,e,t),s(e,Pl,t),s(e,He,t),s(e,ql,t),d(Fe,e,t),s(e,Dl,t),s(e,Ee,t),s(e,Kl,t),d(A,e,t),s(e,Ol,t),s(e,X,t),f(X,Y),f(Y,sl),d($e,sl,null),f(X,Ja),f(X,Dt),s(e,es,t),s(e,Ae,t),s(e,ts,t),s(e,Ye,t),s(e,ls,t),s(e,Se,t),s(e,ss,t),s(e,Qe,t),s(e,as,t),s(e,ze,t),s(e,is,t),s(e,Le,t),s(e,ns,t),s(e,Pe,t),s(e,ps,t),s(e,qe,t),s(e,os,t),d(De,e,t),s(e,rs,t),d(Ke,e,t),s(e,cs,t),s(e,Oe,t),s(e,ms,t),s(e,et,t),s(e,Ms,t),s(e,tt,t),s(e,ds,t),d(lt,e,t),s(e,hs,t),d(st,e,t),s(e,us,t),s(e,at,t),s(e,ws,t),d(it,e,t),s(e,Js,t),s(e,nt,t),s(e,fs,t),s(e,pt,t),s(e,ys,t),s(e,ot,t),s(e,Ts,t),d(rt,e,t),s(e,js,t),s(e,ct,t),s(e,Us,t),d(mt,e,t),s(e,bs,t),s(e,Mt,t),s(e,gs,t),d(dt,e,t),s(e,Is,t),s(e,ht,t),s(e,vs,t),s(e,ut,t),s(e,Cs,t),d(wt,e,t),s(e,Zs,t),s(e,Jt,t),s(e,Bs,t),d(ft,e,t),s(e,_s,t),s(e,yt,t),s(e,Ws,t),s(e,Tt,t),s(e,Gs,t),s(e,jt,t),s(e,xs,t),s(e,Ut,t),s(e,ks,t),d(S,e,t),s(e,Xs,t),s(e,bt,t),s(e,Vs,t),s(e,gt,t),s(e,Rs,t),s(e,V,t),f(V,Q),f(Q,al),d(It,al,null),f(V,fa),f(V,Kt),s(e,Ns,t),s(e,vt,t),s(e,Hs,t),s(e,Ct,t),s(e,Fs,t),s(e,Zt,t),s(e,Es,t),s(e,Bt,t),s(e,$s,t),s(e,_t,t),s(e,As,t),d(Wt,e,t),s(e,Ys,t),d(Gt,e,t),s(e,Ss,t),s(e,xt,t),s(e,Qs,t),s(e,z,t),s(e,zs,t),s(e,kt,t),s(e,Ls,t),d(Xt,e,t),s(e,Ps,t),s(e,Vt,t),s(e,qs,t),d(Rt,e,t),s(e,Ds,t),s(e,Nt,t),s(e,Ks,t),d(Ht,e,t),s(e,Os,t),s(e,Ft,t),s(e,ea,t),s(e,Et,t),s(e,ta,t),s(e,$t,t),s(e,la,t),d(L,e,t),s(e,sa,t),s(e,At,t),s(e,aa,t),s(e,P,t),ia=!0},p(e,[t]){const Yt={};t&2&&(Yt.$$scope={dirty:t,ctx:e}),F.$set(Yt);const il={};t&2&&(il.$$scope={dirty:t,ctx:e}),A.$set(il);const nl={};t&2&&(nl.$$scope={dirty:t,ctx:e}),S.$set(nl);const St={};t&2&&(St.$$scope={dirty:t,ctx:e}),L.$set(St)},i(e){ia||(h(g.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(we.$$.fragment,e),h(fe.$$.fragment,e),h(F.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(Be.$$.fragment,e),h(We.$$.fragment,e),h(xe.$$.fragment,e),h(Ve.$$.fragment,e),h(Ne.$$.fragment,e),h(Fe.$$.fragment,e),h(A.$$.fragment,e),h($e.$$.fragment,e),h(De.$$.fragment,e),h(Ke.$$.fragment,e),h(lt.$$.fragment,e),h(st.$$.fragment,e),h(it.$$.fragment,e),h(rt.$$.fragment,e),h(mt.$$.fragment,e),h(dt.$$.fragment,e),h(wt.$$.fragment,e),h(ft.$$.fragment,e),h(S.$$.fragment,e),h(It.$$.fragment,e),h(Wt.$$.fragment,e),h(Gt.$$.fragment,e),h(Xt.$$.fragment,e),h(Rt.$$.fragment,e),h(Ht.$$.fragment,e),h(L.$$.fragment,e),ia=!0)},o(e){u(g.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(we.$$.fragment,e),u(fe.$$.fragment,e),u(F.$$.fragment,e),u(be.$$.fragment,e),u(ve.$$.fragment,e),u(Be.$$.fragment,e),u(We.$$.fragment,e),u(xe.$$.fragment,e),u(Ve.$$.fragment,e),u(Ne.$$.fragment,e),u(Fe.$$.fragment,e),u(A.$$.fragment,e),u($e.$$.fragment,e),u(De.$$.fragment,e),u(Ke.$$.fragment,e),u(lt.$$.fragment,e),u(st.$$.fragment,e),u(it.$$.fragment,e),u(rt.$$.fragment,e),u(mt.$$.fragment,e),u(dt.$$.fragment,e),u(wt.$$.fragment,e),u(ft.$$.fragment,e),u(S.$$.fragment,e),u(It.$$.fragment,e),u(Wt.$$.fragment,e),u(Gt.$$.fragment,e),u(Xt.$$.fragment,e),u(Rt.$$.fragment,e),u(Ht.$$.fragment,e),u(L.$$.fragment,e),ia=!1},d(e){e&&(l(b),l(J),l(I),l(v),l(C),l(D),l(pl),l(K),l(ol),l(O),l(rl),l(ee),l(cl),l(W),l(ml),l(le),l(Ml),l(se),l(dl),l(G),l(hl),l(ie),l(ul),l(ne),l(wl),l(pe),l(Jl),l(oe),l(fl),l(re),l(yl),l(ce),l(Tl),l(me),l(jl),l(Me),l(Ul),l(de),l(bl),l(he),l(gl),l(ue),l(Il),l(vl),l(Je),l(Cl),l(Zl),l(ye),l(Bl),l(Te),l(_l),l(je),l(Wl),l(Ue),l(Gl),l(xl),l(x),l(kl),l(ge),l(Xl),l(Ie),l(Vl),l(k),l(Rl),l(Ce),l(Nl),l(Ze),l(Hl),l(Fl),l(_e),l(El),l($l),l(Ge),l(Al),l(Yl),l(ke),l(Sl),l(Xe),l(Ql),l(zl),l(Re),l(Ll),l(Pl),l(He),l(ql),l(Dl),l(Ee),l(Kl),l(Ol),l(X),l(es),l(Ae),l(ts),l(Ye),l(ls),l(Se),l(ss),l(Qe),l(as),l(ze),l(is),l(Le),l(ns),l(Pe),l(ps),l(qe),l(os),l(rs),l(cs),l(Oe),l(ms),l(et),l(Ms),l(tt),l(ds),l(hs),l(us),l(at),l(ws),l(Js),l(nt),l(fs),l(pt),l(ys),l(ot),l(Ts),l(js),l(ct),l(Us),l(bs),l(Mt),l(gs),l(Is),l(ht),l(vs),l(ut),l(Cs),l(Zs),l(Jt),l(Bs),l(_s),l(yt),l(Ws),l(Tt),l(Gs),l(jt),l(xs),l(Ut),l(ks),l(Xs),l(bt),l(Vs),l(gt),l(Rs),l(V),l(Ns),l(vt),l(Hs),l(Ct),l(Fs),l(Zt),l(Es),l(Bt),l($s),l(_t),l(As),l(Ys),l(Ss),l(xt),l(Qs),l(z),l(zs),l(kt),l(Ls),l(Ps),l(Vt),l(qs),l(Ds),l(Nt),l(Ks),l(Os),l(Ft),l(ea),l(Et),l(ta),l($t),l(la),l(sa),l(At),l(aa),l(P)),l(r),w(g),w(te),w(ae),w(we,e),w(fe,e),w(F,e),w(be),w(ve),w(Be,e),w(We,e),w(xe,e),w(Ve,e),w(Ne,e),w(Fe,e),w(A,e),w($e),w(De,e),w(Ke,e),w(lt,e),w(st,e),w(it,e),w(rt,e),w(mt,e),w(dt,e),w(wt,e),w(ft,e),w(S,e),w(It),w(Wt,e),w(Gt,e),w(Xt,e),w(Rt,e),w(Ht,e),w(L,e)}}}const hn={local:"evaluating-diffusion-models",sections:[{local:"scenarios",title:"Scenarios"},{local:"qualitative-evaluation",title:"Qualitative Evaluation"},{local:"quantitative-evaluation",sections:[{local:"textguided-image-generation",title:"Text-guided image generation"},{local:"imageconditioned-texttoimage-generation",title:"Image-conditioned text-to-image generation"},{local:"classconditioned-image-generation",title:"Class-conditioned image generation"}],title:"Quantitative Evaluation"}],title:"Evaluating Diffusion Models"};function un(B){return an(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jn extends nn{constructor(r){super(),pn(this,r,un,dn,sn,{})}}export{jn as component};
