import{s as Kn,o as eo,n as bn}from"../chunks/scheduler.182ea377.js";import{S as to,i as no,g as i,s as n,r as g,A as oo,h as s,f as a,c as o,j as D,u,x as l,k as $,y as t,a as m,v as h,d as _,t as b,w as v}from"../chunks/index.abf12888.js";import{T as io}from"../chunks/Tip.230e2334.js";import{D as C}from"../chunks/Docstring.93f6f462.js";import{C as Yn}from"../chunks/CodeBlock.57fe6e13.js";import{E as qn}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as nt}from"../chunks/Heading.16916d63.js";function so(S){let p,k='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){p=i("p"),p.innerHTML=k},l(w){p=s(w,"P",{"data-svelte-h":!0}),l(p)!=="svelte-1wmc0l4"&&(p.innerHTML=k)},m(w,x){m(w,p,x)},p:bn,d(w){w&&a(p)}}}function ao(S){let p,k="Examples:",w,x,M;return x=new Yn({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQWx0RGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwQWx0RGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkJBQUklMkZBbHREaWZmdXNpb24tbTklMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjAlMjJkYXJrJTIwZWxmJTIwcHJpbmNlc3MlMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMGQlMjAlMjYlMjBkJTJDJTIwZmFudGFzeSUyQyUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwZGlnaXRhbCUyMHBhaW50aW5nJTJDJTIwdHJlbmRpbmclMjBvbiUyMGFydHN0YXRpb24lMkMlMjBjb25jZXB0JTIwYXJ0JTJDJTIwc2hhcnAlMjBmb2N1cyUyQyUyMGlsbHVzdHJhdGlvbiUyQyUyMGFydCUyMGJ5JTIwYXJ0Z2VybSUyMGFuZCUyMGdyZWclMjBydXRrb3dza2klMjBhbmQlMjBmdWppJTIwY2hva28lMjBhbmQlMjB2aWt0b3JpYSUyMGdhdnJpbGVua28lMjBhbmQlMjBob2FuZyUyMGxhcCUyMiUwQXByb21wdCUyMCUzRCUyMCUyMiVFOSVCQiU5MSVFNiU5QSU5NyVFNyVCMiVCRSVFNyU4MSVCNSVFNSU4NSVBQyVFNCVCOCVCQiVFRiVCQyU4QyVFOSU5RCU5RSVFNSVCOCVCOCVFOCVBRiVBNiVFNyVCQiU4NiVFRiVCQyU4QyVFNSVCOSVCQiVFNiU4MyVCMyVFRiVCQyU4QyVFOSU5RCU5RSVFNSVCOCVCOCVFOCVBRiVBNiVFNyVCQiU4NiVFRiVCQyU4QyVFNiU5NSVCMCVFNSVBRCU5NyVFNyVCQiU5OCVFNyU5NCVCQiVFRiVCQyU4QyVFNiVBNiU4MiVFNSVCRiVCNSVFOCU4OSVCQSVFNiU5QyVBRiVFRiVCQyU4QyVFNiU5NSU4RiVFOSU5NCU5MCVFNyU5QSU4NCVFNyU4NCVBNiVFNyU4MiVCOSVFRiVCQyU4QyVFNiU4RiU5MiVFNSU5QiVCRSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AltDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AltDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;BAAI/AltDiffusion-m9&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># &quot;dark elf princess, highly detailed, d &amp; d, fantasy, highly detailed, digital painting, trending on artstation, concept art, sharp focus, illustration, art by artgerm and greg rutkowski and fuji choko and viktoria gavrilenko and hoang lap&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;黑暗精灵公主，非常详细，幻想，非常详细，数字绘画，概念艺术，敏锐的焦点，插图&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=i("p"),p.textContent=k,w=n(),g(x.$$.fragment)},l(d){p=s(d,"P",{"data-svelte-h":!0}),l(p)!=="svelte-kvfsh7"&&(p.textContent=k),w=o(d),u(x.$$.fragment,d)},m(d,P){m(d,p,P),m(d,w,P),h(x,d,P),M=!0},p:bn,i(d){M||(_(x.$$.fragment,d),M=!0)},o(d){b(x.$$.fragment,d),M=!1},d(d){d&&(a(p),a(w)),v(x,d)}}}function ro(S){let p,k="Examples:",w,x,M;return x=new Yn({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQWx0RGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsX2lkX29yX3BhdGglMjAlM0QlMjAlMjJCQUFJJTJGQWx0RGlmZnVzaW9uLW05JTIyJTBBcGlwZSUyMCUzRCUyMEFsdERpZmZ1c2lvbkltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byhkZXZpY2UpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oQnl0ZXNJTyhyZXNwb25zZS5jb250ZW50KSkuY29udmVydCglMjJSR0IlMjIpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGluaXRfaW1hZ2UucmVzaXplKCg3NjglMkMlMjA1MTIpKSUwQSUwQSUyMyUyMCUyMkElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTJDJTIwdHJlbmRpbmclMjBvbiUyMGFydHN0YXRpb24lMjIlMEFwcm9tcHQlMjAlM0QlMjAlMjIlRTUlQjklQkIlRTYlODMlQjMlRTklQTMlOEUlRTYlOTklQUYlMkMlMjBhcnRzdGF0aW9uJTIyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBzdHJlbmd0aCUzRDAuNzUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMiVFNSVCOSVCQiVFNiU4MyVCMyVFOSVBMyU4RSVFNiU5OSVBRi5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AltDiffusionImg2ImgPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id_or_path = <span class="hljs-string">&quot;BAAI/AltDiffusion-m9&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AltDiffusionImg2ImgPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># &quot;A fantasy landscape, trending on artstation&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;幻想风景, artstation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;幻想风景.png&quot;</span>)`,wrap:!1}}),{c(){p=i("p"),p.textContent=k,w=n(),g(x.$$.fragment)},l(d){p=s(d,"P",{"data-svelte-h":!0}),l(p)!=="svelte-kvfsh7"&&(p.textContent=k),w=o(d),u(x.$$.fragment,d)},m(d,P){m(d,p,P),m(d,w,P),h(x,d,P),M=!0},p:bn,i(d){M||(_(x.$$.fragment,d),M=!0)},o(d){b(x.$$.fragment,d),M=!1},d(d){d&&(a(p),a(w)),v(x,d)}}}function lo(S){let p,k,w,x,M,d,P,vn='AltDiffusion was proposed in <a href="https://huggingface.co/papers/2211.06679" rel="nofollow">AltCLIP: Altering the Language Encoder in CLIP for Extended Language Capabilities</a> by Zhongzhi Chen, Guang Liu, Bo-Wen Zhang, Fulong Ye, Qinghong Yang, Ledell Wu.',ot,K,yn="The abstract from the paper is:",it,ee,xn='<em>In this work, we present a conceptually simple and effective method to train a strong bilingual/multilingual multimodal representation model. Starting from the pre-trained multimodal representation model CLIP released by OpenAI, we altered its text encoder with a pre-trained multilingual text encoder XLM-R, and aligned both languages and image representations by a two-stage training schema consisting of teacher learning and contrastive learning. We validate our method through evaluations of a wide range of tasks. We set new state-of-the-art performances on a bunch of tasks including ImageNet-CN, Flicker30k-CN, COCO-CN and XTD. Further, we obtain very close performances with CLIP on almost all tasks, suggesting that one can simply alter the text encoder in CLIP for extended capabilities such as multilingual understanding. Our models and code are available at <a href="https://github.com/FlagAI-Open/FlagAI" rel="nofollow">this https URL</a>.</em>',st,te,at,ne,wn='<code>AltDiffusion</code> is conceptually the same as <a href="./stable_diffusion/overview">Stable Diffusion</a>.',rt,j,lt,oe,dt,c,ie,Ct,$e,In="Pipeline for text-to-image generation using Alt Diffusion.",Mt,Ce,Dn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Pt,Me,$n="The pipeline also inherits the following loading methods:",kt,Pe,Cn='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li>',Tt,U,se,At,ke,Mn="The call function to the pipeline for generation.",Lt,F,Ut,J,ae,Vt,Te,Pn="Disables the FreeU mechanism if enabled.",Nt,R,re,St,Ae,kn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,jt,B,le,Ft,Le,Tn=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Jt,T,de,Rt,Ue,An='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Bt,Ve,Ln="The suffixes after the scaling factors represent the stages where they are being applied.",Wt,Ne,Un=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Alt Diffusion v1, v2, and Alt Diffusion XL.`,Zt,W,pe,Et,Se,Vn=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Gt,Z,ce,Qt,je,Nn=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,zt,E,fe,Ot,Fe,Sn="Encodes the prompt into text encoder hidden states.",Ht,G,me,Xt,Je,jn='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',pt,ge,ct,y,ue,qt,Re,Fn="Pipeline for text-guided image-to-image generation using Alt Diffusion.",Yt,Be,Jn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Kt,We,Rn="The pipeline also inherits the following loading methods:",en,Ze,Bn='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li>',tn,V,he,nn,Ee,Wn="The call function to the pipeline for generation.",on,Q,sn,z,_e,an,Ge,Zn="Disables the FreeU mechanism if enabled.",rn,A,be,ln,Qe,En='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',dn,ze,Gn="The suffixes after the scaling factors represent the stages where they are being applied.",pn,Oe,Qn=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Alt Diffusion v1, v2, and Alt Diffusion XL.`,cn,O,ve,fn,He,zn="Encodes the prompt into text encoder hidden states.",mn,H,ye,gn,Xe,On='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',ft,xe,mt,L,we,un,qe,Hn="Output class for Alt Diffusion pipelines.",hn,X,Ie,_n,Ye,Xn="Call self as a function.",gt,tt,ut;return M=new nt({props:{title:"AltDiffusion",local:"altdiffusion",headingTag:"h1"}}),te=new nt({props:{title:"Tips",local:"tips",headingTag:"h2"}}),j=new io({props:{$$slots:{default:[so]},$$scope:{ctx:S}}}),oe=new nt({props:{title:"AltDiffusionPipeline",local:"diffusers.AltDiffusionPipeline",headingTag:"h2"}}),ie=new C({props:{name:"class diffusers.AltDiffusionPipeline",anchor:"diffusers.AltDiffusionPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": RobertaSeriesModelWithTransformation"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.AltDiffusionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AltDiffusionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>RobertaSeriesModelWithTransformation</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.AltDiffusionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer" rel="nofollow">XLMRobertaTokenizer</a>) &#x2014;
A <code>XLMRobertaTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AltDiffusionPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.AltDiffusionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.AltDiffusionPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.AltDiffusionPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion.py#L77"}}),se=new C({props:{name:"__call__",anchor:"diffusers.AltDiffusionPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.AltDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AltDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.AltDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.AltDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AltDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AltDiffusionPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AltDiffusionPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.AltDiffusionPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AltDiffusionPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AltDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.AltDiffusionPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AltDiffusionPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AltDiffusionPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AltDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.AltDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.AltDiffusionPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AltDiffusionPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.AltDiffusionPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.AltDiffusionPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.AltDiffusionPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion.py#L639",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.stable_diffusion.AltDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.AltDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),F=new qn({props:{anchor:"diffusers.AltDiffusionPipeline.__call__.example",$$slots:{default:[ao]},$$scope:{ctx:S}}}),ae=new C({props:{name:"disable_freeu",anchor:"diffusers.AltDiffusionPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion.py#L580"}}),re=new C({props:{name:"disable_vae_slicing",anchor:"diffusers.AltDiffusionPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion.py#L212"}}),le=new C({props:{name:"disable_vae_tiling",anchor:"diffusers.AltDiffusionPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion.py#L227"}}),de=new C({props:{name:"enable_freeu",anchor:"diffusers.AltDiffusionPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.AltDiffusionPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.AltDiffusionPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.AltDiffusionPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.AltDiffusionPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion.py#L558"}}),pe=new C({props:{name:"enable_vae_slicing",anchor:"diffusers.AltDiffusionPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion.py#L205"}}),ce=new C({props:{name:"enable_vae_tiling",anchor:"diffusers.AltDiffusionPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion.py#L219"}}),fe=new C({props:{name:"encode_prompt",anchor:"diffusers.AltDiffusionPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.AltDiffusionPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.AltDiffusionPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.AltDiffusionPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AltDiffusionPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AltDiffusionPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AltDiffusionPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AltDiffusionPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AltDiffusionPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion.py#L266"}}),me=new C({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.AltDiffusionPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:""},{name:"embedding_dim",val:" = 512"},{name:"dtype",val:" = torch.float32"}],parametersDescription:[{anchor:"diffusers.AltDiffusionPipeline.get_guidance_scale_embedding.timesteps",description:`<strong>timesteps</strong> (<code>torch.Tensor</code>) &#x2014;
generate embedding vectors at these timesteps`,name:"timesteps"},{anchor:"diffusers.AltDiffusionPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
dimension of the embeddings to generate
dtype &#x2014;
data type of the generated embeddings`,name:"embedding_dim"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion.py#L584",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(timesteps), embedding_dim)</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),ge=new nt({props:{title:"AltDiffusionImg2ImgPipeline",local:"diffusers.AltDiffusionImg2ImgPipeline",headingTag:"h2"}}),ue=new C({props:{name:"class diffusers.AltDiffusionImg2ImgPipeline",anchor:"diffusers.AltDiffusionImg2ImgPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": RobertaSeriesModelWithTransformation"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.AltDiffusionImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>RobertaSeriesModelWithTransformation</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer" rel="nofollow">XLMRobertaTokenizer</a>) &#x2014;
A <code>XLMRobertaTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion_img2img.py#L113"}}),he=new C({props:{name:"__call__",anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": typing.Optional[int] = 50"},{name:"guidance_scale",val:": typing.Optional[float] = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": typing.Optional[float] = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"clip_skip",val:": int = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.AltDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion_img2img.py#L693",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.stable_diffusion.AltDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.AltDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Q=new qn({props:{anchor:"diffusers.AltDiffusionImg2ImgPipeline.__call__.example",$$slots:{default:[ro]},$$scope:{ctx:S}}}),_e=new C({props:{name:"disable_freeu",anchor:"diffusers.AltDiffusionImg2ImgPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion_img2img.py#L638"}}),be=new C({props:{name:"enable_freeu",anchor:"diffusers.AltDiffusionImg2ImgPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.AltDiffusionImg2ImgPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion_img2img.py#L616"}}),ve=new C({props:{name:"encode_prompt",anchor:"diffusers.AltDiffusionImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.AltDiffusionImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion_img2img.py#L275"}}),ye=new C({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.AltDiffusionImg2ImgPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:""},{name:"embedding_dim",val:" = 512"},{name:"dtype",val:" = torch.float32"}],parametersDescription:[{anchor:"diffusers.AltDiffusionImg2ImgPipeline.get_guidance_scale_embedding.timesteps",description:`<strong>timesteps</strong> (<code>torch.Tensor</code>) &#x2014;
generate embedding vectors at these timesteps`,name:"timesteps"},{anchor:"diffusers.AltDiffusionImg2ImgPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
dimension of the embeddings to generate
dtype &#x2014;
data type of the generated embeddings`,name:"embedding_dim"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_alt_diffusion_img2img.py#L642",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(timesteps), embedding_dim)</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),xe=new nt({props:{title:"AltDiffusionPipelineOutput",local:"diffusers.pipelines.alt_diffusion.AltDiffusionPipelineOutput",headingTag:"h2"}}),we=new C({props:{name:"class diffusers.pipelines.alt_diffusion.AltDiffusionPipelineOutput",anchor:"diffusers.pipelines.alt_diffusion.AltDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.alt_diffusion.AltDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.alt_diffusion.AltDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/alt_diffusion/pipeline_output.py#L14"}}),Ie=new C({props:{name:"__call__",anchor:"diffusers.pipelines.alt_diffusion.AltDiffusionPipelineOutput.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),{c(){p=i("meta"),k=n(),w=i("p"),x=n(),g(M.$$.fragment),d=n(),P=i("p"),P.innerHTML=vn,ot=n(),K=i("p"),K.textContent=yn,it=n(),ee=i("p"),ee.innerHTML=xn,st=n(),g(te.$$.fragment),at=n(),ne=i("p"),ne.innerHTML=wn,rt=n(),g(j.$$.fragment),lt=n(),g(oe.$$.fragment),dt=n(),c=i("div"),g(ie.$$.fragment),Ct=n(),$e=i("p"),$e.textContent=In,Mt=n(),Ce=i("p"),Ce.innerHTML=Dn,Pt=n(),Me=i("p"),Me.textContent=$n,kt=n(),Pe=i("ul"),Pe.innerHTML=Cn,Tt=n(),U=i("div"),g(se.$$.fragment),At=n(),ke=i("p"),ke.textContent=Mn,Lt=n(),g(F.$$.fragment),Ut=n(),J=i("div"),g(ae.$$.fragment),Vt=n(),Te=i("p"),Te.textContent=Pn,Nt=n(),R=i("div"),g(re.$$.fragment),St=n(),Ae=i("p"),Ae.innerHTML=kn,jt=n(),B=i("div"),g(le.$$.fragment),Ft=n(),Le=i("p"),Le.innerHTML=Tn,Jt=n(),T=i("div"),g(de.$$.fragment),Rt=n(),Ue=i("p"),Ue.innerHTML=An,Bt=n(),Ve=i("p"),Ve.textContent=Ln,Wt=n(),Ne=i("p"),Ne.innerHTML=Un,Zt=n(),W=i("div"),g(pe.$$.fragment),Et=n(),Se=i("p"),Se.textContent=Vn,Gt=n(),Z=i("div"),g(ce.$$.fragment),Qt=n(),je=i("p"),je.textContent=Nn,zt=n(),E=i("div"),g(fe.$$.fragment),Ot=n(),Fe=i("p"),Fe.textContent=Sn,Ht=n(),G=i("div"),g(me.$$.fragment),Xt=n(),Je=i("p"),Je.innerHTML=jn,pt=n(),g(ge.$$.fragment),ct=n(),y=i("div"),g(ue.$$.fragment),qt=n(),Re=i("p"),Re.textContent=Fn,Yt=n(),Be=i("p"),Be.innerHTML=Jn,Kt=n(),We=i("p"),We.textContent=Rn,en=n(),Ze=i("ul"),Ze.innerHTML=Bn,tn=n(),V=i("div"),g(he.$$.fragment),nn=n(),Ee=i("p"),Ee.textContent=Wn,on=n(),g(Q.$$.fragment),sn=n(),z=i("div"),g(_e.$$.fragment),an=n(),Ge=i("p"),Ge.textContent=Zn,rn=n(),A=i("div"),g(be.$$.fragment),ln=n(),Qe=i("p"),Qe.innerHTML=En,dn=n(),ze=i("p"),ze.textContent=Gn,pn=n(),Oe=i("p"),Oe.innerHTML=Qn,cn=n(),O=i("div"),g(ve.$$.fragment),fn=n(),He=i("p"),He.textContent=zn,mn=n(),H=i("div"),g(ye.$$.fragment),gn=n(),Xe=i("p"),Xe.innerHTML=On,ft=n(),g(xe.$$.fragment),mt=n(),L=i("div"),g(we.$$.fragment),un=n(),qe=i("p"),qe.textContent=Hn,hn=n(),X=i("div"),g(Ie.$$.fragment),_n=n(),Ye=i("p"),Ye.textContent=Xn,gt=n(),tt=i("p"),this.h()},l(e){const r=oo("svelte-u9bgzb",document.head);p=s(r,"META",{name:!0,content:!0}),r.forEach(a),k=o(e),w=s(e,"P",{}),D(w).forEach(a),x=o(e),u(M.$$.fragment,e),d=o(e),P=s(e,"P",{"data-svelte-h":!0}),l(P)!=="svelte-4gzqzf"&&(P.innerHTML=vn),ot=o(e),K=s(e,"P",{"data-svelte-h":!0}),l(K)!=="svelte-1cwsb16"&&(K.textContent=yn),it=o(e),ee=s(e,"P",{"data-svelte-h":!0}),l(ee)!=="svelte-1ii61zn"&&(ee.innerHTML=xn),st=o(e),u(te.$$.fragment,e),at=o(e),ne=s(e,"P",{"data-svelte-h":!0}),l(ne)!=="svelte-1fxp82q"&&(ne.innerHTML=wn),rt=o(e),u(j.$$.fragment,e),lt=o(e),u(oe.$$.fragment,e),dt=o(e),c=s(e,"DIV",{class:!0});var f=D(c);u(ie.$$.fragment,f),Ct=o(f),$e=s(f,"P",{"data-svelte-h":!0}),l($e)!=="svelte-1y8ubhy"&&($e.textContent=In),Mt=o(f),Ce=s(f,"P",{"data-svelte-h":!0}),l(Ce)!=="svelte-496sm0"&&(Ce.innerHTML=Dn),Pt=o(f),Me=s(f,"P",{"data-svelte-h":!0}),l(Me)!=="svelte-14s6m4u"&&(Me.textContent=$n),kt=o(f),Pe=s(f,"UL",{"data-svelte-h":!0}),l(Pe)!=="svelte-iou1i9"&&(Pe.innerHTML=Cn),Tt=o(f),U=s(f,"DIV",{class:!0});var N=D(U);u(se.$$.fragment,N),At=o(N),ke=s(N,"P",{"data-svelte-h":!0}),l(ke)!=="svelte-50j04k"&&(ke.textContent=Mn),Lt=o(N),u(F.$$.fragment,N),N.forEach(a),Ut=o(f),J=s(f,"DIV",{class:!0});var De=D(J);u(ae.$$.fragment,De),Vt=o(De),Te=s(De,"P",{"data-svelte-h":!0}),l(Te)!=="svelte-psupw6"&&(Te.textContent=Pn),De.forEach(a),Nt=o(f),R=s(f,"DIV",{class:!0});var ht=D(R);u(re.$$.fragment,ht),St=o(ht),Ae=s(ht,"P",{"data-svelte-h":!0}),l(Ae)!=="svelte-1s3c06i"&&(Ae.innerHTML=kn),ht.forEach(a),jt=o(f),B=s(f,"DIV",{class:!0});var _t=D(B);u(le.$$.fragment,_t),Ft=o(_t),Le=s(_t,"P",{"data-svelte-h":!0}),l(Le)!=="svelte-pkn4ui"&&(Le.innerHTML=Tn),_t.forEach(a),Jt=o(f),T=s(f,"DIV",{class:!0});var q=D(T);u(de.$$.fragment,q),Rt=o(q),Ue=s(q,"P",{"data-svelte-h":!0}),l(Ue)!=="svelte-1f3tmq1"&&(Ue.innerHTML=An),Bt=o(q),Ve=s(q,"P",{"data-svelte-h":!0}),l(Ve)!=="svelte-xjijlp"&&(Ve.textContent=Ln),Wt=o(q),Ne=s(q,"P",{"data-svelte-h":!0}),l(Ne)!=="svelte-6gu1ro"&&(Ne.innerHTML=Un),q.forEach(a),Zt=o(f),W=s(f,"DIV",{class:!0});var bt=D(W);u(pe.$$.fragment,bt),Et=o(bt),Se=s(bt,"P",{"data-svelte-h":!0}),l(Se)!=="svelte-14bnrb6"&&(Se.textContent=Vn),bt.forEach(a),Gt=o(f),Z=s(f,"DIV",{class:!0});var vt=D(Z);u(ce.$$.fragment,vt),Qt=o(vt),je=s(vt,"P",{"data-svelte-h":!0}),l(je)!=="svelte-1xwrf7t"&&(je.textContent=Nn),vt.forEach(a),zt=o(f),E=s(f,"DIV",{class:!0});var yt=D(E);u(fe.$$.fragment,yt),Ot=o(yt),Fe=s(yt,"P",{"data-svelte-h":!0}),l(Fe)!=="svelte-16q0ax1"&&(Fe.textContent=Sn),yt.forEach(a),Ht=o(f),G=s(f,"DIV",{class:!0});var xt=D(G);u(me.$$.fragment,xt),Xt=o(xt),Je=s(xt,"P",{"data-svelte-h":!0}),l(Je)!=="svelte-vo59ec"&&(Je.innerHTML=jn),xt.forEach(a),f.forEach(a),pt=o(e),u(ge.$$.fragment,e),ct=o(e),y=s(e,"DIV",{class:!0});var I=D(y);u(ue.$$.fragment,I),qt=o(I),Re=s(I,"P",{"data-svelte-h":!0}),l(Re)!=="svelte-ghlpck"&&(Re.textContent=Fn),Yt=o(I),Be=s(I,"P",{"data-svelte-h":!0}),l(Be)!=="svelte-496sm0"&&(Be.innerHTML=Jn),Kt=o(I),We=s(I,"P",{"data-svelte-h":!0}),l(We)!=="svelte-14s6m4u"&&(We.textContent=Rn),en=o(I),Ze=s(I,"UL",{"data-svelte-h":!0}),l(Ze)!=="svelte-iou1i9"&&(Ze.innerHTML=Bn),tn=o(I),V=s(I,"DIV",{class:!0});var Ke=D(V);u(he.$$.fragment,Ke),nn=o(Ke),Ee=s(Ke,"P",{"data-svelte-h":!0}),l(Ee)!=="svelte-50j04k"&&(Ee.textContent=Wn),on=o(Ke),u(Q.$$.fragment,Ke),Ke.forEach(a),sn=o(I),z=s(I,"DIV",{class:!0});var wt=D(z);u(_e.$$.fragment,wt),an=o(wt),Ge=s(wt,"P",{"data-svelte-h":!0}),l(Ge)!=="svelte-psupw6"&&(Ge.textContent=Zn),wt.forEach(a),rn=o(I),A=s(I,"DIV",{class:!0});var Y=D(A);u(be.$$.fragment,Y),ln=o(Y),Qe=s(Y,"P",{"data-svelte-h":!0}),l(Qe)!=="svelte-1f3tmq1"&&(Qe.innerHTML=En),dn=o(Y),ze=s(Y,"P",{"data-svelte-h":!0}),l(ze)!=="svelte-xjijlp"&&(ze.textContent=Gn),pn=o(Y),Oe=s(Y,"P",{"data-svelte-h":!0}),l(Oe)!=="svelte-6gu1ro"&&(Oe.innerHTML=Qn),Y.forEach(a),cn=o(I),O=s(I,"DIV",{class:!0});var It=D(O);u(ve.$$.fragment,It),fn=o(It),He=s(It,"P",{"data-svelte-h":!0}),l(He)!=="svelte-16q0ax1"&&(He.textContent=zn),It.forEach(a),mn=o(I),H=s(I,"DIV",{class:!0});var Dt=D(H);u(ye.$$.fragment,Dt),gn=o(Dt),Xe=s(Dt,"P",{"data-svelte-h":!0}),l(Xe)!=="svelte-vo59ec"&&(Xe.innerHTML=On),Dt.forEach(a),I.forEach(a),ft=o(e),u(xe.$$.fragment,e),mt=o(e),L=s(e,"DIV",{class:!0});var et=D(L);u(we.$$.fragment,et),un=o(et),qe=s(et,"P",{"data-svelte-h":!0}),l(qe)!=="svelte-t88zjp"&&(qe.textContent=Hn),hn=o(et),X=s(et,"DIV",{class:!0});var $t=D(X);u(Ie.$$.fragment,$t),_n=o($t),Ye=s($t,"P",{"data-svelte-h":!0}),l(Ye)!=="svelte-1eed40t"&&(Ye.textContent=Xn),$t.forEach(a),et.forEach(a),gt=o(e),tt=s(e,"P",{}),D(tt).forEach(a),this.h()},h(){$(p,"name","hf:doc:metadata"),$(p,"content",po),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){t(document.head,p),m(e,k,r),m(e,w,r),m(e,x,r),h(M,e,r),m(e,d,r),m(e,P,r),m(e,ot,r),m(e,K,r),m(e,it,r),m(e,ee,r),m(e,st,r),h(te,e,r),m(e,at,r),m(e,ne,r),m(e,rt,r),h(j,e,r),m(e,lt,r),h(oe,e,r),m(e,dt,r),m(e,c,r),h(ie,c,null),t(c,Ct),t(c,$e),t(c,Mt),t(c,Ce),t(c,Pt),t(c,Me),t(c,kt),t(c,Pe),t(c,Tt),t(c,U),h(se,U,null),t(U,At),t(U,ke),t(U,Lt),h(F,U,null),t(c,Ut),t(c,J),h(ae,J,null),t(J,Vt),t(J,Te),t(c,Nt),t(c,R),h(re,R,null),t(R,St),t(R,Ae),t(c,jt),t(c,B),h(le,B,null),t(B,Ft),t(B,Le),t(c,Jt),t(c,T),h(de,T,null),t(T,Rt),t(T,Ue),t(T,Bt),t(T,Ve),t(T,Wt),t(T,Ne),t(c,Zt),t(c,W),h(pe,W,null),t(W,Et),t(W,Se),t(c,Gt),t(c,Z),h(ce,Z,null),t(Z,Qt),t(Z,je),t(c,zt),t(c,E),h(fe,E,null),t(E,Ot),t(E,Fe),t(c,Ht),t(c,G),h(me,G,null),t(G,Xt),t(G,Je),m(e,pt,r),h(ge,e,r),m(e,ct,r),m(e,y,r),h(ue,y,null),t(y,qt),t(y,Re),t(y,Yt),t(y,Be),t(y,Kt),t(y,We),t(y,en),t(y,Ze),t(y,tn),t(y,V),h(he,V,null),t(V,nn),t(V,Ee),t(V,on),h(Q,V,null),t(y,sn),t(y,z),h(_e,z,null),t(z,an),t(z,Ge),t(y,rn),t(y,A),h(be,A,null),t(A,ln),t(A,Qe),t(A,dn),t(A,ze),t(A,pn),t(A,Oe),t(y,cn),t(y,O),h(ve,O,null),t(O,fn),t(O,He),t(y,mn),t(y,H),h(ye,H,null),t(H,gn),t(H,Xe),m(e,ft,r),h(xe,e,r),m(e,mt,r),m(e,L,r),h(we,L,null),t(L,un),t(L,qe),t(L,hn),t(L,X),h(Ie,X,null),t(X,_n),t(X,Ye),m(e,gt,r),m(e,tt,r),ut=!0},p(e,[r]){const f={};r&2&&(f.$$scope={dirty:r,ctx:e}),j.$set(f);const N={};r&2&&(N.$$scope={dirty:r,ctx:e}),F.$set(N);const De={};r&2&&(De.$$scope={dirty:r,ctx:e}),Q.$set(De)},i(e){ut||(_(M.$$.fragment,e),_(te.$$.fragment,e),_(j.$$.fragment,e),_(oe.$$.fragment,e),_(ie.$$.fragment,e),_(se.$$.fragment,e),_(F.$$.fragment,e),_(ae.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(pe.$$.fragment,e),_(ce.$$.fragment,e),_(fe.$$.fragment,e),_(me.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(he.$$.fragment,e),_(Q.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(ve.$$.fragment,e),_(ye.$$.fragment,e),_(xe.$$.fragment,e),_(we.$$.fragment,e),_(Ie.$$.fragment,e),ut=!0)},o(e){b(M.$$.fragment,e),b(te.$$.fragment,e),b(j.$$.fragment,e),b(oe.$$.fragment,e),b(ie.$$.fragment,e),b(se.$$.fragment,e),b(F.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),b(de.$$.fragment,e),b(pe.$$.fragment,e),b(ce.$$.fragment,e),b(fe.$$.fragment,e),b(me.$$.fragment,e),b(ge.$$.fragment,e),b(ue.$$.fragment,e),b(he.$$.fragment,e),b(Q.$$.fragment,e),b(_e.$$.fragment,e),b(be.$$.fragment,e),b(ve.$$.fragment,e),b(ye.$$.fragment,e),b(xe.$$.fragment,e),b(we.$$.fragment,e),b(Ie.$$.fragment,e),ut=!1},d(e){e&&(a(k),a(w),a(x),a(d),a(P),a(ot),a(K),a(it),a(ee),a(st),a(at),a(ne),a(rt),a(lt),a(dt),a(c),a(pt),a(ct),a(y),a(ft),a(mt),a(L),a(gt),a(tt)),a(p),v(M,e),v(te,e),v(j,e),v(oe,e),v(ie),v(se),v(F),v(ae),v(re),v(le),v(de),v(pe),v(ce),v(fe),v(me),v(ge,e),v(ue),v(he),v(Q),v(_e),v(be),v(ve),v(ye),v(xe,e),v(we),v(Ie)}}}const po='{"title":"AltDiffusion","local":"altdiffusion","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"AltDiffusionPipeline","local":"diffusers.AltDiffusionPipeline","sections":[],"depth":2},{"title":"AltDiffusionImg2ImgPipeline","local":"diffusers.AltDiffusionImg2ImgPipeline","sections":[],"depth":2},{"title":"AltDiffusionPipelineOutput","local":"diffusers.pipelines.alt_diffusion.AltDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function co(S){return eo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vo extends to{constructor(p){super(),no(this,p,co,lo,Kn,{})}}export{vo as component};
