import{s as Po,o as vo,n as Te}from"../chunks/scheduler.182ea377.js";import{S as yo,i as wo,g as s,s as o,r as h,A as Io,h as a,f as d,c as i,j as S,u as _,x as c,k as $,y as t,a as g,v as b,d as x,t as P,w as v}from"../chunks/index.abf12888.js";import{T as Mo}from"../chunks/Tip.230e2334.js";import{D as U}from"../chunks/Docstring.93f6f462.js";import{C as ut}from"../chunks/CodeBlock.57fe6e13.js";import{E as ft}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Cn}from"../chunks/Heading.16916d63.js";function To(k){let r,M='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){r=s("p"),r.innerHTML=M},l(f){r=a(f,"P",{"data-svelte-h":!0}),c(r)!=="svelte-1wmc0l4"&&(r.innerHTML=M)},m(f,l){g(f,r,l)},p:Te,d(f){f&&d(r)}}}function Lo(k){let r,M="Examples:",f,l,u;return l=new ut({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEElMEElMEFkZWYlMjBkb3dubG9hZF9pbWFnZSh1cmwpJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFBJTC5JbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQSUwQWltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UoaW1nX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIydGltYnJvb2tzJTJGaW5zdHJ1Y3QtcGl4MnBpeCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMm1ha2UlMjB0aGUlMjBtb3VudGFpbnMlMjBzbm93eSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
<span class="hljs-meta">... </span>    response = requests.get(url)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionInstructPix2PixPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;make the mountains snowy&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){r=s("p"),r.textContent=M,f=o(),h(l.$$.fragment)},l(n){r=a(n,"P",{"data-svelte-h":!0}),c(r)!=="svelte-kvfsh7"&&(r.textContent=M),f=i(n),_(l.$$.fragment,n)},m(n,y){g(n,r,y),g(n,f,y),b(l,n,y),u=!0},p:Te,i(n){u||(x(l.$$.fragment,n),u=!0)},o(n){P(l.$$.fragment,n),u=!1},d(n){n&&(d(r),d(f)),v(l,n)}}}function So(k){let r,M="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",f,l,u;return l=new ut({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){r=s("p"),r.textContent=M,f=o(),h(l.$$.fragment)},l(n){r=a(n,"P",{"data-svelte-h":!0}),c(r)!=="svelte-1gc783q"&&(r.textContent=M),f=i(n),_(l.$$.fragment,n)},m(n,y){g(n,r,y),g(n,f,y),b(l,n,y),u=!0},p:Te,i(n){u||(x(l.$$.fragment,n),u=!0)},o(n){P(l.$$.fragment,n),u=!1},d(n){n&&(d(r),d(f)),v(l,n)}}}function $o(k){let r,M="locally:",f,l,u;return l=new ut({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){r=s("p"),r.textContent=M,f=o(),h(l.$$.fragment)},l(n){r=a(n,"P",{"data-svelte-h":!0}),c(r)!=="svelte-4c75kq"&&(r.textContent=M),f=i(n),_(l.$$.fragment,n)},m(n,y){g(n,r,y),g(n,f,y),b(l,n,y),u=!0},p:Te,i(n){u||(x(l.$$.fragment,n),u=!0)},o(n){P(l.$$.fragment,n),u=!1},d(n){n&&(d(r),d(f)),v(l,n)}}}function Do(k){let r,M="Example:",f,l,u;return l=new ut({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTBBJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUwQSklMEFwaXBlbGluZS5sb2FkX2xvcmFfd2VpZ2h0cyglMEElMjAlMjAlMjAlMjAlMjJZbnRlYyUyRnBpbmVhcHBsZUFuaW1lTWl4JTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJwaW5lYXBwbGVBbmltZU1peF9waW5lYXBwbGUxMC4xLnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYW5pbWUlMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16).to(
    <span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.load_lora_weights(
    <span class="hljs-string">&quot;Yntec/pineappleAnimeMix&quot;</span>, weight_name=<span class="hljs-string">&quot;pineappleAnimeMix_pineapple10.1.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;anime&quot;</span>
)`,wrap:!1}}),{c(){r=s("p"),r.textContent=M,f=o(),h(l.$$.fragment)},l(n){r=a(n,"P",{"data-svelte-h":!0}),c(r)!=="svelte-11lpom8"&&(r.textContent=M),f=i(n),_(l.$$.fragment,n)},m(n,y){g(n,r,y),g(n,f,y),b(l,n,y),u=!0},p:Te,i(n){u||(x(l.$$.fragment,n),u=!0)},o(n){P(l.$$.fragment,n),u=!1},d(n){n&&(d(r),d(f)),v(l,n)}}}function ko(k){let r,M="Example:",f,l,u;return l=new ut({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFmcm9tJTIwcGVmdC51dGlscyUyMGltcG9ydCUyMGdldF9wZWZ0X21vZGVsX3N0YXRlX2RpY3QlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmxvYWRfbG9yYV93ZWlnaHRzKCUyMm5lcmlqcyUyRnBpeGVsLWFydC14bCUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIycGl4ZWwtYXJ0LXhsLnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIycGl4ZWwlMjIpJTBBcGlwZWxpbmUuZnVzZV9sb3JhKCklMEElMEElMjMlMjBnZXQlMjBhbmQlMjBzYXZlJTIwdW5ldCUyMHN0YXRlJTIwZGljdCUwQXVuZXRfc3RhdGVfZGljdCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsX3N0YXRlX2RpY3QocGlwZWxpbmUudW5ldCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnBpeGVsJTIyKSUwQXBpcGVsaW5lLnNhdmVfbG9yYV93ZWlnaHRzKCUyMmZ1c2VkLW1vZGVsJTIyJTJDJTIwdW5ldF9sb3JhX2xheWVycyUzRHVuZXRfc3RhdGVfZGljdCklMEFwaXBlbGluZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJmdXNlZC1tb2RlbCUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIycHl0b3JjaF9sb3JhX3dlaWdodHMuc2FmZXRlbnNvcnMlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">from</span> peft.utils <span class="hljs-keyword">import</span> get_peft_model_state_dict
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(<span class="hljs-string">&quot;nerijs/pixel-art-xl&quot;</span>, weight_name=<span class="hljs-string">&quot;pixel-art-xl.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;pixel&quot;</span>)
pipeline.fuse_lora()

<span class="hljs-comment"># get and save unet state dict</span>
unet_state_dict = get_peft_model_state_dict(pipeline.unet, adapter_name=<span class="hljs-string">&quot;pixel&quot;</span>)
pipeline.save_lora_weights(<span class="hljs-string">&quot;fused-model&quot;</span>, unet_lora_layers=unet_state_dict)
pipeline.load_lora_weights(<span class="hljs-string">&quot;fused-model&quot;</span>, weight_name=<span class="hljs-string">&quot;pytorch_lora_weights.safetensors&quot;</span>)`,wrap:!1}}),{c(){r=s("p"),r.textContent=M,f=o(),h(l.$$.fragment)},l(n){r=a(n,"P",{"data-svelte-h":!0}),c(r)!=="svelte-11lpom8"&&(r.textContent=M),f=i(n),_(l.$$.fragment,n)},m(n,y){g(n,r,y),g(n,f,y),b(l,n,y),u=!0},p:Te,i(n){u||(x(l.$$.fragment,n),u=!0)},o(n){P(l.$$.fragment,n),u=!1},d(n){n&&(d(r),d(f)),v(l,n)}}}function Co(k){let r,M="Examples:",f,l,u;return l=new ut({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExJbnN0cnVjdFBpeDJQaXhQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcmVzb2x1dGlvbiUyMCUzRCUyMDc2OCUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhmLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQSkucmVzaXplKChyZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbikpJTBBZWRpdF9pbnN0cnVjdGlvbiUyMCUzRCUyMCUyMlR1cm4lMjBza3klMjBpbnRvJTIwYSUyMGNsb3VkeSUyMG9uZSUyMiUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEluc3RydWN0UGl4MlBpeFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMkZzZHhsLWluc3RydWN0cGl4MnBpeC03NjglMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBZWRpdGVkX2ltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0RlZGl0X2luc3RydWN0aW9uJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRHJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRHJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDMuMCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2d1aWRhbmNlX3NjYWxlJTNEMS41JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBZWRpdGVkX2ltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLInstructPix2PixPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>resolution = <span class="hljs-number">768</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>
<span class="hljs-meta">... </span>).resize((resolution, resolution))
<span class="hljs-meta">&gt;&gt;&gt; </span>edit_instruction = <span class="hljs-string">&quot;Turn sky into a cloudy one&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLInstructPix2PixPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;diffusers/sdxl-instructpix2pix-768&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image = pipe(
<span class="hljs-meta">... </span>    prompt=edit_instruction,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    height=resolution,
<span class="hljs-meta">... </span>    width=resolution,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">3.0</span>,
<span class="hljs-meta">... </span>    image_guidance_scale=<span class="hljs-number">1.5</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image`,wrap:!1}}),{c(){r=s("p"),r.textContent=M,f=o(),h(l.$$.fragment)},l(n){r=a(n,"P",{"data-svelte-h":!0}),c(r)!=="svelte-kvfsh7"&&(r.textContent=M),f=i(n),_(l.$$.fragment,n)},m(n,y){g(n,r,y),g(n,f,y),b(l,n,y),u=!0},p:Te,i(n){u||(x(l.$$.fragment,n),u=!0)},o(n){P(l.$$.fragment,n),u=!1},d(n){n&&(d(r),d(f)),v(l,n)}}}function Uo(k){let r,M,f,l,u,n,y,Un='<a href="https://huggingface.co/papers/2211.09800" rel="nofollow">InstructPix2Pix: Learning to Follow Image Editing Instructions</a> is by Tim Brooks, Aleksander Holynski and Alexei A. Efros.',gt,ie,Jn="The abstract from the paper is:",ht,se,jn="<em>We propose a method for editing images from human instructions: given an input image and a written instruction that tells the model what to do, our model follows these instructions to edit the image. To obtain training data for this problem, we combine the knowledge of two large pretrained models — a language model (GPT-3) and a text-to-image model (Stable Diffusion) — to generate a large dataset of image editing examples. Our conditional diffusion model, InstructPix2Pix, is trained on our generated data, and generalizes to real images and user-written instructions at inference time. Since it performs edits in the forward pass and does not require per example fine-tuning or inversion, our model edits images quickly, in a matter of seconds. We show compelling editing results for a diverse collection of input images and written instructions.</em>",_t,ae,Xn='You can find additional information about InstructPix2Pix on the <a href="https://www.timothybrooks.com/instruct-pix2pix" rel="nofollow">project page</a>, <a href="https://github.com/timothybrooks/instruct-pix2pix" rel="nofollow">original codebase</a>, and try it out in a <a href="https://huggingface.co/spaces/timbrooks/instruct-pix2pix" rel="nofollow">demo</a>.',bt,E,xt,re,Pt,I,le,$t,Le,Zn="Pipeline for pixel-level image editing by following text instructions (based on Stable Diffusion).",Dt,Se,Wn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,kt,$e,Nn="The pipeline also inherits the following loading methods:",Ct,De,Gn='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',Ut,W,de,Jt,ke,zn="The call function to the pipeline for generation.",jt,V,Xt,C,ce,Zt,Ce,Bn=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Wt,Ue,Fn="Example:",Nt,q,Gt,Je,Rn=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,zt,H,Bt,L,pe,Ft,je,En=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,Rt,Xe,Vn="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Et,Ze,qn='See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',Vt,We,Hn=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,qt,Ne,Yn=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,Ht,Y,Yt,N,fe,At,Ge,An="Save the UNet and text encoder LoRA parameters.",Qt,A,Ot,Q,ue,Kt,ze,Qn="Disables the FreeU mechanism if enabled.",en,j,me,tn,Be,On='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',nn,Fe,Kn="The suffixes after the scaling factors represent the stages where they are being applied.",on,Re,eo=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,vt,ge,yt,m,he,sn,Ee,to="Pipeline for pixel-level image editing by following text instructions. Based on Stable Diffusion XL.",an,Ve,no=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,rn,qe,oo="In addition the pipeline inherits the following loading methods:",ln,He,io='<li><em>LoRA</em>: <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights()</a></li>',dn,Ye,so="as well as the following saving methods:",cn,Ae,ao='<li><em>LoRA</em>: <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights">loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights()</a></li>',pn,G,_e,fn,Qe,ro="Function invoked when calling the pipeline for generation.",un,O,mn,K,be,gn,Oe,lo="Disables the FreeU mechanism if enabled.",hn,ee,xe,_n,Ke,co=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously invoked, this method will go back to
computing decoding in one step.`,bn,te,Pe,xn,et,po=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously invoked, this method will go back to
computing decoding in one step.`,Pn,X,ve,vn,tt,fo='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',yn,nt,uo="The suffixes after the scaling factors represent the stages where they are being applied.",wn,ot,mo=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,In,z,ye,Mn,it,go="Enable sliced VAE decoding.",Tn,st,ho=`When this option is enabled, the VAE will split the input tensor in slices to compute decoding in several
steps. This is useful to save some memory and allow larger batch sizes.`,Ln,B,we,Sn,at,_o="Enable tiled VAE decoding.",$n,rt,bo=`When this option is enabled, the VAE will split the input tensor into tiles to compute decoding and encoding in
several steps. This is useful to save a large amount of memory and to allow the processing of larger images.`,Dn,ne,Ie,kn,lt,xo="Encodes the prompt into text encoder hidden states.",wt,mt,It;return u=new Cn({props:{title:"InstructPix2Pix",local:"instructpix2pix",headingTag:"h1"}}),E=new Mo({props:{$$slots:{default:[To]},$$scope:{ctx:k}}}),re=new Cn({props:{title:"StableDiffusionInstructPix2PixPipeline",local:"diffusers.StableDiffusionInstructPix2PixPipeline",headingTag:"h2"}}),le=new U({props:{name:"class diffusers.StableDiffusionInstructPix2PixPipeline",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L61"}}),de=new U({props:{name:"__call__",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 7.5"},{name:"image_guidance_scale",val:": float = 1.5"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> <code>np.ndarray</code>, <code>PIL.Image.Image</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be repainted according to <code>prompt</code>. Can also accept
image latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.image_guidance_scale",description:`<strong>image_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.5) &#x2014;
Push the generated image towards the inital <code>image</code>. Image guidance scale is enabled by setting
<code>image_guidance_scale &gt; 1</code>. Higher image guidance scale encourages generated images that are closely
linked to the source <code>image</code>, usually at the expense of lower image quality. This pipeline requires a
value of at least <code>1</code>.`,name:"image_guidance_scale"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L140",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),V=new ft({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.example",$$slots:{default:[Lo]},$$scope:{ctx:k}}}),ce=new U({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, typing.List[str], typing.Dict[str, torch.Tensor], typing.List[typing.Dict[str, torch.Tensor]]]"},{name:"token",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[ForwardRef('PreTrainedTokenizer')] = None"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L270"}}),q=new ft({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.example",$$slots:{default:[So]},$$scope:{ctx:k}}}),H=new ft({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.example-2",$$slots:{default:[$o]},$$scope:{ctx:k}}}),pe=new U({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
A string (model id of a pretrained model hosted on the Hub), a path to a directory containing the model
weights, or a <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name for referencing the loaded adapter model. If not specified, it will use <code>default_{i}</code> where <code>i</code> is
the total number of adapters being loaded. Must have PEFT installed to use.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L78"}}),Y=new ft({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.example",$$slots:{default:[Do]},$$scope:{ctx:k}}}),fe=new U({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"unet_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_lora_layers",val:": typing.Dict[str, torch.nn.modules.module.Module] = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to (will be created if it doesn&#x2019;t exist).`,name:"save_directory"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dict. Useful during distributed training when you need to replace
<code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L883"}}),A=new ft({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.example",$$slots:{default:[ko]},$$scope:{ctx:k}}}),ue=new U({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L779"}}),me=new U({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L756"}}),ge=new Cn({props:{title:"StableDiffusionXLInstructPix2PixPipeline",local:"diffusers.StableDiffusionXLInstructPix2PixPipeline",headingTag:"h2"}}),he=new U({props:{name:"class diffusers.StableDiffusionXLInstructPix2PixPipeline",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion XL uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code> CLIPTextModelWithProjection</code>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.requires_aesthetics_score",description:`<strong>requires_aesthetics_score</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;False&quot;</code>) &#x2014;
Whether the <code>unet</code> requires a aesthetic_score condition to be passed during inference. Also see the config
of <code>stabilityai/stable-diffusion-xl-refiner-1-0</code>.`,name:"requires_aesthetics_score"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark library</a> to
watermark output images. If not defined, it will default to True if the package is installed, otherwise no
watermarker will be used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L105"}}),_e=new U({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 100"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"image_guidance_scale",val:": float = 1.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Tuple[int, int] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Tuple[int, int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> or <code>PIL.Image.Image</code> or <code>np.ndarray</code> or <code>List[torch.FloatTensor]</code> or <code>List[PIL.Image.Image]</code> or <code>List[np.ndarray]</code>) &#x2014;
The image(s) to modify with the pipeline.`,name:"image"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.image_guidance_scale",description:`<strong>image_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.5) &#x2014;
Image guidance scale is to push the generated image towards the inital image <code>image</code>. Image guidance
scale is enabled by setting <code>image_guidance_scale &gt; 1</code>. Higher image guidance scale encourages to
generate images that are closely linked to the source image <code>image</code>, usually at the expense of lower
image quality. This pipeline requires a value of at least <code>1</code>.`,name:"image_guidance_scale"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L646",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),O=new ft({props:{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.example",$$slots:{default:[Co]},$$scope:{ctx:k}}}),be=new U({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L642"}}),xe=new U({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L202"}}),Pe=new U({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L218"}}),ve=new U({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L619"}}),ye=new U({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L193"}}),we=new U({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L209"}}),Ie=new U({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": typing.Optional[str] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt_2",val:": typing.Optional[str] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L225"}}),{c(){r=s("meta"),M=o(),f=s("p"),l=o(),h(u.$$.fragment),n=o(),y=s("p"),y.innerHTML=Un,gt=o(),ie=s("p"),ie.textContent=Jn,ht=o(),se=s("p"),se.innerHTML=jn,_t=o(),ae=s("p"),ae.innerHTML=Xn,bt=o(),h(E.$$.fragment),xt=o(),h(re.$$.fragment),Pt=o(),I=s("div"),h(le.$$.fragment),$t=o(),Le=s("p"),Le.textContent=Zn,Dt=o(),Se=s("p"),Se.innerHTML=Wn,kt=o(),$e=s("p"),$e.textContent=Nn,Ct=o(),De=s("ul"),De.innerHTML=Gn,Ut=o(),W=s("div"),h(de.$$.fragment),Jt=o(),ke=s("p"),ke.textContent=zn,jt=o(),h(V.$$.fragment),Xt=o(),C=s("div"),h(ce.$$.fragment),Zt=o(),Ce=s("p"),Ce.innerHTML=Bn,Wt=o(),Ue=s("p"),Ue.textContent=Fn,Nt=o(),h(q.$$.fragment),Gt=o(),Je=s("p"),Je.innerHTML=Rn,zt=o(),h(H.$$.fragment),Bt=o(),L=s("div"),h(pe.$$.fragment),Ft=o(),je=s("p"),je.innerHTML=En,Rt=o(),Xe=s("p"),Xe.innerHTML=Vn,Et=o(),Ze=s("p"),Ze.innerHTML=qn,Vt=o(),We=s("p"),We.innerHTML=Hn,qt=o(),Ne=s("p"),Ne.innerHTML=Yn,Ht=o(),h(Y.$$.fragment),Yt=o(),N=s("div"),h(fe.$$.fragment),At=o(),Ge=s("p"),Ge.textContent=An,Qt=o(),h(A.$$.fragment),Ot=o(),Q=s("div"),h(ue.$$.fragment),Kt=o(),ze=s("p"),ze.textContent=Qn,en=o(),j=s("div"),h(me.$$.fragment),tn=o(),Be=s("p"),Be.innerHTML=On,nn=o(),Fe=s("p"),Fe.textContent=Kn,on=o(),Re=s("p"),Re.innerHTML=eo,vt=o(),h(ge.$$.fragment),yt=o(),m=s("div"),h(he.$$.fragment),sn=o(),Ee=s("p"),Ee.textContent=to,an=o(),Ve=s("p"),Ve.innerHTML=no,rn=o(),qe=s("p"),qe.textContent=oo,ln=o(),He=s("ul"),He.innerHTML=io,dn=o(),Ye=s("p"),Ye.textContent=so,cn=o(),Ae=s("ul"),Ae.innerHTML=ao,pn=o(),G=s("div"),h(_e.$$.fragment),fn=o(),Qe=s("p"),Qe.textContent=ro,un=o(),h(O.$$.fragment),mn=o(),K=s("div"),h(be.$$.fragment),gn=o(),Oe=s("p"),Oe.textContent=lo,hn=o(),ee=s("div"),h(xe.$$.fragment),_n=o(),Ke=s("p"),Ke.innerHTML=co,bn=o(),te=s("div"),h(Pe.$$.fragment),xn=o(),et=s("p"),et.innerHTML=po,Pn=o(),X=s("div"),h(ve.$$.fragment),vn=o(),tt=s("p"),tt.innerHTML=fo,yn=o(),nt=s("p"),nt.textContent=uo,wn=o(),ot=s("p"),ot.innerHTML=mo,In=o(),z=s("div"),h(ye.$$.fragment),Mn=o(),it=s("p"),it.textContent=go,Tn=o(),st=s("p"),st.textContent=ho,Ln=o(),B=s("div"),h(we.$$.fragment),Sn=o(),at=s("p"),at.textContent=_o,$n=o(),rt=s("p"),rt.textContent=bo,Dn=o(),ne=s("div"),h(Ie.$$.fragment),kn=o(),lt=s("p"),lt.textContent=xo,wt=o(),mt=s("p"),this.h()},l(e){const p=Io("svelte-u9bgzb",document.head);r=a(p,"META",{name:!0,content:!0}),p.forEach(d),M=i(e),f=a(e,"P",{}),S(f).forEach(d),l=i(e),_(u.$$.fragment,e),n=i(e),y=a(e,"P",{"data-svelte-h":!0}),c(y)!=="svelte-1tl4gnd"&&(y.innerHTML=Un),gt=i(e),ie=a(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-1cwsb16"&&(ie.textContent=Jn),ht=i(e),se=a(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-1gbgk0u"&&(se.innerHTML=jn),_t=i(e),ae=a(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-18wh1q7"&&(ae.innerHTML=Xn),bt=i(e),_(E.$$.fragment,e),xt=i(e),_(re.$$.fragment,e),Pt=i(e),I=a(e,"DIV",{class:!0});var T=S(I);_(le.$$.fragment,T),$t=i(T),Le=a(T,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-1gz00nq"&&(Le.textContent=Zn),Dt=i(T),Se=a(T,"P",{"data-svelte-h":!0}),c(Se)!=="svelte-496sm0"&&(Se.innerHTML=Wn),kt=i(T),$e=a(T,"P",{"data-svelte-h":!0}),c($e)!=="svelte-14s6m4u"&&($e.textContent=Nn),Ct=i(T),De=a(T,"UL",{"data-svelte-h":!0}),c(De)!=="svelte-ks5x56"&&(De.innerHTML=Gn),Ut=i(T),W=a(T,"DIV",{class:!0});var F=S(W);_(de.$$.fragment,F),Jt=i(F),ke=a(F,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-50j04k"&&(ke.textContent=zn),jt=i(F),_(V.$$.fragment,F),F.forEach(d),Xt=i(T),C=a(T,"DIV",{class:!0});var J=S(C);_(ce.$$.fragment,J),Zt=i(J),Ce=a(J,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-1lv88wo"&&(Ce.innerHTML=Bn),Wt=i(J),Ue=a(J,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-11lpom8"&&(Ue.textContent=Fn),Nt=i(J),_(q.$$.fragment,J),Gt=i(J),Je=a(J,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-15d7mv5"&&(Je.innerHTML=Rn),zt=i(J),_(H.$$.fragment,J),J.forEach(d),Bt=i(T),L=a(T,"DIV",{class:!0});var D=S(L);_(pe.$$.fragment,D),Ft=i(D),je=a(D,"P",{"data-svelte-h":!0}),c(je)!=="svelte-vs7s0z"&&(je.innerHTML=En),Rt=i(D),Xe=a(D,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-15b960v"&&(Xe.innerHTML=Vn),Et=i(D),Ze=a(D,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-12uyc98"&&(Ze.innerHTML=qn),Vt=i(D),We=a(D,"P",{"data-svelte-h":!0}),c(We)!=="svelte-1q3yzk7"&&(We.innerHTML=Hn),qt=i(D),Ne=a(D,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-10xxjud"&&(Ne.innerHTML=Yn),Ht=i(D),_(Y.$$.fragment,D),D.forEach(d),Yt=i(T),N=a(T,"DIV",{class:!0});var R=S(N);_(fe.$$.fragment,R),At=i(R),Ge=a(R,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-1ac6d9e"&&(Ge.textContent=An),Qt=i(R),_(A.$$.fragment,R),R.forEach(d),Ot=i(T),Q=a(T,"DIV",{class:!0});var Me=S(Q);_(ue.$$.fragment,Me),Kt=i(Me),ze=a(Me,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-psupw6"&&(ze.textContent=Qn),Me.forEach(d),en=i(T),j=a(T,"DIV",{class:!0});var Z=S(j);_(me.$$.fragment,Z),tn=i(Z),Be=a(Z,"P",{"data-svelte-h":!0}),c(Be)!=="svelte-1f3tmq1"&&(Be.innerHTML=On),nn=i(Z),Fe=a(Z,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-xjijlp"&&(Fe.textContent=Kn),on=i(Z),Re=a(Z,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-hy0nzs"&&(Re.innerHTML=eo),Z.forEach(d),T.forEach(d),vt=i(e),_(ge.$$.fragment,e),yt=i(e),m=a(e,"DIV",{class:!0});var w=S(m);_(he.$$.fragment,w),sn=i(w),Ee=a(w,"P",{"data-svelte-h":!0}),c(Ee)!=="svelte-1n3req3"&&(Ee.textContent=to),an=i(w),Ve=a(w,"P",{"data-svelte-h":!0}),c(Ve)!=="svelte-wu1jmh"&&(Ve.innerHTML=no),rn=i(w),qe=a(w,"P",{"data-svelte-h":!0}),c(qe)!=="svelte-984r3o"&&(qe.textContent=oo),ln=i(w),He=a(w,"UL",{"data-svelte-h":!0}),c(He)!=="svelte-11w1spj"&&(He.innerHTML=io),dn=i(w),Ye=a(w,"P",{"data-svelte-h":!0}),c(Ye)!=="svelte-19qtqre"&&(Ye.textContent=so),cn=i(w),Ae=a(w,"UL",{"data-svelte-h":!0}),c(Ae)!=="svelte-1x26159"&&(Ae.innerHTML=ao),pn=i(w),G=a(w,"DIV",{class:!0});var dt=S(G);_(_e.$$.fragment,dt),fn=i(dt),Qe=a(dt,"P",{"data-svelte-h":!0}),c(Qe)!=="svelte-v78lg8"&&(Qe.textContent=ro),un=i(dt),_(O.$$.fragment,dt),dt.forEach(d),mn=i(w),K=a(w,"DIV",{class:!0});var Mt=S(K);_(be.$$.fragment,Mt),gn=i(Mt),Oe=a(Mt,"P",{"data-svelte-h":!0}),c(Oe)!=="svelte-psupw6"&&(Oe.textContent=lo),Mt.forEach(d),hn=i(w),ee=a(w,"DIV",{class:!0});var Tt=S(ee);_(xe.$$.fragment,Tt),_n=i(Tt),Ke=a(Tt,"P",{"data-svelte-h":!0}),c(Ke)!=="svelte-1lk12qh"&&(Ke.innerHTML=co),Tt.forEach(d),bn=i(w),te=a(w,"DIV",{class:!0});var Lt=S(te);_(Pe.$$.fragment,Lt),xn=i(Lt),et=a(Lt,"P",{"data-svelte-h":!0}),c(et)!=="svelte-elsxjh"&&(et.innerHTML=po),Lt.forEach(d),Pn=i(w),X=a(w,"DIV",{class:!0});var oe=S(X);_(ve.$$.fragment,oe),vn=i(oe),tt=a(oe,"P",{"data-svelte-h":!0}),c(tt)!=="svelte-1f3tmq1"&&(tt.innerHTML=fo),yn=i(oe),nt=a(oe,"P",{"data-svelte-h":!0}),c(nt)!=="svelte-xjijlp"&&(nt.textContent=uo),wn=i(oe),ot=a(oe,"P",{"data-svelte-h":!0}),c(ot)!=="svelte-hy0nzs"&&(ot.innerHTML=mo),oe.forEach(d),In=i(w),z=a(w,"DIV",{class:!0});var ct=S(z);_(ye.$$.fragment,ct),Mn=i(ct),it=a(ct,"P",{"data-svelte-h":!0}),c(it)!=="svelte-ssd5ny"&&(it.textContent=go),Tn=i(ct),st=a(ct,"P",{"data-svelte-h":!0}),c(st)!=="svelte-62zig4"&&(st.textContent=ho),ct.forEach(d),Ln=i(w),B=a(w,"DIV",{class:!0});var pt=S(B);_(we.$$.fragment,pt),Sn=i(pt),at=a(pt,"P",{"data-svelte-h":!0}),c(at)!=="svelte-4j2l7q"&&(at.textContent=_o),$n=i(pt),rt=a(pt,"P",{"data-svelte-h":!0}),c(rt)!=="svelte-1biw85q"&&(rt.textContent=bo),pt.forEach(d),Dn=i(w),ne=a(w,"DIV",{class:!0});var St=S(ne);_(Ie.$$.fragment,St),kn=i(St),lt=a(St,"P",{"data-svelte-h":!0}),c(lt)!=="svelte-16q0ax1"&&(lt.textContent=xo),St.forEach(d),w.forEach(d),wt=i(e),mt=a(e,"P",{}),S(mt).forEach(d),this.h()},h(){$(r,"name","hf:doc:metadata"),$(r,"content",Jo),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){t(document.head,r),g(e,M,p),g(e,f,p),g(e,l,p),b(u,e,p),g(e,n,p),g(e,y,p),g(e,gt,p),g(e,ie,p),g(e,ht,p),g(e,se,p),g(e,_t,p),g(e,ae,p),g(e,bt,p),b(E,e,p),g(e,xt,p),b(re,e,p),g(e,Pt,p),g(e,I,p),b(le,I,null),t(I,$t),t(I,Le),t(I,Dt),t(I,Se),t(I,kt),t(I,$e),t(I,Ct),t(I,De),t(I,Ut),t(I,W),b(de,W,null),t(W,Jt),t(W,ke),t(W,jt),b(V,W,null),t(I,Xt),t(I,C),b(ce,C,null),t(C,Zt),t(C,Ce),t(C,Wt),t(C,Ue),t(C,Nt),b(q,C,null),t(C,Gt),t(C,Je),t(C,zt),b(H,C,null),t(I,Bt),t(I,L),b(pe,L,null),t(L,Ft),t(L,je),t(L,Rt),t(L,Xe),t(L,Et),t(L,Ze),t(L,Vt),t(L,We),t(L,qt),t(L,Ne),t(L,Ht),b(Y,L,null),t(I,Yt),t(I,N),b(fe,N,null),t(N,At),t(N,Ge),t(N,Qt),b(A,N,null),t(I,Ot),t(I,Q),b(ue,Q,null),t(Q,Kt),t(Q,ze),t(I,en),t(I,j),b(me,j,null),t(j,tn),t(j,Be),t(j,nn),t(j,Fe),t(j,on),t(j,Re),g(e,vt,p),b(ge,e,p),g(e,yt,p),g(e,m,p),b(he,m,null),t(m,sn),t(m,Ee),t(m,an),t(m,Ve),t(m,rn),t(m,qe),t(m,ln),t(m,He),t(m,dn),t(m,Ye),t(m,cn),t(m,Ae),t(m,pn),t(m,G),b(_e,G,null),t(G,fn),t(G,Qe),t(G,un),b(O,G,null),t(m,mn),t(m,K),b(be,K,null),t(K,gn),t(K,Oe),t(m,hn),t(m,ee),b(xe,ee,null),t(ee,_n),t(ee,Ke),t(m,bn),t(m,te),b(Pe,te,null),t(te,xn),t(te,et),t(m,Pn),t(m,X),b(ve,X,null),t(X,vn),t(X,tt),t(X,yn),t(X,nt),t(X,wn),t(X,ot),t(m,In),t(m,z),b(ye,z,null),t(z,Mn),t(z,it),t(z,Tn),t(z,st),t(m,Ln),t(m,B),b(we,B,null),t(B,Sn),t(B,at),t(B,$n),t(B,rt),t(m,Dn),t(m,ne),b(Ie,ne,null),t(ne,kn),t(ne,lt),g(e,wt,p),g(e,mt,p),It=!0},p(e,[p]){const T={};p&2&&(T.$$scope={dirty:p,ctx:e}),E.$set(T);const F={};p&2&&(F.$$scope={dirty:p,ctx:e}),V.$set(F);const J={};p&2&&(J.$$scope={dirty:p,ctx:e}),q.$set(J);const D={};p&2&&(D.$$scope={dirty:p,ctx:e}),H.$set(D);const R={};p&2&&(R.$$scope={dirty:p,ctx:e}),Y.$set(R);const Me={};p&2&&(Me.$$scope={dirty:p,ctx:e}),A.$set(Me);const Z={};p&2&&(Z.$$scope={dirty:p,ctx:e}),O.$set(Z)},i(e){It||(x(u.$$.fragment,e),x(E.$$.fragment,e),x(re.$$.fragment,e),x(le.$$.fragment,e),x(de.$$.fragment,e),x(V.$$.fragment,e),x(ce.$$.fragment,e),x(q.$$.fragment,e),x(H.$$.fragment,e),x(pe.$$.fragment,e),x(Y.$$.fragment,e),x(fe.$$.fragment,e),x(A.$$.fragment,e),x(ue.$$.fragment,e),x(me.$$.fragment,e),x(ge.$$.fragment,e),x(he.$$.fragment,e),x(_e.$$.fragment,e),x(O.$$.fragment,e),x(be.$$.fragment,e),x(xe.$$.fragment,e),x(Pe.$$.fragment,e),x(ve.$$.fragment,e),x(ye.$$.fragment,e),x(we.$$.fragment,e),x(Ie.$$.fragment,e),It=!0)},o(e){P(u.$$.fragment,e),P(E.$$.fragment,e),P(re.$$.fragment,e),P(le.$$.fragment,e),P(de.$$.fragment,e),P(V.$$.fragment,e),P(ce.$$.fragment,e),P(q.$$.fragment,e),P(H.$$.fragment,e),P(pe.$$.fragment,e),P(Y.$$.fragment,e),P(fe.$$.fragment,e),P(A.$$.fragment,e),P(ue.$$.fragment,e),P(me.$$.fragment,e),P(ge.$$.fragment,e),P(he.$$.fragment,e),P(_e.$$.fragment,e),P(O.$$.fragment,e),P(be.$$.fragment,e),P(xe.$$.fragment,e),P(Pe.$$.fragment,e),P(ve.$$.fragment,e),P(ye.$$.fragment,e),P(we.$$.fragment,e),P(Ie.$$.fragment,e),It=!1},d(e){e&&(d(M),d(f),d(l),d(n),d(y),d(gt),d(ie),d(ht),d(se),d(_t),d(ae),d(bt),d(xt),d(Pt),d(I),d(vt),d(yt),d(m),d(wt),d(mt)),d(r),v(u,e),v(E,e),v(re,e),v(le),v(de),v(V),v(ce),v(q),v(H),v(pe),v(Y),v(fe),v(A),v(ue),v(me),v(ge,e),v(he),v(_e),v(O),v(be),v(xe),v(Pe),v(ve),v(ye),v(we),v(Ie)}}}const Jo='{"title":"InstructPix2Pix","local":"instructpix2pix","sections":[{"title":"StableDiffusionInstructPix2PixPipeline","local":"diffusers.StableDiffusionInstructPix2PixPipeline","sections":[],"depth":2},{"title":"StableDiffusionXLInstructPix2PixPipeline","local":"diffusers.StableDiffusionXLInstructPix2PixPipeline","sections":[],"depth":2}],"depth":1}';function jo(k){return vo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fo extends yo{constructor(r){super(),wo(this,r,jo,Uo,Po,{})}}export{Fo as component};
