import{s as nn,o as on,n as N}from"../chunks/scheduler.182ea377.js";import{S as sn,i as an,g as p,s as i,r as y,A as rn,h as d,f as l,c as r,j as Z,u as w,x as _,k,y as s,a as h,v,d as x,t as M,w as $}from"../chunks/index.abf12888.js";import{T as jt}from"../chunks/Tip.230e2334.js";import{D as W}from"../chunks/Docstring.93f6f462.js";import{C as ye}from"../chunks/CodeBlock.57fe6e13.js";import{E as be}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Pt}from"../chunks/Heading.16916d63.js";function ln(T){let n,u='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',a,o,c='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){n=p("p"),n.innerHTML=u,a=i(),o=p("p"),o.innerHTML=c},l(e){n=d(e,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1j961ct"&&(n.innerHTML=u),a=r(e),o=d(e,"P",{"data-svelte-h":!0}),_(o)!=="svelte-z4pn9c"&&(o.innerHTML=c)},m(e,f){h(e,n,f),h(e,a,f),h(e,o,f)},p:N,d(e){e&&(l(n),l(a),l(o))}}}function pn(T){let n,u="Examples:",a,o,c;return o=new ye({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25EZXB0aDJJbWdQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25EZXB0aDJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItZGVwdGglMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQXByb21wdCUyMCUzRCUyMCUyMnR3byUyMHRpZ2VycyUyMiUwQW5fcHJvcG10JTIwJTNEJTIwJTIyYmFkJTJDJTIwZGVmb3JtZWQlMkMlMjB1Z2x5JTJDJTIwYmFkJTIwYW5vdG9teSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuX3Byb3BtdCUyQyUyMHN0cmVuZ3RoJTNEMC43KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionDepth2ImgPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionDepth2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-depth&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;two tigers&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>n_propmt = <span class="hljs-string">&quot;bad, deformed, ugly, bad anotomy&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=init_image, negative_prompt=n_propmt, strength=<span class="hljs-number">0.7</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=p("p"),n.textContent=u,a=i(),y(o.$$.fragment)},l(e){n=d(e,"P",{"data-svelte-h":!0}),_(n)!=="svelte-kvfsh7"&&(n.textContent=u),a=r(e),w(o.$$.fragment,e)},m(e,f){h(e,n,f),h(e,a,f),v(o,e,f),c=!0},p:N,i(e){c||(x(o.$$.fragment,e),c=!0)},o(e){M(o.$$.fragment,e),c=!1},d(e){e&&(l(n),l(a)),$(o,e)}}}function dn(T){let n,u=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=p("p"),n.innerHTML=u},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-ackzsn"&&(n.innerHTML=u)},m(a,o){h(a,n,o)},p:N,d(a){a&&l(n)}}}function cn(T){let n,u="Examples:",a,o,c;return o=new ye({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=p("p"),n.textContent=u,a=i(),y(o.$$.fragment)},l(e){n=d(e,"P",{"data-svelte-h":!0}),_(n)!=="svelte-kvfsh7"&&(n.textContent=u),a=r(e),w(o.$$.fragment,e)},m(e,f){h(e,n,f),h(e,a,f),v(o,e,f),c=!0},p:N,i(e){c||(x(o.$$.fragment,e),c=!0)},o(e){M(o.$$.fragment,e),c=!1},d(e){e&&(l(n),l(a)),$(o,e)}}}function mn(T){let n,u=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=p("p"),n.textContent=u},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-17p1lpg"&&(n.textContent=u)},m(a,o){h(a,n,o)},p:N,d(a){a&&l(n)}}}function fn(T){let n,u="Examples:",a,o,c;return o=new ye({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=p("p"),n.textContent=u,a=i(),y(o.$$.fragment)},l(e){n=d(e,"P",{"data-svelte-h":!0}),_(n)!=="svelte-kvfsh7"&&(n.textContent=u),a=r(e),w(o.$$.fragment,e)},m(e,f){h(e,n,f),h(e,a,f),v(o,e,f),c=!0},p:N,i(e){c||(x(o.$$.fragment,e),c=!0)},o(e){M(o.$$.fragment,e),c=!1},d(e){e&&(l(n),l(a)),$(o,e)}}}function un(T){let n,u="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",a,o,c;return o=new ye({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){n=p("p"),n.textContent=u,a=i(),y(o.$$.fragment)},l(e){n=d(e,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1gc783q"&&(n.textContent=u),a=r(e),w(o.$$.fragment,e)},m(e,f){h(e,n,f),h(e,a,f),v(o,e,f),c=!0},p:N,i(e){c||(x(o.$$.fragment,e),c=!0)},o(e){M(o.$$.fragment,e),c=!1},d(e){e&&(l(n),l(a)),$(o,e)}}}function gn(T){let n,u="locally:",a,o,c;return o=new ye({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){n=p("p"),n.textContent=u,a=i(),y(o.$$.fragment)},l(e){n=d(e,"P",{"data-svelte-h":!0}),_(n)!=="svelte-4c75kq"&&(n.textContent=u),a=r(e),w(o.$$.fragment,e)},m(e,f){h(e,n,f),h(e,a,f),v(o,e,f),c=!0},p:N,i(e){c||(x(o.$$.fragment,e),c=!0)},o(e){M(o.$$.fragment,e),c=!1},d(e){e&&(l(n),l(a)),$(o,e)}}}function hn(T){let n,u="Example:",a,o,c;return o=new ye({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTBBJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUwQSklMEFwaXBlbGluZS5sb2FkX2xvcmFfd2VpZ2h0cyglMEElMjAlMjAlMjAlMjAlMjJZbnRlYyUyRnBpbmVhcHBsZUFuaW1lTWl4JTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJwaW5lYXBwbGVBbmltZU1peF9waW5lYXBwbGUxMC4xLnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYW5pbWUlMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16).to(
    <span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.load_lora_weights(
    <span class="hljs-string">&quot;Yntec/pineappleAnimeMix&quot;</span>, weight_name=<span class="hljs-string">&quot;pineappleAnimeMix_pineapple10.1.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;anime&quot;</span>
)`,wrap:!1}}),{c(){n=p("p"),n.textContent=u,a=i(),y(o.$$.fragment)},l(e){n=d(e,"P",{"data-svelte-h":!0}),_(n)!=="svelte-11lpom8"&&(n.textContent=u),a=r(e),w(o.$$.fragment,e)},m(e,f){h(e,n,f),h(e,a,f),v(o,e,f),c=!0},p:N,i(e){c||(x(o.$$.fragment,e),c=!0)},o(e){M(o.$$.fragment,e),c=!1},d(e){e&&(l(n),l(a)),$(o,e)}}}function _n(T){let n,u="Example:",a,o,c;return o=new ye({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFmcm9tJTIwcGVmdC51dGlscyUyMGltcG9ydCUyMGdldF9wZWZ0X21vZGVsX3N0YXRlX2RpY3QlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmxvYWRfbG9yYV93ZWlnaHRzKCUyMm5lcmlqcyUyRnBpeGVsLWFydC14bCUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIycGl4ZWwtYXJ0LXhsLnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIycGl4ZWwlMjIpJTBBcGlwZWxpbmUuZnVzZV9sb3JhKCklMEElMEElMjMlMjBnZXQlMjBhbmQlMjBzYXZlJTIwdW5ldCUyMHN0YXRlJTIwZGljdCUwQXVuZXRfc3RhdGVfZGljdCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsX3N0YXRlX2RpY3QocGlwZWxpbmUudW5ldCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnBpeGVsJTIyKSUwQXBpcGVsaW5lLnNhdmVfbG9yYV93ZWlnaHRzKCUyMmZ1c2VkLW1vZGVsJTIyJTJDJTIwdW5ldF9sb3JhX2xheWVycyUzRHVuZXRfc3RhdGVfZGljdCklMEFwaXBlbGluZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJmdXNlZC1tb2RlbCUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIycHl0b3JjaF9sb3JhX3dlaWdodHMuc2FmZXRlbnNvcnMlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">from</span> peft.utils <span class="hljs-keyword">import</span> get_peft_model_state_dict
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(<span class="hljs-string">&quot;nerijs/pixel-art-xl&quot;</span>, weight_name=<span class="hljs-string">&quot;pixel-art-xl.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;pixel&quot;</span>)
pipeline.fuse_lora()

<span class="hljs-comment"># get and save unet state dict</span>
unet_state_dict = get_peft_model_state_dict(pipeline.unet, adapter_name=<span class="hljs-string">&quot;pixel&quot;</span>)
pipeline.save_lora_weights(<span class="hljs-string">&quot;fused-model&quot;</span>, unet_lora_layers=unet_state_dict)
pipeline.load_lora_weights(<span class="hljs-string">&quot;fused-model&quot;</span>, weight_name=<span class="hljs-string">&quot;pytorch_lora_weights.safetensors&quot;</span>)`,wrap:!1}}),{c(){n=p("p"),n.textContent=u,a=i(),y(o.$$.fragment)},l(e){n=d(e,"P",{"data-svelte-h":!0}),_(n)!=="svelte-11lpom8"&&(n.textContent=u),a=r(e),w(o.$$.fragment,e)},m(e,f){h(e,n,f),h(e,a,f),v(o,e,f),c=!0},p:N,i(e){c||(x(o.$$.fragment,e),c=!0)},o(e){M(o.$$.fragment,e),c=!1},d(e){e&&(l(n),l(a)),$(o,e)}}}function bn(T){let n,u,a,o,c,e,f,Ct='The Stable Diffusion model can also infer depth based on an image using <a href="https://github.com/isl-org/MiDaS" rel="nofollow">MiDaS</a>. This allows you to pass a text prompt and an initial image to condition the generation of new images as well as a <code>depth_map</code> to preserve the image structure.',Xe,B,Fe,ne,Be,g,oe,ze,we,Wt="Pipeline for text-guided depth-based image-to-image generation using Stable Diffusion.",Qe,ve,Gt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ae,xe,Lt="The pipeline also inherits the following loading methods:",Oe,Me,Nt='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',Ke,G,se,et,$e,Rt="The call function to the pipeline for generation.",tt,E,nt,S,ae,ot,Te,Xt=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,st,Y,at,V,it,q,ie,rt,Ie,Ft=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,lt,j,re,pt,De,Bt=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,dt,H,ct,z,mt,Q,le,ft,Je,Et='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',ut,J,pe,gt,Ue,Yt=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,ht,Ze,Vt="Example:",_t,A,bt,ke,qt=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,yt,O,wt,I,de,vt,Se,Ht=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,xt,je,zt="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Mt,Pe,Qt='See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',$t,Ce,At=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,Tt,We,Ot=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,It,K,Dt,L,ce,Jt,Ge,Kt="Save the UNet and text encoder LoRA parameters.",Ut,ee,Zt,te,me,kt,Le,en="Encodes the prompt into text encoder hidden states.",Ee,fe,Ye,R,ue,St,Ne,tn="Output class for Stable Diffusion pipelines.",Ve,Re,qe;return c=new Pt({props:{title:"Depth-to-image",local:"depth-to-image",headingTag:"h1"}}),B=new jt({props:{$$slots:{default:[ln]},$$scope:{ctx:T}}}),ne=new Pt({props:{title:"StableDiffusionDepth2ImgPipeline",local:"diffusers.StableDiffusionDepth2ImgPipeline",headingTag:"h2"}}),oe=new W({props:{name:"class diffusers.StableDiffusionDepth2ImgPipeline",anchor:"diffusers.StableDiffusionDepth2ImgPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"depth_estimator",val:": DPTForDepthEstimation"},{name:"feature_extractor",val:": DPTFeatureExtractor"}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_depth2img.py#L73"}}),se=new W({props:{name:"__call__",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"depth_map",val:": typing.Optional[torch.FloatTensor] = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": typing.Optional[int] = 50"},{name:"guidance_scale",val:": typing.Optional[float] = 7.5"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": typing.Optional[float] = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be used as the starting point. Can accept image
latents as <code>image</code> only if <code>depth_map</code> is not <code>None</code>.`,name:"image"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.depth_map",description:`<strong>depth_map</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Depth prediction to be used as additional conditioning for the image generation process. If not
defined, it automatically predicts the depth with <code>self.depth_estimator</code>.`,name:"depth_map"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_depth2img.py#L595",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),E=new be({props:{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.example",$$slots:{default:[pn]},$$scope:{ctx:T}}}),ae=new W({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2039"}}),Y=new jt({props:{warning:!0,$$slots:{default:[dn]},$$scope:{ctx:T}}}),V=new be({props:{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.enable_attention_slicing.example",$$slots:{default:[cn]},$$scope:{ctx:T}}}),ie=new W({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2079"}}),re=new W({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1978"}}),H=new jt({props:{warning:!0,$$slots:{default:[mn]},$$scope:{ctx:T}}}),z=new be({props:{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[fn]},$$scope:{ctx:T}}}),le=new W({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2013"}}),pe=new W({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, typing.List[str], typing.Dict[str, torch.Tensor], typing.List[typing.Dict[str, torch.Tensor]]]"},{name:"token",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[ForwardRef('PreTrainedTokenizer')] = None"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L270"}}),A=new be({props:{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.example",$$slots:{default:[un]},$$scope:{ctx:T}}}),O=new be({props:{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.example-2",$$slots:{default:[gn]},$$scope:{ctx:T}}}),de=new W({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
A string (model id of a pretrained model hosted on the Hub), a path to a directory containing the model
weights, or a <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name for referencing the loaded adapter model. If not specified, it will use <code>default_{i}</code> where <code>i</code> is
the total number of adapters being loaded. Must have PEFT installed to use.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L78"}}),K=new be({props:{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_lora_weights.example",$$slots:{default:[hn]},$$scope:{ctx:T}}}),ce=new W({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"unet_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_lora_layers",val:": typing.Dict[str, torch.nn.modules.module.Module] = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to (will be created if it doesn&#x2019;t exist).`,name:"save_directory"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dict. Useful during distributed training when you need to replace
<code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L883"}}),ee=new be({props:{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights.example",$$slots:{default:[_n]},$$scope:{ctx:T}}}),me=new W({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_depth2img.py#L181"}}),fe=new Pt({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),ue=new W({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L11"}}),{c(){n=p("meta"),u=i(),a=p("p"),o=i(),y(c.$$.fragment),e=i(),f=p("p"),f.innerHTML=Ct,Xe=i(),y(B.$$.fragment),Fe=i(),y(ne.$$.fragment),Be=i(),g=p("div"),y(oe.$$.fragment),ze=i(),we=p("p"),we.textContent=Wt,Qe=i(),ve=p("p"),ve.innerHTML=Gt,Ae=i(),xe=p("p"),xe.textContent=Lt,Oe=i(),Me=p("ul"),Me.innerHTML=Nt,Ke=i(),G=p("div"),y(se.$$.fragment),et=i(),$e=p("p"),$e.textContent=Rt,tt=i(),y(E.$$.fragment),nt=i(),S=p("div"),y(ae.$$.fragment),ot=i(),Te=p("p"),Te.textContent=Xt,st=i(),y(Y.$$.fragment),at=i(),y(V.$$.fragment),it=i(),q=p("div"),y(ie.$$.fragment),rt=i(),Ie=p("p"),Ie.innerHTML=Ft,lt=i(),j=p("div"),y(re.$$.fragment),pt=i(),De=p("p"),De.innerHTML=Bt,dt=i(),y(H.$$.fragment),ct=i(),y(z.$$.fragment),mt=i(),Q=p("div"),y(le.$$.fragment),ft=i(),Je=p("p"),Je.innerHTML=Et,ut=i(),J=p("div"),y(pe.$$.fragment),gt=i(),Ue=p("p"),Ue.innerHTML=Yt,ht=i(),Ze=p("p"),Ze.textContent=Vt,_t=i(),y(A.$$.fragment),bt=i(),ke=p("p"),ke.innerHTML=qt,yt=i(),y(O.$$.fragment),wt=i(),I=p("div"),y(de.$$.fragment),vt=i(),Se=p("p"),Se.innerHTML=Ht,xt=i(),je=p("p"),je.innerHTML=zt,Mt=i(),Pe=p("p"),Pe.innerHTML=Qt,$t=i(),Ce=p("p"),Ce.innerHTML=At,Tt=i(),We=p("p"),We.innerHTML=Ot,It=i(),y(K.$$.fragment),Dt=i(),L=p("div"),y(ce.$$.fragment),Jt=i(),Ge=p("p"),Ge.textContent=Kt,Ut=i(),y(ee.$$.fragment),Zt=i(),te=p("div"),y(me.$$.fragment),kt=i(),Le=p("p"),Le.textContent=en,Ee=i(),y(fe.$$.fragment),Ye=i(),R=p("div"),y(ue.$$.fragment),St=i(),Ne=p("p"),Ne.textContent=tn,Ve=i(),Re=p("p"),this.h()},l(t){const m=rn("svelte-u9bgzb",document.head);n=d(m,"META",{name:!0,content:!0}),m.forEach(l),u=r(t),a=d(t,"P",{}),Z(a).forEach(l),o=r(t),w(c.$$.fragment,t),e=r(t),f=d(t,"P",{"data-svelte-h":!0}),_(f)!=="svelte-z7xyn"&&(f.innerHTML=Ct),Xe=r(t),w(B.$$.fragment,t),Fe=r(t),w(ne.$$.fragment,t),Be=r(t),g=d(t,"DIV",{class:!0});var b=Z(g);w(oe.$$.fragment,b),ze=r(b),we=d(b,"P",{"data-svelte-h":!0}),_(we)!=="svelte-1fmvafp"&&(we.textContent=Wt),Qe=r(b),ve=d(b,"P",{"data-svelte-h":!0}),_(ve)!=="svelte-496sm0"&&(ve.innerHTML=Gt),Ae=r(b),xe=d(b,"P",{"data-svelte-h":!0}),_(xe)!=="svelte-14s6m4u"&&(xe.textContent=Lt),Oe=r(b),Me=d(b,"UL",{"data-svelte-h":!0}),_(Me)!=="svelte-ks5x56"&&(Me.innerHTML=Nt),Ke=r(b),G=d(b,"DIV",{class:!0});var X=Z(G);w(se.$$.fragment,X),et=r(X),$e=d(X,"P",{"data-svelte-h":!0}),_($e)!=="svelte-50j04k"&&($e.textContent=Rt),tt=r(X),w(E.$$.fragment,X),X.forEach(l),nt=r(b),S=d(b,"DIV",{class:!0});var P=Z(S);w(ae.$$.fragment,P),ot=r(P),Te=d(P,"P",{"data-svelte-h":!0}),_(Te)!=="svelte-10jaql7"&&(Te.textContent=Xt),st=r(P),w(Y.$$.fragment,P),at=r(P),w(V.$$.fragment,P),P.forEach(l),it=r(b),q=d(b,"DIV",{class:!0});var ge=Z(q);w(ie.$$.fragment,ge),rt=r(ge),Ie=d(ge,"P",{"data-svelte-h":!0}),_(Ie)!=="svelte-1lh0nh5"&&(Ie.innerHTML=Ft),ge.forEach(l),lt=r(b),j=d(b,"DIV",{class:!0});var C=Z(j);w(re.$$.fragment,C),pt=r(C),De=d(C,"P",{"data-svelte-h":!0}),_(De)!=="svelte-e03q3e"&&(De.innerHTML=Bt),dt=r(C),w(H.$$.fragment,C),ct=r(C),w(z.$$.fragment,C),C.forEach(l),mt=r(b),Q=d(b,"DIV",{class:!0});var he=Z(Q);w(le.$$.fragment,he),ft=r(he),Je=d(he,"P",{"data-svelte-h":!0}),_(Je)!=="svelte-1vfte1e"&&(Je.innerHTML=Et),he.forEach(l),ut=r(b),J=d(b,"DIV",{class:!0});var U=Z(J);w(pe.$$.fragment,U),gt=r(U),Ue=d(U,"P",{"data-svelte-h":!0}),_(Ue)!=="svelte-1lv88wo"&&(Ue.innerHTML=Yt),ht=r(U),Ze=d(U,"P",{"data-svelte-h":!0}),_(Ze)!=="svelte-11lpom8"&&(Ze.textContent=Vt),_t=r(U),w(A.$$.fragment,U),bt=r(U),ke=d(U,"P",{"data-svelte-h":!0}),_(ke)!=="svelte-15d7mv5"&&(ke.innerHTML=qt),yt=r(U),w(O.$$.fragment,U),U.forEach(l),wt=r(b),I=d(b,"DIV",{class:!0});var D=Z(I);w(de.$$.fragment,D),vt=r(D),Se=d(D,"P",{"data-svelte-h":!0}),_(Se)!=="svelte-vs7s0z"&&(Se.innerHTML=Ht),xt=r(D),je=d(D,"P",{"data-svelte-h":!0}),_(je)!=="svelte-15b960v"&&(je.innerHTML=zt),Mt=r(D),Pe=d(D,"P",{"data-svelte-h":!0}),_(Pe)!=="svelte-12uyc98"&&(Pe.innerHTML=Qt),$t=r(D),Ce=d(D,"P",{"data-svelte-h":!0}),_(Ce)!=="svelte-1q3yzk7"&&(Ce.innerHTML=At),Tt=r(D),We=d(D,"P",{"data-svelte-h":!0}),_(We)!=="svelte-10xxjud"&&(We.innerHTML=Ot),It=r(D),w(K.$$.fragment,D),D.forEach(l),Dt=r(b),L=d(b,"DIV",{class:!0});var F=Z(L);w(ce.$$.fragment,F),Jt=r(F),Ge=d(F,"P",{"data-svelte-h":!0}),_(Ge)!=="svelte-1ac6d9e"&&(Ge.textContent=Kt),Ut=r(F),w(ee.$$.fragment,F),F.forEach(l),Zt=r(b),te=d(b,"DIV",{class:!0});var _e=Z(te);w(me.$$.fragment,_e),kt=r(_e),Le=d(_e,"P",{"data-svelte-h":!0}),_(Le)!=="svelte-16q0ax1"&&(Le.textContent=en),_e.forEach(l),b.forEach(l),Ee=r(t),w(fe.$$.fragment,t),Ye=r(t),R=d(t,"DIV",{class:!0});var He=Z(R);w(ue.$$.fragment,He),St=r(He),Ne=d(He,"P",{"data-svelte-h":!0}),_(Ne)!=="svelte-1qpjiuf"&&(Ne.textContent=tn),He.forEach(l),Ve=r(t),Re=d(t,"P",{}),Z(Re).forEach(l),this.h()},h(){k(n,"name","hf:doc:metadata"),k(n,"content",yn),k(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,m){s(document.head,n),h(t,u,m),h(t,a,m),h(t,o,m),v(c,t,m),h(t,e,m),h(t,f,m),h(t,Xe,m),v(B,t,m),h(t,Fe,m),v(ne,t,m),h(t,Be,m),h(t,g,m),v(oe,g,null),s(g,ze),s(g,we),s(g,Qe),s(g,ve),s(g,Ae),s(g,xe),s(g,Oe),s(g,Me),s(g,Ke),s(g,G),v(se,G,null),s(G,et),s(G,$e),s(G,tt),v(E,G,null),s(g,nt),s(g,S),v(ae,S,null),s(S,ot),s(S,Te),s(S,st),v(Y,S,null),s(S,at),v(V,S,null),s(g,it),s(g,q),v(ie,q,null),s(q,rt),s(q,Ie),s(g,lt),s(g,j),v(re,j,null),s(j,pt),s(j,De),s(j,dt),v(H,j,null),s(j,ct),v(z,j,null),s(g,mt),s(g,Q),v(le,Q,null),s(Q,ft),s(Q,Je),s(g,ut),s(g,J),v(pe,J,null),s(J,gt),s(J,Ue),s(J,ht),s(J,Ze),s(J,_t),v(A,J,null),s(J,bt),s(J,ke),s(J,yt),v(O,J,null),s(g,wt),s(g,I),v(de,I,null),s(I,vt),s(I,Se),s(I,xt),s(I,je),s(I,Mt),s(I,Pe),s(I,$t),s(I,Ce),s(I,Tt),s(I,We),s(I,It),v(K,I,null),s(g,Dt),s(g,L),v(ce,L,null),s(L,Jt),s(L,Ge),s(L,Ut),v(ee,L,null),s(g,Zt),s(g,te),v(me,te,null),s(te,kt),s(te,Le),h(t,Ee,m),v(fe,t,m),h(t,Ye,m),h(t,R,m),v(ue,R,null),s(R,St),s(R,Ne),h(t,Ve,m),h(t,Re,m),qe=!0},p(t,[m]){const b={};m&2&&(b.$$scope={dirty:m,ctx:t}),B.$set(b);const X={};m&2&&(X.$$scope={dirty:m,ctx:t}),E.$set(X);const P={};m&2&&(P.$$scope={dirty:m,ctx:t}),Y.$set(P);const ge={};m&2&&(ge.$$scope={dirty:m,ctx:t}),V.$set(ge);const C={};m&2&&(C.$$scope={dirty:m,ctx:t}),H.$set(C);const he={};m&2&&(he.$$scope={dirty:m,ctx:t}),z.$set(he);const U={};m&2&&(U.$$scope={dirty:m,ctx:t}),A.$set(U);const D={};m&2&&(D.$$scope={dirty:m,ctx:t}),O.$set(D);const F={};m&2&&(F.$$scope={dirty:m,ctx:t}),K.$set(F);const _e={};m&2&&(_e.$$scope={dirty:m,ctx:t}),ee.$set(_e)},i(t){qe||(x(c.$$.fragment,t),x(B.$$.fragment,t),x(ne.$$.fragment,t),x(oe.$$.fragment,t),x(se.$$.fragment,t),x(E.$$.fragment,t),x(ae.$$.fragment,t),x(Y.$$.fragment,t),x(V.$$.fragment,t),x(ie.$$.fragment,t),x(re.$$.fragment,t),x(H.$$.fragment,t),x(z.$$.fragment,t),x(le.$$.fragment,t),x(pe.$$.fragment,t),x(A.$$.fragment,t),x(O.$$.fragment,t),x(de.$$.fragment,t),x(K.$$.fragment,t),x(ce.$$.fragment,t),x(ee.$$.fragment,t),x(me.$$.fragment,t),x(fe.$$.fragment,t),x(ue.$$.fragment,t),qe=!0)},o(t){M(c.$$.fragment,t),M(B.$$.fragment,t),M(ne.$$.fragment,t),M(oe.$$.fragment,t),M(se.$$.fragment,t),M(E.$$.fragment,t),M(ae.$$.fragment,t),M(Y.$$.fragment,t),M(V.$$.fragment,t),M(ie.$$.fragment,t),M(re.$$.fragment,t),M(H.$$.fragment,t),M(z.$$.fragment,t),M(le.$$.fragment,t),M(pe.$$.fragment,t),M(A.$$.fragment,t),M(O.$$.fragment,t),M(de.$$.fragment,t),M(K.$$.fragment,t),M(ce.$$.fragment,t),M(ee.$$.fragment,t),M(me.$$.fragment,t),M(fe.$$.fragment,t),M(ue.$$.fragment,t),qe=!1},d(t){t&&(l(u),l(a),l(o),l(e),l(f),l(Xe),l(Fe),l(Be),l(g),l(Ee),l(Ye),l(R),l(Ve),l(Re)),l(n),$(c,t),$(B,t),$(ne,t),$(oe),$(se),$(E),$(ae),$(Y),$(V),$(ie),$(re),$(H),$(z),$(le),$(pe),$(A),$(O),$(de),$(K),$(ce),$(ee),$(me),$(fe,t),$(ue)}}}const yn='{"title":"Depth-to-image","local":"depth-to-image","sections":[{"title":"StableDiffusionDepth2ImgPipeline","local":"diffusers.StableDiffusionDepth2ImgPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function wn(T){return on(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jn extends sn{constructor(n){super(),an(this,n,wn,bn,nn,{})}}export{Jn as component};
