import{s as ds,n as as,o as os}from"../chunks/scheduler.b108d059.js";import{S as is,i as ss,g as o,s as d,r as m,A as ns,h as i,f as l,c as a,j as u,u as f,x as s,k as n,y as us,a as r,v as p,d as c,t as h,w as T}from"../chunks/index.008de539.js";import{C as ms}from"../chunks/CodeBlock.3968c746.js";import{H as y}from"../chunks/Heading.88bfeb84.js";function fs(yo){let v,cl,fl,hl,b,Tl,_,yl,x,vo="Helper module for mathematical processing.",vl,$,bo=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,bl,F,_o='<li><a href="#module_utils/maths">utils/maths</a><ul><li><em>static</em><ul><li><a href="#module_utils/maths.FFT">.FFT</a><ul><li><a href="#new_module_utils/maths.FFT_new"><code>new FFT(size)</code></a></li> <li><a href="#module_utils/maths.FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float32Array</code></li> <li><a href="#module_utils/maths.FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float32Array</code></li> <li><a href="#module_utils/maths.FFT+completeSpectrum"><code>.completeSpectrum(spectrum)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths.FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths.FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths.FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths.FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths.FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths.FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths.FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths.FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths.FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li> <li><a href="#module_utils/maths.interpolate_data"><code>.interpolate_data(input)</code></a></li> <li><a href="#module_utils/maths.transpose_data"><code>.transpose_data(array, dims, axes)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.softmax"><code>.softmax(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.log_softmax"><code>.log_softmax(arr)</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/maths.dot"><code>.dot(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.getTopItems"><code>.getTopItems(items, [top_k])</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/maths.cos_sim"><code>.cos_sim(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.magnitude"><code>.magnitude(arr)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.min"><code>.min(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.max"><code>.max(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.rfftfreq"><code>.rfftfreq(n, [d])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.medianFilter"><code>.medianFilter(data, windowSize)</code></a></li> <li><a href="#module_utils/maths.round"><code>.round(num, decimals)</code></a> ⇒ <code>number</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/maths..AnyTypedArray"><code>~AnyTypedArray</code></a> : <code>Int8Array</code> | <code>Uint8Array</code> | <code>Uint8ClampedArray</code> | <code>Int16Array</code> | <code>Uint16Array</code> | <code>Int32Array</code> | <code>Uint32Array</code> | <code>Float32Array</code> | <code>Float64Array</code></li></ul></li></ul></li>',_l,xl,$l,A,Fl,C,Al,L,xo=`FFT class provides functionality for performing Fast Fourier Transform on arrays
Code adapted from <a href="https://www.npmjs.com/package/fft.js" rel="nofollow">https://www.npmjs.com/package/fft.js</a>`,Cl,M,$o='<strong>Kind</strong>: static class of <a href="#module_utils/maths"><code>utils/maths</code></a>',Ll,H,Fo='<li><a href="#module_utils/maths.FFT">.FFT</a><ul><li><a href="#new_module_utils/maths.FFT_new"><code>new FFT(size)</code></a></li> <li><a href="#module_utils/maths.FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float32Array</code></li> <li><a href="#module_utils/maths.FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float32Array</code></li> <li><a href="#module_utils/maths.FFT+completeSpectrum"><code>.completeSpectrum(spectrum)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths.FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths.FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths.FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths.FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths.FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths.FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths.FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths.FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths.FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li>',Ml,Hl,wl,w,gl,g,Pl,P,Ao="<strong>Throws</strong>:",El,E,Co="<li><code>Error</code> FFT size must be a power of two and bigger than 1.</li>",Rl,R,Lo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>number</code></td><td><p>The size of the input array. Must be a power of two and bigger than 1.</p></td></tr></tbody>",zl,Dl,kl,z,Ul,D,ql,k,Mo="Create a complex number array with size <code>2 * size</code>",Kl,U,Ho='<strong>Kind</strong>: instance method of <a href="#module_utils/maths.FFT"><code>FFT</code></a><br/> <strong>Returns</strong>: <code>Float32Array</code> - A complex number array with size <code>2 * size</code>',Ol,jl,Bl,q,Il,K,Sl,O,wo="Converts a complex number representation stored in a Float32Array to an array of real numbers.",Jl,j,go='<strong>Kind</strong>: instance method of <a href="#module_utils/maths.FFT"><code>FFT</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - An array of real numbers representing the input complex number representation.',Zl,B,Po="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>complex</td><td><code>Float32Array</code></td><td><p>The complex number representation to be converted.</p></td> </tr><tr><td>[storage]</td><td><code>Array.&lt;number&gt;</code></td><td><p>An optional array to store the result in.</p></td></tr></tbody>",Gl,Nl,Ql,I,Vl,S,Wl,J,Eo="Convert a real-valued input array to a complex-valued output array.",Xl,Z,Ro='<strong>Kind</strong>: instance method of <a href="#module_utils/maths.FFT"><code>FFT</code></a><br/> <strong>Returns</strong>: <code>Float32Array</code> - The complex-valued output array.',Yl,G,zo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Float32Array</code></td><td><p>The real-valued input array.</p></td> </tr><tr><td>[storage]</td><td><code>Float32Array</code></td><td><p>Optional buffer to store the output array.</p></td></tr></tbody>",tr,er,lr,N,rr,Q,dr,V,Do="Completes the spectrum by adding its mirrored negative frequency components.",ar,W,ko='<strong>Kind</strong>: instance method of <a href="#module_utils/maths.FFT"><code>FFT</code></a>',or,X,Uo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>spectrum</td><td><code>Float32Array</code></td><td><p>The input spectrum.</p></td></tr></tbody>",ir,sr,nr,Y,ur,tt,mr,et,qo="Performs a Fast Fourier Transform (FFT) on the given input data and stores the result in the output buffer.",fr,lt,Ko='<strong>Kind</strong>: instance method of <a href="#module_utils/maths.FFT"><code>FFT</code></a><br/> <strong>Throws</strong>:',pr,rt,Oo="<li><code>Error</code> Input and output buffers must be different.</li>",cr,dt,jo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float32Array</code></td><td><p>The output buffer to store the result.</p></td> </tr><tr><td>data</td><td><code>Float32Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",hr,Tr,yr,at,vr,ot,br,it,Bo=`Performs a real-valued forward FFT on the given input buffer and stores the result in the given output buffer.
The input buffer must contain real values only, while the output buffer will contain complex values. The input and
output buffers must be different.`,_r,st,Io='<strong>Kind</strong>: instance method of <a href="#module_utils/maths.FFT"><code>FFT</code></a><br/> <strong>Throws</strong>:',xr,nt,So="<li><code>Error</code> If the input and output buffers are the same.</li>",$r,ut,Jo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float32Array</code></td><td><p>The output buffer.</p></td> </tr><tr><td>data</td><td><code>Float32Array</code></td><td><p>The input buffer containing real values.</p></td></tr></tbody>",Fr,Ar,Cr,mt,Lr,ft,Mr,pt,Zo=`Performs an inverse FFT transformation on the given <code>data</code> array, and stores the result in <code>out</code>.
The <code>out</code> array must be a different buffer than the <code>data</code> array. The <code>out</code> array will contain the
result of the transformation. The <code>data</code> array will not be modified.`,Hr,ct,Go='<strong>Kind</strong>: instance method of <a href="#module_utils/maths.FFT"><code>FFT</code></a><br/> <strong>Throws</strong>:',wr,ht,No="<li><code>Error</code> If `out` and `data` refer to the same buffer.</li>",gr,Tt,Qo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float32Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float32Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",Pr,Er,Rr,yt,zr,vt,Dr,bt,Vo="Performs a radix-4 implementation of a discrete Fourier transform on a given set of data.",kr,_t,Wo='<strong>Kind</strong>: instance method of <a href="#module_utils/maths.FFT"><code>FFT</code></a>',Ur,xt,Xo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float32Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float32Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>A scaling factor to apply to the transform.</p></td></tr></tbody>",qr,Kr,Or,$t,jr,Ft,Br,At,Yo="Performs a radix-2 implementation of a discrete Fourier transform on a given set of data.",Ir,Ct,ti='<strong>Kind</strong>: instance method of <a href="#module_utils/maths.FFT"><code>FFT</code></a>',Sr,Lt,ei="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float32Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>out</td><td><code>Float32Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset at which to write the output data.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset at which to begin reading the input data.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for indexing the input data.</p></td></tr></tbody>",Jr,Zr,Gr,Mt,Nr,Ht,Qr,wt,li="Performs radix-4 transformation on input data of length 8",Vr,gt,ri='<strong>Kind</strong>: instance method of <a href="#module_utils/maths.FFT"><code>FFT</code></a>',Wr,Pt,di="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float32Array</code></td><td><p>Input data array of length 8</p></td> </tr><tr><td>out</td><td><code>Float32Array</code></td><td><p>Output data array of length 8</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>Index of output array to start writing from</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>Index of input array to start reading from</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>Step size between elements in input array</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>Scaling factor for inverse transform</p></td></tr></tbody>",Xr,Yr,td,Et,ed,Rt,ld,zt,ai="Real input radix-4 implementation",rd,Dt,oi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths.FFT"><code>FFT</code></a>',dd,kt,ii="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float32Array</code></td><td><p>Output array for the transformed data</p></td> </tr><tr><td>data</td><td><code>Float32Array</code></td><td><p>Input array of real data to be transformed</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The scale factor used to normalize the inverse transform</p></td></tr></tbody>",ad,od,id,Ut,sd,qt,nd,Kt,si="Performs a single real input radix-2 transformation on the provided data",ud,Ot,ni='<strong>Kind</strong>: instance method of <a href="#module_utils/maths.FFT"><code>FFT</code></a>',md,jt,ui="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float32Array</code></td><td><p>The input data array</p></td> </tr><tr><td>out</td><td><code>Float32Array</code></td><td><p>The output data array</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The output offset</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The input offset</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step</p></td></tr></tbody>",fd,pd,cd,Bt,hd,It,Td,St,mi=`Computes a single real-valued transform using radix-4 algorithm.
This method is only called for len=8.`,yd,Jt,fi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths.FFT"><code>FFT</code></a>',vd,Zt,pi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float32Array</code></td><td><p>The input data array.</p></td> </tr><tr><td>out</td><td><code>Float32Array</code></td><td><p>The output data array.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset into the output array.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset into the input array.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for the input array.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The value of inverse.</p></td></tr></tbody>",bd,_d,xd,Gt,$d,Nt,Fd,Qt,ci='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',Ad,Vt,hi="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code>TypedArray</code></td></tr></tbody>",Cd,Ld,Md,Wt,Hd,Xt,wd,Yt,Ti="Helper method to transpose a <code>AnyTypedArray</code> directly",gd,te,yi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - The transposed array and the new shape.',Pd,ee,vi="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>array</td><td><code>T</code></td> </tr><tr><td>dims</td><td><code>Array.&lt;number&gt;</code></td> </tr><tr><td>axes</td><td><code>Array.&lt;number&gt;</code></td></tr></tbody>",Ed,Rd,zd,le,Dd,re,kd,de,bi="Compute the softmax of an array of numbers.",Ud,ae,_i='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The softmax array.',qd,oe,xi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The array of numbers to compute the softmax of.</p></td></tr></tbody>",Kd,Od,jd,ie,Bd,se,Id,ne,$i="Calculates the logarithm of the softmax function for the input array.",Sd,ue,Fi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>any</code> - The resulting log_softmax array.',Jd,me,Ai="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The input array to calculate the log_softmax function for.</p></td></tr></tbody>",Zd,Gd,Nd,fe,Qd,pe,Vd,ce,Ci="Calculates the dot product of two arrays.",Wd,he,Li='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The dot product of arr1 and arr2.',Xd,Te,Mi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",Yd,ta,ea,ye,la,ve,ra,be,Hi="Get the top k items from an iterable, sorted by descending order",da,_e,wi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array</code> - The top k items, sorted by descending order',aa,xe,gi="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>items</td><td><code>Array</code></td><td></td><td><p>The items to be sorted</p></td> </tr><tr><td>[top_k]</td><td><code>number</code></td><td><code>0</code></td><td><p>The number of top items to return (default: 0 = return all)</p></td></tr></tbody>",oa,ia,sa,$e,na,Fe,ua,Ae,Pi="Computes the cosine similarity between two arrays.",ma,Ce,Ei='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The cosine similarity between the two arrays.',fa,Le,Ri="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",pa,ca,ha,Me,Ta,He,ya,we,zi="Calculates the magnitude of a given array.",va,ge,Di='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The magnitude of the array.',ba,Pe,ki="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The array to calculate the magnitude of.</p></td></tr></tbody>",_a,xa,$a,Ee,Fa,Re,Aa,ze,Ui="Returns the value and index of the minimum element in an array.",Ca,De,qi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - the value and index of the minimum element, of the form: [valueOfMin, indexOfMin]<br/> <strong>Throws</strong>:',La,ke,Ki="<li><code>Error</code> If array is empty.</li>",Ma,Ue,Oi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>TypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",Ha,wa,ga,qe,Pa,Ke,Ea,Oe,ji="Returns the value and index of the maximum element in an array.",Ra,je,Bi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - the value and index of the maximum element, of the form: [valueOfMax, indexOfMax]<br/> <strong>Throws</strong>:',za,Be,Ii="<li><code>Error</code> If array is empty.</li>",Da,Ie,Si="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>TypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",ka,Ua,qa,Se,Ka,Je,Oa,Ze,Ji="Return the Discrete Fourier Transform sample frequencies.",ja,Ge,Zi=`Code adapted from <a href="https://github.com/numpy/numpy/blob/25908cacd19915bf3ddd659c28be28a41bd97a54/numpy/fft/helper.py#L173-L221" rel="nofollow">https://github.com/numpy/numpy/blob/25908cacd19915bf3ddd659c28be28a41bd97a54/numpy/fft/helper.py#L173-L221</a>
Original Python doc: <a href="https://numpy.org/doc/stable/reference/generated/numpy.fft.rfftfreq.html" rel="nofollow">https://numpy.org/doc/stable/reference/generated/numpy.fft.rfftfreq.html</a>`,Ba,Ne,Gi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - Array of length <code>Math.floor(n / 2) + 1;</code> containing the sample frequencies.<br/> <strong>Throws</strong>:',Ia,Qe,Ni="<li><code>TypeError</code> If n is not an integer.</li>",Sa,Ve,Qi="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>n</td><td><code>number</code></td><td></td><td><p>Window length</p></td> </tr><tr><td>[d]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Sample spacing (inverse of the sampling rate). Defaults to 1.</p></td></tr></tbody>",Ja,We,Vi="<strong>Example</strong>",Za,Xe,Ga,Na,Qa,Ye,Va,tl,Wa,el,Wi="Performs median filter on the provided data. Padding is done by mirroring the data.",Xa,ll,Xi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',Ya,rl,Yi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>AnyTypedArray</code></td><td><p>The input array</p></td> </tr><tr><td>windowSize</td><td><code>number</code></td><td><p>The window size</p></td></tr></tbody>",to,eo,lo,dl,ro,al,ao,ol,ts="Helper function to round a number to a given number of decimals",oo,il,es='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The rounded number',io,sl,ls="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>num</td><td><code>number</code></td><td><p>The number to round</p></td> </tr><tr><td>decimals</td><td><code>number</code></td><td><p>The number of decimals</p></td></tr></tbody>",so,no,uo,nl,mo,ul,fo,ml,rs='<strong>Kind</strong>: inner typedef of <a href="#module_utils/maths"><code>utils/maths</code></a>',po,co,ho,pl,To;return _=new y({props:{title:"utils/maths",local:"utilsmaths",headingTag:"h1"}}),C=new y({props:{title:"utils/maths.FFT",local:"utilsmathsfft",headingTag:"h2"}}),g=new y({props:{title:"new FFT(size)",local:"new-fftsize",headingTag:"h3"}}),D=new y({props:{title:"ffT.createComplexArray() ⇒ <code> Float32Array </code>",local:"fftcreatecomplexarray--code-float32array-code",headingTag:"h3"}}),K=new y({props:{title:"ffT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>",local:"fftfromcomplexarraycomplex-storage--code-array--number--code",headingTag:"h3"}}),S=new y({props:{title:"ffT.toComplexArray(input, [storage]) ⇒ <code> Float32Array </code>",local:"ffttocomplexarrayinput-storage--code-float32array-code",headingTag:"h3"}}),Q=new y({props:{title:"ffT.completeSpectrum(spectrum) ⇒ <code> void </code>",local:"fftcompletespectrumspectrum--code-void-code",headingTag:"h3"}}),tt=new y({props:{title:"ffT.transform(out, data) ⇒ <code> void </code>",local:"ffttransformout-data--code-void-code",headingTag:"h3"}}),ot=new y({props:{title:"ffT.realTransform(out, data)",local:"fftrealtransformout-data",headingTag:"h3"}}),ft=new y({props:{title:"ffT.inverseTransform(out, data) ⇒ <code> void </code>",local:"fftinversetransformout-data--code-void-code",headingTag:"h3"}}),vt=new y({props:{title:"ffT._transform4(out, data, inv) ⇒ <code> void </code>",local:"ffttransform4out-data-inv--code-void-code",headingTag:"h3"}}),Ft=new y({props:{title:"ffT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"fftsingletransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),Ht=new y({props:{title:"ffT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>",local:"fftsingletransform4data-out-outoff-off-step-inv--code-void-code",headingTag:"h3"}}),Rt=new y({props:{title:"ffT._realTransform4(out, data, inv)",local:"fftrealtransform4out-data-inv",headingTag:"h3"}}),qt=new y({props:{title:"ffT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"fftsinglerealtransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),It=new y({props:{title:"ffT._singleRealTransform4(data, out, outOff, off, step, inv)",local:"fftsinglerealtransform4data-out-outoff-off-step-inv",headingTag:"h3"}}),Nt=new y({props:{title:"utils/maths.interpolate_data(input)",local:"utilsmathsinterpolatedatainput",headingTag:"h2"}}),Xt=new y({props:{title:"utils/maths.transpose_data(array, dims, axes) ⇒ <code> * </code>",local:"utilsmathstransposedataarray-dims-axes--code--code",headingTag:"h2"}}),re=new y({props:{title:"utils/maths.softmax(arr) ⇒ <code> Array. < number > </code>",local:"utilsmathssoftmaxarr--code-array--number--code",headingTag:"h2"}}),se=new y({props:{title:"utils/maths.log_softmax(arr) ⇒ <code> any </code>",local:"utilsmathslogsoftmaxarr--code-any-code",headingTag:"h2"}}),pe=new y({props:{title:"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathsdotarr1-arr2--code-number-code",headingTag:"h2"}}),ve=new y({props:{title:"utils/maths.getTopItems(items, [top_k]) ⇒ <code> Array </code>",local:"utilsmathsgettopitemsitems-topk--code-array-code",headingTag:"h2"}}),Fe=new y({props:{title:"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathscossimarr1-arr2--code-number-code",headingTag:"h2"}}),He=new y({props:{title:"utils/maths.magnitude(arr) ⇒ <code> number </code>",local:"utilsmathsmagnitudearr--code-number-code",headingTag:"h2"}}),Re=new y({props:{title:"utils/maths.min(arr) ⇒ <code> Array. < number > </code>",local:"utilsmathsminarr--code-array--number--code",headingTag:"h2"}}),Ke=new y({props:{title:"utils/maths.max(arr) ⇒ <code> Array. < number > </code>",local:"utilsmathsmaxarr--code-array--number--code",headingTag:"h2"}}),Je=new y({props:{title:"utils/maths.rfftfreq(n, [d]) ⇒ <code> Array. < number > </code>",local:"utilsmathsrfftfreqn-d--code-array--number--code",headingTag:"h2"}}),Xe=new ms({props:{code:"cmZmdGZyZXEoNDAwJTJDJTIwMSUyMCUyRiUyMDE2MDAwKSUyMCUyRiUyRiUyMCgyMDEpJUMyJUEwJTVCMCUyQyUyMDQwJTJDJTIwODAlMkMlMjAxMjAlMkMlMjAxNjAlMkMlMjAyMDAlMkMlMjAuLi4lMkMlMjA4MDAwJTVE",highlighted:'<span class="hljs-title function_">rfftfreq</span>(<span class="hljs-number">400</span>, <span class="hljs-number">1</span> / <span class="hljs-number">16000</span>) <span class="hljs-comment">// (201) [0, 40, 80, 120, 160, 200, ..., 8000]</span>',wrap:!1}}),tl=new y({props:{title:"utils/maths.medianFilter(data, windowSize)",local:"utilsmathsmedianfilterdata-windowsize",headingTag:"h2"}}),al=new y({props:{title:"utils/maths.round(num, decimals) ⇒ <code> number </code>",local:"utilsmathsroundnum-decimals--code-number-code",headingTag:"h2"}}),ul=new y({props:{title:"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>",local:"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code",headingTag:"h2"}}),{c(){v=o("meta"),cl=d(),fl=o("p"),hl=d(),b=o("a"),Tl=d(),m(_.$$.fragment),yl=d(),x=o("p"),x.textContent=vo,vl=d(),$=o("p"),$.textContent=bo,bl=d(),F=o("ul"),F.innerHTML=_o,_l=d(),xl=o("hr"),$l=d(),A=o("a"),Fl=d(),m(C.$$.fragment),Al=d(),L=o("p"),L.innerHTML=xo,Cl=d(),M=o("p"),M.innerHTML=$o,Ll=d(),H=o("ul"),H.innerHTML=Fo,Ml=d(),Hl=o("hr"),wl=d(),w=o("a"),gl=d(),m(g.$$.fragment),Pl=d(),P=o("p"),P.innerHTML=Ao,El=d(),E=o("ul"),E.innerHTML=Co,Rl=d(),R=o("table"),R.innerHTML=Lo,zl=d(),Dl=o("hr"),kl=d(),z=o("a"),Ul=d(),m(D.$$.fragment),ql=d(),k=o("p"),k.innerHTML=Mo,Kl=d(),U=o("p"),U.innerHTML=Ho,Ol=d(),jl=o("hr"),Bl=d(),q=o("a"),Il=d(),m(K.$$.fragment),Sl=d(),O=o("p"),O.textContent=wo,Jl=d(),j=o("p"),j.innerHTML=go,Zl=d(),B=o("table"),B.innerHTML=Po,Gl=d(),Nl=o("hr"),Ql=d(),I=o("a"),Vl=d(),m(S.$$.fragment),Wl=d(),J=o("p"),J.textContent=Eo,Xl=d(),Z=o("p"),Z.innerHTML=Ro,Yl=d(),G=o("table"),G.innerHTML=zo,tr=d(),er=o("hr"),lr=d(),N=o("a"),rr=d(),m(Q.$$.fragment),dr=d(),V=o("p"),V.textContent=Do,ar=d(),W=o("p"),W.innerHTML=ko,or=d(),X=o("table"),X.innerHTML=Uo,ir=d(),sr=o("hr"),nr=d(),Y=o("a"),ur=d(),m(tt.$$.fragment),mr=d(),et=o("p"),et.textContent=qo,fr=d(),lt=o("p"),lt.innerHTML=Ko,pr=d(),rt=o("ul"),rt.innerHTML=Oo,cr=d(),dt=o("table"),dt.innerHTML=jo,hr=d(),Tr=o("hr"),yr=d(),at=o("a"),vr=d(),m(ot.$$.fragment),br=d(),it=o("p"),it.textContent=Bo,_r=d(),st=o("p"),st.innerHTML=Io,xr=d(),nt=o("ul"),nt.innerHTML=So,$r=d(),ut=o("table"),ut.innerHTML=Jo,Fr=d(),Ar=o("hr"),Cr=d(),mt=o("a"),Lr=d(),m(ft.$$.fragment),Mr=d(),pt=o("p"),pt.innerHTML=Zo,Hr=d(),ct=o("p"),ct.innerHTML=Go,wr=d(),ht=o("ul"),ht.innerHTML=No,gr=d(),Tt=o("table"),Tt.innerHTML=Qo,Pr=d(),Er=o("hr"),Rr=d(),yt=o("a"),zr=d(),m(vt.$$.fragment),Dr=d(),bt=o("p"),bt.textContent=Vo,kr=d(),_t=o("p"),_t.innerHTML=Wo,Ur=d(),xt=o("table"),xt.innerHTML=Xo,qr=d(),Kr=o("hr"),Or=d(),$t=o("a"),jr=d(),m(Ft.$$.fragment),Br=d(),At=o("p"),At.textContent=Yo,Ir=d(),Ct=o("p"),Ct.innerHTML=ti,Sr=d(),Lt=o("table"),Lt.innerHTML=ei,Jr=d(),Zr=o("hr"),Gr=d(),Mt=o("a"),Nr=d(),m(Ht.$$.fragment),Qr=d(),wt=o("p"),wt.textContent=li,Vr=d(),gt=o("p"),gt.innerHTML=ri,Wr=d(),Pt=o("table"),Pt.innerHTML=di,Xr=d(),Yr=o("hr"),td=d(),Et=o("a"),ed=d(),m(Rt.$$.fragment),ld=d(),zt=o("p"),zt.textContent=ai,rd=d(),Dt=o("p"),Dt.innerHTML=oi,dd=d(),kt=o("table"),kt.innerHTML=ii,ad=d(),od=o("hr"),id=d(),Ut=o("a"),sd=d(),m(qt.$$.fragment),nd=d(),Kt=o("p"),Kt.textContent=si,ud=d(),Ot=o("p"),Ot.innerHTML=ni,md=d(),jt=o("table"),jt.innerHTML=ui,fd=d(),pd=o("hr"),cd=d(),Bt=o("a"),hd=d(),m(It.$$.fragment),Td=d(),St=o("p"),St.textContent=mi,yd=d(),Jt=o("p"),Jt.innerHTML=fi,vd=d(),Zt=o("table"),Zt.innerHTML=pi,bd=d(),_d=o("hr"),xd=d(),Gt=o("a"),$d=d(),m(Nt.$$.fragment),Fd=d(),Qt=o("p"),Qt.innerHTML=ci,Ad=d(),Vt=o("table"),Vt.innerHTML=hi,Cd=d(),Ld=o("hr"),Md=d(),Wt=o("a"),Hd=d(),m(Xt.$$.fragment),wd=d(),Yt=o("p"),Yt.innerHTML=Ti,gd=d(),te=o("p"),te.innerHTML=yi,Pd=d(),ee=o("table"),ee.innerHTML=vi,Ed=d(),Rd=o("hr"),zd=d(),le=o("a"),Dd=d(),m(re.$$.fragment),kd=d(),de=o("p"),de.textContent=bi,Ud=d(),ae=o("p"),ae.innerHTML=_i,qd=d(),oe=o("table"),oe.innerHTML=xi,Kd=d(),Od=o("hr"),jd=d(),ie=o("a"),Bd=d(),m(se.$$.fragment),Id=d(),ne=o("p"),ne.textContent=$i,Sd=d(),ue=o("p"),ue.innerHTML=Fi,Jd=d(),me=o("table"),me.innerHTML=Ai,Zd=d(),Gd=o("hr"),Nd=d(),fe=o("a"),Qd=d(),m(pe.$$.fragment),Vd=d(),ce=o("p"),ce.textContent=Ci,Wd=d(),he=o("p"),he.innerHTML=Li,Xd=d(),Te=o("table"),Te.innerHTML=Mi,Yd=d(),ta=o("hr"),ea=d(),ye=o("a"),la=d(),m(ve.$$.fragment),ra=d(),be=o("p"),be.textContent=Hi,da=d(),_e=o("p"),_e.innerHTML=wi,aa=d(),xe=o("table"),xe.innerHTML=gi,oa=d(),ia=o("hr"),sa=d(),$e=o("a"),na=d(),m(Fe.$$.fragment),ua=d(),Ae=o("p"),Ae.textContent=Pi,ma=d(),Ce=o("p"),Ce.innerHTML=Ei,fa=d(),Le=o("table"),Le.innerHTML=Ri,pa=d(),ca=o("hr"),ha=d(),Me=o("a"),Ta=d(),m(He.$$.fragment),ya=d(),we=o("p"),we.textContent=zi,va=d(),ge=o("p"),ge.innerHTML=Di,ba=d(),Pe=o("table"),Pe.innerHTML=ki,_a=d(),xa=o("hr"),$a=d(),Ee=o("a"),Fa=d(),m(Re.$$.fragment),Aa=d(),ze=o("p"),ze.textContent=Ui,Ca=d(),De=o("p"),De.innerHTML=qi,La=d(),ke=o("ul"),ke.innerHTML=Ki,Ma=d(),Ue=o("table"),Ue.innerHTML=Oi,Ha=d(),wa=o("hr"),ga=d(),qe=o("a"),Pa=d(),m(Ke.$$.fragment),Ea=d(),Oe=o("p"),Oe.textContent=ji,Ra=d(),je=o("p"),je.innerHTML=Bi,za=d(),Be=o("ul"),Be.innerHTML=Ii,Da=d(),Ie=o("table"),Ie.innerHTML=Si,ka=d(),Ua=o("hr"),qa=d(),Se=o("a"),Ka=d(),m(Je.$$.fragment),Oa=d(),Ze=o("p"),Ze.textContent=Ji,ja=d(),Ge=o("p"),Ge.innerHTML=Zi,Ba=d(),Ne=o("p"),Ne.innerHTML=Gi,Ia=d(),Qe=o("ul"),Qe.innerHTML=Ni,Sa=d(),Ve=o("table"),Ve.innerHTML=Qi,Ja=d(),We=o("p"),We.innerHTML=Vi,Za=d(),m(Xe.$$.fragment),Ga=d(),Na=o("hr"),Qa=d(),Ye=o("a"),Va=d(),m(tl.$$.fragment),Wa=d(),el=o("p"),el.textContent=Wi,Xa=d(),ll=o("p"),ll.innerHTML=Xi,Ya=d(),rl=o("table"),rl.innerHTML=Yi,to=d(),eo=o("hr"),lo=d(),dl=o("a"),ro=d(),m(al.$$.fragment),ao=d(),ol=o("p"),ol.textContent=ts,oo=d(),il=o("p"),il.innerHTML=es,io=d(),sl=o("table"),sl.innerHTML=ls,so=d(),no=o("hr"),uo=d(),nl=o("a"),mo=d(),m(ul.$$.fragment),fo=d(),ml=o("p"),ml.innerHTML=rs,po=d(),co=o("hr"),ho=d(),pl=o("p"),this.h()},l(t){const e=ns("svelte-u9bgzb",document.head);v=i(e,"META",{name:!0,content:!0}),e.forEach(l),cl=a(t),fl=i(t,"P",{}),u(fl).forEach(l),hl=a(t),b=i(t,"A",{id:!0,class:!0}),u(b).forEach(l),Tl=a(t),f(_.$$.fragment,t),yl=a(t),x=i(t,"P",{"data-svelte-h":!0}),s(x)!=="svelte-1d3zgi"&&(x.textContent=vo),vl=a(t),$=i(t,"P",{"data-svelte-h":!0}),s($)!=="svelte-il3kl8"&&($.textContent=bo),bl=a(t),F=i(t,"UL",{"data-svelte-h":!0}),s(F)!=="svelte-edcnvh"&&(F.innerHTML=_o),_l=a(t),xl=i(t,"HR",{}),$l=a(t),A=i(t,"A",{id:!0,class:!0}),u(A).forEach(l),Fl=a(t),f(C.$$.fragment,t),Al=a(t),L=i(t,"P",{"data-svelte-h":!0}),s(L)!=="svelte-7n75rz"&&(L.innerHTML=xo),Cl=a(t),M=i(t,"P",{"data-svelte-h":!0}),s(M)!=="svelte-17lmlic"&&(M.innerHTML=$o),Ll=a(t),H=i(t,"UL",{"data-svelte-h":!0}),s(H)!=="svelte-885sax"&&(H.innerHTML=Fo),Ml=a(t),Hl=i(t,"HR",{}),wl=a(t),w=i(t,"A",{id:!0,class:!0}),u(w).forEach(l),gl=a(t),f(g.$$.fragment,t),Pl=a(t),P=i(t,"P",{"data-svelte-h":!0}),s(P)!=="svelte-1fz4yns"&&(P.innerHTML=Ao),El=a(t),E=i(t,"UL",{"data-svelte-h":!0}),s(E)!=="svelte-qf1c3v"&&(E.innerHTML=Co),Rl=a(t),R=i(t,"TABLE",{"data-svelte-h":!0}),s(R)!=="svelte-167nzyg"&&(R.innerHTML=Lo),zl=a(t),Dl=i(t,"HR",{}),kl=a(t),z=i(t,"A",{id:!0,class:!0}),u(z).forEach(l),Ul=a(t),f(D.$$.fragment,t),ql=a(t),k=i(t,"P",{"data-svelte-h":!0}),s(k)!=="svelte-1rrw4ya"&&(k.innerHTML=Mo),Kl=a(t),U=i(t,"P",{"data-svelte-h":!0}),s(U)!=="svelte-1rh9tqv"&&(U.innerHTML=Ho),Ol=a(t),jl=i(t,"HR",{}),Bl=a(t),q=i(t,"A",{id:!0,class:!0}),u(q).forEach(l),Il=a(t),f(K.$$.fragment,t),Sl=a(t),O=i(t,"P",{"data-svelte-h":!0}),s(O)!=="svelte-1c12f1a"&&(O.textContent=wo),Jl=a(t),j=i(t,"P",{"data-svelte-h":!0}),s(j)!=="svelte-xf977d"&&(j.innerHTML=go),Zl=a(t),B=i(t,"TABLE",{"data-svelte-h":!0}),s(B)!=="svelte-1y3lbpx"&&(B.innerHTML=Po),Gl=a(t),Nl=i(t,"HR",{}),Ql=a(t),I=i(t,"A",{id:!0,class:!0}),u(I).forEach(l),Vl=a(t),f(S.$$.fragment,t),Wl=a(t),J=i(t,"P",{"data-svelte-h":!0}),s(J)!=="svelte-rsnsrd"&&(J.textContent=Eo),Xl=a(t),Z=i(t,"P",{"data-svelte-h":!0}),s(Z)!=="svelte-1p1r7nu"&&(Z.innerHTML=Ro),Yl=a(t),G=i(t,"TABLE",{"data-svelte-h":!0}),s(G)!=="svelte-uvfu55"&&(G.innerHTML=zo),tr=a(t),er=i(t,"HR",{}),lr=a(t),N=i(t,"A",{id:!0,class:!0}),u(N).forEach(l),rr=a(t),f(Q.$$.fragment,t),dr=a(t),V=i(t,"P",{"data-svelte-h":!0}),s(V)!=="svelte-id49q5"&&(V.textContent=Do),ar=a(t),W=i(t,"P",{"data-svelte-h":!0}),s(W)!=="svelte-12df40n"&&(W.innerHTML=ko),or=a(t),X=i(t,"TABLE",{"data-svelte-h":!0}),s(X)!=="svelte-wm92m6"&&(X.innerHTML=Uo),ir=a(t),sr=i(t,"HR",{}),nr=a(t),Y=i(t,"A",{id:!0,class:!0}),u(Y).forEach(l),ur=a(t),f(tt.$$.fragment,t),mr=a(t),et=i(t,"P",{"data-svelte-h":!0}),s(et)!=="svelte-846pp1"&&(et.textContent=qo),fr=a(t),lt=i(t,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-2myf8f"&&(lt.innerHTML=Ko),pr=a(t),rt=i(t,"UL",{"data-svelte-h":!0}),s(rt)!=="svelte-173tqd8"&&(rt.innerHTML=Oo),cr=a(t),dt=i(t,"TABLE",{"data-svelte-h":!0}),s(dt)!=="svelte-1ks7pv9"&&(dt.innerHTML=jo),hr=a(t),Tr=i(t,"HR",{}),yr=a(t),at=i(t,"A",{id:!0,class:!0}),u(at).forEach(l),vr=a(t),f(ot.$$.fragment,t),br=a(t),it=i(t,"P",{"data-svelte-h":!0}),s(it)!=="svelte-ozshoc"&&(it.textContent=Bo),_r=a(t),st=i(t,"P",{"data-svelte-h":!0}),s(st)!=="svelte-2myf8f"&&(st.innerHTML=Io),xr=a(t),nt=i(t,"UL",{"data-svelte-h":!0}),s(nt)!=="svelte-1ap3720"&&(nt.innerHTML=So),$r=a(t),ut=i(t,"TABLE",{"data-svelte-h":!0}),s(ut)!=="svelte-1647ezg"&&(ut.innerHTML=Jo),Fr=a(t),Ar=i(t,"HR",{}),Cr=a(t),mt=i(t,"A",{id:!0,class:!0}),u(mt).forEach(l),Lr=a(t),f(ft.$$.fragment,t),Mr=a(t),pt=i(t,"P",{"data-svelte-h":!0}),s(pt)!=="svelte-ijignt"&&(pt.innerHTML=Zo),Hr=a(t),ct=i(t,"P",{"data-svelte-h":!0}),s(ct)!=="svelte-2myf8f"&&(ct.innerHTML=Go),wr=a(t),ht=i(t,"UL",{"data-svelte-h":!0}),s(ht)!=="svelte-1bp21xg"&&(ht.innerHTML=No),gr=a(t),Tt=i(t,"TABLE",{"data-svelte-h":!0}),s(Tt)!=="svelte-hchha2"&&(Tt.innerHTML=Qo),Pr=a(t),Er=i(t,"HR",{}),Rr=a(t),yt=i(t,"A",{id:!0,class:!0}),u(yt).forEach(l),zr=a(t),f(vt.$$.fragment,t),Dr=a(t),bt=i(t,"P",{"data-svelte-h":!0}),s(bt)!=="svelte-3r4wxn"&&(bt.textContent=Vo),kr=a(t),_t=i(t,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-12df40n"&&(_t.innerHTML=Wo),Ur=a(t),xt=i(t,"TABLE",{"data-svelte-h":!0}),s(xt)!=="svelte-kv3ieb"&&(xt.innerHTML=Xo),qr=a(t),Kr=i(t,"HR",{}),Or=a(t),$t=i(t,"A",{id:!0,class:!0}),u($t).forEach(l),jr=a(t),f(Ft.$$.fragment,t),Br=a(t),At=i(t,"P",{"data-svelte-h":!0}),s(At)!=="svelte-1jz5wqp"&&(At.textContent=Yo),Ir=a(t),Ct=i(t,"P",{"data-svelte-h":!0}),s(Ct)!=="svelte-12df40n"&&(Ct.innerHTML=ti),Sr=a(t),Lt=i(t,"TABLE",{"data-svelte-h":!0}),s(Lt)!=="svelte-1mr0spx"&&(Lt.innerHTML=ei),Jr=a(t),Zr=i(t,"HR",{}),Gr=a(t),Mt=i(t,"A",{id:!0,class:!0}),u(Mt).forEach(l),Nr=a(t),f(Ht.$$.fragment,t),Qr=a(t),wt=i(t,"P",{"data-svelte-h":!0}),s(wt)!=="svelte-1baynqa"&&(wt.textContent=li),Vr=a(t),gt=i(t,"P",{"data-svelte-h":!0}),s(gt)!=="svelte-12df40n"&&(gt.innerHTML=ri),Wr=a(t),Pt=i(t,"TABLE",{"data-svelte-h":!0}),s(Pt)!=="svelte-1ejtysz"&&(Pt.innerHTML=di),Xr=a(t),Yr=i(t,"HR",{}),td=a(t),Et=i(t,"A",{id:!0,class:!0}),u(Et).forEach(l),ed=a(t),f(Rt.$$.fragment,t),ld=a(t),zt=i(t,"P",{"data-svelte-h":!0}),s(zt)!=="svelte-1gll44b"&&(zt.textContent=ai),rd=a(t),Dt=i(t,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-12df40n"&&(Dt.innerHTML=oi),dd=a(t),kt=i(t,"TABLE",{"data-svelte-h":!0}),s(kt)!=="svelte-16u1rxd"&&(kt.innerHTML=ii),ad=a(t),od=i(t,"HR",{}),id=a(t),Ut=i(t,"A",{id:!0,class:!0}),u(Ut).forEach(l),sd=a(t),f(qt.$$.fragment,t),nd=a(t),Kt=i(t,"P",{"data-svelte-h":!0}),s(Kt)!=="svelte-1upf1p8"&&(Kt.textContent=si),ud=a(t),Ot=i(t,"P",{"data-svelte-h":!0}),s(Ot)!=="svelte-12df40n"&&(Ot.innerHTML=ni),md=a(t),jt=i(t,"TABLE",{"data-svelte-h":!0}),s(jt)!=="svelte-19ynn29"&&(jt.innerHTML=ui),fd=a(t),pd=i(t,"HR",{}),cd=a(t),Bt=i(t,"A",{id:!0,class:!0}),u(Bt).forEach(l),hd=a(t),f(It.$$.fragment,t),Td=a(t),St=i(t,"P",{"data-svelte-h":!0}),s(St)!=="svelte-8fqhv2"&&(St.textContent=mi),yd=a(t),Jt=i(t,"P",{"data-svelte-h":!0}),s(Jt)!=="svelte-12df40n"&&(Jt.innerHTML=fi),vd=a(t),Zt=i(t,"TABLE",{"data-svelte-h":!0}),s(Zt)!=="svelte-x70c2w"&&(Zt.innerHTML=pi),bd=a(t),_d=i(t,"HR",{}),xd=a(t),Gt=i(t,"A",{id:!0,class:!0}),u(Gt).forEach(l),$d=a(t),f(Nt.$$.fragment,t),Fd=a(t),Qt=i(t,"P",{"data-svelte-h":!0}),s(Qt)!=="svelte-z8esp"&&(Qt.innerHTML=ci),Ad=a(t),Vt=i(t,"TABLE",{"data-svelte-h":!0}),s(Vt)!=="svelte-13raiaj"&&(Vt.innerHTML=hi),Cd=a(t),Ld=i(t,"HR",{}),Md=a(t),Wt=i(t,"A",{id:!0,class:!0}),u(Wt).forEach(l),Hd=a(t),f(Xt.$$.fragment,t),wd=a(t),Yt=i(t,"P",{"data-svelte-h":!0}),s(Yt)!=="svelte-69x642"&&(Yt.innerHTML=Ti),gd=a(t),te=i(t,"P",{"data-svelte-h":!0}),s(te)!=="svelte-1t49mrp"&&(te.innerHTML=yi),Pd=a(t),ee=i(t,"TABLE",{"data-svelte-h":!0}),s(ee)!=="svelte-18fxup5"&&(ee.innerHTML=vi),Ed=a(t),Rd=i(t,"HR",{}),zd=a(t),le=i(t,"A",{id:!0,class:!0}),u(le).forEach(l),Dd=a(t),f(re.$$.fragment,t),kd=a(t),de=i(t,"P",{"data-svelte-h":!0}),s(de)!=="svelte-1liv70i"&&(de.textContent=bi),Ud=a(t),ae=i(t,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-rbowzb"&&(ae.innerHTML=_i),qd=a(t),oe=i(t,"TABLE",{"data-svelte-h":!0}),s(oe)!=="svelte-5w3h5g"&&(oe.innerHTML=xi),Kd=a(t),Od=i(t,"HR",{}),jd=a(t),ie=i(t,"A",{id:!0,class:!0}),u(ie).forEach(l),Bd=a(t),f(se.$$.fragment,t),Id=a(t),ne=i(t,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-5479oq"&&(ne.textContent=$i),Sd=a(t),ue=i(t,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-qwp7fz"&&(ue.innerHTML=Fi),Jd=a(t),me=i(t,"TABLE",{"data-svelte-h":!0}),s(me)!=="svelte-1482umh"&&(me.innerHTML=Ai),Zd=a(t),Gd=i(t,"HR",{}),Nd=a(t),fe=i(t,"A",{id:!0,class:!0}),u(fe).forEach(l),Qd=a(t),f(pe.$$.fragment,t),Vd=a(t),ce=i(t,"P",{"data-svelte-h":!0}),s(ce)!=="svelte-1kaf4lx"&&(ce.textContent=Ci),Wd=a(t),he=i(t,"P",{"data-svelte-h":!0}),s(he)!=="svelte-gudhvq"&&(he.innerHTML=Li),Xd=a(t),Te=i(t,"TABLE",{"data-svelte-h":!0}),s(Te)!=="svelte-nyqk4k"&&(Te.innerHTML=Mi),Yd=a(t),ta=i(t,"HR",{}),ea=a(t),ye=i(t,"A",{id:!0,class:!0}),u(ye).forEach(l),la=a(t),f(ve.$$.fragment,t),ra=a(t),be=i(t,"P",{"data-svelte-h":!0}),s(be)!=="svelte-s7mgi8"&&(be.textContent=Hi),da=a(t),_e=i(t,"P",{"data-svelte-h":!0}),s(_e)!=="svelte-u4yvnz"&&(_e.innerHTML=wi),aa=a(t),xe=i(t,"TABLE",{"data-svelte-h":!0}),s(xe)!=="svelte-pqgsee"&&(xe.innerHTML=gi),oa=a(t),ia=i(t,"HR",{}),sa=a(t),$e=i(t,"A",{id:!0,class:!0}),u($e).forEach(l),na=a(t),f(Fe.$$.fragment,t),ua=a(t),Ae=i(t,"P",{"data-svelte-h":!0}),s(Ae)!=="svelte-6quqqj"&&(Ae.textContent=Pi),ma=a(t),Ce=i(t,"P",{"data-svelte-h":!0}),s(Ce)!=="svelte-1y45k06"&&(Ce.innerHTML=Ei),fa=a(t),Le=i(t,"TABLE",{"data-svelte-h":!0}),s(Le)!=="svelte-nyqk4k"&&(Le.innerHTML=Ri),pa=a(t),ca=i(t,"HR",{}),ha=a(t),Me=i(t,"A",{id:!0,class:!0}),u(Me).forEach(l),Ta=a(t),f(He.$$.fragment,t),ya=a(t),we=i(t,"P",{"data-svelte-h":!0}),s(we)!=="svelte-132v21g"&&(we.textContent=zi),va=a(t),ge=i(t,"P",{"data-svelte-h":!0}),s(ge)!=="svelte-odriss"&&(ge.innerHTML=Di),ba=a(t),Pe=i(t,"TABLE",{"data-svelte-h":!0}),s(Pe)!=="svelte-nbo00i"&&(Pe.innerHTML=ki),_a=a(t),xa=i(t,"HR",{}),$a=a(t),Ee=i(t,"A",{id:!0,class:!0}),u(Ee).forEach(l),Fa=a(t),f(Re.$$.fragment,t),Aa=a(t),ze=i(t,"P",{"data-svelte-h":!0}),s(ze)!=="svelte-67h0u1"&&(ze.textContent=Ui),Ca=a(t),De=i(t,"P",{"data-svelte-h":!0}),s(De)!=="svelte-cs0f6n"&&(De.innerHTML=qi),La=a(t),ke=i(t,"UL",{"data-svelte-h":!0}),s(ke)!=="svelte-jusv8t"&&(ke.innerHTML=Ki),Ma=a(t),Ue=i(t,"TABLE",{"data-svelte-h":!0}),s(Ue)!=="svelte-mtkj0x"&&(Ue.innerHTML=Oi),Ha=a(t),wa=i(t,"HR",{}),ga=a(t),qe=i(t,"A",{id:!0,class:!0}),u(qe).forEach(l),Pa=a(t),f(Ke.$$.fragment,t),Ea=a(t),Oe=i(t,"P",{"data-svelte-h":!0}),s(Oe)!=="svelte-9vv4b"&&(Oe.textContent=ji),Ra=a(t),je=i(t,"P",{"data-svelte-h":!0}),s(je)!=="svelte-19uyzyt"&&(je.innerHTML=Bi),za=a(t),Be=i(t,"UL",{"data-svelte-h":!0}),s(Be)!=="svelte-jusv8t"&&(Be.innerHTML=Ii),Da=a(t),Ie=i(t,"TABLE",{"data-svelte-h":!0}),s(Ie)!=="svelte-mtkj0x"&&(Ie.innerHTML=Si),ka=a(t),Ua=i(t,"HR",{}),qa=a(t),Se=i(t,"A",{id:!0,class:!0}),u(Se).forEach(l),Ka=a(t),f(Je.$$.fragment,t),Oa=a(t),Ze=i(t,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-8fws3u"&&(Ze.textContent=Ji),ja=a(t),Ge=i(t,"P",{"data-svelte-h":!0}),s(Ge)!=="svelte-8awj2f"&&(Ge.innerHTML=Zi),Ba=a(t),Ne=i(t,"P",{"data-svelte-h":!0}),s(Ne)!=="svelte-165oo4g"&&(Ne.innerHTML=Gi),Ia=a(t),Qe=i(t,"UL",{"data-svelte-h":!0}),s(Qe)!=="svelte-1i3knpp"&&(Qe.innerHTML=Ni),Sa=a(t),Ve=i(t,"TABLE",{"data-svelte-h":!0}),s(Ve)!=="svelte-166ukyk"&&(Ve.innerHTML=Qi),Ja=a(t),We=i(t,"P",{"data-svelte-h":!0}),s(We)!=="svelte-1aswmub"&&(We.innerHTML=Vi),Za=a(t),f(Xe.$$.fragment,t),Ga=a(t),Na=i(t,"HR",{}),Qa=a(t),Ye=i(t,"A",{id:!0,class:!0}),u(Ye).forEach(l),Va=a(t),f(tl.$$.fragment,t),Wa=a(t),el=i(t,"P",{"data-svelte-h":!0}),s(el)!=="svelte-xb1vdd"&&(el.textContent=Wi),Xa=a(t),ll=i(t,"P",{"data-svelte-h":!0}),s(ll)!=="svelte-z8esp"&&(ll.innerHTML=Xi),Ya=a(t),rl=i(t,"TABLE",{"data-svelte-h":!0}),s(rl)!=="svelte-pk7ooi"&&(rl.innerHTML=Yi),to=a(t),eo=i(t,"HR",{}),lo=a(t),dl=i(t,"A",{id:!0,class:!0}),u(dl).forEach(l),ro=a(t),f(al.$$.fragment,t),ao=a(t),ol=i(t,"P",{"data-svelte-h":!0}),s(ol)!=="svelte-11aka64"&&(ol.textContent=ts),oo=a(t),il=i(t,"P",{"data-svelte-h":!0}),s(il)!=="svelte-jttckh"&&(il.innerHTML=es),io=a(t),sl=i(t,"TABLE",{"data-svelte-h":!0}),s(sl)!=="svelte-c6gnt1"&&(sl.innerHTML=ls),so=a(t),no=i(t,"HR",{}),uo=a(t),nl=i(t,"A",{id:!0,class:!0}),u(nl).forEach(l),mo=a(t),f(ul.$$.fragment,t),fo=a(t),ml=i(t,"P",{"data-svelte-h":!0}),s(ml)!=="svelte-9rr3v5"&&(ml.innerHTML=rs),po=a(t),co=i(t,"HR",{}),ho=a(t),pl=i(t,"P",{}),u(pl).forEach(l),this.h()},h(){n(v,"name","hf:doc:metadata"),n(v,"content",ps),n(b,"id","module_utils/maths"),n(b,"class","group"),n(A,"id","module_utils/maths.FFT"),n(A,"class","group"),n(w,"id","new_module_utils/maths.FFT_new"),n(w,"class","group"),n(z,"id","module_utils/maths.FFT+createComplexArray"),n(z,"class","group"),n(q,"id","module_utils/maths.FFT+fromComplexArray"),n(q,"class","group"),n(I,"id","module_utils/maths.FFT+toComplexArray"),n(I,"class","group"),n(N,"id","module_utils/maths.FFT+completeSpectrum"),n(N,"class","group"),n(Y,"id","module_utils/maths.FFT+transform"),n(Y,"class","group"),n(at,"id","module_utils/maths.FFT+realTransform"),n(at,"class","group"),n(mt,"id","module_utils/maths.FFT+inverseTransform"),n(mt,"class","group"),n(yt,"id","module_utils/maths.FFT+_transform4"),n(yt,"class","group"),n($t,"id","module_utils/maths.FFT+_singleTransform2"),n($t,"class","group"),n(Mt,"id","module_utils/maths.FFT+_singleTransform4"),n(Mt,"class","group"),n(Et,"id","module_utils/maths.FFT+_realTransform4"),n(Et,"class","group"),n(Ut,"id","module_utils/maths.FFT+_singleRealTransform2"),n(Ut,"class","group"),n(Bt,"id","module_utils/maths.FFT+_singleRealTransform4"),n(Bt,"class","group"),n(Gt,"id","module_utils/maths.interpolate_data"),n(Gt,"class","group"),n(Wt,"id","module_utils/maths.transpose_data"),n(Wt,"class","group"),n(le,"id","module_utils/maths.softmax"),n(le,"class","group"),n(ie,"id","module_utils/maths.log_softmax"),n(ie,"class","group"),n(fe,"id","module_utils/maths.dot"),n(fe,"class","group"),n(ye,"id","module_utils/maths.getTopItems"),n(ye,"class","group"),n($e,"id","module_utils/maths.cos_sim"),n($e,"class","group"),n(Me,"id","module_utils/maths.magnitude"),n(Me,"class","group"),n(Ee,"id","module_utils/maths.min"),n(Ee,"class","group"),n(qe,"id","module_utils/maths.max"),n(qe,"class","group"),n(Se,"id","module_utils/maths.rfftfreq"),n(Se,"class","group"),n(Ye,"id","module_utils/maths.medianFilter"),n(Ye,"class","group"),n(dl,"id","module_utils/maths.round"),n(dl,"class","group"),n(nl,"id","module_utils/maths..AnyTypedArray"),n(nl,"class","group")},m(t,e){us(document.head,v),r(t,cl,e),r(t,fl,e),r(t,hl,e),r(t,b,e),r(t,Tl,e),p(_,t,e),r(t,yl,e),r(t,x,e),r(t,vl,e),r(t,$,e),r(t,bl,e),r(t,F,e),r(t,_l,e),r(t,xl,e),r(t,$l,e),r(t,A,e),r(t,Fl,e),p(C,t,e),r(t,Al,e),r(t,L,e),r(t,Cl,e),r(t,M,e),r(t,Ll,e),r(t,H,e),r(t,Ml,e),r(t,Hl,e),r(t,wl,e),r(t,w,e),r(t,gl,e),p(g,t,e),r(t,Pl,e),r(t,P,e),r(t,El,e),r(t,E,e),r(t,Rl,e),r(t,R,e),r(t,zl,e),r(t,Dl,e),r(t,kl,e),r(t,z,e),r(t,Ul,e),p(D,t,e),r(t,ql,e),r(t,k,e),r(t,Kl,e),r(t,U,e),r(t,Ol,e),r(t,jl,e),r(t,Bl,e),r(t,q,e),r(t,Il,e),p(K,t,e),r(t,Sl,e),r(t,O,e),r(t,Jl,e),r(t,j,e),r(t,Zl,e),r(t,B,e),r(t,Gl,e),r(t,Nl,e),r(t,Ql,e),r(t,I,e),r(t,Vl,e),p(S,t,e),r(t,Wl,e),r(t,J,e),r(t,Xl,e),r(t,Z,e),r(t,Yl,e),r(t,G,e),r(t,tr,e),r(t,er,e),r(t,lr,e),r(t,N,e),r(t,rr,e),p(Q,t,e),r(t,dr,e),r(t,V,e),r(t,ar,e),r(t,W,e),r(t,or,e),r(t,X,e),r(t,ir,e),r(t,sr,e),r(t,nr,e),r(t,Y,e),r(t,ur,e),p(tt,t,e),r(t,mr,e),r(t,et,e),r(t,fr,e),r(t,lt,e),r(t,pr,e),r(t,rt,e),r(t,cr,e),r(t,dt,e),r(t,hr,e),r(t,Tr,e),r(t,yr,e),r(t,at,e),r(t,vr,e),p(ot,t,e),r(t,br,e),r(t,it,e),r(t,_r,e),r(t,st,e),r(t,xr,e),r(t,nt,e),r(t,$r,e),r(t,ut,e),r(t,Fr,e),r(t,Ar,e),r(t,Cr,e),r(t,mt,e),r(t,Lr,e),p(ft,t,e),r(t,Mr,e),r(t,pt,e),r(t,Hr,e),r(t,ct,e),r(t,wr,e),r(t,ht,e),r(t,gr,e),r(t,Tt,e),r(t,Pr,e),r(t,Er,e),r(t,Rr,e),r(t,yt,e),r(t,zr,e),p(vt,t,e),r(t,Dr,e),r(t,bt,e),r(t,kr,e),r(t,_t,e),r(t,Ur,e),r(t,xt,e),r(t,qr,e),r(t,Kr,e),r(t,Or,e),r(t,$t,e),r(t,jr,e),p(Ft,t,e),r(t,Br,e),r(t,At,e),r(t,Ir,e),r(t,Ct,e),r(t,Sr,e),r(t,Lt,e),r(t,Jr,e),r(t,Zr,e),r(t,Gr,e),r(t,Mt,e),r(t,Nr,e),p(Ht,t,e),r(t,Qr,e),r(t,wt,e),r(t,Vr,e),r(t,gt,e),r(t,Wr,e),r(t,Pt,e),r(t,Xr,e),r(t,Yr,e),r(t,td,e),r(t,Et,e),r(t,ed,e),p(Rt,t,e),r(t,ld,e),r(t,zt,e),r(t,rd,e),r(t,Dt,e),r(t,dd,e),r(t,kt,e),r(t,ad,e),r(t,od,e),r(t,id,e),r(t,Ut,e),r(t,sd,e),p(qt,t,e),r(t,nd,e),r(t,Kt,e),r(t,ud,e),r(t,Ot,e),r(t,md,e),r(t,jt,e),r(t,fd,e),r(t,pd,e),r(t,cd,e),r(t,Bt,e),r(t,hd,e),p(It,t,e),r(t,Td,e),r(t,St,e),r(t,yd,e),r(t,Jt,e),r(t,vd,e),r(t,Zt,e),r(t,bd,e),r(t,_d,e),r(t,xd,e),r(t,Gt,e),r(t,$d,e),p(Nt,t,e),r(t,Fd,e),r(t,Qt,e),r(t,Ad,e),r(t,Vt,e),r(t,Cd,e),r(t,Ld,e),r(t,Md,e),r(t,Wt,e),r(t,Hd,e),p(Xt,t,e),r(t,wd,e),r(t,Yt,e),r(t,gd,e),r(t,te,e),r(t,Pd,e),r(t,ee,e),r(t,Ed,e),r(t,Rd,e),r(t,zd,e),r(t,le,e),r(t,Dd,e),p(re,t,e),r(t,kd,e),r(t,de,e),r(t,Ud,e),r(t,ae,e),r(t,qd,e),r(t,oe,e),r(t,Kd,e),r(t,Od,e),r(t,jd,e),r(t,ie,e),r(t,Bd,e),p(se,t,e),r(t,Id,e),r(t,ne,e),r(t,Sd,e),r(t,ue,e),r(t,Jd,e),r(t,me,e),r(t,Zd,e),r(t,Gd,e),r(t,Nd,e),r(t,fe,e),r(t,Qd,e),p(pe,t,e),r(t,Vd,e),r(t,ce,e),r(t,Wd,e),r(t,he,e),r(t,Xd,e),r(t,Te,e),r(t,Yd,e),r(t,ta,e),r(t,ea,e),r(t,ye,e),r(t,la,e),p(ve,t,e),r(t,ra,e),r(t,be,e),r(t,da,e),r(t,_e,e),r(t,aa,e),r(t,xe,e),r(t,oa,e),r(t,ia,e),r(t,sa,e),r(t,$e,e),r(t,na,e),p(Fe,t,e),r(t,ua,e),r(t,Ae,e),r(t,ma,e),r(t,Ce,e),r(t,fa,e),r(t,Le,e),r(t,pa,e),r(t,ca,e),r(t,ha,e),r(t,Me,e),r(t,Ta,e),p(He,t,e),r(t,ya,e),r(t,we,e),r(t,va,e),r(t,ge,e),r(t,ba,e),r(t,Pe,e),r(t,_a,e),r(t,xa,e),r(t,$a,e),r(t,Ee,e),r(t,Fa,e),p(Re,t,e),r(t,Aa,e),r(t,ze,e),r(t,Ca,e),r(t,De,e),r(t,La,e),r(t,ke,e),r(t,Ma,e),r(t,Ue,e),r(t,Ha,e),r(t,wa,e),r(t,ga,e),r(t,qe,e),r(t,Pa,e),p(Ke,t,e),r(t,Ea,e),r(t,Oe,e),r(t,Ra,e),r(t,je,e),r(t,za,e),r(t,Be,e),r(t,Da,e),r(t,Ie,e),r(t,ka,e),r(t,Ua,e),r(t,qa,e),r(t,Se,e),r(t,Ka,e),p(Je,t,e),r(t,Oa,e),r(t,Ze,e),r(t,ja,e),r(t,Ge,e),r(t,Ba,e),r(t,Ne,e),r(t,Ia,e),r(t,Qe,e),r(t,Sa,e),r(t,Ve,e),r(t,Ja,e),r(t,We,e),r(t,Za,e),p(Xe,t,e),r(t,Ga,e),r(t,Na,e),r(t,Qa,e),r(t,Ye,e),r(t,Va,e),p(tl,t,e),r(t,Wa,e),r(t,el,e),r(t,Xa,e),r(t,ll,e),r(t,Ya,e),r(t,rl,e),r(t,to,e),r(t,eo,e),r(t,lo,e),r(t,dl,e),r(t,ro,e),p(al,t,e),r(t,ao,e),r(t,ol,e),r(t,oo,e),r(t,il,e),r(t,io,e),r(t,sl,e),r(t,so,e),r(t,no,e),r(t,uo,e),r(t,nl,e),r(t,mo,e),p(ul,t,e),r(t,fo,e),r(t,ml,e),r(t,po,e),r(t,co,e),r(t,ho,e),r(t,pl,e),To=!0},p:as,i(t){To||(c(_.$$.fragment,t),c(C.$$.fragment,t),c(g.$$.fragment,t),c(D.$$.fragment,t),c(K.$$.fragment,t),c(S.$$.fragment,t),c(Q.$$.fragment,t),c(tt.$$.fragment,t),c(ot.$$.fragment,t),c(ft.$$.fragment,t),c(vt.$$.fragment,t),c(Ft.$$.fragment,t),c(Ht.$$.fragment,t),c(Rt.$$.fragment,t),c(qt.$$.fragment,t),c(It.$$.fragment,t),c(Nt.$$.fragment,t),c(Xt.$$.fragment,t),c(re.$$.fragment,t),c(se.$$.fragment,t),c(pe.$$.fragment,t),c(ve.$$.fragment,t),c(Fe.$$.fragment,t),c(He.$$.fragment,t),c(Re.$$.fragment,t),c(Ke.$$.fragment,t),c(Je.$$.fragment,t),c(Xe.$$.fragment,t),c(tl.$$.fragment,t),c(al.$$.fragment,t),c(ul.$$.fragment,t),To=!0)},o(t){h(_.$$.fragment,t),h(C.$$.fragment,t),h(g.$$.fragment,t),h(D.$$.fragment,t),h(K.$$.fragment,t),h(S.$$.fragment,t),h(Q.$$.fragment,t),h(tt.$$.fragment,t),h(ot.$$.fragment,t),h(ft.$$.fragment,t),h(vt.$$.fragment,t),h(Ft.$$.fragment,t),h(Ht.$$.fragment,t),h(Rt.$$.fragment,t),h(qt.$$.fragment,t),h(It.$$.fragment,t),h(Nt.$$.fragment,t),h(Xt.$$.fragment,t),h(re.$$.fragment,t),h(se.$$.fragment,t),h(pe.$$.fragment,t),h(ve.$$.fragment,t),h(Fe.$$.fragment,t),h(He.$$.fragment,t),h(Re.$$.fragment,t),h(Ke.$$.fragment,t),h(Je.$$.fragment,t),h(Xe.$$.fragment,t),h(tl.$$.fragment,t),h(al.$$.fragment,t),h(ul.$$.fragment,t),To=!1},d(t){t&&(l(cl),l(fl),l(hl),l(b),l(Tl),l(yl),l(x),l(vl),l($),l(bl),l(F),l(_l),l(xl),l($l),l(A),l(Fl),l(Al),l(L),l(Cl),l(M),l(Ll),l(H),l(Ml),l(Hl),l(wl),l(w),l(gl),l(Pl),l(P),l(El),l(E),l(Rl),l(R),l(zl),l(Dl),l(kl),l(z),l(Ul),l(ql),l(k),l(Kl),l(U),l(Ol),l(jl),l(Bl),l(q),l(Il),l(Sl),l(O),l(Jl),l(j),l(Zl),l(B),l(Gl),l(Nl),l(Ql),l(I),l(Vl),l(Wl),l(J),l(Xl),l(Z),l(Yl),l(G),l(tr),l(er),l(lr),l(N),l(rr),l(dr),l(V),l(ar),l(W),l(or),l(X),l(ir),l(sr),l(nr),l(Y),l(ur),l(mr),l(et),l(fr),l(lt),l(pr),l(rt),l(cr),l(dt),l(hr),l(Tr),l(yr),l(at),l(vr),l(br),l(it),l(_r),l(st),l(xr),l(nt),l($r),l(ut),l(Fr),l(Ar),l(Cr),l(mt),l(Lr),l(Mr),l(pt),l(Hr),l(ct),l(wr),l(ht),l(gr),l(Tt),l(Pr),l(Er),l(Rr),l(yt),l(zr),l(Dr),l(bt),l(kr),l(_t),l(Ur),l(xt),l(qr),l(Kr),l(Or),l($t),l(jr),l(Br),l(At),l(Ir),l(Ct),l(Sr),l(Lt),l(Jr),l(Zr),l(Gr),l(Mt),l(Nr),l(Qr),l(wt),l(Vr),l(gt),l(Wr),l(Pt),l(Xr),l(Yr),l(td),l(Et),l(ed),l(ld),l(zt),l(rd),l(Dt),l(dd),l(kt),l(ad),l(od),l(id),l(Ut),l(sd),l(nd),l(Kt),l(ud),l(Ot),l(md),l(jt),l(fd),l(pd),l(cd),l(Bt),l(hd),l(Td),l(St),l(yd),l(Jt),l(vd),l(Zt),l(bd),l(_d),l(xd),l(Gt),l($d),l(Fd),l(Qt),l(Ad),l(Vt),l(Cd),l(Ld),l(Md),l(Wt),l(Hd),l(wd),l(Yt),l(gd),l(te),l(Pd),l(ee),l(Ed),l(Rd),l(zd),l(le),l(Dd),l(kd),l(de),l(Ud),l(ae),l(qd),l(oe),l(Kd),l(Od),l(jd),l(ie),l(Bd),l(Id),l(ne),l(Sd),l(ue),l(Jd),l(me),l(Zd),l(Gd),l(Nd),l(fe),l(Qd),l(Vd),l(ce),l(Wd),l(he),l(Xd),l(Te),l(Yd),l(ta),l(ea),l(ye),l(la),l(ra),l(be),l(da),l(_e),l(aa),l(xe),l(oa),l(ia),l(sa),l($e),l(na),l(ua),l(Ae),l(ma),l(Ce),l(fa),l(Le),l(pa),l(ca),l(ha),l(Me),l(Ta),l(ya),l(we),l(va),l(ge),l(ba),l(Pe),l(_a),l(xa),l($a),l(Ee),l(Fa),l(Aa),l(ze),l(Ca),l(De),l(La),l(ke),l(Ma),l(Ue),l(Ha),l(wa),l(ga),l(qe),l(Pa),l(Ea),l(Oe),l(Ra),l(je),l(za),l(Be),l(Da),l(Ie),l(ka),l(Ua),l(qa),l(Se),l(Ka),l(Oa),l(Ze),l(ja),l(Ge),l(Ba),l(Ne),l(Ia),l(Qe),l(Sa),l(Ve),l(Ja),l(We),l(Za),l(Ga),l(Na),l(Qa),l(Ye),l(Va),l(Wa),l(el),l(Xa),l(ll),l(Ya),l(rl),l(to),l(eo),l(lo),l(dl),l(ro),l(ao),l(ol),l(oo),l(il),l(io),l(sl),l(so),l(no),l(uo),l(nl),l(mo),l(fo),l(ml),l(po),l(co),l(ho),l(pl)),l(v),T(_,t),T(C,t),T(g,t),T(D,t),T(K,t),T(S,t),T(Q,t),T(tt,t),T(ot,t),T(ft,t),T(vt,t),T(Ft,t),T(Ht,t),T(Rt,t),T(qt,t),T(It,t),T(Nt,t),T(Xt,t),T(re,t),T(se,t),T(pe,t),T(ve,t),T(Fe,t),T(He,t),T(Re,t),T(Ke,t),T(Je,t),T(Xe,t),T(tl,t),T(al,t),T(ul,t)}}}const ps='{"title":"utils/maths","local":"utilsmaths","sections":[{"title":"utils/maths.FFT","local":"utilsmathsfft","sections":[{"title":"new FFT(size)","local":"new-fftsize","sections":[],"depth":3},{"title":"ffT.createComplexArray() ⇒ <code> Float32Array </code>","local":"fftcreatecomplexarray--code-float32array-code","sections":[],"depth":3},{"title":"ffT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>","local":"fftfromcomplexarraycomplex-storage--code-array--number--code","sections":[],"depth":3},{"title":"ffT.toComplexArray(input, [storage]) ⇒ <code> Float32Array </code>","local":"ffttocomplexarrayinput-storage--code-float32array-code","sections":[],"depth":3},{"title":"ffT.completeSpectrum(spectrum) ⇒ <code> void </code>","local":"fftcompletespectrumspectrum--code-void-code","sections":[],"depth":3},{"title":"ffT.transform(out, data) ⇒ <code> void </code>","local":"ffttransformout-data--code-void-code","sections":[],"depth":3},{"title":"ffT.realTransform(out, data)","local":"fftrealtransformout-data","sections":[],"depth":3},{"title":"ffT.inverseTransform(out, data) ⇒ <code> void </code>","local":"fftinversetransformout-data--code-void-code","sections":[],"depth":3},{"title":"ffT._transform4(out, data, inv) ⇒ <code> void </code>","local":"ffttransform4out-data-inv--code-void-code","sections":[],"depth":3},{"title":"ffT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"fftsingletransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"ffT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>","local":"fftsingletransform4data-out-outoff-off-step-inv--code-void-code","sections":[],"depth":3},{"title":"ffT._realTransform4(out, data, inv)","local":"fftrealtransform4out-data-inv","sections":[],"depth":3},{"title":"ffT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"fftsinglerealtransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"ffT._singleRealTransform4(data, out, outOff, off, step, inv)","local":"fftsinglerealtransform4data-out-outoff-off-step-inv","sections":[],"depth":3}],"depth":2},{"title":"utils/maths.interpolate_data(input)","local":"utilsmathsinterpolatedatainput","sections":[],"depth":2},{"title":"utils/maths.transpose_data(array, dims, axes) ⇒ <code> * </code>","local":"utilsmathstransposedataarray-dims-axes--code--code","sections":[],"depth":2},{"title":"utils/maths.softmax(arr) ⇒ <code> Array. < number > </code>","local":"utilsmathssoftmaxarr--code-array--number--code","sections":[],"depth":2},{"title":"utils/maths.log_softmax(arr) ⇒ <code> any </code>","local":"utilsmathslogsoftmaxarr--code-any-code","sections":[],"depth":2},{"title":"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathsdotarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.getTopItems(items, [top_k]) ⇒ <code> Array </code>","local":"utilsmathsgettopitemsitems-topk--code-array-code","sections":[],"depth":2},{"title":"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathscossimarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.magnitude(arr) ⇒ <code> number </code>","local":"utilsmathsmagnitudearr--code-number-code","sections":[],"depth":2},{"title":"utils/maths.min(arr) ⇒ <code> Array. < number > </code>","local":"utilsmathsminarr--code-array--number--code","sections":[],"depth":2},{"title":"utils/maths.max(arr) ⇒ <code> Array. < number > </code>","local":"utilsmathsmaxarr--code-array--number--code","sections":[],"depth":2},{"title":"utils/maths.rfftfreq(n, [d]) ⇒ <code> Array. < number > </code>","local":"utilsmathsrfftfreqn-d--code-array--number--code","sections":[],"depth":2},{"title":"utils/maths.medianFilter(data, windowSize)","local":"utilsmathsmedianfilterdata-windowsize","sections":[],"depth":2},{"title":"utils/maths.round(num, decimals) ⇒ <code> number </code>","local":"utilsmathsroundnum-decimals--code-number-code","sections":[],"depth":2},{"title":"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>","local":"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code","sections":[],"depth":2}],"depth":1}';function cs(yo){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends is{constructor(v){super(),ss(this,v,cs,fs,ds,{})}}export{bs as component};
