import{s as bw,n as xw,o as Cw}from"../chunks/scheduler.b108d059.js";import{S as gw,i as Iw,g as a,s as i,r as c,A as kw,h as p,f as l,c as n,j as J,u as M,x as o,k as d,y as Gw,a as s,v as r,d as T,t as m,w as y}from"../chunks/index.008de539.js";import{C as u}from"../chunks/CodeBlock.3968c746.js";import{H as h}from"../chunks/Heading.88bfeb84.js";function Qw(Ny){let w,ua,Ja,wa,j,ja,U,Ua,f,Ay="Pipelines provide a high-level, easy to use, API for running machine learning models.",fa,b,vy="<strong>Example:</strong> Instantiate pipeline using the <code>pipeline</code> function.",ba,x,xa,C,_y='<li><a href="#module_pipelines">pipelines</a><ul><li><em>static</em><ul><li><a href="#module_pipelines.Pipeline">.Pipeline</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_pipelines.Pipeline_new"><code>new Pipeline(options)</code></a></li> <li><a href="#module_pipelines.Pipeline+dispose"><code>.dispose()</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li> <li><a href="#module_pipelines.Pipeline+_call"><code>._call(texts, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.TextClassificationPipeline">.TextClassificationPipeline</a><ul><li><a href="#module_pipelines.TextClassificationPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.TokenClassificationPipeline">.TokenClassificationPipeline</a><ul><li><a href="#module_pipelines.TokenClassificationPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.QuestionAnsweringPipeline">.QuestionAnsweringPipeline</a><ul><li><a href="#module_pipelines.QuestionAnsweringPipeline+_call"><code>._call(question, context, options)</code></a> ⇒ <code>QuestionAnsweringReturnType</code></li></ul></li> <li><a href="#module_pipelines.FillMaskPipeline">.FillMaskPipeline</a><ul><li><a href="#module_pipelines.FillMaskPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.Text2TextGenerationPipeline">.Text2TextGenerationPipeline</a><ul><li><a href="#module_pipelines.Text2TextGenerationPipeline+_call"><code>._call(texts, [options])</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.SummarizationPipeline">.SummarizationPipeline</a></li> <li><a href="#module_pipelines.TranslationPipeline">.TranslationPipeline</a></li> <li><a href="#module_pipelines.TextGenerationPipeline">.TextGenerationPipeline</a><ul><li><a href="#module_pipelines.TextGenerationPipeline+_call"><code>._call(texts, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline">.ZeroShotClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotClassificationPipeline_new"><code>new ZeroShotClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+_call"><code>._call(texts, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.FeatureExtractionPipeline">.FeatureExtractionPipeline</a><ul><li><a href="#module_pipelines.FeatureExtractionPipeline+_call"><code>._call(texts, options)</code></a> ⇒</li></ul></li> <li><a href="#module_pipelines.AudioClassificationPipeline">.AudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.AudioClassificationPipeline_new"><code>new AudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.AudioClassificationPipeline+_call"><code>._call(audio, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline">.AutomaticSpeechRecognitionPipeline</a><ul><li><a href="#new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"><code>new AutomaticSpeechRecognitionPipeline(options)</code></a></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline+_call"><code>._call(audio, [kwargs])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageToTextPipeline">.ImageToTextPipeline</a><ul><li><a href="#new_module_pipelines.ImageToTextPipeline_new"><code>new ImageToTextPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToTextPipeline+_call"><code>._call(images, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageClassificationPipeline">.ImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ImageClassificationPipeline_new"><code>new ImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageClassificationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageSegmentationPipeline">.ImageSegmentationPipeline</a><ul><li><a href="#new_module_pipelines.ImageSegmentationPipeline_new"><code>new ImageSegmentationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageSegmentationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;Array&gt;</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline">.ZeroShotImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotImageClassificationPipeline_new"><code>new ZeroShotImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ObjectDetectionPipeline">.ObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ObjectDetectionPipeline_new"><code>new ObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ObjectDetectionPipeline+_call"><code>._call(images, options)</code></a></li></ul></li> <li><a href="#module_pipelines.ZeroShotObjectDetectionPipeline">.ZeroShotObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotObjectDetectionPipeline_new"><code>new ZeroShotObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotObjectDetectionPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline">.DocumentQuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.DocumentQuestionAnsweringPipeline_new"><code>new DocumentQuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline+_call"><code>._call(image, question, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.TextToAudioPipeline">.TextToAudioPipeline</a><ul><li><a href="#new_module_pipelines.TextToAudioPipeline_new"><code>new TextToAudioPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextToAudioPipeline+_call"><code>._call(text_inputs, options)</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageToImagePipeline">.ImageToImagePipeline</a><ul><li><a href="#module_pipelines.ImageToImagePipeline+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.DepthEstimationPipeline">.DepthEstimationPipeline</a><ul><li><a href="#module_pipelines.DepthEstimationPipeline+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.pipeline"><code>.pipeline(task, [model], [options])</code></a> ⇒ <code>Promise.&lt;Pipeline&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_pipelines..QuestionAnsweringResult"><code>~QuestionAnsweringResult</code></a> : <code>object</code></li> <li><a href="#module_pipelines..QuestionAnsweringReturnType"><code>~QuestionAnsweringReturnType</code></a> : <code>Promise.&lt;(QuestionAnsweringResult|Array&lt;QuestionAnsweringResult&gt;)&gt;</code></li> <li><a href="#module_pipelines..ChunkCallback"><code>~ChunkCallback</code></a> : <code>function</code></li></ul></li></ul></li>',Ca,ga,Ia,g,ka,I,Ga,k,Ry=`The Pipeline class is the class from which all pipelines inherit.
Refer to this class for methods shared across different pipelines.`,Qa,G,Yy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',Ba,Q,$y='<li><a href="#module_pipelines.Pipeline">.Pipeline</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_pipelines.Pipeline_new"><code>new Pipeline(options)</code></a></li> <li><a href="#module_pipelines.Pipeline+dispose"><code>.dispose()</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li> <li><a href="#module_pipelines.Pipeline+_call"><code>._call(texts, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',Za,Na,Aa,B,va,Z,_a,N,Vy="Create a new Pipeline.",Ra,A,Ey="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><code></code></td><td><p>The tokenizer to use (if any).</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><code></code></td><td><p>The processor to use (if any).</p></td></tr></tbody>",Ya,$a,Va,v,Ea,_,Pa,R,Py="Disposes the model.",Ha,Y,Hy='<strong>Kind</strong>: instance method of <a href="#module_pipelines.Pipeline"><code>Pipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;void&gt;</code> - A promise that resolves when the model has been disposed.',za,Wa,Sa,$,Xa,V,La,E,zy="Executes the task associated with the pipeline.",Da,P,Wy='<strong>Kind</strong>: instance method of <a href="#module_pipelines.Pipeline"><code>Pipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A promise that resolves to an array containing the inputs and outputs of the task.',Fa,H,Sy="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td><p>The input texts to be processed.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",qa,Oa,Ka,z,ep,W,tp,S,Xy="Text classification pipeline using any <code>ModelForSequenceClassification</code>.",lp,X,Ly="<strong>Example:</strong> Sentiment-analysis w/ <code>Xenova/distilbert-base-uncased-finetuned-sst-2-english</code>.",sp,L,ip,D,Dy="<strong>Example:</strong> Multilingual sentiment-analysis w/ <code>Xenova/bert-base-multilingual-uncased-sentiment</code> (and return top 5 classes).",np,F,ap,q,Fy="<strong>Example:</strong> Toxic comment classification w/ <code>Xenova/toxic-bert</code> (and return all classes).",pp,O,op,K,qy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',dp,cp,Mp,ee,rp,te,Tp,le,Oy="Executes the text classification task.",mp,se,Ky='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextClassificationPipeline"><code>TextClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',yp,ie,eJ="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The input texts to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",Jp,hp,up,ne,wp,ae,jp,pe,tJ="Named Entity Recognition pipeline using any <code>ModelForTokenClassification</code>.",Up,oe,lJ="<strong>Example:</strong> Perform named entity recognition with <code>Xenova/bert-base-NER</code>.",fp,de,bp,ce,sJ="<strong>Example:</strong> Perform named entity recognition with <code>Xenova/bert-base-NER</code> (and return all labels).",xp,Me,Cp,re,iJ='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',gp,Ip,kp,Te,Gp,me,Qp,ye,nJ="Executes the token classification task.",Bp,Je,aJ='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TokenClassificationPipeline"><code>TokenClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',Zp,he,pJ="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td><p>The input texts to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>An optional object containing the following properties:</p></td></tr></tbody>",Np,Ap,vp,ue,_p,we,Rp,je,oJ="Question Answering pipeline using any <code>ModelForQuestionAnswering</code>.",Yp,Ue,dJ="<strong>Example:</strong> Run question answering with <code>Xenova/distilbert-base-uncased-distilled-squad</code>.",$p,fe,Vp,be,cJ='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Ep,Pp,Hp,xe,zp,Ce,Wp,ge,MJ="Executes the question answering task.",Sp,Ie,rJ=`<strong>Kind</strong>: instance method of <a href="#module_pipelines.QuestionAnsweringPipeline"><code>QuestionAnsweringPipeline</code></a><br/> <strong>Returns</strong>: <code>QuestionAnsweringReturnType</code> - A promise that resolves to an array or object
containing the predicted answers and scores.`,Xp,ke,TJ="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>question</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The question(s) to be answered.</p></td> </tr><tr><td>context</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The context(s) where the answer(s) can be found.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top answer predictions to be returned.</p></td></tr></tbody>",Lp,Dp,Fp,Ge,qp,Qe,Op,Be,mJ="Masked language modeling prediction pipeline using any <code>ModelWithLMHead</code>.",Kp,Ze,yJ="<strong>Example:</strong> Perform masked language modelling (a.k.a. “fill-mask”) with <code>Xenova/bert-base-uncased</code>.",eo,Ne,to,Ae,JJ="<strong>Example:</strong> Perform masked language modelling (a.k.a. “fill-mask”) with <code>Xenova/bert-base-cased</code> (and return top result).",lo,ve,so,_e,hJ='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',io,no,ao,Re,po,Ye,oo,$e,uJ="Fill the masked token in the text(s) given as inputs.",co,Ve,wJ='<strong>Kind</strong>: instance method of <a href="#module_pipelines.FillMaskPipeline"><code>FillMaskPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted tokens and scores.',Mo,Ee,jJ="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The masked input texts.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",ro,To,mo,Pe,yo,He,Jo,ze,UJ="Text2TextGenerationPipeline class for generating text using a model that performs text-to-text generation tasks.",ho,We,fJ="<strong>Example:</strong> Text-to-text generation w/ <code>Xenova/LaMini-Flan-T5-783M</code>.",uo,Se,wo,Xe,bJ='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',jo,Uo,fo,Le,bo,De,xo,Fe,xJ="Fill the masked token in the text(s) given as inputs.",Co,qe,CJ=`<strong>Kind</strong>: instance method of <a href="#module_pipelines.Text2TextGenerationPipeline"><code>Text2TextGenerationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An array of objects containing the score, predicted token, predicted token string,
and the sequence with the predicted token filled in, or an array of such arrays (one for each input text).
If only one input text is given, the output will be an array of objects.<br/> <strong>Throws</strong>:`,go,Oe,gJ="<li><code>Error</code> When the mask token is not found in the input text.</li>",Io,Ke,IJ="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The text or array of texts to be processed.</p></td> </tr><tr><td>[options]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Options for the fill-mask pipeline.</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top-k predictions to return.</p></td></tr></tbody>",ko,Go,Qo,et,Bo,tt,Zo,lt,kJ="A pipeline for summarization tasks, inheriting from Text2TextGenerationPipeline.",No,st,GJ="<strong>Example:</strong> Summarization w/ <code>Xenova/distilbart-cnn-6-6</code>.",Ao,it,vo,nt,QJ='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',_o,Ro,Yo,at,$o,pt,Vo,ot,BJ="Translates text from one language to another.",Eo,dt,ZJ="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/nllb-200-distilled-600M</code>.",Po,ct,NJ=`See <a href="https://github.com/facebookresearch/flores/blob/main/flores200/README.md#languages-in-flores-200" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,Ho,Mt,zo,rt,AJ="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/m2m100_418M</code>.",Wo,Tt,vJ=`See <a href="https://huggingface.co/facebook/m2m100_418M#languages-covered" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,So,mt,Xo,yt,_J="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/mbart-large-50-many-to-many-mmt</code>.",Lo,Jt,RJ=`See <a href="https://huggingface.co/facebook/mbart-large-50-many-to-many-mmt#languages-covered" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,Do,ht,Fo,ut,YJ='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',qo,Oo,Ko,wt,ed,jt,td,Ut,$J=`Language generation pipeline using any <code>ModelWithLMHead</code> or <code>ModelForCausalLM</code>.
This pipeline predicts the words that will follow a specified text prompt.
NOTE: For the full list of generation parameters, see <a href="./utils/generation#module_utils/generation.GenerationConfig"><code>GenerationConfig</code></a>.`,ld,ft,VJ="<strong>Example:</strong> Text generation with <code>Xenova/distilgpt2</code> (default settings).",sd,bt,id,xt,EJ="<strong>Example:</strong> Text generation with <code>Xenova/distilgpt2</code> (custom settings).",nd,Ct,ad,gt,PJ="<strong>Example:</strong> Run code generation with <code>Xenova/codegen-350M-mono</code>.",pd,It,od,kt,HJ='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',dd,cd,Md,Gt,rd,Qt,Td,Bt,zJ="Generates text based on an input prompt.",md,Zt,WJ='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextGenerationPipeline"><code>TextGenerationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - The generated text or texts.',yd,Nt,SJ="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The input prompt or prompts to generate text from.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Additional arguments for text generation.</p></td></tr></tbody>",Jd,hd,ud,At,wd,vt,jd,_t,XJ=`NLI-based zero-shot classification pipeline using a <code>ModelForSequenceClassification</code>
trained on NLI (natural language inference) tasks. Equivalent of <code>text-classification</code>
pipelines, but these models don’t require a hardcoded number of potential classes, they
can be chosen at runtime. It usually means it’s slower but it is <strong>much</strong> more flexible.`,Ud,Rt,LJ="<strong>Example:</strong> Zero shot classification with <code>Xenova/mobilebert-uncased-mnli</code>.",fd,Yt,bd,$t,DJ="<strong>Example:</strong> Zero shot classification with <code>Xenova/nli-deberta-v3-xsmall</code> (multi-label).",xd,Vt,Cd,Et,FJ='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',gd,Pt,qJ='<li><a href="#module_pipelines.ZeroShotClassificationPipeline">.ZeroShotClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotClassificationPipeline_new"><code>new ZeroShotClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+_call"><code>._call(texts, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',Id,kd,Gd,Ht,Qd,zt,Bd,Wt,OJ="Create a new ZeroShotClassificationPipeline.",Zd,St,KJ="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td></tr></tbody>",Nd,Ad,vd,Xt,_d,Lt,Rd,Dt,eh='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotClassificationPipeline"><code>ZeroShotClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - The prediction(s), as a map (or list of maps) from label to score.',Yd,Ft,th=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>Array.&lt;any&gt;</code></td><td></td><td></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td></td><td></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options:</p></td> </tr><tr><td>[options.hypothesis_template]</td><td><code>string</code></td><td><code>&quot;&quot;This example is {}.&quot;&quot;</code></td><td><p>The template used to turn each
candidate label into an NLI-style hypothesis. The candidate label will replace the &amp;#123;} placeholder.</p></td> </tr><tr><td>[options.multi_label]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not multiple candidate labels can be true.
If <code>false</code>, the scores are normalized such that the sum of the label likelihoods for each sequence
is 1. If <code>true</code>, the labels are considered independent and probabilities are normalized for each
candidate by doing a softmax of the entailment score vs. the contradiction score.</p></td></tr></tbody>`,$d,Vd,Ed,qt,Pd,Ot,Hd,Kt,lh=`Feature extraction pipeline using no model head. This pipeline extracts the hidden
states from the base transformer, which can be used as features in downstream tasks.`,zd,el,sh="<strong>Example:</strong> Run feature extraction with <code>bert-base-uncased</code> (without pooling/normalization).",Wd,tl,Sd,ll,ih="<strong>Example:</strong> Run feature extraction with <code>bert-base-uncased</code> (with pooling/normalization).",Xd,sl,Ld,il,nh="<strong>Example:</strong> Calculating embeddings with <code>sentence-transformers</code> models.",Dd,nl,Fd,al,ah='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',qd,Od,Kd,pl,ec,ol,tc,dl,ph="Extract the features of the input(s).",lc,cl,oh='<strong>Kind</strong>: instance method of <a href="#module_pipelines.FeatureExtractionPipeline"><code>FeatureExtractionPipeline</code></a><br/> <strong>Returns</strong>: The features computed by the model.',sc,Ml,dh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The input texts</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options:</p></td> </tr><tr><td>[options.pooling]</td><td><code>string</code></td><td><code>&quot;&quot;none&quot;&quot;</code></td><td><p>The pooling method to use. Can be one of: &quot;none&quot;, &quot;mean&quot;.</p></td> </tr><tr><td>[options.normalize]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to normalize the embeddings in the last dimension.</p></td></tr></tbody>",ic,nc,ac,rl,pc,Tl,oc,ml,ch=`Audio classification pipeline using any <code>AutoModelForAudioClassification</code>.
This pipeline predicts the class of a raw waveform or an audio file.`,dc,yl,Mh="<strong>Example:</strong> Perform audio classification.",cc,Jl,Mc,hl,rh='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',rc,ul,Th='<li><a href="#module_pipelines.AudioClassificationPipeline">.AudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.AudioClassificationPipeline_new"><code>new AudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.AudioClassificationPipeline+_call"><code>._call(audio, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li>',Tc,mc,yc,wl,Jc,jl,hc,Ul,mh="Create a new AudioClassificationPipeline.",uc,fl,yh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",wc,jc,Uc,bl,fc,xl,bc,Cl,Jh="Executes the audio classification task.",xc,gl,hh='<strong>Kind</strong>: instance method of <a href="#module_pipelines.AudioClassificationPipeline"><code>AudioClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',Cc,Il,uh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td></td><td><p>The input audio files to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",gc,Ic,kc,kl,Gc,Gl,Qc,Ql,wh="Pipeline that aims at extracting spoken text contained within some audio.",Bc,Bl,jh="<strong>Example:</strong> Transcribe English.",Zc,Zl,Nc,Nl,Uh="<strong>Example:</strong> Transcribe English w/ timestamps.",Ac,Al,vc,vl,fh="<strong>Example:</strong> Transcribe English w/ word-level timestamps.",_c,_l,Rc,Rl,bh="<strong>Example:</strong> Transcribe French.",Yc,Yl,$c,$l,xh="<strong>Example:</strong> Translate French to English.",Vc,Vl,Ec,El,Ch="<strong>Example:</strong> Transcribe/translate audio longer than 30 seconds.",Pc,Pl,Hc,Hl,gh='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',zc,zl,Ih='<li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline">.AutomaticSpeechRecognitionPipeline</a><ul><li><a href="#new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"><code>new AutomaticSpeechRecognitionPipeline(options)</code></a></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline+_call"><code>._call(audio, [kwargs])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',Wc,Sc,Xc,Wl,Lc,Sl,Dc,Xl,kh="Create a new AutomaticSpeechRecognitionPipeline.",Fc,Ll,Gh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",qc,Oc,Kc,Dl,eM,Fl,tM,ql,Qh="Asynchronously processes audio and generates text transcription using the model.",lM,Ol,Bh='<strong>Kind</strong>: instance method of <a href="#module_pipelines.AutomaticSpeechRecognitionPipeline"><code>AutomaticSpeechRecognitionPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - A Promise that resolves to an object containing the transcription text and optionally timestamps if <code>return_timestamps</code> is <code>true</code>.',sM,Kl,Zh=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>Float32Array</code> | <code>Array&lt;Float32Array&gt;</code></td><td></td><td><p>The audio to be transcribed. Can be a single Float32Array or an array of Float32Arrays.</p></td> </tr><tr><td>[kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional arguments.</p></td> </tr><tr><td>[kwargs.return_timestamps]</td><td><code>boolean</code> | <code>&#39;word&#39;</code></td><td></td><td><p>Whether to return timestamps or not. Default is <code>false</code>.</p></td> </tr><tr><td>[kwargs.chunk_length_s]</td><td><code>number</code></td><td></td><td><p>The length of audio chunks to process in seconds. Default is 0 (no chunking).</p></td> </tr><tr><td>[kwargs.stride_length_s]</td><td><code>number</code></td><td></td><td><p>The length of overlap between consecutive audio chunks in seconds. If not provided, defaults to <code>chunk_length_s / 6</code>.</p></td> </tr><tr><td>[kwargs.chunk_callback]</td><td><code>ChunkCallback</code></td><td></td><td><p>Callback function to be called with each chunk processed.</p></td> </tr><tr><td>[kwargs.force_full_sequences]</td><td><code>boolean</code></td><td></td><td><p>Whether to force outputting full sequences or not. Default is <code>false</code>.</p></td> </tr><tr><td>[kwargs.language]</td><td><code>string</code></td><td></td><td><p>The source language. Default is <code>null</code>, meaning it should be auto-detected. Use this to potentially improve performance if the source language is known.</p></td> </tr><tr><td>[kwargs.task]</td><td><code>string</code></td><td></td><td><p>The task to perform. Default is <code>null</code>, meaning it should be auto-detected.</p></td> </tr><tr><td>[kwargs.forced_decoder_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td></td><td><p>A list of pairs of integers which indicates a mapping from generation indices to token indices
that will be forced before sampling. For example, [[1, 123]] means the second generated token will always be a token of index 123.</p></td></tr></tbody>`,iM,nM,aM,es,pM,ts,oM,ls,Nh="Image To Text pipeline using a <code>AutoModelForVision2Seq</code>. This pipeline predicts a caption for a given image.",dM,ss,Ah="<strong>Example:</strong> Generate a caption for an image w/ <code>Xenova/vit-gpt2-image-captioning</code>.",cM,is,MM,ns,vh="<strong>Example:</strong> Optical Character Recognition (OCR) w/ <code>Xenova/trocr-small-handwritten</code>.",rM,as,TM,ps,_h='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',mM,os,Rh='<li><a href="#module_pipelines.ImageToTextPipeline">.ImageToTextPipeline</a><ul><li><a href="#new_module_pipelines.ImageToTextPipeline_new"><code>new ImageToTextPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToTextPipeline+_call"><code>._call(images, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',yM,JM,hM,ds,uM,cs,wM,Ms,Yh="Create a new ImageToTextPipeline.",jM,rs,$h="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",UM,fM,bM,Ts,xM,ms,CM,ys,Vh="Assign labels to the image(s) passed as inputs.",gM,Js,Eh='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageToTextPipeline"><code>ImageToTextPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - A Promise that resolves to an object (or array of objects) containing the generated text(s).',IM,hs,Ph="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;any&gt;</code></td><td></td><td><p>The images to be captioned.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional generation arguments.</p></td></tr></tbody>",kM,GM,QM,us,BM,ws,ZM,js,Hh=`Image classification pipeline using any <code>AutoModelForImageClassification</code>.
This pipeline predicts the class of an image.`,NM,Us,zh="<strong>Example:</strong> Classify an image.",AM,fs,vM,bs,Wh="<strong>Example:</strong> Classify an image and return top <code>n</code> classes.",_M,xs,RM,Cs,Sh="<strong>Example:</strong> Classify an image and return all classes.",YM,gs,$M,Is,Xh='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',VM,ks,Lh='<li><a href="#module_pipelines.ImageClassificationPipeline">.ImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ImageClassificationPipeline_new"><code>new ImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageClassificationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',EM,PM,HM,Gs,zM,Qs,WM,Bs,Dh="Create a new ImageClassificationPipeline.",SM,Zs,Fh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",XM,LM,DM,Ns,FM,As,qM,vs,qh="Classify the given images.",OM,_s,Oh='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageClassificationPipeline"><code>ImageClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - The top classification results for the images.',KM,Rs,Kh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>any</code></td><td></td><td><p>The images to classify.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options to use for classification.</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top results to return.</p></td></tr></tbody>",er,tr,lr,Ys,sr,$s,ir,Vs,eu=`Image segmentation pipeline using any <code>AutoModelForXXXSegmentation</code>.
This pipeline predicts masks of objects and their classes.`,nr,Es,tu="<strong>Example:</strong> Perform image segmentation with <code>Xenova/detr-resnet-50-panoptic</code>.",ar,Ps,pr,Hs,lu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',or,zs,su='<li><a href="#module_pipelines.ImageSegmentationPipeline">.ImageSegmentationPipeline</a><ul><li><a href="#new_module_pipelines.ImageSegmentationPipeline_new"><code>new ImageSegmentationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageSegmentationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;Array&gt;</code></li></ul></li>',dr,cr,Mr,Ws,rr,Ss,Tr,Xs,iu="Create a new ImageSegmentationPipeline.",mr,Ls,nu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",yr,Jr,hr,Ds,ur,Fs,wr,qs,au="Segment the input images.",jr,Os,pu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageSegmentationPipeline"><code>ImageSegmentationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Array&gt;</code> - The annotated segments.',Ur,Ks,ou="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array</code></td><td></td><td><p>The input images.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options to use for segmentation.</p></td> </tr><tr><td>[options.threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Probability threshold to filter out predicted masks.</p></td> </tr><tr><td>[options.mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[options.overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>Mask overlap threshold to eliminate small, disconnected segments.</p></td> </tr><tr><td>[options.subtask]</td><td><code>null</code> | <code>string</code></td><td><code></code></td><td><p>Segmentation task to be performed. One of [<code>panoptic</code>, <code>instance</code>, and <code>semantic</code>], depending on model capabilities. If not set, the pipeline will attempt to resolve (in that order).</p></td> </tr><tr><td>[options.label_ids_to_fuse]</td><td><code>Array</code></td><td><code></code></td><td><p>List of label ids to fuse. If not set, do not fuse any labels.</p></td> </tr><tr><td>[options.target_sizes]</td><td><code>Array</code></td><td><code></code></td><td><p>List of target sizes for the input images. If not set, use the original image sizes.</p></td></tr></tbody>",fr,br,xr,ei,Cr,ti,gr,li,du=`Zero shot image classification pipeline. This pipeline predicts the class of
an image when you provide an image and a set of <code>candidate_labels</code>.`,Ir,si,cu="<strong>Example:</strong> Zero shot image classification w/ <code>Xenova/clip-vit-base-patch32</code>.",kr,ii,Gr,ni,Mu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Qr,ai,ru='<li><a href="#module_pipelines.ZeroShotImageClassificationPipeline">.ZeroShotImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotImageClassificationPipeline_new"><code>new ZeroShotImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',Br,Zr,Nr,pi,Ar,oi,vr,di,Tu="Create a new ZeroShotImageClassificationPipeline.",_r,ci,mu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",Rr,Yr,$r,Mi,Vr,ri,Er,Ti,yu="Classify the input images with candidate labels using a zero-shot approach.",Pr,mi,Ju='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotImageClassificationPipeline"><code>ZeroShotImageClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An array of classifications for each input image or a single classification object if only one input image is provided.',Hr,yi,hu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array</code></td><td><p>The input images.</p></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td><p>The candidate labels.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>The options for the classification.</p></td> </tr><tr><td>[options.hypothesis_template]</td><td><code>string</code></td><td><p>The hypothesis template to use for zero-shot classification. Default: &quot;This is a photo of &amp;#123;}&quot;.</p></td></tr></tbody>",zr,Wr,Sr,Ji,Xr,hi,Lr,ui,uu=`Object detection pipeline using any <code>AutoModelForObjectDetection</code>.
This pipeline predicts bounding boxes of objects and their classes.`,Dr,wi,wu="<strong>Example:</strong> Run object-detection with <code>facebook/detr-resnet-50</code>.",Fr,ji,qr,Ui,ju='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Or,fi,Uu='<li><a href="#module_pipelines.ObjectDetectionPipeline">.ObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ObjectDetectionPipeline_new"><code>new ObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ObjectDetectionPipeline+_call"><code>._call(images, options)</code></a></li></ul></li>',Kr,eT,tT,bi,lT,xi,sT,Ci,fu="Create a new ObjectDetectionPipeline.",iT,gi,bu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",nT,aT,pT,Ii,oT,ki,dT,Gi,xu="Detect objects (bounding boxes & classes) in the image(s) passed as inputs.",cT,Qi,Cu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ObjectDetectionPipeline"><code>ObjectDetectionPipeline</code></a>',MT,Bi,gu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;any&gt;</code></td><td></td><td><p>The input images.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the object detection.</p></td> </tr><tr><td>[options.threshold]</td><td><code>number</code></td><td><code>0.9</code></td><td><p>The threshold used to filter boxes by score.</p></td> </tr><tr><td>[options.percentage]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to return the boxes coordinates in percentage (true) or in pixels (false).</p></td></tr></tbody>",rT,TT,mT,Zi,yT,Ni,JT,Ai,Iu=`Zero-shot object detection pipeline. This pipeline predicts bounding boxes of
objects when you provide an image and a set of <code>candidate_labels</code>.`,hT,vi,ku="<strong>Example:</strong> Zero-shot object detection w/ <code>Xenova/clip-vit-base-patch32</code>.",uT,_i,wT,Ri,Gu="<strong>Example:</strong> Zero-shot object detection w/ <code>Xenova/clip-vit-base-patch32</code> (returning top 4 matches and setting a threshold).",jT,Yi,UT,$i,Qu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',fT,Vi,Bu='<li><a href="#module_pipelines.ZeroShotObjectDetectionPipeline">.ZeroShotObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotObjectDetectionPipeline_new"><code>new ZeroShotObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotObjectDetectionPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',bT,xT,CT,Ei,gT,Pi,IT,Hi,Zu="Create a new ZeroShotObjectDetectionPipeline.",kT,zi,Nu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",GT,QT,BT,Wi,ZT,Si,NT,Xi,Au="Detect objects (bounding boxes & classes) in the image(s) passed as inputs.",AT,Li,vu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotObjectDetectionPipeline"><code>ZeroShotObjectDetectionPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An array of classifications for each input image or a single classification object if only one input image is provided.',vT,Di,_u=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array</code></td><td></td><td><p>The input images.</p></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td></td><td><p>What the model should recognize in the image.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the classification.</p></td> </tr><tr><td>[options.threshold]</td><td><code>number</code></td><td></td><td><p>The probability necessary to make a prediction.</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td></td><td><p>The number of top predictions that will be returned by the pipeline.
If the provided number is <code>null</code> or higher than the number of predictions available, it will default
to the number of predictions.</p></td> </tr><tr><td>[options.percentage]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to return the boxes coordinates in percentage (true) or in pixels (false).</p></td></tr></tbody>`,_T,RT,YT,Fi,$T,qi,VT,Oi,Ru=`Document Question Answering pipeline using any <code>AutoModelForDocumentQuestionAnswering</code>.
The inputs/outputs are similar to the (extractive) question answering pipeline; however,
the pipeline takes an image (and optional OCR’d words/boxes) as input instead of text context.`,ET,Ki,Yu="<strong>Example:</strong> Answer questions about a document with <code>Xenova/donut-base-finetuned-docvqa</code>.",PT,en,HT,tn,$u='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',zT,ln,Vu='<li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline">.DocumentQuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.DocumentQuestionAnsweringPipeline_new"><code>new DocumentQuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline+_call"><code>._call(image, question, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',WT,ST,XT,sn,LT,nn,DT,an,Eu="Create a new DocumentQuestionAnsweringPipeline.",FT,pn,Pu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",qT,OT,KT,on,em,dn,tm,cn,Hu="Answer the question given as input by using the document.",lm,Mn,zu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.DocumentQuestionAnsweringPipeline"><code>DocumentQuestionAnsweringPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - A Promise that resolves to an object (or array of objects) containing the generated text(s).',sm,rn,Wu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>any</code></td><td></td><td><p>The image of the document to use.</p></td> </tr><tr><td>question</td><td><code>string</code></td><td></td><td><p>A question to ask of the document.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional generation arguments.</p></td></tr></tbody>",im,nm,am,Tn,pm,mn,om,yn,Su=`Text-to-audio generation pipeline using any <code>AutoModelForTextToWaveform</code> or <code>AutoModelForTextToSpectrogram</code>.
This pipeline generates an audio file from an input text and optional other conditional inputs.`,dm,Jn,Xu="<strong>Example:</strong> Generate audio from text with <code>Xenova/speecht5_tts</code>.",cm,hn,Mm,un,Lu="You can then save the audio to a .wav file with the <code>wavefile</code> package:",rm,wn,Tm,jn,Du='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',mm,Un,Fu='<li><a href="#module_pipelines.TextToAudioPipeline">.TextToAudioPipeline</a><ul><li><a href="#new_module_pipelines.TextToAudioPipeline_new"><code>new TextToAudioPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextToAudioPipeline+_call"><code>._call(text_inputs, options)</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',ym,Jm,hm,fn,um,bn,wm,xn,qu="Create a new TextToAudioPipeline.",jm,Cn,Ou="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td> </tr><tr><td>[options.vocoder]</td><td><code>PreTrainedModel</code></td><td><p>The vocoder to use.</p></td></tr></tbody>",Um,fm,bm,gn,xm,In,Cm,kn,Ku="Generates speech/audio from the inputs.",gm,Gn,ew='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextToAudioPipeline"><code>TextToAudioPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - An object containing the generated audio and sampling rate.',Im,Qn,tw="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>text_inputs</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The text(s) to generate.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Parameters passed to the model generation/forward method.</p></td> </tr><tr><td>[options.vocoder]</td><td><code>PreTrainedModel</code></td><td><code></code></td><td><p>The vocoder to use (if the model uses one). If not provided, use the default HifiGan vocoder.</p></td> </tr><tr><td>[options.speaker_embeddings]</td><td><code>Tensor</code> | <code>Float32Array</code> | <code>string</code> | <code>URL</code></td><td><code></code></td><td></td></tr></tbody>",km,Gm,Qm,Bn,Bm,Zn,Zm,Nn,lw="Image to Image pipeline using any <code>AutoModelForImageToImage</code>. This pipeline generates an image based on a previous image input.",Nm,An,sw="<strong>Example:</strong> Super-resolution w/ <code>Xenova/swin2SR-classical-sr-x2-64</code>",Am,vn,vm,_n,iw='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',_m,Rm,Ym,Rn,$m,Yn,Vm,$n,nw="Transform the image(s) passed as inputs.",Em,Vn,aw='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageToImagePipeline"><code>ImageToImagePipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An image or a list of images containing result(s).',Pm,En,pw="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>any</code></td><td><p>The images to transform.</p></td></tr></tbody>",Hm,zm,Wm,Pn,Sm,Hn,Xm,zn,ow="Depth estimation pipeline using any <code>AutoModelForDepthEstimation</code>. This pipeline predicts the depth of an image.",Lm,Wn,dw="<strong>Example:</strong> Depth estimation w/ <code>Xenova/dpt-hybrid-midas</code>",Dm,Sn,Fm,Xn,cw='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',qm,Om,Km,Ln,ey,Dn,ty,Fn,Mw="Predicts the depth for the image(s) passed as inputs.",ly,qn,rw='<strong>Kind</strong>: instance method of <a href="#module_pipelines.DepthEstimationPipeline"><code>DepthEstimationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An image or a list of images containing result(s).',sy,On,Tw="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>any</code></td><td><p>The images to compute depth for.</p></td></tr></tbody>",iy,ny,ay,Kn,py,ea,oy,ta,mw="Utility factory method to build a [<code>Pipeline</code>] object.",dy,la,yw='<strong>Kind</strong>: static method of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Pipeline&gt;</code> - A Pipeline object for the specified task.<br/> <strong>Throws</strong>:',cy,sa,Jw="<li><code>Error</code> If an unsupported pipeline is requested.</li>",My,ia,hw="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>task</td><td><code>string</code></td><td></td><td><p>The task defining which pipeline will be returned. Currently accepted tasks are:</p> <ul><li><code>&quot;audio-classification&quot;</code>: will return a <code>AudioClassificationPipeline</code>.</li> <li><code>&quot;automatic-speech-recognition&quot;</code>: will return a <code>AutomaticSpeechRecognitionPipeline</code>.</li> <li><code>&quot;depth-estimation&quot;</code>: will return a <code>DepthEstimationPipeline</code>.</li> <li><code>&quot;document-question-answering&quot;</code>: will return a <code>DocumentQuestionAnsweringPipeline</code>.</li> <li><code>&quot;feature-extraction&quot;</code>: will return a <code>FeatureExtractionPipeline</code>.</li> <li><code>&quot;fill-mask&quot;</code>: will return a <code>FillMaskPipeline</code>.</li> <li><code>&quot;image-classification&quot;</code>: will return a <code>ImageClassificationPipeline</code>.</li> <li><code>&quot;image-segmentation&quot;</code>: will return a <code>ImageSegmentationPipeline</code>.</li> <li><code>&quot;image-to-text&quot;</code>: will return a <code>ImageToTextPipeline</code>.</li> <li><code>&quot;object-detection&quot;</code>: will return a <code>ObjectDetectionPipeline</code>.</li> <li><code>&quot;question-answering&quot;</code>: will return a <code>QuestionAnsweringPipeline</code>.</li> <li><code>&quot;summarization&quot;</code>: will return a <code>SummarizationPipeline</code>.</li> <li><code>&quot;text2text-generation&quot;</code>: will return a <code>Text2TextGenerationPipeline</code>.</li> <li><code>&quot;text-classification&quot;</code> (alias &quot;sentiment-analysis&quot; available): will return a <code>TextClassificationPipeline</code>.</li> <li><code>&quot;text-generation&quot;</code>: will return a <code>TextGenerationPipeline</code>.</li> <li><code>&quot;token-classification&quot;</code> (alias &quot;ner&quot; available): will return a <code>TokenClassificationPipeline</code>.</li> <li><code>&quot;translation&quot;</code>: will return a <code>TranslationPipeline</code>.</li> <li><code>&quot;translation_xx_to_yy&quot;</code>: will return a <code>TranslationPipeline</code>.</li> <li><code>&quot;zero-shot-classification&quot;</code>: will return a <code>ZeroShotClassificationPipeline</code>.</li> <li><code>&quot;zero-shot-image-classification&quot;</code>: will return a <code>ZeroShotImageClassificationPipeline</code>.</li> <li><code>&quot;zero-shot-object-detection&quot;</code>: will return a <code>ZeroShotObjectDetectionPipeline</code>.</li></ul></td> </tr><tr><td>[model]</td><td><code>string</code></td><td><code>null</code></td><td><p>The name of the pre-trained model to use. If not specified, the default model for the task will be used.</p></td> </tr><tr><td>[options]</td><td><code>*</code></td><td></td><td><p>Optional parameters for the pipeline.</p></td></tr></tbody>",ry,Ty,my,na,yy,aa,Jy,pa,uw='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Properties</strong>',hy,oa,ww="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>answer</td><td><code>string</code></td><td><p>The answer.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score.</p></td></tr></tbody>",uy,wy,jy,da,Uy,ca,fy,Ma,jw='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',by,xy,Cy,ra,gy,Ta,Iy,ma,Uw='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',ky,ya,fw="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>chunk</td><td><code>Chunk</code></td><td><p>The chunk to process.</p></td></tr></tbody>",Gy,Qy,By,ha,Zy;return U=new h({props:{title:"pipelines",local:"pipelines",headingTag:"h1"}}),x=new u({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnc2VudGltZW50LWFuYWx5c2lzJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ0klMjBsb3ZlJTIwdHJhbnNmb3JtZXJzIScpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJ2xhYmVsJyUzQSUyMCdQT1NJVElWRSclMkMlMjAnc2NvcmUnJTNBJTIwMC45OTk4MTc2ODYlN0QlNUQ=",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.999817686}]</span>`,wrap:!1}}),I=new h({props:{title:"pipelines.Pipeline ⇐ <code> Callable </code>",local:"pipelinespipeline--code-callable-code",headingTag:"h2"}}),Z=new h({props:{title:"new Pipeline(options)",local:"new-pipelineoptions",headingTag:"h3"}}),_=new h({props:{title:"pipeline.dispose() ⇒ <code> Promise. < void > </code>",local:"pipelinedispose--code-promise--void--code",headingTag:"h3"}}),V=new h({props:{title:"pipeline._call(texts, ...args) ⇒ <code> Promise. < any > </code>",local:"pipelinecalltexts-args--code-promise--any--code",headingTag:"h3"}}),W=new h({props:{title:"pipelines.TextClassificationPipeline",local:"pipelinestextclassificationpipeline",headingTag:"h2"}}),L=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnWGVub3ZhJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcignSSUyMGxvdmUlMjB0cmFuc2Zvcm1lcnMhJyklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjBsYWJlbCUzQSUyMCdQT1NJVElWRSclMkMlMjBzY29yZSUzQSUyMDAuOTk5Nzg4NzYxMTM4OTE2JTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{ label: &#x27;POSITIVE&#x27;, score: 0.999788761138916 }]</span>`,wrap:!1}}),F=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnWGVub3ZhJTJGYmVydC1iYXNlLW11bHRpbGluZ3VhbC11bmNhc2VkLXNlbnRpbWVudCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKCdMZSUyMG1laWxsZXVyJTIwZmlsbSUyMGRlJTIwdG91cyUyMGxlcyUyMHRlbXBzLiclMkMlMjAlN0IlMjB0b3BrJTNBJTIwNSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCc1JTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjk2MTA3NTk2MTU4OTgxMzIlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCc0JTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjAzMzIzMzUxNTkxODI1NDg1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnMyUyMHN0YXJzJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDM2MTU1MTgxMDA1NTk3MTE1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnMSUyMHN0YXInJTJDJTIwc2NvcmUlM0ElMjAwLjAwMTEzMjU5Njc0OTgxMjM2NDYlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCcyJTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMDk0MjM5NzEwNTk3MzIxMzklMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-multilingual-uncased-sentiment&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;Le meilleur film de tous les temps.&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-number">5</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;5 stars&#x27;, score: 0.9610759615898132 },</span>
<span class="hljs-comment">//   { label: &#x27;4 stars&#x27;, score: 0.03323351591825485 },</span>
<span class="hljs-comment">//   { label: &#x27;3 stars&#x27;, score: 0.0036155181005597115 },</span>
<span class="hljs-comment">//   { label: &#x27;1 star&#x27;, score: 0.0011325967498123646 },</span>
<span class="hljs-comment">//   { label: &#x27;2 stars&#x27;, score: 0.0009423971059732139 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),O=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RleHQtY2xhc3NpZmljYXRpb24nJTJDJTIwJ1hlbm92YSUyRnRveGljLWJlcnQnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcignSSUyMGhhdGUlMjB5b3UhJyUyQyUyMCU3QiUyMHRvcGslM0ElMjBudWxsJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RveGljJyUyQyUyMHNjb3JlJTNBJTIwMC45NTkzMTQwNDgyOTAyNTI3JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnaW5zdWx0JyUyQyUyMHNjb3JlJTNBJTIwMC4xNjE4NzMzNDA2MDY2ODk0NSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ29ic2NlbmUnJTJDJTIwc2NvcmUlM0ElMjAwLjAzNDUyNjgwNjMyNDcyMDM4JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnaWRlbnRpdHlfaGF0ZSclMkMlMjBzY29yZSUzQSUyMDAuMDIyMzI1MDU3NTM2MzYzNiUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RocmVhdCclMkMlMjBzY29yZSUzQSUyMDAuMDE5MTk3MDQxMTY4ODA4OTM3JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnc2V2ZXJlX3RveGljJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDU2NTEwOTk2MDczNDg0NDIlMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/toxic-bert&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I hate you!&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-literal">null</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;toxic&#x27;, score: 0.9593140482902527 },</span>
<span class="hljs-comment">//   { label: &#x27;insult&#x27;, score: 0.16187334060668945 },</span>
<span class="hljs-comment">//   { label: &#x27;obscene&#x27;, score: 0.03452680632472038 },</span>
<span class="hljs-comment">//   { label: &#x27;identity_hate&#x27;, score: 0.0223250575363636 },</span>
<span class="hljs-comment">//   { label: &#x27;threat&#x27;, score: 0.019197041168808937 },</span>
<span class="hljs-comment">//   { label: &#x27;severe_toxic&#x27;, score: 0.005651099607348442 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),te=new h({props:{title:"textClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"textclassificationpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),ae=new h({props:{title:"pipelines.TokenClassificationPipeline",local:"pipelinestokenclassificationpipeline",headingTag:"h2"}}),de=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3Rva2VuLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtTkVSJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ015JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwTG9uZG9uJyklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnQi1QRVInJTJDJTIwc2NvcmUlM0ElMjAwLjk5ODAyMDI5MTMyODQzMDIlMkMlMjBpbmRleCUzQSUyMDQlMkMlMjB3b3JkJTNBJTIwJ1NhcmFoJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5NDQ3NDA1MzM4Mjg3NCUyQyUyMGluZGV4JTNBJTIwOSUyQyUyMHdvcmQlM0ElMjAnTG9uZG9uJyUyMCU3RCUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-NER&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;My name is Sarah and I live in London&#x27;</span>);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { entity: &#x27;B-PER&#x27;, score: 0.9980202913284302, index: 4, word: &#x27;Sarah&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;B-LOC&#x27;, score: 0.9994474053382874, index: 9, word: &#x27;London&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Me=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3Rva2VuLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtTkVSJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ1NhcmFoJTIwbGl2ZXMlMjBpbiUyMHRoZSUyMFVuaXRlZCUyMFN0YXRlcyUyMG9mJTIwQW1lcmljYSclMkMlMjAlN0IlMjBpZ25vcmVfbGFiZWxzJTNBJTIwJTVCJTVEJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLVBFUiclMkMlMjBzY29yZSUzQSUyMDAuOTk2NjU4NzQyNDI3ODI1OSUyQyUyMGluZGV4JTNBJTIwMSUyQyUyMHdvcmQlM0ElMjAnU2FyYWgnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwZW50aXR5JTNBJTIwJ08nJTJDJTIwc2NvcmUlM0ElMjAwLjk5ODczODU4NjkwMjYxODQlMkMlMjBpbmRleCUzQSUyMDIlMkMlMjB3b3JkJTNBJTIwJ2xpdmVzJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdPJyUyQyUyMHNjb3JlJTNBJTIwMC45OTkwMDcyODQ2NDEyNjU5JTJDJTIwaW5kZXglM0ElMjAzJTJDJTIwd29yZCUzQSUyMCdpbiclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnTyclMkMlMjBzY29yZSUzQSUyMDAuOTk4ODI5ODQxNjEzNzY5NSUyQyUyMGluZGV4JTNBJTIwNCUyQyUyMHdvcmQlM0ElMjAndGhlJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5NTUxMDU3ODE1NTUxOCUyQyUyMGluZGV4JTNBJTIwNSUyQyUyMHdvcmQlM0ElMjAnVW5pdGVkJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdJLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5MDM5NTMwNzU0MDg5NCUyQyUyMGluZGV4JTNBJTIwNiUyQyUyMHdvcmQlM0ElMjAnU3RhdGVzJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdJLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk4NjcyNDg1MzUxNTYyNSUyQyUyMGluZGV4JTNBJTIwNyUyQyUyMHdvcmQlM0ElMjAnb2YnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwZW50aXR5JTNBJTIwJ0ktTE9DJyUyQyUyMHNjb3JlJTNBJTIwMC45OTc1Mjk0NDcwNzg3MDQ4JTJDJTIwaW5kZXglM0ElMjA4JTJDJTIwd29yZCUzQSUyMCdBbWVyaWNhJyUyMCU3RCUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-NER&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;Sarah lives in the United States of America&#x27;</span>, { <span class="hljs-attr">ignore_labels</span>: [] });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { entity: &#x27;B-PER&#x27;, score: 0.9966587424278259, index: 1, word: &#x27;Sarah&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9987385869026184, index: 2, word: &#x27;lives&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9990072846412659, index: 3, word: &#x27;in&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9988298416137695, index: 4, word: &#x27;the&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;B-LOC&#x27;, score: 0.9995510578155518, index: 5, word: &#x27;United&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9990395307540894, index: 6, word: &#x27;States&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9986724853515625, index: 7, word: &#x27;of&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9975294470787048, index: 8, word: &#x27;America&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),me=new h({props:{title:"tokenClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"tokenclassificationpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),we=new h({props:{title:"pipelines.QuestionAnsweringPipeline",local:"pipelinesquestionansweringpipeline",headingTag:"h2"}}),fe=new u({props:{code:"bGV0JTIwcXVlc3Rpb24lMjAlM0QlMjAnV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJyUzQiUwQWxldCUyMGNvbnRleHQlMjAlM0QlMjAnSmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQuJyUzQiUwQSUwQWxldCUyMGFuc3dlcmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgncXVlc3Rpb24tYW5zd2VyaW5nJyUyQyUyMCdYZW5vdmElMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1kaXN0aWxsZWQtc3F1YWQnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwYW5zd2VyZXIocXVlc3Rpb24lMkMlMjBjb250ZXh0KSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMmFuc3dlciUyMiUzQSUyMCUyMmElMjBuaWNlJTIwcHVwcGV0JTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyc2NvcmUlMjIlM0ElMjAwLjU3Njg5MTE1MDI1MjY3NDElMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> question = <span class="hljs-string">&#x27;Who was Jim Henson?&#x27;</span>;
<span class="hljs-keyword">let</span> context = <span class="hljs-string">&#x27;Jim Henson was a nice puppet.&#x27;</span>;

<span class="hljs-keyword">let</span> answerer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;question-answering&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-distilled-squad&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">answerer</span>(question, context);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;answer&quot;: &quot;a nice puppet&quot;,</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.5768911502526741</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Ce=new h({props:{title:"questionAnsweringPipeline._call(question, context, options) ⇒ <code> QuestionAnsweringReturnType </code>",local:"questionansweringpipelinecallquestion-context-options--code-questionansweringreturntype-code",headingTag:"h3"}}),Qe=new h({props:{title:"pipelines.FillMaskPipeline",local:"pipelinesfillmaskpipeline",headingTag:"h2"}}),Ne=new u({props:{code:"bGV0JTIwdW5tYXNrZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmaWxsLW1hc2snJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS1jYXNlZCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB1bm1hc2tlcignVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwJTVCTUFTSyU1RC4nKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHRva2VuX3N0ciUzQSUyMCdzdXJ2aXZhbCclMkMlMjBzY29yZSUzQSUyMDAuMDYxMzc0MTk0OTIwMDYzMDIlMkMlMjB0b2tlbiUzQSUyMDgxMTUlMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBzdXJ2aXZhbC4nJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwdG9rZW5fc3RyJTNBJTIwJ2xvdmUnJTJDJTIwc2NvcmUlM0ElMjAwLjAzOTAyNDUwMjAzODk1NTY5JTJDJTIwdG9rZW4lM0ElMjAxNTY3JTJDJTIwc2VxdWVuY2UlM0ElMjAnVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwbG92ZS4nJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwdG9rZW5fc3RyJTNBJTIwJ2hhcHBpbmVzcyclMkMlMjBzY29yZSUzQSUyMDAuMDMyNTMxODM1MTM4Nzk3NzYlMkMlMjB0b2tlbiUzQSUyMDkyNjYlMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBoYXBwaW5lc3MuJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHRva2VuX3N0ciUzQSUyMCdmcmVlZG9tJyUyQyUyMHNjb3JlJTNBJTIwMC4wMTg3MzYzMDY1Nzc5MjA5MTQlMkMlMjB0b2tlbiUzQSUyMDQ0MzglMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBmcmVlZG9tLiclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjB0b2tlbl9zdHIlM0ElMjAnbGlmZSclMkMlMjBzY29yZSUzQSUyMDAuMDE4NTk3OTQ3NDMzNTkwODklMkMlMjB0b2tlbiUzQSUyMDEyOTclMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBsaWZlLiclMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> unmasker = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-cased&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">unmasker</span>(<span class="hljs-string">&#x27;The goal of life is [MASK].&#x27;</span>);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { token_str: &#x27;survival&#x27;, score: 0.06137419492006302, token: 8115, sequence: &#x27;The goal of life is survival.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;love&#x27;, score: 0.03902450203895569, token: 1567, sequence: &#x27;The goal of life is love.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;happiness&#x27;, score: 0.03253183513879776, token: 9266, sequence: &#x27;The goal of life is happiness.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;freedom&#x27;, score: 0.018736306577920914, token: 4438, sequence: &#x27;The goal of life is freedom.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;life&#x27;, score: 0.01859794743359089, token: 1297, sequence: &#x27;The goal of life is life.&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),ve=new u({props:{code:"bGV0JTIwdW5tYXNrZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmaWxsLW1hc2snJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS1jYXNlZCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB1bm1hc2tlcignVGhlJTIwTWlsa3klMjBXYXklMjBpcyUyMGElMjAlNUJNQVNLJTVEJTIwZ2FsYXh5LiclMkMlMjAlN0IlMjB0b3BrJTNBJTIwMSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjB0b2tlbl9zdHIlM0ElMjAnc3BpcmFsJyUyQyUyMHNjb3JlJTNBJTIwMC42Mjk5OTg3NDM1MzQwODgxJTJDJTIwdG9rZW4lM0ElMjAxNDA2MSUyQyUyMHNlcXVlbmNlJTNBJTIwJ1RoZSUyME1pbGt5JTIwV2F5JTIwaXMlMjBhJTIwc3BpcmFsJTIwZ2FsYXh5LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> unmasker = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-cased&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">unmasker</span>(<span class="hljs-string">&#x27;The Milky Way is a [MASK] galaxy.&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-number">1</span> });
<span class="hljs-comment">// [{ token_str: &#x27;spiral&#x27;, score: 0.6299987435340881, token: 14061, sequence: &#x27;The Milky Way is a spiral galaxy.&#x27; }]</span>`,wrap:!1}}),Ye=new h({props:{title:"fillMaskPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"fillmaskpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),He=new h({props:{title:"pipelines.Text2TextGenerationPipeline",local:"pipelinestext2textgenerationpipeline",headingTag:"h2"}}),Se=new u({props:{code:"bGV0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dDJ0ZXh0LWdlbmVyYXRpb24nJTJDJTIwJ1hlbm92YSUyRkxhTWluaS1GbGFuLVQ1LTc4M00nKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwZ2VuZXJhdG9yKCdob3clMjBjYW4lMjBJJTIwYmVjb21lJTIwbW9yZSUyMGhlYWx0aHklM0YnJTJDJTIwJTdCJTBBJTIwJTIwbWF4X25ld190b2tlbnMlM0ElMjAxMDAlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAlMjJUbyUyMGJlY29tZSUyMG1vcmUlMjBoZWFsdGh5JTJDJTIweW91JTIwY2FuJTNBJTIwMS4lMjBFYXQlMjBhJTIwYmFsYW5jZWQlMjBkaWV0JTIwd2l0aCUyMHBsZW50eSUyMG9mJTIwZnJ1aXRzJTJDJTIwdmVnZXRhYmxlcyUyQyUyMHdob2xlJTIwZ3JhaW5zJTJDJTIwbGVhbiUyMHByb3RlaW5zJTJDJTIwYW5kJTIwaGVhbHRoeSUyMGZhdHMuJTIwMi4lMjBTdGF5JTIwaHlkcmF0ZWQlMjBieSUyMGRyaW5raW5nJTIwcGxlbnR5JTIwb2YlMjB3YXRlci4lMjAzLiUyMEdldCUyMGVub3VnaCUyMHNsZWVwJTIwYW5kJTIwbWFuYWdlJTIwc3RyZXNzJTIwbGV2ZWxzLiUyMDQuJTIwQXZvaWQlMjBzbW9raW5nJTIwYW5kJTIwZXhjZXNzaXZlJTIwYWxjb2hvbCUyMGNvbnN1bXB0aW9uLiUyMDUuJTIwUmVndWxhcmx5JTIwZXhlcmNpc2UlMjBhbmQlMjBtYWludGFpbiUyMGElMjBoZWFsdGh5JTIwd2VpZ2h0LiUyMDYuJTIwUHJhY3RpY2UlMjBnb29kJTIwaHlnaWVuZSUyMGFuZCUyMHNhbml0YXRpb24uJTIwNy4lMjBTZWVrJTIwbWVkaWNhbCUyMGF0dGVudGlvbiUyMGlmJTIweW91JTIwZXhwZXJpZW5jZSUyMGFueSUyMGhlYWx0aCUyMGlzc3Vlcy4lMjIlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text2text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/LaMini-Flan-T5-783M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(<span class="hljs-string">&#x27;how can I become more healthy?&#x27;</span>, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">100</span>,
});
<span class="hljs-comment">// [{ generated_text: &quot;To become more healthy, you can: 1. Eat a balanced diet with plenty of fruits, vegetables, whole grains, lean proteins, and healthy fats. 2. Stay hydrated by drinking plenty of water. 3. Get enough sleep and manage stress levels. 4. Avoid smoking and excessive alcohol consumption. 5. Regularly exercise and maintain a healthy weight. 6. Practice good hygiene and sanitation. 7. Seek medical attention if you experience any health issues.&quot; }]</span>`,wrap:!1}}),De=new h({props:{title:"text2TextGenerationPipeline._call(texts, [options]) ⇒ <code> Promise. < any > </code>",local:"text2textgenerationpipelinecalltexts-options--code-promise--any--code",headingTag:"h3"}}),tt=new h({props:{title:"pipelines.SummarizationPipeline",local:"pipelinessummarizationpipeline",headingTag:"h2"}}),it=new u({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdUaGUlMjB0b3dlciUyMGlzJTIwMzI0JTIwbWV0cmVzJTIwKDElMkMwNjMlMjBmdCklMjB0YWxsJTJDJTIwYWJvdXQlMjB0aGUlMjBzYW1lJTIwaGVpZ2h0JTIwYXMlMjBhbiUyMDgxLXN0b3JleSUyMGJ1aWxkaW5nJTJDJTIwJyUyMCUyQiUwQSUyMCUyMCdhbmQlMjB0aGUlMjB0YWxsZXN0JTIwc3RydWN0dXJlJTIwaW4lMjBQYXJpcy4lMjBJdHMlMjBiYXNlJTIwaXMlMjBzcXVhcmUlMkMlMjBtZWFzdXJpbmclMjAxMjUlMjBtZXRyZXMlMjAoNDEwJTIwZnQpJTIwb24lMjBlYWNoJTIwc2lkZS4lMjAnJTIwJTJCJTBBJTIwJTIwJ0R1cmluZyUyMGl0cyUyMGNvbnN0cnVjdGlvbiUyQyUyMHRoZSUyMEVpZmZlbCUyMFRvd2VyJTIwc3VycGFzc2VkJTIwdGhlJTIwV2FzaGluZ3RvbiUyME1vbnVtZW50JTIwdG8lMjBiZWNvbWUlMjB0aGUlMjB0YWxsZXN0JTIwJyUyMCUyQiUwQSUyMCUyMCdtYW4tbWFkZSUyMHN0cnVjdHVyZSUyMGluJTIwdGhlJTIwd29ybGQlMkMlMjBhJTIwdGl0bGUlMjBpdCUyMGhlbGQlMjBmb3IlMjA0MSUyMHllYXJzJTIwdW50aWwlMjB0aGUlMjBDaHJ5c2xlciUyMEJ1aWxkaW5nJTIwaW4lMjBOZXclMjAnJTIwJTJCJTBBJTIwJTIwJ1lvcmslMjBDaXR5JTIwd2FzJTIwZmluaXNoZWQlMjBpbiUyMDE5MzAuJTIwSXQlMjB3YXMlMjB0aGUlMjBmaXJzdCUyMHN0cnVjdHVyZSUyMHRvJTIwcmVhY2glMjBhJTIwaGVpZ2h0JTIwb2YlMjAzMDAlMjBtZXRyZXMuJTIwRHVlJTIwdG8lMjAnJTIwJTJCJTBBJTIwJTIwJ3RoZSUyMGFkZGl0aW9uJTIwb2YlMjBhJTIwYnJvYWRjYXN0aW5nJTIwYWVyaWFsJTIwYXQlMjB0aGUlMjB0b3AlMjBvZiUyMHRoZSUyMHRvd2VyJTIwaW4lMjAxOTU3JTJDJTIwaXQlMjBpcyUyMG5vdyUyMHRhbGxlciUyMHRoYW4lMjB0aGUlMjAnJTIwJTJCJTBBJTIwJTIwJ0NocnlzbGVyJTIwQnVpbGRpbmclMjBieSUyMDUuMiUyMG1ldHJlcyUyMCgxNyUyMGZ0KS4lMjBFeGNsdWRpbmclMjB0cmFuc21pdHRlcnMlMkMlMjB0aGUlMjBFaWZmZWwlMjBUb3dlciUyMGlzJTIwdGhlJTIwc2Vjb25kJTIwJyUyMCUyQiUwQSUyMCUyMCd0YWxsZXN0JTIwZnJlZS1zdGFuZGluZyUyMHN0cnVjdHVyZSUyMGluJTIwRnJhbmNlJTIwYWZ0ZXIlMjB0aGUlMjBNaWxsYXUlMjBWaWFkdWN0LiclM0IlMEElMEFsZXQlMjBnZW5lcmF0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdzdW1tYXJpemF0aW9uJyUyQyUyMCdYZW5vdmElMkZkaXN0aWxiYXJ0LWNubi02LTYnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwZ2VuZXJhdG9yKHRleHQlMkMlMjAlN0IlMEElMjAlMjBtYXhfbmV3X3Rva2VucyUzQSUyMDEwMCUyQyUwQSU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjBzdW1tYXJ5X3RleHQlM0ElMjAnJTIwVGhlJTIwRWlmZmVsJTIwVG93ZXIlMjBpcyUyMGFib3V0JTIwdGhlJTIwc2FtZSUyMGhlaWdodCUyMGFzJTIwYW4lMjA4MS1zdG9yZXklMjBidWlsZGluZyUyMGFuZCUyMHRoZSUyMHRhbGxlc3QlMjBzdHJ1Y3R1cmUlMjBpbiUyMFBhcmlzLiUyMEl0JTIwaXMlMjB0aGUlMjBzZWNvbmQlMjB0YWxsZXN0JTIwZnJlZS1zdGFuZGluZyUyMHN0cnVjdHVyZSUyMGluJTIwRnJhbmNlJTIwYWZ0ZXIlMjB0aGUlMjBNaWxsYXUlMjBWaWFkdWN0LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, &#x27;</span> +
  <span class="hljs-string">&#x27;and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. &#x27;</span> +
  <span class="hljs-string">&#x27;During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest &#x27;</span> +
  <span class="hljs-string">&#x27;man-made structure in the world, a title it held for 41 years until the Chrysler Building in New &#x27;</span> +
  <span class="hljs-string">&#x27;York City was finished in 1930. It was the first structure to reach a height of 300 metres. Due to &#x27;</span> +
  <span class="hljs-string">&#x27;the addition of a broadcasting aerial at the top of the tower in 1957, it is now taller than the &#x27;</span> +
  <span class="hljs-string">&#x27;Chrysler Building by 5.2 metres (17 ft). Excluding transmitters, the Eiffel Tower is the second &#x27;</span> +
  <span class="hljs-string">&#x27;tallest free-standing structure in France after the Millau Viaduct.&#x27;</span>;

<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;summarization&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbart-cnn-6-6&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">100</span>,
});
<span class="hljs-comment">// [{ summary_text: &#x27; The Eiffel Tower is about the same height as an 81-storey building and the tallest structure in Paris. It is the second tallest free-standing structure in France after the Millau Viaduct.&#x27; }]</span>`,wrap:!1}}),pt=new h({props:{title:"pipelines.TranslationPipeline",local:"pipelinestranslationpipeline",headingTag:"h2"}}),Mt=new u({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZubGxiLTIwMC1kaXN0aWxsZWQtNjAwTScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKCclRTAlQTQlOUMlRTAlQTUlODAlRTAlQTQlQjUlRTAlQTQlQTglMjAlRTAlQTQlOEYlRTAlQTQlOTUlMjAlRTAlQTQlOUElRTAlQTUlODklRTAlQTQlOTUlRTAlQTQlQjIlRTAlQTUlODclRTAlQTQlOUYlMjAlRTAlQTQlQUMlRTAlQTUlODklRTAlQTQlOTUlRTAlQTUlOEQlRTAlQTQlQjglMjAlRTAlQTQlOTUlRTAlQTUlODAlMjAlRTAlQTQlQTQlRTAlQTQlQjAlRTAlQTQlQjklMjAlRTAlQTQlQjklRTAlQTUlODglRTAlQTUlQTQnJTJDJTIwJTdCJTBBJTIwJTIwc3JjX2xhbmclM0ElMjAnaGluX0RldmEnJTJDJTIwJTJGJTJGJTIwSGluZGklMEElMjAlMjB0Z3RfbGFuZyUzQSUyMCdmcmFfTGF0biclMkMlMjAlMkYlMkYlMjBGcmVuY2glMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwdHJhbnNsYXRpb25fdGV4dCUzQSUyMCdMYSUyMHZpZSUyMGVzdCUyMGNvbW1lJTIwdW5lJTIwYm8lQzMlQUV0ZSUyMCVDMyVBMCUyMGNob2NvbGF0LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nllb-200-distilled-600M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;जीवन एक चॉकलेट बॉक्स की तरह है।&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;hin_Deva&#x27;</span>, <span class="hljs-comment">// Hindi</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;fra_Latn&#x27;</span>, <span class="hljs-comment">// French</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;La vie est comme une boîte à chocolat.&#x27; }]</span>`,wrap:!1}}),mt=new u({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZtMm0xMDBfNDE4TScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKCclRTclOTQlOUYlRTYlQjQlQkIlRTUlQjAlQjElRTUlODMlOEYlRTQlQjglODAlRTclOUIlOTIlRTUlQjclQTclRTUlODUlOEIlRTUlOEElOUIlRTMlODAlODInJTJDJTIwJTdCJTBBJTIwJTIwc3JjX2xhbmclM0ElMjAnemgnJTJDJTIwJTJGJTJGJTIwQ2hpbmVzZSUwQSUyMCUyMHRndF9sYW5nJTNBJTIwJ2VuJyUyQyUyMCUyRiUyRiUyMEVuZ2xpc2glMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwdHJhbnNsYXRpb25fdGV4dCUzQSUyMCdMaWZlJTIwaXMlMjBsaWtlJTIwYSUyMGJveCUyMG9mJTIwY2hvY29sYXRlLiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/m2m100_418M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;生活就像一盒巧克力。&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;zh&#x27;</span>, <span class="hljs-comment">// Chinese</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-comment">// English</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;Life is like a box of chocolate.&#x27; }]</span>`,wrap:!1}}),ht=new u({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zbGF0b3IoJyVFMCVBNCVCOCVFMCVBNCU4MiVFMCVBNCVBRiVFMCVBNSU4MSVFMCVBNCU5NSVFMCVBNSU4RCVFMCVBNCVBNCUyMCVFMCVBNCVCMCVFMCVBNCVCRSVFMCVBNCVCNyVFMCVBNSU4RCVFMCVBNCU5RiVFMCVBNSU4RCVFMCVBNCVCMCUyMCVFMCVBNCU5NSVFMCVBNSU4NyUyMCVFMCVBNCVBQSVFMCVBNSU4RCVFMCVBNCVCMCVFMCVBNCVBRSVFMCVBNSU4MSVFMCVBNCU5NiUyMCVFMCVBNCU5NSVFMCVBNCVCRSUyMCVFMCVBNCU5NSVFMCVBNCVCOSVFMCVBNCVBOCVFMCVBNCVCRSUyMCVFMCVBNCVCOSVFMCVBNSU4OCUyMCVFMCVBNCU5NSVFMCVBNCVCRiUyMCVFMCVBNCVCOCVFMCVBNSU4MCVFMCVBNCVCMCVFMCVBNCVCRiVFMCVBNCVBRiVFMCVBNCVCRSUyMCVFMCVBNCVBRSVFMCVBNSU4NyVFMCVBNCU4MiUyMCVFMCVBNCU5NSVFMCVBNSU4QiVFMCVBNCU4OCUyMCVFMCVBNCVCOCVFMCVBNSU4OCVFMCVBNCVBOCVFMCVBNSU4RCVFMCVBNCVBRiUyMCVFMCVBNCVCOCVFMCVBNCVBRSVFMCVBNCVCRSVFMCVBNCVBNyVFMCVBNCVCRSVFMCVBNCVBOCUyMCVFMCVBNCVBOCVFMCVBNCVCOSVFMCVBNSU4MCVFMCVBNCU4MiUyMCVFMCVBNCVCOSVFMCVBNSU4OCclMkMlMjAlN0IlMEElMjAlMjBzcmNfbGFuZyUzQSUyMCdoaV9JTiclMkMlMjAlMkYlMkYlMjBIaW5kaSUwQSUyMCUyMHRndF9sYW5nJTNBJTIwJ2ZyX1hYJyUyQyUyMCUyRiUyRiUyMEZyZW5jaCUwQSU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjB0cmFuc2xhdGlvbl90ZXh0JTNBJTIwJ0xlJTIwY2hlZiUyMGRlcyUyME5hdGlvbnMlMjBhZmZpcm1lJTIwcXUlMjAnaWwlMjBuJTIwJ3klMjBhJTIwbWlsaXRhcnklMjBzb2x1dGlvbiUyMGluJTIwU3lyaWEuJyUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/mbart-large-50-many-to-many-mmt&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;संयुक्त राष्ट्र के प्रमुख का कहना है कि सीरिया में कोई सैन्य समाधान नहीं है&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;hi_IN&#x27;</span>, <span class="hljs-comment">// Hindi</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;fr_XX&#x27;</span>, <span class="hljs-comment">// French</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;Le chef des Nations affirme qu &#x27;il n &#x27;y a military solution in Syria.&#x27; }]</span>`,wrap:!1}}),jt=new h({props:{title:"pipelines.TextGenerationPipeline",local:"pipelinestextgenerationpipeline",headingTag:"h2"}}),bt=new u({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdJJTIwZW5qb3klMjB3YWxraW5nJTIwd2l0aCUyMG15JTIwY3V0ZSUyMGRvZyUyQyclM0IlMEFsZXQlMjBnZW5lcmF0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCd0ZXh0LWdlbmVyYXRpb24nJTJDJTIwJ1hlbm92YSUyRmRpc3RpbGdwdDInKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwZ2VuZXJhdG9yKHRleHQpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAlMjJJJTIwZW5qb3klMjB3YWxraW5nJTIwd2l0aCUyMG15JTIwY3V0ZSUyMGRvZyUyQyUyMGFuZCUyMEklMjBsb3ZlJTIwdG8lMjBwbGF5JTIwd2l0aCUyMHRoZSUyMG90aGVyJTIwZG9ncy4lMjIlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;I enjoy walking with my cute dog,&#x27;</span>;
<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilgpt2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text);
<span class="hljs-comment">// [{ generated_text: &quot;I enjoy walking with my cute dog, and I love to play with the other dogs.&quot; }]</span>`,wrap:!1}}),Ct=new u({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwdGhlcmUlMjB3YXMnJTNCJTBBbGV0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC1nZW5lcmF0aW9uJyUyQyUyMCdYZW5vdmElMkZkaXN0aWxncHQyJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGdlbmVyYXRvcih0ZXh0JTJDJTIwJTdCJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAyJTJDJTBBJTIwJTIwbWF4X25ld190b2tlbnMlM0ElMjAxMCUyQyUwQSUyMCUyMHJlcGV0aXRpb25fcGVuYWx0eSUzQSUyMDEuNSUyQyUwQSUyMCUyMG5vX3JlcGVhdF9uZ3JhbV9zaXplJTNBJTIwMiUyQyUwQSUyMCUyMG51bV9iZWFtcyUzQSUyMDIlMkMlMEElMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzQSUyMDIlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIyZ2VuZXJhdGVkX3RleHQlMjIlM0ElMjAlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwdGhlcmUlMjB3YXMlMjBhbiUyMGFidW5kYW5jZSUyMG9mJTIwaW5mb3JtYXRpb24lMjBhYm91dCUyMHRoZSUyMGhpc3RvcnklMjBhbmQlMjBhY3Rpdml0aWVzJTIwdGhhdCUyMiUwQSUyRiUyRiUyMCU3RCUyQyUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMmdlbmVyYXRlZF90ZXh0JTIyJTNBJTIwJTIyT25jZSUyMHVwb24lMjBhJTIwdGltZSUyQyUyMHRoZXJlJTIwd2FzJTIwYW4lMjBhYnVuZGFuY2UlMjBvZiUyMGluZm9ybWF0aW9uJTIwYWJvdXQlMjB0aGUlMjBtb3N0JTIwaW1wb3J0YW50JTIwYW5kJTIwaW5mbHVlbnRpYWwlMjIlMEElMkYlMkYlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;Once upon a time, there was&#x27;</span>;
<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilgpt2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">10</span>,
  <span class="hljs-attr">repetition_penalty</span>: <span class="hljs-number">1.5</span>,
  <span class="hljs-attr">no_repeat_ngram_size</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">num_beams</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">num_return_sequences</span>: <span class="hljs-number">2</span>,
});
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   &quot;generated_text&quot;: &quot;Once upon a time, there was an abundance of information about the history and activities that&quot;</span>
<span class="hljs-comment">// }, {</span>
<span class="hljs-comment">//   &quot;generated_text&quot;: &quot;Once upon a time, there was an abundance of information about the most important and influential&quot;</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),It=new u({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdkZWYlMjBmaWIobiklM0EnJTNCJTBBbGV0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC1nZW5lcmF0aW9uJyUyQyUyMCdYZW5vdmElMkZjb2RlZ2VuLTM1ME0tbW9ubycpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBnZW5lcmF0b3IodGV4dCUyQyUyMCU3QiUwQSUyMCUyMG1heF9uZXdfdG9rZW5zJTNBJTIwNDQlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTBBJTJGJTJGJTIwJTIwJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAnZGVmJTIwZmliKG4pJTNBJTVDbiclMjAlMkIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAnJTIwJTIwJTIwJTIwaWYlMjBuJTIwJTNEJTNEJTIwMCUzQSU1Q24nJTIwJTJCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMDAlNUNuJyUyMCUyQiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCclMjAlMjAlMjAlMjBlbGlmJTIwbiUyMCUzRCUzRCUyMDElM0ElNUNuJyUyMCUyQiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAxJTVDbiclMjAlMkIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAnJTIwJTIwJTIwJTIwZWxzZSUzQSU1Q24nJTIwJTJCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGZpYihuLTEpJTIwJTJCJTIwZmliKG4tMiklNUNuJyUwQSUyRiUyRiUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;def fib(n):&#x27;</span>;
<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/codegen-350M-mono&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">44</span>,
});
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   generated_text: &#x27;def fib(n):\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    if n == 0:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return 0\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    elif n == 1:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return 1\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    else:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return fib(n-1) + fib(n-2)\\n&#x27;</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),Qt=new h({props:{title:"textGenerationPipeline._call(texts, [generate_kwargs]) ⇒ <code> Promise. < any > </code>",local:"textgenerationpipelinecalltexts-generatekwargs--code-promise--any--code",headingTag:"h3"}}),vt=new h({props:{title:"pipelines.ZeroShotClassificationPipeline",local:"pipelineszeroshotclassificationpipeline",headingTag:"h2"}}),Yt=new u({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdMYXN0JTIwd2VlayUyMEklMjB1cGdyYWRlZCUyMG15JTIwaU9TJTIwdmVyc2lvbiUyMGFuZCUyMGV2ZXIlMjBzaW5jZSUyMHRoZW4lMjBteSUyMHBob25lJTIwaGFzJTIwYmVlbiUyMG92ZXJoZWF0aW5nJTIwd2hlbmV2ZXIlMjBJJTIwdXNlJTIweW91ciUyMGFwcC4nJTNCJTBBbGV0JTIwbGFiZWxzJTIwJTNEJTIwJTVCJTIwJ21vYmlsZSclMkMlMjAnYmlsbGluZyclMkMlMjAnd2Vic2l0ZSclMkMlMjAnYWNjb3VudCUyMGFjY2VzcyclMjAlNUQlM0IlMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZtb2JpbGViZXJ0LXVuY2FzZWQtbW5saScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHRleHQlMkMlMjBsYWJlbHMpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwc2VxdWVuY2UlM0ElMjAnTGFzdCUyMHdlZWslMjBJJTIwdXBncmFkZWQlMjBteSUyMGlPUyUyMHZlcnNpb24lMjBhbmQlMjBldmVyJTIwc2luY2UlMjB0aGVuJTIwbXklMjBwaG9uZSUyMGhhcyUyMGJlZW4lMjBvdmVyaGVhdGluZyUyMHdoZW5ldmVyJTIwSSUyMHVzZSUyMHlvdXIlMjBhcHAuJyUyQyUwQSUyRiUyRiUyMCUyMCUyMGxhYmVscyUzQSUyMCU1QiUyMCdtb2JpbGUnJTJDJTIwJ3dlYnNpdGUnJTJDJTIwJ2JpbGxpbmcnJTJDJTIwJ2FjY291bnQlMjBhY2Nlc3MnJTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwc2NvcmVzJTNBJTIwJTVCJTIwMC41NTYyMDkxMDQwNDgyMDE4JTJDJTIwMC4xODQzNjIxMzA3ODYwODUzJTJDJTIwMC4xMzk0MjY0NjYzOTMzNjM3NiUyQyUyMDAuMTIwMDAyMjk4NzcyMzQ5MjMlMjAlNUQlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;Last week I upgraded my iOS version and ever since then my phone has been overheating whenever I use your app.&#x27;</span>;
<span class="hljs-keyword">let</span> labels = [ <span class="hljs-string">&#x27;mobile&#x27;</span>, <span class="hljs-string">&#x27;billing&#x27;</span>, <span class="hljs-string">&#x27;website&#x27;</span>, <span class="hljs-string">&#x27;account access&#x27;</span> ];
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/mobilebert-uncased-mnli&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, labels);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   sequence: &#x27;Last week I upgraded my iOS version and ever since then my phone has been overheating whenever I use your app.&#x27;,</span>
<span class="hljs-comment">//   labels: [ &#x27;mobile&#x27;, &#x27;website&#x27;, &#x27;billing&#x27;, &#x27;account access&#x27; ],</span>
<span class="hljs-comment">//   scores: [ 0.5562091040482018, 0.1843621307860853, 0.13942646639336376, 0.12000229877234923 ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Vt=new u({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdJJTIwaGF2ZSUyMGElMjBwcm9ibGVtJTIwd2l0aCUyMG15JTIwaXBob25lJTIwdGhhdCUyMG5lZWRzJTIwdG8lMjBiZSUyMHJlc29sdmVkJTIwYXNhcCEnJTNCJTBBbGV0JTIwbGFiZWxzJTIwJTNEJTIwJTVCJTIwJ3VyZ2VudCclMkMlMjAnbm90JTIwdXJnZW50JyUyQyUyMCdwaG9uZSclMkMlMjAndGFibGV0JyUyQyUyMCdjb21wdXRlciclMjAlNUQlM0IlMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZubGktZGViZXJ0YS12My14c21hbGwnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwJTdCJTIwbXVsdGlfbGFiZWwlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHNlcXVlbmNlJTNBJTIwJ0klMjBoYXZlJTIwYSUyMHByb2JsZW0lMjB3aXRoJTIwbXklMjBpcGhvbmUlMjB0aGF0JTIwbmVlZHMlMjB0byUyMGJlJTIwcmVzb2x2ZWQlMjBhc2FwISclMkMlMEElMkYlMkYlMjAlMjAlMjBsYWJlbHMlM0ElMjAlNUIlMjAndXJnZW50JyUyQyUyMCdwaG9uZSclMkMlMjAnY29tcHV0ZXInJTJDJTIwJ3RhYmxldCclMkMlMjAnbm90JTIwdXJnZW50JyUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMHNjb3JlcyUzQSUyMCU1QiUyMDAuOTk1ODg3MDk1NjM2MDI3NSUyQyUyMDAuOTkyMzk2MzQwMDY5NzAzNSUyQyUyMDAuMDAyMzMzNTM3OTQ2MTYwMjM1JTJDJTIwMC4wMDE1MTM0MTM4NTY3NTk4NzY1JTJDJTIwMC4wMDEwNjk5Mzg0MjA4Mzc3MTYzJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!&#x27;</span>;
<span class="hljs-keyword">let</span> labels = [ <span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span> ];
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nli-deberta-v3-xsmall&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, labels, { <span class="hljs-attr">multi_label</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   sequence: &#x27;I have a problem with my iphone that needs to be resolved asap!&#x27;,</span>
<span class="hljs-comment">//   labels: [ &#x27;urgent&#x27;, &#x27;phone&#x27;, &#x27;computer&#x27;, &#x27;tablet&#x27;, &#x27;not urgent&#x27; ],</span>
<span class="hljs-comment">//   scores: [ 0.9958870956360275, 0.9923963400697035, 0.002333537946160235, 0.0015134138567598765, 0.0010699384208377163 ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),zt=new h({props:{title:"new ZeroShotClassificationPipeline(options)",local:"new-zeroshotclassificationpipelineoptions",headingTag:"h3"}}),Lt=new h({props:{title:"zeroShotClassificationPipeline._call(texts, candidate_labels, options) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"zeroshotclassificationpipelinecalltexts-candidatelabels-options--code-promise--objectarray--object----code",headingTag:"h3"}}),Ot=new h({props:{title:"pipelines.FeatureExtractionPipeline",local:"pipelinesfeatureextractionpipeline",headingTag:"h2"}}),tl=new u({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMjAlN0IlMjByZXZpc2lvbiUzQSUyMCdkZWZhdWx0JyUyMCU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSUyMCU1QjAuMDU5Mzk5MjQ3MTY5NDk0NjMlMkMlMjAwLjAyMTY1NTkzNTc5NDExNTA2NyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwOCUyQyUyMDc2OCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-uncased&#x27;</span>, { <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;default&#x27;</span> });
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.05939924716949463, 0.021655935794115067, ...],</span>
<span class="hljs-comment">//   dims: [1, 8, 768]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),sl=new u({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMjAlN0IlMjByZXZpc2lvbiUzQSUyMCdkZWZhdWx0JyUyMCU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyUyQyUyMCU3QiUyMHBvb2xpbmclM0ElMjAnbWVhbiclMkMlMjBub3JtYWxpemUlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMFRlbnNvciUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCMC4wMzM3Mzc3ODk4Mzk1MDYxNSUyQyUyMC0wLjAxMDEwNjA3NzQxNzczMTI4NSUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwNzY4JTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-uncased&#x27;</span>, { <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;default&#x27;</span> });
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&#x27;mean&#x27;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.03373778983950615, -0.010106077417731285, ...],</span>
<span class="hljs-comment">//   dims: [1, 768]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),nl=new u({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZhbGwtTWluaUxNLUw2LXYyJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyUyQyUyMCU3QiUyMHBvb2xpbmclM0ElMjAnbWVhbiclMkMlMjBub3JtYWxpemUlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMFRlbnNvciUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCMC4wOTA5NDk4MjU5NDI1MTYzMyUyQyUyMC0wLjAxNDc3NDI0NjE0MTMxNDUwNyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwMzg0JTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/all-MiniLM-L6-v2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&#x27;mean&#x27;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.09094982594251633, -0.014774246141314507, ...],</span>
<span class="hljs-comment">//   dims: [1, 384]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),ol=new h({props:{title:"featureExtractionPipeline._call(texts, options) ⇒",local:"featureextractionpipelinecalltexts-options-",headingTag:"h3"}}),Tl=new h({props:{title:"pipelines.AudioClassificationPipeline",local:"pipelinesaudioclassificationpipeline",headingTag:"h2"}}),Jl=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMGNsYXNzaWZpZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdhdWRpby1jbGFzc2lmaWNhdGlvbiclMkMlMjAnWGVub3ZhJTJGd2F2MnZlYzItbGFyZ2UteGxzci01My1nZW5kZXItcmVjb2duaXRpb24tbGlicmlzcGVlY2gnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnbWFsZSclMkMlMjBzY29yZSUzQSUyMDAuOTk4MTU0MjIyOTY1MjQwNSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ2ZlbWFsZSclMkMlMjBzY29yZSUzQSUyMDAuMDAxODQ1NzQ3ODE0NTEzNzQzJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;audio-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/wav2vec2-large-xlsr-53-gender-recognition-librispeech&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;male&#x27;, score: 0.9981542229652405 },</span>
<span class="hljs-comment">//   { label: &#x27;female&#x27;, score: 0.001845747814513743 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),jl=new h({props:{title:"new AudioClassificationPipeline(options)",local:"new-audioclassificationpipelineoptions",headingTag:"h3"}}),xl=new h({props:{title:"audioClassificationPipeline._call(audio, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"audioclassificationpipelinecallaudio-options--code-promise--array--object--object--code",headingTag:"h3"}}),Gl=new h({props:{title:"pipelines.AutomaticSpeechRecognitionPipeline",local:"pipelinesautomaticspeechrecognitionpipeline",headingTag:"h2"}}),Zl=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCklM0IlMEElMkYlMkYlMjAlN0IlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url);
<span class="hljs-comment">// { text: &quot; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&quot; }</span>`,wrap:!1}}),Al=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMHJldHVybl90aW1lc3RhbXBzJTNBJTIwdHJ1ZSUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJTIyJTBBJTJGJTJGJTIwJTIwJTIwY2h1bmtzJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwdGltZXN0YW1wJTNBJTIwJTVCMCUyQyUyMDglNUQlMkMlMjAlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTIyJTIwJTdEJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwdGltZXN0YW1wJTNBJTIwJTVCOCUyQyUyMDExJTVEJTJDJTIwdGV4dCUzQSUyMCUyMiUyMGFzayUyMHdoYXQlMjB5b3UlMjBjYW4lMjBkbyUyMGZvciUyMHlvdXIlMjBjb3VudHJ5LiUyMiUyMCU3RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">return_timestamps</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   text: &quot; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&quot;</span>
<span class="hljs-comment">//   chunks: [</span>
<span class="hljs-comment">//     { timestamp: [0, 8],  text: &quot; And so my fellow Americans ask not what your country can do for you&quot; }</span>
<span class="hljs-comment">//     { timestamp: [8, 11], text: &quot; ask what you can do for your country.&quot; }</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),_l=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyUyQyUyMCU3QiUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNBJTIwJ291dHB1dF9hdHRlbnRpb25zJyUyQyUwQSU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMHJldHVybl90aW1lc3RhbXBzJTNBJTIwJ3dvcmQnJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjAlMjIlMjBBbmQlMjBzbyUyMG15JTIwZmVsbG93JTIwQW1lcmljYW5zJTIwYXNrJTIwbm90JTIwd2hhdCUyMHlvdXIlMjBjb3VudHJ5JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3UlMjBhc2slMjB3aGF0JTIweW91JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3VyJTIwY291bnRyeS4lMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJjaHVua3MlMjIlM0ElMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwQW5kJTIyJTJDJTIwJTIydGltZXN0YW1wJTIyJTNBJTIwJTVCMCUyQyUyMDAuNzglNUQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwc28lMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUIwLjc4JTJDJTIwMS4wNiU1RCUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnRleHQlMjIlM0ElMjAlMjIlMjBteSUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMCU1QjEuMDYlMkMlMjAxLjQ2JTVEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIydGV4dCUyMiUzQSUyMCUyMiUyMGZvciUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMCU1QjkuNzIlMkMlMjA5LjkyJTVEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIydGV4dCUyMiUzQSUyMCUyMiUyMHlvdXIlMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUI5LjkyJTJDJTIwMTAuMjIlNUQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwY291bnRyeS4lMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUIxMC4yMiUyQyUyMDEzLjUlNUQlMjAlN0QlMEElMkYlMkYlMjAlMjAlMjAlNUQlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>, {
    <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;output_attentions&#x27;</span>,
});
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">return_timestamps</span>: <span class="hljs-string">&#x27;word&#x27;</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;text&quot;: &quot; And so my fellow Americans ask not what your country can do for you ask what you can do for your country.&quot;,</span>
<span class="hljs-comment">//   &quot;chunks&quot;: [</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; And&quot;, &quot;timestamp&quot;: [0, 0.78] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; so&quot;, &quot;timestamp&quot;: [0.78, 1.06] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; my&quot;, &quot;timestamp&quot;: [1.06, 1.46] },</span>
<span class="hljs-comment">//     ...</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; for&quot;, &quot;timestamp&quot;: [9.72, 9.92] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; your&quot;, &quot;timestamp&quot;: [9.92, 10.22] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; country.&quot;, &quot;timestamp&quot;: [10.22, 13.5] }</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Yl=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmcmVuY2gtYXVkaW8ubXAzJyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci1zbWFsbCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwlMkMlMjAlN0IlMjBsYW5ndWFnZSUzQSUyMCdmcmVuY2gnJTJDJTIwdGFzayUzQSUyMCd0cmFuc2NyaWJlJyUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMjB0ZXh0JTNBJTIwJTIyJTIwSidhZG9yZSUyQyUyMGonYWltZSUyQyUyMGplJTIwbidhaW1lJTIwcGFzJTJDJTIwamUlMjBkJUMzJUE5dGVzdGUuJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/french-audio.mp3&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">language</span>: <span class="hljs-string">&#x27;french&#x27;</span>, <span class="hljs-attr">task</span>: <span class="hljs-string">&#x27;transcribe&#x27;</span> });
<span class="hljs-comment">// { text: &quot; J&#x27;adore, j&#x27;aime, je n&#x27;aime pas, je déteste.&quot; }</span>`,wrap:!1}}),Vl=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmcmVuY2gtYXVkaW8ubXAzJyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci1zbWFsbCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwlMkMlMjAlN0IlMjBsYW5ndWFnZSUzQSUyMCdmcmVuY2gnJTJDJTIwdGFzayUzQSUyMCd0cmFuc2xhdGUnJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAlMjIlMjBJJTIwbG92ZSUyQyUyMEklMjBsaWtlJTJDJTIwSSUyMGRvbid0JTIwbGlrZSUyQyUyMEklMjBoYXRlLiUyMiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/french-audio.mp3&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">language</span>: <span class="hljs-string">&#x27;french&#x27;</span>, <span class="hljs-attr">task</span>: <span class="hljs-string">&#x27;translate&#x27;</span> });
<span class="hljs-comment">// { text: &quot; I love, I like, I don&#x27;t like, I hate.&quot; }</span>`,wrap:!1}}),Pl=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0ZWRfNjAud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMGNodW5rX2xlbmd0aF9zJTNBJTIwMzAlMkMlMjBzdHJpZGVfbGVuZ3RoX3MlM0ElMjA1JTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAlMjIlMjBTbyUyMGluJTIwY29sbGVnZSUyQyUyMEklMjB3YXMlMjBhJTIwZ292ZXJubWVudCUyMG1ham9yJTJDJTIwd2hpY2glMjBtZWFucyUyMCU1Qi4uLiU1RCUyMFNvJTIwSSdkJTIwc3RhcnQlMjBvZmYlMjBsaWdodCUyMGFuZCUyMEknZCUyMGJ1bXAlMjBpdCUyMHVwJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/ted_60.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">chunk_length_s</span>: <span class="hljs-number">30</span>, <span class="hljs-attr">stride_length_s</span>: <span class="hljs-number">5</span> });
<span class="hljs-comment">// { text: &quot; So in college, I was a government major, which means [...] So I&#x27;d start off light and I&#x27;d bump it up&quot; }</span>`,wrap:!1}}),Sl=new h({props:{title:"new AutomaticSpeechRecognitionPipeline(options)",local:"new-automaticspeechrecognitionpipelineoptions",headingTag:"h3"}}),Fl=new h({props:{title:"automaticSpeechRecognitionPipeline._call(audio, [kwargs]) ⇒ <code> Promise. < Object > </code>",local:"automaticspeechrecognitionpipelinecallaudio-kwargs--code-promise--object--code",headingTag:"h3"}}),ts=new h({props:{title:"pipelines.ImageToTextPipeline",local:"pipelinesimagetotextpipeline",headingTag:"h2"}}),is=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEFsZXQlMjBjYXB0aW9uZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdpbWFnZS10by10ZXh0JyUyQyUyMCdYZW5vdmElMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNhcHRpb25lcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAnYSUyMGNhdCUyMGxheWluZyUyMG9uJTIwYSUyMGNvdWNoJTIwd2l0aCUyMGFub3RoZXIlMjBjYXQnJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> captioner = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-text&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-gpt2-image-captioning&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">captioner</span>(url);
<span class="hljs-comment">// [{ generated_text: &#x27;a cat laying on a couch with another cat&#x27; }]</span>`,wrap:!1}}),as=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZoYW5kd3JpdGluZy5qcGcnJTNCJTBBbGV0JTIwY2FwdGlvbmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnaW1hZ2UtdG8tdGV4dCclMkMlMjAnWGVub3ZhJTJGdHJvY3Itc21hbGwtaGFuZHdyaXR0ZW4nKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2FwdGlvbmVyKHVybCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjBnZW5lcmF0ZWRfdGV4dCUzQSUyMCdNci4lMjBCcm93biUyMGNvbW1lbnRlZCUyMGljaWx5LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/handwriting.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> captioner = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-text&#x27;</span>, <span class="hljs-string">&#x27;Xenova/trocr-small-handwritten&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">captioner</span>(url);
<span class="hljs-comment">// [{ generated_text: &#x27;Mr. Brown commented icily.&#x27; }]</span>`,wrap:!1}}),cs=new h({props:{title:"new ImageToTextPipeline(options)",local:"new-imagetotextpipelineoptions",headingTag:"h3"}}),ms=new h({props:{title:"imageToTextPipeline._call(images, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"imagetotextpipelinecallimages-generatekwargs--code-promise--objectarray--object----code",headingTag:"h3"}}),ws=new h({props:{title:"pipelines.ImageClassificationPipeline",local:"pipelinesimageclassificationpipeline",headingTag:"h2"}}),fs=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0JsYWJlbCUzQSUyMCd0aWdlciUyQyUyMFBhbnRoZXJhJTIwdGlncmlzJyUyQyUyMHNjb3JlJTNBJTIwMC42MzI2OTU3MzQ1MDA4ODUlN0QlMkMlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885},</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),xs=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjAzJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTJDJTIwUGFudGhlcmElMjB0aWdyaXMnJTJDJTIwc2NvcmUlM0ElMjAwLjYzMjY5NTczNDUwMDg4NSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zNjM0ODI1NjQ2ODc3Mjg5JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnbGlvbiUyQyUyMGtpbmclMjBvZiUyMGJlYXN0cyUyQyUyMFBhbnRoZXJhJTIwbGVvJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDA0NTA2MDMwODE4NDQ3NDcwNyUyMCU3RCUyQyUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">3</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885 },</span>
<span class="hljs-comment">//   { label: &#x27;tiger cat&#x27;, score: 0.3634825646877289 },</span>
<span class="hljs-comment">//   { label: &#x27;lion, king of beasts, Panthera leo&#x27;, score: 0.00045060308184474707 },</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),gs=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjAwJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ3RpZ2VyJTJDJTIwUGFudGhlcmElMjB0aWdyaXMnJTJDJTIwc2NvcmUlM0ElMjAwLjYzMjY5NTczNDUwMDg4NSU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zNjM0ODI1NjQ2ODc3Mjg5JTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCbGFiZWwlM0ElMjAnbGlvbiUyQyUyMGtpbmclMjBvZiUyMGJlYXN0cyUyQyUyMFBhbnRoZXJhJTIwbGVvJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDA0NTA2MDMwODE4NDQ3NDcwNyU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ2phZ3VhciUyQyUyMHBhbnRoZXIlMkMlMjBQYW50aGVyYSUyMG9uY2ElMkMlMjBGZWxpcyUyMG9uY2EnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMDM1NDY1NDk5OTY4MjY3OTc3JTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">0</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885},</span>
<span class="hljs-comment">//   {label: &#x27;tiger cat&#x27;, score: 0.3634825646877289},</span>
<span class="hljs-comment">//   {label: &#x27;lion, king of beasts, Panthera leo&#x27;, score: 0.00045060308184474707},</span>
<span class="hljs-comment">//   {label: &#x27;jaguar, panther, Panthera onca, Felis onca&#x27;, score: 0.00035465499968267977},</span>
<span class="hljs-comment">//   ...</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Qs=new h({props:{title:"new ImageClassificationPipeline(options)",local:"new-imageclassificationpipelineoptions",headingTag:"h3"}}),As=new h({props:{title:"imageClassificationPipeline._call(images, options) ⇒ <code> Promise. < any > </code>",local:"imageclassificationpipelinecallimages-options--code-promise--any--code",headingTag:"h3"}}),$s=new h({props:{title:"pipelines.ImageSegmentationPipeline",local:"pipelinesimagesegmentationpipeline",headingTag:"h2"}}),Ps=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEFsZXQlMjBzZWdtZW50ZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdpbWFnZS1zZWdtZW50YXRpb24nJTJDJTIwJ1hlbm92YSUyRmRldHItcmVzbmV0LTUwLXBhbm9wdGljJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHNlZ21lbnRlcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAncmVtb3RlJyUyQyUyMHNjb3JlJTNBJTIwMC45OTg0NjQ5NDE5Nzg0NTQ2JTJDJTIwbWFzayUzQSUyMFJhd0ltYWdlJTIwJTdCJTIwLi4uJTIwJTdEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC45OTk0MzE2MTAxMDc0MjE5JTJDJTIwbWFzayUzQSUyMFJhd0ltYWdlJTIwJTdCJTIwLi4uJTIwJTdEJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> segmenter = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-segmentation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/detr-resnet-50-panoptic&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">segmenter</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;remote&#x27;, score: 0.9984649419784546, mask: RawImage { ... } },</span>
<span class="hljs-comment">//   { label: &#x27;cat&#x27;, score: 0.9994316101074219, mask: RawImage { ... } }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Ss=new h({props:{title:"new ImageSegmentationPipeline(options)",local:"new-imagesegmentationpipelineoptions",headingTag:"h3"}}),Fs=new h({props:{title:"imageSegmentationPipeline._call(images, options) ⇒ <code> Promise. < Array > </code>",local:"imagesegmentationpipelinecallimages-options--code-promise--array--code",headingTag:"h3"}}),ti=new h({props:{title:"pipelines.ZeroShotImageClassificationPipeline",local:"pipelineszeroshotimageclassificationpipeline",headingTag:"h2"}}),ii=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3plcm8tc2hvdC1pbWFnZS1jbGFzc2lmaWNhdGlvbiclMkMlMjAnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDMyJyklM0IlMEFsZXQlMjB1cmwlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRnRpZ2VyLmpwZyclM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIodXJsJTJDJTIwJTVCJ3RpZ2VyJyUyQyUyMCdob3JzZSclMkMlMjAnZG9nJyU1RCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBzY29yZSUzQSUyMDAuOTk5MzkxNzk0MjA0NzExOSUyQyUyMGxhYmVsJTNBJTIwJ3RpZ2VyJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHNjb3JlJTNBJTIwMC4wMDAzNTE5Mjk0ODQxNjgwNjc2JTJDJTIwbGFiZWwlM0ElMjAnaG9yc2UnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwc2NvcmUlM0ElMjAwLjAwMDI1NjI2OTg3OTE3MzQ4NzQlMkMlMjBsYWJlbCUzQSUyMCdkb2cnJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/clip-vit-base-patch32&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, [<span class="hljs-string">&#x27;tiger&#x27;</span>, <span class="hljs-string">&#x27;horse&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { score: 0.9993917942047119, label: &#x27;tiger&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0003519294841680676, label: &#x27;horse&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0002562698791734874, label: &#x27;dog&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),oi=new h({props:{title:"new ZeroShotImageClassificationPipeline(options)",local:"new-zeroshotimageclassificationpipelineoptions",headingTag:"h3"}}),ri=new h({props:{title:"zeroShotImageClassificationPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>",local:"zeroshotimageclassificationpipelinecallimages-candidatelabels-options--code-promise--any--code",headingTag:"h3"}}),hi=new h({props:{title:"pipelines.ObjectDetectionPipeline",local:"pipelinesobjectdetectionpipeline",headingTag:"h2"}}),ji=new u({props:{code:"bGV0JTIwaW1nJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEElMEFsZXQlMjBkZXRlY3RvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ29iamVjdC1kZXRlY3Rpb24nJTJDJTIwJ1hlbm92YSUyRmRldHItcmVzbmV0LTUwJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGRldGVjdG9yKGltZyUyQyUyMCU3QiUyMHRocmVzaG9sZCUzQSUyMDAuOSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjJzY29yZSUyMiUzQSUyMDAuOTk3NjM3MDkzMDY3MTY5MiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTIycmVtb3RlJTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyYm94JTIyJTNBJTIwJTdCJTIwJTIyeG1pbiUyMiUzQSUyMDMxJTJDJTIwJTIyeW1pbiUyMiUzQSUyMDY4JTJDJTIwJTIyeG1heCUyMiUzQSUyMDE5MCUyQyUyMCUyMnltYXglMjIlM0ElMjAxMTglMjAlN0QlMEElMkYlMkYlMjAlN0QlMkMlMEElMkYlMkYlMjAuLi4lMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjJzY29yZSUyMiUzQSUyMDAuOTk4NDA5MjExNjM1NTg5NiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2F0JTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyYm94JTIyJTNBJTIwJTdCJTIwJTIyeG1pbiUyMiUzQSUyMDMzMSUyQyUyMCUyMnltaW4lMjIlM0ElMjAxOSUyQyUyMCUyMnhtYXglMjIlM0ElMjA2NDklMkMlMjAlMjJ5bWF4JTIyJTNBJTIwMzcxJTIwJTdEJTBBJTJGJTJGJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> img = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;

<span class="hljs-keyword">let</span> detector = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;object-detection&#x27;</span>, <span class="hljs-string">&#x27;Xenova/detr-resnet-50&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">detector</span>(img, { <span class="hljs-attr">threshold</span>: <span class="hljs-number">0.9</span> });
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.9976370930671692,</span>
<span class="hljs-comment">//   &quot;label&quot;: &quot;remote&quot;,</span>
<span class="hljs-comment">//   &quot;box&quot;: { &quot;xmin&quot;: 31, &quot;ymin&quot;: 68, &quot;xmax&quot;: 190, &quot;ymax&quot;: 118 }</span>
<span class="hljs-comment">// },</span>
<span class="hljs-comment">// ...</span>
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.9984092116355896,</span>
<span class="hljs-comment">//   &quot;label&quot;: &quot;cat&quot;,</span>
<span class="hljs-comment">//   &quot;box&quot;: { &quot;xmin&quot;: 331, &quot;ymin&quot;: 19, &quot;xmax&quot;: 649, &quot;ymax&quot;: 371 }</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),xi=new h({props:{title:"new ObjectDetectionPipeline(options)",local:"new-objectdetectionpipelineoptions",headingTag:"h3"}}),ki=new h({props:{title:"objectDetectionPipeline._call(images, options)",local:"objectdetectionpipelinecallimages-options",headingTag:"h3"}}),Ni=new h({props:{title:"pipelines.ZeroShotObjectDetectionPipeline",local:"pipelineszeroshotobjectdetectionpipeline",headingTag:"h2"}}),_i=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/astronaut.png&#x27;</span>;
<span class="hljs-keyword">let</span> candidate_labels = [<span class="hljs-string">&#x27;human face&#x27;</span>, <span class="hljs-string">&#x27;rocket&#x27;</span>, <span class="hljs-string">&#x27;helmet&#x27;</span>, <span class="hljs-string">&#x27;american flag&#x27;</span>];
<span class="hljs-keyword">let</span> detector = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-object-detection&#x27;</span>, <span class="hljs-string">&#x27;Xenova/owlvit-base-patch32&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">detector</span>(url, candidate_labels);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.24392342567443848,</span>
<span class="hljs-comment">//     label: &#x27;human face&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 180, ymin: 67, xmax: 274, ymax: 175 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.15129457414150238,</span>
<span class="hljs-comment">//     label: &#x27;american flag&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 0, ymin: 4, xmax: 106, ymax: 513 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.13649864494800568,</span>
<span class="hljs-comment">//     label: &#x27;helmet&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 277, ymin: 337, xmax: 511, ymax: 511 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.10262022167444229,</span>
<span class="hljs-comment">//     label: &#x27;rocket&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 352, ymin: -1, xmax: 463, ymax: 287 }</span>
<span class="hljs-comment">//   }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Yi=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/beach.png&#x27;</span>;
<span class="hljs-keyword">let</span> candidate_labels = [<span class="hljs-string">&#x27;hat&#x27;</span>, <span class="hljs-string">&#x27;book&#x27;</span>, <span class="hljs-string">&#x27;sunglasses&#x27;</span>, <span class="hljs-string">&#x27;camera&#x27;</span>];
<span class="hljs-keyword">let</span> detector = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-object-detection&#x27;</span>, <span class="hljs-string">&#x27;Xenova/owlvit-base-patch32&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">detector</span>(url, candidate_labels, { <span class="hljs-attr">topk</span>: <span class="hljs-number">4</span>, <span class="hljs-attr">threshold</span>: <span class="hljs-number">0.05</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.1606510728597641,</span>
<span class="hljs-comment">//     label: &#x27;sunglasses&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 347, ymin: 229, xmax: 429, ymax: 264 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.08935828506946564,</span>
<span class="hljs-comment">//     label: &#x27;hat&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 38, ymin: 174, xmax: 258, ymax: 364 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.08530698716640472,</span>
<span class="hljs-comment">//     label: &#x27;camera&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 187, ymin: 350, xmax: 260, ymax: 411 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.08349756896495819,</span>
<span class="hljs-comment">//     label: &#x27;book&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 261, ymin: 280, xmax: 494, ymax: 425 }</span>
<span class="hljs-comment">//   }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Pi=new h({props:{title:"new ZeroShotObjectDetectionPipeline(options)",local:"new-zeroshotobjectdetectionpipelineoptions",headingTag:"h3"}}),Si=new h({props:{title:"zeroShotObjectDetectionPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>",local:"zeroshotobjectdetectionpipelinecallimages-candidatelabels-options--code-promise--any--code",headingTag:"h3"}}),qi=new h({props:{title:"pipelines.DocumentQuestionAnsweringPipeline",local:"pipelinesdocumentquestionansweringpipeline",headingTag:"h2"}}),en=new u({props:{code:"bGV0JTIwaW1hZ2UlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmludm9pY2UucG5nJyUzQiUwQWxldCUyMHF1ZXN0aW9uJTIwJTNEJTIwJ1doYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YnJTNCJTBBJTBBbGV0JTIwcWFfcGlwZWxpbmUlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdkb2N1bWVudC1xdWVzdGlvbi1hbnN3ZXJpbmcnJTJDJTIwJ1hlbm92YSUyRmRvbnV0LWJhc2UtZmluZXR1bmVkLWRvY3ZxYScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBxYV9waXBlbGluZShpbWFnZSUyQyUyMHF1ZXN0aW9uKSUzQiUwQSUyRiUyRiUyMCU1QiU3QiUyMGFuc3dlciUzQSUyMCd1cy0wMDEnJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> image = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/invoice.png&#x27;</span>;
<span class="hljs-keyword">let</span> question = <span class="hljs-string">&#x27;What is the invoice number?&#x27;</span>;

<span class="hljs-keyword">let</span> qa_pipeline = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;document-question-answering&#x27;</span>, <span class="hljs-string">&#x27;Xenova/donut-base-finetuned-docvqa&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">qa_pipeline</span>(image, question);
<span class="hljs-comment">// [{ answer: &#x27;us-001&#x27; }]</span>`,wrap:!1}}),nn=new h({props:{title:"new DocumentQuestionAnsweringPipeline(options)",local:"new-documentquestionansweringpipelineoptions",headingTag:"h3"}}),dn=new h({props:{title:"documentQuestionAnsweringPipeline._call(image, question, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"documentquestionansweringpipelinecallimage-question-generatekwargs--code-promise--objectarray--object----code",headingTag:"h3"}}),mn=new h({props:{title:"pipelines.TextToAudioPipeline",local:"pipelinestexttoaudiopipeline",headingTag:"h2"}}),hn=new u({props:{code:"bGV0JTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZzcGVha2VyX2VtYmVkZGluZ3MuYmluJyUzQiUwQWxldCUyMHN5bnRoZXNpemVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC10by1zcGVlY2gnJTJDJTIwJ1hlbm92YSUyRnNwZWVjaHQ1X3R0cyclMkMlMjAlN0IlMjBxdWFudGl6ZWQlM0ElMjBmYWxzZSUyMCU3RCklM0IlMEFsZXQlMjBvdXQlMjAlM0QlMjBhd2FpdCUyMHN5bnRoZXNpemVyKCdIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJyUyQyUyMCU3QiUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBhdWRpbyUzQSUyMEZsb2F0MzJBcnJheSgyNjExMiklMjAlNUItMC4wMDAwNTY1NzMzNzg5Njk5MTUyMSUyQyUyMDAuMDAwMjA1ODM4NzQ3MjA2MTQ0MDMlMkMlMjAuLi4lNUQlMkMlMEElMkYlMkYlMjAlMjAlMjBzYW1wbGluZ19yYXRlJTNBJTIwMTYwMDAlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> speaker_embeddings = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/speaker_embeddings.bin&#x27;</span>;
<span class="hljs-keyword">let</span> synthesizer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-to-speech&#x27;</span>, <span class="hljs-string">&#x27;Xenova/speecht5_tts&#x27;</span>, { <span class="hljs-attr">quantized</span>: <span class="hljs-literal">false</span> });
<span class="hljs-keyword">let</span> out = <span class="hljs-keyword">await</span> <span class="hljs-title function_">synthesizer</span>(<span class="hljs-string">&#x27;Hello, my dog is cute&#x27;</span>, { speaker_embeddings });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   audio: Float32Array(26112) [-0.00005657337896991521, 0.00020583874720614403, ...],</span>
<span class="hljs-comment">//   sampling_rate: 16000</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),wn=new u({props:{code:"aW1wb3J0JTIwd2F2ZWZpbGUlMjBmcm9tJTIwJ3dhdmVmaWxlJyUzQiUwQWltcG9ydCUyMGZzJTIwZnJvbSUyMCdmcyclM0IlMEElMEFsZXQlMjB3YXYlMjAlM0QlMjBuZXclMjB3YXZlZmlsZS5XYXZlRmlsZSgpJTNCJTBBd2F2LmZyb21TY3JhdGNoKDElMkMlMjBvdXQuc2FtcGxpbmdfcmF0ZSUyQyUyMCczMmYnJTJDJTIwb3V0LmF1ZGlvKSUzQiUwQWZzLndyaXRlRmlsZVN5bmMoJ291dC53YXYnJTJDJTIwd2F2LnRvQnVmZmVyKCkpJTNC",highlighted:`<span class="hljs-keyword">import</span> wavefile <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;wavefile&#x27;</span>;
<span class="hljs-keyword">import</span> fs <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;fs&#x27;</span>;

<span class="hljs-keyword">let</span> wav = <span class="hljs-keyword">new</span> wavefile.<span class="hljs-title class_">WaveFile</span>();
wav.<span class="hljs-title function_">fromScratch</span>(<span class="hljs-number">1</span>, out.<span class="hljs-property">sampling_rate</span>, <span class="hljs-string">&#x27;32f&#x27;</span>, out.<span class="hljs-property">audio</span>);
fs.<span class="hljs-title function_">writeFileSync</span>(<span class="hljs-string">&#x27;out.wav&#x27;</span>, wav.<span class="hljs-title function_">toBuffer</span>());`,wrap:!1}}),bn=new h({props:{title:"new TextToAudioPipeline(options)",local:"new-texttoaudiopipelineoptions",headingTag:"h3"}}),In=new h({props:{title:"textToAudioPipeline._call(text_inputs, options) ⇒ <code> Promise. < Object > </code>",local:"texttoaudiopipelinecalltextinputs-options--code-promise--object--code",headingTag:"h3"}}),Zn=new h({props:{title:"pipelines.ImageToImagePipeline",local:"pipelinesimagetoimagepipeline",headingTag:"h2"}}),vn=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZidXR0ZXJmbHkuanBnJyUzQiUwQWxldCUyMHVwc2NhbGVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnaW1hZ2UtdG8taW1hZ2UnJTJDJTIwJ1hlbm92YSUyRnN3aW4yU1ItY2xhc3NpY2FsLXNyLXgyLTY0JyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHVwc2NhbGVyKHVybCklM0IlMEElMkYlMkYlMjBSYXdJbWFnZSUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMGRhdGElM0ElMjBVaW50OEFycmF5KDc4NjQzMiklMjAlNUIlMjA0MSUyQyUyMDMxJTJDJTIwMjQlMkMlMjAlMjA0MyUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMHdpZHRoJTNBJTIwNTEyJTJDJTBBJTJGJTJGJTIwJTIwJTIwaGVpZ2h0JTNBJTIwNTEyJTJDJTBBJTJGJTJGJTIwJTIwJTIwY2hhbm5lbHMlM0ElMjAzJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/butterfly.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> upscaler = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-image&#x27;</span>, <span class="hljs-string">&#x27;Xenova/swin2SR-classical-sr-x2-64&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">upscaler</span>(url);
<span class="hljs-comment">// RawImage {</span>
<span class="hljs-comment">//   data: Uint8Array(786432) [ 41, 31, 24,  43, ... ],</span>
<span class="hljs-comment">//   width: 512,</span>
<span class="hljs-comment">//   height: 512,</span>
<span class="hljs-comment">//   channels: 3</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Yn=new h({props:{title:"imageToImagePipeline._call(images) ⇒ <code> Promise. < any > </code>",local:"imagetoimagepipelinecallimages--code-promise--any--code",headingTag:"h3"}}),Hn=new h({props:{title:"pipelines.DepthEstimationPipeline",local:"pipelinesdepthestimationpipeline",headingTag:"h2"}}),Sn=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEFsZXQlMjBkZXB0aF9lc3RpbWF0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdkZXB0aC1lc3RpbWF0aW9uJyUyQyUyMCdYZW5vdmElMkZkcHQtaHlicmlkLW1pZGFzJyklM0IlMEFsZXQlMjBvdXQlMjAlM0QlMjBhd2FpdCUyMGRlcHRoX2VzdGltYXRvcih1cmwpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoJTNBJTIwVGVuc29yJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwZGltcyUzQSUyMCU1QiUyMDM4NCUyQyUyMDM4NCUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5KDE0NzQ1NiklMjAlNUIlMjA1NDIuODU5MTMwODU5Mzc1JTJDJTIwNTQ1LjI4MzM4NjIzMDQ2ODglMkMlMjA1NDYuMTY0OTE2OTkyMTg3NSUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMHNpemUlM0ElMjAxNDc0NTYlMEElMkYlMkYlMjAlMjAlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjBkZXB0aCUzQSUyMFJhd0ltYWdlJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwZGF0YSUzQSUyMFVpbnQ4QXJyYXkoMzA3MjAwKSUyMCU1QiUyMDg2JTJDJTIwODYlMkMlMjA4NiUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMHdpZHRoJTNBJTIwNjQwJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwaGVpZ2h0JTNBJTIwNDgwJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwY2hhbm5lbHMlM0ElMjAxJTBBJTJGJTJGJTIwJTIwJTIwJTdEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> depth_estimator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;depth-estimation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/dpt-hybrid-midas&#x27;</span>);
<span class="hljs-keyword">let</span> out = <span class="hljs-keyword">await</span> <span class="hljs-title function_">depth_estimator</span>(url);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   predicted_depth: Tensor {</span>
<span class="hljs-comment">//     dims: [ 384, 384 ],</span>
<span class="hljs-comment">//     type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//     data: Float32Array(147456) [ 542.859130859375, 545.2833862304688, 546.1649169921875, ... ],</span>
<span class="hljs-comment">//     size: 147456</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   depth: RawImage {</span>
<span class="hljs-comment">//     data: Uint8Array(307200) [ 86, 86, 86, ... ],</span>
<span class="hljs-comment">//     width: 640,</span>
<span class="hljs-comment">//     height: 480,</span>
<span class="hljs-comment">//     channels: 1</span>
<span class="hljs-comment">//   }</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Dn=new h({props:{title:"depthEstimationPipeline._call(images) ⇒ <code> Promise. < any > </code>",local:"depthestimationpipelinecallimages--code-promise--any--code",headingTag:"h3"}}),ea=new h({props:{title:"pipelines.pipeline(task, [model], [options]) ⇒ <code> Promise. < Pipeline > </code>",local:"pipelinespipelinetask-model-options--code-promise--pipeline--code",headingTag:"h2"}}),aa=new h({props:{title:"pipelines~QuestionAnsweringResult : <code> object </code>",local:"pipelinesquestionansweringresult--code-object-code",headingTag:"h2"}}),ca=new h({props:{title:"pipelines~QuestionAnsweringReturnType : <code> Promise. < (QuestionAnsweringResult|Array < QuestionAnsweringResult > ) > </code>",local:"pipelinesquestionansweringreturntype--code-promise--questionansweringresultarray--questionansweringresult----code",headingTag:"h2"}}),Ta=new h({props:{title:"pipelines~ChunkCallback : <code> function </code>",local:"pipelineschunkcallback--code-function-code",headingTag:"h2"}}),{c(){w=a("meta"),ua=i(),Ja=a("p"),wa=i(),j=a("a"),ja=i(),c(U.$$.fragment),Ua=i(),f=a("p"),f.textContent=Ay,fa=i(),b=a("p"),b.innerHTML=vy,ba=i(),c(x.$$.fragment),xa=i(),C=a("ul"),C.innerHTML=_y,Ca=i(),ga=a("hr"),Ia=i(),g=a("a"),ka=i(),c(I.$$.fragment),Ga=i(),k=a("p"),k.textContent=Ry,Qa=i(),G=a("p"),G.innerHTML=Yy,Ba=i(),Q=a("ul"),Q.innerHTML=$y,Za=i(),Na=a("hr"),Aa=i(),B=a("a"),va=i(),c(Z.$$.fragment),_a=i(),N=a("p"),N.textContent=Vy,Ra=i(),A=a("table"),A.innerHTML=Ey,Ya=i(),$a=a("hr"),Va=i(),v=a("a"),Ea=i(),c(_.$$.fragment),Pa=i(),R=a("p"),R.textContent=Py,Ha=i(),Y=a("p"),Y.innerHTML=Hy,za=i(),Wa=a("hr"),Sa=i(),$=a("a"),Xa=i(),c(V.$$.fragment),La=i(),E=a("p"),E.textContent=zy,Da=i(),P=a("p"),P.innerHTML=Wy,Fa=i(),H=a("table"),H.innerHTML=Sy,qa=i(),Oa=a("hr"),Ka=i(),z=a("a"),ep=i(),c(W.$$.fragment),tp=i(),S=a("p"),S.innerHTML=Xy,lp=i(),X=a("p"),X.innerHTML=Ly,sp=i(),c(L.$$.fragment),ip=i(),D=a("p"),D.innerHTML=Dy,np=i(),c(F.$$.fragment),ap=i(),q=a("p"),q.innerHTML=Fy,pp=i(),c(O.$$.fragment),op=i(),K=a("p"),K.innerHTML=qy,dp=i(),cp=a("hr"),Mp=i(),ee=a("a"),rp=i(),c(te.$$.fragment),Tp=i(),le=a("p"),le.textContent=Oy,mp=i(),se=a("p"),se.innerHTML=Ky,yp=i(),ie=a("table"),ie.innerHTML=eJ,Jp=i(),hp=a("hr"),up=i(),ne=a("a"),wp=i(),c(ae.$$.fragment),jp=i(),pe=a("p"),pe.innerHTML=tJ,Up=i(),oe=a("p"),oe.innerHTML=lJ,fp=i(),c(de.$$.fragment),bp=i(),ce=a("p"),ce.innerHTML=sJ,xp=i(),c(Me.$$.fragment),Cp=i(),re=a("p"),re.innerHTML=iJ,gp=i(),Ip=a("hr"),kp=i(),Te=a("a"),Gp=i(),c(me.$$.fragment),Qp=i(),ye=a("p"),ye.textContent=nJ,Bp=i(),Je=a("p"),Je.innerHTML=aJ,Zp=i(),he=a("table"),he.innerHTML=pJ,Np=i(),Ap=a("hr"),vp=i(),ue=a("a"),_p=i(),c(we.$$.fragment),Rp=i(),je=a("p"),je.innerHTML=oJ,Yp=i(),Ue=a("p"),Ue.innerHTML=dJ,$p=i(),c(fe.$$.fragment),Vp=i(),be=a("p"),be.innerHTML=cJ,Ep=i(),Pp=a("hr"),Hp=i(),xe=a("a"),zp=i(),c(Ce.$$.fragment),Wp=i(),ge=a("p"),ge.textContent=MJ,Sp=i(),Ie=a("p"),Ie.innerHTML=rJ,Xp=i(),ke=a("table"),ke.innerHTML=TJ,Lp=i(),Dp=a("hr"),Fp=i(),Ge=a("a"),qp=i(),c(Qe.$$.fragment),Op=i(),Be=a("p"),Be.innerHTML=mJ,Kp=i(),Ze=a("p"),Ze.innerHTML=yJ,eo=i(),c(Ne.$$.fragment),to=i(),Ae=a("p"),Ae.innerHTML=JJ,lo=i(),c(ve.$$.fragment),so=i(),_e=a("p"),_e.innerHTML=hJ,io=i(),no=a("hr"),ao=i(),Re=a("a"),po=i(),c(Ye.$$.fragment),oo=i(),$e=a("p"),$e.textContent=uJ,co=i(),Ve=a("p"),Ve.innerHTML=wJ,Mo=i(),Ee=a("table"),Ee.innerHTML=jJ,ro=i(),To=a("hr"),mo=i(),Pe=a("a"),yo=i(),c(He.$$.fragment),Jo=i(),ze=a("p"),ze.textContent=UJ,ho=i(),We=a("p"),We.innerHTML=fJ,uo=i(),c(Se.$$.fragment),wo=i(),Xe=a("p"),Xe.innerHTML=bJ,jo=i(),Uo=a("hr"),fo=i(),Le=a("a"),bo=i(),c(De.$$.fragment),xo=i(),Fe=a("p"),Fe.textContent=xJ,Co=i(),qe=a("p"),qe.innerHTML=CJ,go=i(),Oe=a("ul"),Oe.innerHTML=gJ,Io=i(),Ke=a("table"),Ke.innerHTML=IJ,ko=i(),Go=a("hr"),Qo=i(),et=a("a"),Bo=i(),c(tt.$$.fragment),Zo=i(),lt=a("p"),lt.textContent=kJ,No=i(),st=a("p"),st.innerHTML=GJ,Ao=i(),c(it.$$.fragment),vo=i(),nt=a("p"),nt.innerHTML=QJ,_o=i(),Ro=a("hr"),Yo=i(),at=a("a"),$o=i(),c(pt.$$.fragment),Vo=i(),ot=a("p"),ot.textContent=BJ,Eo=i(),dt=a("p"),dt.innerHTML=ZJ,Po=i(),ct=a("p"),ct.innerHTML=NJ,Ho=i(),c(Mt.$$.fragment),zo=i(),rt=a("p"),rt.innerHTML=AJ,Wo=i(),Tt=a("p"),Tt.innerHTML=vJ,So=i(),c(mt.$$.fragment),Xo=i(),yt=a("p"),yt.innerHTML=_J,Lo=i(),Jt=a("p"),Jt.innerHTML=RJ,Do=i(),c(ht.$$.fragment),Fo=i(),ut=a("p"),ut.innerHTML=YJ,qo=i(),Oo=a("hr"),Ko=i(),wt=a("a"),ed=i(),c(jt.$$.fragment),td=i(),Ut=a("p"),Ut.innerHTML=$J,ld=i(),ft=a("p"),ft.innerHTML=VJ,sd=i(),c(bt.$$.fragment),id=i(),xt=a("p"),xt.innerHTML=EJ,nd=i(),c(Ct.$$.fragment),ad=i(),gt=a("p"),gt.innerHTML=PJ,pd=i(),c(It.$$.fragment),od=i(),kt=a("p"),kt.innerHTML=HJ,dd=i(),cd=a("hr"),Md=i(),Gt=a("a"),rd=i(),c(Qt.$$.fragment),Td=i(),Bt=a("p"),Bt.textContent=zJ,md=i(),Zt=a("p"),Zt.innerHTML=WJ,yd=i(),Nt=a("table"),Nt.innerHTML=SJ,Jd=i(),hd=a("hr"),ud=i(),At=a("a"),wd=i(),c(vt.$$.fragment),jd=i(),_t=a("p"),_t.innerHTML=XJ,Ud=i(),Rt=a("p"),Rt.innerHTML=LJ,fd=i(),c(Yt.$$.fragment),bd=i(),$t=a("p"),$t.innerHTML=DJ,xd=i(),c(Vt.$$.fragment),Cd=i(),Et=a("p"),Et.innerHTML=FJ,gd=i(),Pt=a("ul"),Pt.innerHTML=qJ,Id=i(),kd=a("hr"),Gd=i(),Ht=a("a"),Qd=i(),c(zt.$$.fragment),Bd=i(),Wt=a("p"),Wt.textContent=OJ,Zd=i(),St=a("table"),St.innerHTML=KJ,Nd=i(),Ad=a("hr"),vd=i(),Xt=a("a"),_d=i(),c(Lt.$$.fragment),Rd=i(),Dt=a("p"),Dt.innerHTML=eh,Yd=i(),Ft=a("table"),Ft.innerHTML=th,$d=i(),Vd=a("hr"),Ed=i(),qt=a("a"),Pd=i(),c(Ot.$$.fragment),Hd=i(),Kt=a("p"),Kt.textContent=lh,zd=i(),el=a("p"),el.innerHTML=sh,Wd=i(),c(tl.$$.fragment),Sd=i(),ll=a("p"),ll.innerHTML=ih,Xd=i(),c(sl.$$.fragment),Ld=i(),il=a("p"),il.innerHTML=nh,Dd=i(),c(nl.$$.fragment),Fd=i(),al=a("p"),al.innerHTML=ah,qd=i(),Od=a("hr"),Kd=i(),pl=a("a"),ec=i(),c(ol.$$.fragment),tc=i(),dl=a("p"),dl.textContent=ph,lc=i(),cl=a("p"),cl.innerHTML=oh,sc=i(),Ml=a("table"),Ml.innerHTML=dh,ic=i(),nc=a("hr"),ac=i(),rl=a("a"),pc=i(),c(Tl.$$.fragment),oc=i(),ml=a("p"),ml.innerHTML=ch,dc=i(),yl=a("p"),yl.innerHTML=Mh,cc=i(),c(Jl.$$.fragment),Mc=i(),hl=a("p"),hl.innerHTML=rh,rc=i(),ul=a("ul"),ul.innerHTML=Th,Tc=i(),mc=a("hr"),yc=i(),wl=a("a"),Jc=i(),c(jl.$$.fragment),hc=i(),Ul=a("p"),Ul.textContent=mh,uc=i(),fl=a("table"),fl.innerHTML=yh,wc=i(),jc=a("hr"),Uc=i(),bl=a("a"),fc=i(),c(xl.$$.fragment),bc=i(),Cl=a("p"),Cl.textContent=Jh,xc=i(),gl=a("p"),gl.innerHTML=hh,Cc=i(),Il=a("table"),Il.innerHTML=uh,gc=i(),Ic=a("hr"),kc=i(),kl=a("a"),Gc=i(),c(Gl.$$.fragment),Qc=i(),Ql=a("p"),Ql.textContent=wh,Bc=i(),Bl=a("p"),Bl.innerHTML=jh,Zc=i(),c(Zl.$$.fragment),Nc=i(),Nl=a("p"),Nl.innerHTML=Uh,Ac=i(),c(Al.$$.fragment),vc=i(),vl=a("p"),vl.innerHTML=fh,_c=i(),c(_l.$$.fragment),Rc=i(),Rl=a("p"),Rl.innerHTML=bh,Yc=i(),c(Yl.$$.fragment),$c=i(),$l=a("p"),$l.innerHTML=xh,Vc=i(),c(Vl.$$.fragment),Ec=i(),El=a("p"),El.innerHTML=Ch,Pc=i(),c(Pl.$$.fragment),Hc=i(),Hl=a("p"),Hl.innerHTML=gh,zc=i(),zl=a("ul"),zl.innerHTML=Ih,Wc=i(),Sc=a("hr"),Xc=i(),Wl=a("a"),Lc=i(),c(Sl.$$.fragment),Dc=i(),Xl=a("p"),Xl.textContent=kh,Fc=i(),Ll=a("table"),Ll.innerHTML=Gh,qc=i(),Oc=a("hr"),Kc=i(),Dl=a("a"),eM=i(),c(Fl.$$.fragment),tM=i(),ql=a("p"),ql.textContent=Qh,lM=i(),Ol=a("p"),Ol.innerHTML=Bh,sM=i(),Kl=a("table"),Kl.innerHTML=Zh,iM=i(),nM=a("hr"),aM=i(),es=a("a"),pM=i(),c(ts.$$.fragment),oM=i(),ls=a("p"),ls.innerHTML=Nh,dM=i(),ss=a("p"),ss.innerHTML=Ah,cM=i(),c(is.$$.fragment),MM=i(),ns=a("p"),ns.innerHTML=vh,rM=i(),c(as.$$.fragment),TM=i(),ps=a("p"),ps.innerHTML=_h,mM=i(),os=a("ul"),os.innerHTML=Rh,yM=i(),JM=a("hr"),hM=i(),ds=a("a"),uM=i(),c(cs.$$.fragment),wM=i(),Ms=a("p"),Ms.textContent=Yh,jM=i(),rs=a("table"),rs.innerHTML=$h,UM=i(),fM=a("hr"),bM=i(),Ts=a("a"),xM=i(),c(ms.$$.fragment),CM=i(),ys=a("p"),ys.textContent=Vh,gM=i(),Js=a("p"),Js.innerHTML=Eh,IM=i(),hs=a("table"),hs.innerHTML=Ph,kM=i(),GM=a("hr"),QM=i(),us=a("a"),BM=i(),c(ws.$$.fragment),ZM=i(),js=a("p"),js.innerHTML=Hh,NM=i(),Us=a("p"),Us.innerHTML=zh,AM=i(),c(fs.$$.fragment),vM=i(),bs=a("p"),bs.innerHTML=Wh,_M=i(),c(xs.$$.fragment),RM=i(),Cs=a("p"),Cs.innerHTML=Sh,YM=i(),c(gs.$$.fragment),$M=i(),Is=a("p"),Is.innerHTML=Xh,VM=i(),ks=a("ul"),ks.innerHTML=Lh,EM=i(),PM=a("hr"),HM=i(),Gs=a("a"),zM=i(),c(Qs.$$.fragment),WM=i(),Bs=a("p"),Bs.textContent=Dh,SM=i(),Zs=a("table"),Zs.innerHTML=Fh,XM=i(),LM=a("hr"),DM=i(),Ns=a("a"),FM=i(),c(As.$$.fragment),qM=i(),vs=a("p"),vs.textContent=qh,OM=i(),_s=a("p"),_s.innerHTML=Oh,KM=i(),Rs=a("table"),Rs.innerHTML=Kh,er=i(),tr=a("hr"),lr=i(),Ys=a("a"),sr=i(),c($s.$$.fragment),ir=i(),Vs=a("p"),Vs.innerHTML=eu,nr=i(),Es=a("p"),Es.innerHTML=tu,ar=i(),c(Ps.$$.fragment),pr=i(),Hs=a("p"),Hs.innerHTML=lu,or=i(),zs=a("ul"),zs.innerHTML=su,dr=i(),cr=a("hr"),Mr=i(),Ws=a("a"),rr=i(),c(Ss.$$.fragment),Tr=i(),Xs=a("p"),Xs.textContent=iu,mr=i(),Ls=a("table"),Ls.innerHTML=nu,yr=i(),Jr=a("hr"),hr=i(),Ds=a("a"),ur=i(),c(Fs.$$.fragment),wr=i(),qs=a("p"),qs.textContent=au,jr=i(),Os=a("p"),Os.innerHTML=pu,Ur=i(),Ks=a("table"),Ks.innerHTML=ou,fr=i(),br=a("hr"),xr=i(),ei=a("a"),Cr=i(),c(ti.$$.fragment),gr=i(),li=a("p"),li.innerHTML=du,Ir=i(),si=a("p"),si.innerHTML=cu,kr=i(),c(ii.$$.fragment),Gr=i(),ni=a("p"),ni.innerHTML=Mu,Qr=i(),ai=a("ul"),ai.innerHTML=ru,Br=i(),Zr=a("hr"),Nr=i(),pi=a("a"),Ar=i(),c(oi.$$.fragment),vr=i(),di=a("p"),di.textContent=Tu,_r=i(),ci=a("table"),ci.innerHTML=mu,Rr=i(),Yr=a("hr"),$r=i(),Mi=a("a"),Vr=i(),c(ri.$$.fragment),Er=i(),Ti=a("p"),Ti.textContent=yu,Pr=i(),mi=a("p"),mi.innerHTML=Ju,Hr=i(),yi=a("table"),yi.innerHTML=hu,zr=i(),Wr=a("hr"),Sr=i(),Ji=a("a"),Xr=i(),c(hi.$$.fragment),Lr=i(),ui=a("p"),ui.innerHTML=uu,Dr=i(),wi=a("p"),wi.innerHTML=wu,Fr=i(),c(ji.$$.fragment),qr=i(),Ui=a("p"),Ui.innerHTML=ju,Or=i(),fi=a("ul"),fi.innerHTML=Uu,Kr=i(),eT=a("hr"),tT=i(),bi=a("a"),lT=i(),c(xi.$$.fragment),sT=i(),Ci=a("p"),Ci.textContent=fu,iT=i(),gi=a("table"),gi.innerHTML=bu,nT=i(),aT=a("hr"),pT=i(),Ii=a("a"),oT=i(),c(ki.$$.fragment),dT=i(),Gi=a("p"),Gi.textContent=xu,cT=i(),Qi=a("p"),Qi.innerHTML=Cu,MT=i(),Bi=a("table"),Bi.innerHTML=gu,rT=i(),TT=a("hr"),mT=i(),Zi=a("a"),yT=i(),c(Ni.$$.fragment),JT=i(),Ai=a("p"),Ai.innerHTML=Iu,hT=i(),vi=a("p"),vi.innerHTML=ku,uT=i(),c(_i.$$.fragment),wT=i(),Ri=a("p"),Ri.innerHTML=Gu,jT=i(),c(Yi.$$.fragment),UT=i(),$i=a("p"),$i.innerHTML=Qu,fT=i(),Vi=a("ul"),Vi.innerHTML=Bu,bT=i(),xT=a("hr"),CT=i(),Ei=a("a"),gT=i(),c(Pi.$$.fragment),IT=i(),Hi=a("p"),Hi.textContent=Zu,kT=i(),zi=a("table"),zi.innerHTML=Nu,GT=i(),QT=a("hr"),BT=i(),Wi=a("a"),ZT=i(),c(Si.$$.fragment),NT=i(),Xi=a("p"),Xi.textContent=Au,AT=i(),Li=a("p"),Li.innerHTML=vu,vT=i(),Di=a("table"),Di.innerHTML=_u,_T=i(),RT=a("hr"),YT=i(),Fi=a("a"),$T=i(),c(qi.$$.fragment),VT=i(),Oi=a("p"),Oi.innerHTML=Ru,ET=i(),Ki=a("p"),Ki.innerHTML=Yu,PT=i(),c(en.$$.fragment),HT=i(),tn=a("p"),tn.innerHTML=$u,zT=i(),ln=a("ul"),ln.innerHTML=Vu,WT=i(),ST=a("hr"),XT=i(),sn=a("a"),LT=i(),c(nn.$$.fragment),DT=i(),an=a("p"),an.textContent=Eu,FT=i(),pn=a("table"),pn.innerHTML=Pu,qT=i(),OT=a("hr"),KT=i(),on=a("a"),em=i(),c(dn.$$.fragment),tm=i(),cn=a("p"),cn.textContent=Hu,lm=i(),Mn=a("p"),Mn.innerHTML=zu,sm=i(),rn=a("table"),rn.innerHTML=Wu,im=i(),nm=a("hr"),am=i(),Tn=a("a"),pm=i(),c(mn.$$.fragment),om=i(),yn=a("p"),yn.innerHTML=Su,dm=i(),Jn=a("p"),Jn.innerHTML=Xu,cm=i(),c(hn.$$.fragment),Mm=i(),un=a("p"),un.innerHTML=Lu,rm=i(),c(wn.$$.fragment),Tm=i(),jn=a("p"),jn.innerHTML=Du,mm=i(),Un=a("ul"),Un.innerHTML=Fu,ym=i(),Jm=a("hr"),hm=i(),fn=a("a"),um=i(),c(bn.$$.fragment),wm=i(),xn=a("p"),xn.textContent=qu,jm=i(),Cn=a("table"),Cn.innerHTML=Ou,Um=i(),fm=a("hr"),bm=i(),gn=a("a"),xm=i(),c(In.$$.fragment),Cm=i(),kn=a("p"),kn.textContent=Ku,gm=i(),Gn=a("p"),Gn.innerHTML=ew,Im=i(),Qn=a("table"),Qn.innerHTML=tw,km=i(),Gm=a("hr"),Qm=i(),Bn=a("a"),Bm=i(),c(Zn.$$.fragment),Zm=i(),Nn=a("p"),Nn.innerHTML=lw,Nm=i(),An=a("p"),An.innerHTML=sw,Am=i(),c(vn.$$.fragment),vm=i(),_n=a("p"),_n.innerHTML=iw,_m=i(),Rm=a("hr"),Ym=i(),Rn=a("a"),$m=i(),c(Yn.$$.fragment),Vm=i(),$n=a("p"),$n.textContent=nw,Em=i(),Vn=a("p"),Vn.innerHTML=aw,Pm=i(),En=a("table"),En.innerHTML=pw,Hm=i(),zm=a("hr"),Wm=i(),Pn=a("a"),Sm=i(),c(Hn.$$.fragment),Xm=i(),zn=a("p"),zn.innerHTML=ow,Lm=i(),Wn=a("p"),Wn.innerHTML=dw,Dm=i(),c(Sn.$$.fragment),Fm=i(),Xn=a("p"),Xn.innerHTML=cw,qm=i(),Om=a("hr"),Km=i(),Ln=a("a"),ey=i(),c(Dn.$$.fragment),ty=i(),Fn=a("p"),Fn.textContent=Mw,ly=i(),qn=a("p"),qn.innerHTML=rw,sy=i(),On=a("table"),On.innerHTML=Tw,iy=i(),ny=a("hr"),ay=i(),Kn=a("a"),py=i(),c(ea.$$.fragment),oy=i(),ta=a("p"),ta.innerHTML=mw,dy=i(),la=a("p"),la.innerHTML=yw,cy=i(),sa=a("ul"),sa.innerHTML=Jw,My=i(),ia=a("table"),ia.innerHTML=hw,ry=i(),Ty=a("hr"),my=i(),na=a("a"),yy=i(),c(aa.$$.fragment),Jy=i(),pa=a("p"),pa.innerHTML=uw,hy=i(),oa=a("table"),oa.innerHTML=ww,uy=i(),wy=a("hr"),jy=i(),da=a("a"),Uy=i(),c(ca.$$.fragment),fy=i(),Ma=a("p"),Ma.innerHTML=jw,by=i(),xy=a("hr"),Cy=i(),ra=a("a"),gy=i(),c(Ta.$$.fragment),Iy=i(),ma=a("p"),ma.innerHTML=Uw,ky=i(),ya=a("table"),ya.innerHTML=fw,Gy=i(),Qy=a("hr"),By=i(),ha=a("p"),this.h()},l(e){const t=kw("svelte-u9bgzb",document.head);w=p(t,"META",{name:!0,content:!0}),t.forEach(l),ua=n(e),Ja=p(e,"P",{}),J(Ja).forEach(l),wa=n(e),j=p(e,"A",{id:!0,class:!0}),J(j).forEach(l),ja=n(e),M(U.$$.fragment,e),Ua=n(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1inm2t9"&&(f.textContent=Ay),fa=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1pjech"&&(b.innerHTML=vy),ba=n(e),M(x.$$.fragment,e),xa=n(e),C=p(e,"UL",{"data-svelte-h":!0}),o(C)!=="svelte-11340v2"&&(C.innerHTML=_y),Ca=n(e),ga=p(e,"HR",{}),Ia=n(e),g=p(e,"A",{id:!0,class:!0}),J(g).forEach(l),ka=n(e),M(I.$$.fragment,e),Ga=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-16ix8v2"&&(k.textContent=Ry),Qa=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1olpg2f"&&(G.innerHTML=Yy),Ba=n(e),Q=p(e,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-1wo4saj"&&(Q.innerHTML=$y),Za=n(e),Na=p(e,"HR",{}),Aa=n(e),B=p(e,"A",{id:!0,class:!0}),J(B).forEach(l),va=n(e),M(Z.$$.fragment,e),_a=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-10jkwj"&&(N.textContent=Vy),Ra=n(e),A=p(e,"TABLE",{"data-svelte-h":!0}),o(A)!=="svelte-13q0syp"&&(A.innerHTML=Ey),Ya=n(e),$a=p(e,"HR",{}),Va=n(e),v=p(e,"A",{id:!0,class:!0}),J(v).forEach(l),Ea=n(e),M(_.$$.fragment,e),Pa=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1yhr8qe"&&(R.textContent=Py),Ha=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1yqombv"&&(Y.innerHTML=Hy),za=n(e),Wa=p(e,"HR",{}),Sa=n(e),$=p(e,"A",{id:!0,class:!0}),J($).forEach(l),Xa=n(e),M(V.$$.fragment,e),La=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-phuke9"&&(E.textContent=zy),Da=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1xajepz"&&(P.innerHTML=Wy),Fa=n(e),H=p(e,"TABLE",{"data-svelte-h":!0}),o(H)!=="svelte-1dl6le6"&&(H.innerHTML=Sy),qa=n(e),Oa=p(e,"HR",{}),Ka=n(e),z=p(e,"A",{id:!0,class:!0}),J(z).forEach(l),ep=n(e),M(W.$$.fragment,e),tp=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1aega0x"&&(S.innerHTML=Xy),lp=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-twv4w2"&&(X.innerHTML=Ly),sp=n(e),M(L.$$.fragment,e),ip=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-9l8wqs"&&(D.innerHTML=Dy),np=n(e),M(F.$$.fragment,e),ap=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-63pkoo"&&(q.innerHTML=Fy),pp=n(e),M(O.$$.fragment,e),op=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-s10qq4"&&(K.innerHTML=qy),dp=n(e),cp=p(e,"HR",{}),Mp=n(e),ee=p(e,"A",{id:!0,class:!0}),J(ee).forEach(l),rp=n(e),M(te.$$.fragment,e),Tp=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-319swt"&&(le.textContent=Oy),mp=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1vshn55"&&(se.innerHTML=Ky),yp=n(e),ie=p(e,"TABLE",{"data-svelte-h":!0}),o(ie)!=="svelte-mqkhxk"&&(ie.innerHTML=eJ),Jp=n(e),hp=p(e,"HR",{}),up=n(e),ne=p(e,"A",{id:!0,class:!0}),J(ne).forEach(l),wp=n(e),M(ae.$$.fragment,e),jp=n(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-199l8oj"&&(pe.innerHTML=tJ),Up=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-3ojewp"&&(oe.innerHTML=lJ),fp=n(e),M(de.$$.fragment,e),bp=n(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1ln7q61"&&(ce.innerHTML=sJ),xp=n(e),M(Me.$$.fragment,e),Cp=n(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-s10qq4"&&(re.innerHTML=iJ),gp=n(e),Ip=p(e,"HR",{}),kp=n(e),Te=p(e,"A",{id:!0,class:!0}),J(Te).forEach(l),Gp=n(e),M(me.$$.fragment,e),Qp=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-qfvk6r"&&(ye.textContent=nJ),Bp=n(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1tvkl0p"&&(Je.innerHTML=aJ),Zp=n(e),he=p(e,"TABLE",{"data-svelte-h":!0}),o(he)!=="svelte-1p6smdx"&&(he.innerHTML=pJ),Np=n(e),Ap=p(e,"HR",{}),vp=n(e),ue=p(e,"A",{id:!0,class:!0}),J(ue).forEach(l),_p=n(e),M(we.$$.fragment,e),Rp=n(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-14f3xkz"&&(je.innerHTML=oJ),Yp=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-o2pgcr"&&(Ue.innerHTML=dJ),$p=n(e),M(fe.$$.fragment,e),Vp=n(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-s10qq4"&&(be.innerHTML=cJ),Ep=n(e),Pp=p(e,"HR",{}),Hp=n(e),xe=p(e,"A",{id:!0,class:!0}),J(xe).forEach(l),zp=n(e),M(Ce.$$.fragment,e),Wp=n(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-v1s8i"&&(ge.textContent=MJ),Sp=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1jet258"&&(Ie.innerHTML=rJ),Xp=n(e),ke=p(e,"TABLE",{"data-svelte-h":!0}),o(ke)!=="svelte-dmekw3"&&(ke.innerHTML=TJ),Lp=n(e),Dp=p(e,"HR",{}),Fp=n(e),Ge=p(e,"A",{id:!0,class:!0}),J(Ge).forEach(l),qp=n(e),M(Qe.$$.fragment,e),Op=n(e),Be=p(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-nzjx48"&&(Be.innerHTML=mJ),Kp=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1xict4f"&&(Ze.innerHTML=yJ),eo=n(e),M(Ne.$$.fragment,e),to=n(e),Ae=p(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1sz7ava"&&(Ae.innerHTML=JJ),lo=n(e),M(ve.$$.fragment,e),so=n(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-s10qq4"&&(_e.innerHTML=hJ),io=n(e),no=p(e,"HR",{}),ao=n(e),Re=p(e,"A",{id:!0,class:!0}),J(Re).forEach(l),po=n(e),M(Ye.$$.fragment,e),oo=n(e),$e=p(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1dgb1r"&&($e.textContent=uJ),co=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-ht5bcu"&&(Ve.innerHTML=wJ),Mo=n(e),Ee=p(e,"TABLE",{"data-svelte-h":!0}),o(Ee)!=="svelte-dhvci0"&&(Ee.innerHTML=jJ),ro=n(e),To=p(e,"HR",{}),mo=n(e),Pe=p(e,"A",{id:!0,class:!0}),J(Pe).forEach(l),yo=n(e),M(He.$$.fragment,e),Jo=n(e),ze=p(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-e2spcq"&&(ze.textContent=UJ),ho=n(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-j4hwgn"&&(We.innerHTML=fJ),uo=n(e),M(Se.$$.fragment,e),wo=n(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-s10qq4"&&(Xe.innerHTML=bJ),jo=n(e),Uo=p(e,"HR",{}),fo=n(e),Le=p(e,"A",{id:!0,class:!0}),J(Le).forEach(l),bo=n(e),M(De.$$.fragment,e),xo=n(e),Fe=p(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-1dgb1r"&&(Fe.textContent=xJ),Co=n(e),qe=p(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-k5n4xx"&&(qe.innerHTML=CJ),go=n(e),Oe=p(e,"UL",{"data-svelte-h":!0}),o(Oe)!=="svelte-wmzf9w"&&(Oe.innerHTML=gJ),Io=n(e),Ke=p(e,"TABLE",{"data-svelte-h":!0}),o(Ke)!=="svelte-18cf78d"&&(Ke.innerHTML=IJ),ko=n(e),Go=p(e,"HR",{}),Qo=n(e),et=p(e,"A",{id:!0,class:!0}),J(et).forEach(l),Bo=n(e),M(tt.$$.fragment,e),Zo=n(e),lt=p(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1axdht2"&&(lt.textContent=kJ),No=n(e),st=p(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-1416cqx"&&(st.innerHTML=GJ),Ao=n(e),M(it.$$.fragment,e),vo=n(e),nt=p(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-s10qq4"&&(nt.innerHTML=QJ),_o=n(e),Ro=p(e,"HR",{}),Yo=n(e),at=p(e,"A",{id:!0,class:!0}),J(at).forEach(l),$o=n(e),M(pt.$$.fragment,e),Vo=n(e),ot=p(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-3abd20"&&(ot.textContent=BJ),Eo=n(e),dt=p(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-1ut0vme"&&(dt.innerHTML=ZJ),Po=n(e),ct=p(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-dr1wsd"&&(ct.innerHTML=NJ),Ho=n(e),M(Mt.$$.fragment,e),zo=n(e),rt=p(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-mqh15a"&&(rt.innerHTML=AJ),Wo=n(e),Tt=p(e,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-zf4dht"&&(Tt.innerHTML=vJ),So=n(e),M(mt.$$.fragment,e),Xo=n(e),yt=p(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1877ohf"&&(yt.innerHTML=_J),Lo=n(e),Jt=p(e,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-1ox1juk"&&(Jt.innerHTML=RJ),Do=n(e),M(ht.$$.fragment,e),Fo=n(e),ut=p(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-s10qq4"&&(ut.innerHTML=YJ),qo=n(e),Oo=p(e,"HR",{}),Ko=n(e),wt=p(e,"A",{id:!0,class:!0}),J(wt).forEach(l),ed=n(e),M(jt.$$.fragment,e),td=n(e),Ut=p(e,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-1yek3op"&&(Ut.innerHTML=$J),ld=n(e),ft=p(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-11p32pq"&&(ft.innerHTML=VJ),sd=n(e),M(bt.$$.fragment,e),id=n(e),xt=p(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-1uqom1e"&&(xt.innerHTML=EJ),nd=n(e),M(Ct.$$.fragment,e),ad=n(e),gt=p(e,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1a7k67n"&&(gt.innerHTML=PJ),pd=n(e),M(It.$$.fragment,e),od=n(e),kt=p(e,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-s10qq4"&&(kt.innerHTML=HJ),dd=n(e),cd=p(e,"HR",{}),Md=n(e),Gt=p(e,"A",{id:!0,class:!0}),J(Gt).forEach(l),rd=n(e),M(Qt.$$.fragment,e),Td=n(e),Bt=p(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-6m3xhk"&&(Bt.textContent=zJ),md=n(e),Zt=p(e,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-1f5btis"&&(Zt.innerHTML=WJ),yd=n(e),Nt=p(e,"TABLE",{"data-svelte-h":!0}),o(Nt)!=="svelte-5kvkn6"&&(Nt.innerHTML=SJ),Jd=n(e),hd=p(e,"HR",{}),ud=n(e),At=p(e,"A",{id:!0,class:!0}),J(At).forEach(l),wd=n(e),M(vt.$$.fragment,e),jd=n(e),_t=p(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-104v5zf"&&(_t.innerHTML=XJ),Ud=n(e),Rt=p(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-17n9q32"&&(Rt.innerHTML=LJ),fd=n(e),M(Yt.$$.fragment,e),bd=n(e),$t=p(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-v99qry"&&($t.innerHTML=DJ),xd=n(e),M(Vt.$$.fragment,e),Cd=n(e),Et=p(e,"P",{"data-svelte-h":!0}),o(Et)!=="svelte-s10qq4"&&(Et.innerHTML=FJ),gd=n(e),Pt=p(e,"UL",{"data-svelte-h":!0}),o(Pt)!=="svelte-svwcak"&&(Pt.innerHTML=qJ),Id=n(e),kd=p(e,"HR",{}),Gd=n(e),Ht=p(e,"A",{id:!0,class:!0}),J(Ht).forEach(l),Qd=n(e),M(zt.$$.fragment,e),Bd=n(e),Wt=p(e,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-1n1xlcl"&&(Wt.textContent=OJ),Zd=n(e),St=p(e,"TABLE",{"data-svelte-h":!0}),o(St)!=="svelte-1h8f"&&(St.innerHTML=KJ),Nd=n(e),Ad=p(e,"HR",{}),vd=n(e),Xt=p(e,"A",{id:!0,class:!0}),J(Xt).forEach(l),_d=n(e),M(Lt.$$.fragment,e),Rd=n(e),Dt=p(e,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-c8gx4u"&&(Dt.innerHTML=eh),Yd=n(e),Ft=p(e,"TABLE",{"data-svelte-h":!0}),o(Ft)!=="svelte-y9oo3q"&&(Ft.innerHTML=th),$d=n(e),Vd=p(e,"HR",{}),Ed=n(e),qt=p(e,"A",{id:!0,class:!0}),J(qt).forEach(l),Pd=n(e),M(Ot.$$.fragment,e),Hd=n(e),Kt=p(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-tzucv0"&&(Kt.textContent=lh),zd=n(e),el=p(e,"P",{"data-svelte-h":!0}),o(el)!=="svelte-zrdgvs"&&(el.innerHTML=sh),Wd=n(e),M(tl.$$.fragment,e),Sd=n(e),ll=p(e,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-et9i9m"&&(ll.innerHTML=ih),Xd=n(e),M(sl.$$.fragment,e),Ld=n(e),il=p(e,"P",{"data-svelte-h":!0}),o(il)!=="svelte-162t9ct"&&(il.innerHTML=nh),Dd=n(e),M(nl.$$.fragment,e),Fd=n(e),al=p(e,"P",{"data-svelte-h":!0}),o(al)!=="svelte-s10qq4"&&(al.innerHTML=ah),qd=n(e),Od=p(e,"HR",{}),Kd=n(e),pl=p(e,"A",{id:!0,class:!0}),J(pl).forEach(l),ec=n(e),M(ol.$$.fragment,e),tc=n(e),dl=p(e,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-11eoigb"&&(dl.textContent=ph),lc=n(e),cl=p(e,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-un4fzt"&&(cl.innerHTML=oh),sc=n(e),Ml=p(e,"TABLE",{"data-svelte-h":!0}),o(Ml)!=="svelte-1qj38gf"&&(Ml.innerHTML=dh),ic=n(e),nc=p(e,"HR",{}),ac=n(e),rl=p(e,"A",{id:!0,class:!0}),J(rl).forEach(l),pc=n(e),M(Tl.$$.fragment,e),oc=n(e),ml=p(e,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-9xhkxa"&&(ml.innerHTML=ch),dc=n(e),yl=p(e,"P",{"data-svelte-h":!0}),o(yl)!=="svelte-gobmso"&&(yl.innerHTML=Mh),cc=n(e),M(Jl.$$.fragment,e),Mc=n(e),hl=p(e,"P",{"data-svelte-h":!0}),o(hl)!=="svelte-s10qq4"&&(hl.innerHTML=rh),rc=n(e),ul=p(e,"UL",{"data-svelte-h":!0}),o(ul)!=="svelte-fjr04l"&&(ul.innerHTML=Th),Tc=n(e),mc=p(e,"HR",{}),yc=n(e),wl=p(e,"A",{id:!0,class:!0}),J(wl).forEach(l),Jc=n(e),M(jl.$$.fragment,e),hc=n(e),Ul=p(e,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-1enract"&&(Ul.textContent=mh),uc=n(e),fl=p(e,"TABLE",{"data-svelte-h":!0}),o(fl)!=="svelte-dgeggs"&&(fl.innerHTML=yh),wc=n(e),jc=p(e,"HR",{}),Uc=n(e),bl=p(e,"A",{id:!0,class:!0}),J(bl).forEach(l),fc=n(e),M(xl.$$.fragment,e),bc=n(e),Cl=p(e,"P",{"data-svelte-h":!0}),o(Cl)!=="svelte-19qhuwa"&&(Cl.textContent=Jh),xc=n(e),gl=p(e,"P",{"data-svelte-h":!0}),o(gl)!=="svelte-1gq3dbn"&&(gl.innerHTML=hh),Cc=n(e),Il=p(e,"TABLE",{"data-svelte-h":!0}),o(Il)!=="svelte-17m2nm1"&&(Il.innerHTML=uh),gc=n(e),Ic=p(e,"HR",{}),kc=n(e),kl=p(e,"A",{id:!0,class:!0}),J(kl).forEach(l),Gc=n(e),M(Gl.$$.fragment,e),Qc=n(e),Ql=p(e,"P",{"data-svelte-h":!0}),o(Ql)!=="svelte-vm8asa"&&(Ql.textContent=wh),Bc=n(e),Bl=p(e,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-p9nqmy"&&(Bl.innerHTML=jh),Zc=n(e),M(Zl.$$.fragment,e),Nc=n(e),Nl=p(e,"P",{"data-svelte-h":!0}),o(Nl)!=="svelte-1xb4yln"&&(Nl.innerHTML=Uh),Ac=n(e),M(Al.$$.fragment,e),vc=n(e),vl=p(e,"P",{"data-svelte-h":!0}),o(vl)!=="svelte-aly754"&&(vl.innerHTML=fh),_c=n(e),M(_l.$$.fragment,e),Rc=n(e),Rl=p(e,"P",{"data-svelte-h":!0}),o(Rl)!=="svelte-127z1r2"&&(Rl.innerHTML=bh),Yc=n(e),M(Yl.$$.fragment,e),$c=n(e),$l=p(e,"P",{"data-svelte-h":!0}),o($l)!=="svelte-5ad2vc"&&($l.innerHTML=xh),Vc=n(e),M(Vl.$$.fragment,e),Ec=n(e),El=p(e,"P",{"data-svelte-h":!0}),o(El)!=="svelte-1ybp4y9"&&(El.innerHTML=Ch),Pc=n(e),M(Pl.$$.fragment,e),Hc=n(e),Hl=p(e,"P",{"data-svelte-h":!0}),o(Hl)!=="svelte-s10qq4"&&(Hl.innerHTML=gh),zc=n(e),zl=p(e,"UL",{"data-svelte-h":!0}),o(zl)!=="svelte-32csn1"&&(zl.innerHTML=Ih),Wc=n(e),Sc=p(e,"HR",{}),Xc=n(e),Wl=p(e,"A",{id:!0,class:!0}),J(Wl).forEach(l),Lc=n(e),M(Sl.$$.fragment,e),Dc=n(e),Xl=p(e,"P",{"data-svelte-h":!0}),o(Xl)!=="svelte-1kkefov"&&(Xl.textContent=kh),Fc=n(e),Ll=p(e,"TABLE",{"data-svelte-h":!0}),o(Ll)!=="svelte-1a94q5m"&&(Ll.innerHTML=Gh),qc=n(e),Oc=p(e,"HR",{}),Kc=n(e),Dl=p(e,"A",{id:!0,class:!0}),J(Dl).forEach(l),eM=n(e),M(Fl.$$.fragment,e),tM=n(e),ql=p(e,"P",{"data-svelte-h":!0}),o(ql)!=="svelte-d8vj38"&&(ql.textContent=Qh),lM=n(e),Ol=p(e,"P",{"data-svelte-h":!0}),o(Ol)!=="svelte-hgdjqs"&&(Ol.innerHTML=Bh),sM=n(e),Kl=p(e,"TABLE",{"data-svelte-h":!0}),o(Kl)!=="svelte-1usuiaq"&&(Kl.innerHTML=Zh),iM=n(e),nM=p(e,"HR",{}),aM=n(e),es=p(e,"A",{id:!0,class:!0}),J(es).forEach(l),pM=n(e),M(ts.$$.fragment,e),oM=n(e),ls=p(e,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-yuzbfo"&&(ls.innerHTML=Nh),dM=n(e),ss=p(e,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-gwolyd"&&(ss.innerHTML=Ah),cM=n(e),M(is.$$.fragment,e),MM=n(e),ns=p(e,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-vvjehq"&&(ns.innerHTML=vh),rM=n(e),M(as.$$.fragment,e),TM=n(e),ps=p(e,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-s10qq4"&&(ps.innerHTML=_h),mM=n(e),os=p(e,"UL",{"data-svelte-h":!0}),o(os)!=="svelte-3k2o01"&&(os.innerHTML=Rh),yM=n(e),JM=p(e,"HR",{}),hM=n(e),ds=p(e,"A",{id:!0,class:!0}),J(ds).forEach(l),uM=n(e),M(cs.$$.fragment,e),wM=n(e),Ms=p(e,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-10qze5e"&&(Ms.textContent=Yh),jM=n(e),rs=p(e,"TABLE",{"data-svelte-h":!0}),o(rs)!=="svelte-1a94q5m"&&(rs.innerHTML=$h),UM=n(e),fM=p(e,"HR",{}),bM=n(e),Ts=p(e,"A",{id:!0,class:!0}),J(Ts).forEach(l),xM=n(e),M(ms.$$.fragment,e),CM=n(e),ys=p(e,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-ypfmt8"&&(ys.textContent=Vh),gM=n(e),Js=p(e,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-sv0g8q"&&(Js.innerHTML=Eh),IM=n(e),hs=p(e,"TABLE",{"data-svelte-h":!0}),o(hs)!=="svelte-1d2oy3p"&&(hs.innerHTML=Ph),kM=n(e),GM=p(e,"HR",{}),QM=n(e),us=p(e,"A",{id:!0,class:!0}),J(us).forEach(l),BM=n(e),M(ws.$$.fragment,e),ZM=n(e),js=p(e,"P",{"data-svelte-h":!0}),o(js)!=="svelte-w5osnc"&&(js.innerHTML=Hh),NM=n(e),Us=p(e,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-1h4310j"&&(Us.innerHTML=zh),AM=n(e),M(fs.$$.fragment,e),vM=n(e),bs=p(e,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-xv6hak"&&(bs.innerHTML=Wh),_M=n(e),M(xs.$$.fragment,e),RM=n(e),Cs=p(e,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-1ids6l"&&(Cs.innerHTML=Sh),YM=n(e),M(gs.$$.fragment,e),$M=n(e),Is=p(e,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-s10qq4"&&(Is.innerHTML=Xh),VM=n(e),ks=p(e,"UL",{"data-svelte-h":!0}),o(ks)!=="svelte-z3581k"&&(ks.innerHTML=Lh),EM=n(e),PM=p(e,"HR",{}),HM=n(e),Gs=p(e,"A",{id:!0,class:!0}),J(Gs).forEach(l),zM=n(e),M(Qs.$$.fragment,e),WM=n(e),Bs=p(e,"P",{"data-svelte-h":!0}),o(Bs)!=="svelte-71b02w"&&(Bs.textContent=Dh),SM=n(e),Zs=p(e,"TABLE",{"data-svelte-h":!0}),o(Zs)!=="svelte-dgeggs"&&(Zs.innerHTML=Fh),XM=n(e),LM=p(e,"HR",{}),DM=n(e),Ns=p(e,"A",{id:!0,class:!0}),J(Ns).forEach(l),FM=n(e),M(As.$$.fragment,e),qM=n(e),vs=p(e,"P",{"data-svelte-h":!0}),o(vs)!=="svelte-1rpepg8"&&(vs.textContent=qh),OM=n(e),_s=p(e,"P",{"data-svelte-h":!0}),o(_s)!=="svelte-zgzruq"&&(_s.innerHTML=Oh),KM=n(e),Rs=p(e,"TABLE",{"data-svelte-h":!0}),o(Rs)!=="svelte-17j2fmt"&&(Rs.innerHTML=Kh),er=n(e),tr=p(e,"HR",{}),lr=n(e),Ys=p(e,"A",{id:!0,class:!0}),J(Ys).forEach(l),sr=n(e),M($s.$$.fragment,e),ir=n(e),Vs=p(e,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-1rwi35s"&&(Vs.innerHTML=eu),nr=n(e),Es=p(e,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-1tpbwb6"&&(Es.innerHTML=tu),ar=n(e),M(Ps.$$.fragment,e),pr=n(e),Hs=p(e,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-s10qq4"&&(Hs.innerHTML=lu),or=n(e),zs=p(e,"UL",{"data-svelte-h":!0}),o(zs)!=="svelte-1n3ebqn"&&(zs.innerHTML=su),dr=n(e),cr=p(e,"HR",{}),Mr=n(e),Ws=p(e,"A",{id:!0,class:!0}),J(Ws).forEach(l),rr=n(e),M(Ss.$$.fragment,e),Tr=n(e),Xs=p(e,"P",{"data-svelte-h":!0}),o(Xs)!=="svelte-1ctgtyq"&&(Xs.textContent=iu),mr=n(e),Ls=p(e,"TABLE",{"data-svelte-h":!0}),o(Ls)!=="svelte-dgeggs"&&(Ls.innerHTML=nu),yr=n(e),Jr=p(e,"HR",{}),hr=n(e),Ds=p(e,"A",{id:!0,class:!0}),J(Ds).forEach(l),ur=n(e),M(Fs.$$.fragment,e),wr=n(e),qs=p(e,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-1v51wpq"&&(qs.textContent=au),jr=n(e),Os=p(e,"P",{"data-svelte-h":!0}),o(Os)!=="svelte-7em0sw"&&(Os.innerHTML=pu),Ur=n(e),Ks=p(e,"TABLE",{"data-svelte-h":!0}),o(Ks)!=="svelte-usc03t"&&(Ks.innerHTML=ou),fr=n(e),br=p(e,"HR",{}),xr=n(e),ei=p(e,"A",{id:!0,class:!0}),J(ei).forEach(l),Cr=n(e),M(ti.$$.fragment,e),gr=n(e),li=p(e,"P",{"data-svelte-h":!0}),o(li)!=="svelte-20dgme"&&(li.innerHTML=du),Ir=n(e),si=p(e,"P",{"data-svelte-h":!0}),o(si)!=="svelte-eob2i5"&&(si.innerHTML=cu),kr=n(e),M(ii.$$.fragment,e),Gr=n(e),ni=p(e,"P",{"data-svelte-h":!0}),o(ni)!=="svelte-s10qq4"&&(ni.innerHTML=Mu),Qr=n(e),ai=p(e,"UL",{"data-svelte-h":!0}),o(ai)!=="svelte-1psrxkl"&&(ai.innerHTML=ru),Br=n(e),Zr=p(e,"HR",{}),Nr=n(e),pi=p(e,"A",{id:!0,class:!0}),J(pi).forEach(l),Ar=n(e),M(oi.$$.fragment,e),vr=n(e),di=p(e,"P",{"data-svelte-h":!0}),o(di)!=="svelte-3wys82"&&(di.textContent=Tu),_r=n(e),ci=p(e,"TABLE",{"data-svelte-h":!0}),o(ci)!=="svelte-1a94q5m"&&(ci.innerHTML=mu),Rr=n(e),Yr=p(e,"HR",{}),$r=n(e),Mi=p(e,"A",{id:!0,class:!0}),J(Mi).forEach(l),Vr=n(e),M(ri.$$.fragment,e),Er=n(e),Ti=p(e,"P",{"data-svelte-h":!0}),o(Ti)!=="svelte-g4x6jx"&&(Ti.textContent=yu),Pr=n(e),mi=p(e,"P",{"data-svelte-h":!0}),o(mi)!=="svelte-zhb55f"&&(mi.innerHTML=Ju),Hr=n(e),yi=p(e,"TABLE",{"data-svelte-h":!0}),o(yi)!=="svelte-tncnks"&&(yi.innerHTML=hu),zr=n(e),Wr=p(e,"HR",{}),Sr=n(e),Ji=p(e,"A",{id:!0,class:!0}),J(Ji).forEach(l),Xr=n(e),M(hi.$$.fragment,e),Lr=n(e),ui=p(e,"P",{"data-svelte-h":!0}),o(ui)!=="svelte-11wm84h"&&(ui.innerHTML=uu),Dr=n(e),wi=p(e,"P",{"data-svelte-h":!0}),o(wi)!=="svelte-yzldbw"&&(wi.innerHTML=wu),Fr=n(e),M(ji.$$.fragment,e),qr=n(e),Ui=p(e,"P",{"data-svelte-h":!0}),o(Ui)!=="svelte-s10qq4"&&(Ui.innerHTML=ju),Or=n(e),fi=p(e,"UL",{"data-svelte-h":!0}),o(fi)!=="svelte-1kysuxh"&&(fi.innerHTML=Uu),Kr=n(e),eT=p(e,"HR",{}),tT=n(e),bi=p(e,"A",{id:!0,class:!0}),J(bi).forEach(l),lT=n(e),M(xi.$$.fragment,e),sT=n(e),Ci=p(e,"P",{"data-svelte-h":!0}),o(Ci)!=="svelte-1la8w69"&&(Ci.textContent=fu),iT=n(e),gi=p(e,"TABLE",{"data-svelte-h":!0}),o(gi)!=="svelte-dgeggs"&&(gi.innerHTML=bu),nT=n(e),aT=p(e,"HR",{}),pT=n(e),Ii=p(e,"A",{id:!0,class:!0}),J(Ii).forEach(l),oT=n(e),M(ki.$$.fragment,e),dT=n(e),Gi=p(e,"P",{"data-svelte-h":!0}),o(Gi)!=="svelte-1ws18e1"&&(Gi.textContent=xu),cT=n(e),Qi=p(e,"P",{"data-svelte-h":!0}),o(Qi)!=="svelte-i9mudt"&&(Qi.innerHTML=Cu),MT=n(e),Bi=p(e,"TABLE",{"data-svelte-h":!0}),o(Bi)!=="svelte-th688q"&&(Bi.innerHTML=gu),rT=n(e),TT=p(e,"HR",{}),mT=n(e),Zi=p(e,"A",{id:!0,class:!0}),J(Zi).forEach(l),yT=n(e),M(Ni.$$.fragment,e),JT=n(e),Ai=p(e,"P",{"data-svelte-h":!0}),o(Ai)!=="svelte-1hdoc64"&&(Ai.innerHTML=Iu),hT=n(e),vi=p(e,"P",{"data-svelte-h":!0}),o(vi)!=="svelte-244nqj"&&(vi.innerHTML=ku),uT=n(e),M(_i.$$.fragment,e),wT=n(e),Ri=p(e,"P",{"data-svelte-h":!0}),o(Ri)!=="svelte-13bh7zz"&&(Ri.innerHTML=Gu),jT=n(e),M(Yi.$$.fragment,e),UT=n(e),$i=p(e,"P",{"data-svelte-h":!0}),o($i)!=="svelte-s10qq4"&&($i.innerHTML=Qu),fT=n(e),Vi=p(e,"UL",{"data-svelte-h":!0}),o(Vi)!=="svelte-1sc4xqq"&&(Vi.innerHTML=Bu),bT=n(e),xT=p(e,"HR",{}),CT=n(e),Ei=p(e,"A",{id:!0,class:!0}),J(Ei).forEach(l),gT=n(e),M(Pi.$$.fragment,e),IT=n(e),Hi=p(e,"P",{"data-svelte-h":!0}),o(Hi)!=="svelte-t69287"&&(Hi.textContent=Zu),kT=n(e),zi=p(e,"TABLE",{"data-svelte-h":!0}),o(zi)!=="svelte-1a94q5m"&&(zi.innerHTML=Nu),GT=n(e),QT=p(e,"HR",{}),BT=n(e),Wi=p(e,"A",{id:!0,class:!0}),J(Wi).forEach(l),ZT=n(e),M(Si.$$.fragment,e),NT=n(e),Xi=p(e,"P",{"data-svelte-h":!0}),o(Xi)!=="svelte-1ws18e1"&&(Xi.textContent=Au),AT=n(e),Li=p(e,"P",{"data-svelte-h":!0}),o(Li)!=="svelte-1c20g67"&&(Li.innerHTML=vu),vT=n(e),Di=p(e,"TABLE",{"data-svelte-h":!0}),o(Di)!=="svelte-u8y6du"&&(Di.innerHTML=_u),_T=n(e),RT=p(e,"HR",{}),YT=n(e),Fi=p(e,"A",{id:!0,class:!0}),J(Fi).forEach(l),$T=n(e),M(qi.$$.fragment,e),VT=n(e),Oi=p(e,"P",{"data-svelte-h":!0}),o(Oi)!=="svelte-iv1c6p"&&(Oi.innerHTML=Ru),ET=n(e),Ki=p(e,"P",{"data-svelte-h":!0}),o(Ki)!=="svelte-1mtx2cy"&&(Ki.innerHTML=Yu),PT=n(e),M(en.$$.fragment,e),HT=n(e),tn=p(e,"P",{"data-svelte-h":!0}),o(tn)!=="svelte-s10qq4"&&(tn.innerHTML=$u),zT=n(e),ln=p(e,"UL",{"data-svelte-h":!0}),o(ln)!=="svelte-1x43yje"&&(ln.innerHTML=Vu),WT=n(e),ST=p(e,"HR",{}),XT=n(e),sn=p(e,"A",{id:!0,class:!0}),J(sn).forEach(l),LT=n(e),M(nn.$$.fragment,e),DT=n(e),an=p(e,"P",{"data-svelte-h":!0}),o(an)!=="svelte-at8fug"&&(an.textContent=Eu),FT=n(e),pn=p(e,"TABLE",{"data-svelte-h":!0}),o(pn)!=="svelte-1a94q5m"&&(pn.innerHTML=Pu),qT=n(e),OT=p(e,"HR",{}),KT=n(e),on=p(e,"A",{id:!0,class:!0}),J(on).forEach(l),em=n(e),M(dn.$$.fragment,e),tm=n(e),cn=p(e,"P",{"data-svelte-h":!0}),o(cn)!=="svelte-bu7lod"&&(cn.textContent=Hu),lm=n(e),Mn=p(e,"P",{"data-svelte-h":!0}),o(Mn)!=="svelte-1or1fiw"&&(Mn.innerHTML=zu),sm=n(e),rn=p(e,"TABLE",{"data-svelte-h":!0}),o(rn)!=="svelte-55abd5"&&(rn.innerHTML=Wu),im=n(e),nm=p(e,"HR",{}),am=n(e),Tn=p(e,"A",{id:!0,class:!0}),J(Tn).forEach(l),pm=n(e),M(mn.$$.fragment,e),om=n(e),yn=p(e,"P",{"data-svelte-h":!0}),o(yn)!=="svelte-1nzvfes"&&(yn.innerHTML=Su),dm=n(e),Jn=p(e,"P",{"data-svelte-h":!0}),o(Jn)!=="svelte-1qq0cp9"&&(Jn.innerHTML=Xu),cm=n(e),M(hn.$$.fragment,e),Mm=n(e),un=p(e,"P",{"data-svelte-h":!0}),o(un)!=="svelte-1mslt41"&&(un.innerHTML=Lu),rm=n(e),M(wn.$$.fragment,e),Tm=n(e),jn=p(e,"P",{"data-svelte-h":!0}),o(jn)!=="svelte-s10qq4"&&(jn.innerHTML=Du),mm=n(e),Un=p(e,"UL",{"data-svelte-h":!0}),o(Un)!=="svelte-1p37gsh"&&(Un.innerHTML=Fu),ym=n(e),Jm=p(e,"HR",{}),hm=n(e),fn=p(e,"A",{id:!0,class:!0}),J(fn).forEach(l),um=n(e),M(bn.$$.fragment,e),wm=n(e),xn=p(e,"P",{"data-svelte-h":!0}),o(xn)!=="svelte-ipwl63"&&(xn.textContent=qu),jm=n(e),Cn=p(e,"TABLE",{"data-svelte-h":!0}),o(Cn)!=="svelte-11vehfm"&&(Cn.innerHTML=Ou),Um=n(e),fm=p(e,"HR",{}),bm=n(e),gn=p(e,"A",{id:!0,class:!0}),J(gn).forEach(l),xm=n(e),M(In.$$.fragment,e),Cm=n(e),kn=p(e,"P",{"data-svelte-h":!0}),o(kn)!=="svelte-1a4c4hr"&&(kn.textContent=Ku),gm=n(e),Gn=p(e,"P",{"data-svelte-h":!0}),o(Gn)!=="svelte-70tp0b"&&(Gn.innerHTML=ew),Im=n(e),Qn=p(e,"TABLE",{"data-svelte-h":!0}),o(Qn)!=="svelte-1hspmv9"&&(Qn.innerHTML=tw),km=n(e),Gm=p(e,"HR",{}),Qm=n(e),Bn=p(e,"A",{id:!0,class:!0}),J(Bn).forEach(l),Bm=n(e),M(Zn.$$.fragment,e),Zm=n(e),Nn=p(e,"P",{"data-svelte-h":!0}),o(Nn)!=="svelte-1y1a6n"&&(Nn.innerHTML=lw),Nm=n(e),An=p(e,"P",{"data-svelte-h":!0}),o(An)!=="svelte-el75jg"&&(An.innerHTML=sw),Am=n(e),M(vn.$$.fragment,e),vm=n(e),_n=p(e,"P",{"data-svelte-h":!0}),o(_n)!=="svelte-s10qq4"&&(_n.innerHTML=iw),_m=n(e),Rm=p(e,"HR",{}),Ym=n(e),Rn=p(e,"A",{id:!0,class:!0}),J(Rn).forEach(l),$m=n(e),M(Yn.$$.fragment,e),Vm=n(e),$n=p(e,"P",{"data-svelte-h":!0}),o($n)!=="svelte-1ega32d"&&($n.textContent=nw),Em=n(e),Vn=p(e,"P",{"data-svelte-h":!0}),o(Vn)!=="svelte-mkrlem"&&(Vn.innerHTML=aw),Pm=n(e),En=p(e,"TABLE",{"data-svelte-h":!0}),o(En)!=="svelte-1l7b6wj"&&(En.innerHTML=pw),Hm=n(e),zm=p(e,"HR",{}),Wm=n(e),Pn=p(e,"A",{id:!0,class:!0}),J(Pn).forEach(l),Sm=n(e),M(Hn.$$.fragment,e),Xm=n(e),zn=p(e,"P",{"data-svelte-h":!0}),o(zn)!=="svelte-cmozej"&&(zn.innerHTML=ow),Lm=n(e),Wn=p(e,"P",{"data-svelte-h":!0}),o(Wn)!=="svelte-10zf5uq"&&(Wn.innerHTML=dw),Dm=n(e),M(Sn.$$.fragment,e),Fm=n(e),Xn=p(e,"P",{"data-svelte-h":!0}),o(Xn)!=="svelte-s10qq4"&&(Xn.innerHTML=cw),qm=n(e),Om=p(e,"HR",{}),Km=n(e),Ln=p(e,"A",{id:!0,class:!0}),J(Ln).forEach(l),ey=n(e),M(Dn.$$.fragment,e),ty=n(e),Fn=p(e,"P",{"data-svelte-h":!0}),o(Fn)!=="svelte-1u7ku6i"&&(Fn.textContent=Mw),ly=n(e),qn=p(e,"P",{"data-svelte-h":!0}),o(qn)!=="svelte-gbsimw"&&(qn.innerHTML=rw),sy=n(e),On=p(e,"TABLE",{"data-svelte-h":!0}),o(On)!=="svelte-1cgj6cy"&&(On.innerHTML=Tw),iy=n(e),ny=p(e,"HR",{}),ay=n(e),Kn=p(e,"A",{id:!0,class:!0}),J(Kn).forEach(l),py=n(e),M(ea.$$.fragment,e),oy=n(e),ta=p(e,"P",{"data-svelte-h":!0}),o(ta)!=="svelte-mcsd8f"&&(ta.innerHTML=mw),dy=n(e),la=p(e,"P",{"data-svelte-h":!0}),o(la)!=="svelte-lb0vbj"&&(la.innerHTML=yw),cy=n(e),sa=p(e,"UL",{"data-svelte-h":!0}),o(sa)!=="svelte-wk6owh"&&(sa.innerHTML=Jw),My=n(e),ia=p(e,"TABLE",{"data-svelte-h":!0}),o(ia)!=="svelte-yqco8e"&&(ia.innerHTML=hw),ry=n(e),Ty=p(e,"HR",{}),my=n(e),na=p(e,"A",{id:!0,class:!0}),J(na).forEach(l),yy=n(e),M(aa.$$.fragment,e),Jy=n(e),pa=p(e,"P",{"data-svelte-h":!0}),o(pa)!=="svelte-ptv3i7"&&(pa.innerHTML=uw),hy=n(e),oa=p(e,"TABLE",{"data-svelte-h":!0}),o(oa)!=="svelte-2eqjop"&&(oa.innerHTML=ww),uy=n(e),wy=p(e,"HR",{}),jy=n(e),da=p(e,"A",{id:!0,class:!0}),J(da).forEach(l),Uy=n(e),M(ca.$$.fragment,e),fy=n(e),Ma=p(e,"P",{"data-svelte-h":!0}),o(Ma)!=="svelte-1axcw5l"&&(Ma.innerHTML=jw),by=n(e),xy=p(e,"HR",{}),Cy=n(e),ra=p(e,"A",{id:!0,class:!0}),J(ra).forEach(l),gy=n(e),M(Ta.$$.fragment,e),Iy=n(e),ma=p(e,"P",{"data-svelte-h":!0}),o(ma)!=="svelte-1axcw5l"&&(ma.innerHTML=Uw),ky=n(e),ya=p(e,"TABLE",{"data-svelte-h":!0}),o(ya)!=="svelte-flnl7b"&&(ya.innerHTML=fw),Gy=n(e),Qy=p(e,"HR",{}),By=n(e),ha=p(e,"P",{}),J(ha).forEach(l),this.h()},h(){d(w,"name","hf:doc:metadata"),d(w,"content",Bw),d(j,"id","module_pipelines"),d(j,"class","group"),d(g,"id","module_pipelines.Pipeline"),d(g,"class","group"),d(B,"id","new_module_pipelines.Pipeline_new"),d(B,"class","group"),d(v,"id","module_pipelines.Pipeline+dispose"),d(v,"class","group"),d($,"id","module_pipelines.Pipeline+_call"),d($,"class","group"),d(z,"id","module_pipelines.TextClassificationPipeline"),d(z,"class","group"),d(ee,"id","module_pipelines.TextClassificationPipeline+_call"),d(ee,"class","group"),d(ne,"id","module_pipelines.TokenClassificationPipeline"),d(ne,"class","group"),d(Te,"id","module_pipelines.TokenClassificationPipeline+_call"),d(Te,"class","group"),d(ue,"id","module_pipelines.QuestionAnsweringPipeline"),d(ue,"class","group"),d(xe,"id","module_pipelines.QuestionAnsweringPipeline+_call"),d(xe,"class","group"),d(Ge,"id","module_pipelines.FillMaskPipeline"),d(Ge,"class","group"),d(Re,"id","module_pipelines.FillMaskPipeline+_call"),d(Re,"class","group"),d(Pe,"id","module_pipelines.Text2TextGenerationPipeline"),d(Pe,"class","group"),d(Le,"id","module_pipelines.Text2TextGenerationPipeline+_call"),d(Le,"class","group"),d(et,"id","module_pipelines.SummarizationPipeline"),d(et,"class","group"),d(at,"id","module_pipelines.TranslationPipeline"),d(at,"class","group"),d(wt,"id","module_pipelines.TextGenerationPipeline"),d(wt,"class","group"),d(Gt,"id","module_pipelines.TextGenerationPipeline+_call"),d(Gt,"class","group"),d(At,"id","module_pipelines.ZeroShotClassificationPipeline"),d(At,"class","group"),d(Ht,"id","new_module_pipelines.ZeroShotClassificationPipeline_new"),d(Ht,"class","group"),d(Xt,"id","module_pipelines.ZeroShotClassificationPipeline+_call"),d(Xt,"class","group"),d(qt,"id","module_pipelines.FeatureExtractionPipeline"),d(qt,"class","group"),d(pl,"id","module_pipelines.FeatureExtractionPipeline+_call"),d(pl,"class","group"),d(rl,"id","module_pipelines.AudioClassificationPipeline"),d(rl,"class","group"),d(wl,"id","new_module_pipelines.AudioClassificationPipeline_new"),d(wl,"class","group"),d(bl,"id","module_pipelines.AudioClassificationPipeline+_call"),d(bl,"class","group"),d(kl,"id","module_pipelines.AutomaticSpeechRecognitionPipeline"),d(kl,"class","group"),d(Wl,"id","new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"),d(Wl,"class","group"),d(Dl,"id","module_pipelines.AutomaticSpeechRecognitionPipeline+_call"),d(Dl,"class","group"),d(es,"id","module_pipelines.ImageToTextPipeline"),d(es,"class","group"),d(ds,"id","new_module_pipelines.ImageToTextPipeline_new"),d(ds,"class","group"),d(Ts,"id","module_pipelines.ImageToTextPipeline+_call"),d(Ts,"class","group"),d(us,"id","module_pipelines.ImageClassificationPipeline"),d(us,"class","group"),d(Gs,"id","new_module_pipelines.ImageClassificationPipeline_new"),d(Gs,"class","group"),d(Ns,"id","module_pipelines.ImageClassificationPipeline+_call"),d(Ns,"class","group"),d(Ys,"id","module_pipelines.ImageSegmentationPipeline"),d(Ys,"class","group"),d(Ws,"id","new_module_pipelines.ImageSegmentationPipeline_new"),d(Ws,"class","group"),d(Ds,"id","module_pipelines.ImageSegmentationPipeline+_call"),d(Ds,"class","group"),d(ei,"id","module_pipelines.ZeroShotImageClassificationPipeline"),d(ei,"class","group"),d(pi,"id","new_module_pipelines.ZeroShotImageClassificationPipeline_new"),d(pi,"class","group"),d(Mi,"id","module_pipelines.ZeroShotImageClassificationPipeline+_call"),d(Mi,"class","group"),d(Ji,"id","module_pipelines.ObjectDetectionPipeline"),d(Ji,"class","group"),d(bi,"id","new_module_pipelines.ObjectDetectionPipeline_new"),d(bi,"class","group"),d(Ii,"id","module_pipelines.ObjectDetectionPipeline+_call"),d(Ii,"class","group"),d(Zi,"id","module_pipelines.ZeroShotObjectDetectionPipeline"),d(Zi,"class","group"),d(Ei,"id","new_module_pipelines.ZeroShotObjectDetectionPipeline_new"),d(Ei,"class","group"),d(Wi,"id","module_pipelines.ZeroShotObjectDetectionPipeline+_call"),d(Wi,"class","group"),d(Fi,"id","module_pipelines.DocumentQuestionAnsweringPipeline"),d(Fi,"class","group"),d(sn,"id","new_module_pipelines.DocumentQuestionAnsweringPipeline_new"),d(sn,"class","group"),d(on,"id","module_pipelines.DocumentQuestionAnsweringPipeline+_call"),d(on,"class","group"),d(Tn,"id","module_pipelines.TextToAudioPipeline"),d(Tn,"class","group"),d(fn,"id","new_module_pipelines.TextToAudioPipeline_new"),d(fn,"class","group"),d(gn,"id","module_pipelines.TextToAudioPipeline+_call"),d(gn,"class","group"),d(Bn,"id","module_pipelines.ImageToImagePipeline"),d(Bn,"class","group"),d(Rn,"id","module_pipelines.ImageToImagePipeline+_call"),d(Rn,"class","group"),d(Pn,"id","module_pipelines.DepthEstimationPipeline"),d(Pn,"class","group"),d(Ln,"id","module_pipelines.DepthEstimationPipeline+_call"),d(Ln,"class","group"),d(Kn,"id","module_pipelines.pipeline"),d(Kn,"class","group"),d(na,"id","module_pipelines..QuestionAnsweringResult"),d(na,"class","group"),d(da,"id","module_pipelines..QuestionAnsweringReturnType"),d(da,"class","group"),d(ra,"id","module_pipelines..ChunkCallback"),d(ra,"class","group")},m(e,t){Gw(document.head,w),s(e,ua,t),s(e,Ja,t),s(e,wa,t),s(e,j,t),s(e,ja,t),r(U,e,t),s(e,Ua,t),s(e,f,t),s(e,fa,t),s(e,b,t),s(e,ba,t),r(x,e,t),s(e,xa,t),s(e,C,t),s(e,Ca,t),s(e,ga,t),s(e,Ia,t),s(e,g,t),s(e,ka,t),r(I,e,t),s(e,Ga,t),s(e,k,t),s(e,Qa,t),s(e,G,t),s(e,Ba,t),s(e,Q,t),s(e,Za,t),s(e,Na,t),s(e,Aa,t),s(e,B,t),s(e,va,t),r(Z,e,t),s(e,_a,t),s(e,N,t),s(e,Ra,t),s(e,A,t),s(e,Ya,t),s(e,$a,t),s(e,Va,t),s(e,v,t),s(e,Ea,t),r(_,e,t),s(e,Pa,t),s(e,R,t),s(e,Ha,t),s(e,Y,t),s(e,za,t),s(e,Wa,t),s(e,Sa,t),s(e,$,t),s(e,Xa,t),r(V,e,t),s(e,La,t),s(e,E,t),s(e,Da,t),s(e,P,t),s(e,Fa,t),s(e,H,t),s(e,qa,t),s(e,Oa,t),s(e,Ka,t),s(e,z,t),s(e,ep,t),r(W,e,t),s(e,tp,t),s(e,S,t),s(e,lp,t),s(e,X,t),s(e,sp,t),r(L,e,t),s(e,ip,t),s(e,D,t),s(e,np,t),r(F,e,t),s(e,ap,t),s(e,q,t),s(e,pp,t),r(O,e,t),s(e,op,t),s(e,K,t),s(e,dp,t),s(e,cp,t),s(e,Mp,t),s(e,ee,t),s(e,rp,t),r(te,e,t),s(e,Tp,t),s(e,le,t),s(e,mp,t),s(e,se,t),s(e,yp,t),s(e,ie,t),s(e,Jp,t),s(e,hp,t),s(e,up,t),s(e,ne,t),s(e,wp,t),r(ae,e,t),s(e,jp,t),s(e,pe,t),s(e,Up,t),s(e,oe,t),s(e,fp,t),r(de,e,t),s(e,bp,t),s(e,ce,t),s(e,xp,t),r(Me,e,t),s(e,Cp,t),s(e,re,t),s(e,gp,t),s(e,Ip,t),s(e,kp,t),s(e,Te,t),s(e,Gp,t),r(me,e,t),s(e,Qp,t),s(e,ye,t),s(e,Bp,t),s(e,Je,t),s(e,Zp,t),s(e,he,t),s(e,Np,t),s(e,Ap,t),s(e,vp,t),s(e,ue,t),s(e,_p,t),r(we,e,t),s(e,Rp,t),s(e,je,t),s(e,Yp,t),s(e,Ue,t),s(e,$p,t),r(fe,e,t),s(e,Vp,t),s(e,be,t),s(e,Ep,t),s(e,Pp,t),s(e,Hp,t),s(e,xe,t),s(e,zp,t),r(Ce,e,t),s(e,Wp,t),s(e,ge,t),s(e,Sp,t),s(e,Ie,t),s(e,Xp,t),s(e,ke,t),s(e,Lp,t),s(e,Dp,t),s(e,Fp,t),s(e,Ge,t),s(e,qp,t),r(Qe,e,t),s(e,Op,t),s(e,Be,t),s(e,Kp,t),s(e,Ze,t),s(e,eo,t),r(Ne,e,t),s(e,to,t),s(e,Ae,t),s(e,lo,t),r(ve,e,t),s(e,so,t),s(e,_e,t),s(e,io,t),s(e,no,t),s(e,ao,t),s(e,Re,t),s(e,po,t),r(Ye,e,t),s(e,oo,t),s(e,$e,t),s(e,co,t),s(e,Ve,t),s(e,Mo,t),s(e,Ee,t),s(e,ro,t),s(e,To,t),s(e,mo,t),s(e,Pe,t),s(e,yo,t),r(He,e,t),s(e,Jo,t),s(e,ze,t),s(e,ho,t),s(e,We,t),s(e,uo,t),r(Se,e,t),s(e,wo,t),s(e,Xe,t),s(e,jo,t),s(e,Uo,t),s(e,fo,t),s(e,Le,t),s(e,bo,t),r(De,e,t),s(e,xo,t),s(e,Fe,t),s(e,Co,t),s(e,qe,t),s(e,go,t),s(e,Oe,t),s(e,Io,t),s(e,Ke,t),s(e,ko,t),s(e,Go,t),s(e,Qo,t),s(e,et,t),s(e,Bo,t),r(tt,e,t),s(e,Zo,t),s(e,lt,t),s(e,No,t),s(e,st,t),s(e,Ao,t),r(it,e,t),s(e,vo,t),s(e,nt,t),s(e,_o,t),s(e,Ro,t),s(e,Yo,t),s(e,at,t),s(e,$o,t),r(pt,e,t),s(e,Vo,t),s(e,ot,t),s(e,Eo,t),s(e,dt,t),s(e,Po,t),s(e,ct,t),s(e,Ho,t),r(Mt,e,t),s(e,zo,t),s(e,rt,t),s(e,Wo,t),s(e,Tt,t),s(e,So,t),r(mt,e,t),s(e,Xo,t),s(e,yt,t),s(e,Lo,t),s(e,Jt,t),s(e,Do,t),r(ht,e,t),s(e,Fo,t),s(e,ut,t),s(e,qo,t),s(e,Oo,t),s(e,Ko,t),s(e,wt,t),s(e,ed,t),r(jt,e,t),s(e,td,t),s(e,Ut,t),s(e,ld,t),s(e,ft,t),s(e,sd,t),r(bt,e,t),s(e,id,t),s(e,xt,t),s(e,nd,t),r(Ct,e,t),s(e,ad,t),s(e,gt,t),s(e,pd,t),r(It,e,t),s(e,od,t),s(e,kt,t),s(e,dd,t),s(e,cd,t),s(e,Md,t),s(e,Gt,t),s(e,rd,t),r(Qt,e,t),s(e,Td,t),s(e,Bt,t),s(e,md,t),s(e,Zt,t),s(e,yd,t),s(e,Nt,t),s(e,Jd,t),s(e,hd,t),s(e,ud,t),s(e,At,t),s(e,wd,t),r(vt,e,t),s(e,jd,t),s(e,_t,t),s(e,Ud,t),s(e,Rt,t),s(e,fd,t),r(Yt,e,t),s(e,bd,t),s(e,$t,t),s(e,xd,t),r(Vt,e,t),s(e,Cd,t),s(e,Et,t),s(e,gd,t),s(e,Pt,t),s(e,Id,t),s(e,kd,t),s(e,Gd,t),s(e,Ht,t),s(e,Qd,t),r(zt,e,t),s(e,Bd,t),s(e,Wt,t),s(e,Zd,t),s(e,St,t),s(e,Nd,t),s(e,Ad,t),s(e,vd,t),s(e,Xt,t),s(e,_d,t),r(Lt,e,t),s(e,Rd,t),s(e,Dt,t),s(e,Yd,t),s(e,Ft,t),s(e,$d,t),s(e,Vd,t),s(e,Ed,t),s(e,qt,t),s(e,Pd,t),r(Ot,e,t),s(e,Hd,t),s(e,Kt,t),s(e,zd,t),s(e,el,t),s(e,Wd,t),r(tl,e,t),s(e,Sd,t),s(e,ll,t),s(e,Xd,t),r(sl,e,t),s(e,Ld,t),s(e,il,t),s(e,Dd,t),r(nl,e,t),s(e,Fd,t),s(e,al,t),s(e,qd,t),s(e,Od,t),s(e,Kd,t),s(e,pl,t),s(e,ec,t),r(ol,e,t),s(e,tc,t),s(e,dl,t),s(e,lc,t),s(e,cl,t),s(e,sc,t),s(e,Ml,t),s(e,ic,t),s(e,nc,t),s(e,ac,t),s(e,rl,t),s(e,pc,t),r(Tl,e,t),s(e,oc,t),s(e,ml,t),s(e,dc,t),s(e,yl,t),s(e,cc,t),r(Jl,e,t),s(e,Mc,t),s(e,hl,t),s(e,rc,t),s(e,ul,t),s(e,Tc,t),s(e,mc,t),s(e,yc,t),s(e,wl,t),s(e,Jc,t),r(jl,e,t),s(e,hc,t),s(e,Ul,t),s(e,uc,t),s(e,fl,t),s(e,wc,t),s(e,jc,t),s(e,Uc,t),s(e,bl,t),s(e,fc,t),r(xl,e,t),s(e,bc,t),s(e,Cl,t),s(e,xc,t),s(e,gl,t),s(e,Cc,t),s(e,Il,t),s(e,gc,t),s(e,Ic,t),s(e,kc,t),s(e,kl,t),s(e,Gc,t),r(Gl,e,t),s(e,Qc,t),s(e,Ql,t),s(e,Bc,t),s(e,Bl,t),s(e,Zc,t),r(Zl,e,t),s(e,Nc,t),s(e,Nl,t),s(e,Ac,t),r(Al,e,t),s(e,vc,t),s(e,vl,t),s(e,_c,t),r(_l,e,t),s(e,Rc,t),s(e,Rl,t),s(e,Yc,t),r(Yl,e,t),s(e,$c,t),s(e,$l,t),s(e,Vc,t),r(Vl,e,t),s(e,Ec,t),s(e,El,t),s(e,Pc,t),r(Pl,e,t),s(e,Hc,t),s(e,Hl,t),s(e,zc,t),s(e,zl,t),s(e,Wc,t),s(e,Sc,t),s(e,Xc,t),s(e,Wl,t),s(e,Lc,t),r(Sl,e,t),s(e,Dc,t),s(e,Xl,t),s(e,Fc,t),s(e,Ll,t),s(e,qc,t),s(e,Oc,t),s(e,Kc,t),s(e,Dl,t),s(e,eM,t),r(Fl,e,t),s(e,tM,t),s(e,ql,t),s(e,lM,t),s(e,Ol,t),s(e,sM,t),s(e,Kl,t),s(e,iM,t),s(e,nM,t),s(e,aM,t),s(e,es,t),s(e,pM,t),r(ts,e,t),s(e,oM,t),s(e,ls,t),s(e,dM,t),s(e,ss,t),s(e,cM,t),r(is,e,t),s(e,MM,t),s(e,ns,t),s(e,rM,t),r(as,e,t),s(e,TM,t),s(e,ps,t),s(e,mM,t),s(e,os,t),s(e,yM,t),s(e,JM,t),s(e,hM,t),s(e,ds,t),s(e,uM,t),r(cs,e,t),s(e,wM,t),s(e,Ms,t),s(e,jM,t),s(e,rs,t),s(e,UM,t),s(e,fM,t),s(e,bM,t),s(e,Ts,t),s(e,xM,t),r(ms,e,t),s(e,CM,t),s(e,ys,t),s(e,gM,t),s(e,Js,t),s(e,IM,t),s(e,hs,t),s(e,kM,t),s(e,GM,t),s(e,QM,t),s(e,us,t),s(e,BM,t),r(ws,e,t),s(e,ZM,t),s(e,js,t),s(e,NM,t),s(e,Us,t),s(e,AM,t),r(fs,e,t),s(e,vM,t),s(e,bs,t),s(e,_M,t),r(xs,e,t),s(e,RM,t),s(e,Cs,t),s(e,YM,t),r(gs,e,t),s(e,$M,t),s(e,Is,t),s(e,VM,t),s(e,ks,t),s(e,EM,t),s(e,PM,t),s(e,HM,t),s(e,Gs,t),s(e,zM,t),r(Qs,e,t),s(e,WM,t),s(e,Bs,t),s(e,SM,t),s(e,Zs,t),s(e,XM,t),s(e,LM,t),s(e,DM,t),s(e,Ns,t),s(e,FM,t),r(As,e,t),s(e,qM,t),s(e,vs,t),s(e,OM,t),s(e,_s,t),s(e,KM,t),s(e,Rs,t),s(e,er,t),s(e,tr,t),s(e,lr,t),s(e,Ys,t),s(e,sr,t),r($s,e,t),s(e,ir,t),s(e,Vs,t),s(e,nr,t),s(e,Es,t),s(e,ar,t),r(Ps,e,t),s(e,pr,t),s(e,Hs,t),s(e,or,t),s(e,zs,t),s(e,dr,t),s(e,cr,t),s(e,Mr,t),s(e,Ws,t),s(e,rr,t),r(Ss,e,t),s(e,Tr,t),s(e,Xs,t),s(e,mr,t),s(e,Ls,t),s(e,yr,t),s(e,Jr,t),s(e,hr,t),s(e,Ds,t),s(e,ur,t),r(Fs,e,t),s(e,wr,t),s(e,qs,t),s(e,jr,t),s(e,Os,t),s(e,Ur,t),s(e,Ks,t),s(e,fr,t),s(e,br,t),s(e,xr,t),s(e,ei,t),s(e,Cr,t),r(ti,e,t),s(e,gr,t),s(e,li,t),s(e,Ir,t),s(e,si,t),s(e,kr,t),r(ii,e,t),s(e,Gr,t),s(e,ni,t),s(e,Qr,t),s(e,ai,t),s(e,Br,t),s(e,Zr,t),s(e,Nr,t),s(e,pi,t),s(e,Ar,t),r(oi,e,t),s(e,vr,t),s(e,di,t),s(e,_r,t),s(e,ci,t),s(e,Rr,t),s(e,Yr,t),s(e,$r,t),s(e,Mi,t),s(e,Vr,t),r(ri,e,t),s(e,Er,t),s(e,Ti,t),s(e,Pr,t),s(e,mi,t),s(e,Hr,t),s(e,yi,t),s(e,zr,t),s(e,Wr,t),s(e,Sr,t),s(e,Ji,t),s(e,Xr,t),r(hi,e,t),s(e,Lr,t),s(e,ui,t),s(e,Dr,t),s(e,wi,t),s(e,Fr,t),r(ji,e,t),s(e,qr,t),s(e,Ui,t),s(e,Or,t),s(e,fi,t),s(e,Kr,t),s(e,eT,t),s(e,tT,t),s(e,bi,t),s(e,lT,t),r(xi,e,t),s(e,sT,t),s(e,Ci,t),s(e,iT,t),s(e,gi,t),s(e,nT,t),s(e,aT,t),s(e,pT,t),s(e,Ii,t),s(e,oT,t),r(ki,e,t),s(e,dT,t),s(e,Gi,t),s(e,cT,t),s(e,Qi,t),s(e,MT,t),s(e,Bi,t),s(e,rT,t),s(e,TT,t),s(e,mT,t),s(e,Zi,t),s(e,yT,t),r(Ni,e,t),s(e,JT,t),s(e,Ai,t),s(e,hT,t),s(e,vi,t),s(e,uT,t),r(_i,e,t),s(e,wT,t),s(e,Ri,t),s(e,jT,t),r(Yi,e,t),s(e,UT,t),s(e,$i,t),s(e,fT,t),s(e,Vi,t),s(e,bT,t),s(e,xT,t),s(e,CT,t),s(e,Ei,t),s(e,gT,t),r(Pi,e,t),s(e,IT,t),s(e,Hi,t),s(e,kT,t),s(e,zi,t),s(e,GT,t),s(e,QT,t),s(e,BT,t),s(e,Wi,t),s(e,ZT,t),r(Si,e,t),s(e,NT,t),s(e,Xi,t),s(e,AT,t),s(e,Li,t),s(e,vT,t),s(e,Di,t),s(e,_T,t),s(e,RT,t),s(e,YT,t),s(e,Fi,t),s(e,$T,t),r(qi,e,t),s(e,VT,t),s(e,Oi,t),s(e,ET,t),s(e,Ki,t),s(e,PT,t),r(en,e,t),s(e,HT,t),s(e,tn,t),s(e,zT,t),s(e,ln,t),s(e,WT,t),s(e,ST,t),s(e,XT,t),s(e,sn,t),s(e,LT,t),r(nn,e,t),s(e,DT,t),s(e,an,t),s(e,FT,t),s(e,pn,t),s(e,qT,t),s(e,OT,t),s(e,KT,t),s(e,on,t),s(e,em,t),r(dn,e,t),s(e,tm,t),s(e,cn,t),s(e,lm,t),s(e,Mn,t),s(e,sm,t),s(e,rn,t),s(e,im,t),s(e,nm,t),s(e,am,t),s(e,Tn,t),s(e,pm,t),r(mn,e,t),s(e,om,t),s(e,yn,t),s(e,dm,t),s(e,Jn,t),s(e,cm,t),r(hn,e,t),s(e,Mm,t),s(e,un,t),s(e,rm,t),r(wn,e,t),s(e,Tm,t),s(e,jn,t),s(e,mm,t),s(e,Un,t),s(e,ym,t),s(e,Jm,t),s(e,hm,t),s(e,fn,t),s(e,um,t),r(bn,e,t),s(e,wm,t),s(e,xn,t),s(e,jm,t),s(e,Cn,t),s(e,Um,t),s(e,fm,t),s(e,bm,t),s(e,gn,t),s(e,xm,t),r(In,e,t),s(e,Cm,t),s(e,kn,t),s(e,gm,t),s(e,Gn,t),s(e,Im,t),s(e,Qn,t),s(e,km,t),s(e,Gm,t),s(e,Qm,t),s(e,Bn,t),s(e,Bm,t),r(Zn,e,t),s(e,Zm,t),s(e,Nn,t),s(e,Nm,t),s(e,An,t),s(e,Am,t),r(vn,e,t),s(e,vm,t),s(e,_n,t),s(e,_m,t),s(e,Rm,t),s(e,Ym,t),s(e,Rn,t),s(e,$m,t),r(Yn,e,t),s(e,Vm,t),s(e,$n,t),s(e,Em,t),s(e,Vn,t),s(e,Pm,t),s(e,En,t),s(e,Hm,t),s(e,zm,t),s(e,Wm,t),s(e,Pn,t),s(e,Sm,t),r(Hn,e,t),s(e,Xm,t),s(e,zn,t),s(e,Lm,t),s(e,Wn,t),s(e,Dm,t),r(Sn,e,t),s(e,Fm,t),s(e,Xn,t),s(e,qm,t),s(e,Om,t),s(e,Km,t),s(e,Ln,t),s(e,ey,t),r(Dn,e,t),s(e,ty,t),s(e,Fn,t),s(e,ly,t),s(e,qn,t),s(e,sy,t),s(e,On,t),s(e,iy,t),s(e,ny,t),s(e,ay,t),s(e,Kn,t),s(e,py,t),r(ea,e,t),s(e,oy,t),s(e,ta,t),s(e,dy,t),s(e,la,t),s(e,cy,t),s(e,sa,t),s(e,My,t),s(e,ia,t),s(e,ry,t),s(e,Ty,t),s(e,my,t),s(e,na,t),s(e,yy,t),r(aa,e,t),s(e,Jy,t),s(e,pa,t),s(e,hy,t),s(e,oa,t),s(e,uy,t),s(e,wy,t),s(e,jy,t),s(e,da,t),s(e,Uy,t),r(ca,e,t),s(e,fy,t),s(e,Ma,t),s(e,by,t),s(e,xy,t),s(e,Cy,t),s(e,ra,t),s(e,gy,t),r(Ta,e,t),s(e,Iy,t),s(e,ma,t),s(e,ky,t),s(e,ya,t),s(e,Gy,t),s(e,Qy,t),s(e,By,t),s(e,ha,t),Zy=!0},p:xw,i(e){Zy||(T(U.$$.fragment,e),T(x.$$.fragment,e),T(I.$$.fragment,e),T(Z.$$.fragment,e),T(_.$$.fragment,e),T(V.$$.fragment,e),T(W.$$.fragment,e),T(L.$$.fragment,e),T(F.$$.fragment,e),T(O.$$.fragment,e),T(te.$$.fragment,e),T(ae.$$.fragment,e),T(de.$$.fragment,e),T(Me.$$.fragment,e),T(me.$$.fragment,e),T(we.$$.fragment,e),T(fe.$$.fragment,e),T(Ce.$$.fragment,e),T(Qe.$$.fragment,e),T(Ne.$$.fragment,e),T(ve.$$.fragment,e),T(Ye.$$.fragment,e),T(He.$$.fragment,e),T(Se.$$.fragment,e),T(De.$$.fragment,e),T(tt.$$.fragment,e),T(it.$$.fragment,e),T(pt.$$.fragment,e),T(Mt.$$.fragment,e),T(mt.$$.fragment,e),T(ht.$$.fragment,e),T(jt.$$.fragment,e),T(bt.$$.fragment,e),T(Ct.$$.fragment,e),T(It.$$.fragment,e),T(Qt.$$.fragment,e),T(vt.$$.fragment,e),T(Yt.$$.fragment,e),T(Vt.$$.fragment,e),T(zt.$$.fragment,e),T(Lt.$$.fragment,e),T(Ot.$$.fragment,e),T(tl.$$.fragment,e),T(sl.$$.fragment,e),T(nl.$$.fragment,e),T(ol.$$.fragment,e),T(Tl.$$.fragment,e),T(Jl.$$.fragment,e),T(jl.$$.fragment,e),T(xl.$$.fragment,e),T(Gl.$$.fragment,e),T(Zl.$$.fragment,e),T(Al.$$.fragment,e),T(_l.$$.fragment,e),T(Yl.$$.fragment,e),T(Vl.$$.fragment,e),T(Pl.$$.fragment,e),T(Sl.$$.fragment,e),T(Fl.$$.fragment,e),T(ts.$$.fragment,e),T(is.$$.fragment,e),T(as.$$.fragment,e),T(cs.$$.fragment,e),T(ms.$$.fragment,e),T(ws.$$.fragment,e),T(fs.$$.fragment,e),T(xs.$$.fragment,e),T(gs.$$.fragment,e),T(Qs.$$.fragment,e),T(As.$$.fragment,e),T($s.$$.fragment,e),T(Ps.$$.fragment,e),T(Ss.$$.fragment,e),T(Fs.$$.fragment,e),T(ti.$$.fragment,e),T(ii.$$.fragment,e),T(oi.$$.fragment,e),T(ri.$$.fragment,e),T(hi.$$.fragment,e),T(ji.$$.fragment,e),T(xi.$$.fragment,e),T(ki.$$.fragment,e),T(Ni.$$.fragment,e),T(_i.$$.fragment,e),T(Yi.$$.fragment,e),T(Pi.$$.fragment,e),T(Si.$$.fragment,e),T(qi.$$.fragment,e),T(en.$$.fragment,e),T(nn.$$.fragment,e),T(dn.$$.fragment,e),T(mn.$$.fragment,e),T(hn.$$.fragment,e),T(wn.$$.fragment,e),T(bn.$$.fragment,e),T(In.$$.fragment,e),T(Zn.$$.fragment,e),T(vn.$$.fragment,e),T(Yn.$$.fragment,e),T(Hn.$$.fragment,e),T(Sn.$$.fragment,e),T(Dn.$$.fragment,e),T(ea.$$.fragment,e),T(aa.$$.fragment,e),T(ca.$$.fragment,e),T(Ta.$$.fragment,e),Zy=!0)},o(e){m(U.$$.fragment,e),m(x.$$.fragment,e),m(I.$$.fragment,e),m(Z.$$.fragment,e),m(_.$$.fragment,e),m(V.$$.fragment,e),m(W.$$.fragment,e),m(L.$$.fragment,e),m(F.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(de.$$.fragment,e),m(Me.$$.fragment,e),m(me.$$.fragment,e),m(we.$$.fragment,e),m(fe.$$.fragment,e),m(Ce.$$.fragment,e),m(Qe.$$.fragment,e),m(Ne.$$.fragment,e),m(ve.$$.fragment,e),m(Ye.$$.fragment,e),m(He.$$.fragment,e),m(Se.$$.fragment,e),m(De.$$.fragment,e),m(tt.$$.fragment,e),m(it.$$.fragment,e),m(pt.$$.fragment,e),m(Mt.$$.fragment,e),m(mt.$$.fragment,e),m(ht.$$.fragment,e),m(jt.$$.fragment,e),m(bt.$$.fragment,e),m(Ct.$$.fragment,e),m(It.$$.fragment,e),m(Qt.$$.fragment,e),m(vt.$$.fragment,e),m(Yt.$$.fragment,e),m(Vt.$$.fragment,e),m(zt.$$.fragment,e),m(Lt.$$.fragment,e),m(Ot.$$.fragment,e),m(tl.$$.fragment,e),m(sl.$$.fragment,e),m(nl.$$.fragment,e),m(ol.$$.fragment,e),m(Tl.$$.fragment,e),m(Jl.$$.fragment,e),m(jl.$$.fragment,e),m(xl.$$.fragment,e),m(Gl.$$.fragment,e),m(Zl.$$.fragment,e),m(Al.$$.fragment,e),m(_l.$$.fragment,e),m(Yl.$$.fragment,e),m(Vl.$$.fragment,e),m(Pl.$$.fragment,e),m(Sl.$$.fragment,e),m(Fl.$$.fragment,e),m(ts.$$.fragment,e),m(is.$$.fragment,e),m(as.$$.fragment,e),m(cs.$$.fragment,e),m(ms.$$.fragment,e),m(ws.$$.fragment,e),m(fs.$$.fragment,e),m(xs.$$.fragment,e),m(gs.$$.fragment,e),m(Qs.$$.fragment,e),m(As.$$.fragment,e),m($s.$$.fragment,e),m(Ps.$$.fragment,e),m(Ss.$$.fragment,e),m(Fs.$$.fragment,e),m(ti.$$.fragment,e),m(ii.$$.fragment,e),m(oi.$$.fragment,e),m(ri.$$.fragment,e),m(hi.$$.fragment,e),m(ji.$$.fragment,e),m(xi.$$.fragment,e),m(ki.$$.fragment,e),m(Ni.$$.fragment,e),m(_i.$$.fragment,e),m(Yi.$$.fragment,e),m(Pi.$$.fragment,e),m(Si.$$.fragment,e),m(qi.$$.fragment,e),m(en.$$.fragment,e),m(nn.$$.fragment,e),m(dn.$$.fragment,e),m(mn.$$.fragment,e),m(hn.$$.fragment,e),m(wn.$$.fragment,e),m(bn.$$.fragment,e),m(In.$$.fragment,e),m(Zn.$$.fragment,e),m(vn.$$.fragment,e),m(Yn.$$.fragment,e),m(Hn.$$.fragment,e),m(Sn.$$.fragment,e),m(Dn.$$.fragment,e),m(ea.$$.fragment,e),m(aa.$$.fragment,e),m(ca.$$.fragment,e),m(Ta.$$.fragment,e),Zy=!1},d(e){e&&(l(ua),l(Ja),l(wa),l(j),l(ja),l(Ua),l(f),l(fa),l(b),l(ba),l(xa),l(C),l(Ca),l(ga),l(Ia),l(g),l(ka),l(Ga),l(k),l(Qa),l(G),l(Ba),l(Q),l(Za),l(Na),l(Aa),l(B),l(va),l(_a),l(N),l(Ra),l(A),l(Ya),l($a),l(Va),l(v),l(Ea),l(Pa),l(R),l(Ha),l(Y),l(za),l(Wa),l(Sa),l($),l(Xa),l(La),l(E),l(Da),l(P),l(Fa),l(H),l(qa),l(Oa),l(Ka),l(z),l(ep),l(tp),l(S),l(lp),l(X),l(sp),l(ip),l(D),l(np),l(ap),l(q),l(pp),l(op),l(K),l(dp),l(cp),l(Mp),l(ee),l(rp),l(Tp),l(le),l(mp),l(se),l(yp),l(ie),l(Jp),l(hp),l(up),l(ne),l(wp),l(jp),l(pe),l(Up),l(oe),l(fp),l(bp),l(ce),l(xp),l(Cp),l(re),l(gp),l(Ip),l(kp),l(Te),l(Gp),l(Qp),l(ye),l(Bp),l(Je),l(Zp),l(he),l(Np),l(Ap),l(vp),l(ue),l(_p),l(Rp),l(je),l(Yp),l(Ue),l($p),l(Vp),l(be),l(Ep),l(Pp),l(Hp),l(xe),l(zp),l(Wp),l(ge),l(Sp),l(Ie),l(Xp),l(ke),l(Lp),l(Dp),l(Fp),l(Ge),l(qp),l(Op),l(Be),l(Kp),l(Ze),l(eo),l(to),l(Ae),l(lo),l(so),l(_e),l(io),l(no),l(ao),l(Re),l(po),l(oo),l($e),l(co),l(Ve),l(Mo),l(Ee),l(ro),l(To),l(mo),l(Pe),l(yo),l(Jo),l(ze),l(ho),l(We),l(uo),l(wo),l(Xe),l(jo),l(Uo),l(fo),l(Le),l(bo),l(xo),l(Fe),l(Co),l(qe),l(go),l(Oe),l(Io),l(Ke),l(ko),l(Go),l(Qo),l(et),l(Bo),l(Zo),l(lt),l(No),l(st),l(Ao),l(vo),l(nt),l(_o),l(Ro),l(Yo),l(at),l($o),l(Vo),l(ot),l(Eo),l(dt),l(Po),l(ct),l(Ho),l(zo),l(rt),l(Wo),l(Tt),l(So),l(Xo),l(yt),l(Lo),l(Jt),l(Do),l(Fo),l(ut),l(qo),l(Oo),l(Ko),l(wt),l(ed),l(td),l(Ut),l(ld),l(ft),l(sd),l(id),l(xt),l(nd),l(ad),l(gt),l(pd),l(od),l(kt),l(dd),l(cd),l(Md),l(Gt),l(rd),l(Td),l(Bt),l(md),l(Zt),l(yd),l(Nt),l(Jd),l(hd),l(ud),l(At),l(wd),l(jd),l(_t),l(Ud),l(Rt),l(fd),l(bd),l($t),l(xd),l(Cd),l(Et),l(gd),l(Pt),l(Id),l(kd),l(Gd),l(Ht),l(Qd),l(Bd),l(Wt),l(Zd),l(St),l(Nd),l(Ad),l(vd),l(Xt),l(_d),l(Rd),l(Dt),l(Yd),l(Ft),l($d),l(Vd),l(Ed),l(qt),l(Pd),l(Hd),l(Kt),l(zd),l(el),l(Wd),l(Sd),l(ll),l(Xd),l(Ld),l(il),l(Dd),l(Fd),l(al),l(qd),l(Od),l(Kd),l(pl),l(ec),l(tc),l(dl),l(lc),l(cl),l(sc),l(Ml),l(ic),l(nc),l(ac),l(rl),l(pc),l(oc),l(ml),l(dc),l(yl),l(cc),l(Mc),l(hl),l(rc),l(ul),l(Tc),l(mc),l(yc),l(wl),l(Jc),l(hc),l(Ul),l(uc),l(fl),l(wc),l(jc),l(Uc),l(bl),l(fc),l(bc),l(Cl),l(xc),l(gl),l(Cc),l(Il),l(gc),l(Ic),l(kc),l(kl),l(Gc),l(Qc),l(Ql),l(Bc),l(Bl),l(Zc),l(Nc),l(Nl),l(Ac),l(vc),l(vl),l(_c),l(Rc),l(Rl),l(Yc),l($c),l($l),l(Vc),l(Ec),l(El),l(Pc),l(Hc),l(Hl),l(zc),l(zl),l(Wc),l(Sc),l(Xc),l(Wl),l(Lc),l(Dc),l(Xl),l(Fc),l(Ll),l(qc),l(Oc),l(Kc),l(Dl),l(eM),l(tM),l(ql),l(lM),l(Ol),l(sM),l(Kl),l(iM),l(nM),l(aM),l(es),l(pM),l(oM),l(ls),l(dM),l(ss),l(cM),l(MM),l(ns),l(rM),l(TM),l(ps),l(mM),l(os),l(yM),l(JM),l(hM),l(ds),l(uM),l(wM),l(Ms),l(jM),l(rs),l(UM),l(fM),l(bM),l(Ts),l(xM),l(CM),l(ys),l(gM),l(Js),l(IM),l(hs),l(kM),l(GM),l(QM),l(us),l(BM),l(ZM),l(js),l(NM),l(Us),l(AM),l(vM),l(bs),l(_M),l(RM),l(Cs),l(YM),l($M),l(Is),l(VM),l(ks),l(EM),l(PM),l(HM),l(Gs),l(zM),l(WM),l(Bs),l(SM),l(Zs),l(XM),l(LM),l(DM),l(Ns),l(FM),l(qM),l(vs),l(OM),l(_s),l(KM),l(Rs),l(er),l(tr),l(lr),l(Ys),l(sr),l(ir),l(Vs),l(nr),l(Es),l(ar),l(pr),l(Hs),l(or),l(zs),l(dr),l(cr),l(Mr),l(Ws),l(rr),l(Tr),l(Xs),l(mr),l(Ls),l(yr),l(Jr),l(hr),l(Ds),l(ur),l(wr),l(qs),l(jr),l(Os),l(Ur),l(Ks),l(fr),l(br),l(xr),l(ei),l(Cr),l(gr),l(li),l(Ir),l(si),l(kr),l(Gr),l(ni),l(Qr),l(ai),l(Br),l(Zr),l(Nr),l(pi),l(Ar),l(vr),l(di),l(_r),l(ci),l(Rr),l(Yr),l($r),l(Mi),l(Vr),l(Er),l(Ti),l(Pr),l(mi),l(Hr),l(yi),l(zr),l(Wr),l(Sr),l(Ji),l(Xr),l(Lr),l(ui),l(Dr),l(wi),l(Fr),l(qr),l(Ui),l(Or),l(fi),l(Kr),l(eT),l(tT),l(bi),l(lT),l(sT),l(Ci),l(iT),l(gi),l(nT),l(aT),l(pT),l(Ii),l(oT),l(dT),l(Gi),l(cT),l(Qi),l(MT),l(Bi),l(rT),l(TT),l(mT),l(Zi),l(yT),l(JT),l(Ai),l(hT),l(vi),l(uT),l(wT),l(Ri),l(jT),l(UT),l($i),l(fT),l(Vi),l(bT),l(xT),l(CT),l(Ei),l(gT),l(IT),l(Hi),l(kT),l(zi),l(GT),l(QT),l(BT),l(Wi),l(ZT),l(NT),l(Xi),l(AT),l(Li),l(vT),l(Di),l(_T),l(RT),l(YT),l(Fi),l($T),l(VT),l(Oi),l(ET),l(Ki),l(PT),l(HT),l(tn),l(zT),l(ln),l(WT),l(ST),l(XT),l(sn),l(LT),l(DT),l(an),l(FT),l(pn),l(qT),l(OT),l(KT),l(on),l(em),l(tm),l(cn),l(lm),l(Mn),l(sm),l(rn),l(im),l(nm),l(am),l(Tn),l(pm),l(om),l(yn),l(dm),l(Jn),l(cm),l(Mm),l(un),l(rm),l(Tm),l(jn),l(mm),l(Un),l(ym),l(Jm),l(hm),l(fn),l(um),l(wm),l(xn),l(jm),l(Cn),l(Um),l(fm),l(bm),l(gn),l(xm),l(Cm),l(kn),l(gm),l(Gn),l(Im),l(Qn),l(km),l(Gm),l(Qm),l(Bn),l(Bm),l(Zm),l(Nn),l(Nm),l(An),l(Am),l(vm),l(_n),l(_m),l(Rm),l(Ym),l(Rn),l($m),l(Vm),l($n),l(Em),l(Vn),l(Pm),l(En),l(Hm),l(zm),l(Wm),l(Pn),l(Sm),l(Xm),l(zn),l(Lm),l(Wn),l(Dm),l(Fm),l(Xn),l(qm),l(Om),l(Km),l(Ln),l(ey),l(ty),l(Fn),l(ly),l(qn),l(sy),l(On),l(iy),l(ny),l(ay),l(Kn),l(py),l(oy),l(ta),l(dy),l(la),l(cy),l(sa),l(My),l(ia),l(ry),l(Ty),l(my),l(na),l(yy),l(Jy),l(pa),l(hy),l(oa),l(uy),l(wy),l(jy),l(da),l(Uy),l(fy),l(Ma),l(by),l(xy),l(Cy),l(ra),l(gy),l(Iy),l(ma),l(ky),l(ya),l(Gy),l(Qy),l(By),l(ha)),l(w),y(U,e),y(x,e),y(I,e),y(Z,e),y(_,e),y(V,e),y(W,e),y(L,e),y(F,e),y(O,e),y(te,e),y(ae,e),y(de,e),y(Me,e),y(me,e),y(we,e),y(fe,e),y(Ce,e),y(Qe,e),y(Ne,e),y(ve,e),y(Ye,e),y(He,e),y(Se,e),y(De,e),y(tt,e),y(it,e),y(pt,e),y(Mt,e),y(mt,e),y(ht,e),y(jt,e),y(bt,e),y(Ct,e),y(It,e),y(Qt,e),y(vt,e),y(Yt,e),y(Vt,e),y(zt,e),y(Lt,e),y(Ot,e),y(tl,e),y(sl,e),y(nl,e),y(ol,e),y(Tl,e),y(Jl,e),y(jl,e),y(xl,e),y(Gl,e),y(Zl,e),y(Al,e),y(_l,e),y(Yl,e),y(Vl,e),y(Pl,e),y(Sl,e),y(Fl,e),y(ts,e),y(is,e),y(as,e),y(cs,e),y(ms,e),y(ws,e),y(fs,e),y(xs,e),y(gs,e),y(Qs,e),y(As,e),y($s,e),y(Ps,e),y(Ss,e),y(Fs,e),y(ti,e),y(ii,e),y(oi,e),y(ri,e),y(hi,e),y(ji,e),y(xi,e),y(ki,e),y(Ni,e),y(_i,e),y(Yi,e),y(Pi,e),y(Si,e),y(qi,e),y(en,e),y(nn,e),y(dn,e),y(mn,e),y(hn,e),y(wn,e),y(bn,e),y(In,e),y(Zn,e),y(vn,e),y(Yn,e),y(Hn,e),y(Sn,e),y(Dn,e),y(ea,e),y(aa,e),y(ca,e),y(Ta,e)}}}const Bw='{"title":"pipelines","local":"pipelines","sections":[{"title":"pipelines.Pipeline ⇐ <code> Callable </code>","local":"pipelinespipeline--code-callable-code","sections":[{"title":"new Pipeline(options)","local":"new-pipelineoptions","sections":[],"depth":3},{"title":"pipeline.dispose() ⇒ <code> Promise. < void > </code>","local":"pipelinedispose--code-promise--void--code","sections":[],"depth":3},{"title":"pipeline._call(texts, ...args) ⇒ <code> Promise. < any > </code>","local":"pipelinecalltexts-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TextClassificationPipeline","local":"pipelinestextclassificationpipeline","sections":[{"title":"textClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"textclassificationpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TokenClassificationPipeline","local":"pipelinestokenclassificationpipeline","sections":[{"title":"tokenClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"tokenclassificationpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.QuestionAnsweringPipeline","local":"pipelinesquestionansweringpipeline","sections":[{"title":"questionAnsweringPipeline._call(question, context, options) ⇒ <code> QuestionAnsweringReturnType </code>","local":"questionansweringpipelinecallquestion-context-options--code-questionansweringreturntype-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.FillMaskPipeline","local":"pipelinesfillmaskpipeline","sections":[{"title":"fillMaskPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"fillmaskpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.Text2TextGenerationPipeline","local":"pipelinestext2textgenerationpipeline","sections":[{"title":"text2TextGenerationPipeline._call(texts, [options]) ⇒ <code> Promise. < any > </code>","local":"text2textgenerationpipelinecalltexts-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.SummarizationPipeline","local":"pipelinessummarizationpipeline","sections":[],"depth":2},{"title":"pipelines.TranslationPipeline","local":"pipelinestranslationpipeline","sections":[],"depth":2},{"title":"pipelines.TextGenerationPipeline","local":"pipelinestextgenerationpipeline","sections":[{"title":"textGenerationPipeline._call(texts, [generate_kwargs]) ⇒ <code> Promise. < any > </code>","local":"textgenerationpipelinecalltexts-generatekwargs--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotClassificationPipeline","local":"pipelineszeroshotclassificationpipeline","sections":[{"title":"new ZeroShotClassificationPipeline(options)","local":"new-zeroshotclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotClassificationPipeline._call(texts, candidate_labels, options) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"zeroshotclassificationpipelinecalltexts-candidatelabels-options--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.FeatureExtractionPipeline","local":"pipelinesfeatureextractionpipeline","sections":[{"title":"featureExtractionPipeline._call(texts, options) ⇒","local":"featureextractionpipelinecalltexts-options-","sections":[],"depth":3}],"depth":2},{"title":"pipelines.AudioClassificationPipeline","local":"pipelinesaudioclassificationpipeline","sections":[{"title":"new AudioClassificationPipeline(options)","local":"new-audioclassificationpipelineoptions","sections":[],"depth":3},{"title":"audioClassificationPipeline._call(audio, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"audioclassificationpipelinecallaudio-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.AutomaticSpeechRecognitionPipeline","local":"pipelinesautomaticspeechrecognitionpipeline","sections":[{"title":"new AutomaticSpeechRecognitionPipeline(options)","local":"new-automaticspeechrecognitionpipelineoptions","sections":[],"depth":3},{"title":"automaticSpeechRecognitionPipeline._call(audio, [kwargs]) ⇒ <code> Promise. < Object > </code>","local":"automaticspeechrecognitionpipelinecallaudio-kwargs--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageToTextPipeline","local":"pipelinesimagetotextpipeline","sections":[{"title":"new ImageToTextPipeline(options)","local":"new-imagetotextpipelineoptions","sections":[],"depth":3},{"title":"imageToTextPipeline._call(images, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"imagetotextpipelinecallimages-generatekwargs--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageClassificationPipeline","local":"pipelinesimageclassificationpipeline","sections":[{"title":"new ImageClassificationPipeline(options)","local":"new-imageclassificationpipelineoptions","sections":[],"depth":3},{"title":"imageClassificationPipeline._call(images, options) ⇒ <code> Promise. < any > </code>","local":"imageclassificationpipelinecallimages-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageSegmentationPipeline","local":"pipelinesimagesegmentationpipeline","sections":[{"title":"new ImageSegmentationPipeline(options)","local":"new-imagesegmentationpipelineoptions","sections":[],"depth":3},{"title":"imageSegmentationPipeline._call(images, options) ⇒ <code> Promise. < Array > </code>","local":"imagesegmentationpipelinecallimages-options--code-promise--array--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotImageClassificationPipeline","local":"pipelineszeroshotimageclassificationpipeline","sections":[{"title":"new ZeroShotImageClassificationPipeline(options)","local":"new-zeroshotimageclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotImageClassificationPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>","local":"zeroshotimageclassificationpipelinecallimages-candidatelabels-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ObjectDetectionPipeline","local":"pipelinesobjectdetectionpipeline","sections":[{"title":"new ObjectDetectionPipeline(options)","local":"new-objectdetectionpipelineoptions","sections":[],"depth":3},{"title":"objectDetectionPipeline._call(images, options)","local":"objectdetectionpipelinecallimages-options","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotObjectDetectionPipeline","local":"pipelineszeroshotobjectdetectionpipeline","sections":[{"title":"new ZeroShotObjectDetectionPipeline(options)","local":"new-zeroshotobjectdetectionpipelineoptions","sections":[],"depth":3},{"title":"zeroShotObjectDetectionPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>","local":"zeroshotobjectdetectionpipelinecallimages-candidatelabels-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.DocumentQuestionAnsweringPipeline","local":"pipelinesdocumentquestionansweringpipeline","sections":[{"title":"new DocumentQuestionAnsweringPipeline(options)","local":"new-documentquestionansweringpipelineoptions","sections":[],"depth":3},{"title":"documentQuestionAnsweringPipeline._call(image, question, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"documentquestionansweringpipelinecallimage-question-generatekwargs--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TextToAudioPipeline","local":"pipelinestexttoaudiopipeline","sections":[{"title":"new TextToAudioPipeline(options)","local":"new-texttoaudiopipelineoptions","sections":[],"depth":3},{"title":"textToAudioPipeline._call(text_inputs, options) ⇒ <code> Promise. < Object > </code>","local":"texttoaudiopipelinecalltextinputs-options--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageToImagePipeline","local":"pipelinesimagetoimagepipeline","sections":[{"title":"imageToImagePipeline._call(images) ⇒ <code> Promise. < any > </code>","local":"imagetoimagepipelinecallimages--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.DepthEstimationPipeline","local":"pipelinesdepthestimationpipeline","sections":[{"title":"depthEstimationPipeline._call(images) ⇒ <code> Promise. < any > </code>","local":"depthestimationpipelinecallimages--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.pipeline(task, [model], [options]) ⇒ <code> Promise. < Pipeline > </code>","local":"pipelinespipelinetask-model-options--code-promise--pipeline--code","sections":[],"depth":2},{"title":"pipelines~QuestionAnsweringResult : <code> object </code>","local":"pipelinesquestionansweringresult--code-object-code","sections":[],"depth":2},{"title":"pipelines~QuestionAnsweringReturnType : <code> Promise. < (QuestionAnsweringResult|Array < QuestionAnsweringResult > ) > </code>","local":"pipelinesquestionansweringreturntype--code-promise--questionansweringresultarray--questionansweringresult----code","sections":[],"depth":2},{"title":"pipelines~ChunkCallback : <code> function </code>","local":"pipelineschunkcallback--code-function-code","sections":[],"depth":2}],"depth":1}';function Zw(Ny){return Cw(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rw extends gw{constructor(w){super(),Iw(this,w,Zw,Qw,bw,{})}}export{Rw as component};
