import{s as UM,n as eM,o as tM}from"../chunks/scheduler.362310b7.js";import{S as TM,i as JM,g as J,s as t,r as C,A as sM,h as s,f as U,c as T,j as lM,u as j,x as a,k as MM,y as aM,a as e,v as n,d as A,t as y,w}from"../chunks/index.57dfc70d.js";import{C as bl}from"../chunks/CodeBlock.d3c47f83.js";import{H as L,E as CM}from"../chunks/EditOnGithub.9633c464.js";function jM(El){let i,P,$,K,I,q,r,Sl="This document aims at describing the architecture of Text Generation Inference (TGI), by describing the call flow between the separate components.",ll,o,fl="A high-level architecture diagram can be seen here:",Ml,p,Bl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/TGI.png" alt="TGI architecture"/>',Ul,c,vl="This diagram shows well there are these separate components:",el,V,Zl="<li><strong>The router</strong>, also named <code>webserver</code>, that receives the client requests, buffers them, creates some batches, and prepares gRPC calls to a model server.</li> <li><strong>The model server</strong>, responsible of receiving the gRPC requests and to process the inference on the model. If the model is sharded across multiple accelerators (e.g.: multiple GPUs), the model server shards might be synchronized via NCCL or equivalent.</li> <li><strong>The launcher</strong> is a helper that will be able to launch one or several model servers (if model is sharded), and it launches the router with the compatible arguments.</li>",tl,N,kl="The router and the model server can be two different machines, they do not need to be deployed together.",Tl,h,Jl,d,Xl=`This component is a rust web server binary that accepts HTTP requests using the custom <a href="https://huggingface.github.io/text-generation-inference/" rel="nofollow">HTTP API</a>, as well as OpenAI’s <a href="https://huggingface.co/docs/text-generation-inference/messages_api" rel="nofollow">Messages API</a>.
The router receives the API calls and handles the “baches” logic (and introduction to batching can be found <a href="https://github.com/huggingface/text-generation-inference/blob/main/router/README.md" rel="nofollow">here</a>).
It uses different strategies to reduce latency between requests and responses, especially oriented to decoding latency. It will use queues, schedulers, and block allocators to achieve that and produce batched requests that it will then be sent to the model server.`,sl,m,al,R,Dl="The router command line will be the way to pass parameters to it (it does not rely on configuration file):",Cl,F,jl,g,nl,u,Wl=`The model server is a python server, capable of starting a server waiting for gRPC requests, loads a given model, perform sharding to provide <a href="https://huggingface.co/docs/text-generation-inference/conceptual/tensor_parallelism" rel="nofollow">tensor parallelism</a>, and stays alive while waiting for new requests.
The model server supports models instantiated using Pytorch and optimized for inference mainly on CUDA/ROCM.`,Al,Q,yl,O,Gl="Several variants of the model server exist that are actively supported by Hugging Face:",wl,b,_l='<li>By default, the model server will attempt building <a href="https://huggingface.co/docs/text-generation-inference/installation_nvidia" rel="nofollow">a server optimized for Nvidia GPUs with CUDA</a>. The code for this version is hosted in the <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">main TGI repository</a>.</li> <li>A <a href="https://huggingface.co/docs/text-generation-inference/installation_amd" rel="nofollow">version optimized for AMD with ROCm</a> is hosted in the main TGI repository. Some model features differ.</li> <li>A <a href="https://huggingface.co/docs/text-generation-inference/installation_intel" rel="nofollow">version optimized for Intel GPUs</a> is hosted in the main TGI repository. Some model features differ.</li> <li>The <a href="https://huggingface.co/docs/text-generation-inference/installation_gaudi" rel="nofollow">version for Intel Gaudi</a> is maintained on a forked repository, often resynchronized with the main <a href="https://github.com/huggingface/tgi-gaudi" rel="nofollow">TGI repository</a>.</li> <li>A <a href="https://huggingface.co/docs/text-generation-inference/installation_inferentia" rel="nofollow">version for Neuron (AWS Inferentia2)</a> is maintained as part of <a href="https://github.com/huggingface/optimum-neuron/tree/main/text-generation-inference" rel="nofollow">Optimum Neuron</a>.</li> <li>A version for Google TPUs is maintained as part of <a href="https://github.com/huggingface/optimum-tpu/tree/main/text-generation-inference" rel="nofollow">Optimum TPU</a>.</li>',il,E,zl="Not all variants provide the same features, as hardware and middleware capabilities do not provide the same optimizations.",Il,S,rl,f,xl="The official command line interface (CLI) for the server supports three subcommands, <code>download-weights</code>, <code>quantize</code> and <code>serve</code>:",ol,B,Yl="<li><code>download-weights</code> will download weights from the hub and, in some variants it will convert weights to a format that is adapted to the given implementation;</li> <li><code>quantize</code> will allow to quantize a model using the <code>qptq</code> package. This feature is not available nor supported on all variants;</li> <li><code>serve</code> will start the server that load a model (or a model shard), receives gRPC calls from the router, performs an inference and provides a formatted response to the given request.</li>",pl,v,Ll="Serve’s command line parameters on the TGI repository are these:",cl,Z,Vl,k,$l="Note that some variants might support different parameters, and they could possibly accept more options that can be passed on using environment variables.",Nl,X,hl,D,Hl='Once both components are initialized, weights downloaded and model server is up and running, router and model server exchange data and info through the gRPC call. There are currently two supported schemas, <a href="https://github.com/huggingface/text-generation-inference/blob/main/proto/generate.proto" rel="nofollow">v2</a> and <a href="https://github.com/huggingface/text-generation-inference/blob/main/proto/v3/generate.proto" rel="nofollow">v3</a>. These two versions are almost identical, except for:',dl,W,Pl="<li>input chunks support, for text and image data,</li> <li>paged attention support</li>",ml,G,Kl="Here’s a diagram that displays the exchanges that follow the router and model server startup.",Rl,_,Fl,z,ql="After these are done, the router is ready to receive generate calls from multiple clients. Here’s an example.",gl,x,ul,Y,Ql,H,Ol;return I=new L({props:{title:"Text Generation Inference Architecture",local:"text-generation-inference-architecture",headingTag:"h1"}}),h=new L({props:{title:"The Router",local:"the-router",headingTag:"h2"}}),m=new L({props:{title:"Router’s command line",local:"routers-command-line",headingTag:"h3"}}),F=new bl({props:{code:"VGV4dCUyMEdlbmVyYXRpb24lMjBXZWJzZXJ2ZXIlMEElMEFVc2FnZSUzQSUyMHRleHQtZ2VuZXJhdGlvbi1yb3V0ZXIlMjAlNUJPUFRJT05TJTVEJTBBJTBBT3B0aW9ucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMC0tbWF4LWNvbmN1cnJlbnQtcmVxdWVzdHMlMjAlM0NNQVhfQ09OQ1VSUkVOVF9SRVFVRVNUUyUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmVudiUzQSUyME1BWF9DT05DVVJSRU5UX1JFUVVFU1RTJTNEJTVEJTIwJTVCZGVmYXVsdCUzQSUyMDEyOCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMC0tbWF4LWJlc3Qtb2YlMjAlM0NNQVhfQkVTVF9PRiUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmVudiUzQSUyME1BWF9CRVNUX09GJTNEJTVEJTIwJTVCZGVmYXVsdCUzQSUyMDIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAtLW1heC1zdG9wLXNlcXVlbmNlcyUyMCUzQ01BWF9TVE9QX1NFUVVFTkNFUyUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmVudiUzQSUyME1BWF9TVE9QX1NFUVVFTkNFUyUzRCU1RCUyMCU1QmRlZmF1bHQlM0ElMjA0JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwLS1tYXgtdG9wLW4tdG9rZW5zJTIwJTNDTUFYX1RPUF9OX1RPS0VOUyUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmVudiUzQSUyME1BWF9UT1BfTl9UT0tFTlMlM0QlNUQlMjAlNUJkZWZhdWx0JTNBJTIwNSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMC0tbWF4LWlucHV0LXRva2VucyUyMCUzQ01BWF9JTlBVVF9UT0tFTlMlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJlbnYlM0ElMjBNQVhfSU5QVVRfVE9LRU5TJTNEJTVEJTIwJTVCZGVmYXVsdCUzQSUyMDEwMjQlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAtLW1heC10b3RhbC10b2tlbnMlMjAlM0NNQVhfVE9UQUxfVE9LRU5TJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCZW52JTNBJTIwTUFYX1RPVEFMX1RPS0VOUyUzRCU1RCUyMCU1QmRlZmF1bHQlM0ElMjAyMDQ4JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwLS13YWl0aW5nLXNlcnZlZC1yYXRpbyUyMCUzQ1dBSVRJTkdfU0VSVkVEX1JBVElPJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCZW52JTNBJTIwV0FJVElOR19TRVJWRURfUkFUSU8lM0QlNUQlMjAlNUJkZWZhdWx0JTNBJTIwMS4yJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwLS1tYXgtYmF0Y2gtcHJlZmlsbC10b2tlbnMlMjAlM0NNQVhfQkFUQ0hfUFJFRklMTF9UT0tFTlMlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJlbnYlM0ElMjBNQVhfQkFUQ0hfUFJFRklMTF9UT0tFTlMlM0QlNUQlMjAlNUJkZWZhdWx0JTNBJTIwNDA5NiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMC0tbWF4LWJhdGNoLXRvdGFsLXRva2VucyUyMCUzQ01BWF9CQVRDSF9UT1RBTF9UT0tFTlMlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJlbnYlM0ElMjBNQVhfQkFUQ0hfVE9UQUxfVE9LRU5TJTNEJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwLS1tYXgtd2FpdGluZy10b2tlbnMlMjAlM0NNQVhfV0FJVElOR19UT0tFTlMlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJlbnYlM0ElMjBNQVhfV0FJVElOR19UT0tFTlMlM0QlNUQlMjAlNUJkZWZhdWx0JTNBJTIwMjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAtLW1heC1iYXRjaC1zaXplJTIwJTNDTUFYX0JBVENIX1NJWkUlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJlbnYlM0ElMjBNQVhfQkFUQ0hfU0laRSUzRCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMC0taG9zdG5hbWUlMjAlM0NIT1NUTkFNRSUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmVudiUzQSUyMEhPU1ROQU1FJTNEJTVEJTIwJTVCZGVmYXVsdCUzQSUyMDAuMC4wLjAlNUQlMEElMjAlMjAtcCUyQyUyMC0tcG9ydCUyMCUzQ1BPUlQlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJlbnYlM0ElMjBQT1JUJTNEJTVEJTIwJTVCZGVmYXVsdCUzQSUyMDMwMDAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAtLW1hc3Rlci1zaGFyZC11ZHMtcGF0aCUyMCUzQ01BU1RFUl9TSEFSRF9VRFNfUEFUSCUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmVudiUzQSUyME1BU1RFUl9TSEFSRF9VRFNfUEFUSCUzRCU1RCUyMCU1QmRlZmF1bHQlM0ElMjAlMkZ0bXAlMkZ0ZXh0LWdlbmVyYXRpb24tc2VydmVyLTAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAtLXRva2VuaXplci1uYW1lJTIwJTNDVE9LRU5JWkVSX05BTUUlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJlbnYlM0ElMjBUT0tFTklaRVJfTkFNRSUzRCU1RCUyMCU1QmRlZmF1bHQlM0ElMjBiaWdzY2llbmNlJTJGYmxvb20lNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAtLXRva2VuaXplci1jb25maWctcGF0aCUyMCUzQ1RPS0VOSVpFUl9DT05GSUdfUEFUSCUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmVudiUzQSUyMFRPS0VOSVpFUl9DT05GSUdfUEFUSCUzRCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMC0tcmV2aXNpb24lMjAlM0NSRVZJU0lPTiUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmVudiUzQSUyMFJFVklTSU9OJTNEJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwLS12YWxpZGF0aW9uLXdvcmtlcnMlMjAlM0NWQUxJREFUSU9OX1dPUktFUlMlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJlbnYlM0ElMjBWQUxJREFUSU9OX1dPUktFUlMlM0QlNUQlMjAlNUJkZWZhdWx0JTNBJTIwMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMC0tanNvbi1vdXRwdXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJlbnYlM0ElMjBKU09OX09VVFBVVCUzRCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMC0tb3RscC1lbmRwb2ludCUyMCUzQ09UTFBfRU5EUE9JTlQlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJlbnYlM0ElMjBPVExQX0VORFBPSU5UJTNEJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwLS1vdGxwLXNlcnZpY2UtbmFtZSUyMCUzQ09UTFBfU0VSVklDRV9OQU1FJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCZW52JTNBJTIwT1RMUF9TRVJWSUNFX05BTUUlM0QlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAtLWNvcnMtYWxsb3ctb3JpZ2luJTIwJTNDQ09SU19BTExPV19PUklHSU4lM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJlbnYlM0ElMjBDT1JTX0FMTE9XX09SSUdJTiUzRCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMC0tbmdyb2slMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJlbnYlM0ElMjBOR1JPSyUzRCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMC0tbmdyb2stYXV0aHRva2VuJTIwJTNDTkdST0tfQVVUSFRPS0VOJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCZW52JTNBJTIwTkdST0tfQVVUSFRPS0VOJTNEJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwLS1uZ3Jvay1lZGdlJTIwJTNDTkdST0tfRURHRSUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmVudiUzQSUyME5HUk9LX0VER0UlM0QlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAtLW1lc3NhZ2VzLWFwaS1lbmFibGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCZW52JTNBJTIwTUVTU0FHRVNfQVBJX0VOQUJMRUQlM0QlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAtLWRpc2FibGUtZ3JhbW1hci1zdXBwb3J0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCZW52JTNBJTIwRElTQUJMRV9HUkFNTUFSX1NVUFBPUlQlM0QlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAtLW1heC1jbGllbnQtYmF0Y2gtc2l6ZSUyMCUzQ01BWF9DTElFTlRfQkFUQ0hfU0laRSUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmVudiUzQSUyME1BWF9DTElFTlRfQkFUQ0hfU0laRSUzRCU1RCUyMCU1QmRlZmF1bHQlM0ElMjA0JTVEJTBBJTIwJTIwLWglMkMlMjAtLWhlbHAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBQcmludCUyMGhlbHAlMEElMjAlMjAtViUyQyUyMC0tdmVyc2lvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFByaW50JTIwdmVyc2lvbg==",highlighted:`Text Generation Webserver

Usage: text-generation-router <span class="hljs-selector-attr">[OPTIONS]</span>

Options:
      <span class="hljs-attr">--max-concurrent-requests</span> &lt;MAX_CONCURRENT_REQUESTS&gt;
          <span class="hljs-selector-attr">[env: MAX_CONCURRENT_REQUESTS=]</span> <span class="hljs-selector-attr">[default: 128]</span>
      <span class="hljs-attr">--max-best-of</span> &lt;MAX_BEST_OF&gt;
          <span class="hljs-selector-attr">[env: MAX_BEST_OF=]</span> <span class="hljs-selector-attr">[default: 2]</span>
      <span class="hljs-attr">--max-stop-sequences</span> &lt;MAX_STOP_SEQUENCES&gt;
          <span class="hljs-selector-attr">[env: MAX_STOP_SEQUENCES=]</span> <span class="hljs-selector-attr">[default: 4]</span>
      <span class="hljs-attr">--max-top-n-tokens</span> &lt;MAX_TOP_N_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_TOP_N_TOKENS=]</span> <span class="hljs-selector-attr">[default: 5]</span>
      <span class="hljs-attr">--max-input-tokens</span> &lt;MAX_INPUT_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_INPUT_TOKENS=]</span> <span class="hljs-selector-attr">[default: 1024]</span>
      <span class="hljs-attr">--max-total-tokens</span> &lt;MAX_TOTAL_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_TOTAL_TOKENS=]</span> <span class="hljs-selector-attr">[default: 2048]</span>
      <span class="hljs-attr">--waiting-served-ratio</span> &lt;WAITING_SERVED_RATIO&gt;
          <span class="hljs-selector-attr">[env: WAITING_SERVED_RATIO=]</span> <span class="hljs-selector-attr">[default: 1.2]</span>
      <span class="hljs-attr">--max-batch-prefill-tokens</span> &lt;MAX_BATCH_PREFILL_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_BATCH_PREFILL_TOKENS=]</span> <span class="hljs-selector-attr">[default: 4096]</span>
      <span class="hljs-attr">--max-batch-total-tokens</span> &lt;MAX_BATCH_TOTAL_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_BATCH_TOTAL_TOKENS=]</span>
      <span class="hljs-attr">--max-waiting-tokens</span> &lt;MAX_WAITING_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_WAITING_TOKENS=]</span> <span class="hljs-selector-attr">[default: 20]</span>
      <span class="hljs-attr">--max-batch-size</span> &lt;MAX_BATCH_SIZE&gt;
          <span class="hljs-selector-attr">[env: MAX_BATCH_SIZE=]</span>
      <span class="hljs-attr">--hostname</span> &lt;HOSTNAME&gt;
          <span class="hljs-selector-attr">[env: HOSTNAME=]</span> <span class="hljs-selector-attr">[default: 0.0.0.0]</span>
  -<span class="hljs-selector-tag">p</span>, <span class="hljs-attr">--port</span> &lt;PORT&gt;
          <span class="hljs-selector-attr">[env: PORT=]</span> <span class="hljs-selector-attr">[default: 3000]</span>
      <span class="hljs-attr">--master-shard-uds-path</span> &lt;MASTER_SHARD_UDS_PATH&gt;
          <span class="hljs-selector-attr">[env: MASTER_SHARD_UDS_PATH=]</span> <span class="hljs-selector-attr">[default: /tmp/text-generation-server-0]</span>
      <span class="hljs-attr">--tokenizer-name</span> &lt;TOKENIZER_NAME&gt;
          <span class="hljs-selector-attr">[env: TOKENIZER_NAME=]</span> <span class="hljs-selector-attr">[default: bigscience/bloom]</span>
      <span class="hljs-attr">--tokenizer-config-path</span> &lt;TOKENIZER_CONFIG_PATH&gt;
          <span class="hljs-selector-attr">[env: TOKENIZER_CONFIG_PATH=]</span>
      <span class="hljs-attr">--revision</span> &lt;REVISION&gt;
          <span class="hljs-selector-attr">[env: REVISION=]</span>
      <span class="hljs-attr">--validation-workers</span> &lt;VALIDATION_WORKERS&gt;
          <span class="hljs-selector-attr">[env: VALIDATION_WORKERS=]</span> <span class="hljs-selector-attr">[default: 2]</span>
      <span class="hljs-attr">--json-output</span>
          <span class="hljs-selector-attr">[env: JSON_OUTPUT=]</span>
      <span class="hljs-attr">--otlp-endpoint</span> &lt;OTLP_ENDPOINT&gt;
          <span class="hljs-selector-attr">[env: OTLP_ENDPOINT=]</span>
      <span class="hljs-attr">--otlp-service-name</span> &lt;OTLP_SERVICE_NAME&gt;
          <span class="hljs-selector-attr">[env: OTLP_SERVICE_NAME=]</span>
      <span class="hljs-attr">--cors-allow-origin</span> &lt;CORS_ALLOW_ORIGIN&gt;
          <span class="hljs-selector-attr">[env: CORS_ALLOW_ORIGIN=]</span>
      <span class="hljs-attr">--ngrok</span>
          <span class="hljs-selector-attr">[env: NGROK=]</span>
      <span class="hljs-attr">--ngrok-authtoken</span> &lt;NGROK_AUTHTOKEN&gt;
          <span class="hljs-selector-attr">[env: NGROK_AUTHTOKEN=]</span>
      <span class="hljs-attr">--ngrok-edge</span> &lt;NGROK_EDGE&gt;
          <span class="hljs-selector-attr">[env: NGROK_EDGE=]</span>
      <span class="hljs-attr">--messages-api-enabled</span>
          <span class="hljs-selector-attr">[env: MESSAGES_API_ENABLED=]</span>
      <span class="hljs-attr">--disable-grammar-support</span>
          <span class="hljs-selector-attr">[env: DISABLE_GRAMMAR_SUPPORT=]</span>
      <span class="hljs-attr">--max-client-batch-size</span> &lt;MAX_CLIENT_BATCH_SIZE&gt;
          <span class="hljs-selector-attr">[env: MAX_CLIENT_BATCH_SIZE=]</span> <span class="hljs-selector-attr">[default: 4]</span>
  -h, <span class="hljs-attr">--help</span>
          Print help
  -V, <span class="hljs-attr">--version</span>
          Print version`,wrap:!1}}),g=new L({props:{title:"The Model Server",local:"the-model-server",headingTag:"h2"}}),Q=new L({props:{title:"Model Server Variants",local:"model-server-variants",headingTag:"h3"}}),S=new L({props:{title:"Command Line Interface",local:"command-line-interface",headingTag:"h3"}}),Z=new bl({props:{code:"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",highlighted:` Usage: cli.py serve [OPTIONS] MODEL_ID

╭─ Arguments ──────────────────────────────────────────────────────────────────────────────────────────────╮
│ *    model_id      TEXT  [default: None] [required]                                                      │
╰──────────────────────────────────────────────────────────────────────────────────────────────────────────╯
╭─ Options ────────────────────────────────────────────────────────────────────────────────────────────────╮
│ <span class="hljs-params">--revision</span>                                       TEXT                        [default: None]             │
│ <span class="hljs-params">--sharded</span>              <span class="hljs-params">--no-sharded</span>                                          [default: no-sharded]       │
│ <span class="hljs-params">--quantize</span>                                       [bitsandbytes|bitsandbytes  [default: None]             │
│                                                  -nf4|bitsandbytes-fp4|gptq                              │
│                                                  |awq|eetq|exl2|fp8]                                     │
│ <span class="hljs-params">--speculate</span>                                      INTEGER                     [default: None]             │
│ <span class="hljs-params">--dtype</span>                                          [float16|bfloat16]          [default: None]             │
│ <span class="hljs-params">--trust-remote-code</span>    <span class="hljs-params">--no-trust-remote-code</span>                                [default:                   │
│                                                                              no-trust-remote-code]       │
│ <span class="hljs-params">--uds-path</span>                                       PATH                        [default:                   │
│                                                                              <span class="hljs-string">/tmp/text-generation-serve</span>… │
│ <span class="hljs-params">--logger-level</span>                                   TEXT                        [default: INFO]             │
│ <span class="hljs-params">--json-output</span>          <span class="hljs-params">--no-json-output</span>                                      [default: no-json-output]   │
│ <span class="hljs-params">--otlp-endpoint</span>                                  TEXT                        [default: None]             │
│ <span class="hljs-params">--otlp-service-name</span>                              TEXT                        [default:                   │
│                                                                              text-generation-inference.<span class="hljs-string">..</span>│
│ <span class="hljs-params">--help</span>                                                                       Show this message and exit. │
╰──────────────────────────────────────────────────────────────────────────────────────────────────────────╯`,wrap:!1}}),X=new L({props:{title:"Call Flow",local:"call-flow",headingTag:"h2"}}),_=new bl({props:{code:"c2VxdWVuY2VEaWFncmFtJTBBJTBBJTIwJTIwJTIwJTIwUm91dGVyLSUzRSUzRU1vZGVsJTIwU2VydmVyJTNBJTIwc2VydmljZSUyMGRpc2NvdmVyeSUwQSUyMCUyMCUyMCUyME1vZGVsJTIwU2VydmVyLS0lM0UlM0VSb3V0ZXIlM0ElMjB1cmxzJTIwZm9yJTIwb3RoZXIlMjBzaGFyZHMlMEElMEElMjAlMjAlMjAlMjBSb3V0ZXItJTNFJTNFTW9kZWwlMjBTZXJ2ZXIlM0ElMjBnZXQlMjBtb2RlbCUyMGluZm8lMEElMjAlMjAlMjAlMjBNb2RlbCUyMFNlcnZlci0tJTNFJTNFUm91dGVyJTNBJTIwc2hhcmQlMjBpbmZvJTBBJTBBJTIwJTIwJTIwJTIwUm91dGVyLSUzRSUzRU1vZGVsJTIwU2VydmVyJTNBJTIwaGVhbHRoJTIwY2hlY2slMEElMjAlMjAlMjAlMjBNb2RlbCUyMFNlcnZlci0tJTNFJTNFUm91dGVyJTNBJTIwaGVhbHRoJTIwT0slMEElMEElMjAlMjAlMjAlMjBSb3V0ZXItJTNFJTNFTW9kZWwlMjBTZXJ2ZXIlM0ElMjB3YXJtdXAobWF4X2lucHV0X3Rva2VucyUyQyUyMG1heF9iYXRjaF9wcmVmaWxsX3Rva2VucyUyQyUyMG1heF90b3RhbF90b2tlbnMlMkMlMjBtYXhfYmF0Y2hfc2l6ZSklMEElMjAlMjAlMjAlMjBNb2RlbCUyMFNlcnZlci0tJTNFJTNFUm91dGVyJTNBJTIwd2FybXVwJTIwcmVzdWx0",highlighted:`sequenceDiagram

    R<span class="hljs-function"><span class="hljs-title">outer</span>-&gt;</span>&gt;Model Server: service discovery
    M<span class="hljs-function"><span class="hljs-title">odel</span> Server--&gt;</span>&gt;Router: urls <span class="hljs-keyword">for</span> other shards

    R<span class="hljs-function"><span class="hljs-title">outer</span>-&gt;</span>&gt;Model Server: get model info
    M<span class="hljs-function"><span class="hljs-title">odel</span> Server--&gt;</span>&gt;Router: shard info

    R<span class="hljs-function"><span class="hljs-title">outer</span>-&gt;</span>&gt;Model Server: health check
    M<span class="hljs-function"><span class="hljs-title">odel</span> Server--&gt;</span>&gt;Router: health OK

    R<span class="hljs-function"><span class="hljs-title">outer</span>-&gt;</span>&gt;Model Server: warmup(max_input_tokens, max_batch_prefill_tokens, max_total_tokens, max_batch_size)
    M<span class="hljs-function"><span class="hljs-title">odel</span> Server--&gt;</span>&gt;Router: warmup result`,wrap:!1}}),x=new bl({props:{code:"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",highlighted:`sequenceDiagram
    participant Client <span class="hljs-number">1</span>
    participant Client <span class="hljs-number">2</span>
    participant Client <span class="hljs-number">3</span>
    participant Router
    participant Model Server

    Client <span class="hljs-number">1</span>-&gt;&gt;Router: generate_stream
    Router-&gt;&gt;Model Server: prefill(batch1)
    Model Server--&gt;&gt;Router: generations, cached_batch1, timings
    Router--&gt;&gt;Client <span class="hljs-number">1</span>: token <span class="hljs-number">1</span>

    Router-&gt;&gt;Model Server: decode(cached_batch1)
    Model Server--&gt;&gt;Router: generations, cached_batch1, timings
    Router--&gt;&gt;Client <span class="hljs-number">1</span>: token <span class="hljs-number">2</span>

    Router-&gt;&gt;Model Server: decode(cached_batch1)
    Model Server--&gt;&gt;Router: generations, cached_batch1, timings
    Router--&gt;&gt;Client <span class="hljs-number">1</span>: token <span class="hljs-number">3</span>

    Client <span class="hljs-number">2</span>-&gt;&gt;Router: generate_stream
    Router-&gt;&gt;Model Server: prefill(batch2)
    Note <span class="hljs-built_in">right</span> of Model Server: This stops previous batch, that is restarted
    Model Server--&gt;&gt;Router: generations, cached_batch2, timings
    Router--&gt;&gt;Client <span class="hljs-number">2</span>: token <span class="hljs-number">1</span>&#x27;

    Router-&gt;&gt;Model Server: decode(cached_batch1, cached_batch2)
    Model Server--&gt;&gt;Router: generations, cached_batch1, timings
    Router--&gt;&gt;Client <span class="hljs-number">1</span>: token <span class="hljs-number">4</span>
    Router--&gt;&gt;Client <span class="hljs-number">2</span>: token <span class="hljs-number">2</span>&#x27;

    Note <span class="hljs-built_in">left</span> of Client <span class="hljs-number">1</span>: Client <span class="hljs-number">1</span> leaves
    Router-&gt;&gt;Model Server: filter_batch(cached_batch1, request_ids_to_keep=batch2)
    Model Server--&gt;&gt;Router: filtered batch

    Router-&gt;&gt;Model Server: decode(cached_batch2)
    Model Server--&gt;&gt;Router: generations, cached_batch2, timings
    Router--&gt;&gt;Client <span class="hljs-number">2</span>: token <span class="hljs-number">3</span>&#x27;

    Client <span class="hljs-number">3</span>-&gt;&gt;Router: generate_stream
    Note <span class="hljs-built_in">right</span> of Model Server: This stops previous batch, that is restarted
    Router-&gt;&gt;Model Server: prefill(batch3)
    Note <span class="hljs-built_in">left</span> of Client <span class="hljs-number">1</span>: Client <span class="hljs-number">3</span> leaves without receiving any batch
    Router-&gt;&gt;Model Server: clear_cache(batch3)
    Note <span class="hljs-built_in">right</span> of Model Server: This stops previous batch, that is restarted

    Router-&gt;&gt;Model Server: decode(cached_batch3)
    Note <span class="hljs-built_in">right</span> of Model Server: Last token (stopping criteria)
    Model Server--&gt;&gt;Router: generations, cached_batch3, timings
    Router--&gt;&gt;Client <span class="hljs-number">2</span>: token <span class="hljs-number">4</span>&#x27;

`,wrap:!1}}),Y=new CM({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/architecture.md"}}),{c(){i=J("meta"),P=t(),$=J("p"),K=t(),C(I.$$.fragment),q=t(),r=J("p"),r.textContent=Sl,ll=t(),o=J("p"),o.textContent=fl,Ml=t(),p=J("p"),p.innerHTML=Bl,Ul=t(),c=J("p"),c.textContent=vl,el=t(),V=J("ul"),V.innerHTML=Zl,tl=t(),N=J("p"),N.textContent=kl,Tl=t(),C(h.$$.fragment),Jl=t(),d=J("p"),d.innerHTML=Xl,sl=t(),C(m.$$.fragment),al=t(),R=J("p"),R.textContent=Dl,Cl=t(),C(F.$$.fragment),jl=t(),C(g.$$.fragment),nl=t(),u=J("p"),u.innerHTML=Wl,Al=t(),C(Q.$$.fragment),yl=t(),O=J("p"),O.textContent=Gl,wl=t(),b=J("ul"),b.innerHTML=_l,il=t(),E=J("p"),E.textContent=zl,Il=t(),C(S.$$.fragment),rl=t(),f=J("p"),f.innerHTML=xl,ol=t(),B=J("ul"),B.innerHTML=Yl,pl=t(),v=J("p"),v.textContent=Ll,cl=t(),C(Z.$$.fragment),Vl=t(),k=J("p"),k.textContent=$l,Nl=t(),C(X.$$.fragment),hl=t(),D=J("p"),D.innerHTML=Hl,dl=t(),W=J("ul"),W.innerHTML=Pl,ml=t(),G=J("p"),G.textContent=Kl,Rl=t(),C(_.$$.fragment),Fl=t(),z=J("p"),z.textContent=ql,gl=t(),C(x.$$.fragment),ul=t(),C(Y.$$.fragment),Ql=t(),H=J("p"),this.h()},l(l){const M=sM("svelte-u9bgzb",document.head);i=s(M,"META",{name:!0,content:!0}),M.forEach(U),P=T(l),$=s(l,"P",{}),lM($).forEach(U),K=T(l),j(I.$$.fragment,l),q=T(l),r=s(l,"P",{"data-svelte-h":!0}),a(r)!=="svelte-vphelk"&&(r.textContent=Sl),ll=T(l),o=s(l,"P",{"data-svelte-h":!0}),a(o)!=="svelte-772u2a"&&(o.textContent=fl),Ml=T(l),p=s(l,"P",{"data-svelte-h":!0}),a(p)!=="svelte-1l2f8t4"&&(p.innerHTML=Bl),Ul=T(l),c=s(l,"P",{"data-svelte-h":!0}),a(c)!=="svelte-1lzr5l3"&&(c.textContent=vl),el=T(l),V=s(l,"UL",{"data-svelte-h":!0}),a(V)!=="svelte-1wfu6c"&&(V.innerHTML=Zl),tl=T(l),N=s(l,"P",{"data-svelte-h":!0}),a(N)!=="svelte-9in8o2"&&(N.textContent=kl),Tl=T(l),j(h.$$.fragment,l),Jl=T(l),d=s(l,"P",{"data-svelte-h":!0}),a(d)!=="svelte-12wcxfx"&&(d.innerHTML=Xl),sl=T(l),j(m.$$.fragment,l),al=T(l),R=s(l,"P",{"data-svelte-h":!0}),a(R)!=="svelte-vrz9ad"&&(R.textContent=Dl),Cl=T(l),j(F.$$.fragment,l),jl=T(l),j(g.$$.fragment,l),nl=T(l),u=s(l,"P",{"data-svelte-h":!0}),a(u)!=="svelte-1fiirti"&&(u.innerHTML=Wl),Al=T(l),j(Q.$$.fragment,l),yl=T(l),O=s(l,"P",{"data-svelte-h":!0}),a(O)!=="svelte-hdemao"&&(O.textContent=Gl),wl=T(l),b=s(l,"UL",{"data-svelte-h":!0}),a(b)!=="svelte-pxmqif"&&(b.innerHTML=_l),il=T(l),E=s(l,"P",{"data-svelte-h":!0}),a(E)!=="svelte-12gjbvy"&&(E.textContent=zl),Il=T(l),j(S.$$.fragment,l),rl=T(l),f=s(l,"P",{"data-svelte-h":!0}),a(f)!=="svelte-8olu0s"&&(f.innerHTML=xl),ol=T(l),B=s(l,"UL",{"data-svelte-h":!0}),a(B)!=="svelte-1gvj873"&&(B.innerHTML=Yl),pl=T(l),v=s(l,"P",{"data-svelte-h":!0}),a(v)!=="svelte-1v1wq4t"&&(v.textContent=Ll),cl=T(l),j(Z.$$.fragment,l),Vl=T(l),k=s(l,"P",{"data-svelte-h":!0}),a(k)!=="svelte-182mwi5"&&(k.textContent=$l),Nl=T(l),j(X.$$.fragment,l),hl=T(l),D=s(l,"P",{"data-svelte-h":!0}),a(D)!=="svelte-10nkdn7"&&(D.innerHTML=Hl),dl=T(l),W=s(l,"UL",{"data-svelte-h":!0}),a(W)!=="svelte-1e4xpg3"&&(W.innerHTML=Pl),ml=T(l),G=s(l,"P",{"data-svelte-h":!0}),a(G)!=="svelte-16m2ryh"&&(G.textContent=Kl),Rl=T(l),j(_.$$.fragment,l),Fl=T(l),z=s(l,"P",{"data-svelte-h":!0}),a(z)!=="svelte-1qai9e7"&&(z.textContent=ql),gl=T(l),j(x.$$.fragment,l),ul=T(l),j(Y.$$.fragment,l),Ql=T(l),H=s(l,"P",{}),lM(H).forEach(U),this.h()},h(){MM(i,"name","hf:doc:metadata"),MM(i,"content",nM)},m(l,M){aM(document.head,i),e(l,P,M),e(l,$,M),e(l,K,M),n(I,l,M),e(l,q,M),e(l,r,M),e(l,ll,M),e(l,o,M),e(l,Ml,M),e(l,p,M),e(l,Ul,M),e(l,c,M),e(l,el,M),e(l,V,M),e(l,tl,M),e(l,N,M),e(l,Tl,M),n(h,l,M),e(l,Jl,M),e(l,d,M),e(l,sl,M),n(m,l,M),e(l,al,M),e(l,R,M),e(l,Cl,M),n(F,l,M),e(l,jl,M),n(g,l,M),e(l,nl,M),e(l,u,M),e(l,Al,M),n(Q,l,M),e(l,yl,M),e(l,O,M),e(l,wl,M),e(l,b,M),e(l,il,M),e(l,E,M),e(l,Il,M),n(S,l,M),e(l,rl,M),e(l,f,M),e(l,ol,M),e(l,B,M),e(l,pl,M),e(l,v,M),e(l,cl,M),n(Z,l,M),e(l,Vl,M),e(l,k,M),e(l,Nl,M),n(X,l,M),e(l,hl,M),e(l,D,M),e(l,dl,M),e(l,W,M),e(l,ml,M),e(l,G,M),e(l,Rl,M),n(_,l,M),e(l,Fl,M),e(l,z,M),e(l,gl,M),n(x,l,M),e(l,ul,M),n(Y,l,M),e(l,Ql,M),e(l,H,M),Ol=!0},p:eM,i(l){Ol||(A(I.$$.fragment,l),A(h.$$.fragment,l),A(m.$$.fragment,l),A(F.$$.fragment,l),A(g.$$.fragment,l),A(Q.$$.fragment,l),A(S.$$.fragment,l),A(Z.$$.fragment,l),A(X.$$.fragment,l),A(_.$$.fragment,l),A(x.$$.fragment,l),A(Y.$$.fragment,l),Ol=!0)},o(l){y(I.$$.fragment,l),y(h.$$.fragment,l),y(m.$$.fragment,l),y(F.$$.fragment,l),y(g.$$.fragment,l),y(Q.$$.fragment,l),y(S.$$.fragment,l),y(Z.$$.fragment,l),y(X.$$.fragment,l),y(_.$$.fragment,l),y(x.$$.fragment,l),y(Y.$$.fragment,l),Ol=!1},d(l){l&&(U(P),U($),U(K),U(q),U(r),U(ll),U(o),U(Ml),U(p),U(Ul),U(c),U(el),U(V),U(tl),U(N),U(Tl),U(Jl),U(d),U(sl),U(al),U(R),U(Cl),U(jl),U(nl),U(u),U(Al),U(yl),U(O),U(wl),U(b),U(il),U(E),U(Il),U(rl),U(f),U(ol),U(B),U(pl),U(v),U(cl),U(Vl),U(k),U(Nl),U(hl),U(D),U(dl),U(W),U(ml),U(G),U(Rl),U(Fl),U(z),U(gl),U(ul),U(Ql),U(H)),U(i),w(I,l),w(h,l),w(m,l),w(F,l),w(g,l),w(Q,l),w(S,l),w(Z,l),w(X,l),w(_,l),w(x,l),w(Y,l)}}}const nM='{"title":"Text Generation Inference Architecture","local":"text-generation-inference-architecture","sections":[{"title":"The Router","local":"the-router","sections":[{"title":"Router’s command line","local":"routers-command-line","sections":[],"depth":3}],"depth":2},{"title":"The Model Server","local":"the-model-server","sections":[{"title":"Model Server Variants","local":"model-server-variants","sections":[],"depth":3},{"title":"Command Line Interface","local":"command-line-interface","sections":[],"depth":3}],"depth":2},{"title":"Call Flow","local":"call-flow","sections":[],"depth":2}],"depth":1}';function AM(El){return tM(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rM extends TM{constructor(i){super(),JM(this,i,AM,jM,UM,{})}}export{rM as component};
