import{s as ft,o as Tt,n as Es}from"../chunks/scheduler.56730f09.js";import{S as wt,i as bt,g as o,s as n,r as M,A as $t,h as m,f as t,c as p,j as Jt,u as j,x as y,k as yt,y as It,a,v as h,d,t as u,w as J}from"../chunks/index.1f144517.js";import{T as Hl}from"../chunks/Tip.41e845e5.js";import{Y as Ct}from"../chunks/Youtube.62e0f062.js";import{C as T}from"../chunks/CodeBlock.738eeccb.js";import{D as _t}from"../chunks/DocNotebookDropdown.243c3df7.js";import{F as gt,M as Ut}from"../chunks/Markdown.c541024b.js";import{H as Gs,E as Rt}from"../chunks/EditOnGithub.854793f1.js";function kt(_){let e,g='이 작업과 호환되는 모든 아키텍처와 체크포인트를 보려면 <a href="https://huggingface.co/tasks/automatic-speech-recognition" rel="nofollow">작업 페이지</a>를 확인하는 것이 좋습니다.';return{c(){e=o("p"),e.innerHTML=g},l(c){e=m(c,"P",{"data-svelte-h":!0}),y(e)!=="svelte-19nd5l3"&&(e.innerHTML=g)},m(c,U){a(c,e,U)},p:Es,d(c){c&&t(e)}}}function Qt(_){let e,g='<code>Trainer</code>로 모델을 미세 조정하는 것이 익숙하지 않다면, <a href="../training#train-with-pytorch-trainer">여기</a>에서 기본 튜토리얼을 확인해보세요!';return{c(){e=o("p"),e.innerHTML=g},l(c){e=m(c,"P",{"data-svelte-h":!0}),y(e)!=="svelte-40ivbg"&&(e.innerHTML=g)},m(c,U){a(c,e,U)},p:Es,d(c){c&&t(e)}}}function vt(_){let e,g,c,U="이제 모델 훈련을 시작할 준비가 되었습니다! <code>AutoModelForCTC</code>로 Wav2Vec2를 가져오세요. <code>ctc_loss_reduction</code> 매개변수로 CTC 손실에 적용할 축소(reduction) 방법을 지정하세요. 기본값인 합계 대신 평균을 사용하는 것이 더 좋은 경우가 많습니다:",w,C,Q,k,R="이제 세 단계만 남았습니다:",v,b,G="<li><code>TrainingArguments</code>에서 훈련 하이퍼파라미터를 정의하세요. <code>output_dir</code>은 모델을 저장할 경로를 지정하는 유일한 필수 매개변수입니다. <code>push_to_hub=True</code>를 설정하여 모델을 Hub에 업로드 할 수 있습니다(모델을 업로드하려면 Hugging Face에 로그인해야 합니다). <code>Trainer</code>는 각 에폭마다 WER을 평가하고 훈련 체크포인트를 저장합니다.</li> <li>모델, 데이터 세트, 토크나이저, 데이터 콜레이터, <code>compute_metrics</code> 함수와 함께 <code>Trainer</code>에 훈련 인수를 전달하세요.</li> <li><code>train()</code>을 호출하여 모델을 미세 조정하세요.</li>",Z,$,V,r,I="훈련이 완료되면 모두가 모델을 사용할 수 있도록 <code>push_to_hub()</code> 메소드를 사용하여 모델을 Hub에 공유하세요:",Y,x,W;return e=new Hl({props:{$$slots:{default:[Qt]},$$scope:{ctx:_}}}),C=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNUQyUyQyUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UlMjIlMkMlMEElMjAlMjAlMjAlMjBjdGNfbG9zc19yZWR1Y3Rpb24lM0QlMjJtZWFuJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGFkX3Rva2VuX2lkJTNEcHJvY2Vzc29yLnRva2VuaXplci5wYWRfdG9rZW5faWQlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCTC, TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/wav2vec2-base&quot;</span>,
<span class="hljs-meta">... </span>    ctc_loss_reduction=<span class="hljs-string">&quot;mean&quot;</span>,
<span class="hljs-meta">... </span>    pad_token_id=processor.tokenizer.pad_token_id,
<span class="hljs-meta">... </span>)`,wrap:!1}}),$=new T({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJteV9hd2Vzb21lX2Fzcl9taW5kX21vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEMWUtNSUyQyUwQSUyMCUyMCUyMCUyMHdhcm11cF9zdGVwcyUzRDUwMCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDIwMDAlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9jaGVja3BvaW50aW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JvdXBfYnlfbGVuZ3RoJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1ldHJpY19mb3JfYmVzdF9tb2RlbCUzRCUyMndlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGdyZWF0ZXJfaXNfYmV0dGVyJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGVuY29kZWRfbWluZHMlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGVuY29kZWRfbWluZHMlNUIlMjJ0ZXN0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yLmZlYXR1cmVfZXh0cmFjdG9yJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;my_awesome_asr_mind_model&quot;</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    gradient_accumulation_steps=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">1e-5</span>,
<span class="hljs-meta">... </span>    warmup_steps=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>    max_steps=<span class="hljs-number">2000</span>,
<span class="hljs-meta">... </span>    gradient_checkpointing=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    fp16=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    group_by_length=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    eval_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    eval_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">25</span>,
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    metric_for_best_model=<span class="hljs-string">&quot;wer&quot;</span>,
<span class="hljs-meta">... </span>    greater_is_better=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=encoded_minds[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    eval_dataset=encoded_minds[<span class="hljs-string">&quot;test&quot;</span>],
<span class="hljs-meta">... </span>    tokenizer=processor.feature_extractor,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`,wrap:!1}}),x=new T({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),{c(){M(e.$$.fragment),g=n(),c=o("p"),c.innerHTML=U,w=n(),M(C.$$.fragment),Q=n(),k=o("p"),k.textContent=R,v=n(),b=o("ol"),b.innerHTML=G,Z=n(),M($.$$.fragment),V=n(),r=o("p"),r.innerHTML=I,Y=n(),M(x.$$.fragment)},l(i){j(e.$$.fragment,i),g=p(i),c=m(i,"P",{"data-svelte-h":!0}),y(c)!=="svelte-lskiab"&&(c.innerHTML=U),w=p(i),j(C.$$.fragment,i),Q=p(i),k=m(i,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1vwg7jz"&&(k.textContent=R),v=p(i),b=m(i,"OL",{"data-svelte-h":!0}),y(b)!=="svelte-1jcsgp0"&&(b.innerHTML=G),Z=p(i),j($.$$.fragment,i),V=p(i),r=m(i,"P",{"data-svelte-h":!0}),y(r)!=="svelte-u37ejb"&&(r.innerHTML=I),Y=p(i),j(x.$$.fragment,i)},m(i,f){h(e,i,f),a(i,g,f),a(i,c,f),a(i,w,f),h(C,i,f),a(i,Q,f),a(i,k,f),a(i,v,f),a(i,b,f),a(i,Z,f),h($,i,f),a(i,V,f),a(i,r,f),a(i,Y,f),h(x,i,f),W=!0},p(i,f){const Xs={};f&2&&(Xs.$$scope={dirty:f,ctx:i}),e.$set(Xs)},i(i){W||(d(e.$$.fragment,i),d(C.$$.fragment,i),d($.$$.fragment,i),d(x.$$.fragment,i),W=!0)},o(i){u(e.$$.fragment,i),u(C.$$.fragment,i),u($.$$.fragment,i),u(x.$$.fragment,i),W=!1},d(i){i&&(t(g),t(c),t(w),t(Q),t(k),t(v),t(b),t(Z),t(V),t(r),t(Y)),J(e,i),J(C,i),J($,i),J(x,i)}}}function Zt(_){let e,g;return e=new Ut({props:{$$slots:{default:[vt]},$$scope:{ctx:_}}}),{c(){M(e.$$.fragment)},l(c){j(e.$$.fragment,c)},m(c,U){h(e,c,U),g=!0},p(c,U){const w={};U&2&&(w.$$scope={dirty:U,ctx:c}),e.$set(w)},i(c){g||(d(e.$$.fragment,c),g=!0)},o(c){u(e.$$.fragment,c),g=!1},d(c){J(e,c)}}}function Wt(_){let e,g='자동 음성 인식을 위해 모델을 미세 조정하는 더 자세한 예제는 영어 자동 음성 인식을 위한 <a href="https://huggingface.co/blog/fine-tune-wav2vec2-english" rel="nofollow">블로그 포스트</a>와 다국어 자동 음성 인식을 위한 <a href="https://huggingface.co/blog/fine-tune-xlsr-wav2vec2" rel="nofollow">포스트</a>를 참조하세요.';return{c(){e=o("p"),e.innerHTML=g},l(c){e=m(c,"P",{"data-svelte-h":!0}),y(e)!=="svelte-1aqt9cb"&&(e.innerHTML=g)},m(c,U){a(c,e,U)},p:Es,d(c){c&&t(e)}}}function Vt(_){let e,g="텍스트로 변환된 결과가 꽤 괜찮지만 더 좋을 수도 있습니다! 더 나은 결과를 얻으려면 더 많은 예제로 모델을 미세 조정하세요!";return{c(){e=o("p"),e.textContent=g},l(c){e=m(c,"P",{"data-svelte-h":!0}),y(e)!=="svelte-1bgb7bv"&&(e.textContent=g)},m(c,U){a(c,e,U)},p:Es,d(c){c&&t(e)}}}function xt(_){let e,g="오디오 파일과 텍스트를 전처리하고 PyTorch 텐서로 <code>input</code>을 반환할 프로세서를 가져오세요:",c,U,w,C,Q="입력을 모델에 전달하고 로짓을 반환하세요:",k,R,v,b,G="가장 높은 확률의 <code>input_ids</code>를 예측하고, 프로세서를 사용하여 예측된 <code>input_ids</code>를 다시 텍스트로 디코딩하세요:",Z,$,V;return U=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzdGV2aGxpdSUyRm15X2F3ZXNvbWVfYXNyX21pbmRfbW9kZWwlMjIpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stevhliu/my_awesome_asr_mind_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),R=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNUQyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJzdGV2aGxpdSUyRm15X2F3ZXNvbWVfYXNyX21pbmRfbW9kZWwlMjIpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCTC

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;stevhliu/my_awesome_asr_mind_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits`,wrap:!1}}),$=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFwcmVkaWN0ZWRfaWRzJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQXRyYW5zY3JpcHRpb24lMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKHByZWRpY3RlZF9pZHMpJTBBdHJhbnNjcmlwdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription
[<span class="hljs-string">&#x27;I WOUL LIKE O SET UP JOINT ACOUNT WTH Y PARTNER&#x27;</span>]`,wrap:!1}}),{c(){e=o("p"),e.innerHTML=g,c=n(),M(U.$$.fragment),w=n(),C=o("p"),C.textContent=Q,k=n(),M(R.$$.fragment),v=n(),b=o("p"),b.innerHTML=G,Z=n(),M($.$$.fragment)},l(r){e=m(r,"P",{"data-svelte-h":!0}),y(e)!=="svelte-1l4sx2f"&&(e.innerHTML=g),c=p(r),j(U.$$.fragment,r),w=p(r),C=m(r,"P",{"data-svelte-h":!0}),y(C)!=="svelte-2w5h5p"&&(C.textContent=Q),k=p(r),j(R.$$.fragment,r),v=p(r),b=m(r,"P",{"data-svelte-h":!0}),y(b)!=="svelte-v9dw3r"&&(b.innerHTML=G),Z=p(r),j($.$$.fragment,r)},m(r,I){a(r,e,I),a(r,c,I),h(U,r,I),a(r,w,I),a(r,C,I),a(r,k,I),h(R,r,I),a(r,v,I),a(r,b,I),a(r,Z,I),h($,r,I),V=!0},p:Es,i(r){V||(d(U.$$.fragment,r),d(R.$$.fragment,r),d($.$$.fragment,r),V=!0)},o(r){u(U.$$.fragment,r),u(R.$$.fragment,r),u($.$$.fragment,r),V=!1},d(r){r&&(t(e),t(c),t(w),t(C),t(k),t(v),t(b),t(Z)),J(U,r),J(R,r),J($,r)}}}function Gt(_){let e,g;return e=new Ut({props:{$$slots:{default:[xt]},$$scope:{ctx:_}}}),{c(){M(e.$$.fragment)},l(c){j(e.$$.fragment,c)},m(c,U){h(e,c,U),g=!0},p(c,U){const w={};U&2&&(w.$$scope={dirty:U,ctx:c}),e.$set(w)},i(c){g||(d(e.$$.fragment,c),g=!0)},o(c){u(e.$$.fragment,c),g=!1},d(c){J(e,c)}}}function Xt(_){let e,g,c,U,w,C,Q,k,R,v,b,G=`자동 음성 인식(Automatic Speech Recognition, ASR)은 음성 신호를 텍스트로 변환하여 음성 입력 시퀀스를 텍스트 출력에 매핑합니다.
Siri와 Alexa와 같은 가상 어시스턴트는 ASR 모델을 사용하여 일상적으로 사용자를 돕고 있으며, 회의 중 라이브 캡션 및 메모 작성과 같은 유용한 사용자 친화적 응용 프로그램도 많이 있습니다.`,Z,$,V="이 가이드에서 소개할 내용은 아래와 같습니다:",r,I,Y='<li><a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MInDS-14</a> 데이터 세트에서 <a href="https://huggingface.co/facebook/wav2vec2-base" rel="nofollow">Wav2Vec2</a>를 미세 조정하여 오디오를 텍스트로 변환합니다.</li> <li>미세 조정한 모델을 추론에 사용합니다.</li>',x,W,i,f,Xs="시작하기 전에 필요한 모든 라이브러리가 설치되어 있는지 확인하세요:",Hs,N,Ys,A,Yl="Hugging Face 계정에 로그인하면 모델을 업로드하고 커뮤니티에 공유할 수 있습니다. 토큰을 입력하여 로그인하세요.",Ns,z,As,F,zs,q,Nl=`먼저, 🤗 Datasets 라이브러리에서 <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MInDS-14</a> 데이터 세트의 일부분을 가져오세요.
이렇게 하면 전체 데이터 세트에 대한 훈련에 시간을 들이기 전에 모든 것이 작동하는지 실험하고 검증할 수 있습니다.`,Fs,S,qs,D,Al="<code>~Dataset.train_test_split</code> 메소드를 사용하여 데이터 세트의 <code>train</code>을 훈련 세트와 테스트 세트로 나누세요:",Ss,L,Ds,P,zl="그리고 데이터 세트를 확인하세요:",Ls,O,Ps,K,Fl="데이터 세트에는 <code>lang_id</code>와 <code>english_transcription</code>과 같은 유용한 정보가 많이 포함되어 있지만, 이 가이드에서는 <code>audio</code>와 <code>transcription</code>에 초점을 맞출 것입니다. 다른 열은 <code>remove_columns</code> 메소드를 사용하여 제거하세요:",Os,ss,Ks,ls,ql="예시를 다시 한번 확인해보세요:",sl,ts,ll,as,Sl="두 개의 필드가 있습니다:",tl,es,Dl="<li><code>audio</code>: 오디오 파일을 가져오고 리샘플링하기 위해 호출해야 하는 음성 신호의 1차원 <code>array(배열)</code></li> <li><code>transcription</code>: 목표 텍스트</li>",al,ns,el,ps,Ll="다음으로 오디오 신호를 처리하기 위한 Wav2Vec2 프로세서를 가져옵니다:",nl,cs,pl,is,Pl='MInDS-14 데이터 세트의 샘플링 레이트는 8000kHz이므로(<a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">데이터 세트 카드</a>에서 확인), 사전 훈련된 Wav2Vec2 모델을 사용하려면 데이터 세트를 16000kHz로 리샘플링해야 합니다:',cl,rs,il,os,Ol="위의 ‘transcription’에서 볼 수 있듯이 텍스트는 대문자와 소문자가 섞여 있습니다. Wav2Vec2 토크나이저는 대문자 문자에 대해서만 훈련되어 있으므로 텍스트가 토크나이저의 어휘와 일치하는지 확인해야 합니다:",rl,ms,ol,Ms,Kl="이제 다음 작업을 수행할 전처리 함수를 만들어보겠습니다:",ml,js,st="<li><code>audio</code> 열을 호출하여 오디오 파일을 가져오고 리샘플링합니다.</li> <li>오디오 파일에서 <code>input_values</code>를 추출하고 프로세서로 <code>transcription</code> 열을 토큰화합니다.</li>",Ml,hs,jl,ds,lt="전체 데이터 세트에 전처리 함수를 적용하려면 🤗 Datasets <code>map</code> 함수를 사용하세요. <code>num_proc</code> 매개변수를 사용하여 프로세스 수를 늘리면 <code>map</code>의 속도를 높일 수 있습니다. <code>remove_columns</code> 메소드를 사용하여 필요하지 않은 열을 제거하세요:",hl,us,dl,Js,tt="🤗 Transformers에는 자동 음성 인식용 데이터 콜레이터가 없으므로 예제 배치를 생성하려면 <code>DataCollatorWithPadding</code>을 조정해야 합니다. 이렇게 하면 데이터 콜레이터는 텍스트와 레이블을 배치에서 가장 긴 요소의 길이에 동적으로 패딩하여 길이를 균일하게 합니다. <code>tokenizer</code> 함수에서 <code>padding=True</code>를 설정하여 텍스트를 패딩할 수 있지만, 동적 패딩이 더 효율적입니다.",ul,ys,at="다른 데이터 콜레이터와 달리 이 특정 데이터 콜레이터는 <code>input_values</code>와 <code>labels</code>에 대해 다른 패딩 방법을 적용해야 합니다.",Jl,gs,yl,Us,et="이제 <code>DataCollatorForCTCWithPadding</code>을 인스턴스화합니다:",gl,fs,Ul,Ts,fl,ws,nt=`훈련 중에 평가 지표를 포함하면 모델의 성능을 평가하는 데 도움이 되는 경우가 많습니다. 🤗 <a href="https://huggingface.co/docs/evaluate/index" rel="nofollow">Evaluate</a> 라이브러리를 사용하면 평가 방법을 빠르게 불러올 수 있습니다.
이 작업에서는 <a href="https://huggingface.co/spaces/evaluate-metric/wer" rel="nofollow">단어 오류율(Word Error Rate, WER)</a> 평가 지표를 가져옵니다.
(평가 지표를 불러오고 계산하는 방법은 🤗 Evaluate <a href="https://huggingface.co/docs/evaluate/a_quick_tour" rel="nofollow">둘러보기</a>를 참조하세요):`,Tl,bs,wl,$s,pt="그런 다음 예측값과 레이블을 <code>compute</code>에 전달하여 WER을 계산하는 함수를 만듭니다:",bl,Is,$l,Cs,ct="이제 <code>compute_metrics</code> 함수를 사용할 준비가 되었으며, 훈련을 설정할 때 이 함수로 되돌아올 것입니다.",Il,_s,Cl,X,_l,B,Rl,Rs,kl,ks,it="좋아요, 이제 모델을 미세 조정했으니 추론에 사용할 수 있습니다!",Ql,Qs,rt="추론에 사용할 오디오 파일을 가져오세요. 필요한 경우 오디오 파일의 샘플링 비율을 모델의 샘플링 레이트에 맞게 리샘플링하는 것을 잊지 마세요!",vl,vs,Zl,Zs,ot="추론을 위해 미세 조정된 모델을 시험해보는 가장 간단한 방법은 <code>pipeline()</code>을 사용하는 것입니다. 모델을 사용하여 자동 음성 인식을 위한 <code>pipeline</code>을 인스턴스화하고 오디오 파일을 전달하세요:",Wl,Ws,Vl,E,xl,Vs,mt="<code>pipeline</code>의 결과를 수동으로 재현할 수도 있습니다:",Gl,H,Xl,xs,Bl,Bs,El;return w=new Gs({props:{title:"자동 음성 인식",local:"automatic-speech-recognition",headingTag:"h1"}}),Q=new _t({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/asr.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/asr.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/asr.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/asr.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/asr.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/asr.ipynb"}]}}),R=new Ct({props:{id:"TksaY_FDgnk"}}),W=new Hl({props:{$$slots:{default:[kt]},$$scope:{ctx:_}}}),N=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwZXZhbHVhdGUlMjBqaXdlcg==",highlighted:"pip install transformers datasets evaluate jiwer",wrap:!1}}),z=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),F=new Gs({props:{title:"MInDS-14 데이터 세트 가져오기",local:"load-minds-14-dataset",headingTag:"h2"}}),S=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZtaW5kczE0JTIyJTJDJTIwbmFtZSUzRCUyMmVuLVVTJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTEwMCU1RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-US&quot;</span>, split=<span class="hljs-string">&quot;train[:100]&quot;</span>)`,wrap:!1}}),L=new T({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy50cmFpbl90ZXN0X3NwbGl0KHRlc3Rfc2l6ZSUzRDAuMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.train_test_split(test_size=<span class="hljs-number">0.2</span>)',wrap:!1}}),O=new T({props:{code:"bWluZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>minds
DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;transcription&#x27;</span>, <span class="hljs-string">&#x27;english_transcription&#x27;</span>, <span class="hljs-string">&#x27;intent_class&#x27;</span>, <span class="hljs-string">&#x27;lang_id&#x27;</span>],
        num_rows: <span class="hljs-number">16</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;transcription&#x27;</span>, <span class="hljs-string">&#x27;english_transcription&#x27;</span>, <span class="hljs-string">&#x27;intent_class&#x27;</span>, <span class="hljs-string">&#x27;lang_id&#x27;</span>],
        num_rows: <span class="hljs-number">4</span>
    })
})`,wrap:!1}}),ss=new T({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyglNUIlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJsYW5nX2lkJTIyJTVEKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.remove_columns([<span class="hljs-string">&quot;english_transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;lang_id&quot;</span>])',wrap:!1}}),ts=new T({props:{code:"bWluZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>minds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;audio&#x27;</span>: {<span class="hljs-string">&#x27;array&#x27;</span>: array([-<span class="hljs-number">0.00024414</span>,  <span class="hljs-number">0.</span>        ,  <span class="hljs-number">0.</span>        , ...,  <span class="hljs-number">0.00024414</span>,
          <span class="hljs-number">0.00024414</span>,  <span class="hljs-number">0.00024414</span>], dtype=float32),
  <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
  <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">8000</span>},
 <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
 <span class="hljs-string">&#x27;transcription&#x27;</span>: <span class="hljs-string">&quot;hi I&#x27;m trying to use the banking app on my phone and currently my checking and savings account balance is not refreshing&quot;</span>}`,wrap:!1}}),ns=new Gs({props:{title:"전처리",local:"preprocess",headingTag:"h2"}}),cs=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base&quot;</span>)`,wrap:!1}}),rs=new T({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5jYXN0X2NvbHVtbiglMjJhdWRpbyUyMiUyQyUyMEF1ZGlvKHNhbXBsaW5nX3JhdGUlM0QxNl8wMDApKSUwQW1pbmRzJTVCJTIydHJhaW4lMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>minds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;audio&#x27;</span>: {<span class="hljs-string">&#x27;array&#x27;</span>: array([-<span class="hljs-number">2.38064706e-04</span>, -<span class="hljs-number">1.58618059e-04</span>, -<span class="hljs-number">5.43987835e-06</span>, ...,
          <span class="hljs-number">2.78103951e-04</span>,  <span class="hljs-number">2.38446111e-04</span>,  <span class="hljs-number">1.18740834e-04</span>], dtype=float32),
  <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
  <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">16000</span>},
 <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
 <span class="hljs-string">&#x27;transcription&#x27;</span>: <span class="hljs-string">&quot;hi I&#x27;m trying to use the banking app on my phone and currently my checking and savings account balance is not refreshing&quot;</span>}`,wrap:!1}}),ms=new T({props:{code:"ZGVmJTIwdXBwZXJjYXNlKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMGV4YW1wbGUlNUIlMjJ0cmFuc2NyaXB0aW9uJTIyJTVELnVwcGVyKCklN0QlMEElMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLm1hcCh1cHBlcmNhc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">uppercase</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;transcription&quot;</span>: example[<span class="hljs-string">&quot;transcription&quot;</span>].upper()}


<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.<span class="hljs-built_in">map</span>(uppercase)`,wrap:!1}}),hs=new T({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwYmF0Y2glNUIlMjJhdWRpbyUyMiU1RCUwQSUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwcHJvY2Vzc29yKGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwdGV4dCUzRGJhdGNoJTVCJTIydHJhbnNjcmlwdGlvbiUyMiU1RCklMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmlucHV0X2xlbmd0aCUyMiU1RCUyMCUzRCUyMGxlbihiYXRjaCU1QiUyMmlucHV0X3ZhbHVlcyUyMiU1RCU1QjAlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2g=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    audio = batch[<span class="hljs-string">&quot;audio&quot;</span>]
<span class="hljs-meta">... </span>    batch = processor(audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], text=batch[<span class="hljs-string">&quot;transcription&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;input_length&quot;</span>] = <span class="hljs-built_in">len</span>(batch[<span class="hljs-string">&quot;input_values&quot;</span>][<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),us=new T({props:{code:"ZW5jb2RlZF9taW5kcyUyMCUzRCUyMG1pbmRzLm1hcChwcmVwYXJlX2RhdGFzZXQlMkMlMjByZW1vdmVfY29sdW1ucyUzRG1pbmRzLmNvbHVtbl9uYW1lcyU1QiUyMnRyYWluJTIyJTVEJTJDJTIwbnVtX3Byb2MlM0Q0KQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=minds.column_names[<span class="hljs-string">&quot;train&quot;</span>], num_proc=<span class="hljs-number">4</span>)',wrap:!1}}),gs=new T({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass, field
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Optional</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">DataCollatorCTCWithPadding</span>:
<span class="hljs-meta">... </span>    processor: AutoProcessor
<span class="hljs-meta">... </span>    padding: <span class="hljs-type">Union</span>[<span class="hljs-built_in">bool</span>, <span class="hljs-built_in">str</span>] = <span class="hljs-string">&quot;longest&quot;</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># 입력과 레이블을 분할합니다</span>
<span class="hljs-meta">... </span>        <span class="hljs-comment"># 길이가 다르고, 각각 다른 패딩 방법을 사용해야 하기 때문입니다</span>
<span class="hljs-meta">... </span>        input_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;input_values&quot;</span>][<span class="hljs-number">0</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        label_features = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

<span class="hljs-meta">... </span>        batch = self.processor.pad(input_features, padding=self.padding, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>        labels_batch = self.processor.pad(labels=label_features, padding=self.padding, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># 패딩에 대해 손실을 적용하지 않도록 -100으로 대체합니다</span>
<span class="hljs-meta">... </span>        labels = labels_batch[<span class="hljs-string">&quot;input_ids&quot;</span>].masked_fill(labels_batch.attention_mask.ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>)

<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),fs=new T({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckNUQ1dpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3NvciUyQyUyMHBhZGRpbmclM0QlMjJsb25nZXN0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DataCollatorCTCWithPadding(processor=processor, padding=<span class="hljs-string">&quot;longest&quot;</span>)',wrap:!1}}),Ts=new Gs({props:{title:"평가하기",local:"evaluate",headingTag:"h2"}}),bs=new T({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEF3ZXIlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMndlciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate

<span class="hljs-meta">&gt;&gt;&gt; </span>wer = evaluate.load(<span class="hljs-string">&quot;wer&quot;</span>)`,wrap:!1}}),Is=new T({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKHByZWQpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZF9sb2dpdHMlMjAlM0QlMjBwcmVkLnByZWRpY3Rpb25zJTBBJTIwJTIwJTIwJTIwcHJlZF9pZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZF9sb2dpdHMlMkMlMjBheGlzJTNELTEpJTBBJTBBJTIwJTIwJTIwJTIwcHJlZC5sYWJlbF9pZHMlNUJwcmVkLmxhYmVsX2lkcyUyMCUzRCUzRCUyMC0xMDAlNUQlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyLnBhZF90b2tlbl9pZCUwQSUwQSUyMCUyMCUyMCUyMHByZWRfc3RyJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShwcmVkX2lkcyklMEElMjAlMjAlMjAlMjBsYWJlbF9zdHIlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKHByZWQubGFiZWxfaWRzJTJDJTIwZ3JvdXBfdG9rZW5zJTNERmFsc2UpJTBBJTBBJTIwJTIwJTIwJTIwd2VyJTIwJTNEJTIwd2VyLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkX3N0ciUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbF9zdHIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyd2VyJTIyJTNBJTIwd2VyJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">pred</span>):
<span class="hljs-meta">... </span>    pred_logits = pred.predictions
<span class="hljs-meta">... </span>    pred_ids = np.argmax(pred_logits, axis=-<span class="hljs-number">1</span>)

<span class="hljs-meta">... </span>    pred.label_ids[pred.label_ids == -<span class="hljs-number">100</span>] = processor.tokenizer.pad_token_id

<span class="hljs-meta">... </span>    pred_str = processor.batch_decode(pred_ids)
<span class="hljs-meta">... </span>    label_str = processor.batch_decode(pred.label_ids, group_tokens=<span class="hljs-literal">False</span>)

<span class="hljs-meta">... </span>    wer = wer.compute(predictions=pred_str, references=label_str)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;wer&quot;</span>: wer}`,wrap:!1}}),_s=new Gs({props:{title:"훈련하기",local:"train",headingTag:"h2"}}),X=new gt({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[Zt]},$$scope:{ctx:_}}}),B=new Hl({props:{$$slots:{default:[Wt]},$$scope:{ctx:_}}}),Rs=new Gs({props:{title:"추론하기",local:"inference",headingTag:"h2"}}),vs=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMlBvbHlBSSUyRm1pbmRzMTQlMjIlMkMlMjAlMjJlbi1VUyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQWF1ZGlvX2ZpbGUlMjAlM0QlMjBkYXRhc2V0JTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIycGF0aCUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, <span class="hljs-string">&quot;en-US&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_file = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;path&quot;</span>]`,wrap:!1}}),Ws=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSglMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJzdGV2aGxpdSUyRm15X2F3ZXNvbWVfYXNyX21pbmRzX21vZGVsJTIyKSUwQXRyYW5zY3JpYmVyKGF1ZGlvX2ZpbGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;stevhliu/my_awesome_asr_minds_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(audio_file)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;I WOUD LIKE O SET UP JOINT ACOUNT WTH Y PARTNER&#x27;</span>}`,wrap:!1}}),E=new Hl({props:{$$slots:{default:[Vt]},$$scope:{ctx:_}}}),H=new gt({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[Gt]},$$scope:{ctx:_}}}),xs=new Rt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/tasks/asr.md"}}),{c(){e=o("meta"),g=n(),c=o("p"),U=n(),M(w.$$.fragment),C=n(),M(Q.$$.fragment),k=n(),M(R.$$.fragment),v=n(),b=o("p"),b.textContent=G,Z=n(),$=o("p"),$.textContent=V,r=n(),I=o("ol"),I.innerHTML=Y,x=n(),M(W.$$.fragment),i=n(),f=o("p"),f.textContent=Xs,Hs=n(),M(N.$$.fragment),Ys=n(),A=o("p"),A.textContent=Yl,Ns=n(),M(z.$$.fragment),As=n(),M(F.$$.fragment),zs=n(),q=o("p"),q.innerHTML=Nl,Fs=n(),M(S.$$.fragment),qs=n(),D=o("p"),D.innerHTML=Al,Ss=n(),M(L.$$.fragment),Ds=n(),P=o("p"),P.textContent=zl,Ls=n(),M(O.$$.fragment),Ps=n(),K=o("p"),K.innerHTML=Fl,Os=n(),M(ss.$$.fragment),Ks=n(),ls=o("p"),ls.textContent=ql,sl=n(),M(ts.$$.fragment),ll=n(),as=o("p"),as.textContent=Sl,tl=n(),es=o("ul"),es.innerHTML=Dl,al=n(),M(ns.$$.fragment),el=n(),ps=o("p"),ps.textContent=Ll,nl=n(),M(cs.$$.fragment),pl=n(),is=o("p"),is.innerHTML=Pl,cl=n(),M(rs.$$.fragment),il=n(),os=o("p"),os.textContent=Ol,rl=n(),M(ms.$$.fragment),ol=n(),Ms=o("p"),Ms.textContent=Kl,ml=n(),js=o("ol"),js.innerHTML=st,Ml=n(),M(hs.$$.fragment),jl=n(),ds=o("p"),ds.innerHTML=lt,hl=n(),M(us.$$.fragment),dl=n(),Js=o("p"),Js.innerHTML=tt,ul=n(),ys=o("p"),ys.innerHTML=at,Jl=n(),M(gs.$$.fragment),yl=n(),Us=o("p"),Us.innerHTML=et,gl=n(),M(fs.$$.fragment),Ul=n(),M(Ts.$$.fragment),fl=n(),ws=o("p"),ws.innerHTML=nt,Tl=n(),M(bs.$$.fragment),wl=n(),$s=o("p"),$s.innerHTML=pt,bl=n(),M(Is.$$.fragment),$l=n(),Cs=o("p"),Cs.innerHTML=ct,Il=n(),M(_s.$$.fragment),Cl=n(),M(X.$$.fragment),_l=n(),M(B.$$.fragment),Rl=n(),M(Rs.$$.fragment),kl=n(),ks=o("p"),ks.textContent=it,Ql=n(),Qs=o("p"),Qs.textContent=rt,vl=n(),M(vs.$$.fragment),Zl=n(),Zs=o("p"),Zs.innerHTML=ot,Wl=n(),M(Ws.$$.fragment),Vl=n(),M(E.$$.fragment),xl=n(),Vs=o("p"),Vs.innerHTML=mt,Gl=n(),M(H.$$.fragment),Xl=n(),M(xs.$$.fragment),Bl=n(),Bs=o("p"),this.h()},l(s){const l=$t("svelte-u9bgzb",document.head);e=m(l,"META",{name:!0,content:!0}),l.forEach(t),g=p(s),c=m(s,"P",{}),Jt(c).forEach(t),U=p(s),j(w.$$.fragment,s),C=p(s),j(Q.$$.fragment,s),k=p(s),j(R.$$.fragment,s),v=p(s),b=m(s,"P",{"data-svelte-h":!0}),y(b)!=="svelte-1qlvl3y"&&(b.textContent=G),Z=p(s),$=m(s,"P",{"data-svelte-h":!0}),y($)!=="svelte-7oxnvp"&&($.textContent=V),r=p(s),I=m(s,"OL",{"data-svelte-h":!0}),y(I)!=="svelte-1ok1jy5"&&(I.innerHTML=Y),x=p(s),j(W.$$.fragment,s),i=p(s),f=m(s,"P",{"data-svelte-h":!0}),y(f)!=="svelte-18iigii"&&(f.textContent=Xs),Hs=p(s),j(N.$$.fragment,s),Ys=p(s),A=m(s,"P",{"data-svelte-h":!0}),y(A)!=="svelte-2mor9q"&&(A.textContent=Yl),Ns=p(s),j(z.$$.fragment,s),As=p(s),j(F.$$.fragment,s),zs=p(s),q=m(s,"P",{"data-svelte-h":!0}),y(q)!=="svelte-7q7xwh"&&(q.innerHTML=Nl),Fs=p(s),j(S.$$.fragment,s),qs=p(s),D=m(s,"P",{"data-svelte-h":!0}),y(D)!=="svelte-3148pn"&&(D.innerHTML=Al),Ss=p(s),j(L.$$.fragment,s),Ds=p(s),P=m(s,"P",{"data-svelte-h":!0}),y(P)!=="svelte-17o70r1"&&(P.textContent=zl),Ls=p(s),j(O.$$.fragment,s),Ps=p(s),K=m(s,"P",{"data-svelte-h":!0}),y(K)!=="svelte-1dp2qnq"&&(K.innerHTML=Fl),Os=p(s),j(ss.$$.fragment,s),Ks=p(s),ls=m(s,"P",{"data-svelte-h":!0}),y(ls)!=="svelte-1p9pg2d"&&(ls.textContent=ql),sl=p(s),j(ts.$$.fragment,s),ll=p(s),as=m(s,"P",{"data-svelte-h":!0}),y(as)!=="svelte-6aiy91"&&(as.textContent=Sl),tl=p(s),es=m(s,"UL",{"data-svelte-h":!0}),y(es)!=="svelte-1l53gx0"&&(es.innerHTML=Dl),al=p(s),j(ns.$$.fragment,s),el=p(s),ps=m(s,"P",{"data-svelte-h":!0}),y(ps)!=="svelte-1fm7wkp"&&(ps.textContent=Ll),nl=p(s),j(cs.$$.fragment,s),pl=p(s),is=m(s,"P",{"data-svelte-h":!0}),y(is)!=="svelte-e2ss04"&&(is.innerHTML=Pl),cl=p(s),j(rs.$$.fragment,s),il=p(s),os=m(s,"P",{"data-svelte-h":!0}),y(os)!=="svelte-14tnwq5"&&(os.textContent=Ol),rl=p(s),j(ms.$$.fragment,s),ol=p(s),Ms=m(s,"P",{"data-svelte-h":!0}),y(Ms)!=="svelte-10u1mcw"&&(Ms.textContent=Kl),ml=p(s),js=m(s,"OL",{"data-svelte-h":!0}),y(js)!=="svelte-bj7uax"&&(js.innerHTML=st),Ml=p(s),j(hs.$$.fragment,s),jl=p(s),ds=m(s,"P",{"data-svelte-h":!0}),y(ds)!=="svelte-vxgjmg"&&(ds.innerHTML=lt),hl=p(s),j(us.$$.fragment,s),dl=p(s),Js=m(s,"P",{"data-svelte-h":!0}),y(Js)!=="svelte-7av315"&&(Js.innerHTML=tt),ul=p(s),ys=m(s,"P",{"data-svelte-h":!0}),y(ys)!=="svelte-pcjp4m"&&(ys.innerHTML=at),Jl=p(s),j(gs.$$.fragment,s),yl=p(s),Us=m(s,"P",{"data-svelte-h":!0}),y(Us)!=="svelte-o882aa"&&(Us.innerHTML=et),gl=p(s),j(fs.$$.fragment,s),Ul=p(s),j(Ts.$$.fragment,s),fl=p(s),ws=m(s,"P",{"data-svelte-h":!0}),y(ws)!=="svelte-1kx52w5"&&(ws.innerHTML=nt),Tl=p(s),j(bs.$$.fragment,s),wl=p(s),$s=m(s,"P",{"data-svelte-h":!0}),y($s)!=="svelte-i1fso8"&&($s.innerHTML=pt),bl=p(s),j(Is.$$.fragment,s),$l=p(s),Cs=m(s,"P",{"data-svelte-h":!0}),y(Cs)!=="svelte-15lq6yk"&&(Cs.innerHTML=ct),Il=p(s),j(_s.$$.fragment,s),Cl=p(s),j(X.$$.fragment,s),_l=p(s),j(B.$$.fragment,s),Rl=p(s),j(Rs.$$.fragment,s),kl=p(s),ks=m(s,"P",{"data-svelte-h":!0}),y(ks)!=="svelte-1annmqf"&&(ks.textContent=it),Ql=p(s),Qs=m(s,"P",{"data-svelte-h":!0}),y(Qs)!=="svelte-18ieb63"&&(Qs.textContent=rt),vl=p(s),j(vs.$$.fragment,s),Zl=p(s),Zs=m(s,"P",{"data-svelte-h":!0}),y(Zs)!=="svelte-12cj03s"&&(Zs.innerHTML=ot),Wl=p(s),j(Ws.$$.fragment,s),Vl=p(s),j(E.$$.fragment,s),xl=p(s),Vs=m(s,"P",{"data-svelte-h":!0}),y(Vs)!=="svelte-1olk0w9"&&(Vs.innerHTML=mt),Gl=p(s),j(H.$$.fragment,s),Xl=p(s),j(xs.$$.fragment,s),Bl=p(s),Bs=m(s,"P",{}),Jt(Bs).forEach(t),this.h()},h(){yt(e,"name","hf:doc:metadata"),yt(e,"content",Bt)},m(s,l){It(document.head,e),a(s,g,l),a(s,c,l),a(s,U,l),h(w,s,l),a(s,C,l),h(Q,s,l),a(s,k,l),h(R,s,l),a(s,v,l),a(s,b,l),a(s,Z,l),a(s,$,l),a(s,r,l),a(s,I,l),a(s,x,l),h(W,s,l),a(s,i,l),a(s,f,l),a(s,Hs,l),h(N,s,l),a(s,Ys,l),a(s,A,l),a(s,Ns,l),h(z,s,l),a(s,As,l),h(F,s,l),a(s,zs,l),a(s,q,l),a(s,Fs,l),h(S,s,l),a(s,qs,l),a(s,D,l),a(s,Ss,l),h(L,s,l),a(s,Ds,l),a(s,P,l),a(s,Ls,l),h(O,s,l),a(s,Ps,l),a(s,K,l),a(s,Os,l),h(ss,s,l),a(s,Ks,l),a(s,ls,l),a(s,sl,l),h(ts,s,l),a(s,ll,l),a(s,as,l),a(s,tl,l),a(s,es,l),a(s,al,l),h(ns,s,l),a(s,el,l),a(s,ps,l),a(s,nl,l),h(cs,s,l),a(s,pl,l),a(s,is,l),a(s,cl,l),h(rs,s,l),a(s,il,l),a(s,os,l),a(s,rl,l),h(ms,s,l),a(s,ol,l),a(s,Ms,l),a(s,ml,l),a(s,js,l),a(s,Ml,l),h(hs,s,l),a(s,jl,l),a(s,ds,l),a(s,hl,l),h(us,s,l),a(s,dl,l),a(s,Js,l),a(s,ul,l),a(s,ys,l),a(s,Jl,l),h(gs,s,l),a(s,yl,l),a(s,Us,l),a(s,gl,l),h(fs,s,l),a(s,Ul,l),h(Ts,s,l),a(s,fl,l),a(s,ws,l),a(s,Tl,l),h(bs,s,l),a(s,wl,l),a(s,$s,l),a(s,bl,l),h(Is,s,l),a(s,$l,l),a(s,Cs,l),a(s,Il,l),h(_s,s,l),a(s,Cl,l),h(X,s,l),a(s,_l,l),h(B,s,l),a(s,Rl,l),h(Rs,s,l),a(s,kl,l),a(s,ks,l),a(s,Ql,l),a(s,Qs,l),a(s,vl,l),h(vs,s,l),a(s,Zl,l),a(s,Zs,l),a(s,Wl,l),h(Ws,s,l),a(s,Vl,l),h(E,s,l),a(s,xl,l),a(s,Vs,l),a(s,Gl,l),h(H,s,l),a(s,Xl,l),h(xs,s,l),a(s,Bl,l),a(s,Bs,l),El=!0},p(s,[l]){const Mt={};l&2&&(Mt.$$scope={dirty:l,ctx:s}),W.$set(Mt);const jt={};l&2&&(jt.$$scope={dirty:l,ctx:s}),X.$set(jt);const ht={};l&2&&(ht.$$scope={dirty:l,ctx:s}),B.$set(ht);const dt={};l&2&&(dt.$$scope={dirty:l,ctx:s}),E.$set(dt);const ut={};l&2&&(ut.$$scope={dirty:l,ctx:s}),H.$set(ut)},i(s){El||(d(w.$$.fragment,s),d(Q.$$.fragment,s),d(R.$$.fragment,s),d(W.$$.fragment,s),d(N.$$.fragment,s),d(z.$$.fragment,s),d(F.$$.fragment,s),d(S.$$.fragment,s),d(L.$$.fragment,s),d(O.$$.fragment,s),d(ss.$$.fragment,s),d(ts.$$.fragment,s),d(ns.$$.fragment,s),d(cs.$$.fragment,s),d(rs.$$.fragment,s),d(ms.$$.fragment,s),d(hs.$$.fragment,s),d(us.$$.fragment,s),d(gs.$$.fragment,s),d(fs.$$.fragment,s),d(Ts.$$.fragment,s),d(bs.$$.fragment,s),d(Is.$$.fragment,s),d(_s.$$.fragment,s),d(X.$$.fragment,s),d(B.$$.fragment,s),d(Rs.$$.fragment,s),d(vs.$$.fragment,s),d(Ws.$$.fragment,s),d(E.$$.fragment,s),d(H.$$.fragment,s),d(xs.$$.fragment,s),El=!0)},o(s){u(w.$$.fragment,s),u(Q.$$.fragment,s),u(R.$$.fragment,s),u(W.$$.fragment,s),u(N.$$.fragment,s),u(z.$$.fragment,s),u(F.$$.fragment,s),u(S.$$.fragment,s),u(L.$$.fragment,s),u(O.$$.fragment,s),u(ss.$$.fragment,s),u(ts.$$.fragment,s),u(ns.$$.fragment,s),u(cs.$$.fragment,s),u(rs.$$.fragment,s),u(ms.$$.fragment,s),u(hs.$$.fragment,s),u(us.$$.fragment,s),u(gs.$$.fragment,s),u(fs.$$.fragment,s),u(Ts.$$.fragment,s),u(bs.$$.fragment,s),u(Is.$$.fragment,s),u(_s.$$.fragment,s),u(X.$$.fragment,s),u(B.$$.fragment,s),u(Rs.$$.fragment,s),u(vs.$$.fragment,s),u(Ws.$$.fragment,s),u(E.$$.fragment,s),u(H.$$.fragment,s),u(xs.$$.fragment,s),El=!1},d(s){s&&(t(g),t(c),t(U),t(C),t(k),t(v),t(b),t(Z),t($),t(r),t(I),t(x),t(i),t(f),t(Hs),t(Ys),t(A),t(Ns),t(As),t(zs),t(q),t(Fs),t(qs),t(D),t(Ss),t(Ds),t(P),t(Ls),t(Ps),t(K),t(Os),t(Ks),t(ls),t(sl),t(ll),t(as),t(tl),t(es),t(al),t(el),t(ps),t(nl),t(pl),t(is),t(cl),t(il),t(os),t(rl),t(ol),t(Ms),t(ml),t(js),t(Ml),t(jl),t(ds),t(hl),t(dl),t(Js),t(ul),t(ys),t(Jl),t(yl),t(Us),t(gl),t(Ul),t(fl),t(ws),t(Tl),t(wl),t($s),t(bl),t($l),t(Cs),t(Il),t(Cl),t(_l),t(Rl),t(kl),t(ks),t(Ql),t(Qs),t(vl),t(Zl),t(Zs),t(Wl),t(Vl),t(xl),t(Vs),t(Gl),t(Xl),t(Bl),t(Bs)),t(e),J(w,s),J(Q,s),J(R,s),J(W,s),J(N,s),J(z,s),J(F,s),J(S,s),J(L,s),J(O,s),J(ss,s),J(ts,s),J(ns,s),J(cs,s),J(rs,s),J(ms,s),J(hs,s),J(us,s),J(gs,s),J(fs,s),J(Ts,s),J(bs,s),J(Is,s),J(_s,s),J(X,s),J(B,s),J(Rs,s),J(vs,s),J(Ws,s),J(E,s),J(H,s),J(xs,s)}}}const Bt='{"title":"자동 음성 인식","local":"automatic-speech-recognition","sections":[{"title":"MInDS-14 데이터 세트 가져오기","local":"load-minds-14-dataset","sections":[],"depth":2},{"title":"전처리","local":"preprocess","sections":[],"depth":2},{"title":"평가하기","local":"evaluate","sections":[],"depth":2},{"title":"훈련하기","local":"train","sections":[],"depth":2},{"title":"추론하기","local":"inference","sections":[],"depth":2}],"depth":1}';function Et(_){return Tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends wt{constructor(e){super(),bt(this,e,Et,Xt,ft,{})}}export{Dt as component};
