import{s as As,n as Gs,o as Ns}from"../chunks/scheduler.9bc65507.js";import{S as Rs,i as Ss,g as p,s as l,r as M,A as Fs,h as r,f as e,c as n,j as Qs,u as m,x as i,k as ks,y as xs,a as t,v as y,d as c,t as J,w as o}from"../chunks/index.707bf1b6.js";import{H as ds,g as zs}from"../chunks/Heading.0c39134e.js";import{C as h}from"../chunks/CodeBlock.54a9f38d.js";function Es(fs){let T,x,S,z,j,E,U,Cs='🤗 Transformersは、🤗 Transformersモデルのトレーニングを最適化する<a href="/docs/transformers/v4.35.1/ja/main_classes/trainer#transformers.Trainer">Trainer</a>クラスを提供し、独自のトレーニングループを手動で記述せずにトレーニングを開始するのが簡単になります。<a href="/docs/transformers/v4.35.1/ja/main_classes/trainer#transformers.Trainer">Trainer</a>はハイパーパラメーター検索のAPIも提供しています。このドキュメントでは、それを例示します。',D,w,L,u,bs=`<a href="/docs/transformers/v4.35.1/ja/main_classes/trainer#transformers.Trainer">Trainer</a>は現在、4つのハイパーパラメーター検索バックエンドをサポートしています：
<a href="https://optuna.org/" rel="nofollow">optuna</a>、<a href="https://sigopt.com/" rel="nofollow">sigopt</a>、<a href="https://docs.ray.io/en/latest/tune/index.html" rel="nofollow">raytune</a>、および<a href="https://wandb.ai/site/sweeps" rel="nofollow">wandb</a>。`,P,I,gs="これらを使用する前に、ハイパーパラメーター検索バックエンドをインストールする必要があります。",K,d,O,f,ss,C,_s="ハイパーパラメータの検索スペースを定義し、異なるバックエンドには異なるフォーマットが必要です。",as,b,$s='Sigoptの場合、sigopt <a href="https://docs.sigopt.com/ai-module-api-references/api_reference/objects/object_parameter" rel="nofollow">object_parameter</a> を参照してください。それは以下のようなものです：',es,g,ts,_,qs='Optunaに関しては、<a href="https://optuna.readthedocs.io/en/stable/tutorial/10_key_features/002_configurations.html#sphx-glr-tutorial-10-key-features-002-configurations-py" rel="nofollow">object_parameter</a>をご覧ください。以下のようになります：',ls,$,ns,q,Xs='Optunaは、多目的のハイパーパラメータ最適化（HPO）を提供しています。 <code>hyperparameter_search</code> で <code>direction</code> を渡し、複数の目的関数値を返すための独自の <code>compute_objective</code> を定義することができます。 Pareto Front（<code>List[BestRun]</code>）は <code>hyperparameter_search</code> で返され、<a href="https://github.com/huggingface/transformers/blob/main/tests/trainer/test_trainer.py" rel="nofollow">test_trainer</a> のテストケース <code>TrainerHyperParameterMultiObjectOptunaIntegrationTest</code> を参照する必要があります。これは以下のようになります。',ps,X,rs,W,Ws='Ray Tuneに関して、<a href="https://docs.ray.io/en/latest/tune/api/search_space.html" rel="nofollow">object_parameter</a>を参照してください。以下のようになります：',is,v,Ms,B,vs='Wandbについては、<a href="https://docs.wandb.ai/guides/sweeps/configuration" rel="nofollow">object_parameter</a>をご覧ください。これは以下のようになります：',ms,Z,ys,Y,Bs='<code>model_init</code> 関数を定義し、それを <a href="/docs/transformers/v4.35.1/ja/main_classes/trainer#transformers.Trainer">Trainer</a> に渡す例を示します：',cs,V,Js,H,Zs='<a href="/docs/transformers/v4.35.1/ja/main_classes/trainer#transformers.Trainer">Trainer</a> を <code>model_init</code> 関数、トレーニング引数、トレーニングデータセット、テストデータセット、および評価関数と共に作成してください:',os,Q,Ts,k,Ys="ハイパーパラメーターの探索を呼び出し、最良のトライアル パラメーターを取得します。バックエンドは <code>&quot;optuna&quot;</code> / <code>&quot;sigopt&quot;</code> / <code>&quot;wandb&quot;</code> / <code>&quot;ray&quot;</code> である可能性があります。方向は <code>&quot;minimize&quot;</code> または <code>&quot;maximize&quot;</code> であり、目標をより大きくするか小さくするかを示します。",hs,A,Vs="<code>compute_objective</code> 関数を独自に定義することもできます。定義されていない場合、デフォルトの <code>compute_objective</code> が呼び出され、F1などの評価メトリックの合計が目標値として返されます。",js,G,Us,N,ws,R,Hs="現在、DDP（Distributed Data Parallel）のためのハイパーパラメーター検索は、Optuna と SigOpt に対して有効になっています。ランクゼロプロセスのみが検索トライアルを生成し、他のランクに引数を渡します。",us,F,Is;return j=new ds({props:{title:"Hyperparameter Search using Trainer API",local:"hyperparameter-search-using-trainer-api",headingTag:"h1"}}),w=new ds({props:{title:"Hyperparameter Search backend",local:"hyperparameter-search-backend",headingTag:"h2"}}),d=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdHVuYSUyRnNpZ29wdCUyRndhbmRiJTJGcmF5JTVCdHVuZSU1RCUyMA==",highlighted:"pip install optuna/sigopt/wandb/ray[tune] ",wrap:!1}}),f=new ds({props:{title:"How to enable Hyperparameter search in example",local:"how-to-enable-hyperparameter-search-in-example",headingTag:"h2"}}),g=new h({props:{code:"ZGVmJTIwc2lnb3B0X2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMmJvdW5kcyUyMiUzQSUyMCU3QiUyMm1pbiUyMiUzQSUyMDFlLTYlMkMlMjAlMjJtYXglMjIlM0ElMjAxZS00JTdEJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlMkMlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZG91YmxlJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY2F0ZWdvcmljYWxfdmFsdWVzJTIyJTNBJTIwJTVCJTIyMTYlMjIlMkMlMjAlMjIzMiUyMiUyQyUyMCUyMjY0JTIyJTJDJTIwJTIyMTI4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybmFtZSUyMiUzQSUyMCUyMnBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJjYXRlZ29yaWNhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sigopt_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> [
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;bounds&quot;</span>: {<span class="hljs-string">&quot;min&quot;</span>: <span class="hljs-number">1e-6</span>, <span class="hljs-string">&quot;max&quot;</span>: <span class="hljs-number">1e-4</span>}, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;learning_rate&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;double&quot;</span>},
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;categorical_values&quot;</span>: [<span class="hljs-string">&quot;16&quot;</span>, <span class="hljs-string">&quot;32&quot;</span>, <span class="hljs-string">&quot;64&quot;</span>, <span class="hljs-string">&quot;128&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;categorical&quot;</span>,
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ]`,wrap:!1}}),$=new h({props:{code:"ZGVmJTIwb3B0dW5hX2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjB0cmlhbC5zdWdnZXN0X2Zsb2F0KCUyMmxlYXJuaW5nX3JhdGUlMjIlMkMlMjAxZS02JTJDJTIwMWUtNCUyQyUyMGxvZyUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwdHJpYWwuc3VnZ2VzdF9jYXRlZ29yaWNhbCglMjJwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjIlMkMlMjAlNUIxNiUyQyUyMDMyJTJDJTIwNjQlMkMlMjAxMjglNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">optuna_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;learning_rate&quot;</span>: trial.suggest_float(<span class="hljs-string">&quot;learning_rate&quot;</span>, <span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-4</span>, log=<span class="hljs-literal">True</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: trial.suggest_categorical(<span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>, [<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]),
<span class="hljs-meta">... </span>    }`,wrap:!1}}),X=new h({props:{code:"YmVzdF90cmlhbHMlMjAlM0QlMjB0cmFpbmVyLmh5cGVycGFyYW1ldGVyX3NlYXJjaCglMEElMjAlMjAlMjAlMjBkaXJlY3Rpb24lM0QlNUIlMjJtaW5pbWl6ZSUyMiUyQyUyMCUyMm1heGltaXplJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwYmFja2VuZCUzRCUyMm9wdHVuYSUyMiUyQyUwQSUyMCUyMCUyMCUyMGhwX3NwYWNlJTNEb3B0dW5hX2hwX3NwYWNlJTJDJTBBJTIwJTIwJTIwJTIwbl90cmlhbHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfb2JqZWN0aXZlJTNEY29tcHV0ZV9vYmplY3RpdmUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>best_trials = trainer.hyperparameter_search(
<span class="hljs-meta">... </span>    direction=[<span class="hljs-string">&quot;minimize&quot;</span>, <span class="hljs-string">&quot;maximize&quot;</span>],
<span class="hljs-meta">... </span>    backend=<span class="hljs-string">&quot;optuna&quot;</span>,
<span class="hljs-meta">... </span>    hp_space=optuna_hp_space,
<span class="hljs-meta">... </span>    n_trials=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    compute_objective=compute_objective,
<span class="hljs-meta">... </span>)`,wrap:!1}}),v=new h({props:{code:"ZGVmJTIwcmF5X2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjB0dW5lLmxvZ3VuaWZvcm0oMWUtNiUyQyUyMDFlLTQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwdHVuZS5jaG9pY2UoJTVCMTYlMkMlMjAzMiUyQyUyMDY0JTJDJTIwMTI4JTVEKSUyQyUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">ray_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;learning_rate&quot;</span>: tune.loguniform(<span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: tune.choice([<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]),
<span class="hljs-meta">... </span>    }`,wrap:!1}}),Z=new h({props:{code:"ZGVmJTIwd2FuZGJfaHBfc3BhY2UodHJpYWwpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0aG9kJTIyJTNBJTIwJTIycmFuZG9tJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljJTIyJTNBJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMm9iamVjdGl2ZSUyMiUyQyUyMCUyMmdvYWwlMjIlM0ElMjAlMjJtaW5pbWl6ZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWFybmluZ19yYXRlJTIyJTNBJTIwJTdCJTIyZGlzdHJpYnV0aW9uJTIyJTNBJTIwJTIydW5pZm9ybSUyMiUyQyUyMCUyMm1pbiUyMiUzQSUyMDFlLTYlMkMlMjAlMjJtYXglMjIlM0ElMjAxZS00JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwJTdCJTIydmFsdWVzJTIyJTNBJTIwJTVCMTYlMkMlMjAzMiUyQyUyMDY0JTJDJTIwMTI4JTVEJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">wandb_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;method&quot;</span>: <span class="hljs-string">&quot;random&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;metric&quot;</span>: {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;objective&quot;</span>, <span class="hljs-string">&quot;goal&quot;</span>: <span class="hljs-string">&quot;minimize&quot;</span>},
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;learning_rate&quot;</span>: {<span class="hljs-string">&quot;distribution&quot;</span>: <span class="hljs-string">&quot;uniform&quot;</span>, <span class="hljs-string">&quot;min&quot;</span>: <span class="hljs-number">1e-6</span>, <span class="hljs-string">&quot;max&quot;</span>: <span class="hljs-number">1e-4</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: {<span class="hljs-string">&quot;values&quot;</span>: [<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    }`,wrap:!1}}),V=new h({props:{code:"ZGVmJTIwbW9kZWxfaW5pdCh0cmlhbCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9hcmdzLm1vZGVsX25hbWVfb3JfcGF0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZyb21fdGYlM0Rib29sKCUyMi5ja3B0JTIyJTIwaW4lMjBtb2RlbF9hcmdzLm1vZGVsX25hbWVfb3JfcGF0aCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWclM0Rjb25maWclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYWNoZV9kaXIlM0Rtb2RlbF9hcmdzLmNhY2hlX2RpciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldmlzaW9uJTNEbW9kZWxfYXJncy5tb2RlbF9yZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSUyMGlmJTIwbW9kZWxfYXJncy51c2VfYXV0aF90b2tlbiUyMGVsc2UlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">model_init</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> AutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>        model_args.model_name_or_path,
<span class="hljs-meta">... </span>        from_tf=<span class="hljs-built_in">bool</span>(<span class="hljs-string">&quot;.ckpt&quot;</span> <span class="hljs-keyword">in</span> model_args.model_name_or_path),
<span class="hljs-meta">... </span>        config=config,
<span class="hljs-meta">... </span>        cache_dir=model_args.cache_dir,
<span class="hljs-meta">... </span>        revision=model_args.model_revision,
<span class="hljs-meta">... </span>        use_auth_token=<span class="hljs-literal">True</span> <span class="hljs-keyword">if</span> model_args.use_auth_token <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>    )`,wrap:!1}}),Q=new h({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEc21hbGxfdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHNtYWxsX2V2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2luaXQlM0Rtb2RlbF9pbml0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=<span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=small_train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=small_eval_dataset,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>    tokenizer=tokenizer,
<span class="hljs-meta">... </span>    model_init=model_init,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>)`,wrap:!1}}),G=new h({props:{code:"YmVzdF90cmlhbCUyMCUzRCUyMHRyYWluZXIuaHlwZXJwYXJhbWV0ZXJfc2VhcmNoKCUwQSUyMCUyMCUyMCUyMGRpcmVjdGlvbiUzRCUyMm1heGltaXplJTIyJTJDJTBBJTIwJTIwJTIwJTIwYmFja2VuZCUzRCUyMm9wdHVuYSUyMiUyQyUwQSUyMCUyMCUyMCUyMGhwX3NwYWNlJTNEb3B0dW5hX2hwX3NwYWNlJTJDJTBBJTIwJTIwJTIwJTIwbl90cmlhbHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfb2JqZWN0aXZlJTNEY29tcHV0ZV9vYmplY3RpdmUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>best_trial = trainer.hyperparameter_search(
<span class="hljs-meta">... </span>    direction=<span class="hljs-string">&quot;maximize&quot;</span>,
<span class="hljs-meta">... </span>    backend=<span class="hljs-string">&quot;optuna&quot;</span>,
<span class="hljs-meta">... </span>    hp_space=optuna_hp_space,
<span class="hljs-meta">... </span>    n_trials=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    compute_objective=compute_objective,
<span class="hljs-meta">... </span>)`,wrap:!1}}),N=new ds({props:{title:"Hyperparameter search For DDP finetune",local:"hyperparameter-search-for-ddp-finetune",headingTag:"h2"}}),{c(){T=p("meta"),x=l(),S=p("p"),z=l(),M(j.$$.fragment),E=l(),U=p("p"),U.innerHTML=Cs,D=l(),M(w.$$.fragment),L=l(),u=p("p"),u.innerHTML=bs,P=l(),I=p("p"),I.textContent=gs,K=l(),M(d.$$.fragment),O=l(),M(f.$$.fragment),ss=l(),C=p("p"),C.textContent=_s,as=l(),b=p("p"),b.innerHTML=$s,es=l(),M(g.$$.fragment),ts=l(),_=p("p"),_.innerHTML=qs,ls=l(),M($.$$.fragment),ns=l(),q=p("p"),q.innerHTML=Xs,ps=l(),M(X.$$.fragment),rs=l(),W=p("p"),W.innerHTML=Ws,is=l(),M(v.$$.fragment),Ms=l(),B=p("p"),B.innerHTML=vs,ms=l(),M(Z.$$.fragment),ys=l(),Y=p("p"),Y.innerHTML=Bs,cs=l(),M(V.$$.fragment),Js=l(),H=p("p"),H.innerHTML=Zs,os=l(),M(Q.$$.fragment),Ts=l(),k=p("p"),k.innerHTML=Ys,hs=l(),A=p("p"),A.innerHTML=Vs,js=l(),M(G.$$.fragment),Us=l(),M(N.$$.fragment),ws=l(),R=p("p"),R.textContent=Hs,us=l(),F=p("p"),this.h()},l(s){const a=Fs("svelte-u9bgzb",document.head);T=r(a,"META",{name:!0,content:!0}),a.forEach(e),x=n(s),S=r(s,"P",{}),Qs(S).forEach(e),z=n(s),m(j.$$.fragment,s),E=n(s),U=r(s,"P",{"data-svelte-h":!0}),i(U)!=="svelte-wtfif4"&&(U.innerHTML=Cs),D=n(s),m(w.$$.fragment,s),L=n(s),u=r(s,"P",{"data-svelte-h":!0}),i(u)!=="svelte-1n79cu7"&&(u.innerHTML=bs),P=n(s),I=r(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1rdjjrk"&&(I.textContent=gs),K=n(s),m(d.$$.fragment,s),O=n(s),m(f.$$.fragment,s),ss=n(s),C=r(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1r6943w"&&(C.textContent=_s),as=n(s),b=r(s,"P",{"data-svelte-h":!0}),i(b)!=="svelte-gv3yto"&&(b.innerHTML=$s),es=n(s),m(g.$$.fragment,s),ts=n(s),_=r(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1aualad"&&(_.innerHTML=qs),ls=n(s),m($.$$.fragment,s),ns=n(s),q=r(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-pz664g"&&(q.innerHTML=Xs),ps=n(s),m(X.$$.fragment,s),rs=n(s),W=r(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1jqrfse"&&(W.innerHTML=Ws),is=n(s),m(v.$$.fragment,s),Ms=n(s),B=r(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-ewosm3"&&(B.innerHTML=vs),ms=n(s),m(Z.$$.fragment,s),ys=n(s),Y=r(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-dl7vw5"&&(Y.innerHTML=Bs),cs=n(s),m(V.$$.fragment,s),Js=n(s),H=r(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-4s69hh"&&(H.innerHTML=Zs),os=n(s),m(Q.$$.fragment,s),Ts=n(s),k=r(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-wgkw6g"&&(k.innerHTML=Ys),hs=n(s),A=r(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1dpfob5"&&(A.innerHTML=Vs),js=n(s),m(G.$$.fragment,s),Us=n(s),m(N.$$.fragment,s),ws=n(s),R=r(s,"P",{"data-svelte-h":!0}),i(R)!=="svelte-thou6i"&&(R.textContent=Hs),us=n(s),F=r(s,"P",{}),Qs(F).forEach(e),this.h()},h(){ks(T,"name","hf:doc:metadata"),ks(T,"content",Ds)},m(s,a){xs(document.head,T),t(s,x,a),t(s,S,a),t(s,z,a),y(j,s,a),t(s,E,a),t(s,U,a),t(s,D,a),y(w,s,a),t(s,L,a),t(s,u,a),t(s,P,a),t(s,I,a),t(s,K,a),y(d,s,a),t(s,O,a),y(f,s,a),t(s,ss,a),t(s,C,a),t(s,as,a),t(s,b,a),t(s,es,a),y(g,s,a),t(s,ts,a),t(s,_,a),t(s,ls,a),y($,s,a),t(s,ns,a),t(s,q,a),t(s,ps,a),y(X,s,a),t(s,rs,a),t(s,W,a),t(s,is,a),y(v,s,a),t(s,Ms,a),t(s,B,a),t(s,ms,a),y(Z,s,a),t(s,ys,a),t(s,Y,a),t(s,cs,a),y(V,s,a),t(s,Js,a),t(s,H,a),t(s,os,a),y(Q,s,a),t(s,Ts,a),t(s,k,a),t(s,hs,a),t(s,A,a),t(s,js,a),y(G,s,a),t(s,Us,a),y(N,s,a),t(s,ws,a),t(s,R,a),t(s,us,a),t(s,F,a),Is=!0},p:Gs,i(s){Is||(c(j.$$.fragment,s),c(w.$$.fragment,s),c(d.$$.fragment,s),c(f.$$.fragment,s),c(g.$$.fragment,s),c($.$$.fragment,s),c(X.$$.fragment,s),c(v.$$.fragment,s),c(Z.$$.fragment,s),c(V.$$.fragment,s),c(Q.$$.fragment,s),c(G.$$.fragment,s),c(N.$$.fragment,s),Is=!0)},o(s){J(j.$$.fragment,s),J(w.$$.fragment,s),J(d.$$.fragment,s),J(f.$$.fragment,s),J(g.$$.fragment,s),J($.$$.fragment,s),J(X.$$.fragment,s),J(v.$$.fragment,s),J(Z.$$.fragment,s),J(V.$$.fragment,s),J(Q.$$.fragment,s),J(G.$$.fragment,s),J(N.$$.fragment,s),Is=!1},d(s){s&&(e(x),e(S),e(z),e(E),e(U),e(D),e(L),e(u),e(P),e(I),e(K),e(O),e(ss),e(C),e(as),e(b),e(es),e(ts),e(_),e(ls),e(ns),e(q),e(ps),e(rs),e(W),e(is),e(Ms),e(B),e(ms),e(ys),e(Y),e(cs),e(Js),e(H),e(os),e(Ts),e(k),e(hs),e(A),e(js),e(Us),e(ws),e(R),e(us),e(F)),e(T),o(j,s),o(w,s),o(d,s),o(f,s),o(g,s),o($,s),o(X,s),o(v,s),o(Z,s),o(V,s),o(Q,s),o(G,s),o(N,s)}}}const Ds='{"title":"Hyperparameter Search using Trainer API","local":"hyperparameter-search-using-trainer-api","sections":[{"title":"Hyperparameter Search backend","local":"hyperparameter-search-backend","sections":[],"depth":2},{"title":"How to enable Hyperparameter search in example","local":"how-to-enable-hyperparameter-search-in-example","sections":[],"depth":2},{"title":"Hyperparameter search For DDP finetune","local":"hyperparameter-search-for-ddp-finetune","sections":[],"depth":2}],"depth":1}';function Ls(fs){return Ns(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=zs}),[]}class aa extends Rs{constructor(T){super(),Ss(this,T,Ls,Es,As,{})}}export{aa as component};
