import{s as Ia,f as $A,n as ba,o as Wa}from"../chunks/scheduler.048ce5c2.js";import{S as Za,i as Ha,g as n,s as l,r as p,A as Va,h as c,f as e,c as s,j as xa,u as j,x as B,k as RA,y as ha,a,v as i,d as M,t as y,w as g}from"../chunks/index.2633050f.js";import{C as o}from"../chunks/CodeBlock.b34ffc90.js";import{D as Ta}from"../chunks/DocNotebookDropdown.2a84b269.js";import{H as u,E as Oa}from"../chunks/EditOnGithub.336973dd.js";function Ua(Oe){let r,_A,LA,At,m,tt,J,et,G,Ue="In this notebook, we’re going to take a brief look at generating audio with diffusion models.",at,k,lt,d,ze="<li>How audio is represented in a computer</li> <li>Methods to convert between raw audio data and spectrograms</li> <li>How to prepare a dataloader with a custom collate function to convert audio slices into spectrograms</li> <li>Fine-tuning an existing audio diffusion model on a specific genre of music</li> <li>Uploading your custom pipeline to the Hugging Face hub</li>",st,w,fe="Caveat: This is mostly for educational purposes - no guarantees our model will sound good 😉.",nt,x,Se="Let’s get started!",ct,I,pt,b,jt,W,it,Z,Mt,H,Ce='Let’s begin by following the <a href="https://huggingface.co/docs/diffusers/api/pipelines/audio_diffusion" rel="nofollow">Audio Diffusion docs</a> to load a pre-existing audio diffusion model pipeline:',yt,V,gt,h,De="As with the pipelines we’ve used in previous units, we can create samples by calling the pipeline like so:",Bt,T,ot,KA,Qe,rt,O,Pe="Here, the <code>rate</code> argument specifies the <em>sampling rate</em> for the audio; we’ll take a deeper look at this later. You’ll also notice there are multiple things returned by the pipeline. What’s going on here? Let’s take a closer look at both outputs.",ut,U,Ye="The first is an array of data, representing the generated audio:",mt,z,Jt,f,qe="The second looks like a greyscale image:",Gt,S,kt,C,Re='This gives us a hint at how this pipeline works. The audio is not directly generated with diffusion - instead, the pipeline has the same kind of 2D UNet as the unconditional image generation pipelines we saw in <a href="https://github.com/huggingface/diffusion-models-class/tree/main/unit1" rel="nofollow">Unit 1</a> that is used to generate the spectrogram, which is then post-processed into the final audio.',dt,D,Ke="The pipe has an extra component that handles these conversions, which we can access via <code>pipe.mel</code>:",wt,Q,xt,P,It,Y,Ne="An audio ‘waveform’ encodes the raw audio samples over time - this could be the electrical signal received from a microphone, for example. Working with this ‘Time Domain’ representation can be tricky, so it is a common practice to convert it into some other form, commonly something called a spectrogram. A spectrogram shows the intensity of different frequencies (y axis) vs time (x axis):",bt,q,Wt,R,Fe=`tensor(0.) tensor(6.0842)
`,Zt,K,Xe="The spectrogram we just made has values between 0.0000000000001 and 1, with most being close to the low end of that range. This is not ideal for visualization or modelling - in fact we had to take the log of these values to get a greyscale plot that showed any detail. For this reason, we typically use a special kind of spectrogram called a Mel spectrogram, which is designed to capture the kinds of information which are important for human hearing by applying some transforms to the different frequency components of the signal.",Ht,N,Ee='<img src="https://download.pytorch.org/torchaudio/tutorial-assets/torchaudio_feature_extractions.png" alt="torchaudio docs diagram"/> <em>Some audio transforms from the <a href="https://pytorch.org/audio/stable/transforms.html" rel="nofollow">torchaudio docs</a></em>',Vt,F,Le="Luckily for us, we don’t even need to worry too much about these transforms - the pipeline’s <code>mel</code> functionality handles these details for us. Using this, we can convert a spectrogram image to audio like so:",ht,X,Tt,E,ve="And we can convert an array of audio data into a spectrogram images by first loading the raw audio data and then calling the <code>audio_slice_to_image()</code> function. Longer clips are automatically sliced into chunks of the correct length to produce a 256x256 spectrogram image:",Ot,L,Ut,NA,$e,zt,v,_e="The audio is represented as a long array of numbers. To play this out loud we need one more key piece of information: the sample rate. How many samples (individual values) do we use to represent a single second of audio?",ft,$,Aa="We can see the sample rate used during training of this pipeline with:",St,_,Ct,AA,ta="If we specify the sample rate incorrectly, we get audio that is sped up or slowed down:",Dt,tA,Qt,eA,Pt,aA,ea="Now that we have a rough understanding of how the pipeline works, let’s fine-tune it on some new audio data!",Yt,lA,aa="The dataset is a collection of audio clips in different genres, which we can load from the hub like so:",qt,sA,Rt,nA,la="You can use the code below to see the different genres in the dataset and how many samples are contained in each:",Kt,cA,Nt,pA,sa=`Pop 945
Blues 58
Punk 2582
Old-Time / Historic 408
Experimental 1800
Folk 1214
Electronic 3071
Spoken 94
Classical 495
Country 142
Instrumental 1044
Chiptune / Glitch 1181
International 814
Ambient Electronic 796
Jazz 306
Soul-RnB 94
Hip-Hop 1757
Easy Listening 13
Rock 3095
`,Ft,jA,na="The dataset has the audio as arrays:",Xt,iA,Et,MA,ca=`Audio array shape: (1323119,)
Sample rate: 44100
`,Lt,yA,pa="Note that the sample rate of this audio is higher - if we want to use the existing pipeline we’ll need to ‘resample’ it to match. The clips are also longer than the ones the pipeline is set up for. Fortunately, when we load the audio using <code>pipe.mel</code> it automatically slices the clip into smaller sections:",vt,gA,$t,FA,ja,_t,BA,ia="We need to remember to adjust the sampling rate, since the data from this dataset has twice as many samples per second:",Ae,oA,te,rA,Ma="Here we use torchaudio’s transforms (imported as AT) to do the resampling, the pipe’s <code>mel</code> to turn audio into an image and torchvision’s transforms (imported as IT) to turn images into tensors. This gives us a function that turns an audio clip into a spectrogram tensor that we can use for training:",ee,uA,ae,mA,ya="We’ll use our <code>to_image()</code> function as part of a custom collate function to turn our dataset into a dataloader we can use for training. The collate function defines how to transform a batch of examples from the dataset into the final batch of data ready for training. In this case we turn each audio sample into a spectrogram image and stack the resulting tensors together:",le,JA,se,GA,ga=`torch.Size([4, 1, 256, 256])
`,ne,kA,Ba="<strong>NB: You will need to use a lower batch size (e.g., 4) unless you have plenty of GPU vRAM available.</strong>",ce,dA,pe,wA,oa="Here is a simple training loop that runs through the dataloader for a few epochs to fine-tune the pipeline’s UNet. You can also skip this cell and load the pipeline with the code in the following cell.",je,xA,ie,IA,Me,bA,ye,XA,ra,ge,WA,Be,EA,ua,oe,ZA,ma="Not the most amazing-sounding outputs, but it’s a start :) Explore tweaking the learning rate and number of epochs, and share your best results on Discord so we can improve together!",re,HA,Ja="Some things to consider:",ue,VA,Ga="<li>We’re working with 256px square spectrogram images which limits our batch size. Can you recover audio of sufficient quality from a 128x128 spectrogram?</li> <li>In place of random image augmentation we’re picking different slices of the audio clip each time, but could this be improved with some different kinds of augmentation when training for many epochs?</li> <li>How else might we use this to generate longer clips? Perhaps you could generate a 5s starting clip and then use inpainting-inspired ideas to continue to generate additional segments of audio that follow on from the initial clip…</li> <li>What is the equivalent of image-to-image in this spectrogram diffusion context?</li>",me,hA,Je,TA,ka="Once you’re happy with your model, you can save it and push it to the hub for others to enjoy:",Ge,OA,ke,UA,de,zA,we,fA,xe,SA,da=`mel  model_index.json  scheduler  unet
`,Ie,CA,be,DA,We,QA,Ze,PA,He,YA,wa="This notebook has hopefully given you a small taste of the potential of audio generation. Check out some of the references linked from the introduction to this unit to see some fancier methods and the astounding samples they can create!",Ve,qA,he,vA,Te;return m=new Ta({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/diffusion-models-class/blob/main/unit4/02_diffusion_for_audio.ipynb"}]}}),J=new u({props:{title:"Diffusion for Audio",local:"diffusion-for-audio",headingTag:"h1"}}),k=new u({props:{title:"What you will learn:",local:"what-you-will-learn",headingTag:"h2"}}),I=new u({props:{title:"Setup and Imports",local:"setup-and-imports",headingTag:"h2"}}),b=new o({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xJTIwZGF0YXNldHMlMjBkaWZmdXNlcnMlMjB0b3JjaGF1ZGlvJTIwYWNjZWxlcmF0ZQ==",highlighted:"%pip install -q datasets diffusers torchaudio accelerate",wrap:!1}}),W=new o({props:{code:"aW1wb3J0JTIwdG9yY2glMkMlMjByYW5kb20lMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjB0b3JjaC5ubi5mdW5jdGlvbmFsJTIwYXMlMjBGJTBBZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEFmcm9tJTIwSVB5dGhvbi5kaXNwbGF5JTIwaW1wb3J0JTIwQXVkaW8lMEFmcm9tJTIwbWF0cGxvdGxpYiUyMGltcG9ydCUyMHB5cGxvdCUyMGFzJTIwcGx0JTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRvcmNoYXVkaW8lMjBpbXBvcnQlMjB0cmFuc2Zvcm1zJTIwYXMlMjBBVCUwQWZyb20lMjB0b3JjaHZpc2lvbiUyMGltcG9ydCUyMHRyYW5zZm9ybXMlMjBhcyUyMElU",highlighted:`<span class="hljs-keyword">import</span> torch, random
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio
<span class="hljs-keyword">from</span> matplotlib <span class="hljs-keyword">import</span> pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> torchaudio <span class="hljs-keyword">import</span> transforms <span class="hljs-keyword">as</span> AT
<span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms <span class="hljs-keyword">as</span> IT`,wrap:!1}}),Z=new u({props:{title:"Sampling from a Pre-Trained Audio Pipeline",local:"sampling-from-a-pre-trained-audio-pipeline",headingTag:"h2"}}),V=new o({props:{code:"JTIzJTIwTG9hZCUyMGElMjBwcmUtdHJhaW5lZCUyMGF1ZGlvJTIwZGlmZnVzaW9uJTIwcGlwZWxpbmUlMEFkZXZpY2UlMjAlM0QlMjAlMjJtcHMlMjIlMjBpZiUyMHRvcmNoLmJhY2tlbmRzLm1wcy5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIydGV0aWNpbyUyRmF1ZGlvLWRpZmZ1c2lvbi1pbnN0cnVtZW50YWwtaGlwaG9wLTI1NiUyMikudG8oZGV2aWNlKQ==",highlighted:`<span class="hljs-comment"># Load a pre-trained audio diffusion pipeline</span>
device = <span class="hljs-string">&quot;mps&quot;</span> <span class="hljs-keyword">if</span> torch.backends.mps.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;teticio/audio-diffusion-instrumental-hiphop-256&quot;</span>).to(device)`,wrap:!1}}),T=new o({props:{code:"JTIzJTIwU2FtcGxlJTIwZnJvbSUyMHRoZSUyMHBpcGVsaW5lJTIwYW5kJTIwZGlzcGxheSUyMHRoZSUyMG91dHB1dHMlMEFvdXRwdXQlMjAlM0QlMjBwaXBlKCklMEFkaXNwbGF5KG91dHB1dC5pbWFnZXMlNUIwJTVEKSUwQWRpc3BsYXkoQXVkaW8ob3V0cHV0LmF1ZGlvcyU1QjAlNUQlMkMlMjByYXRlJTNEcGlwZS5tZWwuZ2V0X3NhbXBsZV9yYXRlKCkpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Sample from the pipeline and display the outputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe()
<span class="hljs-meta">&gt;&gt;&gt; </span>display(output.images[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>display(Audio(output.audios[<span class="hljs-number">0</span>], rate=pipe.mel.get_sample_rate()))`,wrap:!1}}),z=new o({props:{code:"JTIzJTIwVGhlJTIwYXVkaW8lMjBhcnJheSUwQW91dHB1dC5hdWRpb3MlNUIwJTVELnNoYXBl",highlighted:`<span class="hljs-comment"># The audio array</span>
output.audios[<span class="hljs-number">0</span>].shape`,wrap:!1}}),S=new o({props:{code:"JTIzJTIwVGhlJTIwb3V0cHV0JTIwaW1hZ2UlMjAoc3BlY3Ryb2dyYW0pJTBBb3V0cHV0LmltYWdlcyU1QjAlNUQuc2l6ZQ==",highlighted:`<span class="hljs-comment"># The output image (spectrogram)</span>
output.images[<span class="hljs-number">0</span>].size`,wrap:!1}}),Q=new o({props:{code:"cGlwZS5tZWw=",highlighted:"pipe.mel",wrap:!1}}),P=new u({props:{title:"From Audio to Image and Back Again",local:"from-audio-to-image-and-back-again",headingTag:"h2"}}),q=new o({props:{code:"JTIzJTIwQ2FsY3VsYXRlJTIwYW5kJTIwc2hvdyUyMGElMjBzcGVjdHJvZ3JhbSUyMGZvciUyMG91ciUyMGdlbmVyYXRlZCUyMGF1ZGlvJTIwc2FtcGxlJTIwdXNpbmclMjB0b3JjaGF1ZGlvJTBBc3BlY190cmFuc2Zvcm0lMjAlM0QlMjBBVC5TcGVjdHJvZ3JhbShwb3dlciUzRDIpJTBBc3BlY3Ryb2dyYW0lMjAlM0QlMjBzcGVjX3RyYW5zZm9ybSh0b3JjaC50ZW5zb3Iob3V0cHV0LmF1ZGlvcyU1QjAlNUQpKSUwQXByaW50KHNwZWN0cm9ncmFtLm1pbigpJTJDJTIwc3BlY3Ryb2dyYW0ubWF4KCkpJTBBbG9nX3NwZWN0cm9ncmFtJTIwJTNEJTIwc3BlY3Ryb2dyYW0ubG9nKCklMEFwbHQuaW1zaG93KGxvZ19zcGVjdHJvZ3JhbSU1QjAlNUQlMkMlMjBjbWFwJTNEJTIyZ3JheSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Calculate and show a spectrogram for our generated audio sample using torchaudio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>spec_transform = AT.Spectrogram(power=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>spectrogram = spec_transform(torch.tensor(output.audios[<span class="hljs-number">0</span>]))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(spectrogram.<span class="hljs-built_in">min</span>(), spectrogram.<span class="hljs-built_in">max</span>())
<span class="hljs-meta">&gt;&gt;&gt; </span>log_spectrogram = spectrogram.log()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(log_spectrogram[<span class="hljs-number">0</span>], cmap=<span class="hljs-string">&quot;gray&quot;</span>)`,wrap:!1}}),X=new o({props:{code:"YSUyMCUzRCUyMHBpcGUubWVsLmltYWdlX3RvX2F1ZGlvKG91dHB1dC5pbWFnZXMlNUIwJTVEKSUwQWEuc2hhcGU=",highlighted:`a = pipe.mel.image_to_audio(output.images[<span class="hljs-number">0</span>])
a.shape`,wrap:!1}}),L=new o({props:{code:"cGlwZS5tZWwubG9hZF9hdWRpbyhyYXdfYXVkaW8lM0RhKSUwQWltJTIwJTNEJTIwcGlwZS5tZWwuYXVkaW9fc2xpY2VfdG9faW1hZ2UoMCklMEFpbQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.mel.load_audio(raw_audio=a)
<span class="hljs-meta">&gt;&gt;&gt; </span>im = pipe.mel.audio_slice_to_image(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>im`,wrap:!1}}),_=new o({props:{code:"c2FtcGxlX3JhdGVfcGlwZWxpbmUlMjAlM0QlMjBwaXBlLm1lbC5nZXRfc2FtcGxlX3JhdGUoKSUwQXNhbXBsZV9yYXRlX3BpcGVsaW5l",highlighted:`sample_rate_pipeline = pipe.mel.get_sample_rate()
sample_rate_pipeline`,wrap:!1}}),tA=new o({props:{code:"ZGlzcGxheShBdWRpbyhvdXRwdXQuYXVkaW9zJTVCMCU1RCUyQyUyMHJhdGUlM0Q0NDEwMCkpJTIwJTIwJTIzJTIwMnglMjBzcGVlZA==",highlighted:'display(Audio(output.audios[<span class="hljs-number">0</span>], rate=<span class="hljs-number">44100</span>))  <span class="hljs-comment"># 2x speed</span>',wrap:!1}}),eA=new u({props:{title:"Fine-Tuning the pipeline",local:"fine-tuning-the-pipeline",headingTag:"h2"}}),sA=new o({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJsZXd0dW4lMkZtdXNpY19nZW5yZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;lewtun/music_genres&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
dataset`,wrap:!1}}),cA=new o({props:{code:"Zm9yJTIwZyUyMGluJTIwbGlzdChzZXQoZGF0YXNldCU1QiUyMmdlbnJlJTIyJTVEKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChnJTJDJTIwc3VtKHglMjAlM0QlM0QlMjBnJTIwZm9yJTIweCUyMGluJTIwZGF0YXNldCU1QiUyMmdlbnJlJTIyJTVEKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> g <span class="hljs-keyword">in</span> <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;genre&quot;</span>])):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(g, <span class="hljs-built_in">sum</span>(x == g <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;genre&quot;</span>]))`,wrap:!1}}),iA=new o({props:{code:"YXVkaW9fYXJyYXklMjAlM0QlMjBkYXRhc2V0JTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMEFzYW1wbGVfcmF0ZV9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEFwcmludCglMjJBdWRpbyUyMGFycmF5JTIwc2hhcGUlM0ElMjIlMkMlMjBhdWRpb19hcnJheS5zaGFwZSklMEFwcmludCglMjJTYW1wbGUlMjByYXRlJTNBJTIyJTJDJTIwc2FtcGxlX3JhdGVfZGF0YXNldCklMEFkaXNwbGF5KEF1ZGlvKGF1ZGlvX2FycmF5JTJDJTIwcmF0ZSUzRHNhbXBsZV9yYXRlX2RhdGFzZXQpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>audio_array = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_rate_dataset = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Audio array shape:&quot;</span>, audio_array.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample rate:&quot;</span>, sample_rate_dataset)
<span class="hljs-meta">&gt;&gt;&gt; </span>display(Audio(audio_array, rate=sample_rate_dataset))`,wrap:!1}}),gA=new o({props:{code:"YSUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyMCUyMCUyMyUyMEdldCUyMHRoZSUyMGF1ZGlvJTIwYXJyYXklMEFwaXBlLm1lbC5sb2FkX2F1ZGlvKHJhd19hdWRpbyUzRGEpJTIwJTIwJTIzJTIwTG9hZCUyMGl0JTIwd2l0aCUyMHBpcGUubWVsJTBBcGlwZS5tZWwuYXVkaW9fc2xpY2VfdG9faW1hZ2UoMCklMjAlMjAlMjMlMjBWaWV3JTIwdGhlJTIwZmlyc3QlMjAnc2xpY2UnJTIwYXMlMjBhJTIwc3BlY3Ryb2dyYW0=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>a = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]  <span class="hljs-comment"># Get the audio array</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.mel.load_audio(raw_audio=a)  <span class="hljs-comment"># Load it with pipe.mel</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.mel.audio_slice_to_image(<span class="hljs-number">0</span>)  <span class="hljs-comment"># View the first &#x27;slice&#x27; as a spectrogram</span>`,wrap:!1}}),oA=new o({props:{code:"c2FtcGxlX3JhdGVfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTBBc2FtcGxlX3JhdGVfZGF0YXNldA==",highlighted:`sample_rate_dataset = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]
sample_rate_dataset`,wrap:!1}}),uA=new o({props:{code:"cmVzYW1wbGVyJTIwJTNEJTIwQVQuUmVzYW1wbGUoc2FtcGxlX3JhdGVfZGF0YXNldCUyQyUyMHNhbXBsZV9yYXRlX3BpcGVsaW5lJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDMyKSUwQXRvX3QlMjAlM0QlMjBJVC5Ub1RlbnNvcigpJTBBJTBBJTBBZGVmJTIwdG9faW1hZ2UoYXVkaW9fYXJyYXkpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW9fdGVuc29yJTIwJTNEJTIwdG9yY2gudGVuc29yKGF1ZGlvX2FycmF5KS50byh0b3JjaC5mbG9hdDMyKSUwQSUyMCUyMCUyMCUyMGF1ZGlvX3RlbnNvciUyMCUzRCUyMHJlc2FtcGxlcihhdWRpb190ZW5zb3IpJTBBJTIwJTIwJTIwJTIwcGlwZS5tZWwubG9hZF9hdWRpbyhyYXdfYXVkaW8lM0RucC5hcnJheShhdWRpb190ZW5zb3IpKSUwQSUyMCUyMCUyMCUyMG51bV9zbGljZXMlMjAlM0QlMjBwaXBlLm1lbC5nZXRfbnVtYmVyX29mX3NsaWNlcygpJTBBJTIwJTIwJTIwJTIwc2xpY2VfaWR4JTIwJTNEJTIwcmFuZG9tLnJhbmRpbnQoMCUyQyUyMG51bV9zbGljZXMlMjAtJTIwMSklMjAlMjAlMjMlMjBQaWMlMjBhJTIwcmFuZG9tJTIwc2xpY2UlMjBlYWNoJTIwdGltZSUyMChleGNsdWRpbmclMjB0aGUlMjBsYXN0JTIwc2hvcnQlMjBzbGljZSklMEElMjAlMjAlMjAlMjBpbSUyMCUzRCUyMHBpcGUubWVsLmF1ZGlvX3NsaWNlX3RvX2ltYWdlKHNsaWNlX2lkeCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbQ==",highlighted:`resampler = AT.Resample(sample_rate_dataset, sample_rate_pipeline, dtype=torch.float32)
to_t = IT.ToTensor()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">to_image</span>(<span class="hljs-params">audio_array</span>):
    audio_tensor = torch.tensor(audio_array).to(torch.float32)
    audio_tensor = resampler(audio_tensor)
    pipe.mel.load_audio(raw_audio=np.array(audio_tensor))
    num_slices = pipe.mel.get_number_of_slices()
    slice_idx = random.randint(<span class="hljs-number">0</span>, num_slices - <span class="hljs-number">1</span>)  <span class="hljs-comment"># Pic a random slice each time (excluding the last short slice)</span>
    im = pipe.mel.audio_slice_to_image(slice_idx)
    <span class="hljs-keyword">return</span> im`,wrap:!1}}),JA=new o({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjB0byUyMGltYWdlJTIwLSUzRSUyMHRvJTIwdGVuc29yJTIwLSUzRSUyMHJlc2NhbGUlMjB0byUyMCgtMSUyQyUyMDEpJTIwLSUzRSUyMHN0YWNrJTIwaW50byUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwYXVkaW9faW1zJTIwJTNEJTIwJTVCdG9fdCh0b19pbWFnZSh4JTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCkpJTIwKiUyMDIlMjAtJTIwMSUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVzJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9yY2guc3RhY2soYXVkaW9faW1zKSUwQSUwQSUwQSUyMyUyMENyZWF0ZSUyMGElMjBkYXRhc2V0JTIwd2l0aCUyMG9ubHklMjB0aGUlMjAnQ2hpcHR1bmUlMjAlMkYlMjBHbGl0Y2gnJTIwZ2VucmUlMjBvZiUyMHNvbmdzJTBBYmF0Y2hfc2l6ZSUyMCUzRCUyMDQlMjAlMjAlMjMlMjA0JTIwb24lMjBjb2xhYiUyQyUyMDEyJTIwb24lMjBBMTAwJTBBY2hvc2VuX2dlbnJlJTIwJTNEJTIwJTIyRWxlY3Ryb25pYyUyMiUyMCUyMCUyMyUyMCUzQyUzQyUzQyUyMFRyeSUyMHRyYWluaW5nJTIwb24lMjBkaWZmZXJlbnQlMjBnZW5yZXMlMjAlM0MlM0MlM0MlMEFpbmRleGVzJTIwJTNEJTIwJTVCaSUyMGZvciUyMGklMkMlMjBnJTIwaW4lMjBlbnVtZXJhdGUoZGF0YXNldCU1QiUyMmdlbnJlJTIyJTVEKSUyMGlmJTIwZyUyMCUzRCUzRCUyMGNob3Nlbl9nZW5yZSU1RCUwQWZpbHRlcmVkX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNlbGVjdChpbmRleGVzKSUwQWRsJTIwJTNEJTIwdG9yY2gudXRpbHMuZGF0YS5EYXRhTG9hZGVyKCUwQSUyMCUyMCUyMCUyMGZpbHRlcmVkX2RhdGFzZXQuc2h1ZmZsZSgpJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBjb2xsYXRlX2ZuJTNEY29sbGF0ZV9mbiUyQyUyMHNodWZmbGUlM0RUcnVlJTBBKSUwQWJhdGNoJTIwJTNEJTIwbmV4dChpdGVyKGRsKSklMEFwcmludChiYXRjaC5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># to image -&gt; to tensor -&gt; rescale to (-1, 1) -&gt; stack into batch</span>
<span class="hljs-meta">... </span>    audio_ims = [to_t(to_image(x[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])) * <span class="hljs-number">2</span> - <span class="hljs-number">1</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> examples]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> torch.stack(audio_ims)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create a dataset with only the &#x27;Chiptune / Glitch&#x27; genre of songs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-number">4</span>  <span class="hljs-comment"># 4 on colab, 12 on A100</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chosen_genre = <span class="hljs-string">&quot;Electronic&quot;</span>  <span class="hljs-comment"># &lt;&lt;&lt; Try training on different genres &lt;&lt;&lt;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indexes = [i <span class="hljs-keyword">for</span> i, g <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataset[<span class="hljs-string">&quot;genre&quot;</span>]) <span class="hljs-keyword">if</span> g == chosen_genre]
<span class="hljs-meta">&gt;&gt;&gt; </span>filtered_dataset = dataset.select(indexes)
<span class="hljs-meta">&gt;&gt;&gt; </span>dl = torch.utils.data.DataLoader(
<span class="hljs-meta">... </span>    filtered_dataset.shuffle(), batch_size=batch_size, collate_fn=collate_fn, shuffle=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dl))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(batch.shape)`,wrap:!1}}),dA=new u({props:{title:"Training Loop",local:"training-loop",headingTag:"h2"}}),xA=new o({props:{code:"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",highlighted:`epochs = <span class="hljs-number">3</span>
lr = <span class="hljs-number">1e-4</span>

pipe.unet.train()
pipe.scheduler.set_timesteps(<span class="hljs-number">1000</span>)
optimizer = torch.optim.AdamW(pipe.unet.parameters(), lr=lr)

<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(epochs):
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(dl), total=<span class="hljs-built_in">len</span>(dl)):

        <span class="hljs-comment"># Prepare the input images</span>
        clean_images = batch.to(device)
        bs = clean_images.shape[<span class="hljs-number">0</span>]

        <span class="hljs-comment"># Sample a random timestep for each image</span>
        timesteps = torch.randint(<span class="hljs-number">0</span>, pipe.scheduler.num_train_timesteps, (bs,), device=clean_images.device).long()

        <span class="hljs-comment"># Add noise to the clean images according to the noise magnitude at each timestep</span>
        noise = torch.randn(clean_images.shape).to(clean_images.device)
        noisy_images = pipe.scheduler.add_noise(clean_images, noise, timesteps)

        <span class="hljs-comment"># Get the model prediction</span>
        noise_pred = pipe.unet(noisy_images, timesteps, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]

        <span class="hljs-comment"># Calculate the loss</span>
        loss = F.mse_loss(noise_pred, noise)
        loss.backward(loss)

        <span class="hljs-comment"># Update the model parameters with the optimizer</span>
        optimizer.step()
        optimizer.zero_grad()`,wrap:!1}}),IA=new o({props:{code:"JTIzJTIwT1IlM0ElMjBMb2FkJTIwdGhlJTIwdmVyc2lvbiUyMEklMjB0cmFpbmVkJTIwZWFybGllciUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyam9obm93aGl0YWtlciUyRkVsZWN0cm9uaWNfdGVzdCUyMikudG8oZGV2aWNlKQ==",highlighted:`<span class="hljs-comment"># OR: Load the version I trained earlier</span>
pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;johnowhitaker/Electronic_test&quot;</span>).to(device)`,wrap:!1}}),bA=new o({props:{code:"b3V0cHV0JTIwJTNEJTIwcGlwZSgpJTBBZGlzcGxheShvdXRwdXQuaW1hZ2VzJTVCMCU1RCklMEFkaXNwbGF5KEF1ZGlvKG91dHB1dC5hdWRpb3MlNUIwJTVEJTJDJTIwcmF0ZSUzRDIyMDUwKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe()
<span class="hljs-meta">&gt;&gt;&gt; </span>display(output.images[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>display(Audio(output.audios[<span class="hljs-number">0</span>], rate=<span class="hljs-number">22050</span>))`,wrap:!1}}),WA=new o({props:{code:"JTIzJTIwTWFrZSUyMGElMjBsb25nZXIlMjBzYW1wbGUlMjBieSUyMHBhc3NpbmclMjBpbiUyMGElMjBzdGFydGluZyUyMG5vaXNlJTIwdGVuc29yJTIwd2l0aCUyMGElMjBkaWZmZXJlbnQlMjBzaGFwZSUwQW5vaXNlJTIwJTNEJTIwdG9yY2gucmFuZG4oMSUyQyUyMDElMkMlMjBwaXBlLnVuZXQuc2FtcGxlX3NpemUlNUIwJTVEJTJDJTIwcGlwZS51bmV0LnNhbXBsZV9zaXplJTVCMSU1RCUyMColMjA0KS50byhkZXZpY2UpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZShub2lzZSUzRG5vaXNlKSUwQWRpc3BsYXkob3V0cHV0LmltYWdlcyU1QjAlNUQpJTBBZGlzcGxheShBdWRpbyhvdXRwdXQuYXVkaW9zJTVCMCU1RCUyQyUyMHJhdGUlM0QyMjA1MCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Make a longer sample by passing in a starting noise tensor with a different shape</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, pipe.unet.sample_size[<span class="hljs-number">0</span>], pipe.unet.sample_size[<span class="hljs-number">1</span>] * <span class="hljs-number">4</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(noise=noise)
<span class="hljs-meta">&gt;&gt;&gt; </span>display(output.images[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>display(Audio(output.audios[<span class="hljs-number">0</span>], rate=<span class="hljs-number">22050</span>))`,wrap:!1}}),hA=new u({props:{title:"Push to Hub",local:"push-to-hub",headingTag:"h2"}}),OA=new o({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9mdWxsX3JlcG9fbmFtZSUyQyUyMEhmQXBpJTJDJTIwY3JlYXRlX3JlcG8lMkMlMjBNb2RlbENhcmQ=",highlighted:'<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_full_repo_name, HfApi, create_repo, ModelCard',wrap:!1}}),UA=new o({props:{code:"JTIzJTIwUGljayUyMGElMjBuYW1lJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIyYXVkaW8tZGlmZnVzaW9uLWVsZWN0cm9uaWMlMjIlMEFodWJfbW9kZWxfaWQlMjAlM0QlMjBnZXRfZnVsbF9yZXBvX25hbWUobW9kZWxfbmFtZSk=",highlighted:`<span class="hljs-comment"># Pick a name for the model</span>
model_name = <span class="hljs-string">&quot;audio-diffusion-electronic&quot;</span>
hub_model_id = get_full_repo_name(model_name)`,wrap:!1}}),zA=new o({props:{code:"JTIzJTIwU2F2ZSUyMHRoZSUyMHBpcGVsaW5lJTIwbG9jYWxseSUwQXBpcGUuc2F2ZV9wcmV0cmFpbmVkKG1vZGVsX25hbWUp",highlighted:`<span class="hljs-comment"># Save the pipeline locally</span>
pipe.save_pretrained(model_name)`,wrap:!1}}),fA=new o({props:{code:"JTIzJTIwSW5zcGVjdCUyMHRoZSUyMGZvbGRlciUyMGNvbnRlbnRzJTBBIWxzJTIwJTdCbW9kZWxfbmFtZSU3RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Inspect the folder contents</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>!ls {model_name}`,wrap:!1}}),CA=new o({props:{code:"JTIzJTIwQ3JlYXRlJTIwYSUyMHJlcG9zaXRvcnklMEFjcmVhdGVfcmVwbyhodWJfbW9kZWxfaWQp",highlighted:`<span class="hljs-comment"># Create a repository</span>
create_repo(hub_model_id)`,wrap:!1}}),DA=new o({props:{code:"JTIzJTIwVXBsb2FkJTIwdGhlJTIwZmlsZXMlMEFhcGklMjAlM0QlMjBIZkFwaSgpJTBBYXBpLnVwbG9hZF9mb2xkZXIoZm9sZGVyX3BhdGglM0RmJTIyJTdCbW9kZWxfbmFtZSU3RCUyRnNjaGVkdWxlciUyMiUyQyUyMHBhdGhfaW5fcmVwbyUzRCUyMnNjaGVkdWxlciUyMiUyQyUyMHJlcG9faWQlM0RodWJfbW9kZWxfaWQpJTBBYXBpLnVwbG9hZF9mb2xkZXIoZm9sZGVyX3BhdGglM0RmJTIyJTdCbW9kZWxfbmFtZSU3RCUyRm1lbCUyMiUyQyUyMHBhdGhfaW5fcmVwbyUzRCUyMm1lbCUyMiUyQyUyMHJlcG9faWQlM0RodWJfbW9kZWxfaWQpJTBBYXBpLnVwbG9hZF9mb2xkZXIoZm9sZGVyX3BhdGglM0RmJTIyJTdCbW9kZWxfbmFtZSU3RCUyRnVuZXQlMjIlMkMlMjBwYXRoX2luX3JlcG8lM0QlMjJ1bmV0JTIyJTJDJTIwcmVwb19pZCUzRGh1Yl9tb2RlbF9pZCklMEFhcGkudXBsb2FkX2ZpbGUoJTBBJTIwJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEZiUyMiU3Qm1vZGVsX25hbWUlN0QlMkZtb2RlbF9pbmRleC5qc29uJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGF0aF9pbl9yZXBvJTNEJTIybW9kZWxfaW5kZXguanNvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RodWJfbW9kZWxfaWQlMkMlMEEp",highlighted:`<span class="hljs-comment"># Upload the files</span>
api = HfApi()
api.upload_folder(folder_path=<span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>/scheduler&quot;</span>, path_in_repo=<span class="hljs-string">&quot;scheduler&quot;</span>, repo_id=hub_model_id)
api.upload_folder(folder_path=<span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>/mel&quot;</span>, path_in_repo=<span class="hljs-string">&quot;mel&quot;</span>, repo_id=hub_model_id)
api.upload_folder(folder_path=<span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>/unet&quot;</span>, path_in_repo=<span class="hljs-string">&quot;unet&quot;</span>, repo_id=hub_model_id)
api.upload_file(
    path_or_fileobj=<span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>/model_index.json&quot;</span>,
    path_in_repo=<span class="hljs-string">&quot;model_index.json&quot;</span>,
    repo_id=hub_model_id,
)`,wrap:!1}}),QA=new o({props:{code:"JTIzJTIwUHVzaCUyMGElMjBtb2RlbCUyMGNhcmQlMEFjb250ZW50JTIwJTNEJTIwZiUyMiUyMiUyMiUwQS0tLSUwQWxpY2Vuc2UlM0ElMjBtaXQlMEF0YWdzJTNBJTBBLSUyMHB5dG9yY2glMEEtJTIwZGlmZnVzZXJzJTBBLSUyMHVuY29uZGl0aW9uYWwtYXVkaW8tZ2VuZXJhdGlvbiUwQS0lMjBkaWZmdXNpb24tbW9kZWxzLWNsYXNzJTBBLS0tJTBBJTBBJTIzJTIwTW9kZWwlMjBDYXJkJTIwZm9yJTIwVW5pdCUyMDQlMjBvZiUyMHRoZSUyMCU1QkRpZmZ1c2lvbiUyME1vZGVscyUyMENsYXNzJTIwJUYwJTlGJUE3JUE4JTVEKGh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGZGlmZnVzaW9uLW1vZGVscy1jbGFzcyklMEElMEFUaGlzJTIwbW9kZWwlMjBpcyUyMGElMjBkaWZmdXNpb24lMjBtb2RlbCUyMGZvciUyMHVuY29uZGl0aW9uYWwlMjBhdWRpbyUyMGdlbmVyYXRpb24lMjBvZiUyMG11c2ljJTIwaW4lMjB0aGUlMjBnZW5yZSUyMCU3QmNob3Nlbl9nZW5yZSU3RCUwQSUwQSUyMyUyMyUyMFVzYWdlJTBBJTBBJTNDcHJlJTNFJTBBZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjIlN0JodWJfbW9kZWxfaWQlN0QlMjIpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSgpJTBBZGlzcGxheShvdXRwdXQuaW1hZ2VzJTVCMCU1RCklMEFkaXNwbGF5KEF1ZGlvKG91dHB1dC5hdWRpb3MlNUIwJTVEJTJDJTIwcmF0ZSUzRHBpcGUubWVsLmdldF9zYW1wbGVfcmF0ZSgpKSklMEElM0MlMkZwcmUlM0UlMEElMjIlMjIlMjIlMEElMEFjYXJkJTIwJTNEJTIwTW9kZWxDYXJkKGNvbnRlbnQpJTBBY2FyZC5wdXNoX3RvX2h1YihodWJfbW9kZWxfaWQp",highlighted:`<span class="hljs-comment"># Push a model card</span>
content = <span class="hljs-string">f&quot;&quot;&quot;
---
license: mit
tags:
- pytorch
- diffusers
- unconditional-audio-generation
- diffusion-models-class
---

# Model Card for Unit 4 of the [Diffusion Models Class 🧨](https://github.com/huggingface/diffusion-models-class)

This model is a diffusion model for unconditional audio generation of music in the genre <span class="hljs-subst">{chosen_genre}</span>

## Usage

&lt;pre&gt;
from IPython.display import Audio
from diffusers import DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(&quot;<span class="hljs-subst">{hub_model_id}</span>&quot;)
output = pipe()
display(output.images[0])
display(Audio(output.audios[0], rate=pipe.mel.get_sample_rate()))
&lt;/pre&gt;
&quot;&quot;&quot;</span>

card = ModelCard(content)
card.push_to_hub(hub_model_id)`,wrap:!1}}),PA=new u({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),qA=new Oa({props:{source:"https://github.com/huggingface/diffusion-models-class/blob/main/unit4/02_diffusion_for_audio.md"}}),{c(){r=n("meta"),_A=l(),LA=n("p"),At=l(),p(m.$$.fragment),tt=l(),p(J.$$.fragment),et=l(),G=n("p"),G.textContent=Ue,at=l(),p(k.$$.fragment),lt=l(),d=n("ul"),d.innerHTML=ze,st=l(),w=n("p"),w.textContent=fe,nt=l(),x=n("p"),x.textContent=Se,ct=l(),p(I.$$.fragment),pt=l(),p(b.$$.fragment),jt=l(),p(W.$$.fragment),it=l(),p(Z.$$.fragment),Mt=l(),H=n("p"),H.innerHTML=Ce,yt=l(),p(V.$$.fragment),gt=l(),h=n("p"),h.textContent=De,Bt=l(),p(T.$$.fragment),ot=l(),KA=n("img"),rt=l(),O=n("p"),O.innerHTML=Pe,ut=l(),U=n("p"),U.textContent=Ye,mt=l(),p(z.$$.fragment),Jt=l(),f=n("p"),f.textContent=qe,Gt=l(),p(S.$$.fragment),kt=l(),C=n("p"),C.innerHTML=Re,dt=l(),D=n("p"),D.innerHTML=Ke,wt=l(),p(Q.$$.fragment),xt=l(),p(P.$$.fragment),It=l(),Y=n("p"),Y.textContent=Ne,bt=l(),p(q.$$.fragment),Wt=l(),R=n("pre"),R.textContent=Fe,Zt=l(),K=n("p"),K.textContent=Xe,Ht=l(),N=n("p"),N.innerHTML=Ee,Vt=l(),F=n("p"),F.innerHTML=Le,ht=l(),p(X.$$.fragment),Tt=l(),E=n("p"),E.innerHTML=ve,Ot=l(),p(L.$$.fragment),Ut=l(),NA=n("img"),zt=l(),v=n("p"),v.textContent=_e,ft=l(),$=n("p"),$.textContent=Aa,St=l(),p(_.$$.fragment),Ct=l(),AA=n("p"),AA.textContent=ta,Dt=l(),p(tA.$$.fragment),Qt=l(),p(eA.$$.fragment),Pt=l(),aA=n("p"),aA.textContent=ea,Yt=l(),lA=n("p"),lA.textContent=aa,qt=l(),p(sA.$$.fragment),Rt=l(),nA=n("p"),nA.textContent=la,Kt=l(),p(cA.$$.fragment),Nt=l(),pA=n("pre"),pA.textContent=sa,Ft=l(),jA=n("p"),jA.textContent=na,Xt=l(),p(iA.$$.fragment),Et=l(),MA=n("pre"),MA.textContent=ca,Lt=l(),yA=n("p"),yA.innerHTML=pa,vt=l(),p(gA.$$.fragment),$t=l(),FA=n("img"),_t=l(),BA=n("p"),BA.textContent=ia,Ae=l(),p(oA.$$.fragment),te=l(),rA=n("p"),rA.innerHTML=Ma,ee=l(),p(uA.$$.fragment),ae=l(),mA=n("p"),mA.innerHTML=ya,le=l(),p(JA.$$.fragment),se=l(),GA=n("pre"),GA.textContent=ga,ne=l(),kA=n("p"),kA.innerHTML=Ba,ce=l(),p(dA.$$.fragment),pe=l(),wA=n("p"),wA.textContent=oa,je=l(),p(xA.$$.fragment),ie=l(),p(IA.$$.fragment),Me=l(),p(bA.$$.fragment),ye=l(),XA=n("img"),ge=l(),p(WA.$$.fragment),Be=l(),EA=n("img"),oe=l(),ZA=n("p"),ZA.textContent=ma,re=l(),HA=n("p"),HA.textContent=Ja,ue=l(),VA=n("ul"),VA.innerHTML=Ga,me=l(),p(hA.$$.fragment),Je=l(),TA=n("p"),TA.textContent=ka,Ge=l(),p(OA.$$.fragment),ke=l(),p(UA.$$.fragment),de=l(),p(zA.$$.fragment),we=l(),p(fA.$$.fragment),xe=l(),SA=n("pre"),SA.textContent=da,Ie=l(),p(CA.$$.fragment),be=l(),p(DA.$$.fragment),We=l(),p(QA.$$.fragment),Ze=l(),p(PA.$$.fragment),He=l(),YA=n("p"),YA.textContent=wa,Ve=l(),p(qA.$$.fragment),he=l(),vA=n("p"),this.h()},l(A){const t=Va("svelte-u9bgzb",document.head);r=c(t,"META",{name:!0,content:!0}),t.forEach(e),_A=s(A),LA=c(A,"P",{}),xa(LA).forEach(e),At=s(A),j(m.$$.fragment,A),tt=s(A),j(J.$$.fragment,A),et=s(A),G=c(A,"P",{"data-svelte-h":!0}),B(G)!=="svelte-isjelk"&&(G.textContent=Ue),at=s(A),j(k.$$.fragment,A),lt=s(A),d=c(A,"UL",{"data-svelte-h":!0}),B(d)!=="svelte-akkmi2"&&(d.innerHTML=ze),st=s(A),w=c(A,"P",{"data-svelte-h":!0}),B(w)!=="svelte-it7067"&&(w.textContent=fe),nt=s(A),x=c(A,"P",{"data-svelte-h":!0}),B(x)!=="svelte-4b3xjd"&&(x.textContent=Se),ct=s(A),j(I.$$.fragment,A),pt=s(A),j(b.$$.fragment,A),jt=s(A),j(W.$$.fragment,A),it=s(A),j(Z.$$.fragment,A),Mt=s(A),H=c(A,"P",{"data-svelte-h":!0}),B(H)!=="svelte-xha4wo"&&(H.innerHTML=Ce),yt=s(A),j(V.$$.fragment,A),gt=s(A),h=c(A,"P",{"data-svelte-h":!0}),B(h)!=="svelte-prowgg"&&(h.textContent=De),Bt=s(A),j(T.$$.fragment,A),ot=s(A),KA=c(A,"IMG",{src:!0}),rt=s(A),O=c(A,"P",{"data-svelte-h":!0}),B(O)!=="svelte-1ntnxxd"&&(O.innerHTML=Pe),ut=s(A),U=c(A,"P",{"data-svelte-h":!0}),B(U)!=="svelte-123lkky"&&(U.textContent=Ye),mt=s(A),j(z.$$.fragment,A),Jt=s(A),f=c(A,"P",{"data-svelte-h":!0}),B(f)!=="svelte-1uukhfr"&&(f.textContent=qe),Gt=s(A),j(S.$$.fragment,A),kt=s(A),C=c(A,"P",{"data-svelte-h":!0}),B(C)!=="svelte-1g4wpvu"&&(C.innerHTML=Re),dt=s(A),D=c(A,"P",{"data-svelte-h":!0}),B(D)!=="svelte-65v2k7"&&(D.innerHTML=Ke),wt=s(A),j(Q.$$.fragment,A),xt=s(A),j(P.$$.fragment,A),It=s(A),Y=c(A,"P",{"data-svelte-h":!0}),B(Y)!=="svelte-1xkgcu4"&&(Y.textContent=Ne),bt=s(A),j(q.$$.fragment,A),Wt=s(A),R=c(A,"PRE",{"data-svelte-h":!0}),B(R)!=="svelte-y4pfwy"&&(R.textContent=Fe),Zt=s(A),K=c(A,"P",{"data-svelte-h":!0}),B(K)!=="svelte-mmy70z"&&(K.textContent=Xe),Ht=s(A),N=c(A,"P",{"data-svelte-h":!0}),B(N)!=="svelte-166fubv"&&(N.innerHTML=Ee),Vt=s(A),F=c(A,"P",{"data-svelte-h":!0}),B(F)!=="svelte-yd2g5t"&&(F.innerHTML=Le),ht=s(A),j(X.$$.fragment,A),Tt=s(A),E=c(A,"P",{"data-svelte-h":!0}),B(E)!=="svelte-1dret7g"&&(E.innerHTML=ve),Ot=s(A),j(L.$$.fragment,A),Ut=s(A),NA=c(A,"IMG",{src:!0}),zt=s(A),v=c(A,"P",{"data-svelte-h":!0}),B(v)!=="svelte-1crnfim"&&(v.textContent=_e),ft=s(A),$=c(A,"P",{"data-svelte-h":!0}),B($)!=="svelte-1yzqmnh"&&($.textContent=Aa),St=s(A),j(_.$$.fragment,A),Ct=s(A),AA=c(A,"P",{"data-svelte-h":!0}),B(AA)!=="svelte-1fhh9bu"&&(AA.textContent=ta),Dt=s(A),j(tA.$$.fragment,A),Qt=s(A),j(eA.$$.fragment,A),Pt=s(A),aA=c(A,"P",{"data-svelte-h":!0}),B(aA)!=="svelte-1if3q06"&&(aA.textContent=ea),Yt=s(A),lA=c(A,"P",{"data-svelte-h":!0}),B(lA)!=="svelte-1f6cx0g"&&(lA.textContent=aa),qt=s(A),j(sA.$$.fragment,A),Rt=s(A),nA=c(A,"P",{"data-svelte-h":!0}),B(nA)!=="svelte-i5n1kl"&&(nA.textContent=la),Kt=s(A),j(cA.$$.fragment,A),Nt=s(A),pA=c(A,"PRE",{"data-svelte-h":!0}),B(pA)!=="svelte-1wm8e68"&&(pA.textContent=sa),Ft=s(A),jA=c(A,"P",{"data-svelte-h":!0}),B(jA)!=="svelte-riqdae"&&(jA.textContent=na),Xt=s(A),j(iA.$$.fragment,A),Et=s(A),MA=c(A,"PRE",{"data-svelte-h":!0}),B(MA)!=="svelte-hmez8y"&&(MA.textContent=ca),Lt=s(A),yA=c(A,"P",{"data-svelte-h":!0}),B(yA)!=="svelte-ayptta"&&(yA.innerHTML=pa),vt=s(A),j(gA.$$.fragment,A),$t=s(A),FA=c(A,"IMG",{src:!0}),_t=s(A),BA=c(A,"P",{"data-svelte-h":!0}),B(BA)!=="svelte-1ammvag"&&(BA.textContent=ia),Ae=s(A),j(oA.$$.fragment,A),te=s(A),rA=c(A,"P",{"data-svelte-h":!0}),B(rA)!=="svelte-ugkgzm"&&(rA.innerHTML=Ma),ee=s(A),j(uA.$$.fragment,A),ae=s(A),mA=c(A,"P",{"data-svelte-h":!0}),B(mA)!=="svelte-zvgb1i"&&(mA.innerHTML=ya),le=s(A),j(JA.$$.fragment,A),se=s(A),GA=c(A,"PRE",{"data-svelte-h":!0}),B(GA)!=="svelte-1r6eqh1"&&(GA.textContent=ga),ne=s(A),kA=c(A,"P",{"data-svelte-h":!0}),B(kA)!=="svelte-18t3iln"&&(kA.innerHTML=Ba),ce=s(A),j(dA.$$.fragment,A),pe=s(A),wA=c(A,"P",{"data-svelte-h":!0}),B(wA)!=="svelte-1rxf1v6"&&(wA.textContent=oa),je=s(A),j(xA.$$.fragment,A),ie=s(A),j(IA.$$.fragment,A),Me=s(A),j(bA.$$.fragment,A),ye=s(A),XA=c(A,"IMG",{src:!0}),ge=s(A),j(WA.$$.fragment,A),Be=s(A),EA=c(A,"IMG",{src:!0}),oe=s(A),ZA=c(A,"P",{"data-svelte-h":!0}),B(ZA)!=="svelte-gdbjaq"&&(ZA.textContent=ma),re=s(A),HA=c(A,"P",{"data-svelte-h":!0}),B(HA)!=="svelte-zvcbvr"&&(HA.textContent=Ja),ue=s(A),VA=c(A,"UL",{"data-svelte-h":!0}),B(VA)!=="svelte-p18yy3"&&(VA.innerHTML=Ga),me=s(A),j(hA.$$.fragment,A),Je=s(A),TA=c(A,"P",{"data-svelte-h":!0}),B(TA)!=="svelte-ci4hz6"&&(TA.textContent=ka),Ge=s(A),j(OA.$$.fragment,A),ke=s(A),j(UA.$$.fragment,A),de=s(A),j(zA.$$.fragment,A),we=s(A),j(fA.$$.fragment,A),xe=s(A),SA=c(A,"PRE",{"data-svelte-h":!0}),B(SA)!=="svelte-135p061"&&(SA.textContent=da),Ie=s(A),j(CA.$$.fragment,A),be=s(A),j(DA.$$.fragment,A),We=s(A),j(QA.$$.fragment,A),Ze=s(A),j(PA.$$.fragment,A),He=s(A),YA=c(A,"P",{"data-svelte-h":!0}),B(YA)!=="svelte-1dmyqj4"&&(YA.textContent=wa),Ve=s(A),j(qA.$$.fragment,A),he=s(A),vA=c(A,"P",{}),xa(vA).forEach(e),this.h()},h(){RA(r,"name","hf:doc:metadata"),RA(r,"content",za),$A(KA.src,Qe="data:image/jpeg;base64,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")||RA(KA,"src",Qe),$A(NA.src,$e="data:image/jpeg;base64,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")||RA(NA,"src",$e),$A(FA.src,ja="data:image/jpeg;base64,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")||RA(FA,"src",ja),$A(XA.src,ra="data:image/jpeg;base64,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")||RA(XA,"src",ra),$A(EA.src,ua="data:image/jpeg;base64,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")||RA(EA,"src",ua)},m(A,t){ha(document.head,r),a(A,_A,t),a(A,LA,t),a(A,At,t),i(m,A,t),a(A,tt,t),i(J,A,t),a(A,et,t),a(A,G,t),a(A,at,t),i(k,A,t),a(A,lt,t),a(A,d,t),a(A,st,t),a(A,w,t),a(A,nt,t),a(A,x,t),a(A,ct,t),i(I,A,t),a(A,pt,t),i(b,A,t),a(A,jt,t),i(W,A,t),a(A,it,t),i(Z,A,t),a(A,Mt,t),a(A,H,t),a(A,yt,t),i(V,A,t),a(A,gt,t),a(A,h,t),a(A,Bt,t),i(T,A,t),a(A,ot,t),a(A,KA,t),a(A,rt,t),a(A,O,t),a(A,ut,t),a(A,U,t),a(A,mt,t),i(z,A,t),a(A,Jt,t),a(A,f,t),a(A,Gt,t),i(S,A,t),a(A,kt,t),a(A,C,t),a(A,dt,t),a(A,D,t),a(A,wt,t),i(Q,A,t),a(A,xt,t),i(P,A,t),a(A,It,t),a(A,Y,t),a(A,bt,t),i(q,A,t),a(A,Wt,t),a(A,R,t),a(A,Zt,t),a(A,K,t),a(A,Ht,t),a(A,N,t),a(A,Vt,t),a(A,F,t),a(A,ht,t),i(X,A,t),a(A,Tt,t),a(A,E,t),a(A,Ot,t),i(L,A,t),a(A,Ut,t),a(A,NA,t),a(A,zt,t),a(A,v,t),a(A,ft,t),a(A,$,t),a(A,St,t),i(_,A,t),a(A,Ct,t),a(A,AA,t),a(A,Dt,t),i(tA,A,t),a(A,Qt,t),i(eA,A,t),a(A,Pt,t),a(A,aA,t),a(A,Yt,t),a(A,lA,t),a(A,qt,t),i(sA,A,t),a(A,Rt,t),a(A,nA,t),a(A,Kt,t),i(cA,A,t),a(A,Nt,t),a(A,pA,t),a(A,Ft,t),a(A,jA,t),a(A,Xt,t),i(iA,A,t),a(A,Et,t),a(A,MA,t),a(A,Lt,t),a(A,yA,t),a(A,vt,t),i(gA,A,t),a(A,$t,t),a(A,FA,t),a(A,_t,t),a(A,BA,t),a(A,Ae,t),i(oA,A,t),a(A,te,t),a(A,rA,t),a(A,ee,t),i(uA,A,t),a(A,ae,t),a(A,mA,t),a(A,le,t),i(JA,A,t),a(A,se,t),a(A,GA,t),a(A,ne,t),a(A,kA,t),a(A,ce,t),i(dA,A,t),a(A,pe,t),a(A,wA,t),a(A,je,t),i(xA,A,t),a(A,ie,t),i(IA,A,t),a(A,Me,t),i(bA,A,t),a(A,ye,t),a(A,XA,t),a(A,ge,t),i(WA,A,t),a(A,Be,t),a(A,EA,t),a(A,oe,t),a(A,ZA,t),a(A,re,t),a(A,HA,t),a(A,ue,t),a(A,VA,t),a(A,me,t),i(hA,A,t),a(A,Je,t),a(A,TA,t),a(A,Ge,t),i(OA,A,t),a(A,ke,t),i(UA,A,t),a(A,de,t),i(zA,A,t),a(A,we,t),i(fA,A,t),a(A,xe,t),a(A,SA,t),a(A,Ie,t),i(CA,A,t),a(A,be,t),i(DA,A,t),a(A,We,t),i(QA,A,t),a(A,Ze,t),i(PA,A,t),a(A,He,t),a(A,YA,t),a(A,Ve,t),i(qA,A,t),a(A,he,t),a(A,vA,t),Te=!0},p:ba,i(A){Te||(M(m.$$.fragment,A),M(J.$$.fragment,A),M(k.$$.fragment,A),M(I.$$.fragment,A),M(b.$$.fragment,A),M(W.$$.fragment,A),M(Z.$$.fragment,A),M(V.$$.fragment,A),M(T.$$.fragment,A),M(z.$$.fragment,A),M(S.$$.fragment,A),M(Q.$$.fragment,A),M(P.$$.fragment,A),M(q.$$.fragment,A),M(X.$$.fragment,A),M(L.$$.fragment,A),M(_.$$.fragment,A),M(tA.$$.fragment,A),M(eA.$$.fragment,A),M(sA.$$.fragment,A),M(cA.$$.fragment,A),M(iA.$$.fragment,A),M(gA.$$.fragment,A),M(oA.$$.fragment,A),M(uA.$$.fragment,A),M(JA.$$.fragment,A),M(dA.$$.fragment,A),M(xA.$$.fragment,A),M(IA.$$.fragment,A),M(bA.$$.fragment,A),M(WA.$$.fragment,A),M(hA.$$.fragment,A),M(OA.$$.fragment,A),M(UA.$$.fragment,A),M(zA.$$.fragment,A),M(fA.$$.fragment,A),M(CA.$$.fragment,A),M(DA.$$.fragment,A),M(QA.$$.fragment,A),M(PA.$$.fragment,A),M(qA.$$.fragment,A),Te=!0)},o(A){y(m.$$.fragment,A),y(J.$$.fragment,A),y(k.$$.fragment,A),y(I.$$.fragment,A),y(b.$$.fragment,A),y(W.$$.fragment,A),y(Z.$$.fragment,A),y(V.$$.fragment,A),y(T.$$.fragment,A),y(z.$$.fragment,A),y(S.$$.fragment,A),y(Q.$$.fragment,A),y(P.$$.fragment,A),y(q.$$.fragment,A),y(X.$$.fragment,A),y(L.$$.fragment,A),y(_.$$.fragment,A),y(tA.$$.fragment,A),y(eA.$$.fragment,A),y(sA.$$.fragment,A),y(cA.$$.fragment,A),y(iA.$$.fragment,A),y(gA.$$.fragment,A),y(oA.$$.fragment,A),y(uA.$$.fragment,A),y(JA.$$.fragment,A),y(dA.$$.fragment,A),y(xA.$$.fragment,A),y(IA.$$.fragment,A),y(bA.$$.fragment,A),y(WA.$$.fragment,A),y(hA.$$.fragment,A),y(OA.$$.fragment,A),y(UA.$$.fragment,A),y(zA.$$.fragment,A),y(fA.$$.fragment,A),y(CA.$$.fragment,A),y(DA.$$.fragment,A),y(QA.$$.fragment,A),y(PA.$$.fragment,A),y(qA.$$.fragment,A),Te=!1},d(A){A&&(e(_A),e(LA),e(At),e(tt),e(et),e(G),e(at),e(lt),e(d),e(st),e(w),e(nt),e(x),e(ct),e(pt),e(jt),e(it),e(Mt),e(H),e(yt),e(gt),e(h),e(Bt),e(ot),e(KA),e(rt),e(O),e(ut),e(U),e(mt),e(Jt),e(f),e(Gt),e(kt),e(C),e(dt),e(D),e(wt),e(xt),e(It),e(Y),e(bt),e(Wt),e(R),e(Zt),e(K),e(Ht),e(N),e(Vt),e(F),e(ht),e(Tt),e(E),e(Ot),e(Ut),e(NA),e(zt),e(v),e(ft),e($),e(St),e(Ct),e(AA),e(Dt),e(Qt),e(Pt),e(aA),e(Yt),e(lA),e(qt),e(Rt),e(nA),e(Kt),e(Nt),e(pA),e(Ft),e(jA),e(Xt),e(Et),e(MA),e(Lt),e(yA),e(vt),e($t),e(FA),e(_t),e(BA),e(Ae),e(te),e(rA),e(ee),e(ae),e(mA),e(le),e(se),e(GA),e(ne),e(kA),e(ce),e(pe),e(wA),e(je),e(ie),e(Me),e(ye),e(XA),e(ge),e(Be),e(EA),e(oe),e(ZA),e(re),e(HA),e(ue),e(VA),e(me),e(Je),e(TA),e(Ge),e(ke),e(de),e(we),e(xe),e(SA),e(Ie),e(be),e(We),e(Ze),e(He),e(YA),e(Ve),e(he),e(vA)),e(r),g(m,A),g(J,A),g(k,A),g(I,A),g(b,A),g(W,A),g(Z,A),g(V,A),g(T,A),g(z,A),g(S,A),g(Q,A),g(P,A),g(q,A),g(X,A),g(L,A),g(_,A),g(tA,A),g(eA,A),g(sA,A),g(cA,A),g(iA,A),g(gA,A),g(oA,A),g(uA,A),g(JA,A),g(dA,A),g(xA,A),g(IA,A),g(bA,A),g(WA,A),g(hA,A),g(OA,A),g(UA,A),g(zA,A),g(fA,A),g(CA,A),g(DA,A),g(QA,A),g(PA,A),g(qA,A)}}}const za='{"title":"Diffusion for Audio","local":"diffusion-for-audio","sections":[{"title":"What you will learn:","local":"what-you-will-learn","sections":[],"depth":2},{"title":"Setup and Imports","local":"setup-and-imports","sections":[],"depth":2},{"title":"Sampling from a Pre-Trained Audio Pipeline","local":"sampling-from-a-pre-trained-audio-pipeline","sections":[],"depth":2},{"title":"From Audio to Image and Back Again","local":"from-audio-to-image-and-back-again","sections":[],"depth":2},{"title":"Fine-Tuning the pipeline","local":"fine-tuning-the-pipeline","sections":[],"depth":2},{"title":"Training Loop","local":"training-loop","sections":[],"depth":2},{"title":"Push to Hub","local":"push-to-hub","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function fa(Oe){return Wa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ya extends Za{constructor(r){super(),Ha(this,r,fa,Ua,Ia,{})}}export{Ya as component};
