import{s as Bs,n as Es,o as Ps}from"../chunks/scheduler.6062bdaf.js";import{S as Vs,i as Ws,g as i,s as l,r as u,A as Ys,h as c,f as a,c as n,j as Ds,u as r,x as p,k as zs,y as Ls,a as t,v as o,d as h,t as g,w as f}from"../chunks/index.4bca734e.js";import{C as E}from"../chunks/CodeBlock.fa01571c.js";import{H as W}from"../chunks/Heading.723dceba.js";function Ss(ws){let d,Y,P,L,m,S,_,vs=`The <code>huggingface_hub</code> library provides a Python interface to interact with Pull Requests and Discussions on the Hub.
Visit <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">the dedicated documentation page</a>
for a deeper view of what Discussions and Pull Requests on the Hub are, and how they work under the hood.`,Q,M,F,b,Js="The <code>HfApi</code> class allows you to retrieve Discussions and Pull Requests on a given repo:",K,j,O,y,Us="<code>HfApi.get_repo_discussions</code> supports filtering by author, type (Pull Request or Discussion) and status (<code>open</code> or <code>closed</code>):",ss,T,es,w,ks=`<code>HfApi.get_repo_discussions</code> returns a <a href="https://docs.python.org/3.7/howto/functional.html#generators" rel="nofollow">generator</a> that yields
<a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/community#huggingface_hub.Discussion">Discussion</a> objects. To get all the Discussions in a single list, run:`,as,v,ts,J,$s=`The <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/community#huggingface_hub.Discussion">Discussion</a> object returned by <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.get_repo_discussions">HfApi.get_repo_discussions()</a> contains high-level overview of the
Discussion or Pull Request. You can also get more detailed information using <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.get_discussion_details">HfApi.get_discussion_details()</a>:`,ls,U,ns,k,qs=`<a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.get_discussion_details">HfApi.get_discussion_details()</a> returns a <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a> object, which is a subclass of <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/community#huggingface_hub.Discussion">Discussion</a>
with more detailed information about the Discussion or Pull Request. Information includes all the comments, status changes,
and renames of the Discussion via <code>DiscussionWithDetails.events</code>.`,is,$,Hs=`In case of a Pull Request, you can retrieve the raw git diff with <code>DiscussionWithDetails.diff</code>. All the commits of the
Pull Request are listed in <code>DiscussionWithDetails.events</code>.`,cs,q,ps,H,Zs=`The <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> class also offers ways to create and edit Discussions and Pull Requests.
You will need an <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">access token</a> to create and edit Discussions
or Pull Requests.`,us,Z,Gs=`The simplest way to propose changes on a repo on the Hub is via the <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> API: just
set the <code>create_pr</code> parameter to <code>True</code>. This parameter is also available on other methods that wrap <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>:`,rs,G,As='<li><a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a></li> <li><a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a></li> <li><a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.delete_file">delete_file()</a></li> <li><a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.delete_folder">delete_folder()</a></li> <li><a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/cards#huggingface_hub.metadata_update">metadata_update()</a></li>',os,A,hs,R,Rs=`You can also use <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.create_discussion">HfApi.create_discussion()</a> (respectively <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.create_pull_request">HfApi.create_pull_request()</a>) to create a Discussion (respectively a Pull Request) on a repo.
Opening a Pull Request this way can be useful if you need to work on changes locally. Pull Requests opened this way will be in <code>&quot;draft&quot;</code> mode.`,gs,C,fs,X,Cs='Managing Pull Requests and Discussions can be done entirely with the <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> class. For example:',ds,I,Xs='<li><a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.comment_discussion">comment_discussion()</a> to add comments</li> <li><a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.edit_discussion_comment">edit_discussion_comment()</a> to edit comments</li> <li><a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.rename_discussion">rename_discussion()</a> to rename a Discussion or Pull Request</li> <li><a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.change_discussion_status">change_discussion_status()</a> to open or close a Discussion / Pull Request</li> <li><a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.merge_pull_request">merge_pull_request()</a> to merge a Pull Request</li>',ms,x,Is='Visit the <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> documentation page for an exhaustive reference of all available methods.',_s,N,Ms,D,xs="<em>Coming soon !</em>",bs,z,js,B,Ns='For a more detailed reference, visit the <a href="../package_reference/community">Discussions and Pull Requests</a> and the <a href="../package_reference/hf_api">hf_api</a> documentation page.',ys,V,Ts;return m=new W({props:{title:"Interact with Discussions and Pull Requests",local:"interact-with-discussions-and-pull-requests",headingTag:"h1"}}),M=new W({props:{title:"Retrieve Discussions and Pull Requests from the Hub",local:"retrieve-discussions-and-pull-requests-from-the-hub",headingTag:"h2"}}),j=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZm9yJTIwZGlzY3Vzc2lvbiUyMGluJTIwZ2V0X3JlcG9fZGlzY3Vzc2lvbnMocmVwb19pZCUzRCUyMmJpZ3NjaWVuY2UlMkZibG9vbSUyMiklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTdCZGlzY3Vzc2lvbi5udW0lN0QlMjAtJTIwJTdCZGlzY3Vzc2lvbi50aXRsZSU3RCUyQyUyMHByJTNBJTIwJTdCZGlzY3Vzc2lvbi5pc19wdWxsX3JlcXVlc3QlN0QlMjIpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> discussion <span class="hljs-keyword">in</span> get_repo_discussions(repo_id=<span class="hljs-string">&quot;bigscience/bloom&quot;</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{discussion.num}</span> - <span class="hljs-subst">{discussion.title}</span>, pr: <span class="hljs-subst">{discussion.is_pull_request}</span>&quot;</span>)

<span class="hljs-comment"># 11 - Add Flax weights, pr: True</span>
<span class="hljs-comment"># 10 - Update README.md, pr: True</span>
<span class="hljs-comment"># 9 - Training languages in the model card, pr: True</span>
<span class="hljs-comment"># 8 - Update tokenizer_config.json, pr: True</span>
<span class="hljs-comment"># 7 - Slurm training script, pr: False</span>
[...]`,wrap:!1}}),T=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZm9yJTIwZGlzY3Vzc2lvbiUyMGluJTIwZ2V0X3JlcG9fZGlzY3Vzc2lvbnMoJTBBJTIwJTIwJTIwcmVwb19pZCUzRCUyMmJpZ3NjaWVuY2UlMkZibG9vbSUyMiUyQyUwQSUyMCUyMCUyMGF1dGhvciUzRCUyMkFydGh1clolMjIlMkMlMEElMjAlMjAlMjBkaXNjdXNzaW9uX3R5cGUlM0QlMjJwdWxsX3JlcXVlc3QlMjIlMkMlMEElMjAlMjAlMjBkaXNjdXNzaW9uX3N0YXR1cyUzRCUyMm9wZW4lMjIlMkMlMEEpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU3QmRpc2N1c3Npb24ubnVtJTdEJTIwLSUyMCU3QmRpc2N1c3Npb24udGl0bGUlN0QlMjBieSUyMCU3QmRpc2N1c3Npb24uYXV0aG9yJTdEJTJDJTIwcHIlM0ElMjAlN0JkaXNjdXNzaW9uLmlzX3B1bGxfcmVxdWVzdCU3RCUyMiklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> discussion <span class="hljs-keyword">in</span> get_repo_discussions(
<span class="hljs-meta">... </span>   repo_id=<span class="hljs-string">&quot;bigscience/bloom&quot;</span>,
<span class="hljs-meta">... </span>   author=<span class="hljs-string">&quot;ArthurZ&quot;</span>,
<span class="hljs-meta">... </span>   discussion_type=<span class="hljs-string">&quot;pull_request&quot;</span>,
<span class="hljs-meta">... </span>   discussion_status=<span class="hljs-string">&quot;open&quot;</span>,
<span class="hljs-meta">... </span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{discussion.num}</span> - <span class="hljs-subst">{discussion.title}</span> by <span class="hljs-subst">{discussion.author}</span>, pr: <span class="hljs-subst">{discussion.is_pull_request}</span>&quot;</span>)

<span class="hljs-comment"># 19 - Add Flax weights by ArthurZ, pr: True</span>`,wrap:!1}}),v=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZGlzY3Vzc2lvbnNfbGlzdCUyMCUzRCUyMGxpc3QoZ2V0X3JlcG9fZGlzY3Vzc2lvbnMocmVwb19pZCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span>discussions_list = <span class="hljs-built_in">list</span>(get_repo_discussions(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>))`,wrap:!1}}),U=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9kaXNjdXNzaW9uX2RldGFpbHMlMEElMEFnZXRfZGlzY3Vzc2lvbl9kZXRhaWxzKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJiaWdzY2llbmNlJTJGYmxvb20tMWIzJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl9udW0lM0QyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_discussion_details

<span class="hljs-meta">&gt;&gt;&gt; </span>get_discussion_details(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;bigscience/bloom-1b3&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">2</span>
<span class="hljs-meta">... </span>)
DiscussionWithDetails(
    num=<span class="hljs-number">2</span>,
    author=<span class="hljs-string">&#x27;cakiki&#x27;</span>,
    title=<span class="hljs-string">&#x27;Update VRAM memory for the V100s&#x27;</span>,
    status=<span class="hljs-string">&#x27;open&#x27;</span>,
    is_pull_request=<span class="hljs-literal">True</span>,
    events=[
        DiscussionComment(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;comment&#x27;</span>, author=<span class="hljs-string">&#x27;cakiki&#x27;</span>, ...),
        DiscussionCommit(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;commit&#x27;</span>, author=<span class="hljs-string">&#x27;cakiki&#x27;</span>, summary=<span class="hljs-string">&#x27;Update VRAM memory for the V100s&#x27;</span>, oid=<span class="hljs-string">&#x27;1256f9d9a33fa8887e1c1bf0e09b4713da96773a&#x27;</span>, ...),
    ],
    conflicting_files=[],
    target_branch=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>,
    merge_commit_oid=<span class="hljs-literal">None</span>,
    diff=<span class="hljs-string">&#x27;diff --git a/README.md b/README.md\\nindex a6ae3b9294edf8d0eda0d67c7780a10241242a7e..3a1814f212bc3f0d3cc8f74bdbd316de4ae7b9e3 100644\\n--- a/README.md\\n+++ b/README.md\\n@@ -132,7 +132,7 [...]&#x27;</span>,
)`,wrap:!1}}),q=new W({props:{title:"Create and edit a Discussion or Pull Request programmatically",local:"create-and-edit-a-discussion-or-pull-request-programmatically",headingTag:"h2"}}),A=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQSUwQW1ldGFkYXRhX3VwZGF0ZSglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZyZXBvX25hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMnRhZ3MlMjIlM0ElMjAlNUIlMjJjb21wdXRlci12aXNpb24lMjIlMkMlMjAlMjJhd2Vzb21lLW1vZGVsJTIyJTVEJTdEJTJDJTBBJTIwJTIwJTIwJTIwY3JlYXRlX3ByJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update

<span class="hljs-meta">&gt;&gt;&gt; </span>metadata_update(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    metadata={<span class="hljs-string">&quot;tags&quot;</span>: [<span class="hljs-string">&quot;computer-vision&quot;</span>, <span class="hljs-string">&quot;awesome-model&quot;</span>]},
<span class="hljs-meta">... </span>    create_pr=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),C=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9kaXNjdXNzaW9uJTJDJTIwY3JlYXRlX3B1bGxfcmVxdWVzdCUwQSUwQWNyZWF0ZV9kaXNjdXNzaW9uKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRnJlcG8tbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIySGklMjBmcm9tJTIwdGhlJTIwaHVnZ2luZ2ZhY2VfaHViJTIwbGlicmFyeSElMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMiUzQ2luc2VydCUyMHlvdXIlMjBhY2Nlc3MlMjB0b2tlbiUyMGhlcmUlM0UlMjIlMkMlMEEpJTBBJTBBY3JlYXRlX3B1bGxfcmVxdWVzdCglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZyZXBvLW5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjB0aXRsZSUzRCUyMkhpJTIwZnJvbSUyMHRoZSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGxpYnJhcnkhJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW4lM0QlMjIlM0NpbnNlcnQlMjB5b3VyJTIwYWNjZXNzJTIwdG9rZW4lMjBoZXJlJTNFJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_discussion, create_pull_request

<span class="hljs-meta">&gt;&gt;&gt; </span>create_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo-name&quot;</span>,
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;Hi from the huggingface_hub library!&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;&lt;insert your access token here&gt;&quot;</span>,
<span class="hljs-meta">... </span>)
DiscussionWithDetails(...)

<span class="hljs-meta">&gt;&gt;&gt; </span>create_pull_request(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo-name&quot;</span>,
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;Hi from the huggingface_hub library!&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;&lt;insert your access token here&gt;&quot;</span>,
<span class="hljs-meta">... </span>)
DiscussionWithDetails(..., is_pull_request=<span class="hljs-literal">True</span>)`,wrap:!1}}),N=new W({props:{title:"Push changes to a Pull Request",local:"push-changes-to-a-pull-request",headingTag:"h2"}}),z=new W({props:{title:"See also",local:"see-also",headingTag:"h2"}}),{c(){d=i("meta"),Y=l(),P=i("p"),L=l(),u(m.$$.fragment),S=l(),_=i("p"),_.innerHTML=vs,Q=l(),u(M.$$.fragment),F=l(),b=i("p"),b.innerHTML=Js,K=l(),u(j.$$.fragment),O=l(),y=i("p"),y.innerHTML=Us,ss=l(),u(T.$$.fragment),es=l(),w=i("p"),w.innerHTML=ks,as=l(),u(v.$$.fragment),ts=l(),J=i("p"),J.innerHTML=$s,ls=l(),u(U.$$.fragment),ns=l(),k=i("p"),k.innerHTML=qs,is=l(),$=i("p"),$.innerHTML=Hs,cs=l(),u(q.$$.fragment),ps=l(),H=i("p"),H.innerHTML=Zs,us=l(),Z=i("p"),Z.innerHTML=Gs,rs=l(),G=i("ul"),G.innerHTML=As,os=l(),u(A.$$.fragment),hs=l(),R=i("p"),R.innerHTML=Rs,gs=l(),u(C.$$.fragment),fs=l(),X=i("p"),X.innerHTML=Cs,ds=l(),I=i("ul"),I.innerHTML=Xs,ms=l(),x=i("p"),x.innerHTML=Is,_s=l(),u(N.$$.fragment),Ms=l(),D=i("p"),D.innerHTML=xs,bs=l(),u(z.$$.fragment),js=l(),B=i("p"),B.innerHTML=Ns,ys=l(),V=i("p"),this.h()},l(s){const e=Ys("svelte-u9bgzb",document.head);d=c(e,"META",{name:!0,content:!0}),e.forEach(a),Y=n(s),P=c(s,"P",{}),Ds(P).forEach(a),L=n(s),r(m.$$.fragment,s),S=n(s),_=c(s,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1wn47li"&&(_.innerHTML=vs),Q=n(s),r(M.$$.fragment,s),F=n(s),b=c(s,"P",{"data-svelte-h":!0}),p(b)!=="svelte-6bkla6"&&(b.innerHTML=Js),K=n(s),r(j.$$.fragment,s),O=n(s),y=c(s,"P",{"data-svelte-h":!0}),p(y)!=="svelte-1ehry1x"&&(y.innerHTML=Us),ss=n(s),r(T.$$.fragment,s),es=n(s),w=c(s,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1bhbu7o"&&(w.innerHTML=ks),as=n(s),r(v.$$.fragment,s),ts=n(s),J=c(s,"P",{"data-svelte-h":!0}),p(J)!=="svelte-vkzw60"&&(J.innerHTML=$s),ls=n(s),r(U.$$.fragment,s),ns=n(s),k=c(s,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1htsk2c"&&(k.innerHTML=qs),is=n(s),$=c(s,"P",{"data-svelte-h":!0}),p($)!=="svelte-1pbvmum"&&($.innerHTML=Hs),cs=n(s),r(q.$$.fragment,s),ps=n(s),H=c(s,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1lll6vt"&&(H.innerHTML=Zs),us=n(s),Z=c(s,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1df4rj0"&&(Z.innerHTML=Gs),rs=n(s),G=c(s,"UL",{"data-svelte-h":!0}),p(G)!=="svelte-ybih79"&&(G.innerHTML=As),os=n(s),r(A.$$.fragment,s),hs=n(s),R=c(s,"P",{"data-svelte-h":!0}),p(R)!=="svelte-jsx12p"&&(R.innerHTML=Rs),gs=n(s),r(C.$$.fragment,s),fs=n(s),X=c(s,"P",{"data-svelte-h":!0}),p(X)!=="svelte-4n3675"&&(X.innerHTML=Cs),ds=n(s),I=c(s,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-vn2whp"&&(I.innerHTML=Xs),ms=n(s),x=c(s,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1f8h0k4"&&(x.innerHTML=Is),_s=n(s),r(N.$$.fragment,s),Ms=n(s),D=c(s,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1j277qo"&&(D.innerHTML=xs),bs=n(s),r(z.$$.fragment,s),js=n(s),B=c(s,"P",{"data-svelte-h":!0}),p(B)!=="svelte-19t3fo7"&&(B.innerHTML=Ns),ys=n(s),V=c(s,"P",{}),Ds(V).forEach(a),this.h()},h(){zs(d,"name","hf:doc:metadata"),zs(d,"content",Qs)},m(s,e){Ls(document.head,d),t(s,Y,e),t(s,P,e),t(s,L,e),o(m,s,e),t(s,S,e),t(s,_,e),t(s,Q,e),o(M,s,e),t(s,F,e),t(s,b,e),t(s,K,e),o(j,s,e),t(s,O,e),t(s,y,e),t(s,ss,e),o(T,s,e),t(s,es,e),t(s,w,e),t(s,as,e),o(v,s,e),t(s,ts,e),t(s,J,e),t(s,ls,e),o(U,s,e),t(s,ns,e),t(s,k,e),t(s,is,e),t(s,$,e),t(s,cs,e),o(q,s,e),t(s,ps,e),t(s,H,e),t(s,us,e),t(s,Z,e),t(s,rs,e),t(s,G,e),t(s,os,e),o(A,s,e),t(s,hs,e),t(s,R,e),t(s,gs,e),o(C,s,e),t(s,fs,e),t(s,X,e),t(s,ds,e),t(s,I,e),t(s,ms,e),t(s,x,e),t(s,_s,e),o(N,s,e),t(s,Ms,e),t(s,D,e),t(s,bs,e),o(z,s,e),t(s,js,e),t(s,B,e),t(s,ys,e),t(s,V,e),Ts=!0},p:Es,i(s){Ts||(h(m.$$.fragment,s),h(M.$$.fragment,s),h(j.$$.fragment,s),h(T.$$.fragment,s),h(v.$$.fragment,s),h(U.$$.fragment,s),h(q.$$.fragment,s),h(A.$$.fragment,s),h(C.$$.fragment,s),h(N.$$.fragment,s),h(z.$$.fragment,s),Ts=!0)},o(s){g(m.$$.fragment,s),g(M.$$.fragment,s),g(j.$$.fragment,s),g(T.$$.fragment,s),g(v.$$.fragment,s),g(U.$$.fragment,s),g(q.$$.fragment,s),g(A.$$.fragment,s),g(C.$$.fragment,s),g(N.$$.fragment,s),g(z.$$.fragment,s),Ts=!1},d(s){s&&(a(Y),a(P),a(L),a(S),a(_),a(Q),a(F),a(b),a(K),a(O),a(y),a(ss),a(es),a(w),a(as),a(ts),a(J),a(ls),a(ns),a(k),a(is),a($),a(cs),a(ps),a(H),a(us),a(Z),a(rs),a(G),a(os),a(hs),a(R),a(gs),a(fs),a(X),a(ds),a(I),a(ms),a(x),a(_s),a(Ms),a(D),a(bs),a(js),a(B),a(ys),a(V)),a(d),f(m,s),f(M,s),f(j,s),f(T,s),f(v,s),f(U,s),f(q,s),f(A,s),f(C,s),f(N,s),f(z,s)}}}const Qs='{"title":"Interact with Discussions and Pull Requests","local":"interact-with-discussions-and-pull-requests","sections":[{"title":"Retrieve Discussions and Pull Requests from the Hub","local":"retrieve-discussions-and-pull-requests-from-the-hub","sections":[],"depth":2},{"title":"Create and edit a Discussion or Pull Request programmatically","local":"create-and-edit-a-discussion-or-pull-request-programmatically","sections":[],"depth":2},{"title":"Push changes to a Pull Request","local":"push-changes-to-a-pull-request","sections":[],"depth":2},{"title":"See also","local":"see-also","sections":[],"depth":2}],"depth":1}';function Fs(ws){return Ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ae extends Vs{constructor(d){super(),Ws(this,d,Fs,Ss,Bs,{})}}export{ae as component};
