import{s as Tt,n as pt,o as yt}from"../chunks/scheduler.c59d9fbb.js";import{S as it,i as rt,g as i,s as a,r as J,A as ct,h as r,f as l,c as n,j as Ut,u as U,x as m,k as Mt,y as mt,a as e,v as M,d as T,t as p,w as y}from"../chunks/index.a47918e3.js";import{C as c}from"../chunks/CodeBlock.936db8cd.js";import{D as ot}from"../chunks/DocNotebookDropdown.c0ce911f.js";import{H as ts}from"../chunks/Heading.604bc707.js";function jt(vs){let o,as,ls,ns,j,Js,h,Us,g,Es="Your class names are likely already good descriptors of the text that you’re looking to classify. With 🤗 SetFit, you can use these class names with strong pretrained Sentence Transformer models to get a strong baseline model without any training samples.",Ms,w,Hs="This guide will show you how to perform zero-shot text classification.",Ts,d,ps,b,qs='We’ll use the <a href="https://huggingface.co/datasets/dair-ai/emotion" rel="nofollow">dair-ai/emotion</a> dataset to test the performance of our zero-shot model.',ys,k,is,u,Ds="This dataset stores the class names within the dataset <code>Features</code>, so we’ll extract the classes like so:",rs,f,cs,C,Ls="Otherwise, we could manually set the list of classes.",ms,I,os,$,Ps='Then, we can use <a href="/docs/setfit/main/en/reference/utility#setfit.get_templated_dataset">get_templated_dataset()</a> to synthetically generate a dummy dataset given these class names.',js,A,hs,Z,gs,x,ws,G,Ks="We can use this dataset to train a SetFit model just like normal:",ds,B,bs,z,ks,W,Os="Once trained, we can evaluate the model:",us,R,fs,X,Cs,N,st="And run predictions:",Is,Y,$s,_,As,Q,tt="These predictions all look right!",Zs,V,xs,F,lt="To show that the zero-shot performance of SetFit works well, we’ll compare it against a zero-shot classification model from <code>transformers</code>.",Gs,S,Bs,v,zs,E,et="With its 59.1% accuracy, the 0-shot SetFit heavily outperforms the recommended zero-shot model by <code>transformers</code>.",Ws,H,Rs,q,at="Beyond getting higher accuracies, SetFit is much faster too. Let’s compute the latency of SetFit with <code>BAAI/bge-small-en-v1.5</code> versus the latency of <code>transformers</code> with <code>facebook/bart-large-mnli</code>. Both tests were performed on a GPU.",Xs,D,Ns,L,Ys,P,_s,K,Qs,O,nt="So, SetFit with <code>BAAI/bge-small-en-v1.5</code> is 67x faster than <code>transformers</code> with <code>facebook/bart-large-mnli</code>, alongside being more accurate:",Vs,ss,Jt='<img src="https://github.com/huggingface/setfit/assets/37621491/33f574d9-c51b-4e02-8d98-6e04e18427ef" alt="zero_shot_transformers_vs_setfit"/>',Fs,es,Ss;return j=new ts({props:{title:"Zero-shot Text Classification",local:"zero-shot-text-classification",headingTag:"h1"}}),h=new ot({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/zero_shot.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/zero_shot.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/zero_shot.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/zero_shot.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/zero_shot.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/zero_shot.ipynb"}]}}),d=new ts({props:{title:"Testing dataset",local:"testing-dataset",headingTag:"h2"}}),k=new c({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmRhaXItYWklMkZlbW90aW9uJTIyJTJDJTIwJTIyc3BsaXQlMjIlMkMlMjBzcGxpdCUzRCUyMnRlc3QlMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

test_dataset = load_dataset(<span class="hljs-string">&quot;dair-ai/emotion&quot;</span>, <span class="hljs-string">&quot;split&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)`,wrap:!1}}),f=new c({props:{code:"Y2xhc3NlcyUyMCUzRCUyMHRlc3RfZGF0YXNldC5mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVELm5hbWVzJTBBJTIzJTIwJTNEJTNFJTIwJTVCJ3NhZG5lc3MnJTJDJTIwJ2pveSclMkMlMjAnbG92ZSclMkMlMjAnYW5nZXInJTJDJTIwJ2ZlYXInJTJDJTIwJ3N1cnByaXNlJyU1RA==",highlighted:`classes = test_dataset.features[<span class="hljs-string">&quot;label&quot;</span>].names
<span class="hljs-comment"># =&gt; [&#x27;sadness&#x27;, &#x27;joy&#x27;, &#x27;love&#x27;, &#x27;anger&#x27;, &#x27;fear&#x27;, &#x27;surprise&#x27;]</span>`,wrap:!1}}),I=new ts({props:{title:"Synthetic dataset",local:"synthetic-dataset",headingTag:"h2"}}),A=new c({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMGdldF90ZW1wbGF0ZWRfZGF0YXNldCUwQSUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBnZXRfdGVtcGxhdGVkX2RhdGFzZXQoKQ==",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> get_templated_dataset

train_dataset = get_templated_dataset()`,wrap:!1}}),Z=new c({props:{code:"cHJpbnQodHJhaW5fZGF0YXNldCklMEElMjMlMjAlM0QlM0UlMjBEYXRhc2V0KCU3QiUwQSUyMyUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3RleHQnJTJDJTIwJ2xhYmVsJyU1RCUyQyUwQSUyMyUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNDglMEElMjMlMjAlN0QpJTBBcHJpbnQodHJhaW5fZGF0YXNldCU1QjAlNUQpJTBBJTIzJTIwJTdCJ3RleHQnJTNBJTIwJ1RoaXMlMjBzZW50ZW5jZSUyMGlzJTIwc2FkbmVzcyclMkMlMjAnbGFiZWwnJTNBJTIwMCU3RA==",highlighted:`<span class="hljs-built_in">print</span>(train_dataset)
<span class="hljs-comment"># =&gt; Dataset({</span>
<span class="hljs-comment">#     features: [&#x27;text&#x27;, &#x27;label&#x27;],</span>
<span class="hljs-comment">#     num_rows: 48</span>
<span class="hljs-comment"># })</span>
<span class="hljs-built_in">print</span>(train_dataset[<span class="hljs-number">0</span>])
<span class="hljs-comment"># {&#x27;text&#x27;: &#x27;This sentence is sadness&#x27;, &#x27;label&#x27;: 0}</span>`,wrap:!1}}),x=new ts({props:{title:"Training",local:"training",headingTag:"h2"}}),B=new c({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTJDJTIwVHJhaW5lciUyQyUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyKSUwQSUwQWFyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBudW1fZXBvY2hzJTNEMSUyQyUwQSklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRGFyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHRlc3RfZGF0YXNldCUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, Trainer, TrainingArguments

model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)

args = TrainingArguments(
    batch_size=<span class="hljs-number">32</span>,
    num_epochs=<span class="hljs-number">1</span>,
)

trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
    eval_dataset=test_dataset,
)
trainer.train()`,wrap:!1}}),z=new c({props:{code:"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",highlighted:`***** Running training *****
  <span class="hljs-type">Num</span> <span class="hljs-variable">examples</span> <span class="hljs-operator">=</span> <span class="hljs-number">60</span>
  <span class="hljs-type">Num</span> <span class="hljs-variable">epochs</span> <span class="hljs-operator">=</span> <span class="hljs-number">1</span>
  Total <span class="hljs-type">optimization</span> <span class="hljs-variable">steps</span> <span class="hljs-operator">=</span> <span class="hljs-number">60</span>
  Total train <span class="hljs-type">batch</span> <span class="hljs-variable">size</span> <span class="hljs-operator">=</span> <span class="hljs-number">32</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2628</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">3.3333333333333333e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.02</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0222</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">3.7037037037037037e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.83</span>}                                                                                 
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">15.4717</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">124.098</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">3.878</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.0</span>}                                                     
<span class="hljs-number">100</span>%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">60</span>/<span class="hljs-number">60</span> [<span class="hljs-number">00</span>:09&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">6.</span>35it/s]`,wrap:!1}}),R=new c({props:{code:"bWV0cmljcyUyMCUzRCUyMHRyYWluZXIuZXZhbHVhdGUoKSUwQXByaW50KG1ldHJpY3Mp",highlighted:`metrics = trainer.evaluate()
<span class="hljs-built_in">print</span>(metrics)`,wrap:!1}}),X=new c({props:{code:"KioqKiolMjBSdW5uaW5nJTIwZXZhbHVhdGlvbiUyMCoqKioqJTBBJTdCJ2FjY3VyYWN5JyUzQSUyMDAuNTkxJTdE",highlighted:`<span class="hljs-bullet">***** </span>Running evaluation <span class="hljs-strong">*****</span>
{<span class="hljs-emphasis">&#x27;accuracy&#x27;</span>: 0.591}`,wrap:!1}}),Y=new c({props:{code:"cHJlZHMlMjAlM0QlMjBtb2RlbC5wcmVkaWN0KCU1QiUwQSUyMCUyMCUyMCUyMCUyMmklMjBhbSUyMGp1c3QlMjBmZWVsaW5nJTIwY3Jhbmt5JTIwYW5kJTIwYmx1ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmklMjBmZWVsJTIwaW5jcmVkaWJseSUyMGx1Y2t5JTIwanVzdCUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB0YWxrJTIwdG8lMjBoZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ5b3UncmUlMjBwaXNzaW5nJTIwbWUlMjBvZmYlMjByaWdodCUyMG5vdyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmklMjBkZWZpbml0ZWx5JTIwaGF2ZSUyMHRoYWxhc3NvcGhvYmlhJTJDJTIwZG9uJ3QlMjBnZXQlMjBtZSUyMG5lYXIlMjB3YXRlciUyMGxpa2UlMjB0aGF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaSUyMGRpZCUyMG5vdCUyMHNlZSUyMHRoYXQlMjBjb21pbmclMjBhdCUyMGFsbCUyMiUyQyUwQSU1RCklMEFwcmludCglNUJjbGFzc2VzJTVCaWR4JTVEJTIwZm9yJTIwaWR4JTIwaW4lMjBwcmVkcyU1RCk=",highlighted:`preds = model.predict([
    <span class="hljs-string">&quot;i am just feeling cranky and blue&quot;</span>,
    <span class="hljs-string">&quot;i feel incredibly lucky just to be able to talk to her&quot;</span>,
    <span class="hljs-string">&quot;you&#x27;re pissing me off right now&quot;</span>,
    <span class="hljs-string">&quot;i definitely have thalassophobia, don&#x27;t get me near water like that&quot;</span>,
    <span class="hljs-string">&quot;i did not see that coming at all&quot;</span>,
])
<span class="hljs-built_in">print</span>([classes[idx] <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> preds])`,wrap:!1}}),_=new c({props:{code:"JTVCJ3NhZG5lc3MnJTJDJTIwJ2pveSclMkMlMjAnYW5nZXInJTJDJTIwJ2ZlYXInJTJDJTIwJ3N1cnByaXNlJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;sadness&#x27;</span>, <span class="hljs-string">&#x27;joy&#x27;</span>, <span class="hljs-string">&#x27;anger&#x27;</span>, <span class="hljs-string">&#x27;fear&#x27;</span>, <span class="hljs-string">&#x27;surprise&#x27;</span>]',wrap:!1}}),V=new ts({props:{title:"Baseline",local:"baseline",headingTag:"h2"}}),S=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwZXZhbHVhdGUlMEElMEElMjMlMjBQcmVwYXJlJTIwdGhlJTIwdGVzdGluZyUyMGRhdGFzZXQlMEF0ZXN0X2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZGFpci1haSUyRmVtb3Rpb24lMjIlMkMlMjAlMjJzcGxpdCUyMiUyQyUyMHNwbGl0JTNEJTIydGVzdCUyMiklMEFjbGFzc2VzJTIwJTNEJTIwdGVzdF9kYXRhc2V0LmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXMlMEElMEElMjMlMjBTZXQlMjB1cCUyMHRoZSUyMHplcm8tc2hvdCUyMGNsYXNzaWZpY2F0aW9uJTIwcGlwZWxpbmUlMjBmcm9tJTIwdHJhbnNmb3JtZXJzJTBBJTIzJTIwVXNlcyUyMCdmYWNlYm9vayUyRmJhcnQtbGFyZ2UtbW5saSclMjBieSUyMGRlZmF1bHQlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwZGV2aWNlJTNEMCklMEF6ZXJvc2hvdF9wcmVkcyUyMCUzRCUyMHBpcGUodGVzdF9kYXRhc2V0JTVCJTIydGV4dCUyMiU1RCUyQyUyMGJhdGNoX3NpemUlM0QxNiUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMlM0RjbGFzc2VzKSUwQXByZWRzJTIwJTNEJTIwJTVCY2xhc3Nlcy5pbmRleChwcmVkJTVCJTIybGFiZWxzJTIyJTVEJTVCMCU1RCklMjBmb3IlMjBwcmVkJTIwaW4lMjB6ZXJvc2hvdF9wcmVkcyU1RCUwQSUwQSUyMyUyMENvbXB1dGUlMjB0aGUlMjBhY2N1cmFjeSUwQW1ldHJpYyUyMCUzRCUyMGV2YWx1YXRlLmxvYWQoJTIyYWNjdXJhY3klMjIpJTBBdHJhbnNmb3JtZXJzX2FjY3VyYWN5JTIwJTNEJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkcyUyQyUyMHJlZmVyZW5jZXMlM0R0ZXN0X2RhdGFzZXQlNUIlMjJsYWJlbCUyMiU1RCklMEFwcmludCh0cmFuc2Zvcm1lcnNfYWNjdXJhY3kp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate

<span class="hljs-comment"># Prepare the testing dataset</span>
test_dataset = load_dataset(<span class="hljs-string">&quot;dair-ai/emotion&quot;</span>, <span class="hljs-string">&quot;split&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)
classes = test_dataset.features[<span class="hljs-string">&quot;label&quot;</span>].names

<span class="hljs-comment"># Set up the zero-shot classification pipeline from transformers</span>
<span class="hljs-comment"># Uses &#x27;facebook/bart-large-mnli&#x27; by default</span>
pipe = pipeline(<span class="hljs-string">&quot;zero-shot-classification&quot;</span>, device=<span class="hljs-number">0</span>)
zeroshot_preds = pipe(test_dataset[<span class="hljs-string">&quot;text&quot;</span>], batch_size=<span class="hljs-number">16</span>, candidate_labels=classes)
preds = [classes.index(pred[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]) <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> zeroshot_preds]

<span class="hljs-comment"># Compute the accuracy</span>
metric = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)
transformers_accuracy = metric.compute(predictions=preds, references=test_dataset[<span class="hljs-string">&quot;label&quot;</span>])
<span class="hljs-built_in">print</span>(transformers_accuracy)`,wrap:!1}}),v=new c({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuMzc2NSU3RA==",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.3765</span>}',wrap:!1}}),H=new ts({props:{title:"Prediction latency",local:"prediction-latency",headingTag:"h2"}}),D=new c({props:{code:"aW1wb3J0JTIwdGltZSUwQSUwQXN0YXJ0X3QlMjAlM0QlMjB0aW1lLnRpbWUoKSUwQXBpcGUodGVzdF9kYXRhc2V0JTVCJTIydGV4dCUyMiU1RCUyQyUyMGJhdGNoX3NpemUlM0QzMiUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMlM0RjbGFzc2VzKSUwQWRlbHRhX3QlMjAlM0QlMjB0aW1lLnRpbWUoKSUyMC0lMjBzdGFydF90JTBBcHJpbnQoZiUyMiU2MHRyYW5zZm9ybWVycyU2MCUyMHdpdGglMjAlNjBmYWNlYm9vayUyRmJhcnQtbGFyZ2UtbW5saSU2MCUyMGxhdGVuY3klM0ElMjAlN0JkZWx0YV90JTIwJTJGJTIwbGVuKHRlc3RfZGF0YXNldCU1Qid0ZXh0JyU1RCklMjAqJTIwMTAwMCUzQS40ZiU3RG1zJTIwcGVyJTIwc2VudGVuY2UlMjIp",highlighted:`<span class="hljs-keyword">import</span> time

start_t = time.time()
pipe(test_dataset[<span class="hljs-string">&quot;text&quot;</span>], batch_size=<span class="hljs-number">32</span>, candidate_labels=classes)
delta_t = time.time() - start_t
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\`transformers\` with \`facebook/bart-large-mnli\` latency: <span class="hljs-subst">{delta_t / <span class="hljs-built_in">len</span>(test_dataset[<span class="hljs-string">&#x27;text&#x27;</span>]) * <span class="hljs-number">1000</span>:<span class="hljs-number">.4</span>f}</span>ms per sentence&quot;</span>)`,wrap:!1}}),L=new c({props:{code:"JTYwdHJhbnNmb3JtZXJzJTYwJTIwd2l0aCUyMCU2MGZhY2Vib29rJTJGYmFydC1sYXJnZS1tbmxpJTYwJTIwbGF0ZW5jeSUzQSUyMDMxLjE3NjVtcyUyMHBlciUyMHNlbnRlbmNl",highlighted:'`transformers` with `facebook/bart-large-mnli` latency: <span class="hljs-number">31.1765</span>ms per sentence',wrap:!1}}),P=new c({props:{code:"aW1wb3J0JTIwdGltZSUwQSUwQXN0YXJ0X3QlMjAlM0QlMjB0aW1lLnRpbWUoKSUwQW1vZGVsLnByZWRpY3QodGVzdF9kYXRhc2V0JTVCJTIydGV4dCUyMiU1RCklMEFkZWx0YV90JTIwJTNEJTIwdGltZS50aW1lKCklMjAtJTIwc3RhcnRfdCUwQXByaW50KGYlMjJTZXRGaXQlMjB3aXRoJTIwJTYwQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTYwJTIwbGF0ZW5jeSUzQSUyMCU3QmRlbHRhX3QlMjAlMkYlMjBsZW4odGVzdF9kYXRhc2V0JTVCJ3RleHQnJTVEKSUyMColMjAxMDAwJTNBLjRmJTdEbXMlMjBwZXIlMjBzZW50ZW5jZSUyMik=",highlighted:`<span class="hljs-keyword">import</span> time

start_t = time.time()
model.predict(test_dataset[<span class="hljs-string">&quot;text&quot;</span>])
delta_t = time.time() - start_t
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;SetFit with \`BAAI/bge-small-en-v1.5\` latency: <span class="hljs-subst">{delta_t / <span class="hljs-built_in">len</span>(test_dataset[<span class="hljs-string">&#x27;text&#x27;</span>]) * <span class="hljs-number">1000</span>:<span class="hljs-number">.4</span>f}</span>ms per sentence&quot;</span>)`,wrap:!1}}),K=new c({props:{code:"U2V0Rml0JTIwd2l0aCUyMCU2MEJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSU2MCUyMGxhdGVuY3klM0ElMjAwLjQ2MDBtcyUyMHBlciUyMHNlbnRlbmNl",highlighted:'<span class="hljs-attribute">SetFit</span> with `BAAI/bge-small-en-v1.<span class="hljs-number">5</span>` latency: <span class="hljs-number">0</span>.<span class="hljs-number">4600</span>ms per sentence',wrap:!1}}),{c(){o=i("meta"),as=a(),ls=i("p"),ns=a(),J(j.$$.fragment),Js=a(),J(h.$$.fragment),Us=a(),g=i("p"),g.textContent=Es,Ms=a(),w=i("p"),w.textContent=Hs,Ts=a(),J(d.$$.fragment),ps=a(),b=i("p"),b.innerHTML=qs,ys=a(),J(k.$$.fragment),is=a(),u=i("p"),u.innerHTML=Ds,rs=a(),J(f.$$.fragment),cs=a(),C=i("p"),C.textContent=Ls,ms=a(),J(I.$$.fragment),os=a(),$=i("p"),$.innerHTML=Ps,js=a(),J(A.$$.fragment),hs=a(),J(Z.$$.fragment),gs=a(),J(x.$$.fragment),ws=a(),G=i("p"),G.textContent=Ks,ds=a(),J(B.$$.fragment),bs=a(),J(z.$$.fragment),ks=a(),W=i("p"),W.textContent=Os,us=a(),J(R.$$.fragment),fs=a(),J(X.$$.fragment),Cs=a(),N=i("p"),N.textContent=st,Is=a(),J(Y.$$.fragment),$s=a(),J(_.$$.fragment),As=a(),Q=i("p"),Q.textContent=tt,Zs=a(),J(V.$$.fragment),xs=a(),F=i("p"),F.innerHTML=lt,Gs=a(),J(S.$$.fragment),Bs=a(),J(v.$$.fragment),zs=a(),E=i("p"),E.innerHTML=et,Ws=a(),J(H.$$.fragment),Rs=a(),q=i("p"),q.innerHTML=at,Xs=a(),J(D.$$.fragment),Ns=a(),J(L.$$.fragment),Ys=a(),J(P.$$.fragment),_s=a(),J(K.$$.fragment),Qs=a(),O=i("p"),O.innerHTML=nt,Vs=a(),ss=i("p"),ss.innerHTML=Jt,Fs=a(),es=i("p"),this.h()},l(s){const t=ct("svelte-u9bgzb",document.head);o=r(t,"META",{name:!0,content:!0}),t.forEach(l),as=n(s),ls=r(s,"P",{}),Ut(ls).forEach(l),ns=n(s),U(j.$$.fragment,s),Js=n(s),U(h.$$.fragment,s),Us=n(s),g=r(s,"P",{"data-svelte-h":!0}),m(g)!=="svelte-u49hsh"&&(g.textContent=Es),Ms=n(s),w=r(s,"P",{"data-svelte-h":!0}),m(w)!=="svelte-13fxshi"&&(w.textContent=Hs),Ts=n(s),U(d.$$.fragment,s),ps=n(s),b=r(s,"P",{"data-svelte-h":!0}),m(b)!=="svelte-1i80jyz"&&(b.innerHTML=qs),ys=n(s),U(k.$$.fragment,s),is=n(s),u=r(s,"P",{"data-svelte-h":!0}),m(u)!=="svelte-1gwdkg3"&&(u.innerHTML=Ds),rs=n(s),U(f.$$.fragment,s),cs=n(s),C=r(s,"P",{"data-svelte-h":!0}),m(C)!=="svelte-2dxojw"&&(C.textContent=Ls),ms=n(s),U(I.$$.fragment,s),os=n(s),$=r(s,"P",{"data-svelte-h":!0}),m($)!=="svelte-1n14wev"&&($.innerHTML=Ps),js=n(s),U(A.$$.fragment,s),hs=n(s),U(Z.$$.fragment,s),gs=n(s),U(x.$$.fragment,s),ws=n(s),G=r(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-10h3047"&&(G.textContent=Ks),ds=n(s),U(B.$$.fragment,s),bs=n(s),U(z.$$.fragment,s),ks=n(s),W=r(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-24emgz"&&(W.textContent=Os),us=n(s),U(R.$$.fragment,s),fs=n(s),U(X.$$.fragment,s),Cs=n(s),N=r(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-io97e0"&&(N.textContent=st),Is=n(s),U(Y.$$.fragment,s),$s=n(s),U(_.$$.fragment,s),As=n(s),Q=r(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-16fgheu"&&(Q.textContent=tt),Zs=n(s),U(V.$$.fragment,s),xs=n(s),F=r(s,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1xcvsej"&&(F.innerHTML=lt),Gs=n(s),U(S.$$.fragment,s),Bs=n(s),U(v.$$.fragment,s),zs=n(s),E=r(s,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1anyja6"&&(E.innerHTML=et),Ws=n(s),U(H.$$.fragment,s),Rs=n(s),q=r(s,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1a47b37"&&(q.innerHTML=at),Xs=n(s),U(D.$$.fragment,s),Ns=n(s),U(L.$$.fragment,s),Ys=n(s),U(P.$$.fragment,s),_s=n(s),U(K.$$.fragment,s),Qs=n(s),O=r(s,"P",{"data-svelte-h":!0}),m(O)!=="svelte-n991oh"&&(O.innerHTML=nt),Vs=n(s),ss=r(s,"P",{"data-svelte-h":!0}),m(ss)!=="svelte-bqzz6k"&&(ss.innerHTML=Jt),Fs=n(s),es=r(s,"P",{}),Ut(es).forEach(l),this.h()},h(){Mt(o,"name","hf:doc:metadata"),Mt(o,"content",ht)},m(s,t){mt(document.head,o),e(s,as,t),e(s,ls,t),e(s,ns,t),M(j,s,t),e(s,Js,t),M(h,s,t),e(s,Us,t),e(s,g,t),e(s,Ms,t),e(s,w,t),e(s,Ts,t),M(d,s,t),e(s,ps,t),e(s,b,t),e(s,ys,t),M(k,s,t),e(s,is,t),e(s,u,t),e(s,rs,t),M(f,s,t),e(s,cs,t),e(s,C,t),e(s,ms,t),M(I,s,t),e(s,os,t),e(s,$,t),e(s,js,t),M(A,s,t),e(s,hs,t),M(Z,s,t),e(s,gs,t),M(x,s,t),e(s,ws,t),e(s,G,t),e(s,ds,t),M(B,s,t),e(s,bs,t),M(z,s,t),e(s,ks,t),e(s,W,t),e(s,us,t),M(R,s,t),e(s,fs,t),M(X,s,t),e(s,Cs,t),e(s,N,t),e(s,Is,t),M(Y,s,t),e(s,$s,t),M(_,s,t),e(s,As,t),e(s,Q,t),e(s,Zs,t),M(V,s,t),e(s,xs,t),e(s,F,t),e(s,Gs,t),M(S,s,t),e(s,Bs,t),M(v,s,t),e(s,zs,t),e(s,E,t),e(s,Ws,t),M(H,s,t),e(s,Rs,t),e(s,q,t),e(s,Xs,t),M(D,s,t),e(s,Ns,t),M(L,s,t),e(s,Ys,t),M(P,s,t),e(s,_s,t),M(K,s,t),e(s,Qs,t),e(s,O,t),e(s,Vs,t),e(s,ss,t),e(s,Fs,t),e(s,es,t),Ss=!0},p:pt,i(s){Ss||(T(j.$$.fragment,s),T(h.$$.fragment,s),T(d.$$.fragment,s),T(k.$$.fragment,s),T(f.$$.fragment,s),T(I.$$.fragment,s),T(A.$$.fragment,s),T(Z.$$.fragment,s),T(x.$$.fragment,s),T(B.$$.fragment,s),T(z.$$.fragment,s),T(R.$$.fragment,s),T(X.$$.fragment,s),T(Y.$$.fragment,s),T(_.$$.fragment,s),T(V.$$.fragment,s),T(S.$$.fragment,s),T(v.$$.fragment,s),T(H.$$.fragment,s),T(D.$$.fragment,s),T(L.$$.fragment,s),T(P.$$.fragment,s),T(K.$$.fragment,s),Ss=!0)},o(s){p(j.$$.fragment,s),p(h.$$.fragment,s),p(d.$$.fragment,s),p(k.$$.fragment,s),p(f.$$.fragment,s),p(I.$$.fragment,s),p(A.$$.fragment,s),p(Z.$$.fragment,s),p(x.$$.fragment,s),p(B.$$.fragment,s),p(z.$$.fragment,s),p(R.$$.fragment,s),p(X.$$.fragment,s),p(Y.$$.fragment,s),p(_.$$.fragment,s),p(V.$$.fragment,s),p(S.$$.fragment,s),p(v.$$.fragment,s),p(H.$$.fragment,s),p(D.$$.fragment,s),p(L.$$.fragment,s),p(P.$$.fragment,s),p(K.$$.fragment,s),Ss=!1},d(s){s&&(l(as),l(ls),l(ns),l(Js),l(Us),l(g),l(Ms),l(w),l(Ts),l(ps),l(b),l(ys),l(is),l(u),l(rs),l(cs),l(C),l(ms),l(os),l($),l(js),l(hs),l(gs),l(ws),l(G),l(ds),l(bs),l(ks),l(W),l(us),l(fs),l(Cs),l(N),l(Is),l($s),l(As),l(Q),l(Zs),l(xs),l(F),l(Gs),l(Bs),l(zs),l(E),l(Ws),l(Rs),l(q),l(Xs),l(Ns),l(Ys),l(_s),l(Qs),l(O),l(Vs),l(ss),l(Fs),l(es)),l(o),y(j,s),y(h,s),y(d,s),y(k,s),y(f,s),y(I,s),y(A,s),y(Z,s),y(x,s),y(B,s),y(z,s),y(R,s),y(X,s),y(Y,s),y(_,s),y(V,s),y(S,s),y(v,s),y(H,s),y(D,s),y(L,s),y(P,s),y(K,s)}}}const ht='{"title":"Zero-shot Text Classification","local":"zero-shot-text-classification","sections":[{"title":"Testing dataset","local":"testing-dataset","sections":[],"depth":2},{"title":"Synthetic dataset","local":"synthetic-dataset","sections":[],"depth":2},{"title":"Training","local":"training","sections":[],"depth":2},{"title":"Baseline","local":"baseline","sections":[],"depth":2},{"title":"Prediction latency","local":"prediction-latency","sections":[],"depth":2}],"depth":1}';function gt(vs){return yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ft extends it{constructor(o){super(),rt(this,o,gt,jt,Tt,{})}}export{ft as component};
