import{s as Rt,o as Gt,n as Le}from"../chunks/scheduler.25b97de1.js";import{S as Xt,i as At,g as l,s as a,r as m,A as Vt,h as c,f as o,c as s,j as q,u as h,x as u,k as P,y as i,a as r,v as f,d as g,t as _,w as b}from"../chunks/index.d9030fc9.js";import{T as bt}from"../chunks/Tip.baa67368.js";import{D as pe}from"../chunks/Docstring.e257edda.js";import{C as vt}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Bt}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as xe,E as Et}from"../chunks/EditOnGithub.91d95064.js";function Yt(S){let n,p;return n=new vt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN0YXJjb2RlcjJNb2RlbCUyQyUyMFN0YXJjb2RlcjJDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3RhcmNvZGVyMiUyMDdCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFN0YXJjb2RlcjJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBTdGFyY29kZXIyJTIwN0IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFN0YXJjb2RlcjJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Starcoder2Model, Starcoder2Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Starcoder2 7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Starcoder2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Starcoder2 7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Starcoder2Model(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){m(n.$$.fragment)},l(d){h(n.$$.fragment,d)},m(d,v){f(n,d,v),p=!0},p:Le,i(d){p||(g(n.$$.fragment,d),p=!0)},o(d){_(n.$$.fragment,d),p=!1},d(d){b(n,d)}}}function Ot(S){let n,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=l("p"),n.innerHTML=p},l(d){n=c(d,"P",{"data-svelte-h":!0}),u(n)!=="svelte-fincs2"&&(n.innerHTML=p)},m(d,v){r(d,n,v)},p:Le,d(d){d&&o(n)}}}function Dt(S){let n,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=l("p"),n.innerHTML=p},l(d){n=c(d,"P",{"data-svelte-h":!0}),u(n)!=="svelte-fincs2"&&(n.innerHTML=p)},m(d,v){r(d,n,v)},p:Le,d(d){d&&o(n)}}}function Qt(S){let n,p="Example:",d,v,$;return v=new vt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTdGFyY29kZXIyRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyMFN0YXJjb2RlcjJGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRnN0YXJjb2RlcjItN2JfMTZrJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ2NvZGUlMkZzdGFyY29kZXIyLTdiXzE2ayUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Starcoder2ForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Starcoder2ForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b_16k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b_16k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){n=l("p"),n.textContent=p,d=a(),m(v.$$.fragment)},l(y){n=c(y,"P",{"data-svelte-h":!0}),u(n)!=="svelte-11lpom8"&&(n.textContent=p),d=s(y),h(v.$$.fragment,y)},m(y,x){r(y,n,x),r(y,d,x),f(v,y,x),$=!0},p:Le,i(y){$||(g(v.$$.fragment,y),$=!0)},o(y){_(v.$$.fragment,y),$=!1},d(y){y&&(o(n),o(d)),b(v,y)}}}function Kt(S){let n,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=l("p"),n.innerHTML=p},l(d){n=c(d,"P",{"data-svelte-h":!0}),u(n)!=="svelte-fincs2"&&(n.innerHTML=p)},m(d,v){r(d,n,v)},p:Le,d(d){d&&o(n)}}}function eo(S){let n,p,d,v,$,y,x,je,G,yt='StarCoder2 is a family of open LLMs for code and comes in 3 different sizes with 3B, 7B and 15B parameters. The flagship StarCoder2-15B model is trained on over 4 trillion tokens and 600+ programming languages from The Stack v2. All models use Grouped Query Attention, a context window of 16,384 tokens with a sliding window attention of 4,096 tokens, and were trained using the Fill-in-the-Middle objective. The models have been released with the paper <a href="https://arxiv.org/abs/2402.19173" rel="nofollow">StarCoder 2 and The Stack v2: The Next Generation</a> by Anton Lozhkov, Raymond Li, Loubna Ben Allal, Federico Cassano, Joel Lamy-Poirier, Nouamane Tazi, Ao Tang, Dmytro Pykhtar, Jiawei Liu, Yuxiang Wei, Tianyang Liu, Max Tian, Denis Kocetkov, Arthur Zucker, Younes Belkada, Zijian Wang, Qian Liu, Dmitry Abulkhanov, Indraneil Paul, Zhuang Li, Wen-Ding Li, Megan Risdal, Jia Li, Jian Zhu, Terry Yue Zhuo, Evgenii Zheltonozhskii, Nii Osae Osae Dade, Wenhao Yu, Lucas Krauß, Naman Jain, Yixuan Su, Xuanli He, Manan Dey, Edoardo Abati, Yekun Chai, Niklas Muennighoff, Xiangru Tang, Muhtasham Oblokulov, Christopher Akiki, Marc Marone, Chenghao Mou, Mayank Mishra, Alex Gu, Binyuan Hui, Tri Dao, Armel Zebaze, Olivier Dehaene, Nicolas Patry, Canwen Xu, Julian McAuley, Han Hu, Torsten Scholak, Sebastien Paquet, Jennifer Robinson, Carolyn Jane Anderson, Nicolas Chapados, Mostofa Patwary, Nima Tajbakhsh, Yacine Jernite, Carlos Muñoz Ferrandis, Lingming Zhang, Sean Hughes, Thomas Wolf, Arjun Guha, Leandro von Werra, and Harm de Vries.',Fe,X,kt="The abstract of the paper is the following:",qe,J,me,Tt="The BigCode project, an open-scientific collaboration focused on the responsible development of Large Language Models for Code (Code LLMs), introduces StarCoder2. In partnership with Software Heritage (SWH), we build The Stack v2 on top of the digital commons of their source code archive. Alongside the SWH repositories spanning 619 programming languages, we carefully select other high-quality data sources, such as GitHub pull requests, Kaggle notebooks, and code documentation. This results in a training set that is 4x larger than the first StarCoder dataset. We train StarCoder2 models with 3B, 7B, and 15B parameters on 3.3 to 4.3 trillion tokens and thoroughly evaluate them on a comprehensive set of Code LLM benchmarks. We find that our small model, StarCoder2-3B, outperforms other Code LLMs of similar size on most benchmarks, and also outperforms StarCoderBase-15B. Our large model, StarCoder2- 15B, significantly outperforms other models of comparable size. In addition, it matches or outperforms CodeLlama-34B, a model more than twice its size. Although DeepSeekCoder- 33B is the best-performing model at code completion for high-resource languages, we find that StarCoder2-15B outperforms it on math and code reasoning benchmarks, as well as several low-resource languages. We make the model weights available under an OpenRAIL license and ensure full transparency regarding the training data by releasing the SoftWare Heritage persistent IDentifiers (SWHIDs) of the source code data.",Oe,A,Ie,V,wt='The models are licensed under the <a href="https://huggingface.co/spaces/bigcode/bigcode-model-license-agreement" rel="nofollow">BigCode OpenRAIL-M v1 license agreement</a>.',Ue,E,Pe,Y,Mt='The StarCoder2 models can be found in the <a href="https://huggingface.co/collections/bigcode/starcoder2-65de6da6e87db3383572be1a" rel="nofollow">HuggingFace hub</a>. You can find some examples for inference and fine-tuning in StarCoder2’s <a href="https://github.com/bigcode-project/starcoder2" rel="nofollow">GitHub repo</a>.',Je,O,Ct="These ready-to-use checkpoints can be downloaded and used via the HuggingFace Hub:",We,D,Ze,Q,He,M,K,De,he,St=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.41.3/en/model_doc/starcoder2#transformers.Starcoder2Model">Starcoder2Model</a>. It is used to instantiate a
Starcoder2 model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/bigcode/starcoder2-7b_16k" rel="nofollow">bigcode/starcoder2-7b_16k</a> model.`,Qe,fe,$t=`Configuration objects inherit from <a href="/docs/transformers/v4.41.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.41.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ke,W,Ne,ee,zt="## Starcoder2Model[[transformers.Starcoder2Model]]",Be,T,te,et,ge,xt=`The bare Starcoder2 Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/v4.41.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,tt,_e,Lt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ot,be,jt="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>Starcoder2DecoderLayer</code>",nt,j,oe,at,ve,Ft='The <a href="/docs/transformers/v4.41.3/en/model_doc/starcoder2#transformers.Starcoder2Model">Starcoder2Model</a> forward method, overrides the <code>__call__</code> special method.',st,Z,Re,ne,qt="## Starcoder2ForCausalLM[[transformers.Starcoder2ForCausalLM]]",Ge,I,ae,rt,z,se,it,ye,It='The <a href="/docs/transformers/v4.41.3/en/model_doc/starcoder2#transformers.Starcoder2ForCausalLM">Starcoder2ForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',dt,H,lt,N,Xe,re,Ut="## Starcoder2ForSequenceClassification[[transformers.Starcoder2ForSequenceClassification]]",Ae,k,ie,ct,ke,Pt="The Starcoder2 Model transformer with a sequence classification head on top (linear layer).",ut,Te,Jt=`<a href="/docs/transformers/v4.41.3/en/model_doc/starcoder2#transformers.Starcoder2ForSequenceClassification">Starcoder2ForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,pt,we,Wt=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,mt,Me,Zt=`This model inherits from <a href="/docs/transformers/v4.41.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ht,Ce,Ht=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ft,F,de,gt,Se,Nt='The <a href="/docs/transformers/v4.41.3/en/model_doc/starcoder2#transformers.Starcoder2ForSequenceClassification">Starcoder2ForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',_t,B,Ve,le,Ee,ze,Ye;return $=new xe({props:{title:"Starcoder2",local:"starcoder2",headingTag:"h1"}}),x=new xe({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new xe({props:{title:"License",local:"license",headingTag:"h2"}}),E=new xe({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),D=new vt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ2NvZGUlMkZzdGFyY29kZXIyLTdiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRnN0YXJjb2RlcjItN2IlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZGVmJTIwcHJpbnRfaGVsbG9fd29ybGQoKSUzQSUyMiUwQSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUJwcm9tcHQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;def print_hello_world():&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([prompt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">10</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;def print_hello_world():\\n    print(&quot;Hello World!&quot;)\\n\\ndef print&#x27;</span>`,wrap:!1}}),Q=new xe({props:{title:"Starcoder2Config",local:"transformers.Starcoder2Config",headingTag:"h2"}}),K=new pe({props:{name:"class transformers.Starcoder2Config",anchor:"transformers.Starcoder2Config",parameters:[{name:"vocab_size",val:" = 49152"},{name:"hidden_size",val:" = 3072"},{name:"intermediate_size",val:" = 12288"},{name:"num_hidden_layers",val:" = 30"},{name:"num_attention_heads",val:" = 24"},{name:"num_key_value_heads",val:" = 2"},{name:"hidden_act",val:" = 'gelu_pytorch_tanh'"},{name:"max_position_embeddings",val:" = 4096"},{name:"initializer_range",val:" = 0.018042"},{name:"norm_epsilon",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"bos_token_id",val:" = 50256"},{name:"eos_token_id",val:" = 50256"},{name:"rope_theta",val:" = 10000.0"},{name:"sliding_window",val:" = None"},{name:"attention_dropout",val:" = 0.0"},{name:"residual_dropout",val:" = 0.0"},{name:"embedding_dropout",val:" = 0.0"},{name:"use_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Starcoder2Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 49152) &#x2014;
Vocabulary size of the Starcoder2 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.41.3/en/model_doc/starcoder2#transformers.Starcoder2Model">Starcoder2Model</a>`,name:"vocab_size"},{anchor:"transformers.Starcoder2Config.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.Starcoder2Config.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 12288) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.Starcoder2Config.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 30) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Starcoder2Config.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Starcoder2Config.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details checkout [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>8\`.`,name:"num_key_value_heads"},{anchor:"transformers.Starcoder2Config.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu_pytorch_tanh&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.Starcoder2Config.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model might ever be used with. Starcoder2&#x2019;s sliding window attention
allows sequence of up to 4096*32 tokens.`,name:"max_position_embeddings"},{anchor:"transformers.Starcoder2Config.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Starcoder2Config.norm_epsilon",description:`<strong>norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
Epsilon value for the layer norm`,name:"norm_epsilon"},{anchor:"transformers.Starcoder2Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.Starcoder2Config.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 50256) &#x2014;
The id of the &#x201C;beginning-of-sequence&#x201D; token.`,name:"bos_token_id"},{anchor:"transformers.Starcoder2Config.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 50256) &#x2014;
The id of the &#x201C;end-of-sequence&#x201D; token.`,name:"eos_token_id"},{anchor:"transformers.Starcoder2Config.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.Starcoder2Config.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Sliding window attention window size. If not specified, will default to <code>None</code> (no sliding window).`,name:"sliding_window"},{anchor:"transformers.Starcoder2Config.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Starcoder2Config.residual_dropout",description:`<strong>residual_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Residual connection dropout value.`,name:"residual_dropout"},{anchor:"transformers.Starcoder2Config.embedding_dropout",description:`<strong>embedding_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Embedding dropout.`,name:"embedding_dropout"},{anchor:"transformers.Starcoder2Config.use_bias",description:`<strong>use_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias term on linear layers of the model.`,name:"use_bias"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/starcoder2/configuration_starcoder2.py#L24"}}),W=new Bt({props:{anchor:"transformers.Starcoder2Config.example",$$slots:{default:[Yt]},$$scope:{ctx:S}}}),te=new pe({props:{name:"class transformers.Starcoder2Model",anchor:"transformers.Starcoder2Model",parameters:[{name:"config",val:": Starcoder2Config"}],parametersDescription:[{anchor:"transformers.Starcoder2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.3/en/model_doc/starcoder2#transformers.Starcoder2Config">Starcoder2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.41.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; Starcoder2Config`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/starcoder2/modeling_starcoder2.py#L867"}}),oe=new pe({props:{name:"forward",anchor:"transformers.Starcoder2Model.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Starcoder2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.41.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.41.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.41.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Starcoder2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.41.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.41.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.41.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Starcoder2Model.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Starcoder2Model.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/v4.41.3/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Starcoder2Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Starcoder2Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Starcoder2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Starcoder2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Starcoder2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.41.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/starcoder2/modeling_starcoder2.py#L901"}}),Z=new bt({props:{$$slots:{default:[Ot]},$$scope:{ctx:S}}}),ae=new pe({props:{name:"class transformers.Starcoder2ForCausalLM",anchor:"transformers.Starcoder2ForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/starcoder2/modeling_starcoder2.py#L1052"}}),se=new pe({props:{name:"forward",anchor:"transformers.Starcoder2ForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Starcoder2ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.41.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.41.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.41.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Starcoder2ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.41.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.41.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.41.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Starcoder2ForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Starcoder2ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/v4.41.3/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Starcoder2ForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Starcoder2ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Starcoder2ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Starcoder2ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Starcoder2ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.41.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/starcoder2/modeling_starcoder2.py#L1082",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.41.3/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.41.3/en/model_doc/starcoder2#transformers.Starcoder2Config"
>Starcoder2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.41.3/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),H=new bt({props:{$$slots:{default:[Dt]},$$scope:{ctx:S}}}),N=new Bt({props:{anchor:"transformers.Starcoder2ForCausalLM.forward.example",$$slots:{default:[Qt]},$$scope:{ctx:S}}}),ie=new pe({props:{name:"class transformers.Starcoder2ForSequenceClassification",anchor:"transformers.Starcoder2ForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Starcoder2ForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.3/en/model_doc/starcoder2#transformers.Starcoder2Config">Starcoder2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.41.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/starcoder2/modeling_starcoder2.py#L1238"}}),de=new pe({props:{name:"forward",anchor:"transformers.Starcoder2ForSequenceClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Union = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Starcoder2ForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.41.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.41.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.41.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.41.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.41.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.41.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/v4.41.3/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.41.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/starcoder2/modeling_starcoder2.py#L1270"}}),B=new bt({props:{$$slots:{default:[Kt]},$$scope:{ctx:S}}}),le=new Et({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/starcoder2.md"}}),{c(){n=l("meta"),p=a(),d=l("p"),v=a(),m($.$$.fragment),y=a(),m(x.$$.fragment),je=a(),G=l("p"),G.innerHTML=yt,Fe=a(),X=l("p"),X.textContent=kt,qe=a(),J=l("blockquote"),me=l("p"),me.textContent=Tt,Oe=a(),m(A.$$.fragment),Ie=a(),V=l("p"),V.innerHTML=wt,Ue=a(),m(E.$$.fragment),Pe=a(),Y=l("p"),Y.innerHTML=Mt,Je=a(),O=l("p"),O.textContent=Ct,We=a(),m(D.$$.fragment),Ze=a(),m(Q.$$.fragment),He=a(),M=l("div"),m(K.$$.fragment),De=a(),he=l("p"),he.innerHTML=St,Qe=a(),fe=l("p"),fe.innerHTML=$t,Ke=a(),m(W.$$.fragment),Ne=a(),ee=l("p"),ee.textContent=zt,Be=a(),T=l("div"),m(te.$$.fragment),et=a(),ge=l("p"),ge.innerHTML=xt,tt=a(),_e=l("p"),_e.innerHTML=Lt,ot=a(),be=l("p"),be.innerHTML=jt,nt=a(),j=l("div"),m(oe.$$.fragment),at=a(),ve=l("p"),ve.innerHTML=Ft,st=a(),m(Z.$$.fragment),Re=a(),ne=l("p"),ne.textContent=qt,Ge=a(),I=l("div"),m(ae.$$.fragment),rt=a(),z=l("div"),m(se.$$.fragment),it=a(),ye=l("p"),ye.innerHTML=It,dt=a(),m(H.$$.fragment),lt=a(),m(N.$$.fragment),Xe=a(),re=l("p"),re.textContent=Ut,Ae=a(),k=l("div"),m(ie.$$.fragment),ct=a(),ke=l("p"),ke.textContent=Pt,ut=a(),Te=l("p"),Te.innerHTML=Jt,pt=a(),we=l("p"),we.innerHTML=Wt,mt=a(),Me=l("p"),Me.innerHTML=Zt,ht=a(),Ce=l("p"),Ce.innerHTML=Ht,ft=a(),F=l("div"),m(de.$$.fragment),gt=a(),Se=l("p"),Se.innerHTML=Nt,_t=a(),m(B.$$.fragment),Ve=a(),m(le.$$.fragment),Ee=a(),ze=l("p"),this.h()},l(e){const t=Vt("svelte-u9bgzb",document.head);n=c(t,"META",{name:!0,content:!0}),t.forEach(o),p=s(e),d=c(e,"P",{}),q(d).forEach(o),v=s(e),h($.$$.fragment,e),y=s(e),h(x.$$.fragment,e),je=s(e),G=c(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-1n8n0dk"&&(G.innerHTML=yt),Fe=s(e),X=c(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-wu27l3"&&(X.textContent=kt),qe=s(e),J=c(e,"BLOCKQUOTE",{});var ce=q(J);me=c(ce,"P",{"data-svelte-h":!0}),u(me)!=="svelte-1cdgnq1"&&(me.textContent=Tt),Oe=s(ce),h(A.$$.fragment,ce),ce.forEach(o),Ie=s(e),V=c(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-1289i3b"&&(V.innerHTML=wt),Ue=s(e),h(E.$$.fragment,e),Pe=s(e),Y=c(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1gol27n"&&(Y.innerHTML=Mt),Je=s(e),O=c(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-a5tlwb"&&(O.textContent=Ct),We=s(e),h(D.$$.fragment,e),Ze=s(e),h(Q.$$.fragment,e),He=s(e),M=c(e,"DIV",{class:!0});var L=q(M);h(K.$$.fragment,L),De=s(L),he=c(L,"P",{"data-svelte-h":!0}),u(he)!=="svelte-1b9f62e"&&(he.innerHTML=St),Qe=s(L),fe=c(L,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-lqtv1n"&&(fe.innerHTML=$t),Ke=s(L),h(W.$$.fragment,L),L.forEach(o),Ne=s(e),ee=c(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-v53k4"&&(ee.textContent=zt),Be=s(e),T=c(e,"DIV",{class:!0});var C=q(T);h(te.$$.fragment,C),et=s(C),ge=c(C,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-1p6bph8"&&(ge.innerHTML=xt),tt=s(C),_e=c(C,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-1ydu1el"&&(_e.innerHTML=Lt),ot=s(C),be=c(C,"P",{"data-svelte-h":!0}),u(be)!=="svelte-1inq57c"&&(be.innerHTML=jt),nt=s(C),j=c(C,"DIV",{class:!0});var U=q(j);h(oe.$$.fragment,U),at=s(U),ve=c(U,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-4bwxsf"&&(ve.innerHTML=Ft),st=s(U),h(Z.$$.fragment,U),U.forEach(o),C.forEach(o),Re=s(e),ne=c(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-1c8liqc"&&(ne.textContent=qt),Ge=s(e),I=c(e,"DIV",{class:!0});var ue=q(I);h(ae.$$.fragment,ue),rt=s(ue),z=c(ue,"DIV",{class:!0});var R=q(z);h(se.$$.fragment,R),it=s(R),ye=c(R,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-1p18q2n"&&(ye.innerHTML=It),dt=s(R),h(H.$$.fragment,R),lt=s(R),h(N.$$.fragment,R),R.forEach(o),ue.forEach(o),Xe=s(e),re=c(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-1qnsuw0"&&(re.textContent=Ut),Ae=s(e),k=c(e,"DIV",{class:!0});var w=q(k);h(ie.$$.fragment,w),ct=s(w),ke=c(w,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-pjsk7t"&&(ke.textContent=Pt),ut=s(w),Te=c(w,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-1wdbspq"&&(Te.innerHTML=Jt),pt=s(w),we=c(w,"P",{"data-svelte-h":!0}),u(we)!=="svelte-10ugs3m"&&(we.innerHTML=Wt),mt=s(w),Me=c(w,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-ajcq9x"&&(Me.innerHTML=Zt),ht=s(w),Ce=c(w,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-1ydu1el"&&(Ce.innerHTML=Ht),ft=s(w),F=c(w,"DIV",{class:!0});var $e=q(F);h(de.$$.fragment,$e),gt=s($e),Se=c($e,"P",{"data-svelte-h":!0}),u(Se)!=="svelte-126k857"&&(Se.innerHTML=Nt),_t=s($e),h(B.$$.fragment,$e),$e.forEach(o),w.forEach(o),Ve=s(e),h(le.$$.fragment,e),Ee=s(e),ze=c(e,"P",{}),q(ze).forEach(o),this.h()},h(){P(n,"name","hf:doc:metadata"),P(n,"content",to),P(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,n),r(e,p,t),r(e,d,t),r(e,v,t),f($,e,t),r(e,y,t),f(x,e,t),r(e,je,t),r(e,G,t),r(e,Fe,t),r(e,X,t),r(e,qe,t),r(e,J,t),i(J,me),i(J,Oe),f(A,J,null),r(e,Ie,t),r(e,V,t),r(e,Ue,t),f(E,e,t),r(e,Pe,t),r(e,Y,t),r(e,Je,t),r(e,O,t),r(e,We,t),f(D,e,t),r(e,Ze,t),f(Q,e,t),r(e,He,t),r(e,M,t),f(K,M,null),i(M,De),i(M,he),i(M,Qe),i(M,fe),i(M,Ke),f(W,M,null),r(e,Ne,t),r(e,ee,t),r(e,Be,t),r(e,T,t),f(te,T,null),i(T,et),i(T,ge),i(T,tt),i(T,_e),i(T,ot),i(T,be),i(T,nt),i(T,j),f(oe,j,null),i(j,at),i(j,ve),i(j,st),f(Z,j,null),r(e,Re,t),r(e,ne,t),r(e,Ge,t),r(e,I,t),f(ae,I,null),i(I,rt),i(I,z),f(se,z,null),i(z,it),i(z,ye),i(z,dt),f(H,z,null),i(z,lt),f(N,z,null),r(e,Xe,t),r(e,re,t),r(e,Ae,t),r(e,k,t),f(ie,k,null),i(k,ct),i(k,ke),i(k,ut),i(k,Te),i(k,pt),i(k,we),i(k,mt),i(k,Me),i(k,ht),i(k,Ce),i(k,ft),i(k,F),f(de,F,null),i(F,gt),i(F,Se),i(F,_t),f(B,F,null),r(e,Ve,t),f(le,e,t),r(e,Ee,t),r(e,ze,t),Ye=!0},p(e,[t]){const ce={};t&2&&(ce.$$scope={dirty:t,ctx:e}),W.$set(ce);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),Z.$set(L);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),H.$set(C);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),N.$set(U);const ue={};t&2&&(ue.$$scope={dirty:t,ctx:e}),B.$set(ue)},i(e){Ye||(g($.$$.fragment,e),g(x.$$.fragment,e),g(A.$$.fragment,e),g(E.$$.fragment,e),g(D.$$.fragment,e),g(Q.$$.fragment,e),g(K.$$.fragment,e),g(W.$$.fragment,e),g(te.$$.fragment,e),g(oe.$$.fragment,e),g(Z.$$.fragment,e),g(ae.$$.fragment,e),g(se.$$.fragment,e),g(H.$$.fragment,e),g(N.$$.fragment,e),g(ie.$$.fragment,e),g(de.$$.fragment,e),g(B.$$.fragment,e),g(le.$$.fragment,e),Ye=!0)},o(e){_($.$$.fragment,e),_(x.$$.fragment,e),_(A.$$.fragment,e),_(E.$$.fragment,e),_(D.$$.fragment,e),_(Q.$$.fragment,e),_(K.$$.fragment,e),_(W.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(Z.$$.fragment,e),_(ae.$$.fragment,e),_(se.$$.fragment,e),_(H.$$.fragment,e),_(N.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(B.$$.fragment,e),_(le.$$.fragment,e),Ye=!1},d(e){e&&(o(p),o(d),o(v),o(y),o(je),o(G),o(Fe),o(X),o(qe),o(J),o(Ie),o(V),o(Ue),o(Pe),o(Y),o(Je),o(O),o(We),o(Ze),o(He),o(M),o(Ne),o(ee),o(Be),o(T),o(Re),o(ne),o(Ge),o(I),o(Xe),o(re),o(Ae),o(k),o(Ve),o(Ee),o(ze)),o(n),b($,e),b(x,e),b(A),b(E,e),b(D,e),b(Q,e),b(K),b(W),b(te),b(oe),b(Z),b(ae),b(se),b(H),b(N),b(ie),b(de),b(B),b(le,e)}}}const to='{"title":"Starcoder2","local":"starcoder2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"License","local":"license","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Starcoder2Config","local":"transformers.Starcoder2Config","sections":[],"depth":2}],"depth":1}';function oo(S){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class uo extends Xt{constructor(n){super(),At(this,n,oo,eo,Rt,{})}}export{uo as component};
