import{s as gp,f as jn,o as fp,n as un}from"../chunks/scheduler.85c25b89.js";import{S as Cp,i as bp,g as y,s as a,r as p,A as $p,h as u,f as l,c as n,j as Tl,u as o,x as j,k as f,y as Qp,a as e,v as i,d as r,t as M,w as c}from"../chunks/index.c9837788.js";import{T as yn}from"../chunks/Tip.6bd863a0.js";import{C as J}from"../chunks/CodeBlock.52fa569e.js";import{H as m,E as Np}from"../chunks/EditOnGithub.b65eee75.js";function Ap($){let U,g="While both the prompt-only and language modeling types are similar, they differ in how the input is handled. In the prompt-only type, the prompt represents a partial input that expects the model to complete or continue, while in the language modeling type, the input is treated as a complete sentence or sequence. These two types are processed differently by TRL. Below is an example showing the difference in the output of the <code>apply_chat_template</code> function for each type:",T,d,q,I,C="<li>The prompt-only output includes a <code>&#39;&lt;|assistant|&gt;\\n&#39;</code>, indicating the beginning of the assistant’s turn and expecting the model to generate a completion.</li> <li>In contrast, the language modeling output treats the input as a complete sequence and terminates it with <code>&#39;&lt;|endoftext|&gt;&#39;</code>, signaling the end of the text and not expecting any additional content.</li>",b;return d=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwYXBwbHlfY2hhdF90ZW1wbGF0ZSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktMTI4ay1pbnN0cnVjdCUyMiklMEElMEElMjMlMjBFeGFtcGxlJTIwZm9yJTIwcHJvbXB0LW9ubHklMjB0eXBlJTBBcHJvbXB0X29ubHlfZXhhbXBsZSUyMCUzRCUyMCU3QiUyMnByb21wdCUyMiUzQSUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTIyJTdEJTVEJTdEJTBBYXBwbHlfY2hhdF90ZW1wbGF0ZShwcm9tcHRfb25seV9leGFtcGxlJTJDJTIwdG9rZW5pemVyKSUwQSUyMyUyME91dHB1dCUzQSUyMCU3Qidwcm9tcHQnJTNBJTIwJyUzQyU3Q3VzZXIlN0MlM0UlNUNuV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlM0MlN0NlbmQlN0MlM0UlNUNuJTNDJTdDYXNzaXN0YW50JTdDJTNFJTVDbiclN0QlMEElMEElMjMlMjBFeGFtcGxlJTIwZm9yJTIwbGFuZ3VhZ2UlMjBtb2RlbGluZyUyMHR5cGUlMEFsbV9leGFtcGxlJTIwJTNEJTIwJTdCJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCU1RCU3RCUwQWFwcGx5X2NoYXRfdGVtcGxhdGUobG1fZXhhbXBsZSUyQyUyMHRva2VuaXplciklMEElMjMlMjBPdXRwdXQlM0ElMjAlN0IndGV4dCclM0ElMjAnJTNDJTdDdXNlciU3QyUzRSU1Q25XaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0NlbmRvZnRleHQlN0MlM0UnJTdE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> apply_chat_template

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-128k-instruct&quot;</span>)

<span class="hljs-comment"># Example for prompt-only type</span>
prompt_only_example = {<span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}]}
apply_chat_template(prompt_only_example, tokenizer)
<span class="hljs-comment"># Output: {&#x27;prompt&#x27;: &#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;}</span>

<span class="hljs-comment"># Example for language modeling type</span>
lm_example = {<span class="hljs-string">&quot;messages&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}]}
apply_chat_template(lm_example, tokenizer)
<span class="hljs-comment"># Output: {&#x27;text&#x27;: &#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;}</span>`,wrap:!1}}),{c(){U=y("p"),U.innerHTML=g,T=a(),p(d.$$.fragment),q=a(),I=y("ul"),I.innerHTML=C},l(h){U=u(h,"P",{"data-svelte-h":!0}),j(U)!=="svelte-1k9p4sz"&&(U.innerHTML=g),T=n(h),o(d.$$.fragment,h),q=n(h),I=u(h,"UL",{"data-svelte-h":!0}),j(I)!=="svelte-17mqw6t"&&(I.innerHTML=C)},m(h,w){e(h,U,w),e(h,T,w),i(d,h,w),e(h,q,w),e(h,I,w),b=!0},p:un,i(h){b||(r(d.$$.fragment,h),b=!0)},o(h){M(d.$$.fragment,h),b=!1},d(h){h&&(l(U),l(T),l(q),l(I)),c(d,h)}}}function xp($){let U,g=`TRL trainers only support standard dataset formats, <a href="https://github.com/huggingface/trl/issues/2071" rel="nofollow">for now</a>. If you have a conversational dataset, you must first convert it into a standard format.
For more information on how to work with conversational datasets, refer to the <a href="#working-with-conversational-datasets-in-trl">Working with conversational datasets in TRL</a> section.`;return{c(){U=y("p"),U.innerHTML=g},l(T){U=u(T,"P",{"data-svelte-h":!0}),j(U)!=="svelte-38co2n"&&(U.innerHTML=g)},m(T,d){e(T,U,d)},p:un,d(T){T&&l(U)}}}function Gp($){let U,g=`We recommend using the <a href="/docs/trl/v0.13.0/en/data_utils#trl.apply_chat_template">apply_chat_template()</a> function instead of calling <code>tokenizer.apply_chat_template</code> directly. Handling chat templates for non-language modeling datasets can be tricky and may result in errors, such as mistakenly placing a system prompt in the middle conversation.
For additional examples, see <a href="https://github.com/huggingface/trl/pull/1930#issuecomment-2292908614" rel="nofollow">#1930 (comment)</a>. The <a href="/docs/trl/v0.13.0/en/data_utils#trl.apply_chat_template">apply_chat_template()</a> is designed to handle these intricacies and ensure the correct application of chat templates for various tasks.`;return{c(){U=y("p"),U.innerHTML=g},l(T){U=u(T,"P",{"data-svelte-h":!0}),j(U)!=="svelte-1exwb7c"&&(U.innerHTML=g)},m(T,d){e(T,U,d)},p:un,d(T){T&&l(U)}}}function Bp($){let U,g='It’s important to note that chat templates are model-specific. For example, if you use the chat template from <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-8B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3.1-8B-Instruct</a> with the above example, you get a different output:',T,d,q,I,C="Always use the chat template associated with the model you’re working with. Using the wrong template can lead to inaccurate or unexpected results.",b;return d=new J({props:{code:"YXBwbHlfY2hhdF90ZW1wbGF0ZShleGFtcGxlJTJDJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy4xLThCLUluc3RydWN0JTIyKSklMEElMjMlMjBPdXRwdXQlM0ElMEElMjMlMjAlN0IncHJvbXB0JyUzQSUyMCclM0MlN0NpbV9zdGFydCU3QyUzRXN5c3RlbSU1Q25Zb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lM0MlN0NpbV9lbmQlN0MlM0UlNUNuJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTVDbldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTVDbiclMkMlMEElMjMlMjAlMjAnY29tcGxldGlvbiclM0ElMjAnSXQlMjBpcyUyMGJsdWUuJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiclN0Q=",highlighted:`apply_chat_template(example, AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span>))
<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># {&#x27;prompt&#x27;: &#x27;&lt;|im_start|&gt;system\\nYou are a helpful assistant.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\nWhat color is the sky?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\n&#x27;,</span>
<span class="hljs-comment">#  &#x27;completion&#x27;: &#x27;It is blue.&lt;|im_end|&gt;\\n&#x27;}</span>`,wrap:!1}}),{c(){U=y("p"),U.innerHTML=g,T=a(),p(d.$$.fragment),q=a(),I=y("p"),I.textContent=C},l(h){U=u(h,"P",{"data-svelte-h":!0}),j(U)!=="svelte-6bgf58"&&(U.innerHTML=g),T=n(h),o(d.$$.fragment,h),q=n(h),I=u(h,"P",{"data-svelte-h":!0}),j(I)!=="svelte-ien9e7"&&(I.textContent=C)},m(h,w){e(h,U,w),e(h,T,w),i(d,h,w),e(h,q,w),e(h,I,w),b=!0},p:un,i(h){b||(r(d.$$.fragment,h),b=!0)},o(h){M(d.$$.fragment,h),b=!1},d(h){h&&(l(U),l(T),l(q),l(I)),c(d,h)}}}function Zp($){let U,g,T,d,q,I,C,b="This guide provides an overview of the dataset formats and types supported by each trainer in TRL.",h,w,dl,v,Jn="<li>The <em>format</em> of a dataset refers to how the data is structured, typically categorized as either <em>standard</em> or <em>conversational</em>.</li> <li>The <em>type</em> is associated with the specific task the dataset is designed for, such as <em>prompt-only</em> or <em>preference</em>. Each type is characterized by its columns, which vary according to the task, as shown in the table.</li>",Il,X,hn=`<tbody><tr><th>Type \\ Format</th> <th>Standard</th> <th>Conversational</th></tr> <tr><td>Language modeling</td> <td><pre><code>{&quot;text&quot;: &quot;The sky is blue.&quot;}</code></pre></td> <td><pre><code>{&quot;messages&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;},
              {&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}]}</code></pre></td></tr> <tr><td>Prompt-only</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}]}</code></pre></td></tr> <tr><td>Prompt-completion</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;,
 &quot;completion&quot;: &quot; blue.&quot;}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}],
 &quot;completion&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}]}</code></pre></td></tr> <tr><td>Preference</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;,
 &quot;chosen&quot;: &quot; blue.&quot;,
 &quot;rejected&quot;: &quot; green.&quot;}</code></pre>
      or, with implicit prompt:
      <pre><code>{&quot;chosen&quot;: &quot;The sky is blue.&quot;,
 &quot;rejected&quot;: &quot;The sky is green.&quot;}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}],
 &quot;chosen&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}],
 &quot;rejected&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is green.&quot;}]}</code></pre>
      or, with implicit prompt:
      <pre><code>{&quot;chosen&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;},
              {&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}],
 &quot;rejected&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;},
                {&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is green.&quot;}]}</code></pre></td></tr> <tr><td>Unpaired preference</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;,
 &quot;completion&quot;: &quot; blue.&quot;,
 &quot;label&quot;: True}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}],
 &quot;completion&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is green.&quot;}],
 &quot;label&quot;: False}</code></pre></td></tr> <tr><td>Stepwise supervision</td> <td><pre><code>{&quot;prompt&quot;: &quot;Which number is larger, 9.8 or 9.11?&quot;,
 &quot;completions&quot;: [&quot;The fractional part of 9.8 is 0.8.&quot;, 
                 &quot;The fractional part of 9.11 is 0.11.&quot;,
                 &quot;0.11 is greater than 0.8.&quot;,
                 &quot;Hence, 9.11 &gt; 9.8.&quot;],
 &quot;labels&quot;: [True, True, False, False]}</code></pre></td> <td></td></tr></tbody>`,wl,k,ql,R,gl,V,Un="The standard dataset format typically consists of plain text strings. The columns in the dataset vary depending on the task. This is the format expected by TRL trainers. Below are examples of standard dataset formats for different tasks:",fl,E,Cl,W,bl,z,mn="Conversational datasets are used for tasks involving dialogues or chat interactions between users and assistants. Unlike standard dataset formats, these contain sequences of messages where each message has a <code>role</code> (e.g., <code>&quot;user&quot;</code> or <code>&quot;assistant&quot;</code>) and <code>content</code> (the message text).",$l,S,Ql,Y,Tn="Just like standard datasets, the columns in conversational datasets vary depending on the task. Below are examples of conversational dataset formats for different tasks:",Nl,F,Al,H,dn='Conversational datasets are useful for training chat models, but must be converted into a standard format before being used with TRL trainers. This is typically done using chat templates specific to the model being used. For more information, refer to the <a href="#working-with-conversational-datasets-in-trl">Working with conversational datasets in TRL</a> section.',xl,_,Gl,D,Bl,L,In="A language modeling dataset consists of a column <code>&quot;text&quot;</code> (or <code>&quot;messages&quot;</code> for conversational datasets) containing a full sequence of text.",Zl,P,vl,K,Xl,O,wn="In a prompt-only dataset, only the initial prompt (the question or partial sentence) is provided under the key <code>&quot;prompt&quot;</code>. The training typically involves generating the completion based on this prompt, where the model learns to continue or complete the given input.",kl,tt,Rl,x,Vl,st,El,lt,qn="A prompt-completion dataset includes a <code>&quot;prompt&quot;</code> and a <code>&quot;completion&quot;</code>.",Wl,et,zl,at,Sl,nt,gn=`A preference dataset is used for tasks where the model is trained to choose between two or more possible completions to the same prompt. This dataset includes a <code>&quot;prompt&quot;</code>, a <code>&quot;chosen&quot;</code> completion, and a <code>&quot;rejected&quot;</code> completion. The model is trained to select the <code>&quot;chosen&quot;</code> response over the <code>&quot;rejected&quot;</code> response.
Some dataset may not include the <code>&quot;prompt&quot;</code> column, in which case the prompt is implicit and directly included in the <code>&quot;chosen&quot;</code> and <code>&quot;rejected&quot;</code> completions. We recommend using explicit prompts whenever possible.`,Yl,pt,Fl,ot,fn='Some preference datasets can be found with <a href="https://huggingface.co/datasets?other=dpo" rel="nofollow">the tag <code>dpo</code> on Hugging Face Hub</a>. You can also explore the <a href="https://huggingface.co/collections/librarian-bots/direct-preference-optimization-datasets-66964b12835f46289b6ef2fc" rel="nofollow">librarian-bots’ DPO Collections</a> to identify preference datasets.',Hl,it,_l,rt,Cn="An unpaired preference dataset is similar to a preference dataset but instead of having <code>&quot;chosen&quot;</code> and <code>&quot;rejected&quot;</code> completions for the same prompt, it includes a single <code>&quot;completion&quot;</code> and a <code>&quot;label&quot;</code> indicating whether the completion is preferred or not.",Dl,Mt,Ll,ct,Pl,yt,bn='A stepwise (or process) supervision dataset is similar to an <a href="#unpaired-preference">unpaired preference</a> dataset but includes multiple steps of completions, each with its own label. This structure is useful for tasks that need detailed, step-by-step labeling, such as reasoning tasks. By evaluating each step separately and providing targeted labels, this approach helps identify precisely where the reasoning is correct and where errors occur, allowing for targeted feedback on each part of the reasoning process.',Kl,ut,Ol,jt,te,Jt,$n="Choosing the right dataset type depends on the task you are working on and the specific requirements of the TRL trainer you are using. Below is a brief overview of the dataset types supported by each TRL trainer.",se,ht,Qn='<thead><tr><th>Trainer</th> <th>Expected dataset type</th></tr></thead> <tbody><tr><td><a href="/docs/trl/v0.13.0/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a></td> <td><a href="#unpaired-preference">Unpaired preference</a></td></tr> <tr><td><a href="/docs/trl/v0.13.0/en/cpo_trainer#trl.CPOTrainer">CPOTrainer</a></td> <td><a href="#preference">Preference (explicit prompt recommended)</a></td></tr> <tr><td><a href="/docs/trl/v0.13.0/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a></td> <td><a href="#preference">Preference (explicit prompt recommended)</a></td></tr> <tr><td><a href="/docs/trl/v0.13.0/en/gkd_trainer#trl.GKDTrainer">GKDTrainer</a></td> <td><a href="#prompt-completion">Prompt-completion</a></td></tr> <tr><td><a href="/docs/trl/v0.13.0/en/iterative_sft_trainer#trl.IterativeSFTTrainer">IterativeSFTTrainer</a></td> <td><a href="#unpaired-preference">Unpaired preference</a></td></tr> <tr><td><a href="/docs/trl/v0.13.0/en/kto_trainer#trl.KTOTrainer">KTOTrainer</a></td> <td><a href="#unpaired-preference">Unpaired preference</a> or <a href="#preference">Preference (explicit prompt recommended)</a></td></tr> <tr><td><a href="/docs/trl/v0.13.0/en/nash_md_trainer#trl.NashMDTrainer">NashMDTrainer</a></td> <td><a href="#prompt-only">Prompt-only</a></td></tr> <tr><td><a href="/docs/trl/v0.13.0/en/online_dpo_trainer#trl.OnlineDPOTrainer">OnlineDPOTrainer</a></td> <td><a href="#prompt-only">Prompt-only</a></td></tr> <tr><td><a href="/docs/trl/v0.13.0/en/orpo_trainer#trl.ORPOTrainer">ORPOTrainer</a></td> <td><a href="#preference">Preference (explicit prompt recommended)</a></td></tr> <tr><td><a href="/docs/trl/v0.13.0/en/ppo_trainer#trl.PPOTrainer">PPOTrainer</a></td> <td>Tokenized language modeling</td></tr> <tr><td><a href="/docs/trl/v0.13.0/en/prm_trainer#trl.PRMTrainer">PRMTrainer</a></td> <td><a href="#stepwise-supervision">Stepwise supervision</a></td></tr> <tr><td><a href="/docs/trl/v0.13.0/en/reward_trainer#trl.RewardTrainer">RewardTrainer</a></td> <td><a href="#preference">Preference (implicit prompt recommended)</a></td></tr> <tr><td><a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a></td> <td><a href="#language-modeling">Language modeling</a></td></tr> <tr><td><a href="/docs/trl/v0.13.0/en/xpo_trainer#trl.XPOTrainer">XPOTrainer</a></td> <td><a href="#prompt-only">Prompt-only</a></td></tr></tbody>',le,G,ee,Ut,ae,mt,Nn=`Conversational datasets are increasingly common, especially for training chat models. However, some TRL trainers don’t support conversational datasets in their raw format. (For more information, see <a href="https://github.com/huggingface/trl/issues/2071" rel="nofollow">issue #2071</a>.) These datasets must first be converted into a standard format.
Fortunately, TRL offers tools to easily handle this conversion, which are detailed below.`,ne,Tt,pe,dt,An="To convert a conversational dataset into a standard dataset, you need to <em>apply a chat template</em> to the dataset. A chat template is a predefined structure that typically includes placeholders for user and assistant messages. This template is provided by the tokenizer of the model you use.",oe,It,xn='For detailed instructions on using chat templating, refer to the <a href="https://huggingface.co/docs/transformers/en/chat_templating" rel="nofollow">Chat templating section in the <code>transformers</code> documentation</a>.',ie,wt,Gn='In TRL, the method you apply to convert the dataset will vary depending on the task. Fortunately, TRL provides a helper function called <a href="/docs/trl/v0.13.0/en/data_utils#trl.apply_chat_template">apply_chat_template()</a> to simplify this process. Here’s an example of how to use it:',re,qt,Me,gt,Bn='Alternatively, you can use the <a href="https://huggingface.co/docs/datasets/v3.2.0/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> method to apply the template across an entire dataset:',ce,ft,ye,B,ue,Z,je,Ct,Je,bt,Zn="Many datasets come in formats tailored to specific tasks, which might not be directly compatible with TRL. To use such datasets with TRL, you may need to preprocess and convert them into the required format.",he,$t,vn='To make this easier, we provide a set of <a href="https://github.com/huggingface/trl/tree/main/examples/datasets" rel="nofollow">example scripts</a> that cover common dataset conversions.',Ue,Qt,me,Nt,Xn='Let’s take the <a href="https://huggingface.co/datasets/openbmb/UltraFeedback" rel="nofollow">UltraFeedback dataset</a> as an example. Here’s a preview of the dataset:',Te,Q,kn,de,At,Rn="As shown above, the dataset format does not match the expected structure. It’s not in a conversational format, the column names differ, and the results pertain to different models (e.g., Bard, GPT-4) and aspects (e.g., “helpfulness”, “honesty”).",Ie,xt,Vn='By using the provided conversion script <a href="https://github.com/huggingface/trl/tree/main/examples/datasets/ultrafeedback.py" rel="nofollow"><code>examples/datasets/ultrafeedback.py</code></a>, you can transform this dataset into an unpaired preference type, and push it to the Hub:',we,Gt,qe,Bt,En="Once converted, the dataset will look like this:",ge,N,Wn,fe,Zt,zn="Now, you can use this dataset with TRL!",Ce,vt,Sn="By adapting the provided scripts or creating your own, you can convert any dataset into a format compatible with TRL.",be,Xt,$e,kt,Yn="This section provides example code to help you convert between different dataset types. While some conversions can be performed after applying the chat template (i.e., in the standard format), we recommend performing the conversion before applying the chat template to ensure it works consistently.",Qe,Rt,Fn="For simplicity, some of the examples below do not follow this recommendation and use the standard format. However, the conversions can be applied directly to the conversational format without modification.",Ne,Vt,Hn='<thead><tr><th>From \\ To</th> <th>Language modeling</th> <th>Prompt-completion</th> <th>Prompt-only</th> <th>Preference with implicit prompt</th> <th>Preference</th> <th>Unpaired preference</th> <th>Stepwise supervision</th></tr></thead> <tbody><tr><td>Language modeling</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr> <tr><td>Prompt-completion</td> <td><a href="#from-prompt-completion-to-language-modeling-dataset">🔗</a></td> <td>N/A</td> <td><a href="#from-prompt-completion-to-prompt-only-dataset">🔗</a></td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr> <tr><td>Prompt-only</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr> <tr><td>Preference with implicit prompt</td> <td><a href="#from-preference-with-implicit-prompt-to-language-modeling-dataset">🔗</a></td> <td><a href="#from-preference-with-implicit-prompt-to-prompt-completion-dataset">🔗</a></td> <td><a href="#from-preference-with-implicit-prompt-to-prompt-only-dataset">🔗</a></td> <td>N/A</td> <td><a href="#from-implicit-to-explicit-prompt-preference-dataset">🔗</a></td> <td><a href="#from-preference-with-implicit-prompt-to-unpaired-preference-dataset">🔗</a></td> <td>N/A</td></tr> <tr><td>Preference</td> <td><a href="#from-preference-to-language-modeling-dataset">🔗</a></td> <td><a href="#from-preference-to-prompt-completion-dataset">🔗</a></td> <td><a href="#from-preference-to-prompt-only-dataset">🔗</a></td> <td><a href="#from-explicit-to-implicit-prompt-preference-dataset">🔗</a></td> <td>N/A</td> <td><a href="#from-preference-to-unpaired-preference-dataset">🔗</a></td> <td>N/A</td></tr> <tr><td>Unpaired preference</td> <td><a href="#from-unpaired-preference-to-language-modeling-dataset">🔗</a></td> <td><a href="#from-unpaired-preference-to-prompt-completion-dataset">🔗</a></td> <td><a href="#from-unpaired-preference-to-prompt-only-dataset">🔗</a></td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr> <tr><td>Stepwise supervision</td> <td><a href="#from-stepwise-supervision-to-language-modeling-dataset">🔗</a></td> <td><a href="#from-stepwise-supervision-to-prompt-completion-dataset">🔗</a></td> <td><a href="#from-stepwise-supervision-to-prompt-only-dataset">🔗</a></td> <td>N/A</td> <td>N/A</td> <td><a href="#from-stepwise-supervision-to-unpaired-preference-dataset">🔗</a></td> <td>N/A</td></tr></tbody>',Ae,Et,xe,Wt,_n="To convert a prompt-completion dataset into a language modeling dataset, concatenate the prompt and the completion.",Ge,zt,Be,St,Ze,Yt,ve,Ft,Dn="To convert a prompt-completion dataset into a prompt-only dataset, remove the completion.",Xe,Ht,ke,_t,Re,Dt,Ve,Lt,Ln="To convert a preference with implicit prompt dataset into a language modeling dataset, remove the rejected, and rename the column <code>&quot;chosen&quot;</code> to <code>&quot;text&quot;</code>.",Ee,Pt,We,Kt,ze,Ot,Se,ts,Pn='To convert a preference dataset with implicit prompt into a prompt-completion dataset, extract the prompt with <a href="/docs/trl/v0.13.0/en/data_utils#trl.extract_prompt">extract_prompt()</a>, remove the rejected, and rename the column <code>&quot;chosen&quot;</code> to <code>&quot;completion&quot;</code>.',Ye,ss,Fe,ls,He,es,_e,as,Kn='To convert a preference dataset with implicit prompt into a prompt-only dataset, extract the prompt with <a href="/docs/trl/v0.13.0/en/data_utils#trl.extract_prompt">extract_prompt()</a>, and remove the rejected and the chosen.',De,ns,Le,ps,Pe,os,Ke,is,On='To convert a preference dataset with implicit prompt into a preference dataset with explicit prompt, extract the prompt with <a href="/docs/trl/v0.13.0/en/data_utils#trl.extract_prompt">extract_prompt()</a>.',Oe,rs,ta,Ms,sa,cs,la,ys,tp='To convert a preference dataset with implicit prompt into an unpaired preference dataset, extract the prompt with <a href="/docs/trl/v0.13.0/en/data_utils#trl.extract_prompt">extract_prompt()</a>, and unpair the dataset with <a href="/docs/trl/v0.13.0/en/data_utils#trl.unpair_preference_dataset">unpair_preference_dataset()</a>.',ea,us,aa,js,na,Js,pa,hs,sp="To convert a preference dataset into a language modeling dataset, remove the rejected, concatenate the prompt and the chosen into the <code>&quot;text&quot;</code> column.",oa,Us,ia,ms,ra,Ts,Ma,ds,lp="To convert a preference dataset into a prompt-completion dataset, remove the rejected, and rename the column <code>&quot;chosen&quot;</code> to <code>&quot;completion&quot;</code>.",ca,Is,ya,ws,ua,qs,ja,gs,ep="To convert a preference dataset into a prompt-only dataset, remove the rejected and the chosen.",Ja,fs,ha,Cs,Ua,bs,ma,$s,ap="To convert a preference dataset with explicit prompt into a preference dataset with implicit prompt, concatenate the prompt to both chosen and rejected, and remove the prompt.",Ta,Qs,da,Ns,Ia,As,wa,xs,np='To convert dataset into an unpaired preference dataset, unpair the dataset with <a href="/docs/trl/v0.13.0/en/data_utils#trl.unpair_preference_dataset">unpair_preference_dataset()</a>.',qa,Gs,ga,Bs,fa,Zs,Ca,vs,pp="To convert an unpaired preference dataset into a language modeling dataset, concatenate the prompt and the completion into the <code>&quot;text&quot;</code> column, and remove the prompt, completion and label columns.",ba,Xs,$a,ks,Qa,Rs,Na,Vs,op="To convert an unpaired preference dataset into a prompt-completion dataset, remove the label columns.",Aa,Es,xa,Ws,Ga,zs,Ba,Ss,ip="To convert an unpaired preference dataset into a prompt-only dataset, remove the completion and the label columns.",Za,Ys,va,Fs,Xa,Hs,ka,_s,rp="To convert a stepwise supervision dataset into a language modeling dataset, concatenate the prompt and the completions into the <code>&quot;text&quot;</code> column.",Ra,Ds,Va,Ls,Ea,Ps,Wa,Ks,Mp="To convert a stepwise supervision dataset into a prompt-completion dataset, join the completions and remove the labels.",za,Os,Sa,tl,Ya,sl,Fa,ll,cp="To convert a stepwise supervision dataset into a prompt-only dataset, remove the completions and the labels.",Ha,el,_a,al,Da,nl,La,pl,yp="To convert a stepwise supervision dataset into an unpaired preference dataset, join the completions and merge the labels.",Pa,ol,up="The method for merging the labels depends on the specific task. In this example, we use the logical AND operation. This means that if the step labels indicate the correctness of individual steps, the resulting label will reflect the correctness of the entire sequence.",Ka,il,Oa,rl,tn,Ml,sn,cl,jp="Some trainers also support fine-tuning vision-language models (VLMs) using image-text pairs. In this scenario, it’s recommended to use a conversational format, as each model handles image placeholders in text differently.",ln,yl,Jp="A conversational vision dataset differs from a standard conversational dataset in two key ways:",en,ul,hp="<li>The dataset must contain the key <code>images</code> with the image data.</li> <li>The <code>&quot;content&quot;</code> field in messages must be a list of dictionaries, where each dictionary specifies the type of data: <code>&quot;image&quot;</code> or <code>&quot;text&quot;</code>.</li>",an,jl,Up="Example:",nn,Jl,pn,hl,mp='An example of a conversational vision dataset is the <a href="https://huggingface.co/datasets/openbmb/RLAIF-V-Dataset" rel="nofollow">openbmb/RLAIF-V-Dataset</a>. Below is an embedded view of the dataset’s training data, allowing you to explore it directly:',on,A,Tp,rn,Ul,Mn,ml,cn;return q=new m({props:{title:"Dataset formats and types",local:"dataset-formats-and-types",headingTag:"h1"}}),w=new m({props:{title:"Overview of the dataset formats and types",local:"overview-of-the-dataset-formats-and-types",headingTag:"h2"}}),k=new m({props:{title:"Formats",local:"formats",headingTag:"h3"}}),R=new m({props:{title:"Standard",local:"standard",headingTag:"h4"}}),E=new J({props:{code:"JTIzJTIwTGFuZ3VhZ2UlMjBtb2RlbGluZyUwQWxhbmd1YWdlX21vZGVsaW5nX2V4YW1wbGUlMjAlM0QlMjAlN0IlMjJ0ZXh0JTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjBibHVlLiUyMiU3RCUwQSUyMyUyMFByZWZlcmVuY2UlMEFwcmVmZXJlbmNlX2V4YW1wbGUlMjAlM0QlMjAlN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMmNob3NlbiUyMiUzQSUyMCUyMiUyMGJsdWUuJTIyJTJDJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlMjIlMjBncmVlbi4lMjIlN0QlMEElMjMlMjBVbnBhaXJlZCUyMHByZWZlcmVuY2UlMEF1bnBhaXJlZF9wcmVmZXJlbmNlX2V4YW1wbGUlMjAlM0QlMjAlN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlMjBibHVlLiUyMiUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwVHJ1ZSU3RA==",highlighted:`<span class="hljs-comment"># Language modeling</span>
language_modeling_example = {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;The sky is blue.&quot;</span>}
<span class="hljs-comment"># Preference</span>
preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot; green.&quot;</span>}
<span class="hljs-comment"># Unpaired preference</span>
unpaired_preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">True</span>}`,wrap:!1}}),W=new m({props:{title:"Conversational",local:"conversational",headingTag:"h4"}}),S=new J({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
]`,wrap:!1}}),F=new J({props:{code:"JTIzJTIwUHJvbXB0LWNvbXBsZXRpb24lMEFwcm9tcHRfY29tcGxldGlvbl9leGFtcGxlJTIwJTNEJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwYmx1ZS4lMjIlN0QlNUQlN0QlMEElMjMlMjBQcmVmZXJlbmNlJTBBcHJlZmVyZW5jZV9leGFtcGxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBibHVlLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlamVjdGVkJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwZ3JlZW4uJTIyJTdEJTVEJTJDJTBBJTdE",highlighted:`<span class="hljs-comment"># Prompt-completion</span>
prompt_completion_example = {<span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
                             <span class="hljs-string">&quot;completion&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}]}
<span class="hljs-comment"># Preference</span>
preference_example = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
    <span class="hljs-string">&quot;chosen&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
    <span class="hljs-string">&quot;rejected&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
}`,wrap:!1}}),_=new m({props:{title:"Types",local:"types",headingTag:"h3"}}),D=new m({props:{title:"Language modeling",local:"language-modeling",headingTag:"h4"}}),P=new J({props:{code:"JTIzJTIwU3RhbmRhcmQlMjBmb3JtYXQlMEFsYW5ndWFnZV9tb2RlbGluZ19leGFtcGxlJTIwJTNEJTIwJTdCJTIydGV4dCUyMiUzQSUyMCUyMlRoZSUyMHNreSUyMGlzJTIwYmx1ZS4lMjIlN0QlMEElMjMlMjBDb252ZXJzYXRpb25hbCUyMGZvcm1hdCUwQWxhbmd1YWdlX21vZGVsaW5nX2V4YW1wbGUlMjAlM0QlMjAlN0IlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwYmx1ZS4lMjIlN0QlMEElNUQlN0Q=",highlighted:`<span class="hljs-comment"># Standard format</span>
language_modeling_example = {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;The sky is blue.&quot;</span>}
<span class="hljs-comment"># Conversational format</span>
language_modeling_example = {<span class="hljs-string">&quot;messages&quot;</span>: [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}
]}`,wrap:!1}}),K=new m({props:{title:"Prompt-only",local:"prompt-only",headingTag:"h4"}}),tt=new J({props:{code:"JTIzJTIwU3RhbmRhcmQlMjBmb3JtYXQlMEFwcm9tcHRfb25seV9leGFtcGxlJTIwJTNEJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlN0QlMEElMjMlMjBDb252ZXJzYXRpb25hbCUyMGZvcm1hdCUwQXByb21wdF9vbmx5X2V4YW1wbGUlMjAlM0QlMjAlN0IlMjJwcm9tcHQlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCU1RCU3RA==",highlighted:`<span class="hljs-comment"># Standard format</span>
prompt_only_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>}
<span class="hljs-comment"># Conversational format</span>
prompt_only_example = {<span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}]}`,wrap:!1}}),x=new yn({props:{$$slots:{default:[Ap]},$$scope:{ctx:$}}}),st=new m({props:{title:"Prompt-completion",local:"prompt-completion",headingTag:"h4"}}),et=new J({props:{code:"JTIzJTIwU3RhbmRhcmQlMjBmb3JtYXQlMEFwcm9tcHRfY29tcGxldGlvbl9leGFtcGxlJTIwJTNEJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTIyJTIwYmx1ZS4lMjIlN0QlMEElMjMlMjBDb252ZXJzYXRpb25hbCUyMGZvcm1hdCUwQXByb21wdF9jb21wbGV0aW9uX2V4YW1wbGUlMjAlM0QlMjAlN0IlMjJwcm9tcHQlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBibHVlLiUyMiU3RCU1RCU3RA==",highlighted:`<span class="hljs-comment"># Standard format</span>
prompt_completion_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>}
<span class="hljs-comment"># Conversational format</span>
prompt_completion_example = {<span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
                             <span class="hljs-string">&quot;completion&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}]}`,wrap:!1}}),at=new m({props:{title:"Preference",local:"preference",headingTag:"h4"}}),pt=new J({props:{code:"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",highlighted:`<span class="hljs-comment"># Standard format</span>
<span class="hljs-comment">## Explicit prompt (recommended)</span>
preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot; green.&quot;</span>}
<span class="hljs-comment"># Implicit prompt</span>
preference_example = {<span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot;The sky is blue.&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot;The sky is green.&quot;</span>}

<span class="hljs-comment"># Conversational format</span>
<span class="hljs-comment">## Explicit prompt (recommended)</span>
preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
                      <span class="hljs-string">&quot;chosen&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
                      <span class="hljs-string">&quot;rejected&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}]}
<span class="hljs-comment">## Implicit prompt</span>
preference_example = {<span class="hljs-string">&quot;chosen&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>},
                                 {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
                      <span class="hljs-string">&quot;rejected&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>},
                                   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}]}`,wrap:!1}}),it=new m({props:{title:"Unpaired preference",local:"unpaired-preference",headingTag:"h4"}}),Mt=new J({props:{code:"JTIzJTIwU3RhbmRhcmQlMjBmb3JtYXQlMEF1bnBhaXJlZF9wcmVmZXJlbmNlX2V4YW1wbGUlMjAlM0QlMjAlN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlMjBibHVlLiUyMiUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwVHJ1ZSU3RCUwQSUyMyUyMENvbnZlcnNhdGlvbmFsJTIwZm9ybWF0JTBBdW5wYWlyZWRfcHJlZmVyZW5jZV9leGFtcGxlJTIwJTNEJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwYmx1ZS4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYWJlbCUyMiUzQSUyMFRydWUlN0Q=",highlighted:`<span class="hljs-comment"># Standard format</span>
unpaired_preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">True</span>}
<span class="hljs-comment"># Conversational format</span>
unpaired_preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
                               <span class="hljs-string">&quot;completion&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
                               <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">True</span>}`,wrap:!1}}),ct=new m({props:{title:"Stepwise supervision",local:"stepwise-supervision",headingTag:"h4"}}),ut=new J({props:{code:"c3RlcHdpc2VfZXhhbXBsZSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCUyMldoaWNoJTIwbnVtYmVyJTIwaXMlMjBsYXJnZXIlMkMlMjA5LjglMjBvciUyMDkuMTElM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjb21wbGV0aW9ucyUyMiUzQSUyMCU1QiUyMlRoZSUyMGZyYWN0aW9uYWwlMjBwYXJ0JTIwb2YlMjA5LjglMjBpcyUyMDAuOCUyQyUyMHdoaWxlJTIwdGhlJTIwZnJhY3Rpb25hbCUyMHBhcnQlMjBvZiUyMDkuMTElMjBpcyUyMDAuMTEuJTIyJTJDJTIwJTIyU2luY2UlMjAwLjExJTIwaXMlMjBncmVhdGVyJTIwdGhhbiUyMDAuOCUyQyUyMHRoZSUyMG51bWJlciUyMDkuMTElMjBpcyUyMGxhcmdlciUyMHRoYW4lMjA5LjguJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIybGFiZWxzJTIyJTNBJTIwJTVCVHJ1ZSUyQyUyMEZhbHNlJTVEJTBBJTdE",highlighted:`stepwise_example = {
    <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;Which number is larger, 9.8 or 9.11?&quot;</span>,
    <span class="hljs-string">&quot;completions&quot;</span>: [<span class="hljs-string">&quot;The fractional part of 9.8 is 0.8, while the fractional part of 9.11 is 0.11.&quot;</span>, <span class="hljs-string">&quot;Since 0.11 is greater than 0.8, the number 9.11 is larger than 9.8.&quot;</span>],
    <span class="hljs-string">&quot;labels&quot;</span>: [<span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>]
}`,wrap:!1}}),jt=new m({props:{title:"Which dataset type to use?",local:"which-dataset-type-to-use",headingTag:"h2"}}),G=new yn({props:{$$slots:{default:[xp]},$$scope:{ctx:$}}}),Ut=new m({props:{title:"Working with conversational datasets in TRL",local:"working-with-conversational-datasets-in-trl",headingTag:"h2"}}),Tt=new m({props:{title:"Converting a conversational dataset into a standard dataset",local:"converting-a-conversational-dataset-into-a-standard-dataset",headingTag:"h3"}}),qt=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwYXBwbHlfY2hhdF90ZW1wbGF0ZSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktMTI4ay1pbnN0cnVjdCUyMiklMEElMEFleGFtcGxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwYmx1ZS4lMjIlN0QlNUQlMEElN0QlMEElMEFhcHBseV9jaGF0X3RlbXBsYXRlKGV4YW1wbGUlMkMlMjB0b2tlbml6ZXIpJTBBJTIzJTIwT3V0cHV0JTNBJTBBJTIzJTIwJTdCJ3Byb21wdCclM0ElMjAnJTNDJTdDdXNlciU3QyUzRSU1Q25XaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0Nhc3Npc3RhbnQlN0MlM0UlNUNuJyUyQyUyMCdjb21wbGV0aW9uJyUzQSUyMCdJdCUyMGlzJTIwYmx1ZS4lM0MlN0NlbmQlN0MlM0UlNUNuJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJyU3RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> apply_chat_template

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-128k-instruct&quot;</span>)

example = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
    <span class="hljs-string">&quot;completion&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}]
}

apply_chat_template(example, tokenizer)
<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># {&#x27;prompt&#x27;: &#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;, &#x27;completion&#x27;: &#x27;It is blue.&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;}</span>`,wrap:!1}}),ft=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBhcHBseV9jaGF0X3RlbXBsYXRlJTBBJTBBZGF0YXNldF9kaWN0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTVCJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGVyZSUyMGlzJTIwdGhlJTIwc3VuJTNGJTIyJTdEJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCU1QiU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJbiUyMHRoZSUyMHNreS4lMjIlN0QlNUQlNUQlMEElN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoZGF0YXNldF9kaWN0KSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChhcHBseV9jaGF0X3RlbXBsYXRlJTJDJTIwZm5fa3dhcmdzJTNEJTdCJTIydG9rZW5pemVyJTIyJTNBJTIwdG9rZW5pemVyJTdEKSUwQSUyMyUyME91dHB1dCUzQSUwQSUyMyUyMCU3Qidwcm9tcHQnJTNBJTIwJTVCJyUzQyU3Q3VzZXIlN0MlM0UlNUNuV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlM0MlN0NlbmQlN0MlM0UlNUNuJTNDJTdDYXNzaXN0YW50JTdDJTNFJTVDbiclMkMlMEElMjMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnJTNDJTdDdXNlciU3QyUzRSU1Q25XaGVyZSUyMGlzJTIwdGhlJTIwc3VuJTNGJTNDJTdDZW5kJTdDJTNFJTVDbiUzQyU3Q2Fzc2lzdGFudCU3QyUzRSU1Q24nJTVEJTJDJTBBJTIzJTIwJTIwJ2NvbXBsZXRpb24nJTNBJTIwJTVCJ0l0JTIwaXMlMjBibHVlLiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0NlbmRvZnRleHQlN0MlM0UnJTJDJTIwJ0luJTIwdGhlJTIwc2t5LiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0NlbmRvZnRleHQlN0MlM0UnJTVEJTdE",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> apply_chat_template

dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
               [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}]],
    <span class="hljs-string">&quot;completion&quot;</span>: [[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
                   [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}]]
}

dataset = Dataset.from_dict(dataset_dict)
dataset = dataset.<span class="hljs-built_in">map</span>(apply_chat_template, fn_kwargs={<span class="hljs-string">&quot;tokenizer&quot;</span>: tokenizer})
<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># {&#x27;prompt&#x27;: [&#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;,</span>
<span class="hljs-comment">#             &#x27;&lt;|user|&gt;\\nWhere is the sun?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;],</span>
<span class="hljs-comment">#  &#x27;completion&#x27;: [&#x27;It is blue.&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;, &#x27;In the sky.&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;]}</span>`,wrap:!1}}),B=new yn({props:{warning:!0,$$slots:{default:[Gp]},$$scope:{ctx:$}}}),Z=new yn({props:{warning:!0,$$slots:{default:[Bp]},$$scope:{ctx:$}}}),Ct=new m({props:{title:"Using any dataset with TRL: preprocessing and conversion",local:"using-any-dataset-with-trl-preprocessing-and-conversion",headingTag:"h2"}}),Qt=new m({props:{title:"Example: UltraFeedback dataset",local:"example-ultrafeedback-dataset",headingTag:"h3"}}),Gt=new J({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZkYXRhc2V0cyUyRnVsdHJhZmVlZGJhY2sucHklMjAtLXB1c2hfdG9faHViJTIwLS1yZXBvX2lkJTIwdHJsLWxpYiUyRnVsdHJhZmVlZGJhY2stZ3B0LTMuNS10dXJiby1oZWxwZnVsbmVzcw==",highlighted:"python examples/datasets/ultrafeedback.py --push_to_hub --repo_id trl-lib/ultrafeedback-gpt-3.5-turbo-helpfulness",wrap:!1}}),Xt=new m({props:{title:"Utilities for converting dataset types",local:"utilities-for-converting-dataset-types",headingTag:"h2"}}),Et=new m({props:{title:"From prompt-completion to language modeling dataset",local:"from-prompt-completion-to-language-modeling-dataset",headingTag:"h3"}}),zt=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCU1QiUyMiUyMGJsdWUuJTIyJTJDJTIwJTIyJTIwaW4lMjB0aGUlMjBza3kuJTIyJTVEJTJDJTBBJTdEKSUwQSUwQWRlZiUyMGNvbmNhdF9wcm9tcHRfY29tcGxldGlvbihleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnRleHQlMjIlM0ElMjBleGFtcGxlJTVCJTIycHJvbXB0JTIyJTVEJTIwJTJCJTIwZXhhbXBsZSU1QiUyMmNvbXBsZXRpb24lMjIlNUQlN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY29uY2F0X3Byb21wdF9jb21wbGV0aW9uJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0QlNUIlMjJwcm9tcHQlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concat_prompt_completion</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;completion&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(concat_prompt_completion, remove_columns=[<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>])`,wrap:!1}}),St=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),Yt=new m({props:{title:"From prompt-completion to prompt-only dataset",local:"from-prompt-completion-to-prompt-only-dataset",headingTag:"h3"}}),Ht=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCU1QiUyMiUyMGJsdWUuJTIyJTJDJTIwJTIyJTIwaW4lMjB0aGUlMjBza3kuJTIyJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCUyMmNvbXBsZXRpb24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
})

dataset = dataset.remove_columns(<span class="hljs-string">&quot;completion&quot;</span>)`,wrap:!1}}),_t=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>}`,wrap:!1}}),Dt=new m({props:{title:"From preference with implicit prompt to language modeling dataset",local:"from-preference-with-implicit-prompt-to-language-modeling-dataset",headingTag:"h3"}}),Pt=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMGJsdWUuJTIyJTJDJTIwJTIyVGhlJTIwc3VuJTIwaXMlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMlRoZSUyMHNreSUyMGlzJTIwZ3JlZW4uJTIyJTJDJTIwJTIyVGhlJTIwc3VuJTIwaXMlMjBpbiUyMHRoZSUyMHNlYS4lMjIlNUQlMkMlMEElN0QpJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVuYW1lX2NvbHVtbiglMjJjaG9zZW4lMjIlMkMlMjAlMjJ0ZXh0JTIyKS5yZW1vdmVfY29sdW1ucyglMjJyZWplY3RlZCUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot;The sky is blue.&quot;</span>, <span class="hljs-string">&quot;The sun is in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot;The sky is green.&quot;</span>, <span class="hljs-string">&quot;The sun is in the sea.&quot;</span>],
})

dataset = dataset.rename_column(<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>).remove_columns(<span class="hljs-string">&quot;rejected&quot;</span>)`,wrap:!1}}),Kt=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),Ot=new m({props:{title:"From preference with implicit prompt to prompt-completion dataset",local:"from-preference-with-implicit-prompt-to-prompt-completion-dataset",headingTag:"h3"}}),ss=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoZXh0cmFjdF9wcm9tcHQpLnJlbW92ZV9jb2x1bW5zKCUyMnJlamVjdGVkJTIyKS5yZW5hbWVfY29sdW1uKCUyMmNob3NlbiUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})
dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt).remove_columns(<span class="hljs-string">&quot;rejected&quot;</span>).rename_column(<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>)`,wrap:!1}}),ls=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}], <span class="hljs-string">&#x27;completion&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}]}`,wrap:!1}}),es=new m({props:{title:"From preference with implicit prompt to prompt-only dataset",local:"from-preference-with-implicit-prompt-to-prompt-only-dataset",headingTag:"h3"}}),ns=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoZXh0cmFjdF9wcm9tcHQpLnJlbW92ZV9jb2x1bW5zKCU1QiUyMmNob3NlbiUyMiUyQyUyMCUyMnJlamVjdGVkJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})
dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt).remove_columns([<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>])`,wrap:!1}}),ps=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}]}`,wrap:!1}}),os=new m({props:{title:"From implicit to explicit prompt preference dataset",local:"from-implicit-to-explicit-prompt-preference-dataset",headingTag:"h3"}}),rs=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoZXh0cmFjdF9wcm9tcHQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt)`,wrap:!1}}),Ms=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}],
 <span class="hljs-string">&#x27;chosen&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;rejected&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is green.&#x27;</span>}]}`,wrap:!1}}),cs=new m({props:{title:"From preference with implicit prompt to unpaired preference dataset",local:"from-preference-with-implicit-prompt-to-unpaired-preference-dataset",headingTag:"h3"}}),us=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUyQyUyMHVucGFpcl9wcmVmZXJlbmNlX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBibHVlLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2t5LiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlamVjdGVkJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBncmVlbi4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGVyZSUyMGlzJTIwdGhlJTIwc3VuJTNGJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJbiUyMHRoZSUyMHNlYS4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0QpJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGV4dHJhY3RfcHJvbXB0KSUwQWRhdGFzZXQlMjAlM0QlMjB1bnBhaXJfcHJlZmVyZW5jZV9kYXRhc2V0KGRhdGFzZXQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt, unpair_preference_dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt)
dataset = unpair_preference_dataset(dataset)`,wrap:!1}}),js=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}],
 <span class="hljs-string">&#x27;completion&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-literal">True</span>}`,wrap:!1}}),Js=new m({props:{title:"From preference to language modeling dataset",local:"from-preference-to-language-modeling-dataset",headingTag:"h3"}}),Us=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTIyJTIwYmx1ZS4lMjIlMkMlMjAlMjIlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSU3RCklMEElMEFkZWYlMjBjb25jYXRfcHJvbXB0X2Nob3NlbihleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnRleHQlMjIlM0ElMjBleGFtcGxlJTVCJTIycHJvbXB0JTIyJTVEJTIwJTJCJTIwZXhhbXBsZSU1QiUyMmNob3NlbiUyMiU1RCU3RCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChjb25jYXRfcHJvbXB0X2Nob3NlbiUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIycHJvbXB0JTIyJTJDJTIwJTIyY2hvc2VuJTIyJTJDJTIwJTIycmVqZWN0ZWQlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concat_prompt_chosen</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;chosen&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(concat_prompt_chosen, remove_columns=[<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>])`,wrap:!1}}),ms=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),Ts=new m({props:{title:"From preference to prompt-completion dataset",local:"from-preference-to-prompt-completion-dataset",headingTag:"h3"}}),Is=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTIyJTIwYmx1ZS4lMjIlMkMlMjAlMjIlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW1vdmVfY29sdW1ucyglMjJyZWplY3RlZCUyMikucmVuYW1lX2NvbHVtbiglMjJjaG9zZW4lMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
})

dataset = dataset.remove_columns(<span class="hljs-string">&quot;rejected&quot;</span>).rename_column(<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>)`,wrap:!1}}),ws=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>, <span class="hljs-string">&#x27;completion&#x27;</span>: <span class="hljs-string">&#x27; blue.&#x27;</span>}`,wrap:!1}}),qs=new m({props:{title:"From preference to prompt-only dataset",local:"from-preference-to-prompt-only-dataset",headingTag:"h3"}}),fs=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTIyJTIwYmx1ZS4lMjIlMkMlMjAlMjIlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW1vdmVfY29sdW1ucyglNUIlMjJjaG9zZW4lMjIlMkMlMjAlMjJyZWplY3RlZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
})

dataset = dataset.remove_columns([<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>])`,wrap:!1}}),Cs=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>}`,wrap:!1}}),bs=new m({props:{title:"From explicit to implicit prompt preference dataset",local:"from-explicit-to-implicit-prompt-preference-dataset",headingTag:"h3"}}),Qs=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBibHVlLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBncmVlbi4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEElMEFkZWYlMjBjb25jYXRfcHJvbXB0X3RvX2NvbXBsZXRpb25zKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyY2hvc2VuJTIyJTNBJTIwZXhhbXBsZSU1QiUyMnByb21wdCUyMiU1RCUyMCUyQiUyMGV4YW1wbGUlNUIlMjJjaG9zZW4lMjIlNUQlMkMlMjAlMjJyZWplY3RlZCUyMiUzQSUyMGV4YW1wbGUlNUIlMjJwcm9tcHQlMjIlNUQlMjAlMkIlMjBleGFtcGxlJTVCJTIycmVqZWN0ZWQlMjIlNUQlN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY29uY2F0X3Byb21wdF90b19jb21wbGV0aW9ucyUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTIycHJvbXB0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}],
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concat_prompt_to_completions</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;chosen&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;chosen&quot;</span>], <span class="hljs-string">&quot;rejected&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;rejected&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(concat_prompt_to_completions, remove_columns=<span class="hljs-string">&quot;prompt&quot;</span>)`,wrap:!1}}),Ns=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;chosen&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;rejected&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is green.&#x27;</span>}]}`,wrap:!1}}),As=new m({props:{title:"From preference to unpaired preference dataset",local:"from-preference-to-unpaired-preference-dataset",headingTag:"h3"}}),Gs=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjB1bnBhaXJfcHJlZmVyZW5jZV9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJbiUyMHRoZSUyMHNreS4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBzZWEuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjB1bnBhaXJfcHJlZmVyZW5jZV9kYXRhc2V0KGRhdGFzZXQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> unpair_preference_dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}],
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

dataset = unpair_preference_dataset(dataset)`,wrap:!1}}),Bs=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}],
 <span class="hljs-string">&#x27;completion&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-literal">True</span>}`,wrap:!1}}),Zs=new m({props:{title:"From unpaired preference to language modeling dataset",local:"from-unpaired-preference-to-language-modeling-dataset",headingTag:"h3"}}),Xs=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTJDJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJUaGUlMjBzdW4lMjBpcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMjIlMjBibHVlLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2t5LiUyMiUyQyUyMCUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCVHJ1ZSUyQyUyMFRydWUlMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTVEJTJDJTBBJTdEKSUwQSUwQWRlZiUyMGNvbmNhdGVuYXRlX3Byb21wdF9jb21wbGV0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIydGV4dCUyMiUzQSUyMGV4YW1wbGUlNUIlMjJwcm9tcHQlMjIlNUQlMjAlMkIlMjBleGFtcGxlJTVCJTIyY29tcGxldGlvbiUyMiU1RCU3RCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChjb25jYXRlbmF0ZV9wcm9tcHRfY29tcGxldGlvbikucmVtb3ZlX2NvbHVtbnMoJTVCJTIycHJvbXB0JTIyJTJDJTIwJTIyY29tcGxldGlvbiUyMiUyQyUyMCUyMmxhYmVsJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>, <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>, <span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
    <span class="hljs-string">&quot;label&quot;</span>: [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concatenate_prompt_completion</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;completion&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(concatenate_prompt_completion).remove_columns([<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),ks=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),Rs=new m({props:{title:"From unpaired preference to prompt-completion dataset",local:"from-unpaired-preference-to-prompt-completion-dataset",headingTag:"h3"}}),Es=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTJDJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJUaGUlMjBzdW4lMjBpcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMjIlMjBibHVlLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2t5LiUyMiUyQyUyMCUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCVHJ1ZSUyQyUyMFRydWUlMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMmxhYmVsJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>, <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>, <span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
    <span class="hljs-string">&quot;label&quot;</span>: [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>],
})

dataset = dataset.remove_columns([<span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),Ws=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>, <span class="hljs-string">&#x27;completion&#x27;</span>: <span class="hljs-string">&#x27; blue.&#x27;</span>}`,wrap:!1}}),zs=new m({props:{title:"From unpaired preference to prompt-only dataset",local:"from-unpaired-preference-to-prompt-only-dataset",headingTag:"h3"}}),Ys=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTJDJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJUaGUlMjBzdW4lMjBpcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMjIlMjBibHVlLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2t5LiUyMiUyQyUyMCUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCVHJ1ZSUyQyUyMFRydWUlMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMmNvbXBsZXRpb24lMjIlMkMlMjAlMjJsYWJlbCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>, <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>, <span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
    <span class="hljs-string">&quot;label&quot;</span>: [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>],
})

dataset = dataset.remove_columns([<span class="hljs-string">&quot;completion&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),Fs=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>}`,wrap:!1}}),Hs=new m({props:{title:"From stepwise supervision to language modeling dataset",local:"from-stepwise-supervision-to-language-modeling-dataset",headingTag:"h3"}}),Ds=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJCbHVlJTIwbGlnaHQlMjIlMkMlMjAlMjJXYXRlciUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb25zJTIyJTNBJTIwJTVCJTVCJTIyJTIwc2NhdHRlcnMlMjBtb3JlJTIwaW4lMjB0aGUlMjBhdG1vc3BoZXJlJTJDJTIyJTJDJTIwJTIyJTIwc28lMjB0aGUlMjBza3klMjBpcyUyMGdyZWVuLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMiUyMGZvcm1zJTIwYSUyMGxlc3MlMjBkZW5zZSUyMHN0cnVjdHVyZSUyMGluJTIwaWNlJTJDJTIyJTJDJTIwJTIyJTIwd2hpY2glMjBjYXVzZXMlMjBpdCUyMHRvJTIwZXhwYW5kJTIwd2hlbiUyMGl0JTIwZnJlZXplcy4lMjIlNUQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJsYWJlbHMlMjIlM0ElMjAlNUIlNUJUcnVlJTJDJTIwRmFsc2UlNUQlMkMlMjAlNUJUcnVlJTJDJTIwVHJ1ZSU1RCU1RCUyQyUwQSU3RCklMEElMEFkZWYlMjBjb25jYXRlbmF0ZV9wcm9tcHRfY29tcGxldGlvbnMoZXhhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBjb21wbGV0aW9uJTIwJTNEJTIwJTIyJTIyLmpvaW4oZXhhbXBsZSU1QiUyMmNvbXBsZXRpb25zJTIyJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnRleHQlMjIlM0ElMjBleGFtcGxlJTVCJTIycHJvbXB0JTIyJTVEJTIwJTJCJTIwY29tcGxldGlvbiU3RCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChjb25jYXRlbmF0ZV9wcm9tcHRfY29tcGxldGlvbnMlMkMlMjByZW1vdmVfY29sdW1ucyUzRCU1QiUyMnByb21wdCUyMiUyQyUyMCUyMmNvbXBsZXRpb25zJTIyJTJDJTIwJTIybGFiZWxzJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;Blue light&quot;</span>, <span class="hljs-string">&quot;Water&quot;</span>],
    <span class="hljs-string">&quot;completions&quot;</span>: [[<span class="hljs-string">&quot; scatters more in the atmosphere,&quot;</span>, <span class="hljs-string">&quot; so the sky is green.&quot;</span>],
                   [<span class="hljs-string">&quot; forms a less dense structure in ice,&quot;</span>, <span class="hljs-string">&quot; which causes it to expand when it freezes.&quot;</span>]],
    <span class="hljs-string">&quot;labels&quot;</span>: [[<span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>], [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>]],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concatenate_prompt_completions</span>(<span class="hljs-params">example</span>):
    completion = <span class="hljs-string">&quot;&quot;</span>.join(example[<span class="hljs-string">&quot;completions&quot;</span>])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + completion}

dataset = dataset.<span class="hljs-built_in">map</span>(concatenate_prompt_completions, remove_columns=[<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;completions&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])`,wrap:!1}}),Ls=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Blue light scatters more in the atmosphere, so the sky is green.&#x27;</span>}`,wrap:!1}}),Ps=new m({props:{title:"From stepwise supervision to prompt completion dataset",local:"from-stepwise-supervision-to-prompt-completion-dataset",headingTag:"h3"}}),Os=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJCbHVlJTIwbGlnaHQlMjIlMkMlMjAlMjJXYXRlciUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb25zJTIyJTNBJTIwJTVCJTVCJTIyJTIwc2NhdHRlcnMlMjBtb3JlJTIwaW4lMjB0aGUlMjBhdG1vc3BoZXJlJTJDJTIyJTJDJTIwJTIyJTIwc28lMjB0aGUlMjBza3klMjBpcyUyMGdyZWVuLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMiUyMGZvcm1zJTIwYSUyMGxlc3MlMjBkZW5zZSUyMHN0cnVjdHVyZSUyMGluJTIwaWNlJTJDJTIyJTJDJTIwJTIyJTIwd2hpY2glMjBjYXVzZXMlMjBpdCUyMHRvJTIwZXhwYW5kJTIwd2hlbiUyMGl0JTIwZnJlZXplcy4lMjIlNUQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJsYWJlbHMlMjIlM0ElMjAlNUIlNUJUcnVlJTJDJTIwRmFsc2UlNUQlMkMlMjAlNUJUcnVlJTJDJTIwVHJ1ZSU1RCU1RCUyQyUwQSU3RCklMEElMEFkZWYlMjBqb2luX2NvbXBsZXRpb25zKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwY29tcGxldGlvbiUyMCUzRCUyMCUyMiUyMi5qb2luKGV4YW1wbGUlNUIlMjJjb21wbGV0aW9ucyUyMiU1RCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJjb21wbGV0aW9uJTIyJTNBJTIwY29tcGxldGlvbiU3RCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChqb2luX2NvbXBsZXRpb25zJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0QlNUIlMjJjb21wbGV0aW9ucyUyMiUyQyUyMCUyMmxhYmVscyUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;Blue light&quot;</span>, <span class="hljs-string">&quot;Water&quot;</span>],
    <span class="hljs-string">&quot;completions&quot;</span>: [[<span class="hljs-string">&quot; scatters more in the atmosphere,&quot;</span>, <span class="hljs-string">&quot; so the sky is green.&quot;</span>],
                   [<span class="hljs-string">&quot; forms a less dense structure in ice,&quot;</span>, <span class="hljs-string">&quot; which causes it to expand when it freezes.&quot;</span>]],
    <span class="hljs-string">&quot;labels&quot;</span>: [[<span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>], [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>]],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">join_completions</span>(<span class="hljs-params">example</span>):
    completion = <span class="hljs-string">&quot;&quot;</span>.join(example[<span class="hljs-string">&quot;completions&quot;</span>])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;completion&quot;</span>: completion}

dataset = dataset.<span class="hljs-built_in">map</span>(join_completions, remove_columns=[<span class="hljs-string">&quot;completions&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])`,wrap:!1}}),tl=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;Blue light&#x27;</span>, <span class="hljs-string">&#x27;completion&#x27;</span>: <span class="hljs-string">&#x27; scatters more in the atmosphere, so the sky is green.&#x27;</span>}`,wrap:!1}}),sl=new m({props:{title:"From stepwise supervision to prompt only dataset",local:"from-stepwise-supervision-to-prompt-only-dataset",headingTag:"h3"}}),el=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJCbHVlJTIwbGlnaHQlMjIlMkMlMjAlMjJXYXRlciUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb25zJTIyJTNBJTIwJTVCJTVCJTIyJTIwc2NhdHRlcnMlMjBtb3JlJTIwaW4lMjB0aGUlMjBhdG1vc3BoZXJlJTJDJTIyJTJDJTIwJTIyJTIwc28lMjB0aGUlMjBza3klMjBpcyUyMGdyZWVuLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMiUyMGZvcm1zJTIwYSUyMGxlc3MlMjBkZW5zZSUyMHN0cnVjdHVyZSUyMGluJTIwaWNlJTJDJTIyJTJDJTIwJTIyJTIwd2hpY2glMjBjYXVzZXMlMjBpdCUyMHRvJTIwZXhwYW5kJTIwd2hlbiUyMGl0JTIwZnJlZXplcy4lMjIlNUQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJsYWJlbHMlMjIlM0ElMjAlNUIlNUJUcnVlJTJDJTIwRmFsc2UlNUQlMkMlMjAlNUJUcnVlJTJDJTIwVHJ1ZSU1RCU1RCUyQyUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW1vdmVfY29sdW1ucyglNUIlMjJjb21wbGV0aW9ucyUyMiUyQyUyMCUyMmxhYmVscyUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;Blue light&quot;</span>, <span class="hljs-string">&quot;Water&quot;</span>],
    <span class="hljs-string">&quot;completions&quot;</span>: [[<span class="hljs-string">&quot; scatters more in the atmosphere,&quot;</span>, <span class="hljs-string">&quot; so the sky is green.&quot;</span>],
                   [<span class="hljs-string">&quot; forms a less dense structure in ice,&quot;</span>, <span class="hljs-string">&quot; which causes it to expand when it freezes.&quot;</span>]],
    <span class="hljs-string">&quot;labels&quot;</span>: [[<span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>], [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>]],
})

dataset = dataset.remove_columns([<span class="hljs-string">&quot;completions&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])`,wrap:!1}}),al=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;Blue light&#x27;</span>}`,wrap:!1}}),nl=new m({props:{title:"From stepwise supervision to unpaired preference dataset",local:"from-stepwise-supervision-to-unpaired-preference-dataset",headingTag:"h3"}}),il=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJCbHVlJTIwbGlnaHQlMjIlMkMlMjAlMjJXYXRlciUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb25zJTIyJTNBJTIwJTVCJTVCJTIyJTIwc2NhdHRlcnMlMjBtb3JlJTIwaW4lMjB0aGUlMjBhdG1vc3BoZXJlJTJDJTIyJTJDJTIwJTIyJTIwc28lMjB0aGUlMjBza3klMjBpcyUyMGdyZWVuLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMiUyMGZvcm1zJTIwYSUyMGxlc3MlMjBkZW5zZSUyMHN0cnVjdHVyZSUyMGluJTIwaWNlJTJDJTIyJTJDJTIwJTIyJTIwd2hpY2glMjBjYXVzZXMlMjBpdCUyMHRvJTIwZXhwYW5kJTIwd2hlbiUyMGl0JTIwZnJlZXplcy4lMjIlNUQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJsYWJlbHMlMjIlM0ElMjAlNUIlNUJUcnVlJTJDJTIwRmFsc2UlNUQlMkMlMjAlNUJUcnVlJTJDJTIwVHJ1ZSU1RCU1RCUyQyUwQSU3RCklMEElMEFkZWYlMjBtZXJnZV9jb21wbGV0aW9uc19hbmRfbGFiZWxzKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwZXhhbXBsZSU1QiUyMnByb21wdCUyMiU1RCUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlMjIuam9pbihleGFtcGxlJTVCJTIyY29tcGxldGlvbnMlMjIlNUQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBhbGwoZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCklN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobWVyZ2VfY29tcGxldGlvbnNfYW5kX2xhYmVscyUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIyY29tcGxldGlvbnMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;Blue light&quot;</span>, <span class="hljs-string">&quot;Water&quot;</span>],
    <span class="hljs-string">&quot;completions&quot;</span>: [[<span class="hljs-string">&quot; scatters more in the atmosphere,&quot;</span>, <span class="hljs-string">&quot; so the sky is green.&quot;</span>],
                   [<span class="hljs-string">&quot; forms a less dense structure in ice,&quot;</span>, <span class="hljs-string">&quot; which causes it to expand when it freezes.&quot;</span>]],
    <span class="hljs-string">&quot;labels&quot;</span>: [[<span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>], [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>]],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_completions_and_labels</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;prompt&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>], <span class="hljs-string">&quot;completion&quot;</span>: <span class="hljs-string">&quot;&quot;</span>.join(example[<span class="hljs-string">&quot;completions&quot;</span>]), <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-built_in">all</span>(example[<span class="hljs-string">&quot;labels&quot;</span>])}

dataset = dataset.<span class="hljs-built_in">map</span>(merge_completions_and_labels, remove_columns=[<span class="hljs-string">&quot;completions&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])`,wrap:!1}}),rl=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;Blue light&#x27;</span>, <span class="hljs-string">&#x27;completion&#x27;</span>: <span class="hljs-string">&#x27; scatters more in the atmosphere, so the sky is green.&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),Ml=new m({props:{title:"Vision datasets",local:"vision-datasets",headingTag:"h2"}}),Jl=new J({props:{code:"JTIzJTIwVGV4dHVhbCUyMGRhdGFzZXQlM0ElMEElMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlMEElMEElMjMlMjBWaXNpb24lMjBkYXRhc2V0JTNBJTBBJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJpbWFnZSUyMiU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTIwaW4lMjB0aGUlMjBpbWFnZSUzRiUyMiU3RCUwQSU1RA==",highlighted:`<span class="hljs-comment"># Textual dataset:</span>
<span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>

<span class="hljs-comment"># Vision dataset:</span>
<span class="hljs-string">&quot;content&quot;</span>: [
    {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}, 
    {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What color is the sky in the image?&quot;</span>}
]`,wrap:!1}}),Ul=new Np({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/dataset_formats.mdx"}}),{c(){U=y("meta"),g=a(),T=y("p"),d=a(),p(q.$$.fragment),I=a(),C=y("p"),C.textContent=b,h=a(),p(w.$$.fragment),dl=a(),v=y("ul"),v.innerHTML=Jn,Il=a(),X=y("table"),X.innerHTML=hn,wl=a(),p(k.$$.fragment),ql=a(),p(R.$$.fragment),gl=a(),V=y("p"),V.textContent=Un,fl=a(),p(E.$$.fragment),Cl=a(),p(W.$$.fragment),bl=a(),z=y("p"),z.innerHTML=mn,$l=a(),p(S.$$.fragment),Ql=a(),Y=y("p"),Y.textContent=Tn,Nl=a(),p(F.$$.fragment),Al=a(),H=y("p"),H.innerHTML=dn,xl=a(),p(_.$$.fragment),Gl=a(),p(D.$$.fragment),Bl=a(),L=y("p"),L.innerHTML=In,Zl=a(),p(P.$$.fragment),vl=a(),p(K.$$.fragment),Xl=a(),O=y("p"),O.innerHTML=wn,kl=a(),p(tt.$$.fragment),Rl=a(),p(x.$$.fragment),Vl=a(),p(st.$$.fragment),El=a(),lt=y("p"),lt.innerHTML=qn,Wl=a(),p(et.$$.fragment),zl=a(),p(at.$$.fragment),Sl=a(),nt=y("p"),nt.innerHTML=gn,Yl=a(),p(pt.$$.fragment),Fl=a(),ot=y("p"),ot.innerHTML=fn,Hl=a(),p(it.$$.fragment),_l=a(),rt=y("p"),rt.innerHTML=Cn,Dl=a(),p(Mt.$$.fragment),Ll=a(),p(ct.$$.fragment),Pl=a(),yt=y("p"),yt.innerHTML=bn,Kl=a(),p(ut.$$.fragment),Ol=a(),p(jt.$$.fragment),te=a(),Jt=y("p"),Jt.textContent=$n,se=a(),ht=y("table"),ht.innerHTML=Qn,le=a(),p(G.$$.fragment),ee=a(),p(Ut.$$.fragment),ae=a(),mt=y("p"),mt.innerHTML=Nn,ne=a(),p(Tt.$$.fragment),pe=a(),dt=y("p"),dt.innerHTML=An,oe=a(),It=y("p"),It.innerHTML=xn,ie=a(),wt=y("p"),wt.innerHTML=Gn,re=a(),p(qt.$$.fragment),Me=a(),gt=y("p"),gt.innerHTML=Bn,ce=a(),p(ft.$$.fragment),ye=a(),p(B.$$.fragment),ue=a(),p(Z.$$.fragment),je=a(),p(Ct.$$.fragment),Je=a(),bt=y("p"),bt.textContent=Zn,he=a(),$t=y("p"),$t.innerHTML=vn,Ue=a(),p(Qt.$$.fragment),me=a(),Nt=y("p"),Nt.innerHTML=Xn,Te=a(),Q=y("iframe"),de=a(),At=y("p"),At.textContent=Rn,Ie=a(),xt=y("p"),xt.innerHTML=Vn,we=a(),p(Gt.$$.fragment),qe=a(),Bt=y("p"),Bt.textContent=En,ge=a(),N=y("iframe"),fe=a(),Zt=y("p"),Zt.textContent=zn,Ce=a(),vt=y("p"),vt.textContent=Sn,be=a(),p(Xt.$$.fragment),$e=a(),kt=y("p"),kt.textContent=Yn,Qe=a(),Rt=y("p"),Rt.textContent=Fn,Ne=a(),Vt=y("table"),Vt.innerHTML=Hn,Ae=a(),p(Et.$$.fragment),xe=a(),Wt=y("p"),Wt.textContent=_n,Ge=a(),p(zt.$$.fragment),Be=a(),p(St.$$.fragment),Ze=a(),p(Yt.$$.fragment),ve=a(),Ft=y("p"),Ft.textContent=Dn,Xe=a(),p(Ht.$$.fragment),ke=a(),p(_t.$$.fragment),Re=a(),p(Dt.$$.fragment),Ve=a(),Lt=y("p"),Lt.innerHTML=Ln,Ee=a(),p(Pt.$$.fragment),We=a(),p(Kt.$$.fragment),ze=a(),p(Ot.$$.fragment),Se=a(),ts=y("p"),ts.innerHTML=Pn,Ye=a(),p(ss.$$.fragment),Fe=a(),p(ls.$$.fragment),He=a(),p(es.$$.fragment),_e=a(),as=y("p"),as.innerHTML=Kn,De=a(),p(ns.$$.fragment),Le=a(),p(ps.$$.fragment),Pe=a(),p(os.$$.fragment),Ke=a(),is=y("p"),is.innerHTML=On,Oe=a(),p(rs.$$.fragment),ta=a(),p(Ms.$$.fragment),sa=a(),p(cs.$$.fragment),la=a(),ys=y("p"),ys.innerHTML=tp,ea=a(),p(us.$$.fragment),aa=a(),p(js.$$.fragment),na=a(),p(Js.$$.fragment),pa=a(),hs=y("p"),hs.innerHTML=sp,oa=a(),p(Us.$$.fragment),ia=a(),p(ms.$$.fragment),ra=a(),p(Ts.$$.fragment),Ma=a(),ds=y("p"),ds.innerHTML=lp,ca=a(),p(Is.$$.fragment),ya=a(),p(ws.$$.fragment),ua=a(),p(qs.$$.fragment),ja=a(),gs=y("p"),gs.textContent=ep,Ja=a(),p(fs.$$.fragment),ha=a(),p(Cs.$$.fragment),Ua=a(),p(bs.$$.fragment),ma=a(),$s=y("p"),$s.textContent=ap,Ta=a(),p(Qs.$$.fragment),da=a(),p(Ns.$$.fragment),Ia=a(),p(As.$$.fragment),wa=a(),xs=y("p"),xs.innerHTML=np,qa=a(),p(Gs.$$.fragment),ga=a(),p(Bs.$$.fragment),fa=a(),p(Zs.$$.fragment),Ca=a(),vs=y("p"),vs.innerHTML=pp,ba=a(),p(Xs.$$.fragment),$a=a(),p(ks.$$.fragment),Qa=a(),p(Rs.$$.fragment),Na=a(),Vs=y("p"),Vs.textContent=op,Aa=a(),p(Es.$$.fragment),xa=a(),p(Ws.$$.fragment),Ga=a(),p(zs.$$.fragment),Ba=a(),Ss=y("p"),Ss.textContent=ip,Za=a(),p(Ys.$$.fragment),va=a(),p(Fs.$$.fragment),Xa=a(),p(Hs.$$.fragment),ka=a(),_s=y("p"),_s.innerHTML=rp,Ra=a(),p(Ds.$$.fragment),Va=a(),p(Ls.$$.fragment),Ea=a(),p(Ps.$$.fragment),Wa=a(),Ks=y("p"),Ks.textContent=Mp,za=a(),p(Os.$$.fragment),Sa=a(),p(tl.$$.fragment),Ya=a(),p(sl.$$.fragment),Fa=a(),ll=y("p"),ll.textContent=cp,Ha=a(),p(el.$$.fragment),_a=a(),p(al.$$.fragment),Da=a(),p(nl.$$.fragment),La=a(),pl=y("p"),pl.textContent=yp,Pa=a(),ol=y("p"),ol.textContent=up,Ka=a(),p(il.$$.fragment),Oa=a(),p(rl.$$.fragment),tn=a(),p(Ml.$$.fragment),sn=a(),cl=y("p"),cl.textContent=jp,ln=a(),yl=y("p"),yl.textContent=Jp,en=a(),ul=y("ol"),ul.innerHTML=hp,an=a(),jl=y("p"),jl.textContent=Up,nn=a(),p(Jl.$$.fragment),pn=a(),hl=y("p"),hl.innerHTML=mp,on=a(),A=y("iframe"),rn=a(),p(Ul.$$.fragment),Mn=a(),ml=y("p"),this.h()},l(t){const s=$p("svelte-u9bgzb",document.head);U=u(s,"META",{name:!0,content:!0}),s.forEach(l),g=n(t),T=u(t,"P",{}),Tl(T).forEach(l),d=n(t),o(q.$$.fragment,t),I=n(t),C=u(t,"P",{"data-svelte-h":!0}),j(C)!=="svelte-1976wsu"&&(C.textContent=b),h=n(t),o(w.$$.fragment,t),dl=n(t),v=u(t,"UL",{"data-svelte-h":!0}),j(v)!=="svelte-fvfcsu"&&(v.innerHTML=Jn),Il=n(t),X=u(t,"TABLE",{"data-svelte-h":!0}),j(X)!=="svelte-1j4ocz4"&&(X.innerHTML=hn),wl=n(t),o(k.$$.fragment,t),ql=n(t),o(R.$$.fragment,t),gl=n(t),V=u(t,"P",{"data-svelte-h":!0}),j(V)!=="svelte-n22pbc"&&(V.textContent=Un),fl=n(t),o(E.$$.fragment,t),Cl=n(t),o(W.$$.fragment,t),bl=n(t),z=u(t,"P",{"data-svelte-h":!0}),j(z)!=="svelte-ftn6so"&&(z.innerHTML=mn),$l=n(t),o(S.$$.fragment,t),Ql=n(t),Y=u(t,"P",{"data-svelte-h":!0}),j(Y)!=="svelte-1n2btf9"&&(Y.textContent=Tn),Nl=n(t),o(F.$$.fragment,t),Al=n(t),H=u(t,"P",{"data-svelte-h":!0}),j(H)!=="svelte-1de5sg2"&&(H.innerHTML=dn),xl=n(t),o(_.$$.fragment,t),Gl=n(t),o(D.$$.fragment,t),Bl=n(t),L=u(t,"P",{"data-svelte-h":!0}),j(L)!=="svelte-zfzona"&&(L.innerHTML=In),Zl=n(t),o(P.$$.fragment,t),vl=n(t),o(K.$$.fragment,t),Xl=n(t),O=u(t,"P",{"data-svelte-h":!0}),j(O)!=="svelte-1fi7big"&&(O.innerHTML=wn),kl=n(t),o(tt.$$.fragment,t),Rl=n(t),o(x.$$.fragment,t),Vl=n(t),o(st.$$.fragment,t),El=n(t),lt=u(t,"P",{"data-svelte-h":!0}),j(lt)!=="svelte-1qh8h3u"&&(lt.innerHTML=qn),Wl=n(t),o(et.$$.fragment,t),zl=n(t),o(at.$$.fragment,t),Sl=n(t),nt=u(t,"P",{"data-svelte-h":!0}),j(nt)!=="svelte-fpgtkb"&&(nt.innerHTML=gn),Yl=n(t),o(pt.$$.fragment,t),Fl=n(t),ot=u(t,"P",{"data-svelte-h":!0}),j(ot)!=="svelte-144ttmo"&&(ot.innerHTML=fn),Hl=n(t),o(it.$$.fragment,t),_l=n(t),rt=u(t,"P",{"data-svelte-h":!0}),j(rt)!=="svelte-ds3631"&&(rt.innerHTML=Cn),Dl=n(t),o(Mt.$$.fragment,t),Ll=n(t),o(ct.$$.fragment,t),Pl=n(t),yt=u(t,"P",{"data-svelte-h":!0}),j(yt)!=="svelte-wwnrua"&&(yt.innerHTML=bn),Kl=n(t),o(ut.$$.fragment,t),Ol=n(t),o(jt.$$.fragment,t),te=n(t),Jt=u(t,"P",{"data-svelte-h":!0}),j(Jt)!=="svelte-vrn817"&&(Jt.textContent=$n),se=n(t),ht=u(t,"TABLE",{"data-svelte-h":!0}),j(ht)!=="svelte-aazyr7"&&(ht.innerHTML=Qn),le=n(t),o(G.$$.fragment,t),ee=n(t),o(Ut.$$.fragment,t),ae=n(t),mt=u(t,"P",{"data-svelte-h":!0}),j(mt)!=="svelte-10g1ofc"&&(mt.innerHTML=Nn),ne=n(t),o(Tt.$$.fragment,t),pe=n(t),dt=u(t,"P",{"data-svelte-h":!0}),j(dt)!=="svelte-18kvh4r"&&(dt.innerHTML=An),oe=n(t),It=u(t,"P",{"data-svelte-h":!0}),j(It)!=="svelte-19t1v1h"&&(It.innerHTML=xn),ie=n(t),wt=u(t,"P",{"data-svelte-h":!0}),j(wt)!=="svelte-1jvfdxb"&&(wt.innerHTML=Gn),re=n(t),o(qt.$$.fragment,t),Me=n(t),gt=u(t,"P",{"data-svelte-h":!0}),j(gt)!=="svelte-yoytwl"&&(gt.innerHTML=Bn),ce=n(t),o(ft.$$.fragment,t),ye=n(t),o(B.$$.fragment,t),ue=n(t),o(Z.$$.fragment,t),je=n(t),o(Ct.$$.fragment,t),Je=n(t),bt=u(t,"P",{"data-svelte-h":!0}),j(bt)!=="svelte-n0cp2u"&&(bt.textContent=Zn),he=n(t),$t=u(t,"P",{"data-svelte-h":!0}),j($t)!=="svelte-wbjjp8"&&($t.innerHTML=vn),Ue=n(t),o(Qt.$$.fragment,t),me=n(t),Nt=u(t,"P",{"data-svelte-h":!0}),j(Nt)!=="svelte-dr0jz6"&&(Nt.innerHTML=Xn),Te=n(t),Q=u(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Tl(Q).forEach(l),de=n(t),At=u(t,"P",{"data-svelte-h":!0}),j(At)!=="svelte-1f6n8q4"&&(At.textContent=Rn),Ie=n(t),xt=u(t,"P",{"data-svelte-h":!0}),j(xt)!=="svelte-17l9hcf"&&(xt.innerHTML=Vn),we=n(t),o(Gt.$$.fragment,t),qe=n(t),Bt=u(t,"P",{"data-svelte-h":!0}),j(Bt)!=="svelte-hplhuu"&&(Bt.textContent=En),ge=n(t),N=u(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Tl(N).forEach(l),fe=n(t),Zt=u(t,"P",{"data-svelte-h":!0}),j(Zt)!=="svelte-jt9cd3"&&(Zt.textContent=zn),Ce=n(t),vt=u(t,"P",{"data-svelte-h":!0}),j(vt)!=="svelte-1rvlfj0"&&(vt.textContent=Sn),be=n(t),o(Xt.$$.fragment,t),$e=n(t),kt=u(t,"P",{"data-svelte-h":!0}),j(kt)!=="svelte-1ttdd1s"&&(kt.textContent=Yn),Qe=n(t),Rt=u(t,"P",{"data-svelte-h":!0}),j(Rt)!=="svelte-17l70ga"&&(Rt.textContent=Fn),Ne=n(t),Vt=u(t,"TABLE",{"data-svelte-h":!0}),j(Vt)!=="svelte-byyzej"&&(Vt.innerHTML=Hn),Ae=n(t),o(Et.$$.fragment,t),xe=n(t),Wt=u(t,"P",{"data-svelte-h":!0}),j(Wt)!=="svelte-q88m1s"&&(Wt.textContent=_n),Ge=n(t),o(zt.$$.fragment,t),Be=n(t),o(St.$$.fragment,t),Ze=n(t),o(Yt.$$.fragment,t),ve=n(t),Ft=u(t,"P",{"data-svelte-h":!0}),j(Ft)!=="svelte-dplhkb"&&(Ft.textContent=Dn),Xe=n(t),o(Ht.$$.fragment,t),ke=n(t),o(_t.$$.fragment,t),Re=n(t),o(Dt.$$.fragment,t),Ve=n(t),Lt=u(t,"P",{"data-svelte-h":!0}),j(Lt)!=="svelte-u8pmva"&&(Lt.innerHTML=Ln),Ee=n(t),o(Pt.$$.fragment,t),We=n(t),o(Kt.$$.fragment,t),ze=n(t),o(Ot.$$.fragment,t),Se=n(t),ts=u(t,"P",{"data-svelte-h":!0}),j(ts)!=="svelte-kj52qv"&&(ts.innerHTML=Pn),Ye=n(t),o(ss.$$.fragment,t),Fe=n(t),o(ls.$$.fragment,t),He=n(t),o(es.$$.fragment,t),_e=n(t),as=u(t,"P",{"data-svelte-h":!0}),j(as)!=="svelte-12zrmp9"&&(as.innerHTML=Kn),De=n(t),o(ns.$$.fragment,t),Le=n(t),o(ps.$$.fragment,t),Pe=n(t),o(os.$$.fragment,t),Ke=n(t),is=u(t,"P",{"data-svelte-h":!0}),j(is)!=="svelte-bt5n5p"&&(is.innerHTML=On),Oe=n(t),o(rs.$$.fragment,t),ta=n(t),o(Ms.$$.fragment,t),sa=n(t),o(cs.$$.fragment,t),la=n(t),ys=u(t,"P",{"data-svelte-h":!0}),j(ys)!=="svelte-11shbqe"&&(ys.innerHTML=tp),ea=n(t),o(us.$$.fragment,t),aa=n(t),o(js.$$.fragment,t),na=n(t),o(Js.$$.fragment,t),pa=n(t),hs=u(t,"P",{"data-svelte-h":!0}),j(hs)!=="svelte-1azgh8u"&&(hs.innerHTML=sp),oa=n(t),o(Us.$$.fragment,t),ia=n(t),o(ms.$$.fragment,t),ra=n(t),o(Ts.$$.fragment,t),Ma=n(t),ds=u(t,"P",{"data-svelte-h":!0}),j(ds)!=="svelte-thhn9e"&&(ds.innerHTML=lp),ca=n(t),o(Is.$$.fragment,t),ya=n(t),o(ws.$$.fragment,t),ua=n(t),o(qs.$$.fragment,t),ja=n(t),gs=u(t,"P",{"data-svelte-h":!0}),j(gs)!=="svelte-yu2uu5"&&(gs.textContent=ep),Ja=n(t),o(fs.$$.fragment,t),ha=n(t),o(Cs.$$.fragment,t),Ua=n(t),o(bs.$$.fragment,t),ma=n(t),$s=u(t,"P",{"data-svelte-h":!0}),j($s)!=="svelte-slr0da"&&($s.textContent=ap),Ta=n(t),o(Qs.$$.fragment,t),da=n(t),o(Ns.$$.fragment,t),Ia=n(t),o(As.$$.fragment,t),wa=n(t),xs=u(t,"P",{"data-svelte-h":!0}),j(xs)!=="svelte-11e0vku"&&(xs.innerHTML=np),qa=n(t),o(Gs.$$.fragment,t),ga=n(t),o(Bs.$$.fragment,t),fa=n(t),o(Zs.$$.fragment,t),Ca=n(t),vs=u(t,"P",{"data-svelte-h":!0}),j(vs)!=="svelte-jxvlnn"&&(vs.innerHTML=pp),ba=n(t),o(Xs.$$.fragment,t),$a=n(t),o(ks.$$.fragment,t),Qa=n(t),o(Rs.$$.fragment,t),Na=n(t),Vs=u(t,"P",{"data-svelte-h":!0}),j(Vs)!=="svelte-1gh6vos"&&(Vs.textContent=op),Aa=n(t),o(Es.$$.fragment,t),xa=n(t),o(Ws.$$.fragment,t),Ga=n(t),o(zs.$$.fragment,t),Ba=n(t),Ss=u(t,"P",{"data-svelte-h":!0}),j(Ss)!=="svelte-1x58tju"&&(Ss.textContent=ip),Za=n(t),o(Ys.$$.fragment,t),va=n(t),o(Fs.$$.fragment,t),Xa=n(t),o(Hs.$$.fragment,t),ka=n(t),_s=u(t,"P",{"data-svelte-h":!0}),j(_s)!=="svelte-svjejq"&&(_s.innerHTML=rp),Ra=n(t),o(Ds.$$.fragment,t),Va=n(t),o(Ls.$$.fragment,t),Ea=n(t),o(Ps.$$.fragment,t),Wa=n(t),Ks=u(t,"P",{"data-svelte-h":!0}),j(Ks)!=="svelte-xgqw8b"&&(Ks.textContent=Mp),za=n(t),o(Os.$$.fragment,t),Sa=n(t),o(tl.$$.fragment,t),Ya=n(t),o(sl.$$.fragment,t),Fa=n(t),ll=u(t,"P",{"data-svelte-h":!0}),j(ll)!=="svelte-1fb8htv"&&(ll.textContent=cp),Ha=n(t),o(el.$$.fragment,t),_a=n(t),o(al.$$.fragment,t),Da=n(t),o(nl.$$.fragment,t),La=n(t),pl=u(t,"P",{"data-svelte-h":!0}),j(pl)!=="svelte-1p3ncex"&&(pl.textContent=yp),Pa=n(t),ol=u(t,"P",{"data-svelte-h":!0}),j(ol)!=="svelte-wppc03"&&(ol.textContent=up),Ka=n(t),o(il.$$.fragment,t),Oa=n(t),o(rl.$$.fragment,t),tn=n(t),o(Ml.$$.fragment,t),sn=n(t),cl=u(t,"P",{"data-svelte-h":!0}),j(cl)!=="svelte-1f2j4bf"&&(cl.textContent=jp),ln=n(t),yl=u(t,"P",{"data-svelte-h":!0}),j(yl)!=="svelte-1dkity6"&&(yl.textContent=Jp),en=n(t),ul=u(t,"OL",{"data-svelte-h":!0}),j(ul)!=="svelte-imd92t"&&(ul.innerHTML=hp),an=n(t),jl=u(t,"P",{"data-svelte-h":!0}),j(jl)!=="svelte-11lpom8"&&(jl.textContent=Up),nn=n(t),o(Jl.$$.fragment,t),pn=n(t),hl=u(t,"P",{"data-svelte-h":!0}),j(hl)!=="svelte-11ot8l1"&&(hl.innerHTML=mp),on=n(t),A=u(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Tl(A).forEach(l),rn=n(t),o(Ul.$$.fragment,t),Mn=n(t),ml=u(t,"P",{}),Tl(ml).forEach(l),this.h()},h(){f(U,"name","hf:doc:metadata"),f(U,"content",vp),jn(Q.src,kn="https://huggingface.co/datasets/openbmb/UltraFeedback/embed/viewer/default/train")||f(Q,"src",kn),f(Q,"frameborder","0"),f(Q,"width","100%"),f(Q,"height","560px"),jn(N.src,Wn="https://huggingface.co/datasets/trl-lib/ultrafeedback-gpt-3.5-turbo-helpfulness/embed/viewer/default/train?row=0")||f(N,"src",Wn),f(N,"frameborder","0"),f(N,"width","100%"),f(N,"height","560px"),jn(A.src,Tp="https://huggingface.co/datasets/trl-lib/rlaif-v/embed/viewer/default/train")||f(A,"src",Tp),f(A,"frameborder","0"),f(A,"width","100%"),f(A,"height","560px")},m(t,s){Qp(document.head,U),e(t,g,s),e(t,T,s),e(t,d,s),i(q,t,s),e(t,I,s),e(t,C,s),e(t,h,s),i(w,t,s),e(t,dl,s),e(t,v,s),e(t,Il,s),e(t,X,s),e(t,wl,s),i(k,t,s),e(t,ql,s),i(R,t,s),e(t,gl,s),e(t,V,s),e(t,fl,s),i(E,t,s),e(t,Cl,s),i(W,t,s),e(t,bl,s),e(t,z,s),e(t,$l,s),i(S,t,s),e(t,Ql,s),e(t,Y,s),e(t,Nl,s),i(F,t,s),e(t,Al,s),e(t,H,s),e(t,xl,s),i(_,t,s),e(t,Gl,s),i(D,t,s),e(t,Bl,s),e(t,L,s),e(t,Zl,s),i(P,t,s),e(t,vl,s),i(K,t,s),e(t,Xl,s),e(t,O,s),e(t,kl,s),i(tt,t,s),e(t,Rl,s),i(x,t,s),e(t,Vl,s),i(st,t,s),e(t,El,s),e(t,lt,s),e(t,Wl,s),i(et,t,s),e(t,zl,s),i(at,t,s),e(t,Sl,s),e(t,nt,s),e(t,Yl,s),i(pt,t,s),e(t,Fl,s),e(t,ot,s),e(t,Hl,s),i(it,t,s),e(t,_l,s),e(t,rt,s),e(t,Dl,s),i(Mt,t,s),e(t,Ll,s),i(ct,t,s),e(t,Pl,s),e(t,yt,s),e(t,Kl,s),i(ut,t,s),e(t,Ol,s),i(jt,t,s),e(t,te,s),e(t,Jt,s),e(t,se,s),e(t,ht,s),e(t,le,s),i(G,t,s),e(t,ee,s),i(Ut,t,s),e(t,ae,s),e(t,mt,s),e(t,ne,s),i(Tt,t,s),e(t,pe,s),e(t,dt,s),e(t,oe,s),e(t,It,s),e(t,ie,s),e(t,wt,s),e(t,re,s),i(qt,t,s),e(t,Me,s),e(t,gt,s),e(t,ce,s),i(ft,t,s),e(t,ye,s),i(B,t,s),e(t,ue,s),i(Z,t,s),e(t,je,s),i(Ct,t,s),e(t,Je,s),e(t,bt,s),e(t,he,s),e(t,$t,s),e(t,Ue,s),i(Qt,t,s),e(t,me,s),e(t,Nt,s),e(t,Te,s),e(t,Q,s),e(t,de,s),e(t,At,s),e(t,Ie,s),e(t,xt,s),e(t,we,s),i(Gt,t,s),e(t,qe,s),e(t,Bt,s),e(t,ge,s),e(t,N,s),e(t,fe,s),e(t,Zt,s),e(t,Ce,s),e(t,vt,s),e(t,be,s),i(Xt,t,s),e(t,$e,s),e(t,kt,s),e(t,Qe,s),e(t,Rt,s),e(t,Ne,s),e(t,Vt,s),e(t,Ae,s),i(Et,t,s),e(t,xe,s),e(t,Wt,s),e(t,Ge,s),i(zt,t,s),e(t,Be,s),i(St,t,s),e(t,Ze,s),i(Yt,t,s),e(t,ve,s),e(t,Ft,s),e(t,Xe,s),i(Ht,t,s),e(t,ke,s),i(_t,t,s),e(t,Re,s),i(Dt,t,s),e(t,Ve,s),e(t,Lt,s),e(t,Ee,s),i(Pt,t,s),e(t,We,s),i(Kt,t,s),e(t,ze,s),i(Ot,t,s),e(t,Se,s),e(t,ts,s),e(t,Ye,s),i(ss,t,s),e(t,Fe,s),i(ls,t,s),e(t,He,s),i(es,t,s),e(t,_e,s),e(t,as,s),e(t,De,s),i(ns,t,s),e(t,Le,s),i(ps,t,s),e(t,Pe,s),i(os,t,s),e(t,Ke,s),e(t,is,s),e(t,Oe,s),i(rs,t,s),e(t,ta,s),i(Ms,t,s),e(t,sa,s),i(cs,t,s),e(t,la,s),e(t,ys,s),e(t,ea,s),i(us,t,s),e(t,aa,s),i(js,t,s),e(t,na,s),i(Js,t,s),e(t,pa,s),e(t,hs,s),e(t,oa,s),i(Us,t,s),e(t,ia,s),i(ms,t,s),e(t,ra,s),i(Ts,t,s),e(t,Ma,s),e(t,ds,s),e(t,ca,s),i(Is,t,s),e(t,ya,s),i(ws,t,s),e(t,ua,s),i(qs,t,s),e(t,ja,s),e(t,gs,s),e(t,Ja,s),i(fs,t,s),e(t,ha,s),i(Cs,t,s),e(t,Ua,s),i(bs,t,s),e(t,ma,s),e(t,$s,s),e(t,Ta,s),i(Qs,t,s),e(t,da,s),i(Ns,t,s),e(t,Ia,s),i(As,t,s),e(t,wa,s),e(t,xs,s),e(t,qa,s),i(Gs,t,s),e(t,ga,s),i(Bs,t,s),e(t,fa,s),i(Zs,t,s),e(t,Ca,s),e(t,vs,s),e(t,ba,s),i(Xs,t,s),e(t,$a,s),i(ks,t,s),e(t,Qa,s),i(Rs,t,s),e(t,Na,s),e(t,Vs,s),e(t,Aa,s),i(Es,t,s),e(t,xa,s),i(Ws,t,s),e(t,Ga,s),i(zs,t,s),e(t,Ba,s),e(t,Ss,s),e(t,Za,s),i(Ys,t,s),e(t,va,s),i(Fs,t,s),e(t,Xa,s),i(Hs,t,s),e(t,ka,s),e(t,_s,s),e(t,Ra,s),i(Ds,t,s),e(t,Va,s),i(Ls,t,s),e(t,Ea,s),i(Ps,t,s),e(t,Wa,s),e(t,Ks,s),e(t,za,s),i(Os,t,s),e(t,Sa,s),i(tl,t,s),e(t,Ya,s),i(sl,t,s),e(t,Fa,s),e(t,ll,s),e(t,Ha,s),i(el,t,s),e(t,_a,s),i(al,t,s),e(t,Da,s),i(nl,t,s),e(t,La,s),e(t,pl,s),e(t,Pa,s),e(t,ol,s),e(t,Ka,s),i(il,t,s),e(t,Oa,s),i(rl,t,s),e(t,tn,s),i(Ml,t,s),e(t,sn,s),e(t,cl,s),e(t,ln,s),e(t,yl,s),e(t,en,s),e(t,ul,s),e(t,an,s),e(t,jl,s),e(t,nn,s),i(Jl,t,s),e(t,pn,s),e(t,hl,s),e(t,on,s),e(t,A,s),e(t,rn,s),i(Ul,t,s),e(t,Mn,s),e(t,ml,s),cn=!0},p(t,[s]){const dp={};s&2&&(dp.$$scope={dirty:s,ctx:t}),x.$set(dp);const Ip={};s&2&&(Ip.$$scope={dirty:s,ctx:t}),G.$set(Ip);const wp={};s&2&&(wp.$$scope={dirty:s,ctx:t}),B.$set(wp);const qp={};s&2&&(qp.$$scope={dirty:s,ctx:t}),Z.$set(qp)},i(t){cn||(r(q.$$.fragment,t),r(w.$$.fragment,t),r(k.$$.fragment,t),r(R.$$.fragment,t),r(E.$$.fragment,t),r(W.$$.fragment,t),r(S.$$.fragment,t),r(F.$$.fragment,t),r(_.$$.fragment,t),r(D.$$.fragment,t),r(P.$$.fragment,t),r(K.$$.fragment,t),r(tt.$$.fragment,t),r(x.$$.fragment,t),r(st.$$.fragment,t),r(et.$$.fragment,t),r(at.$$.fragment,t),r(pt.$$.fragment,t),r(it.$$.fragment,t),r(Mt.$$.fragment,t),r(ct.$$.fragment,t),r(ut.$$.fragment,t),r(jt.$$.fragment,t),r(G.$$.fragment,t),r(Ut.$$.fragment,t),r(Tt.$$.fragment,t),r(qt.$$.fragment,t),r(ft.$$.fragment,t),r(B.$$.fragment,t),r(Z.$$.fragment,t),r(Ct.$$.fragment,t),r(Qt.$$.fragment,t),r(Gt.$$.fragment,t),r(Xt.$$.fragment,t),r(Et.$$.fragment,t),r(zt.$$.fragment,t),r(St.$$.fragment,t),r(Yt.$$.fragment,t),r(Ht.$$.fragment,t),r(_t.$$.fragment,t),r(Dt.$$.fragment,t),r(Pt.$$.fragment,t),r(Kt.$$.fragment,t),r(Ot.$$.fragment,t),r(ss.$$.fragment,t),r(ls.$$.fragment,t),r(es.$$.fragment,t),r(ns.$$.fragment,t),r(ps.$$.fragment,t),r(os.$$.fragment,t),r(rs.$$.fragment,t),r(Ms.$$.fragment,t),r(cs.$$.fragment,t),r(us.$$.fragment,t),r(js.$$.fragment,t),r(Js.$$.fragment,t),r(Us.$$.fragment,t),r(ms.$$.fragment,t),r(Ts.$$.fragment,t),r(Is.$$.fragment,t),r(ws.$$.fragment,t),r(qs.$$.fragment,t),r(fs.$$.fragment,t),r(Cs.$$.fragment,t),r(bs.$$.fragment,t),r(Qs.$$.fragment,t),r(Ns.$$.fragment,t),r(As.$$.fragment,t),r(Gs.$$.fragment,t),r(Bs.$$.fragment,t),r(Zs.$$.fragment,t),r(Xs.$$.fragment,t),r(ks.$$.fragment,t),r(Rs.$$.fragment,t),r(Es.$$.fragment,t),r(Ws.$$.fragment,t),r(zs.$$.fragment,t),r(Ys.$$.fragment,t),r(Fs.$$.fragment,t),r(Hs.$$.fragment,t),r(Ds.$$.fragment,t),r(Ls.$$.fragment,t),r(Ps.$$.fragment,t),r(Os.$$.fragment,t),r(tl.$$.fragment,t),r(sl.$$.fragment,t),r(el.$$.fragment,t),r(al.$$.fragment,t),r(nl.$$.fragment,t),r(il.$$.fragment,t),r(rl.$$.fragment,t),r(Ml.$$.fragment,t),r(Jl.$$.fragment,t),r(Ul.$$.fragment,t),cn=!0)},o(t){M(q.$$.fragment,t),M(w.$$.fragment,t),M(k.$$.fragment,t),M(R.$$.fragment,t),M(E.$$.fragment,t),M(W.$$.fragment,t),M(S.$$.fragment,t),M(F.$$.fragment,t),M(_.$$.fragment,t),M(D.$$.fragment,t),M(P.$$.fragment,t),M(K.$$.fragment,t),M(tt.$$.fragment,t),M(x.$$.fragment,t),M(st.$$.fragment,t),M(et.$$.fragment,t),M(at.$$.fragment,t),M(pt.$$.fragment,t),M(it.$$.fragment,t),M(Mt.$$.fragment,t),M(ct.$$.fragment,t),M(ut.$$.fragment,t),M(jt.$$.fragment,t),M(G.$$.fragment,t),M(Ut.$$.fragment,t),M(Tt.$$.fragment,t),M(qt.$$.fragment,t),M(ft.$$.fragment,t),M(B.$$.fragment,t),M(Z.$$.fragment,t),M(Ct.$$.fragment,t),M(Qt.$$.fragment,t),M(Gt.$$.fragment,t),M(Xt.$$.fragment,t),M(Et.$$.fragment,t),M(zt.$$.fragment,t),M(St.$$.fragment,t),M(Yt.$$.fragment,t),M(Ht.$$.fragment,t),M(_t.$$.fragment,t),M(Dt.$$.fragment,t),M(Pt.$$.fragment,t),M(Kt.$$.fragment,t),M(Ot.$$.fragment,t),M(ss.$$.fragment,t),M(ls.$$.fragment,t),M(es.$$.fragment,t),M(ns.$$.fragment,t),M(ps.$$.fragment,t),M(os.$$.fragment,t),M(rs.$$.fragment,t),M(Ms.$$.fragment,t),M(cs.$$.fragment,t),M(us.$$.fragment,t),M(js.$$.fragment,t),M(Js.$$.fragment,t),M(Us.$$.fragment,t),M(ms.$$.fragment,t),M(Ts.$$.fragment,t),M(Is.$$.fragment,t),M(ws.$$.fragment,t),M(qs.$$.fragment,t),M(fs.$$.fragment,t),M(Cs.$$.fragment,t),M(bs.$$.fragment,t),M(Qs.$$.fragment,t),M(Ns.$$.fragment,t),M(As.$$.fragment,t),M(Gs.$$.fragment,t),M(Bs.$$.fragment,t),M(Zs.$$.fragment,t),M(Xs.$$.fragment,t),M(ks.$$.fragment,t),M(Rs.$$.fragment,t),M(Es.$$.fragment,t),M(Ws.$$.fragment,t),M(zs.$$.fragment,t),M(Ys.$$.fragment,t),M(Fs.$$.fragment,t),M(Hs.$$.fragment,t),M(Ds.$$.fragment,t),M(Ls.$$.fragment,t),M(Ps.$$.fragment,t),M(Os.$$.fragment,t),M(tl.$$.fragment,t),M(sl.$$.fragment,t),M(el.$$.fragment,t),M(al.$$.fragment,t),M(nl.$$.fragment,t),M(il.$$.fragment,t),M(rl.$$.fragment,t),M(Ml.$$.fragment,t),M(Jl.$$.fragment,t),M(Ul.$$.fragment,t),cn=!1},d(t){t&&(l(g),l(T),l(d),l(I),l(C),l(h),l(dl),l(v),l(Il),l(X),l(wl),l(ql),l(gl),l(V),l(fl),l(Cl),l(bl),l(z),l($l),l(Ql),l(Y),l(Nl),l(Al),l(H),l(xl),l(Gl),l(Bl),l(L),l(Zl),l(vl),l(Xl),l(O),l(kl),l(Rl),l(Vl),l(El),l(lt),l(Wl),l(zl),l(Sl),l(nt),l(Yl),l(Fl),l(ot),l(Hl),l(_l),l(rt),l(Dl),l(Ll),l(Pl),l(yt),l(Kl),l(Ol),l(te),l(Jt),l(se),l(ht),l(le),l(ee),l(ae),l(mt),l(ne),l(pe),l(dt),l(oe),l(It),l(ie),l(wt),l(re),l(Me),l(gt),l(ce),l(ye),l(ue),l(je),l(Je),l(bt),l(he),l($t),l(Ue),l(me),l(Nt),l(Te),l(Q),l(de),l(At),l(Ie),l(xt),l(we),l(qe),l(Bt),l(ge),l(N),l(fe),l(Zt),l(Ce),l(vt),l(be),l($e),l(kt),l(Qe),l(Rt),l(Ne),l(Vt),l(Ae),l(xe),l(Wt),l(Ge),l(Be),l(Ze),l(ve),l(Ft),l(Xe),l(ke),l(Re),l(Ve),l(Lt),l(Ee),l(We),l(ze),l(Se),l(ts),l(Ye),l(Fe),l(He),l(_e),l(as),l(De),l(Le),l(Pe),l(Ke),l(is),l(Oe),l(ta),l(sa),l(la),l(ys),l(ea),l(aa),l(na),l(pa),l(hs),l(oa),l(ia),l(ra),l(Ma),l(ds),l(ca),l(ya),l(ua),l(ja),l(gs),l(Ja),l(ha),l(Ua),l(ma),l($s),l(Ta),l(da),l(Ia),l(wa),l(xs),l(qa),l(ga),l(fa),l(Ca),l(vs),l(ba),l($a),l(Qa),l(Na),l(Vs),l(Aa),l(xa),l(Ga),l(Ba),l(Ss),l(Za),l(va),l(Xa),l(ka),l(_s),l(Ra),l(Va),l(Ea),l(Wa),l(Ks),l(za),l(Sa),l(Ya),l(Fa),l(ll),l(Ha),l(_a),l(Da),l(La),l(pl),l(Pa),l(ol),l(Ka),l(Oa),l(tn),l(sn),l(cl),l(ln),l(yl),l(en),l(ul),l(an),l(jl),l(nn),l(pn),l(hl),l(on),l(A),l(rn),l(Mn),l(ml)),l(U),c(q,t),c(w,t),c(k,t),c(R,t),c(E,t),c(W,t),c(S,t),c(F,t),c(_,t),c(D,t),c(P,t),c(K,t),c(tt,t),c(x,t),c(st,t),c(et,t),c(at,t),c(pt,t),c(it,t),c(Mt,t),c(ct,t),c(ut,t),c(jt,t),c(G,t),c(Ut,t),c(Tt,t),c(qt,t),c(ft,t),c(B,t),c(Z,t),c(Ct,t),c(Qt,t),c(Gt,t),c(Xt,t),c(Et,t),c(zt,t),c(St,t),c(Yt,t),c(Ht,t),c(_t,t),c(Dt,t),c(Pt,t),c(Kt,t),c(Ot,t),c(ss,t),c(ls,t),c(es,t),c(ns,t),c(ps,t),c(os,t),c(rs,t),c(Ms,t),c(cs,t),c(us,t),c(js,t),c(Js,t),c(Us,t),c(ms,t),c(Ts,t),c(Is,t),c(ws,t),c(qs,t),c(fs,t),c(Cs,t),c(bs,t),c(Qs,t),c(Ns,t),c(As,t),c(Gs,t),c(Bs,t),c(Zs,t),c(Xs,t),c(ks,t),c(Rs,t),c(Es,t),c(Ws,t),c(zs,t),c(Ys,t),c(Fs,t),c(Hs,t),c(Ds,t),c(Ls,t),c(Ps,t),c(Os,t),c(tl,t),c(sl,t),c(el,t),c(al,t),c(nl,t),c(il,t),c(rl,t),c(Ml,t),c(Jl,t),c(Ul,t)}}}const vp='{"title":"Dataset formats and types","local":"dataset-formats-and-types","sections":[{"title":"Overview of the dataset formats and types","local":"overview-of-the-dataset-formats-and-types","sections":[{"title":"Formats","local":"formats","sections":[{"title":"Standard","local":"standard","sections":[],"depth":4},{"title":"Conversational","local":"conversational","sections":[],"depth":4}],"depth":3},{"title":"Types","local":"types","sections":[{"title":"Language modeling","local":"language-modeling","sections":[],"depth":4},{"title":"Prompt-only","local":"prompt-only","sections":[],"depth":4},{"title":"Prompt-completion","local":"prompt-completion","sections":[],"depth":4},{"title":"Preference","local":"preference","sections":[],"depth":4},{"title":"Unpaired preference","local":"unpaired-preference","sections":[],"depth":4},{"title":"Stepwise supervision","local":"stepwise-supervision","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Which dataset type to use?","local":"which-dataset-type-to-use","sections":[],"depth":2},{"title":"Working with conversational datasets in TRL","local":"working-with-conversational-datasets-in-trl","sections":[{"title":"Converting a conversational dataset into a standard dataset","local":"converting-a-conversational-dataset-into-a-standard-dataset","sections":[],"depth":3}],"depth":2},{"title":"Using any dataset with TRL: preprocessing and conversion","local":"using-any-dataset-with-trl-preprocessing-and-conversion","sections":[{"title":"Example: UltraFeedback dataset","local":"example-ultrafeedback-dataset","sections":[],"depth":3}],"depth":2},{"title":"Utilities for converting dataset types","local":"utilities-for-converting-dataset-types","sections":[{"title":"From prompt-completion to language modeling dataset","local":"from-prompt-completion-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From prompt-completion to prompt-only dataset","local":"from-prompt-completion-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to language modeling dataset","local":"from-preference-with-implicit-prompt-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to prompt-completion dataset","local":"from-preference-with-implicit-prompt-to-prompt-completion-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to prompt-only dataset","local":"from-preference-with-implicit-prompt-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From implicit to explicit prompt preference dataset","local":"from-implicit-to-explicit-prompt-preference-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to unpaired preference dataset","local":"from-preference-with-implicit-prompt-to-unpaired-preference-dataset","sections":[],"depth":3},{"title":"From preference to language modeling dataset","local":"from-preference-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From preference to prompt-completion dataset","local":"from-preference-to-prompt-completion-dataset","sections":[],"depth":3},{"title":"From preference to prompt-only dataset","local":"from-preference-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From explicit to implicit prompt preference dataset","local":"from-explicit-to-implicit-prompt-preference-dataset","sections":[],"depth":3},{"title":"From preference to unpaired preference dataset","local":"from-preference-to-unpaired-preference-dataset","sections":[],"depth":3},{"title":"From unpaired preference to language modeling dataset","local":"from-unpaired-preference-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From unpaired preference to prompt-completion dataset","local":"from-unpaired-preference-to-prompt-completion-dataset","sections":[],"depth":3},{"title":"From unpaired preference to prompt-only dataset","local":"from-unpaired-preference-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From stepwise supervision to language modeling dataset","local":"from-stepwise-supervision-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From stepwise supervision to prompt completion dataset","local":"from-stepwise-supervision-to-prompt-completion-dataset","sections":[],"depth":3},{"title":"From stepwise supervision to prompt only dataset","local":"from-stepwise-supervision-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From stepwise supervision to unpaired preference dataset","local":"from-stepwise-supervision-to-unpaired-preference-dataset","sections":[],"depth":3}],"depth":2},{"title":"Vision datasets","local":"vision-datasets","sections":[],"depth":2}],"depth":1}';function Xp($){return fp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zp extends Cp{constructor(U){super(),bp(this,U,Xp,Zp,gp,{})}}export{zp as component};
