import{s as _o,f as vo,n as Jo,o as Uo}from"../chunks/scheduler.9039eef2.js";import{S as jo,i as Co,g as r,s as o,r as m,A as Io,h as s,f as a,c as l,j as y,u as h,x as d,k as T,l as xo,y as i,a as n,v as u,d as f,t as g,w as M}from"../chunks/index.ded8f90d.js";import{D as w}from"../chunks/Docstring.a2ba2b54.js";import{C as Jt}from"../chunks/CodeBlock.8580f3e8.js";import{H as _}from"../chunks/Heading.f027f30d.js";function $o(Tn){let C,Ut,_t,jt,E,Ct,L,yn='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://arxiv.org/abs/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by Rafailov et al., 2023. For a full example have a look at  <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo.py" rel="nofollow"><code>examples/scripts/dpo.py</code></a>.',It,R,wn="The first step as always is to train your SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",xt,H,$t,F,bn="Fine-tuning a language model via DPO consists of two steps and is easier than PPO:",Dt,N,_n="<li><strong>Data collection</strong>: Gather a preference dataset with positive and negative selected pairs of generation, given a prompt.</li> <li><strong>Optimization</strong>: Maximize the log-likelihood of the DPO loss directly.</li>",Pt,G,vn='DPO-compatible datasets can be found with <a href="https://huggingface.co/datasets?other=dpo" rel="nofollow">the tag <code>dpo</code> on Hugging Face Hub</a>.',At,Q,Jn='This process is illustrated in the sketch below (from <a href="https://arxiv.org/pdf/2305.18290.pdf" rel="nofollow">figure 1 of the original paper</a>):',kt,I,Un,Bt,z,jn='Read more about DPO algorithm in the <a href="https://arxiv.org/pdf/2305.18290.pdf" rel="nofollow">original paper</a>.',Ot,X,qt,V,Cn='The DPO trainer expects a very specific format for the dataset. Since the model will be trained to directly optimize the preference of which sentence is the most relevant, given two sentences. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',Wt,x,In='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',Zt,S,xn="Therefore the final dataset object should contain these 3 entries if you use the default <code>DPODataCollatorWithPadding</code> data collator. The entries should be named:",Et,Y,$n="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",Lt,K,Dn="for example:",Rt,ee,Ht,te,Pn="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",Ft,ae,Nt,ne,An="The DPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",Gt,oe,Qt,le,kn="For a detailed example have a look at the <code>examples/scripts/dpo.py</code> script. At a high level we need to initialize the <code>DPOTrainer</code> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",zt,re,Xt,se,Bn="After this one can then call:",Vt,ie,St,de,On="Note that the <code>beta</code> is the temperature parameter for the DPO loss, typically something in the range of <code>0.1</code> to <code>0.5</code>. We ignore the reference model as <code>beta</code> -&gt; 0.",Yt,ce,Kt,pe,qn="Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the DPO authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.",ea,me,Wn='The <a href="https://arxiv.org/abs/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper. The <code>DPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;hinge&quot;</code> argument and the <code>beta</code> in this case is the reciprocal of the margin.',ta,he,Zn='The <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss which can be used via the <code>loss_type=&quot;ipo&quot;</code> argument to the trainer. Note that the <code>beta</code>  parameter is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike DPO which is summed only).',aa,ue,En='The <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> is a tweak on the DPO loss where we assume that the preference labels are noisy with some probability that can be passed to the <code>DPOTrainer</code> via <code>label_smoothing</code> argument (between 0 and 0.5) and then a conservative DPO loss is used. Use the <code>loss_type=&quot;cdpo&quot;</code> argument to the trainer to use it.',na,fe,Ln='The <a href="https://arxiv.org/abs/2402.01306" rel="nofollow">KTO</a> authors directly maximize the utility of LLM generations instead of the log-likelihood of preferences. To use preference data with KTO, we recommend breaking up the n preferences into 2n examples and using <a href="kto_trainer"><code>KTOTrainer</code></a> (i.e., treating the data like an unpaired feedback dataset). Although it is possible to pass in <code>loss_type=&quot;kto_pair&quot;</code> into DPOTrainer, this is a highly simplified version of KTO that we <em>do not recommend</em> in most cases. Please use <a href="kto_trainer"><code>KTOTrainer</code></a> when possible.',oa,ge,la,Me,Rn="While training and evaluating we record the following reward metrics:",ra,Te,Hn="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",sa,ye,ia,we,Fn='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks for DPO listed below:',da,be,Nn="<thead><tr><th>GPU</th> <th>Model</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>A100 40G</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.24x</td> <td><strong>1.88x</strong></td> <td>-11.6%</td></tr> <tr><td>Tesla T4</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.09x</td> <td><strong>1.55x</strong></td> <td>-18.6%</td></tr></tbody>",ca,_e,Gn='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',pa,ve,ma,Je,Qn='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',ha,Ue,ua,je,zn="You have three main options (plus several variants) for how the reference model works when using PEFT, assuming the model that you would like to further enhance with DPO was tuned using (Q)LoRA.",fa,Ce,Xn="<li>Simply create two instances of the model, each loading your adapter - works fine but is very inefficient.</li> <li>Merge the adapter into the base model, create another adapter on top, then leave the <code>model_ref</code> param null, in which case DPOTrainer will unload the adapter for reference inference - efficient, but has potential downsides discussed below.</li> <li>Load the adapter twice with different names, then use <code>set_adapter</code> during training to swap between the adapter being DPO’d and the reference adapter - slightly less efficient compared to 2 (~adapter size VRAM overhead), but avoids the pitfalls.</li>",ga,Ie,Ma,xe,Vn='As suggested by <a href="https://medium.com/@bnjmn_marie/dont-merge-your-lora-adapter-into-a-4-bit-llm-65b6da287997" rel="nofollow">Benjamin Marie</a>, the best option for merging QLoRA adapters is to first dequantize the base model, then merge the adapter. Something similar to <a href="https://github.com/jondurbin/qlora/blob/main/qmerge.py" rel="nofollow">this script</a>.',Ta,$e,Sn="However, after using this approach, you will have an unquantized base model. Therefore, to use QLoRA for DPO, you will need to re-quantize the merged model or use the unquantized merge (resulting in higher memory demand).",ya,De,wa,Pe,Yn="To avoid the downsides with option 2, you can load your fine-tuned adapter into the model twice, with different names, and set the model/ref adapter names in DPOTrainer.",ba,Ae,Kn="For example:",_a,ke,va,Be,Ja,c,Oe,Oa,Se,eo="Initialize DPOTrainer.",qa,$,qe,Wa,Ye,to=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Za,D,We,Ea,Ke,ao="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",La,v,Ze,Ra,et,no="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Ha,tt,oo="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Fa,P,Ee,Na,at,lo="Concatenate the chosen and rejected inputs into a single tensor.",Ga,A,Le,Qa,nt,ro="Compute the DPO loss for a batch of policy and reference model log probabilities.",za,J,Re,Xa,ot,so=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Va,lt,io="Works both with or without labels.",Sa,k,He,Ya,rt,co="Compute the log probabilities of the given labels under the given logits.",Ka,B,Fe,en,st,po="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",tn,O,Ne,an,it,mo="Generate samples from the model and reference model for the given batch of inputs.",nn,U,Ge,on,dt,ho="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",ln,ct,uo="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",rn,j,Qe,sn,pt,fo="Returns the training <code>~torch.utils.data.DataLoader</code>.",dn,mt,go="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",cn,q,ze,pn,ht,Mo="Log <code>logs</code> on the various objects watching training, including stored metrics.",mn,W,Xe,hn,ut,To="Context manager for handling null reference model (that is, peft adapter manipulation).",un,b,Ve,fn,ft,yo="Tokenize a single row from a DPO specific dataset.",gn,gt,wo=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,Mn,Mt,bo=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,Ua,vt,ja;return E=new _({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),H=new _({props:{title:"How DPO works",local:"how-dpo-works",headingTag:"h2"}}),X=new _({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),ee=new Jt({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),ae=new _({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),oe=new _({props:{title:"Using the DPOTrainer",local:"using-the-dpotrainer",headingTag:"h2"}}),re=new Jt({props:{code:"ZHBvX3RyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfcmVmJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`dpo_trainer = DPOTrainer(
    model,
    model_ref,
    args=training_args,
    beta=<span class="hljs-number">0.1</span>,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),ie=new Jt({props:{code:"ZHBvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"dpo_trainer.train()",wrap:!1}}),ce=new _({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),ge=new _({props:{title:"Logging",local:"logging",headingTag:"h2"}}),ye=new _({props:{title:"Accelerate DPO fine-tuning using unsloth",local:"accelerate-dpo-fine-tuning-using-unsloth",headingTag:"h2"}}),ve=new Jt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number.</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/zephyr-sft&quot;</span>,
    max_seq_length = max_seq_length,
    dtype = <span class="hljs-literal">None</span>, <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False.</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
)

training_args = TrainingArguments(output_dir=<span class="hljs-string">&quot;./output&quot;</span>)

dpo_trainer = DPOTrainer(
    model,
    model_ref=<span class="hljs-literal">None</span>,
    args=training_args,
    beta=<span class="hljs-number">0.1</span>,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)
dpo_trainer.train()`,wrap:!1}}),Ue=new _({props:{title:"Reference model considerations with PEFT",local:"reference-model-considerations-with-peft",headingTag:"h2"}}),Ie=new _({props:{title:"Downsides to merging QLoRA before DPO (approach 2)",local:"downsides-to-merging-qlora-before-dpo-approach-2",headingTag:"h3"}}),De=new _({props:{title:"Using option 3 - load the adapter twice",local:"using-option-3---load-the-adapter-twice",headingTag:"h3"}}),ke=new Jt({props:{code:"JTIzJTIwTG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbC4lMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBsbG1faW50OF90aHJlc2hvbGQlM0Q2LjAlMkMlMEElMjAlMjAlMjAlMjBsbG1faW50OF9oYXNfZnAxNl93ZWlnaHQlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUwQSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtaXN0cmFsYWklMkZtaXh0cmFsLTh4N2ItdjAuMSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSklMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwYWRhcHRlci4lMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAlMjIlMkZwYXRoJTJGdG8lMkZwZWZ0JTIyJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5hYmxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGFkYXB0ZXJfbmFtZSUzRCUyMnRyYWluJTIyJTJDJTBBKSUwQSUyMyUyMExvYWQlMjB0aGUlMjBhZGFwdGVyJTIwYSUyMHNlY29uZCUyMHRpbWUlMkMlMjB3aXRoJTIwYSUyMGRpZmZlcmVudCUyMG5hbWUlMkMlMjB3aGljaCUyMHdpbGwlMjBiZSUyMG91ciUyMHJlZmVyZW5jZSUyMG1vZGVsLiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjIlMkZwYXRoJTJGdG8lMkZwZWZ0JTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIycmVmZXJlbmNlJTIyKSUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjB0cmFpbmVyJTJDJTIwd2l0aG91dCUyMGElMjByZWZfbW9kZWwlMjBwYXJhbS4lMEFkcG9fdHJhaW5lciUyMCUzRCUyMERQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjBtb2RlbF9hZGFwdGVyX25hbWUlM0QlMjJ0cmFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZl9hZGFwdGVyX25hbWUlM0QlMjJyZWZlcmVuY2UlMjIlMkMlMEEp",highlighted:`<span class="hljs-comment"># Load the base model.</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    llm_int8_threshold=<span class="hljs-number">6.0</span>,
    llm_int8_has_fp16_weight=<span class="hljs-literal">False</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/mixtral-8x7b-v0.1&quot;</span>,
    load_in_4bit=<span class="hljs-literal">True</span>,
    quantization_config=bnb_config,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the adapter.</span>
model = PeftModel.from_pretrained(
    model,
    <span class="hljs-string">&quot;/path/to/peft&quot;</span>,
    is_trainable=<span class="hljs-literal">True</span>,
    adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
)
<span class="hljs-comment"># Load the adapter a second time, with a different name, which will be our reference model.</span>
model.load_adapter(<span class="hljs-string">&quot;/path/to/peft&quot;</span>, adapter_name=<span class="hljs-string">&quot;reference&quot;</span>)

<span class="hljs-comment"># Initialize the trainer, without a ref_model param.</span>
dpo_trainer = DPOTrainer(
    model,
    ...
    model_adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
    ref_adapter_name=<span class="hljs-string">&quot;reference&quot;</span>,
)`,wrap:!1}}),Be=new _({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),Oe=new w({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOTrainer.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOTrainer.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss,<code>&quot;hinge&quot;</code> loss from <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper, <code>&quot;ipo&quot;</code> from <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> paper, or <code>&quot;kto&quot;</code> from the HALOs <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">report</a>.`,name:"loss_type"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>transformers.TrainingArguments</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOTrainer.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOTrainer.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOTrainer.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOTrainer.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOTrainer.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.DPOTrainer.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.DPOTrainer.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.DPOTrainer.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"ref_model_init_kwargs"},{anchor:"trl.DPOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"},{anchor:"trl.DPOTrainer.reference_free",description:`<strong>reference_free</strong> (<code>bool</code>) &#x2014;
If True, we ignore the <em>provided</em> reference model and implicitly use a reference model that assigns equal probability to all responses.`,name:"reference_free"},{anchor:"trl.DPOTrainer.force_use_ref_model",description:`<strong>force_use_ref_model</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
In case one passes a PEFT model for the active model and you want to use a different model for the ref_model, set this flag to <code>True</code>.`,name:"force_use_ref_model"}],source:"https://github.com/huggingface/trl/blob/v0.8.1/trl/trainer/dpo_trainer.py#L65"}}),qe=new w({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/v0.8.1/trl/trainer/dpo_trainer.py#L550"}}),We=new w({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.1/trl/trainer/dpo_trainer.py#L758"}}),Ze=new w({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.1/trl/trainer/dpo_trainer.py#L961"}}),Ee=new w({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/v0.8.1/trl/trainer/dpo_trainer.py#L782",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),Le=new w({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/v0.8.1/trl/trainer/dpo_trainer.py#L844",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Re=new w({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.8.1/trl/trainer/dpo_trainer.py#L1182"}}),He=new w({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/v0.8.1/trl/trainer/dpo_trainer.py#L923",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),Fe=new w({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/v0.8.1/trl/trainer/dpo_trainer.py#L1008"}}),Ne=new w({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.1/trl/trainer/dpo_trainer.py#L1092"}}),Ge=new w({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/v2.18.0/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/v0.8.1/trl/trainer/dpo_trainer.py#L498"}}),Qe=new w({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.8.1/trl/trainer/dpo_trainer.py#L455"}}),ze=new w({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/v0.8.1/trl/trainer/dpo_trainer.py#L1232"}}),Xe=new w({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.8.1/trl/trainer/dpo_trainer.py#L746"}}),Ve=new w({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/v0.8.1/trl/trainer/dpo_trainer.py#L600"}}),{c(){C=r("meta"),Ut=o(),_t=r("p"),jt=o(),m(E.$$.fragment),Ct=o(),L=r("p"),L.innerHTML=yn,It=o(),R=r("p"),R.textContent=wn,xt=o(),m(H.$$.fragment),$t=o(),F=r("p"),F.textContent=bn,Dt=o(),N=r("ol"),N.innerHTML=_n,Pt=o(),G=r("p"),G.innerHTML=vn,At=o(),Q=r("p"),Q.innerHTML=Jn,kt=o(),I=r("img"),Bt=o(),z=r("p"),z.innerHTML=jn,Ot=o(),m(X.$$.fragment),qt=o(),V=r("p"),V.innerHTML=Cn,Wt=o(),x=r("div"),x.innerHTML=In,Zt=o(),S=r("p"),S.innerHTML=xn,Et=o(),Y=r("ul"),Y.innerHTML=$n,Lt=o(),K=r("p"),K.textContent=Dn,Rt=o(),m(ee.$$.fragment),Ht=o(),te=r("p"),te.innerHTML=Pn,Ft=o(),m(ae.$$.fragment),Nt=o(),ne=r("p"),ne.innerHTML=An,Gt=o(),m(oe.$$.fragment),Qt=o(),le=r("p"),le.innerHTML=kn,zt=o(),m(re.$$.fragment),Xt=o(),se=r("p"),se.textContent=Bn,Vt=o(),m(ie.$$.fragment),St=o(),de=r("p"),de.innerHTML=On,Yt=o(),m(ce.$$.fragment),Kt=o(),pe=r("p"),pe.innerHTML=qn,ea=o(),me=r("p"),me.innerHTML=Wn,ta=o(),he=r("p"),he.innerHTML=Zn,aa=o(),ue=r("p"),ue.innerHTML=En,na=o(),fe=r("p"),fe.innerHTML=Ln,oa=o(),m(ge.$$.fragment),la=o(),Me=r("p"),Me.textContent=Rn,ra=o(),Te=r("ul"),Te.innerHTML=Hn,sa=o(),m(ye.$$.fragment),ia=o(),we=r("p"),we.innerHTML=Fn,da=o(),be=r("table"),be.innerHTML=Nn,ca=o(),_e=r("p"),_e.innerHTML=Gn,pa=o(),m(ve.$$.fragment),ma=o(),Je=r("p"),Je.innerHTML=Qn,ha=o(),m(Ue.$$.fragment),ua=o(),je=r("p"),je.textContent=zn,fa=o(),Ce=r("ol"),Ce.innerHTML=Xn,ga=o(),m(Ie.$$.fragment),Ma=o(),xe=r("p"),xe.innerHTML=Vn,Ta=o(),$e=r("p"),$e.textContent=Sn,ya=o(),m(De.$$.fragment),wa=o(),Pe=r("p"),Pe.textContent=Yn,ba=o(),Ae=r("p"),Ae.textContent=Kn,_a=o(),m(ke.$$.fragment),va=o(),m(Be.$$.fragment),Ja=o(),c=r("div"),m(Oe.$$.fragment),Oa=o(),Se=r("p"),Se.textContent=eo,qa=o(),$=r("div"),m(qe.$$.fragment),Wa=o(),Ye=r("p"),Ye.innerHTML=to,Za=o(),D=r("div"),m(We.$$.fragment),Ea=o(),Ke=r("p"),Ke.textContent=ao,La=o(),v=r("div"),m(Ze.$$.fragment),Ra=o(),et=r("p"),et.textContent=no,Ha=o(),tt=r("p"),tt.textContent=oo,Fa=o(),P=r("div"),m(Ee.$$.fragment),Na=o(),at=r("p"),at.textContent=lo,Ga=o(),A=r("div"),m(Le.$$.fragment),Qa=o(),nt=r("p"),nt.textContent=ro,za=o(),J=r("div"),m(Re.$$.fragment),Xa=o(),ot=r("p"),ot.innerHTML=so,Va=o(),lt=r("p"),lt.textContent=io,Sa=o(),k=r("div"),m(He.$$.fragment),Ya=o(),rt=r("p"),rt.textContent=co,Ka=o(),B=r("div"),m(Fe.$$.fragment),en=o(),st=r("p"),st.textContent=po,tn=o(),O=r("div"),m(Ne.$$.fragment),an=o(),it=r("p"),it.textContent=mo,nn=o(),U=r("div"),m(Ge.$$.fragment),on=o(),dt=r("p"),dt.innerHTML=ho,ln=o(),ct=r("p"),ct.innerHTML=uo,rn=o(),j=r("div"),m(Qe.$$.fragment),sn=o(),pt=r("p"),pt.innerHTML=fo,dn=o(),mt=r("p"),mt.innerHTML=go,cn=o(),q=r("div"),m(ze.$$.fragment),pn=o(),ht=r("p"),ht.innerHTML=Mo,mn=o(),W=r("div"),m(Xe.$$.fragment),hn=o(),ut=r("p"),ut.textContent=To,un=o(),b=r("div"),m(Ve.$$.fragment),fn=o(),ft=r("p"),ft.textContent=yo,gn=o(),gt=r("p"),gt.textContent=wo,Mn=o(),Mt=r("p"),Mt.textContent=bo,Ua=o(),vt=r("p"),this.h()},l(e){const t=Io("svelte-u9bgzb",document.head);C=s(t,"META",{name:!0,content:!0}),t.forEach(a),Ut=l(e),_t=s(e,"P",{}),y(_t).forEach(a),jt=l(e),h(E.$$.fragment,e),Ct=l(e),L=s(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-5p7twb"&&(L.innerHTML=yn),It=l(e),R=s(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-xh4sh7"&&(R.textContent=wn),xt=l(e),h(H.$$.fragment,e),$t=l(e),F=s(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-e9zjgv"&&(F.textContent=bn),Dt=l(e),N=s(e,"OL",{"data-svelte-h":!0}),d(N)!=="svelte-1fzn07o"&&(N.innerHTML=_n),Pt=l(e),G=s(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-11tyi92"&&(G.innerHTML=vn),At=l(e),Q=s(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-lms3te"&&(Q.innerHTML=Jn),kt=l(e),I=s(e,"IMG",{width:!0,alt:!0,src:!0}),Bt=l(e),z=s(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1yw8azb"&&(z.innerHTML=jn),Ot=l(e),h(X.$$.fragment,e),qt=l(e),V=s(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-dcawbe"&&(V.innerHTML=Cn),Wt=l(e),x=s(e,"DIV",{style:!0,"data-svelte-h":!0}),d(x)!=="svelte-z15c7z"&&(x.innerHTML=In),Zt=l(e),S=s(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-cb9b0v"&&(S.innerHTML=xn),Et=l(e),Y=s(e,"UL",{"data-svelte-h":!0}),d(Y)!=="svelte-17vxuta"&&(Y.innerHTML=$n),Lt=l(e),K=s(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1gl9mvz"&&(K.textContent=Dn),Rt=l(e),h(ee.$$.fragment,e),Ht=l(e),te=s(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1a8oxjk"&&(te.innerHTML=Pn),Ft=l(e),h(ae.$$.fragment,e),Nt=l(e),ne=s(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-174yw9s"&&(ne.innerHTML=An),Gt=l(e),h(oe.$$.fragment,e),Qt=l(e),le=s(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1wn9xrv"&&(le.innerHTML=kn),zt=l(e),h(re.$$.fragment,e),Xt=l(e),se=s(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1lg6q1l"&&(se.textContent=Bn),Vt=l(e),h(ie.$$.fragment,e),St=l(e),de=s(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-1ac5mum"&&(de.innerHTML=On),Yt=l(e),h(ce.$$.fragment,e),Kt=l(e),pe=s(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-7nvktz"&&(pe.innerHTML=qn),ea=l(e),me=s(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-bl9wh7"&&(me.innerHTML=Wn),ta=l(e),he=s(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-1quvcuu"&&(he.innerHTML=Zn),aa=l(e),ue=s(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-x8vvul"&&(ue.innerHTML=En),na=l(e),fe=s(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-m3f292"&&(fe.innerHTML=Ln),oa=l(e),h(ge.$$.fragment,e),la=l(e),Me=s(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-132s7j9"&&(Me.textContent=Rn),ra=l(e),Te=s(e,"UL",{"data-svelte-h":!0}),d(Te)!=="svelte-1oji3mm"&&(Te.innerHTML=Hn),sa=l(e),h(ye.$$.fragment,e),ia=l(e),we=s(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-2145zu"&&(we.innerHTML=Fn),da=l(e),be=s(e,"TABLE",{"data-svelte-h":!0}),d(be)!=="svelte-435mua"&&(be.innerHTML=Nn),ca=l(e),_e=s(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-1p74c9x"&&(_e.innerHTML=Gn),pa=l(e),h(ve.$$.fragment,e),ma=l(e),Je=s(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1o18rwj"&&(Je.innerHTML=Qn),ha=l(e),h(Ue.$$.fragment,e),ua=l(e),je=s(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-4infz6"&&(je.textContent=zn),fa=l(e),Ce=s(e,"OL",{"data-svelte-h":!0}),d(Ce)!=="svelte-1p7od7"&&(Ce.innerHTML=Xn),ga=l(e),h(Ie.$$.fragment,e),Ma=l(e),xe=s(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-rqj7uy"&&(xe.innerHTML=Vn),Ta=l(e),$e=s(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1xhv3st"&&($e.textContent=Sn),ya=l(e),h(De.$$.fragment,e),wa=l(e),Pe=s(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-a0kxee"&&(Pe.textContent=Yn),ba=l(e),Ae=s(e,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1gkqha7"&&(Ae.textContent=Kn),_a=l(e),h(ke.$$.fragment,e),va=l(e),h(Be.$$.fragment,e),Ja=l(e),c=s(e,"DIV",{class:!0});var p=y(c);h(Oe.$$.fragment,p),Oa=l(p),Se=s(p,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-n6cc8y"&&(Se.textContent=eo),qa=l(p),$=s(p,"DIV",{class:!0});var Ca=y($);h(qe.$$.fragment,Ca),Wa=l(Ca),Ye=s(Ca,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-mcz8nm"&&(Ye.innerHTML=to),Ca.forEach(a),Za=l(p),D=s(p,"DIV",{class:!0});var Ia=y(D);h(We.$$.fragment,Ia),Ea=l(Ia),Ke=s(Ia,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-10t1062"&&(Ke.textContent=ao),Ia.forEach(a),La=l(p),v=s(p,"DIV",{class:!0});var Tt=y(v);h(Ze.$$.fragment,Tt),Ra=l(Tt),et=s(Tt,"P",{"data-svelte-h":!0}),d(et)!=="svelte-16i1nac"&&(et.textContent=no),Ha=l(Tt),tt=s(Tt,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-tgti68"&&(tt.textContent=oo),Tt.forEach(a),Fa=l(p),P=s(p,"DIV",{class:!0});var xa=y(P);h(Ee.$$.fragment,xa),Na=l(xa),at=s(xa,"P",{"data-svelte-h":!0}),d(at)!=="svelte-1cvsgkk"&&(at.textContent=lo),xa.forEach(a),Ga=l(p),A=s(p,"DIV",{class:!0});var $a=y(A);h(Le.$$.fragment,$a),Qa=l($a),nt=s($a,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-ymgxq7"&&(nt.textContent=ro),$a.forEach(a),za=l(p),J=s(p,"DIV",{class:!0});var yt=y(J);h(Re.$$.fragment,yt),Xa=l(yt),ot=s(yt,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-8qlty5"&&(ot.innerHTML=so),Va=l(yt),lt=s(yt,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-1tyo99t"&&(lt.textContent=io),yt.forEach(a),Sa=l(p),k=s(p,"DIV",{class:!0});var Da=y(k);h(He.$$.fragment,Da),Ya=l(Da),rt=s(Da,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-4nmimv"&&(rt.textContent=co),Da.forEach(a),Ka=l(p),B=s(p,"DIV",{class:!0});var Pa=y(B);h(Fe.$$.fragment,Pa),en=l(Pa),st=s(Pa,"P",{"data-svelte-h":!0}),d(st)!=="svelte-11q8u7l"&&(st.textContent=po),Pa.forEach(a),tn=l(p),O=s(p,"DIV",{class:!0});var Aa=y(O);h(Ne.$$.fragment,Aa),an=l(Aa),it=s(Aa,"P",{"data-svelte-h":!0}),d(it)!=="svelte-18uwvbi"&&(it.textContent=mo),Aa.forEach(a),nn=l(p),U=s(p,"DIV",{class:!0});var wt=y(U);h(Ge.$$.fragment,wt),on=l(wt),dt=s(wt,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-xesobz"&&(dt.innerHTML=ho),ln=l(wt),ct=s(wt,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-qg43tm"&&(ct.innerHTML=uo),wt.forEach(a),rn=l(p),j=s(p,"DIV",{class:!0});var bt=y(j);h(Qe.$$.fragment,bt),sn=l(bt),pt=s(bt,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-dkae9b"&&(pt.innerHTML=fo),dn=l(bt),mt=s(bt,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-hmd5cw"&&(mt.innerHTML=go),bt.forEach(a),cn=l(p),q=s(p,"DIV",{class:!0});var ka=y(q);h(ze.$$.fragment,ka),pn=l(ka),ht=s(ka,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-nqksfz"&&(ht.innerHTML=Mo),ka.forEach(a),mn=l(p),W=s(p,"DIV",{class:!0});var Ba=y(W);h(Xe.$$.fragment,Ba),hn=l(Ba),ut=s(Ba,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-17kjsy4"&&(ut.textContent=To),Ba.forEach(a),un=l(p),b=s(p,"DIV",{class:!0});var Z=y(b);h(Ve.$$.fragment,Z),fn=l(Z),ft=s(Z,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-1861yti"&&(ft.textContent=yo),gn=l(Z),gt=s(Z,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-1mn1gnw"&&(gt.textContent=wo),Mn=l(Z),Mt=s(Z,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-1xvpyih"&&(Mt.textContent=bo),Z.forEach(a),p.forEach(a),Ua=l(e),vt=s(e,"P",{}),y(vt).forEach(a),this.h()},h(){T(C,"name","hf:doc:metadata"),T(C,"content",Do),T(I,"width","835"),T(I,"alt","Screenshot 2024-03-19 at 12 39 41"),vo(I.src,Un="https://github.com/huggingface/trl/assets/49240599/9150fac6-3d88-4ca2-8ec6-2a6f3473216d")||T(I,"src",Un),xo(x,"text-align","center"),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,C),n(e,Ut,t),n(e,_t,t),n(e,jt,t),u(E,e,t),n(e,Ct,t),n(e,L,t),n(e,It,t),n(e,R,t),n(e,xt,t),u(H,e,t),n(e,$t,t),n(e,F,t),n(e,Dt,t),n(e,N,t),n(e,Pt,t),n(e,G,t),n(e,At,t),n(e,Q,t),n(e,kt,t),n(e,I,t),n(e,Bt,t),n(e,z,t),n(e,Ot,t),u(X,e,t),n(e,qt,t),n(e,V,t),n(e,Wt,t),n(e,x,t),n(e,Zt,t),n(e,S,t),n(e,Et,t),n(e,Y,t),n(e,Lt,t),n(e,K,t),n(e,Rt,t),u(ee,e,t),n(e,Ht,t),n(e,te,t),n(e,Ft,t),u(ae,e,t),n(e,Nt,t),n(e,ne,t),n(e,Gt,t),u(oe,e,t),n(e,Qt,t),n(e,le,t),n(e,zt,t),u(re,e,t),n(e,Xt,t),n(e,se,t),n(e,Vt,t),u(ie,e,t),n(e,St,t),n(e,de,t),n(e,Yt,t),u(ce,e,t),n(e,Kt,t),n(e,pe,t),n(e,ea,t),n(e,me,t),n(e,ta,t),n(e,he,t),n(e,aa,t),n(e,ue,t),n(e,na,t),n(e,fe,t),n(e,oa,t),u(ge,e,t),n(e,la,t),n(e,Me,t),n(e,ra,t),n(e,Te,t),n(e,sa,t),u(ye,e,t),n(e,ia,t),n(e,we,t),n(e,da,t),n(e,be,t),n(e,ca,t),n(e,_e,t),n(e,pa,t),u(ve,e,t),n(e,ma,t),n(e,Je,t),n(e,ha,t),u(Ue,e,t),n(e,ua,t),n(e,je,t),n(e,fa,t),n(e,Ce,t),n(e,ga,t),u(Ie,e,t),n(e,Ma,t),n(e,xe,t),n(e,Ta,t),n(e,$e,t),n(e,ya,t),u(De,e,t),n(e,wa,t),n(e,Pe,t),n(e,ba,t),n(e,Ae,t),n(e,_a,t),u(ke,e,t),n(e,va,t),u(Be,e,t),n(e,Ja,t),n(e,c,t),u(Oe,c,null),i(c,Oa),i(c,Se),i(c,qa),i(c,$),u(qe,$,null),i($,Wa),i($,Ye),i(c,Za),i(c,D),u(We,D,null),i(D,Ea),i(D,Ke),i(c,La),i(c,v),u(Ze,v,null),i(v,Ra),i(v,et),i(v,Ha),i(v,tt),i(c,Fa),i(c,P),u(Ee,P,null),i(P,Na),i(P,at),i(c,Ga),i(c,A),u(Le,A,null),i(A,Qa),i(A,nt),i(c,za),i(c,J),u(Re,J,null),i(J,Xa),i(J,ot),i(J,Va),i(J,lt),i(c,Sa),i(c,k),u(He,k,null),i(k,Ya),i(k,rt),i(c,Ka),i(c,B),u(Fe,B,null),i(B,en),i(B,st),i(c,tn),i(c,O),u(Ne,O,null),i(O,an),i(O,it),i(c,nn),i(c,U),u(Ge,U,null),i(U,on),i(U,dt),i(U,ln),i(U,ct),i(c,rn),i(c,j),u(Qe,j,null),i(j,sn),i(j,pt),i(j,dn),i(j,mt),i(c,cn),i(c,q),u(ze,q,null),i(q,pn),i(q,ht),i(c,mn),i(c,W),u(Xe,W,null),i(W,hn),i(W,ut),i(c,un),i(c,b),u(Ve,b,null),i(b,fn),i(b,ft),i(b,gn),i(b,gt),i(b,Mn),i(b,Mt),n(e,Ua,t),n(e,vt,t),ja=!0},p:Jo,i(e){ja||(f(E.$$.fragment,e),f(H.$$.fragment,e),f(X.$$.fragment,e),f(ee.$$.fragment,e),f(ae.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(ie.$$.fragment,e),f(ce.$$.fragment,e),f(ge.$$.fragment,e),f(ye.$$.fragment,e),f(ve.$$.fragment,e),f(Ue.$$.fragment,e),f(Ie.$$.fragment,e),f(De.$$.fragment,e),f(ke.$$.fragment,e),f(Be.$$.fragment,e),f(Oe.$$.fragment,e),f(qe.$$.fragment,e),f(We.$$.fragment,e),f(Ze.$$.fragment,e),f(Ee.$$.fragment,e),f(Le.$$.fragment,e),f(Re.$$.fragment,e),f(He.$$.fragment,e),f(Fe.$$.fragment,e),f(Ne.$$.fragment,e),f(Ge.$$.fragment,e),f(Qe.$$.fragment,e),f(ze.$$.fragment,e),f(Xe.$$.fragment,e),f(Ve.$$.fragment,e),ja=!0)},o(e){g(E.$$.fragment,e),g(H.$$.fragment,e),g(X.$$.fragment,e),g(ee.$$.fragment,e),g(ae.$$.fragment,e),g(oe.$$.fragment,e),g(re.$$.fragment,e),g(ie.$$.fragment,e),g(ce.$$.fragment,e),g(ge.$$.fragment,e),g(ye.$$.fragment,e),g(ve.$$.fragment,e),g(Ue.$$.fragment,e),g(Ie.$$.fragment,e),g(De.$$.fragment,e),g(ke.$$.fragment,e),g(Be.$$.fragment,e),g(Oe.$$.fragment,e),g(qe.$$.fragment,e),g(We.$$.fragment,e),g(Ze.$$.fragment,e),g(Ee.$$.fragment,e),g(Le.$$.fragment,e),g(Re.$$.fragment,e),g(He.$$.fragment,e),g(Fe.$$.fragment,e),g(Ne.$$.fragment,e),g(Ge.$$.fragment,e),g(Qe.$$.fragment,e),g(ze.$$.fragment,e),g(Xe.$$.fragment,e),g(Ve.$$.fragment,e),ja=!1},d(e){e&&(a(Ut),a(_t),a(jt),a(Ct),a(L),a(It),a(R),a(xt),a($t),a(F),a(Dt),a(N),a(Pt),a(G),a(At),a(Q),a(kt),a(I),a(Bt),a(z),a(Ot),a(qt),a(V),a(Wt),a(x),a(Zt),a(S),a(Et),a(Y),a(Lt),a(K),a(Rt),a(Ht),a(te),a(Ft),a(Nt),a(ne),a(Gt),a(Qt),a(le),a(zt),a(Xt),a(se),a(Vt),a(St),a(de),a(Yt),a(Kt),a(pe),a(ea),a(me),a(ta),a(he),a(aa),a(ue),a(na),a(fe),a(oa),a(la),a(Me),a(ra),a(Te),a(sa),a(ia),a(we),a(da),a(be),a(ca),a(_e),a(pa),a(ma),a(Je),a(ha),a(ua),a(je),a(fa),a(Ce),a(ga),a(Ma),a(xe),a(Ta),a($e),a(ya),a(wa),a(Pe),a(ba),a(Ae),a(_a),a(va),a(Ja),a(c),a(Ua),a(vt)),a(C),M(E,e),M(H,e),M(X,e),M(ee,e),M(ae,e),M(oe,e),M(re,e),M(ie,e),M(ce,e),M(ge,e),M(ye,e),M(ve,e),M(Ue,e),M(Ie,e),M(De,e),M(ke,e),M(Be,e),M(Oe),M(qe),M(We),M(Ze),M(Ee),M(Le),M(Re),M(He),M(Fe),M(Ne),M(Ge),M(Qe),M(ze),M(Xe),M(Ve)}}}const Do='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"How DPO works","local":"how-dpo-works","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the DPOTrainer","local":"using-the-dpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"Accelerate DPO fine-tuning using unsloth","local":"accelerate-dpo-fine-tuning-using-unsloth","sections":[],"depth":2},{"title":"Reference model considerations with PEFT","local":"reference-model-considerations-with-peft","sections":[{"title":"Downsides to merging QLoRA before DPO (approach 2)","local":"downsides-to-merging-qlora-before-dpo-approach-2","sections":[],"depth":3},{"title":"Using option 3 - load the adapter twice","local":"using-option-3---load-the-adapter-twice","sections":[],"depth":3}],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2}],"depth":1}';function Po(Tn){return Uo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wo extends jo{constructor(C){super(),Co(this,C,Po,$o,_o,{})}}export{Wo as component};
