import{s as We,n as Be,o as De}from"../chunks/scheduler.c59d9fbb.js";import{S as Oe,i as Ve,g as o,s as l,r as S,A as Ge,h as r,f as a,c as n,j as Ie,u as j,x as s,k as Le,y as Je,a as i,v as F,d as I,t as W,w as B}from"../chunks/index.a47918e3.js";import{H as D}from"../chunks/Heading.604bc707.js";function Ke(_e){let d,O,q,V,p,G,f,ve=`This conceptual guide gives a brief overview of <a href="https://arxiv.org/abs/2106.09685" rel="nofollow">LoRA</a>, a technique that accelerates
the fine-tuning of large models while consuming less memory.`,J,h,ye=`To make fine-tuning more efficient, LoRA’s approach is to represent the weight updates with two smaller
matrices (called <strong>update matrices</strong>) through low-rank decomposition. These new matrices can be trained to adapt to the
new data while keeping the overall number of changes low. The original weight matrix remains frozen and doesn’t receive
any further adjustments. To produce the final results, both the original and the adapted weights are combined.`,K,c,be="This approach has a number of advantages:",N,u,Te="<li>LoRA makes fine-tuning more efficient by drastically reducing the number of trainable parameters.</li> <li>The original pre-trained weights are kept frozen, which means you can have multiple lightweight and portable LoRA models for various downstream tasks built on top of them.</li> <li>LoRA is orthogonal to many other parameter-efficient methods and can be combined with many of them.</li> <li>Performance of models fine-tuned using LoRA is comparable to the performance of fully fine-tuned models.</li> <li>LoRA does not add any inference latency because adapter weights can be merged with the base model.</li>",Q,g,xe=`In principle, LoRA can be applied to any subset of weight matrices in a neural network to reduce the number of trainable
parameters. However, for simplicity and further parameter efficiency, in Transformer models LoRA is typically applied to
attention blocks only. The resulting number of trainable parameters in a LoRA model depends on the size of the low-rank
update matrices, which is determined mainly by the rank <code>r</code> and the shape of the original weight matrix.`,X,w,Y,L,Me='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA model. To eliminate latency, use the <a href="/docs/peft/v0.6.0/en/package_reference/tuners#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model which allows you to effectively use the newly merged model as a standalone model.',Z,m,$e='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',ee,_,Ae="This works because during training, the smaller weight matrices (<em>A</em> and <em>B</em> in the diagram above) are separate. But once training is complete, the weights can actually be merged into a new weight matrix that is identical.",te,v,ae,y,ke=`Use <code>merge_adapter()</code> to merge the LoRa layers into the base model while retaining the PeftModel.
This will help in later unmerging, deleting, loading different adapters and so on.`,ie,b,He=`Use <code>unmerge_adapter()</code> to unmerge the LoRa layers from the base model while retaining the PeftModel.
This will help in later merging, deleting, loading different adapters and so on.`,le,T,Re=`Use <a href="/docs/peft/v0.6.0/en/package_reference/tuners#peft.LoraModel.unload">unload()</a> to get back the base model without the merging of the active lora modules.
This will help when you want to get back the pretrained base model in some applications when you want to reset the model to its original state.
For example, in Stable Diffusion WebUi, when the user wants to infer with base model post trying out LoRAs.`,ne,x,Ce='Use <a href="/docs/peft/v0.6.0/en/package_reference/tuners#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete an existing adapter.',oe,M,Pe='Use <a href="/docs/peft/v0.6.0/en/package_reference/tuners#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> to combine multiple LoRAs into a new adapter based on the user provided weighing scheme.',re,$,se,A,Ue="As with other methods supported by PEFT, to fine-tune a model using LoRA, you need to:",de,k,ze="<li>Instantiate a base model.</li> <li>Create a configuration (<code>LoraConfig</code>) where you define LoRA-specific parameters.</li> <li>Wrap the base model with <code>get_peft_model()</code> to get a trainable <code>PeftModel</code>.</li> <li>Train the <code>PeftModel</code> as you normally would train the base model.</li>",me,H,qe="<code>LoraConfig</code> allows you to control how LoRA is applied to the base model through the following parameters:",pe,R,Ee="<li><code>r</code>: the rank of the update matrices, expressed in <code>int</code>. Lower rank results in smaller update matrices with fewer trainable parameters.</li> <li><code>target_modules</code>: The modules (for example, attention blocks) to apply the LoRA update matrices.</li> <li><code>alpha</code>: LoRA scaling factor.</li> <li><code>bias</code>: Specifies if the <code>bias</code> parameters should be trained. Can be <code>&#39;none&#39;</code>, <code>&#39;all&#39;</code> or <code>&#39;lora_only&#39;</code>.</li> <li><code>modules_to_save</code>: List of modules apart from LoRA layers to be set as trainable and saved in the final checkpoint. These typically include model’s custom head that is randomly initialized for the fine-tuning task.</li> <li><code>layers_to_transform</code>: List of layers to be transformed by LoRA. If not specified, all layers in <code>target_modules</code> are transformed.</li> <li><code>layers_pattern</code>: Pattern to match layer names in <code>target_modules</code>, if <code>layers_to_transform</code> is specified. By default <code>PeftModel</code> will look at common layer pattern (<code>layers</code>, <code>h</code>, <code>blocks</code>, etc.), use it for exotic and custom models.</li> <li><code>rank_pattern</code>: The mapping from layer names or regexp expression to ranks which are different from the default rank specified by <code>r</code>.</li> <li><code>alpha_pattern</code>: The mapping from layer names or regexp expression to alphas which are different from the default alpha specified by <code>lora_alpha</code>.</li>",fe,C,he,P,Se="For an example of LoRA method application to various downstream tasks, please refer to the following guides:",ce,U,je='<li><a href="../task_guides/image_classification_lora">Image classification using LoRA</a></li> <li><a href="../task_guides/semantic_segmentation_lora">Semantic segmentation</a></li>',ue,z,Fe=`While the original paper focuses on language models, the technique can be applied to any dense layers in deep learning
models. As such, you can leverage this technique with diffusion models. See <a href="../task_guides/task_guides/dreambooth_lora">Dreambooth fine-tuning with LoRA</a> task guide for an example.`,ge,E,we;return p=new D({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),w=new D({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),v=new D({props:{title:"Utils for LoRA",local:"utils-for-lora",headingTag:"h2"}}),$=new D({props:{title:"Common LoRA parameters in PEFT",local:"common-lora-parameters-in-peft",headingTag:"h2"}}),C=new D({props:{title:"LoRA examples",local:"lora-examples",headingTag:"h2"}}),{c(){d=o("meta"),O=l(),q=o("p"),V=l(),S(p.$$.fragment),G=l(),f=o("p"),f.innerHTML=ve,J=l(),h=o("p"),h.innerHTML=ye,K=l(),c=o("p"),c.textContent=be,N=l(),u=o("ul"),u.innerHTML=Te,Q=l(),g=o("p"),g.innerHTML=xe,X=l(),S(w.$$.fragment),Y=l(),L=o("p"),L.innerHTML=Me,Z=l(),m=o("div"),m.innerHTML=$e,ee=l(),_=o("p"),_.innerHTML=Ae,te=l(),S(v.$$.fragment),ae=l(),y=o("p"),y.innerHTML=ke,ie=l(),b=o("p"),b.innerHTML=He,le=l(),T=o("p"),T.innerHTML=Re,ne=l(),x=o("p"),x.innerHTML=Ce,oe=l(),M=o("p"),M.innerHTML=Pe,re=l(),S($.$$.fragment),se=l(),A=o("p"),A.textContent=Ue,de=l(),k=o("ol"),k.innerHTML=ze,me=l(),H=o("p"),H.innerHTML=qe,pe=l(),R=o("ul"),R.innerHTML=Ee,fe=l(),S(C.$$.fragment),he=l(),P=o("p"),P.textContent=Se,ce=l(),U=o("ul"),U.innerHTML=je,ue=l(),z=o("p"),z.innerHTML=Fe,ge=l(),E=o("p"),this.h()},l(e){const t=Ge("svelte-u9bgzb",document.head);d=r(t,"META",{name:!0,content:!0}),t.forEach(a),O=n(e),q=r(e,"P",{}),Ie(q).forEach(a),V=n(e),j(p.$$.fragment,e),G=n(e),f=r(e,"P",{"data-svelte-h":!0}),s(f)!=="svelte-10j2kq5"&&(f.innerHTML=ve),J=n(e),h=r(e,"P",{"data-svelte-h":!0}),s(h)!=="svelte-yvfnx3"&&(h.innerHTML=ye),K=n(e),c=r(e,"P",{"data-svelte-h":!0}),s(c)!=="svelte-1usho35"&&(c.textContent=be),N=n(e),u=r(e,"UL",{"data-svelte-h":!0}),s(u)!=="svelte-b91w2n"&&(u.innerHTML=Te),Q=n(e),g=r(e,"P",{"data-svelte-h":!0}),s(g)!=="svelte-1pnerbz"&&(g.innerHTML=xe),X=n(e),j(w.$$.fragment,e),Y=n(e),L=r(e,"P",{"data-svelte-h":!0}),s(L)!=="svelte-11n0vev"&&(L.innerHTML=Me),Z=n(e),m=r(e,"DIV",{class:!0,"data-svelte-h":!0}),s(m)!=="svelte-1f6iuw5"&&(m.innerHTML=$e),ee=n(e),_=r(e,"P",{"data-svelte-h":!0}),s(_)!=="svelte-6quaur"&&(_.innerHTML=Ae),te=n(e),j(v.$$.fragment,e),ae=n(e),y=r(e,"P",{"data-svelte-h":!0}),s(y)!=="svelte-d2gh5y"&&(y.innerHTML=ke),ie=n(e),b=r(e,"P",{"data-svelte-h":!0}),s(b)!=="svelte-1swysoz"&&(b.innerHTML=He),le=n(e),T=r(e,"P",{"data-svelte-h":!0}),s(T)!=="svelte-5knf1d"&&(T.innerHTML=Re),ne=n(e),x=r(e,"P",{"data-svelte-h":!0}),s(x)!=="svelte-1iv2xd9"&&(x.innerHTML=Ce),oe=n(e),M=r(e,"P",{"data-svelte-h":!0}),s(M)!=="svelte-1prfrxh"&&(M.innerHTML=Pe),re=n(e),j($.$$.fragment,e),se=n(e),A=r(e,"P",{"data-svelte-h":!0}),s(A)!=="svelte-kdwy7m"&&(A.textContent=Ue),de=n(e),k=r(e,"OL",{"data-svelte-h":!0}),s(k)!=="svelte-yij1ed"&&(k.innerHTML=ze),me=n(e),H=r(e,"P",{"data-svelte-h":!0}),s(H)!=="svelte-ezuo7y"&&(H.innerHTML=qe),pe=n(e),R=r(e,"UL",{"data-svelte-h":!0}),s(R)!=="svelte-vpooj9"&&(R.innerHTML=Ee),fe=n(e),j(C.$$.fragment,e),he=n(e),P=r(e,"P",{"data-svelte-h":!0}),s(P)!=="svelte-aryync"&&(P.textContent=Se),ce=n(e),U=r(e,"UL",{"data-svelte-h":!0}),s(U)!=="svelte-19vcsei"&&(U.innerHTML=je),ue=n(e),z=r(e,"P",{"data-svelte-h":!0}),s(z)!=="svelte-1moq18d"&&(z.innerHTML=Fe),ge=n(e),E=r(e,"P",{}),Ie(E).forEach(a),this.h()},h(){Le(d,"name","hf:doc:metadata"),Le(d,"content",Ne),Le(m,"class","flex justify-center")},m(e,t){Je(document.head,d),i(e,O,t),i(e,q,t),i(e,V,t),F(p,e,t),i(e,G,t),i(e,f,t),i(e,J,t),i(e,h,t),i(e,K,t),i(e,c,t),i(e,N,t),i(e,u,t),i(e,Q,t),i(e,g,t),i(e,X,t),F(w,e,t),i(e,Y,t),i(e,L,t),i(e,Z,t),i(e,m,t),i(e,ee,t),i(e,_,t),i(e,te,t),F(v,e,t),i(e,ae,t),i(e,y,t),i(e,ie,t),i(e,b,t),i(e,le,t),i(e,T,t),i(e,ne,t),i(e,x,t),i(e,oe,t),i(e,M,t),i(e,re,t),F($,e,t),i(e,se,t),i(e,A,t),i(e,de,t),i(e,k,t),i(e,me,t),i(e,H,t),i(e,pe,t),i(e,R,t),i(e,fe,t),F(C,e,t),i(e,he,t),i(e,P,t),i(e,ce,t),i(e,U,t),i(e,ue,t),i(e,z,t),i(e,ge,t),i(e,E,t),we=!0},p:Be,i(e){we||(I(p.$$.fragment,e),I(w.$$.fragment,e),I(v.$$.fragment,e),I($.$$.fragment,e),I(C.$$.fragment,e),we=!0)},o(e){W(p.$$.fragment,e),W(w.$$.fragment,e),W(v.$$.fragment,e),W($.$$.fragment,e),W(C.$$.fragment,e),we=!1},d(e){e&&(a(O),a(q),a(V),a(G),a(f),a(J),a(h),a(K),a(c),a(N),a(u),a(Q),a(g),a(X),a(Y),a(L),a(Z),a(m),a(ee),a(_),a(te),a(ae),a(y),a(ie),a(b),a(le),a(T),a(ne),a(x),a(oe),a(M),a(re),a(se),a(A),a(de),a(k),a(me),a(H),a(pe),a(R),a(fe),a(he),a(P),a(ce),a(U),a(ue),a(z),a(ge),a(E)),a(d),B(p,e),B(w,e),B(v,e),B($,e),B(C,e)}}}const Ne='{"title":"LoRA","local":"lora","sections":[{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Utils for LoRA","local":"utils-for-lora","sections":[],"depth":2},{"title":"Common LoRA parameters in PEFT","local":"common-lora-parameters-in-peft","sections":[],"depth":2},{"title":"LoRA examples","local":"lora-examples","sections":[],"depth":2}],"depth":1}';function Qe(_e){return De(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class et extends Oe{constructor(d){super(),Ve(this,d,Qe,Ke,We,{})}}export{et as component};
