import{s as Ae,o as Le,n as Ie}from"../chunks/scheduler.852ec091.js";import{S as Be,i as Ye,g as p,s as a,r as d,A as He,h as r,f as s,c as i,j as ke,u as b,x as o,k as he,y as Fe,a as l,v as c,d as M,t as u,w as y}from"../chunks/index.28275fd3.js";import{T as Ce}from"../chunks/Tip.9f398c59.js";import{C as E}from"../chunks/CodeBlock.c3366071.js";import{H as we}from"../chunks/Heading.3b22a250.js";function Qe(S){let n,h="8-bit optimizers reduce memory usage and accelerate optimization on a wide range of tasks. However, since 8-bit optimizers only reduce memory proportional to the number of parameters, models that use large amounts of activation memory, such as convolutional networks, don’t really benefit from 8-bit optimizers. 8-bit optimizers are most beneficial for training or finetuning models with many parameters on highly memory-constrained GPUs.";return{c(){n=p("p"),n.textContent=h},l(m){n=r(m,"P",{"data-svelte-h":!0}),o(n)!=="svelte-q5gilt"&&(n.textContent=h)},m(m,w){l(m,n,w)},p:Ie,d(m){m&&s(n)}}}function Ee(S){let n,h="Check the optimizer API documentation for more information about other hyperparameters you can override.";return{c(){n=p("p"),n.textContent=h},l(m){n=r(m,"P",{"data-svelte-h":!0}),o(n)!=="svelte-g9htrg"&&(n.textContent=h)},m(m,w){l(m,n,w)},p:Ie,d(m){m&&s(n)}}}function Se(S){let n,h,m,w,T,R,$,fe="With 8-bit optimizers, large models can be finetuned with 75% less GPU memory without losing any accuracy compared to training with standard 32-bit optimizers. The reduced memory requirements means 8-bit optimizers are 4x faster than a standard optimizer, and no hyperparameter tuning is required.",V,g,Je="This guide will show you how to use 8-bit optimizers.",N,f,P,U,je='8-bit optimizers are a drop-in replacement for regular optimizers which means they also accept the same arguments as a regular optimizer. For NLP models, it is recommended to use the <a href="/docs/bitsandbytes/main/en/reference/nn/embeddings#bitsandbytes.nn.StableEmbedding">StableEmbedding</a> class to improve stability and results.',K,G,O,v,Te="By default, all parameter tensors with less than 4096 elements are kept at 32-bits even if you initialize those parameters with 8-bit optimizers. This is done because small tensors do not save much memory and often contain highly variable parameters (biases) or parameters that require high precision (batch norm, layer norm).",D,_,$e="You can change this value with the <code>min_8bit_size</code> parameter. For example, if you want to optimize parameters to 8-bits only if the minimum size is 16384 values (it is recommended to use multiples of 4096):",q,Z,ee,x,ge='Other parameters you can configure include the learning rate (<code>lr</code>), the decay rates (<code>betas</code>), the number of bits of the optimizer state (<code>optim_bits</code>), and percentile clipping (<code>percentile_clipping</code>) which can increase stability. For example, to initialize a 32-bit <a href="/docs/bitsandbytes/main/en/reference/optim/adam#bitsandbytes.optim.Adam">Adam</a> optimizer with 5th percentile clipping:',te,W,se,z,le,k,Ue='To optimize some unstable parameters with 32-bit Adam and others with 8-bit Adam, use the <a href="/docs/bitsandbytes/main/en/reference/optim/optim_overview#bitsandbytes.optim.GlobalOptimManager">GlobalOptimManager</a> class to override the specific hyperparameters for a particular layer. You’ll need to:',ae,C,Ge="<li>Register the parameters while they’re on the CPU.</li>",ie,I,ne,J,ve="<li>Override the config with the new desired hyperparameters. For example, let’s override the <code>model.fc1.weight</code> layer to use 32-bit Adam.</li>",me,j,pe,A,re,L,_e="You can also override multiple layers at once by passing them as a list and the new hyperparameters as a dictionary. For example, let’s override the <code>model.special.weight</code> and <code>model.also_special.weight</code> layers to use sparse optimization and a lower learning and decay rate.",oe,B,de,Y,Ze='For a specific layer, we recommend overriding locally in each module. Pass the module, the parameter, and its attribute name to the <a href="/docs/bitsandbytes/main/en/reference/optim/optim_overview#bitsandbytes.optim.GlobalOptimManager">GlobalOptimManager</a>:',be,H,ce,F,Me,Q,xe='For more conceptual details and explanation about 8-bit optimizers, take a look at the <a href="./explanations/optimizers">8-bit optimizers</a> guide.',ue,X,ye;return T=new we({props:{title:"8-bit optimizers",local:"8-bit-optimizers",headingTag:"h1"}}),f=new Ce({props:{warning:!0,$$slots:{default:[Qe]},$$scope:{ctx:S}}}),G=new E({props:{code:"aW1wb3J0JTIwYml0c2FuZGJ5dGVzJTIwYXMlMjBibmIlMEElMEEtJTIwYWRhbSUyMCUzRCUyMHRvcmNoLm9wdGltLkFkYW0oLi4uKSUwQSUyQiUyMGFkYW0lMjAlM0QlMjBibmIub3B0aW0uQWRhbThiaXQoLi4uKSUwQSUwQSUyMyUyMHJlY29tbWVuZGVkJTIwZm9yJTIwTkxQJTIwbW9kZWxzJTBBLSUyMGJlZm9yZSUzQSUyMHRvcmNoLm5uLkVtYmVkZGluZyguLi4pJTBBJTJCJTIwYm5iLm5uLlN0YWJsZUVtYmVkZGluZyguLi4p",highlighted:`import bitsandbytes as bnb

<span class="hljs-deletion">- adam = torch.optim.Adam(...)</span>
<span class="hljs-addition">+ adam = bnb.optim.Adam8bit(...)</span>

# recommended for NLP models
<span class="hljs-deletion">- before: torch.nn.Embedding(...)</span>
<span class="hljs-addition">+ bnb.nn.StableEmbedding(...)</span>`,wrap:!1}}),Z=new E({props:{code:"aW1wb3J0JTIwYml0c2FuZGJ5dGVzJTIwYXMlMjBibmIlMEElMEFhZGFtJTIwJTNEJTIwYm5iLm9wdGltLkFkYW04Yml0KG1vZGVsLnBhcmFtZXRlcnMoKSUyQyUyMG1pbl84Yml0X3NpemUlM0QxNjM4NCk=",highlighted:`<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

adam = bnb.optim.Adam8bit(model.parameters(), min_8bit_size=<span class="hljs-number">16384</span>)`,wrap:!1}}),W=new E({props:{code:"aW1wb3J0JTIwYml0c2FuZGJ5dGVzJTIwYXMlMjBibmIlMEElMEFhZGFtJTIwJTNEJTIwYm5iLm9wdGltLkFkYW0obW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QwLjAwMSUyQyUyMGJldGFzJTNEKDAuOSUyQyUyMDAuOTk1KSUyQyUyMG9wdGltX2JpdHMlM0QzMiUyQyUyMHBlcmNlbnRpbGVfY2xpcHBpbmclM0Q1KQ==",highlighted:`<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

adam = bnb.optim.Adam(model.parameters(), lr=<span class="hljs-number">0.001</span>, betas=(<span class="hljs-number">0.9</span>, <span class="hljs-number">0.995</span>), optim_bits=<span class="hljs-number">32</span>, percentile_clipping=<span class="hljs-number">5</span>)`,wrap:!1}}),z=new we({props:{title:"Optimize unstable parameters",local:"optimize-unstable-parameters",headingTag:"h2"}}),I=new E({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBiaXRzYW5kYnl0ZXMlMjBhcyUyMGJuYiUwQSUwQW1uZyUyMCUzRCUyMGJuYi5vcHRpbS5HbG9iYWxPcHRpbU1hbmFnZXIuZ2V0X2luc3RhbmNlKCklMEElMEFtb2RlbCUyMCUzRCUyME15TW9kZWwoKSUwQW1uZy5yZWdpc3Rlcl9wYXJhbWV0ZXJzKG1vZGVsLnBhcmFtZXRlcnMoKSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

mng = bnb.optim.GlobalOptimManager.get_instance()

model = MyModel()
mng.register_parameters(model.parameters())`,wrap:!1}}),j=new Ce({props:{warning:!1,$$slots:{default:[Ee]},$$scope:{ctx:S}}}),A=new E({props:{code:"bW9kZWwlMjAlM0QlMjBtb2RlbC5jdWRhKCklMEElMjMlMjB1c2UlMjA4LWJpdCUyMG9wdGltaXplciUyMHN0YXRlcyUyMGZvciUyMGFsbCUyMHBhcmFtZXRlcnMlMEFhZGFtJTIwJTNEJTIwYm5iLm9wdGltLkFkYW0obW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QwLjAwMSUyQyUyMG9wdGltX2JpdHMlM0Q4KSUwQSUwQSUyMyUyMG92ZXJyaWRlJTIwdGhlJTIwcGFyYW1ldGVyJTIwbW9kZWwuZmMxLndlaWdodCUyMG5vdyUyMHVzZXMlMjAzMi1iaXQlMjBBZGFtJTBBbW5nLm92ZXJyaWRlX2NvbmZpZyhtb2RlbC5mYzEud2VpZ2h0JTJDJTIwJTIyb3B0aW1fYml0cyUyMiUyQyUyMDMyKQ==",highlighted:`model = model.cuda()
<span class="hljs-comment"># use 8-bit optimizer states for all parameters</span>
adam = bnb.optim.Adam(model.parameters(), lr=<span class="hljs-number">0.001</span>, optim_bits=<span class="hljs-number">8</span>)

<span class="hljs-comment"># override the parameter model.fc1.weight now uses 32-bit Adam</span>
mng.override_config(model.fc1.weight, <span class="hljs-string">&quot;optim_bits&quot;</span>, <span class="hljs-number">32</span>)`,wrap:!1}}),B=new E({props:{code:"bW5nLm92ZXJyaWRlX2NvbmZpZyglNUJtb2RlbC5zcGVjaWFsLndlaWdodCUyQyUyMG1vZGVsLmFsc29fc3BlY2lhbC53ZWlnaHQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBrZXlfdmFsdWVfZGljdCUyMCUzRCU3Qidpc19zcGFyc2UnJTNBJTIwVHJ1ZSUyQyUyMCdsciclM0ElMjAxZS01JTJDJTIwJ2JldGFzJyUzRCgwLjklMkMlMjAwLjk4KSU3RCk=",highlighted:`mng.override_config([model.special.weight, model.also_special.weight],
                    key_value_dict ={<span class="hljs-string">&#x27;is_sparse&#x27;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&#x27;lr&#x27;</span>: <span class="hljs-number">1e-5</span>, <span class="hljs-string">&#x27;betas&#x27;</span>=(<span class="hljs-number">0.9</span>, <span class="hljs-number">0.98</span>)})`,wrap:!1}}),H=new E({props:{code:"Y2xhc3MlMjBNeU1vZHVsZSh0b3JjaC5ubi5Nb2R1bGUpJTNBJTBBJTIwJTIwZGVmJTIwX19pbml0X18oZF9pbiUyQyUyMGRfb3V0KSUzQSUwQSUyMCUyMCUyMCUyMHN1cGVyKE15TW9kdWxlJTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMHNlbGYubGluZWFyJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKGRfaW4lMkMlMjBkX291dCklMEElMjAlMjAlMjAlMjAlMjMlMjBvcHRpbWl6YXRpb24lMjB3aWxsJTIwaGFwcGVuJTIwaW4lMjAzMi1iaXQlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjMlMjBsZWFybmluZyUyMHJhdGUlMjB3aWxsJTIwYmUlMjBzZXQlMjB0byUyMDAuMDAwMSUyMGluZGVwZW5kZW50JTIwb2YlMjB0aGUlMjBtYWluJTIwbGVhcm5pbmclMjByYXRlJTBBJTIwJTIwJTIwJTIwY29uZmlnJTIwJTNEJTIwJTdCJ29wdGltX2JpdHMnJTNBJTIwMzIlMkMlMjAnbHInJTIwJTNBJTIwMC4wMDAxJTdEJTBBJTIwJTIwJTIwJTIwR2xvYmFsT3B0aW1NYW5hZ2VyLmdldF9pbnN0YW5jZSgpLnJlZ2lzdGVyX21vZHVsZV9vdmVycmlkZShzZWxmJTJDJTIwJ3dlaWdodCclMkMlMjBjb25maWcpJTBB",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModule</span>(torch.nn.Module):
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">d_in, d_out</span>):
    <span class="hljs-built_in">super</span>(MyModule, self).__init__()
    self.linear = torch.nn.Linear(d_in, d_out)
    <span class="hljs-comment"># optimization will happen in 32-bit and</span>
    <span class="hljs-comment"># learning rate will be set to 0.0001 independent of the main learning rate</span>
    config = {<span class="hljs-string">&#x27;optim_bits&#x27;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&#x27;lr&#x27;</span> : <span class="hljs-number">0.0001</span>}
    GlobalOptimManager.get_instance().register_module_override(self, <span class="hljs-string">&#x27;weight&#x27;</span>, config)
`,wrap:!1}}),F=new we({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){n=p("meta"),h=a(),m=p("p"),w=a(),d(T.$$.fragment),R=a(),$=p("p"),$.textContent=fe,V=a(),g=p("p"),g.textContent=Je,N=a(),d(f.$$.fragment),P=a(),U=p("p"),U.innerHTML=je,K=a(),d(G.$$.fragment),O=a(),v=p("p"),v.textContent=Te,D=a(),_=p("p"),_.innerHTML=$e,q=a(),d(Z.$$.fragment),ee=a(),x=p("p"),x.innerHTML=ge,te=a(),d(W.$$.fragment),se=a(),d(z.$$.fragment),le=a(),k=p("p"),k.innerHTML=Ue,ae=a(),C=p("ol"),C.innerHTML=Ge,ie=a(),d(I.$$.fragment),ne=a(),J=p("ol"),J.innerHTML=ve,me=a(),d(j.$$.fragment),pe=a(),d(A.$$.fragment),re=a(),L=p("p"),L.innerHTML=_e,oe=a(),d(B.$$.fragment),de=a(),Y=p("p"),Y.innerHTML=Ze,be=a(),d(H.$$.fragment),ce=a(),d(F.$$.fragment),Me=a(),Q=p("p"),Q.innerHTML=xe,ue=a(),X=p("p"),this.h()},l(e){const t=He("svelte-u9bgzb",document.head);n=r(t,"META",{name:!0,content:!0}),t.forEach(s),h=i(e),m=r(e,"P",{}),ke(m).forEach(s),w=i(e),b(T.$$.fragment,e),R=i(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-7xifi0"&&($.textContent=fe),V=i(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-anq6iu"&&(g.textContent=Je),N=i(e),b(f.$$.fragment,e),P=i(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-42uda"&&(U.innerHTML=je),K=i(e),b(G.$$.fragment,e),O=i(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1swxts3"&&(v.textContent=Te),D=i(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-swi3zx"&&(_.innerHTML=$e),q=i(e),b(Z.$$.fragment,e),ee=i(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-198tc99"&&(x.innerHTML=ge),te=i(e),b(W.$$.fragment,e),se=i(e),b(z.$$.fragment,e),le=i(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-t6ql1m"&&(k.innerHTML=Ue),ae=i(e),C=r(e,"OL",{"data-svelte-h":!0}),o(C)!=="svelte-1revex8"&&(C.innerHTML=Ge),ie=i(e),b(I.$$.fragment,e),ne=i(e),J=r(e,"OL",{start:!0,"data-svelte-h":!0}),o(J)!=="svelte-127zgse"&&(J.innerHTML=ve),me=i(e),b(j.$$.fragment,e),pe=i(e),b(A.$$.fragment,e),re=i(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-kxfpon"&&(L.innerHTML=_e),oe=i(e),b(B.$$.fragment,e),de=i(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-sha7g0"&&(Y.innerHTML=Ze),be=i(e),b(H.$$.fragment,e),ce=i(e),b(F.$$.fragment,e),Me=i(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1er8qov"&&(Q.innerHTML=xe),ue=i(e),X=r(e,"P",{}),ke(X).forEach(s),this.h()},h(){he(n,"name","hf:doc:metadata"),he(n,"content",Xe),he(J,"start","2")},m(e,t){Fe(document.head,n),l(e,h,t),l(e,m,t),l(e,w,t),c(T,e,t),l(e,R,t),l(e,$,t),l(e,V,t),l(e,g,t),l(e,N,t),c(f,e,t),l(e,P,t),l(e,U,t),l(e,K,t),c(G,e,t),l(e,O,t),l(e,v,t),l(e,D,t),l(e,_,t),l(e,q,t),c(Z,e,t),l(e,ee,t),l(e,x,t),l(e,te,t),c(W,e,t),l(e,se,t),c(z,e,t),l(e,le,t),l(e,k,t),l(e,ae,t),l(e,C,t),l(e,ie,t),c(I,e,t),l(e,ne,t),l(e,J,t),l(e,me,t),c(j,e,t),l(e,pe,t),c(A,e,t),l(e,re,t),l(e,L,t),l(e,oe,t),c(B,e,t),l(e,de,t),l(e,Y,t),l(e,be,t),c(H,e,t),l(e,ce,t),c(F,e,t),l(e,Me,t),l(e,Q,t),l(e,ue,t),l(e,X,t),ye=!0},p(e,[t]){const We={};t&2&&(We.$$scope={dirty:t,ctx:e}),f.$set(We);const ze={};t&2&&(ze.$$scope={dirty:t,ctx:e}),j.$set(ze)},i(e){ye||(M(T.$$.fragment,e),M(f.$$.fragment,e),M(G.$$.fragment,e),M(Z.$$.fragment,e),M(W.$$.fragment,e),M(z.$$.fragment,e),M(I.$$.fragment,e),M(j.$$.fragment,e),M(A.$$.fragment,e),M(B.$$.fragment,e),M(H.$$.fragment,e),M(F.$$.fragment,e),ye=!0)},o(e){u(T.$$.fragment,e),u(f.$$.fragment,e),u(G.$$.fragment,e),u(Z.$$.fragment,e),u(W.$$.fragment,e),u(z.$$.fragment,e),u(I.$$.fragment,e),u(j.$$.fragment,e),u(A.$$.fragment,e),u(B.$$.fragment,e),u(H.$$.fragment,e),u(F.$$.fragment,e),ye=!1},d(e){e&&(s(h),s(m),s(w),s(R),s($),s(V),s(g),s(N),s(P),s(U),s(K),s(O),s(v),s(D),s(_),s(q),s(ee),s(x),s(te),s(se),s(le),s(k),s(ae),s(C),s(ie),s(ne),s(J),s(me),s(pe),s(re),s(L),s(oe),s(de),s(Y),s(be),s(ce),s(Me),s(Q),s(ue),s(X)),s(n),y(T,e),y(f,e),y(G,e),y(Z,e),y(W,e),y(z,e),y(I,e),y(j,e),y(A,e),y(B,e),y(H,e),y(F,e)}}}const Xe='{"title":"8-bit optimizers","local":"8-bit-optimizers","sections":[{"title":"Optimize unstable parameters","local":"optimize-unstable-parameters","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Re(S){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class De extends Be{constructor(n){super(),Ye(this,n,Re,Se,Ae,{})}}export{De as component};
