import{s as Ae,o as Le,n as Je}from"../chunks/scheduler.22bf70d2.js";import{S as Ye,i as Se,g as r,s as a,r as c,A as We,h as o,f as l,c as i,j as ke,u as h,x as d,k as Ge,y as Be,a as n,v as f,d as u,t as $,w}from"../chunks/index.59178e06.js";import{T as Ze}from"../chunks/Tip.75d940ba.js";import{C as ue}from"../chunks/CodeBlock.f7047b13.js";import{H as I}from"../chunks/Heading.f8746c79.js";function He(X){let s,m="In this example, there are two GPUs for “Multi-GPU” and a TPU pod with 8 workers";return{c(){s=r("p"),s.textContent=m},l(p){s=o(p,"P",{"data-svelte-h":!0}),d(s)!=="svelte-k9rq2f"&&(s.textContent=m)},m(p,b){n(p,s,b)},p:Je,d(p){p&&l(s)}}}function Xe(X){let s,m=`Since users can have their own learning rate schedulers defined, we leave this up to the user to decide if they wish to scale their
learning rate or not.`;return{c(){s=r("p"),s.textContent=m},l(p){s=o(p,"P",{"data-svelte-h":!0}),d(s)!=="svelte-1birp9c"&&(s.textContent=m)},m(p,b){n(p,s,b)},p:Je,d(p){p&&l(s)}}}function Ee(X){let s,m,p,b,v,V,T,$e=`Evaluating and comparing the performance from different setups can be quite tricky if you don’t know what to look for.
For example, you cannot run the same script with the same batch size across TPU, multi-GPU, and single-GPU with Accelerate
and expect your results to line up.`,R,x,we="But why?",F,_,be="There are three reasons for this that this tutorial will cover:",N,C,ge="<li><strong>Setting the right seeds</strong></li> <li><strong>Observed Batch Sizes</strong></li> <li><strong>Learning Rates</strong></li>",Q,y,q,U,Me='While this issue has not come up as much, make sure to use <a href="/docs/accelerate/v0.29.0/en/package_reference/utilities#accelerate.utils.set_seed">utils.set_seed()</a> to fully set the seed in all distributed cases so training will be reproducible:',K,j,O,P,ve="Why is this important? Under the hood this will set <strong>5</strong> different seed settings:",D,z,ee,k,Te="The random state, numpy’s state, torch, torch’s cuda state, and if TPUs are available torch_xla’s cuda state.",te,G,le,Z,xe=`When training with Accelerate, the batch size passed to the dataloader is the <strong>batch size per GPU</strong>. What this entails is
a batch size of 64 on two GPUs is truly a batch size of 128. As a result, when testing on a single GPU this needs to be accounted for,
as well as similarly for TPUs.`,ne,J,_e="The below table can be used as a quick reference to try out different batch sizes:",se,g,ae,A,Ce="<thead><tr><th>Single GPU Batch Size</th> <th>Multi-GPU Equivalent Batch Size</th> <th>TPU Equivalent Batch Size</th></tr></thead> <tbody><tr><td>256</td> <td>128</td> <td>32</td></tr> <tr><td>128</td> <td>64</td> <td>16</td></tr> <tr><td>64</td> <td>32</td> <td>8</td></tr> <tr><td>32</td> <td>16</td> <td>4</td></tr></tbody>",ie,L,re,Y,ye=`As noted in multiple sources[<a href="https://aws.amazon.com/blogs/machine-learning/scalable-multi-node-deep-learning-training-using-gpus-in-the-aws-cloud/" rel="nofollow">1</a>][<a href="https://docs.nvidia.com/clara/clara-train-sdk/pt/model.html#classification-models-multi-gpu-training" rel="nofollow">2</a>], the learning rate should be scaled <em>linearly</em> based on the number of devices present. The below
snippet shows doing so with Accelerate:`,oe,M,pe,S,de,W,Ue=`You will also find that <code>accelerate</code> will step the learning rate based on the number of processes being trained on. This is because
of the observed batch size noted earlier. So in the case of 2 GPUs, the learning rate will be stepped twice as often as a single GPU
to account for the batch size being twice as large (if no changes to the batch size on the single GPU instance are made).`,me,B,ce,H,je=`When using gradient accumulation and mixed precision, due to how gradient averaging works (accumulation) and the precision loss (mixed precision),
some degradation in performance is expected. This will be explicitly seen when comparing the batch-wise loss between different compute
setups. However, the overall loss, metric, and general performance at the end of training should be <em>roughly</em> the same.`,he,E,fe;return v=new I({props:{title:"Comparing performance between different device setups",local:"comparing-performance-between-different-device-setups",headingTag:"h1"}}),y=new I({props:{title:"Setting the Seed",local:"setting-the-seed",headingTag:"h2"}}),j=new ue({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBzZXRfc2VlZCUwQSUwQXNldF9zZWVkKDQyKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> set_seed

set_seed(<span class="hljs-number">42</span>)`,wrap:!1}}),z=new ue({props:{code:"JTIwJTIwJTIwJTIwcmFuZG9tLnNlZWQoc2VlZCklMEElMjAlMjAlMjAlMjBucC5yYW5kb20uc2VlZChzZWVkKSUwQSUyMCUyMCUyMCUyMHRvcmNoLm1hbnVhbF9zZWVkKHNlZWQpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5tYW51YWxfc2VlZF9hbGwoc2VlZCklMEElMjAlMjAlMjAlMjAlMjMlMjAlNUUlNUUlMjBzYWZlJTIwdG8lMjBjYWxsJTIwdGhpcyUyMGZ1bmN0aW9uJTIwZXZlbiUyMGlmJTIwY3VkYSUyMGlzJTIwbm90JTIwYXZhaWxhYmxlJTBBJTIwJTIwJTIwJTIwaWYlMjBpc190b3JjaF94bGFfYXZhaWxhYmxlKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4bS5zZXRfcm5nX3N0YXRlKHNlZWQp",highlighted:`    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    <span class="hljs-comment"># ^^ safe to call this function even if cuda is not available</span>
    <span class="hljs-keyword">if</span> is_torch_xla_available():
        xm.set_rng_state(seed)`,wrap:!1}}),G=new I({props:{title:"Observed Batch Sizes",local:"observed-batch-sizes",headingTag:"h2"}}),g=new Ze({props:{$$slots:{default:[He]},$$scope:{ctx:X}}}),L=new I({props:{title:"Learning Rates",local:"learning-rates",headingTag:"h2"}}),M=new Ze({props:{$$slots:{default:[Xe]},$$scope:{ctx:X}}}),S=new ue({props:{code:"bGVhcm5pbmdfcmF0ZSUyMCUzRCUyMDFlLTMlMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCklMEFsZWFybmluZ19yYXRlJTIwKiUzRCUyMGFjY2VsZXJhdG9yLm51bV9wcm9jZXNzZXMlMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhwYXJhbXMlM0Rtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRGxlYXJuaW5nX3JhdGUp",highlighted:`learning_rate = <span class="hljs-number">1e-3</span>
accelerator = Accelerator()
learning_rate *= accelerator.num_processes

optimizer = AdamW(params=model.parameters(), lr=learning_rate)`,wrap:!1}}),B=new I({props:{title:"Gradient Accumulation and Mixed Precision",local:"gradient-accumulation-and-mixed-precision",headingTag:"h2"}}),{c(){s=r("meta"),m=a(),p=r("p"),b=a(),c(v.$$.fragment),V=a(),T=r("p"),T.textContent=$e,R=a(),x=r("p"),x.textContent=we,F=a(),_=r("p"),_.textContent=be,N=a(),C=r("ol"),C.innerHTML=ge,Q=a(),c(y.$$.fragment),q=a(),U=r("p"),U.innerHTML=Me,K=a(),c(j.$$.fragment),O=a(),P=r("p"),P.innerHTML=ve,D=a(),c(z.$$.fragment),ee=a(),k=r("p"),k.textContent=Te,te=a(),c(G.$$.fragment),le=a(),Z=r("p"),Z.innerHTML=xe,ne=a(),J=r("p"),J.textContent=_e,se=a(),c(g.$$.fragment),ae=a(),A=r("table"),A.innerHTML=Ce,ie=a(),c(L.$$.fragment),re=a(),Y=r("p"),Y.innerHTML=ye,oe=a(),c(M.$$.fragment),pe=a(),c(S.$$.fragment),de=a(),W=r("p"),W.innerHTML=Ue,me=a(),c(B.$$.fragment),ce=a(),H=r("p"),H.innerHTML=je,he=a(),E=r("p"),this.h()},l(e){const t=We("svelte-u9bgzb",document.head);s=o(t,"META",{name:!0,content:!0}),t.forEach(l),m=i(e),p=o(e,"P",{}),ke(p).forEach(l),b=i(e),h(v.$$.fragment,e),V=i(e),T=o(e,"P",{"data-svelte-h":!0}),d(T)!=="svelte-1u8i7ng"&&(T.textContent=$e),R=i(e),x=o(e,"P",{"data-svelte-h":!0}),d(x)!=="svelte-1pzk3n6"&&(x.textContent=we),F=i(e),_=o(e,"P",{"data-svelte-h":!0}),d(_)!=="svelte-1px1vea"&&(_.textContent=be),N=i(e),C=o(e,"OL",{"data-svelte-h":!0}),d(C)!=="svelte-1ezajja"&&(C.innerHTML=ge),Q=i(e),h(y.$$.fragment,e),q=i(e),U=o(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-bsdfhs"&&(U.innerHTML=Me),K=i(e),h(j.$$.fragment,e),O=i(e),P=o(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-bvqjor"&&(P.innerHTML=ve),D=i(e),h(z.$$.fragment,e),ee=i(e),k=o(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1x4b50a"&&(k.textContent=Te),te=i(e),h(G.$$.fragment,e),le=i(e),Z=o(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-y1nchk"&&(Z.innerHTML=xe),ne=i(e),J=o(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-1pogoqw"&&(J.textContent=_e),se=i(e),h(g.$$.fragment,e),ae=i(e),A=o(e,"TABLE",{"data-svelte-h":!0}),d(A)!=="svelte-4k3weo"&&(A.innerHTML=Ce),ie=i(e),h(L.$$.fragment,e),re=i(e),Y=o(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1xakrqo"&&(Y.innerHTML=ye),oe=i(e),h(M.$$.fragment,e),pe=i(e),h(S.$$.fragment,e),de=i(e),W=o(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1z0alx"&&(W.innerHTML=Ue),me=i(e),h(B.$$.fragment,e),ce=i(e),H=o(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-1oucnsg"&&(H.innerHTML=je),he=i(e),E=o(e,"P",{}),ke(E).forEach(l),this.h()},h(){Ge(s,"name","hf:doc:metadata"),Ge(s,"content",Ie)},m(e,t){Be(document.head,s),n(e,m,t),n(e,p,t),n(e,b,t),f(v,e,t),n(e,V,t),n(e,T,t),n(e,R,t),n(e,x,t),n(e,F,t),n(e,_,t),n(e,N,t),n(e,C,t),n(e,Q,t),f(y,e,t),n(e,q,t),n(e,U,t),n(e,K,t),f(j,e,t),n(e,O,t),n(e,P,t),n(e,D,t),f(z,e,t),n(e,ee,t),n(e,k,t),n(e,te,t),f(G,e,t),n(e,le,t),n(e,Z,t),n(e,ne,t),n(e,J,t),n(e,se,t),f(g,e,t),n(e,ae,t),n(e,A,t),n(e,ie,t),f(L,e,t),n(e,re,t),n(e,Y,t),n(e,oe,t),f(M,e,t),n(e,pe,t),f(S,e,t),n(e,de,t),n(e,W,t),n(e,me,t),f(B,e,t),n(e,ce,t),n(e,H,t),n(e,he,t),n(e,E,t),fe=!0},p(e,[t]){const Pe={};t&2&&(Pe.$$scope={dirty:t,ctx:e}),g.$set(Pe);const ze={};t&2&&(ze.$$scope={dirty:t,ctx:e}),M.$set(ze)},i(e){fe||(u(v.$$.fragment,e),u(y.$$.fragment,e),u(j.$$.fragment,e),u(z.$$.fragment,e),u(G.$$.fragment,e),u(g.$$.fragment,e),u(L.$$.fragment,e),u(M.$$.fragment,e),u(S.$$.fragment,e),u(B.$$.fragment,e),fe=!0)},o(e){$(v.$$.fragment,e),$(y.$$.fragment,e),$(j.$$.fragment,e),$(z.$$.fragment,e),$(G.$$.fragment,e),$(g.$$.fragment,e),$(L.$$.fragment,e),$(M.$$.fragment,e),$(S.$$.fragment,e),$(B.$$.fragment,e),fe=!1},d(e){e&&(l(m),l(p),l(b),l(V),l(T),l(R),l(x),l(F),l(_),l(N),l(C),l(Q),l(q),l(U),l(K),l(O),l(P),l(D),l(ee),l(k),l(te),l(le),l(Z),l(ne),l(J),l(se),l(ae),l(A),l(ie),l(re),l(Y),l(oe),l(pe),l(de),l(W),l(me),l(ce),l(H),l(he),l(E)),l(s),w(v,e),w(y,e),w(j,e),w(z,e),w(G,e),w(g,e),w(L,e),w(M,e),w(S,e),w(B,e)}}}const Ie='{"title":"Comparing performance between different device setups","local":"comparing-performance-between-different-device-setups","sections":[{"title":"Setting the Seed","local":"setting-the-seed","sections":[],"depth":2},{"title":"Observed Batch Sizes","local":"observed-batch-sizes","sections":[],"depth":2},{"title":"Learning Rates","local":"learning-rates","sections":[],"depth":2},{"title":"Gradient Accumulation and Mixed Precision","local":"gradient-accumulation-and-mixed-precision","sections":[],"depth":2}],"depth":1}';function Ve(X){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ke extends Ye{constructor(s){super(),Se(this,s,Ve,Ee,Ae,{})}}export{Ke as component};
