import{s as Ft,n as Rt,o as Jt}from"../chunks/scheduler.22bf70d2.js";import{S as Ht,i as xt,g as n,s,r as d,A as Wt,h as r,f as l,c as i,j as jt,u as p,x as o,k as St,y as At,a,v as c,d as f,t as m,w as h}from"../chunks/index.59178e06.js";import{C as _}from"../chunks/CodeBlock.f7047b13.js";import{H as ie}from"../chunks/Heading.f8746c79.js";function Ut(Ke){let u,oe,ne,de,w,pe,M,et=`To accelerate training huge models on larger batch sizes, we can use a fully sharded data parallel model.
This type of data parallel paradigm enables fitting more data and larger models by sharding the optimizer states, gradients and parameters.
To read more about it and the benefits, check out the <a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api/" rel="nofollow">Fully Sharded Data Parallel blog</a>.
We have integrated the latest PyTorch’s Fully Sharded Data Parallel (FSDP) training feature.
All you need to do is enable it through the config.`,ce,T,fe,y,tt="On your machine(s) just run:",me,g,he,b,lt=`and answer the questions asked. This will generate a config file that will be used automatically to properly set the
default options when doing`,ue,B,_e,v,at="For instance, here is how you would run <code>examples/nlp_example.py</code> (from the root of the repo) with FSDP enabled:",we,$,Me,Z,Te,j,st="Currently, <code>Accelerate</code> supports the following config through the CLI:",ye,S,it='<code>fsdp_sharding_strategy</code>: [1] FULL_SHARD (shards optimizer states, gradients and parameters), [2] SHARD_GRAD_OP (shards optimizer states and gradients), [3] NO_SHARD (DDP), [4] HYBRID_SHARD (shards optimizer states, gradients and parameters within each node while each node has full copy), [5] HYBRID_SHARD_ZERO2 (shards optimizer states and gradients within each node while each node has full copy). For more information, please refer the official <a href="https://pytorch.org/docs/stable/fsdp.html#torch.distributed.fsdp.ShardingStrategy" rel="nofollow">PyTorch docs</a>.',ge,F,nt="<code>fsdp_offload_params</code> : Decides Whether to offload parameters and gradients to CPU",be,R,rt="<code>fsdp_auto_wrap_policy</code>: [1] TRANSFORMER_BASED_WRAP, [2] SIZE_BASED_WRAP, [3] NO_WRAP",Be,J,ot="<code>fsdp_transformer_layer_cls_to_wrap</code>: Only applicable for 🤗 Transformers. When using <code>fsdp_auto_wrap_policy=TRANSFORMER_BASED_WRAP</code>, a user may provide a comma-separated string of transformer layer class names (case-sensitive) to wrap, e.g., <code>BertLayer</code>, <code>GPTJBlock</code>, <code>T5Block</code>, <code>BertLayer,BertEmbeddings,BertSelfOutput</code>. This is important because submodules that share weights (e.g., embedding layers) should not end up in different FSDP wrapped units. Using this policy, wrapping happens for each block containing Multi-Head Attention followed by a couple of MLP layers. Remaining layers including the shared embeddings are conveniently wrapped in same outermost FSDP unit. Therefore, use this for transformer-based models. You can use the <code>model._no_split_modules</code> for 🤗 Transformer models by answering <code>yes</code> to <code>Do you want to use the model&#39;s </code>_no_split_modules<code>to wrap. It will try to use</code>model._no_split_modules` when possible.",ve,H,dt="<code>fsdp_min_num_params</code>: minimum number of parameters when using <code>fsdp_auto_wrap_policy=SIZE_BASED_WRAP</code>.",$e,x,pt="<code>fsdp_backward_prefetch_policy</code>: [1] BACKWARD_PRE, [2] BACKWARD_POST, [3] NO_PREFETCH",Ze,W,ct="<code>fsdp_forward_prefetch</code>: if True, then FSDP explicitly prefetches the next upcoming all-gather while executing in the forward pass. Should only be used for static-graph models since the prefetching follows the first iteration’s execution order. i.e., if the sub-modules’ order changes dynamically during the model’s execution do not enable this feature.",je,A,ft="<code>fsdp_state_dict_type</code>: [1] FULL_STATE_DICT, [2] LOCAL_STATE_DICT, [3] SHARDED_STATE_DICT",Se,U,mt='<code>fsdp_use_orig_params</code>: If True, allows non-uniform <code>requires_grad</code> during init, which means support for interspersed frozen and trainable parameters. This setting is useful in cases such as parameter-efficient fine-tuning as discussed in <a href="https://dev-discuss.pytorch.org/t/rethinking-pytorch-fully-sharded-data-parallel-fsdp-from-first-principles/1019" rel="nofollow">this post</a>. This option also allows one to have multiple optimizer param groups. This should be <code>True</code> when creating an optimizer before preparing/wrapping the model with FSDP.',Fe,G,ht="<code>fsdp_cpu_ram_efficient_loading</code>: Only applicable for 🤗 Transformers models. If True, only the first process loads the pretrained model checkpoint while all other processes have empty weights. This should be set to False if you experience errors when loading the pretrained 🤗 Transformers model via <code>from_pretrained</code> method. When this setting is True <code>fsdp_sync_module_states</code> also must to be True, otherwise all the processes except the main process would have random weights leading to unexpected behaviour during training. For this to work, make sure the distributed process group is initialized before calling Transformers <code>from_pretrained</code> method. When using 🤗 Trainer API, the distributed process group is initialized when you create an instance of <code>TrainingArguments</code> class.",Re,k,ut="<code>fsdp_sync_module_states</code>: If True, each individually wrapped FSDP unit will broadcast module parameters from rank 0.",Je,P,_t=`For additional and more nuanced control, you can specify other FSDP parameters via <code>FullyShardedDataParallelPlugin</code>.
When creating <code>FullyShardedDataParallelPlugin</code> object, pass it the parameters that weren’t part of the accelerate config or if you want to override them.
The FSDP parameters will be picked based on the accelerate config file or launch command arguments and other parameters that you will pass directly through the <code>FullyShardedDataParallelPlugin</code> object will set/override that.`,He,C,wt="Below is an example:",xe,E,We,N,Ae,z,Mt=`The new recommended way of checkpointing when using FSDP models is to use <code>SHARDED_STATE_DICT</code> as <code>StateDictType</code> when setting up the accelerate config.
Below is the code snippet to save using <code>save_state</code> utility of accelerate.`,Ue,D,Ge,X,Tt="Inspect the checkpoint folder to see model and optimizer as shards per process:",ke,L,Pe,Y,yt="To load them back for resuming the training, use the <code>load_state</code> utility of accelerate",Ce,I,Ee,V,gt=`When using transformers <code>save_pretrained</code>, pass <code>state_dict=accelerator.get_state_dict(model)</code> to save the model state dict.
Below is an example:`,Ne,Q,ze,O,De,q,bt="<code>accelerator.get_state_dict</code> will call the underlying <code>model.state_dict</code> implementation using <code>FullStateDictConfig(offload_to_cpu=True, rank0_only=True)</code> context manager to get the state dict only for rank 0 and it will be offloaded to CPU.",Xe,K,Bt='You can then pass <code>state</code> into the <code>save_pretrained</code> method.  There are several modes for <code>StateDictType</code> and <code>FullStateDictConfig</code> that you can use to control the behavior of <code>state_dict</code>.  For more information, see the <a href="https://pytorch.org/docs/stable/fsdp.html" rel="nofollow">PyTorch documentation</a>.',Le,ee,Ye,te,vt="<li><code>FULL_SHARD</code> maps to the DeepSpeed <code>ZeRO Stage-3</code>. Shards optimizer states, gradients and parameters.</li> <li><code>SHARD_GRAD_OP</code> maps to the DeepSpeed <code>ZeRO Stage-2</code>. Shards optimizer states and gradients.</li> <li><code>NO_SHARD</code> maps to <code>ZeRO Stage-0</code>. No sharding wherein each GPU has full copy of model, optimizer states and gradients.</li> <li><code>HYBRID_SHARD</code> maps to <code>ZeRO++ Stage-3</code> wherein <code>zero_hpz_partition_size=&lt;num_gpus_per_node&gt;</code>. Here, this will shard optimizer states, gradients and parameters within each node while each node has full copy.</li>",Ie,le,Ve,ae,$t="<li>In case of multiple models, pass the optimizers to the prepare call in the same order as corresponding models else <code>accelerator.save_state()</code> and <code>accelerator.load_state()</code> will result in wrong/unexpected behaviour.</li> <li>This feature is incompatible with <code>--predict_with_generate</code> in the <code>run_translation.py</code> script of 🤗 <code>Transformers</code> library.</li>",Qe,se,Zt=`For more control, users can leverage the <code>FullyShardedDataParallelPlugin</code>. After creating an instance of this class, users can pass it to the Accelerator class instantiation.
For more information on these options, please refer to the PyTorch <a href="https://github.com/pytorch/pytorch/blob/0df2e863fbd5993a7b9e652910792bd21a516ff3/torch/distributed/fsdp/fully_sharded_data_parallel.py#L236" rel="nofollow">FullyShardedDataParallel</a> code.`,Oe,re,qe;return w=new ie({props:{title:"Fully Sharded Data Parallel",local:"fully-sharded-data-parallel",headingTag:"h1"}}),T=new ie({props:{title:"How it works out of the box",local:"how-it-works-out-of-the-box",headingTag:"h2"}}),g=new _({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),B=new _({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMG15X3NjcmlwdC5weSUyMC0tYXJnc190b19teV9zY3JpcHQ=",highlighted:"accelerate launch my_script.py --args_to_my_script",wrap:!1}}),$=new _({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWJ1ZyUzQSUyMGZhbHNlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMEZTRFAlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQWZzZHBfY29uZmlnJTNBJTBBJTIwJTIwZnNkcF9hdXRvX3dyYXBfcG9saWN5JTNBJTIwVFJBTlNGT1JNRVJfQkFTRURfV1JBUCUwQSUyMCUyMGZzZHBfYmFja3dhcmRfcHJlZmV0Y2hfcG9saWN5JTNBJTIwQkFDS1dBUkRfUFJFJTBBJTIwJTIwZnNkcF9mb3J3YXJkX3ByZWZldGNoJTNBJTIwZmFsc2UlMEElMjAlMjBmc2RwX2NwdV9yYW1fZWZmaWNpZW50X2xvYWRpbmclM0ElMjB0cnVlJTBBJTIwJTIwZnNkcF9vZmZsb2FkX3BhcmFtcyUzQSUyMGZhbHNlJTBBJTIwJTIwZnNkcF9zaGFyZGluZ19zdHJhdGVneSUzQSUyMEZVTExfU0hBUkQlMEElMjAlMjBmc2RwX3N0YXRlX2RpY3RfdHlwZSUzQSUyMFNIQVJERURfU1RBVEVfRElDVCUwQSUyMCUyMGZzZHBfc3luY19tb2R1bGVfc3RhdGVzJTNBJTIwdHJ1ZSUwQSUyMCUyMGZzZHBfdHJhbnNmb3JtZXJfbGF5ZXJfY2xzX3RvX3dyYXAlM0ElMjBCZXJ0TGF5ZXIlMEElMjAlMjBmc2RwX3VzZV9vcmlnX3BhcmFtcyUzQSUyMHRydWUlMEFtYWNoaW5lX3JhbmslM0ElMjAwJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtaXhlZF9wcmVjaXNpb24lM0ElMjBiZjE2JTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBcmR6dl9iYWNrZW5kJTNBJTIwc3RhdGljJTBBc2FtZV9uZXR3b3JrJTNBJTIwdHJ1ZSUwQXRwdV9lbnYlM0ElMjAlNUIlNUQlMEF0cHVfdXNlX2NsdXN0ZXIlM0ElMjBmYWxzZSUwQXRwdV91c2Vfc3VkbyUzQSUyMGZhbHNlJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`compute_environment: LOCAL_MACHINE
debug: <span class="hljs-literal">false</span>
distributed_type: FSDP
downcast_bf16: <span class="hljs-string">&#x27;no&#x27;</span>
fsdp_config:
  fsdp_auto_wrap_policy: TRANSFORMER_BASED_WRAP
  fsdp_backward_prefetch_policy: BACKWARD_PRE
  fsdp_forward_prefetch: <span class="hljs-literal">false</span>
  fsdp_cpu_ram_efficient_loading: <span class="hljs-literal">true</span>
  fsdp_offload_params: <span class="hljs-literal">false</span>
  fsdp_sharding_strategy: FULL_SHARD
  fsdp_state_dict_type: SHARDED_STATE_DICT
  fsdp_sync_module_states: <span class="hljs-literal">true</span>
  fsdp_transformer_layer_cls_to_wrap: BertLayer
  fsdp_use_orig_params: <span class="hljs-literal">true</span>
machine_rank: 0
main_training_function: main
mixed_precision: bf16
num_machines: 1
num_processes: 2
rdzv_backend: static
same_network: <span class="hljs-literal">true</span>
tpu_env: []
tpu_use_cluster: <span class="hljs-literal">false</span>
tpu_use_sudo: <span class="hljs-literal">false</span>
use_cpu: <span class="hljs-literal">false</span>`,wrap:!1}}),Z=new _({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGbmxwX2V4YW1wbGUucHk=",highlighted:"accelerate launch examples/nlp_example.py",wrap:!1}}),E=new _({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBGdWxseVNoYXJkZWREYXRhUGFyYWxsZWxQbHVnaW4lMEFmcm9tJTIwdG9yY2guZGlzdHJpYnV0ZWQuZnNkcC5mdWxseV9zaGFyZGVkX2RhdGFfcGFyYWxsZWwlMjBpbXBvcnQlMjBGdWxsT3B0aW1TdGF0ZURpY3RDb25maWclMkMlMjBGdWxsU3RhdGVEaWN0Q29uZmlnJTBBJTBBZnNkcF9wbHVnaW4lMjAlM0QlMjBGdWxseVNoYXJkZWREYXRhUGFyYWxsZWxQbHVnaW4oJTBBJTIwJTIwJTIwJTIwc3RhdGVfZGljdF9jb25maWclM0RGdWxsU3RhdGVEaWN0Q29uZmlnKG9mZmxvYWRfdG9fY3B1JTNERmFsc2UlMkMlMjByYW5rMF9vbmx5JTNERmFsc2UpJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW1fc3RhdGVfZGljdF9jb25maWclM0RGdWxsT3B0aW1TdGF0ZURpY3RDb25maWcob2ZmbG9hZF90b19jcHUlM0RGYWxzZSUyQyUyMHJhbmswX29ubHklM0RGYWxzZSklMkMlMEEpJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihmc2RwX3BsdWdpbiUzRGZzZHBfcGx1Z2luKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> FullyShardedDataParallelPlugin
<span class="hljs-keyword">from</span> torch.distributed.fsdp.fully_sharded_data_parallel <span class="hljs-keyword">import</span> FullOptimStateDictConfig, FullStateDictConfig

fsdp_plugin = FullyShardedDataParallelPlugin(
    state_dict_config=FullStateDictConfig(offload_to_cpu=<span class="hljs-literal">False</span>, rank0_only=<span class="hljs-literal">False</span>),
    optim_state_dict_config=FullOptimStateDictConfig(offload_to_cpu=<span class="hljs-literal">False</span>, rank0_only=<span class="hljs-literal">False</span>),
)

accelerator = Accelerator(fsdp_plugin=fsdp_plugin)`,wrap:!1}}),N=new ie({props:{title:"Saving and loading",local:"saving-and-loading",headingTag:"h2"}}),D=new _({props:{code:"YWNjZWxlcmF0b3Iuc2F2ZV9zdGF0ZSglMjJja3B0JTIyKQ==",highlighted:'accelerator.save_state(<span class="hljs-string">&quot;ckpt&quot;</span>)',wrap:!1}}),L=new _({props:{code:"bHMlMjBja3B0JTBBJTIzJTIwb3B0aW1pemVyXzAlMjAlMjBweXRvcmNoX21vZGVsXzAlMjAlMjByYW5kb21fc3RhdGVzXzAucGtsJTIwJTIwcmFuZG9tX3N0YXRlc18xLnBrbCUyMCUyMHNjaGVkdWxlci5iaW4lMEElMEFjZCUyMGNrcHQlMEElMEFscyUyMG9wdGltaXplcl8wJTBBJTIzJTIwX18wXzAuZGlzdGNwJTIwJTIwX18xXzAuZGlzdGNwJTBBJTBBbHMlMjBweXRvcmNoX21vZGVsXzAlMEElMjMlMjBfXzBfMC5kaXN0Y3AlMjAlMjBfXzFfMC5kaXN0Y3A=",highlighted:`<span class="hljs-built_in">ls</span> ckpt
<span class="hljs-comment"># optimizer_0  pytorch_model_0  random_states_0.pkl  random_states_1.pkl  scheduler.bin</span>

<span class="hljs-built_in">cd</span> ckpt

<span class="hljs-built_in">ls</span> optimizer_0
<span class="hljs-comment"># __0_0.distcp  __1_0.distcp</span>

<span class="hljs-built_in">ls</span> pytorch_model_0
<span class="hljs-comment"># __0_0.distcp  __1_0.distcp</span>`,wrap:!1}}),I=new _({props:{code:"YWNjZWxlcmF0b3IubG9hZF9zdGF0ZSglMjJja3B0JTIyKQ==",highlighted:'accelerator.load_state(<span class="hljs-string">&quot;ckpt&quot;</span>)',wrap:!1}}),Q=new _({props:{code:"JTIwJTIwdW53cmFwcGVkX21vZGVsLnNhdmVfcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjBhcmdzLm91dHB1dF9kaXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBpc19tYWluX3Byb2Nlc3MlM0RhY2NlbGVyYXRvci5pc19tYWluX3Byb2Nlc3MlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBzYXZlX2Z1bmN0aW9uJTNEYWNjZWxlcmF0b3Iuc2F2ZSUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMHN0YXRlX2RpY3QlM0RhY2NlbGVyYXRvci5nZXRfc3RhdGVfZGljdChtb2RlbCklMkMlMEEp",highlighted:`  unwrapped_model.save_pretrained(
      args.output_dir,
      is_main_process=accelerator.is_main_process,
      save_function=accelerator.save,
<span class="hljs-addition">+     state_dict=accelerator.get_state_dict(model),</span>
)`,wrap:!1}}),O=new ie({props:{title:"State Dict",local:"state-dict",headingTag:"h3"}}),ee=new ie({props:{title:"Mapping between FSDP sharding strategies and DeepSpeed ZeRO Stages",local:"mapping-between-fsdp-sharding-strategies-and-deepspeed-zero-stages",headingTag:"h2"}}),le=new ie({props:{title:"A few caveats to be aware of",local:"a-few-caveats-to-be-aware-of",headingTag:"h2"}}),{c(){u=n("meta"),oe=s(),ne=n("p"),de=s(),d(w.$$.fragment),pe=s(),M=n("p"),M.innerHTML=et,ce=s(),d(T.$$.fragment),fe=s(),y=n("p"),y.textContent=tt,me=s(),d(g.$$.fragment),he=s(),b=n("p"),b.textContent=lt,ue=s(),d(B.$$.fragment),_e=s(),v=n("p"),v.innerHTML=at,we=s(),d($.$$.fragment),Me=s(),d(Z.$$.fragment),Te=s(),j=n("p"),j.innerHTML=st,ye=s(),S=n("p"),S.innerHTML=it,ge=s(),F=n("p"),F.innerHTML=nt,be=s(),R=n("p"),R.innerHTML=rt,Be=s(),J=n("p"),J.innerHTML=ot,ve=s(),H=n("p"),H.innerHTML=dt,$e=s(),x=n("p"),x.innerHTML=pt,Ze=s(),W=n("p"),W.innerHTML=ct,je=s(),A=n("p"),A.innerHTML=ft,Se=s(),U=n("p"),U.innerHTML=mt,Fe=s(),G=n("p"),G.innerHTML=ht,Re=s(),k=n("p"),k.innerHTML=ut,Je=s(),P=n("p"),P.innerHTML=_t,He=s(),C=n("p"),C.textContent=wt,xe=s(),d(E.$$.fragment),We=s(),d(N.$$.fragment),Ae=s(),z=n("p"),z.innerHTML=Mt,Ue=s(),d(D.$$.fragment),Ge=s(),X=n("p"),X.textContent=Tt,ke=s(),d(L.$$.fragment),Pe=s(),Y=n("p"),Y.innerHTML=yt,Ce=s(),d(I.$$.fragment),Ee=s(),V=n("p"),V.innerHTML=gt,Ne=s(),d(Q.$$.fragment),ze=s(),d(O.$$.fragment),De=s(),q=n("p"),q.innerHTML=bt,Xe=s(),K=n("p"),K.innerHTML=Bt,Le=s(),d(ee.$$.fragment),Ye=s(),te=n("ul"),te.innerHTML=vt,Ie=s(),d(le.$$.fragment),Ve=s(),ae=n("ul"),ae.innerHTML=$t,Qe=s(),se=n("p"),se.innerHTML=Zt,Oe=s(),re=n("p"),this.h()},l(e){const t=Wt("svelte-u9bgzb",document.head);u=r(t,"META",{name:!0,content:!0}),t.forEach(l),oe=i(e),ne=r(e,"P",{}),jt(ne).forEach(l),de=i(e),p(w.$$.fragment,e),pe=i(e),M=r(e,"P",{"data-svelte-h":!0}),o(M)!=="svelte-qnvjvw"&&(M.innerHTML=et),ce=i(e),p(T.$$.fragment,e),fe=i(e),y=r(e,"P",{"data-svelte-h":!0}),o(y)!=="svelte-3pof6s"&&(y.textContent=tt),me=i(e),p(g.$$.fragment,e),he=i(e),b=r(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-ovz84c"&&(b.textContent=lt),ue=i(e),p(B.$$.fragment,e),_e=i(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-109sebi"&&(v.innerHTML=at),we=i(e),p($.$$.fragment,e),Me=i(e),p(Z.$$.fragment,e),Te=i(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-aporbc"&&(j.innerHTML=st),ye=i(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-mtvmo1"&&(S.innerHTML=it),ge=i(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-173mpds"&&(F.innerHTML=nt),be=i(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-56dvve"&&(R.innerHTML=rt),Be=i(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-9h1xw0"&&(J.innerHTML=ot),ve=i(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-fbrtfo"&&(H.innerHTML=dt),$e=i(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-gnni23"&&(x.innerHTML=pt),Ze=i(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1b8s7mr"&&(W.innerHTML=ct),je=i(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1bw4fgg"&&(A.innerHTML=ft),Se=i(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1hsz8jb"&&(U.innerHTML=mt),Fe=i(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1lu06m7"&&(G.innerHTML=ht),Re=i(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-9z96c5"&&(k.innerHTML=ut),Je=i(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1mlu7qv"&&(P.innerHTML=_t),He=i(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-ks9e2y"&&(C.textContent=wt),xe=i(e),p(E.$$.fragment,e),We=i(e),p(N.$$.fragment,e),Ae=i(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-105rpu1"&&(z.innerHTML=Mt),Ue=i(e),p(D.$$.fragment,e),Ge=i(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-zz881x"&&(X.textContent=Tt),ke=i(e),p(L.$$.fragment,e),Pe=i(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1v7i9ht"&&(Y.innerHTML=yt),Ce=i(e),p(I.$$.fragment,e),Ee=i(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1y7f54p"&&(V.innerHTML=gt),Ne=i(e),p(Q.$$.fragment,e),ze=i(e),p(O.$$.fragment,e),De=i(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-y5myy"&&(q.innerHTML=bt),Xe=i(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-57zs50"&&(K.innerHTML=Bt),Le=i(e),p(ee.$$.fragment,e),Ye=i(e),te=r(e,"UL",{"data-svelte-h":!0}),o(te)!=="svelte-1mojn5u"&&(te.innerHTML=vt),Ie=i(e),p(le.$$.fragment,e),Ve=i(e),ae=r(e,"UL",{"data-svelte-h":!0}),o(ae)!=="svelte-125fftf"&&(ae.innerHTML=$t),Qe=i(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1dlu8nc"&&(se.innerHTML=Zt),Oe=i(e),re=r(e,"P",{}),jt(re).forEach(l),this.h()},h(){St(u,"name","hf:doc:metadata"),St(u,"content",Gt)},m(e,t){At(document.head,u),a(e,oe,t),a(e,ne,t),a(e,de,t),c(w,e,t),a(e,pe,t),a(e,M,t),a(e,ce,t),c(T,e,t),a(e,fe,t),a(e,y,t),a(e,me,t),c(g,e,t),a(e,he,t),a(e,b,t),a(e,ue,t),c(B,e,t),a(e,_e,t),a(e,v,t),a(e,we,t),c($,e,t),a(e,Me,t),c(Z,e,t),a(e,Te,t),a(e,j,t),a(e,ye,t),a(e,S,t),a(e,ge,t),a(e,F,t),a(e,be,t),a(e,R,t),a(e,Be,t),a(e,J,t),a(e,ve,t),a(e,H,t),a(e,$e,t),a(e,x,t),a(e,Ze,t),a(e,W,t),a(e,je,t),a(e,A,t),a(e,Se,t),a(e,U,t),a(e,Fe,t),a(e,G,t),a(e,Re,t),a(e,k,t),a(e,Je,t),a(e,P,t),a(e,He,t),a(e,C,t),a(e,xe,t),c(E,e,t),a(e,We,t),c(N,e,t),a(e,Ae,t),a(e,z,t),a(e,Ue,t),c(D,e,t),a(e,Ge,t),a(e,X,t),a(e,ke,t),c(L,e,t),a(e,Pe,t),a(e,Y,t),a(e,Ce,t),c(I,e,t),a(e,Ee,t),a(e,V,t),a(e,Ne,t),c(Q,e,t),a(e,ze,t),c(O,e,t),a(e,De,t),a(e,q,t),a(e,Xe,t),a(e,K,t),a(e,Le,t),c(ee,e,t),a(e,Ye,t),a(e,te,t),a(e,Ie,t),c(le,e,t),a(e,Ve,t),a(e,ae,t),a(e,Qe,t),a(e,se,t),a(e,Oe,t),a(e,re,t),qe=!0},p:Rt,i(e){qe||(f(w.$$.fragment,e),f(T.$$.fragment,e),f(g.$$.fragment,e),f(B.$$.fragment,e),f($.$$.fragment,e),f(Z.$$.fragment,e),f(E.$$.fragment,e),f(N.$$.fragment,e),f(D.$$.fragment,e),f(L.$$.fragment,e),f(I.$$.fragment,e),f(Q.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(le.$$.fragment,e),qe=!0)},o(e){m(w.$$.fragment,e),m(T.$$.fragment,e),m(g.$$.fragment,e),m(B.$$.fragment,e),m($.$$.fragment,e),m(Z.$$.fragment,e),m(E.$$.fragment,e),m(N.$$.fragment,e),m(D.$$.fragment,e),m(L.$$.fragment,e),m(I.$$.fragment,e),m(Q.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),qe=!1},d(e){e&&(l(oe),l(ne),l(de),l(pe),l(M),l(ce),l(fe),l(y),l(me),l(he),l(b),l(ue),l(_e),l(v),l(we),l(Me),l(Te),l(j),l(ye),l(S),l(ge),l(F),l(be),l(R),l(Be),l(J),l(ve),l(H),l($e),l(x),l(Ze),l(W),l(je),l(A),l(Se),l(U),l(Fe),l(G),l(Re),l(k),l(Je),l(P),l(He),l(C),l(xe),l(We),l(Ae),l(z),l(Ue),l(Ge),l(X),l(ke),l(Pe),l(Y),l(Ce),l(Ee),l(V),l(Ne),l(ze),l(De),l(q),l(Xe),l(K),l(Le),l(Ye),l(te),l(Ie),l(Ve),l(ae),l(Qe),l(se),l(Oe),l(re)),l(u),h(w,e),h(T,e),h(g,e),h(B,e),h($,e),h(Z,e),h(E,e),h(N,e),h(D,e),h(L,e),h(I,e),h(Q,e),h(O,e),h(ee,e),h(le,e)}}}const Gt='{"title":"Fully Sharded Data Parallel","local":"fully-sharded-data-parallel","sections":[{"title":"How it works out of the box","local":"how-it-works-out-of-the-box","sections":[],"depth":2},{"title":"Saving and loading","local":"saving-and-loading","sections":[{"title":"State Dict","local":"state-dict","sections":[],"depth":3}],"depth":2},{"title":"Mapping between FSDP sharding strategies and DeepSpeed ZeRO Stages","local":"mapping-between-fsdp-sharding-strategies-and-deepspeed-zero-stages","sections":[],"depth":2},{"title":"A few caveats to be aware of","local":"a-few-caveats-to-be-aware-of","sections":[],"depth":2}],"depth":1}';function kt(Ke){return Jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends Ht{constructor(u){super(),xt(this,u,kt,Ut,Ft,{})}}export{zt as component};
