import{s as UZ,o as ZZ,n as x}from"../chunks/scheduler.25b97de1.js";import{S as CZ,i as WZ,g as o,s as a,r as m,A as BZ,h as l,f as n,c as r,j as T,u as g,x as _,k as M,y as t,a as p,v as h,d as u,t as f,w as b}from"../chunks/index.d9030fc9.js";import{T as Ra}from"../chunks/Tip.baa67368.js";import{D as v}from"../chunks/Docstring.ffac8efa.js";import{C as U}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Z}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as se,E as IZ}from"../chunks/EditOnGithub.91d95064.js";function zZ(j){let i,$=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/en/model_doc/bark" rel="nofollow">Bark</a>’s fine submodel. See the model documentation
for examples.`;return{c(){i=o("p"),i.innerHTML=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),_(i)!=="svelte-nbt45a"&&(i.innerHTML=$)},m(y,d){p(y,i,d)},p:x,d(y){y&&n(i)}}}function VZ(j){let i,$=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/main/en/model_doc/musicgen" rel="nofollow">MusicGen</a>`;return{c(){i=o("p"),i.innerHTML=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),_(i)!=="svelte-1uojnuk"&&(i.innerHTML=$)},m(y,d){p(y,i,d)},p:x,d(y){y&&n(i)}}}function GZ(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function FZ(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkFsaWNlJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMFdoYXQlMjBkbyUyMHlvdSUyMGxvdmUlM0YlNUNuQm9iJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwZ3JlZWR5JTIwZGVjb2RpbmclMkMlMjB3ZSUyMHNlZSUyMEJvYiUyMHJlcGVhdGluZyUyMEFsaWNlJ3MlMjBvcGluaW9uLiUyMElmJTIwQm9iJTIwd2FzJTIwYSUyMGNoYXRib3QlMkMlMjBpdCUyMHdvdWxkJTIwYmUlMjBhJTIwcG9vciUyMG9uZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhpcyUyMGxvZ2l0cyUyMHByb2Nlc3NvciUyQyUyMHdlJTIwY2FuJTIwcHJldmVudCUyMEJvYiUyMGZyb20lMjByZXBlYXRpbmclMjBBbGljZSdzJTIwb3Bpbmlvbi4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX25vX3JlcGVhdF9uZ3JhbV9zaXplJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice: I love cats. What do you love?\\nBob:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With greedy decoding, we see Bob repeating Alice&#x27;s opinion. If Bob was a chatbot, it would be a poor one.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: I love cats. What do you

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With this logits processor, we can prevent Bob from repeating Alice&#x27;s opinion.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, encoder_no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: My cats are very cute.`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function XZ(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkFsaWNlJTIwYW5kJTIwQm9iLiUyMFRoZSUyMHRoaXJkJTIwbWVtYmVyJ3MlMjBuYW1lJTIwd2FzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhlJTIwJTYwZW5jb2Rlcl9yZXBldGl0aW9uX3BlbmFsdHklNjAlMjBhcmd1bWVudCUyMHdlJTIwY2FuJTIwdHJpZ2dlciUyMHRoaXMlMjBsb2dpdHMlMjBwcm9jZXNzb3IlMjBpbiUyMCU2MGdlbmVyYXRlJTYwJTJDJTIwd2hpY2glMjBjYW4lMEElMjMlMjBwcm9tb3RlJTIwdGhlJTIwdXNlJTIwb2YlMjBwcm9tcHQlMjB0b2tlbnMlMjAoJTIyQm9iJTIyJTIwaW4lMjB0aGlzJTIwZXhhbXBsZSklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX3JlcGV0aXRpb25fcGVuYWx0eSUzRDEuMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob. The third member&#x27;s name was&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob. The third membe<span class="hljs-string">r&#x27;s name was not mentioned.

&gt;&gt;&gt; # With the \`encoder_repetition_penalty\` argument we can trigger this logits processor in \`generate\`, which can
&gt;&gt;&gt; # promote the use of prompt tokens (&quot;Bob&quot; in this example)
&gt;&gt;&gt; gen_out = model.generate(**inputs, encoder_repetition_penalty=1.2)
&gt;&gt;&gt; print(tokenizer.batch_decode(gen_out, skip_special_tokens=True)[0])
Alice and Bob. The third member&#x27;</span>s name was Bob. The third membe<span class="hljs-string">r&#x27;s name was Bob.</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function RZ(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGVwc2lsb24lMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyME5vdGUlMjB0aGF0JTIwdGhpcyUyMGlzJTIwc2ltaWxhciUyMHRvJTBBJTIzJTIwVG9wJTIwUCUyMHNhbXBsaW5nJTJDJTIwd2hpY2glMjByZXN0cmljdHMlMjB0b2tlbnMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBjdW11bGF0aXZlJTIwcHJvYmFiaWxpdHkuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGVwc2lsb25fY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjBhbmQlMjA5ZS00JTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGVwc2lsb25fY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function LZ(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGV0YSUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTIwWW91JTIwY2FuJTIwc2VlJTIwaXQlMjBhcyUyMGElMjBkeW5hbWljJTIwZm9ybSUyMG9mJTBBJTIzJTIwZXBzaWxvbiUyMHNhbXBsaW5nJTIwdGhhdCUyMGFkYXB0cyUyMGl0cyUyMGN1dG9mZiUyMHByb2JhYmlsaXR5JTIwYmFzZWQlMjBvbiUyMHRoZSUyMGVudHJvcHklMjAoaGlnaCUyMGVudHJvcHklMjAlM0QlMjBsb3dlciUyMGN1dG9mZikuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGV0YV9jdXRvZmYlNjAlMjB2YWx1ZXMlMjBiZXR3ZWVuJTIwM2UtNCUyMHRvJTIwNGUtMyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBldGFfY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function NZ(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Just wanted to let you know, I&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s consider that we want short sentences, so we limit \`max_length=30\`. However, we observe that the answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tends to end abruptly.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, max_length=<span class="hljs-number">30</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span> Although

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To promote the appearance of the EOS token at the right time, we add the \`exponential_decay_length_penalty =</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (start_index, decay_factor)\`. Instead of cutting at max_tokens, the output comes to an end before and usually</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with more meaning. What happens is that starting from \`start_index\` the EOS token score will be increased</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># by \`decay_factor\` exponentially. However, if you set a high decay factor, you may also end up with abruptly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ending sequences.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.6</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network
which&lt;|endoftext|&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With a small decay factor, you will have a higher chance of getting a meaningful sequence.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.01</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span>&lt;|endoftext|&gt;`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function SZ(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwaXQlMjBjb250aW51ZXMlMjBnZW5lcmF0aW5nJTIwYWNjb3JkaW5nJTIwdG8lMjB0aGUlMjBtb2RlbCdzJTIwbG9naXRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCklMEElMEElMjMlMjBXZSUyMGNhbiUyMHVzZSUyMCU2MGZvcmNlZF9ib3NfdG9rZW5faWQlNjAlMjB0byUyMGZvcmNlJTIwdGhlJTIwc3RhcnQlMjBvZiUyMGdlbmVyYXRpb24lMjB3aXRoJTIwYW4lMjBlbmNvZGVyLWRlY29kZXIlMjBtb2RlbCUwQSUyMyUyMChpbmNsdWRpbmclMjBmb3JjaW5nJTIwaXQlMjB0byUyMGVuZCUyMHN0cmFpZ2h0JTIwYXdheSUyMHdpdGglMjBhbiUyMEVPUyUyMHRva2VuKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmVvc190b2tlbl9pZCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Translate from English to German: I love cats.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt; Ich liebe Kitty.&lt;/s&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can use \`forced_bos_token_id\` to force the start of generation with an encoder-decoder model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (including forcing it to end straight away with an EOS token)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_bos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt;&lt;/s&gt;`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function HZ(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJBJTIwc2VxdWVuY2UlM0ElMjAxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMGl0JTIwY29udGludWVzJTIwZ2VuZXJhdGluZyUyMGFjY29yZGluZyUyMHRvJTIwdGhlJTIwbW9kZWwncyUyMGxvZ2l0cyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQpJTBBJTBBJTIzJTIwJTYwZm9yY2VkX2Vvc190b2tlbl9pZCU2MCUyMGVuc3VyZXMlMjB0aGUlMjBnZW5lcmF0aW9uJTIwZW5kcyUyMHdpdGglMjBhJTIwRU9TJTIwdG9rZW4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwJTJDJTIwZm9yY2VkX2Vvc190b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`forced_eos_token_id\` ensures the generation ends with a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_eos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>,&lt;|endoftext|&gt;`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function EZ(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function qZ(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTJDJTIwMyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwdGhlJTIwc2NvcmVzJTIwYXJlJTIwbm90JTIwbm9ybWFsaXplZCUyMC0tJTIwdGhlJTIwc3VtJTIwb2YlMjB0aGVpciUyMGV4cG9uZW50aWFscyUyMGlzJTIwTk9UJTIwYSUyMG5vcm1hbGl6ZWQlMjBwcm9iYWJpbGl0eSUwQSUyMyUyMGRpc3RyaWJ1dGlvbiUyQyUyMHN1bW1pbmclMjB0byUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSklMEFwcmludCh0b3JjaC5hbGxjbG9zZSh0b3JjaC5zdW0odG9yY2guZXhwKG91dHB1dHMuc2NvcmVzJTVCLTElNUQpKSUyQyUyMHRvcmNoLlRlbnNvcigoMS4wMDAlMkMpKSUyQyUyMHJ0b2wlM0QxZS00KSklMEElMEElMjMlMjBOb3JtYWxpemluZyUyMHRoZW0lMjBtYXklMjBoYXZlJTIwYSUyMHBvc2l0aXZlJTIwaW1wYWN0JTIwb24lMjBiZWFtJTIwbWV0aG9kcyUyQyUyMG9yJTIwd2hlbiUyMHVzaW5nJTIwdGhlJTIwc2NvcmVzJTIwb24lMjB5b3VyJTIwYXBwbGljYXRpb24lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZW5vcm1hbGl6ZV9sb2dpdHMlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQodG9yY2guYWxsY2xvc2UodG9yY2guc3VtKHRvcmNoLmV4cChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEKSklMkMlMjB0b3JjaC5UZW5zb3IoKDEuMDAwJTJDKSklMkMlMjBydG9sJTNEMWUtNCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the scores are not normalized -- the sum of their exponentials is NOT a normalized probability</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># distribution, summing to 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Normalizing them may have a positive impact on beam methods, or when using the scores on your application</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, renormalize_logits=<span class="hljs-literal">True</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function DZ(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBudW1iZXIlM0ElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbGVuZ3RoJTYwJTIwdG8lMjBhJTIwdmFsdWUlMjBzbWFsbGVyJTIwdGhhbiUyMHRoZSUyMHVuY29udHJvbGxlZCUyMG91dHB1dCUyMGxlbmd0aCUyMGhhcyUyMG5vJTIwaW1wYWN0JTBBZ2VuX291dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX2xlbmd0aCUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBzZXR0aW5nJTIwYSUyMGxhcmdlciUyMCU2MG1pbl9sZW5ndGglNjAlMjB3aWxsJTIwZm9yY2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwZ2VuZXJhdGUlMjBiZXlvbmQlMjBpdHMlMjBuYXR1cmFsJTIwZW5kaW5nJTIwcG9pbnQlMkMlMjB3aGljaCUyMGlzJTIwbm90JTBBJTIzJTIwbmVjZXNzYXJpbHklMjBpbmNvcnJlY3QlMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtaW5fbGVuZ3RoJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A number:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_length\` to a value smaller than the uncontrolled output length has no impact</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting a larger \`min_length\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand, nine hundred <span class="hljs-keyword">and</span> ninety-four`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function QZ(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBudW1iZXIlM0ElMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBmb3JjZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBnZW5lcmF0ZSUyMGJleW9uZCUyMGl0cyUyMG5hdHVyYWwlMjBlbmRpbmclMjBwb2ludCUyQyUyMHdoaWNoJTIwaXMlMjBub3QlMEElMjMlMjBuZWNlc3NhcmlseSUyMGluY29ycmVjdCUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1pbl9uZXdfdG9rZW5zJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;A number:&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_new_tokens\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function YZ(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MG1pbl9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MG1pbl9wJTYwJTIwaW4lMjB0aGUlMjAwLjAxLTAuMiUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBtaW5fcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`min_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`min_p\` in the 0.01-0.2 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, min_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function PZ(j){let i,$=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){i=o("p"),i.innerHTML=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),_(i)!=="svelte-15bvr1j"&&(i.innerHTML=$)},m(y,d){p(y,i,d)},p:x,d(y){y&&n(i)}}}function AZ(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function OZ(j){let i,$=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){i=o("p"),i.innerHTML=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),_(i)!=="svelte-5zfsi9"&&(i.innerHTML=$)},m(y,d){p(y,i,d)},p:x,d(y){y&&n(i)}}}function KZ(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyMEklMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBOb3clMjBsZXQncyUyMGFkZCUyMG5ncmFtJTIwc2l6ZSUyMHVzaW5nJTIwJTYwbm9fcmVwZWF0X25ncmFtX3NpemUlNjAuJTIwVGhpcyUyMHN0b3BzJTIwdGhlJTIwcmVwZXRpdGlvbnMlMjAoJTIySSVFMiU4MCU5OW0lMjIpJTIwaW4lMjB0aGUlMjBvdXRwdXQuJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBub19yZXBlYXRfbmdyYW1fc2l6ZSUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function eC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkFsaWNlJTIwYW5kJTIwQm9iJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjBpdCUyMGNvbnRpbnVlcyUyMGdlbmVyYXRpbmclMjBhY2NvcmRpbmclMjB0byUyMHRoZSUyMG1vZGVsJ3MlMjBsb2dpdHMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXZSUyMGNhbiUyMGNvbnRyYWluJTIwaXQlMjB3aXRoJTIwJTYwcHJlZml4X2FsbG93ZWRfdG9rZW5zX2ZuJTYwJTIwdG8lMjBmb3JjZSUyMGElMjBjZXJ0YWluJTIwYmVoYXZpb3IlMjBiYXNlZCUyMG9uJTIwYSUyMHByZWZpeC4lMEElMjMlMjBGb3IlMjBpbnN0YW5jZSUyQyUyMHdlJTIwY2FuJTIwZm9yY2UlMjBhbiUyMGVudGlyZSUyMGVudGl0eSUyMHRvJTIwYmUlMjBnZW5lcmF0ZWQlMjB3aGVuJTIwaXRzJTIwYmVnaW5uaW5nJTIwaXMlMjBkZXRlY3RlZC4lMEFlbnRpdHklMjAlM0QlMjB0b2tlbml6ZXIoJTIyJTIwQm9iJTIwTWFybGV5JTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfaWRzJTVCMCU1RCUyMCUyMCUyMyUyMDMlMjB0b2tlbnMlMEFkZWYlMjBwcmVmaXhfYWxsb3dlZF90b2tlbnNfZm4oYmF0Y2hfaWQlMkMlMjBpbnB1dF9pZHMpJTNBJTBBJTIwJTIwJTIwJTIwJycnJTBBJTIwJTIwJTIwJTIwQXR0ZW1wdHMlMjB0byUyMGdlbmVyYXRlJTIwJ0JvYiUyME1hcmxleSclMjB3aGVuJTIwJ0JvYiclMjBpcyUyMGRldGVjdGVkLiUwQSUyMCUyMCUyMCUyMEluJTIwdGhpcyUyMGNhc2UlMkMlMjAlNjBiYXRjaF9pZCU2MCUyMGlzJTIwbm90JTIwdXNlZCUyQyUyMGJ1dCUyMHlvdSUyMGNhbiUyMHNldCUyMHJ1bGVzJTIwZm9yJTIwZWFjaCUyMGJhdGNoJTIwbWVtYmVyLiUwQSUyMCUyMCUyMCUyMCcnJyUwQSUyMCUyMCUyMCUyMGlmJTIwaW5wdXRfaWRzJTVCLTElNUQlMjAlM0QlM0QlMjBlbnRpdHklNUIwJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCZW50aXR5JTVCMSU1RC5pdGVtKCklNUQlMEElMjAlMjAlMjAlMjBlbGlmJTIwaW5wdXRfaWRzJTVCLTIlNUQlMjAlM0QlM0QlMjBlbnRpdHklNUIwJTVEJTIwYW5kJTIwaW5wdXRfaWRzJTVCLTElNUQlMjAlM0QlM0QlMjBlbnRpdHklNUIxJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCZW50aXR5JTVCMiU1RC5pdGVtKCklNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsaXN0KHJhbmdlKHRva2VuaXplci52b2NhYl9zaXplKSklMjAlMjAlMjMlMjBJZiUyMG5vJTIwbWF0Y2glMkMlMjBhbGxvdyUyMGFsbCUyMHRva2VucyUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENSUyQyUyMHByZWZpeF9hbGxvd2VkX3Rva2Vuc19mbiUzRHByZWZpeF9hbGxvd2VkX3Rva2Vuc19mbiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice and Bob&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob are friends

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can contrain it with \`prefix_allowed_tokens_fn\` to force a certain behavior based on a prefix.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, we can force an entire entity to be generated when its beginning is detected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>entity = tokenizer(<span class="hljs-string">&quot; Bob Marley&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids[<span class="hljs-number">0</span>]  <span class="hljs-comment"># 3 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prefix_allowed_tokens_fn</span>(<span class="hljs-params">batch_id, input_ids</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Attempts to generate &#x27;Bob Marley&#x27; when &#x27;Bob&#x27; is detected.
<span class="hljs-meta">... </span>    In this case, \`batch_id\` is not used, but you can set rules for each batch member.
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">0</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">1</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">elif</span> input_ids[-<span class="hljs-number">2</span>] == entity[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">1</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">2</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(tokenizer.vocab_size))  <span class="hljs-comment"># If no match, allow all tokens</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, prefix_allowed_tokens_fn=prefix_allowed_tokens_fn)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob Marley`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function tC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySSdtJTIwbm90JTIwZ29pbmclMjB0byUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwVGhpcyUyMHNob3dzJTIwYSUyMG5vcm1hbCUyMGdlbmVyYXRlJTIwd2l0aG91dCUyMGFueSUyMHNwZWNpZmljJTIwcGFyYW1ldGVycyUwQXN1bW1hcnlfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShzdW1tYXJ5X2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwVGhpcyUyMGdlbmVyYXRlcyUyMGElMjBwZW5hbHR5JTIwZm9yJTIwcmVwZWF0ZWQlMjB0b2tlbnMlMEFwZW5hbGl6ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShwZW5hbGl6ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function sC(j){let i,$=`In order to get the token ids of the sequences that you want to bias, make sure to set <code>add_prefix_space=True</code> when
initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The
<code>add_prefix_space</code> argument is only supported for some slow tokenizers, as fast tokenizers’ prefixing behaviours
come from <code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){i=o("p"),i.innerHTML=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),_(i)!=="svelte-16cusgy"&&(i.innerHTML=$)},m(y,d){p(y,i,d)},p:x,d(y){y&&n(i)}}}function nC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUaGUlMjBmdWxsJTIwbmFtZSUyMG9mJTIwRG9uYWxkJTIwaXMlMjBEb25hbGQlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXN1bW1hcnlfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwbWF4X25ld190b2tlbnMlM0Q0KSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoc3VtbWFyeV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyME5vdyUyMGxldCdzJTIwY29udHJvbCUyMGdlbmVyYXRpb24lMjB0aHJvdWdoJTIwYSUyMGJpYXMuJTIwUGxlYXNlJTIwbm90ZSUyMHRoYXQlMjB0aGUlMjB0b2tlbml6ZXIlMjBpcyUyMGluaXRpYWxpemVkJTIwZGlmZmVyZW50bHkhJTBBdG9rZW5pemVyX3dpdGhfcHJlZml4X3NwYWNlJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBhZGRfcHJlZml4X3NwYWNlJTNEVHJ1ZSklMEElMEElMEFkZWYlMjBnZXRfdG9rZW5zKHdvcmQpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyX3dpdGhfcHJlZml4X3NwYWNlKCU1QndvcmQlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTVCMCU1RCUwQSUwQSUwQSUyMyUyMElmJTIwd2UlMjBhZGQlMjBhJTIwbmVnYXRpdmUlMjBiaWFzJTIwd2l0aG91dCUyMGJlYW0lMjBzZWFyY2glMkMlMjBpdCUyMG1heSUyMGJlY29tZSUyMCUyMnN0dWNrJTIyJTIwaW4lMjBhJTIwcHJlZml4JTIwd2l0aG91dCUyMGdvb2QlMjBjb250aW51YXRpb25zJTBBc2VxdWVuY2VfYmlhcyUyMCUzRCUyMCU1QmdldF90b2tlbnMoJTIyVHJ1bXAlMjIpJTJDJTIwLTEwLjAlNUQlMEFiaWFzZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwbWF4X25ld190b2tlbnMlM0Q0JTJDJTIwc2VxdWVuY2VfYmlhcyUzRHNlcXVlbmNlX2JpYXMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShiaWFzZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEFiaWFzZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwbWF4X25ld190b2tlbnMlM0Q0JTJDJTIwbnVtX2JlYW1zJTNENCUyQyUyMHNlcXVlbmNlX2JpYXMlM0RzZXF1ZW5jZV9iaWFzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoYmlhc2VkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2UlMjBjYW4lMjBhbHNvJTIwYWRkJTIwYSUyMHBvc2l0aXZlJTIwYmlhcyUyMHRvJTIwbnVkZ2UlMjB0aGUlMjBtb2RlbCUyMHRvd2FyZHMlMjBzcGVjaWZpYyUyMHRva2VucyUyMG9yJTIwY29udGludWF0aW9ucyUwQXNlcXVlbmNlX2JpYXMlMjAlM0QlMjAlNUJnZXRfdG9rZW5zKCUyMkRvbmFsZCUyMER1Y2slMjIpJTJDJTIwMTAuMCU1RCUwQWJpYXNlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDQlMkMlMjBudW1fYmVhbXMlM0Q0JTJDJTIwc2VxdWVuY2VfYmlhcyUzRHNlcXVlbmNlX2JpYXMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShiaWFzZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Trump Jr

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation through a bias. Please note that the tokenizer is initialized differently!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we add a negative bias without beam search, it may become &quot;stuck&quot; in a prefix without good continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = [get_tokens(<span class="hljs-string">&quot;Trump&quot;</span>), -<span class="hljs-number">10.0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Donald,

<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Rumsfeld,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = [get_tokens(<span class="hljs-string">&quot;Donald Duck&quot;</span>), <span class="hljs-number">10.0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck.`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function aC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyMHNldCUyMGJ5JTIwZGVmYXVsdCUyMCglM0QlMjAlNjAlNUIyMjAlMkMlMjA1MDI1NiU1RCU2MCkuJTIwNTAyNTYlMjBpcyUyMHRoZSUyMEVPUyUyMHRva2VuJTJDJTIwc28lMjB0aGlzJTIwbWVhbnMlMEElMjMlMjBpdCUyMGNhbid0JTIwZ2VuZXJhdGUlMjBhbmQlMjBFT1MlMjB0b2tlbiUyMGluJTIwdGhlJTIwZmlyc3QlMjBpdGVyYXRpb24lMkMlMjBidXQlMjBpdCUyMGNhbiUyMGluJTIwdGhlJTIwb3RoZXJzLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlKSUwQXByaW50KG91dHB1dHMuc2NvcmVzJTVCMCU1RCU1QjAlMkMlMjA1MDI1NiU1RCklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEJTVCMCUyQyUyMDUwMjU2JTVEKSUyMCUyMCUyMyUyMGluJTIwb3RoZXIlMjBwbGFjZXMlMjB3ZSUyMGNhbiUyMHNlZSUyMHNvbWUlMjBwcm9iYWJpbGl0eSUyMG1hc3MlMjBmb3IlMjBFT1MlMEElMEElMjMlMjBJZiUyMHdlJTIwZGlzYWJsZSUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyQyUyMHdlJTIwY2FuJTIwZ2VuZXJhdGUlMjBFT1MlMjBpbiUyMHRoZSUyMGZpcnN0JTIwaXRlcmF0aW9uLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwYmVnaW5fc3VwcHJlc3NfdG9rZW5zJTNETm9uZSUwQSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjAlNUQlNUIwJTJDJTIwNTAyNTYlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has \`begin_suppress_tokens\` set by default (= \`[220, 50256]\`). 50256 is the EOS token, so this means</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># it can&#x27;t generate and EOS token in the first iteration, but it can in the others.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(-inf)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[-<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># in other places we can see some probability mass for EOS</span>
tensor(<span class="hljs-number">29.9010</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`begin_suppress_tokens\`, we can generate EOS in the first iteration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, begin_suppress_tokens=<span class="hljs-literal">None</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(<span class="hljs-number">11.2027</span>)`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function rC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMGElMjBsb25nJTIwbGlzdCUyMG9mJTIwc3VwcHJlc3NlZCUyMHRva2Vucy4lMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMkMlMjB0aGUlMjB0b2tlbiUyMDElMjBpcyUyMHN1cHByZXNzZWQlMjBieSUyMGRlZmF1bHQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQob3V0cHV0cy5zY29yZXMlNUIxJTVEJTVCMCUyQyUyMDElNUQpJTIwJTIwJTIzJTIwMSUyMChhbmQlMjBub3QlMjAwKSUyMGlzJTIwdGhlJTIwZmlyc3QlMjBmcmVlbHklMjBnZW5lcmF0ZWQlMjB0b2tlbiUwQSUwQSUyMyUyMElmJTIwd2UlMjBkaXNhYmxlJTIwJTYwc3VwcHJlc3NfdG9rZW5zJTYwJTJDJTIwd2UlMjBjYW4lMjBnZW5lcmF0ZSUyMGl0LiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwc3VwcHJlc3NfdG9rZW5zJTNETm9uZSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjElNUQlNUIwJTJDJTIwMSU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has a long list of suppressed tokens. For instance, in this case, the token 1 is suppressed by default.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`suppress_tokens\`, we can generate it.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, suppress_tokens=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
tensor(<span class="hljs-number">6.0678</span>)`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function oC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2dvb2dsZSUyRmdlbW1hLTItMmInJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCgnZ29vZ2xlJTJGZ2VtbWEtMi0yYicpJTBBJTBBJTIzJTIwU3ludGhJRCUyMFRleHQlMjBjb25maWd1cmF0aW9uJTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGtleXMlM0QlNUI2NTQlMkMlMjA0MDAlMkMlMjA4MzYlMkMlMjAxMjMlMkMlMjAzNDAlMkMlMjA0NDMlMkMlMjA1OTclMkMlMjAxNjAlMkMlMjA1NyU1RCUyQyUwQSUyMCUyMCUyMCUyMG5ncmFtX2xlbiUzRDUlMkMlMEEpJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMHdpdGglMjB3YXRlcm1hcmtpbmclMEF0b2tlbml6ZWRfcHJvbXB0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQW91dHB1dF9zZXF1ZW5jZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKnRva2VuaXplZF9wcm9tcHRzJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRHdhdGVybWFya2luZ19jb25maWclMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUwQSklMEF3YXRlcm1hcmtlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfc2VxdWVuY2VzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, SynthIDTextWatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># SynthID Text configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = SynthIDTextWatermarkingConfig(
<span class="hljs-meta">... </span>    keys=[<span class="hljs-number">654</span>, <span class="hljs-number">400</span>, <span class="hljs-number">836</span>, <span class="hljs-number">123</span>, <span class="hljs-number">340</span>, <span class="hljs-number">443</span>, <span class="hljs-number">597</span>, <span class="hljs-number">160</span>, <span class="hljs-number">57</span>],
<span class="hljs-meta">... </span>    ngram_len=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation with watermarking</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_prompts = tokenizer([<span class="hljs-string">&quot;Once upon a time, &quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_sequences = model.generate(
<span class="hljs-meta">... </span>    **tokenized_prompts, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">10</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarked_text = tokenizer.batch_decode(output_sequences, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function lC(j){let i,$=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){i=o("p"),i.innerHTML=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),_(i)!=="svelte-1byeoum"&&(i.innerHTML=$)},m(y,d){p(y,i,d)},p:x,d(y){y&&n(i)}}}function iC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMjAlM0QlMjBtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkh1Z2dpbmclMjBGYWNlJTIwQ29tcGFueSUyMGlzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwdGVtcGVyYXR1cmUlM0QxLjAlMkMlMjB0aGUlMjBkZWZhdWx0JTJDJTIwd2UlMjBjb25zaXN0ZW50bHklMjBnZXQlMjByYW5kb20lMjBvdXRwdXRzJTIwZHVlJTIwdG8lMjByYW5kb20lMjBzYW1wbGluZy4lMEFnZW5lcmF0ZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEwJTJDJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTIwJTIybnVtX3JldHVybl9zZXF1ZW5jZXMlMjIlM0ElMjAyJTdEJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwKipnZW5lcmF0ZV9rd2FyZ3MpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEhvd2V2ZXIlMkMlMjB3aXRoJTIwdGVtcGVyYXR1cmUlMjBjbG9zZSUyMHRvJTIwMCUyQyUyMGl0JTIwYXBwcm94aW1hdGVzJTIwZ3JlZWR5JTIwZGVjb2RpbmclMjBzdHJhdGVnaWVzJTIwKGludmFyaWFudCklMEFnZW5lcmF0ZV9rd2FyZ3MlNUIlMjJ0ZW1wZXJhdHVyZSUyMiU1RCUyMCUzRCUyMDAuMDAwMSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is one of these companies that is going to take a&#x27;</span>,
<span class="hljs-string">&quot;Hugging Face Company is a brand created by Brian A. O&#x27;Neil&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function cC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjB1bmV4cGVjdGVkJTIwLS0lMjBzb21ldGltZXMlMjB0b28lMjB1bmV4cGVjdGVkLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwJTYwdG9wX2slNjAlMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdGhlJTIwayUyMG1vc3QlMjBsaWtlbHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfayU2MCUyMGluJTIwdGhlJTIwNS01MCUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfayUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: A, B, C, D&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E — S — O, P — R

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_k\` sampling, the output gets restricted the k most likely tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_k\` in the 5-50 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E, F, G, H, I`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function dC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MHRvcF9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MHRvcF9wJTYwJTIwaW4lMjB0aGUlMjAwLjktMC45NSUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function pC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that greedy decoding produces a sequence of numbers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>, <span class="hljs-number">10</span>,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For this particular seed, we can see that sampling produces nearly the same low-information (= low entropy)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sequence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span> <span class="hljs-keyword">and</span> <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`typical_p\` set, the most obvious sequence is no longer produced, which may be good for your problem</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, do_sample=<span class="hljs-literal">True</span>, typical_p=<span class="hljs-number">0.1</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.sequences, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> <span class="hljs-keyword">and</span> <span class="hljs-number">5</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that the token corresponding to &quot;4&quot; (token 934) in the second position, the most likely token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># as seen with greedy decoding, was entirely blocked out</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">934</span>])
tensor(-inf)`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function mC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyQyUyMGElMjBkcmFnb24lMjBmbGV3JTIwb3ZlciUyMFBhcmlzJTJDJTIwRnJhbmNlJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEuNSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjB3aXRoJTIwYSUyMG5lZ2F0aXZlJTIwcHJvbXB0JTBBbmVnX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwdmVyeSUyMGhhcHB5JTIwZXZlbnQlMjBoYXBwZW5lZCUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2lkcyUzRG5lZ19pbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBwb3NpdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function gC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIzJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfZmVhdHVyZXMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfZmVhdHVyZXMlMEElMEElMjNEaXNwbGF5aW5nJTIwdGltZXN0YW1wcyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlM0RpbnB1dF9mZWF0dXJlcyUyQyUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwZGVjb2RlX3dpdGhfdGltZXN0YW1wcyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKSUwQSUwQSUwQSUyM05vJTIwdGltZXN0YW1wcyUyMCUyNiUyMGNoYW5nZSUyMEVPUyUzQSUwQSUyM1RoaXMlMjBhbGxvd3MlMjB0aGUlMjB1c2VyJTIwdG8lMjBzZWxlY3QlMjBhJTIwc3BlY2lmaWMlMjB0b2tlbiUyMHRvJTIwdGVybWluYXRlJTIwdGhlJTIwc2VxdWVuY2UlMjBvbiUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMjBpdCdzJTIwdGhlJTIwd29yZCUyMCUyMmNhbiUyMig0NjApJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZW9zX3Rva2VuX2lkJTIwJTNEJTIwNDYwJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0X2ZlYXR1cmVzJTJDcmV0dXJuX3RpbWVzdGFtcHMlM0RGYWxzZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration, GenerationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">3</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_features = inputs.input_features

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">#Displaying timestamps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, decode_with_timestamps=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription: &lt;|startoftranscript|&gt;&lt;|<span class="hljs-number">0.00</span>|&gt; He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all, and can&lt;|6.44|&gt;&lt;|6.44|&gt; discover in it but little of rocky Ithaca.&lt;|9.44|&gt;&lt;|endoftext|&gt;


&gt;&gt;&gt; #No timestamps &amp; change EOS:
&gt;&gt;&gt; #This allows the user to select a specific token to terminate the sequence on, in this case it&#x27;</span>s the word <span class="hljs-string">&quot;can&quot;</span>(<span class="hljs-number">460</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.eos_token_id = <span class="hljs-number">460</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features,return_timestamps=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription:  He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all and can</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function hC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya2luZ0NvbmZpZyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBbGljZSUyMGFuZCUyMEJvYiUyMGFyZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwbm9ybWFsJTIwZ2VuZXJhdGlvbiUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMG1heF9sZW5ndGglM0QyMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHdhdGVybWFya2VkJTIwZ2VuZXJhdGlvbiUwQXdhdGVybWFya2luZ19jb25maWclMjAlM0QlMjBXYXRlcm1hcmtpbmdDb25maWcoYmlhcyUzRDIuNSUyQyUyMGNvbnRleHRfd2lkdGglM0QyJTJDJTIwc2VlZGluZ19zY2hlbWUlM0QlMjJzZWxmaGFzaCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjB3YXRlcm1hcmtpbmdfY29uZmlnJTNEd2F0ZXJtYXJraW5nX2NvbmZpZyUyQyUyMG1heF9sZW5ndGglM0QyMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHRvJTIwZGV0ZWN0JTIwd2F0ZXJtYXJrZWQlMjB0ZXh0JTIwdXNlJTIwdGhlJTIwV2F0ZXJtYXJrRGV0ZWN0b3IlMjBjbGFzcyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBXYXRlcm1hcmtEZXRlY3RvciUwQWRldGVjdG9yJTIwJTNEJTIwV2F0ZXJtYXJrRGV0ZWN0b3IobW9kZWxfY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwZGV2aWNlJTNEJTIyY3B1JTIyJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRCUyMHdhdGVybWFya2luZ19jb25maWcpJTBBZGV0ZWN0aW9uX3ByZWRzJTIwJTNEJTIwZGV0ZWN0b3Iob3V0KSUwQWRldGVjdGlvbl9wcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob are&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># normal generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_length=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Alice and Bob are both in the same room.\\n\\n&quot;I\\&#x27;m not sure if you\\&#x27;re&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># watermarked generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, context_width=<span class="hljs-number">2</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], watermarking_config=watermarking_config, max_length=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Alice and Bob are both still alive and well and the story is pretty much a one-hour adventure&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to detect watermarked text use the WatermarkDetector class</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WatermarkDetector
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config= watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_preds = detector(out)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_preds
array([ <span class="hljs-literal">True</span>])`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function uC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBiaWdnZXN0JTIwc3RhdGVzJTIwaW4lMjB0aGUlMjBVU0ElMjBieSUyMGxhbmQlMjBhcmVhJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBQYXNzaW5nJTIwb25lJTIwb3IlMjBtb3JlJTIwc3RvcCUyMHN0cmluZ3MlMjB3aWxsJTIwaGFsdCUyMGdlbmVyYXRpb24lMjBhZnRlciUyMHRob3NlJTIwc3RyaW5ncyUyMGFyZSUyMGVtaXR0ZWQlMEElMjMlMjBOb3RlJTIwdGhhdCUyMGdlbmVyYXRpbmclMjB3aXRoJTIwc3RvcCUyMHN0cmluZ3MlMjByZXF1aXJlcyUyMHlvdSUyMHRvJTIwcGFzcyUyMHRoZSUyMHRva2VuaXplciUyMHRvbyUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHN0b3Bfc3RyaW5ncyUzRCU1QiUyMlRleGFzJTIyJTVEJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX291dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The biggest states in the USA by land area:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The biggest states <span class="hljs-keyword">in</span> the USA by land area:
- Alaska
- Texas
- California

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Passing one or more stop strings will halt generation after those strings are emitted</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that generating with stop strings requires you to pass the tokenizer too</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, stop_strings=[<span class="hljs-string">&quot;Texas&quot;</span>], tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The biggest states <span class="hljs-keyword">in</span> the USA by land area:
- Alaska
- Texas`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function fC(j){let i,$;return i=new U({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`,wrap:!1}}),{c(){m(i.$$.fragment)},l(y){g(i.$$.fragment,y)},m(y,d){h(i,y,d),$=!0},p:x,i(y){$||(u(i.$$.fragment,y),$=!0)},o(y){f(i.$$.fragment,y),$=!1},d(y){b(i,y)}}}function bC(j){let i,$="The API for the streamer classes is still under development and may change in the future.";return{c(){i=o("p"),i.textContent=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),_(i)!=="svelte-gv2g1g"&&(i.textContent=$)},m(y,d){p(y,i,d)},p:x,d(y){y&&n(i)}}}function _C(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0U3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMERlc3BpdGUlMjByZXR1cm5pbmclMjB0aGUlMjB1c3VhbCUyMG91dHB1dCUyQyUyMHRoZSUyMHN0cmVhbWVyJTIwd2lsbCUyMGFsc28lMjBwcmludCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjB0byUyMHN0ZG91dC4lMEFfJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function yC(j){let i,$="The API for the streamer classes is still under development and may change in the future.";return{c(){i=o("p"),i.textContent=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),_(i)!=="svelte-gv2g1g"&&(i.textContent=$)},m(y,d){p(y,i,d)},p:x,d(y){y&&n(i)}}}function TC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0SXRlcmF0b3JTdHJlYW1lcih0b2spJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwZ2VuZXJhdGlvbiUyMGluJTIwYSUyMHNlcGFyYXRlJTIwdGhyZWFkJTJDJTIwc28lMjB0aGF0JTIwd2UlMjBjYW4lMjBmZXRjaCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjBpbiUyMGElMjBub24tYmxvY2tpbmclMjB3YXkuJTBBZ2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjBkaWN0KGlucHV0cyUyQyUyMHN0cmVhbWVyJTNEc3RyZWFtZXIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKSUwQXRocmVhZCUyMCUzRCUyMFRocmVhZCh0YXJnZXQlM0Rtb2RlbC5nZW5lcmF0ZSUyQyUyMGt3YXJncyUzRGdlbmVyYXRpb25fa3dhcmdzKSUwQXRocmVhZC5zdGFydCgpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjAlMjIlMjIlMEFmb3IlMjBuZXdfdGV4dCUyMGluJTIwc3RyZWFtZXIlM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdGV4dCUyMCUyQiUzRCUyMG5ld190ZXh0JTBBZ2VuZXJhdGVkX3RleHQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function MC(j){let i,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMER5bmFtaWNDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBRd2VuMiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMER5bmFtaWNDYWNoZSgpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, DynamicCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
DynamicCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-11lpom8"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function vC(j){let i,$="Example:",y,d,w;return d=new U({props:{code:"JTIzJTIwUnVuJTIwcGlwJTIwaW5zdGFsbCUyMHF1YW50byUyMGZpcnN0JTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBpdCUyMHlldCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBRdWFudG9RdWFudGl6ZWRDYWNoZSUyQyUyMFF1YW50aXplZENhY2hlQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMFF3ZW4yJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBQcmVwYXJlJTIwYSUyMGNhY2hlJTIwY2xhc3MlMjBhbmQlMjBwYXNzJTIwaXQlMjB0byUyMG1vZGVsJ3MlMjBmb3J3YXJkJTBBY2FjaGVfY29uZmlnJTIwJTNEJTIwUXVhbnRpemVkQ2FjaGVDb25maWcobmJpdHMlM0Q0KSUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFF1YW50b1F1YW50aXplZENhY2hlKGNhY2hlX2NvbmZpZyUzRGNhY2hlX2NvbmZpZyklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUwQW91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run pip install quanto first if you don&#x27;t have it yet</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, QuantoQuantizedCache, QuantizedCacheConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_config = QuantizedCacheConfig(nbits=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = QuantoQuantizedCache(cache_config=cache_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
QuantoQuantizedCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-11lpom8"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function wC(j){let i,$="Example:",y,d,w;return d=new U({props:{code:"JTIzJTIwUnVuJTIwcGlwJTIwaW5zdGFsbCUyMGhxcSUyMGZpcnN0JTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBpdCUyMHlldCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBIUVFRdWFudGl6ZWRDYWNoZSUyQyUyMFF1YW50aXplZENhY2hlQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMFF3ZW4yJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBQcmVwYXJlJTIwYSUyMGNhY2hlJTIwY2xhc3MlMjBhbmQlMjBwYXNzJTIwaXQlMjB0byUyMG1vZGVsJ3MlMjBmb3J3YXJkJTBBY2FjaGVfY29uZmlnJTIwJTNEJTIwUXVhbnRpemVkQ2FjaGVDb25maWcobmJpdHMlM0Q0JTJDJTIwYXhpc19rZXklM0QxJTJDJTIwYXhpc192YWx1ZSUzRDEpJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwSFFRUXVhbnRpemVkQ2FjaGUoY2FjaGVfY29uZmlnJTNEY2FjaGVfY29uZmlnKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run pip install hqq first if you don&#x27;t have it yet</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, HQQQuantizedCache, QuantizedCacheConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_config = QuantizedCacheConfig(nbits=<span class="hljs-number">4</span>, axis_key=<span class="hljs-number">1</span>, axis_value=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = HQQQuantizedCache(cache_config=cache_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
HQQQuantizedCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-11lpom8"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function kC(j){let i,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFNpbmtDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBRd2VuMiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFNpbmtDYWNoZSh3aW5kb3dfbGVuZ3RoJTNEMjU2JTJDJTIwbnVtX3NpbmtfdG9rZW5zJTNENCklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUwQW91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SinkCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SinkCache(window_length=<span class="hljs-number">256</span>, num_sink_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
SinkCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-11lpom8"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function $C(j){let i,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFN0YXRpY0NhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBMbGFtYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQSUyMyUyMExlYXZlJTIwZW1wdHklMjBzcGFjZSUyMGZvciUyMDEwJTIwbmV3JTIwdG9rZW5zJTJDJTIwd2hpY2glMjBjYW4lMjBiZSUyMHVzZWQlMjB3aGVuJTIwY2FsbGluZyUyMGZvcndhcmQlMjBpdGVyYXRpdmVseSUyMDEwJTIwdGltZXMlMjB0byUyMGdlbmVyYXRlJTBBbWF4X2dlbmVyYXRlZF9sZW5ndGglMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzLnNoYXBlJTVCMSU1RCUyMCUyQiUyMDEwJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwU3RhdGljQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBtYXhfY2FjaGVfbGVuJTNEbWF4X2dlbmVyYXRlZF9sZW5ndGglMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, StaticCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Llama&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = StaticCache(config=model.config, batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
StaticCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-11lpom8"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function jC(j){let i,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyME9mZmxvYWRlZFN0YXRpY0NhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMEdQVDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFByZXBhcmUlMjBhJTIwY2FjaGUlMjBjbGFzcyUyMGFuZCUyMHBhc3MlMjBpdCUyMHRvJTIwbW9kZWwncyUyMGZvcndhcmQlMEElMjMlMjBMZWF2ZSUyMGVtcHR5JTIwc3BhY2UlMjBmb3IlMjAxMCUyMG5ldyUyMHRva2VucyUyQyUyMHdoaWNoJTIwY2FuJTIwYmUlMjB1c2VkJTIwd2hlbiUyMGNhbGxpbmclMjBmb3J3YXJkJTIwaXRlcmF0aXZlbHklMjAxMCUyMHRpbWVzJTIwdG8lMjBnZW5lcmF0ZSUwQW1heF9nZW5lcmF0ZWRfbGVuZ3RoJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjElNUQlMjAlMkIlMjAxMCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyME9mZmxvYWRlZFN0YXRpY0NhY2hlKGNvbmZpZyUzRG1vZGVsLmNvbmZpZyUyQyUyMG1heF9iYXRjaF9zaXplJTNEMSUyQyUyMG1heF9jYWNoZV9sZW4lM0RtYXhfZ2VuZXJhdGVkX2xlbmd0aCUyQyUyMGRldmljZSUzRG1vZGVsLmRldmljZSUyQyUyMGR0eXBlJTNEbW9kZWwuZHR5cGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFwYXN0X2t2X2xlbmd0aCUyMCUzRCUyMG91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, OffloadedStaticCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is GPT2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = OffloadedStaticCache(config=model.config, max_batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_kv_length = outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-11lpom8"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function xC(j){let i,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEh5YnJpZENhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtMi0yYiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZnZW1tYS0yLTJiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBHZW1tYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQSUyMyUyMExlYXZlJTIwZW1wdHklMjBzcGFjZSUyMGZvciUyMDEwJTIwbmV3JTIwdG9rZW5zJTJDJTIwd2hpY2glMjBjYW4lMjBiZSUyMHVzZWQlMjB3aGVuJTIwY2FsbGluZyUyMGZvcndhcmQlMjBpdGVyYXRpdmVseSUyMDEwJTIwdGltZXMlMjB0byUyMGdlbmVyYXRlJTBBbWF4X2dlbmVyYXRlZF9sZW5ndGglMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzLnNoYXBlJTVCMSU1RCUyMCUyQiUyMDEwJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwSHlicmlkQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBtYXhfY2FjaGVfbGVuJTNEbWF4X2dlbmVyYXRlZF9sZW5ndGglMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, HybridCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-2b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-2b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Gemma&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = HybridCache(config=model.config, batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
HybridCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-11lpom8"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function JC(j){let i,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFNsaWRpbmdXaW5kb3dDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItSW5zdHJ1Y3QtdjAuMyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjMlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyME1pc3RyYWwlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFByZXBhcmUlMjBhJTIwY2FjaGUlMjBjbGFzcyUyMGFuZCUyMHBhc3MlMjBpdCUyMHRvJTIwbW9kZWwncyUyMGZvcndhcmQlMEElMjMlMjBMZWF2ZSUyMGVtcHR5JTIwc3BhY2UlMjBmb3IlMjAxMCUyMG5ldyUyMHRva2VucyUyQyUyMHdoaWNoJTIwY2FuJTIwYmUlMjB1c2VkJTIwd2hlbiUyMGNhbGxpbmclMjBmb3J3YXJkJTIwaXRlcmF0aXZlbHklMjAxMCUyMHRpbWVzJTIwdG8lMjBnZW5lcmF0ZSUwQW1heF9nZW5lcmF0ZWRfbGVuZ3RoJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjElNUQlMjAlMkIlMjAxMCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFNsaWRpbmdXaW5kb3dDYWNoZShjb25maWclM0Rtb2RlbC5jb25maWclMkMlMjBiYXRjaF9zaXplJTNEMSUyQyUyMG1heF9jYWNoZV9sZW4lM0RtYXhfZ2VuZXJhdGVkX2xlbmd0aCUyQyUyMGRldmljZSUzRG1vZGVsLmRldmljZSUyQyUyMGR0eXBlJTNEbW9kZWwuZHR5cGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SlidingWindowCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.3&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.3&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Mistral&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SlidingWindowCache(config=model.config, batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
SlidingWindowCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-11lpom8"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function UC(j){let i,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMER5bmFtaWNDYWNoZSUyQyUyMEVuY29kZXJEZWNvZGVyQ2FjaGUlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRndoaXNwZXItc21hbGwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGF1ZGlvJTNEWU9VUi1BVURJTyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGNhY2hlJTIwY2xhc3NlcyUyMGZvciUyMGVuY29kZXIlMjBhbmQlMjBkZWNvZGVyJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXNlbGZfYXR0ZW50aW9uX2NhY2hlJTIwJTNEJTIwRHluYW1pY0NhY2hlKCklMEFjcm9zc19hdHRlbnRpb25fY2FjaGUlMjAlM0QlMjBEeW5hbWljQ2FjaGUoKSUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMEVuY29kZXJEZWNvZGVyQ2FjaGUoc2VsZl9hdHRlbnRpb25fY2FjaGUlMkMlMjBjcm9zc19hdHRlbnRpb25fY2FjaGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForCausalLM, DynamicCache, EncoderDecoderCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(audio=YOUR-AUDIO, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare cache classes for encoder and decoder and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>self_attention_cache = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>cross_attention_cache = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = EncoderDecoderCache(self_attention_cache, cross_attention_cache)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
EncoderDecoderCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-11lpom8"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function ZC(j){let i,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNYW1iYUZvckNhdXNhbExNJTJDJTIwTWFtYmFDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwTWFtYmFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhdGUtc3BhY2VzJTJGbWFtYmEtMTMwbS1oZiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdGF0ZS1zcGFjZXMlMkZtYW1iYS0xMzBtLWhmJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBNYW1iYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyME1hbWJhQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MambaForCausalLM, MambaCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MambaForCausalLM.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Mamba&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = MambaCache(config=model.config, batch_size=<span class="hljs-number">1</span>, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values
MambaCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-11lpom8"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function CC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya0RldGVjdG9yJTJDJTIwV2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRvay5wYWRfdG9rZW5faWQlMjAlM0QlMjB0b2suZW9zX3Rva2VuX2lkJTBBdG9rLnBhZGRpbmdfc2lkZSUyMCUzRCUyMCUyMmxlZnQlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyVGhpcyUyMGlzJTIwdGhlJTIwYmVnaW5uaW5nJTIwb2YlMjBhJTIwbG9uZyUyMHN0b3J5JTIyJTJDJTIwJTIyQWxpY2UlMjBhbmQlMjBCb2IlMjBhcmUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfbGVuJTIwJTNEJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCLTElNUQlMEElMEElMjMlMjBmaXJzdCUyMGdlbmVyYXRlJTIwdGV4dCUyMHdpdGglMjB3YXRlcm1hcmslMjBhbmQlMjB3aXRob3V0JTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFdhdGVybWFya2luZ0NvbmZpZyhiaWFzJTNEMi41JTJDJTIwc2VlZGluZ19zY2hlbWUlM0QlMjJzZWxmaGFzaCUyMiklMEFvdXRfd2F0ZXJtYXJrZWQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHdhdGVybWFya2luZ19jb25maWclM0R3YXRlcm1hcmtpbmdfY29uZmlnJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbGVuZ3RoJTNEMjApJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9sZW5ndGglM0QyMCklMEElMEElMjMlMjBub3clMjB3ZSUyMGNhbiUyMGluc3RhbnRpYXRlJTIwdGhlJTIwZGV0ZWN0b3IlMjBhbmQlMjBjaGVjayUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMEFkZXRlY3RvciUyMCUzRCUyMFdhdGVybWFya0RldGVjdG9yKG1vZGVsX2NvbmZpZyUzRG1vZGVsLmNvbmZpZyUyQyUyMGRldmljZSUzRCUyMmNwdSUyMiUyQyUyMHdhdGVybWFya2luZ19jb25maWclM0R3YXRlcm1hcmtpbmdfY29uZmlnKSUwQWRldGVjdGlvbl9vdXRfd2F0ZXJtYXJrZWQlMjAlM0QlMjBkZXRlY3RvcihvdXRfd2F0ZXJtYXJrZWQlMkMlMjByZXR1cm5fZGljdCUzRFRydWUpJTBBZGV0ZWN0aW9uX291dCUyMCUzRCUyMGRldGVjdG9yKG91dCUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSklMEFkZXRlY3Rpb25fb3V0X3dhdGVybWFya2VkLnByZWRpY3Rpb24lMEElMEFkZXRlY3Rpb25fb3V0LnByZWRpY3Rpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkDetector, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.pad_token_id = tok.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.padding_side = <span class="hljs-string">&quot;left&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;This is the beginning of a long story&quot;</span>, <span class="hljs-string">&quot;Alice and Bob are&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_len = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># first generate text with watermark and without</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out_watermarked = model.generate(**inputs, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now we can instantiate the detector and check the generated text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config=watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out_watermarked = detector(out_watermarked, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out = detector(out, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out_watermarked.prediction
array([ <span class="hljs-literal">True</span>,  <span class="hljs-literal">True</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out.prediction
array([<span class="hljs-literal">False</span>,  <span class="hljs-literal">False</span>])`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function WC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2dvb2dsZSUyRmdlbW1hLTItMmInJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCgnZ29vZ2xlJTJGZ2VtbWEtMi0yYicpJTBBJTBBJTIzJTIwU3ludGhJRCUyMFRleHQlMjBjb25maWd1cmF0aW9uJTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGtleXMlM0QlNUI2NTQlMkMlMjA0MDAlMkMlMjA4MzYlMkMlMjAxMjMlMkMlMjAzNDAlMkMlMjA0NDMlMkMlMjA1OTclMkMlMjAxNjAlMkMlMjA1NyU1RCUyQyUwQSUyMCUyMCUyMCUyMG5ncmFtX2xlbiUzRDUlMkMlMEEpJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMHdpdGglMjB3YXRlcm1hcmtpbmclMEF0b2tlbml6ZWRfcHJvbXB0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQW91dHB1dF9zZXF1ZW5jZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKnRva2VuaXplZF9wcm9tcHRzJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRHdhdGVybWFya2luZ19jb25maWclMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUwQSklMEF3YXRlcm1hcmtlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfc2VxdWVuY2VzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, SynthIDTextWatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># SynthID Text configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = SynthIDTextWatermarkingConfig(
<span class="hljs-meta">... </span>    keys=[<span class="hljs-number">654</span>, <span class="hljs-number">400</span>, <span class="hljs-number">836</span>, <span class="hljs-number">123</span>, <span class="hljs-number">340</span>, <span class="hljs-number">443</span>, <span class="hljs-number">597</span>, <span class="hljs-number">160</span>, <span class="hljs-number">57</span>],
<span class="hljs-meta">... </span>    ngram_len=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation with watermarking</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_prompts = tokenizer([<span class="hljs-string">&quot;Once upon a time, &quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_sequences = model.generate(
<span class="hljs-meta">... </span>    **tokenized_prompts, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">10</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarked_text = tokenizer.batch_decode(output_sequences, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function BC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBBdXRvVG9rZW5pemVyJTJDJTIwQmF5ZXNpYW5EZXRlY3Rvck1vZGVsJTJDJTIwU3ludGhJRFRleHRXYXRlcm1hcmtMb2dpdHNQcm9jZXNzb3IlMkMlMjBTeW50aElEVGV4dFdhdGVybWFya0RldGVjdG9yJTBBKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBkZXRlY3Rvci4lMjBTZWUlMjBleGFtcGxlcyUyRnJlc2VhcmNoX3Byb2plY3RzJTJGc3ludGhpZF90ZXh0JTIwZm9yJTIwdHJhaW5pbmclMjBhJTIwZGV0ZWN0b3IuJTBBZGV0ZWN0b3JfbW9kZWwlMjAlM0QlMjBCYXllc2lhbkRldGVjdG9yTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmpvYW9nYW50ZSUyRmR1bW15X3N5bnRoaWRfZGV0ZWN0b3IlMjIpJTBBbG9naXRzX3Byb2Nlc3NvciUyMCUzRCUyMFN5bnRoSURUZXh0V2F0ZXJtYXJrTG9naXRzUHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCoqZGV0ZWN0b3JfbW9kZWwuY29uZmlnLndhdGVybWFya2luZ19jb25maWclMkMlMjBkZXZpY2UlM0QlMjJjcHUlMjIlMEEpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoZGV0ZWN0b3JfbW9kZWwuY29uZmlnLm1vZGVsX25hbWUpJTBBZGV0ZWN0b3IlMjAlM0QlMjBTeW50aElEVGV4dFdhdGVybWFya0RldGVjdG9yKGRldGVjdG9yX21vZGVsJTJDJTIwbG9naXRzX3Byb2Nlc3NvciUyQyUyMHRva2VuaXplciklMEElMEElMjMlMjBUZXN0JTIwd2hldGhlciUyMGElMjBjZXJ0YWluJTIwc3RyaW5nJTIwaXMlMjB3YXRlcm1hcmtlZCUwQXRlc3RfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjBpbnB1dCUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaXNfd2F0ZXJtYXJrZWQlMjAlM0QlMjBkZXRlY3Rvcih0ZXN0X2lucHV0LmlucHV0X2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer, BayesianDetectorModel, SynthIDTextWatermarkLogitsProcessor, SynthIDTextWatermarkDetector
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the detector. See examples/research_projects/synthid_text for training a detector.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector_model = BayesianDetectorModel.from_pretrained(<span class="hljs-string">&quot;joaogante/dummy_synthid_detector&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = SynthIDTextWatermarkLogitsProcessor(
<span class="hljs-meta">... </span>    **detector_model.config.watermarking_config, device=<span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(detector_model.config.model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = SynthIDTextWatermarkDetector(detector_model, logits_processor, tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Test whether a certain string is watermarked</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>test_input = tokenizer([<span class="hljs-string">&quot;This is a test input&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>is_watermarked = detector(test_input.input_ids)`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function IC(j){let i,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMENvbXBpbGVDb25maWclMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCgnZ29vZ2xlJTJGZ2VtbWEtMi0yYicpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJ2dvb2dsZSUyRmdlbW1hLTItMmInKS5jdWRhKCklMEElMEElMjMlMjBBdXRvbWF0aWMlMjBjb21waWxlJTIwY29uZmlndXJhdGlvbiUyQyUyMHVzZWQlMjB3aXRoJTIwc3RhdGljJTIwY2FjaGUlMEFjb21waWxlX2NvbmZpZyUyMCUzRCUyMENvbXBpbGVDb25maWcoZHluYW1pYyUzRFRydWUpJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMHdpdGglMjBzdGF0aWMlMjBjYWNoZSUyMGFuZCUyMGNvbXBpbGUlMjBjb25maWclMEFpbnB1dCUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUoJTIySGVsbG8lMjB0aGVyZSUyQyUyMGhvdyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmN1ZGEoKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMGlucHV0JTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDMwMCUyQyUyMGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyc3RhdGljJTIyJTJDJTIwY29tcGlsZV9jb25maWclM0Rjb21waWxlX2NvbmZpZyUwQSklMEFvdXRwdXRfdGV4dCUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, CompileConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>).cuda()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Automatic compile configuration, used with static cache</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compile_config = CompileConfig(dynamic=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation with static cache and compile config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">input</span> = tokenizer.encode(<span class="hljs-string">&quot;Hello there, how&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).cuda()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">input</span>, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">300</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>, compile_config=compile_config
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_text = tokenizer.batch_decode(output, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=o("p"),i.textContent=$,y=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(y)),b(d,s)}}}function zC(j){let i,$,y,d,w,s,k,K$='This page lists all the utility functions used by <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>.',Ef,La,qf,Na,ej=`The output of <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is an instance of a subclass of
<a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. This output is a data structure containing all the information returned
by <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, but that can also be used as tuple or dictionary.`,Df,Sa,tj="Here’s an example:",Qf,Ha,Yf,Ea,sj=`The <code>generation_output</code> object is a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput">GenerateDecoderOnlyOutput</a>, as we can
see in the documentation of that class below, it means it has the following attributes:`,Pf,qa,nj="<li><code>sequences</code>: the generated sequences of tokens</li> <li><code>scores</code> (optional): the prediction scores of the language modelling head, for each generation step</li> <li><code>hidden_states</code> (optional): the hidden states of the model, for each generation step</li> <li><code>attentions</code> (optional): the attention weights of the model, for each generation step</li>",Af,Da,aj=`Here we have the <code>scores</code> since we passed along <code>output_scores=True</code>, but we don’t have <code>hidden_states</code> and
<code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or <code>output_attentions=True</code>.`,Of,Qa,rj=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>generation_output.scores</code> are all the generated prediction scores of the
language modeling head, and <code>generation_output.attentions</code> is <code>None</code>.`,Kf,Ya,oj=`When using our <code>generation_output</code> object as a tuple, it only keeps the attributes that don’t have <code>None</code> values.
Here, for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,eb,Pa,tb,Aa,lj="will return the tuple <code>(generation_output.sequences, generation_output.scores)</code> for instance.",sb,Oa,ij=`When using our <code>generation_output</code> object as a dictionary, it only keeps the attributes that don’t have <code>None</code>
values. Here, for instance, it has two keys that are <code>sequences</code> and <code>scores</code>.`,nb,Ka,cj="We document here all output types.",ab,er,rb,gs,tr,kT,id,dj="Outputs of decoder-only generation models, when using non-beam methods.",ob,hs,sr,$T,cd,pj="Outputs of encoder-decoder generation models, when using non-beam methods.",lb,us,nr,jT,dd,mj="Outputs of decoder-only generation models, when using beam methods.",ib,fs,ar,xT,pd,gj="Outputs of encoder-decoder generation models, when using beam methods.",cb,rr,db,bs,or,JT,md,hj=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,pb,_s,lr,UT,gd,uj="Base class for outputs of decoder-only generation models using greedy search.",mb,ys,ir,ZT,hd,fj=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,gb,Ts,cr,CT,ud,bj="Base class for outputs of decoder-only generation models using sampling.",hb,Ms,dr,WT,fd,_j=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,ub,vs,pr,BT,bd,yj="Base class for outputs of decoder-only generation models using beam search.",fb,ws,mr,IT,_d,Tj=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,bb,ks,gr,zT,yd,Mj="Base class for outputs of decoder-only generation models using beam sample.",_b,$s,hr,VT,Td,vj=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,yb,js,ur,GT,Md,wj="Base class for outputs of decoder-only generation models using contrastive search.",Tb,fr,Mb,tt,br,FT,vd,kj="Flax Base class for outputs of decoder-only generation models using sampling.",XT,zs,_r,RT,wd,$j="“Returns a new object replacing the specified fields with new values.",vb,st,yr,LT,kd,jj="Flax Base class for outputs of decoder-only generation models using greedy search.",NT,Vs,Tr,ST,$d,xj="“Returns a new object replacing the specified fields with new values.",wb,nt,Mr,HT,jd,Jj="Flax Base class for outputs of decoder-only generation models using greedy search.",ET,Gs,vr,qT,xd,Uj="“Returns a new object replacing the specified fields with new values.",kb,wr,$b,kr,Zj=`A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> can be used to modify the prediction scores of a language model head for
generation.`,jb,$r,xb,ke,jr,DT,Jd,Cj='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of Bark.',QT,Fs,YT,Ud,xr,Jb,N,Jr,PT,Zd,Wj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,AT,Cd,Bj='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',OT,Xs,KT,Rs,eM,Wd,Ur,Ub,ne,Zr,tM,Bd,Ij=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.NoRepeatNGramLogitsProcessor">NoRepeatNGramLogitsProcessor</a>, but applied exclusively to prevent
the repetition of n-grams present in the prompt.`,sM,Id,zj=`It was designed to promote chattiness in a language model, by preventing the generation of n-grams present in
previous conversation rounds.`,nM,Ls,aM,zd,Cr,Zb,ae,Wr,rM,Vd,Vj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.RepetitionPenaltyLogitsProcessor">RepetitionPenaltyLogitsProcessor</a>, but with an <em>inverse</em> penalty
that is applied to the tokens present in the prompt. In other words, a penalty above 1.0 increases the odds of
selecting tokens that were present in the prompt.`,oM,Gd,Gj=`It was designed to avoid hallucination in input-grounded tasks, like summarization. Although originally intended
for encoder-decoder models, it can also be used with decoder-only models like LLMs.`,lM,Ns,iM,Fd,Br,Cb,$e,Ir,cM,Xd,Fj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,dM,Ss,pM,Rd,zr,Wb,je,Vr,mM,Ld,Xj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsProcessor</code> to work.`,gM,Hs,hM,Nd,Gr,Bb,xe,Fr,uM,Sd,Rj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the <code>eos_token_id</code> after <code>start_index</code> has been
reached. This allows generating shorter sequences without having a hard cutoff, allowing the <code>eos_token</code> to be
predicted in a meaningful position.`,fM,Es,bM,Hd,Xr,Ib,Je,Rr,_M,Ed,Lj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token. Used with encoder-decoder
models.`,yM,qs,TM,qd,Lr,zb,Ue,Nr,MM,Dd,Nj='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',vM,Ds,wM,Qd,Sr,Vb,S,Hr,kM,Yd,Sj='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',$M,Pd,Hj=`Note that this logits processor is only effective for <code>PreTrainedModel.group_beam_search</code>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,jM,Ad,Ej=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,xM,Qs,JM,Od,Er,Gb,Ze,qr,UM,Kd,qj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,ZM,ep,Dj=`This logits processor has no <code>generate</code> example, as there shouldn’t be a correct combination of flags that warrants
its use.`,CM,tp,Dr,Fb,Ce,Qr,WM,sp,Qj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,BM,Ys,IM,np,Yr,Xb,at,Pr,zM,ap,Yj="Abstract base class for all logit processors that can be applied during generation.",VM,rp,Ar,Rb,rt,Or,GM,op,Pj=`This class can be used to create a list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> to the
inputs.`,FM,lp,Kr,Lb,We,eo,XM,ip,Aj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0. Note that, for decoder-only models
like most LLMs, the length includes the prompt.`,RM,Ps,LM,cp,to,Nb,Be,so,NM,dp,Oj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Contrarily to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.MinLengthLogitsProcessor">MinLengthLogitsProcessor</a>, this processor ignores the prompt.`,SM,As,HM,pp,no,Sb,H,ao,EM,mp,Kj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs min-p, i.e. keeps all tokens that are above a minimum probability, scaled by the
probability of the most likely token. As a result, the filter becomes more agressive in the presence of
high-probability tokens, which is a sign of a confident output that we shouldn’t deviate from.`,qM,gp,e0=`Often used together with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a>. Used as an alternative to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,DM,hp,t0='Created by @menhguin and @kalomaze (github handles). Code adapted from <a href="https://github.com/oobabooga/text-generation-webui/pull/4449/files" rel="nofollow">this external PR</a>',QM,Os,YM,up,ro,Hb,re,oo,PM,fp,s0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',AM,Ks,OM,en,KM,bp,lo,Eb,oe,io,ev,_p,n0=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores. Note that, for decoder-only models like most LLMs, the
prompt is also considered to obtain the n-grams.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,tv,tn,sv,sn,nv,yp,co,qb,Ie,po,av,Tp,a0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,rv,nn,ov,Mp,mo,Db,le,go,lv,vp,r0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through a penalty. This penalty is applied at
most once per token. Note that, for decoder-only models like most LLMs, the considered tokens include the prompt.`,iv,wp,o0=`In the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>, the authors suggest the use of a penalty of around
1.2 to achieve a good balance between truthful generation and lack of repetition. To penalize and reduce
repetition, use <code>penalty</code> values above 1.0, where a higher value penalizes more strongly. To reward and encourage
repetition, use <code>penalty</code> values between 0.0 and 1.0, where a lower value rewards more strongly.`,cv,an,dv,kp,ho,Qb,ie,uo,pv,$p,l0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,mv,rn,gv,on,hv,jp,fo,Yb,ze,bo,uv,xp,i0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> supresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are
not generated at the beginning. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,fv,ln,bv,Jp,_o,Pb,Ve,yo,_v,Up,c0=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so
that they are not generated. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,yv,cn,Tv,Zp,To,Ab,G,Mo,Mv,Cp,d0=`Logits processor that implements watermarking techniques for text generation models.
This class facilitates the application of SynthID text watermarking, a method for embedding imperceptible signals
into generated text to aid in detecting synthetic content. It operates by subtly manipulating the probabilities of
token selection during text generation in a manner that can be reliably recovered later for verification.`,vv,Wp,p0="Key Features:",wv,Bp,m0=`<li><p><strong>State Management:</strong> Maintains internal state to track token sequences and generate watermarking keys
dynamically.</p></li> <li><p><strong>Key Generation:</strong> Computes hashes based on token sequences and watermarking parameters to create unique keys
for each position.</p></li> <li><p><strong>G-Value Sampling:</strong> Employs a pre-computed sampling table to sample watermarking values (g-values) based on
the generated keys.</p></li> <li><p><strong>Score Adjustment:</strong> Applies calculated g-values to modify token probabilities during generation, embedding the
watermark.</p></li> <li><p><strong>Context Repetition Handling:</strong> Incorporates logic to avoid watermarking tokens in repeated contexts,
preserving naturalness.</p></li> <li><p><strong>EOS Token Masking:</strong> Supports masking end-of-sentence tokens to prevent their inclusion in watermarking
calculations.</p></li> <li><p><strong>Utility Functions:</strong> Provides functions to compute g-values directly, check for context repetition, create
EOS token masks, and estimate expected mean g-values.</p></li>`,kv,Ip,g0='Refer to paper url: <a href="https://www.nature.com/articles/s41586-024-08025-4" rel="nofollow">https://www.nature.com/articles/s41586-024-08025-4</a> for more details around this.',$v,dn,jv,zp,vo,Ob,ce,wo,xv,Vp,h0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens. Often used together with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,Jv,pn,Uv,mn,Zv,Gp,ko,Kb,Ge,$o,Cv,Fp,u0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs top-k, i.e. restricting to the k highest probability elements. Often used
together with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a>.`,Wv,gn,Bv,Xp,jo,e_,Fe,xo,Iv,Rp,f0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.
Often used together with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,zv,hn,Vv,Lp,Jo,t_,de,Uo,Gv,Np,b0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs typical decoding. Inspired on how humans use language, it prioritizes tokens
whose log probability is close to the entropy of the token probability distribution. This means that the most
likely tokens may be discarded in the process.`,Fv,Sp,_0='See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information.',Xv,un,Rv,Hp,Zo,s_,pe,Co,Lv,Ep,y0=`Logits processor for Classifier-Free Guidance (CFG). The processors computes a weighted average across scores
from prompt conditional and prompt unconditional (or negative) logits, parameterized by the <code>guidance_scale</code>.
The unconditional scores are computed internally by prompting <code>model</code> with the <code>unconditional_ids</code> branch.`,Nv,qp,T0='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',Sv,fn,Hv,Dp,Wo,n_,me,Bo,Ev,Qp,M0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that modifies the logits for the generation of timestamps in the transcription. When the input
tokens are at a specific threshold, the processor sets the scores to negative infinity. The processor makes sure
that timestamp tokens appear in pairs, by masking out the logits that would break this pairing pattern. This is
done to maintain the consistency and structure of generated timestamps. It also ensures that when the predicted
probability of sampling any of the timestamp token is greater than any individual non-timestamp token, those
non-timestamp logits are set to negative infinity. This is done to ensure the generation of timestamps over other
potential tokens.`,qv,Yp,v0='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',Dv,bn,Qv,Pp,Io,a_,E,zo,Yv,Ap,w0=`Logits processor for watermarking generated text. The processor modifies model output scores by adding a small bias to
randomized set of “green” tokens before generating the next token. “Green” tokens selection process depends on the
<code>seeding_scheme</code> used. The code was based on the <a href="https://github.com/jwkirchenbauer/lm-watermarking/tree/main" rel="nofollow">original repo</a>.`,Pv,Op,k0='The text generated by this <code>LogitsProcessor</code> can be detected using <code>WatermarkDetector</code>. See <a href="/docs/transformers/main/en/internal/generation_utils#transformers.WatermarkDetector.__call__"><strong>call</strong>()</a> for details,',Av,Kp,$0='See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">the paper</a> for more information.',Ov,_n,Kv,em,Vo,r_,Go,o_,ot,Fo,ew,tm,j0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',tw,sm,Xo,l_,lt,Ro,sw,nm,x0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',nw,am,Lo,i_,it,No,aw,rm,J0=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,rw,om,So,c_,ct,Ho,ow,lm,U0="Abstract base class for all logit processors that can be applied during generation.",lw,yn,Eo,iw,im,Z0="TF method for processing logits.",d_,dt,qo,cw,cm,C0=`This class can be used to create a list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,dw,dm,Do,p_,pt,Qo,pw,pm,W0="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",mw,Tn,Yo,gw,mm,B0="TF method for warping logits.",m_,mt,Po,hw,gm,I0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',uw,hm,Ao,g_,gt,Oo,fw,um,z0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',bw,fm,Ko,h_,ht,el,_w,bm,V0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,yw,_m,tl,u_,ut,sl,Tw,ym,G0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',Mw,Tm,nl,f_,ft,al,vw,Mm,F0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the beginning of the generation.`,ww,vm,rl,b_,bt,ol,kw,wm,X0=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,$w,km,ll,__,_t,il,jw,$m,R0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',xw,jm,cl,y_,yt,dl,Jw,xm,L0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',Uw,Jm,pl,T_,Tt,ml,Zw,Um,N0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',Cw,Zm,gl,M_,hl,v_,Mt,ul,Ww,Cm,S0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',Bw,Wm,fl,w_,vt,bl,Iw,Bm,H0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',zw,Im,_l,k_,wt,yl,Vw,zm,E0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,Gw,Vm,Tl,$_,kt,Ml,Fw,Gm,q0="Abstract base class for all logit processors that can be applied during generation.",Xw,Mn,vl,Rw,Fm,D0="Flax method for processing logits.",j_,$t,wl,Lw,Xm,Q0=`This class can be used to create a list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,Nw,Rm,kl,x_,jt,$l,Sw,Lm,Y0="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Hw,vn,jl,Ew,Nm,P0="Flax method for warping logits.",J_,xt,xl,qw,Sm,A0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',Dw,Hm,Jl,U_,Jt,Ul,Qw,Em,O0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> supressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
beginning of the generation.`,Yw,qm,Zl,Z_,Ut,Cl,Pw,Dm,K0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,Aw,Qm,Wl,C_,Zt,Bl,Ow,Ym,ex='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',Kw,Pm,Il,W_,Ct,zl,e2,Am,tx='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',t2,Om,Vl,B_,Wt,Gl,s2,Km,sx='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',n2,eg,Fl,I_,Bt,Xl,a2,tg,nx=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,r2,sg,Rl,z_,Ll,V_,Nl,ax='A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> can be used to change when to stop generation (other than EOS token). Please note that this is exclusively available to our PyTorch implementations.',G_,Xe,Sl,o2,ng,rx="Abstract base class for all stopping criteria that can be applied during generation.",l2,ag,ox="If your stopping criteria depends on the <code>scores</code> input, make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.",i2,rg,Hl,F_,xs,El,c2,og,ql,X_,It,Dl,d2,lg,lx=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,p2,ig,Ql,R_,zt,Yl,m2,cg,ix=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,g2,dg,Pl,L_,J,Al,h2,pg,cx=`This class can be used to stop generation whenever specific string sequences are generated. It preprocesses
the strings together with the tokenizer vocab to find positions where tokens can validly complete the stop strings.`,u2,mg,dx=`Generation is stopped as soon as a token is generated that completes any of the stop strings.
We want to catch any instance in which the stop string would be present in the decoded output, which means
we must also catch cases with “overhangs” off one or both ends. To make this more concrete, for the stop string
“stop”, any of the following token sequences would trigger the match:`,f2,gg,px="<li>[“st”, “op”]</li> <li>[“stop”]</li> <li>[“st”, “opera”]</li> <li>[“sto”, “pper”]</li> <li>[“las”, “topper”]</li> <li>[“s”, “to”, “pped”]</li>",b2,hg,mx=`Note that a match will only be triggered if the stop string is at the end of the generated sequence. In other
words, these sequences will not trigger a match:`,_2,ug,gx="<li>[“stop”, “at”]</li> <li>[“st”, “op”, “at”]</li> <li>[“st”, “opera”, “tion”]</li>",y2,fg,hx=`The reason these are not a match is that the stop string does not overlap with the final token. If you can remove
one or more tokens from the end of the sequence without destroying the stop string, then this criterion will not
match that stop string. This is by design; because this check is run after each token is generated, we can’t miss a
valid stop string if one is generated, but we don’t want to halt generation just because the stop string exists
somewhere in the past input_ids.`,T2,bg,ux=`How is the match actually performed, though? We do it in quite a confusing way, because we want the entire match
process to be compilable with Torch or XLA, which means we cannot use standard string methods. However, it is possible,
with some work, to do string matching with pure tensor operations. We’ll begin by describing the algorithm we use
with standard string operations, and then at the end we’ll explain how this is converted to pure tensor operations.`,M2,_g,fx=`The key to the algorithm is an observation: Because the stop string must overlap with the end of the token sequence, we can start at
the end of the sequence and work backwards. Specifically, we check that there is an overlap between the start of
the final token and the end of the stop_string, or to put it another way, stop_string[-i:] == token[:i] for
some i > 0. If you look at the positive examples above, you’ll see the last token in all of them fulfills this
property:`,v2,yg,bx="<li>[“st”, “op”] (overlap is “op”, overlap length == 2)</li> <li>[“stop”]  (overlap is “stop”, overlap length == 4)</li> <li>[“st”, “opera”]  (overlap is “op”, overlap length == 2)</li> <li>[“sto”, “pper”]  (overlap is “p”, overlap length == 1)</li> <li>[“las”, “topper”]  (overlap is “top”, overlap length == 3)</li> <li>[“s”, “to”, “pped”]  (overlap is “p”, overlap length == 1)</li>",w2,Tg,_x=`It’s impossible to construct a matching sequence that does not have this property (feel free to verify this
yourself). However, although this overlap between the start of the final token and the end of the stop string is
necessary for a match, it is not sufficient. We also need to check that the rest of the token sequence is
consistent with the stop string.`,k2,Mg,yx=`How do we do that? Let’s use [“s”, “to”, “pped”] as an example. We know that the final token, “pped”, has an
overlap of 1 with the stop string, “stop”. We then go back to the previous token, “to”. Since we have already
matched 1 character from the stop string, the remainder to check is “sto”. We check that the next token “to”
matches the end of the remainder, which it does. We have now matched 3 characters from the stop string, and the
remainder to match is “s”. We go back to the previous token again, which is also “s”. This is a match, and so
we have matched the entire stop string.`,$2,vg,Tx=`How does it work when the tokens run off the start of the stop string, though? Let’s consider the example of
[“las”, “topper”]. The final token, “topper”, has an overlap of 3 with the stop string, “stop”. Therefore,
the remaining stop string to match is “s”. We go back to the previous token, “las”. Because the remainder to
match is just “s”, with length 1, we consider only the final 1 character from the token, which is “s”. This
matches the stop string, and so the entire string is matched.`,j2,wg,Mx=`How do we compute these matches with tensor operations, though? Simply: we efficiently precompute the necessary
information for all tokens! For every token, we compute:`,x2,kg,vx="<li>Its overlap with the end of the stop string, if any</li> <li>The positions inside the stop string where the token matches, including matches that run off the start.</li> <li>The total length of the token</li>",J2,$g,wx=`For example, for the token “pped”, we would compute an end overlap of 1, no internal matching positions,
and a length of 4. For the token “to”, we would compute no end overlap, a single internal matching position
of 1 (counting from the end), and a length of 2. For the token “s”, we would compute no end overlap,
a single internal matching position of 3 (again counting from the end) and a length of 1.`,U2,jg,kx=`As long as we have this information, we can execute the algorithm above without any string comparison
operations. We simply perform the following steps:`,Z2,xg,$x="<li>Check if the final token has an end-overlap with the start string</li> <li>Continue backwards, keeping track of how much of the stop string we’ve matched so far</li> <li>At each point, check if the next token has the current position as one of its valid positions</li> <li>Continue until either a match fails, or we completely match the whole stop string</li>",C2,Jg,jx=`Again, consider [“s”, “to”, “pped”] as an example. “pped” has an end overlap of 1, so we can begin a match.
We have matched 1 character so far, so we check that the next token “to”, has 1 as a valid position (again,
counting from the end). It does, so we add the length of “to” to our position tracker. We have now matched
3 characters, so we check that the next token “s” has 3 as a valid position. It does, so we add its length
to the position tracker. The position tracker is now 4, which is the length of the stop string. We have matched the
entire stop string.`,W2,Ug,xx=`In the second case, [“las”, “topper”], “topper” has an end overlap of 3, so we can begin a match. We have
matched 3 characters so far, so we check that the next token “las” has 3 as a valid position. It does, because we
allow tokens to match positions that run off the start of the stop string. We add its length to the position
tracker. The position tracker is now 6, which is greater than the length of the stop string! Don’t panic, though -
this also counts as a match of the stop string. We have matched the entire stop string.`,B2,wn,I2,Zg,Ol,N_,Vt,Kl,z2,Cg,Jx=`This class can be used to stop generation whenever the “end-of-sequence” token is generated.
By default, it uses the <code>model.generation_config.eos_token_id</code>.`,V2,Wg,ei,S_,ti,H_,si,Ux='A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusively available to our PyTorch implementations.',E_,W,ni,G2,Bg,Zx=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,F2,Ig,Cx="All classes that inherit Constraint must follow the requirement that",X2,kn,R2,zg,Wx="will always terminate (halt).",L2,$n,ai,N2,Vg,Bx="When called, returns the token(s) that would take this constraint one step closer to being fulfilled.",S2,jn,ri,H2,Gg,Ix="Creates a new instance of this constraint.",E2,xn,oi,q2,Fg,zx="Reads in a token and returns whether it creates progress.",D2,Jn,li,Q2,Xg,Vx="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",Y2,Un,ii,P2,Rg,Gx=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,A2,Zn,ci,O2,Lg,Fx="Tests whether this constraint has been properly defined.",K2,es,di,ek,Ng,Xx=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,tk,Sg,Rx=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,q_,Js,pi,sk,Hg,Lx='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',D_,Us,mi,nk,Eg,Nx='A special <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',Q_,Re,gi,ak,qg,Sx="A class for beam scorers to track its progress through a list of constraints.",rk,K,hi,ok,Dg,Hx=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,lk,Qg,Ex=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,ik,Yg,qx="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",ck,Pg,Dx=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,dk,Ag,Qx=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,pk,Cn,ui,mk,Og,Yx="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",Y_,fi,P_,Le,bi,gk,Kg,Px=`Abstract base class for all beam scorers that are used for <code>~PreTrainedModel.beam_search</code> and
<code>~PreTrainedModel.beam_sample</code>.`,hk,eh,_i,uk,th,yi,A_,q,Ti,fk,sh,Ax='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',bk,nh,Ox=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,_k,ah,Kx=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,yk,rh,Mi,Tk,oh,vi,O_,Ne,wi,Mk,lh,eJ='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',vk,ih,ki,wk,ch,$i,K_,ji,ey,F,xi,kk,dh,tJ="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",$k,Wn,jk,Bn,xk,In,Ji,Jk,ph,sJ="Flushes any remaining cache and prints a newline to stdout.",Uk,zn,Ui,Zk,mh,nJ="Prints the new text to stdout. If the stream is ending, also prints a newline.",Ck,Vn,Zi,Wk,gh,aJ="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",ty,ge,Ci,Bk,hh,rJ=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,Ik,Gn,zk,Fn,Vk,Xn,Wi,Gk,uh,oJ="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",sy,Bi,ny,Gt,Ii,Fk,fh,lJ="Base, abstract class for all caches. The actual data structure is specific to each subclass.",Xk,Rn,zi,Rk,bh,iJ="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",ay,Ft,Vi,Lk,_h,cJ="Base class for cache configs",Nk,Ln,Gi,Sk,yh,dJ=`Updates attributes of this class instance with attributes from <code>kwargs</code> if they match existing attributes,
returning all the unused kwargs.`,ry,Xt,Fi,Hk,Th,pJ="Configuration class for quantized cache settings.",Ek,Nn,Xi,qk,Mh,mJ="Validates if the arguments passed are correct",oy,I,Ri,Dk,vh,gJ="A cache that grows dynamically as more tokens are generated. This is the default for generative models.",Qk,wh,hJ=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,Yk,Sn,Pk,Hn,Li,Ak,kh,uJ="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",Ok,En,Ni,Kk,$h,fJ="Returns the sequence length of the cached states. A layer index can be optionally passed.",e1,qn,Si,t1,jh,bJ="Reorders the cache for beam search, given the selected beam indices.",s1,Dn,Hi,n1,xh,_J=`Converts the <code>DynamicCache</code> instance into the its equivalent in the legacy cache format. Used for
backward compatibility.`,a1,Qn,Ei,r1,Jh,yJ=`Converts a cache in the legacy cache format into an equivalent <code>DynamicCache</code>. Used for
backward compatibility.`,ly,D,qi,o1,Uh,TJ=`A quantizer cache similar to what is described in the <a href="https://arxiv.org/abs/2402.02750" rel="nofollow">KIVI: A Tuning-Free Asymmetric 2bit Quantization for KV Cache paper</a>.
It allows the model to generate longer sequence length without allocating too much memory for Key and Value cache by applying quantization.`,l1,Zh,MJ=`The cache has two types of storage, one for original precision and one for the quantized cache. A <code>residual length</code> is set as a maximum capacity for the
original precision cache. When the length goes beyond maximum capacity, the original precision cache is discarded and moved into the quantized cache. The
quantization is done per-channel with a set <code>q_group_size</code> for both Keys and Values, in contrast to what was described in the paper.`,i1,Ch,vJ=`It stores Keys and Values a list of quantized tensors (tuples in case we need to store metadata), one for each layer. Additionally, it stores the Key and
Value in original precision states as a list of tensors, one for each layer. The size of each tensor
is <code>[batch_size, num_heads, seq_len - residual_length, head_dim]</code>`,c1,Wh,Di,d1,Yn,Qi,p1,Bh,wJ="Returns the sequence length of the cached states. A layer index can be optionally passed.",iy,Rt,Yi,m1,Ih,kJ="Quantized Cache class that uses <code>quanto</code> as a backend to perform quantization. Current implementation supports <code>int2</code> and <code>int4</code> dtypes only.",g1,Pn,cy,Lt,Pi,h1,zh,$J="Quantized Cache class that uses <code>HQQ</code> as a backend to perform quantization. Current implementation supports <code>int2</code>, <code>int4</code>, <code>int8</code> dtypes.",u1,An,dy,X,Ai,f1,Vh,jJ=`A cache that as described in the <a href="https://arxiv.org/abs/2309.17453" rel="nofollow">Attention Sinks paper</a>. It allows the model to
generate beyond the length of its context window, without losing fluency in the conversation. As it discards past
tokens, the model will lose the ability to generate tokens that depend on the context that was discarded.`,b1,Gh,xJ=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,_1,On,y1,Kn,Oi,T1,Fh,JJ="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",M1,ea,Ki,v1,Xh,UJ="Returns the sequence length of the cached states. A layer index can be optionally passed.",w1,ta,ec,k1,Rh,ZJ="Reorders the cache for beam search, given the selected beam indices.",py,Q,tc,$1,Lh,CJ=`A drop-in replacement for DynamicCache that conserves GPU memory at the expense of more CPU memory.
Useful for generating from models with very long context.`,j1,Nh,WJ=`In addition to the default CUDA stream, where all forward() computations happen,
this class uses another stream, the prefetch stream, which it creates itself.
Since scheduling of operations on separate streams happens independently, this class uses
the prefetch stream to asynchronously prefetch the KV cache of layer k+1 when layer k is executing.
The movement of the layer k-1 cache to the CPU is handled by the default stream as a simple way to
ensure the eviction is scheduled after all computations on that cache are finished.`,x1,sa,sc,J1,Sh,BJ="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",U1,na,nc,Z1,Hh,IJ="Starts prefetching the next layer cache",C1,aa,ac,W1,Eh,zJ="Moves the previous layer cache to the CPU",my,Y,rc,B1,qh,VJ="Static Cache class to be used with <code>torch.compile(model)</code> and <code>torch.export()</code>.",I1,ra,z1,oa,oc,V1,Dh,GJ=`Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.
It is VERY important to index using a tensor, otherwise you introduce a copy to the device.`,G1,la,lc,F1,Qh,FJ="Returns the sequence length of the cached states that were seen by the model.",X1,ia,ic,R1,Yh,XJ="Resets the cache values while preserving the objects",gy,P,cc,L1,Ph,RJ=`Static cache class to be used with <code>torch.compile(model)</code> that offloads to the CPU or
another device.`,N1,ca,S1,da,dc,H1,Ah,LJ=`Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.
It is VERY important to index using a tensor, otherwise you introduce a copy to the device.`,E1,pa,pc,q1,Oh,NJ="Returns the sequence length of the cached states that were seen by the model.",D1,ma,mc,Q1,Kh,SJ="Resets the cache values while preserving the objects.",hy,A,gc,Y1,eu,HJ=`Hybrid Cache class to be used with <code>torch.compile</code> for Gemma2 models that alternate between a local sliding window attention
and global attention in every other layer. Under the hood, Hybrid Cache leverages [“SlidingWindowCache”] for sliding window attention
and [“StaticCache”] for global attention. For more information, see the documentation of each subcomponeent cache class.`,P1,ga,A1,tu,hc,O1,su,uc,K1,ha,fc,e$,nu,EJ="Resets the cache values while preserving the objects",uy,z,bc,t$,au,qJ=`Sliding Window Cache class to be used with <code>torch.compile</code> for models like Mistral that support sliding window attention.
Every time when we try to update the cache, we compute the <code>indices</code> based on <code>cache_position &gt;= self.config.sliding_window - 1</code>,
if true(which means the cache can not hold all the old key value states and new states together because of the sliding window constraint),
we need to do a cycle shift based on <code>indices</code> to replace the oldest states by the new key value states passed in.`,s$,ru,DJ="The <code>to_shift</code> is only true once we are above sliding_window. Thus with <code>sliding_window==64</code>:",n$,ou,QJ=`indices = (slicing + to_shift[-1].int()-1) % self.config.sliding_window
tensor([ 1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
55, 56, 57, 58, 59, 60, 61, 62, 63,  0])`,a$,lu,YJ="We overwrite the cache using these, then we always write at cache_position (clamped to <code>sliding_window</code>)",r$,ua,o$,iu,_c,l$,cu,yc,fy,V,Tc,i$,du,PJ=`Base, abstract class for all encoder-decoder caches. Can be used to hold combinations of self-attention and
cross-attention caches.`,c$,fa,d$,ba,Mc,p$,pu,AJ="Returns the sequence length of the cached states. A layer index can be optionally passed.",m$,_a,vc,g$,mu,OJ="Converts the <code>EncoderDecoderCache</code> instance into  its equivalent in the legacy cache format.",h$,ya,wc,u$,gu,KJ="Converts a cache in the legacy cache format into an equivalent <code>EncoderDecoderCache</code>.",f$,hu,kc,b$,Ta,$c,_$,uu,eU="Reorders the cache for beam search, given the selected beam indices.",by,O,jc,y$,fu,tU="Cache for mamba model which does not have attention mechanism and key value states.",T$,Ma,M$,bu,xc,v$,_u,Jc,w$,yu,Uc,_y,Zc,yy,he,Cc,k$,Tu,sU=`Class that holds arguments for watermark generation and should be passed into <code>GenerationConfig</code> during <code>generate</code>.
See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">this paper</a> for more details on the arguments.`,$$,Mu,nU="Accepts the following keys:",j$,vu,aU=`<li>greenlist_ratio (<code>float</code>):
Used for watermarking. The ratio of “green” tokens used to the vocabulary size. Defaults to 0.25.</li> <li>bias (<code>float</code>):
Used with watermarking. The bias added to the selected “green” tokens’ logits. Defaults to 2.0.</li> <li>hashing_key (<code>int</code>):
Hashing key used for watermarking. Defaults to 15485863 (the millionth prime).</li> <li>seeding_scheme (<code>str</code>):
Algorithm to use for watermarking. Accepts values:<ul><li>“lefthash” (default): “green” tokens selection depend on the last token (Algorithm 2 from the paper)</li> <li>“selfhash”: “green” tokens selection depends on the current token itself (Algorithm 3 from the paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than “lefthash”.</li></ul></li> <li>context_width(<code>int</code>):
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>`,x$,va,Wc,J$,wu,rU="Call self as a function.",Ty,ue,Bc,U$,ku,oU=`Detector for detection of watermark generated text. The detector needs to be given the exact same settings that were
given during text generation to replicate the watermark greenlist generation and so detect the watermark. This includes
the correct device that was used during text generation, the correct watermarking arguments and the correct tokenizer vocab size.
The code was based on the <a href="https://github.com/jwkirchenbauer/lm-watermarking/tree/main" rel="nofollow">original repo</a>.`,Z$,$u,lU='See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">the paper</a> for more information.',C$,wa,W$,ka,Ic,B$,ju,iU="ma",My,Nt,zc,I$,xu,cU=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.BayesianDetectorModel">BayesianDetectorModel</a>. It is used to
instantiate a Bayesian Detector model according to the specified arguments.`,z$,Ju,dU=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,vy,R,Vc,V$,Uu,pU="Bayesian classifier for watermark detection.",G$,Zu,mU=`This detector uses Bayes’ rule to compute a watermarking score, which is the sigmoid of the log of ratio of the
posterior probabilities P(watermarked|g_values) and P(unwatermarked|g_values). Please see the section on
BayesianScore in the paper for further details.
Paper URL: <a href="https://www.nature.com/articles/s41586-024-08025-4" rel="nofollow">https://www.nature.com/articles/s41586-024-08025-4</a>`,F$,Cu,gU=`Note that this detector only works with non-distortionary Tournament-based watermarking using the Bernoulli(0.5)
g-value distribution.`,X$,Wu,hU=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,R$,Bu,uU=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,L$,$a,Gc,N$,Iu,fU="Computes the watermarked posterior P(watermarked|g_values).",wy,St,Fc,S$,zu,bU=`Class that holds arguments for watermark generation and should be passed into <code>GenerationConfig</code> during <code>generate</code>.
See <a href="https://www.nature.com/articles/s41586-024-08025-4" rel="nofollow">this paper</a> for more details on the arguments.`,H$,ja,ky,fe,Xc,E$,Vu,_U="SynthID text watermark detector class.",q$,Gu,yU=`This class has to be initialized with the trained bayesian detector module check script
in examples/synthid_text/detector_training.py for example in training/saving/loading this
detector module. The folder also showcases example use case of this detector.`,D$,xa,Q$,Fu,Rc,$y,Lc,jy,Se,Nc,Y$,Xu,TU=`Class that holds arguments relative to <code>torch.compile</code> behavior, when using automatic compilation in <code>generate</code>.
See <a href="https://pytorch.org/docs/stable/generated/torch.compile.html" rel="nofollow"><code>torch.compile</code></a> for more details on the arguments.`,P$,Ja,A$,Ua,Sc,O$,Ru,MU="Call self as a function.",xy,Hc,Jy,xf,Uy;return w=new se({props:{title:"Utilities for Generation",local:"utilities-for-generation",headingTag:"h1"}}),La=new se({props:{title:"Generate Outputs",local:"generate-outputs",headingTag:"h2"}}),Ha=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiklMEFtb2RlbCUyMCUzRCUyMEdQVDJMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjBhbmQlMjAlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbmVyYXRpb25fb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`,wrap:!1}}),Pa=new U({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]',wrap:!1}}),er=new se({props:{title:"PyTorch",local:"transformers.generation.GenerateDecoderOnlyOutput",headingTag:"h3"}}),tr=new v({props:{name:"class transformers.generation.GenerateDecoderOnlyOutput",anchor:"transformers.generation.GenerateDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L119"}}),sr=new v({props:{name:"class transformers.generation.GenerateEncoderDecoderOutput",anchor:"transformers.generation.GenerateEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L155"}}),nr=new v({props:{name:"class transformers.generation.GenerateBeamDecoderOnlyOutput",anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L203"}}),ar=new v({props:{name:"class transformers.generation.GenerateBeamEncoderDecoderOutput",anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L247"}}),rr=new se({props:{title:"TensorFlow",local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",headingTag:"h3"}}),or=new v({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L85"}}),lr=new v({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L57"}}),ir=new v({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L155"}}),cr=new v({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L127"}}),dr=new v({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L232"}}),pr=new v({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L197"}}),mr=new v({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L317"}}),gr=new v({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L282"}}),hr=new v({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L393"}}),ur=new v({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L366"}}),fr=new se({props:{title:"FLAX",local:"transformers.generation.FlaxSampleOutput",headingTag:"h3"}}),br=new v({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L69"}}),_r=new v({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),yr=new v({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L55"}}),Tr=new v({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),Mr=new v({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L83"}}),vr=new v({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),wr=new se({props:{title:"LogitsProcessor",local:"logitsprocessor",headingTag:"h2"}}),$r=new se({props:{title:"PyTorch",local:"transformers.AlternatingCodebooksLogitsProcessor",headingTag:"h3"}}),jr=new v({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2131"}}),Fs=new Ra({props:{warning:!0,$$slots:{default:[zZ]},$$scope:{ctx:j}}}),xr=new v({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2160"}}),Jr=new v({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2067"}}),Xs=new Ra({props:{warning:!0,$$slots:{default:[VZ]},$$scope:{ctx:j}}}),Rs=new Z({props:{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[GZ]},$$scope:{ctx:j}}}),Ur=new v({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2115",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Zr=new v({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L981"}}),Ls=new Z({props:{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.example",$$slots:{default:[FZ]},$$scope:{ctx:j}}}),Cr=new v({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1030",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Wr=new v({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 rewards prompt tokens. Between 0.0
and 1.0 penalizes prompt tokens.`,name:"penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L362"}}),Ns=new Z({props:{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.example",$$slots:{default:[XZ]},$$scope:{ctx:j}}}),Br=new v({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L406",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ir=new v({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L702"}}),Ss=new Z({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[RZ]},$$scope:{ctx:j}}}),zr=new v({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L757",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Vr=new v({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"},{anchor:"transformers.EtaLogitsWarper.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L771"}}),Hs=new Z({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[LZ]},$$scope:{ctx:j}}}),Gr=new v({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L840",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Fr=new v({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": typing.Tuple[int, float]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1643"}}),Es=new Z({props:{anchor:"transformers.ExponentialDecayLengthPenalty.example",$$slots:{default:[NZ]},$$scope:{ctx:j}}}),Xr=new v({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1729",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Rr=new v({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1521"}}),qs=new Z({props:{anchor:"transformers.ForcedBOSTokenLogitsProcessor.example",$$slots:{default:[SZ]},$$scope:{ctx:j}}}),Lr=new v({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1556",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Nr=new v({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1566"}}),Ds=new Z({props:{anchor:"transformers.ForcedEOSTokenLogitsProcessor.example",$$slots:{default:[HZ]},$$scope:{ctx:j}}}),Sr=new v({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1612",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Hr=new v({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. A higher <code>diversity_penalty</code> will enforce greater diversity among the beams. Adjusting
this value can help strike a balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1385"}}),Qs=new Z({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[EZ]},$$scope:{ctx:j}}}),Er=new v({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1472",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),qr=new v({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1622"}}),Dr=new v({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1631",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qr=new v({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1744"}}),Ys=new Z({props:{anchor:"transformers.LogitNormalization.example",$$slots:{default:[qZ]},$$scope:{ctx:j}}}),Yr=new v({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1775",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Pr=new v({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L45"}}),Ar=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Or=new v({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L71"}}),Kr=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L78",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),eo=new v({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.MinLengthLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L109"}}),Ps=new Z({props:{anchor:"transformers.MinLengthLogitsProcessor.example",$$slots:{default:[DZ]},$$scope:{ctx:j}}}),to=new v({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L160",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),so=new v({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L170"}}),As=new Z({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[QZ]},$$scope:{ctx:j}}}),no=new v({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L230",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ao=new v({props:{name:"class transformers.MinPLogitsWarper",anchor:"transformers.MinPLogitsWarper",parameters:[{name:"min_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.MinPLogitsWarper.min_p",description:`<strong>min_p</strong> (<code>float</code>) &#x2014;
Minimum token probability, which will be scaled by the probability of the most likely token. It must be a
value between 0 and 1. Typical values are in the 0.01-0.2 range, comparably selective as setting <code>top_p</code> in
the 0.99-0.8 range (use the opposite of normal <code>top_p</code> values).`,name:"min_p"},{anchor:"transformers.MinPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.MinPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L537"}}),Os=new Z({props:{anchor:"transformers.MinPLogitsWarper.example",$$slots:{default:[YZ]},$$scope:{ctx:j}}}),ro=new v({props:{name:"__call__",anchor:"transformers.MinPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L594"}}),oo=new v({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>, <em>optional</em>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1225"}}),Ks=new Ra({props:{$$slots:{default:[PZ]},$$scope:{ctx:j}}}),en=new Z({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[AZ]},$$scope:{ctx:j}}}),lo=new v({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1123",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),io=new v({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L922"}}),tn=new Ra({props:{$$slots:{default:[OZ]},$$scope:{ctx:j}}}),sn=new Z({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[KZ]},$$scope:{ctx:j}}}),co=new v({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L969",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),po=new v({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": typing.Callable[[int, torch.Tensor], typing.List[int]]"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1316"}}),nn=new Z({props:{anchor:"transformers.PrefixConstrainedLogitsProcessor.example",$$slots:{default:[eC]},$$scope:{ctx:j}}}),mo=new v({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1367",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),go=new v({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 penalizes previously generated
tokens. Between 0.0 and 1.0 rewards previously generated tokens.`,name:"penalty"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L308"}}),an=new Z({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[tC]},$$scope:{ctx:j}}}),ho=new v({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L351",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),uo=new v({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": typing.List[typing.List[typing.Union[typing.List[int], float]]]"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>List[List[Union[List[int], float]]]</code>) &#x2014;
List of lists that maps a sequence of tokens to its bias term (e.g. <code>[[[10, 45], -2.0], [[64], -7.5]]</code>). Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1050"}}),rn=new Ra({props:{$$slots:{default:[sC]},$$scope:{ctx:j}}}),on=new Z({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[nC]},$$scope:{ctx:j}}}),fo=new v({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1123",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),bo=new v({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""},{name:"device",val:": str = 'cpu'"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1781"}}),ln=new Z({props:{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.example",$$slots:{default:[aC]},$$scope:{ctx:j}}}),_o=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1823",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),yo=new v({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""},{name:"device",val:": str = 'cpu'"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1834"}}),cn=new Z({props:{anchor:"transformers.SuppressTokensLogitsProcessor.example",$$slots:{default:[rC]},$$scope:{ctx:j}}}),To=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1866",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Mo=new v({props:{name:"class transformers.SynthIDTextWatermarkLogitsProcessor",anchor:"transformers.SynthIDTextWatermarkLogitsProcessor",parameters:[{name:"ngram_len",val:": int"},{name:"keys",val:": typing.List[int]"},{name:"sampling_table_size",val:": int"},{name:"sampling_table_seed",val:": int"},{name:"context_history_size",val:": int"},{name:"device",val:": device"},{name:"skip_first_ngram_calls",val:": bool = False"},{name:"debug_mode",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.ngram_len",description:`<strong>ngram_len</strong> (<code>int</code>) &#x2014;
Ngram length.`,name:"ngram_len"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.keys",description:`<strong>keys</strong> (<code>List[int]</code>) &#x2014;
A sequence of watermarking keys, one for each depth.`,name:"keys"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.sampling_table_size",description:`<strong>sampling_table_size</strong> (<code>int</code>) &#x2014;
Size of the sampling table.`,name:"sampling_table_size"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.sampling_table_seed",description:`<strong>sampling_table_seed</strong> (<code>int</code>) &#x2014;
Random seed to generate the sampling table.`,name:"sampling_table_seed"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.context_history_size",description:`<strong>context_history_size</strong> (<code>int</code>) &#x2014;
Size of the tensor to keep track of seen contexts.`,name:"context_history_size"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Device to use.`,name:"device"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.skip_first_ngram_calls",description:`<strong>skip_first_ngram_calls</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip first ngram calls.`,name:"skip_first_ngram_calls"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.debug_mode",description:`<strong>debug_mode</strong> (<code>bool</code>, optional, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Logits are modified to uniform one got before watermarking modification is applied. This is to test the
implementation.`,name:"debug_mode"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2514"}}),dn=new Z({props:{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.example",$$slots:{default:[oC]},$$scope:{ctx:j}}}),vo=new v({props:{name:"__call__",anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2652",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),wo=new v({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L242"}}),pn=new Ra({props:{$$slots:{default:[lC]},$$scope:{ctx:j}}}),mn=new Z({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[iC]},$$scope:{ctx:j}}}),ko=new v({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L302",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$o=new v({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L484"}}),gn=new Z({props:{anchor:"transformers.TopKLogitsWarper.example",$$slots:{default:[cC]},$$scope:{ctx:j}}}),jo=new v({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L528",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xo=new v({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L417"}}),hn=new Z({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[dC]},$$scope:{ctx:j}}}),Jo=new v({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L468",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Uo=new v({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L614"}}),un=new Z({props:{anchor:"transformers.TypicalLogitsWarper.example",$$slots:{default:[pC]},$$scope:{ctx:j}}}),Zo=new v({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L678",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Co=new v({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"unconditional_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2176"}}),fn=new Z({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[mC]},$$scope:{ctx:j}}}),Wo=new v({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2282"}}),Bo=new v({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"begin_index",val:": typing.Optional[int] = None"},{name:"_detect_timestamp_from_logprob",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.begin_index",description:"<strong>begin_index</strong> (<code>Optional</code>, <em>optional</em>) &#x2014; Token index of the first token that is generated by the model.",name:"begin_index"},{anchor:"transformers.WhisperTimeStampLogitsProcessor._detect_timestamp_from_logprob",description:"<strong>_detect_timestamp_from_logprob</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether timestamps can be predicted from logprobs over all timestamps.",name:"_detect_timestamp_from_logprob"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1874"}}),bn=new Z({props:{anchor:"transformers.WhisperTimeStampLogitsProcessor.example",$$slots:{default:[gC]},$$scope:{ctx:j}}}),Io=new v({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1959",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),zo=new v({props:{name:"class transformers.WatermarkLogitsProcessor",anchor:"transformers.WatermarkLogitsProcessor",parameters:[{name:"vocab_size",val:""},{name:"device",val:""},{name:"greenlist_ratio",val:": float = 0.25"},{name:"bias",val:": float = 2.0"},{name:"hashing_key",val:": int = 15485863"},{name:"seeding_scheme",val:": str = 'lefthash'"},{name:"context_width",val:": int = 1"}],parametersDescription:[{anchor:"transformers.WatermarkLogitsProcessor.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>) &#x2014;
The model tokenizer&#x2019;s vocab_size. Used to calculate &#x201C;green&#x201D; tokens ratio.`,name:"vocab_size"},{anchor:"transformers.WatermarkLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>) &#x2014;
The device where model is allocated.`,name:"device"},{anchor:"transformers.WatermarkLogitsProcessor.greenlist_ratio",description:`<strong>greenlist_ratio</strong> (<code>float</code>, optional, <em>optional</em>, defaults to 0.25) &#x2014;
The ratio of &#x201C;green&#x201D; tokens used to the vocabulary size. Defaults to 0.25.`,name:"greenlist_ratio"},{anchor:"transformers.WatermarkLogitsProcessor.bias",description:`<strong>bias</strong> (<code>float</code>, optional, <em>optional</em>, defaults to 2.0) &#x2014;
The bias added to the selected &#x201C;green&#x201D; tokens&#x2019; logits. Consider lowering the
<code>bias</code> if the text generation quality degrades. Recommended values are in the
range of [0.5, 2.0]. Defaults to 2.0.`,name:"bias"},{anchor:"transformers.WatermarkLogitsProcessor.hashing_key",description:`<strong>hashing_key</strong> (<code>int</code>, optional, <em>optional</em>, defaults to 15485863) &#x2014;
Key used for hashing. If you deploy this watermark, we advise using another private key.
Defaults to 15485863 (the millionth prime).`,name:"hashing_key"},{anchor:"transformers.WatermarkLogitsProcessor.seeding_scheme",description:`<strong>seeding_scheme</strong> (<code>str</code>, optional, <em>optional</em>, defaults to <code>&quot;lefthash&quot;</code>) &#x2014;
The seeding scheme used for selecting &#x201C;green&#x201D; tokens. Accepts values:<ul>
<li>&#x201C;lefthash&#x201D; (default): &#x201C;green&#x201D; tokens selection depend on the last token (Algorithm 2 from paper)</li>
<li>&#x201C;selfhash&#x201D;: &#x201C;green&#x201D; tokens selection depends on the current token itself (Algorithm 3 from paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than &#x201C;lefthash&#x201D;.
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>
</ul>`,name:"seeding_scheme"},{anchor:"transformers.WatermarkLogitsProcessor.context_width",description:`<strong>context_width</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of previous tokens to use when setting the seed.`,name:"context_width"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2341"}}),_n=new Z({props:{anchor:"transformers.WatermarkLogitsProcessor.example",$$slots:{default:[hC]},$$scope:{ctx:j}}}),Vo=new v({props:{name:"__call__",anchor:"transformers.WatermarkLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WatermarkLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WatermarkLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2463",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Go=new se({props:{title:"TensorFlow",local:"transformers.TFForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),Fo=new v({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L448"}}),Xo=new v({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L462"}}),Ro=new v({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L478"}}),Lo=new v({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L495"}}),No=new v({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": typing.List[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L563"}}),So=new v({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L579"}}),Ho=new v({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L53"}}),Eo=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),qo=new v({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L75"}}),Do=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qo=new v({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L64"}}),Yo=new v({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Po=new v({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L202"}}),Ao=new v({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L228"}}),Oo=new v({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L288"}}),Ko=new v({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L367"}}),el=new v({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L388"}}),tl=new v({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L427"}}),sl=new v({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L238"}}),nl=new v({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L280"}}),al=new v({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L511"}}),rl=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L522"}}),ol=new v({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L541"}}),ll=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L548"}}),il=new v({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L98"}}),cl=new v({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L113"}}),dl=new v({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L118"}}),pl=new v({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L138"}}),ml=new v({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L146"}}),gl=new v({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L170"}}),hl=new se({props:{title:"FLAX",local:"transformers.FlaxForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),ul=new v({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L195"}}),fl=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L207"}}),bl=new v({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L217"}}),_l=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L232"}}),yl=new v({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L316"}}),Tl=new v({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L338"}}),Ml=new v({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L51"}}),vl=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L54",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),wl=new v({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L73"}}),kl=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L80",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$l=new v({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L62"}}),jl=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L65",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xl=new v({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L242"}}),Jl=new v({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L263"}}),Ul=new v({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L272"}}),Zl=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L289"}}),Cl=new v({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L297"}}),Wl=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L310"}}),Bl=new v({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L96"}}),Il=new v({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L111"}}),zl=new v({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L160"}}),Vl=new v({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L180"}}),Gl=new v({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L116"}}),Fl=new v({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L140"}}),Xl=new v({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L364"}}),Rl=new v({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L398"}}),Ll=new se({props:{title:"StoppingCriteria",local:"transformers.StoppingCriteria",headingTag:"h2"}}),Sl=new v({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L46"}}),Hl=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L53",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),El=new v({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L491"}}),ql=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L492",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Dl=new v({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L58"}}),Ql=new v({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L74",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Yl=new v({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L87"}}),Pl=new v({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L104",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Al=new v({props:{name:"class transformers.StopStringCriteria",anchor:"transformers.StopStringCriteria",parameters:[{name:"tokenizer",val:": PreTrainedTokenizerBase"},{name:"stop_strings",val:": typing.Union[str, typing.List[str]]"}],parametersDescription:[{anchor:"transformers.StopStringCriteria.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
The model&#x2019;s associated tokenizer (necessary to extract vocab and tokenize the termination sequences)`,name:"tokenizer"},{anchor:"transformers.StopStringCriteria.stop_strings",description:`<strong>stop_strings</strong> (<code>Union[str, List[str]]</code>) &#x2014;
A list of strings that should end generation. If a string is passed, it will be treated like a
list with a single element.`,name:"stop_strings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L110"}}),wn=new Z({props:{anchor:"transformers.StopStringCriteria.example",$$slots:{default:[uC]},$$scope:{ctx:j}}}),Ol=new v({props:{name:"__call__",anchor:"transformers.StopStringCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StopStringCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StopStringCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StopStringCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L387",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Kl=new v({props:{name:"class transformers.EosTokenCriteria",anchor:"transformers.EosTokenCriteria",parameters:[{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"}],parametersDescription:[{anchor:"transformers.EosTokenCriteria.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L446"}}),ei=new v({props:{name:"__call__",anchor:"transformers.EosTokenCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EosTokenCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EosTokenCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.EosTokenCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L463",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),ti=new se({props:{title:"Constraints",local:"transformers.Constraint",headingTag:"h2"}}),ni=new v({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L5"}}),kn=new Z({props:{anchor:"transformers.Constraint.example",$$slots:{default:[fC]},$$scope:{ctx:j}}}),ai=new v({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>A single token ID (int) that advances the constraint, or</li>
<li>A list of token IDs that could advance the constraint</li>
<li>None if the constraint is completed or cannot be advanced</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>token_ids (Union[int, List[int], None])</p>
`}}),ri=new v({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],parametersDescription:[{anchor:"transformers.Constraint.copy.stateful(bool)",description:"<strong>stateful(<code>bool</code>)</strong> &#x2014; Whether to not only copy the constraint for new instance, but also its state.",name:"stateful(bool)"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L116",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same constraint as the one being called from.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>constraint(<code>Constraint</code>)</p>
`}}),oi=new v({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L63"}}),li=new v({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L107"}}),ii=new v({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L97"}}),ci=new v({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L24"}}),di=new v({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],parametersDescription:[{anchor:"transformers.Constraint.update.token_id(int)",description:`<strong>token_id(<code>int</code>)</strong> &#x2014;
The id of a newly generated token in the beam search.`,name:"token_id(int)"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L72",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stepped(<code>bool</code>)</p>
`}}),pi=new v({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": typing.List[int]"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L132"}}),mi=new v({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": typing.List[typing.List[int]]"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:`<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014;
A list of words, where each word is a list of ids. This constraint is fulfilled by generating just one from
the list of words.`,name:"nested_token_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L264"}}),gi=new v({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L354"}}),hi=new v({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L386"}}),ui=new v({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": typing.Optional[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L421"}}),fi=new se({props:{title:"BeamSearch",local:"transformers.BeamScorer",headingTag:"h2"}}),bi=new v({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L91"}}),_i=new v({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <code>~PreTrainedModel.group_beam_search</code>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),yi=new v({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),Ti=new v({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[bool, str, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L123"}}),Mi=new v({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"group_index",val:": typing.Optional[int] = 0"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L215"}}),vi=new v({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L320"}}),wi=new v({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[bool, str, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L419"}}),ki=new v({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.decoder_prompt_len",description:`<strong>decoder_prompt_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The length of prompt that is included in the input to decoder.`,name:"decoder_prompt_len"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L513",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),$i=new v({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L813"}}),ji=new se({props:{title:"Streamers",local:"transformers.TextStreamer",headingTag:"h2"}}),xi=new v({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L38"}}),Wn=new Ra({props:{warning:!0,$$slots:{default:[bC]},$$scope:{ctx:j}}}),Bn=new Z({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[_C]},$$scope:{ctx:j}}}),Ji=new v({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L116"}}),Ui=new v({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L130"}}),Zi=new v({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L82"}}),Ci=new v({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": typing.Optional[float] = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L159"}}),Gn=new Ra({props:{warning:!0,$$slots:{default:[yC]},$$scope:{ctx:j}}}),Fn=new Z({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[TC]},$$scope:{ctx:j}}}),Wi=new v({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L213"}}),Bi=new se({props:{title:"Caches",local:"transformers.Cache",headingTag:"h2"}}),Ii=new v({props:{name:"class transformers.Cache",anchor:"transformers.Cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L27"}}),zi=new v({props:{name:"update",anchor:"transformers.Cache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.Cache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.Cache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.Cache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.Cache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. These are specific to each subclass and allow new types of
cache to be created.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L35",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Vi=new v({props:{name:"class transformers.CacheConfig",anchor:"transformers.CacheConfig",parameters:[{name:"cache_implementation",val:": None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L114"}}),Gi=new v({props:{name:"update",anchor:"transformers.CacheConfig.update",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CacheConfig.update.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary of attributes to tentatively update this class.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L188",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary containing all the key-value pairs that were not used to update the instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Fi=new v({props:{name:"class transformers.QuantizedCacheConfig",anchor:"transformers.QuantizedCacheConfig",parameters:[{name:"backend",val:": str = 'quanto'"},{name:"nbits",val:": typing.Optional[int] = 4"},{name:"axis_key",val:": typing.Optional[int] = 0"},{name:"axis_value",val:": typing.Optional[int] = 0"},{name:"q_group_size",val:": typing.Optional[int] = 64"},{name:"residual_length",val:": typing.Optional[int] = 128"},{name:"compute_dtype",val:": typing.Optional[torch.dtype] = torch.float16"},{name:"device",val:": typing.Optional[str] = 'cpu'"}],parametersDescription:[{anchor:"transformers.QuantizedCacheConfig.backend",description:`<strong>backend</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;quanto&quot;</code>) &#x2014;
Backend to use when performing quantization, Can be one of [<code>quanto</code>, <code>HQQ</code>]`,name:"backend"},{anchor:"transformers.QuantizedCacheConfig.nbits",description:`<strong>nbits</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of bits, can be 2 or 4 for the <code>quanto</code> backend and one of [1, 2, 3, 4, 8] for the <code>HQQ</code> backend. Defaults to 2.`,name:"nbits"},{anchor:"transformers.QuantizedCacheConfig.axis_key",description:`<strong>axis_key</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Axis over which to perform grouping for the key tensors. Can be [0, -1] for <code>quanto</code> backend and [0, 1] for <code>HQQ</code> backend.`,name:"axis_key"},{anchor:"transformers.QuantizedCacheConfig.axis_value",description:`<strong>axis_value</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Axis over which to perform grouping for the value tensors. Can be [0, -1] for <code>quanto</code> backend and [0, 1] for <code>HQQ</code> backend.`,name:"axis_value"},{anchor:"transformers.QuantizedCacheConfig.q_group_size",description:`<strong>q_group_size</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 64) &#x2014;
Size of the quantization group, should be a divisor of the model&#x2019;s hidden dimension.
Defaults to 64.`,name:"q_group_size"},{anchor:"transformers.QuantizedCacheConfig.residual_length",description:`<strong>residual_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 128) &#x2014;
Length of the residual cache which will always be stored in original presicion.
Defaults to 128.`,name:"residual_length"},{anchor:"transformers.QuantizedCacheConfig.compute_dtype",description:`<strong>compute_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float16</code>) &#x2014;
The defualt dtype used for computations in the model. Keys and Values will be cast to this dtype after dequantization.`,name:"compute_dtype"},{anchor:"transformers.QuantizedCacheConfig.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
Device on which to perform computations, should be same as the model&#x2019;s device.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L211"}}),Xi=new v({props:{name:"validate",anchor:"transformers.QuantizedCacheConfig.validate",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L257"}}),Ri=new v({props:{name:"class transformers.DynamicCache",anchor:"transformers.DynamicCache",parameters:[{name:"num_hidden_layers",val:": typing.Optional[int] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L350"}}),Sn=new Z({props:{anchor:"transformers.DynamicCache.example",$$slots:{default:[MC]},$$scope:{ctx:j}}}),Li=new v({props:{name:"update",anchor:"transformers.DynamicCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.DynamicCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.DynamicCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.DynamicCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.DynamicCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>DynamicCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L407",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Ni=new v({props:{name:"get_seq_length",anchor:"transformers.DynamicCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L454"}}),Si=new v({props:{name:"reorder_cache",anchor:"transformers.DynamicCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L92"}}),Hi=new v({props:{name:"to_legacy_cache",anchor:"transformers.DynamicCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L469"}}),Ei=new v({props:{name:"from_legacy_cache",anchor:"transformers.DynamicCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"num_hidden_layers",val:": int = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L477"}}),qi=new v({props:{name:"class transformers.QuantizedCache",anchor:"transformers.QuantizedCache",parameters:[{name:"cache_config",val:": QuantizedCacheConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L664"}}),Di=new v({props:{name:"update",anchor:"transformers.QuantizedCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L693"}}),Qi=new v({props:{name:"get_seq_length",anchor:"transformers.QuantizedCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L736"}}),Yi=new v({props:{name:"class transformers.QuantoQuantizedCache",anchor:"transformers.QuantoQuantizedCache",parameters:[{name:"cache_config",val:": CacheConfig"}],parametersDescription:[{anchor:"transformers.QuantoQuantizedCache.cache_config",description:`<strong>cache_config</strong> (<code>QuantizedCacheConfig</code>) &#x2014;
A configuration containing all the arguments to be used by the quantizer, including axis, qtype and group size.`,name:"cache_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L754"}}),Pn=new Z({props:{anchor:"transformers.QuantoQuantizedCache.example",$$slots:{default:[vC]},$$scope:{ctx:j}}}),Pi=new v({props:{name:"class transformers.HQQQuantizedCache",anchor:"transformers.HQQQuantizedCache",parameters:[{name:"cache_config",val:": CacheConfig"}],parametersDescription:[{anchor:"transformers.HQQQuantizedCache.cache_config",description:`<strong>cache_config</strong> (<code>QuantizedCacheConfig</code>) &#x2014;
A configuration containing all the arguments to be used by the quantizer, including axis, qtype and group size.`,name:"cache_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L820"}}),An=new Z({props:{anchor:"transformers.HQQQuantizedCache.example",$$slots:{default:[wC]},$$scope:{ctx:j}}}),Ai=new v({props:{name:"class transformers.SinkCache",anchor:"transformers.SinkCache",parameters:[{name:"window_length",val:": int"},{name:"num_sink_tokens",val:": int"}],parametersDescription:[{anchor:"transformers.SinkCache.window_length",description:`<strong>window_length</strong> (<code>int</code>) &#x2014;
The length of the context window.`,name:"window_length"},{anchor:"transformers.SinkCache.num_sink_tokens",description:`<strong>num_sink_tokens</strong> (<code>int</code>) &#x2014;
The number of sink tokens. See the original paper for more information.`,name:"num_sink_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L882"}}),On=new Z({props:{anchor:"transformers.SinkCache.example",$$slots:{default:[kC]},$$scope:{ctx:j}}}),Oi=new v({props:{name:"update",anchor:"transformers.SinkCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.SinkCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.SinkCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.SinkCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.SinkCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The following arguments can be used in <code>SinkCache</code>: <code>sin</code>,
<code>cos</code> and <code>partial_rotation_size</code>. These arguments are used with models using RoPE, to recompute the
rotation as the tokens are shifted.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L974",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Ki=new v({props:{name:"get_seq_length",anchor:"transformers.SinkCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L962"}}),ec=new v({props:{name:"reorder_cache",anchor:"transformers.SinkCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L92"}}),tc=new v({props:{name:"class transformers.OffloadedCache",anchor:"transformers.OffloadedCache",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L550"}}),sc=new v({props:{name:"update",anchor:"transformers.OffloadedCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.OffloadedCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.OffloadedCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.OffloadedCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.OffloadedCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>OffloadedCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L617",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),nc=new v({props:{name:"prefetch_layer",anchor:"transformers.OffloadedCache.prefetch_layer",parameters:[{name:"layer_idx",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L571"}}),ac=new v({props:{name:"evict_previous_layer",anchor:"transformers.OffloadedCache.evict_previous_layer",parameters:[{name:"layer_idx",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L580"}}),rc=new v({props:{name:"class transformers.StaticCache",anchor:"transformers.StaticCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"max_cache_len",val:": int = None"},{name:"device",val:": device = None"},{name:"dtype",val:": dtype = torch.float32"},{name:"max_batch_size",val:": typing.Optional[int] = None"},{name:"layer_device_map",val:": typing.Optional[typing.Dict[int, typing.Union[str, torch.device, int]]] = None"}],parametersDescription:[{anchor:"transformers.StaticCache.config",description:`<strong>config</strong> (<code>PretrainedConfig</code>) &#x2014;
The configuration file defining the shape-related attributes required to initialize the static cache.`,name:"config"},{anchor:"transformers.StaticCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used. If you are manually setting the batch size, make sure to take into account the number of beams if you are running beam search`,name:"batch_size"},{anchor:"transformers.StaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.StaticCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.StaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.StaticCache.layer_device_map(`Dict[int,",description:"<strong>layer_device_map(`Dict[int,</strong> Union[str, torch.device, int]]]<code>, </code>optional<code>) -- Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus. You can know which layers mapped to which device by checking the associated device_map: </code>model.hf_device_map`.",name:"layer_device_map(`Dict[int,"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1069"}}),ra=new Z({props:{anchor:"transformers.StaticCache.example",$$slots:{default:[$C]},$$scope:{ctx:j}}}),oc=new v({props:{name:"update",anchor:"transformers.StaticCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.StaticCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.StaticCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.StaticCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.StaticCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The <code>StaticCache</code> needs the <code>cache_position</code> input
to know how where to write in the cache.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1168",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),lc=new v({props:{name:"get_seq_length",anchor:"transformers.StaticCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1218"}}),ic=new v({props:{name:"reset",anchor:"transformers.StaticCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1228"}}),cc=new v({props:{name:"class transformers.OffloadedStaticCache",anchor:"transformers.OffloadedStaticCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"max_batch_size",val:": int"},{name:"max_cache_len",val:": typing.Optional[int]"},{name:"device",val:": typing.Union[str, torch.device]"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"},{name:"offload_device",val:": typing.Union[str, torch.device] = device(type='cpu')"},{name:"layer_device_map",val:": typing.Optional[typing.Dict[int, typing.Union[str, torch.device, int]]] = None"}],parametersDescription:[{anchor:"transformers.OffloadedStaticCache.config",description:`<strong>config</strong> (\`PretrainedConfig) &#x2014;
The configuration file defining the shape-related attributes required to initialize
the static cache.`,name:"config"},{anchor:"transformers.OffloadedStaticCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which the model will be used.`,name:"max_batch_size"},{anchor:"transformers.OffloadedStaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.OffloadedStaticCache.device",description:`<strong>device</strong> (<code>Union[str, torch.device]</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the
layer device.`,name:"device"},{anchor:"transformers.OffloadedStaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
The default <code>dtype</code> to use when initializing the cache.`,name:"dtype"},{anchor:"transformers.OffloadedStaticCache.offload_device",description:`<strong>offload_device</strong> (<code>Union[str, torch.device]</code>, <em>optional</em>, defaults to <code>cpu</code>) &#x2014;
The device to offload to. Defaults to CPU.`,name:"offload_device"},{anchor:"transformers.OffloadedStaticCache.layer_device_map",description:`<strong>layer_device_map</strong> (<code>Dict[int, Union[str, torch.device, int]]</code>, <em>optional</em>) &#x2014;
Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus.
You can know which layers mapped to which device by checking the associated device_map: <code>model.hf_device_map</code>.`,name:"layer_device_map"},{anchor:"transformers.OffloadedStaticCache.key_cache",description:`<strong>key_cache</strong> (<code>List[torch.Tensor]</code>) &#x2014;
Off-loaded key cache tensors. First one will be on device, where-as the others are
off-loaded.`,name:"key_cache"},{anchor:"transformers.OffloadedStaticCache.value_cache",description:`<strong>value_cache</strong> (<code>List[torch.Tensor]</code>) &#x2014;
Off-loaded value cache tensors. First one will be on device, where-as the others are
off-loaded.`,name:"value_cache"},{anchor:"transformers.OffloadedStaticCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which this cache can be used.`,name:"max_batch_size"},{anchor:"transformers.OffloadedStaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which this cache can be used.`,name:"max_cache_len"},{anchor:"transformers.OffloadedStaticCache.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
The device on which the cache is used.`,name:"device"},{anchor:"transformers.OffloadedStaticCache.offload_device",description:`<strong>offload_device</strong> (<code>torch.device</code>) &#x2014;
The device used to offload to.`,name:"offload_device"},{anchor:"transformers.OffloadedStaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>) &#x2014;
The <code>dtype</code> used to initializing the cache.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1873"}}),ca=new Z({props:{anchor:"transformers.OffloadedStaticCache.example",$$slots:{default:[jC]},$$scope:{ctx:j}}}),dc=new v({props:{name:"update",anchor:"transformers.OffloadedStaticCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.OffloadedStaticCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.OffloadedStaticCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.OffloadedStaticCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.OffloadedStaticCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional arguments for the cache subclass. The <code>OffloadedStaticCache</code> needs the
<code>cache_position</code> input to know how where to write in the cache.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1991",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),pc=new v({props:{name:"get_seq_length",anchor:"transformers.OffloadedStaticCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L2074"}}),mc=new v({props:{name:"reset",anchor:"transformers.OffloadedStaticCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L2085"}}),gc=new v({props:{name:"class transformers.HybridCache",anchor:"transformers.HybridCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"max_cache_len",val:": int = None"},{name:"device",val:": typing.Union[torch.device, str] = 'cpu'"},{name:"dtype",val:": dtype = torch.float32"},{name:"max_batch_size",val:": typing.Optional[int] = None"},{name:"layer_device_map",val:": typing.Optional[typing.Dict[int, typing.Union[str, torch.device, int]]] = None"}],parametersDescription:[{anchor:"transformers.HybridCache.config",description:"<strong>config</strong> (`PretrainedConfig) &#x2014;\nThe configuration file defining the shape-related attributes required to initialize the static cache.",name:"config"},{anchor:"transformers.HybridCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"batch_size"},{anchor:"transformers.HybridCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.HybridCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.HybridCache.dtype",description:`<strong>dtype</strong> (torch.dtype, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.HybridCache.layer_device_map(`Dict[int,",description:"<strong>layer_device_map(`Dict[int,</strong> Union[str, torch.device, int]]]<code>, </code>optional<code>) -- Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus. You can know which layers mapped to which device by checking the associated device_map: </code>model.hf_device_map`.",name:"layer_device_map(`Dict[int,"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1561"}}),ga=new Z({props:{anchor:"transformers.HybridCache.example",$$slots:{default:[xC]},$$scope:{ctx:j}}}),hc=new v({props:{name:"update",anchor:"transformers.HybridCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1701"}}),uc=new v({props:{name:"get_seq_length",anchor:"transformers.HybridCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1730"}}),fc=new v({props:{name:"reset",anchor:"transformers.HybridCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1741"}}),bc=new v({props:{name:"class transformers.SlidingWindowCache",anchor:"transformers.SlidingWindowCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"max_cache_len",val:": int = None"},{name:"device",val:": device = None"},{name:"dtype",val:": dtype = torch.float32"},{name:"max_batch_size",val:": typing.Optional[int] = None"},{name:"layer_device_map",val:": typing.Optional[typing.Dict[int, typing.Union[str, torch.device, int]]] = None"}],parametersDescription:[{anchor:"transformers.SlidingWindowCache.config",description:`<strong>config</strong> (<code>PretrainedConfig</code>) &#x2014;
The configuration file defining the shape-related attributes required to initialize the static cache.`,name:"config"},{anchor:"transformers.SlidingWindowCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"batch_size"},{anchor:"transformers.SlidingWindowCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.SlidingWindowCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.SlidingWindowCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.SlidingWindowCache.layer_device_map(`Dict[int,",description:"<strong>layer_device_map(`Dict[int,</strong> Union[str, torch.device, int]]]<code>, </code>optional<code>) -- Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus. You can know which layers mapped to which device by checking the associated device_map: </code>model.hf_device_map`.",name:"layer_device_map(`Dict[int,"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1244"}}),ua=new Z({props:{anchor:"transformers.SlidingWindowCache.example",$$slots:{default:[JC]},$$scope:{ctx:j}}}),_c=new v({props:{name:"update",anchor:"transformers.SlidingWindowCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1327"}}),yc=new v({props:{name:"reset",anchor:"transformers.SlidingWindowCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1377"}}),Tc=new v({props:{name:"class transformers.EncoderDecoderCache",anchor:"transformers.EncoderDecoderCache",parameters:[{name:"self_attention_cache",val:": Cache"},{name:"cross_attention_cache",val:": Cache"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1384"}}),fa=new Z({props:{anchor:"transformers.EncoderDecoderCache.example",$$slots:{default:[UC]},$$scope:{ctx:j}}}),Mc=new v({props:{name:"get_seq_length",anchor:"transformers.EncoderDecoderCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1472"}}),vc=new v({props:{name:"to_legacy_cache",anchor:"transformers.EncoderDecoderCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1441"}}),wc=new v({props:{name:"from_legacy_cache",anchor:"transformers.EncoderDecoderCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1453"}}),kc=new v({props:{name:"reset",anchor:"transformers.EncoderDecoderCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1477"}}),$c=new v({props:{name:"reorder_cache",anchor:"transformers.EncoderDecoderCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1492"}}),jc=new v({props:{name:"class transformers.MambaCache",anchor:"transformers.MambaCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"dtype",val:": dtype = torch.float16"},{name:"device",val:": typing.Union[torch.device, str, NoneType] = None"},{name:"max_batch_size",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.MambaCache.config",description:"<strong>config</strong> (`PretrainedConfig) &#x2014;\nThe configuration file defining the shape-related attributes required to initialize the static cache.",name:"config"},{anchor:"transformers.MambaCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"batch_size"},{anchor:"transformers.MambaCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float16</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.MambaCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.MambaCache.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>):
The default <code>dtype</code> used to initializing the cache.`,name:"dtype"},{anchor:"transformers.MambaCache.intermediate_size",description:`<strong>intermediate_size</strong> &#x2014; (<code>int</code>):
Model&#x2019;s intermediate_size taken from config.`,name:"intermediate_size"},{anchor:"transformers.MambaCache.ssm_state_size",description:`<strong>ssm_state_size</strong> &#x2014; (<code>int</code>):
Model&#x2019;s state_size taken from config.`,name:"ssm_state_size"},{anchor:"transformers.MambaCache.conv_kernel_size",description:`<strong>conv_kernel_size</strong> &#x2014; (<code>int</code>):
Model&#x2019;s convolution kernel size taken from config`,name:"conv_kernel_size"},{anchor:"transformers.MambaCache.conv_states",description:`<strong>conv_states</strong> &#x2014; (<code>torch.Tensor</code>):
A tensor of shape <code>[layer_idx, batch_size, intermediate_size, conv_kernel_size]</code> that holds convolutional states.`,name:"conv_states"},{anchor:"transformers.MambaCache.ssm_states",description:`<strong>ssm_states</strong> &#x2014; (<code>torch.Tensor</code>):
A tensor of shape <code>[layer_idx, batch_size, intermediate_size, ssm_state_size]</code> that holds ssm states`,name:"ssm_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1757"}}),Ma=new Z({props:{anchor:"transformers.MambaCache.example",$$slots:{default:[ZC]},$$scope:{ctx:j}}}),xc=new v({props:{name:"update_conv_state",anchor:"transformers.MambaCache.update_conv_state",parameters:[{name:"layer_idx",val:": int"},{name:"new_conv_state",val:": Tensor"},{name:"cache_position",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1844"}}),Jc=new v({props:{name:"update_ssm_state",anchor:"transformers.MambaCache.update_ssm_state",parameters:[{name:"layer_idx",val:": int"},{name:"new_ssm_state",val:": Tensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1856"}}),Uc=new v({props:{name:"reset",anchor:"transformers.MambaCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1860"}}),Zc=new se({props:{title:"Watermark Utils",local:"transformers.WatermarkingConfig",headingTag:"h2"}}),Cc=new v({props:{name:"class transformers.WatermarkingConfig",anchor:"transformers.WatermarkingConfig",parameters:[{name:"greenlist_ratio",val:": typing.Optional[float] = 0.25"},{name:"bias",val:": typing.Optional[float] = 2.0"},{name:"hashing_key",val:": typing.Optional[int] = 15485863"},{name:"seeding_scheme",val:": typing.Optional[str] = 'lefthash'"},{name:"context_width",val:": typing.Optional[int] = 1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L1415"}}),Wc=new v({props:{name:"__call__",anchor:"transformers.WatermarkingConfig.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Bc=new v({props:{name:"class transformers.WatermarkDetector",anchor:"transformers.WatermarkDetector",parameters:[{name:"model_config",val:": PretrainedConfig"},{name:"device",val:": str"},{name:"watermarking_config",val:": typing.Union[transformers.generation.configuration_utils.WatermarkingConfig, typing.Dict]"},{name:"ignore_repeated_ngrams",val:": bool = False"},{name:"max_cache_size",val:": int = 128"}],parametersDescription:[{anchor:"transformers.WatermarkDetector.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to get model specific arguments used when generating.`,name:"model_config"},{anchor:"transformers.WatermarkDetector.device",description:`<strong>device</strong> (<code>str</code>) &#x2014;
The device which was used during watermarked text generation.`,name:"device"},{anchor:"transformers.WatermarkDetector.watermarking_config",description:`<strong>watermarking_config</strong> (Union[<code>WatermarkingConfig</code>, <code>Dict</code>]) &#x2014;
The exact same watermarking config and arguments used when generating text.`,name:"watermarking_config"},{anchor:"transformers.WatermarkDetector.ignore_repeated_ngrams",description:`<strong>ignore_repeated_ngrams</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to count every unique ngram only once or not.`,name:"ignore_repeated_ngrams"},{anchor:"transformers.WatermarkDetector.max_cache_size",description:`<strong>max_cache_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The max size to be used for LRU caching of seeding/sampling algorithms called for every token.`,name:"max_cache_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L73"}}),wa=new Z({props:{anchor:"transformers.WatermarkDetector.example",$$slots:{default:[CC]},$$scope:{ctx:j}}}),Ic=new v({props:{name:"__call__",anchor:"transformers.WatermarkDetector.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"z_threshold",val:": float = 3.0"},{name:"return_dict",val:": bool = False"}],parametersDescription:[{anchor:"transformers.WatermarkDetector.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The watermark generated text. It is advised to remove the prompt, which can affect the detection.`,name:"input_ids"},{anchor:"transformers.WatermarkDetector.__call__.z_threshold",description:`<strong>z_threshold</strong> (<code>Dict</code>, <em>optional</em>, defaults to <code>3.0</code>) &#x2014;
Changing this threshold will change the sensitivity of the detector. Higher z threshold gives less
sensitivity and vice versa for lower z threshold.`,name:"z_threshold"},{anchor:"transformers.WatermarkDetector.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>,  <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return <code>~generation.WatermarkDetectorOutput</code> or not. If not it will return boolean predictions,`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L193",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>WatermarkDetectorOutput</code>
if <code>return_dict=True</code> otherwise a <code>np.array</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WatermarkDetectorOutput</code> or <code>np.array</code></p>
`}}),zc=new v({props:{name:"class transformers.BayesianDetectorConfig",anchor:"transformers.BayesianDetectorConfig",parameters:[{name:"watermarking_depth",val:": int = None"},{name:"base_rate",val:": float = 0.5"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BayesianDetectorConfig.watermarking_depth",description:`<strong>watermarking_depth</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of tournament layers.`,name:"watermarking_depth"},{anchor:"transformers.BayesianDetectorConfig.base_rate",description:`<strong>base_rate</strong> (<code>float1</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Prior probability P(w) that a text is watermarked.`,name:"base_rate"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L245"}}),Vc=new v({props:{name:"class transformers.BayesianDetectorModel",anchor:"transformers.BayesianDetectorModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.BayesianDetectorModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BayesianDetectorConfig">BayesianDetectorConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L352"}}),Gc=new v({props:{name:"forward",anchor:"transformers.BayesianDetectorModel.forward",parameters:[{name:"g_values",val:": Tensor"},{name:"mask",val:": Tensor"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"loss_batch_weight",val:" = 1"},{name:"return_dict",val:" = False"}],parametersDescription:[{anchor:"transformers.BayesianDetectorModel.forward.g_values",description:`<strong>g_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, seq_len, watermarking_depth, ...)</code>) &#x2014;
g-values (with values 0 or 1)`,name:"g_values"},{anchor:"transformers.BayesianDetectorModel.forward.mask",description:`<strong>mask</strong> &#x2014;
A binary array shape [batch_size, seq_len] indicating which g-values should be used. g-values with mask
value 0 are discarded.`,name:"mask"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L438",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>p(watermarked | g_values), of shape [batch_size].</p>
`}}),Fc=new v({props:{name:"class transformers.SynthIDTextWatermarkingConfig",anchor:"transformers.SynthIDTextWatermarkingConfig",parameters:[{name:"ngram_len",val:": int"},{name:"keys",val:": typing.List[int]"},{name:"context_history_size",val:": int = 1024"},{name:"sampling_table_seed",val:": int = 0"},{name:"sampling_table_size",val:": int = 65536"},{name:"skip_first_ngram_calls",val:": bool = False"},{name:"debug_mode",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkingConfig.ngram_len",description:`<strong>ngram_len</strong> (<code>int</code>) &#x2014;
Ngram length.`,name:"ngram_len"},{anchor:"transformers.SynthIDTextWatermarkingConfig.keys",description:`<strong>keys</strong> (<code>List[int]</code>) &#x2014;
A sequence of watermarking keys, one for each depth.`,name:"keys"},{anchor:"transformers.SynthIDTextWatermarkingConfig.context_history_size",description:`<strong>context_history_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Size of the tensor to keep track of seen contexts.`,name:"context_history_size"},{anchor:"transformers.SynthIDTextWatermarkingConfig.sampling_table_seed",description:`<strong>sampling_table_seed</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Random seed to generate the sampling table.`,name:"sampling_table_seed"},{anchor:"transformers.SynthIDTextWatermarkingConfig.sampling_table_size",description:`<strong>sampling_table_size</strong> (<code>int</code>, <em>optional</em>, defaults to 65536) &#x2014;
Size of the sampling table.`,name:"sampling_table_size"},{anchor:"transformers.SynthIDTextWatermarkingConfig.skip_first_ngram_calls",description:`<strong>skip_first_ngram_calls</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip first ngram calls.`,name:"skip_first_ngram_calls"},{anchor:"transformers.SynthIDTextWatermarkingConfig.debug_mode",description:`<strong>debug_mode</strong> (<code>bool</code>, optional, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Logits are modified to uniform one got before watermarking modification is applied. This is to test the
implementation.`,name:"debug_mode"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L1493"}}),ja=new Z({props:{anchor:"transformers.SynthIDTextWatermarkingConfig.example",$$slots:{default:[WC]},$$scope:{ctx:j}}}),Xc=new v({props:{name:"class transformers.SynthIDTextWatermarkDetector",anchor:"transformers.SynthIDTextWatermarkDetector",parameters:[{name:"detector_module",val:": BayesianDetectorModel"},{name:"logits_processor",val:": SynthIDTextWatermarkLogitsProcessor"},{name:"tokenizer",val:": typing.Any"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkDetector.detector_module",description:`<strong>detector_module</strong> (<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BayesianDetectorModel">BayesianDetectorModel</a>) &#x2014;
Bayesian detector module object initialized with parameters.
Check examples/research_projects/synthid_text/detector_training.py for usage.`,name:"detector_module"},{anchor:"transformers.SynthIDTextWatermarkDetector.logits_processor",description:`<strong>logits_processor</strong> (<code>SynthIDTextWatermarkLogitsProcessor</code>) &#x2014;
The logits processor used for watermarking.`,name:"logits_processor"},{anchor:"transformers.SynthIDTextWatermarkDetector.tokenizer",description:`<strong>tokenizer</strong> (<code>Any</code>) &#x2014;
The tokenizer used for the model.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L482"}}),xa=new Z({props:{anchor:"transformers.SynthIDTextWatermarkDetector.example",$$slots:{default:[BC]},$$scope:{ctx:j}}}),Rc=new v({props:{name:"__call__",anchor:"transformers.SynthIDTextWatermarkDetector.__call__",parameters:[{name:"tokenized_outputs",val:": Tensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L529"}}),Lc=new se({props:{title:"Compile Utils",local:"transformers.CompileConfig",headingTag:"h2"}}),Nc=new v({props:{name:"class transformers.CompileConfig",anchor:"transformers.CompileConfig",parameters:[{name:"fullgraph",val:": bool = True"},{name:"dynamic",val:": typing.Optional[bool] = None"},{name:"backend",val:": typing.Union[str, typing.Callable] = 'inductor'"},{name:"mode",val:": str = 'reduce-overhead'"},{name:"options",val:": typing.Optional[dict] = None"}],parametersDescription:[{anchor:"transformers.CompileConfig.fullgraph",description:`<strong>fullgraph</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If <code>True</code>, requires that the whole forward be capturable in a single graph.`,name:"fullgraph"},{anchor:"transformers.CompileConfig.dynamic",description:`<strong>dynamic</strong> (<code>bool</code> or <code>None</code>, <em>optional</em>) &#x2014;
Whether to try to use dynamic shape graphs.`,name:"dynamic"},{anchor:"transformers.CompileConfig.backend",description:`<strong>backend</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;inductor&quot;</code>) &#x2014;
Backend to be used.`,name:"backend"},{anchor:"transformers.CompileConfig.mode",description:`<strong>mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;reduce-overhead&quot;</code>) &#x2014;
Controls balance between performance and overhead.`,name:"mode"},{anchor:"transformers.CompileConfig.options",description:`<strong>options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A dictionary of options to pass to the backend.`,name:"options"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L1583"}}),Ja=new Z({props:{anchor:"transformers.CompileConfig.example",$$slots:{default:[IC]},$$scope:{ctx:j}}}),Sc=new v({props:{name:"__call__",anchor:"transformers.CompileConfig.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Hc=new IZ({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/internal/generation_utils.md"}}),{c(){i=o("meta"),$=a(),y=o("p"),d=a(),m(w.$$.fragment),s=a(),k=o("p"),k.innerHTML=K$,Ef=a(),m(La.$$.fragment),qf=a(),Na=o("p"),Na.innerHTML=ej,Df=a(),Sa=o("p"),Sa.textContent=tj,Qf=a(),m(Ha.$$.fragment),Yf=a(),Ea=o("p"),Ea.innerHTML=sj,Pf=a(),qa=o("ul"),qa.innerHTML=nj,Af=a(),Da=o("p"),Da.innerHTML=aj,Of=a(),Qa=o("p"),Qa.innerHTML=rj,Kf=a(),Ya=o("p"),Ya.innerHTML=oj,eb=a(),m(Pa.$$.fragment),tb=a(),Aa=o("p"),Aa.innerHTML=lj,sb=a(),Oa=o("p"),Oa.innerHTML=ij,nb=a(),Ka=o("p"),Ka.textContent=cj,ab=a(),m(er.$$.fragment),rb=a(),gs=o("div"),m(tr.$$.fragment),kT=a(),id=o("p"),id.textContent=dj,ob=a(),hs=o("div"),m(sr.$$.fragment),$T=a(),cd=o("p"),cd.textContent=pj,lb=a(),us=o("div"),m(nr.$$.fragment),jT=a(),dd=o("p"),dd.textContent=mj,ib=a(),fs=o("div"),m(ar.$$.fragment),xT=a(),pd=o("p"),pd.textContent=gj,cb=a(),m(rr.$$.fragment),db=a(),bs=o("div"),m(or.$$.fragment),JT=a(),md=o("p"),md.textContent=hj,pb=a(),_s=o("div"),m(lr.$$.fragment),UT=a(),gd=o("p"),gd.textContent=uj,mb=a(),ys=o("div"),m(ir.$$.fragment),ZT=a(),hd=o("p"),hd.textContent=fj,gb=a(),Ts=o("div"),m(cr.$$.fragment),CT=a(),ud=o("p"),ud.textContent=bj,hb=a(),Ms=o("div"),m(dr.$$.fragment),WT=a(),fd=o("p"),fd.textContent=_j,ub=a(),vs=o("div"),m(pr.$$.fragment),BT=a(),bd=o("p"),bd.textContent=yj,fb=a(),ws=o("div"),m(mr.$$.fragment),IT=a(),_d=o("p"),_d.textContent=Tj,bb=a(),ks=o("div"),m(gr.$$.fragment),zT=a(),yd=o("p"),yd.textContent=Mj,_b=a(),$s=o("div"),m(hr.$$.fragment),VT=a(),Td=o("p"),Td.textContent=vj,yb=a(),js=o("div"),m(ur.$$.fragment),GT=a(),Md=o("p"),Md.textContent=wj,Tb=a(),m(fr.$$.fragment),Mb=a(),tt=o("div"),m(br.$$.fragment),FT=a(),vd=o("p"),vd.textContent=kj,XT=a(),zs=o("div"),m(_r.$$.fragment),RT=a(),wd=o("p"),wd.textContent=$j,vb=a(),st=o("div"),m(yr.$$.fragment),LT=a(),kd=o("p"),kd.textContent=jj,NT=a(),Vs=o("div"),m(Tr.$$.fragment),ST=a(),$d=o("p"),$d.textContent=xj,wb=a(),nt=o("div"),m(Mr.$$.fragment),HT=a(),jd=o("p"),jd.textContent=Jj,ET=a(),Gs=o("div"),m(vr.$$.fragment),qT=a(),xd=o("p"),xd.textContent=Uj,kb=a(),m(wr.$$.fragment),$b=a(),kr=o("p"),kr.innerHTML=Zj,jb=a(),m($r.$$.fragment),xb=a(),ke=o("div"),m(jr.$$.fragment),DT=a(),Jd=o("p"),Jd.innerHTML=Cj,QT=a(),m(Fs.$$.fragment),YT=a(),Ud=o("div"),m(xr.$$.fragment),Jb=a(),N=o("div"),m(Jr.$$.fragment),PT=a(),Zd=o("p"),Zd.innerHTML=Wj,AT=a(),Cd=o("p"),Cd.innerHTML=Bj,OT=a(),m(Xs.$$.fragment),KT=a(),m(Rs.$$.fragment),eM=a(),Wd=o("div"),m(Ur.$$.fragment),Ub=a(),ne=o("div"),m(Zr.$$.fragment),tM=a(),Bd=o("p"),Bd.innerHTML=Ij,sM=a(),Id=o("p"),Id.textContent=zj,nM=a(),m(Ls.$$.fragment),aM=a(),zd=o("div"),m(Cr.$$.fragment),Zb=a(),ae=o("div"),m(Wr.$$.fragment),rM=a(),Vd=o("p"),Vd.innerHTML=Vj,oM=a(),Gd=o("p"),Gd.textContent=Gj,lM=a(),m(Ns.$$.fragment),iM=a(),Fd=o("div"),m(Br.$$.fragment),Cb=a(),$e=o("div"),m(Ir.$$.fragment),cM=a(),Xd=o("p"),Xd.innerHTML=Fj,dM=a(),m(Ss.$$.fragment),pM=a(),Rd=o("div"),m(zr.$$.fragment),Wb=a(),je=o("div"),m(Vr.$$.fragment),mM=a(),Ld=o("p"),Ld.innerHTML=Xj,gM=a(),m(Hs.$$.fragment),hM=a(),Nd=o("div"),m(Gr.$$.fragment),Bb=a(),xe=o("div"),m(Fr.$$.fragment),uM=a(),Sd=o("p"),Sd.innerHTML=Rj,fM=a(),m(Es.$$.fragment),bM=a(),Hd=o("div"),m(Xr.$$.fragment),Ib=a(),Je=o("div"),m(Rr.$$.fragment),_M=a(),Ed=o("p"),Ed.innerHTML=Lj,yM=a(),m(qs.$$.fragment),TM=a(),qd=o("div"),m(Lr.$$.fragment),zb=a(),Ue=o("div"),m(Nr.$$.fragment),MM=a(),Dd=o("p"),Dd.innerHTML=Nj,vM=a(),m(Ds.$$.fragment),wM=a(),Qd=o("div"),m(Sr.$$.fragment),Vb=a(),S=o("div"),m(Hr.$$.fragment),kM=a(),Yd=o("p"),Yd.innerHTML=Sj,$M=a(),Pd=o("p"),Pd.innerHTML=Hj,jM=a(),Ad=o("p"),Ad.innerHTML=Ej,xM=a(),m(Qs.$$.fragment),JM=a(),Od=o("div"),m(Er.$$.fragment),Gb=a(),Ze=o("div"),m(qr.$$.fragment),UM=a(),Kd=o("p"),Kd.innerHTML=qj,ZM=a(),ep=o("p"),ep.innerHTML=Dj,CM=a(),tp=o("div"),m(Dr.$$.fragment),Fb=a(),Ce=o("div"),m(Qr.$$.fragment),WM=a(),sp=o("p"),sp.innerHTML=Qj,BM=a(),m(Ys.$$.fragment),IM=a(),np=o("div"),m(Yr.$$.fragment),Xb=a(),at=o("div"),m(Pr.$$.fragment),zM=a(),ap=o("p"),ap.textContent=Yj,VM=a(),rp=o("div"),m(Ar.$$.fragment),Rb=a(),rt=o("div"),m(Or.$$.fragment),GM=a(),op=o("p"),op.innerHTML=Pj,FM=a(),lp=o("div"),m(Kr.$$.fragment),Lb=a(),We=o("div"),m(eo.$$.fragment),XM=a(),ip=o("p"),ip.innerHTML=Aj,RM=a(),m(Ps.$$.fragment),LM=a(),cp=o("div"),m(to.$$.fragment),Nb=a(),Be=o("div"),m(so.$$.fragment),NM=a(),dp=o("p"),dp.innerHTML=Oj,SM=a(),m(As.$$.fragment),HM=a(),pp=o("div"),m(no.$$.fragment),Sb=a(),H=o("div"),m(ao.$$.fragment),EM=a(),mp=o("p"),mp.innerHTML=Kj,qM=a(),gp=o("p"),gp.innerHTML=e0,DM=a(),hp=o("p"),hp.innerHTML=t0,QM=a(),m(Os.$$.fragment),YM=a(),up=o("div"),m(ro.$$.fragment),Hb=a(),re=o("div"),m(oo.$$.fragment),PM=a(),fp=o("p"),fp.innerHTML=s0,AM=a(),m(Ks.$$.fragment),OM=a(),m(en.$$.fragment),KM=a(),bp=o("div"),m(lo.$$.fragment),Eb=a(),oe=o("div"),m(io.$$.fragment),ev=a(),_p=o("p"),_p.innerHTML=n0,tv=a(),m(tn.$$.fragment),sv=a(),m(sn.$$.fragment),nv=a(),yp=o("div"),m(co.$$.fragment),qb=a(),Ie=o("div"),m(po.$$.fragment),av=a(),Tp=o("p"),Tp.innerHTML=a0,rv=a(),m(nn.$$.fragment),ov=a(),Mp=o("div"),m(mo.$$.fragment),Db=a(),le=o("div"),m(go.$$.fragment),lv=a(),vp=o("p"),vp.innerHTML=r0,iv=a(),wp=o("p"),wp.innerHTML=o0,cv=a(),m(an.$$.fragment),dv=a(),kp=o("div"),m(ho.$$.fragment),Qb=a(),ie=o("div"),m(uo.$$.fragment),pv=a(),$p=o("p"),$p.innerHTML=l0,mv=a(),m(rn.$$.fragment),gv=a(),m(on.$$.fragment),hv=a(),jp=o("div"),m(fo.$$.fragment),Yb=a(),ze=o("div"),m(bo.$$.fragment),uv=a(),xp=o("p"),xp.innerHTML=i0,fv=a(),m(ln.$$.fragment),bv=a(),Jp=o("div"),m(_o.$$.fragment),Pb=a(),Ve=o("div"),m(yo.$$.fragment),_v=a(),Up=o("p"),Up.innerHTML=c0,yv=a(),m(cn.$$.fragment),Tv=a(),Zp=o("div"),m(To.$$.fragment),Ab=a(),G=o("div"),m(Mo.$$.fragment),Mv=a(),Cp=o("p"),Cp.textContent=d0,vv=a(),Wp=o("p"),Wp.textContent=p0,wv=a(),Bp=o("ul"),Bp.innerHTML=m0,kv=a(),Ip=o("p"),Ip.innerHTML=g0,$v=a(),m(dn.$$.fragment),jv=a(),zp=o("div"),m(vo.$$.fragment),Ob=a(),ce=o("div"),m(wo.$$.fragment),xv=a(),Vp=o("p"),Vp.innerHTML=h0,Jv=a(),m(pn.$$.fragment),Uv=a(),m(mn.$$.fragment),Zv=a(),Gp=o("div"),m(ko.$$.fragment),Kb=a(),Ge=o("div"),m($o.$$.fragment),Cv=a(),Fp=o("p"),Fp.innerHTML=u0,Wv=a(),m(gn.$$.fragment),Bv=a(),Xp=o("div"),m(jo.$$.fragment),e_=a(),Fe=o("div"),m(xo.$$.fragment),Iv=a(),Rp=o("p"),Rp.innerHTML=f0,zv=a(),m(hn.$$.fragment),Vv=a(),Lp=o("div"),m(Jo.$$.fragment),t_=a(),de=o("div"),m(Uo.$$.fragment),Gv=a(),Np=o("p"),Np.innerHTML=b0,Fv=a(),Sp=o("p"),Sp.innerHTML=_0,Xv=a(),m(un.$$.fragment),Rv=a(),Hp=o("div"),m(Zo.$$.fragment),s_=a(),pe=o("div"),m(Co.$$.fragment),Lv=a(),Ep=o("p"),Ep.innerHTML=y0,Nv=a(),qp=o("p"),qp.innerHTML=T0,Sv=a(),m(fn.$$.fragment),Hv=a(),Dp=o("div"),m(Wo.$$.fragment),n_=a(),me=o("div"),m(Bo.$$.fragment),Ev=a(),Qp=o("p"),Qp.innerHTML=M0,qv=a(),Yp=o("p"),Yp.innerHTML=v0,Dv=a(),m(bn.$$.fragment),Qv=a(),Pp=o("div"),m(Io.$$.fragment),a_=a(),E=o("div"),m(zo.$$.fragment),Yv=a(),Ap=o("p"),Ap.innerHTML=w0,Pv=a(),Op=o("p"),Op.innerHTML=k0,Av=a(),Kp=o("p"),Kp.innerHTML=$0,Ov=a(),m(_n.$$.fragment),Kv=a(),em=o("div"),m(Vo.$$.fragment),r_=a(),m(Go.$$.fragment),o_=a(),ot=o("div"),m(Fo.$$.fragment),ew=a(),tm=o("p"),tm.innerHTML=j0,tw=a(),sm=o("div"),m(Xo.$$.fragment),l_=a(),lt=o("div"),m(Ro.$$.fragment),sw=a(),nm=o("p"),nm.innerHTML=x0,nw=a(),am=o("div"),m(Lo.$$.fragment),i_=a(),it=o("div"),m(No.$$.fragment),aw=a(),rm=o("p"),rm.innerHTML=J0,rw=a(),om=o("div"),m(So.$$.fragment),c_=a(),ct=o("div"),m(Ho.$$.fragment),ow=a(),lm=o("p"),lm.textContent=U0,lw=a(),yn=o("div"),m(Eo.$$.fragment),iw=a(),im=o("p"),im.textContent=Z0,d_=a(),dt=o("div"),m(qo.$$.fragment),cw=a(),cm=o("p"),cm.innerHTML=C0,dw=a(),dm=o("div"),m(Do.$$.fragment),p_=a(),pt=o("div"),m(Qo.$$.fragment),pw=a(),pm=o("p"),pm.textContent=W0,mw=a(),Tn=o("div"),m(Yo.$$.fragment),gw=a(),mm=o("p"),mm.textContent=B0,m_=a(),mt=o("div"),m(Po.$$.fragment),hw=a(),gm=o("p"),gm.innerHTML=I0,uw=a(),hm=o("div"),m(Ao.$$.fragment),g_=a(),gt=o("div"),m(Oo.$$.fragment),fw=a(),um=o("p"),um.innerHTML=z0,bw=a(),fm=o("div"),m(Ko.$$.fragment),h_=a(),ht=o("div"),m(el.$$.fragment),_w=a(),bm=o("p"),bm.innerHTML=V0,yw=a(),_m=o("div"),m(tl.$$.fragment),u_=a(),ut=o("div"),m(sl.$$.fragment),Tw=a(),ym=o("p"),ym.innerHTML=G0,Mw=a(),Tm=o("div"),m(nl.$$.fragment),f_=a(),ft=o("div"),m(al.$$.fragment),vw=a(),Mm=o("p"),Mm.innerHTML=F0,ww=a(),vm=o("div"),m(rl.$$.fragment),b_=a(),bt=o("div"),m(ol.$$.fragment),kw=a(),wm=o("p"),wm.innerHTML=X0,$w=a(),km=o("div"),m(ll.$$.fragment),__=a(),_t=o("div"),m(il.$$.fragment),jw=a(),$m=o("p"),$m.innerHTML=R0,xw=a(),jm=o("div"),m(cl.$$.fragment),y_=a(),yt=o("div"),m(dl.$$.fragment),Jw=a(),xm=o("p"),xm.innerHTML=L0,Uw=a(),Jm=o("div"),m(pl.$$.fragment),T_=a(),Tt=o("div"),m(ml.$$.fragment),Zw=a(),Um=o("p"),Um.innerHTML=N0,Cw=a(),Zm=o("div"),m(gl.$$.fragment),M_=a(),m(hl.$$.fragment),v_=a(),Mt=o("div"),m(ul.$$.fragment),Ww=a(),Cm=o("p"),Cm.innerHTML=S0,Bw=a(),Wm=o("div"),m(fl.$$.fragment),w_=a(),vt=o("div"),m(bl.$$.fragment),Iw=a(),Bm=o("p"),Bm.innerHTML=H0,zw=a(),Im=o("div"),m(_l.$$.fragment),k_=a(),wt=o("div"),m(yl.$$.fragment),Vw=a(),zm=o("p"),zm.innerHTML=E0,Gw=a(),Vm=o("div"),m(Tl.$$.fragment),$_=a(),kt=o("div"),m(Ml.$$.fragment),Fw=a(),Gm=o("p"),Gm.textContent=q0,Xw=a(),Mn=o("div"),m(vl.$$.fragment),Rw=a(),Fm=o("p"),Fm.textContent=D0,j_=a(),$t=o("div"),m(wl.$$.fragment),Lw=a(),Xm=o("p"),Xm.innerHTML=Q0,Nw=a(),Rm=o("div"),m(kl.$$.fragment),x_=a(),jt=o("div"),m($l.$$.fragment),Sw=a(),Lm=o("p"),Lm.textContent=Y0,Hw=a(),vn=o("div"),m(jl.$$.fragment),Ew=a(),Nm=o("p"),Nm.textContent=P0,J_=a(),xt=o("div"),m(xl.$$.fragment),qw=a(),Sm=o("p"),Sm.innerHTML=A0,Dw=a(),Hm=o("div"),m(Jl.$$.fragment),U_=a(),Jt=o("div"),m(Ul.$$.fragment),Qw=a(),Em=o("p"),Em.innerHTML=O0,Yw=a(),qm=o("div"),m(Zl.$$.fragment),Z_=a(),Ut=o("div"),m(Cl.$$.fragment),Pw=a(),Dm=o("p"),Dm.innerHTML=K0,Aw=a(),Qm=o("div"),m(Wl.$$.fragment),C_=a(),Zt=o("div"),m(Bl.$$.fragment),Ow=a(),Ym=o("p"),Ym.innerHTML=ex,Kw=a(),Pm=o("div"),m(Il.$$.fragment),W_=a(),Ct=o("div"),m(zl.$$.fragment),e2=a(),Am=o("p"),Am.innerHTML=tx,t2=a(),Om=o("div"),m(Vl.$$.fragment),B_=a(),Wt=o("div"),m(Gl.$$.fragment),s2=a(),Km=o("p"),Km.innerHTML=sx,n2=a(),eg=o("div"),m(Fl.$$.fragment),I_=a(),Bt=o("div"),m(Xl.$$.fragment),a2=a(),tg=o("p"),tg.innerHTML=nx,r2=a(),sg=o("div"),m(Rl.$$.fragment),z_=a(),m(Ll.$$.fragment),V_=a(),Nl=o("p"),Nl.innerHTML=ax,G_=a(),Xe=o("div"),m(Sl.$$.fragment),o2=a(),ng=o("p"),ng.textContent=rx,l2=a(),ag=o("p"),ag.innerHTML=ox,i2=a(),rg=o("div"),m(Hl.$$.fragment),F_=a(),xs=o("div"),m(El.$$.fragment),c2=a(),og=o("div"),m(ql.$$.fragment),X_=a(),It=o("div"),m(Dl.$$.fragment),d2=a(),lg=o("p"),lg.innerHTML=lx,p2=a(),ig=o("div"),m(Ql.$$.fragment),R_=a(),zt=o("div"),m(Yl.$$.fragment),m2=a(),cg=o("p"),cg.innerHTML=ix,g2=a(),dg=o("div"),m(Pl.$$.fragment),L_=a(),J=o("div"),m(Al.$$.fragment),h2=a(),pg=o("p"),pg.textContent=cx,u2=a(),mg=o("p"),mg.textContent=dx,f2=a(),gg=o("ul"),gg.innerHTML=px,b2=a(),hg=o("p"),hg.textContent=mx,_2=a(),ug=o("ul"),ug.innerHTML=gx,y2=a(),fg=o("p"),fg.textContent=hx,T2=a(),bg=o("p"),bg.textContent=ux,M2=a(),_g=o("p"),_g.textContent=fx,v2=a(),yg=o("ul"),yg.innerHTML=bx,w2=a(),Tg=o("p"),Tg.textContent=_x,k2=a(),Mg=o("p"),Mg.textContent=yx,$2=a(),vg=o("p"),vg.textContent=Tx,j2=a(),wg=o("p"),wg.textContent=Mx,x2=a(),kg=o("ul"),kg.innerHTML=vx,J2=a(),$g=o("p"),$g.textContent=wx,U2=a(),jg=o("p"),jg.textContent=kx,Z2=a(),xg=o("ul"),xg.innerHTML=$x,C2=a(),Jg=o("p"),Jg.textContent=jx,W2=a(),Ug=o("p"),Ug.textContent=xx,B2=a(),m(wn.$$.fragment),I2=a(),Zg=o("div"),m(Ol.$$.fragment),N_=a(),Vt=o("div"),m(Kl.$$.fragment),z2=a(),Cg=o("p"),Cg.innerHTML=Jx,V2=a(),Wg=o("div"),m(ei.$$.fragment),S_=a(),m(ti.$$.fragment),H_=a(),si=o("p"),si.innerHTML=Ux,E_=a(),W=o("div"),m(ni.$$.fragment),G2=a(),Bg=o("p"),Bg.textContent=Zx,F2=a(),Ig=o("p"),Ig.textContent=Cx,X2=a(),m(kn.$$.fragment),R2=a(),zg=o("p"),zg.textContent=Wx,L2=a(),$n=o("div"),m(ai.$$.fragment),N2=a(),Vg=o("p"),Vg.textContent=Bx,S2=a(),jn=o("div"),m(ri.$$.fragment),H2=a(),Gg=o("p"),Gg.textContent=Ix,E2=a(),xn=o("div"),m(oi.$$.fragment),q2=a(),Fg=o("p"),Fg.textContent=zx,D2=a(),Jn=o("div"),m(li.$$.fragment),Q2=a(),Xg=o("p"),Xg.innerHTML=Vx,Y2=a(),Un=o("div"),m(ii.$$.fragment),P2=a(),Rg=o("p"),Rg.textContent=Gx,A2=a(),Zn=o("div"),m(ci.$$.fragment),O2=a(),Lg=o("p"),Lg.textContent=Fx,K2=a(),es=o("div"),m(di.$$.fragment),ek=a(),Ng=o("p"),Ng.innerHTML=Xx,tk=a(),Sg=o("p"),Sg.textContent=Rx,q_=a(),Js=o("div"),m(pi.$$.fragment),sk=a(),Hg=o("p"),Hg.innerHTML=Lx,D_=a(),Us=o("div"),m(mi.$$.fragment),nk=a(),Eg=o("p"),Eg.innerHTML=Nx,Q_=a(),Re=o("div"),m(gi.$$.fragment),ak=a(),qg=o("p"),qg.textContent=Sx,rk=a(),K=o("div"),m(hi.$$.fragment),ok=a(),Dg=o("p"),Dg.textContent=Hx,lk=a(),Qg=o("p"),Qg.innerHTML=Ex,ik=a(),Yg=o("p"),Yg.innerHTML=qx,ck=a(),Pg=o("p"),Pg.innerHTML=Dx,dk=a(),Ag=o("p"),Ag.textContent=Qx,pk=a(),Cn=o("div"),m(ui.$$.fragment),mk=a(),Og=o("p"),Og.textContent=Yx,Y_=a(),m(fi.$$.fragment),P_=a(),Le=o("div"),m(bi.$$.fragment),gk=a(),Kg=o("p"),Kg.innerHTML=Px,hk=a(),eh=o("div"),m(_i.$$.fragment),uk=a(),th=o("div"),m(yi.$$.fragment),A_=a(),q=o("div"),m(Ti.$$.fragment),fk=a(),sh=o("p"),sh.innerHTML=Ax,bk=a(),nh=o("p"),nh.innerHTML=Ox,_k=a(),ah=o("p"),ah.innerHTML=Kx,yk=a(),rh=o("div"),m(Mi.$$.fragment),Tk=a(),oh=o("div"),m(vi.$$.fragment),O_=a(),Ne=o("div"),m(wi.$$.fragment),Mk=a(),lh=o("p"),lh.innerHTML=eJ,vk=a(),ih=o("div"),m(ki.$$.fragment),wk=a(),ch=o("div"),m($i.$$.fragment),K_=a(),m(ji.$$.fragment),ey=a(),F=o("div"),m(xi.$$.fragment),kk=a(),dh=o("p"),dh.textContent=tJ,$k=a(),m(Wn.$$.fragment),jk=a(),m(Bn.$$.fragment),xk=a(),In=o("div"),m(Ji.$$.fragment),Jk=a(),ph=o("p"),ph.textContent=sJ,Uk=a(),zn=o("div"),m(Ui.$$.fragment),Zk=a(),mh=o("p"),mh.textContent=nJ,Ck=a(),Vn=o("div"),m(Zi.$$.fragment),Wk=a(),gh=o("p"),gh.textContent=aJ,ty=a(),ge=o("div"),m(Ci.$$.fragment),Bk=a(),hh=o("p"),hh.textContent=rJ,Ik=a(),m(Gn.$$.fragment),zk=a(),m(Fn.$$.fragment),Vk=a(),Xn=o("div"),m(Wi.$$.fragment),Gk=a(),uh=o("p"),uh.textContent=oJ,sy=a(),m(Bi.$$.fragment),ny=a(),Gt=o("div"),m(Ii.$$.fragment),Fk=a(),fh=o("p"),fh.textContent=lJ,Xk=a(),Rn=o("div"),m(zi.$$.fragment),Rk=a(),bh=o("p"),bh.innerHTML=iJ,ay=a(),Ft=o("div"),m(Vi.$$.fragment),Lk=a(),_h=o("p"),_h.textContent=cJ,Nk=a(),Ln=o("div"),m(Gi.$$.fragment),Sk=a(),yh=o("p"),yh.innerHTML=dJ,ry=a(),Xt=o("div"),m(Fi.$$.fragment),Hk=a(),Th=o("p"),Th.textContent=pJ,Ek=a(),Nn=o("div"),m(Xi.$$.fragment),qk=a(),Mh=o("p"),Mh.textContent=mJ,oy=a(),I=o("div"),m(Ri.$$.fragment),Dk=a(),vh=o("p"),vh.textContent=gJ,Qk=a(),wh=o("p"),wh.innerHTML=hJ,Yk=a(),m(Sn.$$.fragment),Pk=a(),Hn=o("div"),m(Li.$$.fragment),Ak=a(),kh=o("p"),kh.innerHTML=uJ,Ok=a(),En=o("div"),m(Ni.$$.fragment),Kk=a(),$h=o("p"),$h.textContent=fJ,e1=a(),qn=o("div"),m(Si.$$.fragment),t1=a(),jh=o("p"),jh.textContent=bJ,s1=a(),Dn=o("div"),m(Hi.$$.fragment),n1=a(),xh=o("p"),xh.innerHTML=_J,a1=a(),Qn=o("div"),m(Ei.$$.fragment),r1=a(),Jh=o("p"),Jh.innerHTML=yJ,ly=a(),D=o("div"),m(qi.$$.fragment),o1=a(),Uh=o("p"),Uh.innerHTML=TJ,l1=a(),Zh=o("p"),Zh.innerHTML=MJ,i1=a(),Ch=o("p"),Ch.innerHTML=vJ,c1=a(),Wh=o("div"),m(Di.$$.fragment),d1=a(),Yn=o("div"),m(Qi.$$.fragment),p1=a(),Bh=o("p"),Bh.textContent=wJ,iy=a(),Rt=o("div"),m(Yi.$$.fragment),m1=a(),Ih=o("p"),Ih.innerHTML=kJ,g1=a(),m(Pn.$$.fragment),cy=a(),Lt=o("div"),m(Pi.$$.fragment),h1=a(),zh=o("p"),zh.innerHTML=$J,u1=a(),m(An.$$.fragment),dy=a(),X=o("div"),m(Ai.$$.fragment),f1=a(),Vh=o("p"),Vh.innerHTML=jJ,b1=a(),Gh=o("p"),Gh.innerHTML=xJ,_1=a(),m(On.$$.fragment),y1=a(),Kn=o("div"),m(Oi.$$.fragment),T1=a(),Fh=o("p"),Fh.innerHTML=JJ,M1=a(),ea=o("div"),m(Ki.$$.fragment),v1=a(),Xh=o("p"),Xh.textContent=UJ,w1=a(),ta=o("div"),m(ec.$$.fragment),k1=a(),Rh=o("p"),Rh.textContent=ZJ,py=a(),Q=o("div"),m(tc.$$.fragment),$1=a(),Lh=o("p"),Lh.textContent=CJ,j1=a(),Nh=o("p"),Nh.textContent=WJ,x1=a(),sa=o("div"),m(sc.$$.fragment),J1=a(),Sh=o("p"),Sh.innerHTML=BJ,U1=a(),na=o("div"),m(nc.$$.fragment),Z1=a(),Hh=o("p"),Hh.textContent=IJ,C1=a(),aa=o("div"),m(ac.$$.fragment),W1=a(),Eh=o("p"),Eh.textContent=zJ,my=a(),Y=o("div"),m(rc.$$.fragment),B1=a(),qh=o("p"),qh.innerHTML=VJ,I1=a(),m(ra.$$.fragment),z1=a(),oa=o("div"),m(oc.$$.fragment),V1=a(),Dh=o("p"),Dh.innerHTML=GJ,G1=a(),la=o("div"),m(lc.$$.fragment),F1=a(),Qh=o("p"),Qh.textContent=FJ,X1=a(),ia=o("div"),m(ic.$$.fragment),R1=a(),Yh=o("p"),Yh.textContent=XJ,gy=a(),P=o("div"),m(cc.$$.fragment),L1=a(),Ph=o("p"),Ph.innerHTML=RJ,N1=a(),m(ca.$$.fragment),S1=a(),da=o("div"),m(dc.$$.fragment),H1=a(),Ah=o("p"),Ah.innerHTML=LJ,E1=a(),pa=o("div"),m(pc.$$.fragment),q1=a(),Oh=o("p"),Oh.textContent=NJ,D1=a(),ma=o("div"),m(mc.$$.fragment),Q1=a(),Kh=o("p"),Kh.textContent=SJ,hy=a(),A=o("div"),m(gc.$$.fragment),Y1=a(),eu=o("p"),eu.innerHTML=HJ,P1=a(),m(ga.$$.fragment),A1=a(),tu=o("div"),m(hc.$$.fragment),O1=a(),su=o("div"),m(uc.$$.fragment),K1=a(),ha=o("div"),m(fc.$$.fragment),e$=a(),nu=o("p"),nu.textContent=EJ,uy=a(),z=o("div"),m(bc.$$.fragment),t$=a(),au=o("p"),au.innerHTML=qJ,s$=a(),ru=o("p"),ru.innerHTML=DJ,n$=a(),ou=o("p"),ou.textContent=QJ,a$=a(),lu=o("p"),lu.innerHTML=YJ,r$=a(),m(ua.$$.fragment),o$=a(),iu=o("div"),m(_c.$$.fragment),l$=a(),cu=o("div"),m(yc.$$.fragment),fy=a(),V=o("div"),m(Tc.$$.fragment),i$=a(),du=o("p"),du.textContent=PJ,c$=a(),m(fa.$$.fragment),d$=a(),ba=o("div"),m(Mc.$$.fragment),p$=a(),pu=o("p"),pu.textContent=AJ,m$=a(),_a=o("div"),m(vc.$$.fragment),g$=a(),mu=o("p"),mu.innerHTML=OJ,h$=a(),ya=o("div"),m(wc.$$.fragment),u$=a(),gu=o("p"),gu.innerHTML=KJ,f$=a(),hu=o("div"),m(kc.$$.fragment),b$=a(),Ta=o("div"),m($c.$$.fragment),_$=a(),uu=o("p"),uu.textContent=eU,by=a(),O=o("div"),m(jc.$$.fragment),y$=a(),fu=o("p"),fu.textContent=tU,T$=a(),m(Ma.$$.fragment),M$=a(),bu=o("div"),m(xc.$$.fragment),v$=a(),_u=o("div"),m(Jc.$$.fragment),w$=a(),yu=o("div"),m(Uc.$$.fragment),_y=a(),m(Zc.$$.fragment),yy=a(),he=o("div"),m(Cc.$$.fragment),k$=a(),Tu=o("p"),Tu.innerHTML=sU,$$=a(),Mu=o("p"),Mu.textContent=nU,j$=a(),vu=o("ul"),vu.innerHTML=aU,x$=a(),va=o("div"),m(Wc.$$.fragment),J$=a(),wu=o("p"),wu.textContent=rU,Ty=a(),ue=o("div"),m(Bc.$$.fragment),U$=a(),ku=o("p"),ku.innerHTML=oU,Z$=a(),$u=o("p"),$u.innerHTML=lU,C$=a(),m(wa.$$.fragment),W$=a(),ka=o("div"),m(Ic.$$.fragment),B$=a(),ju=o("p"),ju.textContent=iU,My=a(),Nt=o("div"),m(zc.$$.fragment),I$=a(),xu=o("p"),xu.innerHTML=cU,z$=a(),Ju=o("p"),Ju.innerHTML=dU,vy=a(),R=o("div"),m(Vc.$$.fragment),V$=a(),Uu=o("p"),Uu.textContent=pU,G$=a(),Zu=o("p"),Zu.innerHTML=mU,F$=a(),Cu=o("p"),Cu.textContent=gU,X$=a(),Wu=o("p"),Wu.innerHTML=hU,R$=a(),Bu=o("p"),Bu.innerHTML=uU,L$=a(),$a=o("div"),m(Gc.$$.fragment),N$=a(),Iu=o("p"),Iu.textContent=fU,wy=a(),St=o("div"),m(Fc.$$.fragment),S$=a(),zu=o("p"),zu.innerHTML=bU,H$=a(),m(ja.$$.fragment),ky=a(),fe=o("div"),m(Xc.$$.fragment),E$=a(),Vu=o("p"),Vu.textContent=_U,q$=a(),Gu=o("p"),Gu.textContent=yU,D$=a(),m(xa.$$.fragment),Q$=a(),Fu=o("div"),m(Rc.$$.fragment),$y=a(),m(Lc.$$.fragment),jy=a(),Se=o("div"),m(Nc.$$.fragment),Y$=a(),Xu=o("p"),Xu.innerHTML=TU,P$=a(),m(Ja.$$.fragment),A$=a(),Ua=o("div"),m(Sc.$$.fragment),O$=a(),Ru=o("p"),Ru.textContent=MU,xy=a(),m(Hc.$$.fragment),Jy=a(),xf=o("p"),this.h()},l(e){const c=BZ("svelte-u9bgzb",document.head);i=l(c,"META",{name:!0,content:!0}),c.forEach(n),$=r(e),y=l(e,"P",{}),T(y).forEach(n),d=r(e),g(w.$$.fragment,e),s=r(e),k=l(e,"P",{"data-svelte-h":!0}),_(k)!=="svelte-1bcp7t6"&&(k.innerHTML=K$),Ef=r(e),g(La.$$.fragment,e),qf=r(e),Na=l(e,"P",{"data-svelte-h":!0}),_(Na)!=="svelte-18ep3y6"&&(Na.innerHTML=ej),Df=r(e),Sa=l(e,"P",{"data-svelte-h":!0}),_(Sa)!=="svelte-wwwyth"&&(Sa.textContent=tj),Qf=r(e),g(Ha.$$.fragment,e),Yf=r(e),Ea=l(e,"P",{"data-svelte-h":!0}),_(Ea)!=="svelte-1xs4157"&&(Ea.innerHTML=sj),Pf=r(e),qa=l(e,"UL",{"data-svelte-h":!0}),_(qa)!=="svelte-1arpy9m"&&(qa.innerHTML=nj),Af=r(e),Da=l(e,"P",{"data-svelte-h":!0}),_(Da)!=="svelte-xh59rv"&&(Da.innerHTML=aj),Of=r(e),Qa=l(e,"P",{"data-svelte-h":!0}),_(Qa)!=="svelte-rqavqw"&&(Qa.innerHTML=rj),Kf=r(e),Ya=l(e,"P",{"data-svelte-h":!0}),_(Ya)!=="svelte-qr02he"&&(Ya.innerHTML=oj),eb=r(e),g(Pa.$$.fragment,e),tb=r(e),Aa=l(e,"P",{"data-svelte-h":!0}),_(Aa)!=="svelte-114v74y"&&(Aa.innerHTML=lj),sb=r(e),Oa=l(e,"P",{"data-svelte-h":!0}),_(Oa)!=="svelte-13knclg"&&(Oa.innerHTML=ij),nb=r(e),Ka=l(e,"P",{"data-svelte-h":!0}),_(Ka)!=="svelte-gz8gow"&&(Ka.textContent=cj),ab=r(e),g(er.$$.fragment,e),rb=r(e),gs=l(e,"DIV",{class:!0});var Ec=T(gs);g(tr.$$.fragment,Ec),kT=r(Ec),id=l(Ec,"P",{"data-svelte-h":!0}),_(id)!=="svelte-k7oes3"&&(id.textContent=dj),Ec.forEach(n),ob=r(e),hs=l(e,"DIV",{class:!0});var qc=T(hs);g(sr.$$.fragment,qc),$T=r(qc),cd=l(qc,"P",{"data-svelte-h":!0}),_(cd)!=="svelte-111f3sj"&&(cd.textContent=pj),qc.forEach(n),lb=r(e),us=l(e,"DIV",{class:!0});var Dc=T(us);g(nr.$$.fragment,Dc),jT=r(Dc),dd=l(Dc,"P",{"data-svelte-h":!0}),_(dd)!=="svelte-1j3b9cp"&&(dd.textContent=mj),Dc.forEach(n),ib=r(e),fs=l(e,"DIV",{class:!0});var Qc=T(fs);g(ar.$$.fragment,Qc),xT=r(Qc),pd=l(Qc,"P",{"data-svelte-h":!0}),_(pd)!=="svelte-16r5px1"&&(pd.textContent=gj),Qc.forEach(n),cb=r(e),g(rr.$$.fragment,e),db=r(e),bs=l(e,"DIV",{class:!0});var Yc=T(bs);g(or.$$.fragment,Yc),JT=r(Yc),md=l(Yc,"P",{"data-svelte-h":!0}),_(md)!=="svelte-1bnrp61"&&(md.textContent=hj),Yc.forEach(n),pb=r(e),_s=l(e,"DIV",{class:!0});var Pc=T(_s);g(lr.$$.fragment,Pc),UT=r(Pc),gd=l(Pc,"P",{"data-svelte-h":!0}),_(gd)!=="svelte-fenhkk"&&(gd.textContent=uj),Pc.forEach(n),mb=r(e),ys=l(e,"DIV",{class:!0});var Ac=T(ys);g(ir.$$.fragment,Ac),ZT=r(Ac),hd=l(Ac,"P",{"data-svelte-h":!0}),_(hd)!=="svelte-1dqtgq4"&&(hd.textContent=fj),Ac.forEach(n),gb=r(e),Ts=l(e,"DIV",{class:!0});var Oc=T(Ts);g(cr.$$.fragment,Oc),CT=r(Oc),ud=l(Oc,"P",{"data-svelte-h":!0}),_(ud)!=="svelte-10orfv5"&&(ud.textContent=bj),Oc.forEach(n),hb=r(e),Ms=l(e,"DIV",{class:!0});var Kc=T(Ms);g(dr.$$.fragment,Kc),WT=r(Kc),fd=l(Kc,"P",{"data-svelte-h":!0}),_(fd)!=="svelte-jg8udg"&&(fd.textContent=_j),Kc.forEach(n),ub=r(e),vs=l(e,"DIV",{class:!0});var ed=T(vs);g(pr.$$.fragment,ed),BT=r(ed),bd=l(ed,"P",{"data-svelte-h":!0}),_(bd)!=="svelte-1i40667"&&(bd.textContent=yj),ed.forEach(n),fb=r(e),ws=l(e,"DIV",{class:!0});var td=T(ws);g(mr.$$.fragment,td),IT=r(td),_d=l(td,"P",{"data-svelte-h":!0}),_(_d)!=="svelte-n5fi8x"&&(_d.textContent=Tj),td.forEach(n),bb=r(e),ks=l(e,"DIV",{class:!0});var sd=T(ks);g(gr.$$.fragment,sd),zT=r(sd),yd=l(sd,"P",{"data-svelte-h":!0}),_(yd)!=="svelte-h5pj3l"&&(yd.textContent=Mj),sd.forEach(n),_b=r(e),$s=l(e,"DIV",{class:!0});var nd=T($s);g(hr.$$.fragment,nd),VT=r(nd),Td=l(nd,"P",{"data-svelte-h":!0}),_(Td)!=="svelte-b9zq6n"&&(Td.textContent=vj),nd.forEach(n),yb=r(e),js=l(e,"DIV",{class:!0});var ad=T(js);g(ur.$$.fragment,ad),GT=r(ad),Md=l(ad,"P",{"data-svelte-h":!0}),_(Md)!=="svelte-pru3ks"&&(Md.textContent=wj),ad.forEach(n),Tb=r(e),g(fr.$$.fragment,e),Mb=r(e),tt=l(e,"DIV",{class:!0});var Zs=T(tt);g(br.$$.fragment,Zs),FT=r(Zs),vd=l(Zs,"P",{"data-svelte-h":!0}),_(vd)!=="svelte-qoov36"&&(vd.textContent=kj),XT=r(Zs),zs=l(Zs,"DIV",{class:!0});var rd=T(zs);g(_r.$$.fragment,rd),RT=r(rd),wd=l(rd,"P",{"data-svelte-h":!0}),_(wd)!=="svelte-5ihtpa"&&(wd.textContent=$j),rd.forEach(n),Zs.forEach(n),vb=r(e),st=l(e,"DIV",{class:!0});var Cs=T(st);g(yr.$$.fragment,Cs),LT=r(Cs),kd=l(Cs,"P",{"data-svelte-h":!0}),_(kd)!=="svelte-1tz7qrd"&&(kd.textContent=jj),NT=r(Cs),Vs=l(Cs,"DIV",{class:!0});var od=T(Vs);g(Tr.$$.fragment,od),ST=r(od),$d=l(od,"P",{"data-svelte-h":!0}),_($d)!=="svelte-5ihtpa"&&($d.textContent=xj),od.forEach(n),Cs.forEach(n),wb=r(e),nt=l(e,"DIV",{class:!0});var Ws=T(nt);g(Mr.$$.fragment,Ws),HT=r(Ws),jd=l(Ws,"P",{"data-svelte-h":!0}),_(jd)!=="svelte-1tz7qrd"&&(jd.textContent=Jj),ET=r(Ws),Gs=l(Ws,"DIV",{class:!0});var ld=T(Gs);g(vr.$$.fragment,ld),qT=r(ld),xd=l(ld,"P",{"data-svelte-h":!0}),_(xd)!=="svelte-5ihtpa"&&(xd.textContent=Uj),ld.forEach(n),Ws.forEach(n),kb=r(e),g(wr.$$.fragment,e),$b=r(e),kr=l(e,"P",{"data-svelte-h":!0}),_(kr)!=="svelte-1mhr04t"&&(kr.innerHTML=Zj),jb=r(e),g($r.$$.fragment,e),xb=r(e),ke=l(e,"DIV",{class:!0});var Ht=T(ke);g(jr.$$.fragment,Ht),DT=r(Ht),Jd=l(Ht,"P",{"data-svelte-h":!0}),_(Jd)!=="svelte-r0ppk6"&&(Jd.innerHTML=Cj),QT=r(Ht),g(Fs.$$.fragment,Ht),YT=r(Ht),Ud=l(Ht,"DIV",{class:!0});var Jf=T(Ud);g(xr.$$.fragment,Jf),Jf.forEach(n),Ht.forEach(n),Jb=r(e),N=l(e,"DIV",{class:!0});var be=T(N);g(Jr.$$.fragment,be),PT=r(be),Zd=l(be,"P",{"data-svelte-h":!0}),_(Zd)!=="svelte-3t2r7l"&&(Zd.innerHTML=Wj),AT=r(be),Cd=l(be,"P",{"data-svelte-h":!0}),_(Cd)!=="svelte-lu7kru"&&(Cd.innerHTML=Bj),OT=r(be),g(Xs.$$.fragment,be),KT=r(be),g(Rs.$$.fragment,be),eM=r(be),Wd=l(be,"DIV",{class:!0});var Uf=T(Wd);g(Ur.$$.fragment,Uf),Uf.forEach(n),be.forEach(n),Ub=r(e),ne=l(e,"DIV",{class:!0});var He=T(ne);g(Zr.$$.fragment,He),tM=r(He),Bd=l(He,"P",{"data-svelte-h":!0}),_(Bd)!=="svelte-jnv1x5"&&(Bd.innerHTML=Ij),sM=r(He),Id=l(He,"P",{"data-svelte-h":!0}),_(Id)!=="svelte-mpy00q"&&(Id.textContent=zj),nM=r(He),g(Ls.$$.fragment,He),aM=r(He),zd=l(He,"DIV",{class:!0});var Zf=T(zd);g(Cr.$$.fragment,Zf),Zf.forEach(n),He.forEach(n),Zb=r(e),ae=l(e,"DIV",{class:!0});var Ee=T(ae);g(Wr.$$.fragment,Ee),rM=r(Ee),Vd=l(Ee,"P",{"data-svelte-h":!0}),_(Vd)!=="svelte-hixi53"&&(Vd.innerHTML=Vj),oM=r(Ee),Gd=l(Ee,"P",{"data-svelte-h":!0}),_(Gd)!=="svelte-3qpgm7"&&(Gd.textContent=Gj),lM=r(Ee),g(Ns.$$.fragment,Ee),iM=r(Ee),Fd=l(Ee,"DIV",{class:!0});var Cf=T(Fd);g(Br.$$.fragment,Cf),Cf.forEach(n),Ee.forEach(n),Cb=r(e),$e=l(e,"DIV",{class:!0});var Et=T($e);g(Ir.$$.fragment,Et),cM=r(Et),Xd=l(Et,"P",{"data-svelte-h":!0}),_(Xd)!=="svelte-y33f0y"&&(Xd.innerHTML=Fj),dM=r(Et),g(Ss.$$.fragment,Et),pM=r(Et),Rd=l(Et,"DIV",{class:!0});var Wf=T(Rd);g(zr.$$.fragment,Wf),Wf.forEach(n),Et.forEach(n),Wb=r(e),je=l(e,"DIV",{class:!0});var qt=T(je);g(Vr.$$.fragment,qt),mM=r(qt),Ld=l(qt,"P",{"data-svelte-h":!0}),_(Ld)!=="svelte-erurzh"&&(Ld.innerHTML=Xj),gM=r(qt),g(Hs.$$.fragment,qt),hM=r(qt),Nd=l(qt,"DIV",{class:!0});var Bf=T(Nd);g(Gr.$$.fragment,Bf),Bf.forEach(n),qt.forEach(n),Bb=r(e),xe=l(e,"DIV",{class:!0});var Dt=T(xe);g(Fr.$$.fragment,Dt),uM=r(Dt),Sd=l(Dt,"P",{"data-svelte-h":!0}),_(Sd)!=="svelte-zac23"&&(Sd.innerHTML=Rj),fM=r(Dt),g(Es.$$.fragment,Dt),bM=r(Dt),Hd=l(Dt,"DIV",{class:!0});var If=T(Hd);g(Xr.$$.fragment,If),If.forEach(n),Dt.forEach(n),Ib=r(e),Je=l(e,"DIV",{class:!0});var Qt=T(Je);g(Rr.$$.fragment,Qt),_M=r(Qt),Ed=l(Qt,"P",{"data-svelte-h":!0}),_(Ed)!=="svelte-1xemmef"&&(Ed.innerHTML=Lj),yM=r(Qt),g(qs.$$.fragment,Qt),TM=r(Qt),qd=l(Qt,"DIV",{class:!0});var zf=T(qd);g(Lr.$$.fragment,zf),zf.forEach(n),Qt.forEach(n),zb=r(e),Ue=l(e,"DIV",{class:!0});var Yt=T(Ue);g(Nr.$$.fragment,Yt),MM=r(Yt),Dd=l(Yt,"P",{"data-svelte-h":!0}),_(Dd)!=="svelte-1ideb0b"&&(Dd.innerHTML=Nj),vM=r(Yt),g(Ds.$$.fragment,Yt),wM=r(Yt),Qd=l(Yt,"DIV",{class:!0});var Vf=T(Qd);g(Sr.$$.fragment,Vf),Vf.forEach(n),Yt.forEach(n),Vb=r(e),S=l(e,"DIV",{class:!0});var _e=T(S);g(Hr.$$.fragment,_e),kM=r(_e),Yd=l(_e,"P",{"data-svelte-h":!0}),_(Yd)!=="svelte-gr8gnh"&&(Yd.innerHTML=Sj),$M=r(_e),Pd=l(_e,"P",{"data-svelte-h":!0}),_(Pd)!=="svelte-1b0c3nk"&&(Pd.innerHTML=Hj),jM=r(_e),Ad=l(_e,"P",{"data-svelte-h":!0}),_(Ad)!=="svelte-2fpu88"&&(Ad.innerHTML=Ej),xM=r(_e),g(Qs.$$.fragment,_e),JM=r(_e),Od=l(_e,"DIV",{class:!0});var Gf=T(Od);g(Er.$$.fragment,Gf),Gf.forEach(n),_e.forEach(n),Gb=r(e),Ze=l(e,"DIV",{class:!0});var Pt=T(Ze);g(qr.$$.fragment,Pt),UM=r(Pt),Kd=l(Pt,"P",{"data-svelte-h":!0}),_(Kd)!=="svelte-19509do"&&(Kd.innerHTML=qj),ZM=r(Pt),ep=l(Pt,"P",{"data-svelte-h":!0}),_(ep)!=="svelte-1v3r596"&&(ep.innerHTML=Dj),CM=r(Pt),tp=l(Pt,"DIV",{class:!0});var Ff=T(tp);g(Dr.$$.fragment,Ff),Ff.forEach(n),Pt.forEach(n),Fb=r(e),Ce=l(e,"DIV",{class:!0});var At=T(Ce);g(Qr.$$.fragment,At),WM=r(At),sp=l(At,"P",{"data-svelte-h":!0}),_(sp)!=="svelte-1e7zhts"&&(sp.innerHTML=Qj),BM=r(At),g(Ys.$$.fragment,At),IM=r(At),np=l(At,"DIV",{class:!0});var Xf=T(np);g(Yr.$$.fragment,Xf),Xf.forEach(n),At.forEach(n),Xb=r(e),at=l(e,"DIV",{class:!0});var Bs=T(at);g(Pr.$$.fragment,Bs),zM=r(Bs),ap=l(Bs,"P",{"data-svelte-h":!0}),_(ap)!=="svelte-y1kta5"&&(ap.textContent=Yj),VM=r(Bs),rp=l(Bs,"DIV",{class:!0});var Rf=T(rp);g(Ar.$$.fragment,Rf),Rf.forEach(n),Bs.forEach(n),Rb=r(e),rt=l(e,"DIV",{class:!0});var Is=T(rt);g(Or.$$.fragment,Is),GM=r(Is),op=l(Is,"P",{"data-svelte-h":!0}),_(op)!=="svelte-1atbpnp"&&(op.innerHTML=Pj),FM=r(Is),lp=l(Is,"DIV",{class:!0});var Lf=T(lp);g(Kr.$$.fragment,Lf),Lf.forEach(n),Is.forEach(n),Lb=r(e),We=l(e,"DIV",{class:!0});var Ot=T(We);g(eo.$$.fragment,Ot),XM=r(Ot),ip=l(Ot,"P",{"data-svelte-h":!0}),_(ip)!=="svelte-1qtsa3r"&&(ip.innerHTML=Aj),RM=r(Ot),g(Ps.$$.fragment,Ot),LM=r(Ot),cp=l(Ot,"DIV",{class:!0});var Nf=T(cp);g(to.$$.fragment,Nf),Nf.forEach(n),Ot.forEach(n),Nb=r(e),Be=l(e,"DIV",{class:!0});var Kt=T(Be);g(so.$$.fragment,Kt),NM=r(Kt),dp=l(Kt,"P",{"data-svelte-h":!0}),_(dp)!=="svelte-1xxt5g1"&&(dp.innerHTML=Oj),SM=r(Kt),g(As.$$.fragment,Kt),HM=r(Kt),pp=l(Kt,"DIV",{class:!0});var Sf=T(pp);g(no.$$.fragment,Sf),Sf.forEach(n),Kt.forEach(n),Sb=r(e),H=l(e,"DIV",{class:!0});var ye=T(H);g(ao.$$.fragment,ye),EM=r(ye),mp=l(ye,"P",{"data-svelte-h":!0}),_(mp)!=="svelte-1m9qk3k"&&(mp.innerHTML=Kj),qM=r(ye),gp=l(ye,"P",{"data-svelte-h":!0}),_(gp)!=="svelte-19dc1me"&&(gp.innerHTML=e0),DM=r(ye),hp=l(ye,"P",{"data-svelte-h":!0}),_(hp)!=="svelte-1fvwhfn"&&(hp.innerHTML=t0),QM=r(ye),g(Os.$$.fragment,ye),YM=r(ye),up=l(ye,"DIV",{class:!0});var Hf=T(up);g(ro.$$.fragment,Hf),Hf.forEach(n),ye.forEach(n),Hb=r(e),re=l(e,"DIV",{class:!0});var ts=T(re);g(oo.$$.fragment,ts),PM=r(ts),fp=l(ts,"P",{"data-svelte-h":!0}),_(fp)!=="svelte-1j8exuv"&&(fp.innerHTML=s0),AM=r(ts),g(Ks.$$.fragment,ts),OM=r(ts),g(en.$$.fragment,ts),KM=r(ts),bp=l(ts,"DIV",{class:!0});var vU=T(bp);g(lo.$$.fragment,vU),vU.forEach(n),ts.forEach(n),Eb=r(e),oe=l(e,"DIV",{class:!0});var ss=T(oe);g(io.$$.fragment,ss),ev=r(ss),_p=l(ss,"P",{"data-svelte-h":!0}),_(_p)!=="svelte-1oiukny"&&(_p.innerHTML=n0),tv=r(ss),g(tn.$$.fragment,ss),sv=r(ss),g(sn.$$.fragment,ss),nv=r(ss),yp=l(ss,"DIV",{class:!0});var wU=T(yp);g(co.$$.fragment,wU),wU.forEach(n),ss.forEach(n),qb=r(e),Ie=l(e,"DIV",{class:!0});var Za=T(Ie);g(po.$$.fragment,Za),av=r(Za),Tp=l(Za,"P",{"data-svelte-h":!0}),_(Tp)!=="svelte-8lc5bj"&&(Tp.innerHTML=a0),rv=r(Za),g(nn.$$.fragment,Za),ov=r(Za),Mp=l(Za,"DIV",{class:!0});var kU=T(Mp);g(mo.$$.fragment,kU),kU.forEach(n),Za.forEach(n),Db=r(e),le=l(e,"DIV",{class:!0});var ns=T(le);g(go.$$.fragment,ns),lv=r(ns),vp=l(ns,"P",{"data-svelte-h":!0}),_(vp)!=="svelte-1dx7orz"&&(vp.innerHTML=r0),iv=r(ns),wp=l(ns,"P",{"data-svelte-h":!0}),_(wp)!=="svelte-qhda5i"&&(wp.innerHTML=o0),cv=r(ns),g(an.$$.fragment,ns),dv=r(ns),kp=l(ns,"DIV",{class:!0});var $U=T(kp);g(ho.$$.fragment,$U),$U.forEach(n),ns.forEach(n),Qb=r(e),ie=l(e,"DIV",{class:!0});var as=T(ie);g(uo.$$.fragment,as),pv=r(as),$p=l(as,"P",{"data-svelte-h":!0}),_($p)!=="svelte-wdblk4"&&($p.innerHTML=l0),mv=r(as),g(rn.$$.fragment,as),gv=r(as),g(on.$$.fragment,as),hv=r(as),jp=l(as,"DIV",{class:!0});var jU=T(jp);g(fo.$$.fragment,jU),jU.forEach(n),as.forEach(n),Yb=r(e),ze=l(e,"DIV",{class:!0});var Ca=T(ze);g(bo.$$.fragment,Ca),uv=r(Ca),xp=l(Ca,"P",{"data-svelte-h":!0}),_(xp)!=="svelte-g0udyy"&&(xp.innerHTML=i0),fv=r(Ca),g(ln.$$.fragment,Ca),bv=r(Ca),Jp=l(Ca,"DIV",{class:!0});var xU=T(Jp);g(_o.$$.fragment,xU),xU.forEach(n),Ca.forEach(n),Pb=r(e),Ve=l(e,"DIV",{class:!0});var Wa=T(Ve);g(yo.$$.fragment,Wa),_v=r(Wa),Up=l(Wa,"P",{"data-svelte-h":!0}),_(Up)!=="svelte-kp6ubc"&&(Up.innerHTML=c0),yv=r(Wa),g(cn.$$.fragment,Wa),Tv=r(Wa),Zp=l(Wa,"DIV",{class:!0});var JU=T(Zp);g(To.$$.fragment,JU),JU.forEach(n),Wa.forEach(n),Ab=r(e),G=l(e,"DIV",{class:!0});var Te=T(G);g(Mo.$$.fragment,Te),Mv=r(Te),Cp=l(Te,"P",{"data-svelte-h":!0}),_(Cp)!=="svelte-1rvhp9l"&&(Cp.textContent=d0),vv=r(Te),Wp=l(Te,"P",{"data-svelte-h":!0}),_(Wp)!=="svelte-1adc5s0"&&(Wp.textContent=p0),wv=r(Te),Bp=l(Te,"UL",{"data-svelte-h":!0}),_(Bp)!=="svelte-eq22a7"&&(Bp.innerHTML=m0),kv=r(Te),Ip=l(Te,"P",{"data-svelte-h":!0}),_(Ip)!=="svelte-1mgc9mo"&&(Ip.innerHTML=g0),$v=r(Te),g(dn.$$.fragment,Te),jv=r(Te),zp=l(Te,"DIV",{class:!0});var UU=T(zp);g(vo.$$.fragment,UU),UU.forEach(n),Te.forEach(n),Ob=r(e),ce=l(e,"DIV",{class:!0});var rs=T(ce);g(wo.$$.fragment,rs),xv=r(rs),Vp=l(rs,"P",{"data-svelte-h":!0}),_(Vp)!=="svelte-1l8rgx"&&(Vp.innerHTML=h0),Jv=r(rs),g(pn.$$.fragment,rs),Uv=r(rs),g(mn.$$.fragment,rs),Zv=r(rs),Gp=l(rs,"DIV",{class:!0});var ZU=T(Gp);g(ko.$$.fragment,ZU),ZU.forEach(n),rs.forEach(n),Kb=r(e),Ge=l(e,"DIV",{class:!0});var Ba=T(Ge);g($o.$$.fragment,Ba),Cv=r(Ba),Fp=l(Ba,"P",{"data-svelte-h":!0}),_(Fp)!=="svelte-1g5adob"&&(Fp.innerHTML=u0),Wv=r(Ba),g(gn.$$.fragment,Ba),Bv=r(Ba),Xp=l(Ba,"DIV",{class:!0});var CU=T(Xp);g(jo.$$.fragment,CU),CU.forEach(n),Ba.forEach(n),e_=r(e),Fe=l(e,"DIV",{class:!0});var Ia=T(Fe);g(xo.$$.fragment,Ia),Iv=r(Ia),Rp=l(Ia,"P",{"data-svelte-h":!0}),_(Rp)!=="svelte-1patzqj"&&(Rp.innerHTML=f0),zv=r(Ia),g(hn.$$.fragment,Ia),Vv=r(Ia),Lp=l(Ia,"DIV",{class:!0});var WU=T(Lp);g(Jo.$$.fragment,WU),WU.forEach(n),Ia.forEach(n),t_=r(e),de=l(e,"DIV",{class:!0});var os=T(de);g(Uo.$$.fragment,os),Gv=r(os),Np=l(os,"P",{"data-svelte-h":!0}),_(Np)!=="svelte-wob73k"&&(Np.innerHTML=b0),Fv=r(os),Sp=l(os,"P",{"data-svelte-h":!0}),_(Sp)!=="svelte-1qmimno"&&(Sp.innerHTML=_0),Xv=r(os),g(un.$$.fragment,os),Rv=r(os),Hp=l(os,"DIV",{class:!0});var BU=T(Hp);g(Zo.$$.fragment,BU),BU.forEach(n),os.forEach(n),s_=r(e),pe=l(e,"DIV",{class:!0});var ls=T(pe);g(Co.$$.fragment,ls),Lv=r(ls),Ep=l(ls,"P",{"data-svelte-h":!0}),_(Ep)!=="svelte-1dewsn6"&&(Ep.innerHTML=y0),Nv=r(ls),qp=l(ls,"P",{"data-svelte-h":!0}),_(qp)!=="svelte-5qs7tv"&&(qp.innerHTML=T0),Sv=r(ls),g(fn.$$.fragment,ls),Hv=r(ls),Dp=l(ls,"DIV",{class:!0});var IU=T(Dp);g(Wo.$$.fragment,IU),IU.forEach(n),ls.forEach(n),n_=r(e),me=l(e,"DIV",{class:!0});var is=T(me);g(Bo.$$.fragment,is),Ev=r(is),Qp=l(is,"P",{"data-svelte-h":!0}),_(Qp)!=="svelte-laa6zp"&&(Qp.innerHTML=M0),qv=r(is),Yp=l(is,"P",{"data-svelte-h":!0}),_(Yp)!=="svelte-qmmn5t"&&(Yp.innerHTML=v0),Dv=r(is),g(bn.$$.fragment,is),Qv=r(is),Pp=l(is,"DIV",{class:!0});var zU=T(Pp);g(Io.$$.fragment,zU),zU.forEach(n),is.forEach(n),a_=r(e),E=l(e,"DIV",{class:!0});var qe=T(E);g(zo.$$.fragment,qe),Yv=r(qe),Ap=l(qe,"P",{"data-svelte-h":!0}),_(Ap)!=="svelte-1722u08"&&(Ap.innerHTML=w0),Pv=r(qe),Op=l(qe,"P",{"data-svelte-h":!0}),_(Op)!=="svelte-1yjxylt"&&(Op.innerHTML=k0),Av=r(qe),Kp=l(qe,"P",{"data-svelte-h":!0}),_(Kp)!=="svelte-y9hsik"&&(Kp.innerHTML=$0),Ov=r(qe),g(_n.$$.fragment,qe),Kv=r(qe),em=l(qe,"DIV",{class:!0});var VU=T(em);g(Vo.$$.fragment,VU),VU.forEach(n),qe.forEach(n),r_=r(e),g(Go.$$.fragment,e),o_=r(e),ot=l(e,"DIV",{class:!0});var Lu=T(ot);g(Fo.$$.fragment,Lu),ew=r(Lu),tm=l(Lu,"P",{"data-svelte-h":!0}),_(tm)!=="svelte-1r9g8lr"&&(tm.innerHTML=j0),tw=r(Lu),sm=l(Lu,"DIV",{class:!0});var GU=T(sm);g(Xo.$$.fragment,GU),GU.forEach(n),Lu.forEach(n),l_=r(e),lt=l(e,"DIV",{class:!0});var Nu=T(lt);g(Ro.$$.fragment,Nu),sw=r(Nu),nm=l(Nu,"P",{"data-svelte-h":!0}),_(nm)!=="svelte-1o8otjv"&&(nm.innerHTML=x0),nw=r(Nu),am=l(Nu,"DIV",{class:!0});var FU=T(am);g(Lo.$$.fragment,FU),FU.forEach(n),Nu.forEach(n),i_=r(e),it=l(e,"DIV",{class:!0});var Su=T(it);g(No.$$.fragment,Su),aw=r(Su),rm=l(Su,"P",{"data-svelte-h":!0}),_(rm)!=="svelte-1557waw"&&(rm.innerHTML=J0),rw=r(Su),om=l(Su,"DIV",{class:!0});var XU=T(om);g(So.$$.fragment,XU),XU.forEach(n),Su.forEach(n),c_=r(e),ct=l(e,"DIV",{class:!0});var Hu=T(ct);g(Ho.$$.fragment,Hu),ow=r(Hu),lm=l(Hu,"P",{"data-svelte-h":!0}),_(lm)!=="svelte-y1kta5"&&(lm.textContent=U0),lw=r(Hu),yn=l(Hu,"DIV",{class:!0});var Zy=T(yn);g(Eo.$$.fragment,Zy),iw=r(Zy),im=l(Zy,"P",{"data-svelte-h":!0}),_(im)!=="svelte-5aspnb"&&(im.textContent=Z0),Zy.forEach(n),Hu.forEach(n),d_=r(e),dt=l(e,"DIV",{class:!0});var Eu=T(dt);g(qo.$$.fragment,Eu),cw=r(Eu),cm=l(Eu,"P",{"data-svelte-h":!0}),_(cm)!=="svelte-wv649x"&&(cm.innerHTML=C0),dw=r(Eu),dm=l(Eu,"DIV",{class:!0});var RU=T(dm);g(Do.$$.fragment,RU),RU.forEach(n),Eu.forEach(n),p_=r(e),pt=l(e,"DIV",{class:!0});var qu=T(pt);g(Qo.$$.fragment,qu),pw=r(qu),pm=l(qu,"P",{"data-svelte-h":!0}),_(pm)!=="svelte-th82mu"&&(pm.textContent=W0),mw=r(qu),Tn=l(qu,"DIV",{class:!0});var Cy=T(Tn);g(Yo.$$.fragment,Cy),gw=r(Cy),mm=l(Cy,"P",{"data-svelte-h":!0}),_(mm)!=="svelte-hcoglc"&&(mm.textContent=B0),Cy.forEach(n),qu.forEach(n),m_=r(e),mt=l(e,"DIV",{class:!0});var Du=T(mt);g(Po.$$.fragment,Du),hw=r(Du),gm=l(Du,"P",{"data-svelte-h":!0}),_(gm)!=="svelte-d6heh3"&&(gm.innerHTML=I0),uw=r(Du),hm=l(Du,"DIV",{class:!0});var LU=T(hm);g(Ao.$$.fragment,LU),LU.forEach(n),Du.forEach(n),g_=r(e),gt=l(e,"DIV",{class:!0});var Qu=T(gt);g(Oo.$$.fragment,Qu),fw=r(Qu),um=l(Qu,"P",{"data-svelte-h":!0}),_(um)!=="svelte-gt0dvy"&&(um.innerHTML=z0),bw=r(Qu),fm=l(Qu,"DIV",{class:!0});var NU=T(fm);g(Ko.$$.fragment,NU),NU.forEach(n),Qu.forEach(n),h_=r(e),ht=l(e,"DIV",{class:!0});var Yu=T(ht);g(el.$$.fragment,Yu),_w=r(Yu),bm=l(Yu,"P",{"data-svelte-h":!0}),_(bm)!=="svelte-e8ez2m"&&(bm.innerHTML=V0),yw=r(Yu),_m=l(Yu,"DIV",{class:!0});var SU=T(_m);g(tl.$$.fragment,SU),SU.forEach(n),Yu.forEach(n),u_=r(e),ut=l(e,"DIV",{class:!0});var Pu=T(ut);g(sl.$$.fragment,Pu),Tw=r(Pu),ym=l(Pu,"P",{"data-svelte-h":!0}),_(ym)!=="svelte-1sr1lwj"&&(ym.innerHTML=G0),Mw=r(Pu),Tm=l(Pu,"DIV",{class:!0});var HU=T(Tm);g(nl.$$.fragment,HU),HU.forEach(n),Pu.forEach(n),f_=r(e),ft=l(e,"DIV",{class:!0});var Au=T(ft);g(al.$$.fragment,Au),vw=r(Au),Mm=l(Au,"P",{"data-svelte-h":!0}),_(Mm)!=="svelte-4hf1vm"&&(Mm.innerHTML=F0),ww=r(Au),vm=l(Au,"DIV",{class:!0});var EU=T(vm);g(rl.$$.fragment,EU),EU.forEach(n),Au.forEach(n),b_=r(e),bt=l(e,"DIV",{class:!0});var Ou=T(bt);g(ol.$$.fragment,Ou),kw=r(Ou),wm=l(Ou,"P",{"data-svelte-h":!0}),_(wm)!=="svelte-a554sd"&&(wm.innerHTML=X0),$w=r(Ou),km=l(Ou,"DIV",{class:!0});var qU=T(km);g(ll.$$.fragment,qU),qU.forEach(n),Ou.forEach(n),__=r(e),_t=l(e,"DIV",{class:!0});var Ku=T(_t);g(il.$$.fragment,Ku),jw=r(Ku),$m=l(Ku,"P",{"data-svelte-h":!0}),_($m)!=="svelte-m0ovbw"&&($m.innerHTML=R0),xw=r(Ku),jm=l(Ku,"DIV",{class:!0});var DU=T(jm);g(cl.$$.fragment,DU),DU.forEach(n),Ku.forEach(n),y_=r(e),yt=l(e,"DIV",{class:!0});var ef=T(yt);g(dl.$$.fragment,ef),Jw=r(ef),xm=l(ef,"P",{"data-svelte-h":!0}),_(xm)!=="svelte-v0j3k9"&&(xm.innerHTML=L0),Uw=r(ef),Jm=l(ef,"DIV",{class:!0});var QU=T(Jm);g(pl.$$.fragment,QU),QU.forEach(n),ef.forEach(n),T_=r(e),Tt=l(e,"DIV",{class:!0});var tf=T(Tt);g(ml.$$.fragment,tf),Zw=r(tf),Um=l(tf,"P",{"data-svelte-h":!0}),_(Um)!=="svelte-1kdstb"&&(Um.innerHTML=N0),Cw=r(tf),Zm=l(tf,"DIV",{class:!0});var YU=T(Zm);g(gl.$$.fragment,YU),YU.forEach(n),tf.forEach(n),M_=r(e),g(hl.$$.fragment,e),v_=r(e),Mt=l(e,"DIV",{class:!0});var sf=T(Mt);g(ul.$$.fragment,sf),Ww=r(sf),Cm=l(sf,"P",{"data-svelte-h":!0}),_(Cm)!=="svelte-115xumf"&&(Cm.innerHTML=S0),Bw=r(sf),Wm=l(sf,"DIV",{class:!0});var PU=T(Wm);g(fl.$$.fragment,PU),PU.forEach(n),sf.forEach(n),w_=r(e),vt=l(e,"DIV",{class:!0});var nf=T(vt);g(bl.$$.fragment,nf),Iw=r(nf),Bm=l(nf,"P",{"data-svelte-h":!0}),_(Bm)!=="svelte-nirf9f"&&(Bm.innerHTML=H0),zw=r(nf),Im=l(nf,"DIV",{class:!0});var AU=T(Im);g(_l.$$.fragment,AU),AU.forEach(n),nf.forEach(n),k_=r(e),wt=l(e,"DIV",{class:!0});var af=T(wt);g(yl.$$.fragment,af),Vw=r(af),zm=l(af,"P",{"data-svelte-h":!0}),_(zm)!=="svelte-klyckq"&&(zm.innerHTML=E0),Gw=r(af),Vm=l(af,"DIV",{class:!0});var OU=T(Vm);g(Tl.$$.fragment,OU),OU.forEach(n),af.forEach(n),$_=r(e),kt=l(e,"DIV",{class:!0});var rf=T(kt);g(Ml.$$.fragment,rf),Fw=r(rf),Gm=l(rf,"P",{"data-svelte-h":!0}),_(Gm)!=="svelte-y1kta5"&&(Gm.textContent=q0),Xw=r(rf),Mn=l(rf,"DIV",{class:!0});var Wy=T(Mn);g(vl.$$.fragment,Wy),Rw=r(Wy),Fm=l(Wy,"P",{"data-svelte-h":!0}),_(Fm)!=="svelte-1l17mwc"&&(Fm.textContent=D0),Wy.forEach(n),rf.forEach(n),j_=r(e),$t=l(e,"DIV",{class:!0});var of=T($t);g(wl.$$.fragment,of),Lw=r(of),Xm=l(of,"P",{"data-svelte-h":!0}),_(Xm)!=="svelte-8dgktv"&&(Xm.innerHTML=Q0),Nw=r(of),Rm=l(of,"DIV",{class:!0});var KU=T(Rm);g(kl.$$.fragment,KU),KU.forEach(n),of.forEach(n),x_=r(e),jt=l(e,"DIV",{class:!0});var lf=T(jt);g($l.$$.fragment,lf),Sw=r(lf),Lm=l(lf,"P",{"data-svelte-h":!0}),_(Lm)!=="svelte-th82mu"&&(Lm.textContent=Y0),Hw=r(lf),vn=l(lf,"DIV",{class:!0});var By=T(vn);g(jl.$$.fragment,By),Ew=r(By),Nm=l(By,"P",{"data-svelte-h":!0}),_(Nm)!=="svelte-1tcb5cf"&&(Nm.textContent=P0),By.forEach(n),lf.forEach(n),J_=r(e),xt=l(e,"DIV",{class:!0});var cf=T(xt);g(xl.$$.fragment,cf),qw=r(cf),Sm=l(cf,"P",{"data-svelte-h":!0}),_(Sm)!=="svelte-18yq2lb"&&(Sm.innerHTML=A0),Dw=r(cf),Hm=l(cf,"DIV",{class:!0});var eZ=T(Hm);g(Jl.$$.fragment,eZ),eZ.forEach(n),cf.forEach(n),U_=r(e),Jt=l(e,"DIV",{class:!0});var df=T(Jt);g(Ul.$$.fragment,df),Qw=r(df),Em=l(df,"P",{"data-svelte-h":!0}),_(Em)!=="svelte-rndo11"&&(Em.innerHTML=O0),Yw=r(df),qm=l(df,"DIV",{class:!0});var tZ=T(qm);g(Zl.$$.fragment,tZ),tZ.forEach(n),df.forEach(n),Z_=r(e),Ut=l(e,"DIV",{class:!0});var pf=T(Ut);g(Cl.$$.fragment,pf),Pw=r(pf),Dm=l(pf,"P",{"data-svelte-h":!0}),_(Dm)!=="svelte-vt3rxp"&&(Dm.innerHTML=K0),Aw=r(pf),Qm=l(pf,"DIV",{class:!0});var sZ=T(Qm);g(Wl.$$.fragment,sZ),sZ.forEach(n),pf.forEach(n),C_=r(e),Zt=l(e,"DIV",{class:!0});var mf=T(Zt);g(Bl.$$.fragment,mf),Ow=r(mf),Ym=l(mf,"P",{"data-svelte-h":!0}),_(Ym)!=="svelte-15abw8y"&&(Ym.innerHTML=ex),Kw=r(mf),Pm=l(mf,"DIV",{class:!0});var nZ=T(Pm);g(Il.$$.fragment,nZ),nZ.forEach(n),mf.forEach(n),W_=r(e),Ct=l(e,"DIV",{class:!0});var gf=T(Ct);g(zl.$$.fragment,gf),e2=r(gf),Am=l(gf,"P",{"data-svelte-h":!0}),_(Am)!=="svelte-1oo0biz"&&(Am.innerHTML=tx),t2=r(gf),Om=l(gf,"DIV",{class:!0});var aZ=T(Om);g(Vl.$$.fragment,aZ),aZ.forEach(n),gf.forEach(n),B_=r(e),Wt=l(e,"DIV",{class:!0});var hf=T(Wt);g(Gl.$$.fragment,hf),s2=r(hf),Km=l(hf,"P",{"data-svelte-h":!0}),_(Km)!=="svelte-1j5ogr1"&&(Km.innerHTML=sx),n2=r(hf),eg=l(hf,"DIV",{class:!0});var rZ=T(eg);g(Fl.$$.fragment,rZ),rZ.forEach(n),hf.forEach(n),I_=r(e),Bt=l(e,"DIV",{class:!0});var uf=T(Bt);g(Xl.$$.fragment,uf),a2=r(uf),tg=l(uf,"P",{"data-svelte-h":!0}),_(tg)!=="svelte-1sygpwz"&&(tg.innerHTML=nx),r2=r(uf),sg=l(uf,"DIV",{class:!0});var oZ=T(sg);g(Rl.$$.fragment,oZ),oZ.forEach(n),uf.forEach(n),z_=r(e),g(Ll.$$.fragment,e),V_=r(e),Nl=l(e,"P",{"data-svelte-h":!0}),_(Nl)!=="svelte-vfaqvb"&&(Nl.innerHTML=ax),G_=r(e),Xe=l(e,"DIV",{class:!0});var za=T(Xe);g(Sl.$$.fragment,za),o2=r(za),ng=l(za,"P",{"data-svelte-h":!0}),_(ng)!=="svelte-rfvu1k"&&(ng.textContent=rx),l2=r(za),ag=l(za,"P",{"data-svelte-h":!0}),_(ag)!=="svelte-e1lytz"&&(ag.innerHTML=ox),i2=r(za),rg=l(za,"DIV",{class:!0});var lZ=T(rg);g(Hl.$$.fragment,lZ),lZ.forEach(n),za.forEach(n),F_=r(e),xs=l(e,"DIV",{class:!0});var Iy=T(xs);g(El.$$.fragment,Iy),c2=r(Iy),og=l(Iy,"DIV",{class:!0});var iZ=T(og);g(ql.$$.fragment,iZ),iZ.forEach(n),Iy.forEach(n),X_=r(e),It=l(e,"DIV",{class:!0});var ff=T(It);g(Dl.$$.fragment,ff),d2=r(ff),lg=l(ff,"P",{"data-svelte-h":!0}),_(lg)!=="svelte-4hfu96"&&(lg.innerHTML=lx),p2=r(ff),ig=l(ff,"DIV",{class:!0});var cZ=T(ig);g(Ql.$$.fragment,cZ),cZ.forEach(n),ff.forEach(n),R_=r(e),zt=l(e,"DIV",{class:!0});var bf=T(zt);g(Yl.$$.fragment,bf),m2=r(bf),cg=l(bf,"P",{"data-svelte-h":!0}),_(cg)!=="svelte-q5v59n"&&(cg.innerHTML=ix),g2=r(bf),dg=l(bf,"DIV",{class:!0});var dZ=T(dg);g(Pl.$$.fragment,dZ),dZ.forEach(n),bf.forEach(n),L_=r(e),J=l(e,"DIV",{class:!0});var C=T(J);g(Al.$$.fragment,C),h2=r(C),pg=l(C,"P",{"data-svelte-h":!0}),_(pg)!=="svelte-1rue44"&&(pg.textContent=cx),u2=r(C),mg=l(C,"P",{"data-svelte-h":!0}),_(mg)!=="svelte-we1k7h"&&(mg.textContent=dx),f2=r(C),gg=l(C,"UL",{"data-svelte-h":!0}),_(gg)!=="svelte-1f6ppg"&&(gg.innerHTML=px),b2=r(C),hg=l(C,"P",{"data-svelte-h":!0}),_(hg)!=="svelte-1uu68ip"&&(hg.textContent=mx),_2=r(C),ug=l(C,"UL",{"data-svelte-h":!0}),_(ug)!=="svelte-izl8df"&&(ug.innerHTML=gx),y2=r(C),fg=l(C,"P",{"data-svelte-h":!0}),_(fg)!=="svelte-hoqys0"&&(fg.textContent=hx),T2=r(C),bg=l(C,"P",{"data-svelte-h":!0}),_(bg)!=="svelte-1a9fclk"&&(bg.textContent=ux),M2=r(C),_g=l(C,"P",{"data-svelte-h":!0}),_(_g)!=="svelte-15ntb9y"&&(_g.textContent=fx),v2=r(C),yg=l(C,"UL",{"data-svelte-h":!0}),_(yg)!=="svelte-vv46ly"&&(yg.innerHTML=bx),w2=r(C),Tg=l(C,"P",{"data-svelte-h":!0}),_(Tg)!=="svelte-1owyk1q"&&(Tg.textContent=_x),k2=r(C),Mg=l(C,"P",{"data-svelte-h":!0}),_(Mg)!=="svelte-wt8oc0"&&(Mg.textContent=yx),$2=r(C),vg=l(C,"P",{"data-svelte-h":!0}),_(vg)!=="svelte-ws21yj"&&(vg.textContent=Tx),j2=r(C),wg=l(C,"P",{"data-svelte-h":!0}),_(wg)!=="svelte-l6qxzs"&&(wg.textContent=Mx),x2=r(C),kg=l(C,"UL",{"data-svelte-h":!0}),_(kg)!=="svelte-p67cyh"&&(kg.innerHTML=vx),J2=r(C),$g=l(C,"P",{"data-svelte-h":!0}),_($g)!=="svelte-1fg1xi2"&&($g.textContent=wx),U2=r(C),jg=l(C,"P",{"data-svelte-h":!0}),_(jg)!=="svelte-1e0ripw"&&(jg.textContent=kx),Z2=r(C),xg=l(C,"UL",{"data-svelte-h":!0}),_(xg)!=="svelte-1v088e0"&&(xg.innerHTML=$x),C2=r(C),Jg=l(C,"P",{"data-svelte-h":!0}),_(Jg)!=="svelte-be7vix"&&(Jg.textContent=jx),W2=r(C),Ug=l(C,"P",{"data-svelte-h":!0}),_(Ug)!=="svelte-1xhdoom"&&(Ug.textContent=xx),B2=r(C),g(wn.$$.fragment,C),I2=r(C),Zg=l(C,"DIV",{class:!0});var pZ=T(Zg);g(Ol.$$.fragment,pZ),pZ.forEach(n),C.forEach(n),N_=r(e),Vt=l(e,"DIV",{class:!0});var _f=T(Vt);g(Kl.$$.fragment,_f),z2=r(_f),Cg=l(_f,"P",{"data-svelte-h":!0}),_(Cg)!=="svelte-1t19wr8"&&(Cg.innerHTML=Jx),V2=r(_f),Wg=l(_f,"DIV",{class:!0});var mZ=T(Wg);g(ei.$$.fragment,mZ),mZ.forEach(n),_f.forEach(n),S_=r(e),g(ti.$$.fragment,e),H_=r(e),si=l(e,"P",{"data-svelte-h":!0}),_(si)!=="svelte-1fq8mcp"&&(si.innerHTML=Ux),E_=r(e),W=l(e,"DIV",{class:!0});var B=T(W);g(ni.$$.fragment,B),G2=r(B),Bg=l(B,"P",{"data-svelte-h":!0}),_(Bg)!=="svelte-1kh5y5v"&&(Bg.textContent=Zx),F2=r(B),Ig=l(B,"P",{"data-svelte-h":!0}),_(Ig)!=="svelte-1ygkifj"&&(Ig.textContent=Cx),X2=r(B),g(kn.$$.fragment,B),R2=r(B),zg=l(B,"P",{"data-svelte-h":!0}),_(zg)!=="svelte-7kbd1a"&&(zg.textContent=Wx),L2=r(B),$n=l(B,"DIV",{class:!0});var zy=T($n);g(ai.$$.fragment,zy),N2=r(zy),Vg=l(zy,"P",{"data-svelte-h":!0}),_(Vg)!=="svelte-163x237"&&(Vg.textContent=Bx),zy.forEach(n),S2=r(B),jn=l(B,"DIV",{class:!0});var Vy=T(jn);g(ri.$$.fragment,Vy),H2=r(Vy),Gg=l(Vy,"P",{"data-svelte-h":!0}),_(Gg)!=="svelte-dtkk01"&&(Gg.textContent=Ix),Vy.forEach(n),E2=r(B),xn=l(B,"DIV",{class:!0});var Gy=T(xn);g(oi.$$.fragment,Gy),q2=r(Gy),Fg=l(Gy,"P",{"data-svelte-h":!0}),_(Fg)!=="svelte-11pa7k0"&&(Fg.textContent=zx),Gy.forEach(n),D2=r(B),Jn=l(B,"DIV",{class:!0});var Fy=T(Jn);g(li.$$.fragment,Fy),Q2=r(Fy),Xg=l(Fy,"P",{"data-svelte-h":!0}),_(Xg)!=="svelte-57vcuk"&&(Xg.innerHTML=Vx),Fy.forEach(n),Y2=r(B),Un=l(B,"DIV",{class:!0});var Xy=T(Un);g(ii.$$.fragment,Xy),P2=r(Xy),Rg=l(Xy,"P",{"data-svelte-h":!0}),_(Rg)!=="svelte-e342dt"&&(Rg.textContent=Gx),Xy.forEach(n),A2=r(B),Zn=l(B,"DIV",{class:!0});var Ry=T(Zn);g(ci.$$.fragment,Ry),O2=r(Ry),Lg=l(Ry,"P",{"data-svelte-h":!0}),_(Lg)!=="svelte-vbd5xj"&&(Lg.textContent=Fx),Ry.forEach(n),K2=r(B),es=l(B,"DIV",{class:!0});var yf=T(es);g(di.$$.fragment,yf),ek=r(yf),Ng=l(yf,"P",{"data-svelte-h":!0}),_(Ng)!=="svelte-1c2dshy"&&(Ng.innerHTML=Xx),tk=r(yf),Sg=l(yf,"P",{"data-svelte-h":!0}),_(Sg)!=="svelte-1qvu1un"&&(Sg.textContent=Rx),yf.forEach(n),B.forEach(n),q_=r(e),Js=l(e,"DIV",{class:!0});var Ly=T(Js);g(pi.$$.fragment,Ly),sk=r(Ly),Hg=l(Ly,"P",{"data-svelte-h":!0}),_(Hg)!=="svelte-1rymat9"&&(Hg.innerHTML=Lx),Ly.forEach(n),D_=r(e),Us=l(e,"DIV",{class:!0});var Ny=T(Us);g(mi.$$.fragment,Ny),nk=r(Ny),Eg=l(Ny,"P",{"data-svelte-h":!0}),_(Eg)!=="svelte-1obuarm"&&(Eg.innerHTML=Nx),Ny.forEach(n),Q_=r(e),Re=l(e,"DIV",{class:!0});var Va=T(Re);g(gi.$$.fragment,Va),ak=r(Va),qg=l(Va,"P",{"data-svelte-h":!0}),_(qg)!=="svelte-rxlesw"&&(qg.textContent=Sx),rk=r(Va),K=l(Va,"DIV",{class:!0});var De=T(K);g(hi.$$.fragment,De),ok=r(De),Dg=l(De,"P",{"data-svelte-h":!0}),_(Dg)!=="svelte-15hhlou"&&(Dg.textContent=Hx),lk=r(De),Qg=l(De,"P",{"data-svelte-h":!0}),_(Qg)!=="svelte-e6h4hs"&&(Qg.innerHTML=Ex),ik=r(De),Yg=l(De,"P",{"data-svelte-h":!0}),_(Yg)!=="svelte-1w36vm3"&&(Yg.innerHTML=qx),ck=r(De),Pg=l(De,"P",{"data-svelte-h":!0}),_(Pg)!=="svelte-1niq0qw"&&(Pg.innerHTML=Dx),dk=r(De),Ag=l(De,"P",{"data-svelte-h":!0}),_(Ag)!=="svelte-af4g6f"&&(Ag.textContent=Qx),De.forEach(n),pk=r(Va),Cn=l(Va,"DIV",{class:!0});var Sy=T(Cn);g(ui.$$.fragment,Sy),mk=r(Sy),Og=l(Sy,"P",{"data-svelte-h":!0}),_(Og)!=="svelte-eab6jp"&&(Og.textContent=Yx),Sy.forEach(n),Va.forEach(n),Y_=r(e),g(fi.$$.fragment,e),P_=r(e),Le=l(e,"DIV",{class:!0});var Ga=T(Le);g(bi.$$.fragment,Ga),gk=r(Ga),Kg=l(Ga,"P",{"data-svelte-h":!0}),_(Kg)!=="svelte-1fikjzl"&&(Kg.innerHTML=Px),hk=r(Ga),eh=l(Ga,"DIV",{class:!0});var gZ=T(eh);g(_i.$$.fragment,gZ),gZ.forEach(n),uk=r(Ga),th=l(Ga,"DIV",{class:!0});var hZ=T(th);g(yi.$$.fragment,hZ),hZ.forEach(n),Ga.forEach(n),A_=r(e),q=l(e,"DIV",{class:!0});var Qe=T(q);g(Ti.$$.fragment,Qe),fk=r(Qe),sh=l(Qe,"P",{"data-svelte-h":!0}),_(sh)!=="svelte-1lvowm"&&(sh.innerHTML=Ax),bk=r(Qe),nh=l(Qe,"P",{"data-svelte-h":!0}),_(nh)!=="svelte-19qrwo1"&&(nh.innerHTML=Ox),_k=r(Qe),ah=l(Qe,"P",{"data-svelte-h":!0}),_(ah)!=="svelte-l79sbt"&&(ah.innerHTML=Kx),yk=r(Qe),rh=l(Qe,"DIV",{class:!0});var uZ=T(rh);g(Mi.$$.fragment,uZ),uZ.forEach(n),Tk=r(Qe),oh=l(Qe,"DIV",{class:!0});var fZ=T(oh);g(vi.$$.fragment,fZ),fZ.forEach(n),Qe.forEach(n),O_=r(e),Ne=l(e,"DIV",{class:!0});var Fa=T(Ne);g(wi.$$.fragment,Fa),Mk=r(Fa),lh=l(Fa,"P",{"data-svelte-h":!0}),_(lh)!=="svelte-cvew4t"&&(lh.innerHTML=eJ),vk=r(Fa),ih=l(Fa,"DIV",{class:!0});var bZ=T(ih);g(ki.$$.fragment,bZ),bZ.forEach(n),wk=r(Fa),ch=l(Fa,"DIV",{class:!0});var _Z=T(ch);g($i.$$.fragment,_Z),_Z.forEach(n),Fa.forEach(n),K_=r(e),g(ji.$$.fragment,e),ey=r(e),F=l(e,"DIV",{class:!0});var Me=T(F);g(xi.$$.fragment,Me),kk=r(Me),dh=l(Me,"P",{"data-svelte-h":!0}),_(dh)!=="svelte-5jvlz5"&&(dh.textContent=tJ),$k=r(Me),g(Wn.$$.fragment,Me),jk=r(Me),g(Bn.$$.fragment,Me),xk=r(Me),In=l(Me,"DIV",{class:!0});var Hy=T(In);g(Ji.$$.fragment,Hy),Jk=r(Hy),ph=l(Hy,"P",{"data-svelte-h":!0}),_(ph)!=="svelte-10d94rs"&&(ph.textContent=sJ),Hy.forEach(n),Uk=r(Me),zn=l(Me,"DIV",{class:!0});var Ey=T(zn);g(Ui.$$.fragment,Ey),Zk=r(Ey),mh=l(Ey,"P",{"data-svelte-h":!0}),_(mh)!=="svelte-tm945r"&&(mh.textContent=nJ),Ey.forEach(n),Ck=r(Me),Vn=l(Me,"DIV",{class:!0});var qy=T(Vn);g(Zi.$$.fragment,qy),Wk=r(qy),gh=l(qy,"P",{"data-svelte-h":!0}),_(gh)!=="svelte-1i1356p"&&(gh.textContent=aJ),qy.forEach(n),Me.forEach(n),ty=r(e),ge=l(e,"DIV",{class:!0});var cs=T(ge);g(Ci.$$.fragment,cs),Bk=r(cs),hh=l(cs,"P",{"data-svelte-h":!0}),_(hh)!=="svelte-190fodr"&&(hh.textContent=rJ),Ik=r(cs),g(Gn.$$.fragment,cs),zk=r(cs),g(Fn.$$.fragment,cs),Vk=r(cs),Xn=l(cs,"DIV",{class:!0});var Dy=T(Xn);g(Wi.$$.fragment,Dy),Gk=r(Dy),uh=l(Dy,"P",{"data-svelte-h":!0}),_(uh)!=="svelte-16i5iz"&&(uh.textContent=oJ),Dy.forEach(n),cs.forEach(n),sy=r(e),g(Bi.$$.fragment,e),ny=r(e),Gt=l(e,"DIV",{class:!0});var Tf=T(Gt);g(Ii.$$.fragment,Tf),Fk=r(Tf),fh=l(Tf,"P",{"data-svelte-h":!0}),_(fh)!=="svelte-15qehu2"&&(fh.textContent=lJ),Xk=r(Tf),Rn=l(Tf,"DIV",{class:!0});var Qy=T(Rn);g(zi.$$.fragment,Qy),Rk=r(Qy),bh=l(Qy,"P",{"data-svelte-h":!0}),_(bh)!=="svelte-dfcv5s"&&(bh.innerHTML=iJ),Qy.forEach(n),Tf.forEach(n),ay=r(e),Ft=l(e,"DIV",{class:!0});var Mf=T(Ft);g(Vi.$$.fragment,Mf),Lk=r(Mf),_h=l(Mf,"P",{"data-svelte-h":!0}),_(_h)!=="svelte-1sqibp"&&(_h.textContent=cJ),Nk=r(Mf),Ln=l(Mf,"DIV",{class:!0});var Yy=T(Ln);g(Gi.$$.fragment,Yy),Sk=r(Yy),yh=l(Yy,"P",{"data-svelte-h":!0}),_(yh)!=="svelte-n0rwld"&&(yh.innerHTML=dJ),Yy.forEach(n),Mf.forEach(n),ry=r(e),Xt=l(e,"DIV",{class:!0});var vf=T(Xt);g(Fi.$$.fragment,vf),Hk=r(vf),Th=l(vf,"P",{"data-svelte-h":!0}),_(Th)!=="svelte-157zylv"&&(Th.textContent=pJ),Ek=r(vf),Nn=l(vf,"DIV",{class:!0});var Py=T(Nn);g(Xi.$$.fragment,Py),qk=r(Py),Mh=l(Py,"P",{"data-svelte-h":!0}),_(Mh)!=="svelte-15juztn"&&(Mh.textContent=mJ),Py.forEach(n),vf.forEach(n),oy=r(e),I=l(e,"DIV",{class:!0});var L=T(I);g(Ri.$$.fragment,L),Dk=r(L),vh=l(L,"P",{"data-svelte-h":!0}),_(vh)!=="svelte-11w7j52"&&(vh.textContent=gJ),Qk=r(L),wh=l(L,"P",{"data-svelte-h":!0}),_(wh)!=="svelte-1f9j82e"&&(wh.innerHTML=hJ),Yk=r(L),g(Sn.$$.fragment,L),Pk=r(L),Hn=l(L,"DIV",{class:!0});var Ay=T(Hn);g(Li.$$.fragment,Ay),Ak=r(Ay),kh=l(Ay,"P",{"data-svelte-h":!0}),_(kh)!=="svelte-dfcv5s"&&(kh.innerHTML=uJ),Ay.forEach(n),Ok=r(L),En=l(L,"DIV",{class:!0});var Oy=T(En);g(Ni.$$.fragment,Oy),Kk=r(Oy),$h=l(Oy,"P",{"data-svelte-h":!0}),_($h)!=="svelte-1nftdf9"&&($h.textContent=fJ),Oy.forEach(n),e1=r(L),qn=l(L,"DIV",{class:!0});var Ky=T(qn);g(Si.$$.fragment,Ky),t1=r(Ky),jh=l(Ky,"P",{"data-svelte-h":!0}),_(jh)!=="svelte-114iuj0"&&(jh.textContent=bJ),Ky.forEach(n),s1=r(L),Dn=l(L,"DIV",{class:!0});var eT=T(Dn);g(Hi.$$.fragment,eT),n1=r(eT),xh=l(eT,"P",{"data-svelte-h":!0}),_(xh)!=="svelte-dst59w"&&(xh.innerHTML=_J),eT.forEach(n),a1=r(L),Qn=l(L,"DIV",{class:!0});var tT=T(Qn);g(Ei.$$.fragment,tT),r1=r(tT),Jh=l(tT,"P",{"data-svelte-h":!0}),_(Jh)!=="svelte-15y4kd1"&&(Jh.innerHTML=yJ),tT.forEach(n),L.forEach(n),ly=r(e),D=l(e,"DIV",{class:!0});var Ye=T(D);g(qi.$$.fragment,Ye),o1=r(Ye),Uh=l(Ye,"P",{"data-svelte-h":!0}),_(Uh)!=="svelte-1x0oesy"&&(Uh.innerHTML=TJ),l1=r(Ye),Zh=l(Ye,"P",{"data-svelte-h":!0}),_(Zh)!=="svelte-2ai6qp"&&(Zh.innerHTML=MJ),i1=r(Ye),Ch=l(Ye,"P",{"data-svelte-h":!0}),_(Ch)!=="svelte-18fduhd"&&(Ch.innerHTML=vJ),c1=r(Ye),Wh=l(Ye,"DIV",{class:!0});var yZ=T(Wh);g(Di.$$.fragment,yZ),yZ.forEach(n),d1=r(Ye),Yn=l(Ye,"DIV",{class:!0});var sT=T(Yn);g(Qi.$$.fragment,sT),p1=r(sT),Bh=l(sT,"P",{"data-svelte-h":!0}),_(Bh)!=="svelte-1nftdf9"&&(Bh.textContent=wJ),sT.forEach(n),Ye.forEach(n),iy=r(e),Rt=l(e,"DIV",{class:!0});var wf=T(Rt);g(Yi.$$.fragment,wf),m1=r(wf),Ih=l(wf,"P",{"data-svelte-h":!0}),_(Ih)!=="svelte-pjm1pe"&&(Ih.innerHTML=kJ),g1=r(wf),g(Pn.$$.fragment,wf),wf.forEach(n),cy=r(e),Lt=l(e,"DIV",{class:!0});var kf=T(Lt);g(Pi.$$.fragment,kf),h1=r(kf),zh=l(kf,"P",{"data-svelte-h":!0}),_(zh)!=="svelte-api7s7"&&(zh.innerHTML=$J),u1=r(kf),g(An.$$.fragment,kf),kf.forEach(n),dy=r(e),X=l(e,"DIV",{class:!0});var ve=T(X);g(Ai.$$.fragment,ve),f1=r(ve),Vh=l(ve,"P",{"data-svelte-h":!0}),_(Vh)!=="svelte-ldcea6"&&(Vh.innerHTML=jJ),b1=r(ve),Gh=l(ve,"P",{"data-svelte-h":!0}),_(Gh)!=="svelte-1f9j82e"&&(Gh.innerHTML=xJ),_1=r(ve),g(On.$$.fragment,ve),y1=r(ve),Kn=l(ve,"DIV",{class:!0});var nT=T(Kn);g(Oi.$$.fragment,nT),T1=r(nT),Fh=l(nT,"P",{"data-svelte-h":!0}),_(Fh)!=="svelte-dfcv5s"&&(Fh.innerHTML=JJ),nT.forEach(n),M1=r(ve),ea=l(ve,"DIV",{class:!0});var aT=T(ea);g(Ki.$$.fragment,aT),v1=r(aT),Xh=l(aT,"P",{"data-svelte-h":!0}),_(Xh)!=="svelte-1nftdf9"&&(Xh.textContent=UJ),aT.forEach(n),w1=r(ve),ta=l(ve,"DIV",{class:!0});var rT=T(ta);g(ec.$$.fragment,rT),k1=r(rT),Rh=l(rT,"P",{"data-svelte-h":!0}),_(Rh)!=="svelte-114iuj0"&&(Rh.textContent=ZJ),rT.forEach(n),ve.forEach(n),py=r(e),Q=l(e,"DIV",{class:!0});var Pe=T(Q);g(tc.$$.fragment,Pe),$1=r(Pe),Lh=l(Pe,"P",{"data-svelte-h":!0}),_(Lh)!=="svelte-8o3e5p"&&(Lh.textContent=CJ),j1=r(Pe),Nh=l(Pe,"P",{"data-svelte-h":!0}),_(Nh)!=="svelte-1cyjk9y"&&(Nh.textContent=WJ),x1=r(Pe),sa=l(Pe,"DIV",{class:!0});var oT=T(sa);g(sc.$$.fragment,oT),J1=r(oT),Sh=l(oT,"P",{"data-svelte-h":!0}),_(Sh)!=="svelte-dfcv5s"&&(Sh.innerHTML=BJ),oT.forEach(n),U1=r(Pe),na=l(Pe,"DIV",{class:!0});var lT=T(na);g(nc.$$.fragment,lT),Z1=r(lT),Hh=l(lT,"P",{"data-svelte-h":!0}),_(Hh)!=="svelte-t93z5n"&&(Hh.textContent=IJ),lT.forEach(n),C1=r(Pe),aa=l(Pe,"DIV",{class:!0});var iT=T(aa);g(ac.$$.fragment,iT),W1=r(iT),Eh=l(iT,"P",{"data-svelte-h":!0}),_(Eh)!=="svelte-1rjgo2n"&&(Eh.textContent=zJ),iT.forEach(n),Pe.forEach(n),my=r(e),Y=l(e,"DIV",{class:!0});var Ae=T(Y);g(rc.$$.fragment,Ae),B1=r(Ae),qh=l(Ae,"P",{"data-svelte-h":!0}),_(qh)!=="svelte-1atvuc"&&(qh.innerHTML=VJ),I1=r(Ae),g(ra.$$.fragment,Ae),z1=r(Ae),oa=l(Ae,"DIV",{class:!0});var cT=T(oa);g(oc.$$.fragment,cT),V1=r(cT),Dh=l(cT,"P",{"data-svelte-h":!0}),_(Dh)!=="svelte-vi6d54"&&(Dh.innerHTML=GJ),cT.forEach(n),G1=r(Ae),la=l(Ae,"DIV",{class:!0});var dT=T(la);g(lc.$$.fragment,dT),F1=r(dT),Qh=l(dT,"P",{"data-svelte-h":!0}),_(Qh)!=="svelte-14hqs6n"&&(Qh.textContent=FJ),dT.forEach(n),X1=r(Ae),ia=l(Ae,"DIV",{class:!0});var pT=T(ia);g(ic.$$.fragment,pT),R1=r(pT),Yh=l(pT,"P",{"data-svelte-h":!0}),_(Yh)!=="svelte-135okg0"&&(Yh.textContent=XJ),pT.forEach(n),Ae.forEach(n),gy=r(e),P=l(e,"DIV",{class:!0});var Oe=T(P);g(cc.$$.fragment,Oe),L1=r(Oe),Ph=l(Oe,"P",{"data-svelte-h":!0}),_(Ph)!=="svelte-t1noj8"&&(Ph.innerHTML=RJ),N1=r(Oe),g(ca.$$.fragment,Oe),S1=r(Oe),da=l(Oe,"DIV",{class:!0});var mT=T(da);g(dc.$$.fragment,mT),H1=r(mT),Ah=l(mT,"P",{"data-svelte-h":!0}),_(Ah)!=="svelte-vi6d54"&&(Ah.innerHTML=LJ),mT.forEach(n),E1=r(Oe),pa=l(Oe,"DIV",{class:!0});var gT=T(pa);g(pc.$$.fragment,gT),q1=r(gT),Oh=l(gT,"P",{"data-svelte-h":!0}),_(Oh)!=="svelte-14hqs6n"&&(Oh.textContent=NJ),gT.forEach(n),D1=r(Oe),ma=l(Oe,"DIV",{class:!0});var hT=T(ma);g(mc.$$.fragment,hT),Q1=r(hT),Kh=l(hT,"P",{"data-svelte-h":!0}),_(Kh)!=="svelte-oxae9u"&&(Kh.textContent=SJ),hT.forEach(n),Oe.forEach(n),hy=r(e),A=l(e,"DIV",{class:!0});var Ke=T(A);g(gc.$$.fragment,Ke),Y1=r(Ke),eu=l(Ke,"P",{"data-svelte-h":!0}),_(eu)!=="svelte-oxdq12"&&(eu.innerHTML=HJ),P1=r(Ke),g(ga.$$.fragment,Ke),A1=r(Ke),tu=l(Ke,"DIV",{class:!0});var TZ=T(tu);g(hc.$$.fragment,TZ),TZ.forEach(n),O1=r(Ke),su=l(Ke,"DIV",{class:!0});var MZ=T(su);g(uc.$$.fragment,MZ),MZ.forEach(n),K1=r(Ke),ha=l(Ke,"DIV",{class:!0});var uT=T(ha);g(fc.$$.fragment,uT),e$=r(uT),nu=l(uT,"P",{"data-svelte-h":!0}),_(nu)!=="svelte-135okg0"&&(nu.textContent=EJ),uT.forEach(n),Ke.forEach(n),uy=r(e),z=l(e,"DIV",{class:!0});var ee=T(z);g(bc.$$.fragment,ee),t$=r(ee),au=l(ee,"P",{"data-svelte-h":!0}),_(au)!=="svelte-16jubgm"&&(au.innerHTML=qJ),s$=r(ee),ru=l(ee,"P",{"data-svelte-h":!0}),_(ru)!=="svelte-437xch"&&(ru.innerHTML=DJ),n$=r(ee),ou=l(ee,"P",{"data-svelte-h":!0}),_(ou)!=="svelte-1qvpx79"&&(ou.textContent=QJ),a$=r(ee),lu=l(ee,"P",{"data-svelte-h":!0}),_(lu)!=="svelte-dhmy5x"&&(lu.innerHTML=YJ),r$=r(ee),g(ua.$$.fragment,ee),o$=r(ee),iu=l(ee,"DIV",{class:!0});var vZ=T(iu);g(_c.$$.fragment,vZ),vZ.forEach(n),l$=r(ee),cu=l(ee,"DIV",{class:!0});var wZ=T(cu);g(yc.$$.fragment,wZ),wZ.forEach(n),ee.forEach(n),fy=r(e),V=l(e,"DIV",{class:!0});var te=T(V);g(Tc.$$.fragment,te),i$=r(te),du=l(te,"P",{"data-svelte-h":!0}),_(du)!=="svelte-biazxg"&&(du.textContent=PJ),c$=r(te),g(fa.$$.fragment,te),d$=r(te),ba=l(te,"DIV",{class:!0});var fT=T(ba);g(Mc.$$.fragment,fT),p$=r(fT),pu=l(fT,"P",{"data-svelte-h":!0}),_(pu)!=="svelte-1nftdf9"&&(pu.textContent=AJ),fT.forEach(n),m$=r(te),_a=l(te,"DIV",{class:!0});var bT=T(_a);g(vc.$$.fragment,bT),g$=r(bT),mu=l(bT,"P",{"data-svelte-h":!0}),_(mu)!=="svelte-qvnpmr"&&(mu.innerHTML=OJ),bT.forEach(n),h$=r(te),ya=l(te,"DIV",{class:!0});var _T=T(ya);g(wc.$$.fragment,_T),u$=r(_T),gu=l(_T,"P",{"data-svelte-h":!0}),_(gu)!=="svelte-1tx1mox"&&(gu.innerHTML=KJ),_T.forEach(n),f$=r(te),hu=l(te,"DIV",{class:!0});var kZ=T(hu);g(kc.$$.fragment,kZ),kZ.forEach(n),b$=r(te),Ta=l(te,"DIV",{class:!0});var yT=T(Ta);g($c.$$.fragment,yT),_$=r(yT),uu=l(yT,"P",{"data-svelte-h":!0}),_(uu)!=="svelte-114iuj0"&&(uu.textContent=eU),yT.forEach(n),te.forEach(n),by=r(e),O=l(e,"DIV",{class:!0});var et=T(O);g(jc.$$.fragment,et),y$=r(et),fu=l(et,"P",{"data-svelte-h":!0}),_(fu)!=="svelte-plgsbf"&&(fu.textContent=tU),T$=r(et),g(Ma.$$.fragment,et),M$=r(et),bu=l(et,"DIV",{class:!0});var $Z=T(bu);g(xc.$$.fragment,$Z),$Z.forEach(n),v$=r(et),_u=l(et,"DIV",{class:!0});var jZ=T(_u);g(Jc.$$.fragment,jZ),jZ.forEach(n),w$=r(et),yu=l(et,"DIV",{class:!0});var xZ=T(yu);g(Uc.$$.fragment,xZ),xZ.forEach(n),et.forEach(n),_y=r(e),g(Zc.$$.fragment,e),yy=r(e),he=l(e,"DIV",{class:!0});var ds=T(he);g(Cc.$$.fragment,ds),k$=r(ds),Tu=l(ds,"P",{"data-svelte-h":!0}),_(Tu)!=="svelte-8pa9bo"&&(Tu.innerHTML=sU),$$=r(ds),Mu=l(ds,"P",{"data-svelte-h":!0}),_(Mu)!=="svelte-1wzt57b"&&(Mu.textContent=nU),j$=r(ds),vu=l(ds,"UL",{"data-svelte-h":!0}),_(vu)!=="svelte-vgskhd"&&(vu.innerHTML=aU),x$=r(ds),va=l(ds,"DIV",{class:!0});var TT=T(va);g(Wc.$$.fragment,TT),J$=r(TT),wu=l(TT,"P",{"data-svelte-h":!0}),_(wu)!=="svelte-1eed40t"&&(wu.textContent=rU),TT.forEach(n),ds.forEach(n),Ty=r(e),ue=l(e,"DIV",{class:!0});var ps=T(ue);g(Bc.$$.fragment,ps),U$=r(ps),ku=l(ps,"P",{"data-svelte-h":!0}),_(ku)!=="svelte-17osgxw"&&(ku.innerHTML=oU),Z$=r(ps),$u=l(ps,"P",{"data-svelte-h":!0}),_($u)!=="svelte-y9hsik"&&($u.innerHTML=lU),C$=r(ps),g(wa.$$.fragment,ps),W$=r(ps),ka=l(ps,"DIV",{class:!0});var MT=T(ka);g(Ic.$$.fragment,MT),B$=r(MT),ju=l(MT,"P",{"data-svelte-h":!0}),_(ju)!=="svelte-8xv78e"&&(ju.textContent=iU),MT.forEach(n),ps.forEach(n),My=r(e),Nt=l(e,"DIV",{class:!0});var $f=T(Nt);g(zc.$$.fragment,$f),I$=r($f),xu=l($f,"P",{"data-svelte-h":!0}),_(xu)!=="svelte-1fls76z"&&(xu.innerHTML=cU),z$=r($f),Ju=l($f,"P",{"data-svelte-h":!0}),_(Ju)!=="svelte-o55m63"&&(Ju.innerHTML=dU),$f.forEach(n),vy=r(e),R=l(e,"DIV",{class:!0});var we=T(R);g(Vc.$$.fragment,we),V$=r(we),Uu=l(we,"P",{"data-svelte-h":!0}),_(Uu)!=="svelte-ti06z9"&&(Uu.textContent=pU),G$=r(we),Zu=l(we,"P",{"data-svelte-h":!0}),_(Zu)!=="svelte-vwtjd"&&(Zu.innerHTML=mU),F$=r(we),Cu=l(we,"P",{"data-svelte-h":!0}),_(Cu)!=="svelte-m9ljkx"&&(Cu.textContent=gU),X$=r(we),Wu=l(we,"P",{"data-svelte-h":!0}),_(Wu)!=="svelte-6pahdo"&&(Wu.innerHTML=hU),R$=r(we),Bu=l(we,"P",{"data-svelte-h":!0}),_(Bu)!=="svelte-hswkmf"&&(Bu.innerHTML=uU),L$=r(we),$a=l(we,"DIV",{class:!0});var vT=T($a);g(Gc.$$.fragment,vT),N$=r(vT),Iu=l(vT,"P",{"data-svelte-h":!0}),_(Iu)!=="svelte-1pf58kz"&&(Iu.textContent=fU),vT.forEach(n),we.forEach(n),wy=r(e),St=l(e,"DIV",{class:!0});var jf=T(St);g(Fc.$$.fragment,jf),S$=r(jf),zu=l(jf,"P",{"data-svelte-h":!0}),_(zu)!=="svelte-1hdm2wz"&&(zu.innerHTML=bU),H$=r(jf),g(ja.$$.fragment,jf),jf.forEach(n),ky=r(e),fe=l(e,"DIV",{class:!0});var ms=T(fe);g(Xc.$$.fragment,ms),E$=r(ms),Vu=l(ms,"P",{"data-svelte-h":!0}),_(Vu)!=="svelte-8dvois"&&(Vu.textContent=_U),q$=r(ms),Gu=l(ms,"P",{"data-svelte-h":!0}),_(Gu)!=="svelte-1xpqz8m"&&(Gu.textContent=yU),D$=r(ms),g(xa.$$.fragment,ms),Q$=r(ms),Fu=l(ms,"DIV",{class:!0});var JZ=T(Fu);g(Rc.$$.fragment,JZ),JZ.forEach(n),ms.forEach(n),$y=r(e),g(Lc.$$.fragment,e),jy=r(e),Se=l(e,"DIV",{class:!0});var Xa=T(Se);g(Nc.$$.fragment,Xa),Y$=r(Xa),Xu=l(Xa,"P",{"data-svelte-h":!0}),_(Xu)!=="svelte-1q732ae"&&(Xu.innerHTML=TU),P$=r(Xa),g(Ja.$$.fragment,Xa),A$=r(Xa),Ua=l(Xa,"DIV",{class:!0});var wT=T(Ua);g(Sc.$$.fragment,wT),O$=r(wT),Ru=l(wT,"P",{"data-svelte-h":!0}),_(Ru)!=="svelte-1eed40t"&&(Ru.textContent=MU),wT.forEach(n),Xa.forEach(n),xy=r(e),g(Hc.$$.fragment,e),Jy=r(e),xf=l(e,"P",{}),T(xf).forEach(n),this.h()},h(){M(i,"name","hf:doc:metadata"),M(i,"content",VC),M(gs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ys,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ts,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ms,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ws,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ud,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Od,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(np,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(cp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(up,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(em,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(am,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(om,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(km,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Im,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Om,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(eg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(og,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ig,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(es,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(eh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(th,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ih,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ch,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(En,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ea,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ta,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(na,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(aa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(la,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ia,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(da,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ma,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(su,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ha,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(iu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(cu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ba,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ya,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ta,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(va,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ka,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(St,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ua,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,i),p(e,$,c),p(e,y,c),p(e,d,c),h(w,e,c),p(e,s,c),p(e,k,c),p(e,Ef,c),h(La,e,c),p(e,qf,c),p(e,Na,c),p(e,Df,c),p(e,Sa,c),p(e,Qf,c),h(Ha,e,c),p(e,Yf,c),p(e,Ea,c),p(e,Pf,c),p(e,qa,c),p(e,Af,c),p(e,Da,c),p(e,Of,c),p(e,Qa,c),p(e,Kf,c),p(e,Ya,c),p(e,eb,c),h(Pa,e,c),p(e,tb,c),p(e,Aa,c),p(e,sb,c),p(e,Oa,c),p(e,nb,c),p(e,Ka,c),p(e,ab,c),h(er,e,c),p(e,rb,c),p(e,gs,c),h(tr,gs,null),t(gs,kT),t(gs,id),p(e,ob,c),p(e,hs,c),h(sr,hs,null),t(hs,$T),t(hs,cd),p(e,lb,c),p(e,us,c),h(nr,us,null),t(us,jT),t(us,dd),p(e,ib,c),p(e,fs,c),h(ar,fs,null),t(fs,xT),t(fs,pd),p(e,cb,c),h(rr,e,c),p(e,db,c),p(e,bs,c),h(or,bs,null),t(bs,JT),t(bs,md),p(e,pb,c),p(e,_s,c),h(lr,_s,null),t(_s,UT),t(_s,gd),p(e,mb,c),p(e,ys,c),h(ir,ys,null),t(ys,ZT),t(ys,hd),p(e,gb,c),p(e,Ts,c),h(cr,Ts,null),t(Ts,CT),t(Ts,ud),p(e,hb,c),p(e,Ms,c),h(dr,Ms,null),t(Ms,WT),t(Ms,fd),p(e,ub,c),p(e,vs,c),h(pr,vs,null),t(vs,BT),t(vs,bd),p(e,fb,c),p(e,ws,c),h(mr,ws,null),t(ws,IT),t(ws,_d),p(e,bb,c),p(e,ks,c),h(gr,ks,null),t(ks,zT),t(ks,yd),p(e,_b,c),p(e,$s,c),h(hr,$s,null),t($s,VT),t($s,Td),p(e,yb,c),p(e,js,c),h(ur,js,null),t(js,GT),t(js,Md),p(e,Tb,c),h(fr,e,c),p(e,Mb,c),p(e,tt,c),h(br,tt,null),t(tt,FT),t(tt,vd),t(tt,XT),t(tt,zs),h(_r,zs,null),t(zs,RT),t(zs,wd),p(e,vb,c),p(e,st,c),h(yr,st,null),t(st,LT),t(st,kd),t(st,NT),t(st,Vs),h(Tr,Vs,null),t(Vs,ST),t(Vs,$d),p(e,wb,c),p(e,nt,c),h(Mr,nt,null),t(nt,HT),t(nt,jd),t(nt,ET),t(nt,Gs),h(vr,Gs,null),t(Gs,qT),t(Gs,xd),p(e,kb,c),h(wr,e,c),p(e,$b,c),p(e,kr,c),p(e,jb,c),h($r,e,c),p(e,xb,c),p(e,ke,c),h(jr,ke,null),t(ke,DT),t(ke,Jd),t(ke,QT),h(Fs,ke,null),t(ke,YT),t(ke,Ud),h(xr,Ud,null),p(e,Jb,c),p(e,N,c),h(Jr,N,null),t(N,PT),t(N,Zd),t(N,AT),t(N,Cd),t(N,OT),h(Xs,N,null),t(N,KT),h(Rs,N,null),t(N,eM),t(N,Wd),h(Ur,Wd,null),p(e,Ub,c),p(e,ne,c),h(Zr,ne,null),t(ne,tM),t(ne,Bd),t(ne,sM),t(ne,Id),t(ne,nM),h(Ls,ne,null),t(ne,aM),t(ne,zd),h(Cr,zd,null),p(e,Zb,c),p(e,ae,c),h(Wr,ae,null),t(ae,rM),t(ae,Vd),t(ae,oM),t(ae,Gd),t(ae,lM),h(Ns,ae,null),t(ae,iM),t(ae,Fd),h(Br,Fd,null),p(e,Cb,c),p(e,$e,c),h(Ir,$e,null),t($e,cM),t($e,Xd),t($e,dM),h(Ss,$e,null),t($e,pM),t($e,Rd),h(zr,Rd,null),p(e,Wb,c),p(e,je,c),h(Vr,je,null),t(je,mM),t(je,Ld),t(je,gM),h(Hs,je,null),t(je,hM),t(je,Nd),h(Gr,Nd,null),p(e,Bb,c),p(e,xe,c),h(Fr,xe,null),t(xe,uM),t(xe,Sd),t(xe,fM),h(Es,xe,null),t(xe,bM),t(xe,Hd),h(Xr,Hd,null),p(e,Ib,c),p(e,Je,c),h(Rr,Je,null),t(Je,_M),t(Je,Ed),t(Je,yM),h(qs,Je,null),t(Je,TM),t(Je,qd),h(Lr,qd,null),p(e,zb,c),p(e,Ue,c),h(Nr,Ue,null),t(Ue,MM),t(Ue,Dd),t(Ue,vM),h(Ds,Ue,null),t(Ue,wM),t(Ue,Qd),h(Sr,Qd,null),p(e,Vb,c),p(e,S,c),h(Hr,S,null),t(S,kM),t(S,Yd),t(S,$M),t(S,Pd),t(S,jM),t(S,Ad),t(S,xM),h(Qs,S,null),t(S,JM),t(S,Od),h(Er,Od,null),p(e,Gb,c),p(e,Ze,c),h(qr,Ze,null),t(Ze,UM),t(Ze,Kd),t(Ze,ZM),t(Ze,ep),t(Ze,CM),t(Ze,tp),h(Dr,tp,null),p(e,Fb,c),p(e,Ce,c),h(Qr,Ce,null),t(Ce,WM),t(Ce,sp),t(Ce,BM),h(Ys,Ce,null),t(Ce,IM),t(Ce,np),h(Yr,np,null),p(e,Xb,c),p(e,at,c),h(Pr,at,null),t(at,zM),t(at,ap),t(at,VM),t(at,rp),h(Ar,rp,null),p(e,Rb,c),p(e,rt,c),h(Or,rt,null),t(rt,GM),t(rt,op),t(rt,FM),t(rt,lp),h(Kr,lp,null),p(e,Lb,c),p(e,We,c),h(eo,We,null),t(We,XM),t(We,ip),t(We,RM),h(Ps,We,null),t(We,LM),t(We,cp),h(to,cp,null),p(e,Nb,c),p(e,Be,c),h(so,Be,null),t(Be,NM),t(Be,dp),t(Be,SM),h(As,Be,null),t(Be,HM),t(Be,pp),h(no,pp,null),p(e,Sb,c),p(e,H,c),h(ao,H,null),t(H,EM),t(H,mp),t(H,qM),t(H,gp),t(H,DM),t(H,hp),t(H,QM),h(Os,H,null),t(H,YM),t(H,up),h(ro,up,null),p(e,Hb,c),p(e,re,c),h(oo,re,null),t(re,PM),t(re,fp),t(re,AM),h(Ks,re,null),t(re,OM),h(en,re,null),t(re,KM),t(re,bp),h(lo,bp,null),p(e,Eb,c),p(e,oe,c),h(io,oe,null),t(oe,ev),t(oe,_p),t(oe,tv),h(tn,oe,null),t(oe,sv),h(sn,oe,null),t(oe,nv),t(oe,yp),h(co,yp,null),p(e,qb,c),p(e,Ie,c),h(po,Ie,null),t(Ie,av),t(Ie,Tp),t(Ie,rv),h(nn,Ie,null),t(Ie,ov),t(Ie,Mp),h(mo,Mp,null),p(e,Db,c),p(e,le,c),h(go,le,null),t(le,lv),t(le,vp),t(le,iv),t(le,wp),t(le,cv),h(an,le,null),t(le,dv),t(le,kp),h(ho,kp,null),p(e,Qb,c),p(e,ie,c),h(uo,ie,null),t(ie,pv),t(ie,$p),t(ie,mv),h(rn,ie,null),t(ie,gv),h(on,ie,null),t(ie,hv),t(ie,jp),h(fo,jp,null),p(e,Yb,c),p(e,ze,c),h(bo,ze,null),t(ze,uv),t(ze,xp),t(ze,fv),h(ln,ze,null),t(ze,bv),t(ze,Jp),h(_o,Jp,null),p(e,Pb,c),p(e,Ve,c),h(yo,Ve,null),t(Ve,_v),t(Ve,Up),t(Ve,yv),h(cn,Ve,null),t(Ve,Tv),t(Ve,Zp),h(To,Zp,null),p(e,Ab,c),p(e,G,c),h(Mo,G,null),t(G,Mv),t(G,Cp),t(G,vv),t(G,Wp),t(G,wv),t(G,Bp),t(G,kv),t(G,Ip),t(G,$v),h(dn,G,null),t(G,jv),t(G,zp),h(vo,zp,null),p(e,Ob,c),p(e,ce,c),h(wo,ce,null),t(ce,xv),t(ce,Vp),t(ce,Jv),h(pn,ce,null),t(ce,Uv),h(mn,ce,null),t(ce,Zv),t(ce,Gp),h(ko,Gp,null),p(e,Kb,c),p(e,Ge,c),h($o,Ge,null),t(Ge,Cv),t(Ge,Fp),t(Ge,Wv),h(gn,Ge,null),t(Ge,Bv),t(Ge,Xp),h(jo,Xp,null),p(e,e_,c),p(e,Fe,c),h(xo,Fe,null),t(Fe,Iv),t(Fe,Rp),t(Fe,zv),h(hn,Fe,null),t(Fe,Vv),t(Fe,Lp),h(Jo,Lp,null),p(e,t_,c),p(e,de,c),h(Uo,de,null),t(de,Gv),t(de,Np),t(de,Fv),t(de,Sp),t(de,Xv),h(un,de,null),t(de,Rv),t(de,Hp),h(Zo,Hp,null),p(e,s_,c),p(e,pe,c),h(Co,pe,null),t(pe,Lv),t(pe,Ep),t(pe,Nv),t(pe,qp),t(pe,Sv),h(fn,pe,null),t(pe,Hv),t(pe,Dp),h(Wo,Dp,null),p(e,n_,c),p(e,me,c),h(Bo,me,null),t(me,Ev),t(me,Qp),t(me,qv),t(me,Yp),t(me,Dv),h(bn,me,null),t(me,Qv),t(me,Pp),h(Io,Pp,null),p(e,a_,c),p(e,E,c),h(zo,E,null),t(E,Yv),t(E,Ap),t(E,Pv),t(E,Op),t(E,Av),t(E,Kp),t(E,Ov),h(_n,E,null),t(E,Kv),t(E,em),h(Vo,em,null),p(e,r_,c),h(Go,e,c),p(e,o_,c),p(e,ot,c),h(Fo,ot,null),t(ot,ew),t(ot,tm),t(ot,tw),t(ot,sm),h(Xo,sm,null),p(e,l_,c),p(e,lt,c),h(Ro,lt,null),t(lt,sw),t(lt,nm),t(lt,nw),t(lt,am),h(Lo,am,null),p(e,i_,c),p(e,it,c),h(No,it,null),t(it,aw),t(it,rm),t(it,rw),t(it,om),h(So,om,null),p(e,c_,c),p(e,ct,c),h(Ho,ct,null),t(ct,ow),t(ct,lm),t(ct,lw),t(ct,yn),h(Eo,yn,null),t(yn,iw),t(yn,im),p(e,d_,c),p(e,dt,c),h(qo,dt,null),t(dt,cw),t(dt,cm),t(dt,dw),t(dt,dm),h(Do,dm,null),p(e,p_,c),p(e,pt,c),h(Qo,pt,null),t(pt,pw),t(pt,pm),t(pt,mw),t(pt,Tn),h(Yo,Tn,null),t(Tn,gw),t(Tn,mm),p(e,m_,c),p(e,mt,c),h(Po,mt,null),t(mt,hw),t(mt,gm),t(mt,uw),t(mt,hm),h(Ao,hm,null),p(e,g_,c),p(e,gt,c),h(Oo,gt,null),t(gt,fw),t(gt,um),t(gt,bw),t(gt,fm),h(Ko,fm,null),p(e,h_,c),p(e,ht,c),h(el,ht,null),t(ht,_w),t(ht,bm),t(ht,yw),t(ht,_m),h(tl,_m,null),p(e,u_,c),p(e,ut,c),h(sl,ut,null),t(ut,Tw),t(ut,ym),t(ut,Mw),t(ut,Tm),h(nl,Tm,null),p(e,f_,c),p(e,ft,c),h(al,ft,null),t(ft,vw),t(ft,Mm),t(ft,ww),t(ft,vm),h(rl,vm,null),p(e,b_,c),p(e,bt,c),h(ol,bt,null),t(bt,kw),t(bt,wm),t(bt,$w),t(bt,km),h(ll,km,null),p(e,__,c),p(e,_t,c),h(il,_t,null),t(_t,jw),t(_t,$m),t(_t,xw),t(_t,jm),h(cl,jm,null),p(e,y_,c),p(e,yt,c),h(dl,yt,null),t(yt,Jw),t(yt,xm),t(yt,Uw),t(yt,Jm),h(pl,Jm,null),p(e,T_,c),p(e,Tt,c),h(ml,Tt,null),t(Tt,Zw),t(Tt,Um),t(Tt,Cw),t(Tt,Zm),h(gl,Zm,null),p(e,M_,c),h(hl,e,c),p(e,v_,c),p(e,Mt,c),h(ul,Mt,null),t(Mt,Ww),t(Mt,Cm),t(Mt,Bw),t(Mt,Wm),h(fl,Wm,null),p(e,w_,c),p(e,vt,c),h(bl,vt,null),t(vt,Iw),t(vt,Bm),t(vt,zw),t(vt,Im),h(_l,Im,null),p(e,k_,c),p(e,wt,c),h(yl,wt,null),t(wt,Vw),t(wt,zm),t(wt,Gw),t(wt,Vm),h(Tl,Vm,null),p(e,$_,c),p(e,kt,c),h(Ml,kt,null),t(kt,Fw),t(kt,Gm),t(kt,Xw),t(kt,Mn),h(vl,Mn,null),t(Mn,Rw),t(Mn,Fm),p(e,j_,c),p(e,$t,c),h(wl,$t,null),t($t,Lw),t($t,Xm),t($t,Nw),t($t,Rm),h(kl,Rm,null),p(e,x_,c),p(e,jt,c),h($l,jt,null),t(jt,Sw),t(jt,Lm),t(jt,Hw),t(jt,vn),h(jl,vn,null),t(vn,Ew),t(vn,Nm),p(e,J_,c),p(e,xt,c),h(xl,xt,null),t(xt,qw),t(xt,Sm),t(xt,Dw),t(xt,Hm),h(Jl,Hm,null),p(e,U_,c),p(e,Jt,c),h(Ul,Jt,null),t(Jt,Qw),t(Jt,Em),t(Jt,Yw),t(Jt,qm),h(Zl,qm,null),p(e,Z_,c),p(e,Ut,c),h(Cl,Ut,null),t(Ut,Pw),t(Ut,Dm),t(Ut,Aw),t(Ut,Qm),h(Wl,Qm,null),p(e,C_,c),p(e,Zt,c),h(Bl,Zt,null),t(Zt,Ow),t(Zt,Ym),t(Zt,Kw),t(Zt,Pm),h(Il,Pm,null),p(e,W_,c),p(e,Ct,c),h(zl,Ct,null),t(Ct,e2),t(Ct,Am),t(Ct,t2),t(Ct,Om),h(Vl,Om,null),p(e,B_,c),p(e,Wt,c),h(Gl,Wt,null),t(Wt,s2),t(Wt,Km),t(Wt,n2),t(Wt,eg),h(Fl,eg,null),p(e,I_,c),p(e,Bt,c),h(Xl,Bt,null),t(Bt,a2),t(Bt,tg),t(Bt,r2),t(Bt,sg),h(Rl,sg,null),p(e,z_,c),h(Ll,e,c),p(e,V_,c),p(e,Nl,c),p(e,G_,c),p(e,Xe,c),h(Sl,Xe,null),t(Xe,o2),t(Xe,ng),t(Xe,l2),t(Xe,ag),t(Xe,i2),t(Xe,rg),h(Hl,rg,null),p(e,F_,c),p(e,xs,c),h(El,xs,null),t(xs,c2),t(xs,og),h(ql,og,null),p(e,X_,c),p(e,It,c),h(Dl,It,null),t(It,d2),t(It,lg),t(It,p2),t(It,ig),h(Ql,ig,null),p(e,R_,c),p(e,zt,c),h(Yl,zt,null),t(zt,m2),t(zt,cg),t(zt,g2),t(zt,dg),h(Pl,dg,null),p(e,L_,c),p(e,J,c),h(Al,J,null),t(J,h2),t(J,pg),t(J,u2),t(J,mg),t(J,f2),t(J,gg),t(J,b2),t(J,hg),t(J,_2),t(J,ug),t(J,y2),t(J,fg),t(J,T2),t(J,bg),t(J,M2),t(J,_g),t(J,v2),t(J,yg),t(J,w2),t(J,Tg),t(J,k2),t(J,Mg),t(J,$2),t(J,vg),t(J,j2),t(J,wg),t(J,x2),t(J,kg),t(J,J2),t(J,$g),t(J,U2),t(J,jg),t(J,Z2),t(J,xg),t(J,C2),t(J,Jg),t(J,W2),t(J,Ug),t(J,B2),h(wn,J,null),t(J,I2),t(J,Zg),h(Ol,Zg,null),p(e,N_,c),p(e,Vt,c),h(Kl,Vt,null),t(Vt,z2),t(Vt,Cg),t(Vt,V2),t(Vt,Wg),h(ei,Wg,null),p(e,S_,c),h(ti,e,c),p(e,H_,c),p(e,si,c),p(e,E_,c),p(e,W,c),h(ni,W,null),t(W,G2),t(W,Bg),t(W,F2),t(W,Ig),t(W,X2),h(kn,W,null),t(W,R2),t(W,zg),t(W,L2),t(W,$n),h(ai,$n,null),t($n,N2),t($n,Vg),t(W,S2),t(W,jn),h(ri,jn,null),t(jn,H2),t(jn,Gg),t(W,E2),t(W,xn),h(oi,xn,null),t(xn,q2),t(xn,Fg),t(W,D2),t(W,Jn),h(li,Jn,null),t(Jn,Q2),t(Jn,Xg),t(W,Y2),t(W,Un),h(ii,Un,null),t(Un,P2),t(Un,Rg),t(W,A2),t(W,Zn),h(ci,Zn,null),t(Zn,O2),t(Zn,Lg),t(W,K2),t(W,es),h(di,es,null),t(es,ek),t(es,Ng),t(es,tk),t(es,Sg),p(e,q_,c),p(e,Js,c),h(pi,Js,null),t(Js,sk),t(Js,Hg),p(e,D_,c),p(e,Us,c),h(mi,Us,null),t(Us,nk),t(Us,Eg),p(e,Q_,c),p(e,Re,c),h(gi,Re,null),t(Re,ak),t(Re,qg),t(Re,rk),t(Re,K),h(hi,K,null),t(K,ok),t(K,Dg),t(K,lk),t(K,Qg),t(K,ik),t(K,Yg),t(K,ck),t(K,Pg),t(K,dk),t(K,Ag),t(Re,pk),t(Re,Cn),h(ui,Cn,null),t(Cn,mk),t(Cn,Og),p(e,Y_,c),h(fi,e,c),p(e,P_,c),p(e,Le,c),h(bi,Le,null),t(Le,gk),t(Le,Kg),t(Le,hk),t(Le,eh),h(_i,eh,null),t(Le,uk),t(Le,th),h(yi,th,null),p(e,A_,c),p(e,q,c),h(Ti,q,null),t(q,fk),t(q,sh),t(q,bk),t(q,nh),t(q,_k),t(q,ah),t(q,yk),t(q,rh),h(Mi,rh,null),t(q,Tk),t(q,oh),h(vi,oh,null),p(e,O_,c),p(e,Ne,c),h(wi,Ne,null),t(Ne,Mk),t(Ne,lh),t(Ne,vk),t(Ne,ih),h(ki,ih,null),t(Ne,wk),t(Ne,ch),h($i,ch,null),p(e,K_,c),h(ji,e,c),p(e,ey,c),p(e,F,c),h(xi,F,null),t(F,kk),t(F,dh),t(F,$k),h(Wn,F,null),t(F,jk),h(Bn,F,null),t(F,xk),t(F,In),h(Ji,In,null),t(In,Jk),t(In,ph),t(F,Uk),t(F,zn),h(Ui,zn,null),t(zn,Zk),t(zn,mh),t(F,Ck),t(F,Vn),h(Zi,Vn,null),t(Vn,Wk),t(Vn,gh),p(e,ty,c),p(e,ge,c),h(Ci,ge,null),t(ge,Bk),t(ge,hh),t(ge,Ik),h(Gn,ge,null),t(ge,zk),h(Fn,ge,null),t(ge,Vk),t(ge,Xn),h(Wi,Xn,null),t(Xn,Gk),t(Xn,uh),p(e,sy,c),h(Bi,e,c),p(e,ny,c),p(e,Gt,c),h(Ii,Gt,null),t(Gt,Fk),t(Gt,fh),t(Gt,Xk),t(Gt,Rn),h(zi,Rn,null),t(Rn,Rk),t(Rn,bh),p(e,ay,c),p(e,Ft,c),h(Vi,Ft,null),t(Ft,Lk),t(Ft,_h),t(Ft,Nk),t(Ft,Ln),h(Gi,Ln,null),t(Ln,Sk),t(Ln,yh),p(e,ry,c),p(e,Xt,c),h(Fi,Xt,null),t(Xt,Hk),t(Xt,Th),t(Xt,Ek),t(Xt,Nn),h(Xi,Nn,null),t(Nn,qk),t(Nn,Mh),p(e,oy,c),p(e,I,c),h(Ri,I,null),t(I,Dk),t(I,vh),t(I,Qk),t(I,wh),t(I,Yk),h(Sn,I,null),t(I,Pk),t(I,Hn),h(Li,Hn,null),t(Hn,Ak),t(Hn,kh),t(I,Ok),t(I,En),h(Ni,En,null),t(En,Kk),t(En,$h),t(I,e1),t(I,qn),h(Si,qn,null),t(qn,t1),t(qn,jh),t(I,s1),t(I,Dn),h(Hi,Dn,null),t(Dn,n1),t(Dn,xh),t(I,a1),t(I,Qn),h(Ei,Qn,null),t(Qn,r1),t(Qn,Jh),p(e,ly,c),p(e,D,c),h(qi,D,null),t(D,o1),t(D,Uh),t(D,l1),t(D,Zh),t(D,i1),t(D,Ch),t(D,c1),t(D,Wh),h(Di,Wh,null),t(D,d1),t(D,Yn),h(Qi,Yn,null),t(Yn,p1),t(Yn,Bh),p(e,iy,c),p(e,Rt,c),h(Yi,Rt,null),t(Rt,m1),t(Rt,Ih),t(Rt,g1),h(Pn,Rt,null),p(e,cy,c),p(e,Lt,c),h(Pi,Lt,null),t(Lt,h1),t(Lt,zh),t(Lt,u1),h(An,Lt,null),p(e,dy,c),p(e,X,c),h(Ai,X,null),t(X,f1),t(X,Vh),t(X,b1),t(X,Gh),t(X,_1),h(On,X,null),t(X,y1),t(X,Kn),h(Oi,Kn,null),t(Kn,T1),t(Kn,Fh),t(X,M1),t(X,ea),h(Ki,ea,null),t(ea,v1),t(ea,Xh),t(X,w1),t(X,ta),h(ec,ta,null),t(ta,k1),t(ta,Rh),p(e,py,c),p(e,Q,c),h(tc,Q,null),t(Q,$1),t(Q,Lh),t(Q,j1),t(Q,Nh),t(Q,x1),t(Q,sa),h(sc,sa,null),t(sa,J1),t(sa,Sh),t(Q,U1),t(Q,na),h(nc,na,null),t(na,Z1),t(na,Hh),t(Q,C1),t(Q,aa),h(ac,aa,null),t(aa,W1),t(aa,Eh),p(e,my,c),p(e,Y,c),h(rc,Y,null),t(Y,B1),t(Y,qh),t(Y,I1),h(ra,Y,null),t(Y,z1),t(Y,oa),h(oc,oa,null),t(oa,V1),t(oa,Dh),t(Y,G1),t(Y,la),h(lc,la,null),t(la,F1),t(la,Qh),t(Y,X1),t(Y,ia),h(ic,ia,null),t(ia,R1),t(ia,Yh),p(e,gy,c),p(e,P,c),h(cc,P,null),t(P,L1),t(P,Ph),t(P,N1),h(ca,P,null),t(P,S1),t(P,da),h(dc,da,null),t(da,H1),t(da,Ah),t(P,E1),t(P,pa),h(pc,pa,null),t(pa,q1),t(pa,Oh),t(P,D1),t(P,ma),h(mc,ma,null),t(ma,Q1),t(ma,Kh),p(e,hy,c),p(e,A,c),h(gc,A,null),t(A,Y1),t(A,eu),t(A,P1),h(ga,A,null),t(A,A1),t(A,tu),h(hc,tu,null),t(A,O1),t(A,su),h(uc,su,null),t(A,K1),t(A,ha),h(fc,ha,null),t(ha,e$),t(ha,nu),p(e,uy,c),p(e,z,c),h(bc,z,null),t(z,t$),t(z,au),t(z,s$),t(z,ru),t(z,n$),t(z,ou),t(z,a$),t(z,lu),t(z,r$),h(ua,z,null),t(z,o$),t(z,iu),h(_c,iu,null),t(z,l$),t(z,cu),h(yc,cu,null),p(e,fy,c),p(e,V,c),h(Tc,V,null),t(V,i$),t(V,du),t(V,c$),h(fa,V,null),t(V,d$),t(V,ba),h(Mc,ba,null),t(ba,p$),t(ba,pu),t(V,m$),t(V,_a),h(vc,_a,null),t(_a,g$),t(_a,mu),t(V,h$),t(V,ya),h(wc,ya,null),t(ya,u$),t(ya,gu),t(V,f$),t(V,hu),h(kc,hu,null),t(V,b$),t(V,Ta),h($c,Ta,null),t(Ta,_$),t(Ta,uu),p(e,by,c),p(e,O,c),h(jc,O,null),t(O,y$),t(O,fu),t(O,T$),h(Ma,O,null),t(O,M$),t(O,bu),h(xc,bu,null),t(O,v$),t(O,_u),h(Jc,_u,null),t(O,w$),t(O,yu),h(Uc,yu,null),p(e,_y,c),h(Zc,e,c),p(e,yy,c),p(e,he,c),h(Cc,he,null),t(he,k$),t(he,Tu),t(he,$$),t(he,Mu),t(he,j$),t(he,vu),t(he,x$),t(he,va),h(Wc,va,null),t(va,J$),t(va,wu),p(e,Ty,c),p(e,ue,c),h(Bc,ue,null),t(ue,U$),t(ue,ku),t(ue,Z$),t(ue,$u),t(ue,C$),h(wa,ue,null),t(ue,W$),t(ue,ka),h(Ic,ka,null),t(ka,B$),t(ka,ju),p(e,My,c),p(e,Nt,c),h(zc,Nt,null),t(Nt,I$),t(Nt,xu),t(Nt,z$),t(Nt,Ju),p(e,vy,c),p(e,R,c),h(Vc,R,null),t(R,V$),t(R,Uu),t(R,G$),t(R,Zu),t(R,F$),t(R,Cu),t(R,X$),t(R,Wu),t(R,R$),t(R,Bu),t(R,L$),t(R,$a),h(Gc,$a,null),t($a,N$),t($a,Iu),p(e,wy,c),p(e,St,c),h(Fc,St,null),t(St,S$),t(St,zu),t(St,H$),h(ja,St,null),p(e,ky,c),p(e,fe,c),h(Xc,fe,null),t(fe,E$),t(fe,Vu),t(fe,q$),t(fe,Gu),t(fe,D$),h(xa,fe,null),t(fe,Q$),t(fe,Fu),h(Rc,Fu,null),p(e,$y,c),h(Lc,e,c),p(e,jy,c),p(e,Se,c),h(Nc,Se,null),t(Se,Y$),t(Se,Xu),t(Se,P$),h(Ja,Se,null),t(Se,A$),t(Se,Ua),h(Sc,Ua,null),t(Ua,O$),t(Ua,Ru),p(e,xy,c),h(Hc,e,c),p(e,Jy,c),p(e,xf,c),Uy=!0},p(e,[c]){const Ec={};c&2&&(Ec.$$scope={dirty:c,ctx:e}),Fs.$set(Ec);const qc={};c&2&&(qc.$$scope={dirty:c,ctx:e}),Xs.$set(qc);const Dc={};c&2&&(Dc.$$scope={dirty:c,ctx:e}),Rs.$set(Dc);const Qc={};c&2&&(Qc.$$scope={dirty:c,ctx:e}),Ls.$set(Qc);const Yc={};c&2&&(Yc.$$scope={dirty:c,ctx:e}),Ns.$set(Yc);const Pc={};c&2&&(Pc.$$scope={dirty:c,ctx:e}),Ss.$set(Pc);const Ac={};c&2&&(Ac.$$scope={dirty:c,ctx:e}),Hs.$set(Ac);const Oc={};c&2&&(Oc.$$scope={dirty:c,ctx:e}),Es.$set(Oc);const Kc={};c&2&&(Kc.$$scope={dirty:c,ctx:e}),qs.$set(Kc);const ed={};c&2&&(ed.$$scope={dirty:c,ctx:e}),Ds.$set(ed);const td={};c&2&&(td.$$scope={dirty:c,ctx:e}),Qs.$set(td);const sd={};c&2&&(sd.$$scope={dirty:c,ctx:e}),Ys.$set(sd);const nd={};c&2&&(nd.$$scope={dirty:c,ctx:e}),Ps.$set(nd);const ad={};c&2&&(ad.$$scope={dirty:c,ctx:e}),As.$set(ad);const Zs={};c&2&&(Zs.$$scope={dirty:c,ctx:e}),Os.$set(Zs);const rd={};c&2&&(rd.$$scope={dirty:c,ctx:e}),Ks.$set(rd);const Cs={};c&2&&(Cs.$$scope={dirty:c,ctx:e}),en.$set(Cs);const od={};c&2&&(od.$$scope={dirty:c,ctx:e}),tn.$set(od);const Ws={};c&2&&(Ws.$$scope={dirty:c,ctx:e}),sn.$set(Ws);const ld={};c&2&&(ld.$$scope={dirty:c,ctx:e}),nn.$set(ld);const Ht={};c&2&&(Ht.$$scope={dirty:c,ctx:e}),an.$set(Ht);const Jf={};c&2&&(Jf.$$scope={dirty:c,ctx:e}),rn.$set(Jf);const be={};c&2&&(be.$$scope={dirty:c,ctx:e}),on.$set(be);const Uf={};c&2&&(Uf.$$scope={dirty:c,ctx:e}),ln.$set(Uf);const He={};c&2&&(He.$$scope={dirty:c,ctx:e}),cn.$set(He);const Zf={};c&2&&(Zf.$$scope={dirty:c,ctx:e}),dn.$set(Zf);const Ee={};c&2&&(Ee.$$scope={dirty:c,ctx:e}),pn.$set(Ee);const Cf={};c&2&&(Cf.$$scope={dirty:c,ctx:e}),mn.$set(Cf);const Et={};c&2&&(Et.$$scope={dirty:c,ctx:e}),gn.$set(Et);const Wf={};c&2&&(Wf.$$scope={dirty:c,ctx:e}),hn.$set(Wf);const qt={};c&2&&(qt.$$scope={dirty:c,ctx:e}),un.$set(qt);const Bf={};c&2&&(Bf.$$scope={dirty:c,ctx:e}),fn.$set(Bf);const Dt={};c&2&&(Dt.$$scope={dirty:c,ctx:e}),bn.$set(Dt);const If={};c&2&&(If.$$scope={dirty:c,ctx:e}),_n.$set(If);const Qt={};c&2&&(Qt.$$scope={dirty:c,ctx:e}),wn.$set(Qt);const zf={};c&2&&(zf.$$scope={dirty:c,ctx:e}),kn.$set(zf);const Yt={};c&2&&(Yt.$$scope={dirty:c,ctx:e}),Wn.$set(Yt);const Vf={};c&2&&(Vf.$$scope={dirty:c,ctx:e}),Bn.$set(Vf);const _e={};c&2&&(_e.$$scope={dirty:c,ctx:e}),Gn.$set(_e);const Gf={};c&2&&(Gf.$$scope={dirty:c,ctx:e}),Fn.$set(Gf);const Pt={};c&2&&(Pt.$$scope={dirty:c,ctx:e}),Sn.$set(Pt);const Ff={};c&2&&(Ff.$$scope={dirty:c,ctx:e}),Pn.$set(Ff);const At={};c&2&&(At.$$scope={dirty:c,ctx:e}),An.$set(At);const Xf={};c&2&&(Xf.$$scope={dirty:c,ctx:e}),On.$set(Xf);const Bs={};c&2&&(Bs.$$scope={dirty:c,ctx:e}),ra.$set(Bs);const Rf={};c&2&&(Rf.$$scope={dirty:c,ctx:e}),ca.$set(Rf);const Is={};c&2&&(Is.$$scope={dirty:c,ctx:e}),ga.$set(Is);const Lf={};c&2&&(Lf.$$scope={dirty:c,ctx:e}),ua.$set(Lf);const Ot={};c&2&&(Ot.$$scope={dirty:c,ctx:e}),fa.$set(Ot);const Nf={};c&2&&(Nf.$$scope={dirty:c,ctx:e}),Ma.$set(Nf);const Kt={};c&2&&(Kt.$$scope={dirty:c,ctx:e}),wa.$set(Kt);const Sf={};c&2&&(Sf.$$scope={dirty:c,ctx:e}),ja.$set(Sf);const ye={};c&2&&(ye.$$scope={dirty:c,ctx:e}),xa.$set(ye);const Hf={};c&2&&(Hf.$$scope={dirty:c,ctx:e}),Ja.$set(Hf)},i(e){Uy||(u(w.$$.fragment,e),u(La.$$.fragment,e),u(Ha.$$.fragment,e),u(Pa.$$.fragment,e),u(er.$$.fragment,e),u(tr.$$.fragment,e),u(sr.$$.fragment,e),u(nr.$$.fragment,e),u(ar.$$.fragment,e),u(rr.$$.fragment,e),u(or.$$.fragment,e),u(lr.$$.fragment,e),u(ir.$$.fragment,e),u(cr.$$.fragment,e),u(dr.$$.fragment,e),u(pr.$$.fragment,e),u(mr.$$.fragment,e),u(gr.$$.fragment,e),u(hr.$$.fragment,e),u(ur.$$.fragment,e),u(fr.$$.fragment,e),u(br.$$.fragment,e),u(_r.$$.fragment,e),u(yr.$$.fragment,e),u(Tr.$$.fragment,e),u(Mr.$$.fragment,e),u(vr.$$.fragment,e),u(wr.$$.fragment,e),u($r.$$.fragment,e),u(jr.$$.fragment,e),u(Fs.$$.fragment,e),u(xr.$$.fragment,e),u(Jr.$$.fragment,e),u(Xs.$$.fragment,e),u(Rs.$$.fragment,e),u(Ur.$$.fragment,e),u(Zr.$$.fragment,e),u(Ls.$$.fragment,e),u(Cr.$$.fragment,e),u(Wr.$$.fragment,e),u(Ns.$$.fragment,e),u(Br.$$.fragment,e),u(Ir.$$.fragment,e),u(Ss.$$.fragment,e),u(zr.$$.fragment,e),u(Vr.$$.fragment,e),u(Hs.$$.fragment,e),u(Gr.$$.fragment,e),u(Fr.$$.fragment,e),u(Es.$$.fragment,e),u(Xr.$$.fragment,e),u(Rr.$$.fragment,e),u(qs.$$.fragment,e),u(Lr.$$.fragment,e),u(Nr.$$.fragment,e),u(Ds.$$.fragment,e),u(Sr.$$.fragment,e),u(Hr.$$.fragment,e),u(Qs.$$.fragment,e),u(Er.$$.fragment,e),u(qr.$$.fragment,e),u(Dr.$$.fragment,e),u(Qr.$$.fragment,e),u(Ys.$$.fragment,e),u(Yr.$$.fragment,e),u(Pr.$$.fragment,e),u(Ar.$$.fragment,e),u(Or.$$.fragment,e),u(Kr.$$.fragment,e),u(eo.$$.fragment,e),u(Ps.$$.fragment,e),u(to.$$.fragment,e),u(so.$$.fragment,e),u(As.$$.fragment,e),u(no.$$.fragment,e),u(ao.$$.fragment,e),u(Os.$$.fragment,e),u(ro.$$.fragment,e),u(oo.$$.fragment,e),u(Ks.$$.fragment,e),u(en.$$.fragment,e),u(lo.$$.fragment,e),u(io.$$.fragment,e),u(tn.$$.fragment,e),u(sn.$$.fragment,e),u(co.$$.fragment,e),u(po.$$.fragment,e),u(nn.$$.fragment,e),u(mo.$$.fragment,e),u(go.$$.fragment,e),u(an.$$.fragment,e),u(ho.$$.fragment,e),u(uo.$$.fragment,e),u(rn.$$.fragment,e),u(on.$$.fragment,e),u(fo.$$.fragment,e),u(bo.$$.fragment,e),u(ln.$$.fragment,e),u(_o.$$.fragment,e),u(yo.$$.fragment,e),u(cn.$$.fragment,e),u(To.$$.fragment,e),u(Mo.$$.fragment,e),u(dn.$$.fragment,e),u(vo.$$.fragment,e),u(wo.$$.fragment,e),u(pn.$$.fragment,e),u(mn.$$.fragment,e),u(ko.$$.fragment,e),u($o.$$.fragment,e),u(gn.$$.fragment,e),u(jo.$$.fragment,e),u(xo.$$.fragment,e),u(hn.$$.fragment,e),u(Jo.$$.fragment,e),u(Uo.$$.fragment,e),u(un.$$.fragment,e),u(Zo.$$.fragment,e),u(Co.$$.fragment,e),u(fn.$$.fragment,e),u(Wo.$$.fragment,e),u(Bo.$$.fragment,e),u(bn.$$.fragment,e),u(Io.$$.fragment,e),u(zo.$$.fragment,e),u(_n.$$.fragment,e),u(Vo.$$.fragment,e),u(Go.$$.fragment,e),u(Fo.$$.fragment,e),u(Xo.$$.fragment,e),u(Ro.$$.fragment,e),u(Lo.$$.fragment,e),u(No.$$.fragment,e),u(So.$$.fragment,e),u(Ho.$$.fragment,e),u(Eo.$$.fragment,e),u(qo.$$.fragment,e),u(Do.$$.fragment,e),u(Qo.$$.fragment,e),u(Yo.$$.fragment,e),u(Po.$$.fragment,e),u(Ao.$$.fragment,e),u(Oo.$$.fragment,e),u(Ko.$$.fragment,e),u(el.$$.fragment,e),u(tl.$$.fragment,e),u(sl.$$.fragment,e),u(nl.$$.fragment,e),u(al.$$.fragment,e),u(rl.$$.fragment,e),u(ol.$$.fragment,e),u(ll.$$.fragment,e),u(il.$$.fragment,e),u(cl.$$.fragment,e),u(dl.$$.fragment,e),u(pl.$$.fragment,e),u(ml.$$.fragment,e),u(gl.$$.fragment,e),u(hl.$$.fragment,e),u(ul.$$.fragment,e),u(fl.$$.fragment,e),u(bl.$$.fragment,e),u(_l.$$.fragment,e),u(yl.$$.fragment,e),u(Tl.$$.fragment,e),u(Ml.$$.fragment,e),u(vl.$$.fragment,e),u(wl.$$.fragment,e),u(kl.$$.fragment,e),u($l.$$.fragment,e),u(jl.$$.fragment,e),u(xl.$$.fragment,e),u(Jl.$$.fragment,e),u(Ul.$$.fragment,e),u(Zl.$$.fragment,e),u(Cl.$$.fragment,e),u(Wl.$$.fragment,e),u(Bl.$$.fragment,e),u(Il.$$.fragment,e),u(zl.$$.fragment,e),u(Vl.$$.fragment,e),u(Gl.$$.fragment,e),u(Fl.$$.fragment,e),u(Xl.$$.fragment,e),u(Rl.$$.fragment,e),u(Ll.$$.fragment,e),u(Sl.$$.fragment,e),u(Hl.$$.fragment,e),u(El.$$.fragment,e),u(ql.$$.fragment,e),u(Dl.$$.fragment,e),u(Ql.$$.fragment,e),u(Yl.$$.fragment,e),u(Pl.$$.fragment,e),u(Al.$$.fragment,e),u(wn.$$.fragment,e),u(Ol.$$.fragment,e),u(Kl.$$.fragment,e),u(ei.$$.fragment,e),u(ti.$$.fragment,e),u(ni.$$.fragment,e),u(kn.$$.fragment,e),u(ai.$$.fragment,e),u(ri.$$.fragment,e),u(oi.$$.fragment,e),u(li.$$.fragment,e),u(ii.$$.fragment,e),u(ci.$$.fragment,e),u(di.$$.fragment,e),u(pi.$$.fragment,e),u(mi.$$.fragment,e),u(gi.$$.fragment,e),u(hi.$$.fragment,e),u(ui.$$.fragment,e),u(fi.$$.fragment,e),u(bi.$$.fragment,e),u(_i.$$.fragment,e),u(yi.$$.fragment,e),u(Ti.$$.fragment,e),u(Mi.$$.fragment,e),u(vi.$$.fragment,e),u(wi.$$.fragment,e),u(ki.$$.fragment,e),u($i.$$.fragment,e),u(ji.$$.fragment,e),u(xi.$$.fragment,e),u(Wn.$$.fragment,e),u(Bn.$$.fragment,e),u(Ji.$$.fragment,e),u(Ui.$$.fragment,e),u(Zi.$$.fragment,e),u(Ci.$$.fragment,e),u(Gn.$$.fragment,e),u(Fn.$$.fragment,e),u(Wi.$$.fragment,e),u(Bi.$$.fragment,e),u(Ii.$$.fragment,e),u(zi.$$.fragment,e),u(Vi.$$.fragment,e),u(Gi.$$.fragment,e),u(Fi.$$.fragment,e),u(Xi.$$.fragment,e),u(Ri.$$.fragment,e),u(Sn.$$.fragment,e),u(Li.$$.fragment,e),u(Ni.$$.fragment,e),u(Si.$$.fragment,e),u(Hi.$$.fragment,e),u(Ei.$$.fragment,e),u(qi.$$.fragment,e),u(Di.$$.fragment,e),u(Qi.$$.fragment,e),u(Yi.$$.fragment,e),u(Pn.$$.fragment,e),u(Pi.$$.fragment,e),u(An.$$.fragment,e),u(Ai.$$.fragment,e),u(On.$$.fragment,e),u(Oi.$$.fragment,e),u(Ki.$$.fragment,e),u(ec.$$.fragment,e),u(tc.$$.fragment,e),u(sc.$$.fragment,e),u(nc.$$.fragment,e),u(ac.$$.fragment,e),u(rc.$$.fragment,e),u(ra.$$.fragment,e),u(oc.$$.fragment,e),u(lc.$$.fragment,e),u(ic.$$.fragment,e),u(cc.$$.fragment,e),u(ca.$$.fragment,e),u(dc.$$.fragment,e),u(pc.$$.fragment,e),u(mc.$$.fragment,e),u(gc.$$.fragment,e),u(ga.$$.fragment,e),u(hc.$$.fragment,e),u(uc.$$.fragment,e),u(fc.$$.fragment,e),u(bc.$$.fragment,e),u(ua.$$.fragment,e),u(_c.$$.fragment,e),u(yc.$$.fragment,e),u(Tc.$$.fragment,e),u(fa.$$.fragment,e),u(Mc.$$.fragment,e),u(vc.$$.fragment,e),u(wc.$$.fragment,e),u(kc.$$.fragment,e),u($c.$$.fragment,e),u(jc.$$.fragment,e),u(Ma.$$.fragment,e),u(xc.$$.fragment,e),u(Jc.$$.fragment,e),u(Uc.$$.fragment,e),u(Zc.$$.fragment,e),u(Cc.$$.fragment,e),u(Wc.$$.fragment,e),u(Bc.$$.fragment,e),u(wa.$$.fragment,e),u(Ic.$$.fragment,e),u(zc.$$.fragment,e),u(Vc.$$.fragment,e),u(Gc.$$.fragment,e),u(Fc.$$.fragment,e),u(ja.$$.fragment,e),u(Xc.$$.fragment,e),u(xa.$$.fragment,e),u(Rc.$$.fragment,e),u(Lc.$$.fragment,e),u(Nc.$$.fragment,e),u(Ja.$$.fragment,e),u(Sc.$$.fragment,e),u(Hc.$$.fragment,e),Uy=!0)},o(e){f(w.$$.fragment,e),f(La.$$.fragment,e),f(Ha.$$.fragment,e),f(Pa.$$.fragment,e),f(er.$$.fragment,e),f(tr.$$.fragment,e),f(sr.$$.fragment,e),f(nr.$$.fragment,e),f(ar.$$.fragment,e),f(rr.$$.fragment,e),f(or.$$.fragment,e),f(lr.$$.fragment,e),f(ir.$$.fragment,e),f(cr.$$.fragment,e),f(dr.$$.fragment,e),f(pr.$$.fragment,e),f(mr.$$.fragment,e),f(gr.$$.fragment,e),f(hr.$$.fragment,e),f(ur.$$.fragment,e),f(fr.$$.fragment,e),f(br.$$.fragment,e),f(_r.$$.fragment,e),f(yr.$$.fragment,e),f(Tr.$$.fragment,e),f(Mr.$$.fragment,e),f(vr.$$.fragment,e),f(wr.$$.fragment,e),f($r.$$.fragment,e),f(jr.$$.fragment,e),f(Fs.$$.fragment,e),f(xr.$$.fragment,e),f(Jr.$$.fragment,e),f(Xs.$$.fragment,e),f(Rs.$$.fragment,e),f(Ur.$$.fragment,e),f(Zr.$$.fragment,e),f(Ls.$$.fragment,e),f(Cr.$$.fragment,e),f(Wr.$$.fragment,e),f(Ns.$$.fragment,e),f(Br.$$.fragment,e),f(Ir.$$.fragment,e),f(Ss.$$.fragment,e),f(zr.$$.fragment,e),f(Vr.$$.fragment,e),f(Hs.$$.fragment,e),f(Gr.$$.fragment,e),f(Fr.$$.fragment,e),f(Es.$$.fragment,e),f(Xr.$$.fragment,e),f(Rr.$$.fragment,e),f(qs.$$.fragment,e),f(Lr.$$.fragment,e),f(Nr.$$.fragment,e),f(Ds.$$.fragment,e),f(Sr.$$.fragment,e),f(Hr.$$.fragment,e),f(Qs.$$.fragment,e),f(Er.$$.fragment,e),f(qr.$$.fragment,e),f(Dr.$$.fragment,e),f(Qr.$$.fragment,e),f(Ys.$$.fragment,e),f(Yr.$$.fragment,e),f(Pr.$$.fragment,e),f(Ar.$$.fragment,e),f(Or.$$.fragment,e),f(Kr.$$.fragment,e),f(eo.$$.fragment,e),f(Ps.$$.fragment,e),f(to.$$.fragment,e),f(so.$$.fragment,e),f(As.$$.fragment,e),f(no.$$.fragment,e),f(ao.$$.fragment,e),f(Os.$$.fragment,e),f(ro.$$.fragment,e),f(oo.$$.fragment,e),f(Ks.$$.fragment,e),f(en.$$.fragment,e),f(lo.$$.fragment,e),f(io.$$.fragment,e),f(tn.$$.fragment,e),f(sn.$$.fragment,e),f(co.$$.fragment,e),f(po.$$.fragment,e),f(nn.$$.fragment,e),f(mo.$$.fragment,e),f(go.$$.fragment,e),f(an.$$.fragment,e),f(ho.$$.fragment,e),f(uo.$$.fragment,e),f(rn.$$.fragment,e),f(on.$$.fragment,e),f(fo.$$.fragment,e),f(bo.$$.fragment,e),f(ln.$$.fragment,e),f(_o.$$.fragment,e),f(yo.$$.fragment,e),f(cn.$$.fragment,e),f(To.$$.fragment,e),f(Mo.$$.fragment,e),f(dn.$$.fragment,e),f(vo.$$.fragment,e),f(wo.$$.fragment,e),f(pn.$$.fragment,e),f(mn.$$.fragment,e),f(ko.$$.fragment,e),f($o.$$.fragment,e),f(gn.$$.fragment,e),f(jo.$$.fragment,e),f(xo.$$.fragment,e),f(hn.$$.fragment,e),f(Jo.$$.fragment,e),f(Uo.$$.fragment,e),f(un.$$.fragment,e),f(Zo.$$.fragment,e),f(Co.$$.fragment,e),f(fn.$$.fragment,e),f(Wo.$$.fragment,e),f(Bo.$$.fragment,e),f(bn.$$.fragment,e),f(Io.$$.fragment,e),f(zo.$$.fragment,e),f(_n.$$.fragment,e),f(Vo.$$.fragment,e),f(Go.$$.fragment,e),f(Fo.$$.fragment,e),f(Xo.$$.fragment,e),f(Ro.$$.fragment,e),f(Lo.$$.fragment,e),f(No.$$.fragment,e),f(So.$$.fragment,e),f(Ho.$$.fragment,e),f(Eo.$$.fragment,e),f(qo.$$.fragment,e),f(Do.$$.fragment,e),f(Qo.$$.fragment,e),f(Yo.$$.fragment,e),f(Po.$$.fragment,e),f(Ao.$$.fragment,e),f(Oo.$$.fragment,e),f(Ko.$$.fragment,e),f(el.$$.fragment,e),f(tl.$$.fragment,e),f(sl.$$.fragment,e),f(nl.$$.fragment,e),f(al.$$.fragment,e),f(rl.$$.fragment,e),f(ol.$$.fragment,e),f(ll.$$.fragment,e),f(il.$$.fragment,e),f(cl.$$.fragment,e),f(dl.$$.fragment,e),f(pl.$$.fragment,e),f(ml.$$.fragment,e),f(gl.$$.fragment,e),f(hl.$$.fragment,e),f(ul.$$.fragment,e),f(fl.$$.fragment,e),f(bl.$$.fragment,e),f(_l.$$.fragment,e),f(yl.$$.fragment,e),f(Tl.$$.fragment,e),f(Ml.$$.fragment,e),f(vl.$$.fragment,e),f(wl.$$.fragment,e),f(kl.$$.fragment,e),f($l.$$.fragment,e),f(jl.$$.fragment,e),f(xl.$$.fragment,e),f(Jl.$$.fragment,e),f(Ul.$$.fragment,e),f(Zl.$$.fragment,e),f(Cl.$$.fragment,e),f(Wl.$$.fragment,e),f(Bl.$$.fragment,e),f(Il.$$.fragment,e),f(zl.$$.fragment,e),f(Vl.$$.fragment,e),f(Gl.$$.fragment,e),f(Fl.$$.fragment,e),f(Xl.$$.fragment,e),f(Rl.$$.fragment,e),f(Ll.$$.fragment,e),f(Sl.$$.fragment,e),f(Hl.$$.fragment,e),f(El.$$.fragment,e),f(ql.$$.fragment,e),f(Dl.$$.fragment,e),f(Ql.$$.fragment,e),f(Yl.$$.fragment,e),f(Pl.$$.fragment,e),f(Al.$$.fragment,e),f(wn.$$.fragment,e),f(Ol.$$.fragment,e),f(Kl.$$.fragment,e),f(ei.$$.fragment,e),f(ti.$$.fragment,e),f(ni.$$.fragment,e),f(kn.$$.fragment,e),f(ai.$$.fragment,e),f(ri.$$.fragment,e),f(oi.$$.fragment,e),f(li.$$.fragment,e),f(ii.$$.fragment,e),f(ci.$$.fragment,e),f(di.$$.fragment,e),f(pi.$$.fragment,e),f(mi.$$.fragment,e),f(gi.$$.fragment,e),f(hi.$$.fragment,e),f(ui.$$.fragment,e),f(fi.$$.fragment,e),f(bi.$$.fragment,e),f(_i.$$.fragment,e),f(yi.$$.fragment,e),f(Ti.$$.fragment,e),f(Mi.$$.fragment,e),f(vi.$$.fragment,e),f(wi.$$.fragment,e),f(ki.$$.fragment,e),f($i.$$.fragment,e),f(ji.$$.fragment,e),f(xi.$$.fragment,e),f(Wn.$$.fragment,e),f(Bn.$$.fragment,e),f(Ji.$$.fragment,e),f(Ui.$$.fragment,e),f(Zi.$$.fragment,e),f(Ci.$$.fragment,e),f(Gn.$$.fragment,e),f(Fn.$$.fragment,e),f(Wi.$$.fragment,e),f(Bi.$$.fragment,e),f(Ii.$$.fragment,e),f(zi.$$.fragment,e),f(Vi.$$.fragment,e),f(Gi.$$.fragment,e),f(Fi.$$.fragment,e),f(Xi.$$.fragment,e),f(Ri.$$.fragment,e),f(Sn.$$.fragment,e),f(Li.$$.fragment,e),f(Ni.$$.fragment,e),f(Si.$$.fragment,e),f(Hi.$$.fragment,e),f(Ei.$$.fragment,e),f(qi.$$.fragment,e),f(Di.$$.fragment,e),f(Qi.$$.fragment,e),f(Yi.$$.fragment,e),f(Pn.$$.fragment,e),f(Pi.$$.fragment,e),f(An.$$.fragment,e),f(Ai.$$.fragment,e),f(On.$$.fragment,e),f(Oi.$$.fragment,e),f(Ki.$$.fragment,e),f(ec.$$.fragment,e),f(tc.$$.fragment,e),f(sc.$$.fragment,e),f(nc.$$.fragment,e),f(ac.$$.fragment,e),f(rc.$$.fragment,e),f(ra.$$.fragment,e),f(oc.$$.fragment,e),f(lc.$$.fragment,e),f(ic.$$.fragment,e),f(cc.$$.fragment,e),f(ca.$$.fragment,e),f(dc.$$.fragment,e),f(pc.$$.fragment,e),f(mc.$$.fragment,e),f(gc.$$.fragment,e),f(ga.$$.fragment,e),f(hc.$$.fragment,e),f(uc.$$.fragment,e),f(fc.$$.fragment,e),f(bc.$$.fragment,e),f(ua.$$.fragment,e),f(_c.$$.fragment,e),f(yc.$$.fragment,e),f(Tc.$$.fragment,e),f(fa.$$.fragment,e),f(Mc.$$.fragment,e),f(vc.$$.fragment,e),f(wc.$$.fragment,e),f(kc.$$.fragment,e),f($c.$$.fragment,e),f(jc.$$.fragment,e),f(Ma.$$.fragment,e),f(xc.$$.fragment,e),f(Jc.$$.fragment,e),f(Uc.$$.fragment,e),f(Zc.$$.fragment,e),f(Cc.$$.fragment,e),f(Wc.$$.fragment,e),f(Bc.$$.fragment,e),f(wa.$$.fragment,e),f(Ic.$$.fragment,e),f(zc.$$.fragment,e),f(Vc.$$.fragment,e),f(Gc.$$.fragment,e),f(Fc.$$.fragment,e),f(ja.$$.fragment,e),f(Xc.$$.fragment,e),f(xa.$$.fragment,e),f(Rc.$$.fragment,e),f(Lc.$$.fragment,e),f(Nc.$$.fragment,e),f(Ja.$$.fragment,e),f(Sc.$$.fragment,e),f(Hc.$$.fragment,e),Uy=!1},d(e){e&&(n($),n(y),n(d),n(s),n(k),n(Ef),n(qf),n(Na),n(Df),n(Sa),n(Qf),n(Yf),n(Ea),n(Pf),n(qa),n(Af),n(Da),n(Of),n(Qa),n(Kf),n(Ya),n(eb),n(tb),n(Aa),n(sb),n(Oa),n(nb),n(Ka),n(ab),n(rb),n(gs),n(ob),n(hs),n(lb),n(us),n(ib),n(fs),n(cb),n(db),n(bs),n(pb),n(_s),n(mb),n(ys),n(gb),n(Ts),n(hb),n(Ms),n(ub),n(vs),n(fb),n(ws),n(bb),n(ks),n(_b),n($s),n(yb),n(js),n(Tb),n(Mb),n(tt),n(vb),n(st),n(wb),n(nt),n(kb),n($b),n(kr),n(jb),n(xb),n(ke),n(Jb),n(N),n(Ub),n(ne),n(Zb),n(ae),n(Cb),n($e),n(Wb),n(je),n(Bb),n(xe),n(Ib),n(Je),n(zb),n(Ue),n(Vb),n(S),n(Gb),n(Ze),n(Fb),n(Ce),n(Xb),n(at),n(Rb),n(rt),n(Lb),n(We),n(Nb),n(Be),n(Sb),n(H),n(Hb),n(re),n(Eb),n(oe),n(qb),n(Ie),n(Db),n(le),n(Qb),n(ie),n(Yb),n(ze),n(Pb),n(Ve),n(Ab),n(G),n(Ob),n(ce),n(Kb),n(Ge),n(e_),n(Fe),n(t_),n(de),n(s_),n(pe),n(n_),n(me),n(a_),n(E),n(r_),n(o_),n(ot),n(l_),n(lt),n(i_),n(it),n(c_),n(ct),n(d_),n(dt),n(p_),n(pt),n(m_),n(mt),n(g_),n(gt),n(h_),n(ht),n(u_),n(ut),n(f_),n(ft),n(b_),n(bt),n(__),n(_t),n(y_),n(yt),n(T_),n(Tt),n(M_),n(v_),n(Mt),n(w_),n(vt),n(k_),n(wt),n($_),n(kt),n(j_),n($t),n(x_),n(jt),n(J_),n(xt),n(U_),n(Jt),n(Z_),n(Ut),n(C_),n(Zt),n(W_),n(Ct),n(B_),n(Wt),n(I_),n(Bt),n(z_),n(V_),n(Nl),n(G_),n(Xe),n(F_),n(xs),n(X_),n(It),n(R_),n(zt),n(L_),n(J),n(N_),n(Vt),n(S_),n(H_),n(si),n(E_),n(W),n(q_),n(Js),n(D_),n(Us),n(Q_),n(Re),n(Y_),n(P_),n(Le),n(A_),n(q),n(O_),n(Ne),n(K_),n(ey),n(F),n(ty),n(ge),n(sy),n(ny),n(Gt),n(ay),n(Ft),n(ry),n(Xt),n(oy),n(I),n(ly),n(D),n(iy),n(Rt),n(cy),n(Lt),n(dy),n(X),n(py),n(Q),n(my),n(Y),n(gy),n(P),n(hy),n(A),n(uy),n(z),n(fy),n(V),n(by),n(O),n(_y),n(yy),n(he),n(Ty),n(ue),n(My),n(Nt),n(vy),n(R),n(wy),n(St),n(ky),n(fe),n($y),n(jy),n(Se),n(xy),n(Jy),n(xf)),n(i),b(w,e),b(La,e),b(Ha,e),b(Pa,e),b(er,e),b(tr),b(sr),b(nr),b(ar),b(rr,e),b(or),b(lr),b(ir),b(cr),b(dr),b(pr),b(mr),b(gr),b(hr),b(ur),b(fr,e),b(br),b(_r),b(yr),b(Tr),b(Mr),b(vr),b(wr,e),b($r,e),b(jr),b(Fs),b(xr),b(Jr),b(Xs),b(Rs),b(Ur),b(Zr),b(Ls),b(Cr),b(Wr),b(Ns),b(Br),b(Ir),b(Ss),b(zr),b(Vr),b(Hs),b(Gr),b(Fr),b(Es),b(Xr),b(Rr),b(qs),b(Lr),b(Nr),b(Ds),b(Sr),b(Hr),b(Qs),b(Er),b(qr),b(Dr),b(Qr),b(Ys),b(Yr),b(Pr),b(Ar),b(Or),b(Kr),b(eo),b(Ps),b(to),b(so),b(As),b(no),b(ao),b(Os),b(ro),b(oo),b(Ks),b(en),b(lo),b(io),b(tn),b(sn),b(co),b(po),b(nn),b(mo),b(go),b(an),b(ho),b(uo),b(rn),b(on),b(fo),b(bo),b(ln),b(_o),b(yo),b(cn),b(To),b(Mo),b(dn),b(vo),b(wo),b(pn),b(mn),b(ko),b($o),b(gn),b(jo),b(xo),b(hn),b(Jo),b(Uo),b(un),b(Zo),b(Co),b(fn),b(Wo),b(Bo),b(bn),b(Io),b(zo),b(_n),b(Vo),b(Go,e),b(Fo),b(Xo),b(Ro),b(Lo),b(No),b(So),b(Ho),b(Eo),b(qo),b(Do),b(Qo),b(Yo),b(Po),b(Ao),b(Oo),b(Ko),b(el),b(tl),b(sl),b(nl),b(al),b(rl),b(ol),b(ll),b(il),b(cl),b(dl),b(pl),b(ml),b(gl),b(hl,e),b(ul),b(fl),b(bl),b(_l),b(yl),b(Tl),b(Ml),b(vl),b(wl),b(kl),b($l),b(jl),b(xl),b(Jl),b(Ul),b(Zl),b(Cl),b(Wl),b(Bl),b(Il),b(zl),b(Vl),b(Gl),b(Fl),b(Xl),b(Rl),b(Ll,e),b(Sl),b(Hl),b(El),b(ql),b(Dl),b(Ql),b(Yl),b(Pl),b(Al),b(wn),b(Ol),b(Kl),b(ei),b(ti,e),b(ni),b(kn),b(ai),b(ri),b(oi),b(li),b(ii),b(ci),b(di),b(pi),b(mi),b(gi),b(hi),b(ui),b(fi,e),b(bi),b(_i),b(yi),b(Ti),b(Mi),b(vi),b(wi),b(ki),b($i),b(ji,e),b(xi),b(Wn),b(Bn),b(Ji),b(Ui),b(Zi),b(Ci),b(Gn),b(Fn),b(Wi),b(Bi,e),b(Ii),b(zi),b(Vi),b(Gi),b(Fi),b(Xi),b(Ri),b(Sn),b(Li),b(Ni),b(Si),b(Hi),b(Ei),b(qi),b(Di),b(Qi),b(Yi),b(Pn),b(Pi),b(An),b(Ai),b(On),b(Oi),b(Ki),b(ec),b(tc),b(sc),b(nc),b(ac),b(rc),b(ra),b(oc),b(lc),b(ic),b(cc),b(ca),b(dc),b(pc),b(mc),b(gc),b(ga),b(hc),b(uc),b(fc),b(bc),b(ua),b(_c),b(yc),b(Tc),b(fa),b(Mc),b(vc),b(wc),b(kc),b($c),b(jc),b(Ma),b(xc),b(Jc),b(Uc),b(Zc,e),b(Cc),b(Wc),b(Bc),b(wa),b(Ic),b(zc),b(Vc),b(Gc),b(Fc),b(ja),b(Xc),b(xa),b(Rc),b(Lc,e),b(Nc),b(Ja),b(Sc),b(Hc,e)}}}const VC='{"title":"Utilities for Generation","local":"utilities-for-generation","sections":[{"title":"Generate Outputs","local":"generate-outputs","sections":[{"title":"PyTorch","local":"transformers.generation.GenerateDecoderOnlyOutput","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.generation.TFGreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"FLAX","local":"transformers.generation.FlaxSampleOutput","sections":[],"depth":3}],"depth":2},{"title":"LogitsProcessor","local":"logitsprocessor","sections":[{"title":"PyTorch","local":"transformers.AlternatingCodebooksLogitsProcessor","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.TFForcedBOSTokenLogitsProcessor","sections":[],"depth":3},{"title":"FLAX","local":"transformers.FlaxForcedBOSTokenLogitsProcessor","sections":[],"depth":3}],"depth":2},{"title":"StoppingCriteria","local":"transformers.StoppingCriteria","sections":[],"depth":2},{"title":"Constraints","local":"transformers.Constraint","sections":[],"depth":2},{"title":"BeamSearch","local":"transformers.BeamScorer","sections":[],"depth":2},{"title":"Streamers","local":"transformers.TextStreamer","sections":[],"depth":2},{"title":"Caches","local":"transformers.Cache","sections":[],"depth":2},{"title":"Watermark Utils","local":"transformers.WatermarkingConfig","sections":[],"depth":2},{"title":"Compile Utils","local":"transformers.CompileConfig","sections":[],"depth":2}],"depth":1}';function GC(j){return ZZ(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class EC extends CZ{constructor(i){super(),WZ(this,i,GC,zC,UZ,{})}}export{EC as component};
