import{s as He,n as Le,o as De}from"../chunks/scheduler.0219f8bd.js";import{S as Pe,i as Ke,g as j,s as e,r as i,A as Oe,h,f as l,c as n,j as Fe,u as p,x as m,k as _e,y as sn,a,v as M,d as o,t as r,w as c}from"../chunks/index.f61edf3b.js";import{C as y}from"../chunks/CodeBlock.38e566ae.js";import{H as J}from"../chunks/Heading.d33122ca.js";function tn(Oa){let u,Et,Gt,vt,g,Wt,T,se=`A Typescript powered wrapper for the Hugging Face Inference Endpoints API. Learn more about Inference Endpoints at <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Hugging Face</a>.
It works with both <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">serverless</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">dedicated</a> Endpoints.`,Xt,f,te='You can also try out a live <a href="https://observablehq.com/@huggingface/hello-huggingface-js-inference" rel="nofollow">interactive notebook</a>, see some demos on <a href="https://huggingface.co/huggingfacejs" rel="nofollow">hf.co/huggingfacejs</a>, or watch a <a href="https://scrimba.com/scrim/cod8248f5adfd6e129582c523" rel="nofollow">Scrimba tutorial that explains how Inference Endpoints works</a>.',At,w,Yt,d,St,U,Vt,$,qt,I,Rt,b,zt,C,Ft,x,_t,B,le='❗<strong>Important note:</strong> Using an access token is optional to get started, however you will be rate limited eventually. Join <a href="https://huggingface.co/join" rel="nofollow">Hugging Face</a> and then visit <a href="https://huggingface.co/settings/tokens" rel="nofollow">access tokens</a> to generate your access token for <strong>free</strong>.',Ht,Z,ae="Your access token should be kept private. If you need to protect it in front-end applications, we suggest setting up a proxy server that stores the access token.",Lt,k,Dt,Q,ee="You can import the functions you need directly from the module instead of using the <code>HfInference</code> class.",Pt,G,Kt,N,ne="This will enable tree-shaking by your bundler.",Ot,E,sl,v,tl,W,ie="Tries to fill in a hole with a missing word (token to be precise).",ll,X,al,A,el,Y,pe="Summarizes longer text into shorter text. Be careful, some models have a maximum length of input.",nl,S,il,V,pl,q,Me="Answers questions based on the context you provide.",Ml,R,ol,z,rl,F,cl,_,jl,H,oe="Often used for sentiment analysis, this method will assign labels to the given text along with a probability score of that label.",hl,L,ml,D,Jl,P,re="Generates text from an input prompt.",yl,K,ce='<a href="https://huggingface.co/spaces/huggingfacejs/streaming-text-generation" rel="nofollow">Demo</a>',ul,O,gl,ss,Tl,ts,je="Used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.",fl,ls,wl,as,dl,es,he="Converts text from one language to another.",Ul,ns,$l,is,Il,ps,me="Checks how well an input text fits into a set of labels you provide.",bl,Ms,Cl,os,xl,rs,Je="This task corresponds to any chatbot-like structure. Models tend to have shorter max_length, so please check with caution when using a given model if you need long-range dependency or not.",Bl,cs,Zl,js,kl,hs,ye="Calculate the semantic similarity between one text and a list of other sentences.",Ql,ms,Gl,Js,Nl,ys,El,us,ue="Transcribes speech from an audio file.",vl,gs,ge='<a href="https://huggingface.co/spaces/huggingfacejs/speech-recognition-vue" rel="nofollow">Demo</a>',Wl,Ts,Xl,fs,Al,ws,Te="Assigns labels to the given audio along with a probability score of that label.",Yl,ds,fe='<a href="https://huggingface.co/spaces/huggingfacejs/audio-classification-vue" rel="nofollow">Demo</a>',Sl,Us,Vl,$s,ql,Is,we="Generates natural-sounding speech from text input.",Rl,bs,de='<a href="https://scrimba.com/scrim/co8da4d23b49b648f77f4848a?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',zl,Cs,Fl,xs,_l,Bs,Ue="Outputs one or multiple generated audios from an input audio, commonly used for speech enhancement and source separation.",Hl,Zs,Ll,ks,Dl,Qs,Pl,Gs,$e="Assigns labels to a given image along with a probability score of that label.",Kl,Ns,Ie='<a href="https://huggingface.co/spaces/huggingfacejs/image-classification-vue" rel="nofollow">Demo</a>',Ol,Es,sa,vs,ta,Ws,be="Detects objects within an image and returns labels with corresponding bounding boxes and probability scores.",la,Xs,Ce='<a href="https://huggingface.co/spaces/huggingfacejs/object-detection-vue" rel="nofollow">Demo</a>',aa,As,ea,Ys,na,Ss,xe="Detects segments within an image and returns labels with corresponding bounding boxes and probability scores.",ia,Vs,pa,qs,Ma,Rs,Be="Outputs text from a given image, commonly used for captioning or optical character recognition.",oa,zs,ra,Fs,ca,_s,Ze="Creates an image from a text prompt.",ja,Hs,ke='<a href="https://huggingface.co/spaces/huggingfacejs/image-to-text" rel="nofollow">Demo</a>',ha,Ls,ma,Ds,Ja,Ps,Qe="Image-to-image is the task of transforming a source image to match the characteristics of a target image or a target image domain.",ya,Ks,Ge='<a href="https://scrimba.com/scrim/co4834bf9a91cc81cfab07969?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',ua,Os,ga,st,Ta,tt,Ne="Checks how well an input image fits into a set of labels you provide.",fa,lt,wa,at,da,et,Ua,nt,Ee="This task reads some text and outputs raw float values, that are usually consumed as part of a semantic database/semantic search.",$a,it,Ia,pt,ba,Mt,ve="Visual Question Answering is the task of answering open-ended questions based on an image. They output natural language responses to natural language questions.",Ca,ot,We='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',xa,rt,Ba,ct,Za,jt,Xe="Document question answering models take a (document, question) pair as input and return an answer in natural language.",ka,ht,Ae='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',Qa,mt,Ga,Jt,Na,yt,Ea,ut,Ye="Tabular regression is the task of predicting a numerical value given a set of attributes.",va,gt,Wa,Tt,Xa,ft,Se="Tabular classification is the task of classifying a target category (a group) based on set of attributes.",Aa,wt,Ya,dt,Sa,Ut,Ve="For models with custom parameters / outputs.",Va,$t,qa,It,Ra,bt,qe='Learn more about using your own inference endpoints <a href="https://hf.co/docs/inference-endpoints/" rel="nofollow">here</a>',za,Ct,Fa,xt,_a,Bt,Ha,Zt,La,kt,Re='We have an informative documentation project called <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> to list available models for each task and explain how each task works in detail.',Da,Qt,ze="It also contains demos, example outputs, and other resources should you want to dig deeper into the ML side of things.",Pa,Nt,Ka;return g=new J({props:{title:"🤗 Hugging Face Inference Endpoints",local:"-hugging-face-inference-endpoints",headingTag:"h1"}}),w=new J({props:{title:"Getting Started",local:"getting-started",headingTag:"h2"}}),d=new J({props:{title:"Install",local:"install",headingTag:"h3"}}),U=new J({props:{title:"Node",local:"node",headingTag:"h4"}}),$=new y({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBcG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBeWFybiUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNl",highlighted:`npm install @huggingface/inference

pnpm add @huggingface/inference

yarn add @huggingface/inference`,wrap:!1}}),I=new J({props:{title:"Deno",local:"deno",headingTag:"h4"}}),b=new y({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUwQSUyRiUyRiUyMG9yJTIwbnBtJTNBJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIybnBtJTNBJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjI=",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>`,wrap:!1}}),C=new J({props:{title:"Initialize",local:"initialize",headingTag:"h3"}}),x=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJyUwQSUwQWNvbnN0JTIwaGYlMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZSgneW91ciUyMGFjY2VzcyUyMHRva2VuJyk=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-string">&#x27;your access token&#x27;</span>)`,wrap:!1}}),k=new J({props:{title:"Tree-shaking",local:"tree-shaking",headingTag:"h4"}}),G=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwdGV4dEdlbmVyYXRpb24lMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEElMEFhd2FpdCUyMHRleHRHZW5lcmF0aW9uKCU3QiUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwJTIyaGZfLi4uJTIyJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtb2RlbF9vcl9lbmRwb2ludCUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMC4uLiUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAuLi4lMEElN0Qp",highlighted:`<span class="hljs-keyword">import</span> { textGeneration } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;model_or_endpoint&quot;</span>,
  <span class="hljs-attr">inputs</span>: ...,
  <span class="hljs-attr">parameters</span>: ...
})`,wrap:!1}}),E=new J({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),v=new J({props:{title:"Fill Mask",local:"fill-mask",headingTag:"h3"}}),X=new y({props:{code:"YXdhaXQlMjBoZi5maWxsTWFzayglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnJTVCTUFTSyU1RCUyMHdvcmxkISclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">fillMask</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;bert-base-uncased&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;[MASK] world!&#x27;</span>
})`,wrap:!1}}),A=new J({props:{title:"Summarization",local:"summarization",headingTag:"h3"}}),S=new y({props:{code:"YXdhaXQlMjBoZi5zdW1tYXJpemF0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1jbm4nJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTBBJTIwJTIwJTIwJTIwJ1RoZSUyMHRvd2VyJTIwaXMlMjAzMjQlMjBtZXRyZXMlMjAoMSUyQzA2MyUyMGZ0KSUyMHRhbGwlMkMlMjBhYm91dCUyMHRoZSUyMHNhbWUlMjBoZWlnaHQlMjBhcyUyMGFuJTIwODEtc3RvcmV5JTIwYnVpbGRpbmclMkMlMjBhbmQlMjB0aGUlMjB0YWxsZXN0JTIwc3RydWN0dXJlJTIwaW4lMjBQYXJpcy4lMjBJdHMlMjBiYXNlJTIwaXMlMjBzcXVhcmUlMkMlMjBtZWFzdXJpbmclMjAxMjUlMjBtZXRyZXMlMjAoNDEwJTIwZnQpJTIwb24lMjBlYWNoJTIwc2lkZS4lMjBEdXJpbmclMjBpdHMlMjBjb25zdHJ1Y3Rpb24lMkMlMjB0aGUlMjBFaWZmZWwlMjBUb3dlciUyMHN1cnBhc3NlZCUyMHRoZSUyMFdhc2hpbmd0b24lMjBNb251bWVudCUyMHRvJTIwYmVjb21lJTIwdGhlJTIwdGFsbGVzdCUyMG1hbi1tYWRlJTIwc3RydWN0dXJlJTIwaW4lMjB0aGUlMjB3b3JsZCUyQyUyMGElMjB0aXRsZSUyMGl0JTIwaGVsZCUyMGZvciUyMDQxJTIweWVhcnMlMjB1bnRpbCUyMHRoZSUyMENocnlzbGVyJTIwQnVpbGRpbmclMjBpbiUyME5ldyUyMFlvcmslMjBDaXR5JTIwd2FzJTIwZmluaXNoZWQlMjBpbiUyMDE5MzAuJyUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBtYXhfbGVuZ3RoJTNBJTIwMTAwJTBBJTIwJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">summarization</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-cnn&#x27;</span>,
  <span class="hljs-attr">inputs</span>:
    <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest man-made structure in the world, a title it held for 41 years until the Chrysler Building in New York City was finished in 1930.&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">max_length</span>: <span class="hljs-number">100</span>
  }
})`,wrap:!1}}),V=new J({props:{title:"Question Answering",local:"question-answering",headingTag:"h3"}}),R=new y({props:{code:"YXdhaXQlMjBoZi5xdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkZWVwc2V0JTJGcm9iZXJ0YS1iYXNlLXNxdWFkMiclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzQSUyMCdXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YnJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzQSUyMCdUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">questionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;deepset/roberta-base-squad2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;What is the capital of France?&#x27;</span>,
    <span class="hljs-attr">context</span>: <span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>
  }
})`,wrap:!1}}),z=new J({props:{title:"Table Question Answering",local:"table-question-answering",headingTag:"h3"}}),F=new y({props:{code:"YXdhaXQlMjBoZi50YWJsZVF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2dvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVyeSUzQSUyMCdIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YnJTJDJTBBJTIwJTIwJTIwJTIwdGFibGUlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjBSZXBvc2l0b3J5JTNBJTIwJTVCJ1RyYW5zZm9ybWVycyclMkMlMjAnRGF0YXNldHMnJTJDJTIwJ1Rva2VuaXplcnMnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwU3RhcnMlM0ElMjAlNUInMzY1NDInJTJDJTIwJzQ1MTInJTJDJTIwJzM5MzQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwQ29udHJpYnV0b3JzJTNBJTIwJTVCJzY1MSclMkMlMjAnNzcnJTJDJTIwJzM0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdQcm9ncmFtbWluZyUyMGxhbmd1YWdlJyUzQSUyMCU1QidQeXRob24nJTJDJTIwJ1B5dGhvbiclMkMlMjAnUnVzdCUyQyUyMFB5dGhvbiUyMGFuZCUyME5vZGVKUyclNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tableQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/tapas-base-finetuned-wtq&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">query</span>: <span class="hljs-string">&#x27;How many stars does the transformers repository have?&#x27;</span>,
    <span class="hljs-attr">table</span>: {
      <span class="hljs-title class_">Repository</span>: [<span class="hljs-string">&#x27;Transformers&#x27;</span>, <span class="hljs-string">&#x27;Datasets&#x27;</span>, <span class="hljs-string">&#x27;Tokenizers&#x27;</span>],
      <span class="hljs-title class_">Stars</span>: [<span class="hljs-string">&#x27;36542&#x27;</span>, <span class="hljs-string">&#x27;4512&#x27;</span>, <span class="hljs-string">&#x27;3934&#x27;</span>],
      <span class="hljs-title class_">Contributors</span>: [<span class="hljs-string">&#x27;651&#x27;</span>, <span class="hljs-string">&#x27;77&#x27;</span>, <span class="hljs-string">&#x27;34&#x27;</span>],
      <span class="hljs-string">&#x27;Programming language&#x27;</span>: [<span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Rust, Python and NodeJS&#x27;</span>]
    }
  }
})`,wrap:!1}}),_=new J({props:{title:"Text Classification",local:"text-classification",headingTag:"h3"}}),L=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0Q2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ0klMjBsaWtlJTIweW91LiUyMEklMjBsb3ZlJTIweW91LiclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;I like you. I love you.&#x27;</span>
})`,wrap:!1}}),D=new J({props:{title:"Text Generation",local:"text-generation",headingTag:"h3"}}),O=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0R2VuZXJhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdncHQyJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdUaGUlMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHVuaXZlcnNlJTIwaXMnJTBBJTdEKSUwQSUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwb3V0cHV0JTIwb2YlMjBoZi50ZXh0R2VuZXJhdGlvblN0cmVhbSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMmdvb2dsZSUyRmZsYW4tdDUteHhsJTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ3JlcGVhdCUyMCUyMm9uZSUyMHR3byUyMHRocmVlJTIwZm91ciUyMiclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTIwbWF4X25ld190b2tlbnMlM0ElMjAyNTAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMGNvbnNvbGUubG9nKG91dHB1dC50b2tlbi50ZXh0JTJDJTIwb3V0cHV0LmdlbmVyYXRlZF90ZXh0KSUzQiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;gpt2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>
})

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">textGenerationStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;google/flan-t5-xxl&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;repeat &quot;one two three four&quot;&#x27;</span>,
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">250</span> }
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>, output.<span class="hljs-property">generated_text</span>);
}`,wrap:!1}}),ss=new J({props:{title:"Token Classification",local:"token-classification",headingTag:"h3"}}),ls=new y({props:{code:"YXdhaXQlMjBoZi50b2tlbkNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2RibWR6JTJGYmVydC1sYXJnZS1jYXNlZC1maW5ldHVuZWQtY29ubGwwMy1lbmdsaXNoJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFNhcmFoJTIwSmVzc2ljYSUyMFBhcmtlciUyMGJ1dCUyMHlvdSUyMGNhbiUyMGNhbGwlMjBtZSUyMEplc3NpY2EnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tokenClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dbmdz/bert-large-cased-finetuned-conll03-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Sarah Jessica Parker but you can call me Jessica&#x27;</span>
})`,wrap:!1}}),as=new J({props:{title:"Translation",local:"translation",headingTag:"h3"}}),ns=new y({props:{code:"YXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCd0NS1iYXNlJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiclMEElN0QpJTBBJTBBYXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRm1iYXJ0LWxhcmdlLTUwLW1hbnktdG8tbWFueS1tbXQnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwdGV4dFRvVHJhbnNsYXRlJTJDJTBBJTIwJTIwcGFyYW1ldGVycyUzQSUyMCU3QiUwQSUwOSUwOSUyMnNyY19sYW5nJTIyJTNBJTIwJTIyZW5fWFglMjIlMkMlMEElMDklMDklMjJ0Z3RfbGFuZyUyMiUzQSUyMCUyMmZyX1hYJTIyJTBBJTA5JTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Berlin&#x27;</span>
})

<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/mbart-large-50-many-to-many-mmt&#x27;</span>,
  <span class="hljs-attr">inputs</span>: textToTranslate,
  <span class="hljs-attr">parameters</span>: {
		<span class="hljs-string">&quot;src_lang&quot;</span>: <span class="hljs-string">&quot;en_XX&quot;</span>,
		<span class="hljs-string">&quot;tgt_lang&quot;</span>: <span class="hljs-string">&quot;fr_XX&quot;</span>
	}
})`,wrap:!1}}),is=new J({props:{title:"Zero-Shot Classification",local:"zero-shot-classification",headingTag:"h3"}}),Ms=new y({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdENsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1tbmxpJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCdIaSUyQyUyMEklMjByZWNlbnRseSUyMGJvdWdodCUyMGElMjBkZXZpY2UlMjBmcm9tJTIweW91ciUyMGNvbXBhbnklMjBidXQlMjBpdCUyMGlzJTIwbm90JTIwd29ya2luZyUyMGFzJTIwYWR2ZXJ0aXNlZCUyMGFuZCUyMEklMjB3b3VsZCUyMGxpa2UlMjB0byUyMGdldCUyMHJlaW1idXJzZWQhJyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMjBjYW5kaWRhdGVfbGFiZWxzJTNBJTIwJTVCJ3JlZnVuZCclMkMlMjAnbGVnYWwnJTJDJTIwJ2ZhcSclNUQlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>,
  <span class="hljs-attr">inputs</span>: [
    <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>
  ],
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>] }
})`,wrap:!1}}),os=new J({props:{title:"Conversational",local:"conversational",headingTag:"h3"}}),cs=new y({props:{code:"YXdhaXQlMjBoZi5jb252ZXJzYXRpb25hbCglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdtaWNyb3NvZnQlMkZEaWFsb0dQVC1sYXJnZSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwYXN0X3VzZXJfaW5wdXRzJTNBJTIwJTVCJ1doaWNoJTIwbW92aWUlMjBpcyUyMHRoZSUyMGJlc3QlMjAlM0YnJTVEJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3Jlc3BvbnNlcyUzQSUyMCU1QidJdCUyMGlzJTIwRGllJTIwSGFyZCUyMGZvciUyMHN1cmUuJyU1RCUyQyUwQSUyMCUyMCUyMCUyMHRleHQlM0ElMjAnQ2FuJTIweW91JTIwZXhwbGFpbiUyMHdoeSUyMCUzRiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">conversational</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;microsoft/DialoGPT-large&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">past_user_inputs</span>: [<span class="hljs-string">&#x27;Which movie is the best ?&#x27;</span>],
    <span class="hljs-attr">generated_responses</span>: [<span class="hljs-string">&#x27;It is Die Hard for sure.&#x27;</span>],
    <span class="hljs-attr">text</span>: <span class="hljs-string">&#x27;Can you explain why ?&#x27;</span>
  }
})`,wrap:!1}}),js=new J({props:{title:"Sentence Similarity",local:"sentence-similarity",headingTag:"h3"}}),ms=new y({props:{code:"YXdhaXQlMjBoZi5zZW50ZW5jZVNpbWlsYXJpdHkoJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGcGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwc291cmNlX3NlbnRlbmNlJTNBJTIwJ1RoYXQlMjBpcyUyMGElMjBoYXBweSUyMHBlcnNvbiclMkMlMEElMjAlMjAlMjAlMjBzZW50ZW5jZXMlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAnVGhhdCUyMGlzJTIwYSUyMGhhcHB5JTIwZG9nJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUaGF0JTIwaXMlMjBhJTIwdmVyeSUyMGhhcHB5JTIwcGVyc29uJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUb2RheSUyMGlzJTIwYSUyMHN1bm55JTIwZGF5JyUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">sentenceSimilarity</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;sentence-transformers/paraphrase-xlm-r-multilingual-v1&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">source_sentence</span>: <span class="hljs-string">&#x27;That is a happy person&#x27;</span>,
    <span class="hljs-attr">sentences</span>: [
      <span class="hljs-string">&#x27;That is a happy dog&#x27;</span>,
      <span class="hljs-string">&#x27;That is a very happy person&#x27;</span>,
      <span class="hljs-string">&#x27;Today is a sunny day&#x27;</span>
    ]
  }
})`,wrap:!1}}),Js=new J({props:{title:"Audio",local:"audio",headingTag:"h2"}}),ys=new J({props:{title:"Automatic Speech Recognition",local:"automatic-speech-recognition",headingTag:"h3"}}),Ts=new y({props:{code:"YXdhaXQlMjBoZi5hdXRvbWF0aWNTcGVlY2hSZWNvZ25pdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmJyUyQyUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZzYW1wbGUxLmZsYWMnKSUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">automaticSpeechRecognition</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/wav2vec2-large-960h-lv60-self&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),fs=new J({props:{title:"Audio Classification",local:"audio-classification",headingTag:"h3"}}),Us=new y({props:{code:"YXdhaXQlMjBoZi5hdWRpb0NsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ3N1cGVyYiUyRmh1YmVydC1sYXJnZS1zdXBlcmItZXInJTJDJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRnNhbXBsZTEuZmxhYycpJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;superb/hubert-large-superb-er&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),$s=new J({props:{title:"Text To Speech",local:"text-to-speech",headingTag:"h3"}}),Cs=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9TcGVlY2goJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZXNwbmV0JTJGa2FuLWJheWFzaGlfbGpzcGVlY2hfdml0cyclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnSGVsbG8lMjB3b3JsZCEnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToSpeech</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;espnet/kan-bayashi_ljspeech_vits&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;Hello world!&#x27;</span>
})`,wrap:!1}}),xs=new J({props:{title:"Audio To Audio",local:"audio-to-audio",headingTag:"h3"}}),Zs=new y({props:{code:"YXdhaXQlMjBoZi5hdWRpb1RvQXVkaW8oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc3BlZWNoYnJhaW4lMkZzZXBmb3JtZXItd2hhbSclMkMlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGc2FtcGxlMS5mbGFjJyklMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioToAudio</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;speechbrain/sepformer-wham&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),ks=new J({props:{title:"Computer Vision",local:"computer-vision",headingTag:"h2"}}),Qs=new J({props:{title:"Image Classification",local:"image-classification",headingTag:"h3"}}),Es=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZUNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZjaGVldGFoLnBuZycpJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAnZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageClassification</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cheetah.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/vit-base-patch16-224&#x27;</span>
})`,wrap:!1}}),vs=new J({props:{title:"Object Detection",local:"object-detection",headingTag:"h3"}}),As=new y({props:{code:"YXdhaXQlMjBoZi5vYmplY3REZXRlY3Rpb24oJTdCJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRmNhdHMucG5nJyklMkMlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">objectDetection</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50&#x27;</span>
})`,wrap:!1}}),Ys=new J({props:{title:"Image Segmentation",local:"image-segmentation",headingTag:"h3"}}),Vs=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVNlZ21lbnRhdGlvbiglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAtcGFub3B0aWMnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageSegmentation</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50-panoptic&#x27;</span>
})`,wrap:!1}}),qs=new J({props:{title:"Image To Text",local:"image-to-text",headingTag:"h3"}}),zs=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvVGV4dCglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ25scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>
})`,wrap:!1}}),Fs=new J({props:{title:"Text To Image",local:"text-to-image",headingTag:"h3"}}),Ls=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBpbnB1dHMlM0ElMjAnYXdhcmQlMjB3aW5uaW5nJTIwaGlnaCUyMHJlc29sdXRpb24lMjBwaG90byUyMG9mJTIwYSUyMGdpYW50JTIwdG9ydG9pc2UlMkYoKGxhZHliaXJkKSklMjBoeWJyaWQlMkMlMjAlNUJ0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiU1RCclMkMlMEElMjAlMjBtb2RlbCUzQSUyMCdzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNBJTIwJ2JsdXJyeSclMkMlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;award winning high resolution photo of a giant tortoise/((ladybird)) hybrid, [trending on artstation]&#x27;</span>,
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;stabilityai/stable-diffusion-2&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">negative_prompt</span>: <span class="hljs-string">&#x27;blurry&#x27;</span>,
  }
})`,wrap:!1}}),Ds=new J({props:{title:"Image To Image",local:"image-to-image",headingTag:"h3"}}),Os=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvSW1hZ2UoJTdCJTBBJTIwJTIwaW5wdXRzJTNBJTIwbmV3JTIwQmxvYiglNUJyZWFkRmlsZVN5bmMoJTIydGVzdCUyRnN0b3JtdHJvb3Blcl9kZXB0aC5wbmclMjIpJTVEKSUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwcm9tcHQlM0ElMjAlMjJlbG1vJ3MlMjBsZWN0dXJlJTIyJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1kZXB0aCUyMiUyQyUwQSU3RCklM0I=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToImage</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&quot;test/stormtrooper_depth.png&quot;</span>)]),
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">prompt</span>: <span class="hljs-string">&quot;elmo&#x27;s lecture&quot;</span>,
  },
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;lllyasviel/sd-controlnet-depth&quot;</span>,
});`,wrap:!1}}),st=new J({props:{title:"Zero Shot Image Classification",local:"zero-shot-image-classification",headingTag:"h3"}}),lt=new y({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnb3BlbmFpJTJGY2xpcC12aXQtbGFyZ2UtcGF0Y2gxNC0zMzYnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMkMlMjAlMjAlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY2FuZGlkYXRlX2xhYmVscyUzQSUyMCU1QidjYXQnJTJDJTIwJ2RvZyclNUQlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotImageClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;openai/clip-vit-large-patch14-336&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  },  
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;cat&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]
  }
})`,wrap:!1}}),at=new J({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),et=new J({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h3"}}),it=new y({props:{code:"YXdhaXQlMjBoZi5mZWF0dXJlRXh0cmFjdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRmRpc3RpbGJlcnQtYmFzZS1ubGktbWVhbi10b2tlbnMlMjIlMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlMjJUaGF0JTIwaXMlMjBhJTIwaGFwcHklMjBwZXJzb24lMjIlMkMlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">featureExtraction</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;sentence-transformers/distilbert-base-nli-mean-tokens&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;That is a happy person&quot;</span>,
});`,wrap:!1}}),pt=new J({props:{title:"Visual Question Answering",local:"visual-question-answering",headingTag:"h3"}}),rt=new y({props:{code:"YXdhaXQlMjBoZi52aXN1YWxRdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkYW5kZWxpbiUyRnZpbHQtYjMyLWZpbmV0dW5lZC12cWEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0ElMjAnSG93JTIwbWFueSUyMGNhdHMlMjBhcmUlMjBseWluZyUyMGRvd24lM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">visualQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dandelin/vilt-b32-finetuned-vqa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;How many cats are lying down?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  }
})`,wrap:!1}}),ct=new J({props:{title:"Document Question Answering",local:"document-question-answering",headingTag:"h3"}}),mt=new y({props:{code:"YXdhaXQlMjBoZi5kb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ltcGlyYSUyRmxheW91dGxtLWRvY3VtZW50LXFhJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNBJTIwJ0ludm9pY2UlMjBudW1iZXIlM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJykpLmJsb2IoKSUyQyUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">documentQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;impira/layoutlm-document-qa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;Invoice number?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
  }
})`,wrap:!1}}),Jt=new J({props:{title:"Tabular",local:"tabular",headingTag:"h2"}}),yt=new J({props:{title:"Tabular Regression",local:"tabular-regression",headingTag:"h3"}}),gt=new y({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyUmVncmVzc2lvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwZGF0YSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlaWdodCUyMiUzQSUyMCU1QiUyMjExLjUyJTIyJTJDJTIwJTIyMTIuNDglMjIlMkMlMjAlMjIxMi4zNzc4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMSUyMiUzQSUyMCU1QiUyMjIzLjIlMjIlMkMlMjAlMjIyNCUyMiUyQyUyMCUyMjIzLjklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJMZW5ndGgyJTIyJTNBJTIwJTVCJTIyMjUuNCUyMiUyQyUyMCUyMjI2LjMlMjIlMkMlMjAlMjIyNi41JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMyUyMiUzQSUyMCU1QiUyMjMwJTIyJTJDJTIwJTIyMzEuMiUyMiUyQyUyMCUyMjMxLjElMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJTcGVjaWVzJTIyJTNBJTIwJTVCJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2lkdGglMjIlM0ElMjAlNUIlMjI0LjAyJTIyJTJDJTIwJTIyNC4zMDU2JTIyJTJDJTIwJTIyNC42OTYxJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularRegression</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
      <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
      <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
      <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
      <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
      <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>]
    },
  },
})`,wrap:!1}}),Tt=new J({props:{title:"Tabular Classification",local:"tabular-classification",headingTag:"h3"}}),wt=new y({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJ2dm1ubm5rdiUyRndpbmUtcXVhbGl0eSUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMGRhdGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlN0QlMkMlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;vvmnnnkv/wine-quality&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
      <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
      <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
      <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
      <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
      <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
      <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
      <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
      <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
      <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
      <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>]
    },
  },
})`,wrap:!1}}),dt=new J({props:{title:"Custom Calls",local:"custom-calls",headingTag:"h2"}}),$t=new y({props:{code:"YXdhaXQlMjBoZi5yZXF1ZXN0KCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ215LWN1c3RvbS1tb2RlbCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnaGVsbG8lMjB3b3JsZCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BhcmFtJTNBJTIwJ3NvbWUlMjBtYWdpYyclMkMlMEElMjAlMjAlN0QlMEElN0QpJTBBJTBBJTJGJTJGJTIwQ3VzdG9tJTIwc3RyZWFtaW5nJTIwY2FsbCUyQyUyMGZvciUyMG1vZGVscyUyMHdpdGglMjBjdXN0b20lMjBwYXJhbWV0ZXJzJTIwJTJGJTIwb3V0cHV0cyUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwb3V0cHV0JTIwb2YlMjBoZi5zdHJlYW1pbmdSZXF1ZXN0KCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ215LWN1c3RvbS1tb2RlbCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnaGVsbG8lMjB3b3JsZCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BhcmFtJTNBJTIwJ3NvbWUlMjBtYWdpYyclMkMlMEElMjAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMC4uLiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">request</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;my-custom-model&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;hello world&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">custom_param</span>: <span class="hljs-string">&#x27;some magic&#x27;</span>,
  }
})

<span class="hljs-comment">// Custom streaming call, for models with custom parameters / outputs</span>
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">streamingRequest</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;my-custom-model&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;hello world&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">custom_param</span>: <span class="hljs-string">&#x27;some magic&#x27;</span>,
  }
})) {
  ...
}`,wrap:!1}}),It=new J({props:{title:"Custom Inference Endpoints",local:"custom-inference-endpoints",headingTag:"h2"}}),Ct=new y({props:{code:"Y29uc3QlMjBncHQyJTIwJTNEJTIwaGYuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCklM0I=",highlighted:`<span class="hljs-keyword">const</span> gpt2 = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>({<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>});`,wrap:!1}}),xt=new J({props:{title:"Running tests",local:"running-tests",headingTag:"h2"}}),Bt=new y({props:{code:"SEZfVE9LRU4lM0QlMjJ5b3VyJTIwYWNjZXNzJTIwdG9rZW4lMjIlMjBwbnBtJTIwcnVuJTIwdGVzdA==",highlighted:"HF_TOKEN=&quot;your access token&quot; pnpm run test",wrap:!1}}),Zt=new J({props:{title:"Finding appropriate models",local:"finding-appropriate-models",headingTag:"h2"}}),{c(){u=j("meta"),Et=e(),Gt=j("p"),vt=e(),i(g.$$.fragment),Wt=e(),T=j("p"),T.innerHTML=se,Xt=e(),f=j("p"),f.innerHTML=te,At=e(),i(w.$$.fragment),Yt=e(),i(d.$$.fragment),St=e(),i(U.$$.fragment),Vt=e(),i($.$$.fragment),qt=e(),i(I.$$.fragment),Rt=e(),i(b.$$.fragment),zt=e(),i(C.$$.fragment),Ft=e(),i(x.$$.fragment),_t=e(),B=j("p"),B.innerHTML=le,Ht=e(),Z=j("p"),Z.textContent=ae,Lt=e(),i(k.$$.fragment),Dt=e(),Q=j("p"),Q.innerHTML=ee,Pt=e(),i(G.$$.fragment),Kt=e(),N=j("p"),N.textContent=ne,Ot=e(),i(E.$$.fragment),sl=e(),i(v.$$.fragment),tl=e(),W=j("p"),W.textContent=ie,ll=e(),i(X.$$.fragment),al=e(),i(A.$$.fragment),el=e(),Y=j("p"),Y.textContent=pe,nl=e(),i(S.$$.fragment),il=e(),i(V.$$.fragment),pl=e(),q=j("p"),q.textContent=Me,Ml=e(),i(R.$$.fragment),ol=e(),i(z.$$.fragment),rl=e(),i(F.$$.fragment),cl=e(),i(_.$$.fragment),jl=e(),H=j("p"),H.textContent=oe,hl=e(),i(L.$$.fragment),ml=e(),i(D.$$.fragment),Jl=e(),P=j("p"),P.textContent=re,yl=e(),K=j("p"),K.innerHTML=ce,ul=e(),i(O.$$.fragment),gl=e(),i(ss.$$.fragment),Tl=e(),ts=j("p"),ts.textContent=je,fl=e(),i(ls.$$.fragment),wl=e(),i(as.$$.fragment),dl=e(),es=j("p"),es.textContent=he,Ul=e(),i(ns.$$.fragment),$l=e(),i(is.$$.fragment),Il=e(),ps=j("p"),ps.textContent=me,bl=e(),i(Ms.$$.fragment),Cl=e(),i(os.$$.fragment),xl=e(),rs=j("p"),rs.textContent=Je,Bl=e(),i(cs.$$.fragment),Zl=e(),i(js.$$.fragment),kl=e(),hs=j("p"),hs.textContent=ye,Ql=e(),i(ms.$$.fragment),Gl=e(),i(Js.$$.fragment),Nl=e(),i(ys.$$.fragment),El=e(),us=j("p"),us.textContent=ue,vl=e(),gs=j("p"),gs.innerHTML=ge,Wl=e(),i(Ts.$$.fragment),Xl=e(),i(fs.$$.fragment),Al=e(),ws=j("p"),ws.textContent=Te,Yl=e(),ds=j("p"),ds.innerHTML=fe,Sl=e(),i(Us.$$.fragment),Vl=e(),i($s.$$.fragment),ql=e(),Is=j("p"),Is.textContent=we,Rl=e(),bs=j("p"),bs.innerHTML=de,zl=e(),i(Cs.$$.fragment),Fl=e(),i(xs.$$.fragment),_l=e(),Bs=j("p"),Bs.textContent=Ue,Hl=e(),i(Zs.$$.fragment),Ll=e(),i(ks.$$.fragment),Dl=e(),i(Qs.$$.fragment),Pl=e(),Gs=j("p"),Gs.textContent=$e,Kl=e(),Ns=j("p"),Ns.innerHTML=Ie,Ol=e(),i(Es.$$.fragment),sa=e(),i(vs.$$.fragment),ta=e(),Ws=j("p"),Ws.textContent=be,la=e(),Xs=j("p"),Xs.innerHTML=Ce,aa=e(),i(As.$$.fragment),ea=e(),i(Ys.$$.fragment),na=e(),Ss=j("p"),Ss.textContent=xe,ia=e(),i(Vs.$$.fragment),pa=e(),i(qs.$$.fragment),Ma=e(),Rs=j("p"),Rs.textContent=Be,oa=e(),i(zs.$$.fragment),ra=e(),i(Fs.$$.fragment),ca=e(),_s=j("p"),_s.textContent=Ze,ja=e(),Hs=j("p"),Hs.innerHTML=ke,ha=e(),i(Ls.$$.fragment),ma=e(),i(Ds.$$.fragment),Ja=e(),Ps=j("p"),Ps.textContent=Qe,ya=e(),Ks=j("p"),Ks.innerHTML=Ge,ua=e(),i(Os.$$.fragment),ga=e(),i(st.$$.fragment),Ta=e(),tt=j("p"),tt.textContent=Ne,fa=e(),i(lt.$$.fragment),wa=e(),i(at.$$.fragment),da=e(),i(et.$$.fragment),Ua=e(),nt=j("p"),nt.textContent=Ee,$a=e(),i(it.$$.fragment),Ia=e(),i(pt.$$.fragment),ba=e(),Mt=j("p"),Mt.textContent=ve,Ca=e(),ot=j("p"),ot.innerHTML=We,xa=e(),i(rt.$$.fragment),Ba=e(),i(ct.$$.fragment),Za=e(),jt=j("p"),jt.textContent=Xe,ka=e(),ht=j("p"),ht.innerHTML=Ae,Qa=e(),i(mt.$$.fragment),Ga=e(),i(Jt.$$.fragment),Na=e(),i(yt.$$.fragment),Ea=e(),ut=j("p"),ut.textContent=Ye,va=e(),i(gt.$$.fragment),Wa=e(),i(Tt.$$.fragment),Xa=e(),ft=j("p"),ft.textContent=Se,Aa=e(),i(wt.$$.fragment),Ya=e(),i(dt.$$.fragment),Sa=e(),Ut=j("p"),Ut.textContent=Ve,Va=e(),i($t.$$.fragment),qa=e(),i(It.$$.fragment),Ra=e(),bt=j("p"),bt.innerHTML=qe,za=e(),i(Ct.$$.fragment),Fa=e(),i(xt.$$.fragment),_a=e(),i(Bt.$$.fragment),Ha=e(),i(Zt.$$.fragment),La=e(),kt=j("p"),kt.innerHTML=Re,Da=e(),Qt=j("p"),Qt.textContent=ze,Pa=e(),Nt=j("p"),this.h()},l(s){const t=Oe("svelte-u9bgzb",document.head);u=h(t,"META",{name:!0,content:!0}),t.forEach(l),Et=n(s),Gt=h(s,"P",{}),Fe(Gt).forEach(l),vt=n(s),p(g.$$.fragment,s),Wt=n(s),T=h(s,"P",{"data-svelte-h":!0}),m(T)!=="svelte-70k4fj"&&(T.innerHTML=se),Xt=n(s),f=h(s,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1pkj38e"&&(f.innerHTML=te),At=n(s),p(w.$$.fragment,s),Yt=n(s),p(d.$$.fragment,s),St=n(s),p(U.$$.fragment,s),Vt=n(s),p($.$$.fragment,s),qt=n(s),p(I.$$.fragment,s),Rt=n(s),p(b.$$.fragment,s),zt=n(s),p(C.$$.fragment,s),Ft=n(s),p(x.$$.fragment,s),_t=n(s),B=h(s,"P",{"data-svelte-h":!0}),m(B)!=="svelte-ys53zo"&&(B.innerHTML=le),Ht=n(s),Z=h(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-2l8ybr"&&(Z.textContent=ae),Lt=n(s),p(k.$$.fragment,s),Dt=n(s),Q=h(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-62skcu"&&(Q.innerHTML=ee),Pt=n(s),p(G.$$.fragment,s),Kt=n(s),N=h(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-88xj6h"&&(N.textContent=ne),Ot=n(s),p(E.$$.fragment,s),sl=n(s),p(v.$$.fragment,s),tl=n(s),W=h(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1mnrr3b"&&(W.textContent=ie),ll=n(s),p(X.$$.fragment,s),al=n(s),p(A.$$.fragment,s),el=n(s),Y=h(s,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-4s1xv3"&&(Y.textContent=pe),nl=n(s),p(S.$$.fragment,s),il=n(s),p(V.$$.fragment,s),pl=n(s),q=h(s,"P",{"data-svelte-h":!0}),m(q)!=="svelte-vnhv92"&&(q.textContent=Me),Ml=n(s),p(R.$$.fragment,s),ol=n(s),p(z.$$.fragment,s),rl=n(s),p(F.$$.fragment,s),cl=n(s),p(_.$$.fragment,s),jl=n(s),H=h(s,"P",{"data-svelte-h":!0}),m(H)!=="svelte-vlz10z"&&(H.textContent=oe),hl=n(s),p(L.$$.fragment,s),ml=n(s),p(D.$$.fragment,s),Jl=n(s),P=h(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-18cimv4"&&(P.textContent=re),yl=n(s),K=h(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-kjz90x"&&(K.innerHTML=ce),ul=n(s),p(O.$$.fragment,s),gl=n(s),p(ss.$$.fragment,s),Tl=n(s),ts=h(s,"P",{"data-svelte-h":!0}),m(ts)!=="svelte-qln4hq"&&(ts.textContent=je),fl=n(s),p(ls.$$.fragment,s),wl=n(s),p(as.$$.fragment,s),dl=n(s),es=h(s,"P",{"data-svelte-h":!0}),m(es)!=="svelte-yinzpl"&&(es.textContent=he),Ul=n(s),p(ns.$$.fragment,s),$l=n(s),p(is.$$.fragment,s),Il=n(s),ps=h(s,"P",{"data-svelte-h":!0}),m(ps)!=="svelte-mqluby"&&(ps.textContent=me),bl=n(s),p(Ms.$$.fragment,s),Cl=n(s),p(os.$$.fragment,s),xl=n(s),rs=h(s,"P",{"data-svelte-h":!0}),m(rs)!=="svelte-1wq8md5"&&(rs.textContent=Je),Bl=n(s),p(cs.$$.fragment,s),Zl=n(s),p(js.$$.fragment,s),kl=n(s),hs=h(s,"P",{"data-svelte-h":!0}),m(hs)!=="svelte-tf7teq"&&(hs.textContent=ye),Ql=n(s),p(ms.$$.fragment,s),Gl=n(s),p(Js.$$.fragment,s),Nl=n(s),p(ys.$$.fragment,s),El=n(s),us=h(s,"P",{"data-svelte-h":!0}),m(us)!=="svelte-1in7idl"&&(us.textContent=ue),vl=n(s),gs=h(s,"P",{"data-svelte-h":!0}),m(gs)!=="svelte-18afluh"&&(gs.innerHTML=ge),Wl=n(s),p(Ts.$$.fragment,s),Xl=n(s),p(fs.$$.fragment,s),Al=n(s),ws=h(s,"P",{"data-svelte-h":!0}),m(ws)!=="svelte-12s1din"&&(ws.textContent=Te),Yl=n(s),ds=h(s,"P",{"data-svelte-h":!0}),m(ds)!=="svelte-1jpdfy8"&&(ds.innerHTML=fe),Sl=n(s),p(Us.$$.fragment,s),Vl=n(s),p($s.$$.fragment,s),ql=n(s),Is=h(s,"P",{"data-svelte-h":!0}),m(Is)!=="svelte-1h8ubig"&&(Is.textContent=we),Rl=n(s),bs=h(s,"P",{"data-svelte-h":!0}),m(bs)!=="svelte-1edrfzt"&&(bs.innerHTML=de),zl=n(s),p(Cs.$$.fragment,s),Fl=n(s),p(xs.$$.fragment,s),_l=n(s),Bs=h(s,"P",{"data-svelte-h":!0}),m(Bs)!=="svelte-zj5o06"&&(Bs.textContent=Ue),Hl=n(s),p(Zs.$$.fragment,s),Ll=n(s),p(ks.$$.fragment,s),Dl=n(s),p(Qs.$$.fragment,s),Pl=n(s),Gs=h(s,"P",{"data-svelte-h":!0}),m(Gs)!=="svelte-1nlp89w"&&(Gs.textContent=$e),Kl=n(s),Ns=h(s,"P",{"data-svelte-h":!0}),m(Ns)!=="svelte-10vvvxx"&&(Ns.innerHTML=Ie),Ol=n(s),p(Es.$$.fragment,s),sa=n(s),p(vs.$$.fragment,s),ta=n(s),Ws=h(s,"P",{"data-svelte-h":!0}),m(Ws)!=="svelte-d15mev"&&(Ws.textContent=be),la=n(s),Xs=h(s,"P",{"data-svelte-h":!0}),m(Xs)!=="svelte-pxrbuw"&&(Xs.innerHTML=Ce),aa=n(s),p(As.$$.fragment,s),ea=n(s),p(Ys.$$.fragment,s),na=n(s),Ss=h(s,"P",{"data-svelte-h":!0}),m(Ss)!=="svelte-1oenl8f"&&(Ss.textContent=xe),ia=n(s),p(Vs.$$.fragment,s),pa=n(s),p(qs.$$.fragment,s),Ma=n(s),Rs=h(s,"P",{"data-svelte-h":!0}),m(Rs)!=="svelte-66badz"&&(Rs.textContent=Be),oa=n(s),p(zs.$$.fragment,s),ra=n(s),p(Fs.$$.fragment,s),ca=n(s),_s=h(s,"P",{"data-svelte-h":!0}),m(_s)!=="svelte-13iv3hh"&&(_s.textContent=Ze),ja=n(s),Hs=h(s,"P",{"data-svelte-h":!0}),m(Hs)!=="svelte-1mgyz4r"&&(Hs.innerHTML=ke),ha=n(s),p(Ls.$$.fragment,s),ma=n(s),p(Ds.$$.fragment,s),Ja=n(s),Ps=h(s,"P",{"data-svelte-h":!0}),m(Ps)!=="svelte-1y7kqaa"&&(Ps.textContent=Qe),ya=n(s),Ks=h(s,"P",{"data-svelte-h":!0}),m(Ks)!=="svelte-m8xmew"&&(Ks.innerHTML=Ge),ua=n(s),p(Os.$$.fragment,s),ga=n(s),p(st.$$.fragment,s),Ta=n(s),tt=h(s,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-m7q2yg"&&(tt.textContent=Ne),fa=n(s),p(lt.$$.fragment,s),wa=n(s),p(at.$$.fragment,s),da=n(s),p(et.$$.fragment,s),Ua=n(s),nt=h(s,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-174b8m1"&&(nt.textContent=Ee),$a=n(s),p(it.$$.fragment,s),Ia=n(s),p(pt.$$.fragment,s),ba=n(s),Mt=h(s,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-cnruui"&&(Mt.textContent=ve),Ca=n(s),ot=h(s,"P",{"data-svelte-h":!0}),m(ot)!=="svelte-hwgezm"&&(ot.innerHTML=We),xa=n(s),p(rt.$$.fragment,s),Ba=n(s),p(ct.$$.fragment,s),Za=n(s),jt=h(s,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-1tpexz3"&&(jt.textContent=Xe),ka=n(s),ht=h(s,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-hwgezm"&&(ht.innerHTML=Ae),Qa=n(s),p(mt.$$.fragment,s),Ga=n(s),p(Jt.$$.fragment,s),Na=n(s),p(yt.$$.fragment,s),Ea=n(s),ut=h(s,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-1js246c"&&(ut.textContent=Ye),va=n(s),p(gt.$$.fragment,s),Wa=n(s),p(Tt.$$.fragment,s),Xa=n(s),ft=h(s,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-7l7zu1"&&(ft.textContent=Se),Aa=n(s),p(wt.$$.fragment,s),Ya=n(s),p(dt.$$.fragment,s),Sa=n(s),Ut=h(s,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-1uv5lul"&&(Ut.textContent=Ve),Va=n(s),p($t.$$.fragment,s),qa=n(s),p(It.$$.fragment,s),Ra=n(s),bt=h(s,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-14q869u"&&(bt.innerHTML=qe),za=n(s),p(Ct.$$.fragment,s),Fa=n(s),p(xt.$$.fragment,s),_a=n(s),p(Bt.$$.fragment,s),Ha=n(s),p(Zt.$$.fragment,s),La=n(s),kt=h(s,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-62a9et"&&(kt.innerHTML=Re),Da=n(s),Qt=h(s,"P",{"data-svelte-h":!0}),m(Qt)!=="svelte-1yyf4wc"&&(Qt.textContent=ze),Pa=n(s),Nt=h(s,"P",{}),Fe(Nt).forEach(l),this.h()},h(){_e(u,"name","hf:doc:metadata"),_e(u,"content",ln)},m(s,t){sn(document.head,u),a(s,Et,t),a(s,Gt,t),a(s,vt,t),M(g,s,t),a(s,Wt,t),a(s,T,t),a(s,Xt,t),a(s,f,t),a(s,At,t),M(w,s,t),a(s,Yt,t),M(d,s,t),a(s,St,t),M(U,s,t),a(s,Vt,t),M($,s,t),a(s,qt,t),M(I,s,t),a(s,Rt,t),M(b,s,t),a(s,zt,t),M(C,s,t),a(s,Ft,t),M(x,s,t),a(s,_t,t),a(s,B,t),a(s,Ht,t),a(s,Z,t),a(s,Lt,t),M(k,s,t),a(s,Dt,t),a(s,Q,t),a(s,Pt,t),M(G,s,t),a(s,Kt,t),a(s,N,t),a(s,Ot,t),M(E,s,t),a(s,sl,t),M(v,s,t),a(s,tl,t),a(s,W,t),a(s,ll,t),M(X,s,t),a(s,al,t),M(A,s,t),a(s,el,t),a(s,Y,t),a(s,nl,t),M(S,s,t),a(s,il,t),M(V,s,t),a(s,pl,t),a(s,q,t),a(s,Ml,t),M(R,s,t),a(s,ol,t),M(z,s,t),a(s,rl,t),M(F,s,t),a(s,cl,t),M(_,s,t),a(s,jl,t),a(s,H,t),a(s,hl,t),M(L,s,t),a(s,ml,t),M(D,s,t),a(s,Jl,t),a(s,P,t),a(s,yl,t),a(s,K,t),a(s,ul,t),M(O,s,t),a(s,gl,t),M(ss,s,t),a(s,Tl,t),a(s,ts,t),a(s,fl,t),M(ls,s,t),a(s,wl,t),M(as,s,t),a(s,dl,t),a(s,es,t),a(s,Ul,t),M(ns,s,t),a(s,$l,t),M(is,s,t),a(s,Il,t),a(s,ps,t),a(s,bl,t),M(Ms,s,t),a(s,Cl,t),M(os,s,t),a(s,xl,t),a(s,rs,t),a(s,Bl,t),M(cs,s,t),a(s,Zl,t),M(js,s,t),a(s,kl,t),a(s,hs,t),a(s,Ql,t),M(ms,s,t),a(s,Gl,t),M(Js,s,t),a(s,Nl,t),M(ys,s,t),a(s,El,t),a(s,us,t),a(s,vl,t),a(s,gs,t),a(s,Wl,t),M(Ts,s,t),a(s,Xl,t),M(fs,s,t),a(s,Al,t),a(s,ws,t),a(s,Yl,t),a(s,ds,t),a(s,Sl,t),M(Us,s,t),a(s,Vl,t),M($s,s,t),a(s,ql,t),a(s,Is,t),a(s,Rl,t),a(s,bs,t),a(s,zl,t),M(Cs,s,t),a(s,Fl,t),M(xs,s,t),a(s,_l,t),a(s,Bs,t),a(s,Hl,t),M(Zs,s,t),a(s,Ll,t),M(ks,s,t),a(s,Dl,t),M(Qs,s,t),a(s,Pl,t),a(s,Gs,t),a(s,Kl,t),a(s,Ns,t),a(s,Ol,t),M(Es,s,t),a(s,sa,t),M(vs,s,t),a(s,ta,t),a(s,Ws,t),a(s,la,t),a(s,Xs,t),a(s,aa,t),M(As,s,t),a(s,ea,t),M(Ys,s,t),a(s,na,t),a(s,Ss,t),a(s,ia,t),M(Vs,s,t),a(s,pa,t),M(qs,s,t),a(s,Ma,t),a(s,Rs,t),a(s,oa,t),M(zs,s,t),a(s,ra,t),M(Fs,s,t),a(s,ca,t),a(s,_s,t),a(s,ja,t),a(s,Hs,t),a(s,ha,t),M(Ls,s,t),a(s,ma,t),M(Ds,s,t),a(s,Ja,t),a(s,Ps,t),a(s,ya,t),a(s,Ks,t),a(s,ua,t),M(Os,s,t),a(s,ga,t),M(st,s,t),a(s,Ta,t),a(s,tt,t),a(s,fa,t),M(lt,s,t),a(s,wa,t),M(at,s,t),a(s,da,t),M(et,s,t),a(s,Ua,t),a(s,nt,t),a(s,$a,t),M(it,s,t),a(s,Ia,t),M(pt,s,t),a(s,ba,t),a(s,Mt,t),a(s,Ca,t),a(s,ot,t),a(s,xa,t),M(rt,s,t),a(s,Ba,t),M(ct,s,t),a(s,Za,t),a(s,jt,t),a(s,ka,t),a(s,ht,t),a(s,Qa,t),M(mt,s,t),a(s,Ga,t),M(Jt,s,t),a(s,Na,t),M(yt,s,t),a(s,Ea,t),a(s,ut,t),a(s,va,t),M(gt,s,t),a(s,Wa,t),M(Tt,s,t),a(s,Xa,t),a(s,ft,t),a(s,Aa,t),M(wt,s,t),a(s,Ya,t),M(dt,s,t),a(s,Sa,t),a(s,Ut,t),a(s,Va,t),M($t,s,t),a(s,qa,t),M(It,s,t),a(s,Ra,t),a(s,bt,t),a(s,za,t),M(Ct,s,t),a(s,Fa,t),M(xt,s,t),a(s,_a,t),M(Bt,s,t),a(s,Ha,t),M(Zt,s,t),a(s,La,t),a(s,kt,t),a(s,Da,t),a(s,Qt,t),a(s,Pa,t),a(s,Nt,t),Ka=!0},p:Le,i(s){Ka||(o(g.$$.fragment,s),o(w.$$.fragment,s),o(d.$$.fragment,s),o(U.$$.fragment,s),o($.$$.fragment,s),o(I.$$.fragment,s),o(b.$$.fragment,s),o(C.$$.fragment,s),o(x.$$.fragment,s),o(k.$$.fragment,s),o(G.$$.fragment,s),o(E.$$.fragment,s),o(v.$$.fragment,s),o(X.$$.fragment,s),o(A.$$.fragment,s),o(S.$$.fragment,s),o(V.$$.fragment,s),o(R.$$.fragment,s),o(z.$$.fragment,s),o(F.$$.fragment,s),o(_.$$.fragment,s),o(L.$$.fragment,s),o(D.$$.fragment,s),o(O.$$.fragment,s),o(ss.$$.fragment,s),o(ls.$$.fragment,s),o(as.$$.fragment,s),o(ns.$$.fragment,s),o(is.$$.fragment,s),o(Ms.$$.fragment,s),o(os.$$.fragment,s),o(cs.$$.fragment,s),o(js.$$.fragment,s),o(ms.$$.fragment,s),o(Js.$$.fragment,s),o(ys.$$.fragment,s),o(Ts.$$.fragment,s),o(fs.$$.fragment,s),o(Us.$$.fragment,s),o($s.$$.fragment,s),o(Cs.$$.fragment,s),o(xs.$$.fragment,s),o(Zs.$$.fragment,s),o(ks.$$.fragment,s),o(Qs.$$.fragment,s),o(Es.$$.fragment,s),o(vs.$$.fragment,s),o(As.$$.fragment,s),o(Ys.$$.fragment,s),o(Vs.$$.fragment,s),o(qs.$$.fragment,s),o(zs.$$.fragment,s),o(Fs.$$.fragment,s),o(Ls.$$.fragment,s),o(Ds.$$.fragment,s),o(Os.$$.fragment,s),o(st.$$.fragment,s),o(lt.$$.fragment,s),o(at.$$.fragment,s),o(et.$$.fragment,s),o(it.$$.fragment,s),o(pt.$$.fragment,s),o(rt.$$.fragment,s),o(ct.$$.fragment,s),o(mt.$$.fragment,s),o(Jt.$$.fragment,s),o(yt.$$.fragment,s),o(gt.$$.fragment,s),o(Tt.$$.fragment,s),o(wt.$$.fragment,s),o(dt.$$.fragment,s),o($t.$$.fragment,s),o(It.$$.fragment,s),o(Ct.$$.fragment,s),o(xt.$$.fragment,s),o(Bt.$$.fragment,s),o(Zt.$$.fragment,s),Ka=!0)},o(s){r(g.$$.fragment,s),r(w.$$.fragment,s),r(d.$$.fragment,s),r(U.$$.fragment,s),r($.$$.fragment,s),r(I.$$.fragment,s),r(b.$$.fragment,s),r(C.$$.fragment,s),r(x.$$.fragment,s),r(k.$$.fragment,s),r(G.$$.fragment,s),r(E.$$.fragment,s),r(v.$$.fragment,s),r(X.$$.fragment,s),r(A.$$.fragment,s),r(S.$$.fragment,s),r(V.$$.fragment,s),r(R.$$.fragment,s),r(z.$$.fragment,s),r(F.$$.fragment,s),r(_.$$.fragment,s),r(L.$$.fragment,s),r(D.$$.fragment,s),r(O.$$.fragment,s),r(ss.$$.fragment,s),r(ls.$$.fragment,s),r(as.$$.fragment,s),r(ns.$$.fragment,s),r(is.$$.fragment,s),r(Ms.$$.fragment,s),r(os.$$.fragment,s),r(cs.$$.fragment,s),r(js.$$.fragment,s),r(ms.$$.fragment,s),r(Js.$$.fragment,s),r(ys.$$.fragment,s),r(Ts.$$.fragment,s),r(fs.$$.fragment,s),r(Us.$$.fragment,s),r($s.$$.fragment,s),r(Cs.$$.fragment,s),r(xs.$$.fragment,s),r(Zs.$$.fragment,s),r(ks.$$.fragment,s),r(Qs.$$.fragment,s),r(Es.$$.fragment,s),r(vs.$$.fragment,s),r(As.$$.fragment,s),r(Ys.$$.fragment,s),r(Vs.$$.fragment,s),r(qs.$$.fragment,s),r(zs.$$.fragment,s),r(Fs.$$.fragment,s),r(Ls.$$.fragment,s),r(Ds.$$.fragment,s),r(Os.$$.fragment,s),r(st.$$.fragment,s),r(lt.$$.fragment,s),r(at.$$.fragment,s),r(et.$$.fragment,s),r(it.$$.fragment,s),r(pt.$$.fragment,s),r(rt.$$.fragment,s),r(ct.$$.fragment,s),r(mt.$$.fragment,s),r(Jt.$$.fragment,s),r(yt.$$.fragment,s),r(gt.$$.fragment,s),r(Tt.$$.fragment,s),r(wt.$$.fragment,s),r(dt.$$.fragment,s),r($t.$$.fragment,s),r(It.$$.fragment,s),r(Ct.$$.fragment,s),r(xt.$$.fragment,s),r(Bt.$$.fragment,s),r(Zt.$$.fragment,s),Ka=!1},d(s){s&&(l(Et),l(Gt),l(vt),l(Wt),l(T),l(Xt),l(f),l(At),l(Yt),l(St),l(Vt),l(qt),l(Rt),l(zt),l(Ft),l(_t),l(B),l(Ht),l(Z),l(Lt),l(Dt),l(Q),l(Pt),l(Kt),l(N),l(Ot),l(sl),l(tl),l(W),l(ll),l(al),l(el),l(Y),l(nl),l(il),l(pl),l(q),l(Ml),l(ol),l(rl),l(cl),l(jl),l(H),l(hl),l(ml),l(Jl),l(P),l(yl),l(K),l(ul),l(gl),l(Tl),l(ts),l(fl),l(wl),l(dl),l(es),l(Ul),l($l),l(Il),l(ps),l(bl),l(Cl),l(xl),l(rs),l(Bl),l(Zl),l(kl),l(hs),l(Ql),l(Gl),l(Nl),l(El),l(us),l(vl),l(gs),l(Wl),l(Xl),l(Al),l(ws),l(Yl),l(ds),l(Sl),l(Vl),l(ql),l(Is),l(Rl),l(bs),l(zl),l(Fl),l(_l),l(Bs),l(Hl),l(Ll),l(Dl),l(Pl),l(Gs),l(Kl),l(Ns),l(Ol),l(sa),l(ta),l(Ws),l(la),l(Xs),l(aa),l(ea),l(na),l(Ss),l(ia),l(pa),l(Ma),l(Rs),l(oa),l(ra),l(ca),l(_s),l(ja),l(Hs),l(ha),l(ma),l(Ja),l(Ps),l(ya),l(Ks),l(ua),l(ga),l(Ta),l(tt),l(fa),l(wa),l(da),l(Ua),l(nt),l($a),l(Ia),l(ba),l(Mt),l(Ca),l(ot),l(xa),l(Ba),l(Za),l(jt),l(ka),l(ht),l(Qa),l(Ga),l(Na),l(Ea),l(ut),l(va),l(Wa),l(Xa),l(ft),l(Aa),l(Ya),l(Sa),l(Ut),l(Va),l(qa),l(Ra),l(bt),l(za),l(Fa),l(_a),l(Ha),l(La),l(kt),l(Da),l(Qt),l(Pa),l(Nt)),l(u),c(g,s),c(w,s),c(d,s),c(U,s),c($,s),c(I,s),c(b,s),c(C,s),c(x,s),c(k,s),c(G,s),c(E,s),c(v,s),c(X,s),c(A,s),c(S,s),c(V,s),c(R,s),c(z,s),c(F,s),c(_,s),c(L,s),c(D,s),c(O,s),c(ss,s),c(ls,s),c(as,s),c(ns,s),c(is,s),c(Ms,s),c(os,s),c(cs,s),c(js,s),c(ms,s),c(Js,s),c(ys,s),c(Ts,s),c(fs,s),c(Us,s),c($s,s),c(Cs,s),c(xs,s),c(Zs,s),c(ks,s),c(Qs,s),c(Es,s),c(vs,s),c(As,s),c(Ys,s),c(Vs,s),c(qs,s),c(zs,s),c(Fs,s),c(Ls,s),c(Ds,s),c(Os,s),c(st,s),c(lt,s),c(at,s),c(et,s),c(it,s),c(pt,s),c(rt,s),c(ct,s),c(mt,s),c(Jt,s),c(yt,s),c(gt,s),c(Tt,s),c(wt,s),c(dt,s),c($t,s),c(It,s),c(Ct,s),c(xt,s),c(Bt,s),c(Zt,s)}}}const ln='{"title":"🤗 Hugging Face Inference Endpoints","local":"-hugging-face-inference-endpoints","sections":[{"title":"Getting Started","local":"getting-started","sections":[{"title":"Install","local":"install","sections":[{"title":"Node","local":"node","sections":[],"depth":4},{"title":"Deno","local":"deno","sections":[],"depth":4}],"depth":3},{"title":"Initialize","local":"initialize","sections":[{"title":"Tree-shaking","local":"tree-shaking","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"Fill Mask","local":"fill-mask","sections":[],"depth":3},{"title":"Summarization","local":"summarization","sections":[],"depth":3},{"title":"Question Answering","local":"question-answering","sections":[],"depth":3},{"title":"Table Question Answering","local":"table-question-answering","sections":[],"depth":3},{"title":"Text Classification","local":"text-classification","sections":[],"depth":3},{"title":"Text Generation","local":"text-generation","sections":[],"depth":3},{"title":"Token Classification","local":"token-classification","sections":[],"depth":3},{"title":"Translation","local":"translation","sections":[],"depth":3},{"title":"Zero-Shot Classification","local":"zero-shot-classification","sections":[],"depth":3},{"title":"Conversational","local":"conversational","sections":[],"depth":3},{"title":"Sentence Similarity","local":"sentence-similarity","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"Automatic Speech Recognition","local":"automatic-speech-recognition","sections":[],"depth":3},{"title":"Audio Classification","local":"audio-classification","sections":[],"depth":3},{"title":"Text To Speech","local":"text-to-speech","sections":[],"depth":3},{"title":"Audio To Audio","local":"audio-to-audio","sections":[],"depth":3}],"depth":2},{"title":"Computer Vision","local":"computer-vision","sections":[{"title":"Image Classification","local":"image-classification","sections":[],"depth":3},{"title":"Object Detection","local":"object-detection","sections":[],"depth":3},{"title":"Image Segmentation","local":"image-segmentation","sections":[],"depth":3},{"title":"Image To Text","local":"image-to-text","sections":[],"depth":3},{"title":"Text To Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image To Image","local":"image-to-image","sections":[],"depth":3},{"title":"Zero Shot Image Classification","local":"zero-shot-image-classification","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"Feature Extraction","local":"feature-extraction","sections":[],"depth":3},{"title":"Visual Question Answering","local":"visual-question-answering","sections":[],"depth":3},{"title":"Document Question Answering","local":"document-question-answering","sections":[],"depth":3}],"depth":2},{"title":"Tabular","local":"tabular","sections":[{"title":"Tabular Regression","local":"tabular-regression","sections":[],"depth":3},{"title":"Tabular Classification","local":"tabular-classification","sections":[],"depth":3}],"depth":2},{"title":"Custom Calls","local":"custom-calls","sections":[],"depth":2},{"title":"Custom Inference Endpoints","local":"custom-inference-endpoints","sections":[],"depth":2},{"title":"Running tests","local":"running-tests","sections":[],"depth":2},{"title":"Finding appropriate models","local":"finding-appropriate-models","sections":[],"depth":2}],"depth":1}';function an(Oa){return De(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class on extends Pe{constructor(u){super(),Ke(this,u,an,tn,He,{})}}export{on as component};
