import{s as li,o as di,n as Yo}from"../chunks/scheduler.182ea377.js";import{S as pi,i as ci,g as n,s as i,p as u,A as mi,h as s,f as o,c as a,q as h,j as m,m as d,k as p,v as t,a as l,r as g,d as _,t as v,u as b}from"../chunks/index.008d68e4.js";import{T as ai}from"../chunks/Tip.4f096367.js";import{D as $}from"../chunks/Docstring.7aec8b85.js";import{C as at}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as it}from"../chunks/IconCopyLink.96bbb92b.js";import{E as ri}from"../chunks/ExampleCodeBlock.23e54afe.js";function fi(D){let c,J="🧪 This pipeline is for research purposes only.";return{c(){c=n("p"),c.textContent=J},l(w){c=s(w,"P",{"data-svelte-h":!0}),d(c)!=="svelte-1oxhjjd"&&(c.textContent=J)},m(w,V){l(w,c,V)},p:Yo,d(w){w&&o(c)}}}function ui(D){let c,J='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){c=n("p"),c.innerHTML=J},l(w){c=s(w,"P",{"data-svelte-h":!0}),d(c)!=="svelte-1wmc0l4"&&(c.innerHTML=J)},m(w,V){l(w,c,V)},p:Yo,d(w){w&&o(c)}}}function hi(D){let c,J="Examples:",w,V,Z;return V=new at({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9TRFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b192aWRlbyUwQSUwQXBpcGUlMjAlM0QlMjBUZXh0VG9WaWRlb1NEUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRhbW8tdmlsYWIlMkZ0ZXh0LXRvLXZpZGVvLW1zLTEuN2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyU3BpZGVybWFuJTIwaXMlMjBzdXJmaW5nJTIyJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQpLmZyYW1lcyUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoSDPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = TextToVideoSDPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt).frames
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path`}}),{c(){c=n("p"),c.textContent=J,w=i(),u(V.$$.fragment)},l(f){c=s(f,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=J),w=a(f),h(V.$$.fragment,f)},m(f,k){l(f,c,k),l(f,w,k),g(V,f,k),Z=!0},p:Yo,i(f){Z||(_(V.$$.fragment,f),Z=!0)},o(f){v(V.$$.fragment,f),Z=!1},d(f){f&&(o(c),o(w)),b(V,f)}}}function gi(D){let c,J="Examples:",w,V,Z;return V=new at({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_576w&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;spiderman running in the desert&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt, num_inference_steps=<span class="hljs-number">40</span>, height=<span class="hljs-number">320</span>, width=<span class="hljs-number">576</span>, num_frames=<span class="hljs-number">24</span>).frames
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># safe low-res video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames, output_video_path=<span class="hljs-string">&quot;./video_576_spiderman.mp4&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s offload the text-to-image model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cpu&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and load the image-to-image model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;cerspense/zeroscope_v2_XL&quot;</span>, torch_dtype=torch.float16, revision=<span class="hljs-string">&quot;refs/pr/15&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The VAE consumes A LOT of memory, let&#x27;s make sure we run it in sliced mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_slicing()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now let&#x27;s upscale it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video = [Image.fromarray(frame).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>)) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video_frames]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and denoise it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt, video=video, strength=<span class="hljs-number">0.6</span>).frames
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames, output_video_path=<span class="hljs-string">&quot;./video_1024_spiderman.mp4&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path`}}),{c(){c=n("p"),c.textContent=J,w=i(),u(V.$$.fragment)},l(f){c=s(f,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=J),w=a(f),h(V.$$.fragment,f)},m(f,k){l(f,c,k),l(f,w,k),g(V,f,k),Z=!0},p:Yo,i(f){Z||(_(V.$$.fragment,f),Z=!0)},o(f){v(V.$$.fragment,f),Z=!1},d(f){f&&(o(c),o(w)),b(V,f)}}}function _i(D){let c,J,w,V,Z,f,k,ce,Qo,rt,qn="Text-to-video",Kt,me,On='<a href="https://arxiv.org/abs/2308.06571" rel="nofollow">ModelScope Text-to-Video Technical Report</a> is by Jiuniu Wang, Hangjie Yuan, Dayou Chen, Yingya Zhang, Xiang Wang, Shiwei Zhang.',eo,fe,Kn="The abstract from the paper is:",to,ue,es='<em>This paper introduces ModelScopeT2V, a text-to-video synthesis model that evolves from a text-to-image synthesis model (i.e., Stable Diffusion). ModelScopeT2V incorporates spatio-temporal blocks to ensure consistent frame generation and smooth movement transitions. The model could adapt to varying frame numbers during training and inference, rendering it suitable for both image-text and video-text datasets. ModelScopeT2V brings together three components (i.e., VQGAN, a text encoder, and a denoising UNet), totally comprising 1.7 billion parameters, in which 0.5 billion parameters are dedicated to temporal capabilities. The model demonstrates superior performance over state-of-the-art methods across three evaluation metrics. The code and an online demo are available at <a href="https://modelscope.cn/models/damo/text-to-video-synthesis/summary" rel="nofollow">https://modelscope.cn/models/damo/text-to-video-synthesis/summary</a>.</em>',oo,he,ts='You can find additional information about Text-to-Video on the <a href="https://modelscope.cn/models/damo/text-to-video-synthesis/summary" rel="nofollow">project page</a>, <a href="https://github.com/modelscope/modelscope/" rel="nofollow">original codebase</a>, and try it out in a <a href="https://huggingface.co/spaces/damo-vilab/modelscope-text-to-video-synthesis" rel="nofollow">demo</a>. Official checkpoints can be found at <a href="https://huggingface.co/damo-vilab" rel="nofollow">damo-vilab</a> and <a href="https://huggingface.co/cerspense" rel="nofollow">cerspense</a>.',no,U,E,Rt,ge,qo,lt,os="Usage example",so,G,z,Ht,_e,Oo,dt,ns="<code>text-to-video-ms-1.7b</code>",io,ve,ss="Let’s start by generating a short video with the default length of 16 frames (2s at 8 fps):",ao,be,ro,xe,is=`Diffusers supports different optimization techniques to improve the latency
and memory footprint of a pipeline. Since videos are often more memory-heavy than images,
we can enable CPU offloading and VAE slicing to keep the memory footprint at bay.`,lo,Te,as="Let’s generate a video of 8 seconds (64 frames) on the same GPU using CPU offloading and VAE slicing:",po,we,co,ye,rs="It just takes <strong>7 GBs of GPU memory</strong> to generate the 64 video frames using PyTorch 2.0, “fp16” precision and the techniques mentioned above.",mo,Me,ls="We can also use a different scheduler easily, using the same method we’d use for Stable Diffusion:",fo,Ve,uo,Ze,ds="Here are some sample outputs:",ho,$e,ps=`<tbody><tr><td><center>An astronaut riding a horse.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/astr.gif" alt="An astronaut riding a horse." style="width: 300px;"/></center></td> <td><center>Darth vader surfing in waves.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/vader.gif" alt="Darth vader surfing in waves." style="width: 300px;"/></center></td></tr></tbody>`,go,I,N,At,Je,Ko,pt,cs="<code>cerspense/zeroscope_v2_576w</code> &amp; <code>cerspense/zeroscope_v2_XL</code>",_o,ke,ms=`Zeroscope are watermark-free model and have been trained on specific sizes such as <code>576x320</code> and <code>1024x576</code>.
One should first generate a video using the lower resolution checkpoint <a href="https://huggingface.co/cerspense/zeroscope_v2_576w" rel="nofollow"><code>cerspense/zeroscope_v2_576w</code></a> with <a href="/docs/diffusers/v0.25.0/en/api/pipelines/text_to_video#diffusers.TextToVideoSDPipeline">TextToVideoSDPipeline</a>,
which can then be upscaled using <a href="/docs/diffusers/v0.25.0/en/api/pipelines/text_to_video#diffusers.VideoToVideoSDPipeline">VideoToVideoSDPipeline</a> and <a href="https://huggingface.co/cerspense/zeroscope_v2_XL" rel="nofollow"><code>cerspense/zeroscope_v2_XL</code></a>.`,vo,Se,bo,Ce,fs="Now the video can be upscaled:",xo,De,To,je,us="Here are some sample outputs:",wo,Pe,hs=`<tbody><tr><td><center>Darth vader surfing in waves.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/darthvader_cerpense.gif" alt="Darth vader surfing in waves." style="width: 576px;"/></center></td></tr></tbody>`,yo,R,Mo,W,H,Ft,Ue,en,ct,gs="TextToVideoSDPipeline",Vo,x,Ge,tn,mt,_s="Pipeline for text-to-video generation.",on,ft,vs=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,nn,ut,bs="The pipeline also inherits the following loading methods:",sn,ht,xs='<li><a href="/docs/diffusers/v0.25.0/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',an,j,Ie,rn,gt,Ts="The call function to the pipeline for generation.",ln,A,dn,F,We,pn,_t,ws="Disables the FreeU mechanism if enabled.",cn,Y,Be,mn,vt,ys=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,fn,Q,Le,un,bt,Ms=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,hn,S,Xe,gn,xt,Vs='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',_n,Tt,Zs="The suffixes after the scaling factors represent the stages where they are being applied.",vn,wt,$s=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,bn,q,Ee,xn,yt,Js=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Tn,O,ze,wn,Mt,ks=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,yn,K,Ne,Mn,Vt,Ss="Encodes the prompt into text encoder hidden states.",Zo,B,ee,Yt,Re,Vn,Zt,Cs="VideoToVideoSDPipeline",$o,T,He,Zn,$t,Ds="Pipeline for text-guided video-to-video generation.",$n,Jt,js=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Jn,kt,Ps="The pipeline also inherits the following loading methods:",kn,St,Us='<li><a href="/docs/diffusers/v0.25.0/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',Sn,P,Ae,Cn,Ct,Gs="The call function to the pipeline for generation.",Dn,te,jn,oe,Fe,Pn,Dt,Is="Disables the FreeU mechanism if enabled.",Un,ne,Ye,Gn,jt,Ws=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,In,se,Qe,Wn,Pt,Bs=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Bn,C,qe,Ln,Ut,Ls='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Xn,Gt,Xs="The suffixes after the scaling factors represent the stages where they are being applied.",En,It,Es=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,zn,ie,Oe,Nn,Wt,zs=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Rn,ae,Ke,Hn,Bt,Ns=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,An,re,et,Fn,Lt,Rs="Encodes the prompt into text encoder hidden states.",Jo,L,le,Qt,tt,Yn,Xt,Hs="TextToVideoSDPipelineOutput",ko,X,ot,Qn,Et,As="Output class for text-to-video pipelines.",So;return w=new ai({props:{warning:!0,$$slots:{default:[fi]},$$scope:{ctx:D}}}),ce=new it({}),ge=new it({}),_e=new it({}),be=new at({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTcGlkZXJtYW4lMjBpcyUyMHN1cmZpbmclMjIlMEF2aWRlb19mcmFtZXMlMjAlM0QlMjBwaXBlKHByb21wdCkuZnJhbWVzJTBBdmlkZW9fcGF0aCUyMCUzRCUyMGV4cG9ydF90b192aWRlbyh2aWRlb19mcmFtZXMpJTBBdmlkZW9fcGF0aA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
video_frames = pipe(prompt).frames
video_path = export_to_video(video_frames)
video_path`}}),we=new at({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMG1lbW9yeSUyMG9wdGltaXphdGlvbiUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJEYXJ0aCUyMFZhZGVyJTIwc3VyZmluZyUyMGElMjB3YXZlJTIyJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1fZnJhbWVzJTNENjQpLmZyYW1lcyUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.enable_vae_slicing()

prompt = <span class="hljs-string">&quot;Darth Vader surfing a wave&quot;</span>
video_frames = pipe(prompt, num_frames=<span class="hljs-number">64</span>).frames
video_path = export_to_video(video_frames)
video_path`}}),Ve=new at({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTcGlkZXJtYW4lMjBpcyUyMHN1cmZpbmclMjIlMEF2aWRlb19mcmFtZXMlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuZnJhbWVzJTBBdmlkZW9fcGF0aCUyMCUzRCUyMGV4cG9ydF90b192aWRlbyh2aWRlb19mcmFtZXMpJTBBdmlkZW9fcGF0aA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
video_frames = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).frames
video_path = export_to_video(video_frames)
video_path`}}),Je=new it({}),Se=new at({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJjZXJzcGVuc2UlMkZ6ZXJvc2NvcGVfdjJfNTc2dyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBJTIzJTIwbWVtb3J5JTIwb3B0aW1pemF0aW9uJTBBcGlwZS51bmV0LmVuYWJsZV9mb3J3YXJkX2NodW5raW5nKGNodW5rX3NpemUlM0QxJTJDJTIwZGltJTNEMSklMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyRGFydGglMjBWYWRlciUyMHN1cmZpbmclMjBhJTIwd2F2ZSUyMiUwQXZpZGVvX2ZyYW1lcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2ZyYW1lcyUzRDI0KS5mcmFtZXMlMEF2aWRlb19wYXRoJTIwJTNEJTIwZXhwb3J0X3RvX3ZpZGVvKHZpZGVvX2ZyYW1lcyklMEF2aWRlb19wYXRo",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_576w&quot;</span>, torch_dtype=torch.float16)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.unet.enable_forward_chunking(chunk_size=<span class="hljs-number">1</span>, dim=<span class="hljs-number">1</span>)
pipe.enable_vae_slicing()

prompt = <span class="hljs-string">&quot;Darth Vader surfing a wave&quot;</span>
video_frames = pipe(prompt, num_frames=<span class="hljs-number">24</span>).frames
video_path = export_to_video(video_frames)
video_path`}}),De=new at({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJjZXJzcGVuc2UlMkZ6ZXJvc2NvcGVfdjJfWEwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEElMjMlMjBtZW1vcnklMjBvcHRpbWl6YXRpb24lMEFwaXBlLnVuZXQuZW5hYmxlX2ZvcndhcmRfY2h1bmtpbmcoY2h1bmtfc2l6ZSUzRDElMkMlMjBkaW0lM0QxKSUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEF2aWRlbyUyMCUzRCUyMCU1QkltYWdlLmZyb21hcnJheShmcmFtZSkucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMjBmb3IlMjBmcmFtZSUyMGluJTIwdmlkZW9fZnJhbWVzJTVEJTBBJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjB2aWRlbyUzRHZpZGVvJTJDJTIwc3RyZW5ndGglM0QwLjYpLmZyYW1lcyUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_XL&quot;</span>, torch_dtype=torch.float16)
pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.unet.enable_forward_chunking(chunk_size=<span class="hljs-number">1</span>, dim=<span class="hljs-number">1</span>)
pipe.enable_vae_slicing()

video = [Image.fromarray(frame).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>)) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video_frames]

video_frames = pipe(prompt, video=video, strength=<span class="hljs-number">0.6</span>).frames
video_path = export_to_video(video_frames)
video_path`}}),R=new ai({props:{$$slots:{default:[ui]},$$scope:{ctx:D}}}),Ue=new it({}),Ge=new $({props:{name:"class diffusers.TextToVideoSDPipeline",anchor:"diffusers.TextToVideoSDPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet3DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.TextToVideoSDPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.TextToVideoSDPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.TextToVideoSDPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/v0.25.0/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.TextToVideoSDPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.25.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L79"}}),Ie=new $({props:{name:"__call__",anchor:"diffusers.TextToVideoSDPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_frames",val:": int = 16"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 9.0"},{name:"negative_prompt",val:": Union = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'np'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L521",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),A=new ri({props:{anchor:"diffusers.TextToVideoSDPipeline.__call__.example",$$slots:{default:[hi]},$$scope:{ctx:D}}}),We=new $({props:{name:"disable_freeu",anchor:"diffusers.TextToVideoSDPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L517"}}),Be=new $({props:{name:"disable_vae_slicing",anchor:"diffusers.TextToVideoSDPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L135"}}),Le=new $({props:{name:"disable_vae_tiling",anchor:"diffusers.TextToVideoSDPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L152"}}),Xe=new $({props:{name:"enable_freeu",anchor:"diffusers.TextToVideoSDPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.TextToVideoSDPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.TextToVideoSDPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.TextToVideoSDPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L494"}}),Ee=new $({props:{name:"enable_vae_slicing",anchor:"diffusers.TextToVideoSDPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L127"}}),ze=new $({props:{name:"enable_vae_tiling",anchor:"diffusers.TextToVideoSDPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L143"}}),Ne=new $({props:{name:"encode_prompt",anchor:"diffusers.TextToVideoSDPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L193"}}),Re=new it({}),He=new $({props:{name:"class diffusers.VideoToVideoSDPipeline",anchor:"diffusers.VideoToVideoSDPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet3DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.VideoToVideoSDPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.VideoToVideoSDPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.VideoToVideoSDPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/v0.25.0/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.VideoToVideoSDPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.25.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L155"}}),Ae=new $({props:{name:"__call__",anchor:"diffusers.VideoToVideoSDPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"video",val:": Union = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 15.0"},{name:"negative_prompt",val:": Union = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'np'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.video",description:`<strong>video</strong> (<code>List[np.ndarray]</code> or <code>torch.FloatTensor</code>) &#x2014;
<code>video</code> frames or tensor representing a video batch to be used as the starting point for the process.
Can also accept video latents as <code>image</code>, if passing latents directly, it will not be encoded again.`,name:"video"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>video</code>. Must be between 0 and 1. <code>video</code> is used as a
starting point, adding more noise to it the larger the <code>strength</code>. The number of denoising steps
depends on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the
denoising process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of
1 essentially ignores <code>video</code>.`,name:"strength"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in video generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L626",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),te=new ri({props:{anchor:"diffusers.VideoToVideoSDPipeline.__call__.example",$$slots:{default:[gi]},$$scope:{ctx:D}}}),Fe=new $({props:{name:"disable_freeu",anchor:"diffusers.VideoToVideoSDPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L622"}}),Ye=new $({props:{name:"disable_vae_slicing",anchor:"diffusers.VideoToVideoSDPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L211"}}),Qe=new $({props:{name:"disable_vae_tiling",anchor:"diffusers.VideoToVideoSDPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L228"}}),qe=new $({props:{name:"enable_freeu",anchor:"diffusers.VideoToVideoSDPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.VideoToVideoSDPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.VideoToVideoSDPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.VideoToVideoSDPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L599"}}),Oe=new $({props:{name:"enable_vae_slicing",anchor:"diffusers.VideoToVideoSDPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L203"}}),Ke=new $({props:{name:"enable_vae_tiling",anchor:"diffusers.VideoToVideoSDPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L219"}}),et=new $({props:{name:"encode_prompt",anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L269"}}),tt=new it({}),ot=new $({props:{name:"class diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",anchor:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",parameters:[{name:"frames",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput.frames",description:`<strong>frames</strong> (<code>List[np.ndarray]</code> or <code>torch.FloatTensor</code>) &#x2014;
List of denoised frames (essentially images) as NumPy arrays of shape <code>(height, width, num_channels)</code> or as
a <code>torch</code> tensor. The length of the list denotes the video length (the number of frames).`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_output.py#L12"}}),{c(){c=n("meta"),J=i(),u(w.$$.fragment),V=i(),Z=n("h1"),f=n("a"),k=n("span"),u(ce.$$.fragment),Qo=i(),rt=n("span"),rt.textContent=qn,Kt=i(),me=n("p"),me.innerHTML=On,eo=i(),fe=n("p"),fe.textContent=Kn,to=i(),ue=n("p"),ue.innerHTML=es,oo=i(),he=n("p"),he.innerHTML=ts,no=i(),U=n("h2"),E=n("a"),Rt=n("span"),u(ge.$$.fragment),qo=i(),lt=n("span"),lt.textContent=os,so=i(),G=n("h3"),z=n("a"),Ht=n("span"),u(_e.$$.fragment),Oo=i(),dt=n("span"),dt.innerHTML=ns,io=i(),ve=n("p"),ve.textContent=ss,ao=i(),u(be.$$.fragment),ro=i(),xe=n("p"),xe.textContent=is,lo=i(),Te=n("p"),Te.textContent=as,po=i(),u(we.$$.fragment),co=i(),ye=n("p"),ye.innerHTML=rs,mo=i(),Me=n("p"),Me.textContent=ls,fo=i(),u(Ve.$$.fragment),uo=i(),Ze=n("p"),Ze.textContent=ds,ho=i(),$e=n("table"),$e.innerHTML=ps,go=i(),I=n("h3"),N=n("a"),At=n("span"),u(Je.$$.fragment),Ko=i(),pt=n("span"),pt.innerHTML=cs,_o=i(),ke=n("p"),ke.innerHTML=ms,vo=i(),u(Se.$$.fragment),bo=i(),Ce=n("p"),Ce.textContent=fs,xo=i(),u(De.$$.fragment),To=i(),je=n("p"),je.textContent=us,wo=i(),Pe=n("table"),Pe.innerHTML=hs,yo=i(),u(R.$$.fragment),Mo=i(),W=n("h2"),H=n("a"),Ft=n("span"),u(Ue.$$.fragment),en=i(),ct=n("span"),ct.textContent=gs,Vo=i(),x=n("div"),u(Ge.$$.fragment),tn=i(),mt=n("p"),mt.textContent=_s,on=i(),ft=n("p"),ft.innerHTML=vs,nn=i(),ut=n("p"),ut.textContent=bs,sn=i(),ht=n("ul"),ht.innerHTML=xs,an=i(),j=n("div"),u(Ie.$$.fragment),rn=i(),gt=n("p"),gt.textContent=Ts,ln=i(),u(A.$$.fragment),dn=i(),F=n("div"),u(We.$$.fragment),pn=i(),_t=n("p"),_t.textContent=ws,cn=i(),Y=n("div"),u(Be.$$.fragment),mn=i(),vt=n("p"),vt.innerHTML=ys,fn=i(),Q=n("div"),u(Le.$$.fragment),un=i(),bt=n("p"),bt.innerHTML=Ms,hn=i(),S=n("div"),u(Xe.$$.fragment),gn=i(),xt=n("p"),xt.innerHTML=Vs,_n=i(),Tt=n("p"),Tt.textContent=Zs,vn=i(),wt=n("p"),wt.innerHTML=$s,bn=i(),q=n("div"),u(Ee.$$.fragment),xn=i(),yt=n("p"),yt.textContent=Js,Tn=i(),O=n("div"),u(ze.$$.fragment),wn=i(),Mt=n("p"),Mt.textContent=ks,yn=i(),K=n("div"),u(Ne.$$.fragment),Mn=i(),Vt=n("p"),Vt.textContent=Ss,Zo=i(),B=n("h2"),ee=n("a"),Yt=n("span"),u(Re.$$.fragment),Vn=i(),Zt=n("span"),Zt.textContent=Cs,$o=i(),T=n("div"),u(He.$$.fragment),Zn=i(),$t=n("p"),$t.textContent=Ds,$n=i(),Jt=n("p"),Jt.innerHTML=js,Jn=i(),kt=n("p"),kt.textContent=Ps,kn=i(),St=n("ul"),St.innerHTML=Us,Sn=i(),P=n("div"),u(Ae.$$.fragment),Cn=i(),Ct=n("p"),Ct.textContent=Gs,Dn=i(),u(te.$$.fragment),jn=i(),oe=n("div"),u(Fe.$$.fragment),Pn=i(),Dt=n("p"),Dt.textContent=Is,Un=i(),ne=n("div"),u(Ye.$$.fragment),Gn=i(),jt=n("p"),jt.innerHTML=Ws,In=i(),se=n("div"),u(Qe.$$.fragment),Wn=i(),Pt=n("p"),Pt.innerHTML=Bs,Bn=i(),C=n("div"),u(qe.$$.fragment),Ln=i(),Ut=n("p"),Ut.innerHTML=Ls,Xn=i(),Gt=n("p"),Gt.textContent=Xs,En=i(),It=n("p"),It.innerHTML=Es,zn=i(),ie=n("div"),u(Oe.$$.fragment),Nn=i(),Wt=n("p"),Wt.textContent=zs,Rn=i(),ae=n("div"),u(Ke.$$.fragment),Hn=i(),Bt=n("p"),Bt.textContent=Ns,An=i(),re=n("div"),u(et.$$.fragment),Fn=i(),Lt=n("p"),Lt.textContent=Rs,Jo=i(),L=n("h2"),le=n("a"),Qt=n("span"),u(tt.$$.fragment),Yn=i(),Xt=n("span"),Xt.textContent=Hs,ko=i(),X=n("div"),u(ot.$$.fragment),Qn=i(),Et=n("p"),Et.textContent=As,this.h()},l(e){const r=mi("svelte-1phssyn",document.head);c=s(r,"META",{name:!0,content:!0}),r.forEach(o),J=a(e),h(w.$$.fragment,e),V=a(e),Z=s(e,"H1",{class:!0});var nt=m(Z);f=s(nt,"A",{id:!0,class:!0,href:!0});var qt=m(f);k=s(qt,"SPAN",{});var Ot=m(k);h(ce.$$.fragment,Ot),Ot.forEach(o),qt.forEach(o),Qo=a(nt),rt=s(nt,"SPAN",{"data-svelte-h":!0}),d(rt)!=="svelte-du4m0i"&&(rt.textContent=qn),nt.forEach(o),Kt=a(e),me=s(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-17trsey"&&(me.innerHTML=On),eo=a(e),fe=s(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1cwsb16"&&(fe.textContent=Kn),to=a(e),ue=s(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1ovx0um"&&(ue.innerHTML=es),oo=a(e),he=s(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-9292p9"&&(he.innerHTML=ts),no=a(e),U=s(e,"H2",{class:!0});var st=m(U);E=s(st,"A",{id:!0,class:!0,href:!0});var Fs=m(E);Rt=s(Fs,"SPAN",{});var Ys=m(Rt);h(ge.$$.fragment,Ys),Ys.forEach(o),Fs.forEach(o),qo=a(st),lt=s(st,"SPAN",{"data-svelte-h":!0}),d(lt)!=="svelte-11riiwe"&&(lt.textContent=os),st.forEach(o),so=a(e),G=s(e,"H3",{class:!0});var Co=m(G);z=s(Co,"A",{id:!0,class:!0,href:!0});var Qs=m(z);Ht=s(Qs,"SPAN",{});var qs=m(Ht);h(_e.$$.fragment,qs),qs.forEach(o),Qs.forEach(o),Oo=a(Co),dt=s(Co,"SPAN",{"data-svelte-h":!0}),d(dt)!=="svelte-1jl0vld"&&(dt.innerHTML=ns),Co.forEach(o),io=a(e),ve=s(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-a4ktac"&&(ve.textContent=ss),ao=a(e),h(be.$$.fragment,e),ro=a(e),xe=s(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1gwbshq"&&(xe.textContent=is),lo=a(e),Te=s(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-yoc5w4"&&(Te.textContent=as),po=a(e),h(we.$$.fragment,e),co=a(e),ye=s(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-m9rmsr"&&(ye.innerHTML=rs),mo=a(e),Me=s(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-1yxs7ur"&&(Me.textContent=ls),fo=a(e),h(Ve.$$.fragment,e),uo=a(e),Ze=s(e,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-1pxzje"&&(Ze.textContent=ds),ho=a(e),$e=s(e,"TABLE",{"data-svelte-h":!0}),d($e)!=="svelte-5s26g4"&&($e.innerHTML=ps),go=a(e),I=s(e,"H3",{class:!0});var Do=m(I);N=s(Do,"A",{id:!0,class:!0,href:!0});var Os=m(N);At=s(Os,"SPAN",{});var Ks=m(At);h(Je.$$.fragment,Ks),Ks.forEach(o),Os.forEach(o),Ko=a(Do),pt=s(Do,"SPAN",{"data-svelte-h":!0}),d(pt)!=="svelte-1helarv"&&(pt.innerHTML=cs),Do.forEach(o),_o=a(e),ke=s(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-7532i2"&&(ke.innerHTML=ms),vo=a(e),h(Se.$$.fragment,e),bo=a(e),Ce=s(e,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-4ywac8"&&(Ce.textContent=fs),xo=a(e),h(De.$$.fragment,e),To=a(e),je=s(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1pxzje"&&(je.textContent=us),wo=a(e),Pe=s(e,"TABLE",{"data-svelte-h":!0}),d(Pe)!=="svelte-9iw63g"&&(Pe.innerHTML=hs),yo=a(e),h(R.$$.fragment,e),Mo=a(e),W=s(e,"H2",{class:!0});var jo=m(W);H=s(jo,"A",{id:!0,class:!0,href:!0});var ei=m(H);Ft=s(ei,"SPAN",{});var ti=m(Ft);h(Ue.$$.fragment,ti),ti.forEach(o),ei.forEach(o),en=a(jo),ct=s(jo,"SPAN",{"data-svelte-h":!0}),d(ct)!=="svelte-12hnxt7"&&(ct.textContent=gs),jo.forEach(o),Vo=a(e),x=s(e,"DIV",{class:!0});var y=m(x);h(Ge.$$.fragment,y),tn=a(y),mt=s(y,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-19ipoo4"&&(mt.textContent=_s),on=a(y),ft=s(y,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-s6xyvg"&&(ft.innerHTML=vs),nn=a(y),ut=s(y,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-14s6m4u"&&(ut.textContent=bs),sn=a(y),ht=s(y,"UL",{"data-svelte-h":!0}),d(ht)!=="svelte-33auf8"&&(ht.innerHTML=xs),an=a(y),j=s(y,"DIV",{class:!0});var zt=m(j);h(Ie.$$.fragment,zt),rn=a(zt),gt=s(zt,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-50j04k"&&(gt.textContent=Ts),ln=a(zt),h(A.$$.fragment,zt),zt.forEach(o),dn=a(y),F=s(y,"DIV",{class:!0});var Po=m(F);h(We.$$.fragment,Po),pn=a(Po),_t=s(Po,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-psupw6"&&(_t.textContent=ws),Po.forEach(o),cn=a(y),Y=s(y,"DIV",{class:!0});var Uo=m(Y);h(Be.$$.fragment,Uo),mn=a(Uo),vt=s(Uo,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-1s3c06i"&&(vt.innerHTML=ys),Uo.forEach(o),fn=a(y),Q=s(y,"DIV",{class:!0});var Go=m(Q);h(Le.$$.fragment,Go),un=a(Go),bt=s(Go,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-pkn4ui"&&(bt.innerHTML=Ms),Go.forEach(o),hn=a(y),S=s(y,"DIV",{class:!0});var de=m(S);h(Xe.$$.fragment,de),gn=a(de),xt=s(de,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-1f3tmq1"&&(xt.innerHTML=Vs),_n=a(de),Tt=s(de,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-xjijlp"&&(Tt.textContent=Zs),vn=a(de),wt=s(de,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-hy0nzs"&&(wt.innerHTML=$s),de.forEach(o),bn=a(y),q=s(y,"DIV",{class:!0});var Io=m(q);h(Ee.$$.fragment,Io),xn=a(Io),yt=s(Io,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-14bnrb6"&&(yt.textContent=Js),Io.forEach(o),Tn=a(y),O=s(y,"DIV",{class:!0});var Wo=m(O);h(ze.$$.fragment,Wo),wn=a(Wo),Mt=s(Wo,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-1xwrf7t"&&(Mt.textContent=ks),Wo.forEach(o),yn=a(y),K=s(y,"DIV",{class:!0});var Bo=m(K);h(Ne.$$.fragment,Bo),Mn=a(Bo),Vt=s(Bo,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-16q0ax1"&&(Vt.textContent=Ss),Bo.forEach(o),y.forEach(o),Zo=a(e),B=s(e,"H2",{class:!0});var Lo=m(B);ee=s(Lo,"A",{id:!0,class:!0,href:!0});var oi=m(ee);Yt=s(oi,"SPAN",{});var ni=m(Yt);h(Re.$$.fragment,ni),ni.forEach(o),oi.forEach(o),Vn=a(Lo),Zt=s(Lo,"SPAN",{"data-svelte-h":!0}),d(Zt)!=="svelte-n5s8y5"&&(Zt.textContent=Cs),Lo.forEach(o),$o=a(e),T=s(e,"DIV",{class:!0});var M=m(T);h(He.$$.fragment,M),Zn=a(M),$t=s(M,"P",{"data-svelte-h":!0}),d($t)!=="svelte-1oyadpc"&&($t.textContent=Ds),$n=a(M),Jt=s(M,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-s6xyvg"&&(Jt.innerHTML=js),Jn=a(M),kt=s(M,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-14s6m4u"&&(kt.textContent=Ps),kn=a(M),St=s(M,"UL",{"data-svelte-h":!0}),d(St)!=="svelte-33auf8"&&(St.innerHTML=Us),Sn=a(M),P=s(M,"DIV",{class:!0});var Nt=m(P);h(Ae.$$.fragment,Nt),Cn=a(Nt),Ct=s(Nt,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-50j04k"&&(Ct.textContent=Gs),Dn=a(Nt),h(te.$$.fragment,Nt),Nt.forEach(o),jn=a(M),oe=s(M,"DIV",{class:!0});var Xo=m(oe);h(Fe.$$.fragment,Xo),Pn=a(Xo),Dt=s(Xo,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-psupw6"&&(Dt.textContent=Is),Xo.forEach(o),Un=a(M),ne=s(M,"DIV",{class:!0});var Eo=m(ne);h(Ye.$$.fragment,Eo),Gn=a(Eo),jt=s(Eo,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-1s3c06i"&&(jt.innerHTML=Ws),Eo.forEach(o),In=a(M),se=s(M,"DIV",{class:!0});var zo=m(se);h(Qe.$$.fragment,zo),Wn=a(zo),Pt=s(zo,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-pkn4ui"&&(Pt.innerHTML=Bs),zo.forEach(o),Bn=a(M),C=s(M,"DIV",{class:!0});var pe=m(C);h(qe.$$.fragment,pe),Ln=a(pe),Ut=s(pe,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1f3tmq1"&&(Ut.innerHTML=Ls),Xn=a(pe),Gt=s(pe,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-xjijlp"&&(Gt.textContent=Xs),En=a(pe),It=s(pe,"P",{"data-svelte-h":!0}),d(It)!=="svelte-hy0nzs"&&(It.innerHTML=Es),pe.forEach(o),zn=a(M),ie=s(M,"DIV",{class:!0});var No=m(ie);h(Oe.$$.fragment,No),Nn=a(No),Wt=s(No,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-14bnrb6"&&(Wt.textContent=zs),No.forEach(o),Rn=a(M),ae=s(M,"DIV",{class:!0});var Ro=m(ae);h(Ke.$$.fragment,Ro),Hn=a(Ro),Bt=s(Ro,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-1xwrf7t"&&(Bt.textContent=Ns),Ro.forEach(o),An=a(M),re=s(M,"DIV",{class:!0});var Ho=m(re);h(et.$$.fragment,Ho),Fn=a(Ho),Lt=s(Ho,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-16q0ax1"&&(Lt.textContent=Rs),Ho.forEach(o),M.forEach(o),Jo=a(e),L=s(e,"H2",{class:!0});var Ao=m(L);le=s(Ao,"A",{id:!0,class:!0,href:!0});var si=m(le);Qt=s(si,"SPAN",{});var ii=m(Qt);h(tt.$$.fragment,ii),ii.forEach(o),si.forEach(o),Yn=a(Ao),Xt=s(Ao,"SPAN",{"data-svelte-h":!0}),d(Xt)!=="svelte-1t69icy"&&(Xt.textContent=Hs),Ao.forEach(o),ko=a(e),X=s(e,"DIV",{class:!0});var Fo=m(X);h(ot.$$.fragment,Fo),Qn=a(Fo),Et=s(Fo,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-1uuckb2"&&(Et.textContent=As),Fo.forEach(o),this.h()},h(){p(c,"name","hf:doc:metadata"),p(c,"content",JSON.stringify(vi)),p(f,"id","texttovideo"),p(f,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(f,"href","#texttovideo"),p(Z,"class","relative group"),p(E,"id","usage-example"),p(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(E,"href","#usage-example"),p(U,"class","relative group"),p(z,"id","texttovideoms17b"),p(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(z,"href","#texttovideoms17b"),p(G,"class","relative group"),p(N,"id","cerspensezeroscopev2576w-cerspensezeroscopev2xl"),p(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(N,"href","#cerspensezeroscopev2576w-cerspensezeroscopev2xl"),p(I,"class","relative group"),p(H,"id","diffusers.TextToVideoSDPipeline"),p(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(H,"href","#diffusers.TextToVideoSDPipeline"),p(W,"class","relative group"),p(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ee,"id","diffusers.VideoToVideoSDPipeline"),p(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ee,"href","#diffusers.VideoToVideoSDPipeline"),p(B,"class","relative group"),p(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(le,"id","diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"),p(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(le,"href","#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"),p(L,"class","relative group"),p(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){t(document.head,c),l(e,J,r),g(w,e,r),l(e,V,r),l(e,Z,r),t(Z,f),t(f,k),g(ce,k,null),t(Z,Qo),t(Z,rt),l(e,Kt,r),l(e,me,r),l(e,eo,r),l(e,fe,r),l(e,to,r),l(e,ue,r),l(e,oo,r),l(e,he,r),l(e,no,r),l(e,U,r),t(U,E),t(E,Rt),g(ge,Rt,null),t(U,qo),t(U,lt),l(e,so,r),l(e,G,r),t(G,z),t(z,Ht),g(_e,Ht,null),t(G,Oo),t(G,dt),l(e,io,r),l(e,ve,r),l(e,ao,r),g(be,e,r),l(e,ro,r),l(e,xe,r),l(e,lo,r),l(e,Te,r),l(e,po,r),g(we,e,r),l(e,co,r),l(e,ye,r),l(e,mo,r),l(e,Me,r),l(e,fo,r),g(Ve,e,r),l(e,uo,r),l(e,Ze,r),l(e,ho,r),l(e,$e,r),l(e,go,r),l(e,I,r),t(I,N),t(N,At),g(Je,At,null),t(I,Ko),t(I,pt),l(e,_o,r),l(e,ke,r),l(e,vo,r),g(Se,e,r),l(e,bo,r),l(e,Ce,r),l(e,xo,r),g(De,e,r),l(e,To,r),l(e,je,r),l(e,wo,r),l(e,Pe,r),l(e,yo,r),g(R,e,r),l(e,Mo,r),l(e,W,r),t(W,H),t(H,Ft),g(Ue,Ft,null),t(W,en),t(W,ct),l(e,Vo,r),l(e,x,r),g(Ge,x,null),t(x,tn),t(x,mt),t(x,on),t(x,ft),t(x,nn),t(x,ut),t(x,sn),t(x,ht),t(x,an),t(x,j),g(Ie,j,null),t(j,rn),t(j,gt),t(j,ln),g(A,j,null),t(x,dn),t(x,F),g(We,F,null),t(F,pn),t(F,_t),t(x,cn),t(x,Y),g(Be,Y,null),t(Y,mn),t(Y,vt),t(x,fn),t(x,Q),g(Le,Q,null),t(Q,un),t(Q,bt),t(x,hn),t(x,S),g(Xe,S,null),t(S,gn),t(S,xt),t(S,_n),t(S,Tt),t(S,vn),t(S,wt),t(x,bn),t(x,q),g(Ee,q,null),t(q,xn),t(q,yt),t(x,Tn),t(x,O),g(ze,O,null),t(O,wn),t(O,Mt),t(x,yn),t(x,K),g(Ne,K,null),t(K,Mn),t(K,Vt),l(e,Zo,r),l(e,B,r),t(B,ee),t(ee,Yt),g(Re,Yt,null),t(B,Vn),t(B,Zt),l(e,$o,r),l(e,T,r),g(He,T,null),t(T,Zn),t(T,$t),t(T,$n),t(T,Jt),t(T,Jn),t(T,kt),t(T,kn),t(T,St),t(T,Sn),t(T,P),g(Ae,P,null),t(P,Cn),t(P,Ct),t(P,Dn),g(te,P,null),t(T,jn),t(T,oe),g(Fe,oe,null),t(oe,Pn),t(oe,Dt),t(T,Un),t(T,ne),g(Ye,ne,null),t(ne,Gn),t(ne,jt),t(T,In),t(T,se),g(Qe,se,null),t(se,Wn),t(se,Pt),t(T,Bn),t(T,C),g(qe,C,null),t(C,Ln),t(C,Ut),t(C,Xn),t(C,Gt),t(C,En),t(C,It),t(T,zn),t(T,ie),g(Oe,ie,null),t(ie,Nn),t(ie,Wt),t(T,Rn),t(T,ae),g(Ke,ae,null),t(ae,Hn),t(ae,Bt),t(T,An),t(T,re),g(et,re,null),t(re,Fn),t(re,Lt),l(e,Jo,r),l(e,L,r),t(L,le),t(le,Qt),g(tt,Qt,null),t(L,Yn),t(L,Xt),l(e,ko,r),l(e,X,r),g(ot,X,null),t(X,Qn),t(X,Et),So=!0},p(e,[r]){const nt={};r&2&&(nt.$$scope={dirty:r,ctx:e}),w.$set(nt);const qt={};r&2&&(qt.$$scope={dirty:r,ctx:e}),R.$set(qt);const Ot={};r&2&&(Ot.$$scope={dirty:r,ctx:e}),A.$set(Ot);const st={};r&2&&(st.$$scope={dirty:r,ctx:e}),te.$set(st)},i(e){So||(_(w.$$.fragment,e),_(ce.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(we.$$.fragment,e),_(Ve.$$.fragment,e),_(Je.$$.fragment,e),_(Se.$$.fragment,e),_(De.$$.fragment,e),_(R.$$.fragment,e),_(Ue.$$.fragment,e),_(Ge.$$.fragment,e),_(Ie.$$.fragment,e),_(A.$$.fragment,e),_(We.$$.fragment,e),_(Be.$$.fragment,e),_(Le.$$.fragment,e),_(Xe.$$.fragment,e),_(Ee.$$.fragment,e),_(ze.$$.fragment,e),_(Ne.$$.fragment,e),_(Re.$$.fragment,e),_(He.$$.fragment,e),_(Ae.$$.fragment,e),_(te.$$.fragment,e),_(Fe.$$.fragment,e),_(Ye.$$.fragment,e),_(Qe.$$.fragment,e),_(qe.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(ot.$$.fragment,e),So=!0)},o(e){v(w.$$.fragment,e),v(ce.$$.fragment,e),v(ge.$$.fragment,e),v(_e.$$.fragment,e),v(be.$$.fragment,e),v(we.$$.fragment,e),v(Ve.$$.fragment,e),v(Je.$$.fragment,e),v(Se.$$.fragment,e),v(De.$$.fragment,e),v(R.$$.fragment,e),v(Ue.$$.fragment,e),v(Ge.$$.fragment,e),v(Ie.$$.fragment,e),v(A.$$.fragment,e),v(We.$$.fragment,e),v(Be.$$.fragment,e),v(Le.$$.fragment,e),v(Xe.$$.fragment,e),v(Ee.$$.fragment,e),v(ze.$$.fragment,e),v(Ne.$$.fragment,e),v(Re.$$.fragment,e),v(He.$$.fragment,e),v(Ae.$$.fragment,e),v(te.$$.fragment,e),v(Fe.$$.fragment,e),v(Ye.$$.fragment,e),v(Qe.$$.fragment,e),v(qe.$$.fragment,e),v(Oe.$$.fragment,e),v(Ke.$$.fragment,e),v(et.$$.fragment,e),v(tt.$$.fragment,e),v(ot.$$.fragment,e),So=!1},d(e){e&&(o(J),o(V),o(Z),o(Kt),o(me),o(eo),o(fe),o(to),o(ue),o(oo),o(he),o(no),o(U),o(so),o(G),o(io),o(ve),o(ao),o(ro),o(xe),o(lo),o(Te),o(po),o(co),o(ye),o(mo),o(Me),o(fo),o(uo),o(Ze),o(ho),o($e),o(go),o(I),o(_o),o(ke),o(vo),o(bo),o(Ce),o(xo),o(To),o(je),o(wo),o(Pe),o(yo),o(Mo),o(W),o(Vo),o(x),o(Zo),o(B),o($o),o(T),o(Jo),o(L),o(ko),o(X)),o(c),b(w,e),b(ce),b(ge),b(_e),b(be,e),b(we,e),b(Ve,e),b(Je),b(Se,e),b(De,e),b(R,e),b(Ue),b(Ge),b(Ie),b(A),b(We),b(Be),b(Le),b(Xe),b(Ee),b(ze),b(Ne),b(Re),b(He),b(Ae),b(te),b(Fe),b(Ye),b(Qe),b(qe),b(Oe),b(Ke),b(et),b(tt),b(ot)}}}const vi={local:"texttovideo",sections:[{local:"usage-example",sections:[{local:"texttovideoms17b",title:"`text-to-video-ms-1.7b`"},{local:"cerspensezeroscopev2576w-cerspensezeroscopev2xl",title:"`cerspense/zeroscope_v2_576w` & `cerspense/zeroscope_v2_XL`"}],title:"Usage example"},{local:"diffusers.TextToVideoSDPipeline",title:"TextToVideoSDPipeline"},{local:"diffusers.VideoToVideoSDPipeline",title:"VideoToVideoSDPipeline"},{local:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",title:"TextToVideoSDPipelineOutput"}],title:"Text-to-video"};function bi(D){return di(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $i extends pi{constructor(c){super(),ci(this,c,bi,_i,li,{})}}export{$i as component};
