import{s as On,o as es,n as wn}from"../chunks/scheduler.6062bdaf.js";import{S as ns,i as ss,g as p,s as a,r,A as ts,h as c,f as s,c as l,j as Kn,u as g,x as o,k as Dn,y as as,a as t,v as u,d as h,t as d,w as f}from"../chunks/index.4bca734e.js";import{T as bn}from"../chunks/Tip.b9ac1f03.js";import{C as y}from"../chunks/CodeBlock.fa01571c.js";import{H as M}from"../chunks/Heading.723dceba.js";function ls(b){let i,j='In this section, we will see methods like <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a>, <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>, <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>, <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a> and <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.delete">delete()</a>. All of those methods are aliases added to <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> for convenience. If you prefer, you can also use the generic methods defined in <code>HfApi</code>: <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>, <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>, <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>, <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">update_inference_endpoint()</a>, and <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">delete_inference_endpoint()</a>.';return{c(){i=p("p"),i.innerHTML=j},l(m){i=c(m,"P",{"data-svelte-h":!0}),o(i)!=="svelte-is6783"&&(i.innerHTML=j)},m(m,_){t(m,i,_)},p:wn,d(m){m&&s(i)}}}function is(b){let i,j='An Inference Endpoint that is <em>paused</em> or <em>scaled to zero</em> doesn’t cost anything. The difference between those two is that a <em>paused</em> endpoint needs to be explicitly <em>resumed</em> using <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>. On the contrary, a <em>scaled to zero</em> endpoint will automatically start if an inference call is made to it, with an additional cold start delay. An Inference Endpoint can also be configured to scale to zero automatically after a certain period of inactivity.';return{c(){i=p("p"),i.innerHTML=j},l(m){i=c(m,"P",{"data-svelte-h":!0}),o(i)!=="svelte-112dhhw"&&(i.innerHTML=j)},m(m,_){t(m,i,_)},p:wn,d(m){m&&s(i)}}}function ps(b){let i,j="This is a non-revertible action that will completely remove the endpoint, including its configuration, logs and usage metrics. You cannot restore a deleted Inference Endpoint.";return{c(){i=p("p"),i.textContent=j},l(m){i=c(m,"P",{"data-svelte-h":!0}),o(i)!=="svelte-lscf4f"&&(i.textContent=j)},m(m,_){t(m,i,_)},p:wn,d(m){m&&s(i)}}}function cs(b){let i,j,m,_,I,be,x,$n=`Inference Endpoints provides a secure production solution to easily deploy any <code>transformers</code>, <code>sentence-transformers</code>, and <code>diffusers</code> models on a dedicated and autoscaling infrastructure managed by Hugging Face. An Inference Endpoint is built from a model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a>.
In this guide, we will learn how to programmatically manage Inference Endpoints with <code>huggingface_hub</code>. For more information about the Inference Endpoints product itself, check out its <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">official documentation</a>.`,we,T,Un='This guide assumes <code>huggingface_hub</code> is correctly installed and that your machine is logged in. Check out the <a href="https://huggingface.co/docs/huggingface_hub/quick-start#quickstart" rel="nofollow">Quick Start guide</a> if that’s not the case yet. The minimal version supporting Inference Endpoints API is <code>v0.19.0</code>.',$e,C,Ue,k,In='The first step is to create an Inference Endpoint using <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>:',Ie,J,xe,v,xn='In this example, we created a <code>protected</code> Inference Endpoint named <code>&quot;my-endpoint-name&quot;</code>, to serve <a href="https://huggingface.co/gpt2" rel="nofollow">gpt2</a> for <code>text-generation</code>. A <code>protected</code> Inference Endpoint means your token is required to access the API. We also need to provide additional information to configure the hardware requirements, such as vendor, region, accelerator, instance type, and size. You can check out the list of available resources <a href="https://api.endpoints.huggingface.cloud/#/v2%3A%3Aprovider/list_vendors" rel="nofollow">here</a>. Alternatively, you can create an Inference Endpoint manually using the <a href="https://ui.endpoints.huggingface.co/new" rel="nofollow">Web interface</a> for convenience. Refer to this <a href="https://huggingface.co/docs/inference-endpoints/guides/advanced" rel="nofollow">guide</a> for details on advanced settings and their usage.',Te,E,Tn='The value returned by <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a> is an <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object:',Ce,W,ke,Z,Cn="It’s a dataclass that holds information about the endpoint. You can access important attributes such as <code>name</code>, <code>repository</code>, <code>status</code>, <code>task</code>, <code>created_at</code>, <code>updated_at</code>, etc. If you need it, you can also access the raw response from the server with <code>endpoint.raw</code>.",Je,q,kn='Once your Inference Endpoint is created, you can find it on your <a href="https://ui.endpoints.huggingface.co/" rel="nofollow">personal dashboard</a>.',ve,H,Jn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface_hub/inference_endpoints_created.png"/>',Ee,Q,We,A,vn='By default the Inference Endpoint is built from a docker image provided by Hugging Face. However, it is possible to specify any docker image using the <code>custom_image</code> parameter. A common use case is to run LLMs using the <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">text-generation-inference</a> framework. This can be done like this:',Ze,V,qe,B,En='The value to pass as <code>custom_image</code> is a dictionary containing a url to the docker container and configuration to run it. For more details about it, checkout the <a href="https://api.endpoints.huggingface.cloud/#/v2%3A%3Aendpoint/create_endpoint" rel="nofollow">Swagger documentation</a>.',He,G,Qe,L,Wn='In some cases, you might need to manage Inference Endpoints you created previously. If you know the name, you can fetch it using <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.get_inference_endpoint">get_inference_endpoint()</a>, which returns an <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object. Alternatively, you can use <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.list_inference_endpoints">list_inference_endpoints()</a> to retrieve a list of all Inference Endpoints. Both methods accept an optional <code>namespace</code> parameter. You can set the <code>namespace</code> to any organization you are a part of. Otherwise, it defaults to your username.',Ae,X,Ve,Y,Be,R,Zn='In the rest of this guide, we will assume that we have a <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object called <code>endpoint</code>. You might have noticed that the endpoint has a <code>status</code> attribute of type <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointStatus">InferenceEndpointStatus</a>. When the Inference Endpoint is deployed and accessible, the status should be <code>&quot;running&quot;</code> and the <code>url</code> attribute is set:',Ge,z,Le,N,qn='Before reaching a <code>&quot;running&quot;</code> state, the Inference Endpoint typically goes through an <code>&quot;initializing&quot;</code> or <code>&quot;pending&quot;</code> phase. You can fetch the new state of the endpoint by running <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.fetch">fetch()</a>. Like every other method from <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> that makes a request to the server, the internal attributes of <code>endpoint</code> are mutated in place:',Xe,S,Ye,F,Hn='Instead of fetching the Inference Endpoint status while waiting for it to run, you can directly call <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.wait">wait()</a>. This helper takes as input a <code>timeout</code> and a <code>fetch_every</code> parameter (in seconds) and will block the thread until the Inference Endpoint is deployed. Default values are respectively <code>None</code> (no timeout) and <code>5</code> seconds.',Re,P,ze,K,Qn="If <code>timeout</code> is set and the Inference Endpoint takes too much time to load, a <code>InferenceEndpointTimeoutError</code> timeout error is raised.",Ne,D,Se,O,An="Once your Inference Endpoint is up and running, you can finally run inference on it!",Fe,ee,Vn='<a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> has two properties <code>client</code> and <code>async_client</code> returning respectively an <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> and an <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> objects.',Pe,ne,Ke,se,Bn='If the Inference Endpoint is not running, an <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError">InferenceEndpointError</a> exception is raised:',De,te,Oe,ae,Gn='For more details about how to use the <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>, check out the <a href="../guides/inference">Inference guide</a>.',en,le,nn,ie,Ln="Now that we saw how to create an Inference Endpoint and run inference on it, let’s see how to manage its lifecycle.",sn,w,tn,pe,an,ce,Xn='To reduce costs when your Inference Endpoint is not in use, you can choose to either pause it using <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a> or scale it to zero using <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>.',ln,$,pn,oe,cn,re,on,ge,Yn='In some cases, you might also want to update your Inference Endpoint without creating a new one. You can either update the hosted model or the hardware requirements to run the model. You can do this using <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a>:',rn,ue,gn,he,un,de,Rn="Finally if you won’t use the Inference Endpoint anymore, you can simply call <code>~InferenceEndpoint.delete()</code>.",hn,U,dn,fe,fn,me,zn="A typical use case of Inference Endpoints is to process a batch of jobs at once to limit the infrastructure costs. You can automate this process using what we saw in this guide:",mn,je,jn,ye,Nn="Or if your Inference Endpoint already exists and is paused:",yn,Me,Mn,_e,_n;return I=new M({props:{title:"Inference Endpoints",local:"inference-endpoints",headingTag:"h1"}}),C=new M({props:{title:"Create an Inference Endpoint",local:"create-an-inference-endpoint",headingTag:"h2"}}),J=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybXktZW5kcG9pbnQtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIybWVkaXVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCUyMmM2aSUyMiUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;my-endpoint-name&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;gpt2&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;medium&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;c6i&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),W=new y({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),Q=new M({props:{title:"Using a custom image",local:"using-a-custom-image",headingTag:"h4"}}),V=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyYXdzLXplcGh5ci03Yi1iZXRhLTA0ODYlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvc2l0b3J5JTNEJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmdwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIybWVkaXVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCUyMmc1LjJ4bGFyZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21faW1hZ2UlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZWFsdGhfcm91dGUlMjIlM0ElMjAlMjIlMkZoZWFsdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnYlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfUFJFRklMTF9UT0tFTlMlMjIlM0ElMjAlMjIyMDQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX0xFTkdUSCUyMiUzQSUyMCUyMjEwMjQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0ExLjEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Start an Inference Endpoint running Zephyr-7b-beta on TGI</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;aws-zephyr-7b-beta-0486&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;medium&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;g5.2xlarge&quot;</span>,
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;env&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;2048&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:1.1.0&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)`,wrap:!1}}),G=new M({props:{title:"Get or list existing Inference Endpoints",local:"get-or-list-existing-inference-endpoints",headingTag:"h3"}}),X=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQlMkMlMjBsaXN0X2luZmVyZW5jZV9lbmRwb2ludHMlMEElMEFnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMm15LWVuZHBvaW50LW5hbWUlMjIpJTBBJTBBbGlzdF9pbmZlcmVuY2VfZW5kcG9pbnRzKG5hbWVzcGFjZSUzRCUyMmh1Z2dpbmdmYWNlJTIyKSUwQSUwQWxpc3RfaW5mZXJlbmNlX2VuZHBvaW50cyhuYW1lc3BhY2UlM0QlMjIqJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint, list_inference_endpoints

<span class="hljs-comment"># Get one</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>get_inference_endpoint(<span class="hljs-string">&quot;my-endpoint-name&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># List all endpoints from an organization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;huggingface&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]

<span class="hljs-comment"># List all endpoints from all organizations the user belongs to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;*&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]`,wrap:!1}}),Y=new M({props:{title:"Check deployment status",local:"check-deployment-status",headingTag:"h2"}}),z=new y({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),S=new y({props:{code:"ZW5kcG9pbnQuZmV0Y2goKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.fetch()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),P=new y({props:{code:"ZW5kcG9pbnQlMEElMEFlbmRwb2ludC53YWl0KHRpbWVvdXQlM0QxMCklMEElMEFlbmRwb2ludC53YWl0KCk=",highlighted:`<span class="hljs-comment"># Pending endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Wait 10s =&gt; raises a InferenceEndpointTimeoutError</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait(timeout=<span class="hljs-number">10</span>)
    <span class="hljs-keyword">raise</span> InferenceEndpointTimeoutError(<span class="hljs-string">&quot;Timeout while waiting for Inference Endpoint to be deployed.&quot;</span>)
huggingface_hub._inference_endpoints.InferenceEndpointTimeoutError: Timeout <span class="hljs-keyword">while</span> waiting <span class="hljs-keyword">for</span> Inference Endpoint to be deployed.

<span class="hljs-comment"># Wait more</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),D=new M({props:{title:"Run inference",local:"run-inference",headingTag:"h2"}}),ne=new y({props:{code:"ZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJJJTIwYW0lMjIpJTBBJTBBYXdhaXQlMjBlbmRwb2ludC5hc3luY19jbGllbnQudGV4dF9nZW5lcmF0aW9uKCUyMkklMjBhbSUyMik=",highlighted:`<span class="hljs-comment"># Run text_generation task:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)
<span class="hljs-string">&#x27; not a fan of the idea of a &quot;big-budget&quot; movie. I think it\\&#x27;s a&#x27;</span>

<span class="hljs-comment"># Or in an asyncio context:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> endpoint.async_client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)`,wrap:!1}}),te=new y({props:{code:"ZW5kcG9pbnQuY2xpZW50",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client\nhuggingface_hub._inference_endpoints.InferenceEndpointError: Cannot create a client <span class="hljs-keyword">for</span> this Inference Endpoint <span class="hljs-keyword">as</span> it <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> yet deployed. Please wait <span class="hljs-keyword">for</span> the Inference Endpoint to be deployed using `endpoint.wait()` <span class="hljs-keyword">and</span> <span class="hljs-keyword">try</span> again.',wrap:!1}}),le=new M({props:{title:"Manage lifecycle",local:"manage-lifecycle",headingTag:"h2"}}),w=new bn({props:{$$slots:{default:[ls]},$$scope:{ctx:b}}}),pe=new M({props:{title:"Pause or scale to zero",local:"pause-or-scale-to-zero",headingTag:"h3"}}),$=new bn({props:{$$slots:{default:[is]},$$scope:{ctx:b}}}),oe=new y({props:{code:"ZW5kcG9pbnQucGF1c2UoKSUwQWVuZHBvaW50LnJlc3VtZSgpJTBBZW5kcG9pbnQud2FpdCgpLmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUwQSUwQWVuZHBvaW50LnNjYWxlX3RvX3plcm8oKQ==",highlighted:`<span class="hljs-comment"># Pause and resume endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.resume()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait().client.text_generation(...)
...

<span class="hljs-comment"># Scale to zero</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.scale_to_zero()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;scaledToZero&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)
<span class="hljs-comment"># Endpoint is not &#x27;running&#x27; but still has a URL and will restart on first call.</span>`,wrap:!1}}),re=new M({props:{title:"Update model or hardware requirements",local:"update-model-or-hardware-requirements",headingTag:"h3"}}),ue=new y({props:{code:"ZW5kcG9pbnQudXBkYXRlKHJlcG9zaXRvcnklM0QlMjJncHQyLWxhcmdlJTIyKSUwQSUwQWVuZHBvaW50LnVwZGF0ZShtaW5fcmVwbGljYSUzRDIlMkMlMjBtYXhfcmVwbGljYSUzRDYpJTBBJTBBZW5kcG9pbnQudXBkYXRlKGFjY2VsZXJhdG9yJTNEJTIyY3B1JTIyJTJDJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMmxhcmdlJTIyJTJDJTIwaW5zdGFuY2VfdHlwZSUzRCUyMmM2aSUyMik=",highlighted:`<span class="hljs-comment"># Change target model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(repository=<span class="hljs-string">&quot;gpt2-large&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Update number of replicas</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(min_replica=<span class="hljs-number">2</span>, max_replica=<span class="hljs-number">6</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Update to larger instance</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(accelerator=<span class="hljs-string">&quot;cpu&quot;</span>, instance_size=<span class="hljs-string">&quot;large&quot;</span>, instance_type=<span class="hljs-string">&quot;c6i&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),he=new M({props:{title:"Delete the endpoint",local:"delete-the-endpoint",headingTag:"h3"}}),U=new bn({props:{warning:!0,$$slots:{default:[ps]},$$scope:{ctx:b}}}),fe=new M({props:{title:"An end-to-end example",local:"an-end-to-end-example",headingTag:"h2"}}),je=new y({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50KG5hbWUlM0QlMjJiYXRjaC1lbmRwb2ludCUyMiUyQy4uLikud2FpdCgpJTBBJTBBY2xpZW50JTIwJTNEJTIwZW5kcG9pbnQuY2xpZW50JTBBcmVzdWx0cyUyMCUzRCUyMCU1QmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCUwQSUwQWFzeW5jX2NsaWVudCUyMCUzRCUyMGVuZHBvaW50LmFzeW5jX2NsaWVudCUwQXJlc3VsdHMlMjAlM0QlMjBhc3luY2lvLmdhdGhlcigqJTVCYXN5bmNfY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4pJTIwZm9yJTIwam9iJTIwaW4lMjBqb2JzJTVEKSUwQSUwQWVuZHBvaW50LnBhdXNlKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-comment"># Start endpoint + wait until initialized</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(name=<span class="hljs-string">&quot;batch-endpoint&quot;</span>,...).wait()

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = endpoint.client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = [client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs]

<span class="hljs-comment"># Or with asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># Pause endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),Me=new y({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMmJhdGNoLWVuZHBvaW50JTIyKS5yZXN1bWUoKS53YWl0KCklMEElMEFhc3luY19jbGllbnQlMjAlM0QlMjBlbmRwb2ludC5hc3luY19jbGllbnQlMEFyZXN1bHRzJTIwJTNEJTIwYXN5bmNpby5nYXRoZXIoKiU1QmFzeW5jX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCklMEElMEFlbmRwb2ludC5wYXVzZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint

<span class="hljs-comment"># Get endpoint + wait until initialized</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = get_inference_endpoint(<span class="hljs-string">&quot;batch-endpoint&quot;</span>).resume().wait()

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># Pause endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),{c(){i=p("meta"),j=a(),m=p("p"),_=a(),r(I.$$.fragment),be=a(),x=p("p"),x.innerHTML=$n,we=a(),T=p("p"),T.innerHTML=Un,$e=a(),r(C.$$.fragment),Ue=a(),k=p("p"),k.innerHTML=In,Ie=a(),r(J.$$.fragment),xe=a(),v=p("p"),v.innerHTML=xn,Te=a(),E=p("p"),E.innerHTML=Tn,Ce=a(),r(W.$$.fragment),ke=a(),Z=p("p"),Z.innerHTML=Cn,Je=a(),q=p("p"),q.innerHTML=kn,ve=a(),H=p("p"),H.innerHTML=Jn,Ee=a(),r(Q.$$.fragment),We=a(),A=p("p"),A.innerHTML=vn,Ze=a(),r(V.$$.fragment),qe=a(),B=p("p"),B.innerHTML=En,He=a(),r(G.$$.fragment),Qe=a(),L=p("p"),L.innerHTML=Wn,Ae=a(),r(X.$$.fragment),Ve=a(),r(Y.$$.fragment),Be=a(),R=p("p"),R.innerHTML=Zn,Ge=a(),r(z.$$.fragment),Le=a(),N=p("p"),N.innerHTML=qn,Xe=a(),r(S.$$.fragment),Ye=a(),F=p("p"),F.innerHTML=Hn,Re=a(),r(P.$$.fragment),ze=a(),K=p("p"),K.innerHTML=Qn,Ne=a(),r(D.$$.fragment),Se=a(),O=p("p"),O.textContent=An,Fe=a(),ee=p("p"),ee.innerHTML=Vn,Pe=a(),r(ne.$$.fragment),Ke=a(),se=p("p"),se.innerHTML=Bn,De=a(),r(te.$$.fragment),Oe=a(),ae=p("p"),ae.innerHTML=Gn,en=a(),r(le.$$.fragment),nn=a(),ie=p("p"),ie.textContent=Ln,sn=a(),r(w.$$.fragment),tn=a(),r(pe.$$.fragment),an=a(),ce=p("p"),ce.innerHTML=Xn,ln=a(),r($.$$.fragment),pn=a(),r(oe.$$.fragment),cn=a(),r(re.$$.fragment),on=a(),ge=p("p"),ge.innerHTML=Yn,rn=a(),r(ue.$$.fragment),gn=a(),r(he.$$.fragment),un=a(),de=p("p"),de.innerHTML=Rn,hn=a(),r(U.$$.fragment),dn=a(),r(fe.$$.fragment),fn=a(),me=p("p"),me.textContent=zn,mn=a(),r(je.$$.fragment),jn=a(),ye=p("p"),ye.textContent=Nn,yn=a(),r(Me.$$.fragment),Mn=a(),_e=p("p"),this.h()},l(e){const n=ts("svelte-u9bgzb",document.head);i=c(n,"META",{name:!0,content:!0}),n.forEach(s),j=l(e),m=c(e,"P",{}),Kn(m).forEach(s),_=l(e),g(I.$$.fragment,e),be=l(e),x=c(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-188e6gz"&&(x.innerHTML=$n),we=l(e),T=c(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1ds3okp"&&(T.innerHTML=Un),$e=l(e),g(C.$$.fragment,e),Ue=l(e),k=c(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1dw3yj5"&&(k.innerHTML=In),Ie=l(e),g(J.$$.fragment,e),xe=l(e),v=c(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1stw0yf"&&(v.innerHTML=xn),Te=l(e),E=c(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-3jqc4c"&&(E.innerHTML=Tn),Ce=l(e),g(W.$$.fragment,e),ke=l(e),Z=c(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-dxdc75"&&(Z.innerHTML=Cn),Je=l(e),q=c(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1tjw294"&&(q.innerHTML=kn),ve=l(e),H=c(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1tajtyl"&&(H.innerHTML=Jn),Ee=l(e),g(Q.$$.fragment,e),We=l(e),A=c(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-j6tvxe"&&(A.innerHTML=vn),Ze=l(e),g(V.$$.fragment,e),qe=l(e),B=c(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-33b9op"&&(B.innerHTML=En),He=l(e),g(G.$$.fragment,e),Qe=l(e),L=c(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1p057nu"&&(L.innerHTML=Wn),Ae=l(e),g(X.$$.fragment,e),Ve=l(e),g(Y.$$.fragment,e),Be=l(e),R=c(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-xk3lyu"&&(R.innerHTML=Zn),Ge=l(e),g(z.$$.fragment,e),Le=l(e),N=c(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1se2jih"&&(N.innerHTML=qn),Xe=l(e),g(S.$$.fragment,e),Ye=l(e),F=c(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-k4iz90"&&(F.innerHTML=Hn),Re=l(e),g(P.$$.fragment,e),ze=l(e),K=c(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1g2lxsg"&&(K.innerHTML=Qn),Ne=l(e),g(D.$$.fragment,e),Se=l(e),O=c(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-un9pgy"&&(O.textContent=An),Fe=l(e),ee=c(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-7weqj1"&&(ee.innerHTML=Vn),Pe=l(e),g(ne.$$.fragment,e),Ke=l(e),se=c(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-lkldnu"&&(se.innerHTML=Bn),De=l(e),g(te.$$.fragment,e),Oe=l(e),ae=c(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1rt1kk8"&&(ae.innerHTML=Gn),en=l(e),g(le.$$.fragment,e),nn=l(e),ie=c(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-16mqpnz"&&(ie.textContent=Ln),sn=l(e),g(w.$$.fragment,e),tn=l(e),g(pe.$$.fragment,e),an=l(e),ce=c(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-olx7n5"&&(ce.innerHTML=Xn),ln=l(e),g($.$$.fragment,e),pn=l(e),g(oe.$$.fragment,e),cn=l(e),g(re.$$.fragment,e),on=l(e),ge=c(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-10wwyhz"&&(ge.innerHTML=Yn),rn=l(e),g(ue.$$.fragment,e),gn=l(e),g(he.$$.fragment,e),un=l(e),de=c(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1j2n6pp"&&(de.innerHTML=Rn),hn=l(e),g(U.$$.fragment,e),dn=l(e),g(fe.$$.fragment,e),fn=l(e),me=c(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-r11tzs"&&(me.textContent=zn),mn=l(e),g(je.$$.fragment,e),jn=l(e),ye=c(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-u5cd5i"&&(ye.textContent=Nn),yn=l(e),g(Me.$$.fragment,e),Mn=l(e),_e=c(e,"P",{}),Kn(_e).forEach(s),this.h()},h(){Dn(i,"name","hf:doc:metadata"),Dn(i,"content",os)},m(e,n){as(document.head,i),t(e,j,n),t(e,m,n),t(e,_,n),u(I,e,n),t(e,be,n),t(e,x,n),t(e,we,n),t(e,T,n),t(e,$e,n),u(C,e,n),t(e,Ue,n),t(e,k,n),t(e,Ie,n),u(J,e,n),t(e,xe,n),t(e,v,n),t(e,Te,n),t(e,E,n),t(e,Ce,n),u(W,e,n),t(e,ke,n),t(e,Z,n),t(e,Je,n),t(e,q,n),t(e,ve,n),t(e,H,n),t(e,Ee,n),u(Q,e,n),t(e,We,n),t(e,A,n),t(e,Ze,n),u(V,e,n),t(e,qe,n),t(e,B,n),t(e,He,n),u(G,e,n),t(e,Qe,n),t(e,L,n),t(e,Ae,n),u(X,e,n),t(e,Ve,n),u(Y,e,n),t(e,Be,n),t(e,R,n),t(e,Ge,n),u(z,e,n),t(e,Le,n),t(e,N,n),t(e,Xe,n),u(S,e,n),t(e,Ye,n),t(e,F,n),t(e,Re,n),u(P,e,n),t(e,ze,n),t(e,K,n),t(e,Ne,n),u(D,e,n),t(e,Se,n),t(e,O,n),t(e,Fe,n),t(e,ee,n),t(e,Pe,n),u(ne,e,n),t(e,Ke,n),t(e,se,n),t(e,De,n),u(te,e,n),t(e,Oe,n),t(e,ae,n),t(e,en,n),u(le,e,n),t(e,nn,n),t(e,ie,n),t(e,sn,n),u(w,e,n),t(e,tn,n),u(pe,e,n),t(e,an,n),t(e,ce,n),t(e,ln,n),u($,e,n),t(e,pn,n),u(oe,e,n),t(e,cn,n),u(re,e,n),t(e,on,n),t(e,ge,n),t(e,rn,n),u(ue,e,n),t(e,gn,n),u(he,e,n),t(e,un,n),t(e,de,n),t(e,hn,n),u(U,e,n),t(e,dn,n),u(fe,e,n),t(e,fn,n),t(e,me,n),t(e,mn,n),u(je,e,n),t(e,jn,n),t(e,ye,n),t(e,yn,n),u(Me,e,n),t(e,Mn,n),t(e,_e,n),_n=!0},p(e,[n]){const Sn={};n&2&&(Sn.$$scope={dirty:n,ctx:e}),w.$set(Sn);const Fn={};n&2&&(Fn.$$scope={dirty:n,ctx:e}),$.$set(Fn);const Pn={};n&2&&(Pn.$$scope={dirty:n,ctx:e}),U.$set(Pn)},i(e){_n||(h(I.$$.fragment,e),h(C.$$.fragment,e),h(J.$$.fragment,e),h(W.$$.fragment,e),h(Q.$$.fragment,e),h(V.$$.fragment,e),h(G.$$.fragment,e),h(X.$$.fragment,e),h(Y.$$.fragment,e),h(z.$$.fragment,e),h(S.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(ne.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(w.$$.fragment,e),h(pe.$$.fragment,e),h($.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(U.$$.fragment,e),h(fe.$$.fragment,e),h(je.$$.fragment,e),h(Me.$$.fragment,e),_n=!0)},o(e){d(I.$$.fragment,e),d(C.$$.fragment,e),d(J.$$.fragment,e),d(W.$$.fragment,e),d(Q.$$.fragment,e),d(V.$$.fragment,e),d(G.$$.fragment,e),d(X.$$.fragment,e),d(Y.$$.fragment,e),d(z.$$.fragment,e),d(S.$$.fragment,e),d(P.$$.fragment,e),d(D.$$.fragment,e),d(ne.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(w.$$.fragment,e),d(pe.$$.fragment,e),d($.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(ue.$$.fragment,e),d(he.$$.fragment,e),d(U.$$.fragment,e),d(fe.$$.fragment,e),d(je.$$.fragment,e),d(Me.$$.fragment,e),_n=!1},d(e){e&&(s(j),s(m),s(_),s(be),s(x),s(we),s(T),s($e),s(Ue),s(k),s(Ie),s(xe),s(v),s(Te),s(E),s(Ce),s(ke),s(Z),s(Je),s(q),s(ve),s(H),s(Ee),s(We),s(A),s(Ze),s(qe),s(B),s(He),s(Qe),s(L),s(Ae),s(Ve),s(Be),s(R),s(Ge),s(Le),s(N),s(Xe),s(Ye),s(F),s(Re),s(ze),s(K),s(Ne),s(Se),s(O),s(Fe),s(ee),s(Pe),s(Ke),s(se),s(De),s(Oe),s(ae),s(en),s(nn),s(ie),s(sn),s(tn),s(an),s(ce),s(ln),s(pn),s(cn),s(on),s(ge),s(rn),s(gn),s(un),s(de),s(hn),s(dn),s(fn),s(me),s(mn),s(jn),s(ye),s(yn),s(Mn),s(_e)),s(i),f(I,e),f(C,e),f(J,e),f(W,e),f(Q,e),f(V,e),f(G,e),f(X,e),f(Y,e),f(z,e),f(S,e),f(P,e),f(D,e),f(ne,e),f(te,e),f(le,e),f(w,e),f(pe,e),f($,e),f(oe,e),f(re,e),f(ue,e),f(he,e),f(U,e),f(fe,e),f(je,e),f(Me,e)}}}const os='{"title":"Inference Endpoints","local":"inference-endpoints","sections":[{"title":"Create an Inference Endpoint","local":"create-an-inference-endpoint","sections":[{"title":"Using a custom image","local":"using-a-custom-image","sections":[],"depth":4},{"title":"Get or list existing Inference Endpoints","local":"get-or-list-existing-inference-endpoints","sections":[],"depth":3}],"depth":2},{"title":"Check deployment status","local":"check-deployment-status","sections":[],"depth":2},{"title":"Run inference","local":"run-inference","sections":[],"depth":2},{"title":"Manage lifecycle","local":"manage-lifecycle","sections":[{"title":"Pause or scale to zero","local":"pause-or-scale-to-zero","sections":[],"depth":3},{"title":"Update model or hardware requirements","local":"update-model-or-hardware-requirements","sections":[],"depth":3},{"title":"Delete the endpoint","local":"delete-the-endpoint","sections":[],"depth":3}],"depth":2},{"title":"An end-to-end example","local":"an-end-to-end-example","sections":[],"depth":2}],"depth":1}';function rs(b){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ms extends ns{constructor(i){super(),ss(this,i,rs,cs,On,{})}}export{ms as component};
