import{s as qt,n as Vt,o as Ft}from"../chunks/scheduler.389d799c.js";import{S as Pt,i as Dt,g as i,s as n,r as d,A as Kt,h as o,f as l,c as a,j as Xt,u as r,x as p,k as Lt,y as Ot,a as s,v as y,d as h,t as c,w}from"../chunks/index.8f81d18f.js";import{C as M}from"../chunks/CodeBlock.3845caa1.js";import{H as u}from"../chunks/Heading.41733039.js";function el(ct){let T,Te,ce,Me,J,ue,m,wt='Hugging Face Endpoints supports all of the Transformers and Sentence-Transformers tasks and can support custom tasks, including custom pre- &amp; post-processing. The customization can be done through a <a href="https://huggingface.co/philschmid/distilbert-onnx-banking77/blob/main/handler.py" rel="nofollow">handler.py</a> file in your model repository on the Hugging Face Hub.',Je,f,Tt='The <a href="https://huggingface.co/philschmid/distilbert-onnx-banking77/blob/main/handler.py" rel="nofollow">handler.py</a> needs to implement the <a href="https://huggingface.co/philschmid/distilbert-onnx-banking77/blob/main/handler.py" rel="nofollow">EndpointHandler</a> class with a <code>__init__</code> and a <code>__call__</code> method.',me,I,Mt='If you want to use custom dependencies, e.g. <a href="https://raw.githubusercontent.com/huggingface/optimum" rel="nofollow">optimum</a>, the dependencies must be listed in a <code>requirements.txt</code> as described above in “add custom dependencies.”',fe,U,Ie,j,ut='There are already several public examples on the <a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">Hugging Face Hub</a> where you can take insipiration or directly use them. The repositories are tagged with <code>endpoints-template</code> and can be found under this <a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">link</a>.',Ue,b,Jt="Included examples are for:",je,C,mt='<li><a href="https://huggingface.co/philschmid/distilbert-onnx-banking77" rel="nofollow">Optimum and ONNX Runtime</a></li> <li><a href="https://huggingface.co/florentgbelidji/blip_image_embeddings" rel="nofollow">Image Embeddings with BLIP</a></li> <li><a href="https://huggingface.co/philschmid/trocr-base-printed" rel="nofollow">TrOCR for OCR Detection</a></li> <li><a href="https://huggingface.co/philschmid/all-MiniLM-L6-v2-optimum-embeddings" rel="nofollow">Optimized Sentence Transformers with Optimum</a></li> <li><a href="https://huggingface.co/philschmid/pyannote-speaker-diarization-endpoint" rel="nofollow">Pyannote Speaker diarization</a></li> <li><a href="https://huggingface.co/philschmid/layoutlm-funsd" rel="nofollow">LayoutLM</a></li> <li><a href="https://huggingface.co/philschmid/flair-ner-english-ontonotes-large" rel="nofollow">Flair NER</a></li> <li><a href="https://huggingface.co/philschmid/gpt-j-6B-fp16-sharded" rel="nofollow">GPT-J 6B Single GPU</a></li> <li><a href="https://huggingface.co/philschmid/donut-base-finetuned-cord-v2" rel="nofollow">Donut Document understanding</a></li> <li><a href="https://huggingface.co/philschmid/setfit-ag-news-endpoint" rel="nofollow">SetFit classifier</a></li>',be,g,Ce,B,ft='Before creating a Custom Handler, you need a Hugging Face Model repository with your model weights and an Access Token with <em>WRITE</em> access to the repository. To find, create and manage Access Tokens, click <a href="https://huggingface.co/settings/tokens" rel="nofollow">here</a>.',ge,G,It='If you want to write a Custom Handler for an existing model from the community, you can use the <a href="https://huggingface.co/spaces/osanseviero/repo_duplicator" rel="nofollow">repo_duplicator</a> to create a repository fork.',Be,v,Ut='The code can also be found in this <a href="https://colab.research.google.com/drive/1hANJeRa1PK1gZaUorobnQGu4bFj4_4Rf?usp=sharing" rel="nofollow">Notebook</a>.',Ge,H,jt='You can also search for already existing Custom Handlers here: <a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">https://huggingface.co/models?other=endpoints-template</a>',ve,$,He,_,bt=`The easiest way to develop our custom handler is to set up a local development environment, to implement, test, and iterate there, and then deploy it as an Inference Endpoint. The first step is to install all required development dependencies.
<em>needed to create the custom handler, not needed for inference</em>`,$e,k,_e,x,Ct="After we have installed our libraries we will clone our repository to our development environment.",ke,Z,gt='We will use <a href="https://huggingface.co/philschmid/distilbert-base-uncased-emotion" rel="nofollow">philschmid/distilbert-base-uncased-emotion</a> during the tutorial.',xe,E,Ze,W,Bt="To be able to push our CP later you need to login into our HF account. This can be done by using the <code>huggingface-cli</code>.",Ee,R,Gt="<em>Note: Make sure to configure git config as well.</em>",We,N,Re,S,Ne,A,vt="After we have set up our environment, we can start creating your custom handler. The custom handler is a Python class (<code>EndpointHandler</code>) inside a <code>handler.py</code> file in our repository. The <code>EndpointHandler</code> needs to implement an <code>__init__</code> and a <code>__call__</code> method.",Se,Y,Ht="<li>The <code>__init__</code> method will be called when starting the Endpoint and will receive 1 argument, a string with the path to your model weights. This allows you to load your model correctly.</li> <li>The <code>__call__</code> method will be called on every request and receive a dictionary with your request body as a python dictionary. It will always contain the <code>inputs</code> key.</li>",Ae,z,$t="The first step is to create our <code>handler.py</code> in the local clone of our repository.",Ye,Q,ze,X,_t="In there, you define your <code>EndpointHandler</code> class with the <code>__init__</code> and <code>__call__ </code>method.",Qe,L,Xe,q,Le,V,kt='Now, you can add all of the custom logic you want to use during initialization or inference to your CP. You can already find multiple <a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">Custom Handler on the Hub</a> if you need some inspiration. In our example, we will add a custom condition based on additional payload information.',qe,F,xt="<em>The model we are using in the tutorial is fine-tuned to detect emotions. We will add an additional payload field for the date, and will use an external package to check if it is a holiday, to add a condition so that when the input date is a holiday, the model returns “happy” - since everyone is happy when there are holidays </em>🌴🎉😆",Ve,P,Zt='First, we need to create a new <code>requirements.txt</code> and add our <a href="https://pypi.org/project/holidays/" rel="nofollow">holiday detection package</a> and make sure we have it installed in our development environment as well.',Fe,D,Pe,K,Et="Next, we have to adjust our <code>handler.py</code> and <code>EndpointHandler</code> to match our condition.",De,O,Ke,ee,Oe,te,Wt="To test our EndpointHandler, we can simplify import, initialize and test it. Therefore we only need to prepare a sample payload.",et,le,tt,se,Rt="It works!!!! 🎉",lt,ne,Nt="<em>Note: If you are using a notebook you might have to restart your kernel when you make changes to the handler.py since it is not automatically re-imported.</em>",st,ae,nt,ie,St="After you have successfully tested your handler locally, you can push it to your repository by simply using basic git commands.",at,oe,it,pe,At='Now, you should see your <code>handler.py</code> and <code>requirements.txt</code> in your repository in the <a href="https://huggingface.co/philschmid/distilbert-base-uncased-emotion/tree/main" rel="nofollow">“Files and version”</a> tab.',ot,de,pt,re,Yt="The last step is to deploy your Custom Handler as an Inference Endpoint. You can deploy your Custom Handler like you would a regular Inference Endpoint. Add your repository, select your cloud and region, your instance and security setting, and deploy.",dt,ye,zt="When creating your Endpoint, the Inference Endpoint Service will check for an available and valid <code>handler.py</code>, and will use it for serving requests no matter which “Task” you select.",rt,he,Qt='<em>Note: In your <a href="https://ui.endpoints.huggingface.co/" rel="nofollow">Inference Endpoints dashboard</a>, the Task for this Endpoint should now be set to Custom</em>',yt,we,ht;return J=new u({props:{title:"Create custom Inference Handler",local:"create-custom-inference-handler",headingTag:"h1"}}),U=new u({props:{title:"Custom Handler Examples",local:"custom-handler-examples",headingTag:"h2"}}),g=new u({props:{title:"Tutorial",local:"tutorial",headingTag:"h2"}}),$=new u({props:{title:"1. Set up Development Environment",local:"1-set-up-development-environment",headingTag:"h3"}}),k=new M({props:{code:"JTIzJTIwaW5zdGFsbCUyMGdpdC1sZnMlMjB0byUyMGludGVyYWN0JTIwd2l0aCUyMHRoZSUyMHJlcG9zaXRvcnklMEFzdWRvJTIwYXB0LWdldCUyMHVwZGF0ZSUwQXN1ZG8lMjBhcHQtZ2V0JTIwaW5zdGFsbCUyMGdpdC1sZnMlMEElMjMlMjBpbnN0YWxsJTIwdHJhbnNmb3JtZXJzJTIwKG5vdCUyMG5lZWRlZCUyMHNpbmNlJTIwaXQlMjBpcyUyMGluc3RhbGxlZCUyMGJ5JTIwZGVmYXVsdCUyMGluJTIwdGhlJTIwY29udGFpbmVyKSUwQXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlNUJza2xlYXJuJTJDc2VudGVuY2VwaWVjZSUyQ2F1ZGlvJTJDdmlzaW9uJTVE",highlighted:`<span class="hljs-comment"># install git-lfs to interact with the repository</span>
sudo apt-<span class="hljs-built_in">get</span> update
sudo apt-<span class="hljs-built_in">get</span> install git-lfs
<span class="hljs-comment"># install transformers (not needed since it is installed by default in the container)</span>
pip install transformers[sklearn,sentencepiece,audio,vision]`,wrap:!1}}),E=new M({props:{code:"Z2l0JTIwbGZzJTIwaW5zdGFsbCUwQWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnBoaWxzY2htaWQlMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1lbW90aW9u",highlighted:`git lfs install
git clone https:<span class="hljs-regexp">//</span>huggingface.co<span class="hljs-regexp">/philschmid/</span>distilbert-base-uncased-emotion`,wrap:!1}}),N=new M({props:{code:"JTIzJTIwc2V0dXAlMjBjbGklMjB3aXRoJTIwdG9rZW4lMEFodWdnaW5nZmFjZS1jbGklMjBsb2dpbiUwQWdpdCUyMGNvbmZpZyUyMC0tZ2xvYmFsJTIwY3JlZGVudGlhbC5oZWxwZXIlMjBzdG9yZQ==",highlighted:`# setup <span class="hljs-keyword">cli</span> with <span class="hljs-keyword">token</span>
huggingface-<span class="hljs-keyword">cli</span> login
git config --<span class="hljs-keyword">global</span> credential.helper store`,wrap:!1}}),S=new u({props:{title:"2. Create EndpointHandler (CP)",local:"2-create-endpointhandler-cp",headingTag:"h3"}}),Q=new M({props:{code:"IWNkJTIwZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZW1vdGlvbiUyMCUyNiUyNiUyMHRvdWNoJTIwaGFuZGxlci5weQ==",highlighted:'!<span class="hljs-built_in">cd</span> distilbert-base-uncased-emotion &amp;&amp; <span class="hljs-built_in">touch</span> handler.py',wrap:!1}}),L=new M({props:{code:"ZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMERpY3QlMkMlMjBMaXN0JTJDJTIwQW55JTBBJTBBY2xhc3MlMjBFbmRwb2ludEhhbmRsZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBwYXRoJTNEJTIyJTIyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByZWxvYWQlMjBhbGwlMjB0aGUlMjBlbGVtZW50cyUyMHlvdSUyMGFyZSUyMGdvaW5nJTIwdG8lMjBuZWVkJTIwYXQlMjBpbmZlcmVuY2UuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwcHNldWRvJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2VsZi5tb2RlbCUzRCUyMGxvYWRfbW9kZWwocGF0aCklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwZGF0YSUzQSUyMERpY3QlNUJzdHIlMkMlMjBBbnklNUQpJTIwLSUzRSUyMExpc3QlNUJEaWN0JTVCc3RyJTJDJTIwQW55JTVEJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YSUyMGFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAoJTNBb2JqJTNBJTIwJTYwc3RyJTYwJTIwJTdDJTIwJTYwUElMLkltYWdlJTYwJTIwJTdDJTIwJTYwbnAuYXJyYXklNjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa3dhcmdzJTBBJTIwJTIwJTIwJTIwJTIwJTIwUmV0dXJuJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQSUyMCUzQW9iaiUzQSU2MGxpc3QlNjAlMjAlN0MlMjAlNjBkaWN0JTYwJTNBJTIwd2lsbCUyMGJlJTIwc2VyaWFsaXplZCUyMGFuZCUyMHJldHVybmVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwcHNldWRvJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2VsZi5tb2RlbChpbnB1dCk=",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Any</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">EndpointHandler</span>():
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, path=<span class="hljs-string">&quot;&quot;</span></span>):
        <span class="hljs-comment"># Preload all the elements you are going to need at inference.</span>
        <span class="hljs-comment"># pseudo:</span>
        <span class="hljs-comment"># self.model= load_model(path)</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, data: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]:
        <span class="hljs-string">&quot;&quot;&quot;
       data args:
            inputs (:obj: \`str\` | \`PIL.Image\` | \`np.array\`)
            kwargs
      Return:
            A :obj:\`list\` | \`dict\`: will be serialized and returned
        &quot;&quot;&quot;</span>

        <span class="hljs-comment"># pseudo</span>
        <span class="hljs-comment"># self.model(input)</span>`,wrap:!1}}),q=new u({props:{title:"3. Customize EndpointHandler",local:"3-customize-endpointhandler",headingTag:"h3"}}),D=new M({props:{code:"IWVjaG8lMjAlMjJob2xpZGF5cyUyMiUyMCUzRSUzRSUyMHJlcXVpcmVtZW50cy50eHQlMEEhcGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`!echo <span class="hljs-string">&quot;holidays&quot;</span> &gt;&gt; requirements.txt
!pip install -r requirements.txt`,wrap:!1}}),O=new M({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Any</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> holidays

<span class="hljs-keyword">class</span> <span class="hljs-title class_">EndpointHandler</span>():
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, path=<span class="hljs-string">&quot;&quot;</span></span>):
        self.pipeline = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>,model=path)
        self.holidays = holidays.US()

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, data: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]:
        <span class="hljs-string">&quot;&quot;&quot;
       data args:
            inputs (:obj: \`str\`)
            date (:obj: \`str\`)
      Return:
            A :obj:\`list\` | \`dict\`: will be serialized and returned
        &quot;&quot;&quot;</span>
        <span class="hljs-comment"># get inputs</span>
        inputs = data.pop(<span class="hljs-string">&quot;inputs&quot;</span>,data)
        date = data.pop(<span class="hljs-string">&quot;date&quot;</span>, <span class="hljs-literal">None</span>)

        <span class="hljs-comment"># check if date exists and if it is a holiday</span>
        <span class="hljs-keyword">if</span> date <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> date <span class="hljs-keyword">in</span> self.holidays:
          <span class="hljs-keyword">return</span> [{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;happy&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">1</span>}]


        <span class="hljs-comment"># run normal prediction</span>
        prediction = self.pipeline(inputs)
        <span class="hljs-keyword">return</span> prediction`,wrap:!1}}),ee=new u({props:{title:"4. Test EndpointHandler",local:"4-test-endpointhandler",headingTag:"h3"}}),le=new M({props:{code:"ZnJvbSUyMGhhbmRsZXIlMjBpbXBvcnQlMjBFbmRwb2ludEhhbmRsZXIlMEElMEElMjMlMjBpbml0JTIwaGFuZGxlciUwQW15X2hhbmRsZXIlMjAlM0QlMjBFbmRwb2ludEhhbmRsZXIocGF0aCUzRCUyMi4lMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMHNhbXBsZSUyMHBheWxvYWQlMEFub25faG9saWRheV9wYXlsb2FkJTIwJTNEJTIwJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIySSUyMGFtJTIwcXVpdGUlMjBleGNpdGVkJTIwaG93JTIwdGhpcyUyMHdpbGwlMjB0dXJuJTIwb3V0JTIyJTJDJTIwJTIyZGF0ZSUyMiUzQSUyMCUyMjIwMjItMDgtMDglMjIlN0QlMEFob2xpZGF5X3BheWxvYWQlMjAlM0QlMjAlN0IlMjJpbnB1dHMlMjIlM0ElMjAlMjJUb2RheSUyMGlzJTIwYSUyMHRob3VnaCUyMGRheSUyMiUyQyUyMCUyMmRhdGUlMjIlM0ElMjAlMjIyMDIyLTA3LTA0JTIyJTdEJTBBJTBBJTIzJTIwdGVzdCUyMHRoZSUyMGhhbmRsZXIlMEFub25faG9saWRheV9wcmVkJTNEbXlfaGFuZGxlcihub25faG9saWRheV9wYXlsb2FkKSUwQWhvbGlkYXlfcGF5bG9hZCUzRG15X2hhbmRsZXIoaG9saWRheV9wYXlsb2FkKSUwQSUwQSUyMyUyMHNob3clMjByZXN1bHRzJTBBcHJpbnQoJTIybm9uX2hvbGlkYXlfcHJlZCUyMiUyQyUyMG5vbl9ob2xpZGF5X3ByZWQpJTBBcHJpbnQoJTIyaG9saWRheV9wYXlsb2FkJTIyJTJDJTIwaG9saWRheV9wYXlsb2FkKSUwQSUwQSUyMyUyMG5vbl9ob2xpZGF5X3ByZWQlMjAlNUIlN0InbGFiZWwnJTNBJTIwJ2pveSclMkMlMjAnc2NvcmUnJTNBJTIwMC45OTg1OTQyMjQ0NTI5NzI0JTdEJTVEJTBBJTIzJTIwaG9saWRheV9wYXlsb2FkJTIwJTVCJTdCJ2xhYmVsJyUzQSUyMCdoYXBweSclMkMlMjAnc2NvcmUnJTNBJTIwMSU3RCU1RA==",highlighted:`<span class="hljs-keyword">from</span> handler <span class="hljs-keyword">import</span> EndpointHandler

<span class="hljs-comment"># init handler</span>
my_handler = EndpointHandler(path=<span class="hljs-string">&quot;.&quot;</span>)

<span class="hljs-comment"># prepare sample payload</span>
non_holiday_payload = {<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;I am quite excited how this will turn out&quot;</span>, <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2022-08-08&quot;</span>}
holiday_payload = {<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Today is a though day&quot;</span>, <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2022-07-04&quot;</span>}

<span class="hljs-comment"># test the handler</span>
non_holiday_pred=my_handler(non_holiday_payload)
holiday_payload=my_handler(holiday_payload)

<span class="hljs-comment"># show results</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;non_holiday_pred&quot;</span>, non_holiday_pred)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;holiday_payload&quot;</span>, holiday_payload)

<span class="hljs-comment"># non_holiday_pred [{&#x27;label&#x27;: &#x27;joy&#x27;, &#x27;score&#x27;: 0.9985942244529724}]</span>
<span class="hljs-comment"># holiday_payload [{&#x27;label&#x27;: &#x27;happy&#x27;, &#x27;score&#x27;: 1}]</span>`,wrap:!1}}),ae=new u({props:{title:"5. Push the Custom Handler to your repository",local:"5-push-the-custom-handler-to-your-repository",headingTag:"h3"}}),oe=new M({props:{code:"JTIzJTIwYWRkJTIwYWxsJTIwb3VyJTIwbmV3JTIwZmlsZXMlMEEhZ2l0JTIwYWRkJTIwKiUwQSUyMyUyMGNvbW1pdCUyMG91ciUyMGZpbGVzJTBBIWdpdCUyMGNvbW1pdCUyMC1tJTIwJTIyYWRkJTIwY3VzdG9tJTIwaGFuZGxlciUyMiUwQSUyMyUyMHB1c2glMjB0aGUlMjBmaWxlcyUyMHRvJTIwdGhlJTIwaHViJTBBIWdpdCUyMHB1c2g=",highlighted:`# <span class="hljs-built_in">add</span> <span class="hljs-keyword">all</span> our <span class="hljs-keyword">new</span> <span class="hljs-keyword">files</span>
!git <span class="hljs-built_in">add</span> *
# commit our <span class="hljs-keyword">files</span>
!git commit -<span class="hljs-keyword">m</span> <span class="hljs-string">&quot;add custom handler&quot;</span>
# push the <span class="hljs-keyword">files</span> <span class="hljs-keyword">to</span> the hub
!git push`,wrap:!1}}),de=new u({props:{title:"6. Deploy your Custom Handler as an Inference Endpoint",local:"6-deploy-your-custom-handler-as-an-inference-endpoint",headingTag:"h3"}}),{c(){T=i("meta"),Te=n(),ce=i("p"),Me=n(),d(J.$$.fragment),ue=n(),m=i("p"),m.innerHTML=wt,Je=n(),f=i("p"),f.innerHTML=Tt,me=n(),I=i("p"),I.innerHTML=Mt,fe=n(),d(U.$$.fragment),Ie=n(),j=i("p"),j.innerHTML=ut,Ue=n(),b=i("p"),b.textContent=Jt,je=n(),C=i("ul"),C.innerHTML=mt,be=n(),d(g.$$.fragment),Ce=n(),B=i("p"),B.innerHTML=ft,ge=n(),G=i("p"),G.innerHTML=It,Be=n(),v=i("p"),v.innerHTML=Ut,Ge=n(),H=i("p"),H.innerHTML=jt,ve=n(),d($.$$.fragment),He=n(),_=i("p"),_.innerHTML=bt,$e=n(),d(k.$$.fragment),_e=n(),x=i("p"),x.textContent=Ct,ke=n(),Z=i("p"),Z.innerHTML=gt,xe=n(),d(E.$$.fragment),Ze=n(),W=i("p"),W.innerHTML=Bt,Ee=n(),R=i("p"),R.innerHTML=Gt,We=n(),d(N.$$.fragment),Re=n(),d(S.$$.fragment),Ne=n(),A=i("p"),A.innerHTML=vt,Se=n(),Y=i("ul"),Y.innerHTML=Ht,Ae=n(),z=i("p"),z.innerHTML=$t,Ye=n(),d(Q.$$.fragment),ze=n(),X=i("p"),X.innerHTML=_t,Qe=n(),d(L.$$.fragment),Xe=n(),d(q.$$.fragment),Le=n(),V=i("p"),V.innerHTML=kt,qe=n(),F=i("p"),F.innerHTML=xt,Ve=n(),P=i("p"),P.innerHTML=Zt,Fe=n(),d(D.$$.fragment),Pe=n(),K=i("p"),K.innerHTML=Et,De=n(),d(O.$$.fragment),Ke=n(),d(ee.$$.fragment),Oe=n(),te=i("p"),te.textContent=Wt,et=n(),d(le.$$.fragment),tt=n(),se=i("p"),se.textContent=Rt,lt=n(),ne=i("p"),ne.innerHTML=Nt,st=n(),d(ae.$$.fragment),nt=n(),ie=i("p"),ie.textContent=St,at=n(),d(oe.$$.fragment),it=n(),pe=i("p"),pe.innerHTML=At,ot=n(),d(de.$$.fragment),pt=n(),re=i("p"),re.textContent=Yt,dt=n(),ye=i("p"),ye.innerHTML=zt,rt=n(),he=i("p"),he.innerHTML=Qt,yt=n(),we=i("p"),this.h()},l(e){const t=Kt("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(l),Te=a(e),ce=o(e,"P",{}),Xt(ce).forEach(l),Me=a(e),r(J.$$.fragment,e),ue=a(e),m=o(e,"P",{"data-svelte-h":!0}),p(m)!=="svelte-utxjdb"&&(m.innerHTML=wt),Je=a(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-nd5753"&&(f.innerHTML=Tt),me=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-rirnor"&&(I.innerHTML=Mt),fe=a(e),r(U.$$.fragment,e),Ie=a(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-6ei6y6"&&(j.innerHTML=ut),Ue=a(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-wxy1ws"&&(b.textContent=Jt),je=a(e),C=o(e,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-hgiuvk"&&(C.innerHTML=mt),be=a(e),r(g.$$.fragment,e),Ce=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1lc7u48"&&(B.innerHTML=ft),ge=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-131h02t"&&(G.innerHTML=It),Be=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-xuocio"&&(v.innerHTML=Ut),Ge=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-16in619"&&(H.innerHTML=jt),ve=a(e),r($.$$.fragment,e),He=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-s875rd"&&(_.innerHTML=bt),$e=a(e),r(k.$$.fragment,e),_e=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-12klzx5"&&(x.textContent=Ct),ke=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-ms7r4w"&&(Z.innerHTML=gt),xe=a(e),r(E.$$.fragment,e),Ze=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1r9okad"&&(W.innerHTML=Bt),Ee=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-k22wa5"&&(R.innerHTML=Gt),We=a(e),r(N.$$.fragment,e),Re=a(e),r(S.$$.fragment,e),Ne=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1dqini1"&&(A.innerHTML=vt),Se=a(e),Y=o(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-1gdza5u"&&(Y.innerHTML=Ht),Ae=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1xwwutb"&&(z.innerHTML=$t),Ye=a(e),r(Q.$$.fragment,e),ze=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-16cpa65"&&(X.innerHTML=_t),Qe=a(e),r(L.$$.fragment,e),Xe=a(e),r(q.$$.fragment,e),Le=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-58qwnr"&&(V.innerHTML=kt),qe=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1f0seln"&&(F.innerHTML=xt),Ve=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1fqhyg1"&&(P.innerHTML=Zt),Fe=a(e),r(D.$$.fragment,e),Pe=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1s8qwlb"&&(K.innerHTML=Et),De=a(e),r(O.$$.fragment,e),Ke=a(e),r(ee.$$.fragment,e),Oe=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-4es9m7"&&(te.textContent=Wt),et=a(e),r(le.$$.fragment,e),tt=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-vtyfqm"&&(se.textContent=Rt),lt=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-15zdf0d"&&(ne.innerHTML=Nt),st=a(e),r(ae.$$.fragment,e),nt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1ii6eax"&&(ie.textContent=St),at=a(e),r(oe.$$.fragment,e),it=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-8xlhlw"&&(pe.innerHTML=At),ot=a(e),r(de.$$.fragment,e),pt=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-n8fnak"&&(re.textContent=Yt),dt=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1uvy9xv"&&(ye.innerHTML=zt),rt=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-hwhuk5"&&(he.innerHTML=Qt),yt=a(e),we=o(e,"P",{}),Xt(we).forEach(l),this.h()},h(){Lt(T,"name","hf:doc:metadata"),Lt(T,"content",tl)},m(e,t){Ot(document.head,T),s(e,Te,t),s(e,ce,t),s(e,Me,t),y(J,e,t),s(e,ue,t),s(e,m,t),s(e,Je,t),s(e,f,t),s(e,me,t),s(e,I,t),s(e,fe,t),y(U,e,t),s(e,Ie,t),s(e,j,t),s(e,Ue,t),s(e,b,t),s(e,je,t),s(e,C,t),s(e,be,t),y(g,e,t),s(e,Ce,t),s(e,B,t),s(e,ge,t),s(e,G,t),s(e,Be,t),s(e,v,t),s(e,Ge,t),s(e,H,t),s(e,ve,t),y($,e,t),s(e,He,t),s(e,_,t),s(e,$e,t),y(k,e,t),s(e,_e,t),s(e,x,t),s(e,ke,t),s(e,Z,t),s(e,xe,t),y(E,e,t),s(e,Ze,t),s(e,W,t),s(e,Ee,t),s(e,R,t),s(e,We,t),y(N,e,t),s(e,Re,t),y(S,e,t),s(e,Ne,t),s(e,A,t),s(e,Se,t),s(e,Y,t),s(e,Ae,t),s(e,z,t),s(e,Ye,t),y(Q,e,t),s(e,ze,t),s(e,X,t),s(e,Qe,t),y(L,e,t),s(e,Xe,t),y(q,e,t),s(e,Le,t),s(e,V,t),s(e,qe,t),s(e,F,t),s(e,Ve,t),s(e,P,t),s(e,Fe,t),y(D,e,t),s(e,Pe,t),s(e,K,t),s(e,De,t),y(O,e,t),s(e,Ke,t),y(ee,e,t),s(e,Oe,t),s(e,te,t),s(e,et,t),y(le,e,t),s(e,tt,t),s(e,se,t),s(e,lt,t),s(e,ne,t),s(e,st,t),y(ae,e,t),s(e,nt,t),s(e,ie,t),s(e,at,t),y(oe,e,t),s(e,it,t),s(e,pe,t),s(e,ot,t),y(de,e,t),s(e,pt,t),s(e,re,t),s(e,dt,t),s(e,ye,t),s(e,rt,t),s(e,he,t),s(e,yt,t),s(e,we,t),ht=!0},p:Vt,i(e){ht||(h(J.$$.fragment,e),h(U.$$.fragment,e),h(g.$$.fragment,e),h($.$$.fragment,e),h(k.$$.fragment,e),h(E.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(Q.$$.fragment,e),h(L.$$.fragment,e),h(q.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(de.$$.fragment,e),ht=!0)},o(e){c(J.$$.fragment,e),c(U.$$.fragment,e),c(g.$$.fragment,e),c($.$$.fragment,e),c(k.$$.fragment,e),c(E.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),c(Q.$$.fragment,e),c(L.$$.fragment,e),c(q.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(de.$$.fragment,e),ht=!1},d(e){e&&(l(Te),l(ce),l(Me),l(ue),l(m),l(Je),l(f),l(me),l(I),l(fe),l(Ie),l(j),l(Ue),l(b),l(je),l(C),l(be),l(Ce),l(B),l(ge),l(G),l(Be),l(v),l(Ge),l(H),l(ve),l(He),l(_),l($e),l(_e),l(x),l(ke),l(Z),l(xe),l(Ze),l(W),l(Ee),l(R),l(We),l(Re),l(Ne),l(A),l(Se),l(Y),l(Ae),l(z),l(Ye),l(ze),l(X),l(Qe),l(Xe),l(Le),l(V),l(qe),l(F),l(Ve),l(P),l(Fe),l(Pe),l(K),l(De),l(Ke),l(Oe),l(te),l(et),l(tt),l(se),l(lt),l(ne),l(st),l(nt),l(ie),l(at),l(it),l(pe),l(ot),l(pt),l(re),l(dt),l(ye),l(rt),l(he),l(yt),l(we)),l(T),w(J,e),w(U,e),w(g,e),w($,e),w(k,e),w(E,e),w(N,e),w(S,e),w(Q,e),w(L,e),w(q,e),w(D,e),w(O,e),w(ee,e),w(le,e),w(ae,e),w(oe,e),w(de,e)}}}const tl='{"title":"Create custom Inference Handler","local":"create-custom-inference-handler","sections":[{"title":"Custom Handler Examples","local":"custom-handler-examples","sections":[],"depth":2},{"title":"Tutorial","local":"tutorial","sections":[{"title":"1. Set up Development Environment","local":"1-set-up-development-environment","sections":[],"depth":3},{"title":"2. Create EndpointHandler (CP)","local":"2-create-endpointhandler-cp","sections":[],"depth":3},{"title":"3. Customize EndpointHandler","local":"3-customize-endpointhandler","sections":[],"depth":3},{"title":"4. Test EndpointHandler","local":"4-test-endpointhandler","sections":[],"depth":3},{"title":"5. Push the Custom Handler to your repository","local":"5-push-the-custom-handler-to-your-repository","sections":[],"depth":3},{"title":"6. Deploy your Custom Handler as an Inference Endpoint","local":"6-deploy-your-custom-handler-as-an-inference-endpoint","sections":[],"depth":3}],"depth":2}],"depth":1}';function ll(ct){return Ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends Pt{constructor(T){super(),Dt(this,T,ll,el,qt,{})}}export{ol as component};
