import{s as Qe,n as Ae,o as We}from"../chunks/scheduler.9f522b10.js";import{S as Fe,i as qe,g as i,s as a,r as p,A as He,h as r,f as l,c as n,j as _e,u as y,x as o,k as Ve,y as Ye,a as s,v as M,d as m,t as h,w}from"../chunks/index.192f26f8.js";import{C as F}from"../chunks/CodeBlock.ac496002.js";import{H as Je}from"../chunks/Heading.1a5b64b4.js";function Se(Te){let c,Y,q,S,u,L,d,be=`In the <a href="quicktour">Quicktour</a>, we saw how to build and train a
tokenizer using text files, but we can actually use any Python Iterator.
In this section we’ll see a few different ways of training our
tokenizer.`,E,f,je=`For all the examples listed below, we’ll use the same <a href="/docs/tokenizers/main/en/api/tokenizer#tokenizers.Tokenizer">Tokenizer</a> and
<code>Trainer</code>, built as
following:`,N,U,P,J,ke=`This tokenizer is based on the <a href="/docs/tokenizers/main/en/api/models#tokenizers.models.Unigram">Unigram</a> model. It
takes care of normalizing the input using the NFKC Unicode normalization
method, and uses a <a href="/docs/tokenizers/main/en/api/pre-tokenizers#tokenizers.pre_tokenizers.ByteLevel">ByteLevel</a> pre-tokenizer with the corresponding decoder.`,K,T,ge=`For more information on the components used here, you can check
<a href="components">here</a>.`,D,b,O,j,Ce=`As you probably guessed already, the easiest way to train our tokenizer
is by using a <code>List</code>{.interpreted-text role=“obj”}:`,ee,k,te,g,Ie=`Easy, right? You can use anything working as an iterator here, be it a
<code>List</code>{.interpreted-text role=“obj”}, <code>Tuple</code>{.interpreted-text
role=“obj”}, or a <code>np.Array</code>{.interpreted-text role=“obj”}. Anything
works as long as it provides strings.`,le,C,se,I,$e=`An awesome way to access one of the many datasets that exist out there
is by using the 🤗 Datasets library. For more information about it, you
should check <a href="https://huggingface.co/docs/datasets/" rel="nofollow">the official documentation
here</a>.`,ae,$,ze="Let’s start by loading our dataset:",ne,z,ie,G,Ge=`The next step is to build an iterator over this dataset. The easiest way
to do this is probably by using a generator:`,re,Z,oe,v,Ze=`As you can see here, for improved efficiency we can actually provide a
batch of examples used to train, instead of iterating over them one by
one. By doing so, we can expect performances very similar to those we
got while training directly from files.`,pe,X,ve=`With our iterator ready, we just need to launch the training. In order
to improve the look of our progress bars, we can specify the total
length of the dataset:`,ye,B,Me,x,Xe="And that’s it!",me,R,he,_,Be=`Since gzip files in Python can be used as iterators, it is extremely
simple to train on such files:`,we,V,ce,Q,xe=`Now if we wanted to train from multiple gzip files, it wouldn’t be much
harder:`,ue,A,de,W,Re="And voilà!",fe,H,Ue;return u=new Je({props:{title:"Training from memory",local:"training-from-memory",headingTag:"h1"}}),U=new F({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBUb2tlbml6ZXIlMkMlMjBkZWNvZGVycyUyQyUyMG1vZGVscyUyQyUyMG5vcm1hbGl6ZXJzJTJDJTIwcHJlX3Rva2VuaXplcnMlMkMlMjB0cmFpbmVycyUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuVW5pZ3JhbSgpKSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuTkZLQygpJTBBdG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoKSUwQXRva2VuaXplci5kZWNvZGVyJTIwJTNEJTIwZGVjb2RlcnMuQnl0ZUxldmVsKCklMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDIwMDAwJTJDJTBBJTIwJTIwJTIwJTIwaW5pdGlhbF9hbHBoYWJldCUzRHByZV90b2tlbml6ZXJzLkJ5dGVMZXZlbC5hbHBoYWJldCgpJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0NQQUQlM0UlMjIlMkMlMjAlMjIlM0NCT1MlM0UlMjIlMkMlMjAlMjIlM0NFT1MlM0UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Tokenizer, decoders, models, normalizers, pre_tokenizers, trainers
tokenizer = Tokenizer(models.Unigram())
tokenizer.normalizer = normalizers.NFKC()
tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel()
tokenizer.decoder = decoders.ByteLevel()
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">20000</span>,
    initial_alphabet=pre_tokenizers.ByteLevel.alphabet(),
    special_tokens=[<span class="hljs-string">&quot;&lt;PAD&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;BOS&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;EOS&gt;&quot;</span>],
)`,wrap:!1}}),b=new Je({props:{title:"The most basic way",local:"the-most-basic-way",headingTag:"h2"}}),k=new F({props:{code:"JTIzJTIwRmlyc3QlMjBmZXclMjBsaW5lcyUyMG9mJTIwdGhlJTIwJTIyWmVuJTIwb2YlMjBQeXRob24lMjIlMjBodHRwcyUzQSUyRiUyRnd3dy5weXRob24ub3JnJTJGZGV2JTJGcGVwcyUyRnBlcC0wMDIwJTJGJTBBZGF0YSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkJlYXV0aWZ1bCUyMGlzJTIwYmV0dGVyJTIwdGhhbiUyMHVnbHkuJTIyJTBBJTIwJTIwJTIwJTIwJTIyRXhwbGljaXQlMjBpcyUyMGJldHRlciUyMHRoYW4lMjBpbXBsaWNpdC4lMjIlMEElMjAlMjAlMjAlMjAlMjJTaW1wbGUlMjBpcyUyMGJldHRlciUyMHRoYW4lMjBjb21wbGV4LiUyMiUwQSUyMCUyMCUyMCUyMCUyMkNvbXBsZXglMjBpcyUyMGJldHRlciUyMHRoYW4lMjBjb21wbGljYXRlZC4lMjIlMEElMjAlMjAlMjAlMjAlMjJGbGF0JTIwaXMlMjBiZXR0ZXIlMjB0aGFuJTIwbmVzdGVkLiUyMiUwQSUyMCUyMCUyMCUyMCUyMlNwYXJzZSUyMGlzJTIwYmV0dGVyJTIwdGhhbiUyMGRlbnNlLiUyMiUwQSUyMCUyMCUyMCUyMCUyMlJlYWRhYmlsaXR5JTIwY291bnRzLiUyMiUwQSU1RCUwQXRva2VuaXplci50cmFpbl9mcm9tX2l0ZXJhdG9yKGRhdGElMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`<span class="hljs-comment"># First few lines of the &quot;Zen of Python&quot; https://www.python.org/dev/peps/pep-0020/</span>
data = [
    <span class="hljs-string">&quot;Beautiful is better than ugly.&quot;</span>
    <span class="hljs-string">&quot;Explicit is better than implicit.&quot;</span>
    <span class="hljs-string">&quot;Simple is better than complex.&quot;</span>
    <span class="hljs-string">&quot;Complex is better than complicated.&quot;</span>
    <span class="hljs-string">&quot;Flat is better than nested.&quot;</span>
    <span class="hljs-string">&quot;Sparse is better than dense.&quot;</span>
    <span class="hljs-string">&quot;Readability counts.&quot;</span>
]
tokenizer.train_from_iterator(data, trainer=trainer)`,wrap:!1}}),C=new Je({props:{title:"Using the 🤗 Datasets library",local:"using-the--datasets-library",headingTag:"h2"}}),z=new F({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMndpa2l0ZXh0JTIyJTJDJTIwJTIyd2lraXRleHQtMTAzLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMkJ0ZXN0JTJCdmFsaWRhdGlvbiUyMik=",highlighted:`<span class="hljs-keyword">import</span> datasets
dataset = datasets.load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, <span class="hljs-string">&quot;wikitext-103-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train+test+validation&quot;</span>)`,wrap:!1}}),Z=new F({props:{code:"ZGVmJTIwYmF0Y2hfaXRlcmF0b3IoYmF0Y2hfc2l6ZSUzRDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihkYXRhc2V0KSUyQyUyMGJhdGNoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBkYXRhc2V0JTVCaSUyMCUzQSUyMGklMjAlMkIlMjBiYXRjaF9zaXplJTVEJTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">batch_iterator</span>(<span class="hljs-params">batch_size=<span class="hljs-number">1000</span></span>):
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), batch_size):
        <span class="hljs-keyword">yield</span> dataset[i : i + batch_size][<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),B=new F({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoYmF0Y2hfaXRlcmF0b3IoKSUyQyUyMHRyYWluZXIlM0R0cmFpbmVyJTJDJTIwbGVuZ3RoJTNEbGVuKGRhdGFzZXQpKQ==",highlighted:'tokenizer.train_from_iterator(batch_iterator(), trainer=trainer, length=<span class="hljs-built_in">len</span>(dataset))',wrap:!1}}),R=new Je({props:{title:"Using gzip files",local:"using-gzip-files",headingTag:"h2"}}),V=new F({props:{code:"aW1wb3J0JTIwZ3ppcCUwQXdpdGglMjBnemlwLm9wZW4oJTIyZGF0YSUyRm15LWZpbGUuMC5neiUyMiUyQyUyMCUyMnJ0JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplci50cmFpbl9mcm9tX2l0ZXJhdG9yKGYlMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`<span class="hljs-keyword">import</span> gzip
<span class="hljs-keyword">with</span> gzip.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;data/my-file.0.gz&quot;</span>, <span class="hljs-string">&quot;rt&quot;</span>) <span class="hljs-keyword">as</span> f:
    tokenizer.train_from_iterator(f, trainer=trainer)`,wrap:!1}}),A=new F({props:{code:"ZmlsZXMlMjAlM0QlMjAlNUIlMjJkYXRhJTJGbXktZmlsZS4wLmd6JTIyJTJDJTIwJTIyZGF0YSUyRm15LWZpbGUuMS5neiUyMiUyQyUyMCUyMmRhdGElMkZteS1maWxlLjIuZ3olMjIlNUQlMEFkZWYlMjBnemlwX2l0ZXJhdG9yKCklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBwYXRoJTIwaW4lMjBmaWxlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBnemlwLm9wZW4ocGF0aCUyQyUyMCUyMnJ0JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGxpbmUlMjBpbiUyMGYlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMGxpbmUlMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnemlwX2l0ZXJhdG9yKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`files = [<span class="hljs-string">&quot;data/my-file.0.gz&quot;</span>, <span class="hljs-string">&quot;data/my-file.1.gz&quot;</span>, <span class="hljs-string">&quot;data/my-file.2.gz&quot;</span>]
<span class="hljs-keyword">def</span> <span class="hljs-title function_">gzip_iterator</span>():
    <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> files:
        <span class="hljs-keyword">with</span> gzip.<span class="hljs-built_in">open</span>(path, <span class="hljs-string">&quot;rt&quot;</span>) <span class="hljs-keyword">as</span> f:
            <span class="hljs-keyword">for</span> line <span class="hljs-keyword">in</span> f:
                <span class="hljs-keyword">yield</span> line
tokenizer.train_from_iterator(gzip_iterator(), trainer=trainer)`,wrap:!1}}),{c(){c=i("meta"),Y=a(),q=i("p"),S=a(),p(u.$$.fragment),L=a(),d=i("p"),d.innerHTML=be,E=a(),f=i("p"),f.innerHTML=je,N=a(),p(U.$$.fragment),P=a(),J=i("p"),J.innerHTML=ke,K=a(),T=i("p"),T.innerHTML=ge,D=a(),p(b.$$.fragment),O=a(),j=i("p"),j.innerHTML=Ce,ee=a(),p(k.$$.fragment),te=a(),g=i("p"),g.innerHTML=Ie,le=a(),p(C.$$.fragment),se=a(),I=i("p"),I.innerHTML=$e,ae=a(),$=i("p"),$.textContent=ze,ne=a(),p(z.$$.fragment),ie=a(),G=i("p"),G.textContent=Ge,re=a(),p(Z.$$.fragment),oe=a(),v=i("p"),v.textContent=Ze,pe=a(),X=i("p"),X.textContent=ve,ye=a(),p(B.$$.fragment),Me=a(),x=i("p"),x.textContent=Xe,me=a(),p(R.$$.fragment),he=a(),_=i("p"),_.textContent=Be,we=a(),p(V.$$.fragment),ce=a(),Q=i("p"),Q.textContent=xe,ue=a(),p(A.$$.fragment),de=a(),W=i("p"),W.textContent=Re,fe=a(),H=i("p"),this.h()},l(e){const t=He("svelte-u9bgzb",document.head);c=r(t,"META",{name:!0,content:!0}),t.forEach(l),Y=n(e),q=r(e,"P",{}),_e(q).forEach(l),S=n(e),y(u.$$.fragment,e),L=n(e),d=r(e,"P",{"data-svelte-h":!0}),o(d)!=="svelte-zs4zcn"&&(d.innerHTML=be),E=n(e),f=r(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-19ksku3"&&(f.innerHTML=je),N=n(e),y(U.$$.fragment,e),P=n(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-187kexu"&&(J.innerHTML=ke),K=n(e),T=r(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1cm91fx"&&(T.innerHTML=ge),D=n(e),y(b.$$.fragment,e),O=n(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-800zef"&&(j.innerHTML=Ce),ee=n(e),y(k.$$.fragment,e),te=n(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-2k2g93"&&(g.innerHTML=Ie),le=n(e),y(C.$$.fragment,e),se=n(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-tt7so"&&(I.innerHTML=$e),ae=n(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-8j5br2"&&($.textContent=ze),ne=n(e),y(z.$$.fragment,e),ie=n(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-134xe8u"&&(G.textContent=Ge),re=n(e),y(Z.$$.fragment,e),oe=n(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-18jpyth"&&(v.textContent=Ze),pe=n(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1ha2c1s"&&(X.textContent=ve),ye=n(e),y(B.$$.fragment,e),Me=n(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-9wooxy"&&(x.textContent=Xe),me=n(e),y(R.$$.fragment,e),he=n(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-rvsukz"&&(_.textContent=Be),we=n(e),y(V.$$.fragment,e),ce=n(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1g7s20h"&&(Q.textContent=xe),ue=n(e),y(A.$$.fragment,e),de=n(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-15ag4ju"&&(W.textContent=Re),fe=n(e),H=r(e,"P",{}),_e(H).forEach(l),this.h()},h(){Ve(c,"name","hf:doc:metadata"),Ve(c,"content",Le)},m(e,t){Ye(document.head,c),s(e,Y,t),s(e,q,t),s(e,S,t),M(u,e,t),s(e,L,t),s(e,d,t),s(e,E,t),s(e,f,t),s(e,N,t),M(U,e,t),s(e,P,t),s(e,J,t),s(e,K,t),s(e,T,t),s(e,D,t),M(b,e,t),s(e,O,t),s(e,j,t),s(e,ee,t),M(k,e,t),s(e,te,t),s(e,g,t),s(e,le,t),M(C,e,t),s(e,se,t),s(e,I,t),s(e,ae,t),s(e,$,t),s(e,ne,t),M(z,e,t),s(e,ie,t),s(e,G,t),s(e,re,t),M(Z,e,t),s(e,oe,t),s(e,v,t),s(e,pe,t),s(e,X,t),s(e,ye,t),M(B,e,t),s(e,Me,t),s(e,x,t),s(e,me,t),M(R,e,t),s(e,he,t),s(e,_,t),s(e,we,t),M(V,e,t),s(e,ce,t),s(e,Q,t),s(e,ue,t),M(A,e,t),s(e,de,t),s(e,W,t),s(e,fe,t),s(e,H,t),Ue=!0},p:Ae,i(e){Ue||(m(u.$$.fragment,e),m(U.$$.fragment,e),m(b.$$.fragment,e),m(k.$$.fragment,e),m(C.$$.fragment,e),m(z.$$.fragment,e),m(Z.$$.fragment,e),m(B.$$.fragment,e),m(R.$$.fragment,e),m(V.$$.fragment,e),m(A.$$.fragment,e),Ue=!0)},o(e){h(u.$$.fragment,e),h(U.$$.fragment,e),h(b.$$.fragment,e),h(k.$$.fragment,e),h(C.$$.fragment,e),h(z.$$.fragment,e),h(Z.$$.fragment,e),h(B.$$.fragment,e),h(R.$$.fragment,e),h(V.$$.fragment,e),h(A.$$.fragment,e),Ue=!1},d(e){e&&(l(Y),l(q),l(S),l(L),l(d),l(E),l(f),l(N),l(P),l(J),l(K),l(T),l(D),l(O),l(j),l(ee),l(te),l(g),l(le),l(se),l(I),l(ae),l($),l(ne),l(ie),l(G),l(re),l(oe),l(v),l(pe),l(X),l(ye),l(Me),l(x),l(me),l(he),l(_),l(we),l(ce),l(Q),l(ue),l(de),l(W),l(fe),l(H)),l(c),w(u,e),w(U,e),w(b,e),w(k,e),w(C,e),w(z,e),w(Z,e),w(B,e),w(R,e),w(V,e),w(A,e)}}}const Le='{"title":"Training from memory","local":"training-from-memory","sections":[{"title":"The most basic way","local":"the-most-basic-way","sections":[],"depth":2},{"title":"Using the 🤗 Datasets library","local":"using-the--datasets-library","sections":[],"depth":2},{"title":"Using gzip files","local":"using-gzip-files","sections":[],"depth":2}],"depth":1}';function Ee(Te){return We(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends Fe{constructor(c){super(),qe(this,c,Ee,Se,Qe,{})}}export{Oe as component};
