import{s as Jo,f as Fo,o as Uo,n as Re}from"../chunks/scheduler.9bc65507.js";import{S as Eo,i as Ro,g as d,s as a,r as h,A as So,h as c,f as t,c as r,j as P,u as g,x as b,k as $,y as i,a as l,v as f,d as u,t as _,w as T}from"../chunks/index.707bf1b6.js";import{T as ro}from"../chunks/Tip.c2ecdbf4.js";import{D}from"../chunks/Docstring.17db21ae.js";import{C as Ct}from"../chunks/CodeBlock.54a9f38d.js";import{E as Dt}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as W}from"../chunks/Heading.342b1fa6.js";function Wo(M){let n,v="Example:",m,p,y;return p=new Ct({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERQVE1vZGVsJTJDJTIwRFBUQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMERQVCUyMGRwdC1sYXJnZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBEUFRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBkcHQtbGFyZ2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMERQVE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DPTModel, DPTConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DPT dpt-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DPTConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the dpt-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DPTModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=a(),h(p.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),b(n)!=="svelte-11lpom8"&&(n.textContent=v),m=r(s),g(p.$$.fragment,s)},m(s,w){l(s,n,w),l(s,m,w),f(p,s,w),y=!0},p:Re,i(s){y||(u(p.$$.fragment,s),y=!0)},o(s){_(p.$$.fragment,s),y=!1},d(s){s&&(t(n),t(m)),T(p,s)}}}function Zo(M){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=v},l(m){n=c(m,"P",{"data-svelte-h":!0}),b(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,p){l(m,n,p)},p:Re,d(m){m&&t(n)}}}function Bo(M){let n,v="Example:",m,p,y;return p=new Ct({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERQVE1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJJbnRlbCUyRmRwdC1sYXJnZSUyMiklMEFtb2RlbCUyMCUzRCUyMERQVE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJJbnRlbCUyRmRwdC1sYXJnZSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DPTModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DPTModel.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">577</span>, <span class="hljs-number">1024</span>]`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=a(),h(p.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),b(n)!=="svelte-11lpom8"&&(n.textContent=v),m=r(s),g(p.$$.fragment,s)},m(s,w){l(s,n,w),l(s,m,w),f(p,s,w),y=!0},p:Re,i(s){y||(u(p.$$.fragment,s),y=!0)},o(s){_(p.$$.fragment,s),y=!1},d(s){s&&(t(n),t(m)),T(p,s)}}}function Lo(M){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=v},l(m){n=c(m,"P",{"data-svelte-h":!0}),b(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,p){l(m,n,p)},p:Re,d(m){m&&t(n)}}}function No(M){let n,v="Examples:",m,p,y;return p=new Ct({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERQVEZvckRlcHRoRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJJbnRlbCUyRmRwdC1sYXJnZSUyMiklMEFtb2RlbCUyMCUzRCUyMERQVEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIySW50ZWwlMkZkcHQtbGFyZ2UlMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwb3V0cHV0cy5wcmVkaWN0ZWRfZGVwdGglMEElMEElMjMlMjBpbnRlcnBvbGF0ZSUyMHRvJTIwb3JpZ2luYWwlMjBzaXplJTBBcHJlZGljdGlvbiUyMCUzRCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwuaW50ZXJwb2xhdGUoJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoLnVuc3F1ZWV6ZSgxKSUyQyUwQSUyMCUyMCUyMCUyMHNpemUlM0RpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlJTNEJTIyYmljdWJpYyUyMiUyQyUwQSUyMCUyMCUyMCUyMGFsaWduX2Nvcm5lcnMlM0RGYWxzZSUyQyUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBb3V0cHV0JTIwJTNEJTIwcHJlZGljdGlvbi5zcXVlZXplKCkuY3B1KCkubnVtcHkoKSUwQWZvcm1hdHRlZCUyMCUzRCUyMChvdXRwdXQlMjAqJTIwMjU1JTIwJTJGJTIwbnAubWF4KG91dHB1dCkpLmFzdHlwZSglMjJ1aW50OCUyMiklMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShmb3JtYXR0ZWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DPTForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DPTForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    predicted_depth = outputs.predicted_depth

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>    predicted_depth.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = prediction.squeeze().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>formatted = (output * <span class="hljs-number">255</span> / np.<span class="hljs-built_in">max</span>(output)).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(formatted)`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=a(),h(p.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),b(n)!=="svelte-kvfsh7"&&(n.textContent=v),m=r(s),g(p.$$.fragment,s)},m(s,w){l(s,n,w),l(s,m,w),f(p,s,w),y=!0},p:Re,i(s){y||(u(p.$$.fragment,s),y=!0)},o(s){_(p.$$.fragment,s),y=!1},d(s){s&&(t(n),t(m)),T(p,s)}}}function Ho(M){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=v},l(m){n=c(m,"P",{"data-svelte-h":!0}),b(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,p){l(m,n,p)},p:Re,d(m){m&&t(n)}}}function Vo(M){let n,v="Examples:",m,p,y;return p=new Ct({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERQVEZvclNlbWFudGljU2VnbWVudGF0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJJbnRlbCUyRmRwdC1sYXJnZS1hZGUlMjIpJTBBbW9kZWwlMjAlM0QlMjBEUFRGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIySW50ZWwlMkZkcHQtbGFyZ2UtYWRlJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DPTForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large-ade&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DPTForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large-ade&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=a(),h(p.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),b(n)!=="svelte-kvfsh7"&&(n.textContent=v),m=r(s),g(p.$$.fragment,s)},m(s,w){l(s,n,w),l(s,m,w),f(p,s,w),y=!0},p:Re,i(s){y||(u(p.$$.fragment,s),y=!0)},o(s){_(p.$$.fragment,s),y=!1},d(s){s&&(t(n),t(m)),T(p,s)}}}function Go(M){let n,v,m,p,y,s,w,ot,se,io=`The DPT model was proposed in <a href="https://arxiv.org/abs/2103.13413" rel="nofollow">Vision Transformers for Dense Prediction</a> by René Ranftl, Alexey Bochkovskiy, Vladlen Koltun.
DPT is a model that leverages the <a href="vit">Vision Transformer (ViT)</a> as backbone for dense prediction tasks like semantic segmentation and depth estimation.`,nt,ae,lo="The abstract from the paper is the following:",st,re,co="<em>We introduce dense vision transformers, an architecture that leverages vision transformers in place of convolutional networks as a backbone for dense prediction tasks. We assemble tokens from various stages of the vision transformer into image-like representations at various resolutions and progressively combine them into full-resolution predictions using a convolutional decoder. The transformer backbone processes representations at a constant and relatively high resolution and has a global receptive field at every stage. These properties allow the dense vision transformer to provide finer-grained and more globally coherent predictions when compared to fully-convolutional networks. Our experiments show that this architecture yields substantial improvements on dense prediction tasks, especially when a large amount of training data is available. For monocular depth estimation, we observe an improvement of up to 28% in relative performance when compared to a state-of-the-art fully-convolutional network. When applied to semantic segmentation, dense vision transformers set a new state of the art on ADE20K with 49.02% mIoU. We further show that the architecture can be fine-tuned on smaller datasets such as NYUv2, KITTI, and Pascal Context where it also sets the new state of the art.</em>",at,Z,mo,rt,ie,po='DPT architecture. Taken from the <a href="https://arxiv.org/abs/2103.13413" target="_blank">original paper</a>.',it,le,ho='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/isl-org/DPT" rel="nofollow">here</a>.',lt,de,dt,ce,go="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with DPT.",ct,me,fo='<li><p>Demo notebooks for <a href="/docs/transformers/v4.35.0/en/model_doc/dpt#transformers.DPTForDepthEstimation">DPTForDepthEstimation</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/DPT" rel="nofollow">here</a>.</p></li> <li><p><a href="../tasks/semantic_segmentation">Semantic segmentation task guide</a></p></li> <li><p><a href="../tasks/monocular_depth_estimation">Monocular depth estimation task guide</a></p></li>',mt,pe,uo="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",pt,he,ht,x,ge,zt,Se,_o=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.35.0/en/model_doc/dpt#transformers.DPTModel">DPTModel</a>. It is used to instantiate an DPT
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the DPT
<a href="https://huggingface.co/Intel/dpt-large" rel="nofollow">Intel/dpt-large</a> architecture.`,kt,We,To=`Configuration objects inherit from <a href="/docs/transformers/v4.35.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.35.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,jt,B,It,L,fe,Jt,Ze,bo=`Serializes this instance to a Python dictionary. Override the default <a href="/docs/transformers/v4.35.0/en/main_classes/configuration#transformers.PretrainedConfig.to_dict">to_dict()</a>. Returns:
<code>Dict[str, any]</code>: Dictionary of all the attributes that make up this configuration instance,`,gt,ue,ft,U,_e,Ft,N,Te,Ut,Be,yo="Preprocess an image or a batch of images.",Et,H,be,Rt,Le,vo='Converts the output of <a href="/docs/transformers/v4.35.0/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',ut,ye,_t,C,ve,St,Ne,wo="Constructs a DPT image processor.",Wt,V,we,Zt,He,$o="Preprocess an image or batch of images.",Bt,G,$e,Lt,Ve,Mo='Converts the output of <a href="/docs/transformers/v4.35.0/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',Tt,Me,bt,E,Pe,Nt,Ge,Po=`The bare DPT Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ht,I,xe,Vt,qe,xo='The <a href="/docs/transformers/v4.35.0/en/model_doc/dpt#transformers.DPTModel">DPTModel</a> forward method, overrides the <code>__call__</code> special method.',Gt,q,qt,A,yt,De,vt,z,Ce,At,Ae,Do="DPT Model with a depth estimation head on top (consisting of 3 convolutional layers) e.g. for KITTI, NYUv2.",Xt,Xe,Co=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Yt,J,ze,Qt,Ye,zo='The <a href="/docs/transformers/v4.35.0/en/model_doc/dpt#transformers.DPTForDepthEstimation">DPTForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',Ot,X,Kt,Y,wt,ke,$t,k,je,eo,Qe,ko="DPT Model with a semantic segmentation head on top e.g. for ADE20k, CityScapes.",to,Oe,jo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,oo,F,Ie,no,Ke,Io='The <a href="/docs/transformers/v4.35.0/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a> forward method, overrides the <code>__call__</code> special method.',so,Q,ao,O,Mt,tt,Pt;return y=new W({props:{title:"DPT",local:"dpt",headingTag:"h1"}}),w=new W({props:{title:"Overview",local:"overview",headingTag:"h2"}}),de=new W({props:{title:"Resources",local:"resources",headingTag:"h2"}}),he=new W({props:{title:"DPTConfig",local:"transformers.DPTConfig",headingTag:"h2"}}),ge=new D({props:{name:"class transformers.DPTConfig",anchor:"transformers.DPTConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"image_size",val:" = 384"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"is_hybrid",val:" = False"},{name:"qkv_bias",val:" = True"},{name:"backbone_out_indices",val:" = [2, 5, 8, 11]"},{name:"readout_type",val:" = 'project'"},{name:"reassemble_factors",val:" = [4, 2, 1, 0.5]"},{name:"neck_hidden_sizes",val:" = [96, 192, 384, 768]"},{name:"fusion_hidden_size",val:" = 256"},{name:"head_in_index",val:" = -1"},{name:"use_batch_norm_in_fusion_residual",val:" = False"},{name:"use_auxiliary_head",val:" = True"},{name:"auxiliary_loss_weight",val:" = 0.4"},{name:"semantic_loss_ignore_index",val:" = 255"},{name:"semantic_classifier_dropout",val:" = 0.1"},{name:"backbone_featmap_shape",val:" = [1, 1024, 24, 24]"},{name:"neck_ignore_stages",val:" = [0, 1]"},{name:"backbone_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DPTConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.DPTConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.DPTConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.DPTConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.DPTConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.DPTConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probabilitiy for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.DPTConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.DPTConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.DPTConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.DPTConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.DPTConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.DPTConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.DPTConfig.is_hybrid",description:`<strong>is_hybrid</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a hybrid backbone. Useful in the context of loading DPT-Hybrid models.`,name:"is_hybrid"},{anchor:"transformers.DPTConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.DPTConfig.backbone_out_indices",description:`<strong>backbone_out_indices</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 5, 8, 11]</code>) &#x2014;
Indices of the intermediate hidden states to use from backbone.`,name:"backbone_out_indices"},{anchor:"transformers.DPTConfig.readout_type",description:`<strong>readout_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;project&quot;</code>) &#x2014;
The readout type to use when processing the readout token (CLS token) of the intermediate hidden states of
the ViT backbone. Can be one of [<code>&quot;ignore&quot;</code>, <code>&quot;add&quot;</code>, <code>&quot;project&quot;</code>].</p>
<ul>
<li>&#x201C;ignore&#x201D; simply ignores the CLS token.</li>
<li>&#x201C;add&#x201D; passes the information from the CLS token to all other tokens by adding the representations.</li>
<li>&#x201C;project&#x201D; passes information to the other tokens by concatenating the readout to all other tokens before
projecting the
representation to the original feature dimension D using a linear layer followed by a GELU non-linearity.</li>
</ul>`,name:"readout_type"},{anchor:"transformers.DPTConfig.reassemble_factors",description:`<strong>reassemble_factors</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 1, 0.5]</code>) &#x2014;
The up/downsampling factors of the reassemble layers.`,name:"reassemble_factors"},{anchor:"transformers.DPTConfig.neck_hidden_sizes",description:`<strong>neck_hidden_sizes</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[96, 192, 384, 768]</code>) &#x2014;
The hidden sizes to project to for the feature maps of the backbone.`,name:"neck_hidden_sizes"},{anchor:"transformers.DPTConfig.fusion_hidden_size",description:`<strong>fusion_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of channels before fusion.`,name:"fusion_hidden_size"},{anchor:"transformers.DPTConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the heads.`,name:"head_in_index"},{anchor:"transformers.DPTConfig.use_batch_norm_in_fusion_residual",description:`<strong>use_batch_norm_in_fusion_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use batch normalization in the pre-activate residual units of the fusion blocks.`,name:"use_batch_norm_in_fusion_residual"},{anchor:"transformers.DPTConfig.use_auxiliary_head",description:`<strong>use_auxiliary_head</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use an auxiliary head during training.`,name:"use_auxiliary_head"},{anchor:"transformers.DPTConfig.auxiliary_loss_weight",description:`<strong>auxiliary_loss_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.4) &#x2014;
Weight of the cross-entropy loss of the auxiliary head.`,name:"auxiliary_loss_weight"},{anchor:"transformers.DPTConfig.semantic_loss_ignore_index",description:`<strong>semantic_loss_ignore_index</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
The index that is ignored by the loss function of the semantic segmentation model.`,name:"semantic_loss_ignore_index"},{anchor:"transformers.DPTConfig.semantic_classifier_dropout",description:`<strong>semantic_classifier_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the semantic classification head.`,name:"semantic_classifier_dropout"},{anchor:"transformers.DPTConfig.backbone_featmap_shape",description:`<strong>backbone_featmap_shape</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 1024, 24, 24]</code>) &#x2014;
Used only for the <code>hybrid</code> embedding type. The shape of the feature maps of the backbone.`,name:"backbone_featmap_shape"},{anchor:"transformers.DPTConfig.neck_ignore_stages",description:`<strong>neck_ignore_stages</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[0, 1]</code>) &#x2014;
Used only for the <code>hybrid</code> embedding type. The stages of the readout layers to ignore.`,name:"neck_ignore_stages"},{anchor:"transformers.DPTConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
Used only for the <code>hybrid</code> embedding type. The configuration of the backbone in a dictionary.`,name:"backbone_config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/models/dpt/configuration_dpt.py#L32"}}),B=new Dt({props:{anchor:"transformers.DPTConfig.example",$$slots:{default:[Wo]},$$scope:{ctx:M}}}),fe=new D({props:{name:"to_dict",anchor:"transformers.DPTConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/models/dpt/configuration_dpt.py#L220"}}),ue=new W({props:{title:"DPTFeatureExtractor",local:"transformers.DPTFeatureExtractor",headingTag:"h2"}}),_e=new D({props:{name:"class transformers.DPTFeatureExtractor",anchor:"transformers.DPTFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/models/dpt/feature_extraction_dpt.py#L26"}}),Te=new D({props:{name:"__call__",anchor:"transformers.DPTFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/image_processing_utils.py#L547"}}),be=new D({props:{name:"post_process_semantic_segmentation",anchor:"transformers.DPTFeatureExtractor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.List[typing.Tuple] = None"}],parametersDescription:[{anchor:"transformers.DPTFeatureExtractor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.35.0/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DPTFeatureExtractor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code> of length <code>batch_size</code>, <em>optional</em>) &#x2014;
List of tuples corresponding to the requested final size (height, width) of each prediction. If unset,
predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/models/dpt/image_processing_dpt.py#L346",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code> of length <code>batch_size</code>, where each item is a semantic
segmentation map of shape (height, width) corresponding to the target_sizes entry (if <code>target_sizes</code> is
specified). Each entry of each <code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>semantic_segmentation</p>
`}}),ye=new W({props:{title:"DPTImageProcessor",local:"transformers.DPTImageProcessor",headingTag:"h2"}}),ve=new D({props:{name:"class transformers.DPTImageProcessor",anchor:"transformers.DPTImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"keep_aspect_ratio",val:": bool = False"},{name:"ensure_multiple_of",val:": int = 1"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DPTImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions. Can be overidden by <code>do_resize</code> in <code>preprocess</code>.`,name:"do_resize"},{anchor:"transformers.DPTImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 384, &quot;width&quot;: 384}</code>):
Size of the image after resizing. Can be overidden by <code>size</code> in <code>preprocess</code>.`,name:"size"},{anchor:"transformers.DPTImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Defines the resampling filter to use if resizing the image. Can be overidden by <code>resample</code> in <code>preprocess</code>.`,name:"resample"},{anchor:"transformers.DPTImageProcessor.keep_aspect_ratio",description:`<strong>keep_aspect_ratio</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the image is resized to the largest possible size such that the aspect ratio is preserved. Can
be overidden by <code>keep_aspect_ratio</code> in <code>preprocess</code>.`,name:"keep_aspect_ratio"},{anchor:"transformers.DPTImageProcessor.ensure_multiple_of",description:`<strong>ensure_multiple_of</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
If <code>do_resize</code> is <code>True</code>, the image is resized to a size that is a multiple of this value. Can be overidden
by <code>ensure_multiple_of</code> in <code>preprocess</code>.`,name:"ensure_multiple_of"},{anchor:"transformers.DPTImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overidden by <code>do_rescale</code> in
<code>preprocess</code>.`,name:"do_rescale"},{anchor:"transformers.DPTImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overidden by <code>rescale_factor</code> in <code>preprocess</code>.`,name:"rescale_factor"},{anchor:"transformers.DPTImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.DPTImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.DPTImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/models/dpt/image_processing_dpt.py#L94"}}),we=new D({props:{name:"preprocess",anchor:"transformers.DPTImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": bool = None"},{name:"size",val:": int = None"},{name:"keep_aspect_ratio",val:": bool = None"},{name:"ensure_multiple_of",val:": int = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DPTImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DPTImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DPTImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after reszing. If <code>keep_aspect_ratio</code> is <code>True</code>, the image is resized to the largest
possible size such that the aspect ratio is preserved. If <code>ensure_multiple_of</code> is set, the image is
resized to a size that is a multiple of this value.`,name:"size"},{anchor:"transformers.DPTImageProcessor.preprocess.keep_aspect_ratio",description:`<strong>keep_aspect_ratio</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.keep_aspect_ratio</code>) &#x2014;
Whether to keep the aspect ratio of the image. If False, the image will be resized to (size, size). If
True, the image will be resized to keep the aspect ratio and the size will be the maximum possible.`,name:"keep_aspect_ratio"},{anchor:"transformers.DPTImageProcessor.preprocess.ensure_multiple_of",description:`<strong>ensure_multiple_of</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.ensure_multiple_of</code>) &#x2014;
Ensure that the image size is a multiple of this value.`,name:"ensure_multiple_of"},{anchor:"transformers.DPTImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.DPTImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.DPTImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.DPTImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DPTImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.DPTImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.DPTImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.DPTImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.DPTImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/models/dpt/image_processing_dpt.py#L211"}}),$e=new D({props:{name:"post_process_semantic_segmentation",anchor:"transformers.DPTImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.List[typing.Tuple] = None"}],parametersDescription:[{anchor:"transformers.DPTImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.35.0/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DPTImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code> of length <code>batch_size</code>, <em>optional</em>) &#x2014;
List of tuples corresponding to the requested final size (height, width) of each prediction. If unset,
predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/models/dpt/image_processing_dpt.py#L346",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code> of length <code>batch_size</code>, where each item is a semantic
segmentation map of shape (height, width) corresponding to the target_sizes entry (if <code>target_sizes</code> is
specified). Each entry of each <code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>semantic_segmentation</p>
`}}),Me=new W({props:{title:"DPTModel",local:"transformers.DPTModel",headingTag:"h2"}}),Pe=new D({props:{name:"class transformers.DPTModel",anchor:"transformers.DPTModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.DPTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.0/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/models/dpt/modeling_dpt.py#L854"}}),xe=new D({props:{name:"forward",anchor:"transformers.DPTModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DPTModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.35.0/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DPTModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DPTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DPTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DPTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/models/dpt/modeling_dpt.py#L886",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.dpt.modeling_dpt.BaseModelOutputWithPoolingAndIntermediateActivations</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.0/en/model_doc/dpt#transformers.DPTConfig"
>DPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>intermediate_activations</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Intermediate activations that can be used to compute hidden states of the model at various layers.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.dpt.modeling_dpt.BaseModelOutputWithPoolingAndIntermediateActivations</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),q=new ro({props:{$$slots:{default:[Zo]},$$scope:{ctx:M}}}),A=new Dt({props:{anchor:"transformers.DPTModel.forward.example",$$slots:{default:[Bo]},$$scope:{ctx:M}}}),De=new W({props:{title:"DPTForDepthEstimation",local:"transformers.DPTForDepthEstimation",headingTag:"h2"}}),Ce=new D({props:{name:"class transformers.DPTForDepthEstimation",anchor:"transformers.DPTForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.DPTForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.0/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/models/dpt/modeling_dpt.py#L1042"}}),ze=new D({props:{name:"forward",anchor:"transformers.DPTForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DPTForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.35.0/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DPTForDepthEstimation.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DPTForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DPTForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DPTForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DPTForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/models/dpt/modeling_dpt.py#L1057",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.0/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.0/en/model_doc/dpt#transformers.DPTConfig"
>DPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.0/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new ro({props:{$$slots:{default:[Lo]},$$scope:{ctx:M}}}),Y=new Dt({props:{anchor:"transformers.DPTForDepthEstimation.forward.example",$$slots:{default:[No]},$$scope:{ctx:M}}}),ke=new W({props:{title:"DPTForSemanticSegmentation",local:"transformers.DPTForSemanticSegmentation",headingTag:"h2"}}),je=new D({props:{name:"class transformers.DPTForSemanticSegmentation",anchor:"transformers.DPTForSemanticSegmentation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.DPTForSemanticSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.0/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/models/dpt/modeling_dpt.py#L1210"}}),Ie=new D({props:{name:"forward",anchor:"transformers.DPTForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DPTForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.35.0/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DPTForSemanticSegmentation.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DPTForSemanticSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DPTForSemanticSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DPTForSemanticSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DPTForSemanticSegmentation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth semantic segmentation maps for computing the loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code>, a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/models/dpt/modeling_dpt.py#L1226",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.0/en/main_classes/output#transformers.modeling_outputs.SemanticSegmenterOutput"
>transformers.modeling_outputs.SemanticSegmenterOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.0/en/model_doc/dpt#transformers.DPTConfig"
>DPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels, logits_height, logits_width)</code>) — Classification scores for each pixel.</p>
<Tip warning={true}>
<p>The logits returned do not necessarily have the same size as the <code>pixel_values</code> passed as inputs. This is
to avoid doing two interpolations and lose some quality when a user needs to resize the logits to the
original image size as post-processing. You should always check your logits shape and resize as needed.</p>
</Tip>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, patch_size, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.0/en/main_classes/output#transformers.modeling_outputs.SemanticSegmenterOutput"
>transformers.modeling_outputs.SemanticSegmenterOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new ro({props:{$$slots:{default:[Ho]},$$scope:{ctx:M}}}),O=new Dt({props:{anchor:"transformers.DPTForSemanticSegmentation.forward.example",$$slots:{default:[Vo]},$$scope:{ctx:M}}}),{c(){n=d("meta"),v=a(),m=d("p"),p=a(),h(y.$$.fragment),s=a(),h(w.$$.fragment),ot=a(),se=d("p"),se.innerHTML=io,nt=a(),ae=d("p"),ae.textContent=lo,st=a(),re=d("p"),re.innerHTML=co,at=a(),Z=d("img"),rt=a(),ie=d("small"),ie.innerHTML=po,it=a(),le=d("p"),le.innerHTML=ho,lt=a(),h(de.$$.fragment),dt=a(),ce=d("p"),ce.textContent=go,ct=a(),me=d("ul"),me.innerHTML=fo,mt=a(),pe=d("p"),pe.textContent=uo,pt=a(),h(he.$$.fragment),ht=a(),x=d("div"),h(ge.$$.fragment),zt=a(),Se=d("p"),Se.innerHTML=_o,kt=a(),We=d("p"),We.innerHTML=To,jt=a(),h(B.$$.fragment),It=a(),L=d("div"),h(fe.$$.fragment),Jt=a(),Ze=d("p"),Ze.innerHTML=bo,gt=a(),h(ue.$$.fragment),ft=a(),U=d("div"),h(_e.$$.fragment),Ft=a(),N=d("div"),h(Te.$$.fragment),Ut=a(),Be=d("p"),Be.textContent=yo,Et=a(),H=d("div"),h(be.$$.fragment),Rt=a(),Le=d("p"),Le.innerHTML=vo,ut=a(),h(ye.$$.fragment),_t=a(),C=d("div"),h(ve.$$.fragment),St=a(),Ne=d("p"),Ne.textContent=wo,Wt=a(),V=d("div"),h(we.$$.fragment),Zt=a(),He=d("p"),He.textContent=$o,Bt=a(),G=d("div"),h($e.$$.fragment),Lt=a(),Ve=d("p"),Ve.innerHTML=Mo,Tt=a(),h(Me.$$.fragment),bt=a(),E=d("div"),h(Pe.$$.fragment),Nt=a(),Ge=d("p"),Ge.innerHTML=Po,Ht=a(),I=d("div"),h(xe.$$.fragment),Vt=a(),qe=d("p"),qe.innerHTML=xo,Gt=a(),h(q.$$.fragment),qt=a(),h(A.$$.fragment),yt=a(),h(De.$$.fragment),vt=a(),z=d("div"),h(Ce.$$.fragment),At=a(),Ae=d("p"),Ae.textContent=Do,Xt=a(),Xe=d("p"),Xe.innerHTML=Co,Yt=a(),J=d("div"),h(ze.$$.fragment),Qt=a(),Ye=d("p"),Ye.innerHTML=zo,Ot=a(),h(X.$$.fragment),Kt=a(),h(Y.$$.fragment),wt=a(),h(ke.$$.fragment),$t=a(),k=d("div"),h(je.$$.fragment),eo=a(),Qe=d("p"),Qe.textContent=ko,to=a(),Oe=d("p"),Oe.innerHTML=jo,oo=a(),F=d("div"),h(Ie.$$.fragment),no=a(),Ke=d("p"),Ke.innerHTML=Io,so=a(),h(Q.$$.fragment),ao=a(),h(O.$$.fragment),Mt=a(),tt=d("p"),this.h()},l(e){const o=So("svelte-u9bgzb",document.head);n=c(o,"META",{name:!0,content:!0}),o.forEach(t),v=r(e),m=c(e,"P",{}),P(m).forEach(t),p=r(e),g(y.$$.fragment,e),s=r(e),g(w.$$.fragment,e),ot=r(e),se=c(e,"P",{"data-svelte-h":!0}),b(se)!=="svelte-19gxegr"&&(se.innerHTML=io),nt=r(e),ae=c(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-vfdo9a"&&(ae.textContent=lo),st=r(e),re=c(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-17tgro5"&&(re.innerHTML=co),at=r(e),Z=c(e,"IMG",{src:!0,alt:!0,width:!0}),rt=r(e),ie=c(e,"SMALL",{"data-svelte-h":!0}),b(ie)!=="svelte-6ly4vl"&&(ie.innerHTML=po),it=r(e),le=c(e,"P",{"data-svelte-h":!0}),b(le)!=="svelte-d1d7zy"&&(le.innerHTML=ho),lt=r(e),g(de.$$.fragment,e),dt=r(e),ce=c(e,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-1b0rfkj"&&(ce.textContent=go),ct=r(e),me=c(e,"UL",{"data-svelte-h":!0}),b(me)!=="svelte-iuvzwu"&&(me.innerHTML=fo),mt=r(e),pe=c(e,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-1xesile"&&(pe.textContent=uo),pt=r(e),g(he.$$.fragment,e),ht=r(e),x=c(e,"DIV",{class:!0});var j=P(x);g(ge.$$.fragment,j),zt=r(j),Se=c(j,"P",{"data-svelte-h":!0}),b(Se)!=="svelte-i9m39y"&&(Se.innerHTML=_o),kt=r(j),We=c(j,"P",{"data-svelte-h":!0}),b(We)!=="svelte-1e2so1n"&&(We.innerHTML=To),jt=r(j),g(B.$$.fragment,j),It=r(j),L=c(j,"DIV",{class:!0});var Je=P(L);g(fe.$$.fragment,Je),Jt=r(Je),Ze=c(Je,"P",{"data-svelte-h":!0}),b(Ze)!=="svelte-5ih1xd"&&(Ze.innerHTML=bo),Je.forEach(t),j.forEach(t),gt=r(e),g(ue.$$.fragment,e),ft=r(e),U=c(e,"DIV",{class:!0});var S=P(U);g(_e.$$.fragment,S),Ft=r(S),N=c(S,"DIV",{class:!0});var Fe=P(N);g(Te.$$.fragment,Fe),Ut=r(Fe),Be=c(Fe,"P",{"data-svelte-h":!0}),b(Be)!=="svelte-khengj"&&(Be.textContent=yo),Fe.forEach(t),Et=r(S),H=c(S,"DIV",{class:!0});var Ue=P(H);g(be.$$.fragment,Ue),Rt=r(Ue),Le=c(Ue,"P",{"data-svelte-h":!0}),b(Le)!=="svelte-c58b5z"&&(Le.innerHTML=vo),Ue.forEach(t),S.forEach(t),ut=r(e),g(ye.$$.fragment,e),_t=r(e),C=c(e,"DIV",{class:!0});var R=P(C);g(ve.$$.fragment,R),St=r(R),Ne=c(R,"P",{"data-svelte-h":!0}),b(Ne)!=="svelte-oc8yhy"&&(Ne.textContent=wo),Wt=r(R),V=c(R,"DIV",{class:!0});var Ee=P(V);g(we.$$.fragment,Ee),Zt=r(Ee),He=c(Ee,"P",{"data-svelte-h":!0}),b(He)!=="svelte-1x3yxsa"&&(He.textContent=$o),Ee.forEach(t),Bt=r(R),G=c(R,"DIV",{class:!0});var xt=P(G);g($e.$$.fragment,xt),Lt=r(xt),Ve=c(xt,"P",{"data-svelte-h":!0}),b(Ve)!=="svelte-c58b5z"&&(Ve.innerHTML=Mo),xt.forEach(t),R.forEach(t),Tt=r(e),g(Me.$$.fragment,e),bt=r(e),E=c(e,"DIV",{class:!0});var et=P(E);g(Pe.$$.fragment,et),Nt=r(et),Ge=c(et,"P",{"data-svelte-h":!0}),b(Ge)!=="svelte-s1wkj9"&&(Ge.innerHTML=Po),Ht=r(et),I=c(et,"DIV",{class:!0});var K=P(I);g(xe.$$.fragment,K),Vt=r(K),qe=c(K,"P",{"data-svelte-h":!0}),b(qe)!=="svelte-1x6rw4w"&&(qe.innerHTML=xo),Gt=r(K),g(q.$$.fragment,K),qt=r(K),g(A.$$.fragment,K),K.forEach(t),et.forEach(t),yt=r(e),g(De.$$.fragment,e),vt=r(e),z=c(e,"DIV",{class:!0});var ee=P(z);g(Ce.$$.fragment,ee),At=r(ee),Ae=c(ee,"P",{"data-svelte-h":!0}),b(Ae)!=="svelte-1w35xhv"&&(Ae.textContent=Do),Xt=r(ee),Xe=c(ee,"P",{"data-svelte-h":!0}),b(Xe)!=="svelte-1gjh92c"&&(Xe.innerHTML=Co),Yt=r(ee),J=c(ee,"DIV",{class:!0});var te=P(J);g(ze.$$.fragment,te),Qt=r(te),Ye=c(te,"P",{"data-svelte-h":!0}),b(Ye)!=="svelte-19uwwa"&&(Ye.innerHTML=zo),Ot=r(te),g(X.$$.fragment,te),Kt=r(te),g(Y.$$.fragment,te),te.forEach(t),ee.forEach(t),wt=r(e),g(ke.$$.fragment,e),$t=r(e),k=c(e,"DIV",{class:!0});var oe=P(k);g(je.$$.fragment,oe),eo=r(oe),Qe=c(oe,"P",{"data-svelte-h":!0}),b(Qe)!=="svelte-a7kv1k"&&(Qe.textContent=ko),to=r(oe),Oe=c(oe,"P",{"data-svelte-h":!0}),b(Oe)!=="svelte-1gjh92c"&&(Oe.innerHTML=jo),oo=r(oe),F=c(oe,"DIV",{class:!0});var ne=P(F);g(Ie.$$.fragment,ne),no=r(ne),Ke=c(ne,"P",{"data-svelte-h":!0}),b(Ke)!=="svelte-1dnmrw4"&&(Ke.innerHTML=Io),so=r(ne),g(Q.$$.fragment,ne),ao=r(ne),g(O.$$.fragment,ne),ne.forEach(t),oe.forEach(t),Mt=r(e),tt=c(e,"P",{}),P(tt).forEach(t),this.h()},h(){$(n,"name","hf:doc:metadata"),$(n,"content",qo),Fo(Z.src,mo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/dpt_architecture.jpg")||$(Z,"src",mo),$(Z,"alt","drawing"),$(Z,"width","600"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){i(document.head,n),l(e,v,o),l(e,m,o),l(e,p,o),f(y,e,o),l(e,s,o),f(w,e,o),l(e,ot,o),l(e,se,o),l(e,nt,o),l(e,ae,o),l(e,st,o),l(e,re,o),l(e,at,o),l(e,Z,o),l(e,rt,o),l(e,ie,o),l(e,it,o),l(e,le,o),l(e,lt,o),f(de,e,o),l(e,dt,o),l(e,ce,o),l(e,ct,o),l(e,me,o),l(e,mt,o),l(e,pe,o),l(e,pt,o),f(he,e,o),l(e,ht,o),l(e,x,o),f(ge,x,null),i(x,zt),i(x,Se),i(x,kt),i(x,We),i(x,jt),f(B,x,null),i(x,It),i(x,L),f(fe,L,null),i(L,Jt),i(L,Ze),l(e,gt,o),f(ue,e,o),l(e,ft,o),l(e,U,o),f(_e,U,null),i(U,Ft),i(U,N),f(Te,N,null),i(N,Ut),i(N,Be),i(U,Et),i(U,H),f(be,H,null),i(H,Rt),i(H,Le),l(e,ut,o),f(ye,e,o),l(e,_t,o),l(e,C,o),f(ve,C,null),i(C,St),i(C,Ne),i(C,Wt),i(C,V),f(we,V,null),i(V,Zt),i(V,He),i(C,Bt),i(C,G),f($e,G,null),i(G,Lt),i(G,Ve),l(e,Tt,o),f(Me,e,o),l(e,bt,o),l(e,E,o),f(Pe,E,null),i(E,Nt),i(E,Ge),i(E,Ht),i(E,I),f(xe,I,null),i(I,Vt),i(I,qe),i(I,Gt),f(q,I,null),i(I,qt),f(A,I,null),l(e,yt,o),f(De,e,o),l(e,vt,o),l(e,z,o),f(Ce,z,null),i(z,At),i(z,Ae),i(z,Xt),i(z,Xe),i(z,Yt),i(z,J),f(ze,J,null),i(J,Qt),i(J,Ye),i(J,Ot),f(X,J,null),i(J,Kt),f(Y,J,null),l(e,wt,o),f(ke,e,o),l(e,$t,o),l(e,k,o),f(je,k,null),i(k,eo),i(k,Qe),i(k,to),i(k,Oe),i(k,oo),i(k,F),f(Ie,F,null),i(F,no),i(F,Ke),i(F,so),f(Q,F,null),i(F,ao),f(O,F,null),l(e,Mt,o),l(e,tt,o),Pt=!0},p(e,[o]){const j={};o&2&&(j.$$scope={dirty:o,ctx:e}),B.$set(j);const Je={};o&2&&(Je.$$scope={dirty:o,ctx:e}),q.$set(Je);const S={};o&2&&(S.$$scope={dirty:o,ctx:e}),A.$set(S);const Fe={};o&2&&(Fe.$$scope={dirty:o,ctx:e}),X.$set(Fe);const Ue={};o&2&&(Ue.$$scope={dirty:o,ctx:e}),Y.$set(Ue);const R={};o&2&&(R.$$scope={dirty:o,ctx:e}),Q.$set(R);const Ee={};o&2&&(Ee.$$scope={dirty:o,ctx:e}),O.$set(Ee)},i(e){Pt||(u(y.$$.fragment,e),u(w.$$.fragment,e),u(de.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(B.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(_e.$$.fragment,e),u(Te.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(ve.$$.fragment,e),u(we.$$.fragment,e),u($e.$$.fragment,e),u(Me.$$.fragment,e),u(Pe.$$.fragment,e),u(xe.$$.fragment,e),u(q.$$.fragment,e),u(A.$$.fragment,e),u(De.$$.fragment,e),u(Ce.$$.fragment,e),u(ze.$$.fragment,e),u(X.$$.fragment,e),u(Y.$$.fragment,e),u(ke.$$.fragment,e),u(je.$$.fragment,e),u(Ie.$$.fragment,e),u(Q.$$.fragment,e),u(O.$$.fragment,e),Pt=!0)},o(e){_(y.$$.fragment,e),_(w.$$.fragment,e),_(de.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(B.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(Te.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(ve.$$.fragment,e),_(we.$$.fragment,e),_($e.$$.fragment,e),_(Me.$$.fragment,e),_(Pe.$$.fragment,e),_(xe.$$.fragment,e),_(q.$$.fragment,e),_(A.$$.fragment,e),_(De.$$.fragment,e),_(Ce.$$.fragment,e),_(ze.$$.fragment,e),_(X.$$.fragment,e),_(Y.$$.fragment,e),_(ke.$$.fragment,e),_(je.$$.fragment,e),_(Ie.$$.fragment,e),_(Q.$$.fragment,e),_(O.$$.fragment,e),Pt=!1},d(e){e&&(t(v),t(m),t(p),t(s),t(ot),t(se),t(nt),t(ae),t(st),t(re),t(at),t(Z),t(rt),t(ie),t(it),t(le),t(lt),t(dt),t(ce),t(ct),t(me),t(mt),t(pe),t(pt),t(ht),t(x),t(gt),t(ft),t(U),t(ut),t(_t),t(C),t(Tt),t(bt),t(E),t(yt),t(vt),t(z),t(wt),t($t),t(k),t(Mt),t(tt)),t(n),T(y,e),T(w,e),T(de,e),T(he,e),T(ge),T(B),T(fe),T(ue,e),T(_e),T(Te),T(be),T(ye,e),T(ve),T(we),T($e),T(Me,e),T(Pe),T(xe),T(q),T(A),T(De,e),T(Ce),T(ze),T(X),T(Y),T(ke,e),T(je),T(Ie),T(Q),T(O)}}}const qo='{"title":"DPT","local":"dpt","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"DPTConfig","local":"transformers.DPTConfig","sections":[],"depth":2},{"title":"DPTFeatureExtractor","local":"transformers.DPTFeatureExtractor","sections":[],"depth":2},{"title":"DPTImageProcessor","local":"transformers.DPTImageProcessor","sections":[],"depth":2},{"title":"DPTModel","local":"transformers.DPTModel","sections":[],"depth":2},{"title":"DPTForDepthEstimation","local":"transformers.DPTForDepthEstimation","sections":[],"depth":2},{"title":"DPTForSemanticSegmentation","local":"transformers.DPTForSemanticSegmentation","sections":[],"depth":2}],"depth":1}';function Ao(M){return Uo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class on extends Eo{constructor(n){super(),Ro(this,n,Ao,Go,Jo,{})}}export{on as component};
