import{s as Ke,n as Oe,o as es}from"../chunks/scheduler.182ea377.js";import{S as ss,i as ls,g as o,s as n,r as p,A as ts,h as i,f as l,c as a,j as Fe,u,x as r,k as Le,y as ns,a as t,v as h,d as M,t as c,w as b}from"../chunks/index.abf12888.js";import{C as m}from"../chunks/CodeBlock.57fe6e13.js";import{D as as}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as L}from"../chunks/Heading.16916d63.js";function os(Ge){let J,K,P,O,T,ee,f,se,d,Ve='🤗 Diffusers provides a <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin">PushToHubMixin</a> for uploading your model, scheduler, or pipeline to the Hub. It is an easy way to store your files on the Hub, and also allows you to share your work with others. Under the hood, the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin">PushToHubMixin</a>:',le,y,De="<li>creates a repository on the Hub</li> <li>saves your model, scheduler, or pipeline files so they can be reloaded later</li> <li>uploads folder containing these files to the Hub</li>",te,w,Ee='This guide will show you how to use the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin">PushToHubMixin</a> to upload your files to the Hub.',ne,j,Xe='You’ll need to log in to your Hub account with your access <a href="https://huggingface.co/settings/tokens" rel="nofollow">token</a> first:',ae,I,oe,U,ie,_,Ne='To push a model to the Hub, call <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> and specify the repository id of the model to be stored on the Hub:',pe,v,ue,k,Re='For models, you can also specify the <a href="loading#checkpoint-variants"><em>variant</em></a> of the weights to push to the Hub. For example, to push <code>fp16</code> weights:',re,B,he,Z,We='The <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function saves the model’s <code>config.json</code> file and the weights are automatically saved in the <code>safetensors</code> format.',Me,g,He="Now you can reload the model from your repository on the Hub:",ce,$,be,C,me,G,xe='To push a scheduler to the Hub, call <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> and specify the repository id of the scheduler to be stored on the Hub:',Je,V,Te,D,Ye='The <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function saves the scheduler’s <code>scheduler_config.json</code> file to the specified repository.',fe,E,ze="Now you can reload the scheduler from your repository on the Hub:",de,X,ye,N,we,R,Qe='You can also push an entire pipeline with all it’s components to the Hub. For example, initialize the components of a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> with the parameters you want:',je,W,Ie,H,Se='Pass all of the components to the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> and call <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to push the pipeline to the Hub:',Ue,x,_e,Y,Ae='The <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function saves each component to a subfolder in the repository. Now you can reload the pipeline from your repository on the Hub:',ve,z,ke,Q,Be,S,qe='Set <code>private=True</code> in the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function to keep your model, scheduler, or pipeline files private:',Ze,A,ge,q,Pe='Private repositories are only visible to you, and other users won’t be able to clone the repository and your repository won’t appear in search results. Even if a user has the URL to your private repository, they’ll receive a <code>404 - Sorry, we can&#39;t find the page you are looking for</code>. You must be <a href="https://huggingface.co/docs/huggingface_hub/quick-start#login" rel="nofollow">logged in</a> to load a model from a private repository.',$e,F,Ce;return T=new L({props:{title:"Push files to the Hub",local:"push-files-to-the-hub",headingTag:"h1"}}),f=new as({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/push_to_hub.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/push_to_hub.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/push_to_hub.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/push_to_hub.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/push_to_hub.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/push_to_hub.ipynb"}]}}),I=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),U=new L({props:{title:"Models",local:"models",headingTag:"h2"}}),v=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbnRyb2xOZXRNb2RlbCUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwoJTBBJTIwJTIwJTIwJTIwYmxvY2tfb3V0X2NoYW5uZWxzJTNEKDMyJTJDJTIwNjQpJTJDJTBBJTIwJTIwJTIwJTIwbGF5ZXJzX3Blcl9ibG9jayUzRDIlMkMlMEElMjAlMjAlMjAlMjBpbl9jaGFubmVscyUzRDQlMkMlMEElMjAlMjAlMjAlMjBkb3duX2Jsb2NrX3R5cGVzJTNEKCUyMkRvd25CbG9jazJEJTIyJTJDJTIwJTIyQ3Jvc3NBdHRuRG93bkJsb2NrMkQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwY3Jvc3NfYXR0ZW50aW9uX2RpbSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwY29uZGl0aW9uaW5nX2VtYmVkZGluZ19vdXRfY2hhbm5lbHMlM0QoMTYlMkMlMjAzMiklMkMlMEEpJTBBY29udHJvbG5ldC5wdXNoX3RvX2h1YiglMjJteS1jb250cm9sbmV0LW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel

controlnet = ControlNetModel(
    block_out_channels=(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>),
    layers_per_block=<span class="hljs-number">2</span>,
    in_channels=<span class="hljs-number">4</span>,
    down_block_types=(<span class="hljs-string">&quot;DownBlock2D&quot;</span>, <span class="hljs-string">&quot;CrossAttnDownBlock2D&quot;</span>),
    cross_attention_dim=<span class="hljs-number">32</span>,
    conditioning_embedding_out_channels=(<span class="hljs-number">16</span>, <span class="hljs-number">32</span>),
)
controlnet.push_to_hub(<span class="hljs-string">&quot;my-controlnet-model&quot;</span>)`,wrap:!1}}),B=new m({props:{code:"Y29udHJvbG5ldC5wdXNoX3RvX2h1YiglMjJteS1jb250cm9sbmV0LW1vZGVsJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIp",highlighted:'controlnet.push_to_hub(<span class="hljs-string">&quot;my-controlnet-model&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)',wrap:!1}}),$=new m({props:{code:"bW9kZWwlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnlvdXItbmFtZXNwYWNlJTJGbXktY29udHJvbG5ldC1tb2RlbCUyMik=",highlighted:'model = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;your-namespace/my-controlnet-model&quot;</span>)',wrap:!1}}),C=new L({props:{title:"Scheduler",local:"scheduler",headingTag:"h2"}}),V=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1TY2hlZHVsZXIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMGJldGFfc3RhcnQlM0QwLjAwMDg1JTJDJTBBJTIwJTIwJTIwJTIwYmV0YV9lbmQlM0QwLjAxMiUyQyUwQSUyMCUyMCUyMCUyMGJldGFfc2NoZWR1bGUlM0QlMjJzY2FsZWRfbGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9zYW1wbGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHNldF9hbHBoYV90b19vbmUlM0RGYWxzZSUyQyUwQSklMEFzY2hlZHVsZXIucHVzaF90b19odWIoJTIybXktY29udHJvbG5ldC1zY2hlZHVsZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler

scheduler = DDIMScheduler(
    beta_start=<span class="hljs-number">0.00085</span>,
    beta_end=<span class="hljs-number">0.012</span>,
    beta_schedule=<span class="hljs-string">&quot;scaled_linear&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    set_alpha_to_one=<span class="hljs-literal">False</span>,
)
scheduler.push_to_hub(<span class="hljs-string">&quot;my-controlnet-scheduler&quot;</span>)`,wrap:!1}}),X=new m({props:{code:"c2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci1uYW1lcHNhY2UlMkZteS1jb250cm9sbmV0LXNjaGVkdWxlciUyMik=",highlighted:'scheduler = DDIMScheduler.from_pretrained(<span class="hljs-string">&quot;your-namepsace/my-controlnet-scheduler&quot;</span>)',wrap:!1}}),N=new L({props:{title:"Pipeline",local:"pipeline",headingTag:"h2"}}),W=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    UNet2DConditionModel,
    AutoencoderKL,
    DDIMScheduler,
    StableDiffusionPipeline,
)
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTextModel, CLIPTextConfig, CLIPTokenizer

unet = UNet2DConditionModel(
    block_out_channels=(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>),
    layers_per_block=<span class="hljs-number">2</span>,
    sample_size=<span class="hljs-number">32</span>,
    in_channels=<span class="hljs-number">4</span>,
    out_channels=<span class="hljs-number">4</span>,
    down_block_types=(<span class="hljs-string">&quot;DownBlock2D&quot;</span>, <span class="hljs-string">&quot;CrossAttnDownBlock2D&quot;</span>),
    up_block_types=(<span class="hljs-string">&quot;CrossAttnUpBlock2D&quot;</span>, <span class="hljs-string">&quot;UpBlock2D&quot;</span>),
    cross_attention_dim=<span class="hljs-number">32</span>,
)

scheduler = DDIMScheduler(
    beta_start=<span class="hljs-number">0.00085</span>,
    beta_end=<span class="hljs-number">0.012</span>,
    beta_schedule=<span class="hljs-string">&quot;scaled_linear&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    set_alpha_to_one=<span class="hljs-literal">False</span>,
)

vae = AutoencoderKL(
    block_out_channels=[<span class="hljs-number">32</span>, <span class="hljs-number">64</span>],
    in_channels=<span class="hljs-number">3</span>,
    out_channels=<span class="hljs-number">3</span>,
    down_block_types=[<span class="hljs-string">&quot;DownEncoderBlock2D&quot;</span>, <span class="hljs-string">&quot;DownEncoderBlock2D&quot;</span>],
    up_block_types=[<span class="hljs-string">&quot;UpDecoderBlock2D&quot;</span>, <span class="hljs-string">&quot;UpDecoderBlock2D&quot;</span>],
    latent_channels=<span class="hljs-number">4</span>,
)

text_encoder_config = CLIPTextConfig(
    bos_token_id=<span class="hljs-number">0</span>,
    eos_token_id=<span class="hljs-number">2</span>,
    hidden_size=<span class="hljs-number">32</span>,
    intermediate_size=<span class="hljs-number">37</span>,
    layer_norm_eps=<span class="hljs-number">1e-05</span>,
    num_attention_heads=<span class="hljs-number">4</span>,
    num_hidden_layers=<span class="hljs-number">5</span>,
    pad_token_id=<span class="hljs-number">1</span>,
    vocab_size=<span class="hljs-number">1000</span>,
)
text_encoder = CLIPTextModel(text_encoder_config)
tokenizer = CLIPTokenizer.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/tiny-random-clip&quot;</span>)`,wrap:!1}}),x=new m({props:{code:"Y29tcG9uZW50cyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnVuZXQlMjIlM0ElMjB1bmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwc2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwJTIydmFlJTIyJTNBJTIwdmFlJTJDJTBBJTIwJTIwJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwdGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwJTIydG9rZW5pemVyJTIyJTNBJTIwdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIyc2FmZXR5X2NoZWNrZXIlMjIlM0ElMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjBOb25lJTJDJTBBJTdEJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSgqKmNvbXBvbmVudHMpJTBBcGlwZWxpbmUucHVzaF90b19odWIoJTIybXktcGlwZWxpbmUlMjIp",highlighted:`components = {
    <span class="hljs-string">&quot;unet&quot;</span>: unet,
    <span class="hljs-string">&quot;scheduler&quot;</span>: scheduler,
    <span class="hljs-string">&quot;vae&quot;</span>: vae,
    <span class="hljs-string">&quot;text_encoder&quot;</span>: text_encoder,
    <span class="hljs-string">&quot;tokenizer&quot;</span>: tokenizer,
    <span class="hljs-string">&quot;safety_checker&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;feature_extractor&quot;</span>: <span class="hljs-literal">None</span>,
}

pipeline = StableDiffusionPipeline(**components)
pipeline.push_to_hub(<span class="hljs-string">&quot;my-pipeline&quot;</span>)`,wrap:!1}}),z=new m({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci1uYW1lc3BhY2UlMkZteS1waXBlbGluZSUyMik=",highlighted:'pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;your-namespace/my-pipeline&quot;</span>)',wrap:!1}}),Q=new L({props:{title:"Privacy",local:"privacy",headingTag:"h2"}}),A=new m({props:{code:"Y29udHJvbG5ldC5wdXNoX3RvX2h1YiglMjJteS1jb250cm9sbmV0LW1vZGVsLXByaXZhdGUlMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:'controlnet.push_to_hub(<span class="hljs-string">&quot;my-controlnet-model-private&quot;</span>, private=<span class="hljs-literal">True</span>)',wrap:!1}}),{c(){J=o("meta"),K=n(),P=o("p"),O=n(),p(T.$$.fragment),ee=n(),p(f.$$.fragment),se=n(),d=o("p"),d.innerHTML=Ve,le=n(),y=o("ol"),y.innerHTML=De,te=n(),w=o("p"),w.innerHTML=Ee,ne=n(),j=o("p"),j.innerHTML=Xe,ae=n(),p(I.$$.fragment),oe=n(),p(U.$$.fragment),ie=n(),_=o("p"),_.innerHTML=Ne,pe=n(),p(v.$$.fragment),ue=n(),k=o("p"),k.innerHTML=Re,re=n(),p(B.$$.fragment),he=n(),Z=o("p"),Z.innerHTML=We,Me=n(),g=o("p"),g.textContent=He,ce=n(),p($.$$.fragment),be=n(),p(C.$$.fragment),me=n(),G=o("p"),G.innerHTML=xe,Je=n(),p(V.$$.fragment),Te=n(),D=o("p"),D.innerHTML=Ye,fe=n(),E=o("p"),E.textContent=ze,de=n(),p(X.$$.fragment),ye=n(),p(N.$$.fragment),we=n(),R=o("p"),R.innerHTML=Qe,je=n(),p(W.$$.fragment),Ie=n(),H=o("p"),H.innerHTML=Se,Ue=n(),p(x.$$.fragment),_e=n(),Y=o("p"),Y.innerHTML=Ae,ve=n(),p(z.$$.fragment),ke=n(),p(Q.$$.fragment),Be=n(),S=o("p"),S.innerHTML=qe,Ze=n(),p(A.$$.fragment),ge=n(),q=o("p"),q.innerHTML=Pe,$e=n(),F=o("p"),this.h()},l(e){const s=ts("svelte-u9bgzb",document.head);J=i(s,"META",{name:!0,content:!0}),s.forEach(l),K=a(e),P=i(e,"P",{}),Fe(P).forEach(l),O=a(e),u(T.$$.fragment,e),ee=a(e),u(f.$$.fragment,e),se=a(e),d=i(e,"P",{"data-svelte-h":!0}),r(d)!=="svelte-hhwa9c"&&(d.innerHTML=Ve),le=a(e),y=i(e,"OL",{"data-svelte-h":!0}),r(y)!=="svelte-11ocvlf"&&(y.innerHTML=De),te=a(e),w=i(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-zk1n3m"&&(w.innerHTML=Ee),ne=a(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1bojsgz"&&(j.innerHTML=Xe),ae=a(e),u(I.$$.fragment,e),oe=a(e),u(U.$$.fragment,e),ie=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-16p7cf"&&(_.innerHTML=Ne),pe=a(e),u(v.$$.fragment,e),ue=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1eiubrc"&&(k.innerHTML=Re),re=a(e),u(B.$$.fragment,e),he=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1szi976"&&(Z.innerHTML=We),Me=a(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1bcc50k"&&(g.textContent=He),ce=a(e),u($.$$.fragment,e),be=a(e),u(C.$$.fragment,e),me=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1gu16l3"&&(G.innerHTML=xe),Je=a(e),u(V.$$.fragment,e),Te=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1b7ix5a"&&(D.innerHTML=Ye),fe=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-rpu5q4"&&(E.textContent=ze),de=a(e),u(X.$$.fragment,e),ye=a(e),u(N.$$.fragment,e),we=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-u6kbra"&&(R.innerHTML=Qe),je=a(e),u(W.$$.fragment,e),Ie=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-u38c6b"&&(H.innerHTML=Se),Ue=a(e),u(x.$$.fragment,e),_e=a(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1p0tpje"&&(Y.innerHTML=Ae),ve=a(e),u(z.$$.fragment,e),ke=a(e),u(Q.$$.fragment,e),Be=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-uorhlp"&&(S.innerHTML=qe),Ze=a(e),u(A.$$.fragment,e),ge=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-ckklvi"&&(q.innerHTML=Pe),$e=a(e),F=i(e,"P",{}),Fe(F).forEach(l),this.h()},h(){Le(J,"name","hf:doc:metadata"),Le(J,"content",is)},m(e,s){ns(document.head,J),t(e,K,s),t(e,P,s),t(e,O,s),h(T,e,s),t(e,ee,s),h(f,e,s),t(e,se,s),t(e,d,s),t(e,le,s),t(e,y,s),t(e,te,s),t(e,w,s),t(e,ne,s),t(e,j,s),t(e,ae,s),h(I,e,s),t(e,oe,s),h(U,e,s),t(e,ie,s),t(e,_,s),t(e,pe,s),h(v,e,s),t(e,ue,s),t(e,k,s),t(e,re,s),h(B,e,s),t(e,he,s),t(e,Z,s),t(e,Me,s),t(e,g,s),t(e,ce,s),h($,e,s),t(e,be,s),h(C,e,s),t(e,me,s),t(e,G,s),t(e,Je,s),h(V,e,s),t(e,Te,s),t(e,D,s),t(e,fe,s),t(e,E,s),t(e,de,s),h(X,e,s),t(e,ye,s),h(N,e,s),t(e,we,s),t(e,R,s),t(e,je,s),h(W,e,s),t(e,Ie,s),t(e,H,s),t(e,Ue,s),h(x,e,s),t(e,_e,s),t(e,Y,s),t(e,ve,s),h(z,e,s),t(e,ke,s),h(Q,e,s),t(e,Be,s),t(e,S,s),t(e,Ze,s),h(A,e,s),t(e,ge,s),t(e,q,s),t(e,$e,s),t(e,F,s),Ce=!0},p:Oe,i(e){Ce||(M(T.$$.fragment,e),M(f.$$.fragment,e),M(I.$$.fragment,e),M(U.$$.fragment,e),M(v.$$.fragment,e),M(B.$$.fragment,e),M($.$$.fragment,e),M(C.$$.fragment,e),M(V.$$.fragment,e),M(X.$$.fragment,e),M(N.$$.fragment,e),M(W.$$.fragment,e),M(x.$$.fragment,e),M(z.$$.fragment,e),M(Q.$$.fragment,e),M(A.$$.fragment,e),Ce=!0)},o(e){c(T.$$.fragment,e),c(f.$$.fragment,e),c(I.$$.fragment,e),c(U.$$.fragment,e),c(v.$$.fragment,e),c(B.$$.fragment,e),c($.$$.fragment,e),c(C.$$.fragment,e),c(V.$$.fragment,e),c(X.$$.fragment,e),c(N.$$.fragment,e),c(W.$$.fragment,e),c(x.$$.fragment,e),c(z.$$.fragment,e),c(Q.$$.fragment,e),c(A.$$.fragment,e),Ce=!1},d(e){e&&(l(K),l(P),l(O),l(ee),l(se),l(d),l(le),l(y),l(te),l(w),l(ne),l(j),l(ae),l(oe),l(ie),l(_),l(pe),l(ue),l(k),l(re),l(he),l(Z),l(Me),l(g),l(ce),l(be),l(me),l(G),l(Je),l(Te),l(D),l(fe),l(E),l(de),l(ye),l(we),l(R),l(je),l(Ie),l(H),l(Ue),l(_e),l(Y),l(ve),l(ke),l(Be),l(S),l(Ze),l(ge),l(q),l($e),l(F)),l(J),b(T,e),b(f,e),b(I,e),b(U,e),b(v,e),b(B,e),b($,e),b(C,e),b(V,e),b(X,e),b(N,e),b(W,e),b(x,e),b(z,e),b(Q,e),b(A,e)}}}const is='{"title":"Push files to the Hub","local":"push-files-to-the-hub","sections":[{"title":"Models","local":"models","sections":[],"depth":2},{"title":"Scheduler","local":"scheduler","sections":[],"depth":2},{"title":"Pipeline","local":"pipeline","sections":[],"depth":2},{"title":"Privacy","local":"privacy","sections":[],"depth":2}],"depth":1}';function ps(Ge){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends ss{constructor(J){super(),ls(this,J,ps,os,Ke,{})}}export{bs as component};
