import{s as $t,A as Bt,o as kt,n as Le}from"../chunks/scheduler.01eeda35.js";import{S as Wt,i as Ct,g as r,s as a,r as m,A as Zt,h as p,f as n,c as o,j as fe,u as g,x as d,k as C,y as w,a as s,v as u,d as f,t as y,w as b}from"../chunks/index.6dd51b66.js";import{T as Jt}from"../chunks/Tip.de9bae2b.js";import{D as Ne}from"../chunks/Docstring.76e6b3cf.js";import{C as Ye}from"../chunks/CodeBlock.864da1b0.js";import{E as vt}from"../chunks/ExampleCodeBlock.6a36fb6b.js";import{H as R,E as Ut}from"../chunks/EditOnGithub.7faefd25.js";function Gt(W){let l,M='<a href="depth_anything_v2">Depth Anything V2</a> was released in June 2024. It uses the same architecture as Depth Anything and therefore it is compatible with all code examples and existing workflows. However, it leverages synthetic data and a larger capacity teacher model to achieve much finer and robust depth predictions.';return{c(){l=r("p"),l.innerHTML=M},l(h){l=p(h,"P",{"data-svelte-h":!0}),d(l)!=="svelte-1s2kjzv"&&(l.innerHTML=M)},m(h,c){s(h,l,c)},p:Le,d(h){h&&n(l)}}}function It(W){let l,M="Example:",h,c,_;return c=new Ye({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoQW55dGhpbmdDb25maWclMkMlMjBEZXB0aEFueXRoaW5nRm9yRGVwdGhFc3RpbWF0aW9uJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMERlcHRoQW55dGhpbmclMjBzbWFsbCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBEZXB0aEFueXRoaW5nQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwRGVwdGhBbnl0aGluZyUyMHNtYWxsJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEZXB0aEFueXRoaW5nRm9yRGVwdGhFc3RpbWF0aW9uKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthAnythingConfig, DepthAnythingForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DepthAnything small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DepthAnythingConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the DepthAnything small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthAnythingForDepthEstimation(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=r("p"),l.textContent=M,h=a(),m(c.$$.fragment)},l(i){l=p(i,"P",{"data-svelte-h":!0}),d(l)!=="svelte-11lpom8"&&(l.textContent=M),h=o(i),g(c.$$.fragment,i)},m(i,T){s(i,l,T),s(i,h,T),u(c,i,T),_=!0},p:Le,i(i){_||(f(c.$$.fragment,i),_=!0)},o(i){y(c.$$.fragment,i),_=!1},d(i){i&&(n(l),n(h)),b(c,i)}}}function At(W){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=r("p"),l.innerHTML=M},l(h){l=p(h,"P",{"data-svelte-h":!0}),d(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(h,c){s(h,l,c)},p:Le,d(h){h&&n(l)}}}function xt(W){let l,M="Examples:",h,c,_;return c=new Ye({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJMaWhlWW91bmclMkZkZXB0aC1hbnl0aGluZy1zbWFsbC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyTGloZVlvdW5nJTJGZGVwdGgtYW55dGhpbmctc21hbGwtaGYlMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUwQXBvc3RfcHJvY2Vzc2VkX291dHB1dCUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wb3N0X3Byb2Nlc3NfZGVwdGhfZXN0aW1hdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X3NpemVzJTNEJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSU1RCUyQyUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTVCMCU1RCU1QiUyMnByZWRpY3RlZF9kZXB0aCUyMiU1RCUwQWRlcHRoJTIwJTNEJTIwcHJlZGljdGVkX2RlcHRoJTIwKiUyMDI1NSUyMCUyRiUyMHByZWRpY3RlZF9kZXB0aC5tYXgoKSUwQWRlcHRoJTIwJTNEJTIwZGVwdGguZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUwQWRlcHRoJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGRlcHRoLmFzdHlwZSglMjJ1aW50OCUyMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = predicted_depth * <span class="hljs-number">255</span> / predicted_depth.<span class="hljs-built_in">max</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),{c(){l=r("p"),l.textContent=M,h=a(),m(c.$$.fragment)},l(i){l=p(i,"P",{"data-svelte-h":!0}),d(l)!=="svelte-kvfsh7"&&(l.textContent=M),h=o(i),g(c.$$.fragment,i)},m(i,T){s(i,l,T),s(i,h,T),u(c,i,T),_=!0},p:Le,i(i){_||(f(c.$$.fragment,i),_=!0)},o(i){y(c.$$.fragment,i),_=!1},d(i){i&&(n(l),n(h)),b(c,i)}}}function Rt(W){let l,M,h,c,_,i,T,ot='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',be,D,we,E,lt='The Depth Anything model was proposed in <a href="https://arxiv.org/abs/2401.10891" rel="nofollow">Depth Anything: Unleashing the Power of Large-Scale Unlabeled Data</a> by Lihe Yang, Bingyi Kang, Zilong Huang, Xiaogang Xu, Jiashi Feng, Hengshuang Zhao. Depth Anything is based on the <a href="dpt">DPT</a> architecture, trained on ~62 million images, obtaining state-of-the-art results for both relative and absolute depth estimation.',_e,Z,Me,F,it="The abstract from the paper is the following:",Te,z,rt="<em>This work presents Depth Anything, a highly practical solution for robust monocular depth estimation. Without pursuing novel technical modules, we aim to build a simple yet powerful foundation model dealing with any images under any circumstances. To this end, we scale up the dataset by designing a data engine to collect and automatically annotate large-scale unlabeled data (~62M), which significantly enlarges the data coverage and thus is able to reduce the generalization error. We investigate two simple yet effective strategies that make data scaling-up promising. First, a more challenging optimization target is created by leveraging data augmentation tools. It compels the model to actively seek extra visual knowledge and acquire robust representations. Second, an auxiliary supervision is developed to enforce the model to inherit rich semantic priors from pre-trained encoders. We evaluate its zero-shot capabilities extensively, including six public datasets and randomly captured photos. It demonstrates impressive generalization ability. Further, through fine-tuning it with metric depth information from NYUv2 and KITTI, new SOTAs are set. Our better depth model also results in a better depth-conditioned ControlNet.</em>",je,U,pt,Je,H,ht='Depth Anything overview. Taken from the <a href="https://arxiv.org/abs/2401.10891">original paper</a>.',ve,V,ct=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/LiheYoung/Depth-Anything" rel="nofollow">here</a>.`,$e,X,Be,N,dt="There are 2 main ways to use Depth Anything: either using the pipeline API, which abstracts away all the complexity for you, or by using the <code>DepthAnythingForDepthEstimation</code> class yourself.",ke,Y,We,L,mt="The pipeline allows to use the model in a few lines of code:",Ce,P,Ze,S,Ue,q,gt="If you want to do the pre- and postprocessing yourself, here’s how to do that:",Ge,Q,Ie,K,Ae,O,ut="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Depth Anything.",xe,ee,ft='<li><a href="../tasks/monocular_depth_estimation">Monocular depth estimation task guide</a></li> <li>A notebook showcasing inference with <a href="/docs/transformers/main/en/model_doc/depth_anything#transformers.DepthAnythingForDepthEstimation">DepthAnythingForDepthEstimation</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/Depth%20Anything/Predicting_depth_in_an_image_with_Depth_Anything.ipynb" rel="nofollow">here</a>. 🌎</li>',Re,te,yt="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",De,ne,Ee,j,se,Pe,he,bt=`This is the configuration class to store the configuration of a <code>DepthAnythingModel</code>. It is used to instantiate a DepthAnything
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the DepthAnything
<a href="https://huggingface.co/LiheYoung/depth-anything-small-hf" rel="nofollow">LiheYoung/depth-anything-small-hf</a> architecture.`,Se,ce,wt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,qe,G,Qe,I,ae,Ke,de,_t=`Serializes this instance to a Python dictionary. Override the default <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.to_dict">to_dict()</a>. Returns:
<code>Dict[str, any]</code>: Dictionary of all the attributes that make up this configuration instance,`,Fe,oe,ze,J,le,Oe,me,Mt="Depth Anything Model with a depth estimation head on top (consisting of 3 convolutional layers) e.g. for KITTI, NYUv2.",et,ge,Tt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,tt,$,ie,nt,ue,jt='The <a href="/docs/transformers/main/en/model_doc/depth_anything#transformers.DepthAnythingForDepthEstimation">DepthAnythingForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',st,A,at,x,He,re,Ve,ye,Xe;return _=new R({props:{title:"Depth Anything",local:"depth-anything",headingTag:"h1"}}),D=new R({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Z=new Jt({props:{$$slots:{default:[Gt]},$$scope:{ctx:W}}}),X=new R({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),Y=new R({props:{title:"Pipeline API",local:"pipeline-api",headingTag:"h3"}}),P=new Ye({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMjMlMjBsb2FkJTIwcGlwZSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyTGloZVlvdW5nJTJGZGVwdGgtYW55dGhpbmctc21hbGwtaGYlMjIpJTBBJTBBJTIzJTIwbG9hZCUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJ2h0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGcnJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBJTIzJTIwaW5mZXJlbmNlJTBBZGVwdGglMjAlM0QlMjBwaXBlKGltYWdlKSU1QiUyMmRlcHRoJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load pipe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>, model=<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = pipe(image)[<span class="hljs-string">&quot;depth&quot;</span>]`,wrap:!1}}),S=new R({props:{title:"Using the model yourself",local:"using-the-model-yourself",headingTag:"h3"}}),Q=new Ye({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJMaWhlWW91bmclMkZkZXB0aC1hbnl0aGluZy1zbWFsbC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyTGloZVlvdW5nJTJGZGVwdGgtYW55dGhpbmctc21hbGwtaGYlMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUyMGFuZCUyMHZpc3VhbGl6ZSUyMHRoZSUyMHByZWRpY3Rpb24lMEFwb3N0X3Byb2Nlc3NlZF9vdXRwdXQlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX2RlcHRoX2VzdGltYXRpb24oJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUzRCU1QihpbWFnZS5oZWlnaHQlMkMlMjBpbWFnZS53aWR0aCklNUQlMkMlMEEpJTBBJTBBcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTVCMCU1RCU1QiUyMnByZWRpY3RlZF9kZXB0aCUyMiU1RCUwQWRlcHRoJTIwJTNEJTIwKHByZWRpY3RlZF9kZXB0aCUyMC0lMjBwcmVkaWN0ZWRfZGVwdGgubWluKCkpJTIwJTJGJTIwKHByZWRpY3RlZF9kZXB0aC5tYXgoKSUyMC0lMjBwcmVkaWN0ZWRfZGVwdGgubWluKCkpJTBBZGVwdGglMjAlM0QlMjBkZXB0aC5kZXRhY2goKS5jcHUoKS5udW1weSgpJTIwKiUyMDI1NSUwQWRlcHRoJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGRlcHRoLmFzdHlwZSglMjJ1aW50OCUyMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size and visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = (predicted_depth - predicted_depth.<span class="hljs-built_in">min</span>()) / (predicted_depth.<span class="hljs-built_in">max</span>() - predicted_depth.<span class="hljs-built_in">min</span>())
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy() * <span class="hljs-number">255</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),K=new R({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ne=new R({props:{title:"DepthAnythingConfig",local:"transformers.DepthAnythingConfig",headingTag:"h2"}}),se=new Ne({props:{name:"class transformers.DepthAnythingConfig",anchor:"transformers.DepthAnythingConfig",parameters:[{name:"backbone_config",val:" = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"use_timm_backbone",val:" = False"},{name:"backbone_kwargs",val:" = None"},{name:"patch_size",val:" = 14"},{name:"initializer_range",val:" = 0.02"},{name:"reassemble_hidden_size",val:" = 384"},{name:"reassemble_factors",val:" = [4, 2, 1, 0.5]"},{name:"neck_hidden_sizes",val:" = [48, 96, 192, 384]"},{name:"fusion_hidden_size",val:" = 64"},{name:"head_in_index",val:" = -1"},{name:"head_hidden_size",val:" = 32"},{name:"depth_estimation_type",val:" = 'relative'"},{name:"max_depth",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DepthAnythingConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>is_hybrid</code> is <code>True</code> or in case you want to
leverage the <a href="/docs/transformers/main/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a> API.`,name:"backbone_config"},{anchor:"transformers.DepthAnythingConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.DepthAnythingConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.DepthAnythingConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the <code>timm</code> library for the backbone. If set to <code>False</code>, will use the <a href="/docs/transformers/main/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a>
API.`,name:"use_timm_backbone"},{anchor:"transformers.DepthAnythingConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.DepthAnythingConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
The size of the patches to extract from the backbone features.`,name:"patch_size"},{anchor:"transformers.DepthAnythingConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.DepthAnythingConfig.reassemble_hidden_size",description:`<strong>reassemble_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The number of input channels of the reassemble layers.`,name:"reassemble_hidden_size"},{anchor:"transformers.DepthAnythingConfig.reassemble_factors",description:`<strong>reassemble_factors</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 1, 0.5]</code>) &#x2014;
The up/downsampling factors of the reassemble layers.`,name:"reassemble_factors"},{anchor:"transformers.DepthAnythingConfig.neck_hidden_sizes",description:`<strong>neck_hidden_sizes</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[48, 96, 192, 384]</code>) &#x2014;
The hidden sizes to project to for the feature maps of the backbone.`,name:"neck_hidden_sizes"},{anchor:"transformers.DepthAnythingConfig.fusion_hidden_size",description:`<strong>fusion_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The number of channels before fusion.`,name:"fusion_hidden_size"},{anchor:"transformers.DepthAnythingConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the depth estimation head.`,name:"head_in_index"},{anchor:"transformers.DepthAnythingConfig.head_hidden_size",description:`<strong>head_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of output channels in the second convolution of the depth estimation head.`,name:"head_hidden_size"},{anchor:"transformers.DepthAnythingConfig.depth_estimation_type",description:`<strong>depth_estimation_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relative&quot;</code>) &#x2014;
The type of depth estimation to use. Can be one of <code>[&quot;relative&quot;, &quot;metric&quot;]</code>.`,name:"depth_estimation_type"},{anchor:"transformers.DepthAnythingConfig.max_depth",description:`<strong>max_depth</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The maximum depth to use for the &#x201C;metric&#x201D; depth estimation head. 20 should be used for indoor models
and 80 for outdoor models. For &#x201C;relative&#x201D; depth estimation, this value is ignored.`,name:"max_depth"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/configuration_depth_anything.py#L28"}}),G=new vt({props:{anchor:"transformers.DepthAnythingConfig.example",$$slots:{default:[It]},$$scope:{ctx:W}}}),ae=new Ne({props:{name:"to_dict",anchor:"transformers.DepthAnythingConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/configuration_depth_anything.py#L154"}}),oe=new R({props:{title:"DepthAnythingForDepthEstimation",local:"transformers.DepthAnythingForDepthEstimation",headingTag:"h2"}}),le=new Ne({props:{name:"class transformers.DepthAnythingForDepthEstimation",anchor:"transformers.DepthAnythingForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.DepthAnythingForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/depth_anything#transformers.DepthAnythingConfig">DepthAnythingConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/modeling_depth_anything.py#L362"}}),ie=new Ne({props:{name:"forward",anchor:"transformers.DepthAnythingForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DepthAnythingForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/modeling_depth_anything.py#L381",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/depth_anything#transformers.DepthAnythingConfig"
>DepthAnythingConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new Jt({props:{$$slots:{default:[At]},$$scope:{ctx:W}}}),x=new vt({props:{anchor:"transformers.DepthAnythingForDepthEstimation.forward.example",$$slots:{default:[xt]},$$scope:{ctx:W}}}),re=new Ut({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/depth_anything.md"}}),{c(){l=r("meta"),M=a(),h=r("p"),c=a(),m(_.$$.fragment),i=a(),T=r("div"),T.innerHTML=ot,be=a(),m(D.$$.fragment),we=a(),E=r("p"),E.innerHTML=lt,_e=a(),m(Z.$$.fragment),Me=a(),F=r("p"),F.textContent=it,Te=a(),z=r("p"),z.innerHTML=rt,je=a(),U=r("img"),Je=a(),H=r("small"),H.innerHTML=ht,ve=a(),V=r("p"),V.innerHTML=ct,$e=a(),m(X.$$.fragment),Be=a(),N=r("p"),N.innerHTML=dt,ke=a(),m(Y.$$.fragment),We=a(),L=r("p"),L.textContent=mt,Ce=a(),m(P.$$.fragment),Ze=a(),m(S.$$.fragment),Ue=a(),q=r("p"),q.textContent=gt,Ge=a(),m(Q.$$.fragment),Ie=a(),m(K.$$.fragment),Ae=a(),O=r("p"),O.textContent=ut,xe=a(),ee=r("ul"),ee.innerHTML=ft,Re=a(),te=r("p"),te.textContent=yt,De=a(),m(ne.$$.fragment),Ee=a(),j=r("div"),m(se.$$.fragment),Pe=a(),he=r("p"),he.innerHTML=bt,Se=a(),ce=r("p"),ce.innerHTML=wt,qe=a(),m(G.$$.fragment),Qe=a(),I=r("div"),m(ae.$$.fragment),Ke=a(),de=r("p"),de.innerHTML=_t,Fe=a(),m(oe.$$.fragment),ze=a(),J=r("div"),m(le.$$.fragment),Oe=a(),me=r("p"),me.textContent=Mt,et=a(),ge=r("p"),ge.innerHTML=Tt,tt=a(),$=r("div"),m(ie.$$.fragment),nt=a(),ue=r("p"),ue.innerHTML=jt,st=a(),m(A.$$.fragment),at=a(),m(x.$$.fragment),He=a(),m(re.$$.fragment),Ve=a(),ye=r("p"),this.h()},l(e){const t=Zt("svelte-u9bgzb",document.head);l=p(t,"META",{name:!0,content:!0}),t.forEach(n),M=o(e),h=p(e,"P",{}),fe(h).forEach(n),c=o(e),g(_.$$.fragment,e),i=o(e),T=p(e,"DIV",{class:!0,"data-svelte-h":!0}),d(T)!=="svelte-13t8s2t"&&(T.innerHTML=ot),be=o(e),g(D.$$.fragment,e),we=o(e),E=p(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-sr5hsf"&&(E.innerHTML=lt),_e=o(e),g(Z.$$.fragment,e),Me=o(e),F=p(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-vfdo9a"&&(F.textContent=it),Te=o(e),z=p(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-fbevff"&&(z.innerHTML=rt),je=o(e),U=p(e,"IMG",{src:!0,alt:!0,width:!0}),Je=o(e),H=p(e,"SMALL",{"data-svelte-h":!0}),d(H)!=="svelte-1ldczql"&&(H.innerHTML=ht),ve=o(e),V=p(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1a1ahjb"&&(V.innerHTML=ct),$e=o(e),g(X.$$.fragment,e),Be=o(e),N=p(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1ffao6h"&&(N.innerHTML=dt),ke=o(e),g(Y.$$.fragment,e),We=o(e),L=p(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1yjxirq"&&(L.textContent=mt),Ce=o(e),g(P.$$.fragment,e),Ze=o(e),g(S.$$.fragment,e),Ue=o(e),q=p(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-eza9ob"&&(q.textContent=gt),Ge=o(e),g(Q.$$.fragment,e),Ie=o(e),g(K.$$.fragment,e),Ae=o(e),O=p(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-msamn6"&&(O.textContent=ut),xe=o(e),ee=p(e,"UL",{"data-svelte-h":!0}),d(ee)!=="svelte-gkv1qe"&&(ee.innerHTML=ft),Re=o(e),te=p(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1xesile"&&(te.textContent=yt),De=o(e),g(ne.$$.fragment,e),Ee=o(e),j=p(e,"DIV",{class:!0});var v=fe(j);g(se.$$.fragment,v),Pe=o(v),he=p(v,"P",{"data-svelte-h":!0}),d(he)!=="svelte-30ivap"&&(he.innerHTML=bt),Se=o(v),ce=p(v,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-o55m63"&&(ce.innerHTML=wt),qe=o(v),g(G.$$.fragment,v),Qe=o(v),I=p(v,"DIV",{class:!0});var pe=fe(I);g(ae.$$.fragment,pe),Ke=o(pe),de=p(pe,"P",{"data-svelte-h":!0}),d(de)!=="svelte-f91b28"&&(de.innerHTML=_t),pe.forEach(n),v.forEach(n),Fe=o(e),g(oe.$$.fragment,e),ze=o(e),J=p(e,"DIV",{class:!0});var B=fe(J);g(le.$$.fragment,B),Oe=o(B),me=p(B,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1lyww6q"&&(me.textContent=Mt),et=o(B),ge=p(B,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-1gjh92c"&&(ge.innerHTML=Tt),tt=o(B),$=p(B,"DIV",{class:!0});var k=fe($);g(ie.$$.fragment,k),nt=o(k),ue=p(k,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-tvw6fn"&&(ue.innerHTML=jt),st=o(k),g(A.$$.fragment,k),at=o(k),g(x.$$.fragment,k),k.forEach(n),B.forEach(n),He=o(e),g(re.$$.fragment,e),Ve=o(e),ye=p(e,"P",{}),fe(ye).forEach(n),this.h()},h(){C(l,"name","hf:doc:metadata"),C(l,"content",Dt),C(T,"class","flex flex-wrap space-x-1"),Bt(U.src,pt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/depth_anything_overview.jpg")||C(U,"src",pt),C(U,"alt","drawing"),C(U,"width","600"),C(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){w(document.head,l),s(e,M,t),s(e,h,t),s(e,c,t),u(_,e,t),s(e,i,t),s(e,T,t),s(e,be,t),u(D,e,t),s(e,we,t),s(e,E,t),s(e,_e,t),u(Z,e,t),s(e,Me,t),s(e,F,t),s(e,Te,t),s(e,z,t),s(e,je,t),s(e,U,t),s(e,Je,t),s(e,H,t),s(e,ve,t),s(e,V,t),s(e,$e,t),u(X,e,t),s(e,Be,t),s(e,N,t),s(e,ke,t),u(Y,e,t),s(e,We,t),s(e,L,t),s(e,Ce,t),u(P,e,t),s(e,Ze,t),u(S,e,t),s(e,Ue,t),s(e,q,t),s(e,Ge,t),u(Q,e,t),s(e,Ie,t),u(K,e,t),s(e,Ae,t),s(e,O,t),s(e,xe,t),s(e,ee,t),s(e,Re,t),s(e,te,t),s(e,De,t),u(ne,e,t),s(e,Ee,t),s(e,j,t),u(se,j,null),w(j,Pe),w(j,he),w(j,Se),w(j,ce),w(j,qe),u(G,j,null),w(j,Qe),w(j,I),u(ae,I,null),w(I,Ke),w(I,de),s(e,Fe,t),u(oe,e,t),s(e,ze,t),s(e,J,t),u(le,J,null),w(J,Oe),w(J,me),w(J,et),w(J,ge),w(J,tt),w(J,$),u(ie,$,null),w($,nt),w($,ue),w($,st),u(A,$,null),w($,at),u(x,$,null),s(e,He,t),u(re,e,t),s(e,Ve,t),s(e,ye,t),Xe=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),Z.$set(v);const pe={};t&2&&(pe.$$scope={dirty:t,ctx:e}),G.$set(pe);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),A.$set(B);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),x.$set(k)},i(e){Xe||(f(_.$$.fragment,e),f(D.$$.fragment,e),f(Z.$$.fragment,e),f(X.$$.fragment,e),f(Y.$$.fragment,e),f(P.$$.fragment,e),f(S.$$.fragment,e),f(Q.$$.fragment,e),f(K.$$.fragment,e),f(ne.$$.fragment,e),f(se.$$.fragment,e),f(G.$$.fragment,e),f(ae.$$.fragment,e),f(oe.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(A.$$.fragment,e),f(x.$$.fragment,e),f(re.$$.fragment,e),Xe=!0)},o(e){y(_.$$.fragment,e),y(D.$$.fragment,e),y(Z.$$.fragment,e),y(X.$$.fragment,e),y(Y.$$.fragment,e),y(P.$$.fragment,e),y(S.$$.fragment,e),y(Q.$$.fragment,e),y(K.$$.fragment,e),y(ne.$$.fragment,e),y(se.$$.fragment,e),y(G.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),y(le.$$.fragment,e),y(ie.$$.fragment,e),y(A.$$.fragment,e),y(x.$$.fragment,e),y(re.$$.fragment,e),Xe=!1},d(e){e&&(n(M),n(h),n(c),n(i),n(T),n(be),n(we),n(E),n(_e),n(Me),n(F),n(Te),n(z),n(je),n(U),n(Je),n(H),n(ve),n(V),n($e),n(Be),n(N),n(ke),n(We),n(L),n(Ce),n(Ze),n(Ue),n(q),n(Ge),n(Ie),n(Ae),n(O),n(xe),n(ee),n(Re),n(te),n(De),n(Ee),n(j),n(Fe),n(ze),n(J),n(He),n(Ve),n(ye)),n(l),b(_,e),b(D,e),b(Z,e),b(X,e),b(Y,e),b(P,e),b(S,e),b(Q,e),b(K,e),b(ne,e),b(se),b(G),b(ae),b(oe,e),b(le),b(ie),b(A),b(x),b(re,e)}}}const Dt='{"title":"Depth Anything","local":"depth-anything","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Pipeline API","local":"pipeline-api","sections":[],"depth":3},{"title":"Using the model yourself","local":"using-the-model-yourself","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"DepthAnythingConfig","local":"transformers.DepthAnythingConfig","sections":[],"depth":2},{"title":"DepthAnythingForDepthEstimation","local":"transformers.DepthAnythingForDepthEstimation","sections":[],"depth":2}],"depth":1}';function Et(W){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Lt extends Wt{constructor(l){super(),Ct(this,l,Et,Rt,$t,{})}}export{Lt as component};
