import{s as rc,A as nc,o as sc,n as k}from"../chunks/scheduler.01eeda35.js";import{S as ac,i as ic,g as l,s as r,r as m,A as lc,h as c,f as o,c as n,j as P,u as g,x as v,k as T,y as s,a as i,v as h,d as u,t as f,w as _}from"../chunks/index.6dd51b66.js";import{T as ie}from"../chunks/Tip.de9bae2b.js";import{D as $}from"../chunks/Docstring.76e6b3cf.js";import{C as ke}from"../chunks/CodeBlock.864da1b0.js";import{E as Ce}from"../chunks/ExampleCodeBlock.6a36fb6b.js";import{H as x,E as cc}from"../chunks/EditOnGithub.7faefd25.js";function dc(j){let a,y='Perceiver does <strong>not</strong> work with <code>torch.nn.DataParallel</code> due to a bug in PyTorch, see <a href="https://github.com/pytorch/pytorch/issues/36035" rel="nofollow">issue #36035</a>';return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),v(a)!=="svelte-1mrs8m2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:k,d(p){p&&o(a)}}}function pc(j){let a,y="Example:",p,b,M;return b=new ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBlcmNlaXZlck1vZGVsJTJDJTIwUGVyY2VpdmVyQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFBlcmNlaXZlciUyMGRlZXBtaW5kJTJGbGFuZ3VhZ2UtcGVyY2VpdmVyJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFBlcmNlaXZlckNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGRlZXBtaW5kJTJGbGFuZ3VhZ2UtcGVyY2VpdmVyJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBQZXJjZWl2ZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverModel, PerceiverConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Perceiver deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PerceiverConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=y),p=n(d),g(b.$$.fragment,d)},m(d,w){i(d,a,w),i(d,p,w),h(b,d,w),M=!0},p:k,i(d){M||(u(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),_(b,d)}}}function mc(j){let a,y=`Note that it’s possible to fine-tune Perceiver on higher resolution images than the ones it has been trained on, by
setting <code>interpolate_pos_encoding</code> to <code>True</code> in the forward of the model. This will interpolate the pre-trained
position embeddings to the higher resolution.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),v(a)!=="svelte-uwdgm5"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:k,d(p){p&&o(a)}}}function gc(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),v(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:k,d(p){p&&o(a)}}}function hc(j){let a,y="Examples:",p,b,M;return b=new ke({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverConfig, PerceiverTokenizer, PerceiverImageProcessor, PerceiverModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.models.perceiver.modeling_perceiver <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    PerceiverTextPreprocessor,
<span class="hljs-meta">... </span>    PerceiverImagePreprocessor,
<span class="hljs-meta">... </span>    PerceiverClassificationDecoder,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 1: using the Perceiver to classify texts</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a TextPreprocessor, which can be used to embed tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a ClassificationDecoder, which can be used to decode the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># final hidden states of the latents to classification logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># using trainable position embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PerceiverConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverTextPreprocessor(config)
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    num_channels=config.d_latents,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(config, input_preprocessor=preprocessor, decoder=decoder)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = PerceiverTokenizer()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 2: using the Perceiver to classify images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define an ImagePreprocessor, which can be used to embed images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PerceiverConfig(image_size=<span class="hljs-number">224</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverImagePreprocessor(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    prep_type=<span class="hljs-string">&quot;conv1x1&quot;</span>,
<span class="hljs-meta">... </span>    spatial_downsample=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    position_encoding_type=<span class="hljs-string">&quot;trainable&quot;</span>,
<span class="hljs-meta">... </span>    concat_or_add_pos=<span class="hljs-string">&quot;concat&quot;</span>,
<span class="hljs-meta">... </span>    project_pos_dim=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(
<span class="hljs-meta">... </span>        num_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>        index_dims=config.image_size**<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    input_preprocessor=preprocessor,
<span class="hljs-meta">... </span>    decoder=PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>        config,
<span class="hljs-meta">... </span>        num_channels=config.d_latents,
<span class="hljs-meta">... </span>        trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>        use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = PerceiverImageProcessor()
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),g(b.$$.fragment,d)},m(d,w){i(d,a,w),i(d,p,w),h(b,d,w),M=!0},p:k,i(d){M||(u(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),_(b,d)}}}function uc(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),v(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:k,d(p){p&&o(a)}}}function fc(j){let a,y="Examples:",p,b,M;return b=new ke({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PerceiverForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMaskedLM.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask &quot; missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">19.87</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">262</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask bytes corresponding to &quot; missing.&quot;. Note that the model performs much better if the masked span starts with a space.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">262</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>masked_tokens_predictions = logits[<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>].argmax(dim=-<span class="hljs-number">1</span>).tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(masked_tokens_predictions)
<span class="hljs-string">&#x27; missing.&#x27;</span>`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),g(b.$$.fragment,d)},m(d,w){i(d,a,w),i(d,p,w),h(b,d,w),M=!0},p:k,i(d){M||(u(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),_(b,d)}}}function _c(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),v(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:k,d(p){p&&o(a)}}}function vc(j){let a,y="Examples:",p,b,M;return b=new ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQZXJjZWl2ZXJGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcG1pbmQlMkZsYW5ndWFnZS1wZXJjZWl2ZXIlMjIpJTBBbW9kZWwlMjAlM0QlMjBQZXJjZWl2ZXJGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRmxhbmd1YWdlLXBlcmNlaXZlciUyMiklMEElMEF0ZXh0JTIwJTNEJTIwJTIyaGVsbG8lMjB3b3JsZCUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfaWRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyUzRGlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PerceiverForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),g(b.$$.fragment,d)},m(d,w){i(d,a,w),i(d,p,w),h(b,d,w),M=!0},p:k,i(d){M||(u(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),_(b,d)}}}function bc(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),v(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:k,d(p){p&&o(a)}}}function yc(j){let a,y="Examples:",p,b,M;return b=new ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFBlcmNlaXZlckZvckltYWdlQ2xhc3NpZmljYXRpb25MZWFybmVkJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRnZpc2lvbi1wZXJjZWl2ZXItbGVhcm5lZCUyMiklMEFtb2RlbCUyMCUzRCUyMFBlcmNlaXZlckZvckltYWdlQ2xhc3NpZmljYXRpb25MZWFybmVkLmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRnZpc2lvbi1wZXJjZWl2ZXItbGVhcm5lZCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5waXhlbF92YWx1ZXMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzJTNEaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBbGlzdChsb2dpdHMuc2hhcGUpJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9jbGFzc19pZHglMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludCglMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZHglNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, PerceiverForImageClassificationLearned
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationLearned.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),g(b.$$.fragment,d)},m(d,w){i(d,a,w),i(d,p,w),h(b,d,w),M=!0},p:k,i(d){M||(u(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),_(b,d)}}}function Mc(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),v(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:k,d(p){p&&o(a)}}}function Tc(j){let a,y="Examples:",p,b,M;return b=new ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFBlcmNlaXZlckZvckltYWdlQ2xhc3NpZmljYXRpb25Gb3VyaWVyJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRnZpc2lvbi1wZXJjZWl2ZXItZm91cmllciUyMiklMEFtb2RlbCUyMCUzRCUyMFBlcmNlaXZlckZvckltYWdlQ2xhc3NpZmljYXRpb25Gb3VyaWVyLmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRnZpc2lvbi1wZXJjZWl2ZXItZm91cmllciUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5waXhlbF92YWx1ZXMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzJTNEaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBbGlzdChsb2dpdHMuc2hhcGUpJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9jbGFzc19pZHglMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludCglMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZHglNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, PerceiverForImageClassificationFourier
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationFourier.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),g(b.$$.fragment,d)},m(d,w){i(d,a,w),i(d,p,w),h(b,d,w),M=!0},p:k,i(d){M||(u(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),_(b,d)}}}function wc(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),v(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:k,d(p){p&&o(a)}}}function Pc(j){let a,y="Examples:",p,b,M;return b=new ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFBlcmNlaXZlckZvckltYWdlQ2xhc3NpZmljYXRpb25Db252UHJvY2Vzc2luZyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcG1pbmQlMkZ2aXNpb24tcGVyY2VpdmVyLWNvbnYlMjIpJTBBbW9kZWwlMjAlM0QlMjBQZXJjZWl2ZXJGb3JJbWFnZUNsYXNzaWZpY2F0aW9uQ29udlByb2Nlc3NpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmRlZXBtaW5kJTJGdmlzaW9uLXBlcmNlaXZlci1jb252JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnBpeGVsX3ZhbHVlcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMlM0RpbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsaXN0KGxvZ2l0cy5zaGFwZSklMEElMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, PerceiverForImageClassificationConvProcessing
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationConvProcessing.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),g(b.$$.fragment,d)},m(d,w){i(d,a,w),i(d,p,w),h(b,d,w),M=!0},p:k,i(d){M||(u(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),_(b,d)}}}function $c(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),v(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:k,d(p){p&&o(a)}}}function jc(j){let a,y="Examples:",p,b,M;return b=new ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBlcmNlaXZlckZvck9wdGljYWxGbG93JTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyMFBlcmNlaXZlckZvck9wdGljYWxGbG93LmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRm9wdGljYWwtZmxvdy1wZXJjZWl2ZXIlMjIpJTBBJTBBJTIzJTIwaW4lMjB0aGUlMjBQZXJjZWl2ZXIlMjBJTyUyMHBhcGVyJTJDJTIwdGhlJTIwYXV0aG9ycyUyMGV4dHJhY3QlMjBhJTIwMyUyMHglMjAzJTIwcGF0Y2glMjBhcm91bmQlMjBlYWNoJTIwcGl4ZWwlMkMlMEElMjMlMjBsZWFkaW5nJTIwdG8lMjAzJTIweCUyMDMlMjB4JTIwMyUyMCUzRCUyMDI3JTIwdmFsdWVzJTIwZm9yJTIwZWFjaCUyMHBpeGVsJTIwKGFzJTIwZWFjaCUyMHBpeGVsJTIwYWxzbyUyMGhhcyUyMDMlMjBjb2xvciUyMGNoYW5uZWxzKSUwQSUyMyUyMHBhdGNoZXMlMjBoYXZlJTIwc2hhcGUlMjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9mcmFtZXMlMkMlMjBudW1fY2hhbm5lbHMlMkMlMjBoZWlnaHQlMkMlMjB3aWR0aCklMEElMjMlMjB0aGUlMjBhdXRob3JzJTIwdHJhaW4lMjBvbiUyMHJlc29sdXRpb25zJTIwb2YlMjAzNjglMjB4JTIwNDk2JTBBcGF0Y2hlcyUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjAyJTJDJTIwMjclMkMlMjAzNjglMkMlMjA0OTYpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyUzRHBhdGNoZXMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsaXN0KGxvZ2l0cy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForOpticalFlow
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForOpticalFlow.from_pretrained(<span class="hljs-string">&quot;deepmind/optical-flow-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, the authors extract a 3 x 3 patch around each pixel,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># leading to 3 x 3 x 3 = 27 values for each pixel (as each pixel also has 3 color channels)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># patches have shape (batch_size, num_frames, num_channels, height, width)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the authors train on resolutions of 368 x 496</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>patches = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">27</span>, <span class="hljs-number">368</span>, <span class="hljs-number">496</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=patches)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">368</span>, <span class="hljs-number">496</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),g(b.$$.fragment,d)},m(d,w){i(d,a,w),i(d,p,w),h(b,d,w),M=!0},p:k,i(d){M||(u(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),_(b,d)}}}function xc(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),v(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:k,d(p){p&&o(a)}}}function Cc(j){let a,y="Examples:",p,b,M;return b=new ke({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForMultimodalAutoencoding
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create multimodal inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">16</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">30720</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(image=images, audio=audio, label=torch.zeros((images.shape[<span class="hljs-number">0</span>], <span class="hljs-number">700</span>)))

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMultimodalAutoencoding.from_pretrained(<span class="hljs-string">&quot;deepmind/multimodal-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, videos are auto-encoded in chunks</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># each chunk subsamples different index dimensions of the image and audio modality decoder queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>nchunks = <span class="hljs-number">128</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_chunk_size = np.prod((<span class="hljs-number">16</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>)) // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_chunk_size = audio.shape[<span class="hljs-number">1</span>] // model.config.samples_per_patch // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># process the first chunk</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chunk_idx = <span class="hljs-number">0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>subsampling = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;image&quot;</span>: torch.arange(image_chunk_size * chunk_idx, image_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;audio&quot;</span>: torch.arange(audio_chunk_size * chunk_idx, audio_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs, subsampled_output_points=subsampling)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;audio&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">240</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;image&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">6272</span>, <span class="hljs-number">3</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;label&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">700</span>]`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),g(b.$$.fragment,d)},m(d,w){i(d,a,w),i(d,p,w),h(b,d,w),M=!0},p:k,i(d){M||(u(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),_(b,d)}}}function kc(j){let a,y,p,b,M,d,w,Fi='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',hn,it,un,lt,Ii=`The Perceiver IO model was proposed in <a href="https://arxiv.org/abs/2107.14795" rel="nofollow">Perceiver IO: A General Architecture for Structured Inputs &amp;
Outputs</a> by Andrew Jaegle, Sebastian Borgeaud, Jean-Baptiste Alayrac, Carl Doersch,
Catalin Ionescu, David Ding, Skanda Koppula, Daniel Zoran, Andrew Brock, Evan Shelhamer, Olivier Hénaff, Matthew M.
Botvinick, Andrew Zisserman, Oriol Vinyals, João Carreira.`,fn,ct,Ui=`Perceiver IO is a generalization of <a href="https://arxiv.org/abs/2103.03206" rel="nofollow">Perceiver</a> to handle arbitrary outputs in
addition to arbitrary inputs. The original Perceiver only produced a single classification label. In addition to
classification labels, Perceiver IO can produce (for example) language, optical flow, and multimodal videos with audio.
This is done using the same building blocks as the original Perceiver. The computational complexity of Perceiver IO is
linear in the input and output size and the bulk of the processing occurs in the latent space, allowing us to process
inputs and outputs that are much larger than can be handled by standard Transformers. This means, for example,
Perceiver IO can do BERT-style masked language modeling directly using bytes instead of tokenized inputs.`,_n,dt,Zi="The abstract from the paper is the following:",vn,pt,zi=`<em>The recently-proposed Perceiver model obtains good results on several domains (images, audio, multimodal, point
clouds) while scaling linearly in compute and memory with the input size. While the Perceiver supports many kinds of
inputs, it can only produce very simple outputs such as class scores. Perceiver IO overcomes this limitation without
sacrificing the original’s appealing properties by learning to flexibly query the model’s latent space to produce
outputs of arbitrary size and semantics. Perceiver IO still decouples model depth from data size and still scales
linearly with data size, but now with respect to both input and output sizes. The full Perceiver IO model achieves
strong results on tasks with highly structured output spaces, such as natural language and visual understanding,
StarCraft II, and multi-task and multi-modal domains. As highlights, Perceiver IO matches a Transformer-based BERT
baseline on the GLUE language benchmark without the need for input tokenization and achieves state-of-the-art
performance on Sintel optical flow estimation.</em>`,bn,mt,Wi="Here’s a TLDR explaining how Perceiver works:",yn,gt,Bi=`The main problem with the self-attention mechanism of the Transformer is that the time and memory requirements scale
quadratically with the sequence length. Hence, models like BERT and RoBERTa are limited to a max sequence length of 512
tokens. Perceiver aims to solve this issue by, instead of performing self-attention on the inputs, perform it on a set
of latent variables, and only use the inputs for cross-attention. In this way, the time and memory requirements don’t
depend on the length of the inputs anymore, as one uses a fixed amount of latent variables, like 256 or 512. These are
randomly initialized, after which they are trained end-to-end using backpropagation.`,Mn,ht,Ni=`Internally, <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> will create the latents, which is a tensor of shape <code>(batch_size, num_latents, d_latents)</code>. One must provide <code>inputs</code> (which could be text, images, audio, you name it!) to the model, which it will
use to perform cross-attention with the latents. The output of the Perceiver encoder is a tensor of the same shape. One
can then, similar to BERT, convert the last hidden states of the latents to classification logits by averaging along
the sequence dimension, and placing a linear layer on top of that to project the <code>d_latents</code> to <code>num_labels</code>.`,Tn,ut,qi=`This was the idea of the original Perceiver paper. However, it could only output classification logits. In a follow-up
work, PerceiverIO, they generalized it to let the model also produce outputs of arbitrary size. How, you might ask? The
idea is actually relatively simple: one defines outputs of an arbitrary size, and then applies cross-attention with the
last hidden states of the latents, using the outputs as queries, and the latents as keys and values.`,wn,ft,Gi=`So let’s say one wants to perform masked language modeling (BERT-style) with the Perceiver. As the Perceiver’s input
length will not have an impact on the computation time of the self-attention layers, one can provide raw bytes,
providing <code>inputs</code> of length 2048 to the model. If one now masks out certain of these 2048 tokens, one can define the
<code>outputs</code> as being of shape: <code>(batch_size, 2048, 768)</code>. Next, one performs cross-attention with the final hidden states
of the latents to update the <code>outputs</code> tensor. After cross-attention, one still has a tensor of shape <code>(batch_size, 2048, 768)</code>. One can then place a regular language modeling head on top, to project the last dimension to the
vocabulary size of the model, i.e. creating logits of shape <code>(batch_size, 2048, 262)</code> (as Perceiver uses a vocabulary
size of 262 byte IDs).`,Pn,Je,Vi,$n,_t,Li='Perceiver IO architecture. Taken from the <a href="https://arxiv.org/abs/2105.15203">original paper</a>',jn,vt,Hi=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found
<a href="https://github.com/deepmind/deepmind-research/tree/master/perceiver" rel="nofollow">here</a>.`,xn,Fe,Cn,bt,kn,yt,Ri=`<li>The quickest way to get started with the Perceiver is by checking the <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Perceiver" rel="nofollow">tutorial
notebooks</a>.</li> <li>Refer to the <a href="https://huggingface.co/blog/perceiver" rel="nofollow">blog post</a> if you want to fully understand how the model works and
is implemented in the library. Note that the models available in the library only showcase some examples of what you can do
with the Perceiver. There are many more use cases, including question answering, named-entity recognition, object detection,
audio classification, video classification, etc.</li> <li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/masked_language_modeling">Masked language modeling task guide</a></li> <li><a href="../tasks/image_classification">Image classification task guide</a></li>`,Jn,Mt,Fn,le,Tt,Rs,Yo,Di="Base class for Perceiver base model’s outputs, with potential hidden states, attentions and cross-attentions.",In,ce,wt,Ds,Qo,Xi="Base class for Perceiver decoder outputs, with potential cross-attentions.",Un,de,Pt,Xs,Ko,Ei="Base class for Perceiver’s masked language model outputs.",Zn,pe,$t,Es,er,Ai=`Base class for Perceiver’s outputs of sequence/image classification models, optical flow and multimodal
autoencoding.`,zn,jt,Wn,W,xt,As,tr,Si=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a>. It is used to instantiate an
Perceiver model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Perceiver
<a href="https://huggingface.co/deepmind/language-perceiver" rel="nofollow">deepmind/language-perceiver</a> architecture.`,Ss,or,Oi=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Os,Ie,Bn,Ct,Nn,B,kt,Ys,rr,Yi="Construct a Perceiver tokenizer. The Perceiver simply uses raw bytes utf-8 encoding.",Qs,nr,Qi=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Ks,Ue,Jt,ea,sr,Ki=`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`,qn,Ft,Gn,me,It,ta,Ze,Ut,oa,ar,el="Preprocess an image or a batch of images.",Vn,Zt,Ln,S,zt,ra,ir,tl="Constructs a Perceiver image processor.",na,ze,Wt,sa,lr,ol="Preprocess an image or batch of images.",Hn,Bt,Rn,O,Nt,aa,cr,rl="Text preprocessing for Perceiver Encoder. Can be used to embed <code>inputs</code> and add positional encodings.",ia,dr,nl="The dimensionality of the embeddings is determined by the <code>d_model</code> attribute of the configuration.",Dn,qt,Xn,Y,Gt,la,pr,sl="Image preprocessing for Perceiver Encoder.",ca,mr,al=`Note: the <em>out_channels</em> argument refers to the output channels of a convolutional layer, if <em>prep_type</em> is set to
“conv1x1” or “conv”. If one adds absolute position embeddings, one must make sure the <em>num_channels</em> of the
position encoding kwargs are set equal to the <em>out_channels</em>.`,En,Vt,An,ge,Lt,da,gr,il="One-hot preprocessor for Perceiver Encoder. Can be used to add a dummy index dimension to the input.",Sn,Ht,On,he,Rt,pa,hr,ll="Audio preprocessing for Perceiver Encoder.",Yn,Dt,Qn,Q,Xt,ma,ur,cl="Multimodal preprocessing for Perceiver Encoder.",ga,fr,dl=`Inputs for each modality are preprocessed, then padded with trainable position embeddings to have the same number
of channels.`,Kn,Et,es,ue,At,ha,_r,pl="Baseline projection decoder (no cross-attention).",ts,St,os,K,Ot,ua,vr,ml=`Cross-attention-based decoder. This class can be used to decode the final hidden states of the latents using a
cross-attention operation, in which the latents produce keys and values.`,fa,br,gl="The shape of the output of this class depends on how one defines the output queries (also called decoder queries).",rs,Yt,ns,fe,Qt,_a,yr,hl=`Cross-attention based classification decoder. Light-weight wrapper of <code>PerceiverBasicDecoder</code> for logit output.
Will turn the output of the Perceiver encoder which is of shape (batch_size, num_latents, d_latents) to a tensor of
shape (batch_size, num_labels). The queries are of shape (batch_size, 1, num_labels).`,ss,Kt,as,_e,eo,va,Mr,ul="Cross-attention based optical flow decoder.",is,to,ls,ve,oo,ba,Tr,fl=`Cross-attention based video-autoencoding decoder. Light-weight wrapper of [<em>PerceiverBasicDecoder</em>] with video
reshaping logic.`,cs,ro,ds,ee,no,ya,wr,_l=`Multimodal decoding by composing uni-modal decoders. The <em>modalities</em> argument of the constructor is a dictionary
mapping modality name to the decoder of that modality. That decoder will be used to construct queries for that
modality. Modality-specific queries are padded with trainable modality-specific parameters, after which they are
concatenated along the time dimension.`,Ma,Pr,vl="Next, there is a shared cross attention operation across all modalities.",ps,so,ms,be,ao,Ta,$r,bl=`Projection postprocessing for Perceiver. Can be used to project the channels of the decoder output to a lower
dimension.`,gs,io,hs,ye,lo,wa,jr,yl="Audio postprocessing for Perceiver. Can be used to convert the decoder output to audio features.",us,co,fs,Me,po,Pa,xr,Ml="Classification postprocessing for Perceiver. Can be used to convert the decoder output to classification logits.",_s,mo,vs,Te,go,$a,Cr,Tl=`Multimodal postprocessing for Perceiver. Can be used to combine modality-specific postprocessors into a single
postprocessor.`,bs,ho,ys,Z,uo,ja,kr,wl="The Perceiver: a scalable, fully attentional architecture.",xa,We,Ca,Jr,Pl=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ka,N,fo,Ja,Fr,$l='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> forward method, overrides the <code>__call__</code> special method.',Fa,Be,Ia,Ne,Ms,_o,Ts,te,vo,Ua,Ir,jl=`Example use of Perceiver for masked language modeling.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Za,q,bo,za,Ur,xl='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForMaskedLM">PerceiverForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',Wa,qe,Ba,Ge,ws,yo,Ps,oe,Mo,Na,Zr,Cl=`Example use of Perceiver for text classification.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,qa,G,To,Ga,zr,kl='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForSequenceClassification">PerceiverForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Va,Ve,La,Le,$s,wo,js,F,Po,Ha,Wr,Jl="Example use of Perceiver for image classification, for tasks such as ImageNet.",Ra,Br,Fl=`This model uses learned position embeddings. In other words, this model is not given any privileged information about
the structure of images. As shown in the paper, this model can achieve a top-1 accuracy of 72.7 on ImageNet.`,Da,Nr,Il=`<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a> uses <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor">PerceiverImagePreprocessor</a>
(with <code>prep_type=&quot;conv1x1&quot;</code>) to preprocess the input images, and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder">PerceiverClassificationDecoder</a> to decode the latent representation of
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> into classification logits.`,Xa,qr,Ul=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ea,V,$o,Aa,Gr,Zl='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a> forward method, overrides the <code>__call__</code> special method.',Sa,He,Oa,Re,xs,jo,Cs,I,xo,Ya,Vr,zl="Example use of Perceiver for image classification, for tasks such as ImageNet.",Qa,Lr,Wl=`This model uses fixed 2D Fourier position embeddings. As shown in the paper, this model can achieve a top-1 accuracy of
79.0 on ImageNet, and 84.5 when pre-trained on a large-scale dataset (i.e. JFT).`,Ka,Hr,Bl=`<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a> uses <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor">PerceiverImagePreprocessor</a>
(with <code>prep_type=&quot;pixels&quot;</code>) to preprocess the input images, and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder">PerceiverClassificationDecoder</a> to decode the latent representation of
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> into classification logits.`,ei,Rr,Nl=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ti,L,Co,oi,Dr,ql='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationFourier">PerceiverForImageClassificationFourier</a> forward method, overrides the <code>__call__</code> special method.',ri,De,ni,Xe,ks,ko,Js,U,Jo,si,Xr,Gl="Example use of Perceiver for image classification, for tasks such as ImageNet.",ai,Er,Vl=`This model uses a 2D conv+maxpool preprocessing network. As shown in the paper, this model can achieve a top-1 accuracy
of 82.1 on ImageNet.`,ii,Ar,Ll=`<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a> uses <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor">PerceiverImagePreprocessor</a>
(with <code>prep_type=&quot;conv&quot;</code>) to preprocess the input images, and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder">PerceiverClassificationDecoder</a> to decode the latent representation of
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> into classification logits.`,li,Sr,Hl=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ci,H,Fo,di,Or,Rl='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationConvProcessing">PerceiverForImageClassificationConvProcessing</a> forward method, overrides the <code>__call__</code> special method.',pi,Ee,mi,Ae,Fs,Io,Is,z,Uo,gi,Yr,Dl=`Example use of Perceiver for optical flow, for tasks such as Sintel and KITTI. <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow">PerceiverForOpticalFlow</a> uses
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor">PerceiverImagePreprocessor</a> (with <em>prep_type=“patches”</em>) to preprocess the
input images, and <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder">PerceiverOpticalFlowDecoder</a> to decode the latent
representation of <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a>.`,hi,Qr,Xl=`As input, one concatenates 2 subsequent frames along the channel dimension and extract a 3 x 3 patch around each pixel
(leading to 3 x 3 x 3 x 2 = 54 values for each pixel). Fixed Fourier position encodings are used to encode the position
of each pixel in the patch. Next, one applies the Perceiver encoder. To decode, one queries the latent representation
using the same encoding used for the input.`,ui,Kr,El=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,fi,R,Zo,_i,en,Al='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow">PerceiverForOpticalFlow</a> forward method, overrides the <code>__call__</code> special method.',vi,Se,bi,Oe,Us,zo,Zs,C,Wo,yi,tn,Sl="Example use of Perceiver for multimodal (video) autoencoding, for tasks such as Kinetics-700.",Mi,on,Ol=`<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding">PerceiverForMultimodalAutoencoding</a> uses <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor">PerceiverMultimodalPreprocessor</a> to
preprocess the 3 modalities: images, audio and class labels. This preprocessor uses modality-specific preprocessors to
preprocess every modality separately, after which they are concatenated. Trainable position embeddings are used to pad
each modality to the same number of channels to make concatenation along the time dimension possible. Next, one applies
the Perceiver encoder.`,Ti,rn,Yl=`<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder">PerceiverMultimodalDecoder</a> is used to decode the latent representation of
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a>. This decoder uses each modality-specific decoder to construct queries. The decoder queries are
created based on the inputs after preprocessing. However, autoencoding an entire video in a single forward pass is
computationally infeasible, hence one only uses parts of the decoder queries to do cross-attention with the latent
representation. This is determined by the subsampled indices for each modality, which can be provided as additional
input to the forward pass of <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding">PerceiverForMultimodalAutoencoding</a>.`,wi,nn,Ql=`<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder">PerceiverMultimodalDecoder</a> also pads the decoder queries of the different
modalities to the same number of channels, in order to concatenate them along the time dimension. Next, cross-attention
is performed with the latent representation of <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a>.`,Pi,sn,Kl=`Finally, <code>~models.perceiver.modeling_perceiver.PerceiverMultiModalPostprocessor</code> is used to turn this tensor into an
actual video. It first splits up the output into the different modalities, and then applies the respective
postprocessor for each modality.`,$i,an,ec=`Note that, by masking the classification label during evaluation (i.e. simply providing a tensor of zeros for the
“label” modality), this auto-encoding model becomes a Kinetics 700 video classifier.`,ji,ln,tc=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,xi,D,Bo,Ci,cn,oc='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding">PerceiverForMultimodalAutoencoding</a> forward method, overrides the <code>__call__</code> special method.',ki,Ye,Ji,Qe,zs,No,Ws,gn,Bs;return M=new x({props:{title:"Perceiver",local:"perceiver",headingTag:"h1"}}),it=new x({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Fe=new ie({props:{warning:!0,$$slots:{default:[dc]},$$scope:{ctx:j}}}),bt=new x({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Mt=new x({props:{title:"Perceiver specific outputs",local:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",headingTag:"h2"}}),Tt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",parameters:[{name:"logits",val:": FloatTensor = None"},{name:"last_hidden_state",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L56"}}),wt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",parameters:[{name:"logits",val:": FloatTensor = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Output of the basic decoder.`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L87"}}),Pt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Masked language modeling (MLM) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L105"}}),$t=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L136"}}),jt=new x({props:{title:"PerceiverConfig",local:"transformers.PerceiverConfig",headingTag:"h2"}}),xt=new $({props:{name:"class transformers.PerceiverConfig",anchor:"transformers.PerceiverConfig",parameters:[{name:"num_latents",val:" = 256"},{name:"d_latents",val:" = 1280"},{name:"d_model",val:" = 768"},{name:"num_blocks",val:" = 1"},{name:"num_self_attends_per_block",val:" = 26"},{name:"num_self_attention_heads",val:" = 8"},{name:"num_cross_attention_heads",val:" = 8"},{name:"qk_channels",val:" = None"},{name:"v_channels",val:" = None"},{name:"cross_attention_shape_for_attention",val:" = 'kv'"},{name:"self_attention_widening_factor",val:" = 1"},{name:"cross_attention_widening_factor",val:" = 1"},{name:"hidden_act",val:" = 'gelu'"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"use_query_residual",val:" = True"},{name:"vocab_size",val:" = 262"},{name:"max_position_embeddings",val:" = 2048"},{name:"image_size",val:" = 56"},{name:"train_size",val:" = [368, 496]"},{name:"num_frames",val:" = 16"},{name:"audio_samples_per_frame",val:" = 1920"},{name:"samples_per_patch",val:" = 16"},{name:"output_shape",val:" = [1, 16, 224, 224]"},{name:"output_num_channels",val:" = 512"},{name:"_label_trainable_num_channels",val:" = 1024"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverConfig.num_latents",description:`<strong>num_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of latents.`,name:"num_latents"},{anchor:"transformers.PerceiverConfig.d_latents",description:`<strong>d_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
Dimension of the latent embeddings.`,name:"d_latents"},{anchor:"transformers.PerceiverConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimension of the inputs. Should only be provided in case [<em>PerceiverTextPreprocessor</em>] is used or no
preprocessor is provided.`,name:"d_model"},{anchor:"transformers.PerceiverConfig.num_blocks",description:`<strong>num_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of blocks in the Transformer encoder.`,name:"num_blocks"},{anchor:"transformers.PerceiverConfig.num_self_attends_per_block",description:`<strong>num_self_attends_per_block</strong> (<code>int</code>, <em>optional</em>, defaults to 26) &#x2014;
The number of self-attention layers per block.`,name:"num_self_attends_per_block"},{anchor:"transformers.PerceiverConfig.num_self_attention_heads",description:`<strong>num_self_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each self-attention layer in the Transformer encoder.`,name:"num_self_attention_heads"},{anchor:"transformers.PerceiverConfig.num_cross_attention_heads",description:`<strong>num_cross_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each cross-attention layer in the Transformer encoder.`,name:"num_cross_attention_heads"},{anchor:"transformers.PerceiverConfig.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the queries + keys before applying attention in the cross-attention and self-attention
layers of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"qk_channels"},{anchor:"transformers.PerceiverConfig.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the values before applying attention in the cross-attention and self-attention layers
of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"v_channels"},{anchor:"transformers.PerceiverConfig.cross_attention_shape_for_attention",description:`<strong>cross_attention_shape_for_attention</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;kv&quot;</code>) &#x2014;
Dimension to use when downsampling the queries and keys in the cross-attention layer of the encoder.`,name:"cross_attention_shape_for_attention"},{anchor:"transformers.PerceiverConfig.self_attention_widening_factor",description:`<strong>self_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the cross-attention layer of the Transformer encoder.`,name:"self_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.cross_attention_widening_factor",description:`<strong>cross_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the self-attention layers of the Transformer encoder.`,name:"cross_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.PerceiverConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.PerceiverConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.PerceiverConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.PerceiverConfig.use_query_residual",description:`<strong>use_query_residual</strong> (<code>float</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a query residual in the cross-attention layer of the encoder.`,name:"use_query_residual"},{anchor:"transformers.PerceiverConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 262) &#x2014;
Vocabulary size for the masked language modeling model.`,name:"vocab_size"},{anchor:"transformers.PerceiverConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that the masked language modeling model might ever be used with. Typically set
this to something large just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.PerceiverConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 56) &#x2014;
Size of the images after preprocessing, for <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a>.`,name:"image_size"},{anchor:"transformers.PerceiverConfig.train_size",description:`<strong>train_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[368, 496]</code>) &#x2014;
Training size of the images for the optical flow model.`,name:"train_size"},{anchor:"transformers.PerceiverConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of video frames used for the multimodal autoencoding model.`,name:"num_frames"},{anchor:"transformers.PerceiverConfig.audio_samples_per_frame",description:`<strong>audio_samples_per_frame</strong> (<code>int</code>, <em>optional</em>, defaults to 1920) &#x2014;
Number of audio samples per frame for the multimodal autoencoding model.`,name:"audio_samples_per_frame"},{anchor:"transformers.PerceiverConfig.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of audio samples per patch when preprocessing the audio for the multimodal autoencoding model.`,name:"samples_per_patch"},{anchor:"transformers.PerceiverConfig.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 16, 224, 224]</code>) &#x2014;
Shape of the output (batch_size, num_frames, height, width) for the video decoder queries of the multimodal
autoencoding model. This excludes the channel dimension.`,name:"output_shape"},{anchor:"transformers.PerceiverConfig.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Number of output channels for each modalitiy decoder.`,name:"output_num_channels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/configuration_perceiver.py#L31"}}),Ie=new Ce({props:{anchor:"transformers.PerceiverConfig.example",$$slots:{default:[pc]},$$scope:{ctx:j}}}),Ct=new x({props:{title:"PerceiverTokenizer",local:"transformers.PerceiverTokenizer",headingTag:"h2"}}),kt=new $({props:{name:"class transformers.PerceiverTokenizer",anchor:"transformers.PerceiverTokenizer",parameters:[{name:"pad_token",val:" = '[PAD]'"},{name:"bos_token",val:" = '[BOS]'"},{name:"eos_token",val:" = '[EOS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"model_max_length",val:" = 2048"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.PerceiverTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[BOS]&quot;</code>) &#x2014;
The BOS token (reserved in the vocab, but not actually used).`,name:"bos_token"},{anchor:"transformers.PerceiverTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[EOS]&quot;</code>) &#x2014;
The end of sequence token (reserved in the vocab, but not actually used).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.PerceiverTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The MASK token, useful for masked language modeling.`,name:"mask_token"},{anchor:"transformers.PerceiverTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The CLS token (reserved in the vocab, but not actually used).`,name:"cls_token"},{anchor:"transformers.PerceiverTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from two sequences.`,name:"sep_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/tokenization_perceiver.py#L26"}}),Jt=new $({props:{name:"__call__",anchor:"transformers.PerceiverTokenizer.__call__",parameters:[{name:"text",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]]] = None"},{name:"text_pair",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"text_target",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]]] = None"},{name:"text_pair_target",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": typing.Union[bool, str, transformers.utils.generic.PaddingStrategy] = False"},{name:"truncation",val:": typing.Union[bool, str, transformers.tokenization_utils_base.TruncationStrategy] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"stride",val:": int = 0"},{name:"is_split_into_words",val:": bool = False"},{name:"pad_to_multiple_of",val:": typing.Optional[int] = None"},{name:"padding_side",val:": typing.Optional[str] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"return_token_type_ids",val:": typing.Optional[bool] = None"},{name:"return_attention_mask",val:": typing.Optional[bool] = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.PerceiverTokenizer.__call__.text_pair",description:`<strong>text_pair</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair"},{anchor:"transformers.PerceiverTokenizer.__call__.text_target",description:`<strong>text_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_target"},{anchor:"transformers.PerceiverTokenizer.__call__.text_pair_target",description:`<strong>text_pair_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair_target"},{anchor:"transformers.PerceiverTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add special tokens when encoding the sequences. This will use the underlying
<code>PretrainedTokenizerBase.build_inputs_with_special_tokens</code> function, which defines which tokens are
automatically added to the input ids. This is useful if you want to add <code>bos</code> or <code>eos</code> tokens
automatically.`,name:"add_special_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.PerceiverTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.PerceiverTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.PerceiverTokenizer.__call__.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.PerceiverTokenizer.__call__.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.PerceiverTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. Requires <code>padding</code> to be activated.
This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.PerceiverTokenizer.__call__.padding_side",description:`<strong>padding_side</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The side on which the model should have padding applied. Should be selected between [&#x2018;right&#x2019;, &#x2018;left&#x2019;].
Default value is picked from the class attribute of the same name.`,name:"padding_side"},{anchor:"transformers.PerceiverTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.PerceiverTokenizer.__call__.return_token_type_ids",description:`<strong>return_token_type_ids</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return token type IDs. If left to the default, will return the token type IDs according to
the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"return_token_type_ids"},{anchor:"transformers.PerceiverTokenizer.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"return_attention_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_overflowing_tokens",description:`<strong>return_overflowing_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return overflowing token sequences. If a pair of sequences of input ids (or a batch
of pairs) is provided with <code>truncation_strategy = longest_first</code> or <code>True</code>, an error is raised instead
of returning overflowing tokens.`,name:"return_overflowing_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.return_special_tokens_mask",description:`<strong>return_special_tokens_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return special tokens mask information.`,name:"return_special_tokens_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_offsets_mapping",description:`<strong>return_offsets_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return <code>(char_start, char_end)</code> for each token.</p>
<p>This is only available on fast tokenizers inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a>, if using
Python&#x2019;s tokenizer, this method will raise <code>NotImplementedError</code>.`,name:"return_offsets_mapping"},{anchor:"transformers.PerceiverTokenizer.__call__.return_length",description:`<strong>return_length</strong>  (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the lengths of the encoded inputs.`,name:"return_length"},{anchor:"transformers.PerceiverTokenizer.__call__.verbose",description:`<strong>verbose</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to print more information and warnings.`,name:"verbose"},{anchor:"transformers.PerceiverTokenizer.__call__.*kwargs",description:"*<strong>*kwargs</strong> &#x2014; passed to the <code>self.tokenize()</code> method",name:"*kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L2810",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a> with the following fields:</p>
<ul>
<li>
<p><strong>input_ids</strong> — List of token ids to be fed to a model.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
</li>
<li>
<p><strong>token_type_ids</strong> — List of token type ids to be fed to a model (when <code>return_token_type_ids=True</code> or
if <em>“token_type_ids”</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a></p>
</li>
<li>
<p><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
</li>
<li>
<p><strong>overflowing_tokens</strong> — List of overflowing tokens sequences (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>num_truncated_tokens</strong> — Number of tokens truncated (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>special_tokens_mask</strong> — List of 0s and 1s, with 1 specifying added special tokens and 0 specifying
regular sequence tokens (when <code>add_special_tokens=True</code> and <code>return_special_tokens_mask=True</code>).</p>
</li>
<li>
<p><strong>length</strong> — The length of the inputs (when <code>return_length=True</code>)</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a></p>
`}}),Ft=new x({props:{title:"PerceiverFeatureExtractor",local:"transformers.PerceiverFeatureExtractor",headingTag:"h2"}}),It=new $({props:{name:"class transformers.PerceiverFeatureExtractor",anchor:"transformers.PerceiverFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/feature_extraction_perceiver.py#L26"}}),Ut=new $({props:{name:"__call__",anchor:"transformers.PerceiverFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils.py#L40"}}),Zt=new x({props:{title:"PerceiverImageProcessor",local:"transformers.PerceiverImageProcessor",headingTag:"h2"}}),zt=new $({props:{name:"class transformers.PerceiverImageProcessor",anchor:"transformers.PerceiverImageProcessor",parameters:[{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>True</code>) &#x2014;
Whether or not to center crop the image. If the input size if smaller than <code>crop_size</code> along any edge, the
image will be padded with zeros and then center cropped. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.PerceiverImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 256}</code>):
Desired output size when applying center-cropping. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.PerceiverImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image to <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>. Can be overridden by the <code>do_resize</code>
parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.PerceiverImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.PerceiverImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Defines the resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter
in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.PerceiverImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.PerceiverImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.PerceiverImageProcessor.do_normalize",description:`<strong>do_normalize</strong> &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.PerceiverImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.PerceiverImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/image_processing_perceiver.py#L47"}}),Wt=new $({props:{name:"preprocess",anchor:"transformers.PerceiverImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.PerceiverImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image to <code>crop_size</code>.`,name:"do_center_crop"},{anchor:"transformers.PerceiverImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Desired output size after applying the center crop.`,name:"crop_size"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.PerceiverImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.PerceiverImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.PerceiverImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.PerceiverImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.PerceiverImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.PerceiverImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.PerceiverImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/image_processing_perceiver.py#L210"}}),Bt=new x({props:{title:"PerceiverTextPreprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",headingTag:"h2"}}),Nt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2885"}}),qt=new x({props:{title:"PerceiverImagePreprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",headingTag:"h2"}}),Gt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:" = 'conv'"},{name:"spatial_downsample",val:": int = 4"},{name:"temporal_downsample",val:": int = 1"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 64"},{name:"conv_after_patching",val:": bool = False"},{name:"conv_after_patching_in_channels",val:": int = 54"},{name:"conv2d_use_batchnorm",val:": bool = True"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"project_pos_dim",val:": int = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;conv&quot;</code>) &#x2014;
Preprocessing type. Can be &#x201C;conv1x1&#x201D;, &#x201C;conv&#x201D;, &#x201C;patches&#x201D;, &#x201C;pixels&#x201D;.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.spatial_downsample",description:`<strong>spatial_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Spatial downsampling factor.`,name:"spatial_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.temporal_downsample",description:`<strong>temporal_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Temporal downsampling factor (only relevant in case a time dimension is present).`,name:"temporal_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Position encoding type. Can be &#x201C;fourier&#x201D; or &#x201C;trainable&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching",description:`<strong>conv_after_patching</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply a convolutional layer after patching.`,name:"conv_after_patching"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching_in_channels",description:`<strong>conv_after_patching_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 54) &#x2014;
Number of channels in the input of the convolutional layer after patching.`,name:"conv_after_patching_in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv2d_use_batchnorm",description:`<strong>conv2d_use_batchnorm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use batch normalization in the convolutional layer.`,name:"conv2d_use_batchnorm"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L3048"}}),Vt=new x({props:{title:"PerceiverOneHotPreprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",headingTag:"h2"}}),Lt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L3286"}}),Ht=new x({props:{title:"PerceiverAudioPreprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",headingTag:"h2"}}),Rt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:": str = 'patches'"},{name:"samples_per_patch",val:": int = 96"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"out_channels",val:" = 64"},{name:"project_pos_dim",val:" = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Preprocessor type to use. Only &#x201C;patches&#x201D; is supported.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
Number of samples per patch.`,name:"samples_per_patch"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Type of position encoding to use. Can be &#x201C;trainable&#x201D; or &#x201C;fourier&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L3312"}}),Dt=new x({props:{title:"PerceiverMultimodalPreprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",headingTag:"h2"}}),Xt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",parameters:[{name:"modalities",val:": typing.Mapping[str, typing.Callable[..., typing.Tuple[torch.Tensor, typing.Optional[torch.Tensor], torch.Tensor]]]"},{name:"mask_probs",val:": typing.Optional[typing.Mapping[str, float]] = None"},{name:"min_padding_size",val:": int = 2"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.modalities",description:`<strong>modalities</strong> (<code>Mapping[str, PreprocessorType]</code>) &#x2014;
Dict mapping modality name to preprocessor.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.mask_probs",description:`<strong>mask_probs</strong> (<code>Dict[str, float]</code>) &#x2014;
Dict mapping modality name to masking probability of that modality.`,name:"mask_probs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L3415"}}),Et=new x({props:{title:"PerceiverProjectionDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",headingTag:"h2"}}),At=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2063"}}),St=new x({props:{title:"PerceiverBasicDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",headingTag:"h2"}}),Ot=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_num_channels",val:": int"},{name:"position_encoding_type",val:": typing.Optional[str] = 'trainable'"},{name:"output_index_dims",val:": typing.Optional[int] = None"},{name:"num_channels",val:": typing.Optional[int] = 128"},{name:"subsampled_index_dims",val:": typing.Optional[int] = None"},{name:"qk_channels",val:": typing.Optional[int] = None"},{name:"v_channels",val:": typing.Optional[int] = None"},{name:"num_heads",val:": typing.Optional[int] = 1"},{name:"widening_factor",val:": typing.Optional[int] = 1"},{name:"use_query_residual",val:": typing.Optional[bool] = False"},{name:"concat_preprocessed_input",val:": typing.Optional[bool] = False"},{name:"final_project",val:": typing.Optional[bool] = True"},{name:"position_encoding_only",val:": typing.Optional[bool] = False"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels in the output. Will only be used in case <em>final_project</em> is set to <code>True</code>.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;trainable&#x201D;) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_index_dims",description:`<strong>output_index_dims</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of dimensions of the output queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"output_index_dims"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The number of channels of the decoder queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the queries and keys in the cross-attention layer.`,name:"qk_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the values in the cross-attention layer.`,name:"v_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of attention heads in the cross-attention layer.`,name:"num_heads"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.widening_factor",description:`<strong>widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The widening factor of the cross-attention layer.`,name:"widening_factor"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.use_query_residual",description:`<strong>use_query_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a residual connection between the query and the output of the cross-attention layer.`,name:"use_query_residual"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.concat_preprocessed_input",description:`<strong>concat_preprocessed_input</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to concatenate the preprocessed input to the query.`,name:"concat_preprocessed_input"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.final_project",description:`<strong>final_project</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to project the output of the cross-attention layer to a target dimension.`,name:"final_project"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_only",description:`<strong>position_encoding_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only use this class to define output queries.`,name:"position_encoding_only"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2089"}}),Yt=new x({props:{title:"PerceiverClassificationDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",headingTag:"h2"}}),Qt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",parameters:[{name:"config",val:""},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2275"}}),Kt=new x({props:{title:"PerceiverOpticalFlowDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",headingTag:"h2"}}),eo=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",parameters:[{name:"config",val:""},{name:"output_image_shape",val:""},{name:"output_num_channels",val:" = 2"},{name:"rescale_factor",val:" = 100.0"},{name:"**decoder_kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2321"}}),to=new x({props:{title:"PerceiverBasicVideoAutoencodingDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",headingTag:"h2"}}),oo=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_shape",val:": typing.List[int]"},{name:"position_encoding_type",val:": str"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>) &#x2014;
Shape of the output as (batch_size, num_frames, height, width), excluding the channel dimension.`,name:"output_shape"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2356"}}),ro=new x({props:{title:"PerceiverMultimodalDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",headingTag:"h2"}}),no=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"modalities",val:": typing.Dict[str, transformers.models.perceiver.modeling_perceiver.PerceiverAbstractDecoder]"},{name:"num_outputs",val:": int"},{name:"output_num_channels",val:": int"},{name:"min_padding_size",val:": typing.Optional[int] = 2"},{name:"subsampled_index_dims",val:": typing.Optional[typing.Dict[str, transformers.models.perceiver.modeling_perceiver.PerceiverAbstractDecoder]] = None"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>) &#x2014;
Dictionary mapping modality name to the decoder of that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.num_outputs",description:`<strong>num_outputs</strong> (<code>int</code>) &#x2014;
The number of outputs of the decoder.`,name:"num_outputs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>) &#x2014;
The number of channels in the output.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.subsampled_index_dims",description:`<strong>subsampled_index_dims</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>, <em>optional</em>) &#x2014;
Dictionary mapping modality name to the subsampled index dimensions to use for the decoder query of that
modality.`,name:"subsampled_index_dims"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2433"}}),so=new x({props:{title:"PerceiverProjectionPostprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",headingTag:"h2"}}),ao=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",parameters:[{name:"in_channels",val:": int"},{name:"out_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the output.`,name:"out_channels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L3027"}}),io=new x({props:{title:"PerceiverAudioPostprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",headingTag:"h2"}}),lo=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"},{name:"postproc_type",val:": str = 'patches'"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.postproc_type",description:`<strong>postproc_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Postprocessor type to use. Currently, only &#x201C;patches&#x201D; is supported.`,name:"postproc_type"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L3000"}}),co=new x({props:{title:"PerceiverClassificationPostprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",headingTag:"h2"}}),po=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2980"}}),mo=new x({props:{title:"PerceiverMultimodalPostprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",headingTag:"h2"}}),go=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",parameters:[{name:"modalities",val:": typing.Mapping[str, typing.Callable[..., typing.Any]]"},{name:"input_is_dict",val:": bool = False"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.modalities",description:`<strong>modalities</strong> (<code>Mapping[str, PostprocessorType]</code>) &#x2014;
Dictionary mapping modality name to postprocessor class for that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.input_is_dict",description:`<strong>input_is_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, input is assumed to be dictionary structured, and outputs keep the same dictionary shape. If
False, input is a tensor which is sliced up during postprocessing by <em>modality_sizes</em>.`,name:"input_is_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2946"}}),ho=new x({props:{title:"PerceiverModel",local:"transformers.PerceiverModel",headingTag:"h2"}}),uo=new $({props:{name:"class transformers.PerceiverModel",anchor:"transformers.PerceiverModel",parameters:[{name:"config",val:""},{name:"decoder",val:" = None"},{name:"input_preprocessor",val:": typing.Callable[..., typing.Tuple[torch.Tensor, typing.Optional[torch.Tensor], torch.Tensor]] = None"},{name:"output_postprocessor",val:": typing.Callable[..., typing.Any] = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.PerceiverModel.decoder",description:`<strong>decoder</strong> (<em>DecoderType</em>, <em>optional</em>) &#x2014;
Optional decoder to use to decode the latent representation of the encoder. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder</em>.`,name:"decoder"},{anchor:"transformers.PerceiverModel.input_preprocessor",description:`<strong>input_preprocessor</strong> (<em>PreprocessorType</em>, <em>optional</em>) &#x2014;
Optional input preprocessor to use. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor</em>.`,name:"input_preprocessor"},{anchor:"transformers.PerceiverModel.output_postprocessor",description:`<strong>output_postprocessor</strong> (<em>PostprocessorType</em>, <em>optional</em>) &#x2014;
Optional output postprocessor to use. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverImagePostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor</em>.`,name:"output_postprocessor"},{anchor:"transformers.PerceiverModel.Note",description:"<strong>Note</strong> that you can define your own decoders, preprocessors and/or postprocessors to fit your use-case. &#x2014;",name:"Note"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L710"}}),We=new ie({props:{$$slots:{default:[mc]},$$scope:{ctx:j}}}),fo=new $({props:{name:"forward",anchor:"transformers.PerceiverModel.forward",parameters:[{name:"inputs",val:": FloatTensor"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"subsampled_output_points",val:": typing.Optional[typing.Dict[str, torch.Tensor]] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.PerceiverModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L759",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Be=new ie({props:{$$slots:{default:[gc]},$$scope:{ctx:j}}}),Ne=new Ce({props:{anchor:"transformers.PerceiverModel.forward.example",$$slots:{default:[hc]},$$scope:{ctx:j}}}),_o=new x({props:{title:"PerceiverForMaskedLM",local:"transformers.PerceiverForMaskedLM",headingTag:"h2"}}),vo=new $({props:{name:"class transformers.PerceiverForMaskedLM",anchor:"transformers.PerceiverForMaskedLM",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L963"}}),bo=new $({props:{name:"forward",anchor:"transformers.PerceiverForMaskedLM.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMaskedLM.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.PerceiverForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L996",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),qe=new ie({props:{$$slots:{default:[uc]},$$scope:{ctx:j}}}),Ge=new Ce({props:{anchor:"transformers.PerceiverForMaskedLM.forward.example",$$slots:{default:[fc]},$$scope:{ctx:j}}}),yo=new x({props:{title:"PerceiverForSequenceClassification",local:"transformers.PerceiverForSequenceClassification",headingTag:"h2"}}),Mo=new $({props:{name:"class transformers.PerceiverForSequenceClassification",anchor:"transformers.PerceiverForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1098"}}),To=new $({props:{name:"forward",anchor:"transformers.PerceiverForSequenceClassification.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForSequenceClassification.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.PerceiverForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1120",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ve=new ie({props:{$$slots:{default:[_c]},$$scope:{ctx:j}}}),Le=new Ce({props:{anchor:"transformers.PerceiverForSequenceClassification.forward.example",$$slots:{default:[vc]},$$scope:{ctx:j}}}),wo=new x({props:{title:"PerceiverForImageClassificationLearned",local:"transformers.PerceiverForImageClassificationLearned",headingTag:"h2"}}),Po=new $({props:{name:"class transformers.PerceiverForImageClassificationLearned",anchor:"transformers.PerceiverForImageClassificationLearned",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1210"}}),$o=new $({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationLearned.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1255",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),He=new ie({props:{$$slots:{default:[bc]},$$scope:{ctx:j}}}),Re=new Ce({props:{anchor:"transformers.PerceiverForImageClassificationLearned.forward.example",$$slots:{default:[yc]},$$scope:{ctx:j}}}),jo=new x({props:{title:"PerceiverForImageClassificationFourier",local:"transformers.PerceiverForImageClassificationFourier",headingTag:"h2"}}),xo=new $({props:{name:"class transformers.PerceiverForImageClassificationFourier",anchor:"transformers.PerceiverForImageClassificationFourier",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1355"}}),Co=new $({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationFourier.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1401",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),De=new ie({props:{$$slots:{default:[Mc]},$$scope:{ctx:j}}}),Xe=new Ce({props:{anchor:"transformers.PerceiverForImageClassificationFourier.forward.example",$$slots:{default:[Tc]},$$scope:{ctx:j}}}),ko=new x({props:{title:"PerceiverForImageClassificationConvProcessing",local:"transformers.PerceiverForImageClassificationConvProcessing",headingTag:"h2"}}),Jo=new $({props:{name:"class transformers.PerceiverForImageClassificationConvProcessing",anchor:"transformers.PerceiverForImageClassificationConvProcessing",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1498"}}),Fo=new $({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1545",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ee=new ie({props:{$$slots:{default:[wc]},$$scope:{ctx:j}}}),Ae=new Ce({props:{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.example",$$slots:{default:[Pc]},$$scope:{ctx:j}}}),Io=new x({props:{title:"PerceiverForOpticalFlow",local:"transformers.PerceiverForOpticalFlow",headingTag:"h2"}}),Uo=new $({props:{name:"class transformers.PerceiverForOpticalFlow",anchor:"transformers.PerceiverForOpticalFlow",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1642"}}),Zo=new $({props:{name:"forward",anchor:"transformers.PerceiverForOpticalFlow.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForOpticalFlow.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForOpticalFlow.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.PerceiverForOpticalFlow.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForOpticalFlow.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the optical flow loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1706",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Se=new ie({props:{$$slots:{default:[$c]},$$scope:{ctx:j}}}),Oe=new Ce({props:{anchor:"transformers.PerceiverForOpticalFlow.forward.example",$$slots:{default:[jc]},$$scope:{ctx:j}}}),zo=new x({props:{title:"PerceiverForMultimodalAutoencoding",local:"transformers.PerceiverForMultimodalAutoencoding",headingTag:"h2"}}),Wo=new $({props:{name:"class transformers.PerceiverForMultimodalAutoencoding",anchor:"transformers.PerceiverForMultimodalAutoencoding",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1771"}}),Bo=new $({props:{name:"forward",anchor:"transformers.PerceiverForMultimodalAutoencoding.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"subsampled_output_points",val:": typing.Optional[typing.Dict[str, torch.Tensor]] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1917",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ye=new ie({props:{$$slots:{default:[xc]},$$scope:{ctx:j}}}),Qe=new Ce({props:{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.example",$$slots:{default:[Cc]},$$scope:{ctx:j}}}),No=new cc({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/perceiver.md"}}),{c(){a=l("meta"),y=r(),p=l("p"),b=r(),m(M.$$.fragment),d=r(),w=l("div"),w.innerHTML=Fi,hn=r(),m(it.$$.fragment),un=r(),lt=l("p"),lt.innerHTML=Ii,fn=r(),ct=l("p"),ct.innerHTML=Ui,_n=r(),dt=l("p"),dt.textContent=Zi,vn=r(),pt=l("p"),pt.innerHTML=zi,bn=r(),mt=l("p"),mt.textContent=Wi,yn=r(),gt=l("p"),gt.textContent=Bi,Mn=r(),ht=l("p"),ht.innerHTML=Ni,Tn=r(),ut=l("p"),ut.textContent=qi,wn=r(),ft=l("p"),ft.innerHTML=Gi,Pn=r(),Je=l("img"),$n=r(),_t=l("small"),_t.innerHTML=Li,jn=r(),vt=l("p"),vt.innerHTML=Hi,xn=r(),m(Fe.$$.fragment),Cn=r(),m(bt.$$.fragment),kn=r(),yt=l("ul"),yt.innerHTML=Ri,Jn=r(),m(Mt.$$.fragment),Fn=r(),le=l("div"),m(Tt.$$.fragment),Rs=r(),Yo=l("p"),Yo.textContent=Di,In=r(),ce=l("div"),m(wt.$$.fragment),Ds=r(),Qo=l("p"),Qo.textContent=Xi,Un=r(),de=l("div"),m(Pt.$$.fragment),Xs=r(),Ko=l("p"),Ko.textContent=Ei,Zn=r(),pe=l("div"),m($t.$$.fragment),Es=r(),er=l("p"),er.textContent=Ai,zn=r(),m(jt.$$.fragment),Wn=r(),W=l("div"),m(xt.$$.fragment),As=r(),tr=l("p"),tr.innerHTML=Si,Ss=r(),or=l("p"),or.innerHTML=Oi,Os=r(),m(Ie.$$.fragment),Bn=r(),m(Ct.$$.fragment),Nn=r(),B=l("div"),m(kt.$$.fragment),Ys=r(),rr=l("p"),rr.textContent=Yi,Qs=r(),nr=l("p"),nr.innerHTML=Qi,Ks=r(),Ue=l("div"),m(Jt.$$.fragment),ea=r(),sr=l("p"),sr.textContent=Ki,qn=r(),m(Ft.$$.fragment),Gn=r(),me=l("div"),m(It.$$.fragment),ta=r(),Ze=l("div"),m(Ut.$$.fragment),oa=r(),ar=l("p"),ar.textContent=el,Vn=r(),m(Zt.$$.fragment),Ln=r(),S=l("div"),m(zt.$$.fragment),ra=r(),ir=l("p"),ir.textContent=tl,na=r(),ze=l("div"),m(Wt.$$.fragment),sa=r(),lr=l("p"),lr.textContent=ol,Hn=r(),m(Bt.$$.fragment),Rn=r(),O=l("div"),m(Nt.$$.fragment),aa=r(),cr=l("p"),cr.innerHTML=rl,ia=r(),dr=l("p"),dr.innerHTML=nl,Dn=r(),m(qt.$$.fragment),Xn=r(),Y=l("div"),m(Gt.$$.fragment),la=r(),pr=l("p"),pr.textContent=sl,ca=r(),mr=l("p"),mr.innerHTML=al,En=r(),m(Vt.$$.fragment),An=r(),ge=l("div"),m(Lt.$$.fragment),da=r(),gr=l("p"),gr.textContent=il,Sn=r(),m(Ht.$$.fragment),On=r(),he=l("div"),m(Rt.$$.fragment),pa=r(),hr=l("p"),hr.textContent=ll,Yn=r(),m(Dt.$$.fragment),Qn=r(),Q=l("div"),m(Xt.$$.fragment),ma=r(),ur=l("p"),ur.textContent=cl,ga=r(),fr=l("p"),fr.textContent=dl,Kn=r(),m(Et.$$.fragment),es=r(),ue=l("div"),m(At.$$.fragment),ha=r(),_r=l("p"),_r.textContent=pl,ts=r(),m(St.$$.fragment),os=r(),K=l("div"),m(Ot.$$.fragment),ua=r(),vr=l("p"),vr.textContent=ml,fa=r(),br=l("p"),br.textContent=gl,rs=r(),m(Yt.$$.fragment),ns=r(),fe=l("div"),m(Qt.$$.fragment),_a=r(),yr=l("p"),yr.innerHTML=hl,ss=r(),m(Kt.$$.fragment),as=r(),_e=l("div"),m(eo.$$.fragment),va=r(),Mr=l("p"),Mr.textContent=ul,is=r(),m(to.$$.fragment),ls=r(),ve=l("div"),m(oo.$$.fragment),ba=r(),Tr=l("p"),Tr.innerHTML=fl,cs=r(),m(ro.$$.fragment),ds=r(),ee=l("div"),m(no.$$.fragment),ya=r(),wr=l("p"),wr.innerHTML=_l,Ma=r(),Pr=l("p"),Pr.textContent=vl,ps=r(),m(so.$$.fragment),ms=r(),be=l("div"),m(ao.$$.fragment),Ta=r(),$r=l("p"),$r.textContent=bl,gs=r(),m(io.$$.fragment),hs=r(),ye=l("div"),m(lo.$$.fragment),wa=r(),jr=l("p"),jr.textContent=yl,us=r(),m(co.$$.fragment),fs=r(),Me=l("div"),m(po.$$.fragment),Pa=r(),xr=l("p"),xr.textContent=Ml,_s=r(),m(mo.$$.fragment),vs=r(),Te=l("div"),m(go.$$.fragment),$a=r(),Cr=l("p"),Cr.textContent=Tl,bs=r(),m(ho.$$.fragment),ys=r(),Z=l("div"),m(uo.$$.fragment),ja=r(),kr=l("p"),kr.textContent=wl,xa=r(),m(We.$$.fragment),Ca=r(),Jr=l("p"),Jr.innerHTML=Pl,ka=r(),N=l("div"),m(fo.$$.fragment),Ja=r(),Fr=l("p"),Fr.innerHTML=$l,Fa=r(),m(Be.$$.fragment),Ia=r(),m(Ne.$$.fragment),Ms=r(),m(_o.$$.fragment),Ts=r(),te=l("div"),m(vo.$$.fragment),Ua=r(),Ir=l("p"),Ir.innerHTML=jl,Za=r(),q=l("div"),m(bo.$$.fragment),za=r(),Ur=l("p"),Ur.innerHTML=xl,Wa=r(),m(qe.$$.fragment),Ba=r(),m(Ge.$$.fragment),ws=r(),m(yo.$$.fragment),Ps=r(),oe=l("div"),m(Mo.$$.fragment),Na=r(),Zr=l("p"),Zr.innerHTML=Cl,qa=r(),G=l("div"),m(To.$$.fragment),Ga=r(),zr=l("p"),zr.innerHTML=kl,Va=r(),m(Ve.$$.fragment),La=r(),m(Le.$$.fragment),$s=r(),m(wo.$$.fragment),js=r(),F=l("div"),m(Po.$$.fragment),Ha=r(),Wr=l("p"),Wr.textContent=Jl,Ra=r(),Br=l("p"),Br.textContent=Fl,Da=r(),Nr=l("p"),Nr.innerHTML=Il,Xa=r(),qr=l("p"),qr.innerHTML=Ul,Ea=r(),V=l("div"),m($o.$$.fragment),Aa=r(),Gr=l("p"),Gr.innerHTML=Zl,Sa=r(),m(He.$$.fragment),Oa=r(),m(Re.$$.fragment),xs=r(),m(jo.$$.fragment),Cs=r(),I=l("div"),m(xo.$$.fragment),Ya=r(),Vr=l("p"),Vr.textContent=zl,Qa=r(),Lr=l("p"),Lr.textContent=Wl,Ka=r(),Hr=l("p"),Hr.innerHTML=Bl,ei=r(),Rr=l("p"),Rr.innerHTML=Nl,ti=r(),L=l("div"),m(Co.$$.fragment),oi=r(),Dr=l("p"),Dr.innerHTML=ql,ri=r(),m(De.$$.fragment),ni=r(),m(Xe.$$.fragment),ks=r(),m(ko.$$.fragment),Js=r(),U=l("div"),m(Jo.$$.fragment),si=r(),Xr=l("p"),Xr.textContent=Gl,ai=r(),Er=l("p"),Er.textContent=Vl,ii=r(),Ar=l("p"),Ar.innerHTML=Ll,li=r(),Sr=l("p"),Sr.innerHTML=Hl,ci=r(),H=l("div"),m(Fo.$$.fragment),di=r(),Or=l("p"),Or.innerHTML=Rl,pi=r(),m(Ee.$$.fragment),mi=r(),m(Ae.$$.fragment),Fs=r(),m(Io.$$.fragment),Is=r(),z=l("div"),m(Uo.$$.fragment),gi=r(),Yr=l("p"),Yr.innerHTML=Dl,hi=r(),Qr=l("p"),Qr.textContent=Xl,ui=r(),Kr=l("p"),Kr.innerHTML=El,fi=r(),R=l("div"),m(Zo.$$.fragment),_i=r(),en=l("p"),en.innerHTML=Al,vi=r(),m(Se.$$.fragment),bi=r(),m(Oe.$$.fragment),Us=r(),m(zo.$$.fragment),Zs=r(),C=l("div"),m(Wo.$$.fragment),yi=r(),tn=l("p"),tn.textContent=Sl,Mi=r(),on=l("p"),on.innerHTML=Ol,Ti=r(),rn=l("p"),rn.innerHTML=Yl,wi=r(),nn=l("p"),nn.innerHTML=Ql,Pi=r(),sn=l("p"),sn.innerHTML=Kl,$i=r(),an=l("p"),an.textContent=ec,ji=r(),ln=l("p"),ln.innerHTML=tc,xi=r(),D=l("div"),m(Bo.$$.fragment),Ci=r(),cn=l("p"),cn.innerHTML=oc,ki=r(),m(Ye.$$.fragment),Ji=r(),m(Qe.$$.fragment),zs=r(),m(No.$$.fragment),Ws=r(),gn=l("p"),this.h()},l(e){const t=lc("svelte-u9bgzb",document.head);a=c(t,"META",{name:!0,content:!0}),t.forEach(o),y=n(e),p=c(e,"P",{}),P(p).forEach(o),b=n(e),g(M.$$.fragment,e),d=n(e),w=c(e,"DIV",{class:!0,"data-svelte-h":!0}),v(w)!=="svelte-13t8s2t"&&(w.innerHTML=Fi),hn=n(e),g(it.$$.fragment,e),un=n(e),lt=c(e,"P",{"data-svelte-h":!0}),v(lt)!=="svelte-1q9pjug"&&(lt.innerHTML=Ii),fn=n(e),ct=c(e,"P",{"data-svelte-h":!0}),v(ct)!=="svelte-tt6rit"&&(ct.innerHTML=Ui),_n=n(e),dt=c(e,"P",{"data-svelte-h":!0}),v(dt)!=="svelte-vfdo9a"&&(dt.textContent=Zi),vn=n(e),pt=c(e,"P",{"data-svelte-h":!0}),v(pt)!=="svelte-1jljul4"&&(pt.innerHTML=zi),bn=n(e),mt=c(e,"P",{"data-svelte-h":!0}),v(mt)!=="svelte-l4zudt"&&(mt.textContent=Wi),yn=n(e),gt=c(e,"P",{"data-svelte-h":!0}),v(gt)!=="svelte-12eh3gr"&&(gt.textContent=Bi),Mn=n(e),ht=c(e,"P",{"data-svelte-h":!0}),v(ht)!=="svelte-wb5zf5"&&(ht.innerHTML=Ni),Tn=n(e),ut=c(e,"P",{"data-svelte-h":!0}),v(ut)!=="svelte-490sb6"&&(ut.textContent=qi),wn=n(e),ft=c(e,"P",{"data-svelte-h":!0}),v(ft)!=="svelte-9ljddx"&&(ft.innerHTML=Gi),Pn=n(e),Je=c(e,"IMG",{src:!0,alt:!0,width:!0}),$n=n(e),_t=c(e,"SMALL",{"data-svelte-h":!0}),v(_t)!=="svelte-d9mm9q"&&(_t.innerHTML=Li),jn=n(e),vt=c(e,"P",{"data-svelte-h":!0}),v(vt)!=="svelte-1mhzktt"&&(vt.innerHTML=Hi),xn=n(e),g(Fe.$$.fragment,e),Cn=n(e),g(bt.$$.fragment,e),kn=n(e),yt=c(e,"UL",{"data-svelte-h":!0}),v(yt)!=="svelte-7v41tc"&&(yt.innerHTML=Ri),Jn=n(e),g(Mt.$$.fragment,e),Fn=n(e),le=c(e,"DIV",{class:!0});var qo=P(le);g(Tt.$$.fragment,qo),Rs=n(qo),Yo=c(qo,"P",{"data-svelte-h":!0}),v(Yo)!=="svelte-13fgwy5"&&(Yo.textContent=Di),qo.forEach(o),In=n(e),ce=c(e,"DIV",{class:!0});var Go=P(ce);g(wt.$$.fragment,Go),Ds=n(Go),Qo=c(Go,"P",{"data-svelte-h":!0}),v(Qo)!=="svelte-19jhdk9"&&(Qo.textContent=Xi),Go.forEach(o),Un=n(e),de=c(e,"DIV",{class:!0});var Vo=P(de);g(Pt.$$.fragment,Vo),Xs=n(Vo),Ko=c(Vo,"P",{"data-svelte-h":!0}),v(Ko)!=="svelte-m841rf"&&(Ko.textContent=Ei),Vo.forEach(o),Zn=n(e),pe=c(e,"DIV",{class:!0});var Lo=P(pe);g($t.$$.fragment,Lo),Es=n(Lo),er=c(Lo,"P",{"data-svelte-h":!0}),v(er)!=="svelte-soa7d4"&&(er.textContent=Ai),Lo.forEach(o),zn=n(e),g(jt.$$.fragment,e),Wn=n(e),W=c(e,"DIV",{class:!0});var re=P(W);g(xt.$$.fragment,re),As=n(re),tr=c(re,"P",{"data-svelte-h":!0}),v(tr)!=="svelte-16vc34i"&&(tr.innerHTML=Si),Ss=n(re),or=c(re,"P",{"data-svelte-h":!0}),v(or)!=="svelte-o55m63"&&(or.innerHTML=Oi),Os=n(re),g(Ie.$$.fragment,re),re.forEach(o),Bn=n(e),g(Ct.$$.fragment,e),Nn=n(e),B=c(e,"DIV",{class:!0});var ne=P(B);g(kt.$$.fragment,ne),Ys=n(ne),rr=c(ne,"P",{"data-svelte-h":!0}),v(rr)!=="svelte-qvnww0"&&(rr.textContent=Yi),Qs=n(ne),nr=c(ne,"P",{"data-svelte-h":!0}),v(nr)!=="svelte-1c3t5ty"&&(nr.innerHTML=Qi),Ks=n(ne),Ue=c(ne,"DIV",{class:!0});var Ho=P(Ue);g(Jt.$$.fragment,Ho),ea=n(Ho),sr=c(Ho,"P",{"data-svelte-h":!0}),v(sr)!=="svelte-kpxj0c"&&(sr.textContent=Ki),Ho.forEach(o),ne.forEach(o),qn=n(e),g(Ft.$$.fragment,e),Gn=n(e),me=c(e,"DIV",{class:!0});var Ro=P(me);g(It.$$.fragment,Ro),ta=n(Ro),Ze=c(Ro,"DIV",{class:!0});var Do=P(Ze);g(Ut.$$.fragment,Do),oa=n(Do),ar=c(Do,"P",{"data-svelte-h":!0}),v(ar)!=="svelte-khengj"&&(ar.textContent=el),Do.forEach(o),Ro.forEach(o),Vn=n(e),g(Zt.$$.fragment,e),Ln=n(e),S=c(e,"DIV",{class:!0});var we=P(S);g(zt.$$.fragment,we),ra=n(we),ir=c(we,"P",{"data-svelte-h":!0}),v(ir)!=="svelte-2cuwar"&&(ir.textContent=tl),na=n(we),ze=c(we,"DIV",{class:!0});var Xo=P(ze);g(Wt.$$.fragment,Xo),sa=n(Xo),lr=c(Xo,"P",{"data-svelte-h":!0}),v(lr)!=="svelte-1x3yxsa"&&(lr.textContent=ol),Xo.forEach(o),we.forEach(o),Hn=n(e),g(Bt.$$.fragment,e),Rn=n(e),O=c(e,"DIV",{class:!0});var Pe=P(O);g(Nt.$$.fragment,Pe),aa=n(Pe),cr=c(Pe,"P",{"data-svelte-h":!0}),v(cr)!=="svelte-14oxh6f"&&(cr.innerHTML=rl),ia=n(Pe),dr=c(Pe,"P",{"data-svelte-h":!0}),v(dr)!=="svelte-10ewy9s"&&(dr.innerHTML=nl),Pe.forEach(o),Dn=n(e),g(qt.$$.fragment,e),Xn=n(e),Y=c(e,"DIV",{class:!0});var $e=P(Y);g(Gt.$$.fragment,$e),la=n($e),pr=c($e,"P",{"data-svelte-h":!0}),v(pr)!=="svelte-qqdw41"&&(pr.textContent=sl),ca=n($e),mr=c($e,"P",{"data-svelte-h":!0}),v(mr)!=="svelte-8bldbv"&&(mr.innerHTML=al),$e.forEach(o),En=n(e),g(Vt.$$.fragment,e),An=n(e),ge=c(e,"DIV",{class:!0});var Eo=P(ge);g(Lt.$$.fragment,Eo),da=n(Eo),gr=c(Eo,"P",{"data-svelte-h":!0}),v(gr)!=="svelte-dy213u"&&(gr.textContent=il),Eo.forEach(o),Sn=n(e),g(Ht.$$.fragment,e),On=n(e),he=c(e,"DIV",{class:!0});var Ao=P(he);g(Rt.$$.fragment,Ao),pa=n(Ao),hr=c(Ao,"P",{"data-svelte-h":!0}),v(hr)!=="svelte-yuiep6"&&(hr.textContent=ll),Ao.forEach(o),Yn=n(e),g(Dt.$$.fragment,e),Qn=n(e),Q=c(e,"DIV",{class:!0});var je=P(Q);g(Xt.$$.fragment,je),ma=n(je),ur=c(je,"P",{"data-svelte-h":!0}),v(ur)!=="svelte-1ktcovi"&&(ur.textContent=cl),ga=n(je),fr=c(je,"P",{"data-svelte-h":!0}),v(fr)!=="svelte-6kslc1"&&(fr.textContent=dl),je.forEach(o),Kn=n(e),g(Et.$$.fragment,e),es=n(e),ue=c(e,"DIV",{class:!0});var So=P(ue);g(At.$$.fragment,So),ha=n(So),_r=c(So,"P",{"data-svelte-h":!0}),v(_r)!=="svelte-y6ydlz"&&(_r.textContent=pl),So.forEach(o),ts=n(e),g(St.$$.fragment,e),os=n(e),K=c(e,"DIV",{class:!0});var xe=P(K);g(Ot.$$.fragment,xe),ua=n(xe),vr=c(xe,"P",{"data-svelte-h":!0}),v(vr)!=="svelte-1kkn2my"&&(vr.textContent=ml),fa=n(xe),br=c(xe,"P",{"data-svelte-h":!0}),v(br)!=="svelte-1rw0gn5"&&(br.textContent=gl),xe.forEach(o),rs=n(e),g(Yt.$$.fragment,e),ns=n(e),fe=c(e,"DIV",{class:!0});var Oo=P(fe);g(Qt.$$.fragment,Oo),_a=n(Oo),yr=c(Oo,"P",{"data-svelte-h":!0}),v(yr)!=="svelte-2naf7r"&&(yr.innerHTML=hl),Oo.forEach(o),ss=n(e),g(Kt.$$.fragment,e),as=n(e),_e=c(e,"DIV",{class:!0});var Ns=P(_e);g(eo.$$.fragment,Ns),va=n(Ns),Mr=c(Ns,"P",{"data-svelte-h":!0}),v(Mr)!=="svelte-5i43m6"&&(Mr.textContent=ul),Ns.forEach(o),is=n(e),g(to.$$.fragment,e),ls=n(e),ve=c(e,"DIV",{class:!0});var qs=P(ve);g(oo.$$.fragment,qs),ba=n(qs),Tr=c(qs,"P",{"data-svelte-h":!0}),v(Tr)!=="svelte-ker3kf"&&(Tr.innerHTML=fl),qs.forEach(o),cs=n(e),g(ro.$$.fragment,e),ds=n(e),ee=c(e,"DIV",{class:!0});var dn=P(ee);g(no.$$.fragment,dn),ya=n(dn),wr=c(dn,"P",{"data-svelte-h":!0}),v(wr)!=="svelte-bcnwvf"&&(wr.innerHTML=_l),Ma=n(dn),Pr=c(dn,"P",{"data-svelte-h":!0}),v(Pr)!=="svelte-1hdadgl"&&(Pr.textContent=vl),dn.forEach(o),ps=n(e),g(so.$$.fragment,e),ms=n(e),be=c(e,"DIV",{class:!0});var Gs=P(be);g(ao.$$.fragment,Gs),Ta=n(Gs),$r=c(Gs,"P",{"data-svelte-h":!0}),v($r)!=="svelte-ko0545"&&($r.textContent=bl),Gs.forEach(o),gs=n(e),g(io.$$.fragment,e),hs=n(e),ye=c(e,"DIV",{class:!0});var Vs=P(ye);g(lo.$$.fragment,Vs),wa=n(Vs),jr=c(Vs,"P",{"data-svelte-h":!0}),v(jr)!=="svelte-19fogj5"&&(jr.textContent=yl),Vs.forEach(o),us=n(e),g(co.$$.fragment,e),fs=n(e),Me=c(e,"DIV",{class:!0});var Ls=P(Me);g(po.$$.fragment,Ls),Pa=n(Ls),xr=c(Ls,"P",{"data-svelte-h":!0}),v(xr)!=="svelte-1kv6g6a"&&(xr.textContent=Ml),Ls.forEach(o),_s=n(e),g(mo.$$.fragment,e),vs=n(e),Te=c(e,"DIV",{class:!0});var Hs=P(Te);g(go.$$.fragment,Hs),$a=n(Hs),Cr=c(Hs,"P",{"data-svelte-h":!0}),v(Cr)!=="svelte-16bd8vx"&&(Cr.textContent=Tl),Hs.forEach(o),bs=n(e),g(ho.$$.fragment,e),ys=n(e),Z=c(e,"DIV",{class:!0});var se=P(Z);g(uo.$$.fragment,se),ja=n(se),kr=c(se,"P",{"data-svelte-h":!0}),v(kr)!=="svelte-jeiqrc"&&(kr.textContent=wl),xa=n(se),g(We.$$.fragment,se),Ca=n(se),Jr=c(se,"P",{"data-svelte-h":!0}),v(Jr)!=="svelte-68lg8f"&&(Jr.innerHTML=Pl),ka=n(se),N=c(se,"DIV",{class:!0});var Ke=P(N);g(fo.$$.fragment,Ke),Ja=n(Ke),Fr=c(Ke,"P",{"data-svelte-h":!0}),v(Fr)!=="svelte-bbo544"&&(Fr.innerHTML=$l),Fa=n(Ke),g(Be.$$.fragment,Ke),Ia=n(Ke),g(Ne.$$.fragment,Ke),Ke.forEach(o),se.forEach(o),Ms=n(e),g(_o.$$.fragment,e),Ts=n(e),te=c(e,"DIV",{class:!0});var pn=P(te);g(vo.$$.fragment,pn),Ua=n(pn),Ir=c(pn,"P",{"data-svelte-h":!0}),v(Ir)!=="svelte-15ycigb"&&(Ir.innerHTML=jl),Za=n(pn),q=c(pn,"DIV",{class:!0});var et=P(q);g(bo.$$.fragment,et),za=n(et),Ur=c(et,"P",{"data-svelte-h":!0}),v(Ur)!=="svelte-1i9anqc"&&(Ur.innerHTML=xl),Wa=n(et),g(qe.$$.fragment,et),Ba=n(et),g(Ge.$$.fragment,et),et.forEach(o),pn.forEach(o),ws=n(e),g(yo.$$.fragment,e),Ps=n(e),oe=c(e,"DIV",{class:!0});var mn=P(oe);g(Mo.$$.fragment,mn),Na=n(mn),Zr=c(mn,"P",{"data-svelte-h":!0}),v(Zr)!=="svelte-a1b1mu"&&(Zr.innerHTML=Cl),qa=n(mn),G=c(mn,"DIV",{class:!0});var tt=P(G);g(To.$$.fragment,tt),Ga=n(tt),zr=c(tt,"P",{"data-svelte-h":!0}),v(zr)!=="svelte-xw807e"&&(zr.innerHTML=kl),Va=n(tt),g(Ve.$$.fragment,tt),La=n(tt),g(Le.$$.fragment,tt),tt.forEach(o),mn.forEach(o),$s=n(e),g(wo.$$.fragment,e),js=n(e),F=c(e,"DIV",{class:!0});var X=P(F);g(Po.$$.fragment,X),Ha=n(X),Wr=c(X,"P",{"data-svelte-h":!0}),v(Wr)!=="svelte-14sixf"&&(Wr.textContent=Jl),Ra=n(X),Br=c(X,"P",{"data-svelte-h":!0}),v(Br)!=="svelte-7wi9f7"&&(Br.textContent=Fl),Da=n(X),Nr=c(X,"P",{"data-svelte-h":!0}),v(Nr)!=="svelte-186j94c"&&(Nr.innerHTML=Il),Xa=n(X),qr=c(X,"P",{"data-svelte-h":!0}),v(qr)!=="svelte-68lg8f"&&(qr.innerHTML=Ul),Ea=n(X),V=c(X,"DIV",{class:!0});var ot=P(V);g($o.$$.fragment,ot),Aa=n(ot),Gr=c(ot,"P",{"data-svelte-h":!0}),v(Gr)!=="svelte-1vqh0cs"&&(Gr.innerHTML=Zl),Sa=n(ot),g(He.$$.fragment,ot),Oa=n(ot),g(Re.$$.fragment,ot),ot.forEach(o),X.forEach(o),xs=n(e),g(jo.$$.fragment,e),Cs=n(e),I=c(e,"DIV",{class:!0});var E=P(I);g(xo.$$.fragment,E),Ya=n(E),Vr=c(E,"P",{"data-svelte-h":!0}),v(Vr)!=="svelte-14sixf"&&(Vr.textContent=zl),Qa=n(E),Lr=c(E,"P",{"data-svelte-h":!0}),v(Lr)!=="svelte-8ozzz2"&&(Lr.textContent=Wl),Ka=n(E),Hr=c(E,"P",{"data-svelte-h":!0}),v(Hr)!=="svelte-m4n2j9"&&(Hr.innerHTML=Bl),ei=n(E),Rr=c(E,"P",{"data-svelte-h":!0}),v(Rr)!=="svelte-68lg8f"&&(Rr.innerHTML=Nl),ti=n(E),L=c(E,"DIV",{class:!0});var rt=P(L);g(Co.$$.fragment,rt),oi=n(rt),Dr=c(rt,"P",{"data-svelte-h":!0}),v(Dr)!=="svelte-1ww2kje"&&(Dr.innerHTML=ql),ri=n(rt),g(De.$$.fragment,rt),ni=n(rt),g(Xe.$$.fragment,rt),rt.forEach(o),E.forEach(o),ks=n(e),g(ko.$$.fragment,e),Js=n(e),U=c(e,"DIV",{class:!0});var A=P(U);g(Jo.$$.fragment,A),si=n(A),Xr=c(A,"P",{"data-svelte-h":!0}),v(Xr)!=="svelte-14sixf"&&(Xr.textContent=Gl),ai=n(A),Er=c(A,"P",{"data-svelte-h":!0}),v(Er)!=="svelte-tp3lrm"&&(Er.textContent=Vl),ii=n(A),Ar=c(A,"P",{"data-svelte-h":!0}),v(Ar)!=="svelte-1jqmhdk"&&(Ar.innerHTML=Ll),li=n(A),Sr=c(A,"P",{"data-svelte-h":!0}),v(Sr)!=="svelte-68lg8f"&&(Sr.innerHTML=Hl),ci=n(A),H=c(A,"DIV",{class:!0});var nt=P(H);g(Fo.$$.fragment,nt),di=n(nt),Or=c(nt,"P",{"data-svelte-h":!0}),v(Or)!=="svelte-1q75rzw"&&(Or.innerHTML=Rl),pi=n(nt),g(Ee.$$.fragment,nt),mi=n(nt),g(Ae.$$.fragment,nt),nt.forEach(o),A.forEach(o),Fs=n(e),g(Io.$$.fragment,e),Is=n(e),z=c(e,"DIV",{class:!0});var ae=P(z);g(Uo.$$.fragment,ae),gi=n(ae),Yr=c(ae,"P",{"data-svelte-h":!0}),v(Yr)!=="svelte-10ms8rq"&&(Yr.innerHTML=Dl),hi=n(ae),Qr=c(ae,"P",{"data-svelte-h":!0}),v(Qr)!=="svelte-15z6y2c"&&(Qr.textContent=Xl),ui=n(ae),Kr=c(ae,"P",{"data-svelte-h":!0}),v(Kr)!=="svelte-68lg8f"&&(Kr.innerHTML=El),fi=n(ae),R=c(ae,"DIV",{class:!0});var st=P(R);g(Zo.$$.fragment,st),_i=n(st),en=c(st,"P",{"data-svelte-h":!0}),v(en)!=="svelte-1ksfz70"&&(en.innerHTML=Al),vi=n(st),g(Se.$$.fragment,st),bi=n(st),g(Oe.$$.fragment,st),st.forEach(o),ae.forEach(o),Us=n(e),g(zo.$$.fragment,e),Zs=n(e),C=c(e,"DIV",{class:!0});var J=P(C);g(Wo.$$.fragment,J),yi=n(J),tn=c(J,"P",{"data-svelte-h":!0}),v(tn)!=="svelte-1oaen3m"&&(tn.textContent=Sl),Mi=n(J),on=c(J,"P",{"data-svelte-h":!0}),v(on)!=="svelte-1z5l98"&&(on.innerHTML=Ol),Ti=n(J),rn=c(J,"P",{"data-svelte-h":!0}),v(rn)!=="svelte-a602dh"&&(rn.innerHTML=Yl),wi=n(J),nn=c(J,"P",{"data-svelte-h":!0}),v(nn)!=="svelte-slizoj"&&(nn.innerHTML=Ql),Pi=n(J),sn=c(J,"P",{"data-svelte-h":!0}),v(sn)!=="svelte-1hs9g1p"&&(sn.innerHTML=Kl),$i=n(J),an=c(J,"P",{"data-svelte-h":!0}),v(an)!=="svelte-1ic9umv"&&(an.textContent=ec),ji=n(J),ln=c(J,"P",{"data-svelte-h":!0}),v(ln)!=="svelte-68lg8f"&&(ln.innerHTML=tc),xi=n(J),D=c(J,"DIV",{class:!0});var at=P(D);g(Bo.$$.fragment,at),Ci=n(at),cn=c(at,"P",{"data-svelte-h":!0}),v(cn)!=="svelte-8u2iso"&&(cn.innerHTML=oc),ki=n(at),g(Ye.$$.fragment,at),Ji=n(at),g(Qe.$$.fragment,at),at.forEach(o),J.forEach(o),zs=n(e),g(No.$$.fragment,e),Ws=n(e),gn=c(e,"P",{}),P(gn).forEach(o),this.h()},h(){T(a,"name","hf:doc:metadata"),T(a,"content",Jc),T(w,"class","flex flex-wrap space-x-1"),nc(Je.src,Vi="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/perceiver_architecture.jpg")||T(Je,"src",Vi),T(Je,"alt","drawing"),T(Je,"width","600"),T(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,a),i(e,y,t),i(e,p,t),i(e,b,t),h(M,e,t),i(e,d,t),i(e,w,t),i(e,hn,t),h(it,e,t),i(e,un,t),i(e,lt,t),i(e,fn,t),i(e,ct,t),i(e,_n,t),i(e,dt,t),i(e,vn,t),i(e,pt,t),i(e,bn,t),i(e,mt,t),i(e,yn,t),i(e,gt,t),i(e,Mn,t),i(e,ht,t),i(e,Tn,t),i(e,ut,t),i(e,wn,t),i(e,ft,t),i(e,Pn,t),i(e,Je,t),i(e,$n,t),i(e,_t,t),i(e,jn,t),i(e,vt,t),i(e,xn,t),h(Fe,e,t),i(e,Cn,t),h(bt,e,t),i(e,kn,t),i(e,yt,t),i(e,Jn,t),h(Mt,e,t),i(e,Fn,t),i(e,le,t),h(Tt,le,null),s(le,Rs),s(le,Yo),i(e,In,t),i(e,ce,t),h(wt,ce,null),s(ce,Ds),s(ce,Qo),i(e,Un,t),i(e,de,t),h(Pt,de,null),s(de,Xs),s(de,Ko),i(e,Zn,t),i(e,pe,t),h($t,pe,null),s(pe,Es),s(pe,er),i(e,zn,t),h(jt,e,t),i(e,Wn,t),i(e,W,t),h(xt,W,null),s(W,As),s(W,tr),s(W,Ss),s(W,or),s(W,Os),h(Ie,W,null),i(e,Bn,t),h(Ct,e,t),i(e,Nn,t),i(e,B,t),h(kt,B,null),s(B,Ys),s(B,rr),s(B,Qs),s(B,nr),s(B,Ks),s(B,Ue),h(Jt,Ue,null),s(Ue,ea),s(Ue,sr),i(e,qn,t),h(Ft,e,t),i(e,Gn,t),i(e,me,t),h(It,me,null),s(me,ta),s(me,Ze),h(Ut,Ze,null),s(Ze,oa),s(Ze,ar),i(e,Vn,t),h(Zt,e,t),i(e,Ln,t),i(e,S,t),h(zt,S,null),s(S,ra),s(S,ir),s(S,na),s(S,ze),h(Wt,ze,null),s(ze,sa),s(ze,lr),i(e,Hn,t),h(Bt,e,t),i(e,Rn,t),i(e,O,t),h(Nt,O,null),s(O,aa),s(O,cr),s(O,ia),s(O,dr),i(e,Dn,t),h(qt,e,t),i(e,Xn,t),i(e,Y,t),h(Gt,Y,null),s(Y,la),s(Y,pr),s(Y,ca),s(Y,mr),i(e,En,t),h(Vt,e,t),i(e,An,t),i(e,ge,t),h(Lt,ge,null),s(ge,da),s(ge,gr),i(e,Sn,t),h(Ht,e,t),i(e,On,t),i(e,he,t),h(Rt,he,null),s(he,pa),s(he,hr),i(e,Yn,t),h(Dt,e,t),i(e,Qn,t),i(e,Q,t),h(Xt,Q,null),s(Q,ma),s(Q,ur),s(Q,ga),s(Q,fr),i(e,Kn,t),h(Et,e,t),i(e,es,t),i(e,ue,t),h(At,ue,null),s(ue,ha),s(ue,_r),i(e,ts,t),h(St,e,t),i(e,os,t),i(e,K,t),h(Ot,K,null),s(K,ua),s(K,vr),s(K,fa),s(K,br),i(e,rs,t),h(Yt,e,t),i(e,ns,t),i(e,fe,t),h(Qt,fe,null),s(fe,_a),s(fe,yr),i(e,ss,t),h(Kt,e,t),i(e,as,t),i(e,_e,t),h(eo,_e,null),s(_e,va),s(_e,Mr),i(e,is,t),h(to,e,t),i(e,ls,t),i(e,ve,t),h(oo,ve,null),s(ve,ba),s(ve,Tr),i(e,cs,t),h(ro,e,t),i(e,ds,t),i(e,ee,t),h(no,ee,null),s(ee,ya),s(ee,wr),s(ee,Ma),s(ee,Pr),i(e,ps,t),h(so,e,t),i(e,ms,t),i(e,be,t),h(ao,be,null),s(be,Ta),s(be,$r),i(e,gs,t),h(io,e,t),i(e,hs,t),i(e,ye,t),h(lo,ye,null),s(ye,wa),s(ye,jr),i(e,us,t),h(co,e,t),i(e,fs,t),i(e,Me,t),h(po,Me,null),s(Me,Pa),s(Me,xr),i(e,_s,t),h(mo,e,t),i(e,vs,t),i(e,Te,t),h(go,Te,null),s(Te,$a),s(Te,Cr),i(e,bs,t),h(ho,e,t),i(e,ys,t),i(e,Z,t),h(uo,Z,null),s(Z,ja),s(Z,kr),s(Z,xa),h(We,Z,null),s(Z,Ca),s(Z,Jr),s(Z,ka),s(Z,N),h(fo,N,null),s(N,Ja),s(N,Fr),s(N,Fa),h(Be,N,null),s(N,Ia),h(Ne,N,null),i(e,Ms,t),h(_o,e,t),i(e,Ts,t),i(e,te,t),h(vo,te,null),s(te,Ua),s(te,Ir),s(te,Za),s(te,q),h(bo,q,null),s(q,za),s(q,Ur),s(q,Wa),h(qe,q,null),s(q,Ba),h(Ge,q,null),i(e,ws,t),h(yo,e,t),i(e,Ps,t),i(e,oe,t),h(Mo,oe,null),s(oe,Na),s(oe,Zr),s(oe,qa),s(oe,G),h(To,G,null),s(G,Ga),s(G,zr),s(G,Va),h(Ve,G,null),s(G,La),h(Le,G,null),i(e,$s,t),h(wo,e,t),i(e,js,t),i(e,F,t),h(Po,F,null),s(F,Ha),s(F,Wr),s(F,Ra),s(F,Br),s(F,Da),s(F,Nr),s(F,Xa),s(F,qr),s(F,Ea),s(F,V),h($o,V,null),s(V,Aa),s(V,Gr),s(V,Sa),h(He,V,null),s(V,Oa),h(Re,V,null),i(e,xs,t),h(jo,e,t),i(e,Cs,t),i(e,I,t),h(xo,I,null),s(I,Ya),s(I,Vr),s(I,Qa),s(I,Lr),s(I,Ka),s(I,Hr),s(I,ei),s(I,Rr),s(I,ti),s(I,L),h(Co,L,null),s(L,oi),s(L,Dr),s(L,ri),h(De,L,null),s(L,ni),h(Xe,L,null),i(e,ks,t),h(ko,e,t),i(e,Js,t),i(e,U,t),h(Jo,U,null),s(U,si),s(U,Xr),s(U,ai),s(U,Er),s(U,ii),s(U,Ar),s(U,li),s(U,Sr),s(U,ci),s(U,H),h(Fo,H,null),s(H,di),s(H,Or),s(H,pi),h(Ee,H,null),s(H,mi),h(Ae,H,null),i(e,Fs,t),h(Io,e,t),i(e,Is,t),i(e,z,t),h(Uo,z,null),s(z,gi),s(z,Yr),s(z,hi),s(z,Qr),s(z,ui),s(z,Kr),s(z,fi),s(z,R),h(Zo,R,null),s(R,_i),s(R,en),s(R,vi),h(Se,R,null),s(R,bi),h(Oe,R,null),i(e,Us,t),h(zo,e,t),i(e,Zs,t),i(e,C,t),h(Wo,C,null),s(C,yi),s(C,tn),s(C,Mi),s(C,on),s(C,Ti),s(C,rn),s(C,wi),s(C,nn),s(C,Pi),s(C,sn),s(C,$i),s(C,an),s(C,ji),s(C,ln),s(C,xi),s(C,D),h(Bo,D,null),s(D,Ci),s(D,cn),s(D,ki),h(Ye,D,null),s(D,Ji),h(Qe,D,null),i(e,zs,t),h(No,e,t),i(e,Ws,t),i(e,gn,t),Bs=!0},p(e,[t]){const qo={};t&2&&(qo.$$scope={dirty:t,ctx:e}),Fe.$set(qo);const Go={};t&2&&(Go.$$scope={dirty:t,ctx:e}),Ie.$set(Go);const Vo={};t&2&&(Vo.$$scope={dirty:t,ctx:e}),We.$set(Vo);const Lo={};t&2&&(Lo.$$scope={dirty:t,ctx:e}),Be.$set(Lo);const re={};t&2&&(re.$$scope={dirty:t,ctx:e}),Ne.$set(re);const ne={};t&2&&(ne.$$scope={dirty:t,ctx:e}),qe.$set(ne);const Ho={};t&2&&(Ho.$$scope={dirty:t,ctx:e}),Ge.$set(Ho);const Ro={};t&2&&(Ro.$$scope={dirty:t,ctx:e}),Ve.$set(Ro);const Do={};t&2&&(Do.$$scope={dirty:t,ctx:e}),Le.$set(Do);const we={};t&2&&(we.$$scope={dirty:t,ctx:e}),He.$set(we);const Xo={};t&2&&(Xo.$$scope={dirty:t,ctx:e}),Re.$set(Xo);const Pe={};t&2&&(Pe.$$scope={dirty:t,ctx:e}),De.$set(Pe);const $e={};t&2&&($e.$$scope={dirty:t,ctx:e}),Xe.$set($e);const Eo={};t&2&&(Eo.$$scope={dirty:t,ctx:e}),Ee.$set(Eo);const Ao={};t&2&&(Ao.$$scope={dirty:t,ctx:e}),Ae.$set(Ao);const je={};t&2&&(je.$$scope={dirty:t,ctx:e}),Se.$set(je);const So={};t&2&&(So.$$scope={dirty:t,ctx:e}),Oe.$set(So);const xe={};t&2&&(xe.$$scope={dirty:t,ctx:e}),Ye.$set(xe);const Oo={};t&2&&(Oo.$$scope={dirty:t,ctx:e}),Qe.$set(Oo)},i(e){Bs||(u(M.$$.fragment,e),u(it.$$.fragment,e),u(Fe.$$.fragment,e),u(bt.$$.fragment,e),u(Mt.$$.fragment,e),u(Tt.$$.fragment,e),u(wt.$$.fragment,e),u(Pt.$$.fragment,e),u($t.$$.fragment,e),u(jt.$$.fragment,e),u(xt.$$.fragment,e),u(Ie.$$.fragment,e),u(Ct.$$.fragment,e),u(kt.$$.fragment,e),u(Jt.$$.fragment,e),u(Ft.$$.fragment,e),u(It.$$.fragment,e),u(Ut.$$.fragment,e),u(Zt.$$.fragment,e),u(zt.$$.fragment,e),u(Wt.$$.fragment,e),u(Bt.$$.fragment,e),u(Nt.$$.fragment,e),u(qt.$$.fragment,e),u(Gt.$$.fragment,e),u(Vt.$$.fragment,e),u(Lt.$$.fragment,e),u(Ht.$$.fragment,e),u(Rt.$$.fragment,e),u(Dt.$$.fragment,e),u(Xt.$$.fragment,e),u(Et.$$.fragment,e),u(At.$$.fragment,e),u(St.$$.fragment,e),u(Ot.$$.fragment,e),u(Yt.$$.fragment,e),u(Qt.$$.fragment,e),u(Kt.$$.fragment,e),u(eo.$$.fragment,e),u(to.$$.fragment,e),u(oo.$$.fragment,e),u(ro.$$.fragment,e),u(no.$$.fragment,e),u(so.$$.fragment,e),u(ao.$$.fragment,e),u(io.$$.fragment,e),u(lo.$$.fragment,e),u(co.$$.fragment,e),u(po.$$.fragment,e),u(mo.$$.fragment,e),u(go.$$.fragment,e),u(ho.$$.fragment,e),u(uo.$$.fragment,e),u(We.$$.fragment,e),u(fo.$$.fragment,e),u(Be.$$.fragment,e),u(Ne.$$.fragment,e),u(_o.$$.fragment,e),u(vo.$$.fragment,e),u(bo.$$.fragment,e),u(qe.$$.fragment,e),u(Ge.$$.fragment,e),u(yo.$$.fragment,e),u(Mo.$$.fragment,e),u(To.$$.fragment,e),u(Ve.$$.fragment,e),u(Le.$$.fragment,e),u(wo.$$.fragment,e),u(Po.$$.fragment,e),u($o.$$.fragment,e),u(He.$$.fragment,e),u(Re.$$.fragment,e),u(jo.$$.fragment,e),u(xo.$$.fragment,e),u(Co.$$.fragment,e),u(De.$$.fragment,e),u(Xe.$$.fragment,e),u(ko.$$.fragment,e),u(Jo.$$.fragment,e),u(Fo.$$.fragment,e),u(Ee.$$.fragment,e),u(Ae.$$.fragment,e),u(Io.$$.fragment,e),u(Uo.$$.fragment,e),u(Zo.$$.fragment,e),u(Se.$$.fragment,e),u(Oe.$$.fragment,e),u(zo.$$.fragment,e),u(Wo.$$.fragment,e),u(Bo.$$.fragment,e),u(Ye.$$.fragment,e),u(Qe.$$.fragment,e),u(No.$$.fragment,e),Bs=!0)},o(e){f(M.$$.fragment,e),f(it.$$.fragment,e),f(Fe.$$.fragment,e),f(bt.$$.fragment,e),f(Mt.$$.fragment,e),f(Tt.$$.fragment,e),f(wt.$$.fragment,e),f(Pt.$$.fragment,e),f($t.$$.fragment,e),f(jt.$$.fragment,e),f(xt.$$.fragment,e),f(Ie.$$.fragment,e),f(Ct.$$.fragment,e),f(kt.$$.fragment,e),f(Jt.$$.fragment,e),f(Ft.$$.fragment,e),f(It.$$.fragment,e),f(Ut.$$.fragment,e),f(Zt.$$.fragment,e),f(zt.$$.fragment,e),f(Wt.$$.fragment,e),f(Bt.$$.fragment,e),f(Nt.$$.fragment,e),f(qt.$$.fragment,e),f(Gt.$$.fragment,e),f(Vt.$$.fragment,e),f(Lt.$$.fragment,e),f(Ht.$$.fragment,e),f(Rt.$$.fragment,e),f(Dt.$$.fragment,e),f(Xt.$$.fragment,e),f(Et.$$.fragment,e),f(At.$$.fragment,e),f(St.$$.fragment,e),f(Ot.$$.fragment,e),f(Yt.$$.fragment,e),f(Qt.$$.fragment,e),f(Kt.$$.fragment,e),f(eo.$$.fragment,e),f(to.$$.fragment,e),f(oo.$$.fragment,e),f(ro.$$.fragment,e),f(no.$$.fragment,e),f(so.$$.fragment,e),f(ao.$$.fragment,e),f(io.$$.fragment,e),f(lo.$$.fragment,e),f(co.$$.fragment,e),f(po.$$.fragment,e),f(mo.$$.fragment,e),f(go.$$.fragment,e),f(ho.$$.fragment,e),f(uo.$$.fragment,e),f(We.$$.fragment,e),f(fo.$$.fragment,e),f(Be.$$.fragment,e),f(Ne.$$.fragment,e),f(_o.$$.fragment,e),f(vo.$$.fragment,e),f(bo.$$.fragment,e),f(qe.$$.fragment,e),f(Ge.$$.fragment,e),f(yo.$$.fragment,e),f(Mo.$$.fragment,e),f(To.$$.fragment,e),f(Ve.$$.fragment,e),f(Le.$$.fragment,e),f(wo.$$.fragment,e),f(Po.$$.fragment,e),f($o.$$.fragment,e),f(He.$$.fragment,e),f(Re.$$.fragment,e),f(jo.$$.fragment,e),f(xo.$$.fragment,e),f(Co.$$.fragment,e),f(De.$$.fragment,e),f(Xe.$$.fragment,e),f(ko.$$.fragment,e),f(Jo.$$.fragment,e),f(Fo.$$.fragment,e),f(Ee.$$.fragment,e),f(Ae.$$.fragment,e),f(Io.$$.fragment,e),f(Uo.$$.fragment,e),f(Zo.$$.fragment,e),f(Se.$$.fragment,e),f(Oe.$$.fragment,e),f(zo.$$.fragment,e),f(Wo.$$.fragment,e),f(Bo.$$.fragment,e),f(Ye.$$.fragment,e),f(Qe.$$.fragment,e),f(No.$$.fragment,e),Bs=!1},d(e){e&&(o(y),o(p),o(b),o(d),o(w),o(hn),o(un),o(lt),o(fn),o(ct),o(_n),o(dt),o(vn),o(pt),o(bn),o(mt),o(yn),o(gt),o(Mn),o(ht),o(Tn),o(ut),o(wn),o(ft),o(Pn),o(Je),o($n),o(_t),o(jn),o(vt),o(xn),o(Cn),o(kn),o(yt),o(Jn),o(Fn),o(le),o(In),o(ce),o(Un),o(de),o(Zn),o(pe),o(zn),o(Wn),o(W),o(Bn),o(Nn),o(B),o(qn),o(Gn),o(me),o(Vn),o(Ln),o(S),o(Hn),o(Rn),o(O),o(Dn),o(Xn),o(Y),o(En),o(An),o(ge),o(Sn),o(On),o(he),o(Yn),o(Qn),o(Q),o(Kn),o(es),o(ue),o(ts),o(os),o(K),o(rs),o(ns),o(fe),o(ss),o(as),o(_e),o(is),o(ls),o(ve),o(cs),o(ds),o(ee),o(ps),o(ms),o(be),o(gs),o(hs),o(ye),o(us),o(fs),o(Me),o(_s),o(vs),o(Te),o(bs),o(ys),o(Z),o(Ms),o(Ts),o(te),o(ws),o(Ps),o(oe),o($s),o(js),o(F),o(xs),o(Cs),o(I),o(ks),o(Js),o(U),o(Fs),o(Is),o(z),o(Us),o(Zs),o(C),o(zs),o(Ws),o(gn)),o(a),_(M,e),_(it,e),_(Fe,e),_(bt,e),_(Mt,e),_(Tt),_(wt),_(Pt),_($t),_(jt,e),_(xt),_(Ie),_(Ct,e),_(kt),_(Jt),_(Ft,e),_(It),_(Ut),_(Zt,e),_(zt),_(Wt),_(Bt,e),_(Nt),_(qt,e),_(Gt),_(Vt,e),_(Lt),_(Ht,e),_(Rt),_(Dt,e),_(Xt),_(Et,e),_(At),_(St,e),_(Ot),_(Yt,e),_(Qt),_(Kt,e),_(eo),_(to,e),_(oo),_(ro,e),_(no),_(so,e),_(ao),_(io,e),_(lo),_(co,e),_(po),_(mo,e),_(go),_(ho,e),_(uo),_(We),_(fo),_(Be),_(Ne),_(_o,e),_(vo),_(bo),_(qe),_(Ge),_(yo,e),_(Mo),_(To),_(Ve),_(Le),_(wo,e),_(Po),_($o),_(He),_(Re),_(jo,e),_(xo),_(Co),_(De),_(Xe),_(ko,e),_(Jo),_(Fo),_(Ee),_(Ae),_(Io,e),_(Uo),_(Zo),_(Se),_(Oe),_(zo,e),_(Wo),_(Bo),_(Ye),_(Qe),_(No,e)}}}const Jc='{"title":"Perceiver","local":"perceiver","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Perceiver specific outputs","local":"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput","sections":[],"depth":2},{"title":"PerceiverConfig","local":"transformers.PerceiverConfig","sections":[],"depth":2},{"title":"PerceiverTokenizer","local":"transformers.PerceiverTokenizer","sections":[],"depth":2},{"title":"PerceiverFeatureExtractor","local":"transformers.PerceiverFeatureExtractor","sections":[],"depth":2},{"title":"PerceiverImageProcessor","local":"transformers.PerceiverImageProcessor","sections":[],"depth":2},{"title":"PerceiverTextPreprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor","sections":[],"depth":2},{"title":"PerceiverImagePreprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor","sections":[],"depth":2},{"title":"PerceiverOneHotPreprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor","sections":[],"depth":2},{"title":"PerceiverAudioPreprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor","sections":[],"depth":2},{"title":"PerceiverMultimodalPreprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor","sections":[],"depth":2},{"title":"PerceiverProjectionDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder","sections":[],"depth":2},{"title":"PerceiverBasicDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder","sections":[],"depth":2},{"title":"PerceiverClassificationDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder","sections":[],"depth":2},{"title":"PerceiverOpticalFlowDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder","sections":[],"depth":2},{"title":"PerceiverBasicVideoAutoencodingDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder","sections":[],"depth":2},{"title":"PerceiverMultimodalDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder","sections":[],"depth":2},{"title":"PerceiverProjectionPostprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor","sections":[],"depth":2},{"title":"PerceiverAudioPostprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor","sections":[],"depth":2},{"title":"PerceiverClassificationPostprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor","sections":[],"depth":2},{"title":"PerceiverMultimodalPostprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor","sections":[],"depth":2},{"title":"PerceiverModel","local":"transformers.PerceiverModel","sections":[],"depth":2},{"title":"PerceiverForMaskedLM","local":"transformers.PerceiverForMaskedLM","sections":[],"depth":2},{"title":"PerceiverForSequenceClassification","local":"transformers.PerceiverForSequenceClassification","sections":[],"depth":2},{"title":"PerceiverForImageClassificationLearned","local":"transformers.PerceiverForImageClassificationLearned","sections":[],"depth":2},{"title":"PerceiverForImageClassificationFourier","local":"transformers.PerceiverForImageClassificationFourier","sections":[],"depth":2},{"title":"PerceiverForImageClassificationConvProcessing","local":"transformers.PerceiverForImageClassificationConvProcessing","sections":[],"depth":2},{"title":"PerceiverForOpticalFlow","local":"transformers.PerceiverForOpticalFlow","sections":[],"depth":2},{"title":"PerceiverForMultimodalAutoencoding","local":"transformers.PerceiverForMultimodalAutoencoding","sections":[],"depth":2}],"depth":1}';function Fc(j){return sc(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qc extends ac{constructor(a){super(),ic(this,a,Fc,kc,rc,{})}}export{qc as component};
