import{s as Xt,o as Vt,n as $t}from"../chunks/scheduler.01eeda35.js";import{S as Qt,i as Yt,g as n,s as t,r as U,A as zt,h as y,f as s,c as a,j as Nt,u as o,x as i,k as Et,y as St,a as M,v as p,d as w,t as j,w as T}from"../chunks/index.6dd51b66.js";import{T as xt}from"../chunks/Tip.de9bae2b.js";import{C as d}from"../chunks/CodeBlock.864da1b0.js";import{H as J,E as Ht}from"../chunks/EditOnGithub.7faefd25.js";function Ft(ue){let c,m="Modular Transformers isn’t meant to replace the modeling code, and if your model isn’t based on an existing model, you’ll need to add a <code>modeling.py</code> file manually. Likewise, if a configuration, tokenization or processing file can’t easily inherit from a similar file, you can add that file directly.";return{c(){c=n("p"),c.innerHTML=m},l(C){c=y(C,"P",{"data-svelte-h":!0}),i(c)!=="svelte-1wc3n5d"&&(c.innerHTML=m)},m(C,he){M(C,c,he)},p:$t,d(C){C&&s(c)}}}function Lt(ue){let c,m,C,he,h,Ae,I,bM="Modular Transformers lowers the bar for contributing models and significantly reduces the code required to add a model by allowing imports and inheritance.",fe,u,_M='One of Transformers’ core design feature is the <a href="https://huggingface.co/blog/transformers-design-philosophy" rel="nofollow">single model, single file</a> policy. Model components - such as attention layers - are repeated across many files and any independent implementations tend to diverge as fixes and changes are applied to specific parts of the code.',be,A,ZM='The <a href="./pr_checks#check-copies"><code># Copied from</code></a> statements prevents the code from diverging, and it is enforced by our continuous integration tests and local commands. The downside is that this approach is tedious and adds significantly more lines of code, most of which is boilerplate.',_e,f,Ze,b,GM="Modular Transformers addresses these issues by adding a <em>modular</em> file to a model folder. The modular file can import code from other models and inherit code from other classes unlike traditional modeling and processing files.",Ge,r,Be,_,BM="A modular file contains model, processor, and configuration class code that would otherwise be in separate files under the single model, single file policy.",Re,Z,RM="Model users still import and use the single-file interface they’ve grown familiar with. In doing so, we hope to enable simpler contributions while sticking to our philosophy.",ke,G,We,B,kM="A linter “unravels” the modular file into a <code>modeling.py</code> file to preserve the single model, single file directory structure (modeling, processor, etc.). Inheritance is flattened to only a <strong>single</strong> level.",ge,R,WM="Run the command below to automatically generate a <code>modeling.py</code> file from a modular file.",ve,k,Ne,W,gM="For example:",Ee,g,vM="<li>If a configuration class inherits from another class, but adds and deletes an argument, the generated file directly references it if an argument is added or completely removes it if an argument is deleted.</li> <li>If a class inherits from another, like <code>GemmaModel(LlamaModel)</code>, the dependencies are automatically inferred. All submodules are also automatically inferred from the superclass.</li> <li>If a new function is defined in the modular file and used inside classes, the linter automatically infers these as well.</li>",Xe,v,NM="You should be able to write everything (tokenizer, image processor, model, config, etc.) in a modular and their corresponding single-files are generated.",Ve,N,EM="Run the command below to ensure the generated content matches <code>modular_&lt;your_model&gt;.py</code>.",$e,E,Qe,X,XM="The example below demonstrates how a model can be added with significantly fewer lines of code with Modular Transformers.",Ye,V,ze,$,VM="BERT and RoBERTa, two very similar models, differ solely in how the embedding layer is implemented.",Se,Q,$M="Instead of redefining the model entirely, consider the <code>modular_roberta.py</code> file shown below for the modeling and configuration classes (the tokenizer isn’t shown in this example).",xe,Y,He,z,QM="If you don’t use the defined dependency, you’ll receive the following error.",Fe,S,Le,x,Oe,H,YM='The easiest way to start is by browsing Transformers for a model similar to yours in order to inherit from it. Some good starting points are <a href="./model_doc/mistral">Mistral</a>, <a href="./model_doc/qwen2">Qwen2</a>, <a href="./model_doc/cohere">Cohere</a> and <a href="./model_doc/cohere2">Cohere</a>, and <a href="./model_doc/llama">Llama</a>. Refer to the table below for components your model might be using and where you can inherit from.',De,F,zM="<thead><tr><th>Component</th> <th>Model</th></tr></thead> <tbody><tr><td>Mixture of expert</td> <td>SwitchTransformers or Mixtral</td></tr> <tr><td>Interleaved (and/or partial) rotary embedding</td> <td>GLM, Phi</td></tr> <tr><td>State space models</td> <td>Jamba, Bamba, Zamba, Mamba2</td></tr> <tr><td>Recurrent hidden states</td> <td>Gemma2</td></tr> <tr><td>Sliding window attention/full attention patterns per layer</td> <td>Gemma2, Cohere2</td></tr> <tr><td>QKV clipping</td> <td>Olmo</td></tr> <tr><td>QK normalization</td> <td>Olmo2, Cohere</td></tr> <tr><td>Fused QKV (not recommended)</td> <td>Phi3</td></tr></tbody>",Pe,L,SM='This section will walk you through how to implement <a href="./model_doc/olmo2">Olmo2</a> from <a href="./model_doc/olmo">Olmo</a> with modular Transformers (you can refer to the original <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/olmo2/modular_olmo2.py" rel="nofollow">modeling.py</a> file).',Ke,O,qe,D,xM="The modular <code>Olmo2Config</code> is shown below.",ls,P,es,K,HM="There are three points where the <code>Olmo2Config</code> is different from the original <code>OlmoConfig</code>.",ss,q,FM="<li>The default value of most arguments have changed.</li> <li>There is a new argument, <code>rms_norm_eps</code>.</li> <li>The <code>clip_qkv</code> argument isn’t used anymore.</li>",Ms,ll,LM="For the new default values and argument, overwrite the <code>__init__</code> function with the new default values and add <code>rms_norm_eps</code>. Assign <code>rms_norm_eps</code> to <code>self</code> in the body of <code>__init__</code>. For the <code>clip_qkv</code> argument, use <code>del self.clip_qkv</code> to remove the assignment of this attribute in the unraveled code (post-linter conversion).",ts,el,OM="Notice how the <code>super().__init__(...)</code> is used. Typically, it calls the parent <code>__init__</code>.",as,sl,DM="But in modular Transformers, if there is a call like <code>super().my_function(...)</code>, the linter takes the body of <code>my_function</code> in the parent and unravels it where the call to <code>super().my_function(...)</code> occurred. The <code>del self.clip_qkv</code> statement removes the reference to <code>self.clip_qkv</code> in the unraveled body.",ns,Ml,PM="<code>del self.</code> and <code>super().my_function(..)</code> work together, and it should always be placed after <code>super().my_function(...)</code>. You can add whatever you want <em>before</em> calling <code>super()</code>, and it is placed before the parents body.",ys,tl,is,al,Us,nl,KM="Nothing needs to be modified in <code>LlamaRMSNorm</code>. The linter unravels the exact content of <code>LlamaRMSNorm</code> into <code>Olmo2RMSNorm</code>. References to Llama in the docstrings, type hints, and comments are also changed to Olmo2.",os,yl,ps,il,qM="The modular <code>Olmo2Attention</code> is shown below.",ws,Ul,js,ol,lt="The <code>super().__init__(...)</code> copies the parent definition and adds 2 new layers from <code>Olmo2RMSNorm</code>. The forward pass needs to be overwritten to use these 2 new layers. A pass with the norm layers is added before projecting with <code>q_proj</code> and <code>k_proj</code>. To make it easier, the <code>eager_attention_forward</code> function is directly imported from Llama and the <code>apply_rotary_pos_emb</code> is imported from Olmo.",Ts,pl,et="The linter automatically adds these imported functions in the final <code>modeling_olmo2.py</code> file by copying their definitions from the source files. The <code>rotate_half</code> and <code>repeat_kv</code> functions are also added because they are used inside <code>apply_rotary_pos_emb</code> and <code>eager_attention_forward</code>.",ds,wl,st="The <code>Attention</code> class had to be redefined because there weren’t any existing models with an <code>Attention</code> layer that included a <code>RMSNorm</code> layer.",Js,jl,cs,Tl,Mt="The modular <code>DecoderLayer</code> is shown below.",Cs,dl,rs,Jl,tt="The norm type is switched in <code>__init__</code> by overwriting <code>self.post_attention_layernorm</code> after the call to <code>super().__init__(...)</code>. Delete the <code>self.input_layernorm</code> attributed and replace it with <code>self.post_feedforward_layernorm</code> because it is applied after in Olmo2. The forward method is overwritten to reflect this change.",ms,cl,at="If you only switched <code>self.post_feedforward_layernorm</code> and <code>self.input_layernorm</code> from <code>LayerNorm</code> to <code>RMSNorm</code> without also changing the name and logic of <code>self.input_layernorm</code>, then you wouldn’t have to rewrite the forward method.",hs,Cl,Is,rl,nt="The modular <code>Olmo2Model</code> class is shown below.",us,ml,As,hl,yt="You only need to change the <em>type</em> of the <code>self.norm</code> attribute to use <code>RMSNorm</code> instead of <code>LayerNorm</code>. This change doesn’t affect the logic in the forward method (layer name and usage is identical to the parent class), so you don’t need to overwrite it. The linter automatically unravels it.",fs,Il,bs,ul,it="The modular causal modeling head is shown below.",_s,Al,Zs,fl,Ut="The logic is identical to <code>OlmoForCausalLM</code> which means you don’t need to make any changes here.",Gs,bl,Bs,_l,ot='The <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/olmo2/modeling_olmo2.py" rel="nofollow">modeling_olmo2.py</a> generated by the linter also contains some classes (<code>Olmo2MLP</code>, <code>Olmo2RotaryEmbedding</code>, <code>Olmo2PreTrainedModel</code>) that weren’t explicitly defined in <code>modular_olmo2.py</code>.',Rs,Zl,pt="Classes that are a dependency of an inherited class but aren’t explicitly defined are automatically added as a part of dependency tracing. This is similar to how some functions were added to the <code>Attention</code> class without directly importing them.",ks,Gl,wt="For example, <code>OlmoDecoderLayer</code> has an attribute defined as <code>self.mlp = OlmoMLP(config)</code>. This class was never explicitly redefined in <code>Olmo2MLP</code>, so the linter automatically created a <code>Olmo2MLP</code> class similar to <code>OlmoMLP</code>. It is identical to the code below if it was explicitly written in <code>modular_olmo2.py</code>.",Ws,Bl,gs,Rl,jt="However, it was necessary to rewrite <code>Olmo2RMSNorm</code> because the layer norm needed to be redefined in the <code>Attention</code> and <code>DecoderLayer</code> classes. Similarly, this is why you didn’t need to create the <code>Olmo2PreTrainedModel</code> and <code>Olmo2RotaryEmbedding</code> classes.",vs,kl,Tt="Classes that aren’t rewritten are copied from the file where the inherited module first uses them. This means if you wanted <code>Olmo2MLP</code> to inherit from <code>MistralMLP</code> instead, you would need to be more explicit as shown below.",Ns,Wl,Es,gl,Xs,vl,dt="You can <code>del</code> to remove attributes defined in the parent after using <code>super().__init__()</code>. However, this doesn’t work if the attribute is also used somewhere else as shown below. It only suppresses the assignment. The <code>self.attribute = config.attribute</code> line is removed, but the <code>if</code> statement remains and references the attribute.",Vs,Nl,$s,El,Qs,Xl,Jt="If you still want to inherit from <code>DummyModel</code> but don’t want to remove the <code>self.attribute</code>, be explicit about which class’ <code>super()</code> you’re calling. The example below shows how to call the <code>super()</code> of <code>nn.Module</code> (unraveled code shown on the right)",Ys,Vl,zs,$l,Ss,Ql,ct="Remove an attribute by overwriting it with a <code>raise AttributeError(&quot;&quot;)</code> statement to mimic the behavior you want when you remove a parent function in Python. The example below removes the methods in the unraveled code.",xs,Yl,Hs,zl,Fs,Sl,Ct="By default, if you inherit from a class and override a method with one or more decorators in the parent method, the decorators are also added to the unraveled code <em>only if you don’t add any yourself</em>. Otherwise, the redefined decorator is used.",Ls,xl,rt="For example, if you had a parent class shown below and you overwrite it, the parent decorator is kept.",Os,Hl,Ds,Fl,mt="Modular code is shown on the left, and the unraveled code is shown on the right.",Ps,Ll,Ks,Ol,ht="But if you add a new decorator, your new decorator is used instead.",qs,Dl,lM,Pl,eM,Kl,It="In scenarios where a forward method is really long and you want to switch decorators, you don’t need to redefine everything and copy/paste the function. You can use <code>super().forward(...)</code> to unravel the parent body. When there are a lot of arguments in the function signature, use the special <code>**super_kwargs</code> syntax in the overwritten signature.",sM,ql,ut='This syntax indicates to the linter to unravel all the parent signature arguments here. An example signature in a <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM">AutoModelForCausalLM</a> model is shown below, with lots of arguments.',MM,le,tM,ee,At="Instead of rewriting and copying/pasting all of those arguments, use the <code>super().forward(**super_kwargs)</code> statement (modular code shown on the left, unraveled code on the right).",aM,se,nM,Me,ft="This makes it very easy to switch decorators and makes it explicit that the only change you want to apply is the decorator.",yM,te,bt="<code>**super_kwargs</code> should not be used to avoid being explicit when redefining methods though. If you overwrite a method, you should explicitly write the signature as you normally would. The <code>**super_kwargs</code> syntax is a shortcut for switching decorators and a few other niche cases.",iM,ae,UM,ne,_t="If an object defined in both the modular and modeling file from which it inherits, the modular definition has precedence unless for assignments containing the pattern <code>DOCSTRING</code>. These variables are typically used in <code>MODEL_START_DOCSTRING</code> and <code>MODEL_INPUT_DOCSTRING</code> in the modeling files. They are big blocks of docstrings and the linter rewrites the names everywhere. For this reason, assignments containing the <code>DOCSTRING</code> variable always uses the definition found in the source file instead of the modular file.",oM,ye,Zt='This is very useful if you need the variable reference somewhere but you don’t want to clutter the modular file with docstrings which are always the same. The example code below allows you to automatically use the same docstrings from <a href="./model_doc/mistral">Mistral</a> in <a href="./model_doc/starcoder2">Starcoder2</a>.',pM,ie,wM,Ue,jM,oe,Gt="The linter automatically renames everything when inheriting from a class. For consistency, you should always use the same class name prefix when inheriting from different classes from the same file.",TM,pe,Bt="The example below is not recommended. It breaks standards in the library, <code>MyModelIncredibleMLP</code> instead of <code>LlamaMLP</code>, and because the linter doesn’t know how to rename potential higher-order dependencies (<code>MyModelIncredible</code> or just <code>MyModel</code>).",dM,we,JM,je,Rt='However, if there aren’t any <a href="#other-classes">implicit dependencies</a>, then you can locally rename a single class. Make sure you still explicitly redefine every other mention of the class with the new name pattern though. For example, all mentions of <code>LlamaMLP</code> should be renamed to <code>MyModelIncredibleMLP</code> otherwise the linter may add a new and unwanted <code>MyModelMLP</code> class.',cM,Te,kt="The linter raises a warning if an ambiguous case is detected. It explains what is happening and which prefix is used by default for getting the dependencies. These warning and renaming pattern complications usually only come up when defining multimodal models. For example, adding <code>Text</code> to class names in a multimodal model to make it clear which modality it refers to.",CM,de,rM,Je,Wt="If there are automatic dependencies with a prefix, but you want another one, explicitly rename the classes locally with a <code>pass</code> class as shown in the following.",mM,ce,hM,Ce,IM,re,gt="When inheriting a <code>Config</code> class or adding and deleting attributes, you may want to only redefine the new attributes in the docstring. However, the linter doesn’t support this yet. You need to directly add the while docstring directly in the modular file under the class definition.",uM,me,AM,Ie,fM;return h=new J({props:{title:"Modular Transformers",local:"modular-transformers",headingTag:"h1"}}),f=new J({props:{title:"Motivation",local:"motivation",headingTag:"h2"}}),r=new xt({props:{warning:!1,$$slots:{default:[Ft]},$$scope:{ctx:ue}}}),G=new J({props:{title:"Create a modeling.py file",local:"create-a-modelingpy-file",headingTag:"h2"}}),k=new d({props:{code:"cHl0aG9uJTIwdXRpbHMlMkZtb2R1bGFyX21vZGVsX2NvbnZlcnRlci5weSUyMC0tZmlsZXNfdG9fcGFyc2UlMjBzcmMlMkZ0cmFuc2Zvcm1lcnMlMkZtb2RlbHMlMkYlM0N5b3VyX21vZGVsJTNFJTJGbW9kdWxhcl8lM0N5b3VyX21vZGVsJTNFLnB5",highlighted:"python utils/modular_model_converter.py --files_to_parse src/transformers/models/&lt;your_model&gt;/modular_&lt;your_model&gt;.py",wrap:!1}}),E=new d({props:{code:"cHl0aG9uJTIwdXRpbHMlMkZjaGVja19tb2R1bGFyX2NvbnZlcnNpb24ucHklMjAtLWZpbGVzJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGJTNDeW91cl9tb2RlbCUzRSUyRm1vZHVsYXJfJTNDeW91cl9tb2RlbCUzRS5weQ==",highlighted:"python utils/check_modular_conversion.py --files src/transformers/models/&lt;your_model&gt;/modular_&lt;your_model&gt;.py",wrap:!1}}),V=new J({props:{title:"BERT and RoBERTa",local:"bert-and-roberta",headingTag:"h3"}}),Y=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> ..bert.configuration_bert <span class="hljs-keyword">import</span> BertConfig
<span class="hljs-keyword">from</span> ..bert.modeling_bert <span class="hljs-keyword">import</span> (
    BertModel,
    BertEmbeddings,
    BertForMaskedLM
)

<span class="hljs-comment"># RoBERTa and BERT config is identical</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaConfig</span>(<span class="hljs-title class_ inherited__">BertConfig</span>):
  model_type = <span class="hljs-string">&#x27;roberta&#x27;</span>

<span class="hljs-comment"># Redefine the embeddings to highlight the padding id difference, and redefine the position embeddings</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaEmbeddings</span>(<span class="hljs-title class_ inherited__">BertEmbeddings</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config())

        self.padding_idx = config.pad_token_id
        self.position_embeddings = nn.Embedding(
            config.max_position_embeddings, config.hidden_size, padding_idx=self.padding_idx
        )

<span class="hljs-comment"># RoBERTa and BERT model is identical except for the embedding layer, which is defined above, so no need for additional changes here</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaModel</span>(<span class="hljs-title class_ inherited__">BertModel</span>):
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    self.embeddings = RobertaEmbeddings(config)

      
<span class="hljs-comment"># The model heads now only need to redefine the model inside to \`RobertaModel\`</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaForMaskedLM</span>(<span class="hljs-title class_ inherited__">BertForMaskedLM</span>):
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    self.model = RobertaModel(config)`,wrap:!1}}),S=new d({props:{code:"VmFsdWVFcnJvciUzQSUyMFlvdSUyMGRlZmluZWQlMjAlNjBSb2JlcnRhRW1iZWRkaW5ncyU2MCUyMGluJTIwdGhlJTIwbW9kdWxhcl9yb2JlcnRhLnB5JTJDJTIwaXQlMjBzaG91bGQlMjBiZSUyMHVzZWQlMjB3aGVuJTIweW91JTIwZGVmaW5lJTIwJTYwQmVydE1vZGVsJTYwJTJDJTIwYXMlMjBpdCUyMGlzJTIwb25lJTIwb2YlMjBpdCdzJTIwZGlyZWN0JTIwZGVwZW5kZW5jaWVzLiUyME1ha2UlMjBzdXJlJTIweW91JTIwdXNlJTIwaXQlMjBpbiUyMHRoZSUyMCU2MF9faW5pdF9fJTYwJTIwZnVuY3Rpb24u",highlighted:'<span class="hljs-symbol">ValueError:</span> You defined `RobertaEmbeddings` <span class="hljs-keyword">in</span> the modular_roberta.py, it should be used <span class="hljs-keyword">when</span> you define `BertModel`, <span class="hljs-keyword">as</span> it <span class="hljs-built_in">is</span> one <span class="hljs-keyword">of</span> it<span class="hljs-comment">&#x27;s direct dependencies. Make sure you use it in the `__init__` function.</span>',wrap:!1}}),x=new J({props:{title:"Implementing a modular file",local:"implementing-a-modular-file",headingTag:"h2"}}),O=new J({props:{title:"Config",local:"config",headingTag:"h3"}}),P=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> ..olmo.configuration_olmo <span class="hljs-keyword">import</span> OlmoConfig

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2Config</span>(<span class="hljs-title class_ inherited__">OlmoConfig</span>):
    <span class="hljs-string">r&quot;&quot;&quot;
    This is the configuration class to store the configuration of a [Olmo2Model](/docs/transformers/main/en/model_doc/olmo2#transformers.Olmo2Model).
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        vocab_size=<span class="hljs-number">50304</span>,
        hidden_size=<span class="hljs-number">4096</span>,
        intermediate_size=<span class="hljs-number">11008</span>,
        num_hidden_layers=<span class="hljs-number">32</span>,
        num_attention_heads=<span class="hljs-number">32</span>,
        num_key_value_heads=<span class="hljs-literal">None</span>,
        hidden_act=<span class="hljs-string">&quot;silu&quot;</span>,
        max_position_embeddings=<span class="hljs-number">2048</span>,
        initializer_range=<span class="hljs-number">0.02</span>,
        use_cache=<span class="hljs-literal">True</span>,
        pad_token_id=<span class="hljs-number">1</span>,
        bos_token_id=<span class="hljs-literal">None</span>,
        eos_token_id=<span class="hljs-number">50279</span>,
        tie_word_embeddings=<span class="hljs-literal">False</span>,
        rope_theta=<span class="hljs-number">10000.0</span>,
        rope_scaling=<span class="hljs-literal">None</span>,
        attention_bias=<span class="hljs-literal">False</span>,
        attention_dropout=<span class="hljs-number">0.0</span>,
        rms_norm_eps=<span class="hljs-number">1e-5</span>,
        **kwargs,
    </span>):
        <span class="hljs-built_in">super</span>().__init__(
            vocab_size=vocab_size,
            hidden_size=hidden_size,
            intermediate_size=intermediate_size,
            num_hidden_layers=num_hidden_layers,
            num_attention_heads=num_attention_heads,
            num_key_value_heads=num_key_value_heads,
            hidden_act=hidden_act,
            max_position_embeddings=max_position_embeddings,
            initializer_range=initializer_range,
            use_cache=use_cache,
            pad_token_id=pad_token_id,
            bos_token_id=bos_token_id,
            eos_token_id=eos_token_id,
            tie_word_embeddings=tie_word_embeddings,
            rope_theta=rope_theta,
            rope_scaling=rope_scaling,
            attention_bias=attention_bias,
            attention_dropout=attention_dropout,
            **kwargs,
        )

        self.rms_norm_eps = rms_norm_eps
        <span class="hljs-keyword">del</span> self.clip_qkv`,wrap:!1}}),tl=new J({props:{title:"Norm",local:"norm",headingTag:"h3"}}),al=new d({props:{code:"ZnJvbSUyMC4ubGxhbWEubW9kZWxpbmdfbGxhbWElMjBpbXBvcnQlMjBMbGFtYVJNU05vcm0lMEElMEFjbGFzcyUyME9sbW8yUk1TTm9ybShMbGFtYVJNU05vcm0pJTNBJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-keyword">from</span> ..llama.modeling_llama <span class="hljs-keyword">import</span> LlamaRMSNorm

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2RMSNorm</span>(<span class="hljs-title class_ inherited__">LlamaRMSNorm</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),yl=new J({props:{title:"Attention",local:"attention",headingTag:"h3"}}),Ul=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> ..llama.modeling_llama <span class="hljs-keyword">import</span> eager_attention_forward
<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoAttention, apply_rotary_pos_emb


<span class="hljs-comment"># Olmo2 attention is identical to OLMo attention except:</span>
<span class="hljs-comment"># - Norm is applied to attention queries and keys.</span>
<span class="hljs-comment"># - No qkv clipping.</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2Attention</span>(<span class="hljs-title class_ inherited__">OlmoAttention</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: Olmo2Config, layer_idx: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">int</span>] = <span class="hljs-literal">None</span></span>):
        <span class="hljs-built_in">super</span>().__init__(config, layer_idx=layer_idx)
        self.q_norm = Olmo2RMSNorm(config.num_attention_heads * self.head_dim, config.rms_norm_eps)
        self.k_norm = Olmo2RMSNorm(config.num_key_value_heads * self.head_dim, config.rms_norm_eps)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
        self,
        hidden_states: torch.Tensor,
        position_embeddings: <span class="hljs-type">Tuple</span>[torch.Tensor, torch.Tensor],
        attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor],
        past_key_value: <span class="hljs-type">Optional</span>[Cache] = <span class="hljs-literal">None</span>,
        cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
        **kwargs,
    </span>) -&gt; <span class="hljs-type">Tuple</span>[torch.Tensor, <span class="hljs-type">Optional</span>[torch.Tensor], <span class="hljs-type">Optional</span>[<span class="hljs-type">Tuple</span>[torch.Tensor]]]:
        input_shape = hidden_states.shape[:-<span class="hljs-number">1</span>]
        hidden_shape = (*input_shape, -<span class="hljs-number">1</span>, self.head_dim)

        query_states = self.q_norm(self.q_proj(hidden_states))
        key_states = self.k_norm(self.k_proj(hidden_states))
        value_states = self.v_proj(hidden_states)

        query_states = query_states.view(hidden_shape).transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
        key_states = key_states.view(hidden_shape).transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
        value_states = value_states.view(hidden_shape).transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)

        cos, sin = position_embeddings
        query_states, key_states = apply_rotary_pos_emb(query_states, key_states, cos, sin)

        <span class="hljs-keyword">if</span> past_key_value <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            <span class="hljs-comment"># sin and cos are specific to RoPE models; cache_position needed for the static cache</span>
            cache_kwargs = {<span class="hljs-string">&quot;sin&quot;</span>: sin, <span class="hljs-string">&quot;cos&quot;</span>: cos, <span class="hljs-string">&quot;cache_position&quot;</span>: cache_position}
            key_states, value_states = past_key_value.update(key_states, value_states, self.layer_idx, cache_kwargs)

        attention_interface: <span class="hljs-type">Callable</span> = eager_attention_forward
        <span class="hljs-keyword">if</span> self.config._attn_implementation != <span class="hljs-string">&quot;eager&quot;</span>:
            <span class="hljs-keyword">if</span> self.config._attn_implementation == <span class="hljs-string">&quot;sdpa&quot;</span> <span class="hljs-keyword">and</span> kwargs.get(<span class="hljs-string">&quot;output_attentions&quot;</span>, <span class="hljs-literal">False</span>):
                logger.warning_once(
                    <span class="hljs-string">&quot;\`torch.nn.functional.scaled_dot_product_attention\` does not support \`output_attentions=True\`. Falling back to &quot;</span>
                    <span class="hljs-string">&#x27;eager attention. This warning can be removed using the argument \`attn_implementation=&quot;eager&quot;\` when loading the model.&#x27;</span>
                )
            <span class="hljs-keyword">else</span>:
                attention_interface = ALL_ATTENTION_FUNCTIONS[self.config._attn_implementation]

        attn_output, attn_weights = attention_interface(
            self,
            query_states,
            key_states,
            value_states,
            attention_mask,
            dropout=<span class="hljs-number">0.0</span> <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.training <span class="hljs-keyword">else</span> self.attention_dropout,
            scaling=self.scaling,
            **kwargs,
        )

        attn_output = attn_output.reshape(*input_shape, -<span class="hljs-number">1</span>).contiguous()
        attn_output = self.o_proj(attn_output)
        <span class="hljs-keyword">return</span> attn_output, attn_weights`,wrap:!1}}),jl=new J({props:{title:"DecoderLayer",local:"decoderlayer",headingTag:"h3"}}),dl=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoDecoderLayer

<span class="hljs-comment"># The OLMo2 layers are identical to those of the OLMo model except:</span>
<span class="hljs-comment"># - RMSNorm is used instead of standard layer norm.</span>
<span class="hljs-comment"># - Norm is applied after attention/feedforward rather than before.</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2DecoderLayer</span>(<span class="hljs-title class_ inherited__">OlmoDecoderLayer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: Olmo2Config, layer_idx: <span class="hljs-built_in">int</span></span>):
        <span class="hljs-built_in">super</span>().__init__(config, layer_idx=layer_idx)
        self.post_attention_layernorm = Olmo2RMSNorm(config.hidden_size, eps=config.rms_norm_eps)
        self.post_feedforward_layernorm = Olmo2RMSNorm(config.hidden_size, eps=config.rms_norm_eps)
        self.self_attn = Olmo2Attention(config=config, layer_idx=layer_idx)
        <span class="hljs-keyword">del</span> self.input_layernorm

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
        self,
        hidden_states: torch.Tensor,
        attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
        position_ids: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
        past_key_value: <span class="hljs-type">Optional</span>[Cache] = <span class="hljs-literal">None</span>,
        output_attentions: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">False</span>,
        use_cache: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">False</span>,
        cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
        position_embeddings: <span class="hljs-type">Optional</span>[<span class="hljs-type">Tuple</span>[torch.Tensor, torch.Tensor]] = <span class="hljs-literal">None</span>,  <span class="hljs-comment"># necessary, but kept here for BC</span>
        **kwargs,
    </span>) -&gt; <span class="hljs-type">Tuple</span>[torch.FloatTensor, <span class="hljs-type">Optional</span>[<span class="hljs-type">Tuple</span>[torch.FloatTensor, torch.FloatTensor]]]:
        residual = hidden_states

        <span class="hljs-comment"># Self Attention</span>
        hidden_states, self_attn_weights = self.self_attn(
            hidden_states=hidden_states,
            attention_mask=attention_mask,
            position_ids=position_ids,
            past_key_value=past_key_value,
            output_attentions=output_attentions,
            use_cache=use_cache,
            cache_position=cache_position,
            position_embeddings=position_embeddings,
            **kwargs,
        )
        hidden_states = self.post_attention_layernorm(hidden_states)
        hidden_states = residual + hidden_states

        <span class="hljs-comment"># Fully Connected</span>
        residual = hidden_states
        hidden_states = self.mlp(hidden_states)
        hidden_states = self.post_feedforward_layernorm(hidden_states)
        hidden_states = residual + hidden_states

        outputs = (hidden_states,)
        <span class="hljs-keyword">if</span> output_attentions:
            outputs += (self_attn_weights,)

        <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),Cl=new J({props:{title:"Model",local:"model",headingTag:"h3"}}),ml=new d({props:{code:"ZnJvbSUyMC4ub2xtby5tb2RlbGluZ19vbG1vJTIwaW1wb3J0JTIwT2xtb01vZGVsJTBBJTBBJTIzJTIwVGhlJTIwT0xNbzIlMjBtb2RlbCUyMGlzJTIwaWRlbnRpY2FsJTIwdG8lMjB0aGUlMjBPTE1vJTIwbW9kZWwlMkMlMjBleGNlcHQlMjBSTVNOb3JtJTIwaXMlMjB1c2VkJTIwaW5zdGVhZCUyMG9mJTBBJTIzJTIwc3RhbmRhcmQlMjBsYXllciUyMG5vcm0lMjBmb3IlMjB0aGUlMjBvdXRwdXQlMjBub3JtLiUwQWNsYXNzJTIwT2xtbzJNb2RlbChPbG1vTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUzQSUyME9sbW8yQ29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubm9ybSUyMCUzRCUyME9sbW8yUk1TTm9ybShjb25maWcuaGlkZGVuX3NpemUlMkMlMjBlcHMlM0Rjb25maWcucm1zX25vcm1fZXBzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGF5ZXJzJTIwJTNEJTIwbm4uTW9kdWxlTGlzdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJPbG1vMkRlY29kZXJMYXllcihjb25maWclMkMlMjBsYXllcl9pZHgpJTIwZm9yJTIwbGF5ZXJfaWR4JTIwaW4lMjByYW5nZShjb25maWcubnVtX2hpZGRlbl9sYXllcnMpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoModel

<span class="hljs-comment"># The OLMo2 model is identical to the OLMo model, except RMSNorm is used instead of</span>
<span class="hljs-comment"># standard layer norm for the output norm.</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2Model</span>(<span class="hljs-title class_ inherited__">OlmoModel</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: Olmo2Config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        self.norm = Olmo2RMSNorm(config.hidden_size, eps=config.rms_norm_eps)
        self.layers = nn.ModuleList(
            [Olmo2DecoderLayer(config, layer_idx) <span class="hljs-keyword">for</span> layer_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(config.num_hidden_layers)]
        )`,wrap:!1}}),Il=new J({props:{title:"Model head",local:"model-head",headingTag:"h3"}}),Al=new d({props:{code:"ZnJvbSUyMC4ub2xtby5tb2RlbGluZ19vbG1vJTIwaW1wb3J0JTIwT2xtb0ZvckNhdXNhbExNJTBBJTBBY2xhc3MlMjBPbG1vMkZvckNhdXNhbExNKE9sbW9Gb3JDYXVzYWxMTSklM0ElMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoForCausalLM

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2ForCausalLM</span>(<span class="hljs-title class_ inherited__">OlmoForCausalLM</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),bl=new J({props:{title:"Other classes",local:"other-classes",headingTag:"h3"}}),Bl=new d({props:{code:"ZnJvbSUyMC4ub2xtby5tb2RlbGluZ19vbG1vJTIwaW1wb3J0JTIwT2xtb01MUCUwQSUwQWNsYXNzJTIwT2xtbzJNTFAoT2xtb01MUCklM0ElMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoMLP

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2MLP</span>(<span class="hljs-title class_ inherited__">OlmoMLP</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),Wl=new d({props:{code:"JTIzJTIwc3dpdGNoJTIwdG8lMjBtaXN0cmFsJTIwZGVmaW5pdGlvbiUwQWZyb20lMjAuLm1pc3RyYWwubW9kZWxpbmdfbWlzdHJhbCUyMGltcG9ydCUyME1pc3RyYWxNTFAlMEElMEFjbGFzcyUyME9sbW8yTUxQKE1pc3RyYWxNTFApJTNBJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-comment"># switch to mistral definition</span>
<span class="hljs-keyword">from</span> ..mistral.modeling_mistral <span class="hljs-keyword">import</span> MistralMLP

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2MLP</span>(<span class="hljs-title class_ inherited__">MistralMLP</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),gl=new J({props:{title:"Removing attributes",local:"removing-attributes",headingTag:"h2"}}),Nl=new d({props:{code:"Y2xhc3MlMjBEdW1teU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMEElMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnJTNBJTIwRHVtbXlDb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwc2VsZi5hdHRyaWJ1dGUlMjAlM0QlMjBjb25maWcuYXR0cmlidXRlJTBBJTIwJTIwJTIwJTIwaWYlMjBzZWxmLmF0dHJpYnV0ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGRvJTIwbW9yZSUyMHN0dWZmJTIwd2l0aCUyMCU2MHNlbGYuYXR0cmlidXRlJTYwJTIwaGVyZSUwQSUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUwQWNsYXNzJTIwTXlOZXdEdW1teU1vZGVsKER1bW15TW9kZWwpJTNBJTBBJTBBJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUzQSUyME15TmV3RHVtbXlDb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXyhjb25maWcpJTBBJTIwJTIwJTIwJTIwZGVsJTIwc2VsZi5hdHRyaWJ1dGU=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(nn.Module):

  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: DummyConfig</span>):
    <span class="hljs-built_in">super</span>().__init__()
    self.attribute = config.attribute
    <span class="hljs-keyword">if</span> self.attribute:
      <span class="hljs-comment"># do more stuff with \`self.attribute\` here</span>
      ...

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewDummyModel</span>(<span class="hljs-title class_ inherited__">DummyModel</span>):

  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyNewDummyConfig</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    <span class="hljs-keyword">del</span> self.attribute`,wrap:!1}}),El=new J({props:{title:"Explicit super() calls",local:"explicit-super-calls",headingTag:"h2"}}),Vl=new d({props:{code:"Y2xhc3MlMjBNeU5ld0R1bW15TW9kZWwoRHVtbXlNb2RlbCUyQyUyMG5uLk1vZHVsZSklM0ElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjBjbGFzcyUyME15TmV3RHVtbXlNb2RlbChubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUzQSUyME15TmV3RHVtbXlDb25maWcpJTNBJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUzQSUyME15TmV3RHVtbXlDb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwbm4uTW9kdWxlLl9faW5pdF9fKGNvbmZpZyklMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjBzZWxmLmZvbyUyMCUzRCUyMGNvbmZpZy5mb28lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZvbyUyMCUzRCUyMGNvbmZpZy5mb28lMEElMjAlMjAlMjAlMjAuLi4lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewDummyModel</span>(DummyModel, nn.Module):        |     <span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewDummyModel</span>(nn.Module):
                                                     |
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyNewDummyConfig</span>):      |       <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyNewDummyConfig</span>):
    nn.Module.__init__(config)                       |         <span class="hljs-built_in">super</span>().__init__()
    self.foo = config.foo                            |         self.foo = config.foo
    ...                                              |         ...`,wrap:!1}}),$l=new J({props:{title:"Deleting unused methods",local:"deleting-unused-methods",headingTag:"h2"}}),Yl=new d({props:{code:"Y2xhc3MlMjBHZW1tYVRva2VuaXplcihMbGFtYVRva2VuaXplciklM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEElMjAlMjAlMjAlMjBkZWYlMjBnZXRfc3BtX3Byb2Nlc3NvcihzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwQXR0cmlidXRlRXJyb3IoJTIyTm90JTIwbmVlZGVkJTIwZm9yJTIwR2VtbWElMjIpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwdW5rX3Rva2VuX2xlbmd0aChzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwQXR0cmlidXRlRXJyb3IoJTIyTm90JTIwbmVlZGVkJTIwZm9yJTIwR2VtbWElMjIp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">GemmaTokenizer</span>(<span class="hljs-title class_ inherited__">LlamaTokenizer</span>):
    ...

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_spm_processor</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">raise</span> AttributeError(<span class="hljs-string">&quot;Not needed for Gemma&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">unk_token_length</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">raise</span> AttributeError(<span class="hljs-string">&quot;Not needed for Gemma&quot;</span>)`,wrap:!1}}),zl=new J({props:{title:"Defining new functions",local:"defining-new-functions",headingTag:"h2"}}),Hl=new d({props:{code:"Y2xhc3MlMjBEdW1teU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAuLi4lMEElMEElMjAlMjAlNDBkZWNvcmF0b3IoLi4uKSUwQSUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRvJTIwc3R1ZmYlMjBoZXJl",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(nn.Module):
  ...

<span class="hljs-meta">  @decorator(<span class="hljs-params">...</span>)</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>)
    <span class="hljs-comment"># do stuff here</span>`,wrap:!1}}),Ll=new d({props:{code:"Y2xhc3MlMjBOZXdNb2RlbChEdW1teU1vZGVsKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMGNsYXNzJTIwTmV3TW9kZWwobm4uTW9kdWxlKSUzQSUwQSUyMCUyMC4uLiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCU0MGRlY29yYXRvciguLi4pJTBBJTIwJTIwJTIwJTIwLi4uJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZCguLi4pJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(<span class="hljs-title class_ inherited__">DummyModel</span>):       |   <span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(nn.Module):
  ...                             |     ...
                                  |
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):               |     @decorator(...)
    ...                           |     <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):
                                  |       ...`,wrap:!1}}),Dl=new d({props:{code:"Y2xhc3MlMjBOZXdNb2RlbChEdW1teU1vZGVsKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMGNsYXNzJTIwTmV3TW9kZWwobm4uTW9kdWxlKSUzQSUwQSUyMCUyMC4uLiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMCU0MG15X25ld19kZWNvcmF0b3IoLi4uKSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCU0MG15X25ld19kZWNvcmF0b3IoLi4uKSUwQSUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUzQSUwQSUyMCUyMCUyMCUyMC4uLiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(<span class="hljs-title class_ inherited__">DummyModel</span>):       |   <span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(nn.Module):
  ...                             |     ...
                                  |
<span class="hljs-meta">  @my_new_decorator(<span class="hljs-params">...</span>)          |     @my_new_decorator(<span class="hljs-params">...</span>)</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):               |     <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):
    ...                           |       ...`,wrap:!1}}),Pl=new J({props:{title:"super_kwargs",local:"superkwargs",headingTag:"h2"}}),le=new d({props:{code:"Y2xhc3MlMjBMbGFtYUZvckNhdXNhbExNKG5uLk1vZHVsZSklM0ElMEElMjAlMjAuLi4lMEElMEElMjAlMjAlNDBhZGRfc3RhcnRfZG9jc3RyaW5nc190b19tb2RlbF9mb3J3YXJkKExMQU1BX0lOUFVUU19ET0NTVFJJTkcpJTBBJTIwJTIwJTQwcmVwbGFjZV9yZXR1cm5fZG9jc3RyaW5ncyhvdXRwdXRfdHlwZSUzRENhdXNhbExNT3V0cHV0V2l0aFBhc3QlMkMlMjBjb25maWdfY2xhc3MlM0RfQ09ORklHX0ZPUl9ET0MpJTBBJTIwJTIwZGVmJTIwZm9yd2FyZCglMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTNBJTIwdG9yY2guTG9uZ1RlbnNvciUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUzQSUyME9wdGlvbmFsJTVCdG9yY2guVGVuc29yJTVEJTIwJTNEJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHBvc2l0aW9uX2lkcyUzQSUyME9wdGlvbmFsJTVCdG9yY2guTG9uZ1RlbnNvciU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwYXN0X2tleV92YWx1ZXMlM0ElMjBPcHRpb25hbCU1QlVuaW9uJTVCQ2FjaGUlMkMlMjBMaXN0JTVCdG9yY2guRmxvYXRUZW5zb3IlNUQlNUQlNUQlMjAlM0QlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzX2VtYmVkcyUzQSUyME9wdGlvbmFsJTVCdG9yY2guRmxvYXRUZW5zb3IlNUQlMjAlM0QlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTNBJTIwT3B0aW9uYWwlNUJ0b3JjaC5Mb25nVGVuc29yJTVEJTIwJTNEJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfYXR0ZW50aW9ucyUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfaGlkZGVuX3N0YXRlcyUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fZGljdCUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBjYWNoZV9wb3NpdGlvbiUzQSUyME9wdGlvbmFsJTVCdG9yY2guTG9uZ1RlbnNvciU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBudW1fbG9naXRzX3RvX2tlZXAlM0ElMjBpbnQlMjAlM0QlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwKiprd2FyZ3MlM0ElMjBVbnBhY2slNUJLd2FyZ3NGb3JDYXVzYWxMTSU1RCUyQyUwQSUyMCUyMCklMjAtJTNFJTIwVW5pb24lNUJUdXBsZSUyQyUyMENhdXNhbExNT3V0cHV0V2l0aFBhc3QlNUQlM0ElMEElMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">LlamaForCausalLM</span>(nn.Module):
  ...

<span class="hljs-meta">  @add_start_docstrings_to_model_forward(<span class="hljs-params">LLAMA_INPUTS_DOCSTRING</span>)</span>
<span class="hljs-meta">  @replace_return_docstrings(<span class="hljs-params">output_type=CausalLMOutputWithPast, config_class=_CONFIG_FOR_DOC</span>)</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
      self,
      input_ids: torch.LongTensor = <span class="hljs-literal">None</span>,
      attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
      position_ids: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
      past_key_values: <span class="hljs-type">Optional</span>[<span class="hljs-type">Union</span>[Cache, <span class="hljs-type">List</span>[torch.FloatTensor]]] = <span class="hljs-literal">None</span>,
      inputs_embeds: <span class="hljs-type">Optional</span>[torch.FloatTensor] = <span class="hljs-literal">None</span>,
      labels: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
      use_cache: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      output_attentions: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      output_hidden_states: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      return_dict: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
      num_logits_to_keep: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span>,
      **kwargs: Unpack[KwargsForCausalLM],
  </span>) -&gt; <span class="hljs-type">Union</span>[<span class="hljs-type">Tuple</span>, CausalLMOutputWithPast]:
    ...`,wrap:!1}}),se=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModelForCausalLM</span>(<span class="hljs-title class_ inherited__">LlamaForCausalLM</span>):    |    <span class="hljs-keyword">class</span> <span class="hljs-title class_">LlamaForCausalLM</span>(nn.Module):
  ...                                           |      ...
                                                |
<span class="hljs-meta">  @my_new_decorator                             |     @my_new_decorator</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, **super_kwargs</span>):            |     <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
    <span class="hljs-built_in">super</span>(<span class="hljs-params"></span>).forward(<span class="hljs-params">**super_kwargs</span>)             |         self,
                                                |         input_ids: torch.LongTensor = <span class="hljs-literal">None</span>,
                                                |         attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
                                                |         position_ids: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
                                                |         past_key_values: <span class="hljs-type">Optional</span>[<span class="hljs-type">Union</span>[Cache, <span class="hljs-type">List</span>[torch.FloatTensor]]] = |<span class="hljs-literal">None</span>,
                                                |         inputs_embeds: <span class="hljs-type">Optional</span>[torch.FloatTensor] = <span class="hljs-literal">None</span>,
                                                |         labels: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
                                                |         use_cache: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         output_attentions: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         output_hidden_states: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         return_dict: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
                                                |         num_logits_to_keep: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span>,
                                                |         **kwargs: Unpack[KwargsForCausalLM],
                                                |     </span>) -&gt; <span class="hljs-type">Union</span>[<span class="hljs-type">Tuple</span>, CausalLMOutputWithPast]:
                                                |       ...`,wrap:!1}}),ae=new J({props:{title:"Docstring variables",local:"docstring-variables",headingTag:"h2"}}),ie=new d({props:{code:"U1RBUkNPREVSMl9JTlBVVFNfRE9DU1RSSU5HJTIwJTNEJTIwTm9uZSUyMCUyMCUyMyUyMHdpbGwlMjBiZSUyMGF1dG9tYXRpY2FsbHklMjByZWRlZmluZWQlMEElMEFjbGFzcyUyMFN0YXJjb2RlcjJNb2RlbChNaXN0cmFsTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTQwYWRkX3N0YXJ0X2RvY3N0cmluZ3NfdG9fbW9kZWxfZm9yd2FyZChTVEFSQ09ERVIyX0lOUFVUU19ET0NTVFJJTkcpJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZCguLi4pJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`STARCODER2_INPUTS_DOCSTRING = <span class="hljs-literal">None</span>  <span class="hljs-comment"># will be automatically redefined</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Starcoder2Model</span>(<span class="hljs-title class_ inherited__">MistralModel</span>):
    ...

<span class="hljs-meta">    @add_start_docstrings_to_model_forward(<span class="hljs-params">STARCODER2_INPUTS_DOCSTRING</span>)</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>)
        ...`,wrap:!1}}),Ue=new J({props:{title:"Special naming",local:"special-naming",headingTag:"h2"}}),we=new d({props:{code:"Y2xhc3MlMjBNeU1vZGVsSW5jcmVkaWJsZU1MUChMbGFtYU1MUCklM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEFjbGFzcyUyME15TW9kZWxEZWNvZGVyTGF5ZXIoTGxhbWFEZWNvZGVyTGF5ZXIpJTNBJTBBJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModelIncredibleMLP</span>(<span class="hljs-title class_ inherited__">LlamaMLP</span>):
    ...

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModelDecoderLayer</span>(<span class="hljs-title class_ inherited__">LlamaDecoderLayer</span>):
    ...`,wrap:!1}}),de=new d({props:{code:"V2UlMjBkZXRlY3RlZCUyMG11bHRpcGxlJTIwcHJlZml4JTIwbmFtZXMlMjB3aGVuJTIwaW5oZXJpdGluZyUyMGZyb20lMjB0cmFuc2Zvcm1lcnMubW9kZWxzLmxsYW1hLm1vZGVsaW5nX2xsYW1hJTNBJTIwKCdFbXUzVGV4dCclMkMlMjAnRW11MycpLiUyMFdlJTIwd2lsbCUyMG9ubHklMjB1c2UlMjB0aGUlMjBtb3N0JTIwdXNlZCUyMCdFbXUzJyUyMHByZWZpeCUyMHdoZW4lMjBncmFiYmluZyUyMGFyZ3MlMjBhbmQlMjBkZXBlbmRlbmNpZXMuJTIwTWFrZSUyMHN1cmUlMjB0byUyMHN1YmNsYXNzJTIwdGhlJTIwaW50ZXJtZWRpYXRlJTIwY2xhc3NlcyUyMHdpdGglMjB0aGUlMjBwcmVmaXglMjB5b3UlMjB3YW50JTIwKGlmJTIwZGlmZmVyZW50JTIwZnJvbSUyMCdFbXUzJyklMjBvciUyMHVzZSUyMGElMjBzaW5nbGUlMjBwcmVmaXglMjBpbiUyMGFsbCUyMHRoZSUyMG1vZHVsYXIlMjAoYmVzdCku",highlighted:'We detected multiple prefix names when inheriting <span class="hljs-keyword">from</span> transformers.models.llama.modeling_llama: (<span class="hljs-string">&#x27;Emu3Text&#x27;</span>, <span class="hljs-string">&#x27;Emu3&#x27;</span>). We will only use the most used <span class="hljs-string">&#x27;Emu3&#x27;</span> prefix when grabbing args <span class="hljs-keyword">and</span> dependencies. Make sure to subclass the intermediate classes <span class="hljs-keyword">with</span> the prefix you want (<span class="hljs-keyword">if</span> different <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;Emu3&#x27;</span>) <span class="hljs-keyword">or</span> use a single prefix <span class="hljs-keyword">in</span> <span class="hljs-built_in">all</span> the modular (best).',wrap:!1}}),ce=new d({props:{code:"Y2xhc3MlMjBFbXUzVGV4dE1MUChMbGFtYU1MUCklM0ElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Emu3TextMLP</span>(<span class="hljs-title class_ inherited__">LlamaMLP</span>):                                 
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),Ce=new J({props:{title:"Config docstrings",local:"config-docstrings",headingTag:"h2"}}),me=new Ht({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/modular_transformers.md"}}),{c(){c=n("meta"),m=t(),C=n("p"),he=t(),U(h.$$.fragment),Ae=t(),I=n("p"),I.textContent=bM,fe=t(),u=n("p"),u.innerHTML=_M,be=t(),A=n("p"),A.innerHTML=ZM,_e=t(),U(f.$$.fragment),Ze=t(),b=n("p"),b.innerHTML=GM,Ge=t(),U(r.$$.fragment),Be=t(),_=n("p"),_.textContent=BM,Re=t(),Z=n("p"),Z.textContent=RM,ke=t(),U(G.$$.fragment),We=t(),B=n("p"),B.innerHTML=kM,ge=t(),R=n("p"),R.innerHTML=WM,ve=t(),U(k.$$.fragment),Ne=t(),W=n("p"),W.textContent=gM,Ee=t(),g=n("ul"),g.innerHTML=vM,Xe=t(),v=n("p"),v.textContent=NM,Ve=t(),N=n("p"),N.innerHTML=EM,$e=t(),U(E.$$.fragment),Qe=t(),X=n("p"),X.textContent=XM,Ye=t(),U(V.$$.fragment),ze=t(),$=n("p"),$.textContent=VM,Se=t(),Q=n("p"),Q.innerHTML=$M,xe=t(),U(Y.$$.fragment),He=t(),z=n("p"),z.textContent=QM,Fe=t(),U(S.$$.fragment),Le=t(),U(x.$$.fragment),Oe=t(),H=n("p"),H.innerHTML=YM,De=t(),F=n("table"),F.innerHTML=zM,Pe=t(),L=n("p"),L.innerHTML=SM,Ke=t(),U(O.$$.fragment),qe=t(),D=n("p"),D.innerHTML=xM,ls=t(),U(P.$$.fragment),es=t(),K=n("p"),K.innerHTML=HM,ss=t(),q=n("ol"),q.innerHTML=FM,Ms=t(),ll=n("p"),ll.innerHTML=LM,ts=t(),el=n("p"),el.innerHTML=OM,as=t(),sl=n("p"),sl.innerHTML=DM,ns=t(),Ml=n("p"),Ml.innerHTML=PM,ys=t(),U(tl.$$.fragment),is=t(),U(al.$$.fragment),Us=t(),nl=n("p"),nl.innerHTML=KM,os=t(),U(yl.$$.fragment),ps=t(),il=n("p"),il.innerHTML=qM,ws=t(),U(Ul.$$.fragment),js=t(),ol=n("p"),ol.innerHTML=lt,Ts=t(),pl=n("p"),pl.innerHTML=et,ds=t(),wl=n("p"),wl.innerHTML=st,Js=t(),U(jl.$$.fragment),cs=t(),Tl=n("p"),Tl.innerHTML=Mt,Cs=t(),U(dl.$$.fragment),rs=t(),Jl=n("p"),Jl.innerHTML=tt,ms=t(),cl=n("p"),cl.innerHTML=at,hs=t(),U(Cl.$$.fragment),Is=t(),rl=n("p"),rl.innerHTML=nt,us=t(),U(ml.$$.fragment),As=t(),hl=n("p"),hl.innerHTML=yt,fs=t(),U(Il.$$.fragment),bs=t(),ul=n("p"),ul.textContent=it,_s=t(),U(Al.$$.fragment),Zs=t(),fl=n("p"),fl.innerHTML=Ut,Gs=t(),U(bl.$$.fragment),Bs=t(),_l=n("p"),_l.innerHTML=ot,Rs=t(),Zl=n("p"),Zl.innerHTML=pt,ks=t(),Gl=n("p"),Gl.innerHTML=wt,Ws=t(),U(Bl.$$.fragment),gs=t(),Rl=n("p"),Rl.innerHTML=jt,vs=t(),kl=n("p"),kl.innerHTML=Tt,Ns=t(),U(Wl.$$.fragment),Es=t(),U(gl.$$.fragment),Xs=t(),vl=n("p"),vl.innerHTML=dt,Vs=t(),U(Nl.$$.fragment),$s=t(),U(El.$$.fragment),Qs=t(),Xl=n("p"),Xl.innerHTML=Jt,Ys=t(),U(Vl.$$.fragment),zs=t(),U($l.$$.fragment),Ss=t(),Ql=n("p"),Ql.innerHTML=ct,xs=t(),U(Yl.$$.fragment),Hs=t(),U(zl.$$.fragment),Fs=t(),Sl=n("p"),Sl.innerHTML=Ct,Ls=t(),xl=n("p"),xl.textContent=rt,Os=t(),U(Hl.$$.fragment),Ds=t(),Fl=n("p"),Fl.textContent=mt,Ps=t(),U(Ll.$$.fragment),Ks=t(),Ol=n("p"),Ol.textContent=ht,qs=t(),U(Dl.$$.fragment),lM=t(),U(Pl.$$.fragment),eM=t(),Kl=n("p"),Kl.innerHTML=It,sM=t(),ql=n("p"),ql.innerHTML=ut,MM=t(),U(le.$$.fragment),tM=t(),ee=n("p"),ee.innerHTML=At,aM=t(),U(se.$$.fragment),nM=t(),Me=n("p"),Me.textContent=ft,yM=t(),te=n("p"),te.innerHTML=bt,iM=t(),U(ae.$$.fragment),UM=t(),ne=n("p"),ne.innerHTML=_t,oM=t(),ye=n("p"),ye.innerHTML=Zt,pM=t(),U(ie.$$.fragment),wM=t(),U(Ue.$$.fragment),jM=t(),oe=n("p"),oe.textContent=Gt,TM=t(),pe=n("p"),pe.innerHTML=Bt,dM=t(),U(we.$$.fragment),JM=t(),je=n("p"),je.innerHTML=Rt,cM=t(),Te=n("p"),Te.innerHTML=kt,CM=t(),U(de.$$.fragment),rM=t(),Je=n("p"),Je.innerHTML=Wt,mM=t(),U(ce.$$.fragment),hM=t(),U(Ce.$$.fragment),IM=t(),re=n("p"),re.innerHTML=gt,uM=t(),U(me.$$.fragment),AM=t(),Ie=n("p"),this.h()},l(l){const e=zt("svelte-u9bgzb",document.head);c=y(e,"META",{name:!0,content:!0}),e.forEach(s),m=a(l),C=y(l,"P",{}),Nt(C).forEach(s),he=a(l),o(h.$$.fragment,l),Ae=a(l),I=y(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-lj81hr"&&(I.textContent=bM),fe=a(l),u=y(l,"P",{"data-svelte-h":!0}),i(u)!=="svelte-1fibcpl"&&(u.innerHTML=_M),be=a(l),A=y(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-12jtllm"&&(A.innerHTML=ZM),_e=a(l),o(f.$$.fragment,l),Ze=a(l),b=y(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-wcqh4p"&&(b.innerHTML=GM),Ge=a(l),o(r.$$.fragment,l),Be=a(l),_=y(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-sz29kf"&&(_.textContent=BM),Re=a(l),Z=y(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1n4f4or"&&(Z.textContent=RM),ke=a(l),o(G.$$.fragment,l),We=a(l),B=y(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-12wgxa8"&&(B.innerHTML=kM),ge=a(l),R=y(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1vs9m3e"&&(R.innerHTML=WM),ve=a(l),o(k.$$.fragment,l),Ne=a(l),W=y(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1gkqha7"&&(W.textContent=gM),Ee=a(l),g=y(l,"UL",{"data-svelte-h":!0}),i(g)!=="svelte-2znzcv"&&(g.innerHTML=vM),Xe=a(l),v=y(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1q8tpr3"&&(v.textContent=NM),Ve=a(l),N=y(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1nmms0q"&&(N.innerHTML=EM),$e=a(l),o(E.$$.fragment,l),Qe=a(l),X=y(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-fj797c"&&(X.textContent=XM),Ye=a(l),o(V.$$.fragment,l),ze=a(l),$=y(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-1tajku"&&($.textContent=VM),Se=a(l),Q=y(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1izmokq"&&(Q.innerHTML=$M),xe=a(l),o(Y.$$.fragment,l),He=a(l),z=y(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1hj80v9"&&(z.textContent=QM),Fe=a(l),o(S.$$.fragment,l),Le=a(l),o(x.$$.fragment,l),Oe=a(l),H=y(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-36nwfz"&&(H.innerHTML=YM),De=a(l),F=y(l,"TABLE",{"data-svelte-h":!0}),i(F)!=="svelte-smzi7r"&&(F.innerHTML=zM),Pe=a(l),L=y(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-vpi0ku"&&(L.innerHTML=SM),Ke=a(l),o(O.$$.fragment,l),qe=a(l),D=y(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1yjd5s7"&&(D.innerHTML=xM),ls=a(l),o(P.$$.fragment,l),es=a(l),K=y(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-q0b1mo"&&(K.innerHTML=HM),ss=a(l),q=y(l,"OL",{"data-svelte-h":!0}),i(q)!=="svelte-139or2s"&&(q.innerHTML=FM),Ms=a(l),ll=y(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-3ks7rn"&&(ll.innerHTML=LM),ts=a(l),el=y(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-11wms29"&&(el.innerHTML=OM),as=a(l),sl=y(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-yznf21"&&(sl.innerHTML=DM),ns=a(l),Ml=y(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-1i7o0i6"&&(Ml.innerHTML=PM),ys=a(l),o(tl.$$.fragment,l),is=a(l),o(al.$$.fragment,l),Us=a(l),nl=y(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-12zqvql"&&(nl.innerHTML=KM),os=a(l),o(yl.$$.fragment,l),ps=a(l),il=y(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-suxygn"&&(il.innerHTML=qM),ws=a(l),o(Ul.$$.fragment,l),js=a(l),ol=y(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1k0gkac"&&(ol.innerHTML=lt),Ts=a(l),pl=y(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-10o1ggb"&&(pl.innerHTML=et),ds=a(l),wl=y(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-1y0dfl"&&(wl.innerHTML=st),Js=a(l),o(jl.$$.fragment,l),cs=a(l),Tl=y(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-jueczp"&&(Tl.innerHTML=Mt),Cs=a(l),o(dl.$$.fragment,l),rs=a(l),Jl=y(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-1grcsyb"&&(Jl.innerHTML=tt),ms=a(l),cl=y(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-krborp"&&(cl.innerHTML=at),hs=a(l),o(Cl.$$.fragment,l),Is=a(l),rl=y(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-12qws02"&&(rl.innerHTML=nt),us=a(l),o(ml.$$.fragment,l),As=a(l),hl=y(l,"P",{"data-svelte-h":!0}),i(hl)!=="svelte-2efkpk"&&(hl.innerHTML=yt),fs=a(l),o(Il.$$.fragment,l),bs=a(l),ul=y(l,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-111k955"&&(ul.textContent=it),_s=a(l),o(Al.$$.fragment,l),Zs=a(l),fl=y(l,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-ue8kve"&&(fl.innerHTML=Ut),Gs=a(l),o(bl.$$.fragment,l),Bs=a(l),_l=y(l,"P",{"data-svelte-h":!0}),i(_l)!=="svelte-j99j4d"&&(_l.innerHTML=ot),Rs=a(l),Zl=y(l,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-1mv6aiq"&&(Zl.innerHTML=pt),ks=a(l),Gl=y(l,"P",{"data-svelte-h":!0}),i(Gl)!=="svelte-li8sd3"&&(Gl.innerHTML=wt),Ws=a(l),o(Bl.$$.fragment,l),gs=a(l),Rl=y(l,"P",{"data-svelte-h":!0}),i(Rl)!=="svelte-1qoxxsw"&&(Rl.innerHTML=jt),vs=a(l),kl=y(l,"P",{"data-svelte-h":!0}),i(kl)!=="svelte-16zifu2"&&(kl.innerHTML=Tt),Ns=a(l),o(Wl.$$.fragment,l),Es=a(l),o(gl.$$.fragment,l),Xs=a(l),vl=y(l,"P",{"data-svelte-h":!0}),i(vl)!=="svelte-1reud8e"&&(vl.innerHTML=dt),Vs=a(l),o(Nl.$$.fragment,l),$s=a(l),o(El.$$.fragment,l),Qs=a(l),Xl=y(l,"P",{"data-svelte-h":!0}),i(Xl)!=="svelte-21xdqm"&&(Xl.innerHTML=Jt),Ys=a(l),o(Vl.$$.fragment,l),zs=a(l),o($l.$$.fragment,l),Ss=a(l),Ql=y(l,"P",{"data-svelte-h":!0}),i(Ql)!=="svelte-ho137b"&&(Ql.innerHTML=ct),xs=a(l),o(Yl.$$.fragment,l),Hs=a(l),o(zl.$$.fragment,l),Fs=a(l),Sl=y(l,"P",{"data-svelte-h":!0}),i(Sl)!=="svelte-mwxhil"&&(Sl.innerHTML=Ct),Ls=a(l),xl=y(l,"P",{"data-svelte-h":!0}),i(xl)!=="svelte-8g3zpp"&&(xl.textContent=rt),Os=a(l),o(Hl.$$.fragment,l),Ds=a(l),Fl=y(l,"P",{"data-svelte-h":!0}),i(Fl)!=="svelte-hkv2ct"&&(Fl.textContent=mt),Ps=a(l),o(Ll.$$.fragment,l),Ks=a(l),Ol=y(l,"P",{"data-svelte-h":!0}),i(Ol)!=="svelte-1b9k8jx"&&(Ol.textContent=ht),qs=a(l),o(Dl.$$.fragment,l),lM=a(l),o(Pl.$$.fragment,l),eM=a(l),Kl=y(l,"P",{"data-svelte-h":!0}),i(Kl)!=="svelte-ce3ins"&&(Kl.innerHTML=It),sM=a(l),ql=y(l,"P",{"data-svelte-h":!0}),i(ql)!=="svelte-142mre4"&&(ql.innerHTML=ut),MM=a(l),o(le.$$.fragment,l),tM=a(l),ee=y(l,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-161qf9e"&&(ee.innerHTML=At),aM=a(l),o(se.$$.fragment,l),nM=a(l),Me=y(l,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-1w35umg"&&(Me.textContent=ft),yM=a(l),te=y(l,"P",{"data-svelte-h":!0}),i(te)!=="svelte-1x7kbin"&&(te.innerHTML=bt),iM=a(l),o(ae.$$.fragment,l),UM=a(l),ne=y(l,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-1fzb00u"&&(ne.innerHTML=_t),oM=a(l),ye=y(l,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-1a2wp3o"&&(ye.innerHTML=Zt),pM=a(l),o(ie.$$.fragment,l),wM=a(l),o(Ue.$$.fragment,l),jM=a(l),oe=y(l,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-1r96udu"&&(oe.textContent=Gt),TM=a(l),pe=y(l,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-1w8gdvq"&&(pe.innerHTML=Bt),dM=a(l),o(we.$$.fragment,l),JM=a(l),je=y(l,"P",{"data-svelte-h":!0}),i(je)!=="svelte-ce2erv"&&(je.innerHTML=Rt),cM=a(l),Te=y(l,"P",{"data-svelte-h":!0}),i(Te)!=="svelte-1n8wdp0"&&(Te.innerHTML=kt),CM=a(l),o(de.$$.fragment,l),rM=a(l),Je=y(l,"P",{"data-svelte-h":!0}),i(Je)!=="svelte-3dj83y"&&(Je.innerHTML=Wt),mM=a(l),o(ce.$$.fragment,l),hM=a(l),o(Ce.$$.fragment,l),IM=a(l),re=y(l,"P",{"data-svelte-h":!0}),i(re)!=="svelte-msrgaf"&&(re.innerHTML=gt),uM=a(l),o(me.$$.fragment,l),AM=a(l),Ie=y(l,"P",{}),Nt(Ie).forEach(s),this.h()},h(){Et(c,"name","hf:doc:metadata"),Et(c,"content",Ot)},m(l,e){St(document.head,c),M(l,m,e),M(l,C,e),M(l,he,e),p(h,l,e),M(l,Ae,e),M(l,I,e),M(l,fe,e),M(l,u,e),M(l,be,e),M(l,A,e),M(l,_e,e),p(f,l,e),M(l,Ze,e),M(l,b,e),M(l,Ge,e),p(r,l,e),M(l,Be,e),M(l,_,e),M(l,Re,e),M(l,Z,e),M(l,ke,e),p(G,l,e),M(l,We,e),M(l,B,e),M(l,ge,e),M(l,R,e),M(l,ve,e),p(k,l,e),M(l,Ne,e),M(l,W,e),M(l,Ee,e),M(l,g,e),M(l,Xe,e),M(l,v,e),M(l,Ve,e),M(l,N,e),M(l,$e,e),p(E,l,e),M(l,Qe,e),M(l,X,e),M(l,Ye,e),p(V,l,e),M(l,ze,e),M(l,$,e),M(l,Se,e),M(l,Q,e),M(l,xe,e),p(Y,l,e),M(l,He,e),M(l,z,e),M(l,Fe,e),p(S,l,e),M(l,Le,e),p(x,l,e),M(l,Oe,e),M(l,H,e),M(l,De,e),M(l,F,e),M(l,Pe,e),M(l,L,e),M(l,Ke,e),p(O,l,e),M(l,qe,e),M(l,D,e),M(l,ls,e),p(P,l,e),M(l,es,e),M(l,K,e),M(l,ss,e),M(l,q,e),M(l,Ms,e),M(l,ll,e),M(l,ts,e),M(l,el,e),M(l,as,e),M(l,sl,e),M(l,ns,e),M(l,Ml,e),M(l,ys,e),p(tl,l,e),M(l,is,e),p(al,l,e),M(l,Us,e),M(l,nl,e),M(l,os,e),p(yl,l,e),M(l,ps,e),M(l,il,e),M(l,ws,e),p(Ul,l,e),M(l,js,e),M(l,ol,e),M(l,Ts,e),M(l,pl,e),M(l,ds,e),M(l,wl,e),M(l,Js,e),p(jl,l,e),M(l,cs,e),M(l,Tl,e),M(l,Cs,e),p(dl,l,e),M(l,rs,e),M(l,Jl,e),M(l,ms,e),M(l,cl,e),M(l,hs,e),p(Cl,l,e),M(l,Is,e),M(l,rl,e),M(l,us,e),p(ml,l,e),M(l,As,e),M(l,hl,e),M(l,fs,e),p(Il,l,e),M(l,bs,e),M(l,ul,e),M(l,_s,e),p(Al,l,e),M(l,Zs,e),M(l,fl,e),M(l,Gs,e),p(bl,l,e),M(l,Bs,e),M(l,_l,e),M(l,Rs,e),M(l,Zl,e),M(l,ks,e),M(l,Gl,e),M(l,Ws,e),p(Bl,l,e),M(l,gs,e),M(l,Rl,e),M(l,vs,e),M(l,kl,e),M(l,Ns,e),p(Wl,l,e),M(l,Es,e),p(gl,l,e),M(l,Xs,e),M(l,vl,e),M(l,Vs,e),p(Nl,l,e),M(l,$s,e),p(El,l,e),M(l,Qs,e),M(l,Xl,e),M(l,Ys,e),p(Vl,l,e),M(l,zs,e),p($l,l,e),M(l,Ss,e),M(l,Ql,e),M(l,xs,e),p(Yl,l,e),M(l,Hs,e),p(zl,l,e),M(l,Fs,e),M(l,Sl,e),M(l,Ls,e),M(l,xl,e),M(l,Os,e),p(Hl,l,e),M(l,Ds,e),M(l,Fl,e),M(l,Ps,e),p(Ll,l,e),M(l,Ks,e),M(l,Ol,e),M(l,qs,e),p(Dl,l,e),M(l,lM,e),p(Pl,l,e),M(l,eM,e),M(l,Kl,e),M(l,sM,e),M(l,ql,e),M(l,MM,e),p(le,l,e),M(l,tM,e),M(l,ee,e),M(l,aM,e),p(se,l,e),M(l,nM,e),M(l,Me,e),M(l,yM,e),M(l,te,e),M(l,iM,e),p(ae,l,e),M(l,UM,e),M(l,ne,e),M(l,oM,e),M(l,ye,e),M(l,pM,e),p(ie,l,e),M(l,wM,e),p(Ue,l,e),M(l,jM,e),M(l,oe,e),M(l,TM,e),M(l,pe,e),M(l,dM,e),p(we,l,e),M(l,JM,e),M(l,je,e),M(l,cM,e),M(l,Te,e),M(l,CM,e),p(de,l,e),M(l,rM,e),M(l,Je,e),M(l,mM,e),p(ce,l,e),M(l,hM,e),p(Ce,l,e),M(l,IM,e),M(l,re,e),M(l,uM,e),p(me,l,e),M(l,AM,e),M(l,Ie,e),fM=!0},p(l,[e]){const vt={};e&2&&(vt.$$scope={dirty:e,ctx:l}),r.$set(vt)},i(l){fM||(w(h.$$.fragment,l),w(f.$$.fragment,l),w(r.$$.fragment,l),w(G.$$.fragment,l),w(k.$$.fragment,l),w(E.$$.fragment,l),w(V.$$.fragment,l),w(Y.$$.fragment,l),w(S.$$.fragment,l),w(x.$$.fragment,l),w(O.$$.fragment,l),w(P.$$.fragment,l),w(tl.$$.fragment,l),w(al.$$.fragment,l),w(yl.$$.fragment,l),w(Ul.$$.fragment,l),w(jl.$$.fragment,l),w(dl.$$.fragment,l),w(Cl.$$.fragment,l),w(ml.$$.fragment,l),w(Il.$$.fragment,l),w(Al.$$.fragment,l),w(bl.$$.fragment,l),w(Bl.$$.fragment,l),w(Wl.$$.fragment,l),w(gl.$$.fragment,l),w(Nl.$$.fragment,l),w(El.$$.fragment,l),w(Vl.$$.fragment,l),w($l.$$.fragment,l),w(Yl.$$.fragment,l),w(zl.$$.fragment,l),w(Hl.$$.fragment,l),w(Ll.$$.fragment,l),w(Dl.$$.fragment,l),w(Pl.$$.fragment,l),w(le.$$.fragment,l),w(se.$$.fragment,l),w(ae.$$.fragment,l),w(ie.$$.fragment,l),w(Ue.$$.fragment,l),w(we.$$.fragment,l),w(de.$$.fragment,l),w(ce.$$.fragment,l),w(Ce.$$.fragment,l),w(me.$$.fragment,l),fM=!0)},o(l){j(h.$$.fragment,l),j(f.$$.fragment,l),j(r.$$.fragment,l),j(G.$$.fragment,l),j(k.$$.fragment,l),j(E.$$.fragment,l),j(V.$$.fragment,l),j(Y.$$.fragment,l),j(S.$$.fragment,l),j(x.$$.fragment,l),j(O.$$.fragment,l),j(P.$$.fragment,l),j(tl.$$.fragment,l),j(al.$$.fragment,l),j(yl.$$.fragment,l),j(Ul.$$.fragment,l),j(jl.$$.fragment,l),j(dl.$$.fragment,l),j(Cl.$$.fragment,l),j(ml.$$.fragment,l),j(Il.$$.fragment,l),j(Al.$$.fragment,l),j(bl.$$.fragment,l),j(Bl.$$.fragment,l),j(Wl.$$.fragment,l),j(gl.$$.fragment,l),j(Nl.$$.fragment,l),j(El.$$.fragment,l),j(Vl.$$.fragment,l),j($l.$$.fragment,l),j(Yl.$$.fragment,l),j(zl.$$.fragment,l),j(Hl.$$.fragment,l),j(Ll.$$.fragment,l),j(Dl.$$.fragment,l),j(Pl.$$.fragment,l),j(le.$$.fragment,l),j(se.$$.fragment,l),j(ae.$$.fragment,l),j(ie.$$.fragment,l),j(Ue.$$.fragment,l),j(we.$$.fragment,l),j(de.$$.fragment,l),j(ce.$$.fragment,l),j(Ce.$$.fragment,l),j(me.$$.fragment,l),fM=!1},d(l){l&&(s(m),s(C),s(he),s(Ae),s(I),s(fe),s(u),s(be),s(A),s(_e),s(Ze),s(b),s(Ge),s(Be),s(_),s(Re),s(Z),s(ke),s(We),s(B),s(ge),s(R),s(ve),s(Ne),s(W),s(Ee),s(g),s(Xe),s(v),s(Ve),s(N),s($e),s(Qe),s(X),s(Ye),s(ze),s($),s(Se),s(Q),s(xe),s(He),s(z),s(Fe),s(Le),s(Oe),s(H),s(De),s(F),s(Pe),s(L),s(Ke),s(qe),s(D),s(ls),s(es),s(K),s(ss),s(q),s(Ms),s(ll),s(ts),s(el),s(as),s(sl),s(ns),s(Ml),s(ys),s(is),s(Us),s(nl),s(os),s(ps),s(il),s(ws),s(js),s(ol),s(Ts),s(pl),s(ds),s(wl),s(Js),s(cs),s(Tl),s(Cs),s(rs),s(Jl),s(ms),s(cl),s(hs),s(Is),s(rl),s(us),s(As),s(hl),s(fs),s(bs),s(ul),s(_s),s(Zs),s(fl),s(Gs),s(Bs),s(_l),s(Rs),s(Zl),s(ks),s(Gl),s(Ws),s(gs),s(Rl),s(vs),s(kl),s(Ns),s(Es),s(Xs),s(vl),s(Vs),s($s),s(Qs),s(Xl),s(Ys),s(zs),s(Ss),s(Ql),s(xs),s(Hs),s(Fs),s(Sl),s(Ls),s(xl),s(Os),s(Ds),s(Fl),s(Ps),s(Ks),s(Ol),s(qs),s(lM),s(eM),s(Kl),s(sM),s(ql),s(MM),s(tM),s(ee),s(aM),s(nM),s(Me),s(yM),s(te),s(iM),s(UM),s(ne),s(oM),s(ye),s(pM),s(wM),s(jM),s(oe),s(TM),s(pe),s(dM),s(JM),s(je),s(cM),s(Te),s(CM),s(rM),s(Je),s(mM),s(hM),s(IM),s(re),s(uM),s(AM),s(Ie)),s(c),T(h,l),T(f,l),T(r,l),T(G,l),T(k,l),T(E,l),T(V,l),T(Y,l),T(S,l),T(x,l),T(O,l),T(P,l),T(tl,l),T(al,l),T(yl,l),T(Ul,l),T(jl,l),T(dl,l),T(Cl,l),T(ml,l),T(Il,l),T(Al,l),T(bl,l),T(Bl,l),T(Wl,l),T(gl,l),T(Nl,l),T(El,l),T(Vl,l),T($l,l),T(Yl,l),T(zl,l),T(Hl,l),T(Ll,l),T(Dl,l),T(Pl,l),T(le,l),T(se,l),T(ae,l),T(ie,l),T(Ue,l),T(we,l),T(de,l),T(ce,l),T(Ce,l),T(me,l)}}}const Ot='{"title":"Modular Transformers","local":"modular-transformers","sections":[{"title":"Motivation","local":"motivation","sections":[],"depth":2},{"title":"Create a modeling.py file","local":"create-a-modelingpy-file","sections":[{"title":"BERT and RoBERTa","local":"bert-and-roberta","sections":[],"depth":3}],"depth":2},{"title":"Implementing a modular file","local":"implementing-a-modular-file","sections":[{"title":"Config","local":"config","sections":[],"depth":3},{"title":"Norm","local":"norm","sections":[],"depth":3},{"title":"Attention","local":"attention","sections":[],"depth":3},{"title":"DecoderLayer","local":"decoderlayer","sections":[],"depth":3},{"title":"Model","local":"model","sections":[],"depth":3},{"title":"Model head","local":"model-head","sections":[],"depth":3},{"title":"Other classes","local":"other-classes","sections":[],"depth":3}],"depth":2},{"title":"Removing attributes","local":"removing-attributes","sections":[],"depth":2},{"title":"Explicit super() calls","local":"explicit-super-calls","sections":[],"depth":2},{"title":"Deleting unused methods","local":"deleting-unused-methods","sections":[],"depth":2},{"title":"Defining new functions","local":"defining-new-functions","sections":[],"depth":2},{"title":"super_kwargs","local":"superkwargs","sections":[],"depth":2},{"title":"Docstring variables","local":"docstring-variables","sections":[],"depth":2},{"title":"Special naming","local":"special-naming","sections":[],"depth":2},{"title":"Config docstrings","local":"config-docstrings","sections":[],"depth":2}],"depth":1}';function Dt(ue){return Vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sa extends Qt{constructor(c){super(),Yt(this,c,Dt,Lt,Xt,{})}}export{sa as component};
