import{s as Ht,o as It,n as gt}from"../chunks/scheduler.01eeda35.js";import{S as xt,i as Yt,g as y,s as a,r as p,A as St,h,f as l,c as s,j as At,u as d,x as J,k as Vt,y as Pt,a as n,v as f,d as u,t as b,w as c}from"../chunks/index.6dd51b66.js";import{T as Dt}from"../chunks/Tip.de9bae2b.js";import{C as Z}from"../chunks/CodeBlock.864da1b0.js";import{H as R,E as Kt}from"../chunks/EditOnGithub.7faefd25.js";import{H as Ot,a as Lt}from"../chunks/HfOption.f7f04550.js";function el(k){let o,U="Quantizing a model in 8-bit halves the memory-usage, and for large models, set <code>device_map=&quot;auto&quot;</code> to efficiently distribute the weights across all available GPUs.",M,T,m,g,j='By default, all other modules such as <a href="https://pytorch.org/docs/stable/generated/torch.nn.LayerNorm.html" rel="nofollow">torch.nn.LayerNorm</a> are set to the default torch dtype. You can change the data type of these modules with the <code>torch_dtype</code> parameter. Setting <code>torch_dtype=&quot;auto&quot;</code> loads the model in the data type defined in a model’s <code>config.json</code> file.',B,w,C,_,X='Once a model is quantized to 8-bit, you can’t push the quantized weights to the Hub unless you’re using the latest version of Transformers and bitsandbytes. If you have the latest versions, then you can push the 8-bit model to the Hub with <a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>. The quantization config.json file is pushed first, followed by the quantized model weights.',v,r,$;return T=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlKSUwQSUwQW1vZGVsXzhiaXQlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)

model_8bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>, 
    quantization_config=quantization_config
)`,wrap:!1}}),w=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBJTBBbW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMjAlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRCUyMmF1dG8lMjIlMEEpJTBBbW9kZWxfOGJpdC5tb2RlbC5kZWNvZGVyLmxheWVycyU1Qi0xJTVELmZpbmFsX2xheWVyX25vcm0ud2VpZ2h0LmR0eXBl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)

model_8bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, 
    quantization_config=quantization_config, 
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>
)
model_8bit.model.decoder.layers[-<span class="hljs-number">1</span>].final_layer_norm.weight.dtype`,wrap:!1}}),r=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl84Yml0JTNEVHJ1ZSklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tNTYwbSUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTBBKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbS01NjBtJTIyKSUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMmJsb29tLTU2MG0tOGJpdCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-560m&quot;</span>, 
    quantization_config=quantization_config
)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom-560m&quot;</span>)

model.push_to_hub(<span class="hljs-string">&quot;bloom-560m-8bit&quot;</span>)`,wrap:!1}}),{c(){o=y("p"),o.innerHTML=U,M=a(),p(T.$$.fragment),m=a(),g=y("p"),g.innerHTML=j,B=a(),p(w.$$.fragment),C=a(),_=y("p"),_.innerHTML=X,v=a(),p(r.$$.fragment)},l(i){o=h(i,"P",{"data-svelte-h":!0}),J(o)!=="svelte-1752qjf"&&(o.innerHTML=U),M=s(i),d(T.$$.fragment,i),m=s(i),g=h(i,"P",{"data-svelte-h":!0}),J(g)!=="svelte-110db1o"&&(g.innerHTML=j),B=s(i),d(w.$$.fragment,i),C=s(i),_=h(i,"P",{"data-svelte-h":!0}),J(_)!=="svelte-13qaumd"&&(_.innerHTML=X),v=s(i),d(r.$$.fragment,i)},m(i,W){n(i,o,W),n(i,M,W),f(T,i,W),n(i,m,W),n(i,g,W),n(i,B,W),f(w,i,W),n(i,C,W),n(i,_,W),n(i,v,W),f(r,i,W),$=!0},p:gt,i(i){$||(u(T.$$.fragment,i),u(w.$$.fragment,i),u(r.$$.fragment,i),$=!0)},o(i){b(T.$$.fragment,i),b(w.$$.fragment,i),b(r.$$.fragment,i),$=!1},d(i){i&&(l(o),l(M),l(m),l(g),l(B),l(C),l(_),l(v)),c(T,i),c(w,i),c(r,i)}}}function tl(k){let o,U="Quantizing a model in 4-bit reduces your memory-usage by 4x, and for large models, set <code>device_map=&quot;auto&quot;</code> to efficiently distribute the weights across all available GPUs.",M,T,m,g,j='By default, all other modules such as <a href="https://pytorch.org/docs/stable/generated/torch.nn.LayerNorm.html" rel="nofollow">torch.nn.LayerNorm</a> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter.. Setting <code>torch_dtype=&quot;auto&quot;</code> loads the model in the data type defined in a model’s <code>config.json</code> file.',B,w,C,_,X='Make sure you have the latest bitsandbytes version so you can serialize 4-bit models and push them to the Hub with <a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>. Use <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> to save the 4-bit model locally.',v;return T=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlKSUwQSUwQW1vZGVsXzRiaXQlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)

model_4bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>,
    quantization_config=quantization_config
)`,wrap:!1}}),w=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUpJTBBJTBBbW9kZWxfNGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMjAlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRCUyMmF1dG8lMjIlMEEpJTBBbW9kZWxfNGJpdC5tb2RlbC5kZWNvZGVyLmxheWVycyU1Qi0xJTVELmZpbmFsX2xheWVyX25vcm0ud2VpZ2h0LmR0eXBl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)

model_4bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    quantization_config=quantization_config, 
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>
)
model_4bit.model.decoder.layers[-<span class="hljs-number">1</span>].final_layer_norm.weight.dtype`,wrap:!1}}),{c(){o=y("p"),o.innerHTML=U,M=a(),p(T.$$.fragment),m=a(),g=y("p"),g.innerHTML=j,B=a(),p(w.$$.fragment),C=a(),_=y("p"),_.innerHTML=X},l(r){o=h(r,"P",{"data-svelte-h":!0}),J(o)!=="svelte-vgig40"&&(o.innerHTML=U),M=s(r),d(T.$$.fragment,r),m=s(r),g=h(r,"P",{"data-svelte-h":!0}),J(g)!=="svelte-5p58r6"&&(g.innerHTML=j),B=s(r),d(w.$$.fragment,r),C=s(r),_=h(r,"P",{"data-svelte-h":!0}),J(_)!=="svelte-1flcsk7"&&(_.innerHTML=X)},m(r,$){n(r,o,$),n(r,M,$),f(T,r,$),n(r,m,$),n(r,g,$),n(r,B,$),f(w,r,$),n(r,C,$),n(r,_,$),v=!0},p:gt,i(r){v||(u(T.$$.fragment,r),u(w.$$.fragment,r),v=!0)},o(r){b(T.$$.fragment,r),b(w.$$.fragment,r),v=!1},d(r){r&&(l(o),l(M),l(m),l(g),l(B),l(C),l(_)),c(T,r),c(w,r)}}}function ll(k){let o,U,M,T;return o=new Lt({props:{id:"bnb",option:"8-bit",$$slots:{default:[el]},$$scope:{ctx:k}}}),M=new Lt({props:{id:"bnb",option:"4-bit",$$slots:{default:[tl]},$$scope:{ctx:k}}}),{c(){p(o.$$.fragment),U=a(),p(M.$$.fragment)},l(m){d(o.$$.fragment,m),U=s(m),d(M.$$.fragment,m)},m(m,g){f(o,m,g),n(m,U,g),f(M,m,g),T=!0},p(m,g){const j={};g&2&&(j.$$scope={dirty:g,ctx:m}),o.$set(j);const B={};g&2&&(B.$$scope={dirty:g,ctx:m}),M.$set(B)},i(m){T||(u(o.$$.fragment,m),u(M.$$.fragment,m),T=!0)},o(m){b(o.$$.fragment,m),b(M.$$.fragment,m),T=!1},d(m){m&&l(U),c(o,m),c(M,m)}}}function nl(k){let o,U="8 and 4-bit training is only supported for training <em>extra</em> parameters.";return{c(){o=y("p"),o.innerHTML=U},l(M){o=h(M,"P",{"data-svelte-h":!0}),J(o)!=="svelte-14e2693"&&(o.innerHTML=U)},m(M,T){n(M,o,T)},p:gt,d(M){M&&l(o)}}}function al(k){let o,U,M,T,m,g,j,B='<a href="https://github.com/bitsandbytes-foundation/bitsandbytes" rel="nofollow">bitsandbytes</a> features the LLM.int8 and QLoRA quantization to enable accessible large language model inference and training.',w,C,_='<a href="https://hf.co/papers/2208.07339" rel="nofollow">LLM.int8()</a> is a quantization method that aims to make large language model inference more accessible without significant degradation. Unlike naive 8-bit quantization, which can result in loss of critical information and accuracy, LLM.int8() dynamically adapts to ensure sensitive components of the computation retain higher precision when needed.',X,v,r="QLoRA, or 4-bit quantization, compresses a model even further to 4-bits and inserts a small set of trainable low-rank adaptation (LoRA) weights to allowing training.",$,i,W="Run the command below to install bitsandbytes.",ve,G,Ze,q,Tt='Quantize a model by passing a <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a> to <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a>. This works for any model in any modality, as long as it supports <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <a href="https://pytorch.org/docs/stable/generated/torch.nn.Linear.html" rel="nofollow">torch.nn.Linear</a> layers.',je,z,Be,N,We,F,wt="Check your memory footprint with <code>get_memory_footprint</code>.",Re,E,ke,Q,$t='Load quantized models with <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> without a <code>quantization_config</code>.',Xe,A,ze,V,Ne,L,Ut="This section explores some of the specific features of 8-bit quantization, such as offloading, outlier thresholds, skipping module conversion, and finetuning.",Ge,H,qe,I,_t='8-bit models can offload weights between the CPU and GPU to fit very large models into memory. The weights dispatched to the CPU are stored in <strong>float32</strong> and aren’t converted to 8-bit. For example, enable offloading for <a href="https://huggingface.co/bigscience/bloom-1b7" rel="nofollow">bigscience/bloom-1b7</a> through <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>.',Fe,x,Ee,Y,Ct="Design a custom device map to fit everything on your GPU except for the <code>lm_head</code>, which is dispatched to the CPU.",Qe,S,Ae,P,vt="Now load your model with the custom <code>device_map</code> and <code>quantization_config</code>.",Ve,D,Le,K,He,O,Zt="An “outlier” is a hidden state value greater than a certain threshold, and these values are computed in fp16. While the values are usually normally distributed ([-3.5, 3.5]), this distribution can be very different for large models ([-60, 6] or [6, 60]). 8-bit quantization works well for values ~5, but beyond that, there is a significant performance penalty. A good default threshold value is 6, but a lower threshold may be needed for more unstable models (small models or finetuning).",Ie,ee,jt='To find the best threshold for your model, experiment with the <code>llm_int8_threshold</code> parameter in <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>. For example, setting the threshold to <code>0.0</code> significantly speeds up inference at the potential cost of some accuracy loss.',xe,te,Ye,le,Se,ne,Bt='For some models, like <a href="model_doc/jukebox">Jukebox</a>, you don’t need to quantize every module to 8-bit because it can actually cause instability. With Jukebox, there are several <code>lm_head</code> modules that should be skipped using the <code>llm_int8_skip_modules</code> parameter in <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>.',Pe,ae,De,se,Ke,ie,Wt='The <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT</a> library supports fine-tuning large models like <a href="https://huggingface.co/google/flan-t5-large" rel="nofollow">flan-t5-large</a> and <a href="https://huggingface.co/facebook/opt-6.7b" rel="nofollow">facebook/opt-6.7b</a> with 8-bit quantization. You don’t need to pass the <code>device_map</code> parameter for training because it automatically loads your model on a GPU. However, you can still customize the device map with the <code>device_map</code> parameter (<code>device_map=&quot;auto&quot;</code> should only be used for inference).',Oe,oe,et,re,Rt="This section explores some of the specific features of 4-bit quantization, such as changing the compute data type, the Normal Float 4 (NF4) data type, and nested quantization.",tt,me,lt,pe,kt='Change the data type from float32 (the default value) to bf16 in <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a> to speedup computation.',nt,de,at,fe,st,ue,Xt='NF4 is a 4-bit data type from the <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> paper, adapted for weights initialized from a normal distribution. You should use NF4 for training 4-bit base models.',it,be,ot,ce,zt="For inference, the <code>bnb_4bit_quant_type</code> does not have a huge impact on performance. However, to remain consistent with the model weights, you should use the <code>bnb_4bit_compute_dtype</code> and <code>torch_dtype</code> values.",rt,ye,mt,he,Nt='Nested quantization can save additional memory at no additional performance cost. This feature performs a second quantization of the already quantized weights to save an additional 0.4 bits/parameter. For example, with nested quantization, you can finetune a <a href="https://huggingface.co/meta-llama/Llama-2-13b" rel="nofollow">Llama-13b</a> model on a 16GB NVIDIA T4 GPU with a sequence length of 1024, a batch size of 1, and enable gradient accumulation with 4 steps.',pt,Me,dt,Je,ft,ge,Gt='Once quantized, you can <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.dequantize">dequantize()</a> a model to the original precision but this may result in some quality loss. Make sure you have enough GPU memory to fit the dequantized model.',ut,Te,bt,we,ct,$e,qt='Learn more about the details of 8-bit quantization in <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">A Gentle Introduction to 8-bit Matrix Multiplication for transformers at scale using Hugging Face Transformers, Accelerate and bitsandbytes</a>.',yt,Ue,Ft='Try 4-bit quantization in this <a href="https://colab.research.google.com/drive/1ge2F1QSK8Q7h0hn3YKuBCOAS0bK8E0wf" rel="nofollow">notebook</a> and learn more about it’s details in <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a>.',ht,_e,Mt,Ce,Jt;return m=new R({props:{title:"bitsandbytes",local:"bitsandbytes",headingTag:"h1"}}),G=new Z({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXM=",highlighted:"pip install --upgrade transformers accelerate bitsandbytes",wrap:!1}}),z=new Ot({props:{id:"bnb",options:["8-bit","4-bit"],$$slots:{default:[ll]},$$scope:{ctx:k}}}),N=new Dt({props:{warning:!0,$$slots:{default:[nl]},$$scope:{ctx:k}}}),E=new Z({props:{code:"cHJpbnQobW9kZWwuZ2V0X21lbW9yeV9mb290cHJpbnQoKSk=",highlighted:'<span class="hljs-built_in">print</span>(model.get_memory_footprint())',wrap:!1}}),A=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZibG9vbS01NjBtLThiaXQlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/bloom-560m-8bit&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),V=new R({props:{title:"LLM.int8",local:"llmint8",headingTag:"h2"}}),H=new R({props:{title:"Offloading",local:"offloading",headingTag:"h3"}}),x=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsbG1faW50OF9lbmFibGVfZnAzMl9jcHVfb2ZmbG9hZCUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(llm_int8_enable_fp32_cpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),S=new Z({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLndvcmRfZW1iZWRkaW5ncyUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci53b3JkX2VtYmVkZGluZ3NfbGF5ZXJub3JtJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxtX2hlYWQlMjIlM0ElMjAlMjJjcHUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci5oJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLmxuX2YlMjIlM0ElMjAwJTJDJTBBJTdE",highlighted:`device_map = {
    <span class="hljs-string">&quot;transformer.word_embeddings&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.word_embeddings_layernorm&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;lm_head&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.h&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.ln_f&quot;</span>: <span class="hljs-number">0</span>,
}`,wrap:!1}}),D=new Z({props:{code:"bW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRGRldmljZV9tYXAlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`model_8bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    device_map=device_map,
    quantization_config=quantization_config,
)`,wrap:!1}}),K=new R({props:{title:"Outlier threshold",local:"outlier-threshold",headingTag:"h3"}}),te=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsbG1faW50OF90aHJlc2hvbGQlM0QwLjAlMkMlMEElMjAlMjAlMjAlMjBsbG1faW50OF9lbmFibGVfZnAzMl9jcHVfb2ZmbG9hZCUzRFRydWUlMEEpJTBBJTBBbW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RkZXZpY2VfbWFwJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

quantization_config = BitsAndBytesConfig(
    llm_int8_threshold=<span class="hljs-number">0.0</span>,
    llm_int8_enable_fp32_cpu_offload=<span class="hljs-literal">True</span>
)

model_8bit = AutoModelForCausalLM.from_pretrained(
    model_id,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    device_map=device_map,
    quantization_config=quantization_config,
)`,wrap:!1}}),le=new R({props:{title:"Skip module conversion",local:"skip-module-conversion",headingTag:"h3"}}),ae=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbGxtX2ludDhfc2tpcF9tb2R1bGVzJTNEJTVCJTIybG1faGVhZCUyMiU1RCUyQyUwQSklMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

quantization_config = BitsAndBytesConfig(
    llm_int8_skip_modules=[<span class="hljs-string">&quot;lm_head&quot;</span>],
)

model_8bit = AutoModelForCausalLM.from_pretrained(
    model_id,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),se=new R({props:{title:"Finetuning",local:"finetuning",headingTag:"h3"}}),oe=new R({props:{title:"QLoRA",local:"qlora",headingTag:"h2"}}),me=new R({props:{title:"Compute data type",local:"compute-data-type",headingTag:"h3"}}),de=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)`,wrap:!1}}),fe=new R({props:{title:"Normal Float 4 (NF4)",local:"normal-float-4-nf4",headingTag:"h3"}}),be=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQW5mNF9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEEpJTBBJTBBbW9kZWxfbmY0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRG5mNF9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

nf4_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

model_nf4 = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=nf4_config)`,wrap:!1}}),ye=new R({props:{title:"Nested quantization",local:"nested-quantization",headingTag:"h3"}}),Me=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQWRvdWJsZV9xdWFudF9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBKSUwQSUwQW1vZGVsX2RvdWJsZV9xdWFudCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi0xM2ItY2hhdC1oZiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMiUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0Rkb3VibGVfcXVhbnRfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

double_quant_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

model_double_quant = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-13b-chat-hf&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=double_quant_config)`,wrap:!1}}),Je=new R({props:{title:"Dequantizing bitsandbytes models",local:"dequantizing-bitsandbytes-models",headingTag:"h2"}}),Te=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEyNW0lMjIlMkMlMjBCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl80Yml0JTNEVHJ1ZSkpJTBBbW9kZWwuZGVxdWFudGl6ZSgp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>, BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>))
model.dequantize()`,wrap:!1}}),we=new R({props:{title:"Resources",local:"resources",headingTag:"h2"}}),_e=new Kt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/quantization/bitsandbytes.md"}}),{c(){o=y("meta"),U=a(),M=y("p"),T=a(),p(m.$$.fragment),g=a(),j=y("p"),j.innerHTML=B,w=a(),C=y("p"),C.innerHTML=_,X=a(),v=y("p"),v.textContent=r,$=a(),i=y("p"),i.textContent=W,ve=a(),p(G.$$.fragment),Ze=a(),q=y("p"),q.innerHTML=Tt,je=a(),p(z.$$.fragment),Be=a(),p(N.$$.fragment),We=a(),F=y("p"),F.innerHTML=wt,Re=a(),p(E.$$.fragment),ke=a(),Q=y("p"),Q.innerHTML=$t,Xe=a(),p(A.$$.fragment),ze=a(),p(V.$$.fragment),Ne=a(),L=y("p"),L.textContent=Ut,Ge=a(),p(H.$$.fragment),qe=a(),I=y("p"),I.innerHTML=_t,Fe=a(),p(x.$$.fragment),Ee=a(),Y=y("p"),Y.innerHTML=Ct,Qe=a(),p(S.$$.fragment),Ae=a(),P=y("p"),P.innerHTML=vt,Ve=a(),p(D.$$.fragment),Le=a(),p(K.$$.fragment),He=a(),O=y("p"),O.textContent=Zt,Ie=a(),ee=y("p"),ee.innerHTML=jt,xe=a(),p(te.$$.fragment),Ye=a(),p(le.$$.fragment),Se=a(),ne=y("p"),ne.innerHTML=Bt,Pe=a(),p(ae.$$.fragment),De=a(),p(se.$$.fragment),Ke=a(),ie=y("p"),ie.innerHTML=Wt,Oe=a(),p(oe.$$.fragment),et=a(),re=y("p"),re.textContent=Rt,tt=a(),p(me.$$.fragment),lt=a(),pe=y("p"),pe.innerHTML=kt,nt=a(),p(de.$$.fragment),at=a(),p(fe.$$.fragment),st=a(),ue=y("p"),ue.innerHTML=Xt,it=a(),p(be.$$.fragment),ot=a(),ce=y("p"),ce.innerHTML=zt,rt=a(),p(ye.$$.fragment),mt=a(),he=y("p"),he.innerHTML=Nt,pt=a(),p(Me.$$.fragment),dt=a(),p(Je.$$.fragment),ft=a(),ge=y("p"),ge.innerHTML=Gt,ut=a(),p(Te.$$.fragment),bt=a(),p(we.$$.fragment),ct=a(),$e=y("p"),$e.innerHTML=qt,yt=a(),Ue=y("p"),Ue.innerHTML=Ft,ht=a(),p(_e.$$.fragment),Mt=a(),Ce=y("p"),this.h()},l(e){const t=St("svelte-u9bgzb",document.head);o=h(t,"META",{name:!0,content:!0}),t.forEach(l),U=s(e),M=h(e,"P",{}),At(M).forEach(l),T=s(e),d(m.$$.fragment,e),g=s(e),j=h(e,"P",{"data-svelte-h":!0}),J(j)!=="svelte-xcj7ov"&&(j.innerHTML=B),w=s(e),C=h(e,"P",{"data-svelte-h":!0}),J(C)!=="svelte-ehhzma"&&(C.innerHTML=_),X=s(e),v=h(e,"P",{"data-svelte-h":!0}),J(v)!=="svelte-1to8m43"&&(v.textContent=r),$=s(e),i=h(e,"P",{"data-svelte-h":!0}),J(i)!=="svelte-nn1zee"&&(i.textContent=W),ve=s(e),d(G.$$.fragment,e),Ze=s(e),q=h(e,"P",{"data-svelte-h":!0}),J(q)!=="svelte-nvcemd"&&(q.innerHTML=Tt),je=s(e),d(z.$$.fragment,e),Be=s(e),d(N.$$.fragment,e),We=s(e),F=h(e,"P",{"data-svelte-h":!0}),J(F)!=="svelte-3u2pq"&&(F.innerHTML=wt),Re=s(e),d(E.$$.fragment,e),ke=s(e),Q=h(e,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-5ab1q1"&&(Q.innerHTML=$t),Xe=s(e),d(A.$$.fragment,e),ze=s(e),d(V.$$.fragment,e),Ne=s(e),L=h(e,"P",{"data-svelte-h":!0}),J(L)!=="svelte-9650w3"&&(L.textContent=Ut),Ge=s(e),d(H.$$.fragment,e),qe=s(e),I=h(e,"P",{"data-svelte-h":!0}),J(I)!=="svelte-1jt3bby"&&(I.innerHTML=_t),Fe=s(e),d(x.$$.fragment,e),Ee=s(e),Y=h(e,"P",{"data-svelte-h":!0}),J(Y)!=="svelte-80v3vx"&&(Y.innerHTML=Ct),Qe=s(e),d(S.$$.fragment,e),Ae=s(e),P=h(e,"P",{"data-svelte-h":!0}),J(P)!=="svelte-1oaka12"&&(P.innerHTML=vt),Ve=s(e),d(D.$$.fragment,e),Le=s(e),d(K.$$.fragment,e),He=s(e),O=h(e,"P",{"data-svelte-h":!0}),J(O)!=="svelte-ur5rgd"&&(O.textContent=Zt),Ie=s(e),ee=h(e,"P",{"data-svelte-h":!0}),J(ee)!=="svelte-1jcweb0"&&(ee.innerHTML=jt),xe=s(e),d(te.$$.fragment,e),Ye=s(e),d(le.$$.fragment,e),Se=s(e),ne=h(e,"P",{"data-svelte-h":!0}),J(ne)!=="svelte-1f7c9ag"&&(ne.innerHTML=Bt),Pe=s(e),d(ae.$$.fragment,e),De=s(e),d(se.$$.fragment,e),Ke=s(e),ie=h(e,"P",{"data-svelte-h":!0}),J(ie)!=="svelte-18qfkz8"&&(ie.innerHTML=Wt),Oe=s(e),d(oe.$$.fragment,e),et=s(e),re=h(e,"P",{"data-svelte-h":!0}),J(re)!=="svelte-1b1i0z0"&&(re.textContent=Rt),tt=s(e),d(me.$$.fragment,e),lt=s(e),pe=h(e,"P",{"data-svelte-h":!0}),J(pe)!=="svelte-cv16qb"&&(pe.innerHTML=kt),nt=s(e),d(de.$$.fragment,e),at=s(e),d(fe.$$.fragment,e),st=s(e),ue=h(e,"P",{"data-svelte-h":!0}),J(ue)!=="svelte-vfa0sb"&&(ue.innerHTML=Xt),it=s(e),d(be.$$.fragment,e),ot=s(e),ce=h(e,"P",{"data-svelte-h":!0}),J(ce)!=="svelte-1qoc2ct"&&(ce.innerHTML=zt),rt=s(e),d(ye.$$.fragment,e),mt=s(e),he=h(e,"P",{"data-svelte-h":!0}),J(he)!=="svelte-1jt2w56"&&(he.innerHTML=Nt),pt=s(e),d(Me.$$.fragment,e),dt=s(e),d(Je.$$.fragment,e),ft=s(e),ge=h(e,"P",{"data-svelte-h":!0}),J(ge)!=="svelte-192l2ej"&&(ge.innerHTML=Gt),ut=s(e),d(Te.$$.fragment,e),bt=s(e),d(we.$$.fragment,e),ct=s(e),$e=h(e,"P",{"data-svelte-h":!0}),J($e)!=="svelte-km4860"&&($e.innerHTML=qt),yt=s(e),Ue=h(e,"P",{"data-svelte-h":!0}),J(Ue)!=="svelte-96sk4r"&&(Ue.innerHTML=Ft),ht=s(e),d(_e.$$.fragment,e),Mt=s(e),Ce=h(e,"P",{}),At(Ce).forEach(l),this.h()},h(){Vt(o,"name","hf:doc:metadata"),Vt(o,"content",sl)},m(e,t){Pt(document.head,o),n(e,U,t),n(e,M,t),n(e,T,t),f(m,e,t),n(e,g,t),n(e,j,t),n(e,w,t),n(e,C,t),n(e,X,t),n(e,v,t),n(e,$,t),n(e,i,t),n(e,ve,t),f(G,e,t),n(e,Ze,t),n(e,q,t),n(e,je,t),f(z,e,t),n(e,Be,t),f(N,e,t),n(e,We,t),n(e,F,t),n(e,Re,t),f(E,e,t),n(e,ke,t),n(e,Q,t),n(e,Xe,t),f(A,e,t),n(e,ze,t),f(V,e,t),n(e,Ne,t),n(e,L,t),n(e,Ge,t),f(H,e,t),n(e,qe,t),n(e,I,t),n(e,Fe,t),f(x,e,t),n(e,Ee,t),n(e,Y,t),n(e,Qe,t),f(S,e,t),n(e,Ae,t),n(e,P,t),n(e,Ve,t),f(D,e,t),n(e,Le,t),f(K,e,t),n(e,He,t),n(e,O,t),n(e,Ie,t),n(e,ee,t),n(e,xe,t),f(te,e,t),n(e,Ye,t),f(le,e,t),n(e,Se,t),n(e,ne,t),n(e,Pe,t),f(ae,e,t),n(e,De,t),f(se,e,t),n(e,Ke,t),n(e,ie,t),n(e,Oe,t),f(oe,e,t),n(e,et,t),n(e,re,t),n(e,tt,t),f(me,e,t),n(e,lt,t),n(e,pe,t),n(e,nt,t),f(de,e,t),n(e,at,t),f(fe,e,t),n(e,st,t),n(e,ue,t),n(e,it,t),f(be,e,t),n(e,ot,t),n(e,ce,t),n(e,rt,t),f(ye,e,t),n(e,mt,t),n(e,he,t),n(e,pt,t),f(Me,e,t),n(e,dt,t),f(Je,e,t),n(e,ft,t),n(e,ge,t),n(e,ut,t),f(Te,e,t),n(e,bt,t),f(we,e,t),n(e,ct,t),n(e,$e,t),n(e,yt,t),n(e,Ue,t),n(e,ht,t),f(_e,e,t),n(e,Mt,t),n(e,Ce,t),Jt=!0},p(e,[t]){const Et={};t&2&&(Et.$$scope={dirty:t,ctx:e}),z.$set(Et);const Qt={};t&2&&(Qt.$$scope={dirty:t,ctx:e}),N.$set(Qt)},i(e){Jt||(u(m.$$.fragment,e),u(G.$$.fragment,e),u(z.$$.fragment,e),u(N.$$.fragment,e),u(E.$$.fragment,e),u(A.$$.fragment,e),u(V.$$.fragment,e),u(H.$$.fragment,e),u(x.$$.fragment,e),u(S.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),u(oe.$$.fragment,e),u(me.$$.fragment,e),u(de.$$.fragment,e),u(fe.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(Me.$$.fragment,e),u(Je.$$.fragment,e),u(Te.$$.fragment,e),u(we.$$.fragment,e),u(_e.$$.fragment,e),Jt=!0)},o(e){b(m.$$.fragment,e),b(G.$$.fragment,e),b(z.$$.fragment,e),b(N.$$.fragment,e),b(E.$$.fragment,e),b(A.$$.fragment,e),b(V.$$.fragment,e),b(H.$$.fragment,e),b(x.$$.fragment,e),b(S.$$.fragment,e),b(D.$$.fragment,e),b(K.$$.fragment,e),b(te.$$.fragment,e),b(le.$$.fragment,e),b(ae.$$.fragment,e),b(se.$$.fragment,e),b(oe.$$.fragment,e),b(me.$$.fragment,e),b(de.$$.fragment,e),b(fe.$$.fragment,e),b(be.$$.fragment,e),b(ye.$$.fragment,e),b(Me.$$.fragment,e),b(Je.$$.fragment,e),b(Te.$$.fragment,e),b(we.$$.fragment,e),b(_e.$$.fragment,e),Jt=!1},d(e){e&&(l(U),l(M),l(T),l(g),l(j),l(w),l(C),l(X),l(v),l($),l(i),l(ve),l(Ze),l(q),l(je),l(Be),l(We),l(F),l(Re),l(ke),l(Q),l(Xe),l(ze),l(Ne),l(L),l(Ge),l(qe),l(I),l(Fe),l(Ee),l(Y),l(Qe),l(Ae),l(P),l(Ve),l(Le),l(He),l(O),l(Ie),l(ee),l(xe),l(Ye),l(Se),l(ne),l(Pe),l(De),l(Ke),l(ie),l(Oe),l(et),l(re),l(tt),l(lt),l(pe),l(nt),l(at),l(st),l(ue),l(it),l(ot),l(ce),l(rt),l(mt),l(he),l(pt),l(dt),l(ft),l(ge),l(ut),l(bt),l(ct),l($e),l(yt),l(Ue),l(ht),l(Mt),l(Ce)),l(o),c(m,e),c(G,e),c(z,e),c(N,e),c(E,e),c(A,e),c(V,e),c(H,e),c(x,e),c(S,e),c(D,e),c(K,e),c(te,e),c(le,e),c(ae,e),c(se,e),c(oe,e),c(me,e),c(de,e),c(fe,e),c(be,e),c(ye,e),c(Me,e),c(Je,e),c(Te,e),c(we,e),c(_e,e)}}}const sl='{"title":"bitsandbytes","local":"bitsandbytes","sections":[{"title":"LLM.int8","local":"llmint8","sections":[{"title":"Offloading","local":"offloading","sections":[],"depth":3},{"title":"Outlier threshold","local":"outlier-threshold","sections":[],"depth":3},{"title":"Skip module conversion","local":"skip-module-conversion","sections":[],"depth":3},{"title":"Finetuning","local":"finetuning","sections":[],"depth":3}],"depth":2},{"title":"QLoRA","local":"qlora","sections":[{"title":"Compute data type","local":"compute-data-type","sections":[],"depth":3},{"title":"Normal Float 4 (NF4)","local":"normal-float-4-nf4","sections":[],"depth":3},{"title":"Nested quantization","local":"nested-quantization","sections":[],"depth":3}],"depth":2},{"title":"Dequantizing bitsandbytes models","local":"dequantizing-bitsandbytes-models","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function il(k){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ul extends xt{constructor(o){super(),Yt(this,o,il,al,Ht,{})}}export{ul as component};
