import{s as dt,o as ht,n as ut}from"../chunks/scheduler.01eeda35.js";import{S as yt,i as ft,g as J,s as c,r as W,A as bt,h as T,f as a,c as m,j as rt,u as X,x as U,k as ct,y as Jt,a as s,v as g,d as Z,t as G,w as I}from"../chunks/index.6dd51b66.js";import{T as Mt}from"../chunks/Tip.de9bae2b.js";import{C as x}from"../chunks/CodeBlock.864da1b0.js";import{H as at,E as Tt}from"../chunks/EditOnGithub.7faefd25.js";import{H as wt,a as mt}from"../chunks/HfOption.f7f04550.js";function jt($){let e,h="Run the quantized model on a CPU by changing <code>device_map</code> to <code>&quot;cpu&quot;</code> and <code>layout</code> to <code>Int4CPULayout()</code>. This is only available in torchao 0.8.0+.";return{c(){e=J("p"),e.innerHTML=h},l(i){e=T(i,"P",{"data-svelte-h":!0}),U(e)!=="svelte-b8nyn5"&&(e.innerHTML=h)},m(i,r){s(i,e,r)},p:ut,d(i){i&&a(e)}}}function _t($){let e,h='Create a <a href="/docs/transformers/main/en/main_classes/quantization#transformers.TorchAoConfig">TorchAoConfig</a> and specify the quantization type and <code>group_size</code> of the weights to quantize. Set the <code>cache_implementation</code> to <code>&quot;static&quot;</code> to automatically <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow">torch.compile</a> the forward method.',i,r,p,u,d,f,j="Run the code below to benchmark the quantized models performance.",w,b,q;return r=new Mt({props:{warning:!1,$$slots:{default:[jt]},$$scope:{ctx:$}}}),u=new x({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVG9yY2hBb0NvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBUb3JjaEFvQ29uZmlnKCUyMmludDRfd2VpZ2h0X29ubHklMjIlMkMlMjBncm91cF9zaXplJTNEMTI4KSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUwQSklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCJTIyKSUwQWlucHV0X3RleHQlMjAlM0QlMjAlMjJXaGF0JTIwYXJlJTIwd2UlMjBoYXZpbmclMjBmb3IlMjBkaW5uZXIlM0YlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwYXV0by1jb21waWxlJTIwdGhlJTIwcXVhbnRpemVkJTIwbW9kZWwlMjB3aXRoJTIwJTYwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIlNjAlMjB0byUyMGdldCUyMHNwZWVkJTIwdXAlMEFvdXRwdXQlMjAlM0QlMjBxdWFudGl6ZWRfbW9kZWwuZ2VuZXJhdGUoKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TorchAoConfig, AutoModelForCausalLM, AutoTokenizer

quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int4_weight_only&quot;</span>, group_size=<span class="hljs-number">128</span>)
quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    quantization_config=quantization_config
)

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>)
input_text = <span class="hljs-string">&quot;What are we having for dinner?&quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># auto-compile the quantized model with \`cache_implementation=&quot;static&quot;\` to get speed up</span>
output = quantized_model.generate(**input_ids, max_new_tokens=<span class="hljs-number">10</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),b=new x({props:{code:"ZnJvbSUyMHRvcmNoLl9pbmR1Y3Rvci51dGlscyUyMGltcG9ydCUyMGRvX2JlbmNoX3VzaW5nX3Byb2ZpbGluZyUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBDYWxsYWJsZSUwQSUwQWRlZiUyMGJlbmNobWFya19mbihmdW5jJTNBJTIwQ2FsbGFibGUlMkMlMjAqYXJncyUyQyUyMCoqa3dhcmdzKSUyMC0lM0UlMjBmbG9hdCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlRoaW4lMjB3cmFwcGVyJTIwYXJvdW5kJTIwZG9fYmVuY2hfdXNpbmdfcHJvZmlsaW5nJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwbm9fYXJncyUyMCUzRCUyMGxhbWJkYSUzQSUyMGZ1bmMoKmFyZ3MlMkMlMjAqKmt3YXJncyklMEElMjAlMjAlMjAlMjB0aW1lJTIwJTNEJTIwZG9fYmVuY2hfdXNpbmdfcHJvZmlsaW5nKG5vX2FyZ3MpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdGltZSUyMColMjAxZTMlMEElMEFNQVhfTkVXX1RPS0VOUyUyMCUzRCUyMDEwMDAlMEFwcmludCglMjJpbnQ0d28tMTI4JTIwbW9kZWwlM0ElMjIlMkMlMjBiZW5jaG1hcmtfZm4ocXVhbnRpemVkX21vZGVsLmdlbmVyYXRlJTJDJTIwKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRE1BWF9ORVdfVE9LRU5TJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIpKSUwQSUwQWJmMTZfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFvdXRwdXQlMjAlM0QlMjBiZjE2X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyc3RhdGljJTIyKSUyMCUyMyUyMGF1dG8tY29tcGlsZSUwQXByaW50KCUyMmJmMTYlMjBtb2RlbCUzQSUyMiUyQyUyMGJlbmNobWFya19mbihiZjE2X21vZGVsLmdlbmVyYXRlJTJDJTIwKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRE1BWF9ORVdfVE9LRU5TJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIpKQ==",highlighted:`<span class="hljs-keyword">from</span> torch._inductor.utils <span class="hljs-keyword">import</span> do_bench_using_profiling
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Callable</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">benchmark_fn</span>(<span class="hljs-params">func: <span class="hljs-type">Callable</span>, *args, **kwargs</span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Thin wrapper around do_bench_using_profiling&quot;&quot;&quot;</span>
    no_args = <span class="hljs-keyword">lambda</span>: func(*args, **kwargs)
    time = do_bench_using_profiling(no_args)
    <span class="hljs-keyword">return</span> time * <span class="hljs-number">1e3</span>

MAX_NEW_TOKENS = <span class="hljs-number">1000</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;int4wo-128 model:&quot;</span>, benchmark_fn(quantized_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>))

bf16_model = AutoModelForCausalLM.from_pretrained(model_name, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16)
output = bf16_model.generate(**input_ids, max_new_tokens=<span class="hljs-number">10</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>) <span class="hljs-comment"># auto-compile</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;bf16 model:&quot;</span>, benchmark_fn(bf16_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>))`,wrap:!1}}),{c(){e=J("p"),e.innerHTML=h,i=c(),W(r.$$.fragment),p=c(),W(u.$$.fragment),d=c(),f=J("p"),f.textContent=j,w=c(),W(b.$$.fragment)},l(l){e=T(l,"P",{"data-svelte-h":!0}),U(e)!=="svelte-vp4lhi"&&(e.innerHTML=h),i=m(l),X(r.$$.fragment,l),p=m(l),X(u.$$.fragment,l),d=m(l),f=T(l,"P",{"data-svelte-h":!0}),U(f)!=="svelte-thutbg"&&(f.textContent=j),w=m(l),X(b.$$.fragment,l)},m(l,M){s(l,e,M),s(l,i,M),g(r,l,M),s(l,p,M),g(u,l,M),s(l,d,M),s(l,f,M),s(l,w,M),g(b,l,M),q=!0},p(l,M){const _={};M&2&&(_.$$scope={dirty:M,ctx:l}),r.$set(_)},i(l){q||(Z(r.$$.fragment,l),Z(u.$$.fragment,l),Z(b.$$.fragment,l),q=!0)},o(l){G(r.$$.fragment,l),G(u.$$.fragment,l),G(b.$$.fragment,l),q=!1},d(l){l&&(a(e),a(i),a(p),a(d),a(f),a(w)),I(r,l),I(u,l),I(b,l)}}}function Ut($){let e,h="Run the quantized model on a CPU by changing <code>device_map</code> to <code>&quot;cpu&quot;</code> and <code>layout</code> to <code>Int4CPULayout()</code>. This is only available in torchao 0.8.0+.";return{c(){e=J("p"),e.innerHTML=h},l(i){e=T(i,"P",{"data-svelte-h":!0}),U(e)!=="svelte-b8nyn5"&&(e.innerHTML=h)},m(i,r){s(i,e,r)},p:ut,d(i){i&&a(e)}}}function Wt($){let e,h='The <a href="https://pytorch.org/ao/stable/generated/torchao.quantization.autoquant.html#torchao.quantization.autoquant" rel="nofollow">autoquant</a> API automatically chooses a quantization type for quantizable layers (<code>nn.Linear</code>) by micro-benchmarking on input type and shape and compiling a single linear layer.',i,r,p='Create a <a href="/docs/transformers/main/en/main_classes/quantization#transformers.TorchAoConfig">TorchAoConfig</a> and set to <code>&quot;autoquant&quot;</code>. Set the <code>cache_implementation</code> to <code>&quot;static&quot;</code> to automatically <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow">torch.compile</a> the forward method. Finally, call <code>finalize_autoquant</code> on the quantized model to finalize the quantization and log the input shapes.',u,d,f,j,w,b,q="Run the code below to benchmark the quantized models performance.",l,M,_;return d=new Mt({props:{warning:!1,$$slots:{default:[Ut]},$$scope:{ctx:$}}}),j=new x({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVG9yY2hBb0NvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBUb3JjaEFvQ29uZmlnKCUyMmF1dG9xdWFudCUyMiUyQyUyMG1pbl9zcW5yJTNETm9uZSklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04QiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMEEpJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04QiUyMiklMEFpbnB1dF90ZXh0JTIwJTNEJTIwJTIyV2hhdCUyMGFyZSUyMHdlJTIwaGF2aW5nJTIwZm9yJTIwZGlubmVyJTNGJTIyJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGF1dG8tY29tcGlsZSUyMHRoZSUyMHF1YW50aXplZCUyMG1vZGVsJTIwd2l0aCUyMCU2MGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyc3RhdGljJTIyJTYwJTIwdG8lMjBnZXQlMjBzcGVlZCUyMHVwJTBBb3V0cHV0JTIwJTNEJTIwcXVhbnRpemVkX21vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyc3RhdGljJTIyKSUwQSUyMyUyMGV4cGxpY2l0bHklMjBjYWxsJTIwJTYwZmluYWxpemVfYXV0b3F1YW50JTYwJTIwKG1heSUyMGJlJTIwcmVmYWN0b3JlZCUyMGFuZCUyMHJlbW92ZWQlMjBpbiUyMHRoZSUyMGZ1dHVyZSklMEFxdWFudGl6ZWRfbW9kZWwuZmluYWxpemVfYXV0b3F1YW50KCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dCU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TorchAoConfig, AutoModelForCausalLM, AutoTokenizer

quantization_config = TorchAoConfig(<span class="hljs-string">&quot;autoquant&quot;</span>, min_sqnr=<span class="hljs-literal">None</span>)
quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    quantization_config=quantization_config
)

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>)
input_text = <span class="hljs-string">&quot;What are we having for dinner?&quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># auto-compile the quantized model with \`cache_implementation=&quot;static&quot;\` to get speed up</span>
output = quantized_model.generate(**input_ids, max_new_tokens=<span class="hljs-number">10</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>)
<span class="hljs-comment"># explicitly call \`finalize_autoquant\` (may be refactored and removed in the future)</span>
quantized_model.finalize_autoquant()
<span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),M=new x({props:{code:"ZnJvbSUyMHRvcmNoLl9pbmR1Y3Rvci51dGlscyUyMGltcG9ydCUyMGRvX2JlbmNoX3VzaW5nX3Byb2ZpbGluZyUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBDYWxsYWJsZSUwQSUwQWRlZiUyMGJlbmNobWFya19mbihmdW5jJTNBJTIwQ2FsbGFibGUlMkMlMjAqYXJncyUyQyUyMCoqa3dhcmdzKSUyMC0lM0UlMjBmbG9hdCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlRoaW4lMjB3cmFwcGVyJTIwYXJvdW5kJTIwZG9fYmVuY2hfdXNpbmdfcHJvZmlsaW5nJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwbm9fYXJncyUyMCUzRCUyMGxhbWJkYSUzQSUyMGZ1bmMoKmFyZ3MlMkMlMjAqKmt3YXJncyklMEElMjAlMjAlMjAlMjB0aW1lJTIwJTNEJTIwZG9fYmVuY2hfdXNpbmdfcHJvZmlsaW5nKG5vX2FyZ3MpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdGltZSUyMColMjAxZTMlMEElMEFNQVhfTkVXX1RPS0VOUyUyMCUzRCUyMDEwMDAlMEFwcmludCglMjJhdXRvcXVhbnRpemVkJTIwbW9kZWwlM0ElMjIlMkMlMjBiZW5jaG1hcmtfZm4ocXVhbnRpemVkX21vZGVsLmdlbmVyYXRlJTJDJTIwKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRE1BWF9ORVdfVE9LRU5TJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIpKSUwQSUwQWJmMTZfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFvdXRwdXQlMjAlM0QlMjBiZjE2X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyc3RhdGljJTIyKSUyMCUyMyUyMGF1dG8tY29tcGlsZSUwQXByaW50KCUyMmJmMTYlMjBtb2RlbCUzQSUyMiUyQyUyMGJlbmNobWFya19mbihiZjE2X21vZGVsLmdlbmVyYXRlJTJDJTIwKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRE1BWF9ORVdfVE9LRU5TJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIpKQ==",highlighted:`<span class="hljs-keyword">from</span> torch._inductor.utils <span class="hljs-keyword">import</span> do_bench_using_profiling
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Callable</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">benchmark_fn</span>(<span class="hljs-params">func: <span class="hljs-type">Callable</span>, *args, **kwargs</span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Thin wrapper around do_bench_using_profiling&quot;&quot;&quot;</span>
    no_args = <span class="hljs-keyword">lambda</span>: func(*args, **kwargs)
    time = do_bench_using_profiling(no_args)
    <span class="hljs-keyword">return</span> time * <span class="hljs-number">1e3</span>

MAX_NEW_TOKENS = <span class="hljs-number">1000</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;autoquantized model:&quot;</span>, benchmark_fn(quantized_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>))

bf16_model = AutoModelForCausalLM.from_pretrained(model_name, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16)
output = bf16_model.generate(**input_ids, max_new_tokens=<span class="hljs-number">10</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>) <span class="hljs-comment"># auto-compile</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;bf16 model:&quot;</span>, benchmark_fn(bf16_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>))`,wrap:!1}}),{c(){e=J("p"),e.innerHTML=h,i=c(),r=J("p"),r.innerHTML=p,u=c(),W(d.$$.fragment),f=c(),W(j.$$.fragment),w=c(),b=J("p"),b.textContent=q,l=c(),W(M.$$.fragment)},l(n){e=T(n,"P",{"data-svelte-h":!0}),U(e)!=="svelte-zr07mp"&&(e.innerHTML=h),i=m(n),r=T(n,"P",{"data-svelte-h":!0}),U(r)!=="svelte-mjuw51"&&(r.innerHTML=p),u=m(n),X(d.$$.fragment,n),f=m(n),X(j.$$.fragment,n),w=m(n),b=T(n,"P",{"data-svelte-h":!0}),U(b)!=="svelte-thutbg"&&(b.textContent=q),l=m(n),X(M.$$.fragment,n)},m(n,y){s(n,e,y),s(n,i,y),s(n,r,y),s(n,u,y),g(d,n,y),s(n,f,y),g(j,n,y),s(n,w,y),s(n,b,y),s(n,l,y),g(M,n,y),_=!0},p(n,y){const R={};y&2&&(R.$$scope={dirty:y,ctx:n}),d.$set(R)},i(n){_||(Z(d.$$.fragment,n),Z(j.$$.fragment,n),Z(M.$$.fragment,n),_=!0)},o(n){G(d.$$.fragment,n),G(j.$$.fragment,n),G(M.$$.fragment,n),_=!1},d(n){n&&(a(e),a(i),a(r),a(u),a(f),a(w),a(b),a(l)),I(d,n),I(j,n),I(M,n)}}}function Xt($){let e,h,i,r;return e=new mt({props:{id:"torchao",option:"manual",$$slots:{default:[_t]},$$scope:{ctx:$}}}),i=new mt({props:{id:"torchao",option:"automatic",$$slots:{default:[Wt]},$$scope:{ctx:$}}}),{c(){W(e.$$.fragment),h=c(),W(i.$$.fragment)},l(p){X(e.$$.fragment,p),h=m(p),X(i.$$.fragment,p)},m(p,u){g(e,p,u),s(p,h,u),g(i,p,u),r=!0},p(p,u){const d={};u&2&&(d.$$scope={dirty:u,ctx:p}),e.$set(d);const f={};u&2&&(f.$$scope={dirty:u,ctx:p}),i.$set(f)},i(p){r||(Z(e.$$.fragment,p),Z(i.$$.fragment,p),r=!0)},o(p){G(e.$$.fragment,p),G(i.$$.fragment,p),r=!1},d(p){p&&a(h),I(e,p),I(i,p)}}}function gt($){let e,h,i,r,p,u,d,f='<a href="https://github.com/pytorch/ao" rel="nofollow">torchao</a> is a PyTorch architecture optimization library with support for custom high performance data types, quantization, and sparsity. It is composable with native PyTorch features such as <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow">torch.compile</a> for even faster inference and training.',j,w,b="Install torchao with the following command.",q,l,M,_,n="torchao supports many quantization types for different data types (int4, float8, weight only, etc.), but the Transformers integration only currently supports int8 weight quantization and int8 dynamic quantization of weights.",y,R,lt="You can manually choose the quantization types and settings or automatically select the quantization types.",N,Y,S,k,H,z,st='torchao implements <a href="https://pytorch.org/docs/stable/notes/extending.html#subclassing-torch-tensor" rel="nofollow">torch.Tensor subclasses</a> for maximum flexibility in supporting new quantized torch.Tensor formats. <a href="https://huggingface.co/docs/safetensors/en/index" rel="nofollow">Safetensors</a> serialization and deserialization does not work with torchaco.',A,V,nt='To avoid arbitrary user code execution, torchao sets <code>weights_only=True</code> in <a href="https://pytorch.org/docs/stable/generated/torch.load.html" rel="nofollow">torch.load</a> to ensure only tensors are loaded. Any known user functions can be whitelisted with <a href="https://pytorch.org/docs/stable/notes/serialization.html#torch.serialization.add_safe_globals" rel="nofollow">add_safe_globals</a>.',L,C,K,B,D,v,ot='For a better sense of expected performance, view the <a href="https://github.com/pytorch/ao/tree/main/torchao/quantization#benchmarks" rel="nofollow">benchmarks</a> for various models with CUDA and XPU backends.',P,Q,it='Refer to <a href="https://github.com/pytorch/ao/tree/main/torchao/quantization#other-available-quantization-techniques" rel="nofollow">Other Available Quantization Techniques</a> for more examples and documentation.',O,F,tt,E,et;return p=new at({props:{title:"torchao",local:"torchao",headingTag:"h1"}}),l=new x({props:{code:"JTIzJTIwVXBkYXRpbmclMjAlRjAlOUYlQTQlOTclMjBUcmFuc2Zvcm1lcnMlMjB0byUyMHRoZSUyMGxhdGVzdCUyMHZlcnNpb24lMkMlMjBhcyUyMHRoZSUyMGV4YW1wbGUlMjBzY3JpcHQlMjBiZWxvdyUyMHVzZXMlMjB0aGUlMjBuZXclMjBhdXRvJTIwY29tcGlsYXRpb24lMEFwaXAlMjBpbnN0YWxsJTIwLS11cGdyYWRlJTIwdG9yY2glMjB0b3JjaGFvJTIwdHJhbnNmb3JtZXJz",highlighted:`<span class="hljs-comment"># Updating 🤗 Transformers to the latest version, as the example script below uses the new auto compilation</span>
pip install --upgrade torch torchao transformers`,wrap:!1}}),Y=new wt({props:{id:"torchao",options:["manual","automatic"],$$slots:{default:[Xt]},$$scope:{ctx:$}}}),k=new at({props:{title:"Serialization",local:"serialization",headingTag:"h2"}}),C=new x({props:{code:"JTIzJTIwZG9uJ3QlMjBzZXJpYWxpemUlMjBtb2RlbCUyMHdpdGglMjBTYWZldGVuc29ycyUwQW91dHB1dF9kaXIlMjAlM0QlMjAlMjJsbGFtYTMtOGItaW50NHdvLTEyOCUyMiUwQXF1YW50aXplZF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIybGxhbWEzLThiLWludDR3by0xMjglMjIlMkMlMjBzYWZlX3NlcmlhbGl6YXRpb24lM0RGYWxzZSk=",highlighted:`<span class="hljs-comment"># don&#x27;t serialize model with Safetensors</span>
output_dir = <span class="hljs-string">&quot;llama3-8b-int4wo-128&quot;</span>
quantized_model.save_pretrained(<span class="hljs-string">&quot;llama3-8b-int4wo-128&quot;</span>, safe_serialization=<span class="hljs-literal">False</span>)`,wrap:!1}}),B=new at({props:{title:"Resources",local:"resources",headingTag:"h2"}}),F=new Tt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/quantization/torchao.md"}}),{c(){e=J("meta"),h=c(),i=J("p"),r=c(),W(p.$$.fragment),u=c(),d=J("p"),d.innerHTML=f,j=c(),w=J("p"),w.textContent=b,q=c(),W(l.$$.fragment),M=c(),_=J("p"),_.textContent=n,y=c(),R=J("p"),R.textContent=lt,N=c(),W(Y.$$.fragment),S=c(),W(k.$$.fragment),H=c(),z=J("p"),z.innerHTML=st,A=c(),V=J("p"),V.innerHTML=nt,L=c(),W(C.$$.fragment),K=c(),W(B.$$.fragment),D=c(),v=J("p"),v.innerHTML=ot,P=c(),Q=J("p"),Q.innerHTML=it,O=c(),W(F.$$.fragment),tt=c(),E=J("p"),this.h()},l(t){const o=bt("svelte-u9bgzb",document.head);e=T(o,"META",{name:!0,content:!0}),o.forEach(a),h=m(t),i=T(t,"P",{}),rt(i).forEach(a),r=m(t),X(p.$$.fragment,t),u=m(t),d=T(t,"P",{"data-svelte-h":!0}),U(d)!=="svelte-hptymg"&&(d.innerHTML=f),j=m(t),w=T(t,"P",{"data-svelte-h":!0}),U(w)!=="svelte-q2xfio"&&(w.textContent=b),q=m(t),X(l.$$.fragment,t),M=m(t),_=T(t,"P",{"data-svelte-h":!0}),U(_)!=="svelte-19gdk6"&&(_.textContent=n),y=m(t),R=T(t,"P",{"data-svelte-h":!0}),U(R)!=="svelte-hxxsaz"&&(R.textContent=lt),N=m(t),X(Y.$$.fragment,t),S=m(t),X(k.$$.fragment,t),H=m(t),z=T(t,"P",{"data-svelte-h":!0}),U(z)!=="svelte-1ykmr48"&&(z.innerHTML=st),A=m(t),V=T(t,"P",{"data-svelte-h":!0}),U(V)!=="svelte-5ma9bd"&&(V.innerHTML=nt),L=m(t),X(C.$$.fragment,t),K=m(t),X(B.$$.fragment,t),D=m(t),v=T(t,"P",{"data-svelte-h":!0}),U(v)!=="svelte-1b589wj"&&(v.innerHTML=ot),P=m(t),Q=T(t,"P",{"data-svelte-h":!0}),U(Q)!=="svelte-fj0t1q"&&(Q.innerHTML=it),O=m(t),X(F.$$.fragment,t),tt=m(t),E=T(t,"P",{}),rt(E).forEach(a),this.h()},h(){ct(e,"name","hf:doc:metadata"),ct(e,"content",Zt)},m(t,o){Jt(document.head,e),s(t,h,o),s(t,i,o),s(t,r,o),g(p,t,o),s(t,u,o),s(t,d,o),s(t,j,o),s(t,w,o),s(t,q,o),g(l,t,o),s(t,M,o),s(t,_,o),s(t,y,o),s(t,R,o),s(t,N,o),g(Y,t,o),s(t,S,o),g(k,t,o),s(t,H,o),s(t,z,o),s(t,A,o),s(t,V,o),s(t,L,o),g(C,t,o),s(t,K,o),g(B,t,o),s(t,D,o),s(t,v,o),s(t,P,o),s(t,Q,o),s(t,O,o),g(F,t,o),s(t,tt,o),s(t,E,o),et=!0},p(t,[o]){const pt={};o&2&&(pt.$$scope={dirty:o,ctx:t}),Y.$set(pt)},i(t){et||(Z(p.$$.fragment,t),Z(l.$$.fragment,t),Z(Y.$$.fragment,t),Z(k.$$.fragment,t),Z(C.$$.fragment,t),Z(B.$$.fragment,t),Z(F.$$.fragment,t),et=!0)},o(t){G(p.$$.fragment,t),G(l.$$.fragment,t),G(Y.$$.fragment,t),G(k.$$.fragment,t),G(C.$$.fragment,t),G(B.$$.fragment,t),G(F.$$.fragment,t),et=!1},d(t){t&&(a(h),a(i),a(r),a(u),a(d),a(j),a(w),a(q),a(M),a(_),a(y),a(R),a(N),a(S),a(H),a(z),a(A),a(V),a(L),a(K),a(D),a(v),a(P),a(Q),a(O),a(tt),a(E)),a(e),I(p,t),I(l,t),I(Y,t),I(k,t),I(C,t),I(B,t),I(F,t)}}}const Zt='{"title":"torchao","local":"torchao","sections":[{"title":"Serialization","local":"serialization","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Gt($){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends yt{constructor(e){super(),ft(this,e,Gt,gt,dt,{})}}export{zt as component};
