import{s as Ps,o as Ls,n as R}from"../chunks/scheduler.182ea377.js";import{S as Qs,i as Ss,g as i,s as n,r as u,m as zs,H as qs,A as As,h as l,f as m,c as r,j as U,u as h,n as Ys,B as Ks,x as _,k as j,y as o,a as x,v as g,d as M,t as b,w as y}from"../chunks/index.abf12888.js";import{T as Es}from"../chunks/Tip.230e2334.js";import{D as k}from"../chunks/Docstring.93f6f462.js";import{C as S}from"../chunks/CodeBlock.57fe6e13.js";import{E as Q}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Qt}from"../chunks/Heading.16916d63.js";function Os(T){let s,v=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){s=i("p"),s.textContent=v},l(d){s=l(d,"P",{"data-svelte-h":!0}),_(s)!=="svelte-17p1lpg"&&(s.textContent=v)},m(d,a){x(d,s,a)},p:R,d(d){d&&m(s)}}}function ea(T){let s,v="Examples:",d,a,c;return a=new S({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQW1vZGVsJTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0yLTElMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQW1vZGVsJTIwJTNEJTIwbW9kZWwudG8oJTIyY3VkYSUyMiklMEFtb2RlbC5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oYXR0ZW50aW9uX29wJTNETWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DConditionModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = model.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)`,wrap:!1}}),{c(){s=i("p"),s.textContent=v,d=n(),u(a.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-kvfsh7"&&(s.textContent=v),d=r(e),h(a.$$.fragment,e)},m(e,f){x(e,s,f),x(e,d,f),g(a,e,f),c=!0},p:R,i(e){c||(M(a.$$.fragment,e),c=!0)},o(e){b(a.$$.fragment,e),c=!1},d(e){e&&(m(s),m(d)),y(a,e)}}}function ta(T){let s,v=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>. You can also activate the special
<a href="https://huggingface.co/diffusers/installation.html#offline-mode" rel="nofollow">“offline-mode”</a> to use this method in a
firewalled environment.`;return{c(){s=i("p"),s.innerHTML=v},l(d){s=l(d,"P",{"data-svelte-h":!0}),_(s)!=="svelte-19a77yg"&&(s.innerHTML=v)},m(d,a){x(d,s,a)},p:R,d(d){d&&m(s)}}}function oa(T){let s,v="Example:",d,a,c;return a=new S({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),{c(){s=i("p"),s.textContent=v,d=n(),u(a.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-11lpom8"&&(s.textContent=v),d=r(e),h(a.$$.fragment,e)},m(e,f){x(e,s,f),x(e,d,f),g(a,e,f),c=!0},p:R,i(e){c||(M(a.$$.fragment,e),c=!0)},o(e){b(a.$$.fragment,e),c=!1},d(e){e&&(m(s),m(d)),y(a,e)}}}function sa(T){let s,v="If you get the error message below, you need to finetune the weights for your downstream task:",d,a,c;return a=new S({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTIwYmVjYXVzZSUyMHRoZSUyMHNoYXBlcyUyMGRpZCUyMG5vdCUyMG1hdGNoJTNBJTBBLSUyMGNvbnZfaW4ud2VpZ2h0JTNBJTIwZm91bmQlMjBzaGFwZSUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwNCUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwY2hlY2twb2ludCUyMGFuZCUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwOSUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwbW9kZWwlMjBpbnN0YW50aWF0ZWQlMEFZb3UlMjBzaG91bGQlMjBwcm9iYWJseSUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bi1zdHJlYW0lMjB0YXNrJTIwdG8lMjBiZSUyMGFibGUlMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2Uu",highlighted:`Some weights of UNet2DConditionModel were not initialized from the model checkpoint at runwayml/stable-diffusion-v1-5 and are newly initialized because the shapes did not match:
- conv_in.weight: found shape torch.Size([320, 4, 3, 3]) <span class="hljs-keyword">in</span> the checkpoint and torch.Size([320, 9, 3, 3]) <span class="hljs-keyword">in</span> the model instantiated
You should probably TRAIN this model on a down-stream task to be able to use it <span class="hljs-keyword">for</span> predictions and inference.`,wrap:!1}}),{c(){s=i("p"),s.textContent=v,d=n(),u(a.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-xueb0m"&&(s.textContent=v),d=r(e),h(a.$$.fragment,e)},m(e,f){x(e,s,f),x(e,d,f),g(a,e,f),c=!0},p:R,i(e){c||(M(a.$$.fragment,e),c=!0)},o(e){b(a.$$.fragment,e),c=!1},d(e){e&&(m(s),m(d)),y(a,e)}}}function aa(T){let s,v="Example:",d,a,c;return a=new S({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyKSUwQXVuZXQubnVtX3BhcmFtZXRlcnMob25seV90cmFpbmFibGUlM0RUcnVlKSUwQTg1OTUyMDk2NA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
unet = UNet2DConditionModel.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)
unet.num_parameters(only_trainable=<span class="hljs-literal">True</span>)
<span class="hljs-number">859520964</span>`,wrap:!1}}),{c(){s=i("p"),s.textContent=v,d=n(),u(a.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-11lpom8"&&(s.textContent=v),d=r(e),h(a.$$.fragment,e)},m(e,f){x(e,s,f),x(e,d,f),g(a,e,f),c=!0},p:R,i(e){c||(M(a.$$.fragment,e),c=!0)},o(e){b(a.$$.fragment,e),c=!1},d(e){e&&(m(s),m(d)),y(a,e)}}}function na(T){let s,v="Examples:",d,a,c;return a=new S({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4VU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQSUyMyUyME1vZGVsJTIwd2FzJTIwc2F2ZWQlMjB1c2luZyUyMCpzYXZlX3ByZXRyYWluZWQoJy4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYnKSolMjAoZm9yJTIwZXhhbXBsZSUyMHB1cnBvc2VzJTJDJTIwbm90JTIwcnVubmFibGUpLiUwQW1vZGVsJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)* (for example purposes, not runnable).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)`,wrap:!1}}),{c(){s=i("p"),s.textContent=v,d=n(),u(a.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-kvfsh7"&&(s.textContent=v),d=r(e),h(a.$$.fragment,e)},m(e,f){x(e,s,f),x(e,d,f),g(a,e,f),c=!0},p:R,i(e){c||(M(a.$$.fragment,e),c=!0)},o(e){b(a.$$.fragment,e),c=!1},d(e){e&&(m(s),m(d)),y(a,e)}}}function ra(T){let s,v="If you get the error message below, you need to finetune the weights for your downstream task:",d,a,c;return a=new S({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTIwYmVjYXVzZSUyMHRoZSUyMHNoYXBlcyUyMGRpZCUyMG5vdCUyMG1hdGNoJTNBJTBBLSUyMGNvbnZfaW4ud2VpZ2h0JTNBJTIwZm91bmQlMjBzaGFwZSUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwNCUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwY2hlY2twb2ludCUyMGFuZCUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwOSUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwbW9kZWwlMjBpbnN0YW50aWF0ZWQlMEFZb3UlMjBzaG91bGQlMjBwcm9iYWJseSUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bi1zdHJlYW0lMjB0YXNrJTIwdG8lMjBiZSUyMGFibGUlMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2Uu",highlighted:`Some weights of UNet2DConditionModel were not initialized from the model checkpoint at runwayml/stable-diffusion-v1-5 and are newly initialized because the shapes did not match:
- conv_in.weight: found shape torch.Size([320, 4, 3, 3]) <span class="hljs-keyword">in</span> the checkpoint and torch.Size([320, 9, 3, 3]) <span class="hljs-keyword">in</span> the model instantiated
You should probably TRAIN this model on a down-stream task to be able to use it <span class="hljs-keyword">for</span> predictions and inference.`,wrap:!1}}),{c(){s=i("p"),s.textContent=v,d=n(),u(a.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-xueb0m"&&(s.textContent=v),d=r(e),h(a.$$.fragment,e)},m(e,f){x(e,s,f),x(e,d,f),g(a,e,f),c=!0},p:R,i(e){c||(M(a.$$.fragment,e),c=!0)},o(e){b(a.$$.fragment,e),c=!1},d(e){e&&(m(s),m(d)),y(a,e)}}}function ia(T){let s,v="Examples:",d,a,c;return a=new S({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMGxvYWQlMjBtb2RlbCUwQW1vZGVsJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBtb2RlbCUyMHBhcmFtZXRlcnMlMjB3aWxsJTIwYmUlMjBpbiUyMGZwMzIlMjBwcmVjaXNpb24lMkMlMjB0byUyMGNhc3QlMjB0aGVzZSUyMHRvJTIwYmZsb2F0MTYlMjBwcmVjaXNpb24lMEFwYXJhbXMlMjAlM0QlMjBtb2RlbC50b19iZjE2KHBhcmFtcyklMEElMjMlMjBJZiUyMHlvdSUyMGRvbid0JTIwd2FudCUyMHRvJTIwY2FzdCUyMGNlcnRhaW4lMjBwYXJhbWV0ZXJzJTIwKGZvciUyMGV4YW1wbGUlMjBsYXllciUyMG5vcm0lMjBiaWFzJTIwYW5kJTIwc2NhbGUpJTBBJTIzJTIwdGhlbiUyMHBhc3MlMjB0aGUlMjBtYXNrJTIwYXMlMjBmb2xsb3dzJTBBZnJvbSUyMGZsYXglMjBpbXBvcnQlMjB0cmF2ZXJzZV91dGlsJTBBJTBBbW9kZWwlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4VU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQWZsYXRfcGFyYW1zJTIwJTNEJTIwdHJhdmVyc2VfdXRpbC5mbGF0dGVuX2RpY3QocGFyYW1zKSUwQW1hc2slMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjBwYXRoJTNBJTIwKHBhdGglNUItMiU1RCUyMCElM0QlMjAoJTIyTGF5ZXJOb3JtJTIyJTJDJTIwJTIyYmlhcyUyMiklMjBhbmQlMjBwYXRoJTVCLTIlM0ElNUQlMjAhJTNEJTIwKCUyMkxheWVyTm9ybSUyMiUyQyUyMCUyMnNjYWxlJTIyKSklMEElMjAlMjAlMjAlMjBmb3IlMjBwYXRoJTIwaW4lMjBmbGF0X3BhcmFtcyUwQSU3RCUwQW1hc2slMjAlM0QlMjB0cmF2ZXJzZV91dGlsLnVuZmxhdHRlbl9kaWN0KG1hc2spJTBBcGFyYW1zJTIwJTNEJTIwbW9kZWwudG9fYmYxNihwYXJhbXMlMkMlMjBtYXNrKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the model parameters will be in fp32 precision, to cast these to bfloat16 precision</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_bf16(params)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you don&#x27;t want to cast certain parameters (for example layer norm bias and scale)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># then pass the mask as follows</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax <span class="hljs-keyword">import</span> traverse_util

<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_params = traverse_util.flatten_dict(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = {
<span class="hljs-meta">... </span>    path: (path[-<span class="hljs-number">2</span>] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;bias&quot;</span>) <span class="hljs-keyword">and</span> path[-<span class="hljs-number">2</span>:] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;scale&quot;</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> flat_params
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = traverse_util.unflatten_dict(mask)
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_bf16(params, mask)`,wrap:!1}}),{c(){s=i("p"),s.textContent=v,d=n(),u(a.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-kvfsh7"&&(s.textContent=v),d=r(e),h(a.$$.fragment,e)},m(e,f){x(e,s,f),x(e,d,f),g(a,e,f),c=!0},p:R,i(e){c||(M(a.$$.fragment,e),c=!0)},o(e){b(a.$$.fragment,e),c=!1},d(e){e&&(m(s),m(d)),y(a,e)}}}function la(T){let s,v="Examples:",d,a,c;return a=new S({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMGxvYWQlMjBtb2RlbCUwQW1vZGVsJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBtb2RlbCUyMHBhcmFtcyUyMHdpbGwlMjBiZSUyMGluJTIwZnAzMiUyQyUyMHRvJTIwY2FzdCUyMHRoZXNlJTIwdG8lMjBmbG9hdDE2JTBBcGFyYW1zJTIwJTNEJTIwbW9kZWwudG9fZnAxNihwYXJhbXMpJTBBJTIzJTIwSWYlMjB5b3UlMjB3YW50JTIwZG9uJ3QlMjB3YW50JTIwdG8lMjBjYXN0JTIwY2VydGFpbiUyMHBhcmFtZXRlcnMlMjAoZm9yJTIwZXhhbXBsZSUyMGxheWVyJTIwbm9ybSUyMGJpYXMlMjBhbmQlMjBzY2FsZSklMEElMjMlMjB0aGVuJTIwcGFzcyUyMHRoZSUyMG1hc2slMjBhcyUyMGZvbGxvd3MlMEFmcm9tJTIwZmxheCUyMGltcG9ydCUyMHRyYXZlcnNlX3V0aWwlMEElMEFtb2RlbCUyQyUyMHBhcmFtcyUyMCUzRCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBZmxhdF9wYXJhbXMlMjAlM0QlMjB0cmF2ZXJzZV91dGlsLmZsYXR0ZW5fZGljdChwYXJhbXMpJTBBbWFzayUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMHBhdGglM0ElMjAocGF0aCU1Qi0yJTVEJTIwISUzRCUyMCglMjJMYXllck5vcm0lMjIlMkMlMjAlMjJiaWFzJTIyKSUyMGFuZCUyMHBhdGglNUItMiUzQSU1RCUyMCElM0QlMjAoJTIyTGF5ZXJOb3JtJTIyJTJDJTIwJTIyc2NhbGUlMjIpKSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhdGglMjBpbiUyMGZsYXRfcGFyYW1zJTBBJTdEJTBBbWFzayUyMCUzRCUyMHRyYXZlcnNlX3V0aWwudW5mbGF0dGVuX2RpY3QobWFzayklMEFwYXJhbXMlMjAlM0QlMjBtb2RlbC50b19mcDE2KHBhcmFtcyUyQyUyMG1hc2sp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the model params will be in fp32, to cast these to float16</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_fp16(params)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you want don&#x27;t want to cast certain parameters (for example layer norm bias and scale)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># then pass the mask as follows</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax <span class="hljs-keyword">import</span> traverse_util

<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_params = traverse_util.flatten_dict(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = {
<span class="hljs-meta">... </span>    path: (path[-<span class="hljs-number">2</span>] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;bias&quot;</span>) <span class="hljs-keyword">and</span> path[-<span class="hljs-number">2</span>:] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;scale&quot;</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> flat_params
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = traverse_util.unflatten_dict(mask)
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_fp16(params, mask)`,wrap:!1}}),{c(){s=i("p"),s.textContent=v,d=n(),u(a.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-kvfsh7"&&(s.textContent=v),d=r(e),h(a.$$.fragment,e)},m(e,f){x(e,s,f),x(e,d,f),g(a,e,f),c=!0},p:R,i(e){c||(M(a.$$.fragment,e),c=!0)},o(e){b(a.$$.fragment,e),c=!1},d(e){e&&(m(s),m(d)),y(a,e)}}}function da(T){let s,v="Examples:",d,a,c;return a=new S({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTBBbW9kZWwlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4VU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMHRoZSUyMG1vZGVsJTIwcGFyYW1zJTIwd2lsbCUyMGJlJTIwaW4lMjBmcDMyJTJDJTIwdG8lMjBpbGx1c3RyYXRlJTIwdGhlJTIwdXNlJTIwb2YlMjB0aGlzJTIwbWV0aG9kJTJDJTBBJTIzJTIwd2UnbGwlMjBmaXJzdCUyMGNhc3QlMjB0byUyMGZwMTYlMjBhbmQlMjBiYWNrJTIwdG8lMjBmcDMyJTBBcGFyYW1zJTIwJTNEJTIwbW9kZWwudG9fZjE2KHBhcmFtcyklMEElMjMlMjBub3clMjBjYXN0JTIwYmFjayUyMHRvJTIwZnAzMiUwQXBhcmFtcyUyMCUzRCUyMG1vZGVsLnRvX2ZwMzIocGFyYW1zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the model params will be in fp32, to illustrate the use of this method,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># we&#x27;ll first cast to fp16 and back to fp32</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_f16(params)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now cast back to fp32</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_fp32(params)`,wrap:!1}}),{c(){s=i("p"),s.textContent=v,d=n(),u(a.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-kvfsh7"&&(s.textContent=v),d=r(e),h(a.$$.fragment,e)},m(e,f){x(e,s,f),x(e,d,f),g(a,e,f),c=!0},p:R,i(e){c||(M(a.$$.fragment,e),c=!0)},o(e){b(a.$$.fragment,e),c=!1},d(e){e&&(m(s),m(d)),y(a,e)}}}function ma(T){let s,v="Examples:",d,a,c;return a=new S({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMHlvdXIlMjBuYW1lc3BhY2UlMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC11bmV0JTIyLiUwQXVuZXQucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLXVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtdW5ldCUyMi4lMEF1bmV0LnB1c2hfdG9faHViKCUyMnlvdXItb3JnJTJGbXktZmluZXR1bmVkLXVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to your namespace with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;my-finetuned-unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to an organization with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;your-org/my-finetuned-unet&quot;</span>)`,wrap:!1}}),{c(){s=i("p"),s.textContent=v,d=n(),u(a.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-kvfsh7"&&(s.textContent=v),d=r(e),h(a.$$.fragment,e)},m(e,f){x(e,s,f),x(e,d,f),g(a,e,f),c=!0},p:R,i(e){c||(M(a.$$.fragment,e),c=!0)},o(e){b(a.$$.fragment,e),c=!1},d(e){e&&(m(s),m(d)),y(a,e)}}}function ca(T){let s,v,d,a,c,e,f,St,Wt,Ds='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>p</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>x</mi><mrow><mi>t</mi><mo>−</mo><mn>1</mn></mrow></msub><mi mathvariant="normal">∣</mi><msub><mi>x</mi><mi>t</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">p_{\\theta}(x_{t-1}|x_{t})</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2083em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',Bt,Vt,ve,is='All models are built from the base <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a> class which is a <a href="https://pytorch.org/docs/stable/generated/torch.nn.Module.html" rel="nofollow"><code>torch.nn.Module</code></a> providing basic functionality for saving and loading models, locally and from the Hugging Face Hub.',Rt,xe,Ht,w,we,qt,qe,ls="Base class for all models.",At,Ae,ds=`<a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a> takes care of storing the model configuration and provides methods for loading, downloading and
saving models.`,Kt,Ke,ms='<li><strong>config_name</strong> (<code>str</code>) — Filename to save a model to when calling <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.</li>',Ot,X,$e,eo,Oe,cs="Gets the current list of active adapters of the model.",to,et,ps=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,oo,N,Te,so,tt,fs=`Adds a new adapter to the current model for training. If no adapter name is passed, a default name is assigned
to the adapter to follow the convention of the PEFT library.`,ao,ot,us=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them in the PEFT
<a href="https://huggingface.co/docs/peft" rel="nofollow">documentation</a>.`,no,z,Ue,ro,st,hs="Disable all adapters attached to the model and fallback to inference with the base model only.",io,at,gs=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,lo,te,Je,mo,nt,Ms=`Deactivates gradient checkpointing for the current model (may be referred to as <em>activation checkpointing</em> or
<em>checkpoint activations</em> in other frameworks).`,co,oe,je,po,rt,bs='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',fo,Y,ke,uo,it,ys=`Enable adapters that are attached to the model. The model will use <code>self.active_adapters()</code> to retrieve the
list of adapters to enable.`,ho,lt,_s=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,go,se,Ze,Mo,dt,vs=`Activates gradient checkpointing for the current model (may be referred to as <em>activation checkpointing</em> or
<em>checkpoint activations</em> in other frameworks).`,bo,F,Ce,yo,mt,xs='Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',_o,ct,ws=`When this option is enabled, you should observe lower GPU memory usage and a potential speed up during
inference. Speed up during training is not guaranteed.`,vo,ae,xo,ne,wo,C,Ge,$o,pt,$s="Instantiate a pretrained PyTorch model from a pretrained model configuration.",To,ft,Ts=`The model is set in evaluation mode - <code>model.eval()</code> - by default, and dropout modules are deactivated. To
train the model, set it back in training mode with <code>model.train()</code>.`,Uo,re,Jo,ie,jo,le,ko,E,Fe,Zo,ut,Us="Get number of (trainable or non-embedding) parameters in the module.",Co,de,Go,me,Ie,Fo,ht,Js=`Save a model and its configuration file to a directory so that it can be reloaded using the
<a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> class method.`,Io,D,We,Wo,gt,js="Sets a specific adapter by forcing the model to only use that adapter and disables the other adapters.",Bo,Mt,ks=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Xt,Be,Nt,J,Ve,Vo,bt,Zs="Base class for all Flax models.",Ro,yt,Cs=`<a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin">FlaxModelMixin</a> takes care of storing the model configuration and provides methods for loading, downloading and
saving models.`,Ho,_t,Gs='<li><strong>config_name</strong> (<code>str</code>) — Filename to save a model to when calling <a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.save_pretrained">save_pretrained()</a>.</li>',Xo,W,Re,No,vt,Fs="Instantiate a pretrained Flax model from a pretrained model configuration.",zo,ce,Yo,pe,Eo,fe,He,Do,xt,Is=`Save a model and its configuration file to a directory so that it can be reloaded using the
<a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.from_pretrained">from_pretrained()</a> class method.`,Po,B,Xe,Lo,wt,Ws=`Cast the floating-point <code>params</code> to <code>jax.numpy.bfloat16</code>. This returns a new <code>params</code> tree and does not cast
the <code>params</code> in place.`,Qo,$t,Bs=`This method can be used on a TPU to explicitly convert the model parameters to bfloat16 precision to do full
half-precision training or to save weights in bfloat16 for inference in order to save memory and improve speed.`,So,ue,qo,V,Ne,Ao,Tt,Vs=`Cast the floating-point <code>params</code> to <code>jax.numpy.float16</code>. This returns a new <code>params</code> tree and does not cast the
<code>params</code> in place.`,Ko,Ut,Rs=`This method can be used on a GPU to explicitly convert the model parameters to float16 precision to do full
half-precision training or to save weights in float16 for inference in order to save memory and improve speed.`,Oo,he,es,P,ze,ts,Jt,Hs=`Cast the floating-point <code>params</code> to <code>jax.numpy.float32</code>. This method can be used to explicitly convert the
model parameters to fp32 precision. This returns a new <code>params</code> tree and does not cast the <code>params</code> in place.`,os,ge,zt,Ye,Yt,H,Ee,ss,jt,Xs="A Mixin to push a model, scheduler, or pipeline to the Hugging Face Hub.",as,L,De,ns,kt,Ns="Upload model, scheduler, or pipeline files to the 🤗 Hugging Face Hub.",rs,Me,Et,It,Dt;return c=new Qt({props:{title:"Models",local:"models",headingTag:"h1"}}),xe=new Qt({props:{title:"ModelMixin",local:"diffusers.ModelMixin",headingTag:"h2"}}),we=new k({props:{name:"class diffusers.ModelMixin",anchor:"diffusers.ModelMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L186"}}),$e=new k({props:{name:"active_adapters",anchor:"diffusers.ModelMixin.active_adapters",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L435"}}),Te=new k({props:{name:"add_adapter",anchor:"diffusers.ModelMixin.add_adapter",parameters:[{name:"adapter_config",val:""},{name:"adapter_name",val:": str = 'default'"}],parametersDescription:[{anchor:"diffusers.ModelMixin.add_adapter.adapter_config",description:`<strong>adapter_config</strong> (<code>[~peft.PeftConfig]</code>) &#x2014;
The configuration of the adapter to add; supported adapters are non-prefix tuning and adaption prompt
methods.`,name:"adapter_config"},{anchor:"diffusers.ModelMixin.add_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The name of the adapter to add. If no name is passed, a default name is assigned to the adapter.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L306"}}),Ue=new k({props:{name:"disable_adapters",anchor:"diffusers.ModelMixin.disable_adapters",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L390"}}),Je=new k({props:{name:"disable_gradient_checkpointing",anchor:"diffusers.ModelMixin.disable_gradient_checkpointing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L239"}}),je=new k({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.ModelMixin.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L300"}}),ke=new k({props:{name:"enable_adapters",anchor:"diffusers.ModelMixin.enable_adapters",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L412"}}),Ze=new k({props:{name:"enable_gradient_checkpointing",anchor:"diffusers.ModelMixin.enable_gradient_checkpointing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L230"}}),Ce=new k({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.ModelMixin.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.ModelMixin.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L264"}}),ae=new Es({props:{warning:!0,$$slots:{default:[Os]},$$scope:{ctx:T}}}),ne=new Q({props:{anchor:"diffusers.ModelMixin.enable_xformers_memory_efficient_attention.example",$$slots:{default:[ea]},$$scope:{ctx:T}}}),Ge=new k({props:{name:"from_pretrained",anchor:"diffusers.ModelMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike, NoneType]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.ModelMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>google/ddpm-celebahq-256</code>) of a pretrained model hosted on
the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.ModelMixin.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.ModelMixin.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.ModelMixin.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.ModelMixin.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.ModelMixin.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.ModelMixin.from_pretrained.output_loading_info",description:`<strong>output_loading_info</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info"},{anchor:"diffusers.ModelMixin.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only(bool,"},{anchor:"diffusers.ModelMixin.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.ModelMixin.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.ModelMixin.from_pretrained.from_flax",description:`<strong>from_flax</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a Flax checkpoint save file.`,name:"from_flax"},{anchor:"diffusers.ModelMixin.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.ModelMixin.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.ModelMixin.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be defined for each
parameter/buffer name; once a given module name is inside, every submodule of it will be sent to the
same device.</p>
<p>Set <code>device_map=&quot;auto&quot;</code> to have &#x1F917; Accelerate automatically compute the most optimized <code>device_map</code>. For
more information about each option see <a href="https://hf.co/docs/accelerate/main/en/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">designing a device
map</a>.`,name:"device_map"},{anchor:"diffusers.ModelMixin.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.ModelMixin.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if <code>device_map</code> contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.ModelMixin.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.ModelMixin.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.ModelMixin.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified <code>variant</code> filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.ModelMixin.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the <code>safetensors</code> weights are downloaded if they&#x2019;re available <strong>and</strong> if the
<code>safetensors</code> library is installed. If set to <code>True</code>, the model is forcibly loaded from <code>safetensors</code>
weights. If set to <code>False</code>, <code>safetensors</code> weights are not loaded.`,name:"use_safetensors"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L536"}}),re=new Es({props:{$$slots:{default:[ta]},$$scope:{ctx:T}}}),ie=new Q({props:{anchor:"diffusers.ModelMixin.from_pretrained.example",$$slots:{default:[oa]},$$scope:{ctx:T}}}),le=new Q({props:{anchor:"diffusers.ModelMixin.from_pretrained.example-2",$$slots:{default:[sa]},$$scope:{ctx:T}}}),Fe=new k({props:{name:"num_parameters",anchor:"diffusers.ModelMixin.num_parameters",parameters:[{name:"only_trainable",val:": bool = False"},{name:"exclude_embeddings",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.ModelMixin.num_parameters.only_trainable",description:`<strong>only_trainable</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return only the number of trainable parameters.`,name:"only_trainable"},{anchor:"diffusers.ModelMixin.num_parameters.exclude_embeddings",description:`<strong>exclude_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return only the number of non-embedding parameters.`,name:"exclude_embeddings"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L1036",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The number of parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>int</code></p>
`}}),de=new Q({props:{anchor:"diffusers.ModelMixin.num_parameters.example",$$slots:{default:[aa]},$$scope:{ctx:T}}}),Ie=new k({props:{name:"save_pretrained",anchor:"diffusers.ModelMixin.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"is_main_process",val:": bool = True"},{name:"save_function",val:": typing.Optional[typing.Callable] = None"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.ModelMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a model and its configuration file to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.ModelMixin.save_pretrained.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.ModelMixin.save_pretrained.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.ModelMixin.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.ModelMixin.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.ModelMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face Hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.ModelMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L453"}}),We=new k({props:{name:"set_adapter",anchor:"diffusers.ModelMixin.set_adapter",parameters:[{name:"adapter_name",val:": typing.Union[str, typing.List[str]]"}],parametersDescription:[{anchor:"diffusers.ModelMixin.set_adapter.adapter_name",description:`<strong>adapter_name</strong> (Union[str, List[str]])) &#x2014;
The list of adapters to set or the adapter name in case of single adapter.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L341"}}),Be=new Qt({props:{title:"FlaxModelMixin",local:"diffusers.FlaxModelMixin",headingTag:"h2"}}),Ve=new k({props:{name:"class diffusers.FlaxModelMixin",anchor:"diffusers.FlaxModelMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L50"}}),Re=new k({props:{name:"from_pretrained",anchor:"diffusers.FlaxModelMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike]"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>runwayml/stable-diffusion-v1-5</code>) of a pretrained model
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
using <a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified, all the computation will be performed with the given <code>dtype</code>.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>This only specifies the dtype of the <em>computation</em> and does not influence the dtype of model
parameters.</p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.to_fp16">to_fp16()</a> and
<a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.to_bf16">to_bf16()</a>.</p>

					</div>`,name:"dtype"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.model_args",description:`<strong>model_args</strong> (sequence of positional arguments, <em>optional</em>) &#x2014;
All remaining positional arguments are passed to the underlying model&#x2019;s <code>__init__</code> method.`,name:"model_args"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only(bool,"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file.`,name:"from_pt"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it is loaded) and initiate the model (for
example, <code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>kwargs</code> are directly passed to the underlying
model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have already been
done).</li>
<li>If a configuration is not provided, <code>kwargs</code> are first passed to the configuration class
initialization function <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin.from_config">from_config()</a>. Each key of the <code>kwargs</code> that corresponds
to a configuration attribute is used to override said attribute with the supplied <code>kwargs</code> value.
Remaining keys that do not correspond to any configuration attribute are passed to the underlying
model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L203"}}),ce=new Q({props:{anchor:"diffusers.FlaxModelMixin.from_pretrained.example",$$slots:{default:[na]},$$scope:{ctx:T}}}),pe=new Q({props:{anchor:"diffusers.FlaxModelMixin.from_pretrained.example-2",$$slots:{default:[ra]},$$scope:{ctx:T}}}),He=new k({props:{name:"save_pretrained",anchor:"diffusers.FlaxModelMixin.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"is_main_process",val:": bool = True"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a model and its configuration file to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L502"}}),Xe=new k({props:{name:"to_bf16",anchor:"diffusers.FlaxModelMixin.to_bf16",parameters:[{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"mask",val:": typing.Any = None"}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.to_bf16.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.to_bf16.mask",description:`<strong>mask</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> with same structure as the <code>params</code> tree. The leaves should be booleans. It should be <code>True</code>
for params you want to cast, and <code>False</code> for those you want to skip.`,name:"mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L95"}}),ue=new Q({props:{anchor:"diffusers.FlaxModelMixin.to_bf16.example",$$slots:{default:[ia]},$$scope:{ctx:T}}}),Ne=new k({props:{name:"to_fp16",anchor:"diffusers.FlaxModelMixin.to_fp16",parameters:[{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"mask",val:": typing.Any = None"}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.to_fp16.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.to_fp16.mask",description:`<strong>mask</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> with same structure as the <code>params</code> tree. The leaves should be booleans. It should be <code>True</code>
for params you want to cast, and <code>False</code> for those you want to skip.`,name:"mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L161"}}),he=new Q({props:{anchor:"diffusers.FlaxModelMixin.to_fp16.example",$$slots:{default:[la]},$$scope:{ctx:T}}}),ze=new k({props:{name:"to_fp32",anchor:"diffusers.FlaxModelMixin.to_fp32",parameters:[{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"mask",val:": typing.Any = None"}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.to_fp32.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.to_fp32.mask",description:`<strong>mask</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> with same structure as the <code>params</code> tree. The leaves should be booleans. It should be <code>True</code>
for params you want to cast, and <code>False</code> for those you want to skip.`,name:"mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L134"}}),ge=new Q({props:{anchor:"diffusers.FlaxModelMixin.to_fp32.example",$$slots:{default:[da]},$$scope:{ctx:T}}}),Ye=new Qt({props:{title:"PushToHubMixin",local:"diffusers.utils.PushToHubMixin",headingTag:"h2"}}),Ee=new k({props:{name:"class diffusers.utils.PushToHubMixin",anchor:"diffusers.utils.PushToHubMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L361"}}),De=new k({props:{name:"push_to_hub",anchor:"diffusers.utils.PushToHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your model, scheduler, or pipeline files to. It should
contain your organization name when pushing to an organization. <code>repo_id</code> can also be a path to a local
directory.`,name:"repo_id"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Default to <code>&quot;Upload {object}&quot;</code>.`,name:"commit_message"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. The token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights to the <code>safetensors</code> format.`,name:"safe_serialization"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L390"}}),Me=new Q({props:{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.example",$$slots:{default:[ma]},$$scope:{ctx:T}}}),{c(){s=i("meta"),v=n(),d=i("p"),a=n(),u(c.$$.fragment),e=n(),f=i("p"),St=zs("🤗 Diffusers provides pretrained models for popular algorithms and modules to create custom diffusion systems. The primary function of models is to denoise an input sample as modeled by the distribution "),Wt=new qs(!1),Bt=zs("."),Vt=n(),ve=i("p"),ve.innerHTML=is,Rt=n(),u(xe.$$.fragment),Ht=n(),w=i("div"),u(we.$$.fragment),qt=n(),qe=i("p"),qe.textContent=ls,At=n(),Ae=i("p"),Ae.innerHTML=ds,Kt=n(),Ke=i("ul"),Ke.innerHTML=ms,Ot=n(),X=i("div"),u($e.$$.fragment),eo=n(),Oe=i("p"),Oe.textContent=cs,to=n(),et=i("p"),et.innerHTML=ps,oo=n(),N=i("div"),u(Te.$$.fragment),so=n(),tt=i("p"),tt.textContent=fs,ao=n(),ot=i("p"),ot.innerHTML=us,no=n(),z=i("div"),u(Ue.$$.fragment),ro=n(),st=i("p"),st.textContent=hs,io=n(),at=i("p"),at.innerHTML=gs,lo=n(),te=i("div"),u(Je.$$.fragment),mo=n(),nt=i("p"),nt.innerHTML=Ms,co=n(),oe=i("div"),u(je.$$.fragment),po=n(),rt=i("p"),rt.innerHTML=bs,fo=n(),Y=i("div"),u(ke.$$.fragment),uo=n(),it=i("p"),it.innerHTML=ys,ho=n(),lt=i("p"),lt.innerHTML=_s,go=n(),se=i("div"),u(Ze.$$.fragment),Mo=n(),dt=i("p"),dt.innerHTML=vs,bo=n(),F=i("div"),u(Ce.$$.fragment),yo=n(),mt=i("p"),mt.innerHTML=xs,_o=n(),ct=i("p"),ct.textContent=ws,vo=n(),u(ae.$$.fragment),xo=n(),u(ne.$$.fragment),wo=n(),C=i("div"),u(Ge.$$.fragment),$o=n(),pt=i("p"),pt.textContent=$s,To=n(),ft=i("p"),ft.innerHTML=Ts,Uo=n(),u(re.$$.fragment),Jo=n(),u(ie.$$.fragment),jo=n(),u(le.$$.fragment),ko=n(),E=i("div"),u(Fe.$$.fragment),Zo=n(),ut=i("p"),ut.textContent=Us,Co=n(),u(de.$$.fragment),Go=n(),me=i("div"),u(Ie.$$.fragment),Fo=n(),ht=i("p"),ht.innerHTML=Js,Io=n(),D=i("div"),u(We.$$.fragment),Wo=n(),gt=i("p"),gt.textContent=js,Bo=n(),Mt=i("p"),Mt.innerHTML=ks,Xt=n(),u(Be.$$.fragment),Nt=n(),J=i("div"),u(Ve.$$.fragment),Vo=n(),bt=i("p"),bt.textContent=Zs,Ro=n(),yt=i("p"),yt.innerHTML=Cs,Ho=n(),_t=i("ul"),_t.innerHTML=Gs,Xo=n(),W=i("div"),u(Re.$$.fragment),No=n(),vt=i("p"),vt.textContent=Fs,zo=n(),u(ce.$$.fragment),Yo=n(),u(pe.$$.fragment),Eo=n(),fe=i("div"),u(He.$$.fragment),Do=n(),xt=i("p"),xt.innerHTML=Is,Po=n(),B=i("div"),u(Xe.$$.fragment),Lo=n(),wt=i("p"),wt.innerHTML=Ws,Qo=n(),$t=i("p"),$t.textContent=Bs,So=n(),u(ue.$$.fragment),qo=n(),V=i("div"),u(Ne.$$.fragment),Ao=n(),Tt=i("p"),Tt.innerHTML=Vs,Ko=n(),Ut=i("p"),Ut.textContent=Rs,Oo=n(),u(he.$$.fragment),es=n(),P=i("div"),u(ze.$$.fragment),ts=n(),Jt=i("p"),Jt.innerHTML=Hs,os=n(),u(ge.$$.fragment),zt=n(),u(Ye.$$.fragment),Yt=n(),H=i("div"),u(Ee.$$.fragment),ss=n(),jt=i("p"),jt.textContent=Xs,as=n(),L=i("div"),u(De.$$.fragment),ns=n(),kt=i("p"),kt.textContent=Ns,rs=n(),u(Me.$$.fragment),Et=n(),It=i("p"),this.h()},l(t){const p=As("svelte-u9bgzb",document.head);s=l(p,"META",{name:!0,content:!0}),p.forEach(m),v=r(t),d=l(t,"P",{}),U(d).forEach(m),a=r(t),h(c.$$.fragment,t),e=r(t),f=l(t,"P",{});var Pe=U(f);St=Ys(Pe,"🤗 Diffusers provides pretrained models for popular algorithms and modules to create custom diffusion systems. The primary function of models is to denoise an input sample as modeled by the distribution "),Wt=Ks(Pe,!1),Bt=Ys(Pe,"."),Pe.forEach(m),Vt=r(t),ve=l(t,"P",{"data-svelte-h":!0}),_(ve)!=="svelte-1elbdrk"&&(ve.innerHTML=is),Rt=r(t),h(xe.$$.fragment,t),Ht=r(t),w=l(t,"DIV",{class:!0});var $=U(w);h(we.$$.fragment,$),qt=r($),qe=l($,"P",{"data-svelte-h":!0}),_(qe)!=="svelte-12nk4t7"&&(qe.textContent=ls),At=r($),Ae=l($,"P",{"data-svelte-h":!0}),_(Ae)!=="svelte-ku6myw"&&(Ae.innerHTML=ds),Kt=r($),Ke=l($,"UL",{"data-svelte-h":!0}),_(Ke)!=="svelte-kvpw1l"&&(Ke.innerHTML=ms),Ot=r($),X=l($,"DIV",{class:!0});var q=U(X);h($e.$$.fragment,q),eo=r(q),Oe=l(q,"P",{"data-svelte-h":!0}),_(Oe)!=="svelte-1i9yvzx"&&(Oe.textContent=cs),to=r(q),et=l(q,"P",{"data-svelte-h":!0}),_(et)!=="svelte-esrgfk"&&(et.innerHTML=ps),q.forEach(m),oo=r($),N=l($,"DIV",{class:!0});var A=U(N);h(Te.$$.fragment,A),so=r(A),tt=l(A,"P",{"data-svelte-h":!0}),_(tt)!=="svelte-ayg1h"&&(tt.textContent=fs),ao=r(A),ot=l(A,"P",{"data-svelte-h":!0}),_(ot)!=="svelte-m719pe"&&(ot.innerHTML=us),A.forEach(m),no=r($),z=l($,"DIV",{class:!0});var K=U(z);h(Ue.$$.fragment,K),ro=r(K),st=l(K,"P",{"data-svelte-h":!0}),_(st)!=="svelte-stjif2"&&(st.textContent=hs),io=r(K),at=l(K,"P",{"data-svelte-h":!0}),_(at)!=="svelte-esrgfk"&&(at.innerHTML=gs),K.forEach(m),lo=r($),te=l($,"DIV",{class:!0});var Le=U(te);h(Je.$$.fragment,Le),mo=r(Le),nt=l(Le,"P",{"data-svelte-h":!0}),_(nt)!=="svelte-jedy0o"&&(nt.innerHTML=Ms),Le.forEach(m),co=r($),oe=l($,"DIV",{class:!0});var Qe=U(oe);h(je.$$.fragment,Qe),po=r(Qe),rt=l(Qe,"P",{"data-svelte-h":!0}),_(rt)!=="svelte-1vfte1e"&&(rt.innerHTML=bs),Qe.forEach(m),fo=r($),Y=l($,"DIV",{class:!0});var O=U(Y);h(ke.$$.fragment,O),uo=r(O),it=l(O,"P",{"data-svelte-h":!0}),_(it)!=="svelte-1wx27ts"&&(it.innerHTML=ys),ho=r(O),lt=l(O,"P",{"data-svelte-h":!0}),_(lt)!=="svelte-esrgfk"&&(lt.innerHTML=_s),O.forEach(m),go=r($),se=l($,"DIV",{class:!0});var Se=U(se);h(Ze.$$.fragment,Se),Mo=r(Se),dt=l(Se,"P",{"data-svelte-h":!0}),_(dt)!=="svelte-1rv66k9"&&(dt.innerHTML=vs),Se.forEach(m),bo=r($),F=l($,"DIV",{class:!0});var I=U(F);h(Ce.$$.fragment,I),yo=r(I),mt=l(I,"P",{"data-svelte-h":!0}),_(mt)!=="svelte-yfpdyb"&&(mt.innerHTML=xs),_o=r(I),ct=l(I,"P",{"data-svelte-h":!0}),_(ct)!=="svelte-z1uct7"&&(ct.textContent=ws),vo=r(I),h(ae.$$.fragment,I),xo=r(I),h(ne.$$.fragment,I),I.forEach(m),wo=r($),C=l($,"DIV",{class:!0});var G=U(C);h(Ge.$$.fragment,G),$o=r(G),pt=l(G,"P",{"data-svelte-h":!0}),_(pt)!=="svelte-1lisopl"&&(pt.textContent=$s),To=r(G),ft=l(G,"P",{"data-svelte-h":!0}),_(ft)!=="svelte-1fnd9e6"&&(ft.innerHTML=Ts),Uo=r(G),h(re.$$.fragment,G),Jo=r(G),h(ie.$$.fragment,G),jo=r(G),h(le.$$.fragment,G),G.forEach(m),ko=r($),E=l($,"DIV",{class:!0});var ee=U(E);h(Fe.$$.fragment,ee),Zo=r(ee),ut=l(ee,"P",{"data-svelte-h":!0}),_(ut)!=="svelte-1jxmzhx"&&(ut.textContent=Us),Co=r(ee),h(de.$$.fragment,ee),ee.forEach(m),Go=r($),me=l($,"DIV",{class:!0});var Pt=U(me);h(Ie.$$.fragment,Pt),Fo=r(Pt),ht=l(Pt,"P",{"data-svelte-h":!0}),_(ht)!=="svelte-1y16a8m"&&(ht.innerHTML=Js),Pt.forEach(m),Io=r($),D=l($,"DIV",{class:!0});var Zt=U(D);h(We.$$.fragment,Zt),Wo=r(Zt),gt=l(Zt,"P",{"data-svelte-h":!0}),_(gt)!=="svelte-1kp30gn"&&(gt.textContent=js),Bo=r(Zt),Mt=l(Zt,"P",{"data-svelte-h":!0}),_(Mt)!=="svelte-esrgfk"&&(Mt.innerHTML=ks),Zt.forEach(m),$.forEach(m),Xt=r(t),h(Be.$$.fragment,t),Nt=r(t),J=l(t,"DIV",{class:!0});var Z=U(J);h(Ve.$$.fragment,Z),Vo=r(Z),bt=l(Z,"P",{"data-svelte-h":!0}),_(bt)!=="svelte-1kw8rks"&&(bt.textContent=Zs),Ro=r(Z),yt=l(Z,"P",{"data-svelte-h":!0}),_(yt)!=="svelte-ltxz86"&&(yt.innerHTML=Cs),Ho=r(Z),_t=l(Z,"UL",{"data-svelte-h":!0}),_(_t)!=="svelte-5tww1s"&&(_t.innerHTML=Gs),Xo=r(Z),W=l(Z,"DIV",{class:!0});var be=U(W);h(Re.$$.fragment,be),No=r(be),vt=l(be,"P",{"data-svelte-h":!0}),_(vt)!=="svelte-72pb05"&&(vt.textContent=Fs),zo=r(be),h(ce.$$.fragment,be),Yo=r(be),h(pe.$$.fragment,be),be.forEach(m),Eo=r(Z),fe=l(Z,"DIV",{class:!0});var Lt=U(fe);h(He.$$.fragment,Lt),Do=r(Lt),xt=l(Lt,"P",{"data-svelte-h":!0}),_(xt)!=="svelte-9z80ed"&&(xt.innerHTML=Is),Lt.forEach(m),Po=r(Z),B=l(Z,"DIV",{class:!0});var ye=U(B);h(Xe.$$.fragment,ye),Lo=r(ye),wt=l(ye,"P",{"data-svelte-h":!0}),_(wt)!=="svelte-16uni9u"&&(wt.innerHTML=Ws),Qo=r(ye),$t=l(ye,"P",{"data-svelte-h":!0}),_($t)!=="svelte-1y9zqww"&&($t.textContent=Bs),So=r(ye),h(ue.$$.fragment,ye),ye.forEach(m),qo=r(Z),V=l(Z,"DIV",{class:!0});var _e=U(V);h(Ne.$$.fragment,_e),Ao=r(_e),Tt=l(_e,"P",{"data-svelte-h":!0}),_(Tt)!=="svelte-ifz6ak"&&(Tt.innerHTML=Vs),Ko=r(_e),Ut=l(_e,"P",{"data-svelte-h":!0}),_(Ut)!=="svelte-yfkr09"&&(Ut.textContent=Rs),Oo=r(_e),h(he.$$.fragment,_e),_e.forEach(m),es=r(Z),P=l(Z,"DIV",{class:!0});var Ct=U(P);h(ze.$$.fragment,Ct),ts=r(Ct),Jt=l(Ct,"P",{"data-svelte-h":!0}),_(Jt)!=="svelte-j66hh4"&&(Jt.innerHTML=Hs),os=r(Ct),h(ge.$$.fragment,Ct),Ct.forEach(m),Z.forEach(m),zt=r(t),h(Ye.$$.fragment,t),Yt=r(t),H=l(t,"DIV",{class:!0});var Gt=U(H);h(Ee.$$.fragment,Gt),ss=r(Gt),jt=l(Gt,"P",{"data-svelte-h":!0}),_(jt)!=="svelte-7y8zei"&&(jt.textContent=Xs),as=r(Gt),L=l(Gt,"DIV",{class:!0});var Ft=U(L);h(De.$$.fragment,Ft),ns=r(Ft),kt=l(Ft,"P",{"data-svelte-h":!0}),_(kt)!=="svelte-5nfhmh"&&(kt.textContent=Ns),rs=r(Ft),h(Me.$$.fragment,Ft),Ft.forEach(m),Gt.forEach(m),Et=r(t),It=l(t,"P",{}),U(It).forEach(m),this.h()},h(){j(s,"name","hf:doc:metadata"),j(s,"content",pa),Wt.a=Bt,j(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,p){o(document.head,s),x(t,v,p),x(t,d,p),x(t,a,p),g(c,t,p),x(t,e,p),x(t,f,p),o(f,St),Wt.m(Ds,f),o(f,Bt),x(t,Vt,p),x(t,ve,p),x(t,Rt,p),g(xe,t,p),x(t,Ht,p),x(t,w,p),g(we,w,null),o(w,qt),o(w,qe),o(w,At),o(w,Ae),o(w,Kt),o(w,Ke),o(w,Ot),o(w,X),g($e,X,null),o(X,eo),o(X,Oe),o(X,to),o(X,et),o(w,oo),o(w,N),g(Te,N,null),o(N,so),o(N,tt),o(N,ao),o(N,ot),o(w,no),o(w,z),g(Ue,z,null),o(z,ro),o(z,st),o(z,io),o(z,at),o(w,lo),o(w,te),g(Je,te,null),o(te,mo),o(te,nt),o(w,co),o(w,oe),g(je,oe,null),o(oe,po),o(oe,rt),o(w,fo),o(w,Y),g(ke,Y,null),o(Y,uo),o(Y,it),o(Y,ho),o(Y,lt),o(w,go),o(w,se),g(Ze,se,null),o(se,Mo),o(se,dt),o(w,bo),o(w,F),g(Ce,F,null),o(F,yo),o(F,mt),o(F,_o),o(F,ct),o(F,vo),g(ae,F,null),o(F,xo),g(ne,F,null),o(w,wo),o(w,C),g(Ge,C,null),o(C,$o),o(C,pt),o(C,To),o(C,ft),o(C,Uo),g(re,C,null),o(C,Jo),g(ie,C,null),o(C,jo),g(le,C,null),o(w,ko),o(w,E),g(Fe,E,null),o(E,Zo),o(E,ut),o(E,Co),g(de,E,null),o(w,Go),o(w,me),g(Ie,me,null),o(me,Fo),o(me,ht),o(w,Io),o(w,D),g(We,D,null),o(D,Wo),o(D,gt),o(D,Bo),o(D,Mt),x(t,Xt,p),g(Be,t,p),x(t,Nt,p),x(t,J,p),g(Ve,J,null),o(J,Vo),o(J,bt),o(J,Ro),o(J,yt),o(J,Ho),o(J,_t),o(J,Xo),o(J,W),g(Re,W,null),o(W,No),o(W,vt),o(W,zo),g(ce,W,null),o(W,Yo),g(pe,W,null),o(J,Eo),o(J,fe),g(He,fe,null),o(fe,Do),o(fe,xt),o(J,Po),o(J,B),g(Xe,B,null),o(B,Lo),o(B,wt),o(B,Qo),o(B,$t),o(B,So),g(ue,B,null),o(J,qo),o(J,V),g(Ne,V,null),o(V,Ao),o(V,Tt),o(V,Ko),o(V,Ut),o(V,Oo),g(he,V,null),o(J,es),o(J,P),g(ze,P,null),o(P,ts),o(P,Jt),o(P,os),g(ge,P,null),x(t,zt,p),g(Ye,t,p),x(t,Yt,p),x(t,H,p),g(Ee,H,null),o(H,ss),o(H,jt),o(H,as),o(H,L),g(De,L,null),o(L,ns),o(L,kt),o(L,rs),g(Me,L,null),x(t,Et,p),x(t,It,p),Dt=!0},p(t,[p]){const Pe={};p&2&&(Pe.$$scope={dirty:p,ctx:t}),ae.$set(Pe);const $={};p&2&&($.$$scope={dirty:p,ctx:t}),ne.$set($);const q={};p&2&&(q.$$scope={dirty:p,ctx:t}),re.$set(q);const A={};p&2&&(A.$$scope={dirty:p,ctx:t}),ie.$set(A);const K={};p&2&&(K.$$scope={dirty:p,ctx:t}),le.$set(K);const Le={};p&2&&(Le.$$scope={dirty:p,ctx:t}),de.$set(Le);const Qe={};p&2&&(Qe.$$scope={dirty:p,ctx:t}),ce.$set(Qe);const O={};p&2&&(O.$$scope={dirty:p,ctx:t}),pe.$set(O);const Se={};p&2&&(Se.$$scope={dirty:p,ctx:t}),ue.$set(Se);const I={};p&2&&(I.$$scope={dirty:p,ctx:t}),he.$set(I);const G={};p&2&&(G.$$scope={dirty:p,ctx:t}),ge.$set(G);const ee={};p&2&&(ee.$$scope={dirty:p,ctx:t}),Me.$set(ee)},i(t){Dt||(M(c.$$.fragment,t),M(xe.$$.fragment,t),M(we.$$.fragment,t),M($e.$$.fragment,t),M(Te.$$.fragment,t),M(Ue.$$.fragment,t),M(Je.$$.fragment,t),M(je.$$.fragment,t),M(ke.$$.fragment,t),M(Ze.$$.fragment,t),M(Ce.$$.fragment,t),M(ae.$$.fragment,t),M(ne.$$.fragment,t),M(Ge.$$.fragment,t),M(re.$$.fragment,t),M(ie.$$.fragment,t),M(le.$$.fragment,t),M(Fe.$$.fragment,t),M(de.$$.fragment,t),M(Ie.$$.fragment,t),M(We.$$.fragment,t),M(Be.$$.fragment,t),M(Ve.$$.fragment,t),M(Re.$$.fragment,t),M(ce.$$.fragment,t),M(pe.$$.fragment,t),M(He.$$.fragment,t),M(Xe.$$.fragment,t),M(ue.$$.fragment,t),M(Ne.$$.fragment,t),M(he.$$.fragment,t),M(ze.$$.fragment,t),M(ge.$$.fragment,t),M(Ye.$$.fragment,t),M(Ee.$$.fragment,t),M(De.$$.fragment,t),M(Me.$$.fragment,t),Dt=!0)},o(t){b(c.$$.fragment,t),b(xe.$$.fragment,t),b(we.$$.fragment,t),b($e.$$.fragment,t),b(Te.$$.fragment,t),b(Ue.$$.fragment,t),b(Je.$$.fragment,t),b(je.$$.fragment,t),b(ke.$$.fragment,t),b(Ze.$$.fragment,t),b(Ce.$$.fragment,t),b(ae.$$.fragment,t),b(ne.$$.fragment,t),b(Ge.$$.fragment,t),b(re.$$.fragment,t),b(ie.$$.fragment,t),b(le.$$.fragment,t),b(Fe.$$.fragment,t),b(de.$$.fragment,t),b(Ie.$$.fragment,t),b(We.$$.fragment,t),b(Be.$$.fragment,t),b(Ve.$$.fragment,t),b(Re.$$.fragment,t),b(ce.$$.fragment,t),b(pe.$$.fragment,t),b(He.$$.fragment,t),b(Xe.$$.fragment,t),b(ue.$$.fragment,t),b(Ne.$$.fragment,t),b(he.$$.fragment,t),b(ze.$$.fragment,t),b(ge.$$.fragment,t),b(Ye.$$.fragment,t),b(Ee.$$.fragment,t),b(De.$$.fragment,t),b(Me.$$.fragment,t),Dt=!1},d(t){t&&(m(v),m(d),m(a),m(e),m(f),m(Vt),m(ve),m(Rt),m(Ht),m(w),m(Xt),m(Nt),m(J),m(zt),m(Yt),m(H),m(Et),m(It)),m(s),y(c,t),y(xe,t),y(we),y($e),y(Te),y(Ue),y(Je),y(je),y(ke),y(Ze),y(Ce),y(ae),y(ne),y(Ge),y(re),y(ie),y(le),y(Fe),y(de),y(Ie),y(We),y(Be,t),y(Ve),y(Re),y(ce),y(pe),y(He),y(Xe),y(ue),y(Ne),y(he),y(ze),y(ge),y(Ye,t),y(Ee),y(De),y(Me)}}}const pa='{"title":"Models","local":"models","sections":[{"title":"ModelMixin","local":"diffusers.ModelMixin","sections":[],"depth":2},{"title":"FlaxModelMixin","local":"diffusers.FlaxModelMixin","sections":[],"depth":2},{"title":"PushToHubMixin","local":"diffusers.utils.PushToHubMixin","sections":[],"depth":2}],"depth":1}';function fa(T){return Ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class va extends Qs{constructor(s){super(),Ss(this,s,fa,ca,Ps,{})}}export{va as component};
