import{s as rt,o as ct,n as dt}from"../chunks/scheduler.182ea377.js";import{S as ut,i as ft,g as s,s as i,r,A as yt,h as a,f as l,c as o,j as mt,u as c,x as p,k as Ne,y as ht,a as n,v as d,d as u,t as f,w as y}from"../chunks/index.abf12888.js";import{T as bt}from"../chunks/Tip.230e2334.js";import{C as b}from"../chunks/CodeBlock.57fe6e13.js";import{D as Mt}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as Ee}from"../chunks/Heading.16916d63.js";function wt(le){let m,U="🔒 By loading a community pipeline from the Hugging Face Hub, you are trusting that the code you are loading is safe. Make sure to inspect the code online before loading and running it automatically!";return{c(){m=s("p"),m.textContent=U},l(h){m=a(h,"P",{"data-svelte-h":!0}),p(m)!=="svelte-154jbq5"&&(m.textContent=U)},m(h,ee){n(h,m,ee)},p:dt,d(h){h&&l(m)}}}function Tt(le){let m,U,h,ee,g,ne,J,ie,Z,oe,_,Xe='Community pipelines are any <a href="/docs/diffusers/v0.22.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class that are different from the original implementation as specified in their paper (for example, the <a href="/docs/diffusers/v0.22.0/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> corresponds to the <a href="https://arxiv.org/abs/2302.05543" rel="nofollow">Text-to-Image Generation with ControlNet Conditioning</a> paper). They provide additional functionality or extend the original implementation of a pipeline.',se,v,Se='There are many cool community pipelines like <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#speech-to-image" rel="nofollow">Speech to Image</a> or <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#composable-stable-diffusion" rel="nofollow">Composable Stable Diffusion</a>, and you can find all the official community pipelines <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">here</a>.',ae,V,Qe='To load any community pipeline on the Hub, pass the repository id of the community pipeline to the <code>custom_pipeline</code> argument and the model repository where you’d like to load the pipeline weights and components from. For example, the example below loads a dummy pipeline from <a href="https://huggingface.co/hf-internal-testing/diffusers-dummy-pipeline/blob/main/pipeline.py" rel="nofollow"><code>hf-internal-testing/diffusers-dummy-pipeline</code></a> and the pipeline weights and components from <a href="https://huggingface.co/google/ddpm-cifar10-32" rel="nofollow"><code>google/ddpm-cifar10-32</code></a>:',pe,M,me,C,re,j,ze='Loading an official community pipeline is similar, but you can mix loading weights from an official repository id and pass pipeline components directly. The example below loads the community <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#clip-guided-stable-diffusion" rel="nofollow">CLIP Guided Stable Diffusion</a> pipeline, and you can pass the CLIP model components directly to it:',ce,$,de,W,Le='For more information about community pipelines, take a look at the <a href="custom_pipeline_examples">Community pipelines</a> guide for how to use them and if you’re interested in adding a community pipeline check out the <a href="contribute_pipeline">How to contribute a community pipeline</a> guide!',ue,k,fe,x,Pe="If your pipeline has custom components that Diffusers doesn’t support already, you need to accompany the Python modules that implement them. These customized components could be VAE, UNet, scheduler, etc. For the text encoder, we rely on <code>transformers</code> anyway. So, that should be handled separately (more info here). The pipeline code itself can be customized as well.",ye,G,Fe="Community components allow users to build pipelines that may have customized components that are not part of Diffusers. This section shows how users should use community components to build a community pipeline.",he,I,Ye='You’ll use the <a href="https://huggingface.co/showlab/show-1-base" rel="nofollow">showlab/show-1-base</a> pipeline checkpoint as an example here. Here, you have a custom UNet and a customized pipeline (<code>TextToVideoIFPipeline</code>). For convenience, let’s call the UNet <code>ShowOneUNet3DConditionModel</code>.',be,B,qe="“showlab/show-1-base” already provides the checkpoints in the Diffusers format, which is a great starting point. So, let’s start loading up the components which are already well-supported:",Me,H,De="<li><strong>Text encoder</strong></li>",we,R,Te,w,Ae="<li><strong>Scheduler</strong></li>",Ue,N,ge,T,Oe="<li><strong>Image processor</strong></li>",Je,E,Ze,X,Ke='Now, you need to implement the custom UNet. The implementation is available <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">here</a>. So, let’s create a Python script called <code>showone_unet_3d_condition.py</code> and copy over the implementation, changing the <code>UNet3DConditionModel</code> classname to <code>ShowOneUNet3DConditionModel</code> to avoid any conflicts with Diffusers. This is because Diffusers already has one <code>UNet3DConditionModel</code>. We put all the components needed to implement the class in <code>showone_unet_3d_condition.py</code> only. You can find the entire file <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">here</a>.',_e,S,et="Once this is done, we can initialize the UNet:",ve,Q,Ve,z,tt='Then implement the custom <code>TextToVideoIFPipeline</code> in another Python script: <code>pipeline_t2v_base_pixel.py</code>. This is already available <a href="https://github.com/showlab/Show-1/blob/main/showone/pipelines/pipeline_t2v_base_pixel.py" rel="nofollow">here</a>.',Ce,L,lt="Now that you have all the components, initialize the <code>TextToVideoIFPipeline</code>:",je,P,$e,F,nt="Push to the pipeline to the Hub to share with the community:",We,Y,ke,q,it="After the pipeline is successfully pushed, you need a couple of changes:",xe,D,ot='<li>In <code>model_index.json</code> file, change the <code>_class_name</code> attribute. It should be like <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/model_index.json#L2" rel="nofollow">so</a>.</li> <li>Upload <code>showone_unet_3d_condition.py</code> to the <code>unet</code> directory (<a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">example</a>).</li> <li>Upload <code>pipeline_t2v_base_pixel.py</code> to the pipeline base directory (<a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">example</a>).</li>',Ge,A,st="To run inference, just do:",Ie,O,Be,K,at="Here, notice the use of the <code>trust_remote_code</code> argument while initializing the pipeline. It is responsible for handling all the “magic” behind the scenes.",He,te,Re;return g=new Ee({props:{title:"Load community pipelines and components",local:"load-community-pipelines-and-components",headingTag:"h1"}}),J=new Mt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"}]}}),Z=new Ee({props:{title:"Community pipelines",local:"community-pipelines",headingTag:"h2"}}),M=new bt({props:{warning:!0,$$slots:{default:[wt]},$$scope:{ctx:le}}}),C=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1kdW1teS1waXBlbGluZSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;hf-internal-testing/diffusers-dummy-pipeline&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),$=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBJbWFnZVByb2Nlc3NvciUyQyUyMENMSVBNb2RlbCUwQSUwQWNsaXBfbW9kZWxfaWQlMjAlM0QlMjAlMjJsYWlvbiUyRkNMSVAtVmlULUItMzItbGFpb24yQi1zMzRCLWI3OUslMjIlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMENMSVBJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2xpcF9tb2RlbF9pZCklMEFjbGlwX21vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZChjbGlwX21vZGVsX2lkKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyY2xpcF9ndWlkZWRfc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPImageProcessor, CLIPModel

clip_model_id = <span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>

feature_extractor = CLIPImageProcessor.from_pretrained(clip_model_id)
clip_model = CLIPModel.from_pretrained(clip_model_id)

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),k=new Ee({props:{title:"Community components",local:"community-components",headingTag:"h2"}}),R=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1VG9rZW5pemVyJTJDJTIwVDVFbmNvZGVyTW9kZWwlMEElMEFwaXBlX2lkJTIwJTNEJTIwJTIyc2hvd2xhYiUyRnNob3ctMS1iYXNlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwVDVUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIpJTBBdGV4dF9lbmNvZGVyJTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5EncoderModel

pipe_id = <span class="hljs-string">&quot;showlab/show-1-base&quot;</span>
tokenizer = T5Tokenizer.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
text_encoder = T5EncoderModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>)`,wrap:!1}}),N=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

scheduler = DPMSolverMultistepScheduler.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`,wrap:!1}}),E=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBDTElQRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMmZlYXR1cmVfZXh0cmFjdG9yJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPFeatureExtractor

feature_extractor = CLIPFeatureExtractor.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;feature_extractor&quot;</span>)`,wrap:!1}}),Q=new b({props:{code:"ZnJvbSUyMHNob3dvbmVfdW5ldF8zZF9jb25kaXRpb24lMjBpbXBvcnQlMjBTaG93T25lVU5ldDNEQ29uZGl0aW9uTW9kZWwlMEElMEF1bmV0JTIwJTNEJTIwU2hvd09uZVVOZXQzRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZChwaXBlX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMik=",highlighted:`<span class="hljs-keyword">from</span> showone_unet_3d_condition <span class="hljs-keyword">import</span> ShowOneUNet3DConditionModel

unet = ShowOneUNet3DConditionModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),P=new b({props:{code:"ZnJvbSUyMHBpcGVsaW5lX3Qydl9iYXNlX3BpeGVsJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9JRlBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFRleHRUb1ZpZGVvSUZQaXBlbGluZSglMEElMjAlMjAlMjAlMjB1bmV0JTNEdW5ldCUyQyUyMCUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRHRleHRfZW5jb2RlciUyQyUyMCUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMCUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHNjaGVkdWxlciUyQyUyMCUwQSUyMCUyMCUyMCUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEZmVhdHVyZV9leHRyYWN0b3IlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byhkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQXBpcGVsaW5lLnRvcmNoX2R0eXBlJTIwJTNEJTIwdG9yY2guZmxvYXQxNg==",highlighted:`<span class="hljs-keyword">from</span> pipeline_t2v_base_pixel <span class="hljs-keyword">import</span> TextToVideoIFPipeline
<span class="hljs-keyword">import</span> torch

pipeline = TextToVideoIFPipeline(
    unet=unet, 
    text_encoder=text_encoder, 
    tokenizer=tokenizer, 
    scheduler=scheduler, 
    feature_extractor=feature_extractor
)
pipeline = pipeline.to(device=<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.torch_dtype = torch.float16`,wrap:!1}}),Y=new b({props:{code:"cGlwZWxpbmUucHVzaF90b19odWIoJTIyY3VzdG9tLXQydi1waXBlbGluZSUyMik=",highlighted:'pipeline.push_to_hub(<span class="hljs-string">&quot;custom-t2v-pipeline&quot;</span>)',wrap:!1}}),O=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIlM0NjaGFuZ2UtdXNlcm5hbWUlM0UlMkYlM0NjaGFuZ2UtaWQlM0UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyaGVsbG8lMjIlMEElMEElMjMlMjBUZXh0JTIwZW1iZWRzJTBBcHJvbXB0X2VtYmVkcyUyQyUyMG5lZ2F0aXZlX2VtYmVkcyUyMCUzRCUyMHBpcGVsaW5lLmVuY29kZV9wcm9tcHQocHJvbXB0KSUwQSUwQSUyMyUyMEtleWZyYW1lcyUyMGdlbmVyYXRpb24lMjAoOHg2NHg0MCUyQyUyMDJmcHMpJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEbmVnYXRpdmVfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDglMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENjQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOS4wJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJwdCUyMiUwQSkuZnJhbWVz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;&lt;change-username&gt;/&lt;change-id&gt;&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;hello&quot;</span>

<span class="hljs-comment"># Text embeds</span>
prompt_embeds, negative_embeds = pipeline.encode_prompt(prompt)

<span class="hljs-comment"># Keyframes generation (8x64x40, 2fps)</span>
video_frames = pipeline(
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=negative_embeds,
    num_frames=<span class="hljs-number">8</span>,
    height=<span class="hljs-number">40</span>,
    width=<span class="hljs-number">64</span>,
    num_inference_steps=<span class="hljs-number">2</span>,
    guidance_scale=<span class="hljs-number">9.0</span>,
    output_type=<span class="hljs-string">&quot;pt&quot;</span>
).frames`,wrap:!1}}),{c(){m=s("meta"),U=i(),h=s("p"),ee=i(),r(g.$$.fragment),ne=i(),r(J.$$.fragment),ie=i(),r(Z.$$.fragment),oe=i(),_=s("p"),_.innerHTML=Xe,se=i(),v=s("p"),v.innerHTML=Se,ae=i(),V=s("p"),V.innerHTML=Qe,pe=i(),r(M.$$.fragment),me=i(),r(C.$$.fragment),re=i(),j=s("p"),j.innerHTML=ze,ce=i(),r($.$$.fragment),de=i(),W=s("p"),W.innerHTML=Le,ue=i(),r(k.$$.fragment),fe=i(),x=s("p"),x.innerHTML=Pe,ye=i(),G=s("p"),G.textContent=Fe,he=i(),I=s("p"),I.innerHTML=Ye,be=i(),B=s("p"),B.textContent=qe,Me=i(),H=s("ol"),H.innerHTML=De,we=i(),r(R.$$.fragment),Te=i(),w=s("ol"),w.innerHTML=Ae,Ue=i(),r(N.$$.fragment),ge=i(),T=s("ol"),T.innerHTML=Oe,Je=i(),r(E.$$.fragment),Ze=i(),X=s("p"),X.innerHTML=Ke,_e=i(),S=s("p"),S.textContent=et,ve=i(),r(Q.$$.fragment),Ve=i(),z=s("p"),z.innerHTML=tt,Ce=i(),L=s("p"),L.innerHTML=lt,je=i(),r(P.$$.fragment),$e=i(),F=s("p"),F.textContent=nt,We=i(),r(Y.$$.fragment),ke=i(),q=s("p"),q.textContent=it,xe=i(),D=s("ol"),D.innerHTML=ot,Ge=i(),A=s("p"),A.textContent=st,Ie=i(),r(O.$$.fragment),Be=i(),K=s("p"),K.innerHTML=at,He=i(),te=s("p"),this.h()},l(e){const t=yt("svelte-u9bgzb",document.head);m=a(t,"META",{name:!0,content:!0}),t.forEach(l),U=o(e),h=a(e,"P",{}),mt(h).forEach(l),ee=o(e),c(g.$$.fragment,e),ne=o(e),c(J.$$.fragment,e),ie=o(e),c(Z.$$.fragment,e),oe=o(e),_=a(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-yyl5sb"&&(_.innerHTML=Xe),se=o(e),v=a(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-10en0rk"&&(v.innerHTML=Se),ae=o(e),V=a(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1mmnk2f"&&(V.innerHTML=Qe),pe=o(e),c(M.$$.fragment,e),me=o(e),c(C.$$.fragment,e),re=o(e),j=a(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1yyre8w"&&(j.innerHTML=ze),ce=o(e),c($.$$.fragment,e),de=o(e),W=a(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1ho2g1z"&&(W.innerHTML=Le),ue=o(e),c(k.$$.fragment,e),fe=o(e),x=a(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-131ainc"&&(x.innerHTML=Pe),ye=o(e),G=a(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1sopnyn"&&(G.textContent=Fe),he=o(e),I=a(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-12fqsoz"&&(I.innerHTML=Ye),be=o(e),B=a(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-pbwz2p"&&(B.textContent=qe),Me=o(e),H=a(e,"OL",{"data-svelte-h":!0}),p(H)!=="svelte-1onvujx"&&(H.innerHTML=De),we=o(e),c(R.$$.fragment,e),Te=o(e),w=a(e,"OL",{start:!0,"data-svelte-h":!0}),p(w)!=="svelte-1irfhza"&&(w.innerHTML=Ae),Ue=o(e),c(N.$$.fragment,e),ge=o(e),T=a(e,"OL",{start:!0,"data-svelte-h":!0}),p(T)!=="svelte-1m4vkll"&&(T.innerHTML=Oe),Je=o(e),c(E.$$.fragment,e),Ze=o(e),X=a(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-w0yamu"&&(X.innerHTML=Ke),_e=o(e),S=a(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1wq1rlm"&&(S.textContent=et),ve=o(e),c(Q.$$.fragment,e),Ve=o(e),z=a(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1noscq6"&&(z.innerHTML=tt),Ce=o(e),L=a(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-v6qaoi"&&(L.innerHTML=lt),je=o(e),c(P.$$.fragment,e),$e=o(e),F=a(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1i13run"&&(F.textContent=nt),We=o(e),c(Y.$$.fragment,e),ke=o(e),q=a(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-azdq2p"&&(q.textContent=it),xe=o(e),D=a(e,"OL",{"data-svelte-h":!0}),p(D)!=="svelte-gc2pb5"&&(D.innerHTML=ot),Ge=o(e),A=a(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-12d2k9k"&&(A.textContent=st),Ie=o(e),c(O.$$.fragment,e),Be=o(e),K=a(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-qxpitj"&&(K.innerHTML=at),He=o(e),te=a(e,"P",{}),mt(te).forEach(l),this.h()},h(){Ne(m,"name","hf:doc:metadata"),Ne(m,"content",Ut),Ne(w,"start","2"),Ne(T,"start","3")},m(e,t){ht(document.head,m),n(e,U,t),n(e,h,t),n(e,ee,t),d(g,e,t),n(e,ne,t),d(J,e,t),n(e,ie,t),d(Z,e,t),n(e,oe,t),n(e,_,t),n(e,se,t),n(e,v,t),n(e,ae,t),n(e,V,t),n(e,pe,t),d(M,e,t),n(e,me,t),d(C,e,t),n(e,re,t),n(e,j,t),n(e,ce,t),d($,e,t),n(e,de,t),n(e,W,t),n(e,ue,t),d(k,e,t),n(e,fe,t),n(e,x,t),n(e,ye,t),n(e,G,t),n(e,he,t),n(e,I,t),n(e,be,t),n(e,B,t),n(e,Me,t),n(e,H,t),n(e,we,t),d(R,e,t),n(e,Te,t),n(e,w,t),n(e,Ue,t),d(N,e,t),n(e,ge,t),n(e,T,t),n(e,Je,t),d(E,e,t),n(e,Ze,t),n(e,X,t),n(e,_e,t),n(e,S,t),n(e,ve,t),d(Q,e,t),n(e,Ve,t),n(e,z,t),n(e,Ce,t),n(e,L,t),n(e,je,t),d(P,e,t),n(e,$e,t),n(e,F,t),n(e,We,t),d(Y,e,t),n(e,ke,t),n(e,q,t),n(e,xe,t),n(e,D,t),n(e,Ge,t),n(e,A,t),n(e,Ie,t),d(O,e,t),n(e,Be,t),n(e,K,t),n(e,He,t),n(e,te,t),Re=!0},p(e,[t]){const pt={};t&2&&(pt.$$scope={dirty:t,ctx:e}),M.$set(pt)},i(e){Re||(u(g.$$.fragment,e),u(J.$$.fragment,e),u(Z.$$.fragment,e),u(M.$$.fragment,e),u(C.$$.fragment,e),u($.$$.fragment,e),u(k.$$.fragment,e),u(R.$$.fragment,e),u(N.$$.fragment,e),u(E.$$.fragment,e),u(Q.$$.fragment,e),u(P.$$.fragment,e),u(Y.$$.fragment,e),u(O.$$.fragment,e),Re=!0)},o(e){f(g.$$.fragment,e),f(J.$$.fragment,e),f(Z.$$.fragment,e),f(M.$$.fragment,e),f(C.$$.fragment,e),f($.$$.fragment,e),f(k.$$.fragment,e),f(R.$$.fragment,e),f(N.$$.fragment,e),f(E.$$.fragment,e),f(Q.$$.fragment,e),f(P.$$.fragment,e),f(Y.$$.fragment,e),f(O.$$.fragment,e),Re=!1},d(e){e&&(l(U),l(h),l(ee),l(ne),l(ie),l(oe),l(_),l(se),l(v),l(ae),l(V),l(pe),l(me),l(re),l(j),l(ce),l(de),l(W),l(ue),l(fe),l(x),l(ye),l(G),l(he),l(I),l(be),l(B),l(Me),l(H),l(we),l(Te),l(w),l(Ue),l(ge),l(T),l(Je),l(Ze),l(X),l(_e),l(S),l(ve),l(Ve),l(z),l(Ce),l(L),l(je),l($e),l(F),l(We),l(ke),l(q),l(xe),l(D),l(Ge),l(A),l(Ie),l(Be),l(K),l(He),l(te)),l(m),y(g,e),y(J,e),y(Z,e),y(M,e),y(C,e),y($,e),y(k,e),y(R,e),y(N,e),y(E,e),y(Q,e),y(P,e),y(Y,e),y(O,e)}}}const Ut='{"title":"Load community pipelines and components","local":"load-community-pipelines-and-components","sections":[{"title":"Community pipelines","local":"community-pipelines","sections":[],"depth":2},{"title":"Community components","local":"community-components","sections":[],"depth":2}],"depth":1}';function gt(le){return ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends ut{constructor(m){super(),ft(this,m,gt,Tt,rt,{})}}export{jt as component};
