import{s as Yp,f as $n,o as Fp,n as bl}from"../chunks/scheduler.d627b047.js";import{S as _p,i as Hp,g as u,s as a,r as p,A as Lp,h as y,f as l,c as n,j as $l,u as o,x as j,k as b,y as Dp,a as e,v as i,d as r,t as M,w as c}from"../chunks/index.73c51727.js";import{T as fl}from"../chunks/Tip.a82942ec.js";import{C as h}from"../chunks/CodeBlock.b1cdc5f6.js";import{H as d,E as Pp}from"../chunks/EditOnGithub.859b9ebc.js";function Kp(f){let J,I="While both the prompt-only and language modeling types are similar, they differ in how the input is handled. In the prompt-only type, the prompt represents a partial input that expects the model to complete or continue, while in the language modeling type, the input is treated as a complete sentence or sequence. These two types are processed differently by TRL. Below is an example showing the difference in the output of the <code>apply_chat_template</code> function for each type:",m,T,g,w,C="<li>The prompt-only output includes a <code>&#39;&lt;|assistant|&gt;\\n&#39;</code>, indicating the beginning of the assistant’s turn and expecting the model to generate a completion.</li> <li>In contrast, the language modeling output treats the input as a complete sequence and terminates it with <code>&#39;&lt;|endoftext|&gt;&#39;</code>, signaling the end of the text and not expecting any additional content.</li>",$;return T=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwYXBwbHlfY2hhdF90ZW1wbGF0ZSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktMTI4ay1pbnN0cnVjdCUyMiklMEElMEElMjMlMjBFeGFtcGxlJTIwZm9yJTIwcHJvbXB0LW9ubHklMjB0eXBlJTBBcHJvbXB0X29ubHlfZXhhbXBsZSUyMCUzRCUyMCU3QiUyMnByb21wdCUyMiUzQSUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTIyJTdEJTVEJTdEJTBBYXBwbHlfY2hhdF90ZW1wbGF0ZShwcm9tcHRfb25seV9leGFtcGxlJTJDJTIwdG9rZW5pemVyKSUwQSUyMyUyME91dHB1dCUzQSUyMCU3Qidwcm9tcHQnJTNBJTIwJyUzQyU3Q3VzZXIlN0MlM0UlNUNuV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlM0MlN0NlbmQlN0MlM0UlNUNuJTNDJTdDYXNzaXN0YW50JTdDJTNFJTVDbiclN0QlMEElMEElMjMlMjBFeGFtcGxlJTIwZm9yJTIwbGFuZ3VhZ2UlMjBtb2RlbGluZyUyMHR5cGUlMEFsbV9leGFtcGxlJTIwJTNEJTIwJTdCJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCU1RCU3RCUwQWFwcGx5X2NoYXRfdGVtcGxhdGUobG1fZXhhbXBsZSUyQyUyMHRva2VuaXplciklMEElMjMlMjBPdXRwdXQlM0ElMjAlN0IndGV4dCclM0ElMjAnJTNDJTdDdXNlciU3QyUzRSU1Q25XaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0NlbmRvZnRleHQlN0MlM0UnJTdE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> apply_chat_template

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-128k-instruct&quot;</span>)

<span class="hljs-comment"># Example for prompt-only type</span>
prompt_only_example = {<span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}]}
apply_chat_template(prompt_only_example, tokenizer)
<span class="hljs-comment"># Output: {&#x27;prompt&#x27;: &#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;}</span>

<span class="hljs-comment"># Example for language modeling type</span>
lm_example = {<span class="hljs-string">&quot;messages&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}]}
apply_chat_template(lm_example, tokenizer)
<span class="hljs-comment"># Output: {&#x27;text&#x27;: &#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;}</span>`,wrap:!1}}),{c(){J=u("p"),J.innerHTML=I,m=a(),p(T.$$.fragment),g=a(),w=u("ul"),w.innerHTML=C},l(U){J=y(U,"P",{"data-svelte-h":!0}),j(J)!=="svelte-1k9p4sz"&&(J.innerHTML=I),m=n(U),o(T.$$.fragment,U),g=n(U),w=y(U,"UL",{"data-svelte-h":!0}),j(w)!=="svelte-17mqw6t"&&(w.innerHTML=C)},m(U,q){e(U,J,q),e(U,m,q),i(T,U,q),e(U,g,q),e(U,w,q),$=!0},p:bl,i(U){$||(r(T.$$.fragment,U),$=!0)},o(U){M(T.$$.fragment,U),$=!1},d(U){U&&(l(J),l(m),l(g),l(w)),c(T,U)}}}function Op(f){let J,I=`TRL trainers only support standard dataset formats, <a href="https://github.com/huggingface/trl/issues/2071" rel="nofollow">for now</a>. If you have a conversational dataset, you must first convert it into a standard format.
For more information on how to work with conversational datasets, refer to the <a href="#working-with-conversational-datasets-in-trl">Working with conversational datasets in TRL</a> section.`;return{c(){J=u("p"),J.innerHTML=I},l(m){J=y(m,"P",{"data-svelte-h":!0}),j(J)!=="svelte-38co2n"&&(J.innerHTML=I)},m(m,T){e(m,J,T)},p:bl,d(m){m&&l(J)}}}function to(f){let J,I=`We recommend using the <a href="/docs/trl/v0.15.1/en/data_utils#trl.apply_chat_template">apply_chat_template()</a> function instead of calling <code>tokenizer.apply_chat_template</code> directly. Handling chat templates for non-language modeling datasets can be tricky and may result in errors, such as mistakenly placing a system prompt in the middle of a conversation.
For additional examples, see <a href="https://github.com/huggingface/trl/pull/1930#issuecomment-2292908614" rel="nofollow">#1930 (comment)</a>. The <a href="/docs/trl/v0.15.1/en/data_utils#trl.apply_chat_template">apply_chat_template()</a> is designed to handle these intricacies and ensure the correct application of chat templates for various tasks.`;return{c(){J=u("p"),J.innerHTML=I},l(m){J=y(m,"P",{"data-svelte-h":!0}),j(J)!=="svelte-155wys6"&&(J.innerHTML=I)},m(m,T){e(m,J,T)},p:bl,d(m){m&&l(J)}}}function so(f){let J,I='It’s important to note that chat templates are model-specific. For example, if you use the chat template from <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-8B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3.1-8B-Instruct</a> with the above example, you get a different output:',m,T,g,w,C="Always use the chat template associated with the model you’re working with. Using the wrong template can lead to inaccurate or unexpected results.",$;return T=new h({props:{code:"YXBwbHlfY2hhdF90ZW1wbGF0ZShleGFtcGxlJTJDJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy4xLThCLUluc3RydWN0JTIyKSklMEElMjMlMjBPdXRwdXQlM0ElMEElMjMlMjAlN0IncHJvbXB0JyUzQSUyMCclM0MlN0NpbV9zdGFydCU3QyUzRXN5c3RlbSU1Q25Zb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lM0MlN0NpbV9lbmQlN0MlM0UlNUNuJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTVDbldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTVDbiclMkMlMEElMjMlMjAlMjAnY29tcGxldGlvbiclM0ElMjAnSXQlMjBpcyUyMGJsdWUuJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiclN0Q=",highlighted:`apply_chat_template(example, AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span>))
<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># {&#x27;prompt&#x27;: &#x27;&lt;|im_start|&gt;system\\nYou are a helpful assistant.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\nWhat color is the sky?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\n&#x27;,</span>
<span class="hljs-comment">#  &#x27;completion&#x27;: &#x27;It is blue.&lt;|im_end|&gt;\\n&#x27;}</span>`,wrap:!1}}),{c(){J=u("p"),J.innerHTML=I,m=a(),p(T.$$.fragment),g=a(),w=u("p"),w.textContent=C},l(U){J=y(U,"P",{"data-svelte-h":!0}),j(J)!=="svelte-6bgf58"&&(J.innerHTML=I),m=n(U),o(T.$$.fragment,U),g=n(U),w=y(U,"P",{"data-svelte-h":!0}),j(w)!=="svelte-ien9e7"&&(w.textContent=C)},m(U,q){e(U,J,q),e(U,m,q),i(T,U,q),e(U,g,q),e(U,w,q),$=!0},p:bl,i(U){$||(r(T.$$.fragment,U),$=!0)},o(U){M(T.$$.fragment,U),$=!1},d(U){U&&(l(J),l(m),l(g),l(w)),c(T,U)}}}function lo(f){let J,I=`Keep in mind that the <code>&quot;chosen&quot;</code> and <code>&quot;rejected&quot;</code> completions in a preference dataset can be both good or bad.
Before applying <a href="/docs/trl/v0.15.1/en/data_utils#trl.unpair_preference_dataset">unpair_preference_dataset()</a>, please ensure that all <code>&quot;chosen&quot;</code> completions can be labeled as good and all <code>&quot;rejected&quot;</code> completions as bad.
This can be ensured by checking absolute rating of each completion, e.g. from a reward model.`;return{c(){J=u("p"),J.innerHTML=I},l(m){J=y(m,"P",{"data-svelte-h":!0}),j(J)!=="svelte-1k0cbuf"&&(J.innerHTML=I)},m(m,T){e(m,J,T)},p:bl,d(m){m&&l(J)}}}function eo(f){let J,I=`Keep in mind that the <code>&quot;chosen&quot;</code> and <code>&quot;rejected&quot;</code> completions in a preference dataset can be both good or bad.
Before applying <a href="/docs/trl/v0.15.1/en/data_utils#trl.unpair_preference_dataset">unpair_preference_dataset()</a>, please ensure that all <code>&quot;chosen&quot;</code> completions can be labeled as good and all <code>&quot;rejected&quot;</code> completions as bad.
This can be ensured by checking absolute rating of each completion, e.g. from a reward model.`;return{c(){J=u("p"),J.innerHTML=I},l(m){J=y(m,"P",{"data-svelte-h":!0}),j(J)!=="svelte-1k0cbuf"&&(J.innerHTML=I)},m(m,T){e(m,J,T)},p:bl,d(m){m&&l(J)}}}function ao(f){let J,I,m,T,g,w,C,$="This guide provides an overview of the dataset formats and types supported by each trainer in TRL.",U,q,Ql,k,Qn="<li>The <em>format</em> of a dataset refers to how the data is structured, typically categorized as either <em>standard</em> or <em>conversational</em>.</li> <li>The <em>type</em> is associated with the specific task the dataset is designed for, such as <em>prompt-only</em> or <em>preference</em>. Each type is characterized by its columns, which vary according to the task, as shown in the table.</li>",Nl,R,Nn=`<tbody><tr><th>Type \\ Format</th> <th>Standard</th> <th>Conversational</th></tr> <tr><td>Language modeling</td> <td><pre><code>{&quot;text&quot;: &quot;The sky is blue.&quot;}</code></pre></td> <td><pre><code>{&quot;messages&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;},
              {&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}]}</code></pre></td></tr> <tr><td>Prompt-only</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}]}</code></pre></td></tr> <tr><td>Prompt-completion</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;,
 &quot;completion&quot;: &quot; blue.&quot;}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}],
 &quot;completion&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}]}</code></pre></td></tr> <tr><td>Preference</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;,
 &quot;chosen&quot;: &quot; blue.&quot;,
 &quot;rejected&quot;: &quot; green.&quot;}</code></pre>
      or, with implicit prompt:
      <pre><code>{&quot;chosen&quot;: &quot;The sky is blue.&quot;,
 &quot;rejected&quot;: &quot;The sky is green.&quot;}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}],
 &quot;chosen&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}],
 &quot;rejected&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is green.&quot;}]}</code></pre>
      or, with implicit prompt:
      <pre><code>{&quot;chosen&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;},
              {&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}],
 &quot;rejected&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;},
                {&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is green.&quot;}]}</code></pre></td></tr> <tr><td>Unpaired preference</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;,
 &quot;completion&quot;: &quot; blue.&quot;,
 &quot;label&quot;: True}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}],
 &quot;completion&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is green.&quot;}],
 &quot;label&quot;: False}</code></pre></td></tr> <tr><td>Stepwise supervision</td> <td><pre><code>{&quot;prompt&quot;: &quot;Which number is larger, 9.8 or 9.11?&quot;,
 &quot;completions&quot;: [&quot;The fractional part of 9.8 is 0.8.&quot;, 
                 &quot;The fractional part of 9.11 is 0.11.&quot;,
                 &quot;0.11 is greater than 0.8.&quot;,
                 &quot;Hence, 9.11 &gt; 9.8.&quot;],
 &quot;labels&quot;: [True, True, False, False]}</code></pre></td> <td></td></tr></tbody>`,Al,E,xl,V,Bl,W,An="The standard dataset format typically consists of plain text strings. The columns in the dataset vary depending on the task. This is the format expected by TRL trainers. Below are examples of standard dataset formats for different tasks:",Gl,z,Zl,S,vl,Y,xn="Conversational datasets are used for tasks involving dialogues or chat interactions between users and assistants. Unlike standard dataset formats, these contain sequences of messages where each message has a <code>role</code> (e.g., <code>&quot;user&quot;</code> or <code>&quot;assistant&quot;</code>) and <code>content</code> (the message text).",Xl,F,kl,_,Bn="Just like standard datasets, the columns in conversational datasets vary depending on the task. Below are examples of conversational dataset formats for different tasks:",Rl,H,El,L,Gn='Conversational datasets are useful for training chat models, but must be converted into a standard format before being used with TRL trainers. This is typically done using chat templates specific to the model being used. For more information, refer to the <a href="#working-with-conversational-datasets-in-trl">Working with conversational datasets in TRL</a> section.',Vl,D,Wl,P,zl,K,Zn="A language modeling dataset consists of a column <code>&quot;text&quot;</code> (or <code>&quot;messages&quot;</code> for conversational datasets) containing a full sequence of text.",Sl,O,Yl,tt,Fl,st,vn="In a prompt-only dataset, only the initial prompt (the question or partial sentence) is provided under the key <code>&quot;prompt&quot;</code>. The training typically involves generating the completion based on this prompt, where the model learns to continue or complete the given input.",_l,lt,Hl,et,Xn='For examples of prompt-only datasets, refer to the <a href="https://huggingface.co/collections/trl-lib/prompt-only-datasets-677ea25245d20252cea00368" rel="nofollow">Prompt-only datasets collection</a>.',Ll,x,Dl,at,Pl,nt,kn="A prompt-completion dataset includes a <code>&quot;prompt&quot;</code> and a <code>&quot;completion&quot;</code>.",Kl,pt,Ol,ot,Rn='For examples of prompt-completion datasets, refer to the <a href="https://huggingface.co/collections/trl-lib/prompt-completion-datasets-677ea2bb20bbb6bdccada216" rel="nofollow">Prompt-completion datasets collection</a>.',te,it,se,rt,En=`A preference dataset is used for tasks where the model is trained to choose between two or more possible completions to the same prompt. This dataset includes a <code>&quot;prompt&quot;</code>, a <code>&quot;chosen&quot;</code> completion, and a <code>&quot;rejected&quot;</code> completion. The model is trained to select the <code>&quot;chosen&quot;</code> response over the <code>&quot;rejected&quot;</code> response.
Some dataset may not include the <code>&quot;prompt&quot;</code> column, in which case the prompt is implicit and directly included in the <code>&quot;chosen&quot;</code> and <code>&quot;rejected&quot;</code> completions. We recommend using explicit prompts whenever possible.`,le,Mt,ee,ct,Vn='For examples of preference datasets, refer to the <a href="https://huggingface.co/collections/trl-lib/preference-datasets-677e99b581018fcad9abd82c" rel="nofollow">Preference datasets collection</a>.',ae,ut,Wn='Some preference datasets can be found with <a href="https://huggingface.co/datasets?other=dpo" rel="nofollow">the tag <code>dpo</code> on Hugging Face Hub</a>. You can also explore the <a href="https://huggingface.co/collections/librarian-bots/direct-preference-optimization-datasets-66964b12835f46289b6ef2fc" rel="nofollow">librarian-bots’ DPO Collections</a> to identify preference datasets.',ne,yt,pe,jt,zn="An unpaired preference dataset is similar to a preference dataset but instead of having <code>&quot;chosen&quot;</code> and <code>&quot;rejected&quot;</code> completions for the same prompt, it includes a single <code>&quot;completion&quot;</code> and a <code>&quot;label&quot;</code> indicating whether the completion is preferred or not.",oe,Jt,ie,ht,Sn='For examples of unpaired preference datasets, refer to the <a href="https://huggingface.co/collections/trl-lib/unpaired-preference-datasets-677ea22bf5f528c125b0bcdf" rel="nofollow">Unpaired preference datasets collection</a>.',re,Ut,Me,mt,Yn='A stepwise (or process) supervision dataset is similar to an <a href="#unpaired-preference">unpaired preference</a> dataset but includes multiple steps of completions, each with its own label. This structure is useful for tasks that need detailed, step-by-step labeling, such as reasoning tasks. By evaluating each step separately and providing targeted labels, this approach helps identify precisely where the reasoning is correct and where errors occur, allowing for targeted feedback on each part of the reasoning process.',ce,dt,ue,Tt,Fn='For examples of stepwise supervision datasets, refer to the <a href="https://huggingface.co/collections/trl-lib/stepwise-supervision-datasets-677ea27fd4c5941beed7a96e" rel="nofollow">Stepwise supervision datasets collection</a>.',ye,It,je,wt,_n="Choosing the right dataset type depends on the task you are working on and the specific requirements of the TRL trainer you are using. Below is a brief overview of the dataset types supported by each TRL trainer.",Je,qt,Hn='<thead><tr><th>Trainer</th> <th>Expected dataset type</th></tr></thead> <tbody><tr><td><a href="/docs/trl/v0.15.1/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a></td> <td><a href="#unpaired-preference">Unpaired preference</a></td></tr> <tr><td><a href="/docs/trl/v0.15.1/en/cpo_trainer#trl.CPOTrainer">CPOTrainer</a></td> <td><a href="#preference">Preference (explicit prompt recommended)</a></td></tr> <tr><td><a href="/docs/trl/v0.15.1/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a></td> <td><a href="#preference">Preference (explicit prompt recommended)</a></td></tr> <tr><td><a href="/docs/trl/v0.15.1/en/gkd_trainer#trl.GKDTrainer">GKDTrainer</a></td> <td><a href="#prompt-completion">Prompt-completion</a></td></tr> <tr><td><a href="/docs/trl/v0.15.1/en/grpo_trainer#trl.GRPOTrainer">GRPOTrainer</a></td> <td><a href="#prompt-only">Prompt-only</a></td></tr> <tr><td><a href="/docs/trl/v0.15.1/en/iterative_sft_trainer#trl.IterativeSFTTrainer">IterativeSFTTrainer</a></td> <td><a href="#unpaired-preference">Unpaired preference</a></td></tr> <tr><td><a href="/docs/trl/v0.15.1/en/kto_trainer#trl.KTOTrainer">KTOTrainer</a></td> <td><a href="#unpaired-preference">Unpaired preference</a> or <a href="#preference">Preference (explicit prompt recommended)</a></td></tr> <tr><td><a href="/docs/trl/v0.15.1/en/nash_md_trainer#trl.NashMDTrainer">NashMDTrainer</a></td> <td><a href="#prompt-only">Prompt-only</a></td></tr> <tr><td><a href="/docs/trl/v0.15.1/en/online_dpo_trainer#trl.OnlineDPOTrainer">OnlineDPOTrainer</a></td> <td><a href="#prompt-only">Prompt-only</a></td></tr> <tr><td><a href="/docs/trl/v0.15.1/en/orpo_trainer#trl.ORPOTrainer">ORPOTrainer</a></td> <td><a href="#preference">Preference (explicit prompt recommended)</a></td></tr> <tr><td><a href="/docs/trl/v0.15.1/en/ppo_trainer#trl.PPOTrainer">PPOTrainer</a></td> <td>Tokenized language modeling</td></tr> <tr><td><a href="/docs/trl/v0.15.1/en/prm_trainer#trl.PRMTrainer">PRMTrainer</a></td> <td><a href="#stepwise-supervision">Stepwise supervision</a></td></tr> <tr><td><a href="/docs/trl/v0.15.1/en/reward_trainer#trl.RewardTrainer">RewardTrainer</a></td> <td><a href="#preference">Preference (implicit prompt recommended)</a></td></tr> <tr><td><a href="/docs/trl/v0.15.1/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a></td> <td><a href="#language-modeling">Language modeling</a></td></tr> <tr><td><a href="/docs/trl/v0.15.1/en/xpo_trainer#trl.XPOTrainer">XPOTrainer</a></td> <td><a href="#prompt-only">Prompt-only</a></td></tr></tbody>',he,B,Ue,gt,me,ft,Ln=`Conversational datasets are increasingly common, especially for training chat models. However, some TRL trainers don’t support conversational datasets in their raw format. (For more information, see <a href="https://github.com/huggingface/trl/issues/2071" rel="nofollow">issue #2071</a>.) These datasets must first be converted into a standard format.
Fortunately, TRL offers tools to easily handle this conversion, which are detailed below.`,de,bt,Te,Ct,Dn="To convert a conversational dataset into a standard dataset, you need to <em>apply a chat template</em> to the dataset. A chat template is a predefined structure that typically includes placeholders for user and assistant messages. This template is provided by the tokenizer of the model you use.",Ie,$t,Pn='For detailed instructions on using chat templating, refer to the <a href="https://huggingface.co/docs/transformers/en/chat_templating" rel="nofollow">Chat templating section in the <code>transformers</code> documentation</a>.',we,Qt,Kn='In TRL, the method you apply to convert the dataset will vary depending on the task. Fortunately, TRL provides a helper function called <a href="/docs/trl/v0.15.1/en/data_utils#trl.apply_chat_template">apply_chat_template()</a> to simplify this process. Here’s an example of how to use it:',qe,Nt,ge,At,On='Alternatively, you can use the <a href="https://huggingface.co/docs/datasets/v3.3.2/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> method to apply the template across an entire dataset:',fe,xt,be,G,Ce,Z,$e,Bt,Qe,Gt,tp="Many datasets come in formats tailored to specific tasks, which might not be directly compatible with TRL. To use such datasets with TRL, you may need to preprocess and convert them into the required format.",Ne,Zt,sp='To make this easier, we provide a set of <a href="https://github.com/huggingface/trl/tree/main/examples/datasets" rel="nofollow">example scripts</a> that cover common dataset conversions.',Ae,vt,xe,Xt,lp='Let’s take the <a href="https://huggingface.co/datasets/openbmb/UltraFeedback" rel="nofollow">UltraFeedback dataset</a> as an example. Here’s a preview of the dataset:',Be,Q,ep,Ge,kt,ap="As shown above, the dataset format does not match the expected structure. It’s not in a conversational format, the column names differ, and the results pertain to different models (e.g., Bard, GPT-4) and aspects (e.g., “helpfulness”, “honesty”).",Ze,Rt,np='By using the provided conversion script <a href="https://github.com/huggingface/trl/tree/main/examples/datasets/ultrafeedback.py" rel="nofollow"><code>examples/datasets/ultrafeedback.py</code></a>, you can transform this dataset into an unpaired preference type, and push it to the Hub:',ve,Et,Xe,Vt,pp="Once converted, the dataset will look like this:",ke,N,op,Re,Wt,ip="Now, you can use this dataset with TRL!",Ee,zt,rp="By adapting the provided scripts or creating your own, you can convert any dataset into a format compatible with TRL.",Ve,St,We,Yt,Mp="This section provides example code to help you convert between different dataset types. While some conversions can be performed after applying the chat template (i.e., in the standard format), we recommend performing the conversion before applying the chat template to ensure it works consistently.",ze,Ft,cp="For simplicity, some of the examples below do not follow this recommendation and use the standard format. However, the conversions can be applied directly to the conversational format without modification.",Se,_t,up='<thead><tr><th>From \\ To</th> <th>Language modeling</th> <th>Prompt-completion</th> <th>Prompt-only</th> <th>Preference with implicit prompt</th> <th>Preference</th> <th>Unpaired preference</th> <th>Stepwise supervision</th></tr></thead> <tbody><tr><td>Language modeling</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr> <tr><td>Prompt-completion</td> <td><a href="#from-prompt-completion-to-language-modeling-dataset">🔗</a></td> <td>N/A</td> <td><a href="#from-prompt-completion-to-prompt-only-dataset">🔗</a></td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr> <tr><td>Prompt-only</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr> <tr><td>Preference with implicit prompt</td> <td><a href="#from-preference-with-implicit-prompt-to-language-modeling-dataset">🔗</a></td> <td><a href="#from-preference-with-implicit-prompt-to-prompt-completion-dataset">🔗</a></td> <td><a href="#from-preference-with-implicit-prompt-to-prompt-only-dataset">🔗</a></td> <td>N/A</td> <td><a href="#from-implicit-to-explicit-prompt-preference-dataset">🔗</a></td> <td><a href="#from-preference-with-implicit-prompt-to-unpaired-preference-dataset">🔗</a></td> <td>N/A</td></tr> <tr><td>Preference</td> <td><a href="#from-preference-to-language-modeling-dataset">🔗</a></td> <td><a href="#from-preference-to-prompt-completion-dataset">🔗</a></td> <td><a href="#from-preference-to-prompt-only-dataset">🔗</a></td> <td><a href="#from-explicit-to-implicit-prompt-preference-dataset">🔗</a></td> <td>N/A</td> <td><a href="#from-preference-to-unpaired-preference-dataset">🔗</a></td> <td>N/A</td></tr> <tr><td>Unpaired preference</td> <td><a href="#from-unpaired-preference-to-language-modeling-dataset">🔗</a></td> <td><a href="#from-unpaired-preference-to-prompt-completion-dataset">🔗</a></td> <td><a href="#from-unpaired-preference-to-prompt-only-dataset">🔗</a></td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr> <tr><td>Stepwise supervision</td> <td><a href="#from-stepwise-supervision-to-language-modeling-dataset">🔗</a></td> <td><a href="#from-stepwise-supervision-to-prompt-completion-dataset">🔗</a></td> <td><a href="#from-stepwise-supervision-to-prompt-only-dataset">🔗</a></td> <td>N/A</td> <td>N/A</td> <td><a href="#from-stepwise-supervision-to-unpaired-preference-dataset">🔗</a></td> <td>N/A</td></tr></tbody>',Ye,Ht,Fe,Lt,yp="To convert a prompt-completion dataset into a language modeling dataset, concatenate the prompt and the completion.",_e,Dt,He,Pt,Le,Kt,De,Ot,jp="To convert a prompt-completion dataset into a prompt-only dataset, remove the completion.",Pe,ts,Ke,ss,Oe,ls,ta,es,Jp="To convert a preference with implicit prompt dataset into a language modeling dataset, remove the rejected, and rename the column <code>&quot;chosen&quot;</code> to <code>&quot;text&quot;</code>.",sa,as,la,ns,ea,ps,aa,os,hp='To convert a preference dataset with implicit prompt into a prompt-completion dataset, extract the prompt with <a href="/docs/trl/v0.15.1/en/data_utils#trl.extract_prompt">extract_prompt()</a>, remove the rejected, and rename the column <code>&quot;chosen&quot;</code> to <code>&quot;completion&quot;</code>.',na,is,pa,rs,oa,Ms,ia,cs,Up='To convert a preference dataset with implicit prompt into a prompt-only dataset, extract the prompt with <a href="/docs/trl/v0.15.1/en/data_utils#trl.extract_prompt">extract_prompt()</a>, and remove the rejected and the chosen.',ra,us,Ma,ys,ca,js,ua,Js,mp='To convert a preference dataset with implicit prompt into a preference dataset with explicit prompt, extract the prompt with <a href="/docs/trl/v0.15.1/en/data_utils#trl.extract_prompt">extract_prompt()</a>.',ya,hs,ja,Us,Ja,ms,ha,ds,dp='To convert a preference dataset with implicit prompt into an unpaired preference dataset, extract the prompt with <a href="/docs/trl/v0.15.1/en/data_utils#trl.extract_prompt">extract_prompt()</a>, and unpair the dataset with <a href="/docs/trl/v0.15.1/en/data_utils#trl.unpair_preference_dataset">unpair_preference_dataset()</a>.',Ua,Ts,ma,Is,da,v,Ta,ws,Ia,qs,Tp="To convert a preference dataset into a language modeling dataset, remove the rejected, concatenate the prompt and the chosen into the <code>&quot;text&quot;</code> column.",wa,gs,qa,fs,ga,bs,fa,Cs,Ip="To convert a preference dataset into a prompt-completion dataset, remove the rejected, and rename the column <code>&quot;chosen&quot;</code> to <code>&quot;completion&quot;</code>.",ba,$s,Ca,Qs,$a,Ns,Qa,As,wp="To convert a preference dataset into a prompt-only dataset, remove the rejected and the chosen.",Na,xs,Aa,Bs,xa,Gs,Ba,Zs,qp="To convert a preference dataset with explicit prompt into a preference dataset with implicit prompt, concatenate the prompt to both chosen and rejected, and remove the prompt.",Ga,vs,Za,Xs,va,ks,Xa,Rs,gp='To convert dataset into an unpaired preference dataset, unpair the dataset with <a href="/docs/trl/v0.15.1/en/data_utils#trl.unpair_preference_dataset">unpair_preference_dataset()</a>.',ka,Es,Ra,Vs,Ea,X,Va,Ws,Wa,zs,fp="To convert an unpaired preference dataset into a language modeling dataset, concatenate prompts with good completions into the <code>&quot;text&quot;</code> column, and remove the prompt, completion and label columns.",za,Ss,Sa,Ys,Ya,Fs,Fa,_s,bp="To convert an unpaired preference dataset into a prompt-completion dataset, filter for good labels, then remove the label columns.",_a,Hs,Ha,Ls,La,Ds,Da,Ps,Cp="To convert an unpaired preference dataset into a prompt-only dataset, remove the completion and the label columns.",Pa,Ks,Ka,Os,Oa,tl,tn,sl,$p="To convert a stepwise supervision dataset into a language modeling dataset, concatenate prompts with good completions into the <code>&quot;text&quot;</code> column.",sn,ll,ln,el,en,al,an,nl,Qp="To convert a stepwise supervision dataset into a prompt-completion dataset, join the good completions and remove the labels.",nn,pl,pn,ol,on,il,rn,rl,Np="To convert a stepwise supervision dataset into a prompt-only dataset, remove the completions and the labels.",Mn,Ml,cn,cl,un,ul,yn,yl,Ap="To convert a stepwise supervision dataset into an unpaired preference dataset, join the completions and merge the labels.",jn,jl,xp="The method for merging the labels depends on the specific task. In this example, we use the logical AND operation. This means that if the step labels indicate the correctness of individual steps, the resulting label will reflect the correctness of the entire sequence.",Jn,Jl,hn,hl,Un,Ul,mn,ml,Bp="Some trainers also support fine-tuning vision-language models (VLMs) using image-text pairs. In this scenario, it’s recommended to use a conversational format, as each model handles image placeholders in text differently.",dn,dl,Gp="A conversational vision dataset differs from a standard conversational dataset in two key ways:",Tn,Tl,Zp="<li>The dataset must contain the key <code>images</code> with the image data.</li> <li>The <code>&quot;content&quot;</code> field in messages must be a list of dictionaries, where each dictionary specifies the type of data: <code>&quot;image&quot;</code> or <code>&quot;text&quot;</code>.</li>",In,Il,vp="Example:",wn,wl,qn,ql,Xp='An example of a conversational vision dataset is the <a href="https://huggingface.co/datasets/openbmb/RLAIF-V-Dataset" rel="nofollow">openbmb/RLAIF-V-Dataset</a>. Below is an embedded view of the dataset’s training data, allowing you to explore it directly:',gn,A,kp,fn,gl,bn,Cl,Cn;return g=new d({props:{title:"Dataset formats and types",local:"dataset-formats-and-types",headingTag:"h1"}}),q=new d({props:{title:"Overview of the dataset formats and types",local:"overview-of-the-dataset-formats-and-types",headingTag:"h2"}}),E=new d({props:{title:"Formats",local:"formats",headingTag:"h3"}}),V=new d({props:{title:"Standard",local:"standard",headingTag:"h4"}}),z=new h({props:{code:"JTIzJTIwTGFuZ3VhZ2UlMjBtb2RlbGluZyUwQWxhbmd1YWdlX21vZGVsaW5nX2V4YW1wbGUlMjAlM0QlMjAlN0IlMjJ0ZXh0JTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjBibHVlLiUyMiU3RCUwQSUyMyUyMFByZWZlcmVuY2UlMEFwcmVmZXJlbmNlX2V4YW1wbGUlMjAlM0QlMjAlN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMmNob3NlbiUyMiUzQSUyMCUyMiUyMGJsdWUuJTIyJTJDJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlMjIlMjBncmVlbi4lMjIlN0QlMEElMjMlMjBVbnBhaXJlZCUyMHByZWZlcmVuY2UlMEF1bnBhaXJlZF9wcmVmZXJlbmNlX2V4YW1wbGUlMjAlM0QlMjAlN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlMjBibHVlLiUyMiUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwVHJ1ZSU3RA==",highlighted:`<span class="hljs-comment"># Language modeling</span>
language_modeling_example = {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;The sky is blue.&quot;</span>}
<span class="hljs-comment"># Preference</span>
preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot; green.&quot;</span>}
<span class="hljs-comment"># Unpaired preference</span>
unpaired_preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">True</span>}`,wrap:!1}}),S=new d({props:{title:"Conversational",local:"conversational",headingTag:"h4"}}),F=new h({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
]`,wrap:!1}}),H=new h({props:{code:"JTIzJTIwUHJvbXB0LWNvbXBsZXRpb24lMEFwcm9tcHRfY29tcGxldGlvbl9leGFtcGxlJTIwJTNEJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwYmx1ZS4lMjIlN0QlNUQlN0QlMEElMjMlMjBQcmVmZXJlbmNlJTBBcHJlZmVyZW5jZV9leGFtcGxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBibHVlLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlamVjdGVkJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwZ3JlZW4uJTIyJTdEJTVEJTJDJTBBJTdE",highlighted:`<span class="hljs-comment"># Prompt-completion</span>
prompt_completion_example = {<span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
                             <span class="hljs-string">&quot;completion&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}]}
<span class="hljs-comment"># Preference</span>
preference_example = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
    <span class="hljs-string">&quot;chosen&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
    <span class="hljs-string">&quot;rejected&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
}`,wrap:!1}}),D=new d({props:{title:"Types",local:"types",headingTag:"h3"}}),P=new d({props:{title:"Language modeling",local:"language-modeling",headingTag:"h4"}}),O=new h({props:{code:"JTIzJTIwU3RhbmRhcmQlMjBmb3JtYXQlMEFsYW5ndWFnZV9tb2RlbGluZ19leGFtcGxlJTIwJTNEJTIwJTdCJTIydGV4dCUyMiUzQSUyMCUyMlRoZSUyMHNreSUyMGlzJTIwYmx1ZS4lMjIlN0QlMEElMjMlMjBDb252ZXJzYXRpb25hbCUyMGZvcm1hdCUwQWxhbmd1YWdlX21vZGVsaW5nX2V4YW1wbGUlMjAlM0QlMjAlN0IlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwYmx1ZS4lMjIlN0QlMEElNUQlN0Q=",highlighted:`<span class="hljs-comment"># Standard format</span>
language_modeling_example = {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;The sky is blue.&quot;</span>}
<span class="hljs-comment"># Conversational format</span>
language_modeling_example = {<span class="hljs-string">&quot;messages&quot;</span>: [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}
]}`,wrap:!1}}),tt=new d({props:{title:"Prompt-only",local:"prompt-only",headingTag:"h4"}}),lt=new h({props:{code:"JTIzJTIwU3RhbmRhcmQlMjBmb3JtYXQlMEFwcm9tcHRfb25seV9leGFtcGxlJTIwJTNEJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlN0QlMEElMjMlMjBDb252ZXJzYXRpb25hbCUyMGZvcm1hdCUwQXByb21wdF9vbmx5X2V4YW1wbGUlMjAlM0QlMjAlN0IlMjJwcm9tcHQlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCU1RCU3RA==",highlighted:`<span class="hljs-comment"># Standard format</span>
prompt_only_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>}
<span class="hljs-comment"># Conversational format</span>
prompt_only_example = {<span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}]}`,wrap:!1}}),x=new fl({props:{$$slots:{default:[Kp]},$$scope:{ctx:f}}}),at=new d({props:{title:"Prompt-completion",local:"prompt-completion",headingTag:"h4"}}),pt=new h({props:{code:"JTIzJTIwU3RhbmRhcmQlMjBmb3JtYXQlMEFwcm9tcHRfY29tcGxldGlvbl9leGFtcGxlJTIwJTNEJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTIyJTIwYmx1ZS4lMjIlN0QlMEElMjMlMjBDb252ZXJzYXRpb25hbCUyMGZvcm1hdCUwQXByb21wdF9jb21wbGV0aW9uX2V4YW1wbGUlMjAlM0QlMjAlN0IlMjJwcm9tcHQlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBibHVlLiUyMiU3RCU1RCU3RA==",highlighted:`<span class="hljs-comment"># Standard format</span>
prompt_completion_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>}
<span class="hljs-comment"># Conversational format</span>
prompt_completion_example = {<span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
                             <span class="hljs-string">&quot;completion&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}]}`,wrap:!1}}),it=new d({props:{title:"Preference",local:"preference",headingTag:"h4"}}),Mt=new h({props:{code:"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",highlighted:`<span class="hljs-comment"># Standard format</span>
<span class="hljs-comment">## Explicit prompt (recommended)</span>
preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot; green.&quot;</span>}
<span class="hljs-comment"># Implicit prompt</span>
preference_example = {<span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot;The sky is blue.&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot;The sky is green.&quot;</span>}

<span class="hljs-comment"># Conversational format</span>
<span class="hljs-comment">## Explicit prompt (recommended)</span>
preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
                      <span class="hljs-string">&quot;chosen&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
                      <span class="hljs-string">&quot;rejected&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}]}
<span class="hljs-comment">## Implicit prompt</span>
preference_example = {<span class="hljs-string">&quot;chosen&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>},
                                 {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
                      <span class="hljs-string">&quot;rejected&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>},
                                   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}]}`,wrap:!1}}),yt=new d({props:{title:"Unpaired preference",local:"unpaired-preference",headingTag:"h4"}}),Jt=new h({props:{code:"JTIzJTIwU3RhbmRhcmQlMjBmb3JtYXQlMEF1bnBhaXJlZF9wcmVmZXJlbmNlX2V4YW1wbGUlMjAlM0QlMjAlN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlMjBibHVlLiUyMiUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwVHJ1ZSU3RCUwQSUyMyUyMENvbnZlcnNhdGlvbmFsJTIwZm9ybWF0JTBBdW5wYWlyZWRfcHJlZmVyZW5jZV9leGFtcGxlJTIwJTNEJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwYmx1ZS4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYWJlbCUyMiUzQSUyMFRydWUlN0Q=",highlighted:`<span class="hljs-comment"># Standard format</span>
unpaired_preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">True</span>}
<span class="hljs-comment"># Conversational format</span>
unpaired_preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
                               <span class="hljs-string">&quot;completion&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
                               <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">True</span>}`,wrap:!1}}),Ut=new d({props:{title:"Stepwise supervision",local:"stepwise-supervision",headingTag:"h4"}}),dt=new h({props:{code:"c3RlcHdpc2VfZXhhbXBsZSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCUyMldoaWNoJTIwbnVtYmVyJTIwaXMlMjBsYXJnZXIlMkMlMjA5LjglMjBvciUyMDkuMTElM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjb21wbGV0aW9ucyUyMiUzQSUyMCU1QiUyMlRoZSUyMGZyYWN0aW9uYWwlMjBwYXJ0JTIwb2YlMjA5LjglMjBpcyUyMDAuOCUyQyUyMHdoaWxlJTIwdGhlJTIwZnJhY3Rpb25hbCUyMHBhcnQlMjBvZiUyMDkuMTElMjBpcyUyMDAuMTEuJTIyJTJDJTIwJTIyU2luY2UlMjAwLjExJTIwaXMlMjBncmVhdGVyJTIwdGhhbiUyMDAuOCUyQyUyMHRoZSUyMG51bWJlciUyMDkuMTElMjBpcyUyMGxhcmdlciUyMHRoYW4lMjA5LjguJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIybGFiZWxzJTIyJTNBJTIwJTVCVHJ1ZSUyQyUyMEZhbHNlJTVEJTBBJTdE",highlighted:`stepwise_example = {
    <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;Which number is larger, 9.8 or 9.11?&quot;</span>,
    <span class="hljs-string">&quot;completions&quot;</span>: [<span class="hljs-string">&quot;The fractional part of 9.8 is 0.8, while the fractional part of 9.11 is 0.11.&quot;</span>, <span class="hljs-string">&quot;Since 0.11 is greater than 0.8, the number 9.11 is larger than 9.8.&quot;</span>],
    <span class="hljs-string">&quot;labels&quot;</span>: [<span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>]
}`,wrap:!1}}),It=new d({props:{title:"Which dataset type to use?",local:"which-dataset-type-to-use",headingTag:"h2"}}),B=new fl({props:{$$slots:{default:[Op]},$$scope:{ctx:f}}}),gt=new d({props:{title:"Working with conversational datasets in TRL",local:"working-with-conversational-datasets-in-trl",headingTag:"h2"}}),bt=new d({props:{title:"Converting a conversational dataset into a standard dataset",local:"converting-a-conversational-dataset-into-a-standard-dataset",headingTag:"h3"}}),Nt=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwYXBwbHlfY2hhdF90ZW1wbGF0ZSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktMTI4ay1pbnN0cnVjdCUyMiklMEElMEFleGFtcGxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwYmx1ZS4lMjIlN0QlNUQlMEElN0QlMEElMEFhcHBseV9jaGF0X3RlbXBsYXRlKGV4YW1wbGUlMkMlMjB0b2tlbml6ZXIpJTBBJTIzJTIwT3V0cHV0JTNBJTBBJTIzJTIwJTdCJ3Byb21wdCclM0ElMjAnJTNDJTdDdXNlciU3QyUzRSU1Q25XaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0Nhc3Npc3RhbnQlN0MlM0UlNUNuJyUyQyUyMCdjb21wbGV0aW9uJyUzQSUyMCdJdCUyMGlzJTIwYmx1ZS4lM0MlN0NlbmQlN0MlM0UlNUNuJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJyU3RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> apply_chat_template

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-128k-instruct&quot;</span>)

example = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
    <span class="hljs-string">&quot;completion&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}]
}

apply_chat_template(example, tokenizer)
<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># {&#x27;prompt&#x27;: &#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;, &#x27;completion&#x27;: &#x27;It is blue.&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;}</span>`,wrap:!1}}),xt=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBhcHBseV9jaGF0X3RlbXBsYXRlJTBBJTBBZGF0YXNldF9kaWN0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTVCJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGVyZSUyMGlzJTIwdGhlJTIwc3VuJTNGJTIyJTdEJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCU1QiU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJbiUyMHRoZSUyMHNreS4lMjIlN0QlNUQlNUQlMEElN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoZGF0YXNldF9kaWN0KSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChhcHBseV9jaGF0X3RlbXBsYXRlJTJDJTIwZm5fa3dhcmdzJTNEJTdCJTIydG9rZW5pemVyJTIyJTNBJTIwdG9rZW5pemVyJTdEKSUwQSUyMyUyME91dHB1dCUzQSUwQSUyMyUyMCU3Qidwcm9tcHQnJTNBJTIwJTVCJyUzQyU3Q3VzZXIlN0MlM0UlNUNuV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlM0MlN0NlbmQlN0MlM0UlNUNuJTNDJTdDYXNzaXN0YW50JTdDJTNFJTVDbiclMkMlMEElMjMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnJTNDJTdDdXNlciU3QyUzRSU1Q25XaGVyZSUyMGlzJTIwdGhlJTIwc3VuJTNGJTNDJTdDZW5kJTdDJTNFJTVDbiUzQyU3Q2Fzc2lzdGFudCU3QyUzRSU1Q24nJTVEJTJDJTBBJTIzJTIwJTIwJ2NvbXBsZXRpb24nJTNBJTIwJTVCJ0l0JTIwaXMlMjBibHVlLiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0NlbmRvZnRleHQlN0MlM0UnJTJDJTIwJ0luJTIwdGhlJTIwc2t5LiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0NlbmRvZnRleHQlN0MlM0UnJTVEJTdE",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> apply_chat_template

dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
               [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}]],
    <span class="hljs-string">&quot;completion&quot;</span>: [[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
                   [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}]]
}

dataset = Dataset.from_dict(dataset_dict)
dataset = dataset.<span class="hljs-built_in">map</span>(apply_chat_template, fn_kwargs={<span class="hljs-string">&quot;tokenizer&quot;</span>: tokenizer})
<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># {&#x27;prompt&#x27;: [&#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;,</span>
<span class="hljs-comment">#             &#x27;&lt;|user|&gt;\\nWhere is the sun?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;],</span>
<span class="hljs-comment">#  &#x27;completion&#x27;: [&#x27;It is blue.&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;, &#x27;In the sky.&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;]}</span>`,wrap:!1}}),G=new fl({props:{warning:!0,$$slots:{default:[to]},$$scope:{ctx:f}}}),Z=new fl({props:{warning:!0,$$slots:{default:[so]},$$scope:{ctx:f}}}),Bt=new d({props:{title:"Using any dataset with TRL: preprocessing and conversion",local:"using-any-dataset-with-trl-preprocessing-and-conversion",headingTag:"h2"}}),vt=new d({props:{title:"Example: UltraFeedback dataset",local:"example-ultrafeedback-dataset",headingTag:"h3"}}),Et=new h({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZkYXRhc2V0cyUyRnVsdHJhZmVlZGJhY2sucHklMjAtLXB1c2hfdG9faHViJTIwLS1yZXBvX2lkJTIwdHJsLWxpYiUyRnVsdHJhZmVlZGJhY2stZ3B0LTMuNS10dXJiby1oZWxwZnVsbmVzcw==",highlighted:"python examples/datasets/ultrafeedback.py --push_to_hub --repo_id trl-lib/ultrafeedback-gpt-3.5-turbo-helpfulness",wrap:!1}}),St=new d({props:{title:"Utilities for converting dataset types",local:"utilities-for-converting-dataset-types",headingTag:"h2"}}),Ht=new d({props:{title:"From prompt-completion to language modeling dataset",local:"from-prompt-completion-to-language-modeling-dataset",headingTag:"h3"}}),Dt=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCU1QiUyMiUyMGJsdWUuJTIyJTJDJTIwJTIyJTIwaW4lMjB0aGUlMjBza3kuJTIyJTVEJTJDJTBBJTdEKSUwQSUwQWRlZiUyMGNvbmNhdF9wcm9tcHRfY29tcGxldGlvbihleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnRleHQlMjIlM0ElMjBleGFtcGxlJTVCJTIycHJvbXB0JTIyJTVEJTIwJTJCJTIwZXhhbXBsZSU1QiUyMmNvbXBsZXRpb24lMjIlNUQlN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY29uY2F0X3Byb21wdF9jb21wbGV0aW9uJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0QlNUIlMjJwcm9tcHQlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concat_prompt_completion</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;completion&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(concat_prompt_completion, remove_columns=[<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>])`,wrap:!1}}),Pt=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),Kt=new d({props:{title:"From prompt-completion to prompt-only dataset",local:"from-prompt-completion-to-prompt-only-dataset",headingTag:"h3"}}),ts=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCU1QiUyMiUyMGJsdWUuJTIyJTJDJTIwJTIyJTIwaW4lMjB0aGUlMjBza3kuJTIyJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCUyMmNvbXBsZXRpb24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
})

dataset = dataset.remove_columns(<span class="hljs-string">&quot;completion&quot;</span>)`,wrap:!1}}),ss=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>}`,wrap:!1}}),ls=new d({props:{title:"From preference with implicit prompt to language modeling dataset",local:"from-preference-with-implicit-prompt-to-language-modeling-dataset",headingTag:"h3"}}),as=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMGJsdWUuJTIyJTJDJTIwJTIyVGhlJTIwc3VuJTIwaXMlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMlRoZSUyMHNreSUyMGlzJTIwZ3JlZW4uJTIyJTJDJTIwJTIyVGhlJTIwc3VuJTIwaXMlMjBpbiUyMHRoZSUyMHNlYS4lMjIlNUQlMkMlMEElN0QpJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVuYW1lX2NvbHVtbiglMjJjaG9zZW4lMjIlMkMlMjAlMjJ0ZXh0JTIyKS5yZW1vdmVfY29sdW1ucyglMjJyZWplY3RlZCUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot;The sky is blue.&quot;</span>, <span class="hljs-string">&quot;The sun is in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot;The sky is green.&quot;</span>, <span class="hljs-string">&quot;The sun is in the sea.&quot;</span>],
})

dataset = dataset.rename_column(<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>).remove_columns(<span class="hljs-string">&quot;rejected&quot;</span>)`,wrap:!1}}),ns=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),ps=new d({props:{title:"From preference with implicit prompt to prompt-completion dataset",local:"from-preference-with-implicit-prompt-to-prompt-completion-dataset",headingTag:"h3"}}),is=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoZXh0cmFjdF9wcm9tcHQpLnJlbW92ZV9jb2x1bW5zKCUyMnJlamVjdGVkJTIyKS5yZW5hbWVfY29sdW1uKCUyMmNob3NlbiUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})
dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt).remove_columns(<span class="hljs-string">&quot;rejected&quot;</span>).rename_column(<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>)`,wrap:!1}}),rs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}], <span class="hljs-string">&#x27;completion&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}]}`,wrap:!1}}),Ms=new d({props:{title:"From preference with implicit prompt to prompt-only dataset",local:"from-preference-with-implicit-prompt-to-prompt-only-dataset",headingTag:"h3"}}),us=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoZXh0cmFjdF9wcm9tcHQpLnJlbW92ZV9jb2x1bW5zKCU1QiUyMmNob3NlbiUyMiUyQyUyMCUyMnJlamVjdGVkJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})
dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt).remove_columns([<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>])`,wrap:!1}}),ys=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}]}`,wrap:!1}}),js=new d({props:{title:"From implicit to explicit prompt preference dataset",local:"from-implicit-to-explicit-prompt-preference-dataset",headingTag:"h3"}}),hs=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoZXh0cmFjdF9wcm9tcHQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt)`,wrap:!1}}),Us=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}],
 <span class="hljs-string">&#x27;chosen&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;rejected&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is green.&#x27;</span>}]}`,wrap:!1}}),ms=new d({props:{title:"From preference with implicit prompt to unpaired preference dataset",local:"from-preference-with-implicit-prompt-to-unpaired-preference-dataset",headingTag:"h3"}}),Ts=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUyQyUyMHVucGFpcl9wcmVmZXJlbmNlX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBibHVlLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2t5LiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlamVjdGVkJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBncmVlbi4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGVyZSUyMGlzJTIwdGhlJTIwc3VuJTNGJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJbiUyMHRoZSUyMHNlYS4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0QpJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGV4dHJhY3RfcHJvbXB0KSUwQWRhdGFzZXQlMjAlM0QlMjB1bnBhaXJfcHJlZmVyZW5jZV9kYXRhc2V0KGRhdGFzZXQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt, unpair_preference_dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt)
dataset = unpair_preference_dataset(dataset)`,wrap:!1}}),Is=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}],
 <span class="hljs-string">&#x27;completion&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-literal">True</span>}`,wrap:!1}}),v=new fl({props:{warning:!0,$$slots:{default:[lo]},$$scope:{ctx:f}}}),ws=new d({props:{title:"From preference to language modeling dataset",local:"from-preference-to-language-modeling-dataset",headingTag:"h3"}}),gs=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTIyJTIwYmx1ZS4lMjIlMkMlMjAlMjIlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSU3RCklMEElMEFkZWYlMjBjb25jYXRfcHJvbXB0X2Nob3NlbihleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnRleHQlMjIlM0ElMjBleGFtcGxlJTVCJTIycHJvbXB0JTIyJTVEJTIwJTJCJTIwZXhhbXBsZSU1QiUyMmNob3NlbiUyMiU1RCU3RCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChjb25jYXRfcHJvbXB0X2Nob3NlbiUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIycHJvbXB0JTIyJTJDJTIwJTIyY2hvc2VuJTIyJTJDJTIwJTIycmVqZWN0ZWQlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concat_prompt_chosen</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;chosen&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(concat_prompt_chosen, remove_columns=[<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>])`,wrap:!1}}),fs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),bs=new d({props:{title:"From preference to prompt-completion dataset",local:"from-preference-to-prompt-completion-dataset",headingTag:"h3"}}),$s=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTIyJTIwYmx1ZS4lMjIlMkMlMjAlMjIlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW1vdmVfY29sdW1ucyglMjJyZWplY3RlZCUyMikucmVuYW1lX2NvbHVtbiglMjJjaG9zZW4lMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
})

dataset = dataset.remove_columns(<span class="hljs-string">&quot;rejected&quot;</span>).rename_column(<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>)`,wrap:!1}}),Qs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>, <span class="hljs-string">&#x27;completion&#x27;</span>: <span class="hljs-string">&#x27; blue.&#x27;</span>}`,wrap:!1}}),Ns=new d({props:{title:"From preference to prompt-only dataset",local:"from-preference-to-prompt-only-dataset",headingTag:"h3"}}),xs=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTIyJTIwYmx1ZS4lMjIlMkMlMjAlMjIlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW1vdmVfY29sdW1ucyglNUIlMjJjaG9zZW4lMjIlMkMlMjAlMjJyZWplY3RlZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
})

dataset = dataset.remove_columns([<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>])`,wrap:!1}}),Bs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>}`,wrap:!1}}),Gs=new d({props:{title:"From explicit to implicit prompt preference dataset",local:"from-explicit-to-implicit-prompt-preference-dataset",headingTag:"h3"}}),vs=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBibHVlLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBncmVlbi4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEElMEFkZWYlMjBjb25jYXRfcHJvbXB0X3RvX2NvbXBsZXRpb25zKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyY2hvc2VuJTIyJTNBJTIwZXhhbXBsZSU1QiUyMnByb21wdCUyMiU1RCUyMCUyQiUyMGV4YW1wbGUlNUIlMjJjaG9zZW4lMjIlNUQlMkMlMjAlMjJyZWplY3RlZCUyMiUzQSUyMGV4YW1wbGUlNUIlMjJwcm9tcHQlMjIlNUQlMjAlMkIlMjBleGFtcGxlJTVCJTIycmVqZWN0ZWQlMjIlNUQlN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY29uY2F0X3Byb21wdF90b19jb21wbGV0aW9ucyUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTIycHJvbXB0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}],
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concat_prompt_to_completions</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;chosen&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;chosen&quot;</span>], <span class="hljs-string">&quot;rejected&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;rejected&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(concat_prompt_to_completions, remove_columns=<span class="hljs-string">&quot;prompt&quot;</span>)`,wrap:!1}}),Xs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;chosen&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;rejected&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is green.&#x27;</span>}]}`,wrap:!1}}),ks=new d({props:{title:"From preference to unpaired preference dataset",local:"from-preference-to-unpaired-preference-dataset",headingTag:"h3"}}),Es=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjB1bnBhaXJfcHJlZmVyZW5jZV9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJbiUyMHRoZSUyMHNreS4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBzZWEuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjB1bnBhaXJfcHJlZmVyZW5jZV9kYXRhc2V0KGRhdGFzZXQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> unpair_preference_dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}],
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

dataset = unpair_preference_dataset(dataset)`,wrap:!1}}),Vs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}],
 <span class="hljs-string">&#x27;completion&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-literal">True</span>}`,wrap:!1}}),X=new fl({props:{warning:!0,$$slots:{default:[eo]},$$scope:{ctx:f}}}),Ws=new d({props:{title:"From unpaired preference to language modeling dataset",local:"from-unpaired-preference-to-language-modeling-dataset",headingTag:"h3"}}),Ss=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTJDJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJUaGUlMjBzdW4lMjBpcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMjIlMjBibHVlLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2t5LiUyMiUyQyUyMCUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCVHJ1ZSUyQyUyMFRydWUlMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTVEJTJDJTBBJTdEKSUwQSUwQWRlZiUyMGNvbmNhdGVuYXRlX3Byb21wdF9jb21wbGV0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIydGV4dCUyMiUzQSUyMGV4YW1wbGUlNUIlMjJwcm9tcHQlMjIlNUQlMjAlMkIlMjBleGFtcGxlJTVCJTIyY29tcGxldGlvbiUyMiU1RCU3RCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihsYW1iZGElMjB4JTNBJTIweCU1QiUyMmxhYmVsJTIyJTVEKS5tYXAoY29uY2F0ZW5hdGVfcHJvbXB0X2NvbXBsZXRpb24pLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnByb21wdCUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIlMkMlMjAlMjJsYWJlbCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>, <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>, <span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
    <span class="hljs-string">&quot;label&quot;</span>: [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concatenate_prompt_completion</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;completion&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;label&quot;</span>]).<span class="hljs-built_in">map</span>(concatenate_prompt_completion).remove_columns([<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),Ys=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),Fs=new d({props:{title:"From unpaired preference to prompt-completion dataset",local:"from-unpaired-preference-to-prompt-completion-dataset",headingTag:"h3"}}),Hs=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTJDJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJUaGUlMjBzdW4lMjBpcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMjIlMjBibHVlLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2t5LiUyMiUyQyUyMCUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCVHJ1ZSUyQyUyMFRydWUlMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihsYW1iZGElMjB4JTNBJTIweCU1QiUyMmxhYmVsJTIyJTVEKS5yZW1vdmVfY29sdW1ucyglNUIlMjJsYWJlbCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>, <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>, <span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
    <span class="hljs-string">&quot;label&quot;</span>: [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>],
})

dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;label&quot;</span>]).remove_columns([<span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),Ls=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>, <span class="hljs-string">&#x27;completion&#x27;</span>: <span class="hljs-string">&#x27; blue.&#x27;</span>}`,wrap:!1}}),Ds=new d({props:{title:"From unpaired preference to prompt-only dataset",local:"from-unpaired-preference-to-prompt-only-dataset",headingTag:"h3"}}),Ks=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTJDJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJUaGUlMjBzdW4lMjBpcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMjIlMjBibHVlLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2t5LiUyMiUyQyUyMCUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCVHJ1ZSUyQyUyMFRydWUlMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMmNvbXBsZXRpb24lMjIlMkMlMjAlMjJsYWJlbCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>, <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>, <span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
    <span class="hljs-string">&quot;label&quot;</span>: [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>],
})

dataset = dataset.remove_columns([<span class="hljs-string">&quot;completion&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),Os=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>}`,wrap:!1}}),tl=new d({props:{title:"From stepwise supervision to language modeling dataset",local:"from-stepwise-supervision-to-language-modeling-dataset",headingTag:"h3"}}),ll=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJCbHVlJTIwbGlnaHQlMjIlMkMlMjAlMjJXYXRlciUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb25zJTIyJTNBJTIwJTVCJTVCJTIyJTIwc2NhdHRlcnMlMjBtb3JlJTIwaW4lMjB0aGUlMjBhdG1vc3BoZXJlJTJDJTIyJTJDJTIwJTIyJTIwc28lMjB0aGUlMjBza3klMjBpcyUyMGdyZWVuLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMiUyMGZvcm1zJTIwYSUyMGxlc3MlMjBkZW5zZSUyMHN0cnVjdHVyZSUyMGluJTIwaWNlJTJDJTIyJTJDJTIwJTIyJTIwd2hpY2glMjBjYXVzZXMlMjBpdCUyMHRvJTIwZXhwYW5kJTIwd2hlbiUyMGl0JTIwZnJlZXplcy4lMjIlNUQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJsYWJlbHMlMjIlM0ElMjAlNUIlNUJUcnVlJTJDJTIwRmFsc2UlNUQlMkMlMjAlNUJUcnVlJTJDJTIwVHJ1ZSU1RCU1RCUyQyUwQSU3RCklMEElMEFkZWYlMjBjb25jYXRlbmF0ZV9wcm9tcHRfY29tcGxldGlvbnMoZXhhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBjb21wbGV0aW9uJTIwJTNEJTIwJTIyJTIyLmpvaW4oZXhhbXBsZSU1QiUyMmNvbXBsZXRpb25zJTIyJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnRleHQlMjIlM0ElMjBleGFtcGxlJTVCJTIycHJvbXB0JTIyJTVEJTIwJTJCJTIwY29tcGxldGlvbiU3RCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihsYW1iZGElMjB4JTNBJTIwYWxsKHglNUIlMjJsYWJlbHMlMjIlNUQpKS5tYXAoY29uY2F0ZW5hdGVfcHJvbXB0X2NvbXBsZXRpb25zJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0QlNUIlMjJwcm9tcHQlMjIlMkMlMjAlMjJjb21wbGV0aW9ucyUyMiUyQyUyMCUyMmxhYmVscyUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;Blue light&quot;</span>, <span class="hljs-string">&quot;Water&quot;</span>],
    <span class="hljs-string">&quot;completions&quot;</span>: [[<span class="hljs-string">&quot; scatters more in the atmosphere,&quot;</span>, <span class="hljs-string">&quot; so the sky is green.&quot;</span>],
                   [<span class="hljs-string">&quot; forms a less dense structure in ice,&quot;</span>, <span class="hljs-string">&quot; which causes it to expand when it freezes.&quot;</span>]],
    <span class="hljs-string">&quot;labels&quot;</span>: [[<span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>], [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>]],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concatenate_prompt_completions</span>(<span class="hljs-params">example</span>):
    completion = <span class="hljs-string">&quot;&quot;</span>.join(example[<span class="hljs-string">&quot;completions&quot;</span>])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + completion}

dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">all</span>(x[<span class="hljs-string">&quot;labels&quot;</span>])).<span class="hljs-built_in">map</span>(concatenate_prompt_completions, remove_columns=[<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;completions&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])`,wrap:!1}}),el=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Blue light scatters more in the atmosphere, so the sky is green.&#x27;</span>}`,wrap:!1}}),al=new d({props:{title:"From stepwise supervision to prompt completion dataset",local:"from-stepwise-supervision-to-prompt-completion-dataset",headingTag:"h3"}}),pl=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJCbHVlJTIwbGlnaHQlMjIlMkMlMjAlMjJXYXRlciUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb25zJTIyJTNBJTIwJTVCJTVCJTIyJTIwc2NhdHRlcnMlMjBtb3JlJTIwaW4lMjB0aGUlMjBhdG1vc3BoZXJlJTJDJTIyJTJDJTIwJTIyJTIwc28lMjB0aGUlMjBza3klMjBpcyUyMGdyZWVuLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMiUyMGZvcm1zJTIwYSUyMGxlc3MlMjBkZW5zZSUyMHN0cnVjdHVyZSUyMGluJTIwaWNlJTJDJTIyJTJDJTIwJTIyJTIwd2hpY2glMjBjYXVzZXMlMjBpdCUyMHRvJTIwZXhwYW5kJTIwd2hlbiUyMGl0JTIwZnJlZXplcy4lMjIlNUQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJsYWJlbHMlMjIlM0ElMjAlNUIlNUJUcnVlJTJDJTIwRmFsc2UlNUQlMkMlMjAlNUJUcnVlJTJDJTIwVHJ1ZSU1RCU1RCUyQyUwQSU3RCklMEElMEFkZWYlMjBqb2luX2NvbXBsZXRpb25zKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwY29tcGxldGlvbiUyMCUzRCUyMCUyMiUyMi5qb2luKGV4YW1wbGUlNUIlMjJjb21wbGV0aW9ucyUyMiU1RCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJjb21wbGV0aW9uJTIyJTNBJTIwY29tcGxldGlvbiU3RCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihsYW1iZGElMjB4JTNBJTIwYWxsKHglNUIlMjJsYWJlbHMlMjIlNUQpKS5tYXAoam9pbl9jb21wbGV0aW9ucyUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIyY29tcGxldGlvbnMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;Blue light&quot;</span>, <span class="hljs-string">&quot;Water&quot;</span>],
    <span class="hljs-string">&quot;completions&quot;</span>: [[<span class="hljs-string">&quot; scatters more in the atmosphere,&quot;</span>, <span class="hljs-string">&quot; so the sky is green.&quot;</span>],
                   [<span class="hljs-string">&quot; forms a less dense structure in ice,&quot;</span>, <span class="hljs-string">&quot; which causes it to expand when it freezes.&quot;</span>]],
    <span class="hljs-string">&quot;labels&quot;</span>: [[<span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>], [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>]],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">join_completions</span>(<span class="hljs-params">example</span>):
    completion = <span class="hljs-string">&quot;&quot;</span>.join(example[<span class="hljs-string">&quot;completions&quot;</span>])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;completion&quot;</span>: completion}

dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">all</span>(x[<span class="hljs-string">&quot;labels&quot;</span>])).<span class="hljs-built_in">map</span>(join_completions, remove_columns=[<span class="hljs-string">&quot;completions&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])`,wrap:!1}}),ol=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;Blue light&#x27;</span>, <span class="hljs-string">&#x27;completion&#x27;</span>: <span class="hljs-string">&#x27; scatters more in the atmosphere, so the sky is green.&#x27;</span>}`,wrap:!1}}),il=new d({props:{title:"From stepwise supervision to prompt only dataset",local:"from-stepwise-supervision-to-prompt-only-dataset",headingTag:"h3"}}),Ml=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJCbHVlJTIwbGlnaHQlMjIlMkMlMjAlMjJXYXRlciUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb25zJTIyJTNBJTIwJTVCJTVCJTIyJTIwc2NhdHRlcnMlMjBtb3JlJTIwaW4lMjB0aGUlMjBhdG1vc3BoZXJlJTJDJTIyJTJDJTIwJTIyJTIwc28lMjB0aGUlMjBza3klMjBpcyUyMGdyZWVuLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMiUyMGZvcm1zJTIwYSUyMGxlc3MlMjBkZW5zZSUyMHN0cnVjdHVyZSUyMGluJTIwaWNlJTJDJTIyJTJDJTIwJTIyJTIwd2hpY2glMjBjYXVzZXMlMjBpdCUyMHRvJTIwZXhwYW5kJTIwd2hlbiUyMGl0JTIwZnJlZXplcy4lMjIlNUQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJsYWJlbHMlMjIlM0ElMjAlNUIlNUJUcnVlJTJDJTIwRmFsc2UlNUQlMkMlMjAlNUJUcnVlJTJDJTIwVHJ1ZSU1RCU1RCUyQyUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW1vdmVfY29sdW1ucyglNUIlMjJjb21wbGV0aW9ucyUyMiUyQyUyMCUyMmxhYmVscyUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;Blue light&quot;</span>, <span class="hljs-string">&quot;Water&quot;</span>],
    <span class="hljs-string">&quot;completions&quot;</span>: [[<span class="hljs-string">&quot; scatters more in the atmosphere,&quot;</span>, <span class="hljs-string">&quot; so the sky is green.&quot;</span>],
                   [<span class="hljs-string">&quot; forms a less dense structure in ice,&quot;</span>, <span class="hljs-string">&quot; which causes it to expand when it freezes.&quot;</span>]],
    <span class="hljs-string">&quot;labels&quot;</span>: [[<span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>], [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>]],
})

dataset = dataset.remove_columns([<span class="hljs-string">&quot;completions&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])`,wrap:!1}}),cl=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;Blue light&#x27;</span>}`,wrap:!1}}),ul=new d({props:{title:"From stepwise supervision to unpaired preference dataset",local:"from-stepwise-supervision-to-unpaired-preference-dataset",headingTag:"h3"}}),Jl=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJCbHVlJTIwbGlnaHQlMjIlMkMlMjAlMjJXYXRlciUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb25zJTIyJTNBJTIwJTVCJTVCJTIyJTIwc2NhdHRlcnMlMjBtb3JlJTIwaW4lMjB0aGUlMjBhdG1vc3BoZXJlJTJDJTIyJTJDJTIwJTIyJTIwc28lMjB0aGUlMjBza3klMjBpcyUyMGdyZWVuLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMiUyMGZvcm1zJTIwYSUyMGxlc3MlMjBkZW5zZSUyMHN0cnVjdHVyZSUyMGluJTIwaWNlJTJDJTIyJTJDJTIwJTIyJTIwd2hpY2glMjBjYXVzZXMlMjBpdCUyMHRvJTIwZXhwYW5kJTIwd2hlbiUyMGl0JTIwZnJlZXplcy4lMjIlNUQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJsYWJlbHMlMjIlM0ElMjAlNUIlNUJUcnVlJTJDJTIwRmFsc2UlNUQlMkMlMjAlNUJUcnVlJTJDJTIwVHJ1ZSU1RCU1RCUyQyUwQSU3RCklMEElMEFkZWYlMjBtZXJnZV9jb21wbGV0aW9uc19hbmRfbGFiZWxzKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwZXhhbXBsZSU1QiUyMnByb21wdCUyMiU1RCUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlMjIuam9pbihleGFtcGxlJTVCJTIyY29tcGxldGlvbnMlMjIlNUQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBhbGwoZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCklN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobWVyZ2VfY29tcGxldGlvbnNfYW5kX2xhYmVscyUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIyY29tcGxldGlvbnMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;Blue light&quot;</span>, <span class="hljs-string">&quot;Water&quot;</span>],
    <span class="hljs-string">&quot;completions&quot;</span>: [[<span class="hljs-string">&quot; scatters more in the atmosphere,&quot;</span>, <span class="hljs-string">&quot; so the sky is green.&quot;</span>],
                   [<span class="hljs-string">&quot; forms a less dense structure in ice,&quot;</span>, <span class="hljs-string">&quot; which causes it to expand when it freezes.&quot;</span>]],
    <span class="hljs-string">&quot;labels&quot;</span>: [[<span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>], [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>]],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_completions_and_labels</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;prompt&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>], <span class="hljs-string">&quot;completion&quot;</span>: <span class="hljs-string">&quot;&quot;</span>.join(example[<span class="hljs-string">&quot;completions&quot;</span>]), <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-built_in">all</span>(example[<span class="hljs-string">&quot;labels&quot;</span>])}

dataset = dataset.<span class="hljs-built_in">map</span>(merge_completions_and_labels, remove_columns=[<span class="hljs-string">&quot;completions&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])`,wrap:!1}}),hl=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;Blue light&#x27;</span>, <span class="hljs-string">&#x27;completion&#x27;</span>: <span class="hljs-string">&#x27; scatters more in the atmosphere, so the sky is green.&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),Ul=new d({props:{title:"Vision datasets",local:"vision-datasets",headingTag:"h2"}}),wl=new h({props:{code:"JTIzJTIwVGV4dHVhbCUyMGRhdGFzZXQlM0ElMEElMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlMEElMEElMjMlMjBWaXNpb24lMjBkYXRhc2V0JTNBJTBBJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJpbWFnZSUyMiU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTIwaW4lMjB0aGUlMjBpbWFnZSUzRiUyMiU3RCUwQSU1RA==",highlighted:`<span class="hljs-comment"># Textual dataset:</span>
<span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>

<span class="hljs-comment"># Vision dataset:</span>
<span class="hljs-string">&quot;content&quot;</span>: [
    {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}, 
    {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What color is the sky in the image?&quot;</span>}
]`,wrap:!1}}),gl=new Pp({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/dataset_formats.md"}}),{c(){J=u("meta"),I=a(),m=u("p"),T=a(),p(g.$$.fragment),w=a(),C=u("p"),C.textContent=$,U=a(),p(q.$$.fragment),Ql=a(),k=u("ul"),k.innerHTML=Qn,Nl=a(),R=u("table"),R.innerHTML=Nn,Al=a(),p(E.$$.fragment),xl=a(),p(V.$$.fragment),Bl=a(),W=u("p"),W.textContent=An,Gl=a(),p(z.$$.fragment),Zl=a(),p(S.$$.fragment),vl=a(),Y=u("p"),Y.innerHTML=xn,Xl=a(),p(F.$$.fragment),kl=a(),_=u("p"),_.textContent=Bn,Rl=a(),p(H.$$.fragment),El=a(),L=u("p"),L.innerHTML=Gn,Vl=a(),p(D.$$.fragment),Wl=a(),p(P.$$.fragment),zl=a(),K=u("p"),K.innerHTML=Zn,Sl=a(),p(O.$$.fragment),Yl=a(),p(tt.$$.fragment),Fl=a(),st=u("p"),st.innerHTML=vn,_l=a(),p(lt.$$.fragment),Hl=a(),et=u("p"),et.innerHTML=Xn,Ll=a(),p(x.$$.fragment),Dl=a(),p(at.$$.fragment),Pl=a(),nt=u("p"),nt.innerHTML=kn,Kl=a(),p(pt.$$.fragment),Ol=a(),ot=u("p"),ot.innerHTML=Rn,te=a(),p(it.$$.fragment),se=a(),rt=u("p"),rt.innerHTML=En,le=a(),p(Mt.$$.fragment),ee=a(),ct=u("p"),ct.innerHTML=Vn,ae=a(),ut=u("p"),ut.innerHTML=Wn,ne=a(),p(yt.$$.fragment),pe=a(),jt=u("p"),jt.innerHTML=zn,oe=a(),p(Jt.$$.fragment),ie=a(),ht=u("p"),ht.innerHTML=Sn,re=a(),p(Ut.$$.fragment),Me=a(),mt=u("p"),mt.innerHTML=Yn,ce=a(),p(dt.$$.fragment),ue=a(),Tt=u("p"),Tt.innerHTML=Fn,ye=a(),p(It.$$.fragment),je=a(),wt=u("p"),wt.textContent=_n,Je=a(),qt=u("table"),qt.innerHTML=Hn,he=a(),p(B.$$.fragment),Ue=a(),p(gt.$$.fragment),me=a(),ft=u("p"),ft.innerHTML=Ln,de=a(),p(bt.$$.fragment),Te=a(),Ct=u("p"),Ct.innerHTML=Dn,Ie=a(),$t=u("p"),$t.innerHTML=Pn,we=a(),Qt=u("p"),Qt.innerHTML=Kn,qe=a(),p(Nt.$$.fragment),ge=a(),At=u("p"),At.innerHTML=On,fe=a(),p(xt.$$.fragment),be=a(),p(G.$$.fragment),Ce=a(),p(Z.$$.fragment),$e=a(),p(Bt.$$.fragment),Qe=a(),Gt=u("p"),Gt.textContent=tp,Ne=a(),Zt=u("p"),Zt.innerHTML=sp,Ae=a(),p(vt.$$.fragment),xe=a(),Xt=u("p"),Xt.innerHTML=lp,Be=a(),Q=u("iframe"),Ge=a(),kt=u("p"),kt.textContent=ap,Ze=a(),Rt=u("p"),Rt.innerHTML=np,ve=a(),p(Et.$$.fragment),Xe=a(),Vt=u("p"),Vt.textContent=pp,ke=a(),N=u("iframe"),Re=a(),Wt=u("p"),Wt.textContent=ip,Ee=a(),zt=u("p"),zt.textContent=rp,Ve=a(),p(St.$$.fragment),We=a(),Yt=u("p"),Yt.textContent=Mp,ze=a(),Ft=u("p"),Ft.textContent=cp,Se=a(),_t=u("table"),_t.innerHTML=up,Ye=a(),p(Ht.$$.fragment),Fe=a(),Lt=u("p"),Lt.textContent=yp,_e=a(),p(Dt.$$.fragment),He=a(),p(Pt.$$.fragment),Le=a(),p(Kt.$$.fragment),De=a(),Ot=u("p"),Ot.textContent=jp,Pe=a(),p(ts.$$.fragment),Ke=a(),p(ss.$$.fragment),Oe=a(),p(ls.$$.fragment),ta=a(),es=u("p"),es.innerHTML=Jp,sa=a(),p(as.$$.fragment),la=a(),p(ns.$$.fragment),ea=a(),p(ps.$$.fragment),aa=a(),os=u("p"),os.innerHTML=hp,na=a(),p(is.$$.fragment),pa=a(),p(rs.$$.fragment),oa=a(),p(Ms.$$.fragment),ia=a(),cs=u("p"),cs.innerHTML=Up,ra=a(),p(us.$$.fragment),Ma=a(),p(ys.$$.fragment),ca=a(),p(js.$$.fragment),ua=a(),Js=u("p"),Js.innerHTML=mp,ya=a(),p(hs.$$.fragment),ja=a(),p(Us.$$.fragment),Ja=a(),p(ms.$$.fragment),ha=a(),ds=u("p"),ds.innerHTML=dp,Ua=a(),p(Ts.$$.fragment),ma=a(),p(Is.$$.fragment),da=a(),p(v.$$.fragment),Ta=a(),p(ws.$$.fragment),Ia=a(),qs=u("p"),qs.innerHTML=Tp,wa=a(),p(gs.$$.fragment),qa=a(),p(fs.$$.fragment),ga=a(),p(bs.$$.fragment),fa=a(),Cs=u("p"),Cs.innerHTML=Ip,ba=a(),p($s.$$.fragment),Ca=a(),p(Qs.$$.fragment),$a=a(),p(Ns.$$.fragment),Qa=a(),As=u("p"),As.textContent=wp,Na=a(),p(xs.$$.fragment),Aa=a(),p(Bs.$$.fragment),xa=a(),p(Gs.$$.fragment),Ba=a(),Zs=u("p"),Zs.textContent=qp,Ga=a(),p(vs.$$.fragment),Za=a(),p(Xs.$$.fragment),va=a(),p(ks.$$.fragment),Xa=a(),Rs=u("p"),Rs.innerHTML=gp,ka=a(),p(Es.$$.fragment),Ra=a(),p(Vs.$$.fragment),Ea=a(),p(X.$$.fragment),Va=a(),p(Ws.$$.fragment),Wa=a(),zs=u("p"),zs.innerHTML=fp,za=a(),p(Ss.$$.fragment),Sa=a(),p(Ys.$$.fragment),Ya=a(),p(Fs.$$.fragment),Fa=a(),_s=u("p"),_s.textContent=bp,_a=a(),p(Hs.$$.fragment),Ha=a(),p(Ls.$$.fragment),La=a(),p(Ds.$$.fragment),Da=a(),Ps=u("p"),Ps.textContent=Cp,Pa=a(),p(Ks.$$.fragment),Ka=a(),p(Os.$$.fragment),Oa=a(),p(tl.$$.fragment),tn=a(),sl=u("p"),sl.innerHTML=$p,sn=a(),p(ll.$$.fragment),ln=a(),p(el.$$.fragment),en=a(),p(al.$$.fragment),an=a(),nl=u("p"),nl.textContent=Qp,nn=a(),p(pl.$$.fragment),pn=a(),p(ol.$$.fragment),on=a(),p(il.$$.fragment),rn=a(),rl=u("p"),rl.textContent=Np,Mn=a(),p(Ml.$$.fragment),cn=a(),p(cl.$$.fragment),un=a(),p(ul.$$.fragment),yn=a(),yl=u("p"),yl.textContent=Ap,jn=a(),jl=u("p"),jl.textContent=xp,Jn=a(),p(Jl.$$.fragment),hn=a(),p(hl.$$.fragment),Un=a(),p(Ul.$$.fragment),mn=a(),ml=u("p"),ml.textContent=Bp,dn=a(),dl=u("p"),dl.textContent=Gp,Tn=a(),Tl=u("ol"),Tl.innerHTML=Zp,In=a(),Il=u("p"),Il.textContent=vp,wn=a(),p(wl.$$.fragment),qn=a(),ql=u("p"),ql.innerHTML=Xp,gn=a(),A=u("iframe"),fn=a(),p(gl.$$.fragment),bn=a(),Cl=u("p"),this.h()},l(t){const s=Lp("svelte-u9bgzb",document.head);J=y(s,"META",{name:!0,content:!0}),s.forEach(l),I=n(t),m=y(t,"P",{}),$l(m).forEach(l),T=n(t),o(g.$$.fragment,t),w=n(t),C=y(t,"P",{"data-svelte-h":!0}),j(C)!=="svelte-1976wsu"&&(C.textContent=$),U=n(t),o(q.$$.fragment,t),Ql=n(t),k=y(t,"UL",{"data-svelte-h":!0}),j(k)!=="svelte-fvfcsu"&&(k.innerHTML=Qn),Nl=n(t),R=y(t,"TABLE",{"data-svelte-h":!0}),j(R)!=="svelte-1j4ocz4"&&(R.innerHTML=Nn),Al=n(t),o(E.$$.fragment,t),xl=n(t),o(V.$$.fragment,t),Bl=n(t),W=y(t,"P",{"data-svelte-h":!0}),j(W)!=="svelte-n22pbc"&&(W.textContent=An),Gl=n(t),o(z.$$.fragment,t),Zl=n(t),o(S.$$.fragment,t),vl=n(t),Y=y(t,"P",{"data-svelte-h":!0}),j(Y)!=="svelte-ftn6so"&&(Y.innerHTML=xn),Xl=n(t),o(F.$$.fragment,t),kl=n(t),_=y(t,"P",{"data-svelte-h":!0}),j(_)!=="svelte-1n2btf9"&&(_.textContent=Bn),Rl=n(t),o(H.$$.fragment,t),El=n(t),L=y(t,"P",{"data-svelte-h":!0}),j(L)!=="svelte-1de5sg2"&&(L.innerHTML=Gn),Vl=n(t),o(D.$$.fragment,t),Wl=n(t),o(P.$$.fragment,t),zl=n(t),K=y(t,"P",{"data-svelte-h":!0}),j(K)!=="svelte-zfzona"&&(K.innerHTML=Zn),Sl=n(t),o(O.$$.fragment,t),Yl=n(t),o(tt.$$.fragment,t),Fl=n(t),st=y(t,"P",{"data-svelte-h":!0}),j(st)!=="svelte-1fi7big"&&(st.innerHTML=vn),_l=n(t),o(lt.$$.fragment,t),Hl=n(t),et=y(t,"P",{"data-svelte-h":!0}),j(et)!=="svelte-19lc5cw"&&(et.innerHTML=Xn),Ll=n(t),o(x.$$.fragment,t),Dl=n(t),o(at.$$.fragment,t),Pl=n(t),nt=y(t,"P",{"data-svelte-h":!0}),j(nt)!=="svelte-1qh8h3u"&&(nt.innerHTML=kn),Kl=n(t),o(pt.$$.fragment,t),Ol=n(t),ot=y(t,"P",{"data-svelte-h":!0}),j(ot)!=="svelte-td5nru"&&(ot.innerHTML=Rn),te=n(t),o(it.$$.fragment,t),se=n(t),rt=y(t,"P",{"data-svelte-h":!0}),j(rt)!=="svelte-fpgtkb"&&(rt.innerHTML=En),le=n(t),o(Mt.$$.fragment,t),ee=n(t),ct=y(t,"P",{"data-svelte-h":!0}),j(ct)!=="svelte-183i8gm"&&(ct.innerHTML=Vn),ae=n(t),ut=y(t,"P",{"data-svelte-h":!0}),j(ut)!=="svelte-144ttmo"&&(ut.innerHTML=Wn),ne=n(t),o(yt.$$.fragment,t),pe=n(t),jt=y(t,"P",{"data-svelte-h":!0}),j(jt)!=="svelte-ds3631"&&(jt.innerHTML=zn),oe=n(t),o(Jt.$$.fragment,t),ie=n(t),ht=y(t,"P",{"data-svelte-h":!0}),j(ht)!=="svelte-2vlprm"&&(ht.innerHTML=Sn),re=n(t),o(Ut.$$.fragment,t),Me=n(t),mt=y(t,"P",{"data-svelte-h":!0}),j(mt)!=="svelte-wwnrua"&&(mt.innerHTML=Yn),ce=n(t),o(dt.$$.fragment,t),ue=n(t),Tt=y(t,"P",{"data-svelte-h":!0}),j(Tt)!=="svelte-1r34it7"&&(Tt.innerHTML=Fn),ye=n(t),o(It.$$.fragment,t),je=n(t),wt=y(t,"P",{"data-svelte-h":!0}),j(wt)!=="svelte-vrn817"&&(wt.textContent=_n),Je=n(t),qt=y(t,"TABLE",{"data-svelte-h":!0}),j(qt)!=="svelte-x68k6g"&&(qt.innerHTML=Hn),he=n(t),o(B.$$.fragment,t),Ue=n(t),o(gt.$$.fragment,t),me=n(t),ft=y(t,"P",{"data-svelte-h":!0}),j(ft)!=="svelte-10g1ofc"&&(ft.innerHTML=Ln),de=n(t),o(bt.$$.fragment,t),Te=n(t),Ct=y(t,"P",{"data-svelte-h":!0}),j(Ct)!=="svelte-18kvh4r"&&(Ct.innerHTML=Dn),Ie=n(t),$t=y(t,"P",{"data-svelte-h":!0}),j($t)!=="svelte-19t1v1h"&&($t.innerHTML=Pn),we=n(t),Qt=y(t,"P",{"data-svelte-h":!0}),j(Qt)!=="svelte-1gqptzs"&&(Qt.innerHTML=Kn),qe=n(t),o(Nt.$$.fragment,t),ge=n(t),At=y(t,"P",{"data-svelte-h":!0}),j(At)!=="svelte-1q93c60"&&(At.innerHTML=On),fe=n(t),o(xt.$$.fragment,t),be=n(t),o(G.$$.fragment,t),Ce=n(t),o(Z.$$.fragment,t),$e=n(t),o(Bt.$$.fragment,t),Qe=n(t),Gt=y(t,"P",{"data-svelte-h":!0}),j(Gt)!=="svelte-n0cp2u"&&(Gt.textContent=tp),Ne=n(t),Zt=y(t,"P",{"data-svelte-h":!0}),j(Zt)!=="svelte-wbjjp8"&&(Zt.innerHTML=sp),Ae=n(t),o(vt.$$.fragment,t),xe=n(t),Xt=y(t,"P",{"data-svelte-h":!0}),j(Xt)!=="svelte-dr0jz6"&&(Xt.innerHTML=lp),Be=n(t),Q=y(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),$l(Q).forEach(l),Ge=n(t),kt=y(t,"P",{"data-svelte-h":!0}),j(kt)!=="svelte-1f6n8q4"&&(kt.textContent=ap),Ze=n(t),Rt=y(t,"P",{"data-svelte-h":!0}),j(Rt)!=="svelte-17l9hcf"&&(Rt.innerHTML=np),ve=n(t),o(Et.$$.fragment,t),Xe=n(t),Vt=y(t,"P",{"data-svelte-h":!0}),j(Vt)!=="svelte-hplhuu"&&(Vt.textContent=pp),ke=n(t),N=y(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),$l(N).forEach(l),Re=n(t),Wt=y(t,"P",{"data-svelte-h":!0}),j(Wt)!=="svelte-jt9cd3"&&(Wt.textContent=ip),Ee=n(t),zt=y(t,"P",{"data-svelte-h":!0}),j(zt)!=="svelte-1rvlfj0"&&(zt.textContent=rp),Ve=n(t),o(St.$$.fragment,t),We=n(t),Yt=y(t,"P",{"data-svelte-h":!0}),j(Yt)!=="svelte-1ttdd1s"&&(Yt.textContent=Mp),ze=n(t),Ft=y(t,"P",{"data-svelte-h":!0}),j(Ft)!=="svelte-17l70ga"&&(Ft.textContent=cp),Se=n(t),_t=y(t,"TABLE",{"data-svelte-h":!0}),j(_t)!=="svelte-byyzej"&&(_t.innerHTML=up),Ye=n(t),o(Ht.$$.fragment,t),Fe=n(t),Lt=y(t,"P",{"data-svelte-h":!0}),j(Lt)!=="svelte-q88m1s"&&(Lt.textContent=yp),_e=n(t),o(Dt.$$.fragment,t),He=n(t),o(Pt.$$.fragment,t),Le=n(t),o(Kt.$$.fragment,t),De=n(t),Ot=y(t,"P",{"data-svelte-h":!0}),j(Ot)!=="svelte-dplhkb"&&(Ot.textContent=jp),Pe=n(t),o(ts.$$.fragment,t),Ke=n(t),o(ss.$$.fragment,t),Oe=n(t),o(ls.$$.fragment,t),ta=n(t),es=y(t,"P",{"data-svelte-h":!0}),j(es)!=="svelte-u8pmva"&&(es.innerHTML=Jp),sa=n(t),o(as.$$.fragment,t),la=n(t),o(ns.$$.fragment,t),ea=n(t),o(ps.$$.fragment,t),aa=n(t),os=y(t,"P",{"data-svelte-h":!0}),j(os)!=="svelte-1j5quti"&&(os.innerHTML=hp),na=n(t),o(is.$$.fragment,t),pa=n(t),o(rs.$$.fragment,t),oa=n(t),o(Ms.$$.fragment,t),ia=n(t),cs=y(t,"P",{"data-svelte-h":!0}),j(cs)!=="svelte-m6nuwc"&&(cs.innerHTML=Up),ra=n(t),o(us.$$.fragment,t),Ma=n(t),o(ys.$$.fragment,t),ca=n(t),o(js.$$.fragment,t),ua=n(t),Js=y(t,"P",{"data-svelte-h":!0}),j(Js)!=="svelte-1c48hy4"&&(Js.innerHTML=mp),ya=n(t),o(hs.$$.fragment,t),ja=n(t),o(Us.$$.fragment,t),Ja=n(t),o(ms.$$.fragment,t),ha=n(t),ds=y(t,"P",{"data-svelte-h":!0}),j(ds)!=="svelte-9i0n0q"&&(ds.innerHTML=dp),Ua=n(t),o(Ts.$$.fragment,t),ma=n(t),o(Is.$$.fragment,t),da=n(t),o(v.$$.fragment,t),Ta=n(t),o(ws.$$.fragment,t),Ia=n(t),qs=y(t,"P",{"data-svelte-h":!0}),j(qs)!=="svelte-1azgh8u"&&(qs.innerHTML=Tp),wa=n(t),o(gs.$$.fragment,t),qa=n(t),o(fs.$$.fragment,t),ga=n(t),o(bs.$$.fragment,t),fa=n(t),Cs=y(t,"P",{"data-svelte-h":!0}),j(Cs)!=="svelte-thhn9e"&&(Cs.innerHTML=Ip),ba=n(t),o($s.$$.fragment,t),Ca=n(t),o(Qs.$$.fragment,t),$a=n(t),o(Ns.$$.fragment,t),Qa=n(t),As=y(t,"P",{"data-svelte-h":!0}),j(As)!=="svelte-yu2uu5"&&(As.textContent=wp),Na=n(t),o(xs.$$.fragment,t),Aa=n(t),o(Bs.$$.fragment,t),xa=n(t),o(Gs.$$.fragment,t),Ba=n(t),Zs=y(t,"P",{"data-svelte-h":!0}),j(Zs)!=="svelte-slr0da"&&(Zs.textContent=qp),Ga=n(t),o(vs.$$.fragment,t),Za=n(t),o(Xs.$$.fragment,t),va=n(t),o(ks.$$.fragment,t),Xa=n(t),Rs=y(t,"P",{"data-svelte-h":!0}),j(Rs)!=="svelte-16s4cth"&&(Rs.innerHTML=gp),ka=n(t),o(Es.$$.fragment,t),Ra=n(t),o(Vs.$$.fragment,t),Ea=n(t),o(X.$$.fragment,t),Va=n(t),o(Ws.$$.fragment,t),Wa=n(t),zs=y(t,"P",{"data-svelte-h":!0}),j(zs)!=="svelte-1rtwiuz"&&(zs.innerHTML=fp),za=n(t),o(Ss.$$.fragment,t),Sa=n(t),o(Ys.$$.fragment,t),Ya=n(t),o(Fs.$$.fragment,t),Fa=n(t),_s=y(t,"P",{"data-svelte-h":!0}),j(_s)!=="svelte-1mntuxe"&&(_s.textContent=bp),_a=n(t),o(Hs.$$.fragment,t),Ha=n(t),o(Ls.$$.fragment,t),La=n(t),o(Ds.$$.fragment,t),Da=n(t),Ps=y(t,"P",{"data-svelte-h":!0}),j(Ps)!=="svelte-1x58tju"&&(Ps.textContent=Cp),Pa=n(t),o(Ks.$$.fragment,t),Ka=n(t),o(Os.$$.fragment,t),Oa=n(t),o(tl.$$.fragment,t),tn=n(t),sl=y(t,"P",{"data-svelte-h":!0}),j(sl)!=="svelte-usvjfj"&&(sl.innerHTML=$p),sn=n(t),o(ll.$$.fragment,t),ln=n(t),o(el.$$.fragment,t),en=n(t),o(al.$$.fragment,t),an=n(t),nl=y(t,"P",{"data-svelte-h":!0}),j(nl)!=="svelte-1wvawda"&&(nl.textContent=Qp),nn=n(t),o(pl.$$.fragment,t),pn=n(t),o(ol.$$.fragment,t),on=n(t),o(il.$$.fragment,t),rn=n(t),rl=y(t,"P",{"data-svelte-h":!0}),j(rl)!=="svelte-1fb8htv"&&(rl.textContent=Np),Mn=n(t),o(Ml.$$.fragment,t),cn=n(t),o(cl.$$.fragment,t),un=n(t),o(ul.$$.fragment,t),yn=n(t),yl=y(t,"P",{"data-svelte-h":!0}),j(yl)!=="svelte-1p3ncex"&&(yl.textContent=Ap),jn=n(t),jl=y(t,"P",{"data-svelte-h":!0}),j(jl)!=="svelte-wppc03"&&(jl.textContent=xp),Jn=n(t),o(Jl.$$.fragment,t),hn=n(t),o(hl.$$.fragment,t),Un=n(t),o(Ul.$$.fragment,t),mn=n(t),ml=y(t,"P",{"data-svelte-h":!0}),j(ml)!=="svelte-1f2j4bf"&&(ml.textContent=Bp),dn=n(t),dl=y(t,"P",{"data-svelte-h":!0}),j(dl)!=="svelte-1dkity6"&&(dl.textContent=Gp),Tn=n(t),Tl=y(t,"OL",{"data-svelte-h":!0}),j(Tl)!=="svelte-imd92t"&&(Tl.innerHTML=Zp),In=n(t),Il=y(t,"P",{"data-svelte-h":!0}),j(Il)!=="svelte-11lpom8"&&(Il.textContent=vp),wn=n(t),o(wl.$$.fragment,t),qn=n(t),ql=y(t,"P",{"data-svelte-h":!0}),j(ql)!=="svelte-11ot8l1"&&(ql.innerHTML=Xp),gn=n(t),A=y(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),$l(A).forEach(l),fn=n(t),o(gl.$$.fragment,t),bn=n(t),Cl=y(t,"P",{}),$l(Cl).forEach(l),this.h()},h(){b(J,"name","hf:doc:metadata"),b(J,"content",no),$n(Q.src,ep="https://huggingface.co/datasets/openbmb/UltraFeedback/embed/viewer/default/train")||b(Q,"src",ep),b(Q,"frameborder","0"),b(Q,"width","100%"),b(Q,"height","560px"),$n(N.src,op="https://huggingface.co/datasets/trl-lib/ultrafeedback-gpt-3.5-turbo-helpfulness/embed/viewer/default/train?row=0")||b(N,"src",op),b(N,"frameborder","0"),b(N,"width","100%"),b(N,"height","560px"),$n(A.src,kp="https://huggingface.co/datasets/trl-lib/rlaif-v/embed/viewer/default/train")||b(A,"src",kp),b(A,"frameborder","0"),b(A,"width","100%"),b(A,"height","560px")},m(t,s){Dp(document.head,J),e(t,I,s),e(t,m,s),e(t,T,s),i(g,t,s),e(t,w,s),e(t,C,s),e(t,U,s),i(q,t,s),e(t,Ql,s),e(t,k,s),e(t,Nl,s),e(t,R,s),e(t,Al,s),i(E,t,s),e(t,xl,s),i(V,t,s),e(t,Bl,s),e(t,W,s),e(t,Gl,s),i(z,t,s),e(t,Zl,s),i(S,t,s),e(t,vl,s),e(t,Y,s),e(t,Xl,s),i(F,t,s),e(t,kl,s),e(t,_,s),e(t,Rl,s),i(H,t,s),e(t,El,s),e(t,L,s),e(t,Vl,s),i(D,t,s),e(t,Wl,s),i(P,t,s),e(t,zl,s),e(t,K,s),e(t,Sl,s),i(O,t,s),e(t,Yl,s),i(tt,t,s),e(t,Fl,s),e(t,st,s),e(t,_l,s),i(lt,t,s),e(t,Hl,s),e(t,et,s),e(t,Ll,s),i(x,t,s),e(t,Dl,s),i(at,t,s),e(t,Pl,s),e(t,nt,s),e(t,Kl,s),i(pt,t,s),e(t,Ol,s),e(t,ot,s),e(t,te,s),i(it,t,s),e(t,se,s),e(t,rt,s),e(t,le,s),i(Mt,t,s),e(t,ee,s),e(t,ct,s),e(t,ae,s),e(t,ut,s),e(t,ne,s),i(yt,t,s),e(t,pe,s),e(t,jt,s),e(t,oe,s),i(Jt,t,s),e(t,ie,s),e(t,ht,s),e(t,re,s),i(Ut,t,s),e(t,Me,s),e(t,mt,s),e(t,ce,s),i(dt,t,s),e(t,ue,s),e(t,Tt,s),e(t,ye,s),i(It,t,s),e(t,je,s),e(t,wt,s),e(t,Je,s),e(t,qt,s),e(t,he,s),i(B,t,s),e(t,Ue,s),i(gt,t,s),e(t,me,s),e(t,ft,s),e(t,de,s),i(bt,t,s),e(t,Te,s),e(t,Ct,s),e(t,Ie,s),e(t,$t,s),e(t,we,s),e(t,Qt,s),e(t,qe,s),i(Nt,t,s),e(t,ge,s),e(t,At,s),e(t,fe,s),i(xt,t,s),e(t,be,s),i(G,t,s),e(t,Ce,s),i(Z,t,s),e(t,$e,s),i(Bt,t,s),e(t,Qe,s),e(t,Gt,s),e(t,Ne,s),e(t,Zt,s),e(t,Ae,s),i(vt,t,s),e(t,xe,s),e(t,Xt,s),e(t,Be,s),e(t,Q,s),e(t,Ge,s),e(t,kt,s),e(t,Ze,s),e(t,Rt,s),e(t,ve,s),i(Et,t,s),e(t,Xe,s),e(t,Vt,s),e(t,ke,s),e(t,N,s),e(t,Re,s),e(t,Wt,s),e(t,Ee,s),e(t,zt,s),e(t,Ve,s),i(St,t,s),e(t,We,s),e(t,Yt,s),e(t,ze,s),e(t,Ft,s),e(t,Se,s),e(t,_t,s),e(t,Ye,s),i(Ht,t,s),e(t,Fe,s),e(t,Lt,s),e(t,_e,s),i(Dt,t,s),e(t,He,s),i(Pt,t,s),e(t,Le,s),i(Kt,t,s),e(t,De,s),e(t,Ot,s),e(t,Pe,s),i(ts,t,s),e(t,Ke,s),i(ss,t,s),e(t,Oe,s),i(ls,t,s),e(t,ta,s),e(t,es,s),e(t,sa,s),i(as,t,s),e(t,la,s),i(ns,t,s),e(t,ea,s),i(ps,t,s),e(t,aa,s),e(t,os,s),e(t,na,s),i(is,t,s),e(t,pa,s),i(rs,t,s),e(t,oa,s),i(Ms,t,s),e(t,ia,s),e(t,cs,s),e(t,ra,s),i(us,t,s),e(t,Ma,s),i(ys,t,s),e(t,ca,s),i(js,t,s),e(t,ua,s),e(t,Js,s),e(t,ya,s),i(hs,t,s),e(t,ja,s),i(Us,t,s),e(t,Ja,s),i(ms,t,s),e(t,ha,s),e(t,ds,s),e(t,Ua,s),i(Ts,t,s),e(t,ma,s),i(Is,t,s),e(t,da,s),i(v,t,s),e(t,Ta,s),i(ws,t,s),e(t,Ia,s),e(t,qs,s),e(t,wa,s),i(gs,t,s),e(t,qa,s),i(fs,t,s),e(t,ga,s),i(bs,t,s),e(t,fa,s),e(t,Cs,s),e(t,ba,s),i($s,t,s),e(t,Ca,s),i(Qs,t,s),e(t,$a,s),i(Ns,t,s),e(t,Qa,s),e(t,As,s),e(t,Na,s),i(xs,t,s),e(t,Aa,s),i(Bs,t,s),e(t,xa,s),i(Gs,t,s),e(t,Ba,s),e(t,Zs,s),e(t,Ga,s),i(vs,t,s),e(t,Za,s),i(Xs,t,s),e(t,va,s),i(ks,t,s),e(t,Xa,s),e(t,Rs,s),e(t,ka,s),i(Es,t,s),e(t,Ra,s),i(Vs,t,s),e(t,Ea,s),i(X,t,s),e(t,Va,s),i(Ws,t,s),e(t,Wa,s),e(t,zs,s),e(t,za,s),i(Ss,t,s),e(t,Sa,s),i(Ys,t,s),e(t,Ya,s),i(Fs,t,s),e(t,Fa,s),e(t,_s,s),e(t,_a,s),i(Hs,t,s),e(t,Ha,s),i(Ls,t,s),e(t,La,s),i(Ds,t,s),e(t,Da,s),e(t,Ps,s),e(t,Pa,s),i(Ks,t,s),e(t,Ka,s),i(Os,t,s),e(t,Oa,s),i(tl,t,s),e(t,tn,s),e(t,sl,s),e(t,sn,s),i(ll,t,s),e(t,ln,s),i(el,t,s),e(t,en,s),i(al,t,s),e(t,an,s),e(t,nl,s),e(t,nn,s),i(pl,t,s),e(t,pn,s),i(ol,t,s),e(t,on,s),i(il,t,s),e(t,rn,s),e(t,rl,s),e(t,Mn,s),i(Ml,t,s),e(t,cn,s),i(cl,t,s),e(t,un,s),i(ul,t,s),e(t,yn,s),e(t,yl,s),e(t,jn,s),e(t,jl,s),e(t,Jn,s),i(Jl,t,s),e(t,hn,s),i(hl,t,s),e(t,Un,s),i(Ul,t,s),e(t,mn,s),e(t,ml,s),e(t,dn,s),e(t,dl,s),e(t,Tn,s),e(t,Tl,s),e(t,In,s),e(t,Il,s),e(t,wn,s),i(wl,t,s),e(t,qn,s),e(t,ql,s),e(t,gn,s),e(t,A,s),e(t,fn,s),i(gl,t,s),e(t,bn,s),e(t,Cl,s),Cn=!0},p(t,[s]){const Rp={};s&2&&(Rp.$$scope={dirty:s,ctx:t}),x.$set(Rp);const Ep={};s&2&&(Ep.$$scope={dirty:s,ctx:t}),B.$set(Ep);const Vp={};s&2&&(Vp.$$scope={dirty:s,ctx:t}),G.$set(Vp);const Wp={};s&2&&(Wp.$$scope={dirty:s,ctx:t}),Z.$set(Wp);const zp={};s&2&&(zp.$$scope={dirty:s,ctx:t}),v.$set(zp);const Sp={};s&2&&(Sp.$$scope={dirty:s,ctx:t}),X.$set(Sp)},i(t){Cn||(r(g.$$.fragment,t),r(q.$$.fragment,t),r(E.$$.fragment,t),r(V.$$.fragment,t),r(z.$$.fragment,t),r(S.$$.fragment,t),r(F.$$.fragment,t),r(H.$$.fragment,t),r(D.$$.fragment,t),r(P.$$.fragment,t),r(O.$$.fragment,t),r(tt.$$.fragment,t),r(lt.$$.fragment,t),r(x.$$.fragment,t),r(at.$$.fragment,t),r(pt.$$.fragment,t),r(it.$$.fragment,t),r(Mt.$$.fragment,t),r(yt.$$.fragment,t),r(Jt.$$.fragment,t),r(Ut.$$.fragment,t),r(dt.$$.fragment,t),r(It.$$.fragment,t),r(B.$$.fragment,t),r(gt.$$.fragment,t),r(bt.$$.fragment,t),r(Nt.$$.fragment,t),r(xt.$$.fragment,t),r(G.$$.fragment,t),r(Z.$$.fragment,t),r(Bt.$$.fragment,t),r(vt.$$.fragment,t),r(Et.$$.fragment,t),r(St.$$.fragment,t),r(Ht.$$.fragment,t),r(Dt.$$.fragment,t),r(Pt.$$.fragment,t),r(Kt.$$.fragment,t),r(ts.$$.fragment,t),r(ss.$$.fragment,t),r(ls.$$.fragment,t),r(as.$$.fragment,t),r(ns.$$.fragment,t),r(ps.$$.fragment,t),r(is.$$.fragment,t),r(rs.$$.fragment,t),r(Ms.$$.fragment,t),r(us.$$.fragment,t),r(ys.$$.fragment,t),r(js.$$.fragment,t),r(hs.$$.fragment,t),r(Us.$$.fragment,t),r(ms.$$.fragment,t),r(Ts.$$.fragment,t),r(Is.$$.fragment,t),r(v.$$.fragment,t),r(ws.$$.fragment,t),r(gs.$$.fragment,t),r(fs.$$.fragment,t),r(bs.$$.fragment,t),r($s.$$.fragment,t),r(Qs.$$.fragment,t),r(Ns.$$.fragment,t),r(xs.$$.fragment,t),r(Bs.$$.fragment,t),r(Gs.$$.fragment,t),r(vs.$$.fragment,t),r(Xs.$$.fragment,t),r(ks.$$.fragment,t),r(Es.$$.fragment,t),r(Vs.$$.fragment,t),r(X.$$.fragment,t),r(Ws.$$.fragment,t),r(Ss.$$.fragment,t),r(Ys.$$.fragment,t),r(Fs.$$.fragment,t),r(Hs.$$.fragment,t),r(Ls.$$.fragment,t),r(Ds.$$.fragment,t),r(Ks.$$.fragment,t),r(Os.$$.fragment,t),r(tl.$$.fragment,t),r(ll.$$.fragment,t),r(el.$$.fragment,t),r(al.$$.fragment,t),r(pl.$$.fragment,t),r(ol.$$.fragment,t),r(il.$$.fragment,t),r(Ml.$$.fragment,t),r(cl.$$.fragment,t),r(ul.$$.fragment,t),r(Jl.$$.fragment,t),r(hl.$$.fragment,t),r(Ul.$$.fragment,t),r(wl.$$.fragment,t),r(gl.$$.fragment,t),Cn=!0)},o(t){M(g.$$.fragment,t),M(q.$$.fragment,t),M(E.$$.fragment,t),M(V.$$.fragment,t),M(z.$$.fragment,t),M(S.$$.fragment,t),M(F.$$.fragment,t),M(H.$$.fragment,t),M(D.$$.fragment,t),M(P.$$.fragment,t),M(O.$$.fragment,t),M(tt.$$.fragment,t),M(lt.$$.fragment,t),M(x.$$.fragment,t),M(at.$$.fragment,t),M(pt.$$.fragment,t),M(it.$$.fragment,t),M(Mt.$$.fragment,t),M(yt.$$.fragment,t),M(Jt.$$.fragment,t),M(Ut.$$.fragment,t),M(dt.$$.fragment,t),M(It.$$.fragment,t),M(B.$$.fragment,t),M(gt.$$.fragment,t),M(bt.$$.fragment,t),M(Nt.$$.fragment,t),M(xt.$$.fragment,t),M(G.$$.fragment,t),M(Z.$$.fragment,t),M(Bt.$$.fragment,t),M(vt.$$.fragment,t),M(Et.$$.fragment,t),M(St.$$.fragment,t),M(Ht.$$.fragment,t),M(Dt.$$.fragment,t),M(Pt.$$.fragment,t),M(Kt.$$.fragment,t),M(ts.$$.fragment,t),M(ss.$$.fragment,t),M(ls.$$.fragment,t),M(as.$$.fragment,t),M(ns.$$.fragment,t),M(ps.$$.fragment,t),M(is.$$.fragment,t),M(rs.$$.fragment,t),M(Ms.$$.fragment,t),M(us.$$.fragment,t),M(ys.$$.fragment,t),M(js.$$.fragment,t),M(hs.$$.fragment,t),M(Us.$$.fragment,t),M(ms.$$.fragment,t),M(Ts.$$.fragment,t),M(Is.$$.fragment,t),M(v.$$.fragment,t),M(ws.$$.fragment,t),M(gs.$$.fragment,t),M(fs.$$.fragment,t),M(bs.$$.fragment,t),M($s.$$.fragment,t),M(Qs.$$.fragment,t),M(Ns.$$.fragment,t),M(xs.$$.fragment,t),M(Bs.$$.fragment,t),M(Gs.$$.fragment,t),M(vs.$$.fragment,t),M(Xs.$$.fragment,t),M(ks.$$.fragment,t),M(Es.$$.fragment,t),M(Vs.$$.fragment,t),M(X.$$.fragment,t),M(Ws.$$.fragment,t),M(Ss.$$.fragment,t),M(Ys.$$.fragment,t),M(Fs.$$.fragment,t),M(Hs.$$.fragment,t),M(Ls.$$.fragment,t),M(Ds.$$.fragment,t),M(Ks.$$.fragment,t),M(Os.$$.fragment,t),M(tl.$$.fragment,t),M(ll.$$.fragment,t),M(el.$$.fragment,t),M(al.$$.fragment,t),M(pl.$$.fragment,t),M(ol.$$.fragment,t),M(il.$$.fragment,t),M(Ml.$$.fragment,t),M(cl.$$.fragment,t),M(ul.$$.fragment,t),M(Jl.$$.fragment,t),M(hl.$$.fragment,t),M(Ul.$$.fragment,t),M(wl.$$.fragment,t),M(gl.$$.fragment,t),Cn=!1},d(t){t&&(l(I),l(m),l(T),l(w),l(C),l(U),l(Ql),l(k),l(Nl),l(R),l(Al),l(xl),l(Bl),l(W),l(Gl),l(Zl),l(vl),l(Y),l(Xl),l(kl),l(_),l(Rl),l(El),l(L),l(Vl),l(Wl),l(zl),l(K),l(Sl),l(Yl),l(Fl),l(st),l(_l),l(Hl),l(et),l(Ll),l(Dl),l(Pl),l(nt),l(Kl),l(Ol),l(ot),l(te),l(se),l(rt),l(le),l(ee),l(ct),l(ae),l(ut),l(ne),l(pe),l(jt),l(oe),l(ie),l(ht),l(re),l(Me),l(mt),l(ce),l(ue),l(Tt),l(ye),l(je),l(wt),l(Je),l(qt),l(he),l(Ue),l(me),l(ft),l(de),l(Te),l(Ct),l(Ie),l($t),l(we),l(Qt),l(qe),l(ge),l(At),l(fe),l(be),l(Ce),l($e),l(Qe),l(Gt),l(Ne),l(Zt),l(Ae),l(xe),l(Xt),l(Be),l(Q),l(Ge),l(kt),l(Ze),l(Rt),l(ve),l(Xe),l(Vt),l(ke),l(N),l(Re),l(Wt),l(Ee),l(zt),l(Ve),l(We),l(Yt),l(ze),l(Ft),l(Se),l(_t),l(Ye),l(Fe),l(Lt),l(_e),l(He),l(Le),l(De),l(Ot),l(Pe),l(Ke),l(Oe),l(ta),l(es),l(sa),l(la),l(ea),l(aa),l(os),l(na),l(pa),l(oa),l(ia),l(cs),l(ra),l(Ma),l(ca),l(ua),l(Js),l(ya),l(ja),l(Ja),l(ha),l(ds),l(Ua),l(ma),l(da),l(Ta),l(Ia),l(qs),l(wa),l(qa),l(ga),l(fa),l(Cs),l(ba),l(Ca),l($a),l(Qa),l(As),l(Na),l(Aa),l(xa),l(Ba),l(Zs),l(Ga),l(Za),l(va),l(Xa),l(Rs),l(ka),l(Ra),l(Ea),l(Va),l(Wa),l(zs),l(za),l(Sa),l(Ya),l(Fa),l(_s),l(_a),l(Ha),l(La),l(Da),l(Ps),l(Pa),l(Ka),l(Oa),l(tn),l(sl),l(sn),l(ln),l(en),l(an),l(nl),l(nn),l(pn),l(on),l(rn),l(rl),l(Mn),l(cn),l(un),l(yn),l(yl),l(jn),l(jl),l(Jn),l(hn),l(Un),l(mn),l(ml),l(dn),l(dl),l(Tn),l(Tl),l(In),l(Il),l(wn),l(qn),l(ql),l(gn),l(A),l(fn),l(bn),l(Cl)),l(J),c(g,t),c(q,t),c(E,t),c(V,t),c(z,t),c(S,t),c(F,t),c(H,t),c(D,t),c(P,t),c(O,t),c(tt,t),c(lt,t),c(x,t),c(at,t),c(pt,t),c(it,t),c(Mt,t),c(yt,t),c(Jt,t),c(Ut,t),c(dt,t),c(It,t),c(B,t),c(gt,t),c(bt,t),c(Nt,t),c(xt,t),c(G,t),c(Z,t),c(Bt,t),c(vt,t),c(Et,t),c(St,t),c(Ht,t),c(Dt,t),c(Pt,t),c(Kt,t),c(ts,t),c(ss,t),c(ls,t),c(as,t),c(ns,t),c(ps,t),c(is,t),c(rs,t),c(Ms,t),c(us,t),c(ys,t),c(js,t),c(hs,t),c(Us,t),c(ms,t),c(Ts,t),c(Is,t),c(v,t),c(ws,t),c(gs,t),c(fs,t),c(bs,t),c($s,t),c(Qs,t),c(Ns,t),c(xs,t),c(Bs,t),c(Gs,t),c(vs,t),c(Xs,t),c(ks,t),c(Es,t),c(Vs,t),c(X,t),c(Ws,t),c(Ss,t),c(Ys,t),c(Fs,t),c(Hs,t),c(Ls,t),c(Ds,t),c(Ks,t),c(Os,t),c(tl,t),c(ll,t),c(el,t),c(al,t),c(pl,t),c(ol,t),c(il,t),c(Ml,t),c(cl,t),c(ul,t),c(Jl,t),c(hl,t),c(Ul,t),c(wl,t),c(gl,t)}}}const no='{"title":"Dataset formats and types","local":"dataset-formats-and-types","sections":[{"title":"Overview of the dataset formats and types","local":"overview-of-the-dataset-formats-and-types","sections":[{"title":"Formats","local":"formats","sections":[{"title":"Standard","local":"standard","sections":[],"depth":4},{"title":"Conversational","local":"conversational","sections":[],"depth":4}],"depth":3},{"title":"Types","local":"types","sections":[{"title":"Language modeling","local":"language-modeling","sections":[],"depth":4},{"title":"Prompt-only","local":"prompt-only","sections":[],"depth":4},{"title":"Prompt-completion","local":"prompt-completion","sections":[],"depth":4},{"title":"Preference","local":"preference","sections":[],"depth":4},{"title":"Unpaired preference","local":"unpaired-preference","sections":[],"depth":4},{"title":"Stepwise supervision","local":"stepwise-supervision","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Which dataset type to use?","local":"which-dataset-type-to-use","sections":[],"depth":2},{"title":"Working with conversational datasets in TRL","local":"working-with-conversational-datasets-in-trl","sections":[{"title":"Converting a conversational dataset into a standard dataset","local":"converting-a-conversational-dataset-into-a-standard-dataset","sections":[],"depth":3}],"depth":2},{"title":"Using any dataset with TRL: preprocessing and conversion","local":"using-any-dataset-with-trl-preprocessing-and-conversion","sections":[{"title":"Example: UltraFeedback dataset","local":"example-ultrafeedback-dataset","sections":[],"depth":3}],"depth":2},{"title":"Utilities for converting dataset types","local":"utilities-for-converting-dataset-types","sections":[{"title":"From prompt-completion to language modeling dataset","local":"from-prompt-completion-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From prompt-completion to prompt-only dataset","local":"from-prompt-completion-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to language modeling dataset","local":"from-preference-with-implicit-prompt-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to prompt-completion dataset","local":"from-preference-with-implicit-prompt-to-prompt-completion-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to prompt-only dataset","local":"from-preference-with-implicit-prompt-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From implicit to explicit prompt preference dataset","local":"from-implicit-to-explicit-prompt-preference-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to unpaired preference dataset","local":"from-preference-with-implicit-prompt-to-unpaired-preference-dataset","sections":[],"depth":3},{"title":"From preference to language modeling dataset","local":"from-preference-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From preference to prompt-completion dataset","local":"from-preference-to-prompt-completion-dataset","sections":[],"depth":3},{"title":"From preference to prompt-only dataset","local":"from-preference-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From explicit to implicit prompt preference dataset","local":"from-explicit-to-implicit-prompt-preference-dataset","sections":[],"depth":3},{"title":"From preference to unpaired preference dataset","local":"from-preference-to-unpaired-preference-dataset","sections":[],"depth":3},{"title":"From unpaired preference to language modeling dataset","local":"from-unpaired-preference-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From unpaired preference to prompt-completion dataset","local":"from-unpaired-preference-to-prompt-completion-dataset","sections":[],"depth":3},{"title":"From unpaired preference to prompt-only dataset","local":"from-unpaired-preference-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From stepwise supervision to language modeling dataset","local":"from-stepwise-supervision-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From stepwise supervision to prompt completion dataset","local":"from-stepwise-supervision-to-prompt-completion-dataset","sections":[],"depth":3},{"title":"From stepwise supervision to prompt only dataset","local":"from-stepwise-supervision-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From stepwise supervision to unpaired preference dataset","local":"from-stepwise-supervision-to-unpaired-preference-dataset","sections":[],"depth":3}],"depth":2},{"title":"Vision datasets","local":"vision-datasets","sections":[],"depth":2}],"depth":1}';function po(f){return Fp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class uo extends _p{constructor(J){super(),Hp(this,J,po,ao,Yp,{})}}export{uo as component};
