import{s as fs,f as rt,n as hs,o as ws}from"../chunks/scheduler.37c15a92.js";import{S as Ts,i as Js,g as o,s,r as m,A as gs,h as i,f as l,c as a,j as ds,u as p,x as r,k as f,y as bs,a as n,v as M,d as c,t as u,w as y}from"../chunks/index.7cb9c9b8.js";import{C as h}from"../chunks/CodeBlock.a6d3f852.js";import{C as vs}from"../chunks/CourseFloatingBanner.36c274d0.js";import{H as d}from"../chunks/Heading.d3928e2a.js";function Us(an){let w,Mt,mt,ct,T,ut,J,yt,g,on=`The colab notebook:
<a href="https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit8/unit8_part2.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>`,dt,b,ft,v,rn,ht,U,mn='In this notebook, we will learn how to train a Deep Neural Network to collect objects in a 3D environment based on the game of Doom, a video of the resulting policy is shown below. We train this policy using <a href="https://www.samplefactory.dev/" rel="nofollow">Sample Factory</a>, an asynchronous implementation of the PPO algorithm.',wt,j,pn="Please note the following points:",Tt,Z,Mn='<li><p><a href="https://www.samplefactory.dev/" rel="nofollow">Sample Factory</a> is an advanced RL framework and <strong>only functions on Linux and Mac</strong> (not Windows).</p></li> <li><p>The framework performs best on a <strong>GPU machine with many CPU cores</strong>, where it can achieve speeds of 100k interactions per second. The resources available on a standard Colab notebook <strong>limit the performance of this library</strong>. So the speed in this setting <strong>does not reflect the real-world performance</strong>.</p></li> <li><p>Benchmarks for Sample Factory are available in a number of settings, check out the <a href="https://github.com/alex-petrenko/sample-factory/tree/master/sf_examples" rel="nofollow">examples</a> if you want to find out more.</p></li>',Jt,I,gt,_,cn='To validate this hands-on for the <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">certification process</a>, you need to push one model:',bt,k,un="<li><code>doom_health_gathering_supreme</code> get a result of &gt;= 5.</li>",vt,C,yn='To find your result, go to the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',Ut,$,dn="If you don’t find your model, <strong>go to the bottom of the page and click on the refresh button</strong>",jt,G,fn='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',Zt,B,It,W,hn="<li>To <strong>accelerate the agent’s training, we’ll use a GPU</strong>. To do that, go to <code>Runtime &gt; Change Runtime type</code></li>",_t,H,wn,kt,X,Tn="<li><code>Hardware Accelerator &gt; GPU</code></li>",Ct,V,Jn,$t,R,gn="Before starting to train our agent, let’s <strong>study the library and environments we’re going to use</strong>.",Gt,L,Bt,z,bn='<a href="https://www.samplefactory.dev/" rel="nofollow">Sample Factory</a> is one of the <strong>fastest RL libraries focused on very efficient synchronous and asynchronous implementations of policy gradients (PPO)</strong>.',Wt,q,vn="Sample Factory is thoroughly <strong>tested, used by many researchers and practitioners</strong>, and is actively maintained. Our implementation is known to <strong>reach SOTA performance in a variety of domains while minimizing RL experiment training time and hardware requirements</strong>.",Ht,x,Un,Xt,E,Vt,N,jn='<li>Highly optimized algorithm <a href="https://www.samplefactory.dev/06-architecture/overview/" rel="nofollow">architecture</a> for maximum learning throughput</li> <li><a href="https://www.samplefactory.dev/07-advanced-topics/sync-async/" rel="nofollow">Synchronous and asynchronous</a> training regimes</li> <li><a href="https://www.samplefactory.dev/07-advanced-topics/serial-mode/" rel="nofollow">Serial (single-process) mode</a> for easy debugging</li> <li>Optimal performance in both CPU-based and <a href="https://www.samplefactory.dev/09-environment-integrations/isaacgym/" rel="nofollow">GPU-accelerated environments</a></li> <li>Single- &amp; multi-agent training, self-play, supports <a href="https://www.samplefactory.dev/07-advanced-topics/multi-policy-training/" rel="nofollow">training multiple policies</a> at once on one or many GPUs</li> <li>Population-Based Training (<a href="https://www.samplefactory.dev/07-advanced-topics/pbt/" rel="nofollow">PBT</a>)</li> <li>Discrete, continuous, hybrid action spaces</li> <li>Vector-based, image-based, dictionary observation spaces</li> <li>Automatically creates a model architecture by parsing action/observation space specification. Supports <a href="https://www.samplefactory.dev/03-customization/custom-models/" rel="nofollow">custom model architectures</a></li> <li>Designed to be imported into other projects, <a href="https://www.samplefactory.dev/03-customization/custom-environments/" rel="nofollow">custom environments</a> are first-class citizens</li> <li>Detailed <a href="https://www.samplefactory.dev/05-monitoring/metrics-reference/" rel="nofollow">WandB and Tensorboard summaries</a>, <a href="https://www.samplefactory.dev/05-monitoring/custom-metrics/" rel="nofollow">custom metrics</a></li> <li><a href="https://www.samplefactory.dev/10-huggingface/huggingface/" rel="nofollow">HuggingFace 🤗 integration</a> (upload trained models and metrics to the Hub)</li> <li><a href="https://www.samplefactory.dev/09-environment-integrations/mujoco/" rel="nofollow">Multiple</a> <a href="https://www.samplefactory.dev/09-environment-integrations/atari/" rel="nofollow">example</a> <a href="https://www.samplefactory.dev/09-environment-integrations/vizdoom/" rel="nofollow">environment</a> <a href="https://www.samplefactory.dev/09-environment-integrations/dmlab/" rel="nofollow">integrations</a> with tuned parameters and trained models</li>',Rt,Y,Zn='All of the above policies are available on the 🤗 hub. Search for the tag <a href="https://huggingface.co/models?library=sample-factory&amp;sort=downloads" rel="nofollow">sample-factory</a>',Lt,S,zt,A,In="Sample-factory is one of the <strong>most highly optimized RL implementations available to the community</strong>.",qt,F,_n="It works by <strong>spawning multiple processes that run rollout workers, inference workers and a learner worker</strong>.",xt,Q,kn="The <em>workers</em> <strong>communicate through shared memory, which lowers the communication cost between processes</strong>.",Et,D,Cn="The <em>rollout workers</em> interact with the environment and send observations to the <em>inference workers</em>.",Nt,P,$n="The <em>inferences workers</em> query a fixed version of the policy and <strong>send actions back to the rollout worker</strong>.",Yt,K,Gn="After <em>k</em> steps the rollout works send a trajectory of experience to the learner worker, <strong>which it uses to update the agent’s policy network</strong>.",St,O,Bn,At,ee,Ft,te,Wn="Actor Critic models in Sample Factory are composed of three components:",Qt,le,Hn="<li><strong>Encoder</strong> - Process input observations (images, vectors) and map them to a vector. This is the part of the model you will most likely want to customize.</li> <li><strong>Core</strong> - Intergrate vectors from one or more encoders, can optionally include a single- or multi-layer LSTM/GRU in a memory-based agent.</li> <li><strong>Decoder</strong> - Apply additional layers to the output of the model core before computing the policy and value outputs.</li>",Dt,ne,Xn='The library has been designed to automatically support any observation and action spaces. Users can easily add their custom models. You can find out more in the <a href="https://www.samplefactory.dev/03-customization/custom-models/#actor-critic-models-in-sample-factory" rel="nofollow">documentation</a>.',Pt,se,Kt,ae,Vn='<a href="https://vizdoom.cs.put.edu.pl/" rel="nofollow">ViZDoom</a> is an <strong>open-source python interface for the Doom Engine</strong>.',Ot,oe,Rn="The library was created in 2016 by Marek Wydmuch, Michal Kempka  at the Institute of Computing Science, Poznan University of Technology, Poland.",el,ie,Ln="The library enables the <strong>training of agents directly from the screen pixels in a number of scenarios</strong>, including team deathmatch, shown in the video below. Because the ViZDoom environment is based on a game the was created in the 90s, it can be run on modern hardware at accelerated speeds, <strong>allowing us to learn complex AI behaviors fairly quickly</strong>.",tl,re,zn="The library includes feature such as:",ll,me,qn='<li>Multi-platform (Linux, macOS, Windows),</li> <li>API for Python and C++,</li> <li><a href="https://www.gymlibrary.dev/" rel="nofollow">OpenAI Gym</a> environment wrappers</li> <li>Easy-to-create custom scenarios (visual editors, scripting language, and examples available),</li> <li>Async and sync single-player and multiplayer modes,</li> <li>Lightweight (few MBs) and fast (up to 7000 fps in sync mode, single-threaded),</li> <li>Customizable resolution and rendering parameters,</li> <li>Access to the depth buffer (3D vision),</li> <li>Automatic labeling of game objects visible in the frame,</li> <li>Access to the audio buffer</li> <li>Access to the list of actors/objects and map geometry,</li> <li>Off-screen rendering and episode recording,</li> <li>Time scaling in async mode.</li>',nl,pe,sl,Me,xn="Now that our Colab runtime is set up, we can start by installing the dependencies required to run ViZDoom on linux.",al,ce,En='If you are following on your machine on Mac, you will want to follow the installation instructions on the <a href="https://github.com/Farama-Foundation/ViZDoom/blob/master/doc/Quickstart.md#-quickstart-for-macos-and-anaconda3-python-36" rel="nofollow">github page</a>.',ol,ue,il,ye,rl,de,Nn="<li>This can take 7min</li>",ml,fe,pl,he,Ml,we,cl,Te,Yn="Now that the setup if complete, we can train the agent. We have chosen here to learn a ViZDoom task called <code>Health Gathering Supreme</code>.",ul,Je,yl,ge,Sn,dl,be,An="The objective of this scenario is to <strong>teach the agent how to survive without knowing what makes it survive</strong>. The Agent know only that <strong>life is precious</strong> and death is bad so <strong>it must learn what prolongs its existence and that its health is connected with survival</strong>.",fl,ve,Fn="The map is a rectangle containing walls and with a green, acidic floor which <strong>hurts the player periodically</strong>. Initially there are some medkits spread uniformly over the map. A new medkit falls from the skies every now and then. <strong>Medkits heal some portions of player’s health</strong> - to survive, the agent needs to pick them up. The episode finishes after the player’s death or on timeout.",hl,Ue,Qn="Further configuration:",wl,je,Dn="<li>Living_reward = 1</li> <li>3 available buttons: turn left, turn right, move forward</li> <li>1 available game variable: HEALTH</li> <li>death penalty = 100</li>",Tl,Ze,Pn='You can find out more about the scenarios available in ViZDoom <a href="https://github.com/Farama-Foundation/ViZDoom/tree/master/scenarios" rel="nofollow">here</a>.',Jl,Ie,Kn='There are also a number of more complex scenarios that have been create for ViZDoom, such as the ones detailed on <a href="https://github.com/edbeeching/3d_control_deep_rl" rel="nofollow">this github page</a>.',gl,_e,bl,ke,On="<li>We’re going to train the agent for 4000000 steps. It will take approximately 20min</li>",vl,Ce,Ul,$e,jl,Ge,Zl,Be,Il,We,_l,He,es="The agent has learned something, but its performance could be better. We would clearly need to train for longer. But let’s upload this model to the Hub.",kl,Xe,Cl,Ve,ts="To be able to share your model with the community there are three more steps to follow:",$l,Re,ls='1️⃣ (If it’s not already done) create an account to HF ➡ <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a>',Gl,Le,ns="2️⃣ Sign in and get your authentication token from the Hugging Face website.",Bl,ze,ss='<li>Create a new token (<a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a>) <strong>with write role</strong></li>',Wl,qe,as,Hl,xe,os="<li>Copy the token</li> <li>Run the cell below and paste the token</li>",Xl,Ee,is="If you don’t want to use Google Colab or a Jupyter Notebook, you need to use this command instead: <code>huggingface-cli login</code>",Vl,Ne,Rl,Ye,Ll,Se,zl,Ae,rs="This agent’s performance was good, but we can do better! Let’s download and visualize an agent trained for 10B timesteps from the hub.",ql,Fe,xl,Qe,El,De,Nl,Pe,Yl,Ke,Sl,Oe,ms="Training an agent to play a Doom deathmatch <strong>takes many hours on a more beefy machine than is available in Colab</strong>.",Al,et,ps="Fortunately, we have have <strong>already trained an agent in this scenario and it is available in the 🤗 Hub!</strong> Let’s download the model and visualize the agent’s performance.",Fl,tt,Ql,lt,Ms="Given the agent plays for a long time the video generation can take <strong>10 minutes</strong>.",Dl,nt,Pl,st,cs=`You <strong>can try to train your agent in this environment</strong> using the code above, but not on colab.
<strong>Good luck 🤞</strong>`,Kl,at,us="If you prefer an easier scenario, <strong>why not try training in another ViZDoom scenario such as <code>doom_deadly_corridor</code> or <code>doom_defend_the_center</code>.</strong>",Ol,en,tn,ot,ys="This concludes the last unit. But we are not finished yet! 🤗 The following <strong>bonus section include some of the most interesting, advanced, and cutting edge work in Deep Reinforcement Learning</strong>.",ln,it,nn,pt,sn;return T=new d({props:{title:"Hands-on: advanced Deep Reinforcement Learning. Using Sample Factory to play Doom from pixels",local:"hands-on-advanced-deep-reinforcement-learning-using-sample-factory-to-play-doom-from-pixels",headingTag:"h1"}}),J=new vs({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/deep-rl-class/blob/main/notebooks/unit8/unit8_part2.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),b=new d({props:{title:"Unit 8 Part 2: Advanced Deep Reinforcement Learning. Using Sample Factory to play Doom from pixels",local:"unit-8-part-2-advanced-deep-reinforcement-learning-using-sample-factory-to-play-doom-from-pixels",headingTag:"h1"}}),I=new h({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEhUTUwlMEElMEFIVE1MKCUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUzQ3ZpZGVvJTIwd2lkdGglM0QlMjI2NDAlMjIlMjBoZWlnaHQlM0QlMjI0ODAlMjIlMjBjb250cm9scyUzRSUwQSUyMCUyMCUzQ3NvdXJjZSUyMHNyYyUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZlZGJlZWNoaW5nJTJGZG9vbV9oZWFsdGhfZ2F0aGVyaW5nX3N1cHJlbWVfMzMzMyUyRnJlc29sdmUlMkZtYWluJTJGcmVwbGF5Lm1wNCUyMiUwQSUyMCUyMHR5cGUlM0QlMjJ2aWRlbyUyRm1wNCUyMiUzRVlvdXIlMjBicm93c2VyJTIwZG9lcyUyMG5vdCUyMHN1cHBvcnQlMjB0aGUlMjB2aWRlbyUyMHRhZy4lM0MlMkZ2aWRlbyUzRSUyMiUyMiUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> HTML

HTML(
    <span class="hljs-string">&quot;&quot;&quot;&lt;video width=&quot;640&quot; height=&quot;480&quot; controls&gt;
  &lt;source src=&quot;https://huggingface.co/edbeeching/doom_health_gathering_supreme_3333/resolve/main/replay.mp4&quot;
  type=&quot;video/mp4&quot;&gt;Your browser does not support the video tag.&lt;/video&gt;&quot;&quot;&quot;</span>
)`,wrap:!1}}),B=new d({props:{title:"Set the GPU 💪",local:"set-the-gpu-",headingTag:"h2"}}),L=new d({props:{title:"Sample Factory",local:"sample-factory",headingTag:"h2"}}),E=new d({props:{title:"Key features",local:"key-features",headingTag:"h3"}}),S=new d({props:{title:"How sample-factory works",local:"how-sample-factory-works",headingTag:"h3"}}),ee=new d({props:{title:"Actor Critic models in Sample-factory",local:"actor-critic-models-in-sample-factory",headingTag:"h3"}}),se=new d({props:{title:"ViZDoom",local:"vizdoom",headingTag:"h2"}}),pe=new d({props:{title:"We first need to install some dependencies that are required for the ViZDoom environment",local:"we-first-need-to-install-some-dependencies-that-are-required-for-the-vizdoom-environment",headingTag:"h2"}}),ue=new h({props:{code:"JTIzJTIwSW5zdGFsbCUyMFZpWkRvb20lMjBkZXBzJTIwZnJvbSUwQSUyMyUyMGh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRm13eWRtdWNoJTJGVmlaRG9vbSUyRmJsb2IlMkZtYXN0ZXIlMkZkb2MlMkZCdWlsZGluZy5tZCUyMy1saW51eCUwQSUwQWFwdC1nZXQlMjBpbnN0YWxsJTIwYnVpbGQtZXNzZW50aWFsJTIwemxpYjFnLWRldiUyMGxpYnNkbDItZGV2JTIwbGlianBlZy1kZXYlMjAlNUMlMEFuYXNtJTIwdGFyJTIwbGliYnoyLWRldiUyMGxpYmd0azIuMC1kZXYlMjBjbWFrZSUyMGdpdCUyMGxpYmZsdWlkc3ludGgtZGV2JTIwbGliZ21lLWRldiUyMCU1QyUwQWxpYm9wZW5hbC1kZXYlMjB0aW1pZGl0eSUyMGxpYndpbGRtaWRpLWRldiUyMHVuemlwJTIwZmZtcGVnJTBBJTBBJTIzJTIwQm9vc3QlMjBsaWJyYXJpZXMlMEFhcHQtZ2V0JTIwaW5zdGFsbCUyMGxpYmJvb3N0LWFsbC1kZXYlMEElMEElMjMlMjBMdWElMjBiaW5kaW5nJTIwZGVwZW5kZW5jaWVzJTBBYXB0LWdldCUyMGluc3RhbGwlMjBsaWJsdWE1LjEtZGV2",highlighted:`<span class="hljs-comment"># Install ViZDoom deps from</span>
<span class="hljs-comment"># https://github.com/mwydmuch/ViZDoom/blob/master/doc/Building.md#-linux</span>

apt-get install build-essential zlib1g-dev libsdl2-dev libjpeg-dev \\
nasm tar libbz2-dev libgtk2<span class="hljs-number">.0</span>-dev cmake git libfluidsynth-dev libgme-dev \\
libopenal-dev timidity libwildmidi-dev unzip ffmpeg

<span class="hljs-comment"># Boost libraries</span>
apt-get install libboost-<span class="hljs-built_in">all</span>-dev

<span class="hljs-comment"># Lua binding dependencies</span>
apt-get install liblua5<span class="hljs-number">.1</span>-dev`,wrap:!1}}),ye=new d({props:{title:"Then we can install Sample Factory and ViZDoom",local:"then-we-can-install-sample-factory-and-vizdoom",headingTag:"h2"}}),fe=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNhbXBsZS1mYWN0b3J5JTBBcGlwJTIwaW5zdGFsbCUyMHZpemRvb20=",highlighted:`pip install sample-factory
pip install vizdoom`,wrap:!1}}),he=new d({props:{title:"Setting up the Doom Environment in sample-factory",local:"setting-up-the-doom-environment-in-sample-factory",headingTag:"h2"}}),we=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> functools

<span class="hljs-keyword">from</span> sample_factory.algo.utils.context <span class="hljs-keyword">import</span> global_model_factory
<span class="hljs-keyword">from</span> sample_factory.cfg.arguments <span class="hljs-keyword">import</span> parse_full_cfg, parse_sf_args
<span class="hljs-keyword">from</span> sample_factory.envs.env_utils <span class="hljs-keyword">import</span> register_env
<span class="hljs-keyword">from</span> sample_factory.train <span class="hljs-keyword">import</span> run_rl

<span class="hljs-keyword">from</span> sf_examples.vizdoom.doom.doom_model <span class="hljs-keyword">import</span> make_vizdoom_encoder
<span class="hljs-keyword">from</span> sf_examples.vizdoom.doom.doom_params <span class="hljs-keyword">import</span> add_doom_env_args, doom_override_defaults
<span class="hljs-keyword">from</span> sf_examples.vizdoom.doom.doom_utils <span class="hljs-keyword">import</span> DOOM_ENVS, make_doom_env_from_spec


<span class="hljs-comment"># Registers all the ViZDoom environments</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">register_vizdoom_envs</span>():
    <span class="hljs-keyword">for</span> env_spec <span class="hljs-keyword">in</span> DOOM_ENVS:
        make_env_func = functools.partial(make_doom_env_from_spec, env_spec)
        register_env(env_spec.name, make_env_func)


<span class="hljs-comment"># Sample Factory allows the registration of a custom Neural Network architecture</span>
<span class="hljs-comment"># See https://github.com/alex-petrenko/sample-factory/blob/master/sf_examples/vizdoom/doom/doom_model.py for more details</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">register_vizdoom_models</span>():
    global_model_factory().register_encoder_factory(make_vizdoom_encoder)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">register_vizdoom_components</span>():
    register_vizdoom_envs()
    register_vizdoom_models()


<span class="hljs-comment"># parse the command line args and create a config</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">parse_vizdoom_cfg</span>(<span class="hljs-params">argv=<span class="hljs-literal">None</span>, evaluation=<span class="hljs-literal">False</span></span>):
    parser, _ = parse_sf_args(argv=argv, evaluation=evaluation)
    <span class="hljs-comment"># parameters specific to Doom envs</span>
    add_doom_env_args(parser)
    <span class="hljs-comment"># override Doom default values for algo parameters</span>
    doom_override_defaults(parser)
    <span class="hljs-comment"># second parsing pass yields the final configuration</span>
    final_cfg = parse_full_cfg(parser, argv)
    <span class="hljs-keyword">return</span> final_cfg`,wrap:!1}}),Je=new d({props:{title:"The scenario: Health Gathering Supreme",local:"the-scenario-health-gathering-supreme",headingTag:"h3"}}),_e=new d({props:{title:"Training the agent",local:"training-the-agent",headingTag:"h2"}}),Ce=new h({props:{code:"JTIzJTIzJTIwU3RhcnQlMjB0aGUlMjB0cmFpbmluZyUyQyUyMHRoaXMlMjBzaG91bGQlMjB0YWtlJTIwYXJvdW5kJTIwMTUlMjBtaW51dGVzJTBBcmVnaXN0ZXJfdml6ZG9vbV9jb21wb25lbnRzKCklMEElMEElMjMlMjBUaGUlMjBzY2VuYXJpbyUyMHdlJTIwdHJhaW4lMjBvbiUyMHRvZGF5JTIwaXMlMjBoZWFsdGglMjBnYXRoZXJpbmclMEElMjMlMjBvdGhlciUyMHNjZW5hcmlvcyUyMGluY2x1ZGUlMjAlMjJkb29tX2Jhc2ljJTIyJTJDJTIwJTIyZG9vbV90d29fY29sb3JzX2Vhc3klMjIlMkMlMjAlMjJkb29tX2RtJTIyJTJDJTIwJTIyZG9vbV9kd2FuZ281JTIyJTJDJTIwJTIyZG9vbV9teV93YXlfaG9tZSUyMiUyQyUyMCUyMmRvb21fZGVhZGx5X2NvcnJpZG9yJTIyJTJDJTIwJTIyZG9vbV9kZWZlbmRfdGhlX2NlbnRlciUyMiUyQyUyMCUyMmRvb21fZGVmZW5kX3RoZV9saW5lJTIyJTBBZW52JTIwJTNEJTIwJTIyZG9vbV9oZWFsdGhfZ2F0aGVyaW5nX3N1cHJlbWUlMjIlMEFjZmclMjAlM0QlMjBwYXJzZV92aXpkb29tX2NmZyglMEElMjAlMjAlMjAlMjBhcmd2JTNEJTVCZiUyMi0tZW52JTNEJTdCZW52JTdEJTIyJTJDJTIwJTIyLS1udW1fd29ya2VycyUzRDglMjIlMkMlMjAlMjItLW51bV9lbnZzX3Blcl93b3JrZXIlM0Q0JTIyJTJDJTIwJTIyLS10cmFpbl9mb3JfZW52X3N0ZXBzJTNENDAwMDAwMCUyMiU1RCUwQSklMEElMEFzdGF0dXMlMjAlM0QlMjBydW5fcmwoY2ZnKQ==",highlighted:`<span class="hljs-comment">## Start the training, this should take around 15 minutes</span>
register_vizdoom_components()

<span class="hljs-comment"># The scenario we train on today is health gathering</span>
<span class="hljs-comment"># other scenarios include &quot;doom_basic&quot;, &quot;doom_two_colors_easy&quot;, &quot;doom_dm&quot;, &quot;doom_dwango5&quot;, &quot;doom_my_way_home&quot;, &quot;doom_deadly_corridor&quot;, &quot;doom_defend_the_center&quot;, &quot;doom_defend_the_line&quot;</span>
env = <span class="hljs-string">&quot;doom_health_gathering_supreme&quot;</span>
cfg = parse_vizdoom_cfg(
    argv=[<span class="hljs-string">f&quot;--env=<span class="hljs-subst">{env}</span>&quot;</span>, <span class="hljs-string">&quot;--num_workers=8&quot;</span>, <span class="hljs-string">&quot;--num_envs_per_worker=4&quot;</span>, <span class="hljs-string">&quot;--train_for_env_steps=4000000&quot;</span>]
)

status = run_rl(cfg)`,wrap:!1}}),$e=new d({props:{title:"Let’s take a look at the performance of the trained policy and output a video of the agent.",local:"lets-take-a-look-at-the-performance-of-the-trained-policy-and-output-a-video-of-the-agent",headingTag:"h2"}}),Ge=new h({props:{code:"ZnJvbSUyMHNhbXBsZV9mYWN0b3J5LmVuam95JTIwaW1wb3J0JTIwZW5qb3klMEElMEFjZmclMjAlM0QlMjBwYXJzZV92aXpkb29tX2NmZyglMEElMjAlMjAlMjAlMjBhcmd2JTNEJTVCZiUyMi0tZW52JTNEJTdCZW52JTdEJTIyJTJDJTIwJTIyLS1udW1fd29ya2VycyUzRDElMjIlMkMlMjAlMjItLXNhdmVfdmlkZW8lMjIlMkMlMjAlMjItLW5vX3JlbmRlciUyMiUyQyUyMCUyMi0tbWF4X251bV9lcGlzb2RlcyUzRDEwJTIyJTVEJTJDJTIwZXZhbHVhdGlvbiUzRFRydWUlMEEpJTBBc3RhdHVzJTIwJTNEJTIwZW5qb3koY2ZnKQ==",highlighted:`<span class="hljs-keyword">from</span> sample_factory.enjoy <span class="hljs-keyword">import</span> enjoy

cfg = parse_vizdoom_cfg(
    argv=[<span class="hljs-string">f&quot;--env=<span class="hljs-subst">{env}</span>&quot;</span>, <span class="hljs-string">&quot;--num_workers=1&quot;</span>, <span class="hljs-string">&quot;--save_video&quot;</span>, <span class="hljs-string">&quot;--no_render&quot;</span>, <span class="hljs-string">&quot;--max_num_episodes=10&quot;</span>], evaluation=<span class="hljs-literal">True</span>
)
status = enjoy(cfg)`,wrap:!1}}),Be=new d({props:{title:"Now lets visualize the performance of the agent",local:"now-lets-visualize-the-performance-of-the-agent",headingTag:"h2"}}),We=new h({props:{code:"ZnJvbSUyMGJhc2U2NCUyMGltcG9ydCUyMGI2NGVuY29kZSUwQWZyb20lMjBJUHl0aG9uLmRpc3BsYXklMjBpbXBvcnQlMjBIVE1MJTBBJTBBbXA0JTIwJTNEJTIwb3BlbiglMjIlMkZjb250ZW50JTJGdHJhaW5fZGlyJTJGZGVmYXVsdF9leHBlcmltZW50JTJGcmVwbGF5Lm1wNCUyMiUyQyUyMCUyMnJiJTIyKS5yZWFkKCklMEFkYXRhX3VybCUyMCUzRCUyMCUyMmRhdGElM0F2aWRlbyUyRm1wNCUzQmJhc2U2NCUyQyUyMiUyMCUyQiUyMGI2NGVuY29kZShtcDQpLmRlY29kZSgpJTBBSFRNTCglMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElM0N2aWRlbyUyMHdpZHRoJTNENjQwJTIwY29udHJvbHMlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0Nzb3VyY2UlMjBzcmMlM0QlMjIlMjVzJTIyJTIwdHlwZSUzRCUyMnZpZGVvJTJGbXA0JTIyJTNFJTBBJTNDJTJGdmlkZW8lM0UlMEElMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjUlMjBkYXRhX3VybCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> base64 <span class="hljs-keyword">import</span> b64encode
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> HTML

mp4 = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;/content/train_dir/default_experiment/replay.mp4&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>).read()
data_url = <span class="hljs-string">&quot;data:video/mp4;base64,&quot;</span> + b64encode(mp4).decode()
HTML(
    <span class="hljs-string">&quot;&quot;&quot;
&lt;video width=640 controls&gt;
      &lt;source src=&quot;%s&quot; type=&quot;video/mp4&quot;&gt;
&lt;/video&gt;
&quot;&quot;&quot;</span>
    % data_url
)`,wrap:!1}}),Xe=new d({props:{title:"Now lets upload your checkpoint and video to the Hugging Face Hub",local:"now-lets-upload-your-checkpoint-and-video-to-the-hugging-face-hub",headingTag:"h2"}}),Ne=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBbm90ZWJvb2tfbG9naW4oKSUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login
notebook_login()
!git config --<span class="hljs-keyword">global</span> credential.helper store`,wrap:!1}}),Ye=new h({props:{code:"ZnJvbSUyMHNhbXBsZV9mYWN0b3J5LmVuam95JTIwaW1wb3J0JTIwZW5qb3klMEElMEFoZl91c2VybmFtZSUyMCUzRCUyMCUyMlRob21hc1NpbW9uaW5pJTIyJTIwJTIwJTIzJTIwaW5zZXJ0JTIweW91ciUyMEh1Z2dpbmdGYWNlJTIwdXNlcm5hbWUlMjBoZXJlJTBBJTBBY2ZnJTIwJTNEJTIwcGFyc2Vfdml6ZG9vbV9jZmcoJTBBJTIwJTIwJTIwJTIwYXJndiUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjItLWVudiUzRCU3QmVudiU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tbnVtX3dvcmtlcnMlM0QxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1zYXZlX3ZpZGVvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1ub19yZW5kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLW1heF9udW1fZXBpc29kZXMlM0QxMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tbWF4X251bV9mcmFtZXMlM0QxMDAwMDAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLXB1c2hfdG9faHViJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMi0taGZfcmVwb3NpdG9yeSUzRCU3QmhmX3VzZXJuYW1lJTdEJTJGcmxfY291cnNlX3ZpemRvb21faGVhbHRoX2dhdGhlcmluZ19zdXByZW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbiUzRFRydWUlMkMlMEEpJTBBc3RhdHVzJTIwJTNEJTIwZW5qb3koY2ZnKQ==",highlighted:`<span class="hljs-keyword">from</span> sample_factory.enjoy <span class="hljs-keyword">import</span> enjoy

hf_username = <span class="hljs-string">&quot;ThomasSimonini&quot;</span>  <span class="hljs-comment"># insert your HuggingFace username here</span>

cfg = parse_vizdoom_cfg(
    argv=[
        <span class="hljs-string">f&quot;--env=<span class="hljs-subst">{env}</span>&quot;</span>,
        <span class="hljs-string">&quot;--num_workers=1&quot;</span>,
        <span class="hljs-string">&quot;--save_video&quot;</span>,
        <span class="hljs-string">&quot;--no_render&quot;</span>,
        <span class="hljs-string">&quot;--max_num_episodes=10&quot;</span>,
        <span class="hljs-string">&quot;--max_num_frames=100000&quot;</span>,
        <span class="hljs-string">&quot;--push_to_hub&quot;</span>,
        <span class="hljs-string">f&quot;--hf_repository=<span class="hljs-subst">{hf_username}</span>/rl_course_vizdoom_health_gathering_supreme&quot;</span>,
    ],
    evaluation=<span class="hljs-literal">True</span>,
)
status = enjoy(cfg)`,wrap:!1}}),Se=new d({props:{title:"Let’s load another model",local:"lets-load-another-model",headingTag:"h2"}}),Fe=new h({props:{code:"JTIzZG93bmxvYWQlMjB0aGUlMjBhZ2VudCUyMGZyb20lMjB0aGUlMjBodWIlMEFweXRob24lMjAtbSUyMHNhbXBsZV9mYWN0b3J5Lmh1Z2dpbmdmYWNlLmxvYWRfZnJvbV9odWIlMjAtciUyMGVkYmVlY2hpbmclMkZkb29tX2hlYWx0aF9nYXRoZXJpbmdfc3VwcmVtZV8yMjIyJTIwLWQlMjAuJTJGdHJhaW5fZGly",highlighted:`<span class="hljs-comment">#download the agent from the hub</span>
python -m sample_factory.huggingface.load_from_hub -r edbeeching/doom_health_gathering_supreme_2222 -d ./train_dir`,wrap:!1}}),Qe=new h({props:{code:"bHMlMjB0cmFpbl9kaXIlMkZkb29tX2hlYWx0aF9nYXRoZXJpbmdfc3VwcmVtZV8yMjIy",highlighted:'<span class="hljs-built_in">ls</span> train_dir/doom_health_gathering_supreme_2222',wrap:!1}}),De=new h({props:{code:"ZW52JTIwJTNEJTIwJTIyZG9vbV9oZWFsdGhfZ2F0aGVyaW5nX3N1cHJlbWUlMjIlMEFjZmclMjAlM0QlMjBwYXJzZV92aXpkb29tX2NmZyglMEElMjAlMjAlMjAlMjBhcmd2JTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMi0tZW52JTNEJTdCZW52JTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1udW1fd29ya2VycyUzRDElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLXNhdmVfdmlkZW8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLW5vX3JlbmRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tbWF4X251bV9lcGlzb2RlcyUzRDEwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1leHBlcmltZW50JTNEZG9vbV9oZWFsdGhfZ2F0aGVyaW5nX3N1cHJlbWVfMjIyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tdHJhaW5fZGlyJTNEdHJhaW5fZGlyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbiUzRFRydWUlMkMlMEEpJTBBc3RhdHVzJTIwJTNEJTIwZW5qb3koY2ZnKQ==",highlighted:`env = <span class="hljs-string">&quot;doom_health_gathering_supreme&quot;</span>
cfg = parse_vizdoom_cfg(
    argv=[
        <span class="hljs-string">f&quot;--env=<span class="hljs-subst">{env}</span>&quot;</span>,
        <span class="hljs-string">&quot;--num_workers=1&quot;</span>,
        <span class="hljs-string">&quot;--save_video&quot;</span>,
        <span class="hljs-string">&quot;--no_render&quot;</span>,
        <span class="hljs-string">&quot;--max_num_episodes=10&quot;</span>,
        <span class="hljs-string">&quot;--experiment=doom_health_gathering_supreme_2222&quot;</span>,
        <span class="hljs-string">&quot;--train_dir=train_dir&quot;</span>,
    ],
    evaluation=<span class="hljs-literal">True</span>,
)
status = enjoy(cfg)`,wrap:!1}}),Pe=new h({props:{code:"bXA0JTIwJTNEJTIwb3BlbiglMjIlMkZjb250ZW50JTJGdHJhaW5fZGlyJTJGZG9vbV9oZWFsdGhfZ2F0aGVyaW5nX3N1cHJlbWVfMjIyMiUyRnJlcGxheS5tcDQlMjIlMkMlMjAlMjJyYiUyMikucmVhZCgpJTBBZGF0YV91cmwlMjAlM0QlMjAlMjJkYXRhJTNBdmlkZW8lMkZtcDQlM0JiYXNlNjQlMkMlMjIlMjAlMkIlMjBiNjRlbmNvZGUobXA0KS5kZWNvZGUoKSUwQUhUTUwoJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTNDdmlkZW8lMjB3aWR0aCUzRDY0MCUyMGNvbnRyb2xzJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTNDc291cmNlJTIwc3JjJTNEJTIyJTI1cyUyMiUyMHR5cGUlM0QlMjJ2aWRlbyUyRm1wNCUyMiUzRSUwQSUzQyUyRnZpZGVvJTNFJTBBJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTI1JTIwZGF0YV91cmwlMEEp",highlighted:`mp4 = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;/content/train_dir/doom_health_gathering_supreme_2222/replay.mp4&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>).read()
data_url = <span class="hljs-string">&quot;data:video/mp4;base64,&quot;</span> + b64encode(mp4).decode()
HTML(
    <span class="hljs-string">&quot;&quot;&quot;
&lt;video width=640 controls&gt;
      &lt;source src=&quot;%s&quot; type=&quot;video/mp4&quot;&gt;
&lt;/video&gt;
&quot;&quot;&quot;</span>
    % data_url
)`,wrap:!1}}),Ke=new d({props:{title:"Some additional challenges 🏆: Doom Deathmatch",local:"some-additional-challenges--doom-deathmatch",headingTag:"h2"}}),tt=new h({props:{code:"JTIzJTIwRG93bmxvYWQlMjB0aGUlMjBhZ2VudCUyMGZyb20lMjB0aGUlMjBodWIlMEFweXRob24lMjAtbSUyMHNhbXBsZV9mYWN0b3J5Lmh1Z2dpbmdmYWNlLmxvYWRfZnJvbV9odWIlMjAtciUyMGVkYmVlY2hpbmclMkZkb29tX2RlYXRobWF0Y2hfYm90c18yMjIyJTIwLWQlMjAuJTJGdHJhaW5fZGly",highlighted:`<span class="hljs-comment"># Download the agent from the hub</span>
python -m sample_factory.huggingface.load_from_hub -r edbeeching/doom_deathmatch_bots_2222 -d ./train_dir`,wrap:!1}}),nt=new h({props:{code:"ZnJvbSUyMHNhbXBsZV9mYWN0b3J5LmVuam95JTIwaW1wb3J0JTIwZW5qb3klMEElMEFyZWdpc3Rlcl92aXpkb29tX2NvbXBvbmVudHMoKSUwQWVudiUyMCUzRCUyMCUyMmRvb21fZGVhdGhtYXRjaF9ib3RzJTIyJTBBY2ZnJTIwJTNEJTIwcGFyc2Vfdml6ZG9vbV9jZmcoJTBBJTIwJTIwJTIwJTIwYXJndiUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjItLWVudiUzRCU3QmVudiU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tbnVtX3dvcmtlcnMlM0QxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1zYXZlX3ZpZGVvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1ub19yZW5kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLW1heF9udW1fZXBpc29kZXMlM0QxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1leHBlcmltZW50JTNEZG9vbV9kZWF0aG1hdGNoX2JvdHNfMjIyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tdHJhaW5fZGlyJTNEdHJhaW5fZGlyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbiUzRFRydWUlMkMlMEEpJTBBc3RhdHVzJTIwJTNEJTIwZW5qb3koY2ZnKSUwQW1wNCUyMCUzRCUyMG9wZW4oJTIyJTJGY29udGVudCUyRnRyYWluX2RpciUyRmRvb21fZGVhdGhtYXRjaF9ib3RzXzIyMjIlMkZyZXBsYXkubXA0JTIyJTJDJTIwJTIycmIlMjIpLnJlYWQoKSUwQWRhdGFfdXJsJTIwJTNEJTIwJTIyZGF0YSUzQXZpZGVvJTJGbXA0JTNCYmFzZTY0JTJDJTIyJTIwJTJCJTIwYjY0ZW5jb2RlKG1wNCkuZGVjb2RlKCklMEFIVE1MKCUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUzQ3ZpZGVvJTIwd2lkdGglM0Q2NDAlMjBjb250cm9scyUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUzQ3NvdXJjZSUyMHNyYyUzRCUyMiUyNXMlMjIlMjB0eXBlJTNEJTIydmlkZW8lMkZtcDQlMjIlM0UlMEElM0MlMkZ2aWRlbyUzRSUwQSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyNSUyMGRhdGFfdXJsJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> sample_factory.enjoy <span class="hljs-keyword">import</span> enjoy

register_vizdoom_components()
env = <span class="hljs-string">&quot;doom_deathmatch_bots&quot;</span>
cfg = parse_vizdoom_cfg(
    argv=[
        <span class="hljs-string">f&quot;--env=<span class="hljs-subst">{env}</span>&quot;</span>,
        <span class="hljs-string">&quot;--num_workers=1&quot;</span>,
        <span class="hljs-string">&quot;--save_video&quot;</span>,
        <span class="hljs-string">&quot;--no_render&quot;</span>,
        <span class="hljs-string">&quot;--max_num_episodes=1&quot;</span>,
        <span class="hljs-string">&quot;--experiment=doom_deathmatch_bots_2222&quot;</span>,
        <span class="hljs-string">&quot;--train_dir=train_dir&quot;</span>,
    ],
    evaluation=<span class="hljs-literal">True</span>,
)
status = enjoy(cfg)
mp4 = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;/content/train_dir/doom_deathmatch_bots_2222/replay.mp4&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>).read()
data_url = <span class="hljs-string">&quot;data:video/mp4;base64,&quot;</span> + b64encode(mp4).decode()
HTML(
    <span class="hljs-string">&quot;&quot;&quot;
&lt;video width=640 controls&gt;
      &lt;source src=&quot;%s&quot; type=&quot;video/mp4&quot;&gt;
&lt;/video&gt;
&quot;&quot;&quot;</span>
    % data_url
)`,wrap:!1}}),it=new d({props:{title:"Keep learning, stay awesome 🤗",local:"keep-learning-stay-awesome-",headingTag:"h2"}}),{c(){w=o("meta"),Mt=s(),mt=o("p"),ct=s(),m(T.$$.fragment),ut=s(),m(J.$$.fragment),yt=s(),g=o("p"),g.innerHTML=on,dt=s(),m(b.$$.fragment),ft=s(),v=o("img"),ht=s(),U=o("p"),U.innerHTML=mn,wt=s(),j=o("p"),j.textContent=pn,Tt=s(),Z=o("ul"),Z.innerHTML=Mn,Jt=s(),m(I.$$.fragment),gt=s(),_=o("p"),_.innerHTML=cn,bt=s(),k=o("ul"),k.innerHTML=un,vt=s(),C=o("p"),C.innerHTML=yn,Ut=s(),$=o("p"),$.innerHTML=dn,jt=s(),G=o("p"),G.innerHTML=fn,Zt=s(),m(B.$$.fragment),It=s(),W=o("ul"),W.innerHTML=hn,_t=s(),H=o("img"),kt=s(),X=o("ul"),X.innerHTML=Tn,Ct=s(),V=o("img"),$t=s(),R=o("p"),R.innerHTML=gn,Gt=s(),m(L.$$.fragment),Bt=s(),z=o("p"),z.innerHTML=bn,Wt=s(),q=o("p"),q.innerHTML=vn,Ht=s(),x=o("img"),Xt=s(),m(E.$$.fragment),Vt=s(),N=o("ul"),N.innerHTML=jn,Rt=s(),Y=o("p"),Y.innerHTML=Zn,Lt=s(),m(S.$$.fragment),zt=s(),A=o("p"),A.innerHTML=In,qt=s(),F=o("p"),F.innerHTML=_n,xt=s(),Q=o("p"),Q.innerHTML=kn,Et=s(),D=o("p"),D.innerHTML=Cn,Nt=s(),P=o("p"),P.innerHTML=$n,Yt=s(),K=o("p"),K.innerHTML=Gn,St=s(),O=o("img"),At=s(),m(ee.$$.fragment),Ft=s(),te=o("p"),te.textContent=Wn,Qt=s(),le=o("ul"),le.innerHTML=Hn,Dt=s(),ne=o("p"),ne.innerHTML=Xn,Pt=s(),m(se.$$.fragment),Kt=s(),ae=o("p"),ae.innerHTML=Vn,Ot=s(),oe=o("p"),oe.textContent=Rn,el=s(),ie=o("p"),ie.innerHTML=Ln,tl=s(),re=o("p"),re.textContent=zn,ll=s(),me=o("ul"),me.innerHTML=qn,nl=s(),m(pe.$$.fragment),sl=s(),Me=o("p"),Me.textContent=xn,al=s(),ce=o("p"),ce.innerHTML=En,ol=s(),m(ue.$$.fragment),il=s(),m(ye.$$.fragment),rl=s(),de=o("ul"),de.innerHTML=Nn,ml=s(),m(fe.$$.fragment),pl=s(),m(he.$$.fragment),Ml=s(),m(we.$$.fragment),cl=s(),Te=o("p"),Te.innerHTML=Yn,ul=s(),m(Je.$$.fragment),yl=s(),ge=o("img"),dl=s(),be=o("p"),be.innerHTML=An,fl=s(),ve=o("p"),ve.innerHTML=Fn,hl=s(),Ue=o("p"),Ue.textContent=Qn,wl=s(),je=o("ul"),je.innerHTML=Dn,Tl=s(),Ze=o("p"),Ze.innerHTML=Pn,Jl=s(),Ie=o("p"),Ie.innerHTML=Kn,gl=s(),m(_e.$$.fragment),bl=s(),ke=o("ul"),ke.innerHTML=On,vl=s(),m(Ce.$$.fragment),Ul=s(),m($e.$$.fragment),jl=s(),m(Ge.$$.fragment),Zl=s(),m(Be.$$.fragment),Il=s(),m(We.$$.fragment),_l=s(),He=o("p"),He.textContent=es,kl=s(),m(Xe.$$.fragment),Cl=s(),Ve=o("p"),Ve.textContent=ts,$l=s(),Re=o("p"),Re.innerHTML=ls,Gl=s(),Le=o("p"),Le.textContent=ns,Bl=s(),ze=o("ul"),ze.innerHTML=ss,Wl=s(),qe=o("img"),Hl=s(),xe=o("ul"),xe.innerHTML=os,Xl=s(),Ee=o("p"),Ee.innerHTML=is,Vl=s(),m(Ne.$$.fragment),Rl=s(),m(Ye.$$.fragment),Ll=s(),m(Se.$$.fragment),zl=s(),Ae=o("p"),Ae.textContent=rs,ql=s(),m(Fe.$$.fragment),xl=s(),m(Qe.$$.fragment),El=s(),m(De.$$.fragment),Nl=s(),m(Pe.$$.fragment),Yl=s(),m(Ke.$$.fragment),Sl=s(),Oe=o("p"),Oe.innerHTML=ms,Al=s(),et=o("p"),et.innerHTML=ps,Fl=s(),m(tt.$$.fragment),Ql=s(),lt=o("p"),lt.innerHTML=Ms,Dl=s(),m(nt.$$.fragment),Pl=s(),st=o("p"),st.innerHTML=cs,Kl=s(),at=o("p"),at.innerHTML=us,Ol=s(),en=o("hr"),tn=s(),ot=o("p"),ot.innerHTML=ys,ln=s(),m(it.$$.fragment),nn=s(),pt=o("p"),this.h()},l(e){const t=gs("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(l),Mt=a(e),mt=i(e,"P",{}),ds(mt).forEach(l),ct=a(e),p(T.$$.fragment,e),ut=a(e),p(J.$$.fragment,e),yt=a(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1rvwns4"&&(g.innerHTML=on),dt=a(e),p(b.$$.fragment,e),ft=a(e),v=i(e,"IMG",{src:!0,alt:!0}),ht=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1emi8cy"&&(U.innerHTML=mn),wt=a(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1r1z9s5"&&(j.textContent=pn),Tt=a(e),Z=i(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-14d2rd7"&&(Z.innerHTML=Mn),Jt=a(e),p(I.$$.fragment,e),gt=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1aajwkw"&&(_.innerHTML=cn),bt=a(e),k=i(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-17i4cff"&&(k.innerHTML=un),vt=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-lt0dbq"&&(C.innerHTML=yn),Ut=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-19noeh0"&&($.innerHTML=dn),jt=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1qkxyrx"&&(G.innerHTML=fn),Zt=a(e),p(B.$$.fragment,e),It=a(e),W=i(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-1funvfi"&&(W.innerHTML=hn),_t=a(e),H=i(e,"IMG",{src:!0,alt:!0}),kt=a(e),X=i(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-1cge6gn"&&(X.innerHTML=Tn),Ct=a(e),V=i(e,"IMG",{src:!0,alt:!0}),$t=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1s4z5f"&&(R.innerHTML=gn),Gt=a(e),p(L.$$.fragment,e),Bt=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1x4am13"&&(z.innerHTML=bn),Wt=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-2jys3z"&&(q.innerHTML=vn),Ht=a(e),x=i(e,"IMG",{src:!0,alt:!0}),Xt=a(e),p(E.$$.fragment,e),Vt=a(e),N=i(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-fckxaw"&&(N.innerHTML=jn),Rt=a(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-10g6all"&&(Y.innerHTML=Zn),Lt=a(e),p(S.$$.fragment,e),zt=a(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1x9lpru"&&(A.innerHTML=In),qt=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1n6rwii"&&(F.innerHTML=_n),xt=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-15dyw52"&&(Q.innerHTML=kn),Et=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1smvsi5"&&(D.innerHTML=Cn),Nt=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-hrlu55"&&(P.innerHTML=$n),Yt=a(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1j1f3jo"&&(K.innerHTML=Gn),St=a(e),O=i(e,"IMG",{src:!0,alt:!0}),At=a(e),p(ee.$$.fragment,e),Ft=a(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-gd99jz"&&(te.textContent=Wn),Qt=a(e),le=i(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-ct17ue"&&(le.innerHTML=Hn),Dt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-89bve0"&&(ne.innerHTML=Xn),Pt=a(e),p(se.$$.fragment,e),Kt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-60uig6"&&(ae.innerHTML=Vn),Ot=a(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-wd45l7"&&(oe.textContent=Rn),el=a(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-7tc00l"&&(ie.innerHTML=Ln),tl=a(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-j6e0v0"&&(re.textContent=zn),ll=a(e),me=i(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-120m9nl"&&(me.innerHTML=qn),nl=a(e),p(pe.$$.fragment,e),sl=a(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-eon89t"&&(Me.textContent=xn),al=a(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-bboubd"&&(ce.innerHTML=En),ol=a(e),p(ue.$$.fragment,e),il=a(e),p(ye.$$.fragment,e),rl=a(e),de=i(e,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-1az788b"&&(de.innerHTML=Nn),ml=a(e),p(fe.$$.fragment,e),pl=a(e),p(he.$$.fragment,e),Ml=a(e),p(we.$$.fragment,e),cl=a(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1f19xzu"&&(Te.innerHTML=Yn),ul=a(e),p(Je.$$.fragment,e),yl=a(e),ge=i(e,"IMG",{src:!0,alt:!0}),dl=a(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1trz4y3"&&(be.innerHTML=An),fl=a(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1s302cc"&&(ve.innerHTML=Fn),hl=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-g7fw6"&&(Ue.textContent=Qn),wl=a(e),je=i(e,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-7pwo6w"&&(je.innerHTML=Dn),Tl=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-zzrzje"&&(Ze.innerHTML=Pn),Jl=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-xo5xn7"&&(Ie.innerHTML=Kn),gl=a(e),p(_e.$$.fragment,e),bl=a(e),ke=i(e,"UL",{"data-svelte-h":!0}),r(ke)!=="svelte-18mvbc9"&&(ke.innerHTML=On),vl=a(e),p(Ce.$$.fragment,e),Ul=a(e),p($e.$$.fragment,e),jl=a(e),p(Ge.$$.fragment,e),Zl=a(e),p(Be.$$.fragment,e),Il=a(e),p(We.$$.fragment,e),_l=a(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1fqobdf"&&(He.textContent=es),kl=a(e),p(Xe.$$.fragment,e),Cl=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-6k9qpu"&&(Ve.textContent=ts),$l=a(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-932u9c"&&(Re.innerHTML=ls),Gl=a(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-adopwf"&&(Le.textContent=ns),Bl=a(e),ze=i(e,"UL",{"data-svelte-h":!0}),r(ze)!=="svelte-19b5tev"&&(ze.innerHTML=ss),Wl=a(e),qe=i(e,"IMG",{src:!0,alt:!0}),Hl=a(e),xe=i(e,"UL",{"data-svelte-h":!0}),r(xe)!=="svelte-mbo7r4"&&(xe.innerHTML=os),Xl=a(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1gq4mmb"&&(Ee.innerHTML=is),Vl=a(e),p(Ne.$$.fragment,e),Rl=a(e),p(Ye.$$.fragment,e),Ll=a(e),p(Se.$$.fragment,e),zl=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-10mw4u3"&&(Ae.textContent=rs),ql=a(e),p(Fe.$$.fragment,e),xl=a(e),p(Qe.$$.fragment,e),El=a(e),p(De.$$.fragment,e),Nl=a(e),p(Pe.$$.fragment,e),Yl=a(e),p(Ke.$$.fragment,e),Sl=a(e),Oe=i(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-dn0c28"&&(Oe.innerHTML=ms),Al=a(e),et=i(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1pu1now"&&(et.innerHTML=ps),Fl=a(e),p(tt.$$.fragment,e),Ql=a(e),lt=i(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-una3pz"&&(lt.innerHTML=Ms),Dl=a(e),p(nt.$$.fragment,e),Pl=a(e),st=i(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-2fsgzg"&&(st.innerHTML=cs),Kl=a(e),at=i(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1sdymzl"&&(at.innerHTML=us),Ol=a(e),en=i(e,"HR",{}),tn=a(e),ot=i(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-oaatl0"&&(ot.innerHTML=ys),ln=a(e),p(it.$$.fragment,e),nn=a(e),pt=i(e,"P",{}),ds(pt).forEach(l),this.h()},h(){f(w,"name","hf:doc:metadata"),f(w,"content",js),rt(v.src,rn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/thumbnail2.png")||f(v,"src",rn),f(v,"alt","Thumbnail"),rt(H.src,wn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step1.jpg")||f(H,"src",wn),f(H,"alt","GPU Step 1"),rt(V.src,Jn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step2.jpg")||f(V,"src",Jn),f(V,"alt","GPU Step 2"),rt(x.src,Un="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/samplefactoryenvs.png")||f(x,"src",Un),f(x,"alt","Sample factory"),rt(O.src,Bn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/samplefactory.png")||f(O,"src",Bn),f(O,"alt","Sample factory"),rt(ge.src,Sn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/Health-Gathering-Supreme.png")||f(ge,"src",Sn),f(ge,"alt","Health-Gathering-Supreme"),rt(qe.src,as="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/create-token.jpg")||f(qe,"src",as),f(qe,"alt","Create HF Token")},m(e,t){bs(document.head,w),n(e,Mt,t),n(e,mt,t),n(e,ct,t),M(T,e,t),n(e,ut,t),M(J,e,t),n(e,yt,t),n(e,g,t),n(e,dt,t),M(b,e,t),n(e,ft,t),n(e,v,t),n(e,ht,t),n(e,U,t),n(e,wt,t),n(e,j,t),n(e,Tt,t),n(e,Z,t),n(e,Jt,t),M(I,e,t),n(e,gt,t),n(e,_,t),n(e,bt,t),n(e,k,t),n(e,vt,t),n(e,C,t),n(e,Ut,t),n(e,$,t),n(e,jt,t),n(e,G,t),n(e,Zt,t),M(B,e,t),n(e,It,t),n(e,W,t),n(e,_t,t),n(e,H,t),n(e,kt,t),n(e,X,t),n(e,Ct,t),n(e,V,t),n(e,$t,t),n(e,R,t),n(e,Gt,t),M(L,e,t),n(e,Bt,t),n(e,z,t),n(e,Wt,t),n(e,q,t),n(e,Ht,t),n(e,x,t),n(e,Xt,t),M(E,e,t),n(e,Vt,t),n(e,N,t),n(e,Rt,t),n(e,Y,t),n(e,Lt,t),M(S,e,t),n(e,zt,t),n(e,A,t),n(e,qt,t),n(e,F,t),n(e,xt,t),n(e,Q,t),n(e,Et,t),n(e,D,t),n(e,Nt,t),n(e,P,t),n(e,Yt,t),n(e,K,t),n(e,St,t),n(e,O,t),n(e,At,t),M(ee,e,t),n(e,Ft,t),n(e,te,t),n(e,Qt,t),n(e,le,t),n(e,Dt,t),n(e,ne,t),n(e,Pt,t),M(se,e,t),n(e,Kt,t),n(e,ae,t),n(e,Ot,t),n(e,oe,t),n(e,el,t),n(e,ie,t),n(e,tl,t),n(e,re,t),n(e,ll,t),n(e,me,t),n(e,nl,t),M(pe,e,t),n(e,sl,t),n(e,Me,t),n(e,al,t),n(e,ce,t),n(e,ol,t),M(ue,e,t),n(e,il,t),M(ye,e,t),n(e,rl,t),n(e,de,t),n(e,ml,t),M(fe,e,t),n(e,pl,t),M(he,e,t),n(e,Ml,t),M(we,e,t),n(e,cl,t),n(e,Te,t),n(e,ul,t),M(Je,e,t),n(e,yl,t),n(e,ge,t),n(e,dl,t),n(e,be,t),n(e,fl,t),n(e,ve,t),n(e,hl,t),n(e,Ue,t),n(e,wl,t),n(e,je,t),n(e,Tl,t),n(e,Ze,t),n(e,Jl,t),n(e,Ie,t),n(e,gl,t),M(_e,e,t),n(e,bl,t),n(e,ke,t),n(e,vl,t),M(Ce,e,t),n(e,Ul,t),M($e,e,t),n(e,jl,t),M(Ge,e,t),n(e,Zl,t),M(Be,e,t),n(e,Il,t),M(We,e,t),n(e,_l,t),n(e,He,t),n(e,kl,t),M(Xe,e,t),n(e,Cl,t),n(e,Ve,t),n(e,$l,t),n(e,Re,t),n(e,Gl,t),n(e,Le,t),n(e,Bl,t),n(e,ze,t),n(e,Wl,t),n(e,qe,t),n(e,Hl,t),n(e,xe,t),n(e,Xl,t),n(e,Ee,t),n(e,Vl,t),M(Ne,e,t),n(e,Rl,t),M(Ye,e,t),n(e,Ll,t),M(Se,e,t),n(e,zl,t),n(e,Ae,t),n(e,ql,t),M(Fe,e,t),n(e,xl,t),M(Qe,e,t),n(e,El,t),M(De,e,t),n(e,Nl,t),M(Pe,e,t),n(e,Yl,t),M(Ke,e,t),n(e,Sl,t),n(e,Oe,t),n(e,Al,t),n(e,et,t),n(e,Fl,t),M(tt,e,t),n(e,Ql,t),n(e,lt,t),n(e,Dl,t),M(nt,e,t),n(e,Pl,t),n(e,st,t),n(e,Kl,t),n(e,at,t),n(e,Ol,t),n(e,en,t),n(e,tn,t),n(e,ot,t),n(e,ln,t),M(it,e,t),n(e,nn,t),n(e,pt,t),sn=!0},p:hs,i(e){sn||(c(T.$$.fragment,e),c(J.$$.fragment,e),c(b.$$.fragment,e),c(I.$$.fragment,e),c(B.$$.fragment,e),c(L.$$.fragment,e),c(E.$$.fragment,e),c(S.$$.fragment,e),c(ee.$$.fragment,e),c(se.$$.fragment,e),c(pe.$$.fragment,e),c(ue.$$.fragment,e),c(ye.$$.fragment,e),c(fe.$$.fragment,e),c(he.$$.fragment,e),c(we.$$.fragment,e),c(Je.$$.fragment,e),c(_e.$$.fragment,e),c(Ce.$$.fragment,e),c($e.$$.fragment,e),c(Ge.$$.fragment,e),c(Be.$$.fragment,e),c(We.$$.fragment,e),c(Xe.$$.fragment,e),c(Ne.$$.fragment,e),c(Ye.$$.fragment,e),c(Se.$$.fragment,e),c(Fe.$$.fragment,e),c(Qe.$$.fragment,e),c(De.$$.fragment,e),c(Pe.$$.fragment,e),c(Ke.$$.fragment,e),c(tt.$$.fragment,e),c(nt.$$.fragment,e),c(it.$$.fragment,e),sn=!0)},o(e){u(T.$$.fragment,e),u(J.$$.fragment,e),u(b.$$.fragment,e),u(I.$$.fragment,e),u(B.$$.fragment,e),u(L.$$.fragment,e),u(E.$$.fragment,e),u(S.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(pe.$$.fragment,e),u(ue.$$.fragment,e),u(ye.$$.fragment,e),u(fe.$$.fragment,e),u(he.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),u(_e.$$.fragment,e),u(Ce.$$.fragment,e),u($e.$$.fragment,e),u(Ge.$$.fragment,e),u(Be.$$.fragment,e),u(We.$$.fragment,e),u(Xe.$$.fragment,e),u(Ne.$$.fragment,e),u(Ye.$$.fragment,e),u(Se.$$.fragment,e),u(Fe.$$.fragment,e),u(Qe.$$.fragment,e),u(De.$$.fragment,e),u(Pe.$$.fragment,e),u(Ke.$$.fragment,e),u(tt.$$.fragment,e),u(nt.$$.fragment,e),u(it.$$.fragment,e),sn=!1},d(e){e&&(l(Mt),l(mt),l(ct),l(ut),l(yt),l(g),l(dt),l(ft),l(v),l(ht),l(U),l(wt),l(j),l(Tt),l(Z),l(Jt),l(gt),l(_),l(bt),l(k),l(vt),l(C),l(Ut),l($),l(jt),l(G),l(Zt),l(It),l(W),l(_t),l(H),l(kt),l(X),l(Ct),l(V),l($t),l(R),l(Gt),l(Bt),l(z),l(Wt),l(q),l(Ht),l(x),l(Xt),l(Vt),l(N),l(Rt),l(Y),l(Lt),l(zt),l(A),l(qt),l(F),l(xt),l(Q),l(Et),l(D),l(Nt),l(P),l(Yt),l(K),l(St),l(O),l(At),l(Ft),l(te),l(Qt),l(le),l(Dt),l(ne),l(Pt),l(Kt),l(ae),l(Ot),l(oe),l(el),l(ie),l(tl),l(re),l(ll),l(me),l(nl),l(sl),l(Me),l(al),l(ce),l(ol),l(il),l(rl),l(de),l(ml),l(pl),l(Ml),l(cl),l(Te),l(ul),l(yl),l(ge),l(dl),l(be),l(fl),l(ve),l(hl),l(Ue),l(wl),l(je),l(Tl),l(Ze),l(Jl),l(Ie),l(gl),l(bl),l(ke),l(vl),l(Ul),l(jl),l(Zl),l(Il),l(_l),l(He),l(kl),l(Cl),l(Ve),l($l),l(Re),l(Gl),l(Le),l(Bl),l(ze),l(Wl),l(qe),l(Hl),l(xe),l(Xl),l(Ee),l(Vl),l(Rl),l(Ll),l(zl),l(Ae),l(ql),l(xl),l(El),l(Nl),l(Yl),l(Sl),l(Oe),l(Al),l(et),l(Fl),l(Ql),l(lt),l(Dl),l(Pl),l(st),l(Kl),l(at),l(Ol),l(en),l(tn),l(ot),l(ln),l(nn),l(pt)),l(w),y(T,e),y(J,e),y(b,e),y(I,e),y(B,e),y(L,e),y(E,e),y(S,e),y(ee,e),y(se,e),y(pe,e),y(ue,e),y(ye,e),y(fe,e),y(he,e),y(we,e),y(Je,e),y(_e,e),y(Ce,e),y($e,e),y(Ge,e),y(Be,e),y(We,e),y(Xe,e),y(Ne,e),y(Ye,e),y(Se,e),y(Fe,e),y(Qe,e),y(De,e),y(Pe,e),y(Ke,e),y(tt,e),y(nt,e),y(it,e)}}}const js='{"title":"Hands-on: advanced Deep Reinforcement Learning. Using Sample Factory to play Doom from pixels","local":"hands-on-advanced-deep-reinforcement-learning-using-sample-factory-to-play-doom-from-pixels","sections":[],"depth":1}';function Zs(an){return ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gs extends Ts{constructor(w){super(),Js(this,w,Zs,Us,fs,{})}}export{Gs as component};
