import{s as yt,n as bt,o as $t}from"../chunks/scheduler.d6170356.js";import{S as _t,i as vt,g as o,s as a,r,A as wt,h as s,f as l,c as i,j as ct,u as m,x as p,k as gt,y as Mt,a as n,v as d,d as u,t as f,w as h}from"../chunks/index.fcd4cc08.js";import{C as ne}from"../chunks/CodeBlock.7b16bdef.js";import{H as c}from"../chunks/Heading.8660bd0e.js";function Tt(Be){let g,ae,te,ie,y,oe,b,Ee='<a href="https://github.com/alex-petrenko/sample-factory" rel="nofollow"><code>sample-factory</code></a> is a codebase for high throughput asynchronous reinforcement learning. It has integrations with the Hugging Face Hub to share models with evaluation results and training metrics.',se,$,pe,_,Ye='You can find <code>sample-factory</code> models by filtering at the left of the <a href="https://huggingface.co/models?library=sample-factory" rel="nofollow">models page</a>.',re,v,Qe="All models on the Hub come up with useful features:",me,w,Ae="<li>An automatically generated model card with a description, a training configuration, and more.</li> <li>Metadata tags that help for discoverability.</li> <li>Evaluation results to compare with other models.</li> <li>A video widget where you can watch your agent performing.</li>",de,M,ue,T,De="To install the <code>sample-factory</code> library, you need to install the package:",fe,x,qe="<code>pip install sample-factory</code>",he,j,Oe="SF is known to work on Linux and MacOS. There is no Windows support at this time.",ce,U,ge,C,ye,H,Ke="To download a model from the Hugging Face Hub to use with Sample-Factory, use the <code>load_from_hub</code> script:",be,L,$e,Z,et="The command line arguments are:",_e,W,tt="<li><code>-r</code>: The repo ID for the HF repository to download from. The repo ID should be in the format <code>&lt;username&gt;/&lt;repo_name&gt;</code></li> <li><code>-d</code>: An optional argument to specify the directory to save the experiment to. Defaults to <code>./train_dir</code> which will save the repo to <code>./train_dir/&lt;repo_name&gt;</code></li>",ve,G,we,X,lt="Hugging Face repositories can be downloaded directly using <code>git clone</code>:",Me,F,Te,N,xe,J,nt="After downloading the model, you can run the models in the repo with the enjoy script corresponding to your environment. For example, if you are downloading a <code>mujoco-ant</code> model, it can be run with:",je,S,Ue,k,at="Note, you may have to specify the <code>--train_dir</code> if your local train_dir has a different path than the one in the <code>cfg.json</code>",Ce,P,He,z,Le,R,it="If you want to upload without generating evaluation metrics or a replay video, you can use the <code>push_to_hub</code> script:",Ze,I,We,V,ot="The command line arguments are:",Ge,B,st="<li><code>-r</code>: The repo_id to save on HF Hub. This is the same as <code>hf_repository</code> in the enjoy script and must be in the form <code>&lt;hf_username&gt;/&lt;hf_repo_name&gt;</code></li> <li><code>-d</code>: The full path to your experiment directory to upload</li>",Xe,E,Fe,Y,pt="You can upload your models to the Hub using your environment’s <code>enjoy</code> script with the <code>--push_to_hub</code> flag. Uploading using <code>enjoy</code> can also generate evaluation metrics and a replay video.",Ne,Q,rt="The evaluation metrics are generated by running your model on the specified environment for a number of episodes and reporting the mean and std reward of those runs.",Je,A,mt="Other relevant command line arguments are:",Se,D,dt="<li><code>--hf_repository</code>: The repository to push to. Must be of the form <code>&lt;username&gt;/&lt;repo_name&gt;</code>. The model will be saved to <code>https://huggingface.co/&lt;username&gt;/&lt;repo_name&gt;</code></li> <li><code>--max_num_episodes</code>: Number of episodes to evaluate on before uploading. Used to generate evaluation metrics. It is recommended to use multiple episodes to generate an accurate mean and std.</li> <li><code>--max_num_frames</code>: Number of frames to evaluate on before uploading. An alternative to <code>max_num_episodes</code></li> <li><code>--no_render</code>: A flag that disables rendering and showing the environment steps. It is recommended to set this flag to speed up the evaluation process.</li>",ke,q,ut="You can also save a video of the model during evaluation to upload to the hub with the <code>--save_video</code> flag",Pe,O,ft="<li><code>--video_frames</code>: The number of frames to be rendered in the video. Defaults to -1 which renders an entire episode</li> <li><code>--video_name</code>: The name of the video to save as. If <code>None</code>, will save to <code>replay.mp4</code> in your experiment directory</li>",ze,K,ht="For example:",Re,ee,Ie,le,Ve;return y=new c({props:{title:"Using sample-factory at Hugging Face",local:"using-sample-factory-at-hugging-face",headingTag:"h1"}}),$=new c({props:{title:"Exploring sample-factory in the Hub",local:"exploring-sample-factory-in-the-hub",headingTag:"h2"}}),M=new c({props:{title:"Install the library",local:"install-the-library",headingTag:"h2"}}),U=new c({props:{title:"Loading models from the Hub",local:"loading-models-from-the-hub",headingTag:"h2"}}),C=new c({props:{title:"Using load_from_hub",local:"using-loadfromhub",headingTag:"h3"}}),L=new ne({props:{code:"cHl0aG9uJTIwLW0lMjBzYW1wbGVfZmFjdG9yeS5odWdnaW5nZmFjZS5sb2FkX2Zyb21faHViJTIwLXIlMjAlM0NIdWdnaW5nRmFjZV9yZXBvX2lkJTNFJTIwLWQlMjAlM0N0cmFpbl9kaXJfcGF0aCUzRQ==",highlighted:'<span class="hljs-keyword">python</span> -<span class="hljs-keyword">m</span> sample_factory.huggingface.load_from_hub -r <span class="hljs-symbol">&lt;HuggingFace_repo_id&gt;</span> -d <span class="hljs-symbol">&lt;train_dir_path&gt;</span>',wrap:!1}}),G=new c({props:{title:"Download Model Repository Directly",local:"download-model-repository-directly",headingTag:"h3"}}),F=new ne({props:{code:"Z2l0JTIwY2xvbmUlMjBnaXQlNDBoZi5jbyUzQSUzQ05hbWUlMjBvZiUyMEh1Z2dpbmdGYWNlJTIwUmVwbyUzRSUyMCUyMyUyMGV4YW1wbGUlM0ElMjBnaXQlMjBjbG9uZSUyMGdpdCU0MGhmLmNvJTNBYmlnc2NpZW5jZSUyRmJsb29t",highlighted:'git <span class="hljs-keyword">clone</span> <span class="hljs-title">git</span>@hf.co:<span class="hljs-tag">&lt;Name of HuggingFace Repo&gt;</span> <span class="hljs-comment"># example: git clone git@hf.co:bigscience/bloom</span>',wrap:!1}}),N=new c({props:{title:"Using Downloaded Models with Sample-Factory",local:"using-downloaded-models-with-sample-factory",headingTag:"h2"}}),S=new ne({props:{code:"cHl0aG9uJTIwLW0lMjBzZl9leGFtcGxlcy5tdWpvY28uZW5qb3lfbXVqb2NvJTIwLS1hbGdvJTNEQVBQTyUyMC0tZW52JTNEbXVqb2NvX2FudCUyMC0tZXhwZXJpbWVudCUzRCUzQ3JlcG9fbmFtZSUzRSUyMC0tdHJhaW5fZGlyJTNELiUyRnRyYWluX2Rpcg==",highlighted:'python -m sf_examples.mujoco.enjoy_mujoco <span class="hljs-attribute">--algo</span>=APPO <span class="hljs-attribute">--env</span>=mujoco_ant <span class="hljs-attribute">--experiment</span>=&lt;repo_name&gt; <span class="hljs-attribute">--train_dir</span>=./train_dir',wrap:!1}}),P=new c({props:{title:"Sharing your models",local:"sharing-your-models",headingTag:"h2"}}),z=new c({props:{title:"Using push_to_hub",local:"using-pushtohub",headingTag:"h3"}}),I=new ne({props:{code:"cHl0aG9uJTIwLW0lMjBzYW1wbGVfZmFjdG9yeS5odWdnaW5nZmFjZS5wdXNoX3RvX2h1YiUyMC1yJTIwJTNDaGZfdXNlcm5hbWUlM0UlMkYlM0NoZl9yZXBvX25hbWUlM0UlMjAtZCUyMCUzQ2V4cGVyaW1lbnRfZGlyX3BhdGglM0U=",highlighted:'<span class="hljs-keyword">python</span> -<span class="hljs-keyword">m</span> sample_factory.huggingface.push_to_hub -r <span class="hljs-symbol">&lt;hf_username&gt;</span>/<span class="hljs-symbol">&lt;hf_repo_name&gt;</span> -d <span class="hljs-symbol">&lt;experiment_dir_path&gt;</span>',wrap:!1}}),E=new c({props:{title:"Using enjoy.py",local:"using-enjoypy",headingTag:"h3"}}),ee=new ne({props:{code:"cHl0aG9uJTIwLW0lMjBzZl9leGFtcGxlcy5tdWpvY29fZXhhbXBsZXMuZW5qb3lfbXVqb2NvJTIwLS1hbGdvJTNEQVBQTyUyMC0tZW52JTNEbXVqb2NvX2FudCUyMC0tZXhwZXJpbWVudCUzRCUzQ3JlcG9fbmFtZSUzRSUyMC0tdHJhaW5fZGlyJTNELiUyRnRyYWluX2RpciUyMC0tbWF4X251bV9lcGlzb2RlcyUzRDEwJTIwLS1wdXNoX3RvX2h1YiUyMC0taGZfdXNlcm5hbWUlM0QlM0N1c2VybmFtZSUzRSUyMC0taGZfcmVwb3NpdG9yeSUzRCUzQ2hmX3JlcG9fbmFtZSUzRSUyMC0tc2F2ZV92aWRlbyUyMC0tbm9fcmVuZGVy",highlighted:'python -m sf_examples.mujoco_examples.enjoy_mujoco <span class="hljs-attribute">--algo</span>=APPO <span class="hljs-attribute">--env</span>=mujoco_ant <span class="hljs-attribute">--experiment</span>=&lt;repo_name&gt; <span class="hljs-attribute">--train_dir</span>=./train_dir <span class="hljs-attribute">--max_num_episodes</span>=10 --push_to_hub <span class="hljs-attribute">--hf_username</span>=&lt;username&gt; <span class="hljs-attribute">--hf_repository</span>=&lt;hf_repo_name&gt; --save_video --no_render',wrap:!1}}),{c(){g=o("meta"),ae=a(),te=o("p"),ie=a(),r(y.$$.fragment),oe=a(),b=o("p"),b.innerHTML=Ee,se=a(),r($.$$.fragment),pe=a(),_=o("p"),_.innerHTML=Ye,re=a(),v=o("p"),v.textContent=Qe,me=a(),w=o("ol"),w.innerHTML=Ae,de=a(),r(M.$$.fragment),ue=a(),T=o("p"),T.innerHTML=De,fe=a(),x=o("p"),x.innerHTML=qe,he=a(),j=o("p"),j.textContent=Oe,ce=a(),r(U.$$.fragment),ge=a(),r(C.$$.fragment),ye=a(),H=o("p"),H.innerHTML=Ke,be=a(),r(L.$$.fragment),$e=a(),Z=o("p"),Z.textContent=et,_e=a(),W=o("ul"),W.innerHTML=tt,ve=a(),r(G.$$.fragment),we=a(),X=o("p"),X.innerHTML=lt,Me=a(),r(F.$$.fragment),Te=a(),r(N.$$.fragment),xe=a(),J=o("p"),J.innerHTML=nt,je=a(),r(S.$$.fragment),Ue=a(),k=o("p"),k.innerHTML=at,Ce=a(),r(P.$$.fragment),He=a(),r(z.$$.fragment),Le=a(),R=o("p"),R.innerHTML=it,Ze=a(),r(I.$$.fragment),We=a(),V=o("p"),V.textContent=ot,Ge=a(),B=o("ul"),B.innerHTML=st,Xe=a(),r(E.$$.fragment),Fe=a(),Y=o("p"),Y.innerHTML=pt,Ne=a(),Q=o("p"),Q.textContent=rt,Je=a(),A=o("p"),A.textContent=mt,Se=a(),D=o("ul"),D.innerHTML=dt,ke=a(),q=o("p"),q.innerHTML=ut,Pe=a(),O=o("ul"),O.innerHTML=ft,ze=a(),K=o("p"),K.textContent=ht,Re=a(),r(ee.$$.fragment),Ie=a(),le=o("p"),this.h()},l(e){const t=wt("svelte-u9bgzb",document.head);g=s(t,"META",{name:!0,content:!0}),t.forEach(l),ae=i(e),te=s(e,"P",{}),ct(te).forEach(l),ie=i(e),m(y.$$.fragment,e),oe=i(e),b=s(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-3rpvj5"&&(b.innerHTML=Ee),se=i(e),m($.$$.fragment,e),pe=i(e),_=s(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-u95f1u"&&(_.innerHTML=Ye),re=i(e),v=s(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1krwbts"&&(v.textContent=Qe),me=i(e),w=s(e,"OL",{"data-svelte-h":!0}),p(w)!=="svelte-117jq8g"&&(w.innerHTML=Ae),de=i(e),m(M.$$.fragment,e),ue=i(e),T=s(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-o20s68"&&(T.innerHTML=De),fe=i(e),x=s(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-vqyzdc"&&(x.innerHTML=qe),he=i(e),j=s(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-bhild8"&&(j.textContent=Oe),ce=i(e),m(U.$$.fragment,e),ge=i(e),m(C.$$.fragment,e),ye=i(e),H=s(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-ypkp8v"&&(H.innerHTML=Ke),be=i(e),m(L.$$.fragment,e),$e=i(e),Z=s(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-lexndg"&&(Z.textContent=et),_e=i(e),W=s(e,"UL",{"data-svelte-h":!0}),p(W)!=="svelte-1fzlb5g"&&(W.innerHTML=tt),ve=i(e),m(G.$$.fragment,e),we=i(e),X=s(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-usqwf8"&&(X.innerHTML=lt),Me=i(e),m(F.$$.fragment,e),Te=i(e),m(N.$$.fragment,e),xe=i(e),J=s(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-j0kkcs"&&(J.innerHTML=nt),je=i(e),m(S.$$.fragment,e),Ue=i(e),k=s(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1vlakif"&&(k.innerHTML=at),Ce=i(e),m(P.$$.fragment,e),He=i(e),m(z.$$.fragment,e),Le=i(e),R=s(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-cpclke"&&(R.innerHTML=it),Ze=i(e),m(I.$$.fragment,e),We=i(e),V=s(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-lexndg"&&(V.textContent=ot),Ge=i(e),B=s(e,"UL",{"data-svelte-h":!0}),p(B)!=="svelte-k6zp1e"&&(B.innerHTML=st),Xe=i(e),m(E.$$.fragment,e),Fe=i(e),Y=s(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-ysos95"&&(Y.innerHTML=pt),Ne=i(e),Q=s(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-fatztu"&&(Q.textContent=rt),Je=i(e),A=s(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-z2hgo"&&(A.textContent=mt),Se=i(e),D=s(e,"UL",{"data-svelte-h":!0}),p(D)!=="svelte-1imkbf"&&(D.innerHTML=dt),ke=i(e),q=s(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-h3gjxj"&&(q.innerHTML=ut),Pe=i(e),O=s(e,"UL",{"data-svelte-h":!0}),p(O)!=="svelte-rp0bx2"&&(O.innerHTML=ft),ze=i(e),K=s(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1gkqha7"&&(K.textContent=ht),Re=i(e),m(ee.$$.fragment,e),Ie=i(e),le=s(e,"P",{}),ct(le).forEach(l),this.h()},h(){gt(g,"name","hf:doc:metadata"),gt(g,"content",xt)},m(e,t){Mt(document.head,g),n(e,ae,t),n(e,te,t),n(e,ie,t),d(y,e,t),n(e,oe,t),n(e,b,t),n(e,se,t),d($,e,t),n(e,pe,t),n(e,_,t),n(e,re,t),n(e,v,t),n(e,me,t),n(e,w,t),n(e,de,t),d(M,e,t),n(e,ue,t),n(e,T,t),n(e,fe,t),n(e,x,t),n(e,he,t),n(e,j,t),n(e,ce,t),d(U,e,t),n(e,ge,t),d(C,e,t),n(e,ye,t),n(e,H,t),n(e,be,t),d(L,e,t),n(e,$e,t),n(e,Z,t),n(e,_e,t),n(e,W,t),n(e,ve,t),d(G,e,t),n(e,we,t),n(e,X,t),n(e,Me,t),d(F,e,t),n(e,Te,t),d(N,e,t),n(e,xe,t),n(e,J,t),n(e,je,t),d(S,e,t),n(e,Ue,t),n(e,k,t),n(e,Ce,t),d(P,e,t),n(e,He,t),d(z,e,t),n(e,Le,t),n(e,R,t),n(e,Ze,t),d(I,e,t),n(e,We,t),n(e,V,t),n(e,Ge,t),n(e,B,t),n(e,Xe,t),d(E,e,t),n(e,Fe,t),n(e,Y,t),n(e,Ne,t),n(e,Q,t),n(e,Je,t),n(e,A,t),n(e,Se,t),n(e,D,t),n(e,ke,t),n(e,q,t),n(e,Pe,t),n(e,O,t),n(e,ze,t),n(e,K,t),n(e,Re,t),d(ee,e,t),n(e,Ie,t),n(e,le,t),Ve=!0},p:bt,i(e){Ve||(u(y.$$.fragment,e),u($.$$.fragment,e),u(M.$$.fragment,e),u(U.$$.fragment,e),u(C.$$.fragment,e),u(L.$$.fragment,e),u(G.$$.fragment,e),u(F.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),u(P.$$.fragment,e),u(z.$$.fragment,e),u(I.$$.fragment,e),u(E.$$.fragment,e),u(ee.$$.fragment,e),Ve=!0)},o(e){f(y.$$.fragment,e),f($.$$.fragment,e),f(M.$$.fragment,e),f(U.$$.fragment,e),f(C.$$.fragment,e),f(L.$$.fragment,e),f(G.$$.fragment,e),f(F.$$.fragment,e),f(N.$$.fragment,e),f(S.$$.fragment,e),f(P.$$.fragment,e),f(z.$$.fragment,e),f(I.$$.fragment,e),f(E.$$.fragment,e),f(ee.$$.fragment,e),Ve=!1},d(e){e&&(l(ae),l(te),l(ie),l(oe),l(b),l(se),l(pe),l(_),l(re),l(v),l(me),l(w),l(de),l(ue),l(T),l(fe),l(x),l(he),l(j),l(ce),l(ge),l(ye),l(H),l(be),l($e),l(Z),l(_e),l(W),l(ve),l(we),l(X),l(Me),l(Te),l(xe),l(J),l(je),l(Ue),l(k),l(Ce),l(He),l(Le),l(R),l(Ze),l(We),l(V),l(Ge),l(B),l(Xe),l(Fe),l(Y),l(Ne),l(Q),l(Je),l(A),l(Se),l(D),l(ke),l(q),l(Pe),l(O),l(ze),l(K),l(Re),l(Ie),l(le)),l(g),h(y,e),h($,e),h(M,e),h(U,e),h(C,e),h(L,e),h(G,e),h(F,e),h(N,e),h(S,e),h(P,e),h(z,e),h(I,e),h(E,e),h(ee,e)}}}const xt='{"title":"Using sample-factory at Hugging Face","local":"using-sample-factory-at-hugging-face","sections":[{"title":"Exploring sample-factory in the Hub","local":"exploring-sample-factory-in-the-hub","sections":[],"depth":2},{"title":"Install the library","local":"install-the-library","sections":[],"depth":2},{"title":"Loading models from the Hub","local":"loading-models-from-the-hub","sections":[{"title":"Using load_from_hub","local":"using-loadfromhub","sections":[],"depth":3},{"title":"Download Model Repository Directly","local":"download-model-repository-directly","sections":[],"depth":3}],"depth":2},{"title":"Using Downloaded Models with Sample-Factory","local":"using-downloaded-models-with-sample-factory","sections":[],"depth":2},{"title":"Sharing your models","local":"sharing-your-models","sections":[{"title":"Using push_to_hub","local":"using-pushtohub","sections":[],"depth":3},{"title":"Using enjoy.py","local":"using-enjoypy","sections":[],"depth":3}],"depth":2}],"depth":1}';function jt(Be){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zt extends _t{constructor(g){super(),vt(this,g,jt,Tt,yt,{})}}export{Zt as component};
