import{s as Qn,n as En,o as Xn}from"../chunks/scheduler.9039eef2.js";import{S as Nn,i as Sn,g as o,s as n,r as p,A as Vn,h as i,f as a,c as l,j as bs,u as c,x as r,k as ks,l as Bn,y as J,a as s,v as d,d as u,t as m,w as M}from"../chunks/index.ded8f90d.js";import{D as zn}from"../chunks/Docstring.a2ba2b54.js";import{C as h}from"../chunks/CodeBlock.8580f3e8.js";import{H as y}from"../chunks/Heading.f027f30d.js";function Wn(vs){let T,be,we,ke,b,_e,k,Fs="Supervised fine-tuning (or SFT for short) is a crucial step in RLHF. In TRL we provide an easy-to-use API to create your SFT models and train them with few lines of code on your dataset.",Ce,_,$s='Check out a complete flexible example at <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft.py" rel="nofollow"><code>examples/scripts/sft.py</code></a>.',Ie,C,xe,I,Gs=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,ve,x,Fe,v,qs="Make sure to pass a correct value for <code>max_seq_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",$e,F,Rs="You can also construct a model outside of the trainer and pass it as follows:",Ge,$,qe,G,Zs='The above snippets will use the default training arguments from the <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow"><code>transformers.TrainingArguments</code></a> class. If you want to modify that, make sure to create your own <code>TrainingArguments</code> object and pass it to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor as it is done on the <a href="https://github.com/huggingface/trl/blob/main/examples/stack_llama/scripts/supervised_finetuning.py" rel="nofollow"><code>supervised_finetuning.py</code> script</a> on the stack-llama example.',Re,q,Ze,R,Be,Z,Bs=`You can use the <code>DataCollatorForCompletionOnlyLM</code> to train your model on the generated prompts only. Note that this works only in the case when <code>packing=False</code>.
To instantiate that collator for instruction data, pass a response template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on completions only on the CodeAlpaca dataset:`,ze,B,Qe,z,zs="To instantiate that collator for assistant style conversation data, pass a response template, an instruction template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on assistant completions only on the Open Assistant Guanaco dataset:",Ee,Q,Xe,E,Qs="Make sure to have a <code>pad_token_id</code> which is different from <code>eos_token_id</code> which can result in the model not properly predicting EOS (End of Sentence) tokens during generation.",Ne,X,Se,N,Es="Some tokenizers like Llama 2 (<code>meta-llama/Llama-2-XXb-hf</code>) tokenize sequences differently depending whether they have context or not. For example:",Ve,S,We,V,Xs="In this case, and due to lack of context in <code>response_template</code>, the same string (”### Assistant:”) is tokenized differently:",Ae,W,Ns="<li>Text (with context): <code>[2277, 29937, 4007, 22137, 29901]</code></li> <li><code>response_template</code> (without context): <code>[835, 4007, 22137, 29901]</code></li>",He,A,Ss="This will lead to an error when the <code>DataCollatorForCompletionOnlyLM</code> does not find the <code>response_template</code> in the dataset example text:",Le,H,Ye,L,Vs="To solve this, you can tokenize the <code>response_template</code> with the same context than in the dataset, truncate it as needed and pass the <code>token_ids</code> directly to the <code>response_template</code> argument of the <code>DataCollatorForCompletionOnlyLM</code> class. For example:",De,Y,Pe,D,Oe,P,Ws='The <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> supports popular dataset formats. This allows you to pass the dataset to the trainer without any pre-processing directly. The following formats are supported:',Ke,O,As="<li>conversational format</li>",ta,K,ea,tt,Hs="<li>instruction format</li>",aa,et,sa,at,Ls='If your dataset uses one of the above formats, you can directly pass it to the trainer without pre-processing. The <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> will then format the dataset for you using the defined format from the model’s tokenizer with the <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#templates-for-chat-models" rel="nofollow">apply_chat_template</a> method.',na,st,la,nt,Ys="If the dataset is not in one those format you can either preprocess the dataset to match the formatting or pass a formatting function to the SFTTrainer to do it for you. Let’s have a look.",oa,lt,ia,ot,Ds=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,ra,it,pa,rt,Ps="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",ca,pt,da,ct,Os='To preperly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example on how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',ua,dt,ma,ut,Ks='<a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. This is done with the <code>ConstantLengthDataset</code> utility class that returns constant length chunks of tokens from a stream of examples. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor.',Ma,mt,ha,Mt,tn="Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.",ya,ht,fa,yt,en="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",Ta,ft,Ua,Tt,an='You can also customize the <code>ConstantLengthDataset</code> much more by directly passing the arguments to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor. Please refer to that class’ signature for more information.',ga,Ut,ja,gt,sn='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>. For example, if you want to load a model in a different precision, analogous to',wa,jt,Ja,wt,ba,Jt,nn="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",ka,bt,_a,kt,ln="We also support a tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model",Ca,_t,Ia,Ct,on="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",xa,It,va,xt,rn="For that you need to first load your 8bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",Fa,vt,$a,Ft,Ga,$t,pn=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,qa,Gt,Ra,qt,cn=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,Za,Rt,Ba,Zt,dn="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",za,Bt,Qa,zt,un="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",Ea,Qt,Xa,Et,mn="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",Na,Xt,Mn="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",Sa,Nt,hn="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",Va,St,Wa,Vt,yn="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",Aa,Wt,Ha,At,fn="And add <code>use_flash_attention_2=True</code> when calling <code>from_pretrained</code>:",La,Ht,Ya,Lt,Tn=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,Da,Yt,Un="In contrary to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",Pa,Dt,Oa,Pt,gn='NEFTune is a technique to boost the performance of chat models and was introduced by the paper <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">“NEFTune: Noisy Embeddings Improve Instruction Finetuning”</a> from Jain et al. it consists of adding noise to the embedding vectors during training. According to the abstract of the paper:',Ka,Ot,jn="<p>Standard finetuning of LLaMA-2-7B using Alpaca achieves 29.79% on AlpacaEval, which rises to 64.69% using noisy embeddings. NEFTune also improves over strong baselines on modern instruction datasets. Models trained with Evol-Instruct see a 10% improvement, with ShareGPT an 8% improvement, and with OpenPlatypus an 8% improvement. Even powerful models further refined with RLHF such as LLaMA-2-Chat benefit from additional training with NEFTune.</p>",ts,g,wn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/neft-screenshot.png"/>',es,Kt,Jn="To use it in <code>SFTTrainer</code> simply pass <code>neftune_noise_alpha</code> when creating your <code>SFTTrainer</code> instance. Note that to avoid any surprising behaviour, NEFTune is disabled after training to retrieve back the original behaviour of the embedding layer.",as,te,ss,ee,bn='We have tested NEFTune by training <code>mistralai/Mistral-7B-v0.1</code> on the <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">OpenAssistant dataset</a> and validated that using NEFTune led to a performance boost of ~25% on MT Bench.',ns,j,kn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-neftune-mistral-7b.png"/>',ls,ae,_n='Note however, that the amount of performance gain is <em>dataset dependent</em> and in particular, applying NEFTune on synthetic datasets like <a href="https://huggingface.co/datasets/stingning/ultrachat" rel="nofollow">UltraChat</a> typically produces smaller gains.',os,se,is,ne,Cn='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks on 1x A100 listed below:',rs,le,In="<thead><tr><th>1 A100 40GB</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>Code Llama 34b</td> <td>Slim Orca</td> <td>1x</td> <td>1.01x</td> <td><strong>1.94x</strong></td> <td>-22.7%</td></tr> <tr><td>Llama-2 7b</td> <td>Slim Orca</td> <td>1x</td> <td>0.96x</td> <td><strong>1.87x</strong></td> <td>-39.3%</td></tr> <tr><td>Mistral 7b</td> <td>Slim Orca</td> <td>1x</td> <td>1.17x</td> <td><strong>1.88x</strong></td> <td>-65.9%</td></tr> <tr><td>Tiny Llama 1.1b</td> <td>Alpaca</td> <td>1x</td> <td>1.55x</td> <td><strong>2.74x</strong></td> <td>-57.8%</td></tr></tbody>",ps,oe,xn='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',cs,ie,ds,re,vn='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',us,pe,ms,ce,Fn="Pay attention to the following best practices when training a model with that trainer:",Ms,de,$n='<li><a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> always pads by default the sequences to the <code>max_seq_length</code> argument of the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide default value, so there is a check to retrieve the minimum between 2048 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',hs,ue,ys,me,Gn="You may experience some issues with GPTQ Quantization after completing training. Lowering <code>gradient_accumulation_steps</code> to <code>4</code> will resolve most issues during the quantization process to GPTQ format.",fs,Me,Ts,U,he,_s,Ue,qn=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,Us,ye,gs,f,fe,Cs,ge,Rn=`Iterable dataset that returns constant length chunks of tokens from stream of text files.
The dataset also formats the text before tokenization with a specific format that is provided
by the user.`,Is,Te,xs,je,Zn=`”<code>infinite (</code>bool<code>, *optional*, defaults to </code>False<code>): If True the iterator is reset after dataset reaches end else stops. seq_length (</code>int<code>, *optional*, defaults to </code>1024<code>): Length of token sequences to return. num_of_sequences (</code>int<code>, *optional*, defaults to </code>1024<code>): Number of token sequences to keep in buffer. chars_per_token (</code>int<code>, *optional*, defaults to </code>3.6<code>): Number of characters per token used to estimate number of tokens in text buffer. eos_token_id (</code>int<code>, *optional*, defaults to </code>0<code>): Id of the end of sequence token if the passed tokenizer does not have an EOS token. shuffle (&#39;bool&#39;, *optional*, defaults to True) Shuffle the examples before they are returned append_concat_token (&#39;bool&#39;, *optional*, defaults to True) If true, appends </code>eos_token_id\` at the end of each sample being packed.
add_special_tokens (‘bool’, <em>optional</em>, defaults to True)
If true, tokenizers adds special tokens to each sample being packed.`,js,Je,ws;return b=new y({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),C=new y({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),x=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)
trainer.train()`,wrap:!1}}),$=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)

trainer.train()`,wrap:!1}}),q=new y({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),R=new y({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),B=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybHVjYXNtY2NhYmUtbG1pJTJGQ29kZUFscGFjYS0yMGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFkZWYlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0ElMjAlN0JleGFtcGxlJTVCJ291dHB1dCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzLmFwcGVuZCh0ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZXh0cyUwQSUwQXJlc3BvbnNlX3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIwJTIzJTIzJTIzJTIwQW5zd2VyJTNBJTIyJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBmb3JtYXR0aW5nX2Z1bmMlM0Rmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;lucasmccabe-lmi/CodeAlpaca-20k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(response_template, tokenizer=tokenizer)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),Q=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJTBBcmVzcG9uc2VfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjMlMjMlMjMlMjBBc3Npc3RhbnQlM0ElMjIlMEFjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0oaW5zdHJ1Y3Rpb25fdGVtcGxhdGUlM0RpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyQyUyMHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGUlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;timdettmers/openassistant-guanaco&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

instruction_template = <span class="hljs-string">&quot;### Human:&quot;</span>
response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(instruction_template=instruction_template, response_template=response_template, tokenizer=tokenizer, mlm=<span class="hljs-literal">False</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),X=new y({props:{title:"Using token_ids directly for response_template",local:"using-tokenids-directly-for-responsetemplate",headingTag:"h4"}}),S=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFkZWYlMjBwcmludF90b2tlbnNfd2l0aF9pZHModHh0KSUzQSUwQSUyMCUyMCUyMCUyMHRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZSh0eHQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklMEElMjAlMjAlMjAlMjB0b2tlbl9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKHR4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMHByaW50KGxpc3QoemlwKHRva2VucyUyQyUyMHRva2VuX2lkcykpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFVzZXIlM0ElMjBIZWxsbyU1Q24lNUNuJTIzJTIzJTIzJTIwQXNzaXN0YW50JTNBJTIwSGklMkMlMjBob3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUzRiUyMiUyMiUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhwcm9tcHQpJTIwJTIwJTIzJTIwJTVCLi4uJTJDJTIwKCclRTIlOTYlODFIZWxsbyclMkMlMjAxNTA0MyklMkMlMjAoJyUzQzB4MEElM0UnJTJDJTIwMTMpJTJDJTIwKCclM0MweDBBJTNFJyUyQyUyMDEzKSUyQyUyMCgnJTIzJTIzJyUyQyUyMDIyNzcpJTJDJTIwKCclMjMnJTJDJTIwMjk5MzcpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklMkMlMjAuLi4lNUQlMEElMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhyZXNwb25zZV90ZW1wbGF0ZSklMjAlMjAlMjMlMjAlNUIoJyVFMiU5NiU4MSUyMyUyMyUyMyclMkMlMjA4MzUpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_tokens_with_ids</span>(<span class="hljs-params">txt</span>):
    tokens = tokenizer.tokenize(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    token_ids = tokenizer.encode(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(<span class="hljs-built_in">zip</span>(tokens, token_ids)))

prompt = <span class="hljs-string">&quot;&quot;&quot;### User: Hello\\n\\n### Assistant: Hi, how can I help you?&quot;&quot;&quot;</span>
print_tokens_with_ids(prompt)  <span class="hljs-comment"># [..., (&#x27;▁Hello&#x27;, 15043), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;##&#x27;, 2277), (&#x27;#&#x27;, 29937), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901), ...]</span>

response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
print_tokens_with_ids(response_template)  <span class="hljs-comment"># [(&#x27;▁###&#x27;, 835), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901)]</span>`,wrap:!1}}),H=new h({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ291bGQlMjBub3QlMjBmaW5kJTIwcmVzcG9uc2UlMjBrZXklMjAlNUI4MzUlMkMlMjA0MDA3JTJDJTIwMjIxMzclMkMlMjAyOTkwMSU1RCUyMGluJTIwdG9rZW4lMjBJRHMlMjB0ZW5zb3IoJTVCJTIwJTIwJTIwJTIwMSUyQyUyMCUyMCUyMDgzNSUyQyUyMCUyMC4uLiU1RCk=",highlighted:'RuntimeError: Could not find response key <span class="hljs-selector-attr">[835, 4007, 22137, 29901]</span> <span class="hljs-keyword">in</span> token IDs <span class="hljs-built_in">tensor</span>(<span class="hljs-selector-attr">[    1,   835,  ...]</span>)',wrap:!1}}),Y=new h({props:{code:"cmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTIwJTNEJTIwJTIyJTVDbiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUyMCUyMCUyMyUyMFdlJTIwYWRkZWQlMjBjb250ZXh0JTIwaGVyZSUzQSUyMCUyMiU1Q24lMjIuJTIwVGhpcyUyMGlzJTIwZW5vdWdoJTIwZm9yJTIwdGhpcyUyMHRva2VuaXplciUwQXJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCMiUzQSU1RCUyMCUyMCUyMyUyME5vdyUyMHdlJTIwaGF2ZSUyMGl0JTIwbGlrZSUyMGluJTIwdGhlJTIwZGF0YXNldCUyMHRleHRzJTNBJTIwJTYwJTVCMjI3NyUyQyUyMDI5OTM3JTJDJTIwNDAwNyUyQyUyMDIyMTM3JTJDJTIwMjk5MDElNUQlNjAlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTShyZXNwb25zZV90ZW1wbGF0ZV9pZHMlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`response_template_with_context = <span class="hljs-string">&quot;\\n### Assistant:&quot;</span>  <span class="hljs-comment"># We added context here: &quot;\\n&quot;. This is enough for this tokenizer</span>
response_template_ids = tokenizer.encode(response_template_with_context, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]  <span class="hljs-comment"># Now we have it like in the dataset texts: \`[2277, 29937, 4007, 22137, 29901]\`</span>

data_collator = DataCollatorForCompletionOnlyLM(response_template_ids, tokenizer=tokenizer)`,wrap:!1}}),D=new y({props:{title:"Dataset format support",local:"dataset-format-support",headingTag:"h3"}}),K=new h({props:{code:"JTdCJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGhlbHBmdWwlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMi4uLiUyMiU3RCU1RCU3RCUwQSU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBoZWxwZnVsJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hvJTIwd3JvdGUlMjAnUm9tZW8lMjBhbmQlMjBKdWxpZXQnJTNGJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIuLi4lMjIlN0QlNUQlN0QlMEElN0IlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwaGVscGZ1bCUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMGZhciUyMGlzJTIwdGhlJTIwTW9vbiUyMGZyb20lMjBFYXJ0aCUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyLi4uJTIyJTdEJTVEJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What&#x27;s the capital of France?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Who wrote &#x27;Romeo and Juliet&#x27;?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;How far is the Moon from Earth?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),et=new h({props:{code:"JTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyJTNDcHJvbXB0JTIwdGV4dCUzRSUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlM0NpZGVhbCUyMGdlbmVyYXRlZCUyMHRleHQlM0UlMjIlN0QlMEElN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjIlM0Nwcm9tcHQlMjB0ZXh0JTNFJTIyJTJDJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCUyMiUzQ2lkZWFsJTIwZ2VuZXJhdGVkJTIwdGV4dCUzRSUyMiU3RCUwQSU3QiUyMnByb21wdCUyMiUzQSUyMCUyMiUzQ3Byb21wdCUyMHRleHQlM0UlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTIyJTNDaWRlYWwlMjBnZW5lcmF0ZWQlMjB0ZXh0JTNFJTIyJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),st=new h({props:{code:"JTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

...

<span class="hljs-comment"># load jsonl dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=<span class="hljs-string">&quot;path/to/dataset.jsonl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-comment"># load dataset from the HuggingFace Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;philschmid/dolly-15k-oai-style&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    args=training_args,
    train_dataset=dataset,
    packing=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),lt=new y({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),it=new h({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),pt=new h({props:{code:"JTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;question&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
)

trainer.train()`,wrap:!1}}),dt=new y({props:{title:"Packing dataset ( ConstantLengthDataset )",local:"packing-dataset--constantlengthdataset-",headingTag:"h3"}}),mt=new h({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    packing=<span class="hljs-literal">True</span>
)

trainer.train()`,wrap:!1}}),ht=new y({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),ft=new h({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwYWNraW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZvcm1hdHRpbmdfZnVuYyUzRGZvcm1hdHRpbmdfZnVuYyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    packing=<span class="hljs-literal">True</span>,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),Ut=new y({props:{title:"Control over the pretrained model",local:"control-over-the-pretrained-model",headingTag:"h3"}}),jt=new h({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYp",highlighted:'model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)',wrap:!1}}),wt=new h({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    model_init_kwargs={
        <span class="hljs-string">&quot;torch_dtype&quot;</span>: torch.bfloat16,
    },
)

trainer.train()`,wrap:!1}}),bt=new y({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),_t=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyRWxldXRoZXJBSSUyRmdwdC1uZW8tMTI1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),It=new y({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),vt=new h({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),Ft=new y({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),Gt=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),Rt=new y({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),Bt=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),Qt=new h({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),St=new y({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),Wt=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),Ht=new h({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2ZsYXNoX2F0dGVudGlvbl8yJTNEVHJ1ZSUwQSk=",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Dt=new y({props:{title:"Enhance model’s performances using NEFTune",local:"enhance-models-performances-using-neftune",headingTag:"h3"}}),te=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG5lZnR1bmVfbm9pc2VfYWxwaGElM0Q1JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
    neftune_noise_alpha=<span class="hljs-number">5</span>,
)
trainer.train()`,wrap:!1}}),se=new y({props:{title:"Accelerate fine-tuning 2x using unsloth",local:"accelerate-fine-tuning-2x-using-unsloth",headingTag:"h3"}}),ie=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/mistral-7b&quot;</span>,
    max_seq_length = max_seq_length,
    dtype = <span class="hljs-literal">None</span>, <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
)

args = TrainingArguments(output_dir = <span class="hljs-string">&quot;./output&quot;</span>)

trainer = SFTTrainer(
    model = model,
    args = args,
    train_dataset = dataset,
    dataset_text_field = <span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length = max_seq_length,
)
trainer.train()`,wrap:!1}}),pe=new y({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),ue=new y({props:{title:"GPTQ Conversion",local:"gptq-conversion",headingTag:"h2"}}),Me=new y({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),he=new zn({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"dataset_text_field",val:": Optional = None"},{name:"packing",val:": Optional = False"},{name:"formatting_func",val:": Optional = None"},{name:"max_seq_length",val:": Optional = None"},{name:"infinite",val:": Optional = None"},{name:"num_of_sequences",val:": Optional = 1024"},{name:"chars_per_token",val:": Optional = 3.6"},{name:"dataset_num_proc",val:": Optional = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automatically creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instruction
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
dataset_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when creating packed or non-packed datasets`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/sft_trainer.py#L54"}}),ye=new y({props:{title:"ConstantLengthDataset",local:"trl.trainer.ConstantLengthDataset",headingTag:"h2"}}),fe=new zn({props:{name:"class trl.trainer.ConstantLengthDataset",anchor:"trl.trainer.ConstantLengthDataset",parameters:[{name:"tokenizer",val:""},{name:"dataset",val:""},{name:"dataset_text_field",val:" = None"},{name:"formatting_func",val:" = None"},{name:"infinite",val:" = False"},{name:"seq_length",val:" = 1024"},{name:"num_of_sequences",val:" = 1024"},{name:"chars_per_token",val:" = 3.6"},{name:"eos_token_id",val:" = 0"},{name:"shuffle",val:" = True"},{name:"append_concat_token",val:" = True"},{name:"add_special_tokens",val:" = True"}],parametersDescription:[{anchor:"trl.trainer.ConstantLengthDataset.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizer</code>) &#x2014;
The processor used for processing the data.`,name:"tokenizer"},{anchor:"trl.trainer.ConstantLengthDataset.dataset",description:`<strong>dataset</strong> (<code>dataset.Dataset</code>) &#x2014;
Dataset with text files.`,name:"dataset"},{anchor:"trl.trainer.ConstantLengthDataset.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
Name of the field in the dataset that contains the text. Used only if <code>formatting_func</code> is <code>None</code>.`,name:"dataset_text_field"},{anchor:"trl.trainer.ConstantLengthDataset.formatting_func",description:`<strong>formatting_func</strong> (<code>Callable</code>, <strong>optional</strong>) &#x2014;
Function that formats the text before tokenization. Usually it is recommended to have follows a certain
pattern such as \`&#x201D;### Question: {question}`,name:"formatting_func"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/utils.py#L343"}}),Te=new y({props:{title:"Answer: {answer}",local:"answer-answer",headingTag:"h3"}}),{c(){T=o("meta"),be=n(),we=o("p"),ke=n(),p(b.$$.fragment),_e=n(),k=o("p"),k.textContent=Fs,Ce=n(),_=o("p"),_.innerHTML=$s,Ie=n(),p(C.$$.fragment),xe=n(),I=o("p"),I.innerHTML=Gs,ve=n(),p(x.$$.fragment),Fe=n(),v=o("p"),v.innerHTML=qs,$e=n(),F=o("p"),F.textContent=Rs,Ge=n(),p($.$$.fragment),qe=n(),G=o("p"),G.innerHTML=Zs,Re=n(),p(q.$$.fragment),Ze=n(),p(R.$$.fragment),Be=n(),Z=o("p"),Z.innerHTML=Bs,ze=n(),p(B.$$.fragment),Qe=n(),z=o("p"),z.innerHTML=zs,Ee=n(),p(Q.$$.fragment),Xe=n(),E=o("p"),E.innerHTML=Qs,Ne=n(),p(X.$$.fragment),Se=n(),N=o("p"),N.innerHTML=Es,Ve=n(),p(S.$$.fragment),We=n(),V=o("p"),V.innerHTML=Xs,Ae=n(),W=o("ul"),W.innerHTML=Ns,He=n(),A=o("p"),A.innerHTML=Ss,Le=n(),p(H.$$.fragment),Ye=n(),L=o("p"),L.innerHTML=Vs,De=n(),p(Y.$$.fragment),Pe=n(),p(D.$$.fragment),Oe=n(),P=o("p"),P.innerHTML=Ws,Ke=n(),O=o("ul"),O.innerHTML=As,ta=n(),p(K.$$.fragment),ea=n(),tt=o("ul"),tt.innerHTML=Hs,aa=n(),p(et.$$.fragment),sa=n(),at=o("p"),at.innerHTML=Ls,na=n(),p(st.$$.fragment),la=n(),nt=o("p"),nt.textContent=Ys,oa=n(),p(lt.$$.fragment),ia=n(),ot=o("p"),ot.innerHTML=Ds,ra=n(),p(it.$$.fragment),pa=n(),rt=o("p"),rt.innerHTML=Ps,ca=n(),p(pt.$$.fragment),da=n(),ct=o("p"),ct.innerHTML=Os,ua=n(),p(dt.$$.fragment),ma=n(),ut=o("p"),ut.innerHTML=Ks,Ma=n(),p(mt.$$.fragment),ha=n(),Mt=o("p"),Mt.innerHTML=tn,ya=n(),p(ht.$$.fragment),fa=n(),yt=o("p"),yt.innerHTML=en,Ta=n(),p(ft.$$.fragment),Ua=n(),Tt=o("p"),Tt.innerHTML=an,ga=n(),p(Ut.$$.fragment),ja=n(),gt=o("p"),gt.innerHTML=sn,wa=n(),p(jt.$$.fragment),Ja=n(),p(wt.$$.fragment),ba=n(),Jt=o("p"),Jt.innerHTML=nn,ka=n(),p(bt.$$.fragment),_a=n(),kt=o("p"),kt.textContent=ln,Ca=n(),p(_t.$$.fragment),Ia=n(),Ct=o("p"),Ct.innerHTML=on,xa=n(),p(It.$$.fragment),va=n(),xt=o("p"),xt.innerHTML=rn,Fa=n(),p(vt.$$.fragment),$a=n(),p(Ft.$$.fragment),Ga=n(),$t=o("p"),$t.textContent=pn,qa=n(),p(Gt.$$.fragment),Ra=n(),qt=o("p"),qt.textContent=cn,Za=n(),p(Rt.$$.fragment),Ba=n(),Zt=o("p"),Zt.innerHTML=dn,za=n(),p(Bt.$$.fragment),Qa=n(),zt=o("p"),zt.innerHTML=un,Ea=n(),p(Qt.$$.fragment),Xa=n(),Et=o("p"),Et.innerHTML=mn,Na=n(),Xt=o("p"),Xt.textContent=Mn,Sa=n(),Nt=o("table"),Nt.innerHTML=hn,Va=n(),p(St.$$.fragment),Wa=n(),Vt=o("p"),Vt.innerHTML=yn,Aa=n(),p(Wt.$$.fragment),Ha=n(),At=o("p"),At.innerHTML=fn,La=n(),p(Ht.$$.fragment),Ya=n(),Lt=o("p"),Lt.textContent=Tn,Da=n(),Yt=o("p"),Yt.textContent=Un,Pa=n(),p(Dt.$$.fragment),Oa=n(),Pt=o("p"),Pt.innerHTML=gn,Ka=n(),Ot=o("blockquote"),Ot.innerHTML=jn,ts=n(),g=o("div"),g.innerHTML=wn,es=n(),Kt=o("p"),Kt.innerHTML=Jn,as=n(),p(te.$$.fragment),ss=n(),ee=o("p"),ee.innerHTML=bn,ns=n(),j=o("div"),j.innerHTML=kn,ls=n(),ae=o("p"),ae.innerHTML=_n,os=n(),p(se.$$.fragment),is=n(),ne=o("p"),ne.innerHTML=Cn,rs=n(),le=o("table"),le.innerHTML=In,ps=n(),oe=o("p"),oe.innerHTML=xn,cs=n(),p(ie.$$.fragment),ds=n(),re=o("p"),re.innerHTML=vn,us=n(),p(pe.$$.fragment),ms=n(),ce=o("p"),ce.textContent=Fn,Ms=n(),de=o("ul"),de.innerHTML=$n,hs=n(),p(ue.$$.fragment),ys=n(),me=o("p"),me.innerHTML=Gn,fs=n(),p(Me.$$.fragment),Ts=n(),U=o("div"),p(he.$$.fragment),_s=n(),Ue=o("p"),Ue.innerHTML=qn,Us=n(),p(ye.$$.fragment),gs=n(),f=o("div"),p(fe.$$.fragment),Cs=n(),ge=o("p"),ge.textContent=Rn,Is=n(),p(Te.$$.fragment),xs=n(),je=o("p"),je.innerHTML=Zn,js=n(),Je=o("p"),this.h()},l(t){const e=Vn("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(a),be=l(t),we=i(t,"P",{}),bs(we).forEach(a),ke=l(t),c(b.$$.fragment,t),_e=l(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-o839x3"&&(k.textContent=Fs),Ce=l(t),_=i(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-exgkch"&&(_.innerHTML=$s),Ie=l(t),c(C.$$.fragment,t),xe=l(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-8asaew"&&(I.innerHTML=Gs),ve=l(t),c(x.$$.fragment,t),Fe=l(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1gbidw"&&(v.innerHTML=qs),$e=l(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-ulikv8"&&(F.textContent=Rs),Ge=l(t),c($.$$.fragment,t),qe=l(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-ryagwl"&&(G.innerHTML=Zs),Re=l(t),c(q.$$.fragment,t),Ze=l(t),c(R.$$.fragment,t),Be=l(t),Z=i(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-13sbeoj"&&(Z.innerHTML=Bs),ze=l(t),c(B.$$.fragment,t),Qe=l(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1a743rp"&&(z.innerHTML=zs),Ee=l(t),c(Q.$$.fragment,t),Xe=l(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-rjhq4r"&&(E.innerHTML=Qs),Ne=l(t),c(X.$$.fragment,t),Se=l(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-dfggk8"&&(N.innerHTML=Es),Ve=l(t),c(S.$$.fragment,t),We=l(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-xlwe87"&&(V.innerHTML=Xs),Ae=l(t),W=i(t,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-1enki0k"&&(W.innerHTML=Ns),He=l(t),A=i(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-14yxh0m"&&(A.innerHTML=Ss),Le=l(t),c(H.$$.fragment,t),Ye=l(t),L=i(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-13h81gp"&&(L.innerHTML=Vs),De=l(t),c(Y.$$.fragment,t),Pe=l(t),c(D.$$.fragment,t),Oe=l(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-3j3q6p"&&(P.innerHTML=Ws),Ke=l(t),O=i(t,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-5iwuvk"&&(O.innerHTML=As),ta=l(t),c(K.$$.fragment,t),ea=l(t),tt=i(t,"UL",{"data-svelte-h":!0}),r(tt)!=="svelte-23l1e6"&&(tt.innerHTML=Hs),aa=l(t),c(et.$$.fragment,t),sa=l(t),at=i(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-15y0dbb"&&(at.innerHTML=Ls),na=l(t),c(st.$$.fragment,t),la=l(t),nt=i(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1da8xo3"&&(nt.textContent=Ys),oa=l(t),c(lt.$$.fragment,t),ia=l(t),ot=i(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-cqsf2h"&&(ot.innerHTML=Ds),ra=l(t),c(it.$$.fragment,t),pa=l(t),rt=i(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-l25vq0"&&(rt.innerHTML=Ps),ca=l(t),c(pt.$$.fragment,t),da=l(t),ct=i(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1iqmdsd"&&(ct.innerHTML=Os),ua=l(t),c(dt.$$.fragment,t),ma=l(t),ut=i(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1a4epj8"&&(ut.innerHTML=Ks),Ma=l(t),c(mt.$$.fragment,t),ha=l(t),Mt=i(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-5wxaqa"&&(Mt.innerHTML=tn),ya=l(t),c(ht.$$.fragment,t),fa=l(t),yt=i(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-iejqw3"&&(yt.innerHTML=en),Ta=l(t),c(ft.$$.fragment,t),Ua=l(t),Tt=i(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-qqgn8q"&&(Tt.innerHTML=an),ga=l(t),c(Ut.$$.fragment,t),ja=l(t),gt=i(t,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1bm376s"&&(gt.innerHTML=sn),wa=l(t),c(jt.$$.fragment,t),Ja=l(t),c(wt.$$.fragment,t),ba=l(t),Jt=i(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1su7aih"&&(Jt.innerHTML=nn),ka=l(t),c(bt.$$.fragment,t),_a=l(t),kt=i(t,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-11jfbzz"&&(kt.textContent=ln),Ca=l(t),c(_t.$$.fragment,t),Ia=l(t),Ct=i(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-pwdaav"&&(Ct.innerHTML=on),xa=l(t),c(It.$$.fragment,t),va=l(t),xt=i(t,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-zbh7v5"&&(xt.innerHTML=rn),Fa=l(t),c(vt.$$.fragment,t),$a=l(t),c(Ft.$$.fragment,t),Ga=l(t),$t=i(t,"P",{"data-svelte-h":!0}),r($t)!=="svelte-fyvvsj"&&($t.textContent=pn),qa=l(t),c(Gt.$$.fragment,t),Ra=l(t),qt=i(t,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-yypgof"&&(qt.textContent=cn),Za=l(t),c(Rt.$$.fragment,t),Ba=l(t),Zt=i(t,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-yugu96"&&(Zt.innerHTML=dn),za=l(t),c(Bt.$$.fragment,t),Qa=l(t),zt=i(t,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-1qms4cl"&&(zt.innerHTML=un),Ea=l(t),c(Qt.$$.fragment,t),Xa=l(t),Et=i(t,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-qe5zfz"&&(Et.innerHTML=mn),Na=l(t),Xt=i(t,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-69u1rz"&&(Xt.textContent=Mn),Sa=l(t),Nt=i(t,"TABLE",{"data-svelte-h":!0}),r(Nt)!=="svelte-8fq96j"&&(Nt.innerHTML=hn),Va=l(t),c(St.$$.fragment,t),Wa=l(t),Vt=i(t,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-1rqlm78"&&(Vt.innerHTML=yn),Aa=l(t),c(Wt.$$.fragment,t),Ha=l(t),At=i(t,"P",{"data-svelte-h":!0}),r(At)!=="svelte-sqoxna"&&(At.innerHTML=fn),La=l(t),c(Ht.$$.fragment,t),Ya=l(t),Lt=i(t,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-vfpk19"&&(Lt.textContent=Tn),Da=l(t),Yt=i(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-zatc00"&&(Yt.textContent=Un),Pa=l(t),c(Dt.$$.fragment,t),Oa=l(t),Pt=i(t,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-6trhkk"&&(Pt.innerHTML=gn),Ka=l(t),Ot=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Ot)!=="svelte-1ejl1pl"&&(Ot.innerHTML=jn),ts=l(t),g=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(g)!=="svelte-1wkjgyb"&&(g.innerHTML=wn),es=l(t),Kt=i(t,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-7jwpzy"&&(Kt.innerHTML=Jn),as=l(t),c(te.$$.fragment,t),ss=l(t),ee=i(t,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-sqj12"&&(ee.innerHTML=bn),ns=l(t),j=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(j)!=="svelte-a1m5gi"&&(j.innerHTML=kn),ls=l(t),ae=i(t,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-rwofnh"&&(ae.innerHTML=_n),os=l(t),c(se.$$.fragment,t),is=l(t),ne=i(t,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1q1m1nw"&&(ne.innerHTML=Cn),rs=l(t),le=i(t,"TABLE",{"data-svelte-h":!0}),r(le)!=="svelte-lj2wpp"&&(le.innerHTML=In),ps=l(t),oe=i(t,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1p74c9x"&&(oe.innerHTML=xn),cs=l(t),c(ie.$$.fragment,t),ds=l(t),re=i(t,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1o18rwj"&&(re.innerHTML=vn),us=l(t),c(pe.$$.fragment,t),ms=l(t),ce=i(t,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-g801h1"&&(ce.textContent=Fn),Ms=l(t),de=i(t,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-1nhm2ti"&&(de.innerHTML=$n),hs=l(t),c(ue.$$.fragment,t),ys=l(t),me=i(t,"P",{"data-svelte-h":!0}),r(me)!=="svelte-xofzi2"&&(me.innerHTML=Gn),fs=l(t),c(Me.$$.fragment,t),Ts=l(t),U=i(t,"DIV",{class:!0});var Js=bs(U);c(he.$$.fragment,Js),_s=l(Js),Ue=i(Js,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-14oyph8"&&(Ue.innerHTML=qn),Js.forEach(a),Us=l(t),c(ye.$$.fragment,t),gs=l(t),f=i(t,"DIV",{class:!0});var w=bs(f);c(fe.$$.fragment,w),Cs=l(w),ge=i(w,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1dlriq1"&&(ge.textContent=Rn),Is=l(w),c(Te.$$.fragment,w),xs=l(w),je=i(w,"P",{"data-svelte-h":!0}),r(je)!=="svelte-gymob5"&&(je.innerHTML=Zn),w.forEach(a),js=l(t),Je=i(t,"P",{}),bs(Je).forEach(a),this.h()},h(){ks(T,"name","hf:doc:metadata"),ks(T,"content",An),Bn(g,"text-align","center"),Bn(j,"text-align","center"),ks(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ks(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){J(document.head,T),s(t,be,e),s(t,we,e),s(t,ke,e),d(b,t,e),s(t,_e,e),s(t,k,e),s(t,Ce,e),s(t,_,e),s(t,Ie,e),d(C,t,e),s(t,xe,e),s(t,I,e),s(t,ve,e),d(x,t,e),s(t,Fe,e),s(t,v,e),s(t,$e,e),s(t,F,e),s(t,Ge,e),d($,t,e),s(t,qe,e),s(t,G,e),s(t,Re,e),d(q,t,e),s(t,Ze,e),d(R,t,e),s(t,Be,e),s(t,Z,e),s(t,ze,e),d(B,t,e),s(t,Qe,e),s(t,z,e),s(t,Ee,e),d(Q,t,e),s(t,Xe,e),s(t,E,e),s(t,Ne,e),d(X,t,e),s(t,Se,e),s(t,N,e),s(t,Ve,e),d(S,t,e),s(t,We,e),s(t,V,e),s(t,Ae,e),s(t,W,e),s(t,He,e),s(t,A,e),s(t,Le,e),d(H,t,e),s(t,Ye,e),s(t,L,e),s(t,De,e),d(Y,t,e),s(t,Pe,e),d(D,t,e),s(t,Oe,e),s(t,P,e),s(t,Ke,e),s(t,O,e),s(t,ta,e),d(K,t,e),s(t,ea,e),s(t,tt,e),s(t,aa,e),d(et,t,e),s(t,sa,e),s(t,at,e),s(t,na,e),d(st,t,e),s(t,la,e),s(t,nt,e),s(t,oa,e),d(lt,t,e),s(t,ia,e),s(t,ot,e),s(t,ra,e),d(it,t,e),s(t,pa,e),s(t,rt,e),s(t,ca,e),d(pt,t,e),s(t,da,e),s(t,ct,e),s(t,ua,e),d(dt,t,e),s(t,ma,e),s(t,ut,e),s(t,Ma,e),d(mt,t,e),s(t,ha,e),s(t,Mt,e),s(t,ya,e),d(ht,t,e),s(t,fa,e),s(t,yt,e),s(t,Ta,e),d(ft,t,e),s(t,Ua,e),s(t,Tt,e),s(t,ga,e),d(Ut,t,e),s(t,ja,e),s(t,gt,e),s(t,wa,e),d(jt,t,e),s(t,Ja,e),d(wt,t,e),s(t,ba,e),s(t,Jt,e),s(t,ka,e),d(bt,t,e),s(t,_a,e),s(t,kt,e),s(t,Ca,e),d(_t,t,e),s(t,Ia,e),s(t,Ct,e),s(t,xa,e),d(It,t,e),s(t,va,e),s(t,xt,e),s(t,Fa,e),d(vt,t,e),s(t,$a,e),d(Ft,t,e),s(t,Ga,e),s(t,$t,e),s(t,qa,e),d(Gt,t,e),s(t,Ra,e),s(t,qt,e),s(t,Za,e),d(Rt,t,e),s(t,Ba,e),s(t,Zt,e),s(t,za,e),d(Bt,t,e),s(t,Qa,e),s(t,zt,e),s(t,Ea,e),d(Qt,t,e),s(t,Xa,e),s(t,Et,e),s(t,Na,e),s(t,Xt,e),s(t,Sa,e),s(t,Nt,e),s(t,Va,e),d(St,t,e),s(t,Wa,e),s(t,Vt,e),s(t,Aa,e),d(Wt,t,e),s(t,Ha,e),s(t,At,e),s(t,La,e),d(Ht,t,e),s(t,Ya,e),s(t,Lt,e),s(t,Da,e),s(t,Yt,e),s(t,Pa,e),d(Dt,t,e),s(t,Oa,e),s(t,Pt,e),s(t,Ka,e),s(t,Ot,e),s(t,ts,e),s(t,g,e),s(t,es,e),s(t,Kt,e),s(t,as,e),d(te,t,e),s(t,ss,e),s(t,ee,e),s(t,ns,e),s(t,j,e),s(t,ls,e),s(t,ae,e),s(t,os,e),d(se,t,e),s(t,is,e),s(t,ne,e),s(t,rs,e),s(t,le,e),s(t,ps,e),s(t,oe,e),s(t,cs,e),d(ie,t,e),s(t,ds,e),s(t,re,e),s(t,us,e),d(pe,t,e),s(t,ms,e),s(t,ce,e),s(t,Ms,e),s(t,de,e),s(t,hs,e),d(ue,t,e),s(t,ys,e),s(t,me,e),s(t,fs,e),d(Me,t,e),s(t,Ts,e),s(t,U,e),d(he,U,null),J(U,_s),J(U,Ue),s(t,Us,e),d(ye,t,e),s(t,gs,e),s(t,f,e),d(fe,f,null),J(f,Cs),J(f,ge),J(f,Is),d(Te,f,null),J(f,xs),J(f,je),s(t,js,e),s(t,Je,e),ws=!0},p:En,i(t){ws||(u(b.$$.fragment,t),u(C.$$.fragment,t),u(x.$$.fragment,t),u($.$$.fragment,t),u(q.$$.fragment,t),u(R.$$.fragment,t),u(B.$$.fragment,t),u(Q.$$.fragment,t),u(X.$$.fragment,t),u(S.$$.fragment,t),u(H.$$.fragment,t),u(Y.$$.fragment,t),u(D.$$.fragment,t),u(K.$$.fragment,t),u(et.$$.fragment,t),u(st.$$.fragment,t),u(lt.$$.fragment,t),u(it.$$.fragment,t),u(pt.$$.fragment,t),u(dt.$$.fragment,t),u(mt.$$.fragment,t),u(ht.$$.fragment,t),u(ft.$$.fragment,t),u(Ut.$$.fragment,t),u(jt.$$.fragment,t),u(wt.$$.fragment,t),u(bt.$$.fragment,t),u(_t.$$.fragment,t),u(It.$$.fragment,t),u(vt.$$.fragment,t),u(Ft.$$.fragment,t),u(Gt.$$.fragment,t),u(Rt.$$.fragment,t),u(Bt.$$.fragment,t),u(Qt.$$.fragment,t),u(St.$$.fragment,t),u(Wt.$$.fragment,t),u(Ht.$$.fragment,t),u(Dt.$$.fragment,t),u(te.$$.fragment,t),u(se.$$.fragment,t),u(ie.$$.fragment,t),u(pe.$$.fragment,t),u(ue.$$.fragment,t),u(Me.$$.fragment,t),u(he.$$.fragment,t),u(ye.$$.fragment,t),u(fe.$$.fragment,t),u(Te.$$.fragment,t),ws=!0)},o(t){m(b.$$.fragment,t),m(C.$$.fragment,t),m(x.$$.fragment,t),m($.$$.fragment,t),m(q.$$.fragment,t),m(R.$$.fragment,t),m(B.$$.fragment,t),m(Q.$$.fragment,t),m(X.$$.fragment,t),m(S.$$.fragment,t),m(H.$$.fragment,t),m(Y.$$.fragment,t),m(D.$$.fragment,t),m(K.$$.fragment,t),m(et.$$.fragment,t),m(st.$$.fragment,t),m(lt.$$.fragment,t),m(it.$$.fragment,t),m(pt.$$.fragment,t),m(dt.$$.fragment,t),m(mt.$$.fragment,t),m(ht.$$.fragment,t),m(ft.$$.fragment,t),m(Ut.$$.fragment,t),m(jt.$$.fragment,t),m(wt.$$.fragment,t),m(bt.$$.fragment,t),m(_t.$$.fragment,t),m(It.$$.fragment,t),m(vt.$$.fragment,t),m(Ft.$$.fragment,t),m(Gt.$$.fragment,t),m(Rt.$$.fragment,t),m(Bt.$$.fragment,t),m(Qt.$$.fragment,t),m(St.$$.fragment,t),m(Wt.$$.fragment,t),m(Ht.$$.fragment,t),m(Dt.$$.fragment,t),m(te.$$.fragment,t),m(se.$$.fragment,t),m(ie.$$.fragment,t),m(pe.$$.fragment,t),m(ue.$$.fragment,t),m(Me.$$.fragment,t),m(he.$$.fragment,t),m(ye.$$.fragment,t),m(fe.$$.fragment,t),m(Te.$$.fragment,t),ws=!1},d(t){t&&(a(be),a(we),a(ke),a(_e),a(k),a(Ce),a(_),a(Ie),a(xe),a(I),a(ve),a(Fe),a(v),a($e),a(F),a(Ge),a(qe),a(G),a(Re),a(Ze),a(Be),a(Z),a(ze),a(Qe),a(z),a(Ee),a(Xe),a(E),a(Ne),a(Se),a(N),a(Ve),a(We),a(V),a(Ae),a(W),a(He),a(A),a(Le),a(Ye),a(L),a(De),a(Pe),a(Oe),a(P),a(Ke),a(O),a(ta),a(ea),a(tt),a(aa),a(sa),a(at),a(na),a(la),a(nt),a(oa),a(ia),a(ot),a(ra),a(pa),a(rt),a(ca),a(da),a(ct),a(ua),a(ma),a(ut),a(Ma),a(ha),a(Mt),a(ya),a(fa),a(yt),a(Ta),a(Ua),a(Tt),a(ga),a(ja),a(gt),a(wa),a(Ja),a(ba),a(Jt),a(ka),a(_a),a(kt),a(Ca),a(Ia),a(Ct),a(xa),a(va),a(xt),a(Fa),a($a),a(Ga),a($t),a(qa),a(Ra),a(qt),a(Za),a(Ba),a(Zt),a(za),a(Qa),a(zt),a(Ea),a(Xa),a(Et),a(Na),a(Xt),a(Sa),a(Nt),a(Va),a(Wa),a(Vt),a(Aa),a(Ha),a(At),a(La),a(Ya),a(Lt),a(Da),a(Yt),a(Pa),a(Oa),a(Pt),a(Ka),a(Ot),a(ts),a(g),a(es),a(Kt),a(as),a(ss),a(ee),a(ns),a(j),a(ls),a(ae),a(os),a(is),a(ne),a(rs),a(le),a(ps),a(oe),a(cs),a(ds),a(re),a(us),a(ms),a(ce),a(Ms),a(de),a(hs),a(ys),a(me),a(fs),a(Ts),a(U),a(Us),a(gs),a(f),a(js),a(Je)),a(T),M(b,t),M(C,t),M(x,t),M($,t),M(q,t),M(R,t),M(B,t),M(Q,t),M(X,t),M(S,t),M(H,t),M(Y,t),M(D,t),M(K,t),M(et,t),M(st,t),M(lt,t),M(it,t),M(pt,t),M(dt,t),M(mt,t),M(ht,t),M(ft,t),M(Ut,t),M(jt,t),M(wt,t),M(bt,t),M(_t,t),M(It,t),M(vt,t),M(Ft,t),M(Gt,t),M(Rt,t),M(Bt,t),M(Qt,t),M(St,t),M(Wt,t),M(Ht,t),M(Dt,t),M(te,t),M(se,t),M(ie,t),M(pe,t),M(ue,t),M(Me,t),M(he),M(ye,t),M(fe),M(Te)}}}const An='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[{"title":"Using token_ids directly for response_template","local":"using-tokenids-directly-for-responsetemplate","sections":[],"depth":4}],"depth":3},{"title":"Dataset format support","local":"dataset-format-support","sections":[],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset ( ConstantLengthDataset )","local":"packing-dataset--constantlengthdataset-","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"control-over-the-pretrained-model","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3},{"title":"Enhance model’s performances using NEFTune","local":"enhance-models-performances-using-neftune","sections":[],"depth":3},{"title":"Accelerate fine-tuning 2x using unsloth","local":"accelerate-fine-tuning-2x-using-unsloth","sections":[],"depth":3}],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"GPTQ Conversion","local":"gptq-conversion","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"ConstantLengthDataset","local":"trl.trainer.ConstantLengthDataset","sections":[{"title":"Answer: {answer}","local":"answer-answer","sections":[],"depth":3}],"depth":2}],"depth":1}';function Hn(vs){return Xn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kn extends Nn{constructor(T){super(),Sn(this,T,Hn,Wn,Qn,{})}}export{Kn as component};
