import{s as $l,o as vl,n as tl}from"../chunks/scheduler.9039eef2.js";import{S as Xl,i as zl,g as o,s as n,r as d,A as Cl,h as p,f as t,c as i,j as Wl,u as M,x as T,k as al,y as Al,a,v as w,d as y,t as h,w as u}from"../chunks/index.cdcc3d35.js";import{T as ll}from"../chunks/Tip.6f74db41.js";import{C as B}from"../chunks/CodeBlock.e3ac94d9.js";import{H as X}from"../chunks/Heading.96ce3702.js";function Gl(j){let s,b="All the example scripts provided in the optimum-neuron repo have those features implemented via the <code>NeuronTrainer</code>.";return{c(){s=o("p"),s.innerHTML=b},l(m){s=p(m,"P",{"data-svelte-h":!0}),T(s)!=="svelte-18pumv8"&&(s.innerHTML=b)},m(m,J){a(m,s,J)},p:tl,d(m){m&&t(s)}}}function Rl(j){let s,b=`Since the example scripts use the <code>NeuronTrainer</code>, you can enable ZeRO-1 when using them by add the <code>--zero_1</code> flag
to your command line.`,m,J,I="For example:",f,c,_;return c=new B({props:{code:"dG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMiUyMGV4YW1wbGVzJTJGbGFuZ3VhZ2UtbW9kZWxpbmclMkZydW5fY2xtLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBUaW55TGxhbWElMkZUaW55TGxhbWEtMS4xQi1DaGF0LXYwLjYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfbmFtZSUyMHdpa2l0ZXh0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X2NvbmZpZ19uYW1lJTIwd2lraXRleHQtMi1yYXctdjElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRvX3RyYWluJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ibG9ja19zaXplJTIwMTAyNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tYmYxNiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0temVyb18xJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1vdXRwdXRfZGlyJTIwbXlfdHJhaW5pbmclMkYlMEE=",highlighted:`torchrun --nproc_per_node=2 examples/language-modeling/run_clm.py \\
    --model_name_or_path TinyLlama/TinyLlama-1.1B-Chat-v0.6 \\
    --dataset_name wikitext \\
    --dataset_config_name wikitext-2-raw-v1 \\
    --do_train \\
    --per_device_train_batch_size 1 \\
    --block_size 1024 \\
    --bf16 \\
    --zero_1 \\
    --output_dir my_training/
`,wrap:!1}}),{c(){s=o("p"),s.innerHTML=b,m=n(),J=o("p"),J.textContent=I,f=n(),d(c.$$.fragment)},l(r){s=p(r,"P",{"data-svelte-h":!0}),T(s)!=="svelte-1971m31"&&(s.innerHTML=b),m=i(r),J=p(r,"P",{"data-svelte-h":!0}),T(J)!=="svelte-1gkqha7"&&(J.textContent=I),f=i(r),M(c.$$.fragment,r)},m(r,U){a(r,s,U),a(r,m,U),a(r,J,U),a(r,f,U),w(c,r,U),_=!0},p:tl,i(r){_||(y(c.$$.fragment,r),_=!0)},o(r){h(c.$$.fragment,r),_=!1},d(r){r&&(t(s),t(m),t(J),t(f)),u(c,r)}}}function Zl(j){let s,b=`Since the example scripts use the <code>NeuronTrainer</code>, you can enable Tensor Parallelism when using them by specifying the <code>--tensor_parallel_size</code> argument, and optionally the <code>disable_embedding_parallelization</code> and <code>disable_sequence_parallel</code> flags.
to your command line.`,m,J,I="For example:",f,c,_;return c=new B({props:{code:"dG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMiUyMGV4YW1wbGVzJTJGbGFuZ3VhZ2UtbW9kZWxpbmclMkZydW5fY2xtLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBUaW55TGxhbWElMkZUaW55TGxhbWEtMS4xQi1DaGF0LXYwLjYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfbmFtZSUyMHdpa2l0ZXh0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X2NvbmZpZ19uYW1lJTIwd2lraXRleHQtMi1yYXctdjElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRvX3RyYWluJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ibG9ja19zaXplJTIwMTAyNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tYmYxNiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGVuc29yX3BhcmFsbGVsX3NpemUlMjAyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1vdXRwdXRfZGlyJTIwbXlfdHJhaW5pbmclMkY=",highlighted:`torchrun --nproc_per_node=2 examples/language-modeling/run_clm.py \\
    --model_name_or_path TinyLlama/TinyLlama-1.1B-Chat-v0.6 \\
    --dataset_name wikitext \\
    --dataset_config_name wikitext-2-raw-v1 \\
    --do_train \\
    --per_device_train_batch_size 1 \\
    --block_size 1024 \\
    --bf16 \\
    --tensor_parallel_size 2 \\
    --output_dir my_training/`,wrap:!1}}),{c(){s=o("p"),s.innerHTML=b,m=n(),J=o("p"),J.textContent=I,f=n(),d(c.$$.fragment)},l(r){s=p(r,"P",{"data-svelte-h":!0}),T(s)!=="svelte-ar8hdp"&&(s.innerHTML=b),m=i(r),J=p(r,"P",{"data-svelte-h":!0}),T(J)!=="svelte-1gkqha7"&&(J.textContent=I),f=i(r),M(c.$$.fragment,r)},m(r,U){a(r,s,U),a(r,m,U),a(r,J,U),a(r,f,U),w(c,r,U),_=!0},p:tl,i(r){_||(y(c.$$.fragment,r),_=!0)},o(r){h(c.$$.fragment,r),_=!1},d(r){r&&(t(s),t(m),t(J),t(f)),u(c,r)}}}function Ql(j){let s,b="The sharded checkpoints are saved under a directory called <code>tensor_parallel_shards</code>. The <code>optimum-cli neuron consolidate</code> command accept as input both a directory that contains a <code>tensor_parallel_shards</code> directory, or the <code>tensor_parallel_shards</code> directory itself.";return{c(){s=o("p"),s.innerHTML=b},l(m){s=p(m,"P",{"data-svelte-h":!0}),T(s)!=="svelte-1rjmyzp"&&(s.innerHTML=b)},m(m,J){a(m,s,J)},p:tl,d(m){m&&t(s)}}}function Vl(j){let s,b,m,J,I,f,c,_='<a href="https://aws.amazon.com/machine-learning/trainium/" rel="nofollow">AWS Trainium instances</a> are great to train models. They can contain up to 16 Neuron devices, each device containing 2 Neuron cores and has 32GB of memory (16GB per core). For example a <code>trn1.32xlarge</code> instance has 32 x 16 = 512GB of memory.',r,U,nl="But there is a caveat: each Neuron core is an independent data-parallel worker by default. It means that the model, the gradient state and the optimizer state, amounting to approximately 4 times the model size, must fit in each of the Neuron cores (16GB) to be able to train. If that is the case, then the activations must also fit in the remaining memory.",de,z,il="To alleviate that, <code>optimum-neuron</code> supports parallelism features enabling you to harness the full power of your Trainium instance:",Me,C,rl='<li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/frameworks/torch/torch-neuronx/tutorials/training/zero1_gpt2.html" rel="nofollow">ZeRO-1</a>: It is an optimization of data-parallelism which consists in sharding the optimizer state (which usually represents half of the memory needed on the device) over the data-parallel ranks.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/tensor_parallelism_overview.html" rel="nofollow">Tensor Parallelism</a>: It is a technique which consists in sharding each of your model matrix-multiplications along a given axis (row or column) on multiple devices. It also known as intra-layer model parallelism. The number of devices to shard your parameters on is called the <code>tensor_parallel_size</code>.</li> <li><a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Sequence parallelism</a>: It is an optimization over Tensor Parallelism which shards the activations on the sequence axis outside of the tensor parallel regions. It is useful because it saves memory by sharding the activations.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/pipeline_parallelism_overview.html" rel="nofollow">Pipeline Parallelism</a>: It consists in sharding the model block layers on multiple devices. It is also known as inter-layer model parallelism. The number of devices to shard your layers on is called the <code>pipeline_parallel_size</code>.</li>',we,A,sl="The good news is that is it possible to combine those techniques, and <code>optimum-neuron</code> makes it very easy!",ye,k,he,G,ue,R,ol='Whether you use the <a href="/docs/optimum.neuron/v0.0.28.dev1/en/package_reference/trainer#optimum.neuron.NeuronTrainer">NeuronTrainer</a> or decide to have your own training script that uses the <code>NeuronAccelerator</code>, it is very easy to enable the ZeRO-1 optimization.',Ue,Z,be,Q,fe,g,Ie,V,_e,x,pl="There is a little bit more work to do when not using the <code>NeuronTrainer</code>:",je,N,Tl="<li>(Optional) Wrap the optimizer class to make it lazy. When ZeRO-1 is enabled the original optimizer is overridden to use a sharded version of it. Hence, it is possible to load the original optimizer lazily so that the optimizer state is not materialized until it is actually sharded.</li>",Be,Y,ke,W,ml="<li>Set the <code>zero_1</code> argument to <code>True</code> when instantiating the <code>NeuronAccelerator</code>.</li>",ge,E,We,F,$e,H,Jl='Just as for ZeRO-1, it is possible to apply Tensor Parallelism either with the <a href="/docs/optimum.neuron/v0.0.28.dev1/en/package_reference/trainer#optimum.neuron.NeuronTrainer">NeuronTrainer</a> or the <code>NeuronAccelerator</code>.',ve,L,cl="When doing Tensor Parallelism, you have different settings:",Xe,O,dl=`<li>The <code>tensor_parallel_size</code>. Ideally it should be smallest value for which the model fits.</li> <li>Whether or not sequence parallelism should be enabled. <a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Sequence parallelism</a> shards the activations on the sequence axis outside of the tensor parallel regions.
It is useful because it saves memory by sharding the activations.</li> <li>Whether or not parallelization of the embedding layer should be done. By default it is done because it offers multiple benefits:</li>`,ze,S,Ml=`<li>Parallelizing the embedding layer saves memory, which can enable fitting a bigger batch size and/or sequence length.</li> <li>For language models, where the embedding layer weights and the language-modeling head weights are usually tied, the language-modeling head ends up parallel
and does not require to <code>all-gather</code> its output since it is fed to a cross entropy loss compatible with parallelism, saving expensive communication.</li>`,Ce,D,wl="On top of that, it is very important to make sure that the original model is loaded in an efficient manner: the training script is going to be called by <code>torchrun</code>, which will dispatch it to workers, one worker per core. If each worker (there are 32 of them in  a <code>trn1.32xlarge</code> instance) loads the full model weights, it can take a lot of time and go out-of-memory really fast.",Ae,P,yl='<code>optimum-neuron</code> provides a context-manager <a href="/docs/optimum.neuron/v0.0.28.dev1/en/package_reference/distributed#optimum.neuron.distributed.lazy_load_for_parallelism">distributed.lazy_load_for_parallelism()</a> that loads the model lazily to prevent that, only the parameters of the corresponding model shard will be materialized in each worker.',Ge,q,Re,K,Ze,$,Qe,ee,Ve,le,hl="Just as for ZeRO-1, it is possible to wrap the optimizer class to make it lazy. Since the model parameters are going to be sharded, it is not needed to materialize the optimizer state prior to model parallelization: the wrapper makes sure that it stays unmaterialized.",xe,te,Ne,ae,Ye,ne,ul="Since Tensor Parallelism consists in sharding the model weights accross different workers, only sharded checkpoints will be saved during training. It is necessary to consolidate the sharded checkpoints to be able to share and use them outside of the specific training configuration there were created under.",Ee,ie,Ul="The Optimum CLI provides a way of doing that very easily via the <code>optimum neuron consolidate</code> command:",Fe,re,He,se,bl=`All you need to do is specify the sharded checkpoints directory and the output directory that will contain the consolidated checkpoints, and the command takes care of the rest.
It is also possible to specify the output format of the consolidated checkpoints, by default it will export them to the <code>safetensors</code> format, which is the recommend format to use.`,Le,oe,fl="Example:",Oe,pe,Il="Training with Tensor Parallelism just completed and the output dir is called <code>my_training</code>. The directory looks like the following:",Se,Te,De,me,_l="It is possible to consolidate the sharded checkpoints in <code>my_training/tensor_parallel_shards</code>, which correspond to the sharded checkpoints saved at the end of the training, by running the following command:",Pe,Je,qe,v,Ke,ce,el;return I=new X({props:{title:"Distributed Training with optimum-neuron",local:"distributed-training-with-optimum-neuron",headingTag:"h1"}}),k=new ll({props:{$$slots:{default:[Gl]},$$scope:{ctx:j}}}),G=new X({props:{title:"How to enable ZeRO-1?",local:"how-to-enable-zero-1",headingTag:"h2"}}),Z=new X({props:{title:"Via the NeuronTrainer",local:"via-the-neurontrainer",headingTag:"h3"}}),Q=new B({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBOZXVyb25UcmFpbmVyJTBBJTBBJTIzJTIwVG8lMjBlbmFibGUlMjBaZVJPLTElMkMlMjBzZXQlMjB0aGUlMjAlNjB6ZXJvXzElNjAlMjBhcmd1bWVudCUyMHRvJTIwJTYwVHJ1ZSU2MCUyMGluJTIwdGhlJTIwdHJhaW5pbmclMjBhcmd1bWVudHMuJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyME5ldXJvblRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMHplcm9fMSUzRFRydWUlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyME5ldXJvblRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0JTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainingArguments, NeuronTrainer

<span class="hljs-comment"># To enable ZeRO-1, set the \`zero_1\` argument to \`True\` in the training arguments.</span>
training_args = NeuronTrainingArguments(
    ...,
    zero_1=<span class="hljs-literal">True</span>,
)

trainer = NeuronTrainer(
    model,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)

trainer.train()`,wrap:!1}}),g=new ll({props:{$$slots:{default:[Rl]},$$scope:{ctx:j}}}),V=new X({props:{title:"Via the NeuronAccelerator",local:"via-the-neuronaccelerator",headingTag:"h3"}}),Y=new B({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwb3B0aW11bS5uZXVyb24uZGlzdHJpYnV0ZWQlMjBpbXBvcnQlMjBtYWtlX29wdGltaXplcl9jb25zdHJ1Y3Rvcl9sYXp5JTBBJTBBbGF6eV9hZGFtdyUyMCUzRCUyMG1ha2Vfb3B0aW1pemVyX2NvbnN0cnVjdG9yX2xhenkoQWRhbVcp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> optimum.neuron.distributed <span class="hljs-keyword">import</span> make_optimizer_constructor_lazy

lazy_adamw = make_optimizer_constructor_lazy(AdamW)`,wrap:!1}}),E=new B({props:{code:"YWNjZWxlcmF0b3IlMjAlM0QlMjBOZXVyb25BY2NlbGVyYXRvciglMEElMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjB6ZXJvXzElM0RUcnVlJTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwLi4uJTBBbGF6eV9vcHRpbWl6ZXIlMjAlM0QlMjBsYXp5X2FkYW13KC4uLiklMjAlMjMlMjBBY3R1YWxseSUyMGluc3RhbnRpYXRlJTIwdGhlJTIwb3B0aW1pemVyLiUwQSUwQSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZShtb2RlbCUyQyUyMGxhenlfb3B0aW1pemVyKQ==",highlighted:`accelerator = NeuronAccelerator(
    ...
    zero_1=<span class="hljs-literal">True</span>,
)

model = ...
lazy_optimizer = lazy_adamw(...) <span class="hljs-comment"># Actually instantiate the optimizer.</span>


model, optimizer = accelerator.prepare(model, lazy_optimizer)`,wrap:!1}}),F=new X({props:{title:"How to enable Tensor Parallelism?",local:"how-to-enable-tensor-parallelism",headingTag:"h2"}}),q=new X({props:{title:"Via the NeuronTrainer",local:"via-the-neurontrainer",headingTag:"h3"}}),K=new B({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBOZXVyb25UcmFpbmVyJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uLmRpc3RyaWJ1dGVkJTIwaW1wb3J0JTIwbGF6eV9sb2FkX2Zvcl9wYXJhbGxlbGlzbSUwQSUwQSUyMyUyMFNwZWNpZnklMjB0aGUlMjAlNjB0ZW5zb3JfcGFyYWxsZWxfc2l6ZSU2MCUyMGluJTIwdGhlJTIwdHJhaW5pbmclMjBhcmd1bWVudHMuJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyME5ldXJvblRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMHRlbnNvcl9wYXJhbGxlbF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMGRpc2FibGVfZW1iZWRkaW5nX3BhcmFsbGVsaXphdGlvbiUzREZhbHNlJTJDJTIwJTIzJTIwSXQlMjBpcyUyMCU2MEZhbHNlJTYwJTIwYnklMjBkZWZhdWx0LiUwQSUyMCUyMCUyMCUyMGRpc2FibGVfc2VxdWVuY2VfcGFyYWxsZWwlM0RGYWxzZSUyQyUyMCUyMyUyMEl0JTIwaXMlMjAlNjBGYWxzZSU2MCUyMGJ5JTIwZGVmYXVsdC4lMEEpJTBBJTBBd2l0aCUyMGxhenlfbG9hZF9mb3JfcGFyYWxsZWxpc20odGVuc29yX3BhcmFsbGVsX3NpemUlM0R0cmFpbmluZ19hcmdzLnRlbnNvcl9wYXJhbGxlbF9zaXplKSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwLi4uJTBBJTBBJTBBdHJhaW5lciUyMCUzRCUyME5ldXJvblRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0JTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainingArguments, NeuronTrainer
<span class="hljs-keyword">from</span> optimum.neuron.distributed <span class="hljs-keyword">import</span> lazy_load_for_parallelism

<span class="hljs-comment"># Specify the \`tensor_parallel_size\` in the training arguments.</span>
training_args = NeuronTrainingArguments(
    ...,
    tensor_parallel_size=<span class="hljs-number">8</span>,
    disable_embedding_parallelization=<span class="hljs-literal">False</span>, <span class="hljs-comment"># It is \`False\` by default.</span>
    disable_sequence_parallel=<span class="hljs-literal">False</span>, <span class="hljs-comment"># It is \`False\` by default.</span>
)

<span class="hljs-keyword">with</span> lazy_load_for_parallelism(tensor_parallel_size=training_args.tensor_parallel_size):
    model = ...


trainer = NeuronTrainer(
    model,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)

trainer.train()`,wrap:!1}}),$=new ll({props:{$$slots:{default:[Zl]},$$scope:{ctx:j}}}),ee=new X({props:{title:"Via the NeuronAccelerator",local:"via-the-neuronaccelerator",headingTag:"h3"}}),te=new B({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25BY2NlbGVyYXRvciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbi5hY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwTW9kZWxQYXJhbGxlbGlzbVBsdWdpbiUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbi5kaXN0cmlidXRlZCUyMGltcG9ydCUyMGxhenlfbG9hZF9mb3JfcGFyYWxsZWxpc20lMEElMEF0ZW5zb3JfcGFyYWxsZWxfc2l6ZSUyMCUzRCUyMDglMEFtcF9wbHVnaW4lMjAlM0QlMjBNb2RlbFBhcmFsbGVsaXNtUGx1Z2luKCUwQSUyMCUyMCUyMCUyMHRlbnNvcl9wYXJhbGxlbF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwcGFyYWxsZWxpemVfZW1iZWRkaW5ncyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzZXF1ZW5jZV9wYXJhbGxlbF9lbmFibGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGNoZWNrcG9pbnRfZGlyJTNETm9uZSUyQyUyMCUyMyUyMENhbiUyMGJlJTIwc3BlY2lmaWVkJTIwd2hlbiUyMHJlc3VtaW5nJTIwZnJvbSUyMGNoZWNrcG9pbnQuJTBBKSUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwTmV1cm9uQWNjZWxlcmF0b3IoJTBBJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwbXBfcGx1Z2luJTNEbXBfcGx1Z2luJTJDJTBBKSUwQSUwQXdpdGglMjBsYXp5X2xvYWRfZm9yX3BhcmFsbGVsaXNtKHRlbnNvcl9wYXJhbGxlbF9zaXplJTNEdGVuc29yX3BhcmFsbGVsX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjAuLi4lMEElMEFsYXp5X2FkYW13JTIwJTNEJTIwbWFrZV9vcHRpbWl6ZXJfY29uc3RydWN0b3JfbGF6eShBZGFtVyklMEFsYXp5X29wdGltaXplciUyMCUzRCUyMGxhenlfYWRhbXcoLi4uKSUyMCUyMyUyMEFjdHVhbGx5JTIwaW5zdGFudGlhdGUlMjB0aGUlMjBvcHRpbWl6ZXIuJTBBJTBBbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsJTJDJTIwbGF6eV9vcHRpbWl6ZXIp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronAccelerator
<span class="hljs-keyword">from</span> optimum.neuron.accelerate.utils <span class="hljs-keyword">import</span> ModelParallelismPlugin
<span class="hljs-keyword">from</span> optimum.neuron.distributed <span class="hljs-keyword">import</span> lazy_load_for_parallelism

tensor_parallel_size = <span class="hljs-number">8</span>
mp_plugin = ModelParallelismPlugin(
    tensor_parallel_size,
    parallelize_embeddings=<span class="hljs-literal">True</span>,
    sequence_parallel_enabled=<span class="hljs-literal">True</span>,
    checkpoint_dir=<span class="hljs-literal">None</span>, <span class="hljs-comment"># Can be specified when resuming from checkpoint.</span>
)

accelerator = NeuronAccelerator(
    ...
    mp_plugin=mp_plugin,
)

<span class="hljs-keyword">with</span> lazy_load_for_parallelism(tensor_parallel_size=tensor_parallel_size):
    model = ...

lazy_adamw = make_optimizer_constructor_lazy(AdamW)
lazy_optimizer = lazy_adamw(...) <span class="hljs-comment"># Actually instantiate the optimizer.</span>

model, optimizer = accelerator.prepare(model, lazy_optimizer)`,wrap:!1}}),ae=new X({props:{title:"Checkpoint consolidation",local:"checkpoint-consolidation",headingTag:"h3"}}),re=new B({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMC0taGVscCUwQSUwQXVzYWdlJTNBJTIwb3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMCU1Qi1oJTVEJTIwJTVCLWYlMjAlN0JweXRvcmNoJTJDc2FmZXRlbnNvcnMlN0QlNUQlMjBjaGVja3BvaW50X2RpciUyMG91dHB1dF9kaXIlMEElMEFwb3NpdGlvbmFsJTIwYXJndW1lbnRzJTNBJTBBJTIwJTIwY2hlY2twb2ludF9kaXIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUaGUlMjBwYXRoJTIwdG8lMjB0aGUlMjBkaXJlY3RvcnklMjBjb250YWluaW5nJTIwdGhlJTIwY2hlY2twb2ludHMuJTBBJTIwJTIwb3V0cHV0X2RpciUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRoZSUyMHBhdGglMjB0byUyMHRoZSUyMG91dHB1dCUyMGRpcmVjdG9yeSUyMGNvbnRhaW5pbmclMjB0aGUlMjBjb25zb2xpZGF0ZWQlMjBjaGVja3BvaW50LiUwQSUwQW9wdGlvbmFsJTIwYXJndW1lbnRzJTNBJTBBJTIwJTIwLWglMkMlMjAtLWhlbHAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaG93JTIwdGhpcyUyMGhlbHAlMjBtZXNzYWdlJTIwYW5kJTIwZXhpdCUwQSUyMCUyMC1mJTIwJTdCcHl0b3JjaCUyQ3NhZmV0ZW5zb3JzJTdEJTJDJTIwLS1mb3JtYXQlMjAlN0JweXRvcmNoJTJDc2FmZXRlbnNvcnMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUaGUlMjBmb3JtYXQlMjB1c2VkJTIwdG8lMjBzYXZlJTIwdGhlJTIwY29uc29saWRhdGVkJTIwY2hlY2twb2ludC4lMEE=",highlighted:`optimum-cli neuron consolidate --help

usage: optimum-cli neuron consolidate [-h] [-f {pytorch,safetensors}] checkpoint_dir output_dir

positional arguments:
  checkpoint_dir        The path to the directory containing the checkpoints.
  output_dir            The path to the output directory containing the consolidated checkpoint.

optional arguments:
  -h, --help            show this help message and <span class="hljs-keyword">exit</span>
  -f {pytorch,safetensors}, --format {pytorch,safetensors}
                        The format used to save the consolidated checkpoint.
`,wrap:!1}}),Te=new B({props:{code:"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",highlighted:`my_training/
├── README.md
├── all_results.json 
├── checkpoint-10 
│   ├── config.json
│   ├── scheduler.pt
│   ├── special_tokens_map.json
│   ├── tensor_parallel_shards
│   ├── tokenizer.json
│   ├── tokenizer.model
│   ├── tokenizer_config.json
│   ├── trainer_state.json
│   └── training_args.bin
├── config.json
├── special_tokens_map.json
├── tensor_parallel_shards
│   ├── tp_rank_00_pp_rank_00
│   ├── tp_rank_01_pp_rank_00
│   ├── tp_rank_02_pp_rank_00
│   ├── tp_rank_03_pp_rank_00
│   ├── tp_rank_04_pp_rank_00
│   ├── tp_rank_05_pp_rank_00
│   ├── tp_rank_06_pp_rank_00
│   └── tp_rank_07_pp_rank_00
├── tokenizer.json
├── tokenizer.model
├── tokenizer_config.json
├── train_results.json
├── trainer_state.json
└── training_args.bin`,wrap:!1}}),Je=new B({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMG15X3RyYWluaW5nJTIwbXlfdHJhaW5pbmdfY29uc29saWRhdGVkX2NoZWNrcG9pbnQ=",highlighted:"optimum-cli neuron consolidate my_training my_training_consolidated_checkpoint",wrap:!1}}),v=new ll({props:{$$slots:{default:[Ql]},$$scope:{ctx:j}}}),{c(){s=o("meta"),b=n(),m=o("p"),J=n(),d(I.$$.fragment),f=n(),c=o("p"),c.innerHTML=_,r=n(),U=o("p"),U.textContent=nl,de=n(),z=o("p"),z.innerHTML=il,Me=n(),C=o("ol"),C.innerHTML=rl,we=n(),A=o("p"),A.innerHTML=sl,ye=n(),d(k.$$.fragment),he=n(),d(G.$$.fragment),ue=n(),R=o("p"),R.innerHTML=ol,Ue=n(),d(Z.$$.fragment),be=n(),d(Q.$$.fragment),fe=n(),d(g.$$.fragment),Ie=n(),d(V.$$.fragment),_e=n(),x=o("p"),x.innerHTML=pl,je=n(),N=o("ol"),N.innerHTML=Tl,Be=n(),d(Y.$$.fragment),ke=n(),W=o("ol"),W.innerHTML=ml,ge=n(),d(E.$$.fragment),We=n(),d(F.$$.fragment),$e=n(),H=o("p"),H.innerHTML=Jl,ve=n(),L=o("p"),L.textContent=cl,Xe=n(),O=o("ol"),O.innerHTML=dl,ze=n(),S=o("ul"),S.innerHTML=Ml,Ce=n(),D=o("p"),D.innerHTML=wl,Ae=n(),P=o("p"),P.innerHTML=yl,Ge=n(),d(q.$$.fragment),Re=n(),d(K.$$.fragment),Ze=n(),d($.$$.fragment),Qe=n(),d(ee.$$.fragment),Ve=n(),le=o("p"),le.textContent=hl,xe=n(),d(te.$$.fragment),Ne=n(),d(ae.$$.fragment),Ye=n(),ne=o("p"),ne.textContent=ul,Ee=n(),ie=o("p"),ie.innerHTML=Ul,Fe=n(),d(re.$$.fragment),He=n(),se=o("p"),se.innerHTML=bl,Le=n(),oe=o("p"),oe.textContent=fl,Oe=n(),pe=o("p"),pe.innerHTML=Il,Se=n(),d(Te.$$.fragment),De=n(),me=o("p"),me.innerHTML=_l,Pe=n(),d(Je.$$.fragment),qe=n(),d(v.$$.fragment),Ke=n(),ce=o("p"),this.h()},l(e){const l=Cl("svelte-u9bgzb",document.head);s=p(l,"META",{name:!0,content:!0}),l.forEach(t),b=i(e),m=p(e,"P",{}),Wl(m).forEach(t),J=i(e),M(I.$$.fragment,e),f=i(e),c=p(e,"P",{"data-svelte-h":!0}),T(c)!=="svelte-1cdv2fm"&&(c.innerHTML=_),r=i(e),U=p(e,"P",{"data-svelte-h":!0}),T(U)!=="svelte-trqv6g"&&(U.textContent=nl),de=i(e),z=p(e,"P",{"data-svelte-h":!0}),T(z)!=="svelte-1rlk2kz"&&(z.innerHTML=il),Me=i(e),C=p(e,"OL",{"data-svelte-h":!0}),T(C)!=="svelte-pdytp0"&&(C.innerHTML=rl),we=i(e),A=p(e,"P",{"data-svelte-h":!0}),T(A)!=="svelte-ogaike"&&(A.innerHTML=sl),ye=i(e),M(k.$$.fragment,e),he=i(e),M(G.$$.fragment,e),ue=i(e),R=p(e,"P",{"data-svelte-h":!0}),T(R)!=="svelte-1vkhwjp"&&(R.innerHTML=ol),Ue=i(e),M(Z.$$.fragment,e),be=i(e),M(Q.$$.fragment,e),fe=i(e),M(g.$$.fragment,e),Ie=i(e),M(V.$$.fragment,e),_e=i(e),x=p(e,"P",{"data-svelte-h":!0}),T(x)!=="svelte-la2f2b"&&(x.innerHTML=pl),je=i(e),N=p(e,"OL",{"data-svelte-h":!0}),T(N)!=="svelte-6khx73"&&(N.innerHTML=Tl),Be=i(e),M(Y.$$.fragment,e),ke=i(e),W=p(e,"OL",{start:!0,"data-svelte-h":!0}),T(W)!=="svelte-1ufjyew"&&(W.innerHTML=ml),ge=i(e),M(E.$$.fragment,e),We=i(e),M(F.$$.fragment,e),$e=i(e),H=p(e,"P",{"data-svelte-h":!0}),T(H)!=="svelte-okly5l"&&(H.innerHTML=Jl),ve=i(e),L=p(e,"P",{"data-svelte-h":!0}),T(L)!=="svelte-c14p9h"&&(L.textContent=cl),Xe=i(e),O=p(e,"OL",{"data-svelte-h":!0}),T(O)!=="svelte-gly1sh"&&(O.innerHTML=dl),ze=i(e),S=p(e,"UL",{"data-svelte-h":!0}),T(S)!=="svelte-19rx9yl"&&(S.innerHTML=Ml),Ce=i(e),D=p(e,"P",{"data-svelte-h":!0}),T(D)!=="svelte-v8xmeb"&&(D.innerHTML=wl),Ae=i(e),P=p(e,"P",{"data-svelte-h":!0}),T(P)!=="svelte-v4mazi"&&(P.innerHTML=yl),Ge=i(e),M(q.$$.fragment,e),Re=i(e),M(K.$$.fragment,e),Ze=i(e),M($.$$.fragment,e),Qe=i(e),M(ee.$$.fragment,e),Ve=i(e),le=p(e,"P",{"data-svelte-h":!0}),T(le)!=="svelte-1gks0nu"&&(le.textContent=hl),xe=i(e),M(te.$$.fragment,e),Ne=i(e),M(ae.$$.fragment,e),Ye=i(e),ne=p(e,"P",{"data-svelte-h":!0}),T(ne)!=="svelte-bc8xo9"&&(ne.textContent=ul),Ee=i(e),ie=p(e,"P",{"data-svelte-h":!0}),T(ie)!=="svelte-24042q"&&(ie.innerHTML=Ul),Fe=i(e),M(re.$$.fragment,e),He=i(e),se=p(e,"P",{"data-svelte-h":!0}),T(se)!=="svelte-1xib7ue"&&(se.innerHTML=bl),Le=i(e),oe=p(e,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-11lpom8"&&(oe.textContent=fl),Oe=i(e),pe=p(e,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-u3s5ug"&&(pe.innerHTML=Il),Se=i(e),M(Te.$$.fragment,e),De=i(e),me=p(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-14t9mzj"&&(me.innerHTML=_l),Pe=i(e),M(Je.$$.fragment,e),qe=i(e),M(v.$$.fragment,e),Ke=i(e),ce=p(e,"P",{}),Wl(ce).forEach(t),this.h()},h(){al(s,"name","hf:doc:metadata"),al(s,"content",xl),al(W,"start","2")},m(e,l){Al(document.head,s),a(e,b,l),a(e,m,l),a(e,J,l),w(I,e,l),a(e,f,l),a(e,c,l),a(e,r,l),a(e,U,l),a(e,de,l),a(e,z,l),a(e,Me,l),a(e,C,l),a(e,we,l),a(e,A,l),a(e,ye,l),w(k,e,l),a(e,he,l),w(G,e,l),a(e,ue,l),a(e,R,l),a(e,Ue,l),w(Z,e,l),a(e,be,l),w(Q,e,l),a(e,fe,l),w(g,e,l),a(e,Ie,l),w(V,e,l),a(e,_e,l),a(e,x,l),a(e,je,l),a(e,N,l),a(e,Be,l),w(Y,e,l),a(e,ke,l),a(e,W,l),a(e,ge,l),w(E,e,l),a(e,We,l),w(F,e,l),a(e,$e,l),a(e,H,l),a(e,ve,l),a(e,L,l),a(e,Xe,l),a(e,O,l),a(e,ze,l),a(e,S,l),a(e,Ce,l),a(e,D,l),a(e,Ae,l),a(e,P,l),a(e,Ge,l),w(q,e,l),a(e,Re,l),w(K,e,l),a(e,Ze,l),w($,e,l),a(e,Qe,l),w(ee,e,l),a(e,Ve,l),a(e,le,l),a(e,xe,l),w(te,e,l),a(e,Ne,l),w(ae,e,l),a(e,Ye,l),a(e,ne,l),a(e,Ee,l),a(e,ie,l),a(e,Fe,l),w(re,e,l),a(e,He,l),a(e,se,l),a(e,Le,l),a(e,oe,l),a(e,Oe,l),a(e,pe,l),a(e,Se,l),w(Te,e,l),a(e,De,l),a(e,me,l),a(e,Pe,l),w(Je,e,l),a(e,qe,l),w(v,e,l),a(e,Ke,l),a(e,ce,l),el=!0},p(e,[l]){const jl={};l&2&&(jl.$$scope={dirty:l,ctx:e}),k.$set(jl);const Bl={};l&2&&(Bl.$$scope={dirty:l,ctx:e}),g.$set(Bl);const kl={};l&2&&(kl.$$scope={dirty:l,ctx:e}),$.$set(kl);const gl={};l&2&&(gl.$$scope={dirty:l,ctx:e}),v.$set(gl)},i(e){el||(y(I.$$.fragment,e),y(k.$$.fragment,e),y(G.$$.fragment,e),y(Z.$$.fragment,e),y(Q.$$.fragment,e),y(g.$$.fragment,e),y(V.$$.fragment,e),y(Y.$$.fragment,e),y(E.$$.fragment,e),y(F.$$.fragment,e),y(q.$$.fragment,e),y(K.$$.fragment,e),y($.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(ae.$$.fragment,e),y(re.$$.fragment,e),y(Te.$$.fragment,e),y(Je.$$.fragment,e),y(v.$$.fragment,e),el=!0)},o(e){h(I.$$.fragment,e),h(k.$$.fragment,e),h(G.$$.fragment,e),h(Z.$$.fragment,e),h(Q.$$.fragment,e),h(g.$$.fragment,e),h(V.$$.fragment,e),h(Y.$$.fragment,e),h(E.$$.fragment,e),h(F.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),h($.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(Te.$$.fragment,e),h(Je.$$.fragment,e),h(v.$$.fragment,e),el=!1},d(e){e&&(t(b),t(m),t(J),t(f),t(c),t(r),t(U),t(de),t(z),t(Me),t(C),t(we),t(A),t(ye),t(he),t(ue),t(R),t(Ue),t(be),t(fe),t(Ie),t(_e),t(x),t(je),t(N),t(Be),t(ke),t(W),t(ge),t(We),t($e),t(H),t(ve),t(L),t(Xe),t(O),t(ze),t(S),t(Ce),t(D),t(Ae),t(P),t(Ge),t(Re),t(Ze),t(Qe),t(Ve),t(le),t(xe),t(Ne),t(Ye),t(ne),t(Ee),t(ie),t(Fe),t(He),t(se),t(Le),t(oe),t(Oe),t(pe),t(Se),t(De),t(me),t(Pe),t(qe),t(Ke),t(ce)),t(s),u(I,e),u(k,e),u(G,e),u(Z,e),u(Q,e),u(g,e),u(V,e),u(Y,e),u(E,e),u(F,e),u(q,e),u(K,e),u($,e),u(ee,e),u(te,e),u(ae,e),u(re,e),u(Te,e),u(Je,e),u(v,e)}}}const xl='{"title":"Distributed Training with optimum-neuron","local":"distributed-training-with-optimum-neuron","sections":[{"title":"How to enable ZeRO-1?","local":"how-to-enable-zero-1","sections":[{"title":"Via the NeuronTrainer","local":"via-the-neurontrainer","sections":[],"depth":3},{"title":"Via the NeuronAccelerator","local":"via-the-neuronaccelerator","sections":[],"depth":3}],"depth":2},{"title":"How to enable Tensor Parallelism?","local":"how-to-enable-tensor-parallelism","sections":[{"title":"Via the NeuronTrainer","local":"via-the-neurontrainer","sections":[],"depth":3},{"title":"Via the NeuronAccelerator","local":"via-the-neuronaccelerator","sections":[],"depth":3},{"title":"Checkpoint consolidation","local":"checkpoint-consolidation","sections":[],"depth":3}],"depth":2}],"depth":1}';function Nl(j){return vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ol extends Xl{constructor(s){super(),zl(this,s,Nl,Vl,$l,{})}}export{Ol as component};
