import{s as fs,n as gs,o as _s}from"../chunks/scheduler.7da89386.js";import{S as Zs,i as Ns,g as i,s as t,r as u,A as Bs,h,f as l,c as p,j as As,u as M,x as y,k as bs,y as Qs,a as n,v as e,d as c,t as o,w as j}from"../chunks/index.20910acc.js";import{C as Js}from"../chunks/CodeBlock.143bd81e.js";import{H as T,E as Es}from"../chunks/index.3af8f81c.js";function Ws(ys){let J,R,$,v,U,Y,w,F,r,Ts=`Lighteval will automatically save results and evaluation details in the
directory set with the <code>--output-dir</code> option. The results will be saved in
<code>{output_dir}/results/{model_name}/results_{timestamp}.json</code>. <a href="#example-of-a-result-file">Here is an
example of a result file</a>. The output path can be
any <a href="https://filesystem-spec.readthedocs.io/en/latest/index.html" rel="nofollow">fsspec</a>
compliant path (local, s3, hf hub, gdrive, ftp, etc).`,V,d,Us=`To save the details of the evaluation, you can use the <code>--save-details</code>
option. The details will be saved in a parquet file
<code>{output_dir}/details/{model_name}/{timestamp}/details_{task}_{timestamp}.parquet</code>.`,x,I,H,m,ws=`You can push the results and evaluation details to the HuggingFace hub. To do
so, you need to set the <code>--push-to-hub</code> as well as the <code>--results-org</code>
option. The results will be saved in a dataset with the name at
<code>{results_org}/{model_org}/{model_name}</code>. To push the details, you need to set
the <code>--save-details</code> option.
The dataset created will be private by default, you can make it public by
setting the <code>--public-run</code> option.`,D,C,L,q,rs=`You can push the results to Tensorboard by setting <code>--push-to-tensorboard</code>.
This will create a Tensorboard dashboard in a HF org set with the <code>--results-org</code>
option.`,P,A,O,b,ds=`You can push the results to WandB by setting <code>--wandb</code>. This will init a WandB
run and log the results.`,K,f,Is="Wandb args need to be set in your env variables.",ss,g,as,_,ms='You can find a list of variable in the <a href="https://docs.wandb.ai/guides/track/environment-variables/" rel="nofollow">wandb documentation</a>.',ls,Z,ns,N,ts,B,ps,Q,us,E,Ms,W,Cs="The detail file contains the following columns:",es,k,qs="<li><code>choices</code>: The choices presented to the model in the case of mutlichoice tasks.</li> <li><code>gold</code>: The gold answer.</li> <li><code>gold_index</code>: The index of the gold answer in the choices list.</li> <li><code>cont_tokens</code>: The continuation tokens.</li> <li><code>example</code>: The input in text form.</li> <li><code>full_prompt</code>: The full prompt, that will be inputed to the model.</li> <li><code>input_tokens</code>: The tokens of the full prompt.</li> <li><code>instruction</code>: The instruction given to the model.</li> <li><code>metrics</code>: The metrics computed for the example.</li> <li><code>num_asked_few_shots</code>: The number of few shots asked to the model.</li> <li><code>num_effective_few_shots</code>: The number of effective few shots.</li> <li><code>padded</code>: Whether the input was padded.</li> <li><code>pred_logits</code>: The logits of the model.</li> <li><code>predictions</code>: The predictions of the model.</li> <li><code>specifics</code>: The specifics of the task.</li> <li><code>truncated</code>: Whether the input was truncated.</li>",cs,G,os,X,js,z,is,S,hs;return U=new T({props:{title:"Saving and reading results",local:"saving-and-reading-results",headingTag:"h1"}}),w=new T({props:{title:"Saving results locally",local:"saving-results-locally",headingTag:"h2"}}),I=new T({props:{title:"Pushing results to the HuggingFace hub",local:"pushing-results-to-the-huggingface-hub",headingTag:"h2"}}),C=new T({props:{title:"Pushing results to Tensorboard",local:"pushing-results-to-tensorboard",headingTag:"h2"}}),A=new T({props:{title:"Pushing results to WandB",local:"pushing-results-to-wandb",headingTag:"h2"}}),g=new Js({props:{code:"ZXhwb3J0JTIwV0FOREJfUFJPSkVDVCUzRCUyMmxpZ2h0ZXZhbCUyMg==",highlighted:'<span class="hljs-built_in">export</span> <span class="hljs-attribute">WANDB_PROJECT</span>=<span class="hljs-string">&quot;lighteval&quot;</span>',wrap:!1}}),Z=new T({props:{title:"How to load and investigate details",local:"how-to-load-and-investigate-details",headingTag:"h2"}}),N=new T({props:{title:"Load from local detail files",local:"load-from-local-detail-files",headingTag:"h3"}}),B=new Js({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwb3MlMEElMEFvdXRwdXRfZGlyJTIwJTNEJTIwJTIyZXZhbHNfZG9jJTIyJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiUwQXRpbWVzdGFtcCUyMCUzRCUyMCUyMmxhdGVzdCUyMiUwQXRhc2slMjAlM0QlMjAlMjJsaWdodGV2YWwlN0Nnc204ayU3QzAlMjIlMEElMEFpZiUyMHRpbWVzdGFtcCUyMCUzRCUzRCUyMCUyMmxhdGVzdCUyMiUzQSUwQSUyMCUyMCUyMCUyMHBhdGglMjAlM0QlMjBmJTIyJTdCb3V0cHV0X2RpciU3RCUyRmRldGFpbHMlMkYlN0Jtb2RlbF9vcmclN0QlMkYlN0Jtb2RlbF9uYW1lJTdEJTJGKiUyRiUyMiUwQSUyMCUyMCUyMCUyMHRpbWVzdGFtcHMlMjAlM0QlMjBnbG9iLmdsb2IocGF0aCklMEElMjAlMjAlMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjBzb3J0ZWQodGltZXN0YW1wcyklNUItMSU1RC5zcGxpdCglMjIlMkYlMjIpJTVCLTIlNUQlMEElMjAlMjAlMjAlMjBwcmludChmJTIyTGF0ZXN0JTIwdGltZXN0YW1wJTNBJTIwJTdCdGltZXN0YW1wJTdEJTIyKSUwQSUwQWRldGFpbHNfcGF0aCUyMCUzRCUyMGYlMjIlN0JvdXRwdXRfZGlyJTdEJTJGZGV0YWlscyUyRiU3Qm1vZGVsX25hbWUlN0QlMkYlN0J0aW1lc3RhbXAlN0QlMkZkZXRhaWxzXyU3QnRhc2slN0RfJTdCdGltZXN0YW1wJTdELnBhcnF1ZXQlMjIlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwZGV0YWlscyUwQWRldGFpbHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIycGFycXVldCUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkZXRhaWxzX3BhdGglMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQWZvciUyMGRldGFpbCUyMGluJTIwZGV0YWlscyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRldGFpbCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> os

output_dir = <span class="hljs-string">&quot;evals_doc&quot;</span>
model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
timestamp = <span class="hljs-string">&quot;latest&quot;</span>
task = <span class="hljs-string">&quot;lighteval|gsm8k|0&quot;</span>

<span class="hljs-keyword">if</span> timestamp == <span class="hljs-string">&quot;latest&quot;</span>:
    path = <span class="hljs-string">f&quot;<span class="hljs-subst">{output_dir}</span>/details/<span class="hljs-subst">{model_org}</span>/<span class="hljs-subst">{model_name}</span>/*/&quot;</span>
    timestamps = glob.glob(path)
    timestamp = <span class="hljs-built_in">sorted</span>(timestamps)[-<span class="hljs-number">1</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">2</span>]
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Latest timestamp: <span class="hljs-subst">{timestamp}</span>&quot;</span>)

details_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{output_dir}</span>/details/<span class="hljs-subst">{model_name}</span>/<span class="hljs-subst">{timestamp}</span>/details_<span class="hljs-subst">{task}</span>_<span class="hljs-subst">{timestamp}</span>.parquet&quot;</span>

<span class="hljs-comment"># Load the details</span>
details = load_dataset(<span class="hljs-string">&quot;parquet&quot;</span>, data_files=details_path, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-keyword">for</span> detail <span class="hljs-keyword">in</span> details:
    <span class="hljs-built_in">print</span>(detail)`,wrap:!1}}),Q=new T({props:{title:"Load from the HuggingFace hub",local:"load-from-the-huggingface-hub",headingTag:"h3"}}),E=new Js({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcmVzdWx0c19vcmclMjAlM0QlMjAlMjJTYXlsb3JUd2lmdCUyMiUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEFzYW5pdGl6ZWRfbW9kZWxfbmFtZSUyMCUzRCUyMG1vZGVsX25hbWUucmVwbGFjZSglMjIlMkYlMjIlMkMlMjAlMjJfXyUyMiklMEF0YXNrJTIwJTNEJTIwJTIybGlnaHRldmFsJTdDZ3NtOGslN0MwJTIyJTBBcHVibGljX3J1biUyMCUzRCUyMEZhbHNlJTBBJTBBZGF0YXNldF9wYXRoJTIwJTNEJTIwZiUyMiU3QnJlc3VsdHNfb3JnJTdEJTJGZGV0YWlsc18lN0JzYW5pdGl6ZWRfbW9kZWxfbmFtZSU3RCU3QidfcHJpdmF0ZSclMjBpZiUyMG5vdCUyMHB1YmxpY19ydW4lMjBlbHNlJTIwJyclN0QlMjIlMEFkZXRhaWxzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KGRhdGFzZXRfcGF0aCUyQyUyMHRhc2sucmVwbGFjZSglMjIlN0MlMjIlMkMlMjAlMjJfJTIyKSUyQyUyMHNwbGl0JTNEJTIybGF0ZXN0JTIyKSUwQSUwQWZvciUyMGRldGFpbCUyMGluJTIwZGV0YWlscyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRldGFpbCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

results_org = <span class="hljs-string">&quot;SaylorTwift&quot;</span>
model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
sanitized_model_name = model_name.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;__&quot;</span>)
task = <span class="hljs-string">&quot;lighteval|gsm8k|0&quot;</span>
public_run = <span class="hljs-literal">False</span>

dataset_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{results_org}</span>/details_<span class="hljs-subst">{sanitized_model_name}</span><span class="hljs-subst">{<span class="hljs-string">&#x27;_private&#x27;</span> <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> public_run <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;&#x27;</span>}</span>&quot;</span>
details = load_dataset(dataset_path, task.replace(<span class="hljs-string">&quot;|&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>), split=<span class="hljs-string">&quot;latest&quot;</span>)

<span class="hljs-keyword">for</span> detail <span class="hljs-keyword">in</span> details:
    <span class="hljs-built_in">print</span>(detail)`,wrap:!1}}),G=new T({props:{title:"Example of a result file",local:"example-of-a-result-file",headingTag:"h2"}}),X=new Js({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;config_general&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval_sha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;203045a8431bc9b77245c9998e05fc54509ea07f&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_fewshot_seeds&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;override_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;max_samples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;job_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;start_time&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">620979.879320166</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;end_time&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">621004.632108041</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;total_evaluation_time_secondes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;24.752787875011563&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gpt2&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_sha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;607a30d783dfa663caf39e06633721c8d4cfcd7e&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_dtype&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;476.2 MB&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;results&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;qem&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;qem_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;all&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;qem&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;qem_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;versions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;config_tasks&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;prompt_function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_repo&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_subset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;main&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;metric&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;metric_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;qem&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;higher_is_better&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;category&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;3&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;use_case&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;sample_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;compute&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;corpus_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mean&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;metric_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;maj@8&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;higher_is_better&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;category&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;use_case&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;sample_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;compute&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;corpus_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mean&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_avail_splits&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;train&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-string">&quot;test&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;evaluation_splits&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;test&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;few_shots_split&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;few_shots_select&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;random_sampling_from_train&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;generation_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">256</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;generation_grammar&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;stop_sequence&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;Question=&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;num_samples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;suite&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;lighteval&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;original_num_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1319</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;effective_num_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;trust_dataset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;must_remove_duplicate_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;summary_tasks&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;hashes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;hash_examples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;8517d5bf7e880086&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_full_prompts&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;8517d5bf7e880086&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_input_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;29916e7afe5cb51d&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_cont_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;37f91ce23ef6d435&quot;</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;truncated&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;non_truncated&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;non_padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;effective_few_shots&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;num_truncated_few_shots&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;summary_general&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;hashes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;hash_examples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5f383c395f01096e&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_full_prompts&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5f383c395f01096e&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_input_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;ac933feb14f96d7b&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_cont_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;9d03fb26f8da7277&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;truncated&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;non_truncated&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;non_padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_truncated_few_shots&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),z=new Es({props:{source:"https://github.com/huggingface/lighteval/blob/main/docs/source/saving-and-reading-results.mdx"}}),{c(){J=i("meta"),R=t(),$=i("p"),v=t(),u(U.$$.fragment),Y=t(),u(w.$$.fragment),F=t(),r=i("p"),r.innerHTML=Ts,V=t(),d=i("p"),d.innerHTML=Us,x=t(),u(I.$$.fragment),H=t(),m=i("p"),m.innerHTML=ws,D=t(),u(C.$$.fragment),L=t(),q=i("p"),q.innerHTML=rs,P=t(),u(A.$$.fragment),O=t(),b=i("p"),b.innerHTML=ds,K=t(),f=i("p"),f.textContent=Is,ss=t(),u(g.$$.fragment),as=t(),_=i("p"),_.innerHTML=ms,ls=t(),u(Z.$$.fragment),ns=t(),u(N.$$.fragment),ts=t(),u(B.$$.fragment),ps=t(),u(Q.$$.fragment),us=t(),u(E.$$.fragment),Ms=t(),W=i("p"),W.textContent=Cs,es=t(),k=i("ul"),k.innerHTML=qs,cs=t(),u(G.$$.fragment),os=t(),u(X.$$.fragment),js=t(),u(z.$$.fragment),is=t(),S=i("p"),this.h()},l(s){const a=Bs("svelte-u9bgzb",document.head);J=h(a,"META",{name:!0,content:!0}),a.forEach(l),R=p(s),$=h(s,"P",{}),As($).forEach(l),v=p(s),M(U.$$.fragment,s),Y=p(s),M(w.$$.fragment,s),F=p(s),r=h(s,"P",{"data-svelte-h":!0}),y(r)!=="svelte-15vw0ij"&&(r.innerHTML=Ts),V=p(s),d=h(s,"P",{"data-svelte-h":!0}),y(d)!=="svelte-8c212v"&&(d.innerHTML=Us),x=p(s),M(I.$$.fragment,s),H=p(s),m=h(s,"P",{"data-svelte-h":!0}),y(m)!=="svelte-sznccd"&&(m.innerHTML=ws),D=p(s),M(C.$$.fragment,s),L=p(s),q=h(s,"P",{"data-svelte-h":!0}),y(q)!=="svelte-1cbg3hm"&&(q.innerHTML=rs),P=p(s),M(A.$$.fragment,s),O=p(s),b=h(s,"P",{"data-svelte-h":!0}),y(b)!=="svelte-q3l9c9"&&(b.innerHTML=ds),K=p(s),f=h(s,"P",{"data-svelte-h":!0}),y(f)!=="svelte-lvtunn"&&(f.textContent=Is),ss=p(s),M(g.$$.fragment,s),as=p(s),_=h(s,"P",{"data-svelte-h":!0}),y(_)!=="svelte-somvse"&&(_.innerHTML=ms),ls=p(s),M(Z.$$.fragment,s),ns=p(s),M(N.$$.fragment,s),ts=p(s),M(B.$$.fragment,s),ps=p(s),M(Q.$$.fragment,s),us=p(s),M(E.$$.fragment,s),Ms=p(s),W=h(s,"P",{"data-svelte-h":!0}),y(W)!=="svelte-1w33ibm"&&(W.textContent=Cs),es=p(s),k=h(s,"UL",{"data-svelte-h":!0}),y(k)!=="svelte-6ruscb"&&(k.innerHTML=qs),cs=p(s),M(G.$$.fragment,s),os=p(s),M(X.$$.fragment,s),js=p(s),M(z.$$.fragment,s),is=p(s),S=h(s,"P",{}),As(S).forEach(l),this.h()},h(){bs(J,"name","hf:doc:metadata"),bs(J,"content",ks)},m(s,a){Qs(document.head,J),n(s,R,a),n(s,$,a),n(s,v,a),e(U,s,a),n(s,Y,a),e(w,s,a),n(s,F,a),n(s,r,a),n(s,V,a),n(s,d,a),n(s,x,a),e(I,s,a),n(s,H,a),n(s,m,a),n(s,D,a),e(C,s,a),n(s,L,a),n(s,q,a),n(s,P,a),e(A,s,a),n(s,O,a),n(s,b,a),n(s,K,a),n(s,f,a),n(s,ss,a),e(g,s,a),n(s,as,a),n(s,_,a),n(s,ls,a),e(Z,s,a),n(s,ns,a),e(N,s,a),n(s,ts,a),e(B,s,a),n(s,ps,a),e(Q,s,a),n(s,us,a),e(E,s,a),n(s,Ms,a),n(s,W,a),n(s,es,a),n(s,k,a),n(s,cs,a),e(G,s,a),n(s,os,a),e(X,s,a),n(s,js,a),e(z,s,a),n(s,is,a),n(s,S,a),hs=!0},p:gs,i(s){hs||(c(U.$$.fragment,s),c(w.$$.fragment,s),c(I.$$.fragment,s),c(C.$$.fragment,s),c(A.$$.fragment,s),c(g.$$.fragment,s),c(Z.$$.fragment,s),c(N.$$.fragment,s),c(B.$$.fragment,s),c(Q.$$.fragment,s),c(E.$$.fragment,s),c(G.$$.fragment,s),c(X.$$.fragment,s),c(z.$$.fragment,s),hs=!0)},o(s){o(U.$$.fragment,s),o(w.$$.fragment,s),o(I.$$.fragment,s),o(C.$$.fragment,s),o(A.$$.fragment,s),o(g.$$.fragment,s),o(Z.$$.fragment,s),o(N.$$.fragment,s),o(B.$$.fragment,s),o(Q.$$.fragment,s),o(E.$$.fragment,s),o(G.$$.fragment,s),o(X.$$.fragment,s),o(z.$$.fragment,s),hs=!1},d(s){s&&(l(R),l($),l(v),l(Y),l(F),l(r),l(V),l(d),l(x),l(H),l(m),l(D),l(L),l(q),l(P),l(O),l(b),l(K),l(f),l(ss),l(as),l(_),l(ls),l(ns),l(ts),l(ps),l(us),l(Ms),l(W),l(es),l(k),l(cs),l(os),l(js),l(is),l(S)),l(J),j(U,s),j(w,s),j(I,s),j(C,s),j(A,s),j(g,s),j(Z,s),j(N,s),j(B,s),j(Q,s),j(E,s),j(G,s),j(X,s),j(z,s)}}}const ks='{"title":"Saving and reading results","local":"saving-and-reading-results","sections":[{"title":"Saving results locally","local":"saving-results-locally","sections":[],"depth":2},{"title":"Pushing results to the HuggingFace hub","local":"pushing-results-to-the-huggingface-hub","sections":[],"depth":2},{"title":"Pushing results to Tensorboard","local":"pushing-results-to-tensorboard","sections":[],"depth":2},{"title":"Pushing results to WandB","local":"pushing-results-to-wandb","sections":[],"depth":2},{"title":"How to load and investigate details","local":"how-to-load-and-investigate-details","sections":[{"title":"Load from local detail files","local":"load-from-local-detail-files","sections":[],"depth":3},{"title":"Load from the HuggingFace hub","local":"load-from-the-huggingface-hub","sections":[],"depth":3}],"depth":2},{"title":"Example of a result file","local":"example-of-a-result-file","sections":[],"depth":2}],"depth":1}';function Gs(ys){return _s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rs extends Zs{constructor(J){super(),Ns(this,J,Gs,Ws,fs,{})}}export{Rs as component};
