import{s as Ns,n as Hs,o as Ws}from"../chunks/scheduler.0219f8bd.js";import{S as vs,i as Rs,g as y,s as n,r as p,A as Ys,h as w,f as t,c as e,j as Es,u as M,x as T,k as Gs,y as _s,a,v as o,d as i,t as j,w as c}from"../chunks/index.f61edf3b.js";import{C as L}from"../chunks/CodeBlock.38e566ae.js";import{H as h,E as Ss}from"../chunks/EditOnGithub.48fa589f.js";function qs(Is){let J,F,V,x,r,z,u,fs="A way to call Hugging Face models and Inference Endpoints from natural language, using an LLM.",D,m,K,U,P,g,O,d,ss,I,ls,f,Cs='Agents.js leverages LLMs hosted as Inference Endpoints on HF, so you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',ts,C,as,B,ns,A,Bs="You can also use your own LLM, by calling one of the <code>LLMFrom*</code> functions.",es,$,ps,b,As="You can specify any valid model on the hub as long as they have an API.",Ms,Z,os,k,is,Q,$s='You can also specify your own endpoint, as long as it implements the same API, for exemple using <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">text generation inference</a> and <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoints</a>.',js,E,cs,G,ys,N,bs="A LLM in this context is defined as any async function that takes a string input and returns a string. For example if you wanted to use the OpenAI API you could do so like this:",ws,H,hs,W,Js,v,Zs="By default, agents ship with 4 tools. (textToImage, textToSpeech, imageToText, speechToText)",Ts,R,ks="But you can expand the list of tools easily by creating new tools and passing them at initialization.",rs,Y,us,_,ms,S,Qs="<li><code>@huggingface/inference</code> : Required to call the inference endpoints themselves.</li>",Us,q,gs,X,ds;return r=new h({props:{title:"🤗 Hugging Face Agents.js",local:"-hugging-face-agentsjs",headingTag:"h1"}}),m=new h({props:{title:"Install",local:"install",headingTag:"h2"}}),U=new L({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZhZ2VudHMlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZhZ2VudHM=",highlighted:`pnpm add @huggingface/agents

npm add @huggingface/agents

yarn add @huggingface/agents`,wrap:!1}}),g=new h({props:{title:"Deno",local:"deno",headingTag:"h3"}}),d=new L({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyMCU3RCUyMGZyb20lMjAlMjJodHRwcyUzQSUyRiUyRmVzbS5zaCUyRiU0MGh1Z2dpbmdmYWNlJTJGYWdlbnQlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMEhmQWdlbnQlMjAlN0QlMjBmcm9tJTIwJTIybnBtJTNBJTQwaHVnZ2luZ2ZhY2UlMkZhZ2VudCUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/agent&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/agent&quot;</span>`,wrap:!1}}),I=new h({props:{title:"Usage",local:"usage",headingTag:"h2"}}),C=new L({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWNvbnN0JTIwYWdlbnQlMjAlM0QlMjBuZXclMjBIZkFnZW50KCUyMmhmXy4uLiUyMiklM0IlMEElMEFjb25zdCUyMGNvZGUlMjAlM0QlMjBhd2FpdCUyMGFnZW50LmdlbmVyYXRlQ29kZSglMjJEcmF3JTIwYSUyMHBpY3R1cmUlMjBvZiUyMGElMjBjYXQlMkMlMjB3ZWFyaW5nJTIwYSUyMHRvcCUyMGhhdC4lMjIpJTBBY29uc29sZS5sb2coY29kZSklMjAlMkYlMkYlMjBhbHdheXMlMjBnb29kJTIwdG8lMjBjaGVjayUyMHRoZSUyMGdlbmVyYXRlZCUyMGNvZGUlMjBiZWZvcmUlMjBydW5uaW5nJTIwaXQlMEFjb25zdCUyMG91dHB1dHMlMjAlM0QlMjBhd2FpdCUyMGFnZW50LmV2YWx1YXRlQ29kZShjb2RlKSUzQiUwQWNvbnNvbGUubG9nKG91dHB1dHMpJTIw",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(<span class="hljs-string">&quot;hf_...&quot;</span>);

<span class="hljs-keyword">const</span> code = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">generateCode</span>(<span class="hljs-string">&quot;Draw a picture of a cat, wearing a top hat.&quot;</span>)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(code) <span class="hljs-comment">// always good to check the generated code before running it</span>
<span class="hljs-keyword">const</span> outputs = <span class="hljs-keyword">await</span> agent.evaluateCode(code);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(outputs) `,wrap:!1}}),B=new h({props:{title:"Choose your LLM",local:"choose-your-llm",headingTag:"h3"}}),$=new h({props:{title:"From the hub",local:"from-the-hub",headingTag:"h4"}}),Z=new L({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyQyUyMExMTUZyb21IdWIlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZhZ2VudHMlMjIlM0IlMEElMEFjb25zdCUyMGFnZW50JTIwJTNEJTIwbmV3JTIwSGZBZ2VudCglMEElMjAlMjAlMjJoZl8uLi4lMjIlMkMlMEElMjAlMjBMTE1Gcm9tSHViKCUyMmhmXy4uLiUyMiUyQyUyMCUyMk9wZW5Bc3Npc3RhbnQlMkZvYXNzdC1zZnQtNC1weXRoaWEtMTJiLWVwb2NoLTMuNSUyMiklMEEpJTNC",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span>, <span class="hljs-title class_">LLMFromHub</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(
  <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-title class_">LLMFromHub</span>(<span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-string">&quot;OpenAssistant/oasst-sft-4-pythia-12b-epoch-3.5&quot;</span>)
);`,wrap:!1}}),k=new h({props:{title:"From your own endpoints",local:"from-your-own-endpoints",headingTag:"h4"}}),E=new L({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyQyUyMExMTUZyb21FbmRwb2ludCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWNvbnN0JTIwYWdlbnQlMjAlM0QlMjBuZXclMjBIZkFnZW50KCUwQSUyMCUyMCUyMmhmXy4uLiUyMiUyQyUwQSUyMCUyMExMTUZyb21FbmRwb2ludCglMjJoZl8uLi4lMjIlMkMlMjAlMjJodHRwJTNBJTJGJTJGLi4uJTIyKSUwQSklM0I=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span>, <span class="hljs-title class_">LLMFromEndpoint</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(
  <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-title class_">LLMFromEndpoint</span>(<span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-string">&quot;http://...&quot;</span>)
);`,wrap:!1}}),G=new h({props:{title:"Custom LLM",local:"custom-llm",headingTag:"h4"}}),H=new L({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQWltcG9ydCUyMCU3QiUyMENvbmZpZ3VyYXRpb24lMkMlMjBPcGVuQUlBcGklMjAlN0QlMjBmcm9tJTIwJTIyb3BlbmFpJTIyJTNCJTBBJTBBY29uc3QlMjBhcGklMjAlM0QlMjBuZXclMjBPcGVuQUlBcGkobmV3JTIwQ29uZmlndXJhdGlvbiglN0IlMjBhcGlLZXklM0ElMjAlMjJzay0uLi4lMjIlMjAlN0QpKSUzQiUwQSUwQWNvbnN0JTIwbGxtT3BlbkFJJTIwJTNEJTIwYXN5bmMlMjAocHJvbXB0JTNBJTIwc3RyaW5nKSUzQSUyMFByb21pc2UlM0NzdHJpbmclM0UlMjAlM0QlM0UlMjAlN0IlMEElMjAlMjByZXR1cm4lMjAoJTBBJTIwJTIwJTIwJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF3YWl0JTIwYXBpLmNyZWF0ZUNvbXBsZXRpb24oJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlM0ElMjAlMjJ0ZXh0LWRhdmluY2ktMDAzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNBJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzQSUyMDEwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QpJTBBJTIwJTIwJTIwJTIwKS5kYXRhLmNob2ljZXMlNUIwJTVELnRleHQlMjAlM0YlM0YlMjAlMjIlMjIlMEElMjAlMjApJTNCJTBBJTdEJTNCJTBBJTBBY29uc3QlMjBhZ2VudCUyMCUzRCUyMG5ldyUyMEhmQWdlbnQoJTBBJTIwJTIwJTIyaGZfLi4uJTIyJTJDJTBBJTIwJTIwbGxtT3BlbkFJJTBBKSUzQiUwQSUwQSUyRiUyRiUyMGRvJTIwYW55dGhpbmclMjB5b3UlMjB3YW50JTIwd2l0aCUyMHRoZSUyMGFnZW50JTIwaGVyZSUwQQ==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">Configuration</span>, <span class="hljs-title class_">OpenAIApi</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;openai&quot;</span>;

<span class="hljs-keyword">const</span> api = <span class="hljs-keyword">new</span> <span class="hljs-title class_">OpenAIApi</span>(<span class="hljs-keyword">new</span> <span class="hljs-title class_">Configuration</span>({ <span class="hljs-attr">apiKey</span>: <span class="hljs-string">&quot;sk-...&quot;</span> }));

<span class="hljs-keyword">const</span> llmOpenAI = <span class="hljs-keyword">async</span> (<span class="hljs-attr">prompt</span>: <span class="hljs-built_in">string</span>): <span class="hljs-title class_">Promise</span>&lt;<span class="hljs-built_in">string</span>&gt; =&gt; {
  <span class="hljs-keyword">return</span> (
    (
      <span class="hljs-keyword">await</span> api.<span class="hljs-title function_">createCompletion</span>({
        <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;text-davinci-003&quot;</span>,
        <span class="hljs-attr">prompt</span>: prompt,
        <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">1000</span>,
      })
    ).<span class="hljs-property">data</span>.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">text</span> ?? <span class="hljs-string">&quot;&quot;</span>
  );
};

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(
  <span class="hljs-string">&quot;hf_...&quot;</span>,
  llmOpenAI
);

<span class="hljs-comment">// do anything you want with the agent here</span>
`,wrap:!1}}),W=new h({props:{title:"Tools",local:"tools",headingTag:"h3"}}),Y=new L({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span>, defaultTools, <span class="hljs-title class_">LLMFromHub</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">Tool</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents/src/types&quot;</span>;

<span class="hljs-comment">// define the tool</span>
<span class="hljs-keyword">const</span> <span class="hljs-attr">uppercaseTool</span>: <span class="hljs-title class_">Tool</span> = {
    <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;uppercase&quot;</span>,
    <span class="hljs-attr">description</span>: <span class="hljs-string">&quot;uppercase the input string and returns it &quot;</span>,
    <span class="hljs-attr">examples</span>: [
        {
            <span class="hljs-attr">prompt</span>: <span class="hljs-string">&quot;uppercase the string: hello world&quot;</span>,
            <span class="hljs-attr">code</span>: <span class="hljs-string">\`const output = uppercase(&quot;hello world&quot;)\`</span>,
            <span class="hljs-attr">tools</span>: [<span class="hljs-string">&quot;uppercase&quot;</span>],
        },
    ],
    <span class="hljs-attr">call</span>: <span class="hljs-keyword">async</span> (input) =&gt; {
        <span class="hljs-keyword">const</span> data = <span class="hljs-keyword">await</span> input;
        <span class="hljs-keyword">if</span> (<span class="hljs-keyword">typeof</span> data !== <span class="hljs-string">&quot;string&quot;</span>) {
            <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Input must be a string&quot;</span>);
        }
        <span class="hljs-keyword">return</span> data.<span class="hljs-title function_">toUpperCase</span>();
    },
};

<span class="hljs-comment">// pass it in the agent</span>
<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(process.<span class="hljs-property">env</span>.<span class="hljs-property">HF_TOKEN</span>,
                <span class="hljs-title class_">LLMFromHub</span>(<span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-string">&quot;OpenAssistant/oasst-sft-4-pythia-12b-epoch-3.5&quot;</span>),
                [uppercaseTool, ...defaultTools]);`,wrap:!1}}),_=new h({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),q=new Ss({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/agents/README.md"}}),{c(){J=y("meta"),F=n(),V=y("p"),x=n(),p(r.$$.fragment),z=n(),u=y("p"),u.textContent=fs,D=n(),p(m.$$.fragment),K=n(),p(U.$$.fragment),P=n(),p(g.$$.fragment),O=n(),p(d.$$.fragment),ss=n(),p(I.$$.fragment),ls=n(),f=y("p"),f.innerHTML=Cs,ts=n(),p(C.$$.fragment),as=n(),p(B.$$.fragment),ns=n(),A=y("p"),A.innerHTML=Bs,es=n(),p($.$$.fragment),ps=n(),b=y("p"),b.textContent=As,Ms=n(),p(Z.$$.fragment),os=n(),p(k.$$.fragment),is=n(),Q=y("p"),Q.innerHTML=$s,js=n(),p(E.$$.fragment),cs=n(),p(G.$$.fragment),ys=n(),N=y("p"),N.textContent=bs,ws=n(),p(H.$$.fragment),hs=n(),p(W.$$.fragment),Js=n(),v=y("p"),v.textContent=Zs,Ts=n(),R=y("p"),R.textContent=ks,rs=n(),p(Y.$$.fragment),us=n(),p(_.$$.fragment),ms=n(),S=y("ul"),S.innerHTML=Qs,Us=n(),p(q.$$.fragment),gs=n(),X=y("p"),this.h()},l(s){const l=Ys("svelte-u9bgzb",document.head);J=w(l,"META",{name:!0,content:!0}),l.forEach(t),F=e(s),V=w(s,"P",{}),Es(V).forEach(t),x=e(s),M(r.$$.fragment,s),z=e(s),u=w(s,"P",{"data-svelte-h":!0}),T(u)!=="svelte-ayvowu"&&(u.textContent=fs),D=e(s),M(m.$$.fragment,s),K=e(s),M(U.$$.fragment,s),P=e(s),M(g.$$.fragment,s),O=e(s),M(d.$$.fragment,s),ss=e(s),M(I.$$.fragment,s),ls=e(s),f=w(s,"P",{"data-svelte-h":!0}),T(f)!=="svelte-zsfsq5"&&(f.innerHTML=Cs),ts=e(s),M(C.$$.fragment,s),as=e(s),M(B.$$.fragment,s),ns=e(s),A=w(s,"P",{"data-svelte-h":!0}),T(A)!=="svelte-1qeoss3"&&(A.innerHTML=Bs),es=e(s),M($.$$.fragment,s),ps=e(s),b=w(s,"P",{"data-svelte-h":!0}),T(b)!=="svelte-53uh5h"&&(b.textContent=As),Ms=e(s),M(Z.$$.fragment,s),os=e(s),M(k.$$.fragment,s),is=e(s),Q=w(s,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-1hj19ct"&&(Q.innerHTML=$s),js=e(s),M(E.$$.fragment,s),cs=e(s),M(G.$$.fragment,s),ys=e(s),N=w(s,"P",{"data-svelte-h":!0}),T(N)!=="svelte-ixq9gr"&&(N.textContent=bs),ws=e(s),M(H.$$.fragment,s),hs=e(s),M(W.$$.fragment,s),Js=e(s),v=w(s,"P",{"data-svelte-h":!0}),T(v)!=="svelte-1v88ysk"&&(v.textContent=Zs),Ts=e(s),R=w(s,"P",{"data-svelte-h":!0}),T(R)!=="svelte-1sb6vmy"&&(R.textContent=ks),rs=e(s),M(Y.$$.fragment,s),us=e(s),M(_.$$.fragment,s),ms=e(s),S=w(s,"UL",{"data-svelte-h":!0}),T(S)!=="svelte-14gp5c0"&&(S.innerHTML=Qs),Us=e(s),M(q.$$.fragment,s),gs=e(s),X=w(s,"P",{}),Es(X).forEach(t),this.h()},h(){Gs(J,"name","hf:doc:metadata"),Gs(J,"content",Ls)},m(s,l){_s(document.head,J),a(s,F,l),a(s,V,l),a(s,x,l),o(r,s,l),a(s,z,l),a(s,u,l),a(s,D,l),o(m,s,l),a(s,K,l),o(U,s,l),a(s,P,l),o(g,s,l),a(s,O,l),o(d,s,l),a(s,ss,l),o(I,s,l),a(s,ls,l),a(s,f,l),a(s,ts,l),o(C,s,l),a(s,as,l),o(B,s,l),a(s,ns,l),a(s,A,l),a(s,es,l),o($,s,l),a(s,ps,l),a(s,b,l),a(s,Ms,l),o(Z,s,l),a(s,os,l),o(k,s,l),a(s,is,l),a(s,Q,l),a(s,js,l),o(E,s,l),a(s,cs,l),o(G,s,l),a(s,ys,l),a(s,N,l),a(s,ws,l),o(H,s,l),a(s,hs,l),o(W,s,l),a(s,Js,l),a(s,v,l),a(s,Ts,l),a(s,R,l),a(s,rs,l),o(Y,s,l),a(s,us,l),o(_,s,l),a(s,ms,l),a(s,S,l),a(s,Us,l),o(q,s,l),a(s,gs,l),a(s,X,l),ds=!0},p:Hs,i(s){ds||(i(r.$$.fragment,s),i(m.$$.fragment,s),i(U.$$.fragment,s),i(g.$$.fragment,s),i(d.$$.fragment,s),i(I.$$.fragment,s),i(C.$$.fragment,s),i(B.$$.fragment,s),i($.$$.fragment,s),i(Z.$$.fragment,s),i(k.$$.fragment,s),i(E.$$.fragment,s),i(G.$$.fragment,s),i(H.$$.fragment,s),i(W.$$.fragment,s),i(Y.$$.fragment,s),i(_.$$.fragment,s),i(q.$$.fragment,s),ds=!0)},o(s){j(r.$$.fragment,s),j(m.$$.fragment,s),j(U.$$.fragment,s),j(g.$$.fragment,s),j(d.$$.fragment,s),j(I.$$.fragment,s),j(C.$$.fragment,s),j(B.$$.fragment,s),j($.$$.fragment,s),j(Z.$$.fragment,s),j(k.$$.fragment,s),j(E.$$.fragment,s),j(G.$$.fragment,s),j(H.$$.fragment,s),j(W.$$.fragment,s),j(Y.$$.fragment,s),j(_.$$.fragment,s),j(q.$$.fragment,s),ds=!1},d(s){s&&(t(F),t(V),t(x),t(z),t(u),t(D),t(K),t(P),t(O),t(ss),t(ls),t(f),t(ts),t(as),t(ns),t(A),t(es),t(ps),t(b),t(Ms),t(os),t(is),t(Q),t(js),t(cs),t(ys),t(N),t(ws),t(hs),t(Js),t(v),t(Ts),t(R),t(rs),t(us),t(ms),t(S),t(Us),t(gs),t(X)),t(J),c(r,s),c(m,s),c(U,s),c(g,s),c(d,s),c(I,s),c(C,s),c(B,s),c($,s),c(Z,s),c(k,s),c(E,s),c(G,s),c(H,s),c(W,s),c(Y,s),c(_,s),c(q,s)}}}const Ls='{"title":"🤗 Hugging Face Agents.js","local":"-hugging-face-agentsjs","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[{"title":"Choose your LLM","local":"choose-your-llm","sections":[{"title":"From the hub","local":"from-the-hub","sections":[],"depth":4},{"title":"From your own endpoints","local":"from-your-own-endpoints","sections":[],"depth":4},{"title":"Custom LLM","local":"custom-llm","sections":[],"depth":4}],"depth":3},{"title":"Tools","local":"tools","sections":[],"depth":3}],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function Vs(Is){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ds extends vs{constructor(J){super(),Rs(this,J,Vs,qs,Ns,{})}}export{Ds as component};
