import{S as Ho,i as Do,s as xo,e as t,k as M,w as y,t as o,M as qo,c as n,d as a,m as h,x as j,a as i,h as p,b as c,N as vn,G as l,g as r,y as u,q as w,o as d,B as J,v as Po}from"../../chunks/vendor-hf-doc-builder.js";import{T as _n}from"../../chunks/Tip-hf-doc-builder.js";import{I as pa}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{C as U}from"../../chunks/CodeBlock-hf-doc-builder.js";import{D as Ko}from"../../chunks/DocNotebookDropdown-hf-doc-builder.js";function Lo(x){let m,C,f,g,I;return{c(){m=t("p"),C=o("\u{1F4A1} This training tutorial is based on the "),f=t("a"),g=o("Training with \u{1F9E8} Diffusers"),I=o(" notebook. For additional details and context about diffusion models like how they work, check out the notebook!"),this.h()},l(T){m=n(T,"P",{});var b=i(m);C=p(b,"\u{1F4A1} This training tutorial is based on the "),f=n(b,"A",{href:!0,rel:!0});var A=i(f);g=p(A,"Training with \u{1F9E8} Diffusers"),A.forEach(a),I=p(b," notebook. For additional details and context about diffusion models like how they work, check out the notebook!"),b.forEach(a),this.h()},h(){c(f,"href","https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/training_example.ipynb"),c(f,"rel","nofollow")},m(T,b){r(T,m,b),l(m,C),l(m,f),l(f,g),l(m,I)},d(T){T&&a(m)}}}function Oo(x){let m,C,f,g,I,T,b,A,ws,k,ds,q,G,Js,E;return{c(){m=t("p"),C=o("\u{1F4A1} You can find additional datasets from the "),f=t("a"),g=o("HugGan Community Event"),I=o(" or you can use your own dataset by creating a local "),T=t("a"),b=t("code"),A=o("ImageFolder"),ws=o(". Set "),k=t("code"),ds=o("config.dataset_name"),q=o(" to the repository id of the dataset if it is from the HugGan Community Event, or "),G=t("code"),Js=o("imagefolder"),E=o(" if you\u2019re using your own images."),this.h()},l(R){m=n(R,"P",{});var B=i(m);C=p(B,"\u{1F4A1} You can find additional datasets from the "),f=n(B,"A",{href:!0,rel:!0});var fs=i(f);g=p(fs,"HugGan Community Event"),fs.forEach(a),I=p(B," or you can use your own dataset by creating a local "),T=n(B,"A",{href:!0,rel:!0});var Z=i(T);b=n(Z,"CODE",{});var ia=i(b);A=p(ia,"ImageFolder"),ia.forEach(a),Z.forEach(a),ws=p(B,". Set "),k=n(B,"CODE",{});var z=i(k);ds=p(z,"config.dataset_name"),z.forEach(a),q=p(B," to the repository id of the dataset if it is from the HugGan Community Event, or "),G=n(B,"CODE",{});var ra=i(G);Js=p(ra,"imagefolder"),ra.forEach(a),E=p(B," if you\u2019re using your own images."),B.forEach(a),this.h()},h(){c(f,"href","https://huggingface.co/huggan"),c(f,"rel","nofollow"),c(T,"href","https://huggingface.co/docs/datasets/image_dataset#imagefolder"),c(T,"rel","nofollow")},m(R,B){r(R,m,B),l(m,C),l(m,f),l(f,g),l(m,I),l(m,T),l(T,b),l(b,A),l(m,ws),l(m,k),l(k,ds),l(m,q),l(m,G),l(G,Js),l(m,E)},d(R){R&&a(m)}}}function sp(x){let m,C;return{c(){m=t("p"),C=o("\u{1F4A1} The training loop below may look intimidating and long, but it\u2019ll be worth it later when you launch your training in just one line of code! If you can\u2019t wait and want to start generating images, feel free to copy and run the code below. You can always come back and examine the training loop more closely later, like when you\u2019re waiting for your model to finish training. \u{1F917}")},l(f){m=n(f,"P",{});var g=i(m);C=p(g,"\u{1F4A1} The training loop below may look intimidating and long, but it\u2019ll be worth it later when you launch your training in just one line of code! If you can\u2019t wait and want to start generating images, feel free to copy and run the code below. You can always come back and examine the training loop more closely later, like when you\u2019re waiting for your model to finish training. \u{1F917}"),g.forEach(a)},m(f,g){r(f,m,g),l(m,C)},d(f){f&&a(m)}}}function ap(x){let m,C,f,g,I,T,b,A,ws,k,ds,q,G,Js,E,R,B,fs,Z,ia,z,ra,ke,Ts,Ee,We,yl,P,jl,W,Xe,Us,Ve,Ne,bs,Ye,Re,ul,gs,wl,K,ze,Is,$e,Se,dl,Cs,Jl,ca,Qe,fl,Bs,Tl,L,Fe,As,He,De,Ul,Gs,bl,$,O,Ya,Zs,xe,Ra,qe,gl,ss,Pe,za,Ke,Le,Il,vs,Cl,S,as,$a,_s,Oe,Sa,st,Bl,ls,at,ks,lt,et,Al,Es,Gl,es,Zl,X,tt,Ws,nt,ot,Xs,Qa,pt,it,vl,Vs,_l,Ns,Fa,kn,kl,Ma,rt,El,V,ts,Ha,ct,Mt,Da,ht,mt,yt,ha,xa,jt,ut,wt,ma,qa,dt,Jt,Wl,Ys,Xl,N,ft,Rs,Tt,Ut,Pa,bt,gt,Vl,zs,Nl,ns,It,$s,Ct,Bt,Yl,Ss,Rl,Q,os,Ka,Qs,At,La,Gt,zl,ps,Zt,ya,vt,_t,$l,Fs,Sl,ja,kt,Ql,Hs,Fl,ua,Et,Hl,F,is,Oa,Ds,Wt,sl,Xt,Dl,Y,Vt,al,Nt,Yt,ll,Rt,zt,xl,v,$t,wa,St,Qt,el,Ft,Ht,tl,Dt,xt,ql,xs,Pl,qs,nl,En,Kl,da,qt,Ll,Ps,Ol,H,rs,ol,Ks,Pt,pl,Kt,se,Ja,Lt,ae,fa,Ot,le,Ls,ee,cs,sn,Ta,an,ln,te,Os,ne,Ua,en,oe,Ms,pe,sa,ie,hs,tn,aa,nn,on,re,la,ce,ba,pn,Me,ea,he,ta,il,Wn,me,D,ms,rl,na,rn,cl,cn,ye,ys,Mn,ga,hn,mn,je,_,Ia,Ca,yn,jn,un,Ba,Aa,wn,dn,Jn,Ga,Za,fn,Tn,Un,va,_a,bn,gn,ue;return f=new Ko({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/basic_training.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/basic_training.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/basic_training.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/basic_training.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/basic_training.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/basic_training.ipynb"}]}}),A=new pa({}),P=new _n({props:{$$slots:{default:[Lo]},$$scope:{ctx:x}}}),gs=new U({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwZGlmZnVzZXJzJTVCdHJhaW5pbmclNUQ=",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install diffusers[training]</span>`}}),Cs=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`}}),Bs=new U({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login"}}),Gs=new U({props:{code:"IXN1ZG8lMjBhcHQlMjAtcXElMjBpbnN0YWxsJTIwZ2l0LWxmcyUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`!sudo apt -qq install git-lfs
!git config --global credential.helper store`}}),Zs=new pa({}),vs=new U({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBJTBBJTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBUcmFpbmluZ0NvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGltYWdlX3NpemUlMjAlM0QlMjAxMjglMjAlMjAlMjMlMjB0aGUlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyMHJlc29sdXRpb24lMEElMjAlMjAlMjAlMjB0cmFpbl9iYXRjaF9zaXplJTIwJTNEJTIwMTYlMEElMjAlMjAlMjAlMjBldmFsX2JhdGNoX3NpemUlMjAlM0QlMjAxNiUyMCUyMCUyMyUyMGhvdyUyMG1hbnklMjBpbWFnZXMlMjB0byUyMHNhbXBsZSUyMGR1cmluZyUyMGV2YWx1YXRpb24lMEElMjAlMjAlMjAlMjBudW1fZXBvY2hzJTIwJTNEJTIwNTAlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlMjAxJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUyMCUzRCUyMDFlLTQlMEElMjAlMjAlMjAlMjBscl93YXJtdXBfc3RlcHMlMjAlM0QlMjA1MDAlMEElMjAlMjAlMjAlMjBzYXZlX2ltYWdlX2Vwb2NocyUyMCUzRCUyMDEwJTBBJTIwJTIwJTIwJTIwc2F2ZV9tb2RlbF9lcG9jaHMlMjAlM0QlMjAzMCUwQSUyMCUyMCUyMCUyMG1peGVkX3ByZWNpc2lvbiUyMCUzRCUyMCUyMmZwMTYlMjIlMjAlMjAlMjMlMjAlNjBubyU2MCUyMGZvciUyMGZsb2F0MzIlMkMlMjAlNjBmcDE2JTYwJTIwZm9yJTIwYXV0b21hdGljJTIwbWl4ZWQlMjBwcmVjaXNpb24lMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTIwJTNEJTIwJTIyZGRwbS1idXR0ZXJmbGllcy0xMjglMjIlMjAlMjAlMjMlMjB0aGUlMjBtb2RlbCUyMG5hbWUlMjBsb2NhbGx5JTIwYW5kJTIwb24lMjB0aGUlMjBIRiUyMEh1YiUwQSUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTIwJTNEJTIwVHJ1ZSUyMCUyMCUyMyUyMHdoZXRoZXIlMjB0byUyMHVwbG9hZCUyMHRoZSUyMHNhdmVkJTIwbW9kZWwlMjB0byUyMHRoZSUyMEhGJTIwSHViJTBBJTIwJTIwJTIwJTIwaHViX3ByaXZhdGVfcmVwbyUyMCUzRCUyMEZhbHNlJTBBJTIwJTIwJTIwJTIwb3ZlcndyaXRlX291dHB1dF9kaXIlMjAlM0QlMjBUcnVlJTIwJTIwJTIzJTIwb3ZlcndyaXRlJTIwdGhlJTIwb2xkJTIwbW9kZWwlMjB3aGVuJTIwcmUtcnVubmluZyUyMHRoZSUyMG5vdGVib29rJTBBJTIwJTIwJTIwJTIwc2VlZCUyMCUzRCUyMDAlMEElMEElMEFjb25maWclMjAlM0QlMjBUcmFpbmluZ0NvbmZpZygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass


<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TrainingConfig</span>:
<span class="hljs-meta">... </span>    image_size = <span class="hljs-number">128</span>  <span class="hljs-comment"># the generated image resolution</span>
<span class="hljs-meta">... </span>    train_batch_size = <span class="hljs-number">16</span>
<span class="hljs-meta">... </span>    eval_batch_size = <span class="hljs-number">16</span>  <span class="hljs-comment"># how many images to sample during evaluation</span>
<span class="hljs-meta">... </span>    num_epochs = <span class="hljs-number">50</span>
<span class="hljs-meta">... </span>    gradient_accumulation_steps = <span class="hljs-number">1</span>
<span class="hljs-meta">... </span>    learning_rate = <span class="hljs-number">1e-4</span>
<span class="hljs-meta">... </span>    lr_warmup_steps = <span class="hljs-number">500</span>
<span class="hljs-meta">... </span>    save_image_epochs = <span class="hljs-number">10</span>
<span class="hljs-meta">... </span>    save_model_epochs = <span class="hljs-number">30</span>
<span class="hljs-meta">... </span>    mixed_precision = <span class="hljs-string">&quot;fp16&quot;</span>  <span class="hljs-comment"># \`no\` for float32, \`fp16\` for automatic mixed precision</span>
<span class="hljs-meta">... </span>    output_dir = <span class="hljs-string">&quot;ddpm-butterflies-128&quot;</span>  <span class="hljs-comment"># the model name locally and on the HF Hub</span>

<span class="hljs-meta">... </span>    push_to_hub = <span class="hljs-literal">True</span>  <span class="hljs-comment"># whether to upload the saved model to the HF Hub</span>
<span class="hljs-meta">... </span>    hub_private_repo = <span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>    overwrite_output_dir = <span class="hljs-literal">True</span>  <span class="hljs-comment"># overwrite the old model when re-running the notebook</span>
<span class="hljs-meta">... </span>    seed = <span class="hljs-number">0</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>config = TrainingConfig()`}}),_s=new pa({}),Es=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBY29uZmlnLmRhdGFzZXRfbmFtZSUyMCUzRCUyMCUyMmh1Z2dhbiUyRnNtaXRoc29uaWFuX2J1dHRlcmZsaWVzX3N1YnNldCUyMiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoY29uZmlnLmRhdGFzZXRfbmFtZSUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>config.dataset_name = <span class="hljs-string">&quot;huggan/smithsonian_butterflies_subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(config.dataset_name, split=<span class="hljs-string">&quot;train&quot;</span>)`}}),es=new _n({props:{$$slots:{default:[Oo]},$$scope:{ctx:x}}}),Vs=new U({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWZpZyUyQyUyMGF4cyUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwNCUyQyUyMGZpZ3NpemUlM0QoMTYlMkMlMjA0KSklMEFmb3IlMjBpJTJDJTIwaW1hZ2UlMjBpbiUyMGVudW1lcmF0ZShkYXRhc2V0JTVCJTNBNCU1RCU1QiUyMmltYWdlJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGF4cyU1QmklNUQuaW1zaG93KGltYWdlKSUwQSUyMCUyMCUyMCUyMGF4cyU1QmklNUQuc2V0X2F4aXNfb2ZmKCklMEFmaWcuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataset[:<span class="hljs-number">4</span>][<span class="hljs-string">&quot;image&quot;</span>]):
<span class="hljs-meta">... </span>    axs[i].imshow(image)
<span class="hljs-meta">... </span>    axs[i].set_axis_off()
<span class="hljs-meta">&gt;&gt;&gt; </span>fig.show()`}}),Ys=new U({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uJTIwaW1wb3J0JTIwdHJhbnNmb3JtcyUwQSUwQXByZXByb2Nlc3MlMjAlM0QlMjB0cmFuc2Zvcm1zLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3Jtcy5SZXNpemUoKGNvbmZpZy5pbWFnZV9zaXplJTJDJTIwY29uZmlnLmltYWdlX3NpemUpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuUmFuZG9tSG9yaXpvbnRhbEZsaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuTm9ybWFsaXplKCU1QjAuNSU1RCUyQyUyMCU1QjAuNSU1RCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocess = transforms.Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        transforms.Resize((config.image_size, config.image_size)),
<span class="hljs-meta">... </span>        transforms.RandomHorizontalFlip(),
<span class="hljs-meta">... </span>        transforms.ToTensor(),
<span class="hljs-meta">... </span>        transforms.Normalize([<span class="hljs-number">0.5</span>], [<span class="hljs-number">0.5</span>]),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`}}),zs=new U({props:{code:"ZGVmJTIwdHJhbnNmb3JtKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QnByZXByb2Nlc3MoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMGltYWdlJTIwaW4lMjBleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyaW1hZ2VzJTIyJTNBJTIwaW1hZ2VzJTdEJTBBJTBBJTBBZGF0YXNldC5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    images = [preprocess(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;images&quot;</span>: images}


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(transform)`}}),Ss=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwdG9yY2gudXRpbHMuZGF0YS5EYXRhTG9hZGVyKGRhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEY29uZmlnLnRyYWluX2JhdGNoX3NpemUlMkMlMjBzaHVmZmxlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = torch.utils.data.DataLoader(dataset, batch_size=config.train_batch_size, shuffle=<span class="hljs-literal">True</span>)`}}),Qs=new pa({}),Fs=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel(
<span class="hljs-meta">... </span>    sample_size=config.image_size,  <span class="hljs-comment"># the target image resolution</span>
<span class="hljs-meta">... </span>    in_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># the number of input channels, 3 for RGB images</span>
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># the number of output channels</span>
<span class="hljs-meta">... </span>    layers_per_block=<span class="hljs-number">2</span>,  <span class="hljs-comment"># how many ResNet layers to use per UNet block</span>
<span class="hljs-meta">... </span>    block_out_channels=(<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>),  <span class="hljs-comment"># the number of output channels for each UNet block</span>
<span class="hljs-meta">... </span>    down_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet downsampling block</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnDownBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet downsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>    up_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet upsampling block</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnUpBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet upsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)`}}),Hs=new U({props:{code:"c2FtcGxlX2ltYWdlJTIwJTNEJTIwZGF0YXNldCU1QjAlNUQlNUIlMjJpbWFnZXMlMjIlNUQudW5zcXVlZXplKDApJTBBcHJpbnQoJTIySW5wdXQlMjBzaGFwZSUzQSUyMiUyQyUyMHNhbXBsZV9pbWFnZS5zaGFwZSklMEElMEFwcmludCglMjJPdXRwdXQlMjBzaGFwZSUzQSUyMiUyQyUyMG1vZGVsKHNhbXBsZV9pbWFnZSUyQyUyMHRpbWVzdGVwJTNEMCkuc2FtcGxlLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>sample_image = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;images&quot;</span>].unsqueeze(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input shape:&quot;</span>, sample_image.shape)
Input shape: torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Output shape:&quot;</span>, model(sample_image, timestep=<span class="hljs-number">0</span>).sample.shape)
Output shape: torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>])`}}),Ds=new pa({}),xs=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERQTVNjaGVkdWxlciUwQSUwQW5vaXNlX3NjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIobnVtX3RyYWluX3RpbWVzdGVwcyUzRDEwMDApJTBBbm9pc2UlMjAlM0QlMjB0b3JjaC5yYW5kbihzYW1wbGVfaW1hZ2Uuc2hhcGUpJTBBdGltZXN0ZXBzJTIwJTNEJTIwdG9yY2guTG9uZ1RlbnNvciglNUI1MCU1RCklMEFub2lzeV9pbWFnZSUyMCUzRCUyMG5vaXNlX3NjaGVkdWxlci5hZGRfbm9pc2Uoc2FtcGxlX2ltYWdlJTJDJTIwbm9pc2UlMkMlMjB0aW1lc3RlcHMpJTBBJTBBSW1hZ2UuZnJvbWFycmF5KCgobm9pc3lfaW1hZ2UucGVybXV0ZSgwJTJDJTIwMiUyQyUyMDMlMkMlMjAxKSUyMCUyQiUyMDEuMCklMjAqJTIwMTI3LjUpLnR5cGUodG9yY2gudWludDgpLm51bXB5KCklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>noise_scheduler = DDPMScheduler(num_train_timesteps=<span class="hljs-number">1000</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn(sample_image.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span>timesteps = torch.LongTensor([<span class="hljs-number">50</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_image = noise_scheduler.add_noise(sample_image, noise, timesteps)

<span class="hljs-meta">&gt;&gt;&gt; </span>Image.fromarray(((noisy_image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>) + <span class="hljs-number">1.0</span>) * <span class="hljs-number">127.5</span>).<span class="hljs-built_in">type</span>(torch.uint8).numpy()[<span class="hljs-number">0</span>])`}}),Ps=new U({props:{code:"aW1wb3J0JTIwdG9yY2gubm4uZnVuY3Rpb25hbCUyMGFzJTIwRiUwQSUwQW5vaXNlX3ByZWQlMjAlM0QlMjBtb2RlbChub2lzeV9pbWFnZSUyQyUyMHRpbWVzdGVwcykuc2FtcGxlJTBBbG9zcyUyMCUzRCUyMEYubXNlX2xvc3Mobm9pc2VfcHJlZCUyQyUyMG5vaXNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F

<span class="hljs-meta">&gt;&gt;&gt; </span>noise_pred = model(noisy_image, timesteps).sample
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = F.mse_loss(noise_pred, noise)`}}),Ks=new pa({}),Ls=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5vcHRpbWl6YXRpb24lMjBpbXBvcnQlMjBnZXRfY29zaW5lX3NjaGVkdWxlX3dpdGhfd2FybXVwJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0Rjb25maWcubGVhcm5pbmdfcmF0ZSklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfY29zaW5lX3NjaGVkdWxlX3dpdGhfd2FybXVwKCUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0Rjb25maWcubHJfd2FybXVwX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEKGxlbih0cmFpbl9kYXRhbG9hZGVyKSUyMColMjBjb25maWcubnVtX2Vwb2NocyklMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.optimization <span class="hljs-keyword">import</span> get_cosine_schedule_with_warmup

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = torch.optim.AdamW(model.parameters(), lr=config.learning_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span>lr_scheduler = get_cosine_schedule_with_warmup(
<span class="hljs-meta">... </span>    optimizer=optimizer,
<span class="hljs-meta">... </span>    num_warmup_steps=config.lr_warmup_steps,
<span class="hljs-meta">... </span>    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * config.num_epochs),
<span class="hljs-meta">... </span>)`}}),Os=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQWltcG9ydCUyMG1hdGglMEFpbXBvcnQlMjBvcyUwQSUwQSUwQWRlZiUyMG1ha2VfZ3JpZChpbWFnZXMlMkMlMjByb3dzJTJDJTIwY29scyklM0ElMEElMjAlMjAlMjAlMjB3JTJDJTIwaCUyMCUzRCUyMGltYWdlcyU1QjAlNUQuc2l6ZSUwQSUyMCUyMCUyMCUyMGdyaWQlMjAlM0QlMjBJbWFnZS5uZXcoJTIyUkdCJTIyJTJDJTIwc2l6ZSUzRChjb2xzJTIwKiUyMHclMkMlMjByb3dzJTIwKiUyMGgpKSUwQSUyMCUyMCUyMCUyMGZvciUyMGklMkMlMjBpbWFnZSUyMGluJTIwZW51bWVyYXRlKGltYWdlcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBncmlkLnBhc3RlKGltYWdlJTJDJTIwYm94JTNEKGklMjAlMjUlMjBjb2xzJTIwKiUyMHclMkMlMjBpJTIwJTJGJTJGJTIwY29scyUyMColMjBoKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBncmlkJTBBJTBBJTBBZGVmJTIwZXZhbHVhdGUoY29uZmlnJTJDJTIwZXBvY2glMkMlMjBwaXBlbGluZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBTYW1wbGUlMjBzb21lJTIwaW1hZ2VzJTIwZnJvbSUyMHJhbmRvbSUyMG5vaXNlJTIwKHRoaXMlMjBpcyUyMHRoZSUyMGJhY2t3YXJkJTIwZGlmZnVzaW9uJTIwcHJvY2VzcykuJTBBJTIwJTIwJTIwJTIwJTIzJTIwVGhlJTIwZGVmYXVsdCUyMHBpcGVsaW5lJTIwb3V0cHV0JTIwdHlwZSUyMGlzJTIwJTYwTGlzdCU1QlBJTC5JbWFnZSU1RCU2MCUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0Rjb25maWcuZXZhbF9iYXRjaF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2gubWFudWFsX3NlZWQoY29uZmlnLnNlZWQpJTJDJTBBJTIwJTIwJTIwJTIwKS5pbWFnZXMlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBNYWtlJTIwYSUyMGdyaWQlMjBvdXQlMjBvZiUyMHRoZSUyMGltYWdlcyUwQSUyMCUyMCUyMCUyMGltYWdlX2dyaWQlMjAlM0QlMjBtYWtlX2dyaWQoaW1hZ2VzJTJDJTIwcm93cyUzRDQlMkMlMjBjb2xzJTNENCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwdGhlJTIwaW1hZ2VzJTBBJTIwJTIwJTIwJTIwdGVzdF9kaXIlMjAlM0QlMjBvcy5wYXRoLmpvaW4oY29uZmlnLm91dHB1dF9kaXIlMkMlMjAlMjJzYW1wbGVzJTIyKSUwQSUyMCUyMCUyMCUyMG9zLm1ha2VkaXJzKHRlc3RfZGlyJTJDJTIwZXhpc3Rfb2slM0RUcnVlKSUwQSUyMCUyMCUyMCUyMGltYWdlX2dyaWQuc2F2ZShmJTIyJTdCdGVzdF9kaXIlN0QlMkYlN0JlcG9jaCUzQTA0ZCU3RC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> math
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">make_grid</span>(<span class="hljs-params">images, rows, cols</span>):
<span class="hljs-meta">... </span>    w, h = images[<span class="hljs-number">0</span>].size
<span class="hljs-meta">... </span>    grid = Image.new(<span class="hljs-string">&quot;RGB&quot;</span>, size=(cols * w, rows * h))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images):
<span class="hljs-meta">... </span>        grid.paste(image, box=(i % cols * w, i // cols * h))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> grid


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">evaluate</span>(<span class="hljs-params">config, epoch, pipeline</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Sample some images from random noise (this is the backward diffusion process).</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># The default pipeline output type is \`List[PIL.Image]\`</span>
<span class="hljs-meta">... </span>    images = pipeline(
<span class="hljs-meta">... </span>        batch_size=config.eval_batch_size,
<span class="hljs-meta">... </span>        generator=torch.manual_seed(config.seed),
<span class="hljs-meta">... </span>    ).images

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Make a grid out of the images</span>
<span class="hljs-meta">... </span>    image_grid = make_grid(images, rows=<span class="hljs-number">4</span>, cols=<span class="hljs-number">4</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Save the images</span>
<span class="hljs-meta">... </span>    test_dir = os.path.join(config.output_dir, <span class="hljs-string">&quot;samples&quot;</span>)
<span class="hljs-meta">... </span>    os.makedirs(test_dir, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    image_grid.save(<span class="hljs-string">f&quot;<span class="hljs-subst">{test_dir}</span>/<span class="hljs-subst">{epoch:04d}</span>.png&quot;</span>)`}}),Ms=new _n({props:{$$slots:{default:[sp]},$$scope:{ctx:x}}}),sa=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFolder, Repository, whoami
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_full_repo_name</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span>, organization: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>, token: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> token <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>        token = HfFolder.get_token()
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> organization <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>        username = whoami(token)[<span class="hljs-string">&quot;name&quot;</span>]
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{username}</span>/<span class="hljs-subst">{model_id}</span>&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{organization}</span>/<span class="hljs-subst">{model_id}</span>&quot;</span>


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">train_loop</span>(<span class="hljs-params">config, model, noise_scheduler, optimizer, train_dataloader, lr_scheduler</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Initialize accelerator and tensorboard logging</span>
<span class="hljs-meta">... </span>    accelerator = Accelerator(
<span class="hljs-meta">... </span>        mixed_precision=config.mixed_precision,
<span class="hljs-meta">... </span>        gradient_accumulation_steps=config.gradient_accumulation_steps,
<span class="hljs-meta">... </span>        log_with=<span class="hljs-string">&quot;tensorboard&quot;</span>,
<span class="hljs-meta">... </span>        project_dir=os.path.join(config.output_dir, <span class="hljs-string">&quot;logs&quot;</span>),
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> accelerator.is_main_process:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> config.push_to_hub:
<span class="hljs-meta">... </span>            repo_name = get_full_repo_name(Path(config.output_dir).name)
<span class="hljs-meta">... </span>            repo = Repository(config.output_dir, clone_from=repo_name)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">elif</span> config.output_dir <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>            os.makedirs(config.output_dir, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>        accelerator.init_trackers(<span class="hljs-string">&quot;train_example&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Prepare everything</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># There is no specific order to remember, you just need to unpack the</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># objects in the same order you gave them to the prepare method.</span>
<span class="hljs-meta">... </span>    model, optimizer, train_dataloader, lr_scheduler = accelerator.prepare(
<span class="hljs-meta">... </span>        model, optimizer, train_dataloader, lr_scheduler
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    global_step = <span class="hljs-number">0</span>

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Now you train the model</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(config.num_epochs):
<span class="hljs-meta">... </span>        progress_bar = tqdm(total=<span class="hljs-built_in">len</span>(train_dataloader), disable=<span class="hljs-keyword">not</span> accelerator.is_local_main_process)
<span class="hljs-meta">... </span>        progress_bar.set_description(<span class="hljs-string">f&quot;Epoch <span class="hljs-subst">{epoch}</span>&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(train_dataloader):
<span class="hljs-meta">... </span>            clean_images = batch[<span class="hljs-string">&quot;images&quot;</span>]
<span class="hljs-meta">... </span>            <span class="hljs-comment"># Sample noise to add to the images</span>
<span class="hljs-meta">... </span>            noise = torch.randn(clean_images.shape).to(clean_images.device)
<span class="hljs-meta">... </span>            bs = clean_images.shape[<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>            <span class="hljs-comment"># Sample a random timestep for each image</span>
<span class="hljs-meta">... </span>            timesteps = torch.randint(
<span class="hljs-meta">... </span>                <span class="hljs-number">0</span>, noise_scheduler.config.num_train_timesteps, (bs,), device=clean_images.device
<span class="hljs-meta">... </span>            ).long()

<span class="hljs-meta">... </span>            <span class="hljs-comment"># Add noise to the clean images according to the noise magnitude at each timestep</span>
<span class="hljs-meta">... </span>            <span class="hljs-comment"># (this is the forward diffusion process)</span>
<span class="hljs-meta">... </span>            noisy_images = noise_scheduler.add_noise(clean_images, noise, timesteps)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">with</span> accelerator.accumulate(model):
<span class="hljs-meta">... </span>                <span class="hljs-comment"># Predict the noise residual</span>
<span class="hljs-meta">... </span>                noise_pred = model(noisy_images, timesteps, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>                loss = F.mse_loss(noise_pred, noise)
<span class="hljs-meta">... </span>                accelerator.backward(loss)

<span class="hljs-meta">... </span>                accelerator.clip_grad_norm_(model.parameters(), <span class="hljs-number">1.0</span>)
<span class="hljs-meta">... </span>                optimizer.step()
<span class="hljs-meta">... </span>                lr_scheduler.step()
<span class="hljs-meta">... </span>                optimizer.zero_grad()

<span class="hljs-meta">... </span>            progress_bar.update(<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>            logs = {<span class="hljs-string">&quot;loss&quot;</span>: loss.detach().item(), <span class="hljs-string">&quot;lr&quot;</span>: lr_scheduler.get_last_lr()[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;step&quot;</span>: global_step}
<span class="hljs-meta">... </span>            progress_bar.set_postfix(**logs)
<span class="hljs-meta">... </span>            accelerator.log(logs, step=global_step)
<span class="hljs-meta">... </span>            global_step += <span class="hljs-number">1</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># After each epoch you optionally sample some demo images with evaluate() and save the model</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> accelerator.is_main_process:
<span class="hljs-meta">... </span>            pipeline = DDPMPipeline(unet=accelerator.unwrap_model(model), scheduler=noise_scheduler)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> (epoch + <span class="hljs-number">1</span>) % config.save_image_epochs == <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> epoch == config.num_epochs - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                evaluate(config, epoch, pipeline)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> (epoch + <span class="hljs-number">1</span>) % config.save_model_epochs == <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> epoch == config.num_epochs - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                <span class="hljs-keyword">if</span> config.push_to_hub:
<span class="hljs-meta">... </span>                    repo.push_to_hub(commit_message=<span class="hljs-string">f&quot;Epoch <span class="hljs-subst">{epoch}</span>&quot;</span>, blocking=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>                <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>                    pipeline.save_pretrained(config.output_dir)`}}),la=new U({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQWFyZ3MlMjAlM0QlMjAoY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBub2lzZV9zY2hlZHVsZXIlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyKSUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluX2xvb3AlMkMlMjBhcmdzJTJDJTIwbnVtX3Byb2Nlc3NlcyUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

<span class="hljs-meta">&gt;&gt;&gt; </span>args = (config, model, noise_scheduler, optimizer, train_dataloader, lr_scheduler)

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_launcher(train_loop, args, num_processes=<span class="hljs-number">1</span>)`}}),ea=new U({props:{code:"aW1wb3J0JTIwZ2xvYiUwQSUwQXNhbXBsZV9pbWFnZXMlMjAlM0QlMjBzb3J0ZWQoZ2xvYi5nbG9iKGYlMjIlN0Jjb25maWcub3V0cHV0X2RpciU3RCUyRnNhbXBsZXMlMkYqLnBuZyUyMikpJTBBSW1hZ2Uub3BlbihzYW1wbGVfaW1hZ2VzJTVCLTElNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> glob

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_images = <span class="hljs-built_in">sorted</span>(glob.glob(<span class="hljs-string">f&quot;<span class="hljs-subst">{config.output_dir}</span>/samples/*.png&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>Image.<span class="hljs-built_in">open</span>(sample_images[-<span class="hljs-number">1</span>])`}}),na=new pa({}),{c(){m=t("meta"),C=M(),y(f.$$.fragment),g=M(),I=t("h1"),T=t("a"),b=t("span"),y(A.$$.fragment),ws=M(),k=t("span"),ds=o("Train a diffusion model"),q=M(),G=t("p"),Js=o("Unconditional image generation is a popular application of diffusion models that generates images that look like those in the dataset used for training. Typically, the best results are obtained from finetuning a pretrained model on a specific dataset. You can find many of these checkpoints on the "),E=t("a"),R=o("Hub"),B=o(", but if you can\u2019t find one you like, you can always train your own!"),fs=M(),Z=t("p"),ia=o("This tutorial will teach you how to train a "),z=t("a"),ra=o("UNet2DModel"),ke=o(" from scratch on a subset of the "),Ts=t("a"),Ee=o("Smithsonian Butterflies"),We=o(" dataset to generate your own \u{1F98B} butterflies \u{1F98B}."),yl=M(),y(P.$$.fragment),jl=M(),W=t("p"),Xe=o("Before you begin, make sure you have \u{1F917} Datasets installed to load and preprocess image datasets, and \u{1F917} Accelerate, to simplify training on any number of GPUs. The following command will also install "),Us=t("a"),Ve=o("TensorBoard"),Ne=o(" to visualize training metrics (you can also use "),bs=t("a"),Ye=o("Weights & Biases"),Re=o(" to track your training)."),ul=M(),y(gs.$$.fragment),wl=M(),K=t("p"),ze=o("We encourage you to share your model with the community, and in order to do that, you\u2019ll need to login to your Hugging Face account (create one "),Is=t("a"),$e=o("here"),Se=o(" if you don\u2019t already have one!). You can login from a notebook and enter your token when prompted:"),dl=M(),y(Cs.$$.fragment),Jl=M(),ca=t("p"),Qe=o("Or login in from the terminal:"),fl=M(),y(Bs.$$.fragment),Tl=M(),L=t("p"),Fe=o("Since the model checkpoints are quite large, install "),As=t("a"),He=o("Git-LFS"),De=o(" to version these large files:"),Ul=M(),y(Gs.$$.fragment),bl=M(),$=t("h2"),O=t("a"),Ya=t("span"),y(Zs.$$.fragment),xe=M(),Ra=t("span"),qe=o("Training configuration"),gl=M(),ss=t("p"),Pe=o("For convenience, create a "),za=t("code"),Ke=o("TrainingConfig"),Le=o(" class containing the training hyperparameters (feel free to adjust them):"),Il=M(),y(vs.$$.fragment),Cl=M(),S=t("h2"),as=t("a"),$a=t("span"),y(_s.$$.fragment),Oe=M(),Sa=t("span"),st=o("Load the dataset"),Bl=M(),ls=t("p"),at=o("You can easily load the "),ks=t("a"),lt=o("Smithsonian Butterflies"),et=o(" dataset with the \u{1F917} Datasets library:"),Al=M(),y(Es.$$.fragment),Gl=M(),y(es.$$.fragment),Zl=M(),X=t("p"),tt=o("\u{1F917} Datasets uses the "),Ws=t("a"),nt=o("Image"),ot=o(" feature to automatically decode the image data and load it as a "),Xs=t("a"),Qa=t("code"),pt=o("PIL.Image"),it=o(" which we can visualize:"),vl=M(),y(Vs.$$.fragment),_l=M(),Ns=t("div"),Fa=t("img"),kl=M(),Ma=t("p"),rt=o("The images are all different sizes though, so you\u2019ll need to preprocess them first:"),El=M(),V=t("ul"),ts=t("li"),Ha=t("code"),ct=o("Resize"),Mt=o(" changes the image size to the one defined in "),Da=t("code"),ht=o("config.image_size"),mt=o("."),yt=M(),ha=t("li"),xa=t("code"),jt=o("RandomHorizontalFlip"),ut=o(" augments the dataset by randomly mirroring the images."),wt=M(),ma=t("li"),qa=t("code"),dt=o("Normalize"),Jt=o(" is important to rescale the pixel values into a [-1, 1] range, which is what the model expects."),Wl=M(),y(Ys.$$.fragment),Xl=M(),N=t("p"),ft=o("Use \u{1F917} Datasets\u2019 "),Rs=t("a"),Tt=o("set_transform"),Ut=o(" method to apply the "),Pa=t("code"),bt=o("preprocess"),gt=o(" function on the fly during training:"),Vl=M(),y(zs.$$.fragment),Nl=M(),ns=t("p"),It=o("Feel free to visualize the images again to confirm that they\u2019ve been resized. Now you\u2019re ready to wrap the dataset in a "),$s=t("a"),Ct=o("DataLoader"),Bt=o(" for training!"),Yl=M(),y(Ss.$$.fragment),Rl=M(),Q=t("h2"),os=t("a"),Ka=t("span"),y(Qs.$$.fragment),At=M(),La=t("span"),Gt=o("Create a UNet2DModel"),zl=M(),ps=t("p"),Zt=o("Pretrained models in \u{1F9E8} Diffusers are easily created from their model class with the parameters you want. For example, to create a "),ya=t("a"),vt=o("UNet2DModel"),_t=o(":"),$l=M(),y(Fs.$$.fragment),Sl=M(),ja=t("p"),kt=o("It is often a good idea to quickly check the sample image shape matches the model output shape:"),Ql=M(),y(Hs.$$.fragment),Fl=M(),ua=t("p"),Et=o("Great! Next, you\u2019ll need a scheduler to add some noise to the image."),Hl=M(),F=t("h2"),is=t("a"),Oa=t("span"),y(Ds.$$.fragment),Wt=M(),sl=t("span"),Xt=o("Create a scheduler"),Dl=M(),Y=t("p"),Vt=o("The scheduler behaves differently depending on whether you\u2019re using the model for training or inference. During inference, the scheduler generates image from the noise. During training, the scheduler takes a model output - or a sample - from a specific point in the diffusion process and applies noise to the image according to a "),al=t("em"),Nt=o("noise schedule"),Yt=o(" and an "),ll=t("em"),Rt=o("update rule"),zt=o("."),xl=M(),v=t("p"),$t=o("Let\u2019s take a look at the "),wa=t("a"),St=o("DDPMScheduler"),Qt=o(" and use the "),el=t("code"),Ft=o("add_noise"),Ht=o(" method to add some random noise to the "),tl=t("code"),Dt=o("sample_image"),xt=o(" from before:"),ql=M(),y(xs.$$.fragment),Pl=M(),qs=t("div"),nl=t("img"),Kl=M(),da=t("p"),qt=o("The training objective of the model is to predict the noise added to the image. The loss at this step can be calculated by:"),Ll=M(),y(Ps.$$.fragment),Ol=M(),H=t("h2"),rs=t("a"),ol=t("span"),y(Ks.$$.fragment),Pt=M(),pl=t("span"),Kt=o("Train the model"),se=M(),Ja=t("p"),Lt=o("By now, you have most of the pieces to start training the model and all that\u2019s left is putting everything together."),ae=M(),fa=t("p"),Ot=o("First, you\u2019ll need an optimizer and a learning rate scheduler:"),le=M(),y(Ls.$$.fragment),ee=M(),cs=t("p"),sn=o("Then, you\u2019ll need a way to evaluate the model. For evaluation, you can use the "),Ta=t("a"),an=o("DDPMPipeline"),ln=o(" to generate a batch of sample images and save it as a grid:"),te=M(),y(Os.$$.fragment),ne=M(),Ua=t("p"),en=o("Now you can wrap all these components together in a training loop with \u{1F917} Accelerate for easy TensorBoard logging, gradient accumulation, and mixed precision training. To upload the model to the Hub, write a function to get your repository name and information and then push it to the Hub."),oe=M(),y(Ms.$$.fragment),pe=M(),y(sa.$$.fragment),ie=M(),hs=t("p"),tn=o("Phew, that was quite a bit of code! But you\u2019re finally ready to launch the training with \u{1F917} Accelerate\u2019s "),aa=t("a"),nn=o("notebook_launcher"),on=o(" function. Pass the function the training loop, all the training arguments, and the number of processes (you can change this value to the number of GPUs available to you) to use for training:"),re=M(),y(la.$$.fragment),ce=M(),ba=t("p"),pn=o("Once training is complete, take a look at the final \u{1F98B} images \u{1F98B} generated by your diffusion model!"),Me=M(),y(ea.$$.fragment),he=M(),ta=t("div"),il=t("img"),me=M(),D=t("h2"),ms=t("a"),rl=t("span"),y(na.$$.fragment),rn=M(),cl=t("span"),cn=o("Next steps"),ye=M(),ys=t("p"),Mn=o("Unconditional image generation is one example of a task that can be trained. You can explore other tasks and training techniques by visiting the "),ga=t("a"),hn=o("\u{1F9E8} Diffusers Training Examples"),mn=o(" page. Here are some examples of what you can learn:"),je=M(),_=t("ul"),Ia=t("li"),Ca=t("a"),yn=o("Textual Inversion"),jn=o(", an algorithm that teaches a model a specific visual concept and integrates it into the generated image."),un=M(),Ba=t("li"),Aa=t("a"),wn=o("DreamBooth"),dn=o(", a technique for generating personalized images of a subject given several input images of the subject."),Jn=M(),Ga=t("li"),Za=t("a"),fn=o("Guide"),Tn=o(" to finetuning a Stable Diffusion model on your own dataset."),Un=M(),va=t("li"),_a=t("a"),bn=o("Guide"),gn=o(" to using LoRA, a memory-efficient technique for finetuning really large models faster."),this.h()},l(s){const e=qo('[data-svelte="svelte-1phssyn"]',document.head);m=n(e,"META",{name:!0,content:!0}),e.forEach(a),C=h(s),j(f.$$.fragment,s),g=h(s),I=n(s,"H1",{class:!0});var oa=i(I);T=n(oa,"A",{id:!0,class:!0,href:!0});var Ml=i(T);b=n(Ml,"SPAN",{});var hl=i(b);j(A.$$.fragment,hl),hl.forEach(a),Ml.forEach(a),ws=h(oa),k=n(oa,"SPAN",{});var Xn=i(k);ds=p(Xn,"Train a diffusion model"),Xn.forEach(a),oa.forEach(a),q=h(s),G=n(s,"P",{});var we=i(G);Js=p(we,"Unconditional image generation is a popular application of diffusion models that generates images that look like those in the dataset used for training. Typically, the best results are obtained from finetuning a pretrained model on a specific dataset. You can find many of these checkpoints on the "),E=n(we,"A",{href:!0,rel:!0});var Vn=i(E);R=p(Vn,"Hub"),Vn.forEach(a),B=p(we,", but if you can\u2019t find one you like, you can always train your own!"),we.forEach(a),fs=h(s),Z=n(s,"P",{});var ka=i(Z);ia=p(ka,"This tutorial will teach you how to train a "),z=n(ka,"A",{href:!0});var Nn=i(z);ra=p(Nn,"UNet2DModel"),Nn.forEach(a),ke=p(ka," from scratch on a subset of the "),Ts=n(ka,"A",{href:!0,rel:!0});var Yn=i(Ts);Ee=p(Yn,"Smithsonian Butterflies"),Yn.forEach(a),We=p(ka," dataset to generate your own \u{1F98B} butterflies \u{1F98B}."),ka.forEach(a),yl=h(s),j(P.$$.fragment,s),jl=h(s),W=n(s,"P",{});var Ea=i(W);Xe=p(Ea,"Before you begin, make sure you have \u{1F917} Datasets installed to load and preprocess image datasets, and \u{1F917} Accelerate, to simplify training on any number of GPUs. The following command will also install "),Us=n(Ea,"A",{href:!0,rel:!0});var Rn=i(Us);Ve=p(Rn,"TensorBoard"),Rn.forEach(a),Ne=p(Ea," to visualize training metrics (you can also use "),bs=n(Ea,"A",{href:!0,rel:!0});var zn=i(bs);Ye=p(zn,"Weights & Biases"),zn.forEach(a),Re=p(Ea," to track your training)."),Ea.forEach(a),ul=h(s),j(gs.$$.fragment,s),wl=h(s),K=n(s,"P",{});var de=i(K);ze=p(de,"We encourage you to share your model with the community, and in order to do that, you\u2019ll need to login to your Hugging Face account (create one "),Is=n(de,"A",{href:!0,rel:!0});var $n=i(Is);$e=p($n,"here"),$n.forEach(a),Se=p(de," if you don\u2019t already have one!). You can login from a notebook and enter your token when prompted:"),de.forEach(a),dl=h(s),j(Cs.$$.fragment,s),Jl=h(s),ca=n(s,"P",{});var Sn=i(ca);Qe=p(Sn,"Or login in from the terminal:"),Sn.forEach(a),fl=h(s),j(Bs.$$.fragment,s),Tl=h(s),L=n(s,"P",{});var Je=i(L);Fe=p(Je,"Since the model checkpoints are quite large, install "),As=n(Je,"A",{href:!0,rel:!0});var Qn=i(As);He=p(Qn,"Git-LFS"),Qn.forEach(a),De=p(Je," to version these large files:"),Je.forEach(a),Ul=h(s),j(Gs.$$.fragment,s),bl=h(s),$=n(s,"H2",{class:!0});var fe=i($);O=n(fe,"A",{id:!0,class:!0,href:!0});var Fn=i(O);Ya=n(Fn,"SPAN",{});var Hn=i(Ya);j(Zs.$$.fragment,Hn),Hn.forEach(a),Fn.forEach(a),xe=h(fe),Ra=n(fe,"SPAN",{});var Dn=i(Ra);qe=p(Dn,"Training configuration"),Dn.forEach(a),fe.forEach(a),gl=h(s),ss=n(s,"P",{});var Te=i(ss);Pe=p(Te,"For convenience, create a "),za=n(Te,"CODE",{});var xn=i(za);Ke=p(xn,"TrainingConfig"),xn.forEach(a),Le=p(Te," class containing the training hyperparameters (feel free to adjust them):"),Te.forEach(a),Il=h(s),j(vs.$$.fragment,s),Cl=h(s),S=n(s,"H2",{class:!0});var Ue=i(S);as=n(Ue,"A",{id:!0,class:!0,href:!0});var qn=i(as);$a=n(qn,"SPAN",{});var Pn=i($a);j(_s.$$.fragment,Pn),Pn.forEach(a),qn.forEach(a),Oe=h(Ue),Sa=n(Ue,"SPAN",{});var Kn=i(Sa);st=p(Kn,"Load the dataset"),Kn.forEach(a),Ue.forEach(a),Bl=h(s),ls=n(s,"P",{});var be=i(ls);at=p(be,"You can easily load the "),ks=n(be,"A",{href:!0,rel:!0});var Ln=i(ks);lt=p(Ln,"Smithsonian Butterflies"),Ln.forEach(a),et=p(be," dataset with the \u{1F917} Datasets library:"),be.forEach(a),Al=h(s),j(Es.$$.fragment,s),Gl=h(s),j(es.$$.fragment,s),Zl=h(s),X=n(s,"P",{});var Wa=i(X);tt=p(Wa,"\u{1F917} Datasets uses the "),Ws=n(Wa,"A",{href:!0,rel:!0});var On=i(Ws);nt=p(On,"Image"),On.forEach(a),ot=p(Wa," feature to automatically decode the image data and load it as a "),Xs=n(Wa,"A",{href:!0,rel:!0});var so=i(Xs);Qa=n(so,"CODE",{});var ao=i(Qa);pt=p(ao,"PIL.Image"),ao.forEach(a),so.forEach(a),it=p(Wa," which we can visualize:"),Wa.forEach(a),vl=h(s),j(Vs.$$.fragment,s),_l=h(s),Ns=n(s,"DIV",{class:!0});var lo=i(Ns);Fa=n(lo,"IMG",{src:!0}),lo.forEach(a),kl=h(s),Ma=n(s,"P",{});var eo=i(Ma);rt=p(eo,"The images are all different sizes though, so you\u2019ll need to preprocess them first:"),eo.forEach(a),El=h(s),V=n(s,"UL",{});var Xa=i(V);ts=n(Xa,"LI",{});var ml=i(ts);Ha=n(ml,"CODE",{});var to=i(Ha);ct=p(to,"Resize"),to.forEach(a),Mt=p(ml," changes the image size to the one defined in "),Da=n(ml,"CODE",{});var no=i(Da);ht=p(no,"config.image_size"),no.forEach(a),mt=p(ml,"."),ml.forEach(a),yt=h(Xa),ha=n(Xa,"LI",{});var In=i(ha);xa=n(In,"CODE",{});var oo=i(xa);jt=p(oo,"RandomHorizontalFlip"),oo.forEach(a),ut=p(In," augments the dataset by randomly mirroring the images."),In.forEach(a),wt=h(Xa),ma=n(Xa,"LI",{});var Cn=i(ma);qa=n(Cn,"CODE",{});var po=i(qa);dt=p(po,"Normalize"),po.forEach(a),Jt=p(Cn," is important to rescale the pixel values into a [-1, 1] range, which is what the model expects."),Cn.forEach(a),Xa.forEach(a),Wl=h(s),j(Ys.$$.fragment,s),Xl=h(s),N=n(s,"P",{});var Va=i(N);ft=p(Va,"Use \u{1F917} Datasets\u2019 "),Rs=n(Va,"A",{href:!0,rel:!0});var io=i(Rs);Tt=p(io,"set_transform"),io.forEach(a),Ut=p(Va," method to apply the "),Pa=n(Va,"CODE",{});var ro=i(Pa);bt=p(ro,"preprocess"),ro.forEach(a),gt=p(Va," function on the fly during training:"),Va.forEach(a),Vl=h(s),j(zs.$$.fragment,s),Nl=h(s),ns=n(s,"P",{});var ge=i(ns);It=p(ge,"Feel free to visualize the images again to confirm that they\u2019ve been resized. Now you\u2019re ready to wrap the dataset in a "),$s=n(ge,"A",{href:!0,rel:!0});var co=i($s);Ct=p(co,"DataLoader"),co.forEach(a),Bt=p(ge," for training!"),ge.forEach(a),Yl=h(s),j(Ss.$$.fragment,s),Rl=h(s),Q=n(s,"H2",{class:!0});var Ie=i(Q);os=n(Ie,"A",{id:!0,class:!0,href:!0});var Mo=i(os);Ka=n(Mo,"SPAN",{});var ho=i(Ka);j(Qs.$$.fragment,ho),ho.forEach(a),Mo.forEach(a),At=h(Ie),La=n(Ie,"SPAN",{});var mo=i(La);Gt=p(mo,"Create a UNet2DModel"),mo.forEach(a),Ie.forEach(a),zl=h(s),ps=n(s,"P",{});var Ce=i(ps);Zt=p(Ce,"Pretrained models in \u{1F9E8} Diffusers are easily created from their model class with the parameters you want. For example, to create a "),ya=n(Ce,"A",{href:!0});var yo=i(ya);vt=p(yo,"UNet2DModel"),yo.forEach(a),_t=p(Ce,":"),Ce.forEach(a),$l=h(s),j(Fs.$$.fragment,s),Sl=h(s),ja=n(s,"P",{});var jo=i(ja);kt=p(jo,"It is often a good idea to quickly check the sample image shape matches the model output shape:"),jo.forEach(a),Ql=h(s),j(Hs.$$.fragment,s),Fl=h(s),ua=n(s,"P",{});var uo=i(ua);Et=p(uo,"Great! Next, you\u2019ll need a scheduler to add some noise to the image."),uo.forEach(a),Hl=h(s),F=n(s,"H2",{class:!0});var Be=i(F);is=n(Be,"A",{id:!0,class:!0,href:!0});var wo=i(is);Oa=n(wo,"SPAN",{});var Jo=i(Oa);j(Ds.$$.fragment,Jo),Jo.forEach(a),wo.forEach(a),Wt=h(Be),sl=n(Be,"SPAN",{});var fo=i(sl);Xt=p(fo,"Create a scheduler"),fo.forEach(a),Be.forEach(a),Dl=h(s),Y=n(s,"P",{});var Na=i(Y);Vt=p(Na,"The scheduler behaves differently depending on whether you\u2019re using the model for training or inference. During inference, the scheduler generates image from the noise. During training, the scheduler takes a model output - or a sample - from a specific point in the diffusion process and applies noise to the image according to a "),al=n(Na,"EM",{});var To=i(al);Nt=p(To,"noise schedule"),To.forEach(a),Yt=p(Na," and an "),ll=n(Na,"EM",{});var Uo=i(ll);Rt=p(Uo,"update rule"),Uo.forEach(a),zt=p(Na,"."),Na.forEach(a),xl=h(s),v=n(s,"P",{});var js=i(v);$t=p(js,"Let\u2019s take a look at the "),wa=n(js,"A",{href:!0});var bo=i(wa);St=p(bo,"DDPMScheduler"),bo.forEach(a),Qt=p(js," and use the "),el=n(js,"CODE",{});var go=i(el);Ft=p(go,"add_noise"),go.forEach(a),Ht=p(js," method to add some random noise to the "),tl=n(js,"CODE",{});var Io=i(tl);Dt=p(Io,"sample_image"),Io.forEach(a),xt=p(js," from before:"),js.forEach(a),ql=h(s),j(xs.$$.fragment,s),Pl=h(s),qs=n(s,"DIV",{class:!0});var Co=i(qs);nl=n(Co,"IMG",{src:!0}),Co.forEach(a),Kl=h(s),da=n(s,"P",{});var Bo=i(da);qt=p(Bo,"The training objective of the model is to predict the noise added to the image. The loss at this step can be calculated by:"),Bo.forEach(a),Ll=h(s),j(Ps.$$.fragment,s),Ol=h(s),H=n(s,"H2",{class:!0});var Ae=i(H);rs=n(Ae,"A",{id:!0,class:!0,href:!0});var Ao=i(rs);ol=n(Ao,"SPAN",{});var Go=i(ol);j(Ks.$$.fragment,Go),Go.forEach(a),Ao.forEach(a),Pt=h(Ae),pl=n(Ae,"SPAN",{});var Zo=i(pl);Kt=p(Zo,"Train the model"),Zo.forEach(a),Ae.forEach(a),se=h(s),Ja=n(s,"P",{});var vo=i(Ja);Lt=p(vo,"By now, you have most of the pieces to start training the model and all that\u2019s left is putting everything together."),vo.forEach(a),ae=h(s),fa=n(s,"P",{});var _o=i(fa);Ot=p(_o,"First, you\u2019ll need an optimizer and a learning rate scheduler:"),_o.forEach(a),le=h(s),j(Ls.$$.fragment,s),ee=h(s),cs=n(s,"P",{});var Ge=i(cs);sn=p(Ge,"Then, you\u2019ll need a way to evaluate the model. For evaluation, you can use the "),Ta=n(Ge,"A",{href:!0});var ko=i(Ta);an=p(ko,"DDPMPipeline"),ko.forEach(a),ln=p(Ge," to generate a batch of sample images and save it as a grid:"),Ge.forEach(a),te=h(s),j(Os.$$.fragment,s),ne=h(s),Ua=n(s,"P",{});var Eo=i(Ua);en=p(Eo,"Now you can wrap all these components together in a training loop with \u{1F917} Accelerate for easy TensorBoard logging, gradient accumulation, and mixed precision training. To upload the model to the Hub, write a function to get your repository name and information and then push it to the Hub."),Eo.forEach(a),oe=h(s),j(Ms.$$.fragment,s),pe=h(s),j(sa.$$.fragment,s),ie=h(s),hs=n(s,"P",{});var Ze=i(hs);tn=p(Ze,"Phew, that was quite a bit of code! But you\u2019re finally ready to launch the training with \u{1F917} Accelerate\u2019s "),aa=n(Ze,"A",{href:!0,rel:!0});var Wo=i(aa);nn=p(Wo,"notebook_launcher"),Wo.forEach(a),on=p(Ze," function. Pass the function the training loop, all the training arguments, and the number of processes (you can change this value to the number of GPUs available to you) to use for training:"),Ze.forEach(a),re=h(s),j(la.$$.fragment,s),ce=h(s),ba=n(s,"P",{});var Xo=i(ba);pn=p(Xo,"Once training is complete, take a look at the final \u{1F98B} images \u{1F98B} generated by your diffusion model!"),Xo.forEach(a),Me=h(s),j(ea.$$.fragment,s),he=h(s),ta=n(s,"DIV",{class:!0});var Vo=i(ta);il=n(Vo,"IMG",{src:!0}),Vo.forEach(a),me=h(s),D=n(s,"H2",{class:!0});var ve=i(D);ms=n(ve,"A",{id:!0,class:!0,href:!0});var No=i(ms);rl=n(No,"SPAN",{});var Yo=i(rl);j(na.$$.fragment,Yo),Yo.forEach(a),No.forEach(a),rn=h(ve),cl=n(ve,"SPAN",{});var Ro=i(cl);cn=p(Ro,"Next steps"),Ro.forEach(a),ve.forEach(a),ye=h(s),ys=n(s,"P",{});var _e=i(ys);Mn=p(_e,"Unconditional image generation is one example of a task that can be trained. You can explore other tasks and training techniques by visiting the "),ga=n(_e,"A",{href:!0});var zo=i(ga);hn=p(zo,"\u{1F9E8} Diffusers Training Examples"),zo.forEach(a),mn=p(_e," page. Here are some examples of what you can learn:"),_e.forEach(a),je=h(s),_=n(s,"UL",{});var us=i(_);Ia=n(us,"LI",{});var Bn=i(Ia);Ca=n(Bn,"A",{href:!0});var $o=i(Ca);yn=p($o,"Textual Inversion"),$o.forEach(a),jn=p(Bn,", an algorithm that teaches a model a specific visual concept and integrates it into the generated image."),Bn.forEach(a),un=h(us),Ba=n(us,"LI",{});var An=i(Ba);Aa=n(An,"A",{href:!0});var So=i(Aa);wn=p(So,"DreamBooth"),So.forEach(a),dn=p(An,", a technique for generating personalized images of a subject given several input images of the subject."),An.forEach(a),Jn=h(us),Ga=n(us,"LI",{});var Gn=i(Ga);Za=n(Gn,"A",{href:!0});var Qo=i(Za);fn=p(Qo,"Guide"),Qo.forEach(a),Tn=p(Gn," to finetuning a Stable Diffusion model on your own dataset."),Gn.forEach(a),Un=h(us),va=n(us,"LI",{});var Zn=i(va);_a=n(Zn,"A",{href:!0});var Fo=i(_a);bn=p(Fo,"Guide"),Fo.forEach(a),gn=p(Zn," to using LoRA, a memory-efficient technique for finetuning really large models faster."),Zn.forEach(a),us.forEach(a),this.h()},h(){c(m,"name","hf:doc:metadata"),c(m,"content",JSON.stringify(lp)),c(T,"id","train-a-diffusion-model"),c(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(T,"href","#train-a-diffusion-model"),c(I,"class","relative group"),c(E,"href","https://huggingface.co/search/full-text?q=unconditional-image-generation&type=model"),c(E,"rel","nofollow"),c(z,"href","/docs/diffusers/v0.19.2/en/api/models/unet2d#diffusers.UNet2DModel"),c(Ts,"href","https://huggingface.co/datasets/huggan/smithsonian_butterflies_subset"),c(Ts,"rel","nofollow"),c(Us,"href","https://www.tensorflow.org/tensorboard"),c(Us,"rel","nofollow"),c(bs,"href","https://docs.wandb.ai/"),c(bs,"rel","nofollow"),c(Is,"href","https://hf.co/join"),c(Is,"rel","nofollow"),c(As,"href","https://git-lfs.com/"),c(As,"rel","nofollow"),c(O,"id","training-configuration"),c(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(O,"href","#training-configuration"),c($,"class","relative group"),c(as,"id","load-the-dataset"),c(as,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(as,"href","#load-the-dataset"),c(S,"class","relative group"),c(ks,"href","https://huggingface.co/datasets/huggan/smithsonian_butterflies_subset"),c(ks,"rel","nofollow"),c(Ws,"href","https://huggingface.co/docs/datasets/v2.14.1/en/package_reference/main_classes#datasets.Image"),c(Ws,"rel","nofollow"),c(Xs,"href","https://pillow.readthedocs.io/en/stable/reference/Image.html"),c(Xs,"rel","nofollow"),vn(Fa.src,kn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/butterflies_ds.png")||c(Fa,"src",kn),c(Ns,"class","flex justify-center"),c(Rs,"href","https://huggingface.co/docs/datasets/v2.14.1/en/package_reference/main_classes#datasets.Dataset.set_transform"),c(Rs,"rel","nofollow"),c($s,"href","https://pytorch.org/docs/stable/data#torch.utils.data.DataLoader"),c($s,"rel","nofollow"),c(os,"id","create-a-unet2dmodel"),c(os,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(os,"href","#create-a-unet2dmodel"),c(Q,"class","relative group"),c(ya,"href","/docs/diffusers/v0.19.2/en/api/models/unet2d#diffusers.UNet2DModel"),c(is,"id","create-a-scheduler"),c(is,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(is,"href","#create-a-scheduler"),c(F,"class","relative group"),c(wa,"href","/docs/diffusers/v0.19.2/en/api/schedulers/ddpm#diffusers.DDPMScheduler"),vn(nl.src,En="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/noisy_butterfly.png")||c(nl,"src",En),c(qs,"class","flex justify-center"),c(rs,"id","train-the-model"),c(rs,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(rs,"href","#train-the-model"),c(H,"class","relative group"),c(Ta,"href","/docs/diffusers/v0.19.2/en/api/pipelines/ddpm#diffusers.DDPMPipeline"),c(aa,"href","https://huggingface.co/docs/accelerate/v0.21.0/en/package_reference/launchers#accelerate.notebook_launcher"),c(aa,"rel","nofollow"),vn(il.src,Wn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/butterflies_final.png")||c(il,"src",Wn),c(ta,"class","flex justify-center"),c(ms,"id","next-steps"),c(ms,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(ms,"href","#next-steps"),c(D,"class","relative group"),c(ga,"href","../training/overview"),c(Ca,"href","../training/text_inversion"),c(Aa,"href","../training/dreambooth"),c(Za,"href","../training/text2image"),c(_a,"href","../training/lora")},m(s,e){l(document.head,m),r(s,C,e),u(f,s,e),r(s,g,e),r(s,I,e),l(I,T),l(T,b),u(A,b,null),l(I,ws),l(I,k),l(k,ds),r(s,q,e),r(s,G,e),l(G,Js),l(G,E),l(E,R),l(G,B),r(s,fs,e),r(s,Z,e),l(Z,ia),l(Z,z),l(z,ra),l(Z,ke),l(Z,Ts),l(Ts,Ee),l(Z,We),r(s,yl,e),u(P,s,e),r(s,jl,e),r(s,W,e),l(W,Xe),l(W,Us),l(Us,Ve),l(W,Ne),l(W,bs),l(bs,Ye),l(W,Re),r(s,ul,e),u(gs,s,e),r(s,wl,e),r(s,K,e),l(K,ze),l(K,Is),l(Is,$e),l(K,Se),r(s,dl,e),u(Cs,s,e),r(s,Jl,e),r(s,ca,e),l(ca,Qe),r(s,fl,e),u(Bs,s,e),r(s,Tl,e),r(s,L,e),l(L,Fe),l(L,As),l(As,He),l(L,De),r(s,Ul,e),u(Gs,s,e),r(s,bl,e),r(s,$,e),l($,O),l(O,Ya),u(Zs,Ya,null),l($,xe),l($,Ra),l(Ra,qe),r(s,gl,e),r(s,ss,e),l(ss,Pe),l(ss,za),l(za,Ke),l(ss,Le),r(s,Il,e),u(vs,s,e),r(s,Cl,e),r(s,S,e),l(S,as),l(as,$a),u(_s,$a,null),l(S,Oe),l(S,Sa),l(Sa,st),r(s,Bl,e),r(s,ls,e),l(ls,at),l(ls,ks),l(ks,lt),l(ls,et),r(s,Al,e),u(Es,s,e),r(s,Gl,e),u(es,s,e),r(s,Zl,e),r(s,X,e),l(X,tt),l(X,Ws),l(Ws,nt),l(X,ot),l(X,Xs),l(Xs,Qa),l(Qa,pt),l(X,it),r(s,vl,e),u(Vs,s,e),r(s,_l,e),r(s,Ns,e),l(Ns,Fa),r(s,kl,e),r(s,Ma,e),l(Ma,rt),r(s,El,e),r(s,V,e),l(V,ts),l(ts,Ha),l(Ha,ct),l(ts,Mt),l(ts,Da),l(Da,ht),l(ts,mt),l(V,yt),l(V,ha),l(ha,xa),l(xa,jt),l(ha,ut),l(V,wt),l(V,ma),l(ma,qa),l(qa,dt),l(ma,Jt),r(s,Wl,e),u(Ys,s,e),r(s,Xl,e),r(s,N,e),l(N,ft),l(N,Rs),l(Rs,Tt),l(N,Ut),l(N,Pa),l(Pa,bt),l(N,gt),r(s,Vl,e),u(zs,s,e),r(s,Nl,e),r(s,ns,e),l(ns,It),l(ns,$s),l($s,Ct),l(ns,Bt),r(s,Yl,e),u(Ss,s,e),r(s,Rl,e),r(s,Q,e),l(Q,os),l(os,Ka),u(Qs,Ka,null),l(Q,At),l(Q,La),l(La,Gt),r(s,zl,e),r(s,ps,e),l(ps,Zt),l(ps,ya),l(ya,vt),l(ps,_t),r(s,$l,e),u(Fs,s,e),r(s,Sl,e),r(s,ja,e),l(ja,kt),r(s,Ql,e),u(Hs,s,e),r(s,Fl,e),r(s,ua,e),l(ua,Et),r(s,Hl,e),r(s,F,e),l(F,is),l(is,Oa),u(Ds,Oa,null),l(F,Wt),l(F,sl),l(sl,Xt),r(s,Dl,e),r(s,Y,e),l(Y,Vt),l(Y,al),l(al,Nt),l(Y,Yt),l(Y,ll),l(ll,Rt),l(Y,zt),r(s,xl,e),r(s,v,e),l(v,$t),l(v,wa),l(wa,St),l(v,Qt),l(v,el),l(el,Ft),l(v,Ht),l(v,tl),l(tl,Dt),l(v,xt),r(s,ql,e),u(xs,s,e),r(s,Pl,e),r(s,qs,e),l(qs,nl),r(s,Kl,e),r(s,da,e),l(da,qt),r(s,Ll,e),u(Ps,s,e),r(s,Ol,e),r(s,H,e),l(H,rs),l(rs,ol),u(Ks,ol,null),l(H,Pt),l(H,pl),l(pl,Kt),r(s,se,e),r(s,Ja,e),l(Ja,Lt),r(s,ae,e),r(s,fa,e),l(fa,Ot),r(s,le,e),u(Ls,s,e),r(s,ee,e),r(s,cs,e),l(cs,sn),l(cs,Ta),l(Ta,an),l(cs,ln),r(s,te,e),u(Os,s,e),r(s,ne,e),r(s,Ua,e),l(Ua,en),r(s,oe,e),u(Ms,s,e),r(s,pe,e),u(sa,s,e),r(s,ie,e),r(s,hs,e),l(hs,tn),l(hs,aa),l(aa,nn),l(hs,on),r(s,re,e),u(la,s,e),r(s,ce,e),r(s,ba,e),l(ba,pn),r(s,Me,e),u(ea,s,e),r(s,he,e),r(s,ta,e),l(ta,il),r(s,me,e),r(s,D,e),l(D,ms),l(ms,rl),u(na,rl,null),l(D,rn),l(D,cl),l(cl,cn),r(s,ye,e),r(s,ys,e),l(ys,Mn),l(ys,ga),l(ga,hn),l(ys,mn),r(s,je,e),r(s,_,e),l(_,Ia),l(Ia,Ca),l(Ca,yn),l(Ia,jn),l(_,un),l(_,Ba),l(Ba,Aa),l(Aa,wn),l(Ba,dn),l(_,Jn),l(_,Ga),l(Ga,Za),l(Za,fn),l(Ga,Tn),l(_,Un),l(_,va),l(va,_a),l(_a,bn),l(va,gn),ue=!0},p(s,[e]){const oa={};e&2&&(oa.$$scope={dirty:e,ctx:s}),P.$set(oa);const Ml={};e&2&&(Ml.$$scope={dirty:e,ctx:s}),es.$set(Ml);const hl={};e&2&&(hl.$$scope={dirty:e,ctx:s}),Ms.$set(hl)},i(s){ue||(w(f.$$.fragment,s),w(A.$$.fragment,s),w(P.$$.fragment,s),w(gs.$$.fragment,s),w(Cs.$$.fragment,s),w(Bs.$$.fragment,s),w(Gs.$$.fragment,s),w(Zs.$$.fragment,s),w(vs.$$.fragment,s),w(_s.$$.fragment,s),w(Es.$$.fragment,s),w(es.$$.fragment,s),w(Vs.$$.fragment,s),w(Ys.$$.fragment,s),w(zs.$$.fragment,s),w(Ss.$$.fragment,s),w(Qs.$$.fragment,s),w(Fs.$$.fragment,s),w(Hs.$$.fragment,s),w(Ds.$$.fragment,s),w(xs.$$.fragment,s),w(Ps.$$.fragment,s),w(Ks.$$.fragment,s),w(Ls.$$.fragment,s),w(Os.$$.fragment,s),w(Ms.$$.fragment,s),w(sa.$$.fragment,s),w(la.$$.fragment,s),w(ea.$$.fragment,s),w(na.$$.fragment,s),ue=!0)},o(s){d(f.$$.fragment,s),d(A.$$.fragment,s),d(P.$$.fragment,s),d(gs.$$.fragment,s),d(Cs.$$.fragment,s),d(Bs.$$.fragment,s),d(Gs.$$.fragment,s),d(Zs.$$.fragment,s),d(vs.$$.fragment,s),d(_s.$$.fragment,s),d(Es.$$.fragment,s),d(es.$$.fragment,s),d(Vs.$$.fragment,s),d(Ys.$$.fragment,s),d(zs.$$.fragment,s),d(Ss.$$.fragment,s),d(Qs.$$.fragment,s),d(Fs.$$.fragment,s),d(Hs.$$.fragment,s),d(Ds.$$.fragment,s),d(xs.$$.fragment,s),d(Ps.$$.fragment,s),d(Ks.$$.fragment,s),d(Ls.$$.fragment,s),d(Os.$$.fragment,s),d(Ms.$$.fragment,s),d(sa.$$.fragment,s),d(la.$$.fragment,s),d(ea.$$.fragment,s),d(na.$$.fragment,s),ue=!1},d(s){a(m),s&&a(C),J(f,s),s&&a(g),s&&a(I),J(A),s&&a(q),s&&a(G),s&&a(fs),s&&a(Z),s&&a(yl),J(P,s),s&&a(jl),s&&a(W),s&&a(ul),J(gs,s),s&&a(wl),s&&a(K),s&&a(dl),J(Cs,s),s&&a(Jl),s&&a(ca),s&&a(fl),J(Bs,s),s&&a(Tl),s&&a(L),s&&a(Ul),J(Gs,s),s&&a(bl),s&&a($),J(Zs),s&&a(gl),s&&a(ss),s&&a(Il),J(vs,s),s&&a(Cl),s&&a(S),J(_s),s&&a(Bl),s&&a(ls),s&&a(Al),J(Es,s),s&&a(Gl),J(es,s),s&&a(Zl),s&&a(X),s&&a(vl),J(Vs,s),s&&a(_l),s&&a(Ns),s&&a(kl),s&&a(Ma),s&&a(El),s&&a(V),s&&a(Wl),J(Ys,s),s&&a(Xl),s&&a(N),s&&a(Vl),J(zs,s),s&&a(Nl),s&&a(ns),s&&a(Yl),J(Ss,s),s&&a(Rl),s&&a(Q),J(Qs),s&&a(zl),s&&a(ps),s&&a($l),J(Fs,s),s&&a(Sl),s&&a(ja),s&&a(Ql),J(Hs,s),s&&a(Fl),s&&a(ua),s&&a(Hl),s&&a(F),J(Ds),s&&a(Dl),s&&a(Y),s&&a(xl),s&&a(v),s&&a(ql),J(xs,s),s&&a(Pl),s&&a(qs),s&&a(Kl),s&&a(da),s&&a(Ll),J(Ps,s),s&&a(Ol),s&&a(H),J(Ks),s&&a(se),s&&a(Ja),s&&a(ae),s&&a(fa),s&&a(le),J(Ls,s),s&&a(ee),s&&a(cs),s&&a(te),J(Os,s),s&&a(ne),s&&a(Ua),s&&a(oe),J(Ms,s),s&&a(pe),J(sa,s),s&&a(ie),s&&a(hs),s&&a(re),J(la,s),s&&a(ce),s&&a(ba),s&&a(Me),J(ea,s),s&&a(he),s&&a(ta),s&&a(me),s&&a(D),J(na),s&&a(ye),s&&a(ys),s&&a(je),s&&a(_)}}}const lp={local:"train-a-diffusion-model",sections:[{local:"training-configuration",title:"Training configuration"},{local:"load-the-dataset",title:"Load the dataset"},{local:"create-a-unet2dmodel",title:"Create a UNet2DModel"},{local:"create-a-scheduler",title:"Create a scheduler"},{local:"train-the-model",title:"Train the model"},{local:"next-steps",title:"Next steps"}],title:"Train a diffusion model"};function ep(x){return Po(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rp extends Ho{constructor(m){super();Do(this,m,ep,ap,xo,{})}}export{rp as default,lp as metadata};
